<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]><xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : lp_pt_PT_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass LP in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/lp_pt_PT_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='personal.firstName' and @before='personal.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
<head>
  <title>LP - HTML</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
  <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
</head>
<body>
  <table class="LP" cellSpacing="0" cellPadding="10" width="740" border="0">
	  <tbody>
	  <tr align="middle">
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_europass_lp.gif" width="95"/></td>
	    <td style="text-align: center" width="60%">
		  <span class="LabelBold">Passaporte de Línguas Europass</span>
		  <br/>
		  <span class="Label">Parte do Portfólio Europeu de Línguas desenvolvido pelo Conselho da Europa</span>
		</td>
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/otherlogo_lp.gif" width="95"/></td>
	  </tr>
	  </tbody>
  </table>
  <div class="VerLine_LP">
    <table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="173"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="516"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
	  <td class="LabelBold">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
	        Apelido(s)&#160;
	      </xsl:when>
	      <xsl:otherwise>
		    &#160;Apelido(s)
	      </xsl:otherwise>
	    </xsl:choose>
	  </td>
      <td class="Normal">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
            <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		  </xsl:when>
	      <xsl:otherwise>
		    <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		  </xsl:otherwise>
	    </xsl:choose>
      </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <xsl:if test="//field[@name='personal.birthDate' and @keep='true']">
    <tr>
      <td class="Label">Data de nascimento</td>
      <td class="Normal">
      <xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
      </td><td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
	</xsl:if>
    <tr>
      <td class="Label">Língua(s) materna(s)</td>
      <td class="Normal"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="Label">Outra(s) língua(s)</td>
	  <td class="Normal">
	    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
          <xsl:if test="position() != 1">,&#160;</xsl:if>
		  <xsl:value-of select="label" />
	    </xsl:for-each>
	   </td>
      <td>&#160;</td>
	 </tr>
	 </tbody>
     </table>
  </div>
  
  <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
    <xsl:variable name="indexedLang">
	  <xsl:value-of select="concat('foreignLanguageList[', position()-1, ']')" />
    </xsl:variable>
	
    <br/>
	<div class="VerLine_LP">
    
	<table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="19"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="8"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="17"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="108"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="86"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="23"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="31"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="79"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalHighlight" colSpan="13"><xsl:value-of select="label" /> </td>
      <td>&#160;</td>
	</tr>
    
	<xsl:if test="//field[@name=concat($indexedLang,'.ass') and @keep='true']">
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Auto-avaliação das competências linguísticas </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeadingBold" colSpan="4">Compreensão</td>
      <td class="GridHeadingBold" colSpan="6">Conversação</td>
      <td class="GridHeadingBold" colSpan="3">Escrita</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="2">Compreensão oral</td>
      <td class="GridHeading" colspan="2">Leitura</td>
      <td class="GridHeading" colspan="3">Interacção oral</td>
      <td class="GridHeading" colspan="3">Produção oral</td>
      <td colSpan="3">&#160;</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalCenter"><xsl:value-of select="level/listening" /> </td>
      <td class="NormalCenter">
	    <xsl:if test="level/listening='a1'">Utilizador básico</xsl:if>
        <xsl:if test="level/listening='b1'">Utilizador independente</xsl:if>
  	    <xsl:if test="level/listening='c1'">Utilizador avançado</xsl:if>
	    
		<xsl:if test="level/listening='a2'">Utilizador básico</xsl:if>
	    <xsl:if test="level/listening='b2'">Utilizador independente</xsl:if>
		<xsl:if test="level/listening='c2'">Utilizador avançado</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/reading" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/reading='a1'">Utilizador básico</xsl:if>
		<xsl:if test="level/reading='b1'">Utilizador independente</xsl:if>
		<xsl:if test="level/reading='c1'">Utilizador avançado</xsl:if>
		
		<xsl:if test="level/reading='a2'">Utilizador básico</xsl:if>
		<xsl:if test="level/reading='b2'">Utilizador independente</xsl:if>
		<xsl:if test="level/reading='c2'">Utilizador avançado</xsl:if>
	  </td>
      <td class="NormalCenter" colSpan="2"><xsl:value-of select="level/spokeninteraction" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/spokeninteraction='a1'">Utilizador básico</xsl:if>
	    <xsl:if test="level/spokeninteraction='b1'">Utilizador independente</xsl:if>
		<xsl:if test="level/spokeninteraction='c1'">Utilizador avançado</xsl:if>
		
		<xsl:if test="level/spokeninteraction='a2'">Utilizador básico</xsl:if>
	    <xsl:if test="level/spokeninteraction='b2'">Utilizador independente</xsl:if>
		<xsl:if test="level/spokeninteraction='c2'">Utilizador avançado</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/spokenproduction" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/spokenproduction='a1'">Utilizador básico</xsl:if>
	    <xsl:if test="level/spokenproduction='b1'">Utilizador independente</xsl:if>
		<xsl:if test="level/spokenproduction='c1'">Utilizador avançado</xsl:if>
		
		<xsl:if test="level/spokenproduction='a2'">Utilizador básico</xsl:if>
	    <xsl:if test="level/spokenproduction='b2'">Utilizador independente</xsl:if>
		<xsl:if test="level/spokenproduction='c2'">Utilizador avançado</xsl:if>
	  </td>
	  <td class="NormalCenter"><xsl:value-of select="level/writing" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/writing='a1'">Utilizador básico</xsl:if>
	    <xsl:if test="level/writing='b1'">Utilizador independente</xsl:if>
		<xsl:if test="level/writing='c1'">Utilizador avançado</xsl:if>
		
		<xsl:if test="level/writing='a2'">Utilizador básico</xsl:if>
	    <xsl:if test="level/writing='b2'">Utilizador independente</xsl:if>
		<xsl:if test="level/writing='c2'">Utilizador avançado</xsl:if>
	  </td>
      <td>&#160;</td>
	</tr>
    </xsl:if>
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Diploma(s) ou certificado(s) </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="5">Título(s) do(s) diploma(s) ou certificado(s)</td>
	  <td class="GridHeading" colspan="4">Organismo outorgante</td>
	  <td class="GridHeading" colspan="3">Data</td>
	  <td class="GridHeading">Nível europeu</td>
      <td>&#160;</td>
	</tr>
    
	<xsl:for-each select="diplomalist/diploma">
	  <xsl:variable name="indexedDiploma">
	    <xsl:value-of select="concat('.diplomaList[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:variable name="indexedBoth">
	    <xsl:value-of select="concat('', $indexedLang, $indexedDiploma)" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
        <tr>
          <td>&#160;</td>
          <td class="Normal" colSpan="5"><xsl:value-of select="title" /></td>
          <td class="Normal" colSpan="4"><xsl:value-of select="awardingBody" /></td>
          <td class="NormalCenter" colSpan="3">
            <xsl:value-of select="translate(date/day,'-','')" />
            <xsl:if test="string-length(date/day) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/month,'-','')" />
            <xsl:if test="string-length(date/month) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/year,'-','')" />
          </td>
          <td class="NormalCenter"><xsl:value-of select="level" /> </td>
          <td>&#160;</td>
	    </tr>
        <tr>
          <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	    </tr>
	  </xsl:if>
    </xsl:for-each>
  
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Experiência(s) linguística(s) </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="9">Descrição</td>
	  <td class="GridHeading" colspan="3">De</td>
	  <td class="GridHeading">Para</td>
      <td>&#160;</td>
	</tr>
	
    <xsl:for-each select="experiencelist/experience">
	<xsl:variable name="indexedExperience">
	  <xsl:value-of select="concat('.experienceList[', position()-1, ']')" />
	</xsl:variable>
	<xsl:variable name="indexedBoth">
	  <xsl:value-of select="concat('', $indexedLang, $indexedExperience)" />
	</xsl:variable>
    <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
      <tr>
        <td>&#160;</td>
        <td class="Normal" colSpan="9"><xsl:value-of select="description" /></td>
        <td class="NormalCenter" colSpan="3">
          <xsl:value-of select="translate(period/from/day,'-','')" />
		    	<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/month,'-','')" />
          <xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/year,'-','')" />
	    </td>
        <td class="NormalCenter">
          <xsl:value-of select="translate(period/to/day,'-','')" />
          <xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/month,'-','')" />
          <xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/year,'-','')" />
	    </td>
        <td>&#160;</td>
	  </tr>
      <tr>
        <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
      </tr>
	</xsl:if>
	</xsl:for-each>
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
  
  </tbody>
  </table>
  
  </div>
  </xsl:for-each>
    
  <div class="Asterix">
    (*)As rubricas assinaladas com um asterisco são opcionais.
	(**)Ver grelha de auto-avaliação no verso.
	(***)O nível do Quadro Europeu Comum de Referência (CECR) deverá ser incluído apenas em caso de constar do diploma ou certificado.<br/>
  </div>
  <br/>
  <div class="Footnote">
	<b>Nota explicativa</b><br/>
	O Passaporte de Línguas Europass faz parte do Portfólio Europeu de Línguas desenvolvido pelo Conselho da Europa. Os 6 níveis europeus do Quadro Europeu Comum de Referência para as Línguas (CECR) destinam-se a definir, num formato normalizado, o grau de conhecimento de uma língua.<br/>
	Informações sobre o Passaporte de Línguas Europass: http://europass.cedefop.europa.eu  -  Informações sobre o Portfólio Europeu de Línguas: www.coe.int/portfolio<br/>
	O modelo do Passaporte de Línguas Europass pode ser descarregado, gratuitamente, dos sítios web acima indicados.<br/>
	© Conselho da Europa e Comunidades Europeias, 2004   20060628<br/>
  </div>
  <br/>
  
  <xsl:if test="//field[@name='grid' and @keep='true']">
  <table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">Níveis europeus – Grelha de auto-avaliação</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Sou capaz de reconhecer palavras e expressões simples de uso corrente relativas a mim próprio, à minha família e aos contextos em que estou inserido, quando me falam de forma clara e pausada.</td>
		<td>Sou capaz de compreender nomes conhecidos, palavras e frases muito simples, por exemplo, em avisos, cartazes ou folhetos.</td>
		<td>Sou capaz de comunicar de forma simples, desde que o meu interlocutor se disponha a repetir ou dizer por outras palavras, num ritmo mais lento, e me ajude a formular aquilo que eu gostaria de dizer. Sou capaz de perguntar e de responder a perguntas simples sobre assuntos conhecidos ou relativos a áreas de necessidade imediata.</td>
		<td>Sou capaz de utilizar expressões e frases simples para descrever o local onde vivo e pessoas que conheço.</td>
		<td>Sou capaz de escrever um postal simples e curto, por exemplo, na altura de férias. Sou capaz de preencher uma ficha com dados pessoais, por exemplo, num hotel, com nome, morada, nacionalidade.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Sou capaz de compreender expressões e vocabulário de uso mais frequente relacionado com aspectos de interesse pessoal como, por exemplo, família, compras, trabalho e meio em que vivo. Sou capaz de compreender o essencial de um anúncio e de mensagens simples, curtas e claras.</td>
		<td>Sou capaz de ler textos curtos e simples. Sou capaz de encontrar uma informação previsível e concreta em textos simples de uso corrente, por exemplo, anúncios, folhetos, ementas, horários. Sou capaz de compreender cartas pessoais curtas e simples.</td>
		<td>Sou capaz de comunicar em situações simples, de rotina do dia-a-dia, sobre assuntos e actividades habituais que exijam apenas uma troca de informação simples e directa. Sou capaz de participar em breves trocas de palavras, apesar de não compreender o suficiente para manter a conversa.</td>
		<td>Sou capaz de utilizar uma série de expressões e frases para falar, de forma simples, da minha família, de outras pessoas, das condições de vida, do meu percurso escolar e do meu trabalho actual ou mais recente.</td>
		<td>Sou capaz de escrever notas e mensagens curtas e simples sobre assuntos de necessidade imediata. Sou capaz de escrever uma carta pessoal muito simples, por exemplo, para agradecer alguma coisa a alguém.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Sou capaz de compreender os pontos essenciais de uma sequência falada que incida sobre assuntos correntes do trabalho, da escola, dos tempos livres, etc. Sou capaz de compreender os pontos principais de muitos programas de rádio e televisão sobre temas actuais ou assuntos de interesse pessoal ou profissional, quando o débito da fala é relativamente lento e claro.</td>
		<td>Sou capaz de compreender textos em que predomine uma linguagem corrente do dia-a-dia ou relacionada com o trabalho. Sou capaz de compreender descrições de acontecimentos, sentimentos e desejos, em cartas pessoais.</td>
		<td>Sou capaz de lidar com a maior parte das situações que podem surgir durante uma viagem a um local onde a língua é falada. Consigo entrar, sem preparação prévia, numa conversa sobre assuntos conhecidos, de interesse pessoal ou pertinentes para o dia-a-dia (por exemplo, família, passatempos, trabalho, viagens e assuntos da actualidade).</td>
		<td>Sou capaz de articular expressões de forma simples para descrever experiências e acontecimentos, sonhos, desejos e ambições. Sou capaz de explicar ou justificar opiniões e planos. Sou capaz de contar uma história, de relatar o enredo de um livro ou de um filme e de descrever as minhas reacções.</td>
		<td>Sou capaz de escrever um texto articulado de forma simples sobre assuntos conhecidos ou de interesse pessoal. Sou capaz de escrever cartas pessoais para descrever experiências e impressões.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Sou capaz de compreender exposições longas e palestras e até seguir partes mais complexas da argumentação, desde que o tema me seja relativamente familiar. Consigo compreender a maior parte dos noticiários e outros programas informativos na televisão. Sou capaz de compreender a maior parte dos filmes, desde que seja utilizada a língua padrão.</td>
		<td>Sou capaz de ler artigos e reportagens sobre assuntos contemporâneos em relação aos quais os autores adoptam determinadas atitudes ou pontos de vista particulares. Sou capaz de compreender textos literários contemporâneos em prosa.</td>
		<td>Sou capaz de conversar com a fluência e espontaneidade suficientes para tornar possível a interacção normal com falantes nativos. Posso tomar parte activa numa discussão que tenha lugar em contextos conhecidos, apresentando e defendendo os meus pontos de vista.</td>
		<td>Sou capaz de me exprimir de forma clara e pormenorizada sobre uma vasta gama de assuntos relacionados com os meus centros de interesse. Sou capaz de explicar um ponto de vista sobre um dado assunto, apresentando as vantagens e desvantagens de diferentes opções.</td>
		<td>Sou capaz de escrever um texto claro e pormenorizado sobre uma vasta gama de assuntos relacionados com os meus centros de interesse. Sou capaz de redigir um texto expositivo ou um relatório, transmitindo informação ou apresentando razões a favor ou contra um determinado ponto de vista. Consigo escrever cartas evidenciando o significado que determinados acontecimentos ou experiências têm para mim</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Sou capaz de compreender uma exposição longa, mesmo que não esteja claramente estruturada ou quando a articulação entre as ideias esteja apenas implícita. Consigo compreender programas de televisão e filmes sem grande dificuldade.</td>
		<td>Sou capaz de compreender textos longos e complexos, literários e não literários, e distinguir estilos. Sou capaz de compreender artigos especializados e instruções técnicas longas, mesmo quando não se relacionam com a minha área de conhecimento.</td>
		<td>Sou capaz de me exprimir de forma espontânea e fluente, sem dificuldade aparente em encontrar as expressões adequadas. Sou capaz de utilizar a língua de maneira flexível e eficaz para fins sociais e profissionais. Formulo ideias e opiniões com precisão e adequo o meu discurso ao dos meus interlocutores.</td>
		<td>Sou capaz de apresentar descrições claras e pormenorizadas sobre temas complexos que integrem subtemas, desenvolvendo aspectos particulares e chegando a uma conclusão apropriada.</td>
		<td>Sou capaz de me exprimir de forma clara e bem estruturada, apresentando os meus pontos de vista com um certo grau de elaboração. Sou capaz de escrever cartas, comunicações ou relatórios sobre assuntos complexos, pondo em evidência os aspectos que considero mais importantes. Sou capaz de escrever no estilo que considero apropriado para o leitor que tenho em mente.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Não tenho nenhuma dificuldade em compreender qualquer tipo de enunciado oral, tanto face a face como através dos meios de comunicação, mesmo quando se fala depressa, à velocidade dos falantes nativos, sendo apenas necessário algum tempo para me familiarizar com o sotaque.</td>
		<td>Sou capaz de ler com facilidade praticamente todas as formas de texto escrito, incluindo textos mais abstractos, linguística ou estruturalmente complexos, tais como manuais, artigos especializados e obras literárias.</td>
		<td>Sou capaz de participar sem esforço em qualquer conversa ou discussão e mesmo utilizar expressões idiomáticas e coloquiais. Sou capaz de me exprimir fluentemente e de transmitir com precisão pequenas diferenças de sentido. Sempre que tenho um problema, sou capaz de voltar atrás, contornar a dificuldade e reformular, sem que tal seja notado.</td>
		<td>Sou capaz de, sem dificuldade e fluentemente, fazer uma exposição oral ou desenvolver uma argumentação num estilo apropriado ao contexto e com uma estrutura lógica tal que ajude o meu interlocutor a identificar e a memorizar os aspectos mais importantes.</td>
		<td>Sou capaz de escrever textos num estilo fluente e apropriado. Sou capaz de redigir de forma estruturada cartas complexas, relatórios ou artigos que apresentem um caso com uma tal estrutura lógica que ajude o leitor a aperceber-se dos pontos essenciais e a memorizá‑los. Sou capaz de fazer resumos e recensões de obras literárias e de âmbito profissional.</td>
	</tr>
  </table>
  </xsl:if>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif"/> <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_for_htmlpreview.gif"/>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg"/> 
</body>
</html>
  </xsl:template>
</xsl:stylesheet>
