Ext.data.JsonP.getting_started({
  "guide": "<h1>I. Introduction</h1>\n\n<hr />\n\n<p>Ext JS 4 is by far the biggest overhaul we’ve ever made to <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS, and constitutes the most advanced JavaScript framework ever created. Almost every area of the framework has been upgraded, from the generated HTML to the class system. We’ve unified APIs, added incredible new capabilities, and improved the performance of the entire framework.</p>\n\n<p>With <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4 we’ve been driven by three key goals: speed, robustness and ease of use. We wanted the framework to be as fast and as robust as possible on every browser, and to be easy to learn and use. To achieve this we took the whole framework back to the drawing board, and what we’ve come back with is the fastest, most bullet-proof version of <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS we’ve ever created. Best of all, we’ve managed to do it while staying true to the core experience of writing apps “the <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS way.”</p>\n\n<iframe src=\"http://player.vimeo.com/video/17666102?byline=0&amp;portrait=0\" width=\"500\" height=\"281\" frameborder=\"0\"></iframe>\n\n\n\n\n<iframe src=\"http://player.vimeo.com/video/17733892?byline=0&amp;portrait=0\" width=\"500\" height=\"281\" frameborder=\"0\"></iframe>\n\n\n<h1>II. Getting Started</h1>\n\n<hr />\n\n<h2>1. Requirements</h2>\n\n<h3>1.1 Web Browsers</h3>\n\n<p>Ext JS 4 supports almost any known web browsers, from Internet Explorer 6 to Chrome 11. During development, we recommend that you choose one of the following as the primary browsers for the best debugging experience:</p>\n\n<ul>\n<li><a href=\"http://www.google.com/chrome/intl/en/landing_chrome_mac.html?hl=en\">Google Chrome</a> 10+</li>\n<li><a href=\"http://www.apple.com/safari/download/\">Apple Safari</a> 5+</li>\n<li><a href=\"http://www.mozilla.com/en-US/firefox/new/?from=getfirefox\">Mozilla Firefox</a> 4+</li>\n</ul>\n\n\n<h3>1.2 Debugging Tools</h3>\n\n<p>Please refer to the dedicated <a href=\"#\">Debugging Handbook</a> guide on the recommended tools for each and every browser, as well as how to make use of them to aid development.</p>\n\n<h3>1.3 Web Server</h3>\n\n<p>Even though a local web server is not a requirement to use <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4, it is still highly recommended that you develop with one, since <a href=\"http://en.wikipedia.org/wiki/XHR\">XHR</a> over local <a href=\"http://en.wikipedia.org/wiki/File_URI_scheme\">file:// protocol</a> has <a href=\"http://en.wikipedia.org/wiki/Same_origin_policy\">cross origin restriction</a> on most browsers.</p>\n\n<h3>1.4. <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4 SDK</h3>\n\n<p>Download <a href=\"http://www.sencha.com/products/extjs/\">Ext JS 4 SDK</a> if you haven't done so. Unzip the package within your web root directory tree. This guide assumes that <code>http://localhost/ext-4.0</code> points to the top level directory of the downloaded SDK.</p>\n\n<p>Open <code>http://localhost/ext-4.0/index.html</code> on your web browser. If a welcome page appears, you are all set.</p>\n\n<h2>2. Application Structure</h2>\n\n<p>Although not being mandatory, all suggestions listed below should be considered as best-practice guidelines to keep your application well organized, extensible and maintainable.</p>\n\n<h3>2.1 Basic Structure</h3>\n\n<pre><code>- appname\n    - app\n        - namespace\n            - Class1.js\n            - Class2.js\n            - ...\n    - resources\n        - css\n        - images\n        - ...\n    - app.js\n    - index.html\n</code></pre>\n\n<p>in which:</p>\n\n<ul>\n<li><code>appname</code> is a directory containing all your application's source files</li>\n<li><code>app</code> contains all your classes, the naming style of which should follow the convention listed in the <a href=\"class_system\">Class System</a> guide</li>\n<li><code>resources</code> contains additional CSS and image files which are responsible for the look and feel of the application, as well as other static resources (XML, JSON, etc.)</li>\n<li><code>index.html</code> is the entry-point HTML document</li>\n<li><code>app.js</code> contains your own application's logic</li>\n</ul>\n\n\n<p>An <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS application is self-contained in a single HTML document, the content of which has this format:</p>\n\n<pre><code>&lt;html&gt;\n&lt;head&gt;\n    &lt;title&gt;Application Name&lt;/title&gt;\n\n    &lt;link rel=\"stylesheet\" type=\"text/css\" href=\"path/to/sdk/resources/css/ext-all.css\"&gt;\n    &lt;script type=\"text/javascript\" src=\"path/to/sdk/ext-debug.js\"&gt;&lt;/script&gt;\n    &lt;script type=\"text/javascript\" src=\"app.js\"&gt;&lt;/script&gt;\n&lt;/head&gt;\n&lt;body&gt;&lt;/body&gt;\n&lt;/html&gt;\n</code></pre>\n\n<p>whereby:</p>\n\n<ul>\n<li><code>path/to/sdk</code> points to <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4 SDK directory in section <em>1.4</em></li>\n<li><code>path/to/sdk/resources/css/ext-all.css</code> contains all styling information needed for the whole framework</li>\n<li><code>path/to/sdk/ext(-debug).js</code> contains <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4 Core library (or <code>path/to/sdk/ext-all(-debug).js</code>, as explained below)</li>\n</ul>\n\n\n<p>From this point you need to choose between 2 different library inclusion methods. Each has its own pros and cons listed below:</p>\n\n<ol>\n<li><p>Include <code>path/to/sdk/ext-all.js</code> (<code>path/to/sdk/ext-all-debug.js</code> during development), which contains the whole framework.</p>\n\n<ul>\n<li>Pros:\n\n<ul>\n<li>There is no need to worry about dependencies when using default <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS components (but not your own custom classes)</li>\n</ul>\n</li>\n<li>Cons:\n\n<ul>\n<li>Deployment file size could be unnecessarily large if your application doesn't make use of everything the library has to offer. That, as a consequence, would lead to slower application initialization due to unnecessary script execution as well as network data transfer overheads.</li>\n<li>Debugging is difficult due to the fact that all source code is confined into one big file.</li>\n</ul>\n</li>\n</ul>\n</li>\n<li><p>Include <code>path/to/sdk/ext.js</code> (<code>path/to/sdk/ext-debug.js</code> during development) which contains just the minimum core library, and make use of <a href=\"../api/Ext.Loader\">Ext.Loader</a> for automatic dependencies resolution.</p>\n\n<ul>\n<li>Pros:\n\n<ul>\n<li>Your application only loads exactly what it needs as you develop. Deployed file size will be minimal.</li>\n<li>Debugging is simple and straight-forward since all source files are loaded separated. Errors messages come with the exact line numbers and file names from which they occur.</li>\n</ul>\n</li>\n<li>Cons:\n\n<ul>\n<li>Attention to dependencies when using default components shipped with the SDK is needed</li>\n</ul>\n</li>\n</ul>\n</li>\n</ol>\n\n\n<p>In summary, it is recommended that you should only use <code>ext-all(-debug).js</code> if you need to shorten the initial learning curve. Otherwise, <code>ext(-debug).js</code> is preferred in most cases for actual application development.</p>\n\n<p>Last but not least, <code>app.js</code> is the entry-point of your own application's logic. For a basic application, the typical format of which may look like this:</p>\n\n<pre><code>// Register namespaces and their corresponding paths to <a href=\"#/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a>\nExt.Loader.setPath({\n    'AppName': 'app',\n    ... // Other namespaces\n});\n\n// Specify a list of classes your application your application needs\nExt.require([\n    ...\n]);\n\n// Application's initialization\nExt.onReady(function() {\n\n    ...\n\n});\n</code></pre>\n\n<h3>2.2 MVC (Model-View-Controller) Structure</h3>\n\n<p>Ext JS 4 shipped with a robust MVC architecture which maximize extensibility and maintainability for medium to large scale applications. Please refer to the <a href=\"application_architecture\">MVC Application Architecture guide</a> for detailed instructions.</p>\n\n<h1>3. Deployment</h1>\n\n<p>The newly introduced Sencha SDK Tools (<a href=\"http://www.sencha.com/products/extjs/\">download here</a> ) makes deployment of any <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4 application easier than ever. The tools allows you to generate a manifest of all dependencies in the form of a JSB3 (JSBuilder file format) file, and create a minimal custom build of just what your application needs within minutes.</p>\n\n<p>Once you've installed the SDK Tools, open a terminal window and navigate into your application's directory.</p>\n\n<pre><code>cd path/to/application\n</code></pre>\n\n<p>From here you only need to run a couple of simple commands. The first one generates a JSB3 file:</p>\n\n<pre><code>sencha create jsb -a index.html -p app.jsb3\n</code></pre>\n\n<p>This scans your <code>index.html</code> file for all framework and application files that are actually used by the app, and then creates a JSB file called <code>app.jsb3</code>. Generating the JSB3 first gives us a chance to modify the generated <code>app.jsb3</code> before building - this can be helpful if you have custom resources to copy, but in most cases we can immediately proceed to build the application with the second command:</p>\n\n<pre><code>sencha build -p app.jsb3 -d .\n</code></pre>\n\n<p>This takes the JSB3 file and creates an <code>app-all.js</code>, which is a minimized build of your application plus all of the <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS classes required to run it. It also creates an <code>all-classes.js</code> file, which has the same classes as <code>app-all.js</code>, but is not minified so is very useful for debugging problems with your built application. In short, <code>app-all.js</code> is the minified and production-ready version of <code>all-classes.js + app.js</code>.</p>\n\n<p>Most applications will need a separate <code>index.html</code> for the deployed version of the app, for example to add Analytics includes or other production-only logic into that file. Typically you would end up with a production <code>index.html</code> file that looks like this:</p>\n\n<pre><code>&lt;html&gt;\n&lt;head&gt;\n    &lt;title&gt;Application Name&lt;/title&gt;\n\n    &lt;link rel=\"stylesheet\" type=\"text/css\" href=\"path/to/sdk/resources/css/ext-all.css\"&gt;\n    &lt;script type=\"text/javascript\" src=\"path/to/sdk/ext.js\"&gt;&lt;/script&gt;\n    &lt;script type=\"text/javascript\" src=\"app-all.js\"&gt;&lt;/script&gt;\n&lt;/head&gt;\n&lt;body&gt;&lt;/body&gt;\n&lt;/html&gt;\n</code></pre>\n\n<p>Notice that <code>path/to/sdk/ext-debug.js</code> has been replaced with <code>path/to/sdk/ext.js</code>, and <code>app.js</code> has been replaced with <code>app-all.js</code> in this production version, comparing with the development one described in section <em>2.1</em></p>\n\n<p>For applications built on top of a dynamic server-side language like PHP, Ruby, ASP, etc., you can simply replace <code>index.html</code> in the first command to the actual URL of your application. This URL should be the same with what is viewable on the browsers during development. For example:</p>\n\n<pre><code>sencha create jsb -a http://localhost/path/to/application/index.php -p app.jsb3\n</code></pre>\n\n<h2>This guide is a work in progress.</h2>\n\n<p>Please check back soon</p>\n"
});