Ext.data.JsonP.Ext_draw_Sprite({
  "mixedInto": [

  ],
  "superclasses": [

  ],
  "inheritable": false,
  "subclasses": [

  ],
  "deprecated": null,
  "allMixins": [

  ],
  "href": "Sprite2.html#Ext-draw-Sprite",
  "members": {
    "cfg": [
      {
        "inheritable": false,
        "type": "String",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-fill",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "fill",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>The fill color</p>\n",
        "linenr": 165,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "String",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-font",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Used with text type sprites. ...",
        "static": false,
        "name": "font",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Used with text type sprites. The full font description. Uses the same syntax as the CSS font parameter</p>\n",
        "linenr": 177,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "String/Array",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-group",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "The group that this sprite belongs to, or an array of groups. ...",
        "static": false,
        "name": "group",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>The group that this sprite belongs to, or an array of groups. Only relevant when added to a\n<a href=\"#/api/Ext.draw.Surface\" rel=\"Ext.draw.Surface\" class=\"docClass\">Ext.draw.Surface</a></p>\n",
        "linenr": 185,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "Number",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-height",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "height",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Used in rectangle sprites, the height of the rectangle</p>\n",
        "linenr": 137,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "Number",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-opacity",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "opacity",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>The opacity of the sprite</p>\n",
        "linenr": 161,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "Array",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-path",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "path",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Used in path sprites, the path of the sprite written in SVG-like path syntax</p>\n",
        "linenr": 157,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "Number",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-radius",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "radius",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Used in circle sprites, the radius of the circle</p>\n",
        "linenr": 145,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "Number",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-size",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "size",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Used in square sprites, the dimension of the square</p>\n",
        "linenr": 141,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "Number",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-stroke",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "stroke",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>-width The width of the stroke</p>\n",
        "linenr": 173,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "String",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-text",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Used with text type sprites. ...",
        "static": false,
        "name": "text",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Used with text type sprites. The text itself</p>\n",
        "linenr": 181,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "String",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-type",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "The type of the sprite. ...",
        "static": false,
        "name": "type",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>The type of the sprite. Possible options are 'circle', 'path', 'rect', 'text', 'square', 'image'</p>\n",
        "linenr": 129,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "Number",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-width",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "width",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Used in rectangle sprites, the width of the rectangle</p>\n",
        "linenr": 133,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "Number",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-x",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "x",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>The position along the x-axis</p>\n",
        "linenr": 149,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "type": "Number",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-cfg-y",
        "protected": false,
        "tagname": "cfg",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "static": false,
        "name": "y",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>The position along the y-axis</p>\n",
        "linenr": 153,
        "html_filename": "Sprite2.html"
      }
    ],
    "method": [
      {
        "inheritable": false,
        "deprecated": null,
        "params": [
          {
            "type": "String/Array",
            "optional": false,
            "doc": "<p>The CSS class to add, or an array of classes</p>\n",
            "name": "className"
          }
        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-addCls",
        "return": {
          "type": "Ext.draw.Sprite",
          "doc": "<p>this</p>\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Adds one or more CSS classes to the element. ...",
        "static": false,
        "name": "addCls",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Adds one or more CSS classes to the element. Duplicate classes are automatically filtered out.  Note this method\nis severly limited in VML.</p>\n",
        "linenr": 478,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "deprecated": null,
        "params": [

        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-destroy",
        "return": {
          "type": "void",
          "doc": "\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Removes the sprite and clears all listeners. ...",
        "static": false,
        "name": "destroy",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Removes the sprite and clears all listeners.</p>\n",
        "linenr": 445,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "deprecated": null,
        "params": [

        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-getBBox",
        "return": {
          "type": "Object",
          "doc": "<p>bbox</p>\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Retrieve the bounding box of the sprite. ...",
        "static": false,
        "name": "getBBox",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Retrieve the bounding box of the sprite. This will be returned as an object with x, y, width, and height properties.</p>\n",
        "linenr": 394,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "deprecated": null,
        "params": [
          {
            "type": "Boolean",
            "optional": false,
            "doc": "<p>Flag to immediatly draw the change.</p>\n",
            "name": "redraw"
          }
        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-hide",
        "return": {
          "type": "Ext.draw.Sprite",
          "doc": "<p>this</p>\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Hide the sprite. ...",
        "static": false,
        "name": "hide",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Hide the sprite.</p>\n",
        "linenr": 406,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "deprecated": null,
        "params": [

        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-redraw",
        "return": {
          "type": "Ext.draw.Sprite",
          "doc": "<p>this</p>\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Redraw the sprite. ...",
        "static": false,
        "name": "redraw",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Redraw the sprite.</p>\n",
        "linenr": 458,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "deprecated": null,
        "params": [

        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-remove",
        "return": {
          "type": "void",
          "doc": "\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Remove the sprite. ...",
        "static": false,
        "name": "remove",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Remove the sprite.</p>\n",
        "linenr": 430,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "deprecated": null,
        "params": [
          {
            "type": "String/Array",
            "optional": false,
            "doc": "<p>The CSS class to remove, or an array of classes.  Note this method\nis severly limited in VML.</p>\n",
            "name": "className"
          }
        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-removeCls",
        "return": {
          "type": "Ext.draw.Sprite",
          "doc": "<p>this</p>\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Removes one or more CSS classes from the element. ...",
        "static": false,
        "name": "removeCls",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Removes one or more CSS classes from the element.</p>\n",
        "linenr": 489,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "deprecated": null,
        "params": [
          {
            "type": "Object",
            "optional": false,
            "doc": "<p>attributes to be changed on the sprite.</p>\n",
            "name": "attrs"
          },
          {
            "type": "Boolean",
            "optional": false,
            "doc": "<p>Flag to immediatly draw the change.</p>\n",
            "name": "redraw"
          }
        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-setAttributes",
        "return": {
          "type": "Ext.draw.Sprite",
          "doc": "<p>this</p>\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Change the attributes of the sprite. ...",
        "static": false,
        "name": "setAttributes",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Change the attributes of the sprite.</p>\n",
        "linenr": 297,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "deprecated": null,
        "params": [
          {
            "type": "String/Object",
            "optional": false,
            "doc": "<p>The style property to be set, or an object of multiple styles.</p>\n",
            "name": "property"
          },
          {
            "type": "String",
            "optional": true,
            "doc": "<p>(optional) The value to apply to the given property, or null if an object was passed.</p>\n",
            "name": "value"
          }
        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-setStyle",
        "return": {
          "type": "Ext.draw.Sprite",
          "doc": "<p>this</p>\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Wrapper for setting style properties, also takes single object parameter of multiple styles. ...",
        "static": false,
        "name": "setStyle",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Wrapper for setting style properties, also takes single object parameter of multiple styles.</p>\n",
        "linenr": 467,
        "html_filename": "Sprite2.html"
      },
      {
        "inheritable": false,
        "deprecated": null,
        "params": [
          {
            "type": "Boolean",
            "optional": false,
            "doc": "<p>Flag to immediatly draw the change.</p>\n",
            "name": "redraw"
          }
        ],
        "href": "Sprite2.html#Ext-draw-Sprite-method-show",
        "return": {
          "type": "Ext.draw.Sprite",
          "doc": "<p>this</p>\n"
        },
        "protected": false,
        "tagname": "method",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "Show the sprite. ...",
        "static": false,
        "name": "show",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>Show the sprite.</p>\n",
        "linenr": 418,
        "html_filename": "Sprite2.html"
      }
    ],
    "event": [

    ],
    "css_var": [

    ],
    "css_mixin": [

    ],
    "property": [
      {
        "inheritable": false,
        "type": "Ext.dd.DragSource.",
        "deprecated": null,
        "href": "Sprite2.html#Ext-draw-Sprite-property-dd",
        "protected": false,
        "tagname": "property",
        "alias": null,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
        "private": false,
        "shortDoc": "If this Sprite is configured draggable, this property will contain\nan instance of Ext.dd.DragSource which handles dra...",
        "static": false,
        "name": "dd",
        "owner": "Ext.draw.Sprite",
        "doc": "<p>If this Sprite is configured draggable, this property will contain\nan instance of <a href=\"#/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> which handles dragging the Sprite.</p>\n\n\n<p>The developer must provide implementations of the abstract methods of <a href=\"#/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a>\nin order to supply behaviour for each stage of the drag/drop process. See draggable.</p>\n",
        "linenr": 278,
        "html_filename": "Sprite2.html"
      }
    ]
  },
  "singleton": false,
  "protected": false,
  "tagname": "class",
  "mixins": [

  ],
  "alias": null,
  "author": null,
  "filename": "/mnt/ebs/nightly/git/SDK/platform/src/draw/Sprite.js",
  "private": false,
  "alternateClassNames": [

  ],
  "static": false,
  "name": "Ext.draw.Sprite",
  "doc": "<p>A Sprite is an object rendered in a Drawing surface. There are different options and types of sprites.\nThe configuration of a Sprite is an object with the following properties:</p>\n\n<ul>\n<li><strong>type</strong> - (String) The type of the sprite. Possible options are 'circle', 'path', 'rect', 'text', 'square', 'image'.</li>\n<li><strong>group</strong> - (String/Array) The group that this sprite belongs to, or an array of groups. Only relevant when added to a <a href=\"#/api/Ext.draw.Surface\" rel=\"Ext.draw.Surface\" class=\"docClass\">Ext.draw.Surface</a>.</li>\n<li><strong>width</strong> - (Number) Used in rectangle sprites, the width of the rectangle.</li>\n<li><strong>height</strong> - (Number) Used in rectangle sprites, the height of the rectangle.</li>\n<li><strong>size</strong> - (Number) Used in square sprites, the dimension of the square.</li>\n<li><strong>radius</strong> - (Number) Used in circle sprites, the radius of the circle.</li>\n<li><strong>x</strong> - (Number) The position along the x-axis.</li>\n<li><strong>y</strong> - (Number) The position along the y-axis.</li>\n<li><strong>path</strong> - (Array) Used in path sprites, the path of the sprite written in SVG-like path syntax.</li>\n<li><strong>opacity</strong> - (Number) The opacity of the sprite.</li>\n<li><strong>fill</strong> - (String) The fill color.</li>\n<li><strong>stroke</strong> - (String) The stroke color.</li>\n<li><strong>stroke-width</strong> - (Number) The width of the stroke.</li>\n<li><strong>font</strong> - (String) Used with text type sprites. The full font description. Uses the same syntax as the CSS <code>font</code> parameter.</li>\n<li><strong>text</strong> - (String) Used with text type sprites. The text itself.</li>\n<li><strong>translate</strong> - (Object) Defines a translation for the Sprite. There's more information on this property below.</li>\n<li><strong>rotate</strong> - (Object) Defines a rotation for the Sprite. There's more information on this property below.</li>\n<li><strong>scale</strong> - (Object) Defines a scaling for the Sprite. There's more information on this property below.</li>\n</ul>\n\n\n<h2>Translation</h2>\n\n<p>For translate, the configuration object contains x and y attributes that indicate where to\ntranslate the object. For example:</p>\n\n<pre><code>sprite.setAttributes({\n  translate: {\n   x: 10,\n   y: 10\n  }\n}, true);\n</code></pre>\n\n<h2>Rotation</h2>\n\n<p>For rotation, the configuration object contains x and y attributes for the center of the rotation (which are optional),\nand a <code>degrees</code> attribute that specifies the rotation in degrees. For example:</p>\n\n<pre><code>sprite.setAttributes({\n  rotate: {\n   degrees: 90\n  }\n}, true);\n</code></pre>\n\n<p>That example will create a 90 degrees rotation using the centroid of the Sprite as center of rotation, whereas:</p>\n\n<pre><code>sprite.setAttributes({\n  rotate: {\n   x: 0,\n   y: 0,\n   degrees: 90\n  }\n}, true);\n</code></pre>\n\n<p>will create a rotation around the <code>(0, 0)</code> axis.</p>\n\n<h2>Scaling</h2>\n\n<p>For scaling, the configuration object contains x and y attributes for the x-axis and y-axis scaling. For example:</p>\n\n<pre><code>sprite.setAttributes({\n  scale: {\n   x: 10,\n   y: 3\n  }\n}, true);\n</code></pre>\n\n<p>You can also specify the center of scaling by adding <code>cx</code> and <code>cy</code> as properties:</p>\n\n<pre><code>sprite.setAttributes({\n  scale: {\n   cx: 0,\n   cy: 0,\n   x: 10,\n   y: 3\n  }\n}, true);\n</code></pre>\n\n<p>That last example will scale a sprite taking as centers of scaling the <code>(0, 0)</code> coordinate.</p>\n\n<h2>Creating and adding a Sprite to a Surface</h2>\n\n<p>Sprites can be created with a reference to a <a href=\"#/api/Ext.draw.Surface\" rel=\"Ext.draw.Surface\" class=\"docClass\">Ext.draw.Surface</a></p>\n\n<pre><code> var drawComponent = Ext.create('Ext.draw.Component', options here...);\n\n var sprite = Ext.create('Ext.draw.Sprite', {\n     type: 'circle',\n     fill: '#ff0',\n     surface: drawComponent.surface,\n     radius: 5\n });\n</code></pre>\n\n<p>Sprites can also be added to the surface as a configuration object:</p>\n\n<pre><code> var sprite = drawComponent.surface.add({\n     type: 'circle',\n     fill: '#ff0',\n     radius: 5\n });\n</code></pre>\n\n<p>In order to properly apply properties and render the sprite we have to\n<code>show</code> the sprite setting the option <code>redraw</code> to <code>true</code>:</p>\n\n<pre><code> sprite.show(true);\n</code></pre>\n\n<p>The constructor configuration object of the Sprite can also be used and passed into the <a href=\"#/api/Ext.draw.Surface\" rel=\"Ext.draw.Surface\" class=\"docClass\">Ext.draw.Surface</a>\nadd method to append a new sprite to the canvas. For example:</p>\n\n<pre><code>drawComponent.surface.add({\n    type: 'circle',\n    fill: '#ffc',\n    radius: 100,\n    x: 100,\n    y: 100\n});\n</code></pre>\n",
  "docauthor": null,
  "component": false,
  "linenr": 1,
  "xtypes": [

  ],
  "html_filename": "Sprite2.html",
  "statics": {
    "cfg": [

    ],
    "method": [

    ],
    "event": [

    ],
    "css_var": [

    ],
    "css_mixin": [

    ],
    "property": [

    ]
  },
  "extends": "Object"
});