Ext.data.JsonP.Ext_Element({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Alternate names</h4><div class='alternate-class-name'>Ext.core.Element</div><h4>Files</h4><div class='dependency'><a href='source/Element-more.html#Ext-Element' target='_blank'>Element-more.js</a></div><div class='dependency'><a href='source/Element.alignment.html#Ext-Element' target='_blank'>Element.alignment.js</a></div><div class='dependency'><a href='source/Element.anim.html#Ext-Element' target='_blank'>Element.anim.js</a></div><div class='dependency'><a href='source/Element.dd.html#Ext-Element' target='_blank'>Element.dd.js</a></div><div class='dependency'><a href='source/Element.fx-more.html#Ext-Element' target='_blank'>Element.fx-more.js</a></div><div class='dependency'><a href='source/Element.fx.html#Ext-Element' target='_blank'>Element.fx.js</a></div><div class='dependency'><a href='source/Element.insertion.html#Ext-Element' target='_blank'>Element.insertion.js</a></div><div class='dependency'><a href='source/Element2.html#Ext-Element' target='_blank'>Element.js</a></div><div class='dependency'><a href='source/Element.keys.html#Ext-Element' target='_blank'>Element.keys.js</a></div><div class='dependency'><a href='source/Element.position.html#Ext-Element' target='_blank'>Element.position.js</a></div><div class='dependency'><a href='source/Element.scroll.html#Ext-Element' target='_blank'>Element.scroll.js</a></div><div class='dependency'><a href='source/Element.static-more.html#Ext-Element' target='_blank'>Element.static-more.js</a></div><div class='dependency'><a href='source/Element.static.html#Ext-Element' target='_blank'>Element.static.js</a></div><div class='dependency'><a href='source/Element.style.html#Ext-Element' target='_blank'>Element.style.js</a></div><div class='dependency'><a href='source/Element.traversal.html#Ext-Element' target='_blank'>Element.traversal.js</a></div></pre><div class='doc-contents'><p>Encapsulates a DOM element, adding simple DOM manipulation facilities, normalizing for browser differences.</p>\n\n<p>All instances of this class inherit the methods of <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a> making visual effects easily available to all\nDOM elements.</p>\n\n<p>Note that the events documented in this class are not Ext events, they encapsulate browser events. Some older browsers\nmay not support the full range of events. Which events are supported is beyond the control of Ext JS.</p>\n\n<p>Usage:</p>\n\n<pre><code>// by id\nvar el = Ext.get(\"my-div\");\n\n// by DOM element reference\nvar el = Ext.get(myDivElement);\n</code></pre>\n\n<h1>Animations</h1>\n\n<p>When an element is manipulated, by default there is no animation.</p>\n\n<pre><code>var el = Ext.get(\"my-div\");\n\n// no animation\nel.setWidth(100);\n</code></pre>\n\n<p>Many of the functions for manipulating an element have an optional \"animate\" parameter. This parameter can be\nspecified as boolean (true) for default animation effects.</p>\n\n<pre><code>// default animation\nel.setWidth(100, true);\n</code></pre>\n\n<p>To configure the effects, an object literal with animation options to use as the Element animation configuration\nobject can also be specified. Note that the supported Element animation configuration options are a subset of the\n<a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a> animation options specific to Fx effects. The supported Element animation configuration options\nare:</p>\n\n<pre><code>Option    Default   Description\n--------- --------  ---------------------------------------------\n<a href=\"#!/api/Ext.fx.Anim-cfg-duration\" rel=\"Ext.fx.Anim-cfg-duration\" class=\"docClass\">duration</a>  .35       The duration of the animation in seconds\n<a href=\"#!/api/Ext.fx.Anim-cfg-easing\" rel=\"Ext.fx.Anim-cfg-easing\" class=\"docClass\">easing</a>    easeOut   The easing method\n<a href=\"#!/api/Ext.fx.Anim-cfg-callback\" rel=\"Ext.fx.Anim-cfg-callback\" class=\"docClass\">callback</a>  none      A function to execute when the anim completes\n<a href=\"#!/api/Ext.fx.Anim-cfg-scope\" rel=\"Ext.fx.Anim-cfg-scope\" class=\"docClass\">scope</a>     this      The scope (this) of the callback function\n</code></pre>\n\n<p>Usage:</p>\n\n<pre><code>// Element animation options object\nvar opt = {\n    <a href=\"#!/api/Ext.fx.Anim-cfg-duration\" rel=\"Ext.fx.Anim-cfg-duration\" class=\"docClass\">duration</a>: 1,\n    <a href=\"#!/api/Ext.fx.Anim-cfg-easing\" rel=\"Ext.fx.Anim-cfg-easing\" class=\"docClass\">easing</a>: 'elasticIn',\n    <a href=\"#!/api/Ext.fx.Anim-cfg-callback\" rel=\"Ext.fx.Anim-cfg-callback\" class=\"docClass\">callback</a>: this.foo,\n    <a href=\"#!/api/Ext.fx.Anim-cfg-scope\" rel=\"Ext.fx.Anim-cfg-scope\" class=\"docClass\">scope</a>: this\n};\n// animation with some options set\nel.setWidth(100, opt);\n</code></pre>\n\n<p>The Element animation object being used for the animation will be set on the options object as \"anim\", which allows\nyou to stop or manipulate the animation. Here is an example:</p>\n\n<pre><code>// using the \"anim\" property to get the Anim object\nif(opt.anim.isAnimated()){\n    opt.anim.stop();\n}\n</code></pre>\n\n<h1>Composite (Collections of) Elements</h1>\n\n<p>For working with collections of Elements, see <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></p>\n</div><div class='members'><div id='m-property'><h3 class='members-title'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Properties</h3><div id='property-autoBoxAdjust' class='member first-child not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-property-autoBoxAdjust' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-property-autoBoxAdjust' class='name not-expandable'>autoBoxAdjust</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>true to automatically adjust width and height settings for box-model issues (default to true)</p>\n</div><div class='long'><p>true to automatically adjust width and height settings for box-model issues (default to true)</p>\n</div></div></div><div id='property-defaultUnit' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-property-defaultUnit' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-property-defaultUnit' class='name not-expandable'>defaultUnit</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The default unit to append to CSS values where a unit isn't provided.</p>\n</div><div class='long'><p>The default unit to append to CSS values where a unit isn't provided.</p>\n</div></div></div><div id='property-dom' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-property-dom' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-property-dom' class='name not-expandable'>dom</a><span> : HTMLElement</span></div><div class='description'><div class='short'><p>The DOM element</p>\n</div><div class='long'><p>The DOM element</p>\n</div></div></div><div id='property-id' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-property-id' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-property-id' class='name not-expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The DOM element ID</p>\n</div><div class='long'><p>The DOM element ID</p>\n</div></div></div><div id='property-originalDisplay' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-property-originalDisplay' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-property-originalDisplay' class='name not-expandable'>originalDisplay</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The element's default display mode</p>\n</div><div class='long'><p>The element's default display mode</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Properties</h3><div id='static-property-DISPLAY' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-static-property-DISPLAY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-property-DISPLAY' class='name expandable'>DISPLAY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Visibility mode constant for use with setVisibilityMode. ...</div><div class='long'><p>Visibility mode constant for use with <a href=\"#!/api/Ext.Element-method-setVisibilityMode\" rel=\"Ext.Element-method-setVisibilityMode\" class=\"docClass\">setVisibilityMode</a>. Use display to hide element</p>\n</div></div></div><div id='static-property-OFFSETS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-static-property-OFFSETS' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-property-OFFSETS' class='name expandable'>OFFSETS</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Visibility mode constant for use with setVisibilityMode. ...</div><div class='long'><p>Visibility mode constant for use with <a href=\"#!/api/Ext.Element-method-setVisibilityMode\" rel=\"Ext.Element-method-setVisibilityMode\" class=\"docClass\">setVisibilityMode</a>. Use offsets (x and y positioning offscreen)\nto hide element.</p>\n</div></div></div><div id='static-property-VISIBILITY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-static-property-VISIBILITY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-property-VISIBILITY' class='name expandable'>VISIBILITY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Visibility mode constant for use with setVisibilityMode. ...</div><div class='long'><p>Visibility mode constant for use with <a href=\"#!/api/Ext.Element-method-setVisibilityMode\" rel=\"Ext.Element-method-setVisibilityMode\" class=\"docClass\">setVisibilityMode</a>. Use visibility to hide element</p>\n</div></div></div><div id='static-property-visibilityCls' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-static-property-visibilityCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-property-visibilityCls' class='name not-expandable'>visibilityCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='static-signature'>static</strong></div><div class='description'><div class='short'><p>Defaults to 'x-hide-nosize'</p>\n</div><div class='long'><p>Defaults to 'x-hide-nosize'</p>\n</div></div></div></div></div><div id='m-method'><h3 class='members-title'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-constructor' target='_blank' class='viewSource'>view source</a></div><strong class='constructor-signature'>new</strong><a href='#!/api/Ext.Element-method-constructor' class='name expandable'>Ext.Element</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement element, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> forceNew]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Creates new Element directly. ...</div><div class='long'><p>Creates new Element directly.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'>\n</div></li><li><span class='pre'>forceNew</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>By default the constructor checks to see if there is already an instance of this\nelement in the cache and if there is it returns the same instance. This will skip that check (useful for extending\nthis class).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-addCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-addCls' class='name expandable'>addCls</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Adds one or more CSS classes to the element. ...</div><div class='long'><p>Adds one or more CSS classes to the element. Duplicate classes are automatically filtered out.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The CSS classes to add separated by space, or an array of classes</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addClsOnClick' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-addClsOnClick' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-addClsOnClick' class='name expandable'>addClsOnClick</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets up event handlers to add and remove a css class when the mouse is down and then up on this element (a click effect) ...</div><div class='long'><p>Sets up event handlers to add and remove a css class when the mouse is down and then up on this element (a click effect)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addClsOnFocus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-addClsOnFocus' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-addClsOnFocus' class='name expandable'>addClsOnFocus</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets up event handlers to add and remove a css class when this element has the focus ...</div><div class='long'><p>Sets up event handlers to add and remove a css class when this element has the focus</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addClsOnOver' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-addClsOnOver' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-addClsOnOver' class='name expandable'>addClsOnOver</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets up event handlers to add and remove a css class when the mouse is over this element ...</div><div class='long'><p>Sets up event handlers to add and remove a css class when the mouse is over this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addKeyListener' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.keys.html#Ext-Element-method-addKeyListener' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-addKeyListener' class='name expandable'>addKeyListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> key, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> ) : <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a></div><div class='description'><div class='short'>Convenience method for constructing a KeyMap ...</div><div class='long'><p>Convenience method for constructing a KeyMap</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Either a string with the keys to listen for, the numeric key code, array of key codes or an object with the following options:\n<code>{key: (number or array), shift: (true/false), ctrl: (true/false), alt: (true/false)}</code></p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the specified function is executed. Defaults to this Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a></span><div class='sub-desc'><p>The KeyMap created</p>\n</div></li></ul></div></div></div><div id='method-addKeyMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.keys.html#Ext-Element-method-addKeyMap' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-addKeyMap' class='name expandable'>addKeyMap</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a></div><div class='description'><div class='short'>Creates a KeyMap for this element ...</div><div class='long'><p>Creates a KeyMap for this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The KeyMap config. See <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a> for more details</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a></span><div class='sub-desc'><p>The KeyMap created</p>\n</div></li></ul></div></div></div><div id='method-addListener' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-addListener' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-addListener' class='name expandable'>addListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Appends an event handler to this element. ...</div><div class='long'><p>Appends an event handler to this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of event to handle.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler function the event invokes. This function is passed the following parameters:</p>\n\n\n\n\n<ul>\n<li><p><strong>evt</strong> : EventObject</p>\n\n<p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">EventObject</a> describing the event.</p></li>\n<li><p><strong>el</strong> : HtmlElement</p>\n\n<p>The DOM element which was the target of the event. Note that this may be filtered by using the delegate option.</p></li>\n<li><p><strong>o</strong> : Object</p>\n\n<p>The options object from the addListener call.</p></li>\n</ul>\n\n\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<strong>this</strong> reference) in which the handler function is executed. <strong>If\nomitted, defaults to this Element.</strong></p>\n\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>An object containing handler configuration properties. This may contain any of\nthe following properties:</p>\n\n\n\n\n<ul>\n<li><p><strong>scope</strong> Object :</p>\n\n<p>The scope (<strong>this</strong> reference) in which the handler function is executed. <strong>If omitted, defaults to this\nElement.</strong></p></li>\n<li><p><strong>delegate</strong> String:</p>\n\n<p>A simple selector to filter the target or look for a descendant of the target. See below for additional details.</p></li>\n<li><p><strong>stopEvent</strong> Boolean:</p>\n\n<p>True to stop the event. That is stop propagation, and prevent the default action.</p></li>\n<li><p><strong>preventDefault</strong> Boolean:</p>\n\n<p>True to prevent the default action</p></li>\n<li><p><strong>stopPropagation</strong> Boolean:</p>\n\n<p>True to prevent event propagation</p></li>\n<li><p><strong>normalized</strong> Boolean:</p>\n\n<p>False to pass a browser event to the handler function instead of an <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a></p></li>\n<li><p><strong>target</strong> Ext.Element:</p>\n\n<p>Only call the handler if the event was fired on the target Element, <em>not</em> if the event was bubbled up from a\nchild node.</p></li>\n<li><p><strong>delay</strong> Number:</p>\n\n<p>The number of milliseconds to delay the invocation of the handler after the event fires.</p></li>\n<li><p><strong>single</strong> Boolean:</p>\n\n<p>True to add a handler to handle just the next firing of the event, and then remove itself.</p></li>\n<li><p><strong>buffer</strong> Number:</p>\n\n<p>Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed by the specified number of\nmilliseconds. If the event fires again within that time, the original handler is <em>not</em> invoked, but the new\nhandler is scheduled in its place.</p></li>\n</ul>\n\n\n\n\n<p><strong>Combining Options</strong></p>\n\n\n\n\n<p>In the following examples, the shorthand form <a href=\"#!/api/Ext.Element-method-on\" rel=\"Ext.Element-method-on\" class=\"docClass\">on</a> is used rather than the more verbose addListener. The\ntwo are equivalent. Using the options argument, it is possible to combine different types of listeners:</p>\n\n\n\n\n<p>A delayed, one-time listener that auto stops the event and adds a custom argument (forumId) to the options\nobject. The options object is available as the third parameter in the handler function.</p>\n\n\n\n\n<p>Code:</p>\n\n\n\n\n<pre><code>el.on('click', this.onClick, this, {\n    single: true,\n    delay: 100,\n    stopEvent : true,\n    forumId: 4\n});\n</code></pre>\n\n\n\n\n<p><strong>Attaching multiple handlers in 1 call</strong></p>\n\n\n\n\n<p>The method also allows for a single argument to be passed which is a config object containing properties which\nspecify multiple handlers.</p>\n\n\n\n\n<p>Code:</p>\n\n\n\n\n<pre><code>el.on({\n    'click' : {\n        fn: this.onClick,\n        scope: this,\n        delay: 100\n    },\n    'mouseover' : {\n        fn: this.onMouseOver,\n        scope: this\n    },\n    'mouseout' : {\n        fn: this.onMouseOut,\n        scope: this\n    }\n});\n</code></pre>\n\n\n\n\n<p>Or a shorthand syntax:</p>\n\n\n\n\n<p>Code:</p>\n\n\n\n\n<pre><code>el.on({\n    'click' : this.onClick,\n    'mouseover' : this.onMouseOver,\n    'mouseout' : this.onMouseOut,\n    scope: this\n});\n</code></pre>\n\n\n\n\n<p><strong>delegate</strong></p>\n\n\n\n\n<p>This is a configuration option that you can pass along when registering a handler for an event to assist with\nevent delegation. Event delegation is a technique that is used to reduce memory consumption and prevent exposure\nto memory-leaks. By registering an event for a container element as opposed to each element within a container.\nBy setting this configuration option to a simple selector, the target element will be filtered to look for a\ndescendant of the target. For example:</p>\n\n\n\n\n<pre><code>// using this markup:\n&lt;div id='elId'&gt;\n    &lt;p id='p1'&gt;paragraph one&lt;/p&gt;\n    &lt;p id='p2' class='clickable'&gt;paragraph two&lt;/p&gt;\n    &lt;p id='p3'&gt;paragraph three&lt;/p&gt;\n&lt;/div&gt;\n\n// utilize event delegation to registering just one handler on the container element:\nel = Ext.get('elId');\nel.on(\n    'click',\n    function(e,t) {\n        // handle click\n        console.info(t.id); // 'p2'\n    },\n    this,\n    {\n        // filter the target element to be a descendant with the class 'clickable'\n        delegate: '.clickable'\n    }\n);\n</code></pre>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n\n</div></li></ul></div></div></div><div id='method-adjustWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-adjustWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-adjustWidth' class='name expandable'>adjustWidth</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> width</span> )</div><div class='description'><div class='short'>TODO: Look at this ...</div><div class='long'><p>TODO: Look at this</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-alignTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.alignment.html#Ext-Element-method-alignTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-alignTo' class='name expandable'>alignTo</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> element, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> position], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] offsets], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Aligns this element with another element relative to the specified anchor points. ...</div><div class='long'><p>Aligns this element with another element relative to the specified anchor points. If the other element is the\ndocument it aligns it to the viewport.\nThe position parameter is optional, and can be specified in any one of the following formats:</p>\n\n<ul>\n  <li><b>Blank</b>: Defaults to aligning the element's top-left corner to the target's bottom-left corner (\"tl-bl\").</li>\n  <li><b>One anchor (deprecated)</b>: The passed anchor position is used as the target element's anchor point.\n      The element being aligned will position its top-left corner (tl) to that point.  <i>This method has been\n      deprecated in favor of the newer two anchor syntax below</i>.</li>\n  <li><b>Two anchors</b>: If two values from the table below are passed separated by a dash, the first value is used as the\n      element's anchor point, and the second value is used as the target's anchor point.</li>\n</ul>\n\n\n<p>In addition to the anchor points, the position parameter also supports the \"?\" character.  If \"?\" is passed at the end of\nthe position string, the element will attempt to align as specified, but the position will be adjusted to constrain to\nthe viewport if necessary.  Note that the element being aligned might be swapped to align to a different position than\nthat specified in order to enforce the viewport constraints.\nFollowing are all of the supported anchor positions:</p>\n\n<pre>Value  Description\n-----  -----------------------------\ntl     The top left corner (default)\nt      The center of the top edge\ntr     The top right corner\nl      The center of the left edge\nc      In the center of the element\nr      The center of the right edge\nbl     The bottom left corner\nb      The center of the bottom edge\nbr     The bottom right corner\n</pre>\n\n\n<p>Example Usage:</p>\n\n<pre><code>// align el to other-el using the default positioning (\"tl-bl\", non-constrained)\nel.alignTo(\"other-el\");\n\n// align the top left corner of el with the top right corner of other-el (constrained to viewport)\nel.alignTo(\"other-el\", \"tr?\");\n\n// align the bottom right corner of el with the center left edge of other-el\nel.alignTo(\"other-el\", \"br-l?\");\n\n// align the center of el with the bottom left corner of other-el and\n// adjust the x position by -6 pixels (and the y position by 0)\nel.alignTo(\"other-el\", \"c-bl\", [-6, 0]);\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The element to align to.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The position to align to</p>\n<p>Defaults to: <code>&quot;tl-bl?&quot;</code></p></div></li><li><span class='pre'>offsets</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] (optional)<div class='sub-desc'><p>Offset the positioning by [x, y]</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-anchorTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.alignment.html#Ext-Element-method-anchorTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-anchorTo' class='name expandable'>anchorTo</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> element, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> position, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] offsets], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> monitorScroll], [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> callback]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Anchors an element to another element and realigns it when the window is resized. ...</div><div class='long'><p>Anchors an element to another element and realigns it when the window is resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The element to align to.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The position to align to.</p>\n</div></li><li><span class='pre'>offsets</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] (optional)<div class='sub-desc'><p>Offset the positioning by [x, y]</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True for the default animation or a standard Element animation config object</p>\n</div></li><li><span class='pre'>monitorScroll</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>True to monitor body scroll and reposition. If this parameter\nis a number, it is used as the buffer delay (defaults to 50ms).</p>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>The function to call after the animation finishes</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-appendChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-appendChild' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-appendChild' class='name expandable'>appendChild</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Appends the passed element(s) to this element ...</div><div class='long'><p>Appends the passed element(s) to this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The id of the node, a DOM Node or an existing Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-appendTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-appendTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-appendTo' class='name expandable'>appendTo</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Appends this element to the passed element ...</div><div class='long'><p>Appends this element to the passed element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The new parent element.\nThe id of the node, a DOM Node or an existing Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-applyStyles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-applyStyles' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-applyStyles' class='name expandable'>applyStyles</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> styles</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>More flexible version of setStyle for setting style properties. ...</div><div class='long'><p>More flexible version of <a href=\"#!/api/Ext.Element-method-setStyle\" rel=\"Ext.Element-method-setStyle\" class=\"docClass\">setStyle</a> for setting style properties.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>styles</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>A style specification string, e.g. \"width:100px\", or object in the form {width:\"100px\"}, or\na function which returns such a specification.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-blur' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-blur' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-blur' class='name expandable'>blur</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Tries to blur the element. ...</div><div class='long'><p>Tries to blur the element. Any exceptions are caught and ignored.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-boxWrap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-boxWrap' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-boxWrap' class='name expandable'>boxWrap</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> class]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Wraps the specified element with a special 9 element markup/CSS block that renders by default as\na gray container wit...</div><div class='long'><p>Wraps the specified element with a special 9 element markup/CSS block that renders by default as\na gray container with a gradient background, rounded corners and a 4-way shadow.</p>\n\n\n<p>This special markup is used throughout Ext when box wrapping elements (<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>,\n<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a> when <tt><a href=\"#!/api/Ext.panel.Panel-cfg-frame\" rel=\"Ext.panel.Panel-cfg-frame\" class=\"docClass\">frame=true</a></tt>, <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>).  The markup\nis of this form:</p>\n\n\n<pre><code>    Ext.Element.boxMarkup =\n    &#39;&lt;div class=\"{0}-tl\">&lt;div class=\"{0}-tr\">&lt;div class=\"{0}-tc\">&lt;/div>&lt;/div>&lt;/div>\n     &lt;div class=\"{0}-ml\">&lt;div class=\"{0}-mr\">&lt;div class=\"{0}-mc\">&lt;/div>&lt;/div>&lt;/div>\n     &lt;div class=\"{0}-bl\">&lt;div class=\"{0}-br\">&lt;div class=\"{0}-bc\">&lt;/div>&lt;/div>&lt;/div>&#39;;\n</code></pre>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>    // Basic box wrap\n    Ext.get(\"foo\").boxWrap();\n\n    // You can also add a custom class and use CSS inheritance rules to customize the box look.\n    // 'x-box-blue' is a built-in alternative -- look at the related CSS definitions as an example\n    // for how to create a custom box wrap style.\n    Ext.get(\"foo\").boxWrap().addCls(\"x-box-blue\");\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>class</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A base CSS class to apply to the containing wrapper element\n(defaults to <tt>'x-box'</tt>). Note that there are a number of CSS rules that are dependent on\nthis name to make the overall effect work, so if you supply an alternate base class, make sure you\nalso supply all of the necessary rules.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The outermost wrapping element of the created box structure.</p>\n</div></li></ul></div></div></div><div id='method-center' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.alignment.html#Ext-Element-method-center' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-center' class='name expandable'>center</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> centerIn]</span> )</div><div class='description'><div class='short'>Centers the Element in either the viewport, or another Element. ...</div><div class='long'><p>Centers the Element in either the viewport, or another Element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>centerIn</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (optional)<div class='sub-desc'><p>The element in which to center the element.</p>\n</div></li></ul></div></div></div><div id='method-child' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-child' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-child' class='name expandable'>child</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Selects a single direct child based on the passed CSS selector (the selector should not contain an id). ...</div><div class='long'><p>Selects a single <em>direct</em> child based on the passed CSS selector (the selector should not contain an id).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS selector</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return the DOM node instead of <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The child <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (or DOM node if returnDom = true)</p>\n</div></li></ul></div></div></div><div id='method-clean' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element-more.html#Ext-Element-method-clean' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-clean' class='name expandable'>clean</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> forceReclean]</span> )</div><div class='description'><div class='short'>Removes Empty, or whitespace filled text nodes. ...</div><div class='long'><p>Removes Empty, or whitespace filled text nodes. Combines adjacent text nodes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>forceReclean</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>By default the element\nkeeps track if it has been cleaned already so\nyou can call this over and over. However, if you update the element and\nneed to force a reclean, you can pass true.</p>\n</div></li></ul></div></div></div><div id='method-clearListeners' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-clearListeners' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-clearListeners' class='name expandable'>clearListeners</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Alias for removeAllListeners. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.Element-method-removeAllListeners\" rel=\"Ext.Element-method-removeAllListeners\" class=\"docClass\">removeAllListeners</a>.</p>\n\n<p>Removes all previous added listeners from this element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n\n</div></li></ul></div></div></div><div id='method-clearOpacity' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-clearOpacity' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-clearOpacity' class='name expandable'>clearOpacity</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Clears any opacity settings from this element. ...</div><div class='long'><p>Clears any opacity settings from this element. Required in some cases for IE.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-clearPositioning' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-clearPositioning' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-clearPositioning' class='name expandable'>clearPositioning</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Clear positioning back to the default when the document was loaded ...</div><div class='long'><p>Clear positioning back to the default when the document was loaded</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The value to use for the left,right,top,bottom, defaults to '' (empty string). You could use 'auto'.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-clip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-clip' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-clip' class='name expandable'>clip</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Store the current overflow setting and clip overflow on the element - use unclip to remove ...</div><div class='long'><p>Store the current overflow setting and clip overflow on the element - use <tt><a href=\"#!/api/Ext.Element-method-unclip\" rel=\"Ext.Element-method-unclip\" class=\"docClass\">unclip</a></tt> to remove</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-contains' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-contains' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-contains' class='name expandable'>contains</a>( <span class='pre'>HTMLElement/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> el</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if this element is an ancestor of the passed element ...</div><div class='long'><p>Returns true if this element is an ancestor of the passed element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : HTMLElement/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The element to check</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if this element is an ancestor of el, else false</p>\n</div></li></ul></div></div></div><div id='method-createChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-createChild' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-createChild' class='name expandable'>createChild</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, [HTMLElement insertBefore], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Creates the passed DomHelper config and appends it to this element or optionally inserts it before the passed child e...</div><div class='long'><p>Creates the passed DomHelper config and appends it to this element or optionally inserts it before the passed child element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>DomHelper element config object.  If no tag is specified (e.g., {tag:'input'}) then a div will be\nautomatically generated with the specified attributes.</p>\n</div></li><li><span class='pre'>insertBefore</span> : HTMLElement (optional)<div class='sub-desc'><p>a child element of this element</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to return the dom node instead of creating an Element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new child element</p>\n</div></li></ul></div></div></div><div id='method-createProxy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element-more.html#Ext-Element-method-createProxy' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-createProxy' class='name expandable'>createProxy</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement renderTo], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> matchBox]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Creates a proxy element of this element ...</div><div class='long'><p>Creates a proxy element of this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The class name of the proxy element or a DomHelper config object</p>\n</div></li><li><span class='pre'>renderTo</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement (optional)<div class='sub-desc'><p>The element or element id to render the proxy to (defaults to document.body)</p>\n</div></li><li><span class='pre'>matchBox</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to align and size the proxy to this element now.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new proxy element</p>\n</div></li></ul></div></div></div><div id='method-createShim' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx-more.html#Ext-Element-method-createShim' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-createShim' class='name expandable'>createShim</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Creates an iframe shim for this element to keep selects and other windowed objects from\nshowing through. ...</div><div class='long'><p>Creates an iframe shim for this element to keep selects and other windowed objects from\nshowing through.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new shim element</p>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-destroy' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes this element's dom reference. ...</div><div class='long'><p>Removes this element's dom reference. Note that event and cache removal is handled at <a href=\"#!/api/Ext-method-removeNode\" rel=\"Ext-method-removeNode\" class=\"docClass\">Ext.removeNode</a>. Alias to <a href=\"#!/api/Ext.Element-method-remove\" rel=\"Ext.Element-method-remove\" class=\"docClass\">remove</a>.</p>\n</div></div></div><div id='method-down' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-down' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-down' class='name expandable'>down</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Selects a single child at any depth below this element based on the passed CSS selector (the selector should not cont...</div><div class='long'><p>Selects a single child at any depth below this element based on the passed CSS selector (the selector should not contain an id).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS selector</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return the DOM node instead of <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The child <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (or DOM node if returnDom = true)</p>\n</div></li></ul></div></div></div><div id='method-enableDisplayMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx-more.html#Ext-Element-method-enableDisplayMode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-enableDisplayMode' class='name expandable'>enableDisplayMode</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> display]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Convenience method for setVisibilityMode(Element.DISPLAY) ...</div><div class='long'><p>Convenience method for setVisibilityMode(Element.DISPLAY)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>display</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>What to set display to when visible</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-fadeIn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-fadeIn' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-fadeIn' class='name expandable'>fadeIn</a>( <span class='pre'>[<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Fade an element in (from transparent to opaque). ...</div><div class='long'><p>Fade an element in (from transparent to opaque). The ending opacity can be specified using the <code>opacity</code>\nconfig option. Usage:</p>\n\n<pre><code>// default: fade in from opacity 0 to 100%\nel.fadeIn();\n\n// custom: fade in from opacity 0 to 75% over 2 seconds\nel.fadeIn({ opacity: .75, duration: 2000});\n\n// common config options shown with default values\nel.fadeIn({\n    opacity: 1, //can be any value between 0 and 1 (e.g. .5)\n    easing: 'easeOut',\n    duration: 500\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-fadeOut' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-fadeOut' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-fadeOut' class='name expandable'>fadeOut</a>( <span class='pre'>[<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Fade an element out (from opaque to transparent). ...</div><div class='long'><p>Fade an element out (from opaque to transparent). The ending opacity can be specified using the <code>opacity</code>\nconfig option. Note that IE may require <code>useDisplay:true</code> in order to redisplay correctly.\nUsage:</p>\n\n<pre><code>// default: fade out from the element's current opacity to 0\nel.fadeOut();\n\n// custom: fade out from the element's current opacity to 25% over 2 seconds\nel.fadeOut({ opacity: .25, duration: 2000});\n\n// common config options shown with default values\nel.fadeOut({\n    opacity: 0, //can be any value between 0 and 1 (e.g. .5)\n    easing: 'easeOut',\n    duration: 500,\n    remove: false,\n    useDisplay: false\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-findParent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-findParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-findParent' class='name expandable'>findParent</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> maxDepth], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnEl]</span> ) : HTMLElement</div><div class='description'><div class='short'>Looks at this node and then at parent nodes for a match of the passed simple selector (e.g. ...</div><div class='long'><p>Looks at this node and then at parent nodes for a match of the passed simple selector (e.g. div.some-class or span:first-child)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The simple selector to test</p>\n</div></li><li><span class='pre'>maxDepth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (optional)<div class='sub-desc'><p>The max depth to search as a number or element (defaults to 50 || document.body)</p>\n</div></li><li><span class='pre'>returnEl</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> object instead of DOM node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>The matching DOM node (or null if no match was found)</p>\n</div></li></ul></div></div></div><div id='method-findParentNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-findParentNode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-findParentNode' class='name expandable'>findParentNode</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> maxDepth], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnEl]</span> ) : HTMLElement</div><div class='description'><div class='short'>Looks at parent nodes for a match of the passed simple selector (e.g. ...</div><div class='long'><p>Looks at parent nodes for a match of the passed simple selector (e.g. div.some-class or span:first-child)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The simple selector to test</p>\n</div></li><li><span class='pre'>maxDepth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (optional)<div class='sub-desc'><p>The max depth to search as a number or element (defaults to 10 || document.body)</p>\n</div></li><li><span class='pre'>returnEl</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> object instead of DOM node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>The matching DOM node (or null if no match was found)</p>\n</div></li></ul></div></div></div><div id='method-first' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-first' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-first' class='name expandable'>first</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the first child, skipping text nodes ...</div><div class='long'><p>Gets the first child, skipping text nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find the next sibling that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The first child or null</p>\n</div></li></ul></div></div></div><div id='method-focus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-focus' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-focus' class='name expandable'>focus</a>( <span class='pre'>[<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> defer]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Tries to focus the element. ...</div><div class='long'><p>Tries to focus the element. Any exceptions are caught and ignored.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>defer</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Milliseconds to defer the focus</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-focusable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element-more.html#Ext-Element-method-focusable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-focusable' class='name expandable'>focusable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks whether this element can be focused. ...</div><div class='long'><p>Checks whether this element can be focused.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the element is focusable</p>\n</div></li></ul></div></div></div><div id='method-frame' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-frame' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-frame' class='name expandable'>frame</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> color], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> count], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Shows a ripple of exploding, attenuating borders to draw attention to an Element. ...</div><div class='long'><p>Shows a ripple of exploding, attenuating borders to draw attention to an Element. Usage:</p>\n\n<pre><code>// default: a single light blue ripple\nel.frame();\n\n// custom: 3 red ripples lasting 3 seconds total\nel.frame(\"#ff0000\", 3, { duration: 3 });\n\n// common config options shown with default values\nel.frame(\"#C3DAF9\", 1, {\n    duration: 1 //duration of each individual ripple.\n    // Note: Easing is not configurable and will be ignored if included\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>color</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The color of the border. Should be a 6 char hex color without the leading #\n(defaults to light blue).</p>\n<p>Defaults to: <code>&quot;C3DAF9&quot;</code></p></div></li><li><span class='pre'>count</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The number of ripples to display</p>\n<p>Defaults to: <code>1</code></p></div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-getActiveElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static-more.html#Ext-Element-method-getActiveElement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getActiveElement' class='name expandable'>getActiveElement</a>( <span class='pre'></span> ) : HTMLElement</div><div class='description'><div class='short'>Returns the active element in the DOM. ...</div><div class='long'><p>Returns the active element in the DOM. If the browser supports activeElement\non the document, this is returned. If not, the focus is tracked and the active\nelement is maintained internally.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>The active (focused) element in the document.</p>\n</div></li></ul></div></div></div><div id='method-getAlignToXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.alignment.html#Ext-Element-method-getAlignToXY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getAlignToXY' class='name expandable'>getAlignToXY</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> element, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> position], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] offsets]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</div><div class='description'><div class='short'>Gets the x,y coordinates to align this element with another element. ...</div><div class='long'><p>Gets the x,y coordinates to align this element with another element. See <a href=\"#!/api/Ext.Element-method-alignTo\" rel=\"Ext.Element-method-alignTo\" class=\"docClass\">alignTo</a> for more info on the\nsupported position values.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The element to align to.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The position to align to (defaults to )</p>\n<p>Defaults to: <code>&quot;tl-bl?&quot;</code></p></div></li><li><span class='pre'>offsets</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] (optional)<div class='sub-desc'><p>Offset the positioning by [x, y]</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span><div class='sub-desc'><p>[x, y]</p>\n</div></li></ul></div></div></div><div id='method-getAnchorXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.alignment.html#Ext-Element-method-getAnchorXY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getAnchorXY' class='name expandable'>getAnchorXY</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> anchor], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> local], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> size]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</div><div class='description'><div class='short'>Gets the x,y coordinates specified by the anchor position on the element. ...</div><div class='long'><p>Gets the x,y coordinates specified by the anchor position on the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>anchor</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The specified anchor position.  See <a href=\"#!/api/Ext.Element-method-alignTo\" rel=\"Ext.Element-method-alignTo\" class=\"docClass\">alignTo</a>\nfor details on supported anchor positions.</p>\n<p>Defaults to: <code>&quot;c&quot;</code></p></div></li><li><span class='pre'>local</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to get the local (element top/left-relative) anchor position instead\nof page coordinates</p>\n</div></li><li><span class='pre'>size</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>An object containing the size to use for calculating anchor position\n{width: (target width), height: (target height)} (defaults to the element's current size)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span><div class='sub-desc'><p>[x, y] An array containing the element's x and y coordinates</p>\n</div></li></ul></div></div></div><div id='method-getAttribute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-getAttribute' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getAttribute' class='name expandable'>getAttribute</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> namespace]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the value of an attribute from the element's underlying DOM node. ...</div><div class='long'><p>Returns the value of an attribute from the element's underlying DOM node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The attribute name</p>\n</div></li><li><span class='pre'>namespace</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The namespace in which to look for the attribute</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The attribute value</p>\n</div></li></ul></div></div></div><div id='method-getAttributeNS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-getAttributeNS' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getAttributeNS' class='name expandable'>getAttributeNS</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> namespace, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the value of a namespaced attribute from the element's underlying DOM node. ...</div><div class='long'><p>Returns the value of a namespaced attribute from the element's underlying DOM node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>namespace</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The namespace in which to look for the attribute</p>\n</div></li><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The attribute name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The attribute value</p>\n</div></li></ul></div></div></div><div id='method-getBorderWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getBorderWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getBorderWidth' class='name expandable'>getBorderWidth</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> side</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the width of the border(s) for the specified side(s) ...</div><div class='long'><p>Gets the width of the border(s) for the specified side(s)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>side</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Can be t, l, r, b or any combination of those to add multiple values. For example,\npassing <tt>'lr'</tt> would get the border <b><u>l</u></b>eft width + the border <b><u>r</u></b>ight width.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The width of the sides passed added together</p>\n</div></li></ul></div></div></div><div id='method-getBottom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getBottom' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getBottom' class='name expandable'>getBottom</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> local</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the bottom Y coordinate of the element (element Y position + element height) ...</div><div class='long'><p>Gets the bottom Y coordinate of the element (element Y position + element height)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to get the local css position instead of page coordinate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getBox' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getBox' class='name expandable'>getBox</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> contentBox], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> local]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Return an object defining the area of this Element which can be passed to setBox to\nset another Element's size/locati...</div><div class='long'><p>Return an object defining the area of this Element which can be passed to <a href=\"#!/api/Ext.Element-method-setBox\" rel=\"Ext.Element-method-setBox\" class=\"docClass\">setBox</a> to\nset another Element's size/location to match this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contentBox</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>If true a box for the content of the element is returned.</p>\n</div></li><li><span class='pre'>local</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page x/y.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>box An object in the format</p>\n\n<pre><code>{\n    x: &lt;Element's X position>,\n    y: &lt;Element's Y position>,\n    width: &lt;Element's width>,\n    height: &lt;Element's height>,\n    bottom: &lt;Element's lower bound>,\n    right: &lt;Element's rightmost bound>\n}\n</code></pre>\n\n\n<p>The returned object may also be addressed as an Array where index 0 contains the X position\nand index 1 contains the Y position. So the result may also be used for <a href=\"#!/api/Ext.Element-method-setXY\" rel=\"Ext.Element-method-setXY\" class=\"docClass\">setXY</a></p>\n</div></li></ul></div></div></div><div id='method-getById' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-getById' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getById' class='name expandable'>getById</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Retrieves Ext.Element objects like Ext.get but is optimized for sub-elements. ...</div><div class='long'><p>Retrieves <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> objects like <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a> but is optimized for sub-elements.\nThis is helpful for performance, because in IE (prior to IE 9), <code>getElementById</code> uses\nan non-optimized search. In those browsers, starting the search for an element with a\nmatching ID at a parent of that element will greatly speed up the process.</p>\n\n<p>Unlike <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>, this method only accepts ID's. If the ID is not a child of\nthis element, it will still be found if it exists in the document, but will be slower\nthan calling <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a> directly.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the element to get.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element object (or null if no matching element was found)</p>\n</div></li></ul></div></div></div><div id='method-getCenterXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.alignment.html#Ext-Element-method-getCenterXY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getCenterXY' class='name expandable'>getCenterXY</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</div><div class='description'><div class='short'>Calculates the x, y to center this element on the screen ...</div><div class='long'><p>Calculates the x, y to center this element on the screen</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span><div class='sub-desc'><p>The x, y values [x, y]</p>\n</div></li></ul></div></div></div><div id='method-getColor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getColor' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getColor' class='name expandable'>getColor</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> attr, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> defaultValue, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> prefix]</span> )</div><div class='description'><div class='short'>Return the CSS color for the specified CSS attribute. ...</div><div class='long'><p>Return the CSS color for the specified CSS attribute. rgb, 3 digit (like #fff) and valid values\nare convert to standard 6 digit hex color.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attr</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The css attribute</p>\n</div></li><li><span class='pre'>defaultValue</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The default value to use when a valid color isn't found</p>\n</div></li><li><span class='pre'>prefix</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>defaults to #. Use an empty string when working with\ncolor anims.</p>\n</div></li></ul></div></div></div><div id='method-getComputedHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getComputedHeight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getComputedHeight' class='name expandable'>getComputedHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns either the offsetHeight or the height of this element based on CSS height adjusted by padding or borders\nwhen...</div><div class='long'><p>Returns either the offsetHeight or the height of this element based on CSS height adjusted by padding or borders\nwhen needed to simulate offsetHeight when offsets aren't available. This may not work on display:none elements\nif a height has not been set using CSS.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getComputedWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getComputedWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getComputedWidth' class='name expandable'>getComputedWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns either the offsetWidth or the width of this element based on CSS width adjusted by padding or borders\nwhen ne...</div><div class='long'><p>Returns either the offsetWidth or the width of this element based on CSS width adjusted by padding or borders\nwhen needed to simulate offsetWidth when offsets aren't available. This may not work on display:none elements\nif a width has not been set using CSS.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getConstrainVector' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.alignment.html#Ext-Element-method-getConstrainVector' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getConstrainVector' class='name expandable'>getConstrainVector</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> constrainTo, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> proposedPosition</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]/<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns the [X, Y] vector by which this element must be translated to make a best attempt\nto constrain within the pas...</div><div class='long'><p>Returns the <code>[X, Y]</code> vector by which this element must be translated to make a best attempt\nto constrain within the passed constraint. Returns <code>false</code> is this element does not need to be moved.</p>\n\n\n<p>Priority is given to constraining the top and left within the constraint.</p>\n\n\n<p>The constraint may either be an existing element into which this element is to be constrained, or\nan <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Region</a> into which this element is to be constrained.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>constrainTo</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>{Mixed} The Element or <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Region</a> into which this element is to be constrained.</p>\n</div></li><li><span class='pre'>proposedPosition</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>{Array} A proposed <code>[X, Y]</code> position to test for validity and to produce a vector for instead\nof using this Element's current position;</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]/<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p><b>If</b> this element <i>needs</i> to be translated, an <code>[X, Y]</code>\nvector by which this element must be translated. Otherwise, <code>false</code>.</p>\n</div></li></ul></div></div></div><div id='method-getFrameWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getFrameWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getFrameWidth' class='name expandable'>getFrameWidth</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sides</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the sum width of the padding and borders for the passed \"sides\". ...</div><div class='long'><p>Returns the sum width of the padding and borders for the passed \"sides\". See getBorderWidth()</p>\n\n<pre><code>     for more information about the sides.\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sides</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getHeight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getHeight' class='name expandable'>getHeight</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> contentHeight]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the offset height of the element ...</div><div class='long'><p>Returns the offset height of the element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contentHeight</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to get the height minus borders and padding</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The element's height</p>\n</div></li></ul></div></div></div><div id='method-getLeft' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getLeft' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getLeft' class='name expandable'>getLeft</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> local</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the left X coordinate ...</div><div class='long'><p>Gets the left X coordinate</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to get the local css position instead of page coordinate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLoader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element-more.html#Ext-Element-method-getLoader' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getLoader' class='name expandable'>getLoader</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.ElementLoader\" rel=\"Ext.ElementLoader\" class=\"docClass\">Ext.ElementLoader</a></div><div class='description'><div class='short'>Gets this element's ElementLoader ...</div><div class='long'><p>Gets this element's <a href=\"#!/api/Ext.ElementLoader\" rel=\"Ext.ElementLoader\" class=\"docClass\">ElementLoader</a></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.ElementLoader\" rel=\"Ext.ElementLoader\" class=\"docClass\">Ext.ElementLoader</a></span><div class='sub-desc'><p>The loader</p>\n</div></li></ul></div></div></div><div id='method-getMargin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getMargin' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getMargin' class='name expandable'>getMargin</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sides]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns an object with properties top, left, right and bottom representing the margins of this element unless sides i...</div><div class='long'><p>Returns an object with properties top, left, right and bottom representing the margins of this element unless sides is passed,\nthen it returns the calculated width of the sides (see getPadding)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sides</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Any combination of l, r, t, b to get the sum of those sides</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getOffsetsTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getOffsetsTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getOffsetsTo' class='name expandable'>getOffsetsTo</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> element</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</div><div class='description'><div class='short'>Returns the offsets of this element from the passed element. ...</div><div class='long'><p>Returns the offsets of this element from the passed element. Both element must be part of the DOM tree and not have display:none to have page coordinates.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The element to get the offsets from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span><div class='sub-desc'><p>The XY page offsets (e.g. [100, -200])</p>\n</div></li></ul></div></div></div><div id='method-getPadding' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getPadding' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getPadding' class='name expandable'>getPadding</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> side</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the width of the padding(s) for the specified side(s) ...</div><div class='long'><p>Gets the width of the padding(s) for the specified side(s)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>side</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Can be t, l, r, b or any combination of those to add multiple values. For example,\npassing <tt>'lr'</tt> would get the padding <b><u>l</u></b>eft + the padding <b><u>r</u></b>ight.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The padding of the sides passed added together</p>\n</div></li></ul></div></div></div><div id='method-getPageBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getPageBox' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getPageBox' class='name expandable'>getPageBox</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> asRegion]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Return an object defining the area of this Element which can be passed to setBox to\nset another Element's size/locati...</div><div class='long'><p>Return an object defining the area of this Element which can be passed to <a href=\"#!/api/Ext.Element-method-setBox\" rel=\"Ext.Element-method-setBox\" class=\"docClass\">setBox</a> to\nset another Element's size/location to match this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>asRegion</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>If true an <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a> will be returned</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>box An object in the format</p>\n\n<pre><code>{\n    x: &lt;Element's X position>,\n    y: &lt;Element's Y position>,\n    width: &lt;Element's width>,\n    height: &lt;Element's height>,\n    bottom: &lt;Element's lower bound>,\n    right: &lt;Element's rightmost bound>\n}\n</code></pre>\n\n\n<p>The returned object may also be addressed as an Array where index 0 contains the X position\nand index 1 contains the Y position. So the result may also be used for <a href=\"#!/api/Ext.Element-method-setXY\" rel=\"Ext.Element-method-setXY\" class=\"docClass\">setXY</a></p>\n</div></li></ul></div></div></div><div id='method-getPositioning' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getPositioning' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getPositioning' class='name expandable'>getPositioning</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Gets an object with all CSS positioning properties. ...</div><div class='long'><p>Gets an object with all CSS positioning properties. Useful along with setPostioning to get\nsnapshot before performing an update and then restoring the element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRegion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getRegion' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getRegion' class='name expandable'>getRegion</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a></div><div class='description'><div class='short'>Returns the region of this element. ...</div><div class='long'><p>Returns the region of this element.\nThe element must be part of the DOM tree to have a region (display:none or elements not appended return false).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a></span><div class='sub-desc'><p>A Region containing \"top, left, bottom, right\" member data.</p>\n</div></li></ul></div></div></div><div id='method-getRight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getRight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getRight' class='name expandable'>getRight</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> local</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the right X coordinate of the element (element X position + element width) ...</div><div class='long'><p>Gets the right X coordinate of the element (element X position + element width)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to get the local css position instead of page coordinate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getScopeParent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element-more.html#Ext-Element-method-getScopeParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getScopeParent' class='name expandable'>getScopeParent</a>( <span class='pre'></span> ) : HTMLElement<strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Gets the parent node of the current element taking into account Ext.scopeResetCSS ...</div><div class='long'><p>Gets the parent node of the current element taking into account Ext.scopeResetCSS</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>The parent element</p>\n</div></li></ul></div></div></div><div id='method-getScroll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.scroll.html#Ext-Element-method-getScroll' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getScroll' class='name expandable'>getScroll</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the current scroll position of the element. ...</div><div class='long'><p>Returns the current scroll position of the element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>An object containing the scroll position in the format {left: (scrollLeft), top: (scrollTop)}</p>\n</div></li></ul></div></div></div><div id='method-getSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getSize' class='name expandable'>getSize</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> contentSize]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the size of the element. ...</div><div class='long'><p>Returns the size of the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contentSize</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to get the width/size minus borders and padding</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>An object containing the element's size {width: (element width), height: (element height)}</p>\n</div></li></ul></div></div></div><div id='method-getStyle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getStyle' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getStyle' class='name expandable'>getStyle</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> property</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Normalizes currentStyle and computedStyle. ...</div><div class='long'><p>Normalizes currentStyle and computedStyle.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>property</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The style property whose value is returned.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The current value of the style property for this element.</p>\n</div></li></ul></div></div></div><div id='method-getStyleSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getStyleSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getStyleSize' class='name expandable'>getStyleSize</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns the dimensions of the element available to lay content out in. ...</div><div class='long'><p>Returns the dimensions of the element available to lay content out in.<p>\n\ngetStyleSize utilizes prefers style sizing if present, otherwise it chooses the larger of offsetHeight/clientHeight and offsetWidth/clientWidth.\nTo obtain the size excluding scrollbars, use getViewSize\n\nSizing of the document body is handled at the adapter level which handles special cases for IE and strict modes, etc.\n\n</div></div></div><div id='method-getStyles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getStyles' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getStyles' class='name expandable'>getStyles</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> style1, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> style2, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> etc</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns an object with properties matching the styles requested. ...</div><div class='long'><p>Returns an object with properties matching the styles requested.\nFor example, el.getStyles('color', 'font-size', 'width') might return\n{'color': '#FFFFFF', 'font-size': '13px', 'width': '100px'}.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>style1</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>A style name</p>\n</div></li><li><span class='pre'>style2</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>A style name</p>\n</div></li><li><span class='pre'>etc</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The style object</p>\n</div></li></ul></div></div></div><div id='method-getTextWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/TextMetrics.html#Ext-Element-method-getTextWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getTextWidth' class='name expandable'>getTextWidth</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> text, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> min], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> max]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the width in pixels of the passed text, or the width of the text in this Element. ...</div><div class='long'><p>Returns the width in pixels of the passed text, or the width of the text in this Element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>text</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The text to measure. Defaults to the innerHTML of the element.</p>\n</div></li><li><span class='pre'>min</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The minumum value to return.</p>\n</div></li><li><span class='pre'>max</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The maximum value to return.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The text width in pixels.</p>\n</div></li></ul></div></div></div><div id='method-getTop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getTop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getTop' class='name expandable'>getTop</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> local</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the top Y coordinate ...</div><div class='long'><p>Gets the top Y coordinate</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to get the local css position instead of page coordinate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-getValue' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getValue' class='name expandable'>getValue</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> asNumber</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the value of the \"value\" attribute ...</div><div class='long'><p>Returns the value of the \"value\" attribute</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>asNumber</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>true to parse the value as a number</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getViewRegion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getViewRegion' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getViewRegion' class='name expandable'>getViewRegion</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a></div><div class='description'><div class='short'>Returns the content region of this element. ...</div><div class='long'><p>Returns the <b>content</b> region of this element. That is the region within the borders and padding.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a></span><div class='sub-desc'><p>A Region containing \"top, left, bottom, right\" member data.</p>\n</div></li></ul></div></div></div><div id='method-getViewSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getViewSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getViewSize' class='name expandable'>getViewSize</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns the dimensions of the element available to lay content out in. ...</div><div class='long'><p>Returns the dimensions of the element available to lay content out in.<p>\n<p>If the element (or any ancestor element) has CSS style <code>display : none</code>, the dimensions will be zero.</p>\nexample:\n<pre><code>        var vpSize = Ext.getBody().getViewSize();\n\n        // all Windows created afterwards will have a default value of 90% height and 95% width\n        Ext.Window.override({\n            width: vpSize.width * 0.9,\n            height: vpSize.height * 0.95\n        });\n        // To handle window resizing you would have to hook onto onWindowResize.\n</code></pre>\n\ngetViewSize utilizes clientHeight/clientWidth which excludes sizing of scrollbars.\nTo obtain the size including scrollbars, use getStyleSize\n\nSizing of the document body is handled at the adapter level which handles special cases for IE and strict modes, etc.\n\n</div></div></div><div id='method-getWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-getWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getWidth' class='name expandable'>getWidth</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> contentWidth]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the offset width of the element ...</div><div class='long'><p>Returns the offset width of the element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contentWidth</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to get the width minus borders and padding</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The element's width</p>\n</div></li></ul></div></div></div><div id='method-getX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getX' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getX' class='name expandable'>getX</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current X position of the element based on page coordinates. ...</div><div class='long'><p>Gets the current X position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The X position of the element</p>\n</div></li></ul></div></div></div><div id='method-getXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getXY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getXY' class='name expandable'>getXY</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</div><div class='description'><div class='short'>Gets the current position of the element based on page coordinates. ...</div><div class='long'><p>Gets the current position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span><div class='sub-desc'><p>The XY position of the element</p>\n</div></li></ul></div></div></div><div id='method-getY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-getY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-getY' class='name expandable'>getY</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current Y position of the element based on page coordinates. ...</div><div class='long'><p>Gets the current Y position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The Y position of the element</p>\n</div></li></ul></div></div></div><div id='method-ghost' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-ghost' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-ghost' class='name expandable'>ghost</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> anchor], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Slides the element while fading it out of view. ...</div><div class='long'><p>Slides the element while fading it out of view. An anchor point can be optionally passed to set the ending point\nof the effect. Usage:</p>\n\n<pre><code>// default: slide the element downward while fading out\nel.ghost();\n\n// custom: slide the element out to the right with a 2-second duration\nel.ghost('r', { duration: 2000 });\n\n// common config options shown with default values\nel.ghost('b', {\n    easing: 'easeOut',\n    duration: 500\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>anchor</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>One of the valid Fx anchor positions</p>\n<p>Defaults to: <code>&quot;b&quot;</code></p></div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-hasCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-hasCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-hasCls' class='name expandable'>hasCls</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> className</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks if the specified CSS class exists on this element's DOM node. ...</div><div class='long'><p>Checks if the specified CSS class exists on this element's DOM node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS class to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the class exists, else false</p>\n</div></li></ul></div></div></div><div id='method-hide' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-method-hide' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-hide' class='name expandable'>hide</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Hide this element - Uses display mode to determine whether to use \"display\" or \"visibility\". ...</div><div class='long'><p>Hide this element - Uses display mode to determine whether to use \"display\" or \"visibility\". See <a href=\"#!/api/Ext.Element-method-setVisible\" rel=\"Ext.Element-method-setVisible\" class=\"docClass\">setVisible</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-highlight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-highlight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-highlight' class='name expandable'>highlight</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> color], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Highlights the Element by setting a color (applies to the background-color by default, but can be changed using\nthe \"...</div><div class='long'><p>Highlights the Element by setting a color (applies to the background-color by default, but can be changed using\nthe \"attr\" config option) and then fading back to the original color. If no original color is available, you\nshould provide the \"endColor\" config option which will be cleared after the animation. Usage:</p>\n\n<pre><code>// default: highlight background to yellow\nel.highlight();\n\n// custom: highlight foreground text to blue for 2 seconds\nel.highlight(\"0000ff\", { attr: 'color', duration: 2000 });\n\n// common config options shown with default values\nel.highlight(\"ffff9c\", {\n    attr: \"backgroundColor\", //can be any valid CSS property (attribute) that supports a color value\n    endColor: (current color) or \"ffffff\",\n    easing: 'easeIn',\n    duration: 1000\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>color</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The highlight color. Should be a 6 char hex color without the leading #</p>\n<p>Defaults to: <code>&quot;ffff9c&quot;</code></p></div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-hover' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-hover' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-hover' class='name expandable'>hover</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> overFn, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> outFn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets up event handlers to call the passed functions when the mouse is moved into and out of the Element. ...</div><div class='long'><p>Sets up event handlers to call the passed functions when the mouse is moved into and out of the Element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>overFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call when the mouse enters the Element.</p>\n</div></li><li><span class='pre'>outFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call when the mouse leaves the Element.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the functions are executed. Defaults\nto the Element's DOM element.</p>\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Options for the listener. See <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">the\noptions parameter</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-initDD' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.dd.html#Ext-Element-method-initDD' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-initDD' class='name expandable'>initDD</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> group, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> overrides</span> ) : <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a></div><div class='description'><div class='short'>Initializes a Ext.dd.DD drag drop object for this element. ...</div><div class='long'><p>Initializes a <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a> drag drop object for this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group the DD object is member of</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The DD config object</p>\n</div></li><li><span class='pre'>overrides</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>An object containing methods to override/implement on the DD object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a></span><div class='sub-desc'><p>The DD object</p>\n</div></li></ul></div></div></div><div id='method-initDDProxy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.dd.html#Ext-Element-method-initDDProxy' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-initDDProxy' class='name expandable'>initDDProxy</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> group, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> overrides</span> ) : <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></div><div class='description'><div class='short'>Initializes a Ext.dd.DDProxy object for this element. ...</div><div class='long'><p>Initializes a <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a> object for this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group the DDProxy object is member of</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The DDProxy config object</p>\n</div></li><li><span class='pre'>overrides</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>An object containing methods to override/implement on the DDProxy object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></span><div class='sub-desc'><p>The DDProxy object</p>\n</div></li></ul></div></div></div><div id='method-initDDTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.dd.html#Ext-Element-method-initDDTarget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-initDDTarget' class='name expandable'>initDDTarget</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> group, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> overrides</span> ) : <a href=\"#!/api/Ext.dd.DDTarget\" rel=\"Ext.dd.DDTarget\" class=\"docClass\">Ext.dd.DDTarget</a></div><div class='description'><div class='short'>Initializes a Ext.dd.DDTarget object for this element. ...</div><div class='long'><p>Initializes a <a href=\"#!/api/Ext.dd.DDTarget\" rel=\"Ext.dd.DDTarget\" class=\"docClass\">Ext.dd.DDTarget</a> object for this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group the DDTarget object is member of</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The DDTarget config object</p>\n</div></li><li><span class='pre'>overrides</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>An object containing methods to override/implement on the DDTarget object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DDTarget\" rel=\"Ext.dd.DDTarget\" class=\"docClass\">Ext.dd.DDTarget</a></span><div class='sub-desc'><p>The DDTarget object</p>\n</div></li></ul></div></div></div><div id='method-insertAfter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-insertAfter' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-insertAfter' class='name expandable'>insertAfter</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Inserts this element after the passed element in the DOM ...</div><div class='long'><p>Inserts this element after the passed element in the DOM</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The element to insert after.\nThe id of the node, a DOM Node or an existing Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-insertBefore' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-insertBefore' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-insertBefore' class='name expandable'>insertBefore</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Inserts this element before the passed element in the DOM ...</div><div class='long'><p>Inserts this element before the passed element in the DOM</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The element before which this element will be inserted.\nThe id of the node, a DOM Node or an existing Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-insertFirst' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-insertFirst' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-insertFirst' class='name expandable'>insertFirst</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Inserts (or creates) an element (or DomHelper config) as the first child of this element ...</div><div class='long'><p>Inserts (or creates) an element (or DomHelper config) as the first child of this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The id or element to insert or a DomHelper config\nto create and insert</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new child</p>\n</div></li></ul></div></div></div><div id='method-insertHtml' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-insertHtml' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-insertHtml' class='name expandable'>insertHtml</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> where, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> html, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnEl]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Inserts an html fragment into this element ...</div><div class='long'><p>Inserts an html fragment into this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>where</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Where to insert the html in relation to this element - beforeBegin, afterBegin, beforeEnd, afterEnd.\nSee <a href=\"#!/api/Ext.DomHelper-method-insertHtml\" rel=\"Ext.DomHelper-method-insertHtml\" class=\"docClass\">Ext.DomHelper.insertHtml</a> for details.</p>\n</div></li><li><span class='pre'>html</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The HTML fragment</p>\n</div></li><li><span class='pre'>returnEl</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The inserted node (or nearest related if more than 1 inserted)</p>\n</div></li></ul></div></div></div><div id='method-insertSibling' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-insertSibling' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-insertSibling' class='name expandable'>insertSibling</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> el, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> where], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Inserts (or creates) the passed element (or DomHelper config) as a sibling of this element ...</div><div class='long'><p>Inserts (or creates) the passed element (or DomHelper config) as a sibling of this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The id, element to insert or a DomHelper config\nto create and insert <em>or</em> an array of any of those.</p>\n</div></li><li><span class='pre'>where</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>'before' or 'after' defaults to before</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return the .;ll;l,raw DOM element instead of <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The inserted Element. If an array is passed, the last inserted element is returned.</p>\n</div></li></ul></div></div></div><div id='method-is' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-is' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-is' class='name expandable'>is</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if this element matches the passed simple selector (e.g. ...</div><div class='long'><p>Returns true if this element matches the passed simple selector (e.g. div.some-class or span:first-child)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The simple selector to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if this element matches the selector, else false</p>\n</div></li></ul></div></div></div><div id='method-isBorderBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-isBorderBox' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-isBorderBox' class='name expandable'>isBorderBox</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Tests various css rules/browsers to determine if this element uses a border box ...</div><div class='long'><p>Tests various css rules/browsers to determine if this element uses a border box</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isDisplayed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx-more.html#Ext-Element-method-isDisplayed' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-isDisplayed' class='name expandable'>isDisplayed</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if display is not \"none\" ...</div><div class='long'><p>Returns true if display is not \"none\"</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isMasked' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx-more.html#Ext-Element-method-isMasked' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-isMasked' class='name expandable'>isMasked</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if this element is masked. ...</div><div class='long'><p>Returns true if this element is masked. Also re-centers any displayed message within the mask.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isScrollable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.scroll.html#Ext-Element-method-isScrollable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-isScrollable' class='name expandable'>isScrollable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if this element is scrollable. ...</div><div class='long'><p>Returns true if this element is scrollable.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isVisible' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-method-isVisible' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-isVisible' class='name expandable'>isVisible</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks whether the element is currently visible using both visibility and display properties. ...</div><div class='long'><p>Checks whether the element is currently visible using both visibility and display properties.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the element is currently visible, else false</p>\n</div></li></ul></div></div></div><div id='method-last' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-last' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-last' class='name expandable'>last</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the last child, skipping text nodes ...</div><div class='long'><p>Gets the last child, skipping text nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find the previous sibling that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The last child or null</p>\n</div></li></ul></div></div></div><div id='method-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element-more.html#Ext-Element-method-load' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-load' class='name expandable'>load</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Direct access to the Ext.ElementLoader Ext.ElementLoader.load method. ...</div><div class='long'><p>Direct access to the <a href=\"#!/api/Ext.ElementLoader\" rel=\"Ext.ElementLoader\" class=\"docClass\">Ext.ElementLoader</a> <a href=\"#!/api/Ext.ElementLoader-event-load\" rel=\"Ext.ElementLoader-event-load\" class=\"docClass\">Ext.ElementLoader.load</a> method. The method takes the same object\nparameter as <a href=\"#!/api/Ext.ElementLoader-event-load\" rel=\"Ext.ElementLoader-event-load\" class=\"docClass\">Ext.ElementLoader.load</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-mask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx-more.html#Ext-Element-method-mask' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-mask' class='name expandable'>mask</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> msg], [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> msgCls]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Puts a mask over this element to disable user interaction. ...</div><div class='long'><p>Puts a mask over this element to disable user interaction. Requires core.css.\nThis method can only be applied to elements which accept child nodes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A message to display in the mask</p>\n</div></li><li><span class='pre'>msgCls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A css class to apply to the msg element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The mask element</p>\n</div></li></ul></div></div></div><div id='method-monitorMouseLeave' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element-more.html#Ext-Element-method-monitorMouseLeave' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-monitorMouseLeave' class='name expandable'>monitorMouseLeave</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> delay, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> handler, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Monitors this Element for the mouse leaving. ...</div><div class='long'><p>Monitors this Element for the mouse leaving. Calls the function after the specified delay only if\nthe mouse was not moved back into the Element within the delay. If the mouse <i>was</i> moved\nback in, the function is not called.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>delay</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The delay <b>in milliseconds</b> to wait for possible mouse re-entry before calling the handler function.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call if the mouse remains outside of this Element for the specified time.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function executes. Defaults to this Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The listeners object which was added to this element so that monitoring can be stopped. Example usage:</p>\n\n<pre><code>// Hide the menu if the mouse moves out for 250ms or more\nthis.mouseLeaveMonitor = this.menuEl.monitorMouseLeave(250, this.hideMenu, this);\n\n...\n// Remove mouseleave monitor on menu destroy\nthis.menuEl.un(this.mouseLeaveMonitor);\n    </code></pre>\n\n</div></li></ul></div></div></div><div id='method-move' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-move' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-move' class='name expandable'>move</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> direction, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> distance, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> )</div><div class='description'><div class='short'>Move this element relative to its current position. ...</div><div class='long'><p>Move this element relative to its current position.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>direction</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Possible values are: \"l\" (or \"left\"), \"r\" (or \"right\"), \"t\" (or \"top\", or \"up\"), \"b\" (or \"bottom\", or \"down\").</p>\n</div></li><li><span class='pre'>distance</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>How far to move the element in pixels</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul></div></div></div><div id='method-moveTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-moveTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-moveTo' class='name expandable'>moveTo</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> x, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the position of the element in page coordinates, regardless of how the element is positioned. ...</div><div class='long'><p>Sets the position of the element in page coordinates, regardless of how the element is positioned.\nThe element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>X value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Y value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-next' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-next' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-next' class='name expandable'>next</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the next sibling, skipping text nodes ...</div><div class='long'><p>Gets the next sibling, skipping text nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find the next sibling that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The next sibling or null</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-on' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-on' class='name expandable'>on</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Shorthand for addListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a>.</p>\n\n<p>Appends an event handler to this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of event to handle.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler function the event invokes. This function is passed the following parameters:</p>\n\n\n\n\n<ul>\n<li><p><strong>evt</strong> : EventObject</p>\n\n<p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">EventObject</a> describing the event.</p></li>\n<li><p><strong>el</strong> : HtmlElement</p>\n\n<p>The DOM element which was the target of the event. Note that this may be filtered by using the delegate option.</p></li>\n<li><p><strong>o</strong> : Object</p>\n\n<p>The options object from the addListener call.</p></li>\n</ul>\n\n\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<strong>this</strong> reference) in which the handler function is executed. <strong>If\nomitted, defaults to this Element.</strong></p>\n\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>An object containing handler configuration properties. This may contain any of\nthe following properties:</p>\n\n\n\n\n<ul>\n<li><p><strong>scope</strong> Object :</p>\n\n<p>The scope (<strong>this</strong> reference) in which the handler function is executed. <strong>If omitted, defaults to this\nElement.</strong></p></li>\n<li><p><strong>delegate</strong> String:</p>\n\n<p>A simple selector to filter the target or look for a descendant of the target. See below for additional details.</p></li>\n<li><p><strong>stopEvent</strong> Boolean:</p>\n\n<p>True to stop the event. That is stop propagation, and prevent the default action.</p></li>\n<li><p><strong>preventDefault</strong> Boolean:</p>\n\n<p>True to prevent the default action</p></li>\n<li><p><strong>stopPropagation</strong> Boolean:</p>\n\n<p>True to prevent event propagation</p></li>\n<li><p><strong>normalized</strong> Boolean:</p>\n\n<p>False to pass a browser event to the handler function instead of an <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a></p></li>\n<li><p><strong>target</strong> Ext.Element:</p>\n\n<p>Only call the handler if the event was fired on the target Element, <em>not</em> if the event was bubbled up from a\nchild node.</p></li>\n<li><p><strong>delay</strong> Number:</p>\n\n<p>The number of milliseconds to delay the invocation of the handler after the event fires.</p></li>\n<li><p><strong>single</strong> Boolean:</p>\n\n<p>True to add a handler to handle just the next firing of the event, and then remove itself.</p></li>\n<li><p><strong>buffer</strong> Number:</p>\n\n<p>Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed by the specified number of\nmilliseconds. If the event fires again within that time, the original handler is <em>not</em> invoked, but the new\nhandler is scheduled in its place.</p></li>\n</ul>\n\n\n\n\n<p><strong>Combining Options</strong></p>\n\n\n\n\n<p>In the following examples, the shorthand form <a href=\"#!/api/Ext.Element-method-on\" rel=\"Ext.Element-method-on\" class=\"docClass\">on</a> is used rather than the more verbose addListener. The\ntwo are equivalent. Using the options argument, it is possible to combine different types of listeners:</p>\n\n\n\n\n<p>A delayed, one-time listener that auto stops the event and adds a custom argument (forumId) to the options\nobject. The options object is available as the third parameter in the handler function.</p>\n\n\n\n\n<p>Code:</p>\n\n\n\n\n<pre><code>el.on('click', this.onClick, this, {\n    single: true,\n    delay: 100,\n    stopEvent : true,\n    forumId: 4\n});\n</code></pre>\n\n\n\n\n<p><strong>Attaching multiple handlers in 1 call</strong></p>\n\n\n\n\n<p>The method also allows for a single argument to be passed which is a config object containing properties which\nspecify multiple handlers.</p>\n\n\n\n\n<p>Code:</p>\n\n\n\n\n<pre><code>el.on({\n    'click' : {\n        fn: this.onClick,\n        scope: this,\n        delay: 100\n    },\n    'mouseover' : {\n        fn: this.onMouseOver,\n        scope: this\n    },\n    'mouseout' : {\n        fn: this.onMouseOut,\n        scope: this\n    }\n});\n</code></pre>\n\n\n\n\n<p>Or a shorthand syntax:</p>\n\n\n\n\n<p>Code:</p>\n\n\n\n\n<pre><code>el.on({\n    'click' : this.onClick,\n    'mouseover' : this.onMouseOver,\n    'mouseout' : this.onMouseOut,\n    scope: this\n});\n</code></pre>\n\n\n\n\n<p><strong>delegate</strong></p>\n\n\n\n\n<p>This is a configuration option that you can pass along when registering a handler for an event to assist with\nevent delegation. Event delegation is a technique that is used to reduce memory consumption and prevent exposure\nto memory-leaks. By registering an event for a container element as opposed to each element within a container.\nBy setting this configuration option to a simple selector, the target element will be filtered to look for a\ndescendant of the target. For example:</p>\n\n\n\n\n<pre><code>// using this markup:\n&lt;div id='elId'&gt;\n    &lt;p id='p1'&gt;paragraph one&lt;/p&gt;\n    &lt;p id='p2' class='clickable'&gt;paragraph two&lt;/p&gt;\n    &lt;p id='p3'&gt;paragraph three&lt;/p&gt;\n&lt;/div&gt;\n\n// utilize event delegation to registering just one handler on the container element:\nel = Ext.get('elId');\nel.on(\n    'click',\n    function(e,t) {\n        // handle click\n        console.info(t.id); // 'p2'\n    },\n    this,\n    {\n        // filter the target element to be a descendant with the class 'clickable'\n        delegate: '.clickable'\n    }\n);\n</code></pre>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n\n</div></li></ul></div></div></div><div id='method-parent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-parent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-parent' class='name expandable'>parent</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the parent node for this element, optionally chaining up trying to match a selector ...</div><div class='long'><p>Gets the parent node for this element, optionally chaining up trying to match a selector</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find a parent node that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The parent node or null</p>\n</div></li></ul></div></div></div><div id='method-pause' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-pause' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-pause' class='name expandable'>pause</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> seconds</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Creates a pause before any subsequent queued effects begin. ...</div><div class='long'><p>Creates a pause before any subsequent queued effects begin. If there are no effects queued after the pause it will\nhave no effect. Usage:</p>\n\n<pre><code>el.pause(1);\n</code></pre>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>seconds</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The length of time to pause (in seconds)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-position' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-position' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-position' class='name expandable'>position</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> pos], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> zIndex], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> x], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y]</span> )</div><div class='description'><div class='short'>Initializes positioning on this element. ...</div><div class='long'><p>Initializes positioning on this element. If a desired position is not passed, it will make the\nthe element positioned relative IF it is not already positioned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pos</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Positioning to use \"relative\", \"absolute\" or \"fixed\"</p>\n</div></li><li><span class='pre'>zIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The zIndex to apply</p>\n</div></li><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Set the page X position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Set the page Y position</p>\n</div></li></ul></div></div></div><div id='method-prev' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-prev' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-prev' class='name expandable'>prev</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the previous sibling, skipping text nodes ...</div><div class='long'><p>Gets the previous sibling, skipping text nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find the previous sibling that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The previous sibling or null</p>\n</div></li></ul></div></div></div><div id='method-puff' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-puff' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-puff' class='name expandable'>puff</a>( <span class='pre'>[<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Fades the element out while slowly expanding it in all directions. ...</div><div class='long'><p>Fades the element out while slowly expanding it in all directions. When the effect is completed, the element will\nbe hidden (visibility = 'hidden') but block elements will still take up space in the document. Usage:</p>\n\n<pre><code>// default\nel.puff();\n\n// common config options shown with default values\nel.puff({\n    easing: 'easeOut',\n    duration: 500,\n    useDisplay: false\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-purgeAllListeners' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-purgeAllListeners' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-purgeAllListeners' class='name expandable'>purgeAllListeners</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Recursively removes all previous added listeners from this element and its children ...</div><div class='long'><p>Recursively removes all previous added listeners from this element and its children</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-query' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-query' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-query' class='name expandable'>query</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector</span> ) : HTMLElement[]</div><div class='description'><div class='short'>Selects child nodes based on the passed CSS selector (the selector should not contain an id). ...</div><div class='long'><p>Selects child nodes based on the passed CSS selector (the selector should not contain an id).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS selector</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement[]</span><div class='sub-desc'><p>An array of the matched nodes</p>\n</div></li></ul></div></div></div><div id='method-radioCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-radioCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-radioCls' class='name expandable'>radioCls</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Adds one or more CSS classes to this element and removes the same class(es) from all siblings. ...</div><div class='long'><p>Adds one or more CSS classes to this element and removes the same class(es) from all siblings.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The CSS class to add, or an array of classes</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-relayEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element-more.html#Ext-Element-method-relayEvent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-relayEvent' class='name expandable'>relayEvent</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object</span> )</div><div class='description'><div class='short'>Create an event handler on this element such that when the event fires and is handled by this element,\nit will be rel...</div><div class='long'><p>Create an event handler on this element such that when the event fires and is handled by this element,\nit will be relayed to another object (i.e., fired again as if it originated from that object instead).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to relay</p>\n</div></li><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Any object that extends <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a> that will provide the context\nfor firing the relayed event</p>\n</div></li></ul></div></div></div><div id='method-remove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-remove' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-remove' class='name expandable'>remove</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes this element's dom reference. ...</div><div class='long'><p>Removes this element's dom reference. Note that event and cache removal is handled at <a href=\"#!/api/Ext-method-removeNode\" rel=\"Ext-method-removeNode\" class=\"docClass\">Ext.removeNode</a></p>\n</div></div></div><div id='method-removeAllListeners' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-removeAllListeners' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-removeAllListeners' class='name expandable'>removeAllListeners</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Removes all previous added listeners from this element ...</div><div class='long'><p>Removes all previous added listeners from this element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n\n</div></li></ul></div></div></div><div id='method-removeAnchor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.alignment.html#Ext-Element-method-removeAnchor' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-removeAnchor' class='name expandable'>removeAnchor</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Remove any anchor to this element. ...</div><div class='long'><p>Remove any anchor to this element. See <a href=\"#!/api/Ext.Element-method-anchorTo\" rel=\"Ext.Element-method-anchorTo\" class=\"docClass\">anchorTo</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-removeCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-removeCls' class='name expandable'>removeCls</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Removes one or more CSS classes from the element. ...</div><div class='long'><p>Removes one or more CSS classes from the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The CSS classes to remove separated by space, or an array of classes</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-removeListener' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Removes an event handler from this element. ...</div><div class='long'><p>Removes an event handler from this element.</p>\n\n<p><strong>Note</strong>: if a <em>scope</em> was explicitly specified when <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">adding</a> the listener,\nthe same scope must be specified here.</p>\n\n<p>Example:</p>\n\n<pre><code>el.removeListener('click', this.handlerFn);\n// or\nel.un('click', this.handlerFn);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event from which to remove the handler.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler function to remove. <strong>This must be a reference to the function passed into the\n<a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</strong></p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>If a scope (<strong>this</strong> reference) was specified when the listener was added, then this must\nrefer to the same object.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n\n</div></li></ul></div></div></div><div id='method-repaint' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-repaint' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-repaint' class='name expandable'>repaint</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Forces the browser to repaint this element ...</div><div class='long'><p>Forces the browser to repaint this element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-replace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-replace' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-replace' class='name expandable'>replace</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Replaces the passed element with this element ...</div><div class='long'><p>Replaces the passed element with this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The element to replace.\nThe id of the node, a DOM Node or an existing Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-replaceCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-replaceCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-replaceCls' class='name expandable'>replaceCls</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> oldClassName, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> newClassName</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Replaces a CSS class on the element with another. ...</div><div class='long'><p>Replaces a CSS class on the element with another.  If the old name does not exist, the new name will simply be added.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oldClassName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS class to replace</p>\n</div></li><li><span class='pre'>newClassName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The replacement CSS class</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-replaceWith' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-replaceWith' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-replaceWith' class='name expandable'>replaceWith</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Replaces this element with the passed element ...</div><div class='long'><p>Replaces this element with the passed element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new element (id of the node, a DOM Node\nor an existing Element) or a DomHelper config of an element to create</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-scale' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-scale' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-scale' class='name expandable'>scale</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> width, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> height, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Animates the transition of an element's dimensions from a starting height/width to an ending height/width. ...</div><div class='long'><p>Animates the transition of an element's dimensions from a starting height/width to an ending height/width. This\nmethod is a convenience implementation of <a href=\"#!/api/Ext.Element-method-shift\" rel=\"Ext.Element-method-shift\" class=\"docClass\">shift</a>. Usage:</p>\n\n<pre><code>// change height and width to 100x100 pixels\nel.scale(100, 100);\n\n// common config options shown with default values.  The height and width will default to\n// the element's existing values if passed as null.\nel.scale(\n    [element's width],\n    [element's height], {\n        easing: 'easeOut',\n        duration: .35\n    }\n);\n</code></pre>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new width (pass undefined to keep the original width)</p>\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new height (pass undefined to keep the original height)</p>\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-scroll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.scroll.html#Ext-Element-method-scroll' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-scroll' class='name expandable'>scroll</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> direction, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> distance, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Scrolls this element the specified direction. ...</div><div class='long'><p>Scrolls this element the specified direction. Does bounds checking to make sure the scroll is\nwithin this element's scrollable range.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>direction</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Possible values are: \"l\" (or \"left\"), \"r\" (or \"right\"), \"t\" (or \"top\", or \"up\"), \"b\" (or \"bottom\", or \"down\").</p>\n</div></li><li><span class='pre'>distance</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>How far to scroll the element in pixels</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>Returns true if a scroll was triggered or false if the element\nwas scrolled as far as it could go.</p>\n</div></li></ul></div></div></div><div id='method-scrollIntoView' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.scroll.html#Ext-Element-method-scrollIntoView' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-scrollIntoView' class='name expandable'>scrollIntoView</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> container], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> hscroll]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Scrolls this element into view within the passed container. ...</div><div class='long'><p>Scrolls this element into view within the passed container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (optional)<div class='sub-desc'><p>The container element to scroll (defaults to document.body).  Should be a\nstring (id), dom node, or <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n</div></li><li><span class='pre'>hscroll</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>False to disable horizontal scroll (defaults to true)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-scrollTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.scroll.html#Ext-Element-method-scrollTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-scrollTo' class='name expandable'>scrollTo</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> side, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> value, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Scrolls this element the specified scroll point. ...</div><div class='long'><p>Scrolls this element the specified scroll point. It does NOT do bounds checking so if you scroll to a weird value it will try to do it. For auto bounds checking, use scroll().</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>side</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either \"left\" for scrollLeft values or \"top\" for scrollTop values.</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new scroll value</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-select' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-select' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-select' class='name expandable'>select</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector</span> ) : <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a>/<a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></div><div class='description'><div class='short'>Creates a Ext.CompositeElement for child nodes based on the passed CSS selector (the selector should not contain an id). ...</div><div class='long'><p>Creates a <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a> for child nodes based on the passed CSS selector (the selector should not contain an id).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS selector</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a>/<a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></span><div class='sub-desc'><p>The composite element</p>\n</div></li></ul></div></div></div><div id='method-selectable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-selectable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-selectable' class='name expandable'>selectable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Enable text selection for this element (normalized across browsers) ...</div><div class='long'><p>Enable text selection for this element (normalized across browsers)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-serializeForm' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static-more.html#Ext-Element-method-serializeForm' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-serializeForm' class='name expandable'>serializeForm</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> form</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Serializes a DOM form into a url encoded string ...</div><div class='long'><p>Serializes a DOM form into a url encoded string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>form</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The form</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The url encoded form</p>\n</div></li></ul></div></div></div><div id='method-set' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-set' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-set' class='name expandable'>set</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> o, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> useSet]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the passed attributes as attributes of this element (a style attribute can be a string, object or function) ...</div><div class='long'><p>Sets the passed attributes as attributes of this element (a style attribute can be a string, object or function)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The object with the attributes</p>\n</div></li><li><span class='pre'>useSet</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>false to override the default setAttribute to use expandos.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setBottom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setBottom' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setBottom' class='name expandable'>setBottom</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> bottom</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the element's CSS bottom style. ...</div><div class='long'><p>Sets the element's CSS bottom style.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bottom</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The bottom CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setBounds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setBounds' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setBounds' class='name expandable'>setBounds</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> x, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> width, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> height, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the element's position and size in one shot. ...</div><div class='long'><p>Sets the element's position and size in one shot. If animation is true then width, height, x and y will be animated concurrently.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>X value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Y value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new width. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels)</li>\n<li>A String used to set the CSS width style. Animation may <b>not</b> be used.\n</ul></div></p>\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new height. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels)</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setBox' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setBox' class='name expandable'>setBox</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> box, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> adjust], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the element's box. ...</div><div class='long'><p>Sets the element's box. Use getBox() on another element to get a box obj. If animate is true then width, height, x and y will be animated concurrently.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>box</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The box to fill {x, y, width, height}</p>\n</div></li><li><span class='pre'>adjust</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Whether to adjust for box-model issues automatically</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setDisplayed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-method-setDisplayed' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setDisplayed' class='name expandable'>setDisplayed</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the CSS display property. ...</div><div class='long'><p>Sets the CSS display property. Uses originalDisplay if the specified value is a boolean true.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Boolean value to display the element using its default display, or a string to set the display directly.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-setHeight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setHeight' class='name expandable'>setHeight</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> height, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Set the height of this Element. ...</div><div class='long'><p>Set the height of this Element.</p>\n\n<pre><code>// change the height to 200px and animate with default configuration\nExt.fly('elementId').setHeight(200, true);\n\n// change the height to 150px and animate with a custom configuration\nExt.fly('elId').setHeight(150, {\n    duration : .5, // animation will have a duration of .5 seconds\n    // will change the content to \"finished\"\n    callback: function(){ this.<a href=\"#!/api/Ext.Element-method-update\" rel=\"Ext.Element-method-update\" class=\"docClass\">update</a>(\"finished\"); }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>height</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new height. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels.)</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setLeft' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setLeft' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setLeft' class='name expandable'>setLeft</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> left</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the element's left position directly using CSS style (instead of setX). ...</div><div class='long'><p>Sets the element's left position directly using CSS style (instead of <a href=\"#!/api/Ext.Element-method-setX\" rel=\"Ext.Element-method-setX\" class=\"docClass\">setX</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>left</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The left CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setLeftTop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setLeftTop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setLeftTop' class='name expandable'>setLeftTop</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> left, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> top</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Quick set left and top adding default units ...</div><div class='long'><p>Quick set left and top adding default units</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>left</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The left CSS property value</p>\n</div></li><li><span class='pre'>top</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The top CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setLocation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setLocation' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setLocation' class='name expandable'>setLocation</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> x, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the position of the element in page coordinates, regardless of how the element is positioned. ...</div><div class='long'><p>Sets the position of the element in page coordinates, regardless of how the element is positioned.\nThe element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>X value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Y value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setOpacity' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-setOpacity' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setOpacity' class='name expandable'>setOpacity</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> opacity, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Set the opacity of the element ...</div><div class='long'><p>Set the opacity of the element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opacity</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new opacity. 0 = transparent, .5 = 50% visibile, 1 = fully visible, etc</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>a standard Element animation config object or <tt>true</tt> for\nthe default animation (<tt>{duration: .35, easing: 'easeIn'}</tt>)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setPositioning' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setPositioning' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setPositioning' class='name expandable'>setPositioning</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> posCfg</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Set positioning with an object returned by getPositioning(). ...</div><div class='long'><p>Set positioning with an object returned by getPositioning().</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>posCfg</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setRegion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setRegion' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setRegion' class='name expandable'>setRegion</a>( <span class='pre'><a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a> region, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the element's position and size the specified region. ...</div><div class='long'><p>Sets the element's position and size the specified region. If animation is true then width, height, x and y will be animated concurrently.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>region</span> : <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a><div class='sub-desc'><p>The region to fill</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setRight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setRight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setRight' class='name expandable'>setRight</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> right</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the element's CSS right style. ...</div><div class='long'><p>Sets the element's CSS right style.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>right</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The right CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-setSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setSize' class='name expandable'>setSize</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> width, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> height, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Set the size of this Element. ...</div><div class='long'><p>Set the size of this Element. If animation is true, both width and height will be animated concurrently.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new width. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style. Animation may <b>not</b> be used.\n<li>A size object in the format <code>{width: widthValue, height: heightValue}</code>.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new height. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setStyle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-setStyle' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setStyle' class='name expandable'>setStyle</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> property, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Wrapper for setting style properties, also takes single object parameter of multiple styles. ...</div><div class='long'><p>Wrapper for setting style properties, also takes single object parameter of multiple styles.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>property</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The style property to be set, or an object of multiple styles.</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The value to apply to the given property, or null if an object was passed.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setTop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setTop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setTop' class='name expandable'>setTop</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> top</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the element's top position directly using CSS style (instead of setY). ...</div><div class='long'><p>Sets the element's top position directly using CSS style (instead of <a href=\"#!/api/Ext.Element-method-setY\" rel=\"Ext.Element-method-setY\" class=\"docClass\">setY</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>top</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The top CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setVisibilityMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-method-setVisibilityMode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setVisibilityMode' class='name expandable'>setVisibilityMode</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> visMode</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the element's visibility mode. ...</div><div class='long'><p>Sets the element's visibility mode. When setVisible() is called it\nwill use this to determine whether to set the visibility or the display property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visMode</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Ext.Element.VISIBILITY or Ext.Element.DISPLAY</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setVisible' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-method-setVisible' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setVisible' class='name expandable'>setVisible</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> visible, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the visibility of the element (see details). ...</div><div class='long'><p>Sets the visibility of the element (see details). If the visibilityMode is set to Element.DISPLAY, it will use\nthe display property to hide the element, otherwise it uses visibility. The default is to hide and show using the visibility property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visible</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>Whether the element is visible</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-setWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setWidth' class='name expandable'>setWidth</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> width, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Set the width of this Element. ...</div><div class='long'><p>Set the width of this Element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new width. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style. Animation may <b>not</b> be used.\n</ul></div></p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setX' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setX' class='name expandable'>setX</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> The, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the X position of the element based on page coordinates. ...</div><div class='long'><p>Sets the X position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>The</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>X position of the element</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setXY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setXY' class='name expandable'>setXY</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] pos, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the position of the element in page coordinates, regardless of how the element is positioned. ...</div><div class='long'><p>Sets the position of the element in page coordinates, regardless of how the element is positioned.\nThe element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pos</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]<div class='sub-desc'><p>Contains X &amp; Y [x, y] values for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-setY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-setY' class='name expandable'>setY</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> The, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Sets the Y position of the element based on page coordinates. ...</div><div class='long'><p>Sets the Y position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>The</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Y position of the element</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-shift' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-shift' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-shift' class='name expandable'>shift</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Animates the transition of any combination of an element's dimensions, xy position and/or opacity. ...</div><div class='long'><p>Animates the transition of any combination of an element's dimensions, xy position and/or opacity. Any of these\nproperties not specified in the config object will not be changed. This effect requires that at least one new\ndimension, position or opacity setting must be passed in on the config object in order for the function to have\nany effect. Usage:</p>\n\n<pre><code>// slide the element horizontally to x position 200 while changing the height and opacity\nel.shift({ x: 200, height: 50, opacity: .8 });\n\n// common config options shown with default values.\nel.shift({\n    width: [element's width],\n    height: [element's height],\n    x: [element's x position],\n    y: [element's y position],\n    opacity: [element's opacity],\n    easing: 'easeOut',\n    duration: .35\n});\n</code></pre>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-show' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-method-show' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-show' class='name expandable'>show</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Show this element - Uses display mode to determine whether to use \"display\" or \"visibility\". ...</div><div class='long'><p>Show this element - Uses display mode to determine whether to use \"display\" or \"visibility\". See <a href=\"#!/api/Ext.Element-method-setVisible\" rel=\"Ext.Element-method-setVisible\" class=\"docClass\">setVisible</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-slideIn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-slideIn' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-slideIn' class='name expandable'>slideIn</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> anchor], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Slides the element into view. ...</div><div class='long'><p>Slides the element into view. An anchor point can be optionally passed to set the point of origin for the slide\neffect. This function automatically handles wrapping the element with a fixed-size container if needed. See the\nFx class overview for valid anchor point options. Usage:</p>\n\n<pre><code>// default: slide the element in from the top\nel.slideIn();\n\n// custom: slide the element in from the right with a 2-second duration\nel.slideIn('r', { duration: 2000 });\n\n// common config options shown with default values\nel.slideIn('t', {\n    easing: 'easeOut',\n    duration: 500\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>anchor</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>One of the valid Fx anchor positions</p>\n<p>Defaults to: <code>&quot;t&quot;</code></p></div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-slideOut' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-slideOut' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-slideOut' class='name expandable'>slideOut</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> anchor], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Slides the element out of view. ...</div><div class='long'><p>Slides the element out of view. An anchor point can be optionally passed to set the end point for the slide\neffect. When the effect is completed, the element will be hidden (visibility = 'hidden') but block elements will\nstill take up space in the document. The element must be removed from the DOM using the 'remove' config option if\ndesired. This function automatically handles wrapping the element with a fixed-size container if needed. See the\nFx class overview for valid anchor point options. Usage:</p>\n\n<pre><code>// default: slide the element out to the top\nel.slideOut();\n\n// custom: slide the element out to the right with a 2-second duration\nel.slideOut('r', { duration: 2000 });\n\n// common config options shown with default values\nel.slideOut('t', {\n    easing: 'easeOut',\n    duration: 500,\n    remove: false,\n    useDisplay: false\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>anchor</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>One of the valid Fx anchor positions</p>\n<p>Defaults to: <code>&quot;t&quot;</code></p></div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-swallowEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element-more.html#Ext-Element-method-swallowEvent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-swallowEvent' class='name expandable'>swallowEvent</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] eventName, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> preventDefault]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Stops the specified event(s) from bubbling and optionally prevents the default action ...</div><div class='long'><p>Stops the specified event(s) from bubbling and optionally prevents the default action</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>an event / array of events to stop from bubbling</p>\n</div></li><li><span class='pre'>preventDefault</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to prevent the default action too</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-switchOff' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.anim.html#Ext-Element-method-switchOff' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-switchOff' class='name expandable'>switchOff</a>( <span class='pre'>[<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Blinks the element as if it was clicked and then collapses on its center (similar to switching off a television). ...</div><div class='long'><p>Blinks the element as if it was clicked and then collapses on its center (similar to switching off a television).\nWhen the effect is completed, the element will be hidden (visibility = 'hidden') but block elements will still\ntake up space in the document. The element must be removed from the DOM using the 'remove' config option if\ndesired. Usage:</p>\n\n<pre><code>// default\nel.switchOff();\n\n// all config options shown with default values\nel.switchOff({\n    easing: 'easeIn',\n    duration: .3,\n    remove: false,\n    useDisplay: false\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Object literal with any of the Fx config options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-toggle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx.html#Ext-Element-method-toggle' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-toggle' class='name expandable'>toggle</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Toggles the element's visibility or display, depending on visibility mode. ...</div><div class='long'><p>Toggles the element's visibility or display, depending on visibility mode.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-toggleCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-toggleCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-toggleCls' class='name expandable'>toggleCls</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Toggles the specified CSS class on this element (removes it if it already exists, otherwise adds it). ...</div><div class='long'><p>Toggles the specified CSS class on this element (removes it if it already exists, otherwise adds it).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS class to toggle</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-translatePoints' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.position.html#Ext-Element-method-translatePoints' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-translatePoints' class='name expandable'>translatePoints</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] x, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Translates the passed page coordinates into left/top css values for this element ...</div><div class='long'><p>Translates the passed page coordinates into left/top css values for this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]<div class='sub-desc'><p>The page x or an array containing [x, y]</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The page y, required if x is not an array</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>An object with left and top properties. e.g. {left: (value), top: (value)}</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-un' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-un' class='name expandable'>un</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Shorthand for removeListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.Element-method-removeListener\" rel=\"Ext.Element-method-removeListener\" class=\"docClass\">removeListener</a>.</p>\n\n<p>Removes an event handler from this element.</p>\n\n<p><strong>Note</strong>: if a <em>scope</em> was explicitly specified when <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">adding</a> the listener,\nthe same scope must be specified here.</p>\n\n<p>Example:</p>\n\n<pre><code>el.removeListener('click', this.handlerFn);\n// or\nel.un('click', this.handlerFn);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event from which to remove the handler.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler function to remove. <strong>This must be a reference to the function passed into the\n<a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</strong></p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>If a scope (<strong>this</strong> reference) was specified when the listener was added, then this must\nrefer to the same object.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n\n</div></li></ul></div></div></div><div id='method-unclip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-unclip' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-unclip' class='name expandable'>unclip</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Return clipping (overflow) to original clipping before clip was called ...</div><div class='long'><p>Return clipping (overflow) to original clipping before <tt><a href=\"#!/api/Ext.Element-method-clip\" rel=\"Ext.Element-method-clip\" class=\"docClass\">clip</a></tt> was called</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-unmask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.fx-more.html#Ext-Element-method-unmask' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-unmask' class='name expandable'>unmask</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes a previously applied mask. ...</div><div class='long'><p>Removes a previously applied mask.</p>\n</div></div></div><div id='method-unselectable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.style.html#Ext-Element-method-unselectable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-unselectable' class='name expandable'>unselectable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Disables text selection for this element (normalized across browsers) ...</div><div class='long'><p>Disables text selection for this element (normalized across browsers)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-up' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.traversal.html#Ext-Element-method-up' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-up' class='name expandable'>up</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> maxDepth]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Walks up the dom looking for a parent node that matches the passed simple selector (e.g. ...</div><div class='long'><p>Walks up the dom looking for a parent node that matches the passed simple selector (e.g. div.some-class or span:first-child).\nThis is a shortcut for findParentNode() that always returns an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The simple selector to test</p>\n</div></li><li><span class='pre'>maxDepth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (optional)<div class='sub-desc'><p>The max depth to search as a number or element (defaults to 10 || document.body)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The matching DOM node (or null if no match was found)</p>\n</div></li></ul></div></div></div><div id='method-update' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-method-update' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-update' class='name expandable'>update</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> html</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Update the innerHTML of this element ...</div><div class='long'><p>Update the innerHTML of this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>html</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new HTML</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-wrap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.insertion.html#Ext-Element-method-wrap' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-method-wrap' class='name expandable'>wrap</a>( <span class='pre'>[<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnDom]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Creates and wraps this element with another element ...</div><div class='long'><p>Creates and wraps this element with another element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>DomHelper element config object for the wrapper element or null for an empty div</p>\n</div></li><li><span class='pre'>returnDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return the raw DOM element instead of <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The newly created wrapper element</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-fly' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-static-method-fly' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-fly' class='name expandable'>fly</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement el, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> named]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Gets the globally shared flyweight Element, with the passed node as the active element. ...</div><div class='long'><p>Gets the globally shared flyweight Element, with the passed node as the active element. Do not store a reference\nto this element - the dom node can be overwritten by other code. <a href=\"#!/api/Ext-method-fly\" rel=\"Ext-method-fly\" class=\"docClass\">Ext.fly</a> is alias for\n<a href=\"#!/api/Ext.Element-static-method-fly\" rel=\"Ext.Element-static-method-fly\" class=\"docClass\">fly</a>.</p>\n\n<p>Use this to make one-time references to DOM elements which are not going to be accessed again either by\napplication code, or by Ext's classes. If accessing an element which will be processed regularly, then <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a> will be more appropriate to take advantage of the caching provided by the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>\nclass.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'><p>The dom node or id</p>\n</div></li><li><span class='pre'>named</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Allows for creation of named reusable flyweights to prevent conflicts (e.g.\ninternally Ext uses \"_global\")</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The shared Element object (or null if no matching element was found)</p>\n</div></li></ul></div></div></div><div id='static-method-fromPoint' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-fromPoint' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-fromPoint' class='name expandable'>fromPoint</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> x, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Returns the top Element that is located at the passed coordinates ...</div><div class='long'><p>Returns the top Element that is located at the passed coordinates</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The x coordinate</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The y coordinate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The found Element</p>\n</div></li></ul></div></div></div><div id='static-method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-static-method-get' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-get' class='name expandable'>get</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Retrieves Ext.Element objects. ...</div><div class='long'><p>Retrieves <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> objects. <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a> is an alias for <a href=\"#!/api/Ext.Element-static-method-get\" rel=\"Ext.Element-static-method-get\" class=\"docClass\">get</a>.</p>\n\n<p><strong>This method does not retrieve <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a>s.</strong> This method retrieves <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>\nobjects which encapsulate DOM elements. To retrieve a Component by its ID, use <a href=\"#!/api/Ext.ComponentManager-method-get\" rel=\"Ext.ComponentManager-method-get\" class=\"docClass\">Ext.ComponentManager.get</a>.</p>\n\n<p>Uses simple caching to consistently return the same object. Automatically fixes if an object was recreated with\nthe same id via AJAX or DOM.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The id of the node, a DOM Node or an existing Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element object (or null if no matching element was found)</p>\n</div></li></ul></div></div></div><div id='static-method-getDocumentHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-getDocumentHeight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-getDocumentHeight' class='name expandable'>getDocumentHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Retrieves the document height ...</div><div class='long'><p>Retrieves the document height</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>documentHeight</p>\n</div></li></ul></div></div></div><div id='static-method-getDocumentWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-getDocumentWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-getDocumentWidth' class='name expandable'>getDocumentWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Retrieves the document width ...</div><div class='long'><p>Retrieves the document width</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>documentWidth</p>\n</div></li></ul></div></div></div><div id='static-method-getOrientation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-getOrientation' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-getOrientation' class='name expandable'>getOrientation</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Retrieves the current orientation of the window. ...</div><div class='long'><p>Retrieves the current orientation of the window. This is calculated by\ndeterming if the height is greater than the width.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>Orientation of window: 'portrait' or 'landscape'</p>\n</div></li></ul></div></div></div><div id='static-method-getViewSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-getViewSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-getViewSize' class='name expandable'>getViewSize</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Retrieves the viewport size of the window. ...</div><div class='long'><p>Retrieves the viewport size of the window.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>object containing width and height properties</p>\n</div></li></ul></div></div></div><div id='static-method-getViewportHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-getViewportHeight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-getViewportHeight' class='name expandable'>getViewportHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Retrieves the viewport height of the window. ...</div><div class='long'><p>Retrieves the viewport height of the window.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>viewportHeight</p>\n</div></li></ul></div></div></div><div id='static-method-getViewportWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-getViewportWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-getViewportWidth' class='name expandable'>getViewportWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Retrieves the viewport width of the window. ...</div><div class='long'><p>Retrieves the viewport width of the window.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>viewportWidth</p>\n</div></li></ul></div></div></div><div id='static-method-normalize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-normalize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-normalize' class='name expandable'>normalize</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> prop</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Normalizes CSS property keys from dash delimited to camel case JavaScript Syntax. ...</div><div class='long'><p>Normalizes CSS property keys from dash delimited to camel case JavaScript Syntax.\nFor example:</p>\n\n<ul>\n <li>border-width -> borderWidth</li>\n <li>padding-top -> paddingTop</li>\n</ul>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>prop</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The property to normalize</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The normalized string</p>\n</div></li></ul></div></div></div><div id='static-method-parseBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-parseBox' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-parseBox' class='name expandable'>parseBox</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> box</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Parses a number or string representing margin sizes into an object. ...</div><div class='long'><p>Parses a number or string representing margin sizes into an object. Supports CSS-style margin declarations\n(e.g. 10, \"10\", \"10 10\", \"10 10 10\" and \"10 10 10 10\" are all valid options and would return the same result)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>box</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The encoded margins</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>An object with margin sizes for top, right, bottom and left</p>\n</div></li></ul></div></div></div><div id='static-method-parseStyles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-parseStyles' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-parseStyles' class='name expandable'>parseStyles</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> styles</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Converts a CSS string into an object with a property for each style. ...</div><div class='long'><p>Converts a CSS string into an object with a property for each style.</p>\n\n<p>\nThe sample code below would return an object with 2 properties, one\nfor background-color and one for color.</p>\n\n\n<pre><code>var css = 'background-color: red;color: blue; ';\nconsole.log(Ext.Element.parseStyles(css));\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>styles</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>A CSS string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>styles</p>\n</div></li></ul></div></div></div><div id='static-method-unitizeBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element.static.html#Ext-Element-static-method-unitizeBox' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-static-method-unitizeBox' class='name expandable'>unitizeBox</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> box, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> units</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Parses a number or string representing margin sizes into an object. ...</div><div class='long'><p>Parses a number or string representing margin sizes into an object. Supports CSS-style margin declarations\n(e.g. 10, \"10\", \"10 10\", \"10 10 10\" and \"10 10 10 10\" are all valid options and would return the same result)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>box</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The encoded margins</p>\n</div></li><li><span class='pre'>units</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of units to add</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>An string with unitized (px if units is not specified) metrics for top, right, bottom and left</p>\n</div></li></ul></div></div></div></div></div><div id='m-event'><div class='definedBy'>Defined By</div><h3 class='members-title'>Events</h3><div class='subsection'><div id='event-DOMActivate' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMActivate' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMActivate' class='name expandable'>DOMActivate</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when an element is activated, for instance, through a mouse click or a keypress.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-DOMAttrModified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMAttrModified' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMAttrModified' class='name expandable'>DOMAttrModified</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when an attribute has been modified.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-DOMCharacterDataModified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMCharacterDataModified' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMCharacterDataModified' class='name expandable'>DOMCharacterDataModified</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when the character data has been modified.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-DOMFocusIn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMFocusIn' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMFocusIn' class='name expandable'>DOMFocusIn</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Similar to HTML focus event, but can be applied to any focusable element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-DOMFocusOut' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMFocusOut' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMFocusOut' class='name expandable'>DOMFocusOut</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Similar to HTML blur event, but can be applied to any focusable element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-DOMNodeInserted' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMNodeInserted' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMNodeInserted' class='name expandable'>DOMNodeInserted</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when a node has been added as a child of another node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-DOMNodeInsertedIntoDocument' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMNodeInsertedIntoDocument' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMNodeInsertedIntoDocument' class='name expandable'>DOMNodeInsertedIntoDocument</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when a node is being inserted into a document.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-DOMNodeRemoved' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMNodeRemoved' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMNodeRemoved' class='name expandable'>DOMNodeRemoved</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when a descendant node of the element is removed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-DOMNodeRemovedFromDocument' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMNodeRemovedFromDocument' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMNodeRemovedFromDocument' class='name expandable'>DOMNodeRemovedFromDocument</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when a node is being removed from a document.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-DOMSubtreeModified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-DOMSubtreeModified' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-DOMSubtreeModified' class='name expandable'>DOMSubtreeModified</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when the subtree is modified.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-abort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-abort' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-abort' class='name expandable'>abort</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when an object/image is stopped from loading before completely loaded. ...</div><div class='long'><p>Fires when an object/image is stopped from loading before completely loaded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-blur' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-blur' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-blur' class='name expandable'>blur</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when an element loses focus either via the pointing device or by tabbing navigation. ...</div><div class='long'><p>Fires when an element loses focus either via the pointing device or by tabbing navigation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-change' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-change' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-change' class='name expandable'>change</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a control loses the input focus and its value has been modified since gaining focus. ...</div><div class='long'><p>Fires when a control loses the input focus and its value has been modified since gaining focus.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-click' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-click' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-click' class='name expandable'>click</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a mouse click is detected within the element. ...</div><div class='long'><p>Fires when a mouse click is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-contextmenu' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-contextmenu' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-contextmenu' class='name expandable'>contextmenu</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a right click is detected within the element. ...</div><div class='long'><p>Fires when a right click is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-dblclick' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-dblclick' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-dblclick' class='name expandable'>dblclick</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a mouse double click is detected within the element. ...</div><div class='long'><p>Fires when a mouse double click is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-error' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-error' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-error' class='name expandable'>error</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when an object/image/frame cannot be loaded properly. ...</div><div class='long'><p>Fires when an object/image/frame cannot be loaded properly.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-focus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-focus' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-focus' class='name expandable'>focus</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when an element receives focus either via the pointing device or by tab navigation. ...</div><div class='long'><p>Fires when an element receives focus either via the pointing device or by tab navigation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-keydown' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-keydown' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-keydown' class='name expandable'>keydown</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a keydown is detected within the element. ...</div><div class='long'><p>Fires when a keydown is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-keypress' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-keypress' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-keypress' class='name expandable'>keypress</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a keypress is detected within the element. ...</div><div class='long'><p>Fires when a keypress is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-keyup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-keyup' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-keyup' class='name expandable'>keyup</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a keyup is detected within the element. ...</div><div class='long'><p>Fires when a keyup is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-load' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-load' class='name expandable'>load</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when the user agent finishes loading all content within the element. ...</div><div class='long'><p>Fires when the user agent finishes loading all content within the element. Only supported by window, frames,\nobjects and images.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-mousedown' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-mousedown' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-mousedown' class='name expandable'>mousedown</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a mousedown is detected within the element. ...</div><div class='long'><p>Fires when a mousedown is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-mouseenter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-mouseenter' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-mouseenter' class='name expandable'>mouseenter</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when the mouse enters the element. ...</div><div class='long'><p>Fires when the mouse enters the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-mouseleave' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-mouseleave' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-mouseleave' class='name expandable'>mouseleave</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when the mouse leaves the element. ...</div><div class='long'><p>Fires when the mouse leaves the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-mousemove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-mousemove' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-mousemove' class='name expandable'>mousemove</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a mousemove is detected with the element. ...</div><div class='long'><p>Fires when a mousemove is detected with the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-mouseout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-mouseout' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-mouseout' class='name expandable'>mouseout</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a mouseout is detected with the element. ...</div><div class='long'><p>Fires when a mouseout is detected with the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-mouseover' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-mouseover' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-mouseover' class='name expandable'>mouseover</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a mouseover is detected within the element. ...</div><div class='long'><p>Fires when a mouseover is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-mouseup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-mouseup' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-mouseup' class='name expandable'>mouseup</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a mouseup is detected within the element. ...</div><div class='long'><p>Fires when a mouseup is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-reset' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-reset' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-reset' class='name expandable'>reset</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a form is reset. ...</div><div class='long'><p>Fires when a form is reset.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-resize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-resize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-resize' class='name expandable'>resize</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a document view is resized. ...</div><div class='long'><p>Fires when a document view is resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-scroll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-scroll' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-scroll' class='name expandable'>scroll</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a document view is scrolled. ...</div><div class='long'><p>Fires when a document view is scrolled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-select' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-select' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-select' class='name expandable'>select</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a user selects some text in a text field, including input and textarea. ...</div><div class='long'><p>Fires when a user selects some text in a text field, including input and textarea.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-submit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-submit' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-submit' class='name expandable'>submit</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a form is submitted. ...</div><div class='long'><p>Fires when a form is submitted.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-unload' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Element' rel='Ext.Element' class='definedIn docClass'>Ext.Element</a><br/><a href='source/Element2.html#Ext-Element-event-unload' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Element-event-unload' class='name expandable'>unload</a>( <span class='pre'><a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e, HTMLElement t, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when the user agent removes all content from a window or frame. ...</div><div class='long'><p>Fires when the user agent removes all content from a window or frame. For elements, it fires when the target\nelement or any of its content has been removed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HTMLElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{},"requires":[],"deprecated":null,"extends":null,"inheritable":false,"static":false,"superclasses":[],"singleton":false,"code_type":"assignment","alias":null,"statics":{"property":[{"tagname":"property","deprecated":null,"static":true,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DISPLAY","id":"static-property-DISPLAY"},{"tagname":"property","deprecated":null,"static":true,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"OFFSETS","id":"static-property-OFFSETS"},{"tagname":"property","deprecated":null,"static":true,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"VISIBILITY","id":"static-property-VISIBILITY"},{"tagname":"property","deprecated":null,"static":true,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"visibilityCls","id":"static-property-visibilityCls"}],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"fly","id":"static-method-fly"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"fromPoint","id":"static-method-fromPoint"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"get","id":"static-method-get"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getDocumentHeight","id":"static-method-getDocumentHeight"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getDocumentWidth","id":"static-method-getDocumentWidth"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getOrientation","id":"static-method-getOrientation"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getViewSize","id":"static-method-getViewSize"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getViewportHeight","id":"static-method-getViewportHeight"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getViewportWidth","id":"static-method-getViewportWidth"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"normalize","id":"static-method-normalize"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"parseBox","id":"static-method-parseBox"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"parseStyles","id":"static-method-parseStyles"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"unitizeBox","id":"static-method-unitizeBox"}],"event":[]},"subclasses":["Ext.Layer"],"uses":[],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"autoBoxAdjust","id":"property-autoBoxAdjust"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"defaultUnit","id":"property-defaultUnit"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"dom","id":"property-dom"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"id","id":"property-id"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"originalDisplay","id":"property-originalDisplay"}],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"constructor","id":"method-constructor"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"addCls","id":"method-addCls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"addClsOnClick","id":"method-addClsOnClick"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"addClsOnFocus","id":"method-addClsOnFocus"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"addClsOnOver","id":"method-addClsOnOver"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"addKeyListener","id":"method-addKeyListener"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"addKeyMap","id":"method-addKeyMap"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"addListener","id":"method-addListener"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"adjustWidth","id":"method-adjustWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"alignTo","id":"method-alignTo"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"anchorTo","id":"method-anchorTo"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"appendChild","id":"method-appendChild"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"appendTo","id":"method-appendTo"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"applyStyles","id":"method-applyStyles"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"blur","id":"method-blur"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"boxWrap","id":"method-boxWrap"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"center","id":"method-center"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"child","id":"method-child"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"clean","id":"method-clean"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"clearListeners","id":"method-clearListeners"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"clearOpacity","id":"method-clearOpacity"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"clearPositioning","id":"method-clearPositioning"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"clip","id":"method-clip"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"contains","id":"method-contains"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"createChild","id":"method-createChild"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"createProxy","id":"method-createProxy"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"createShim","id":"method-createShim"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"destroy","id":"method-destroy"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"down","id":"method-down"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"enableDisplayMode","id":"method-enableDisplayMode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"fadeIn","id":"method-fadeIn"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"fadeOut","id":"method-fadeOut"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"findParent","id":"method-findParent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"findParentNode","id":"method-findParentNode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"first","id":"method-first"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"focus","id":"method-focus"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"focusable","id":"method-focusable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"frame","id":"method-frame"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getActiveElement","id":"method-getActiveElement"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getAlignToXY","id":"method-getAlignToXY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getAnchorXY","id":"method-getAnchorXY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getAttribute","id":"method-getAttribute"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getAttributeNS","id":"method-getAttributeNS"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getBorderWidth","id":"method-getBorderWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getBottom","id":"method-getBottom"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getBox","id":"method-getBox"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getById","id":"method-getById"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getCenterXY","id":"method-getCenterXY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getColor","id":"method-getColor"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getComputedHeight","id":"method-getComputedHeight"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getComputedWidth","id":"method-getComputedWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getConstrainVector","id":"method-getConstrainVector"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getFrameWidth","id":"method-getFrameWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getHeight","id":"method-getHeight"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getLeft","id":"method-getLeft"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getLoader","id":"method-getLoader"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getMargin","id":"method-getMargin"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getOffsetsTo","id":"method-getOffsetsTo"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getPadding","id":"method-getPadding"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getPageBox","id":"method-getPageBox"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getPositioning","id":"method-getPositioning"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getRegion","id":"method-getRegion"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getRight","id":"method-getRight"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":true,"name":"getScopeParent","id":"method-getScopeParent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getScroll","id":"method-getScroll"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getSize","id":"method-getSize"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getStyle","id":"method-getStyle"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getStyleSize","id":"method-getStyleSize"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getStyles","id":"method-getStyles"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getTextWidth","id":"method-getTextWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getTop","id":"method-getTop"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getValue","id":"method-getValue"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getViewRegion","id":"method-getViewRegion"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getViewSize","id":"method-getViewSize"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getWidth","id":"method-getWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getX","id":"method-getX"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getXY","id":"method-getXY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"getY","id":"method-getY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"ghost","id":"method-ghost"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"hasCls","id":"method-hasCls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"hide","id":"method-hide"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"highlight","id":"method-highlight"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"hover","id":"method-hover"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"initDD","id":"method-initDD"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"initDDProxy","id":"method-initDDProxy"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"initDDTarget","id":"method-initDDTarget"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"insertAfter","id":"method-insertAfter"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"insertBefore","id":"method-insertBefore"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"insertFirst","id":"method-insertFirst"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"insertHtml","id":"method-insertHtml"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"insertSibling","id":"method-insertSibling"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"is","id":"method-is"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"isBorderBox","id":"method-isBorderBox"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"isDisplayed","id":"method-isDisplayed"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"isMasked","id":"method-isMasked"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"isScrollable","id":"method-isScrollable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"isVisible","id":"method-isVisible"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"last","id":"method-last"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"load","id":"method-load"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"mask","id":"method-mask"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"monitorMouseLeave","id":"method-monitorMouseLeave"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"move","id":"method-move"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"moveTo","id":"method-moveTo"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"next","id":"method-next"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"on","id":"method-on"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"parent","id":"method-parent"},{"tagname":"method","deprecated":{"doc":"Creates a pause before any subsequent queued effects begin. If there are no effects queued after the pause it will\nhave no effect. Usage:\n\n    el.pause(1);","tagname":"deprecated","text":"\n","version":"4.0"},"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"pause","id":"method-pause"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"position","id":"method-position"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"prev","id":"method-prev"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"puff","id":"method-puff"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"purgeAllListeners","id":"method-purgeAllListeners"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"query","id":"method-query"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"radioCls","id":"method-radioCls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"relayEvent","id":"method-relayEvent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"remove","id":"method-remove"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"removeAllListeners","id":"method-removeAllListeners"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"removeAnchor","id":"method-removeAnchor"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"removeCls","id":"method-removeCls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"removeListener","id":"method-removeListener"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"repaint","id":"method-repaint"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"replace","id":"method-replace"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"replaceCls","id":"method-replaceCls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"replaceWith","id":"method-replaceWith"},{"tagname":"method","deprecated":{"doc":"Animates the transition of an element's dimensions from a starting height/width to an ending height/width. This\nmethod is a convenience implementation of {@link #shift}. Usage:\n\n    // change height and width to 100x100 pixels\n    el.scale(100, 100);\n\n    // common config options shown with default values.  The height and width will default to\n    // the element's existing values if passed as null.\n    el.scale(\n        [element's width],\n        [element's height], {\n            easing: 'easeOut',\n            duration: .35\n        }\n    );","tagname":"deprecated","text":"\n","version":"4.0"},"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"scale","id":"method-scale"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"scroll","id":"method-scroll"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"scrollIntoView","id":"method-scrollIntoView"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"scrollTo","id":"method-scrollTo"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"select","id":"method-select"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"selectable","id":"method-selectable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"serializeForm","id":"method-serializeForm"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"set","id":"method-set"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setBottom","id":"method-setBottom"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setBounds","id":"method-setBounds"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setBox","id":"method-setBox"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setDisplayed","id":"method-setDisplayed"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setHeight","id":"method-setHeight"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setLeft","id":"method-setLeft"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setLeftTop","id":"method-setLeftTop"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setLocation","id":"method-setLocation"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setOpacity","id":"method-setOpacity"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setPositioning","id":"method-setPositioning"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setRegion","id":"method-setRegion"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setRight","id":"method-setRight"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setSize","id":"method-setSize"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setStyle","id":"method-setStyle"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setTop","id":"method-setTop"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setVisibilityMode","id":"method-setVisibilityMode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setVisible","id":"method-setVisible"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setWidth","id":"method-setWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setX","id":"method-setX"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setXY","id":"method-setXY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"setY","id":"method-setY"},{"tagname":"method","deprecated":{"doc":"Animates the transition of any combination of an element's dimensions, xy position and/or opacity. Any of these\nproperties not specified in the config object will not be changed. This effect requires that at least one new\ndimension, position or opacity setting must be passed in on the config object in order for the function to have\nany effect. Usage:\n\n    // slide the element horizontally to x position 200 while changing the height and opacity\n    el.shift({ x: 200, height: 50, opacity: .8 });\n\n    // common config options shown with default values.\n    el.shift({\n        width: [element's width],\n        height: [element's height],\n        x: [element's x position],\n        y: [element's y position],\n        opacity: [element's opacity],\n        easing: 'easeOut',\n        duration: .35\n    });","tagname":"deprecated","text":"\n","version":"4.0"},"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"shift","id":"method-shift"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"show","id":"method-show"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"slideIn","id":"method-slideIn"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"slideOut","id":"method-slideOut"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"swallowEvent","id":"method-swallowEvent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"switchOff","id":"method-switchOff"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"toggle","id":"method-toggle"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"toggleCls","id":"method-toggleCls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"translatePoints","id":"method-translatePoints"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"un","id":"method-un"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"unclip","id":"method-unclip"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"unmask","id":"method-unmask"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"unselectable","id":"method-unselectable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"up","id":"method-up"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"update","id":"method-update"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Element","template":false,"required":null,"protected":false,"name":"wrap","id":"method-wrap"}],"event":[{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMActivate","id":"event-DOMActivate"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMAttrModified","id":"event-DOMAttrModified"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMCharacterDataModified","id":"event-DOMCharacterDataModified"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMFocusIn","id":"event-DOMFocusIn"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMFocusOut","id":"event-DOMFocusOut"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMNodeInserted","id":"event-DOMNodeInserted"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMNodeInsertedIntoDocument","id":"event-DOMNodeInsertedIntoDocument"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMNodeRemoved","id":"event-DOMNodeRemoved"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMNodeRemovedFromDocument","id":"event-DOMNodeRemovedFromDocument"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"DOMSubtreeModified","id":"event-DOMSubtreeModified"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"abort","id":"event-abort"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"blur","id":"event-blur"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"change","id":"event-change"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"click","id":"event-click"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"contextmenu","id":"event-contextmenu"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"dblclick","id":"event-dblclick"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"error","id":"event-error"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"focus","id":"event-focus"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"keydown","id":"event-keydown"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"keypress","id":"event-keypress"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"keyup","id":"event-keyup"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"load","id":"event-load"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"mousedown","id":"event-mousedown"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"mouseenter","id":"event-mouseenter"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"mouseleave","id":"event-mouseleave"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"mousemove","id":"event-mousemove"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"mouseout","id":"event-mouseout"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"mouseover","id":"event-mouseover"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"mouseup","id":"event-mouseup"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"reset","id":"event-reset"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"resize","id":"event-resize"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"scroll","id":"event-scroll"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"select","id":"event-select"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"submit","id":"event-submit"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.Element","template":null,"required":null,"protected":false,"name":"unload","id":"event-unload"}]},"private":false,"component":false,"name":"Ext.Element","alternateClassNames":["Ext.core.Element"],"id":"class-Ext.Element","mixedInto":[],"xtypes":{},"files":[{"href":"Element-more.html#Ext-Element","filename":"Element-more.js"},{"href":"Element.alignment.html#Ext-Element","filename":"Element.alignment.js"},{"href":"Element.anim.html#Ext-Element","filename":"Element.anim.js"},{"href":"Element.dd.html#Ext-Element","filename":"Element.dd.js"},{"href":"Element.fx-more.html#Ext-Element","filename":"Element.fx-more.js"},{"href":"Element.fx.html#Ext-Element","filename":"Element.fx.js"},{"href":"Element.insertion.html#Ext-Element","filename":"Element.insertion.js"},{"href":"Element2.html#Ext-Element","filename":"Element.js"},{"href":"Element.keys.html#Ext-Element","filename":"Element.keys.js"},{"href":"Element.position.html#Ext-Element","filename":"Element.position.js"},{"href":"Element.scroll.html#Ext-Element","filename":"Element.scroll.js"},{"href":"Element.static-more.html#Ext-Element","filename":"Element.static-more.js"},{"href":"Element.static.html#Ext-Element","filename":"Element.static.js"},{"href":"Element.style.html#Ext-Element","filename":"Element.style.js"},{"href":"Element.traversal.html#Ext-Element","filename":"Element.traversal.js"}]});