Ext.data.JsonP.Ext_EventObject({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><strong>Ext.EventObject</strong></div></div><h4>Uses</h4><div class='dependency'><a href='#!/api/Ext.util.Point' rel='Ext.util.Point' class='docClass'>Ext.util.Point</a></div><h4>Files</h4><div class='dependency'><a href='source/EventObject.html#Ext-EventObject' target='_blank'>EventObject.js</a></div></pre><div class='doc-contents'><p>Just as <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> wraps around a native DOM node, <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a>\nwraps the browser's native event-object normalizing cross-browser differences,\nsuch as which mouse button is clicked, keys pressed, mechanisms to stop\nevent-propagation along with a method to prevent default actions from taking place.</p>\n\n<p>For example:</p>\n\n<pre><code>function handleClick(e, t){ // e is not a standard event object, it is a <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a>\n    e.preventDefault();\n    var target = e.getTarget(); // same as t (the target HTMLElement)\n    ...\n}\n\nvar myDiv = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(\"myDiv\");  // get reference to an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>\nmyDiv.on(         // 'on' is shorthand for addListener\n    \"click\",      // perform an action on click of myDiv\n    handleClick   // reference to the action handler\n);\n\n// other methods to do the same:\nExt.EventManager.on(\"myDiv\", 'click', handleClick);\nExt.EventManager.addListener(\"myDiv\", 'click', handleClick);\n</code></pre>\n</div><div class='members'><div id='m-property'><div class='definedBy'>Defined By</div><h3 class='members-title'>Properties</h3><div class='subsection'><div id='property-A' class='member first-child not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-A' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-A' class='name not-expandable'>A</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-ALT' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-ALT' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-ALT' class='name not-expandable'>ALT</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-B' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-B' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-B' class='name not-expandable'>B</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-BACKSPACE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-BACKSPACE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-BACKSPACE' class='name not-expandable'>BACKSPACE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-C' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-C' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-C' class='name not-expandable'>C</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-CAPS_LOCK' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-CAPS_LOCK' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-CAPS_LOCK' class='name not-expandable'>CAPS_LOCK</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-CONTEXT_MENU' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-CONTEXT_MENU' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-CONTEXT_MENU' class='name not-expandable'>CONTEXT_MENU</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-CTRL' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-CTRL' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-CTRL' class='name not-expandable'>CTRL</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-D' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-D' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-D' class='name not-expandable'>D</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-DELETE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-DELETE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-DELETE' class='name not-expandable'>DELETE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-DOWN' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-DOWN' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-DOWN' class='name not-expandable'>DOWN</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-E' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-E' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-E' class='name not-expandable'>E</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-EIGHT' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-EIGHT' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-EIGHT' class='name not-expandable'>EIGHT</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-END' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-END' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-END' class='name not-expandable'>END</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-ENTER' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-ENTER' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-ENTER' class='name not-expandable'>ENTER</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-ESC' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-ESC' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-ESC' class='name not-expandable'>ESC</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F' class='name not-expandable'>F</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F1' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F1' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F1' class='name not-expandable'>F1</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F10' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F10' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F10' class='name not-expandable'>F10</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F11' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F11' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F11' class='name not-expandable'>F11</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F12' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F12' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F12' class='name not-expandable'>F12</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F2' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F2' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F2' class='name not-expandable'>F2</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F3' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F3' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F3' class='name not-expandable'>F3</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F4' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F4' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F4' class='name not-expandable'>F4</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F5' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F5' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F5' class='name not-expandable'>F5</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F6' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F6' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F6' class='name not-expandable'>F6</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F7' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F7' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F7' class='name not-expandable'>F7</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F8' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F8' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F8' class='name not-expandable'>F8</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-F9' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-F9' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-F9' class='name not-expandable'>F9</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-FIVE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-FIVE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-FIVE' class='name not-expandable'>FIVE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-FOUR' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-FOUR' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-FOUR' class='name not-expandable'>FOUR</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-G' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-G' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-G' class='name not-expandable'>G</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-H' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-H' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-H' class='name not-expandable'>H</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-HOME' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-HOME' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-HOME' class='name not-expandable'>HOME</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-I' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-I' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-I' class='name not-expandable'>I</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-INSERT' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-INSERT' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-INSERT' class='name not-expandable'>INSERT</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-J' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-J' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-J' class='name not-expandable'>J</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-K' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-K' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-K' class='name not-expandable'>K</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-L' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-L' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-L' class='name not-expandable'>L</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-LEFT' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-LEFT' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-LEFT' class='name not-expandable'>LEFT</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-M' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-M' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-M' class='name not-expandable'>M</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-N' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-N' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-N' class='name not-expandable'>N</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NINE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NINE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NINE' class='name not-expandable'>NINE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_CENTER' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_CENTER' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_CENTER' class='name not-expandable'>NUM_CENTER</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_DIVISION' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_DIVISION' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_DIVISION' class='name not-expandable'>NUM_DIVISION</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_EIGHT' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_EIGHT' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_EIGHT' class='name not-expandable'>NUM_EIGHT</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_FIVE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_FIVE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_FIVE' class='name not-expandable'>NUM_FIVE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_FOUR' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_FOUR' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_FOUR' class='name not-expandable'>NUM_FOUR</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_MINUS' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_MINUS' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_MINUS' class='name not-expandable'>NUM_MINUS</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_MULTIPLY' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_MULTIPLY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_MULTIPLY' class='name not-expandable'>NUM_MULTIPLY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_NINE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_NINE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_NINE' class='name not-expandable'>NUM_NINE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_ONE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_ONE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_ONE' class='name not-expandable'>NUM_ONE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_PERIOD' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_PERIOD' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_PERIOD' class='name not-expandable'>NUM_PERIOD</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_PLUS' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_PLUS' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_PLUS' class='name not-expandable'>NUM_PLUS</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_SEVEN' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_SEVEN' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_SEVEN' class='name not-expandable'>NUM_SEVEN</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_SIX' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_SIX' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_SIX' class='name not-expandable'>NUM_SIX</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_THREE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_THREE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_THREE' class='name not-expandable'>NUM_THREE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_TWO' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_TWO' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_TWO' class='name not-expandable'>NUM_TWO</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-NUM_ZERO' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-NUM_ZERO' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-NUM_ZERO' class='name not-expandable'>NUM_ZERO</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-O' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-O' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-O' class='name not-expandable'>O</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-ONE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-ONE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-ONE' class='name not-expandable'>ONE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-P' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-P' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-P' class='name not-expandable'>P</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-PAGE_DOWN' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-PAGE_DOWN' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-PAGE_DOWN' class='name not-expandable'>PAGE_DOWN</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-PAGE_UP' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-PAGE_UP' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-PAGE_UP' class='name not-expandable'>PAGE_UP</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-PAUSE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-PAUSE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-PAUSE' class='name not-expandable'>PAUSE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-PRINT_SCREEN' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-PRINT_SCREEN' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-PRINT_SCREEN' class='name not-expandable'>PRINT_SCREEN</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-Q' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-Q' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-Q' class='name not-expandable'>Q</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-R' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-R' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-R' class='name not-expandable'>R</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-RETURN' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-RETURN' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-RETURN' class='name not-expandable'>RETURN</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-RIGHT' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-RIGHT' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-RIGHT' class='name not-expandable'>RIGHT</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-S' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-S' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-S' class='name not-expandable'>S</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-SEVEN' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-SEVEN' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-SEVEN' class='name not-expandable'>SEVEN</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-SHIFT' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-SHIFT' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-SHIFT' class='name not-expandable'>SHIFT</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-SIX' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-SIX' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-SIX' class='name not-expandable'>SIX</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-SPACE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-SPACE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-SPACE' class='name not-expandable'>SPACE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-T' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-T' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-T' class='name not-expandable'>T</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-TAB' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-TAB' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-TAB' class='name not-expandable'>TAB</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-THREE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-THREE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-THREE' class='name not-expandable'>THREE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-TWO' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-TWO' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-TWO' class='name not-expandable'>TWO</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-U' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-U' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-U' class='name not-expandable'>U</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-UP' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-UP' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-UP' class='name not-expandable'>UP</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-V' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-V' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-V' class='name not-expandable'>V</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-W' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-W' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-W' class='name not-expandable'>W</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-WHEEL_SCALE' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-WHEEL_SCALE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-WHEEL_SCALE' class='name expandable'>WHEEL_SCALE</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The mouse wheel delta scaling factor. ...</div><div class='long'><p>The mouse wheel delta scaling factor. This value depends on browser version and OS and\nattempts to produce a similar scrolling experience across all platforms and browsers.</p>\n\n<p>To change this value:</p>\n\n<pre><code> Ext.EventObjectImpl.prototype.WHEEL_SCALE = 72;\n</code></pre>\n</div></div></div><div id='property-X' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-X' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-X' class='name not-expandable'>X</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-Y' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-Y' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-Y' class='name not-expandable'>Y</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-Z' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-Z' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-Z' class='name not-expandable'>Z</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-ZERO' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-property-ZERO' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-property-ZERO' class='name not-expandable'>ZERO</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>Key constant</p>\n</div><div class='long'><p>Key constant</p>\n</div></div></div><div id='property-self' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-property-self' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependent on 'this'\n\n        return this;\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div></div></div><div id='m-method'><div class='definedBy'>Defined By</div><h3 class='members-title'>Methods</h3><div class='subsection'><div id='method-callOverridden' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callOverridden' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result after calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the parent's overridden method. ...</div><div class='long'><p>Call the parent's overridden method. For example:</p>\n\n<pre><code>Ext.define('My.own.A', {\n    constructor: function(test) {\n        alert(test);\n    }\n});\n\nExt.define('My.own.B', {\n    extend: 'My.own.A',\n\n    constructor: function(test) {\n        alert(test);\n\n        this.callParent([test + 1]);\n    }\n});\n\nExt.define('My.own.C', {\n    extend: 'My.own.B',\n\n    constructor: function() {\n        alert(\"Going to call parent's overriden constructor...\");\n\n        this.callParent(arguments);\n    }\n});\n\nvar a = new My.own.A(1); // alerts '1'\nvar b = new My.own.B(1); // alerts '1', then alerts '2'\nvar c = new My.own.C(2); // alerts \"Going to call parent's overriden constructor...\"\n                         // alerts '2', then alerts '3'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result from the superclass' method</p>\n</div></li></ul></div></div></div><div id='method-correctWheelDelta' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-correctWheelDelta' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-correctWheelDelta' class='name expandable'>correctWheelDelta</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> delta</span> )</div><div class='description'><div class='short'>Correctly scales a given wheel delta. ...</div><div class='long'><p>Correctly scales a given wheel delta.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>delta</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The delta value.</p>\n</div></li></ul></div></div></div><div id='method-getCharCode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getCharCode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getCharCode' class='name expandable'>getCharCode</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the character code for the event. ...</div><div class='long'><p>Gets the character code for the event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getKey' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getKey' class='name expandable'>getKey</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns a normalized keyCode for the event. ...</div><div class='long'><p>Returns a normalized keyCode for the event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The key code</p>\n</div></li></ul></div></div></div><div id='method-getPageX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getPageX' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getPageX' class='name expandable'>getPageX</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Gets the x coordinate of the event. ...</div><div class='long'><p>Gets the x coordinate of the event.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0</p><p>Replaced by <a href=\"#!/api/Ext.EventObject-method-getX\" rel=\"Ext.EventObject-method-getX\" class=\"docClass\">getX</a></p>\n</div><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getPageY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getPageY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getPageY' class='name expandable'>getPageY</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Gets the y coordinate of the event. ...</div><div class='long'><p>Gets the y coordinate of the event.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0</p><p>Replaced by <a href=\"#!/api/Ext.EventObject-method-getY\" rel=\"Ext.EventObject-method-getY\" class=\"docClass\">getY</a></p>\n</div><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getPoint' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getPoint' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getPoint' class='name expandable'>getPoint</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.util.Point\" rel=\"Ext.util.Point\" class=\"docClass\">Ext.util.Point</a></div><div class='description'><div class='short'>Returns a point object that consists of the object coordinates. ...</div><div class='long'><p>Returns a point object that consists of the object coordinates.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.Point\" rel=\"Ext.util.Point\" class=\"docClass\">Ext.util.Point</a></span><div class='sub-desc'><p>point</p>\n</div></li></ul></div></div></div><div id='method-getRelatedTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getRelatedTarget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getRelatedTarget' class='name expandable'>getRelatedTarget</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/HTMLElement maxDepth], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnEl]</span> ) : HTMLElement</div><div class='description'><div class='short'>Gets the related target. ...</div><div class='long'><p>Gets the related target.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A simple selector to filter the target or look for an ancestor of the target</p>\n</div></li><li><span class='pre'>maxDepth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/HTMLElement (optional)<div class='sub-desc'><p>The max depth to search as a number or element (defaults to 10 || document.body)</p>\n</div></li><li><span class='pre'>returnEl</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> object instead of DOM node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getTarget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getTarget' class='name expandable'>getTarget</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/HTMLElement maxDepth], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> returnEl]</span> ) : HTMLElement</div><div class='description'><div class='short'>Gets the target for the event. ...</div><div class='long'><p>Gets the target for the event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A simple selector to filter the target or look for an ancestor of the target</p>\n</div></li><li><span class='pre'>maxDepth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/HTMLElement (optional)<div class='sub-desc'><p>The max depth to search as a number or element (defaults to 10 || document.body)</p>\n</div></li><li><span class='pre'>returnEl</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> object instead of DOM node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getWheelDelta' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getWheelDelta' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getWheelDelta' class='name expandable'>getWheelDelta</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Normalizes mouse wheel y-delta across browsers. ...</div><div class='long'><p>Normalizes mouse wheel y-delta across browsers. To get x-delta information, use\n<a href=\"#!/api/Ext.EventObject-method-getWheelDeltas\" rel=\"Ext.EventObject-method-getWheelDeltas\" class=\"docClass\">getWheelDeltas</a> instead.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The mouse wheel y-delta</p>\n</div></li></ul></div></div></div><div id='method-getWheelDeltas' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getWheelDeltas' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getWheelDeltas' class='name expandable'>getWheelDeltas</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the mouse wheel deltas for this event. ...</div><div class='long'><p>Returns the mouse wheel deltas for this event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>An object with \"x\" and \"y\" properties holding the mouse wheel deltas.</p>\n</div></li></ul></div></div></div><div id='method-getX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getX' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getX' class='name expandable'>getX</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the x coordinate of the event. ...</div><div class='long'><p>Gets the x coordinate of the event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getXY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getXY' class='name expandable'>getXY</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</div><div class='description'><div class='short'>Gets the page coordinates of the event. ...</div><div class='long'><p>Gets the page coordinates of the event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span><div class='sub-desc'><p>The xy values like [x, y]</p>\n</div></li></ul></div></div></div><div id='method-getY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-getY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-getY' class='name expandable'>getY</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the y coordinate of the event. ...</div><div class='long'><p>Gets the y coordinate of the event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasModifier' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-hasModifier' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-hasModifier' class='name expandable'>hasModifier</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the control, meta, shift or alt key was pressed during this event. ...</div><div class='long'><p>Returns true if the control, meta, shift or alt key was pressed during this event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-initConfig' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code>Ext.define('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n\n        return this;\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-injectEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-injectEvent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-injectEvent' class='name expandable'>injectEvent</a>( <span class='pre'>[<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement target]</span> )</div><div class='description'><div class='short'>Injects a DOM event using the data in this object and (optionally) a new target. ...</div><div class='long'><p>Injects a DOM event using the data in this object and (optionally) a new target.\nThis is a low-level technique and not likely to be used by application code. The\ncurrently supported event types are:</p>\n\n<p><b>HTMLEvents</b></p>\n\n\n<ul>\n<li>load</li>\n<li>unload</li>\n<li>select</li>\n<li>change</li>\n<li>submit</li>\n<li>reset</li>\n<li>resize</li>\n<li>scroll</li>\n</ul>\n\n\n<p><b>MouseEvents</b></p>\n\n\n<ul>\n<li>click</li>\n<li>dblclick</li>\n<li>mousedown</li>\n<li>mouseup</li>\n<li>mouseover</li>\n<li>mousemove</li>\n<li>mouseout</li>\n</ul>\n\n\n<p><b>UIEvents</b></p>\n\n\n<ul>\n<li>focusin</li>\n<li>focusout</li>\n<li>activate</li>\n<li>focus</li>\n<li>blur</li>\n</ul>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement (optional)<div class='sub-desc'><p>If specified, the target for the event. This\nis likely to be used when relaying a DOM event. If not specified, <a href=\"#!/api/Ext.EventObject-method-getTarget\" rel=\"Ext.EventObject-method-getTarget\" class=\"docClass\">getTarget</a>\nis used to determine the target.</p>\n</div></li></ul></div></div></div><div id='method-isNavKeyPress' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-isNavKeyPress' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-isNavKeyPress' class='name expandable'>isNavKeyPress</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks if the key pressed was a \"navigation\" key ...</div><div class='long'><p>Checks if the key pressed was a \"navigation\" key</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the press is a navigation keypress</p>\n</div></li></ul></div></div></div><div id='method-isSpecialKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-isSpecialKey' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-isSpecialKey' class='name expandable'>isSpecialKey</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks if the key pressed was a \"special\" key ...</div><div class='long'><p>Checks if the key pressed was a \"special\" key</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the press is a special keypress</p>\n</div></li></ul></div></div></div><div id='method-preventDefault' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-preventDefault' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-preventDefault' class='name expandable'>preventDefault</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Prevents the browsers default handling of the event. ...</div><div class='long'><p>Prevents the browsers default handling of the event.</p>\n</div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-statics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n\n        return this;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-stopEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-stopEvent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-stopEvent' class='name expandable'>stopEvent</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Stop the event (preventDefault and stopPropagation) ...</div><div class='long'><p>Stop the event (preventDefault and stopPropagation)</p>\n</div></div></div><div id='method-stopPropagation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-stopPropagation' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-stopPropagation' class='name expandable'>stopPropagation</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Cancels bubbling of the event. ...</div><div class='long'><p>Cancels bubbling of the event.</p>\n</div></div></div><div id='method-within' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.EventObject' rel='Ext.EventObject' class='definedIn docClass'>Ext.EventObject</a><br/><a href='source/EventObject.html#Ext-EventObject-method-within' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.EventObject-method-within' class='name expandable'>within</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> related], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> allowEl]</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the target of this event is a child of el. ...</div><div class='long'><p>Returns true if the target of this event is a child of el.  Unless the allowEl parameter is set, it will return false if if the target is el.\nExample usage:</p>\n\n<pre><code>// Handle click on any child of an element\nExt.getBody().on('click', function(e){\n    if(e.within('some-el')){\n        alert('Clicked on a child of some-el!');\n    }\n});\n\n// Handle click directly on an element, ignoring clicks on child nodes\nExt.getBody().on('click', function(e,t){\n    if((t.id == 'some-el') && !e.within(t, true)){\n        alert('Clicked directly on some-el!');\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The id, DOM element or <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> to check</p>\n</div></li><li><span class='pre'>related</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to test if the related target is within el instead of the target</p>\n</div></li><li><span class='pre'>allowEl</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to also check if the passed element is the target or related target</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{},"requires":[],"deprecated":null,"extends":"Ext.Base","inheritable":false,"static":false,"superclasses":["Ext.Base","Ext.EventObject"],"singleton":true,"code_type":"ext_define","alias":null,"statics":{"property":[],"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[]},"subclasses":[],"uses":["Ext.util.Point"],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"A","id":"property-A"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"ALT","id":"property-ALT"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"B","id":"property-B"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"BACKSPACE","id":"property-BACKSPACE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"C","id":"property-C"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"CAPS_LOCK","id":"property-CAPS_LOCK"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"CONTEXT_MENU","id":"property-CONTEXT_MENU"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"CTRL","id":"property-CTRL"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"D","id":"property-D"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"DELETE","id":"property-DELETE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"DOWN","id":"property-DOWN"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"E","id":"property-E"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"EIGHT","id":"property-EIGHT"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"END","id":"property-END"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"ENTER","id":"property-ENTER"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"ESC","id":"property-ESC"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F","id":"property-F"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F1","id":"property-F1"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F10","id":"property-F10"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F11","id":"property-F11"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F12","id":"property-F12"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F2","id":"property-F2"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F3","id":"property-F3"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F4","id":"property-F4"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F5","id":"property-F5"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F6","id":"property-F6"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F7","id":"property-F7"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F8","id":"property-F8"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"F9","id":"property-F9"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"FIVE","id":"property-FIVE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"FOUR","id":"property-FOUR"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"G","id":"property-G"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"H","id":"property-H"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"HOME","id":"property-HOME"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"I","id":"property-I"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"INSERT","id":"property-INSERT"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"J","id":"property-J"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"K","id":"property-K"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"L","id":"property-L"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"LEFT","id":"property-LEFT"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"M","id":"property-M"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"N","id":"property-N"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NINE","id":"property-NINE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_CENTER","id":"property-NUM_CENTER"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_DIVISION","id":"property-NUM_DIVISION"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_EIGHT","id":"property-NUM_EIGHT"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_FIVE","id":"property-NUM_FIVE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_FOUR","id":"property-NUM_FOUR"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_MINUS","id":"property-NUM_MINUS"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_MULTIPLY","id":"property-NUM_MULTIPLY"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_NINE","id":"property-NUM_NINE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_ONE","id":"property-NUM_ONE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_PERIOD","id":"property-NUM_PERIOD"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_PLUS","id":"property-NUM_PLUS"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_SEVEN","id":"property-NUM_SEVEN"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_SIX","id":"property-NUM_SIX"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_THREE","id":"property-NUM_THREE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_TWO","id":"property-NUM_TWO"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"NUM_ZERO","id":"property-NUM_ZERO"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"O","id":"property-O"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"ONE","id":"property-ONE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"P","id":"property-P"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"PAGE_DOWN","id":"property-PAGE_DOWN"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"PAGE_UP","id":"property-PAGE_UP"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"PAUSE","id":"property-PAUSE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"PRINT_SCREEN","id":"property-PRINT_SCREEN"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"Q","id":"property-Q"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"R","id":"property-R"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"RETURN","id":"property-RETURN"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"RIGHT","id":"property-RIGHT"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"S","id":"property-S"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"SEVEN","id":"property-SEVEN"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"SHIFT","id":"property-SHIFT"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"SIX","id":"property-SIX"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"SPACE","id":"property-SPACE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"T","id":"property-T"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"TAB","id":"property-TAB"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"THREE","id":"property-THREE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"TWO","id":"property-TWO"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"U","id":"property-U"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"UP","id":"property-UP"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"V","id":"property-V"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"W","id":"property-W"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"WHEEL_SCALE","id":"property-WHEEL_SCALE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"X","id":"property-X"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"Y","id":"property-Y"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"Z","id":"property-Z"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.EventObject","template":null,"required":null,"protected":false,"name":"ZERO","id":"property-ZERO"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Base","template":null,"required":null,"protected":true,"name":"self","id":"property-self"}],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callOverridden","id":"method-callOverridden"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callParent","id":"method-callParent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"correctWheelDelta","id":"method-correctWheelDelta"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getCharCode","id":"method-getCharCode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getKey","id":"method-getKey"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Replaced by <a href=\"#!/api/Ext.EventObject-method-getX\" rel=\"Ext.EventObject-method-getX\" class=\"docClass\">getX</a></p>\n","version":"4.0"},"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getPageX","id":"method-getPageX"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Replaced by <a href=\"#!/api/Ext.EventObject-method-getY\" rel=\"Ext.EventObject-method-getY\" class=\"docClass\">getY</a></p>\n","version":"4.0"},"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getPageY","id":"method-getPageY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getPoint","id":"method-getPoint"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getRelatedTarget","id":"method-getRelatedTarget"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getTarget","id":"method-getTarget"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getWheelDelta","id":"method-getWheelDelta"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getWheelDeltas","id":"method-getWheelDeltas"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getX","id":"method-getX"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getXY","id":"method-getXY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"getY","id":"method-getY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"hasModifier","id":"method-hasModifier"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"initConfig","id":"method-initConfig"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"injectEvent","id":"method-injectEvent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"isNavKeyPress","id":"method-isNavKeyPress"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"isSpecialKey","id":"method-isSpecialKey"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"preventDefault","id":"method-preventDefault"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"statics","id":"method-statics"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"stopEvent","id":"method-stopEvent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"stopPropagation","id":"method-stopPropagation"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.EventObject","template":false,"required":null,"protected":false,"name":"within","id":"method-within"}],"event":[]},"private":false,"component":false,"name":"Ext.EventObject","alternateClassNames":[],"id":"class-Ext.EventObject","mixedInto":[],"xtypes":{},"files":[{"href":"EventObject.html#Ext-EventObject","filename":"EventObject.js"}]});