Ext.data.JsonP.Ext_form_Labelable({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><strong>Ext.form.Labelable</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/Ext.XTemplate' rel='Ext.XTemplate' class='docClass'>Ext.XTemplate</a></div><h4>Files</h4><div class='dependency'><a href='source/Labelable.html#Ext-form-Labelable' target='_blank'>Labelable.js</a></div></pre><div class='doc-contents'><p>A mixin which allows a component to be configured and decorated with a label and/or error message as is\ncommon for form fields. This is used by e.g. <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> and <a href=\"#!/api/Ext.form.FieldContainer\" rel=\"Ext.form.FieldContainer\" class=\"docClass\">Ext.form.FieldContainer</a>\nto let them be managed by the Field layout.</p>\n\n<p>NOTE: This mixin is mainly for internal library use and most users should not need to use it directly. It\nis more likely you will want to use one of the component classes that import this mixin, such as\n<a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> or <a href=\"#!/api/Ext.form.FieldContainer\" rel=\"Ext.form.FieldContainer\" class=\"docClass\">Ext.form.FieldContainer</a>.</p>\n\n<p>Use of this mixin does not make a component a field in the logical sense, meaning it does not provide any\nlogic or state related to values or validation; that is handled by the related <a href=\"#!/api/Ext.form.field.Field\" rel=\"Ext.form.field.Field\" class=\"docClass\">Ext.form.field.Field</a>\nmixin. These two mixins may be used separately (for example <a href=\"#!/api/Ext.form.FieldContainer\" rel=\"Ext.form.FieldContainer\" class=\"docClass\">Ext.form.FieldContainer</a> is Labelable but not a\nField), or in combination (for example <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> implements both and has logic for connecting the\ntwo.)</p>\n\n<p>Component classes which use this mixin should use the Field layout\nor a derivation thereof to properly size and position the label and message according to the component config.\nThey must also call the <a href=\"#!/api/Ext.form.Labelable-method-initLabelable\" rel=\"Ext.form.Labelable-method-initLabelable\" class=\"docClass\">initLabelable</a> method during component initialization to ensure the mixin gets\nset up correctly.</p>\n</div><div class='members'><div id='m-cfg'><div class='definedBy'>Defined By</div><h3 class='members-title'>Config options</h3><div class='subsection'><div id='cfg-activeError' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-activeError' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-activeError' class='name expandable'>activeError</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>If specified, then the component will be displayed with this value as its active error when\nfirst rendered. ...</div><div class='long'><p>If specified, then the component will be displayed with this value as its active error when\nfirst rendered. Use <a href=\"#!/api/Ext.form.Labelable-method-setActiveError\" rel=\"Ext.form.Labelable-method-setActiveError\" class=\"docClass\">setActiveError</a> or <a href=\"#!/api/Ext.form.Labelable-method-unsetActiveError\" rel=\"Ext.form.Labelable-method-unsetActiveError\" class=\"docClass\">unsetActiveError</a> to\nchange it after component creation.</p>\n</div></div></div><div id='cfg-activeErrorsTpl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-activeErrorsTpl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-activeErrorsTpl' class='name expandable'>activeErrorsTpl</a><span> : <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a></span></div><div class='description'><div class='short'>The template used to format the Array of error messages passed to setActiveErrors\ninto a single HTML string. ...</div><div class='long'><p>The template used to format the Array of error messages passed to <a href=\"#!/api/Ext.form.Labelable-method-setActiveErrors\" rel=\"Ext.form.Labelable-method-setActiveErrors\" class=\"docClass\">setActiveErrors</a>\ninto a single HTML string. By default this renders each message as an item in an unordered list.</p>\n<p>Defaults to: <code>[&quot;&lt;tpl if=&quot;errors &amp;&amp; errors.length&quot;&gt;&quot;, &quot;&lt;ul&gt;&lt;tpl for=&quot;errors&quot;&gt;&lt;li&lt;tpl if=&quot;xindex == xcount&quot;&gt; class=&quot;last&quot;&lt;/tpl&gt;&gt;{.}&lt;/li&gt;&lt;/tpl&gt;&lt;/ul&gt;&quot;, &quot;&lt;/tpl&gt;&quot;]</code></p></div></div></div><div id='cfg-autoFitErrors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-autoFitErrors' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-autoFitErrors' class='name expandable'>autoFitErrors</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Whether to adjust the component's body area to make room for 'side' or 'under'\nerror messages. ...</div><div class='long'><p>Whether to adjust the component's body area to make room for 'side' or 'under'\n<a href=\"#!/api/Ext.form.Labelable-cfg-msgTarget\" rel=\"Ext.form.Labelable-cfg-msgTarget\" class=\"docClass\">error messages</a>.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-baseBodyCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-baseBodyCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-baseBodyCls' class='name expandable'>baseBodyCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class to be applied to the body content element. ...</div><div class='long'><p>The CSS class to be applied to the body content element.</p>\n<p>Defaults to: <code>&quot;x-form-item-body&quot;</code></p></div></div></div><div id='cfg-clearCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-clearCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-clearCls' class='name expandable'>clearCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class to be applied to the special clearing div rendered directly after the field\ncontents wrapper to provide...</div><div class='long'><p>The CSS class to be applied to the special clearing div rendered directly after the field\ncontents wrapper to provide field clearing.</p>\n<p>Defaults to: <code>&quot;x-clear&quot;</code></p></div></div></div><div id='cfg-errorMsgCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-errorMsgCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-errorMsgCls' class='name expandable'>errorMsgCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class to be applied to the error message element. ...</div><div class='long'><p>The CSS class to be applied to the error message element.</p>\n<p>Defaults to: <code>&quot;x-form-error-msg&quot;</code></p></div></div></div><div id='cfg-fieldBodyCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-fieldBodyCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-fieldBodyCls' class='name expandable'>fieldBodyCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An extra CSS class to be applied to the body content element in addition to fieldBodyCls. ...</div><div class='long'><p>An extra CSS class to be applied to the body content element in addition to <a href=\"#!/api/Ext.form.Labelable-cfg-fieldBodyCls\" rel=\"Ext.form.Labelable-cfg-fieldBodyCls\" class=\"docClass\">fieldBodyCls</a>.</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='cfg-fieldLabel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-fieldLabel' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-fieldLabel' class='name expandable'>fieldLabel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The label for the field. ...</div><div class='long'><p>The label for the field. It gets appended with the <a href=\"#!/api/Ext.form.Labelable-cfg-labelSeparator\" rel=\"Ext.form.Labelable-cfg-labelSeparator\" class=\"docClass\">labelSeparator</a>, and its position\nand sizing is determined by the <a href=\"#!/api/Ext.form.Labelable-cfg-labelAlign\" rel=\"Ext.form.Labelable-cfg-labelAlign\" class=\"docClass\">labelAlign</a>, <a href=\"#!/api/Ext.form.Labelable-cfg-labelWidth\" rel=\"Ext.form.Labelable-cfg-labelWidth\" class=\"docClass\">labelWidth</a>, and <a href=\"#!/api/Ext.form.Labelable-cfg-labelPad\" rel=\"Ext.form.Labelable-cfg-labelPad\" class=\"docClass\">labelPad</a>\nconfigs.</p>\n</div></div></div><div id='cfg-formItemCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-formItemCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-formItemCls' class='name expandable'>formItemCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A CSS class to be applied to the outermost element to denote that it is participating in the form\nfield layout. ...</div><div class='long'><p>A CSS class to be applied to the outermost element to denote that it is participating in the form\nfield layout.</p>\n<p>Defaults to: <code>&quot;x-form-item&quot;</code></p></div></div></div><div id='cfg-hideEmptyLabel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-hideEmptyLabel' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-hideEmptyLabel' class='name expandable'>hideEmptyLabel</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>When set to true, the label element (fieldLabel and labelSeparator) will be\nautomatically hidden if the fieldLabel is...</div><div class='long'><p>When set to <tt>true</tt>, the label element (<a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a> and <a href=\"#!/api/Ext.form.Labelable-cfg-labelSeparator\" rel=\"Ext.form.Labelable-cfg-labelSeparator\" class=\"docClass\">labelSeparator</a>) will be\nautomatically hidden if the <a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a> is empty. Setting this to <tt>false</tt> will cause the empty\nlabel element to be rendered and space to be reserved for it; this is useful if you want a field without a label\nto line up with other labeled fields in the same form.</p>\n\n\n<p>If you wish to unconditionall hide the label even if a non-empty fieldLabel is configured, then set\nthe <a href=\"#!/api/Ext.form.Labelable-cfg-hideLabel\" rel=\"Ext.form.Labelable-cfg-hideLabel\" class=\"docClass\">hideLabel</a> config to <tt>true</tt>.</p>\n\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-hideLabel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-hideLabel' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-hideLabel' class='name expandable'>hideLabel</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Set to true to completely hide the label element (fieldLabel and labelSeparator). ...</div><div class='long'><p>Set to true to completely hide the label element (<a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a> and <a href=\"#!/api/Ext.form.Labelable-cfg-labelSeparator\" rel=\"Ext.form.Labelable-cfg-labelSeparator\" class=\"docClass\">labelSeparator</a>).\nAlso see <a href=\"#!/api/Ext.form.Labelable-cfg-hideEmptyLabel\" rel=\"Ext.form.Labelable-cfg-hideEmptyLabel\" class=\"docClass\">hideEmptyLabel</a>, which controls whether space will be reserved for an empty fieldLabel.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-invalidCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-invalidCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-invalidCls' class='name expandable'>invalidCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class to use when marking the component invalid. ...</div><div class='long'><p>The CSS class to use when marking the component invalid.</p>\n<p>Defaults to: <code>&quot;x-form-invalid&quot;</code></p></div></div></div><div id='cfg-labelAlign' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-labelAlign' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-labelAlign' class='name expandable'>labelAlign</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Controls the position and alignment of the fieldLabel. ...</div><div class='long'><p>Controls the position and alignment of the <a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a>. Valid values are:</p>\n\n\n<ul>\n<li><tt>\"left\"</tt> (the default) - The label is positioned to the left of the field, with its text\naligned to the left. Its width is determined by the <a href=\"#!/api/Ext.form.Labelable-cfg-labelWidth\" rel=\"Ext.form.Labelable-cfg-labelWidth\" class=\"docClass\">labelWidth</a> config.</li>\n<li><tt>\"top\"</tt> - The label is positioned above the field.</li>\n<li><tt>\"right\"</tt> - The label is positioned to the left of the field, with its text aligned\nto the right. Its width is determined by the <a href=\"#!/api/Ext.form.Labelable-cfg-labelWidth\" rel=\"Ext.form.Labelable-cfg-labelWidth\" class=\"docClass\">labelWidth</a> config.</li>\n</ul>\n\n<p>Defaults to: <code>&quot;left&quot;</code></p></div></div></div><div id='cfg-labelCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-labelCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-labelCls' class='name expandable'>labelCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class to be applied to the label element. ...</div><div class='long'><p>The CSS class to be applied to the label element.\nThis (single) CSS class is used to formulate the renderSelector and drives the field\nlayout where it is concatenated with a hyphen ('-') and <a href=\"#!/api/Ext.form.Labelable-cfg-labelAlign\" rel=\"Ext.form.Labelable-cfg-labelAlign\" class=\"docClass\">labelAlign</a>. To add\nadditional classes, use <a href=\"#!/api/Ext.form.Labelable-cfg-labelClsExtra\" rel=\"Ext.form.Labelable-cfg-labelClsExtra\" class=\"docClass\">labelClsExtra</a>.</p>\n<p>Defaults to: <code>&quot;x-form-item-label&quot;</code></p></div></div></div><div id='cfg-labelClsExtra' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-labelClsExtra' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-labelClsExtra' class='name expandable'>labelClsExtra</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional string of one or more additional CSS classes to add to the label element. ...</div><div class='long'><p>An optional string of one or more additional CSS classes to add to the label element.\nDefaults to empty.</p>\n</div></div></div><div id='cfg-labelPad' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-labelPad' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-labelPad' class='name expandable'>labelPad</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The amount of space in pixels between the fieldLabel and the input field. ...</div><div class='long'><p>The amount of space in pixels between the <a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a> and the input field.</p>\n<p>Defaults to: <code>5</code></p></div></div></div><div id='cfg-labelSeparator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-labelSeparator' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-labelSeparator' class='name expandable'>labelSeparator</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Character(s) to be inserted at the end of the label text. ...</div><div class='long'><p>Character(s) to be inserted at the end of the <a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">label text</a>.</p>\n<p>Defaults to: <code>&quot;:&quot;</code></p></div></div></div><div id='cfg-labelStyle' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-labelStyle' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-labelStyle' class='name not-expandable'>labelStyle</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>A CSS style specification string to apply directly to this field's label.</p>\n</div><div class='long'><p>A CSS style specification string to apply directly to this field's label.</p>\n</div></div></div><div id='cfg-labelWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-labelWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-labelWidth' class='name expandable'>labelWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The width of the fieldLabel in pixels. ...</div><div class='long'><p>The width of the <a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a> in pixels. Only applicable if the <a href=\"#!/api/Ext.form.Labelable-cfg-labelAlign\" rel=\"Ext.form.Labelable-cfg-labelAlign\" class=\"docClass\">labelAlign</a> is set\nto \"left\" or \"right\".</p>\n<p>Defaults to: <code>100</code></p></div></div></div><div id='cfg-labelableRenderTpl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-labelableRenderTpl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-labelableRenderTpl' class='name expandable'>labelableRenderTpl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]/<a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a></span></div><div class='description'><div class='short'>The rendering template for the field decorations. ...</div><div class='long'><p>The rendering template for the field decorations. Component classes using this mixin should include\nlogic to use this as their <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a>, and implement the\n<a href=\"#!/api/Ext.form.Labelable-method-getSubTplMarkup\" rel=\"Ext.form.Labelable-method-getSubTplMarkup\" class=\"docClass\">getSubTplMarkup</a> method to generate the field body content.</p>\n<p>Defaults to: <code>[&quot;&lt;tpl if=&quot;!hideLabel &amp;&amp; !(!fieldLabel &amp;&amp; hideEmptyLabel)&quot;&gt;&quot;, &quot;&lt;label id=&quot;{id}-labelEl&quot;&lt;tpl if=&quot;inputId&quot;&gt; for=&quot;{inputId}&quot;&lt;/tpl&gt; class=&quot;{labelCls}&quot;&quot;, &quot;&lt;tpl if=&quot;labelStyle&quot;&gt; style=&quot;{labelStyle}&quot;&lt;/tpl&gt;&gt;&quot;, &quot;&lt;tpl if=&quot;fieldLabel&quot;&gt;{fieldLabel}{labelSeparator}&lt;/tpl&gt;&quot;, &quot;&lt;/label&gt;&quot;, &quot;&lt;/tpl&gt;&quot;, &quot;&lt;div class=&quot;{baseBodyCls} {fieldBodyCls}&quot; id=&quot;{id}-bodyEl&quot; role=&quot;presentation&quot;&gt;{subTplMarkup}&lt;/div&gt;&quot;, &quot;&lt;div id=&quot;{id}-errorEl&quot; class=&quot;{errorMsgCls}&quot; style=&quot;display:none&quot;&gt;&lt;/div&gt;&quot;, &quot;&lt;div class=&quot;{clearCls}&quot; role=&quot;presentation&quot;&gt;&lt;!-- --&gt;&lt;/div&gt;&quot;, {compiled: true, disableFormats: true}]</code></p></div></div></div><div id='cfg-msgTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-msgTarget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-msgTarget' class='name expandable'>msgTarget</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The location where the error message text should display. ...</div><div class='long'><p>The location where the error message text should display.\nMust be one of the following values:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><code>qtip</code> Display a quick tip containing the message when the user hovers over the field. This is the default.\n<div class=\"subdesc\"><b><a href=\"#!/api/Ext.tip.QuickTipManager-method-init\" rel=\"Ext.tip.QuickTipManager-method-init\" class=\"docClass\">Ext.tip.QuickTipManager.init</a> must have been called for this setting to work.</b></div></li>\n<li><code>title</code> Display the message in a default browser title attribute popup.</li>\n<li><code>under</code> Add a block div beneath the field containing the error message.</li>\n<li><code>side</code> Add an error icon to the right of the field, displaying the message in a popup on hover.</li>\n<li><code>none</code> Don't display any error message. This might be useful if you are implementing custom error display.</li>\n<li><code>[element id]</code> Add the error message directly to the innerHTML of the specified element.</li>\n</ul></div>\n\n<p>Defaults to: <code>&quot;qtip&quot;</code></p></div></div></div><div id='cfg-preventMark' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-cfg-preventMark' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-cfg-preventMark' class='name expandable'>preventMark</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>true to disable displaying any error message set on this object. ...</div><div class='long'><p><tt>true</tt> to disable displaying any <a href=\"#!/api/Ext.form.Labelable-method-setActiveError\" rel=\"Ext.form.Labelable-method-setActiveError\" class=\"docClass\">error message</a> set on this object.</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div id='m-property'><div class='definedBy'>Defined By</div><h3 class='members-title'>Properties</h3><div class='subsection'><div id='property-bodyEl' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-property-bodyEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-property-bodyEl' class='name expandable'>bodyEl</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The div Element wrapping the component's contents. ...</div><div class='long'><p>The div Element wrapping the component's contents. Only available after the component has been rendered.</p>\n</div></div></div><div id='property-errorEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-property-errorEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-property-errorEl' class='name expandable'>errorEl</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The div Element that will contain the component's error message(s). ...</div><div class='long'><p>The div Element that will contain the component's error message(s). Note that depending on the\nconfigured <a href=\"#!/api/Ext.form.Labelable-cfg-msgTarget\" rel=\"Ext.form.Labelable-cfg-msgTarget\" class=\"docClass\">msgTarget</a>, this element may be hidden in favor of some other form of\npresentation, but will always be present in the DOM for use by assistive technologies.</p>\n</div></div></div><div id='property-isFieldLabelable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-property-isFieldLabelable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-property-isFieldLabelable' class='name expandable'>isFieldLabelable</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Flag denoting that this object is labelable as a field. ...</div><div class='long'><p>Flag denoting that this object is labelable as a field. Always true.</p>\n</div></div></div><div id='property-labelEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-property-labelEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-property-labelEl' class='name expandable'>labelEl</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The label Element for this component. ...</div><div class='long'><p>The label Element for this component. Only available after the component has been rendered.</p>\n</div></div></div><div id='property-self' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-property-self' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependent on 'this'\n\n        return this;\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div></div></div><div id='m-method'><h3 class='members-title'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-callOverridden' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callOverridden' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result after calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the parent's overridden method. ...</div><div class='long'><p>Call the parent's overridden method. For example:</p>\n\n<pre><code>Ext.define('My.own.A', {\n    constructor: function(test) {\n        alert(test);\n    }\n});\n\nExt.define('My.own.B', {\n    extend: 'My.own.A',\n\n    constructor: function(test) {\n        alert(test);\n\n        this.callParent([test + 1]);\n    }\n});\n\nExt.define('My.own.C', {\n    extend: 'My.own.B',\n\n    constructor: function() {\n        alert(\"Going to call parent's overriden constructor...\");\n\n        this.callParent(arguments);\n    }\n});\n\nvar a = new My.own.A(1); // alerts '1'\nvar b = new My.own.B(1); // alerts '1', then alerts '2'\nvar c = new My.own.C(2); // alerts \"Going to call parent's overriden constructor...\"\n                         // alerts '2', then alerts '3'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result from the superclass' method</p>\n</div></li></ul></div></div></div><div id='method-getActiveError' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-getActiveError' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-getActiveError' class='name expandable'>getActiveError</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Gets the active error message for this component, if any. ...</div><div class='long'><p>Gets the active error message for this component, if any. This does not trigger\nvalidation on its own, it merely returns any message that the component may already hold.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The active error message on the component; if there is no error, an empty string is returned.</p>\n</div></li></ul></div></div></div><div id='method-getActiveErrors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-getActiveErrors' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-getActiveErrors' class='name expandable'>getActiveErrors</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</div><div class='description'><div class='short'>Gets an Array of any active error messages currently applied to the field. ...</div><div class='long'><p>Gets an Array of any active error messages currently applied to the field. This does not trigger\nvalidation on its own, it merely returns any messages that the component may already hold.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span><div class='sub-desc'><p>The active error messages on the component; if there are no errors, an empty Array is returned.</p>\n</div></li></ul></div></div></div><div id='method-getBodyNaturalWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-getBodyNaturalWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-getBodyNaturalWidth' class='name expandable'>getBodyNaturalWidth</a>( <span class='pre'></span> )<strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Calculate and return the natural width of the bodyEl. ...</div><div class='long'><p>Calculate and return the natural width of the bodyEl. Override to provide custom logic.\nNote for implementors: if at all possible this method should be overridden with a custom implementation\nthat can avoid anything that would cause the browser to reflow, e.g. querying offsetWidth.</p>\n</div></div></div><div id='method-getFieldLabel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-getFieldLabel' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-getFieldLabel' class='name expandable'>getFieldLabel</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the label for the field. ...</div><div class='long'><p>Returns the label for the field. Defaults to simply returning the <a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a> config. Can be\noverridden to provide</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The configured field label, or empty string if not defined</p>\n</div></li></ul></div></div></div><div id='method-getInputId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-getInputId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-getInputId' class='name expandable'>getInputId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the input id, if any, for this component. ...</div><div class='long'><p>Get the input id, if any, for this component. This is used as the \"for\" attribute on the label element.\nImplementing subclasses may also use this as e.g. the id for their own <tt>input</tt> element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The input id</p>\n</div></li></ul></div></div></div><div id='method-getLabelableRenderData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-getLabelableRenderData' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-getLabelableRenderData' class='name expandable'>getLabelableRenderData</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Generates the arguments for the field decorations rendering template. ...</div><div class='long'><p>Generates the arguments for the field decorations <a href=\"#!/api/Ext.form.Labelable-cfg-labelableRenderTpl\" rel=\"Ext.form.Labelable-cfg-labelableRenderTpl\" class=\"docClass\">rendering template</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The template arguments</p>\n</div></li></ul></div></div></div><div id='method-getSubTplMarkup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-getSubTplMarkup' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-getSubTplMarkup' class='name expandable'>getSubTplMarkup</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Gets the markup to be inserted into the outer template's bodyEl. ...</div><div class='long'><p>Gets the markup to be inserted into the outer template's bodyEl. Defaults to empty string, should\nbe implemented by classes including this mixin as needed.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The markup to be inserted</p>\n</div></li></ul></div></div></div><div id='method-hasActiveError' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-hasActiveError' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-hasActiveError' class='name expandable'>hasActiveError</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Tells whether the field currently has an active error message. ...</div><div class='long'><p>Tells whether the field currently has an active error message. This does not trigger\nvalidation on its own, it merely looks for any message that the component may already hold.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-initConfig' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code>Ext.define('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n\n        return this;\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-initLabelable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-initLabelable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-initLabelable' class='name expandable'>initLabelable</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Performs initialization of this mixin. ...</div><div class='long'><p>Performs initialization of this mixin. Component classes using this mixin should call this method\nduring their own initialization.</p>\n</div></div></div><div id='method-setActiveError' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-setActiveError' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-setActiveError' class='name expandable'>setActiveError</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> msg</span> )</div><div class='description'><div class='short'>Sets the active error message to the given string. ...</div><div class='long'><p>Sets the active error message to the given string. This replaces the entire error message\ncontents with the given string. Also see <a href=\"#!/api/Ext.form.Labelable-method-setActiveErrors\" rel=\"Ext.form.Labelable-method-setActiveErrors\" class=\"docClass\">setActiveErrors</a> which accepts an Array of\nmessages and formats them according to the <a href=\"#!/api/Ext.form.Labelable-cfg-activeErrorsTpl\" rel=\"Ext.form.Labelable-cfg-activeErrorsTpl\" class=\"docClass\">activeErrorsTpl</a>.</p>\n\n<p>Note that this only updates the error message element's text and attributes, you'll have\nto call doComponentLayout to actually update the field's layout to match. If the field extends\n<a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> you should call <a href=\"#!/api/Ext.form.field.Base-method-markInvalid\" rel=\"Ext.form.field.Base-method-markInvalid\" class=\"docClass\">markInvalid</a> instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The error message</p>\n</div></li></ul></div></div></div><div id='method-setActiveErrors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-setActiveErrors' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-setActiveErrors' class='name expandable'>setActiveErrors</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] errors</span> )</div><div class='description'><div class='short'>Set the active error message to an Array of error messages. ...</div><div class='long'><p>Set the active error message to an Array of error messages. The messages are formatted into\na single message string using the <a href=\"#!/api/Ext.form.Labelable-cfg-activeErrorsTpl\" rel=\"Ext.form.Labelable-cfg-activeErrorsTpl\" class=\"docClass\">activeErrorsTpl</a>. Also see <a href=\"#!/api/Ext.form.Labelable-method-setActiveError\" rel=\"Ext.form.Labelable-method-setActiveError\" class=\"docClass\">setActiveError</a>\nwhich allows setting the entire error contents with a single string.</p>\n\n<p>Note that this only updates the error message element's text and attributes, you'll have\nto call doComponentLayout to actually update the field's layout to match. If the field extends\n<a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> you should call <a href=\"#!/api/Ext.form.field.Base-method-markInvalid\" rel=\"Ext.form.field.Base-method-markInvalid\" class=\"docClass\">markInvalid</a> instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>errors</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The error messages</p>\n</div></li></ul></div></div></div><div id='method-setFieldDefaults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-setFieldDefaults' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-setFieldDefaults' class='name expandable'>setFieldDefaults</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> defaults</span> )</div><div class='description'><div class='short'>Applies a set of default configuration values to this Labelable instance. ...</div><div class='long'><p>Applies a set of default configuration values to this Labelable instance. For each of the\nproperties in the given object, check if this component hasOwnProperty that config; if not\nthen it's inheriting a default value from its prototype and we should apply the default value.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>defaults</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The defaults to apply to the object.</p>\n</div></li></ul></div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-statics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n\n        return this;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-unsetActiveError' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-method-unsetActiveError' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-method-unsetActiveError' class='name expandable'>unsetActiveError</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Clears the active error message(s). ...</div><div class='long'><p>Clears the active error message(s).</p>\n\n<p>Note that this only clears the error message element's text and attributes, you'll have\nto call doComponentLayout to actually update the field's layout to match. If the field extends\n<a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> you should call <a href=\"#!/api/Ext.form.field.Base-method-clearInvalid\" rel=\"Ext.form.field.Base-method-clearInvalid\" class=\"docClass\">clearInvalid</a> instead.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-addStatics' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-addStatics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-addStatics' class='name expandable'>addStatics</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add / override static properties of this class. ...</div><div class='long'><p>Add / override static properties of this class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-borrow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-borrow' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-borrow' class='name expandable'>borrow</a>( <span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a> fromClass, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Borrow another class' members to the prototype of this class. ...</div><div class='long'><p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code>Ext.define('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\nExt.define('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromClass</span> : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><div class='sub-desc'><p>The class to borrow members from</p>\n</div></li><li><span class='pre'>members</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The names of the members to borrow</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-create' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-create' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-create' class='name expandable'>create</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create a new instance of this Class. ...</div><div class='long'><p>Create a new instance of this Class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the created instance.</p>\n</div></li></ul></div></div></div><div id='static-method-createAlias' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-createAlias' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-createAlias' class='name expandable'>createAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> alias, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> origin</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create aliases for existing prototype methods. ...</div><div class='long'><p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new method name, or an object to set multiple aliases. See\n<a href=\"#!/api/Ext.Function-method-flexSetter\" rel=\"Ext.Function-method-flexSetter\" class=\"docClass\">flexSetter</a></p>\n</div></li><li><span class='pre'>origin</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The original method name</p>\n</div></li></ul></div></div></div><div id='static-method-getName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-getName' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Get the current class' name in string format. ...</div><div class='long'><p>Get the current class' name in string format.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='static-method-implement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-implement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-implement' class='name expandable'>implement</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add methods / properties to the prototype of this class. ...</div><div class='long'><p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code>Ext.define('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.implement({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-override' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-override' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-override' class='name expandable'>override</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Override prototype members of this class. ...</div><div class='long'><p>Override prototype members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callOverridden\" rel=\"Ext.Base-method-callOverridden\" class=\"docClass\">callOverridden</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div><div id='m-event'><div class='definedBy'>Defined By</div><h3 class='members-title'>Events</h3><div class='subsection'><div id='event-errorchange' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.form.Labelable' rel='Ext.form.Labelable' class='definedIn docClass'>Ext.form.Labelable</a><br/><a href='source/Labelable.html#Ext-form-Labelable-event-errorchange' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.form.Labelable-event-errorchange' class='name expandable'>errorchange</a>( <span class='pre'><a href=\"#!/api/Ext.form.Labelable\" rel=\"Ext.form.Labelable\" class=\"docClass\">Ext.form.Labelable</a> this, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> error, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when the active error message is changed via setActiveError. ...</div><div class='long'><p>Fires when the active error message is changed via <a href=\"#!/api/Ext.form.Labelable-method-setActiveError\" rel=\"Ext.form.Labelable-method-setActiveError\" class=\"docClass\">setActiveError</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.form.Labelable\" rel=\"Ext.form.Labelable\" class=\"docClass\">Ext.form.Labelable</a><div class='sub-desc'>\n</div></li><li><span class='pre'>error</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The active error message</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{"docauthor":["Jason Johnston <jason@sencha.com>"]},"requires":["Ext.XTemplate"],"deprecated":null,"extends":"Ext.Base","inheritable":false,"static":false,"superclasses":["Ext.Base","Ext.form.Labelable"],"singleton":false,"code_type":"ext_define","alias":null,"statics":{"property":[],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"addStatics","id":"static-method-addStatics"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"borrow","id":"static-method-borrow"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"create","id":"static-method-create"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"createAlias","id":"static-method-createAlias"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"getName","id":"static-method-getName"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"implement","id":"static-method-implement"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"override","id":"static-method-override"}],"event":[]},"subclasses":[],"uses":[],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":null,"protected":false,"name":"bodyEl","id":"property-bodyEl"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":null,"protected":false,"name":"errorEl","id":"property-errorEl"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":null,"protected":false,"name":"isFieldLabelable","id":"property-isFieldLabelable"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":null,"protected":false,"name":"labelEl","id":"property-labelEl"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Base","template":null,"required":null,"protected":true,"name":"self","id":"property-self"}],"css_var":[],"css_mixin":[],"cfg":[{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"activeError","id":"cfg-activeError"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"activeErrorsTpl","id":"cfg-activeErrorsTpl"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"autoFitErrors","id":"cfg-autoFitErrors"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"baseBodyCls","id":"cfg-baseBodyCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"clearCls","id":"cfg-clearCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"errorMsgCls","id":"cfg-errorMsgCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"fieldBodyCls","id":"cfg-fieldBodyCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"fieldLabel","id":"cfg-fieldLabel"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"formItemCls","id":"cfg-formItemCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"hideEmptyLabel","id":"cfg-hideEmptyLabel"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"hideLabel","id":"cfg-hideLabel"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"invalidCls","id":"cfg-invalidCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"labelAlign","id":"cfg-labelAlign"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"labelCls","id":"cfg-labelCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"labelClsExtra","id":"cfg-labelClsExtra"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"labelPad","id":"cfg-labelPad"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"labelSeparator","id":"cfg-labelSeparator"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"labelStyle","id":"cfg-labelStyle"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"labelWidth","id":"cfg-labelWidth"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"labelableRenderTpl","id":"cfg-labelableRenderTpl"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"msgTarget","id":"cfg-msgTarget"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":false,"protected":false,"name":"preventMark","id":"cfg-preventMark"}],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callOverridden","id":"method-callOverridden"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callParent","id":"method-callParent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"getActiveError","id":"method-getActiveError"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"getActiveErrors","id":"method-getActiveErrors"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":true,"name":"getBodyNaturalWidth","id":"method-getBodyNaturalWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"getFieldLabel","id":"method-getFieldLabel"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"getInputId","id":"method-getInputId"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":true,"name":"getLabelableRenderData","id":"method-getLabelableRenderData"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":true,"name":"getSubTplMarkup","id":"method-getSubTplMarkup"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"hasActiveError","id":"method-hasActiveError"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"initConfig","id":"method-initConfig"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"initLabelable","id":"method-initLabelable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"setActiveError","id":"method-setActiveError"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"setActiveErrors","id":"method-setActiveErrors"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"setFieldDefaults","id":"method-setFieldDefaults"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"statics","id":"method-statics"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":false,"required":null,"protected":false,"name":"unsetActiveError","id":"method-unsetActiveError"}],"event":[{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.form.Labelable","template":null,"required":null,"protected":false,"name":"errorchange","id":"event-errorchange"}]},"private":false,"component":false,"name":"Ext.form.Labelable","alternateClassNames":[],"id":"class-Ext.form.Labelable","mixedInto":["Ext.form.field.Base","Ext.form.field.HtmlEditor","Ext.form.FieldContainer"],"xtypes":{},"files":[{"href":"Labelable.html#Ext-form-Labelable","filename":"Labelable.js"}]});