Ext.data.JsonP.theming({"title":"Theming","guide":"<h1>Theming</h1>\n<div class='toc'>\n<p><strong>Contents</strong></p>\n<ol>\n<li><a href='#!/guide/theming-section-1'>A Brief Introduction to SASS &amp; Compass</a></li>\n<li><a href='#!/guide/theming-section-2'>Requirements</a></li>\n<li><a href='#!/guide/theming-section-3'>Directory Structure</a></li>\n<li><a href='#!/guide/theming-section-4'>Compiling your CSS</a></li>\n<li><a href='#!/guide/theming-section-5'>Changing global SASS variables</a></li>\n<li><a href='#!/guide/theming-section-6'>View the Results</a></li>\n<li><a href='#!/guide/theming-section-7'>Component UIs</a></li>\n<li><a href='#!/guide/theming-section-8'>Supporting Legacy Browsers</a></li>\n<li><a href='#!/guide/theming-section-9'>FAQ</a></li>\n</ol>\n</div>\n\n<p>Ext JS 4 has a brand new theming system to customize the look of your application while still supporting all browsers.</p>\n\n<h2 id='theming-section-1'>A Brief Introduction to SASS &amp; Compass</h2>\n\n<p>SASS is a pre-processor which adds new syntax to CSS allowing for things like variables, mixins, nesting, and math/color functions. For example, in SASS we can write:</p>\n\n<pre><code>$blue: #3bbfce;\n$margin: 16px;\n\n.content-navigation {\n    border-color: $blue;\n    color: darken($blue, 9%);\n}\n\n.border {\n    padding: $margin / 2;\n    margin: $margin / 2;\n    border-color: $blue;\n}\n</code></pre>\n\n<p>And it will compile to:</p>\n\n<pre><code>.content-navigation {\n    border-color: #3bbfce;\n    color: #2b9eab;\n}\n\n.border {\n    padding: 8px;\n    margin: 8px;\n    border-color: #3bbfce;\n}\n</code></pre>\n\n<p>To see the wide variety of other features available in SASS, please see <a href=\"http://sass-lang.com/\">http://sass-lang.com/</a>. Compass extends SASS by adding a variety of CSS3 mixins and providing the extension system that Ext JS leverages. With Compass, one can include rules like:</p>\n\n<pre><code>$boxheight: 10em;\n\n.mybox {\n    @include border-radius($boxheight/4);\n}\n</code></pre>\n\n<p>Which compiles into:</p>\n\n<pre><code>.mybox {\n    -webkit-border-radius: 2.5em;\n    -moz-border-radius: 2.5em;\n    -o-border-radius: 2.5em;\n    -ms-border-radius: 2.5em;\n    -khtml-border-radius: 2.5em;\n    border-radius: 2.5em;\n}\n</code></pre>\n\n<p>You can learn more about the pre-included mixins with Compass and the other tools it provides here: <a href=\"http://compass-style.org/docs/\">http://compass-style.org/docs/</a>.</p>\n\n<h2 id='theming-section-2'>Requirements</h2>\n\n<h3>Ruby</h3>\n\n<h4>Mac OSX</h4>\n\n<p>XCode installs Ruby and all necessary dependencies to your Mac when installed.</p>\n\n<p>Xcode can be found on the Apple Developer Website: <a href=\"http://developer.apple.com/xcode/\">http://developer.apple.com/xcode/</a></p>\n\n<h4>Windows</h4>\n\n<p>Visit <a href=\"http://rubyinstaller.org/\">http://rubyinstaller.org/</a> and download the latest packaged version of Ruby (1.9.2 at the time of writing)</p>\n\n<h3>Compass/SASS gem</h3>\n\n<h4>Mac OSX</h4>\n\n<p>In <code>/Applications/Utilities/Terminal.app</code>, run the following code (you will be asked for your password):</p>\n\n<pre><code>sudo gem install compass\n</code></pre>\n\n<p>You can verify you have Compass and Sass installed by running the following in <code>Terminal.app</code>:</p>\n\n<pre><code>compass -v\n\nsass -v\n</code></pre>\n\n<p>At the time of writing, the latest version of Compass is <code>0.11.1 (Antares)</code>. The latest version of Sass is <code>3.1.1 (Brainy Betty)</code></p>\n\n<h4>Windows</h4>\n\n<p>Select <strong>Start Command Prompt with Ruby</strong> from the new Start Menu option.</p>\n\n<p>Type the following:</p>\n\n<pre><code>gem install compass\n</code></pre>\n\n<p>You can verify you have Compass and Sass installed by running the following in <strong>Terminal.app</strong>:</p>\n\n<pre><code>compass -v\nsass -v\n</code></pre>\n\n<p>At the time of writing, the latest version of Compass is <code>0.11.1 (Antares)</code>. The latest version of Sass is <code>3.1.1 (Brainy Betty)</code></p>\n\n<h2 id='theming-section-3'>Directory Structure</h2>\n\n<p>The Ext JS SDK comes with a template which can be used as a base for your new theme. If you followed the <a href=\"#/guide/getting_started\">Getting Started</a> guide, you should have a directory for your application with a subfolder <code>extjs</code> containing the Ext JS SDK. It should look something like this:</p>\n\n<pre><code>appname/\nappname/extjs/\nappname/app.js\nappname/index.html\n</code></pre>\n\n<p>Copy the template resources folder from <code>appname/extjs/resources/themes/templates/resource</code> to your root application folder:</p>\n\n<pre><code>appname/\nappname/resources/\nappname/resources/css/\nappname/resources/sass/\nappname/resources/sass/config.rb\nappname/resources/sass/my-ext-theme.sass\n</code></pre>\n\n<p>You will also need to copy the images from <code>appname/extjs/resources/themes/images/default</code> to <code>appname/resources/images</code>.</p>\n\n<p>Ensure the path to your Ext JS folder is correct in <code>appname/resources/sass/config.rb</code>:</p>\n\n<pre><code># $ext_path: This should be the path of the Ext JS SDK relative to this file\n$ext_path = \"../../extjs\"\n</code></pre>\n\n<p>Due to a bug in Ext JS 4.0.2a you will also need to edit line 62 of <code>appname/extjs/resources/themes/lib/utils.rb</code> from this:</p>\n\n<pre><code>images_path = File.join($ext_path, 'resources', 'themes', 'images', theme)\n</code></pre>\n\n<p>to this:</p>\n\n<pre><code>images_path = relative_path\n</code></pre>\n\n<p>This ensures images will be served from <code>appname/resources/images</code> rather than <code>appname/extjs/resources/images</code></p>\n\n<h2 id='theming-section-4'>Compiling your CSS</h2>\n\n<p>Compiling your CSS is a simple process using Compass.</p>\n\n<p>First, change to your sass directory in <code>appname/resources/sass</code>, then run the following command in <strong>Terminal.app on Mac OSX</strong> or <strong>Command Prompt on Windows</strong>:</p>\n\n<pre><code>&gt; compass compile\n</code></pre>\n\n<p>This should output the following:</p>\n\n<pre><code>&gt; create ../css/my-ext-theme.css\n</code></pre>\n\n<p>Your minified css file should now be in <code>appname/resources/css/my-ext-theme.css</code>.</p>\n\n<h2 id='theming-section-5'>Changing global SASS variables</h2>\n\n<p>The Ext JS theming system comes with global SASS variables which you can use to change the look of your application with a few lines of code.</p>\n\n<p>These SASS variables can be added to your <code>appname/resources/sass/my-ext-theme.scss</code> file, but they <strong>must</strong> be inserted before the call to <code>@import 'ext4/default/all'</code>. You can see an example commented out at the top of your <code>my-ext-theme.scss</code> file:</p>\n\n<pre><code>// Insert your custom variables here.\n// $base-color: #aa0000;\n</code></pre>\n\n<p>Try uncommenting this line and changing the base-color to something else, perhaps the green #a1c148.</p>\n\n<p>Now regenerate your theme by navigating to <code>appname/resources/sass</code> and running <code>compass compile</code></p>\n\n<h3>Available Variables</h3>\n\n<p>Navigate to <code>appname/extjs/resources/themes/stylesheets/ext4/default/variables</code> directory. This directory contains all defined variables for each component in Ext JS 4.</p>\n\n<p>The naming convention for variables follows CSS property names, prepends by the component name. For example:</p>\n\n<ul>\n<li><p><strong>Panel border radius</strong></p>\n\n<ul>\n<li>CSS Property: <code>border-radius</code></li>\n<li>Variable: <code>$panel-border-radius</code></li>\n</ul>\n</li>\n<li><p><strong>Panel body background color</strong></p>\n\n<ul>\n<li>CSS Property: <code>background-color</code></li>\n<li>Variable: <code>$panel-body-background-color</code></li>\n</ul>\n</li>\n<li><p><strong>Toolbar background color</strong></p>\n\n<ul>\n<li>CSS Property: <code>background-color</code></li>\n<li>Variable: <code>$toolbar-background-color</code></li>\n</ul>\n</li>\n</ul>\n\n\n<p>You can copy any of these variables and add them to your <code>appname/resources/sass/my-ext-theme.scss</code> file <strong>before</strong> the <code>@import 'ext4/default/all'</code> line.</p>\n\n<h2 id='theming-section-6'>View the Results</h2>\n\n<p>To view your new theme, lets overwrite <code>app.js</code> with the Theme example from the main SDK. This example shows most Ext JS components on a single page. Copy <code>appname/extjs/examples/themes/themes.js</code> to <code>appname/app.js</code>.</p>\n\n<p>Update <code>appname/index.html</code> to the following:</p>\n\n<pre><code>&lt;html&gt;\n&lt;head&gt;\n    &lt;title&gt;Ext Theme&lt;/title&gt;\n\n    &lt;link rel=\"stylesheet\" type=\"text/css\" href=\"resources/css/my-ext-theme.css\"&gt;\n    &lt;script type=\"text/javascript\" src=\"extjs/ext-debug.js\"&gt;&lt;/script&gt;\n    &lt;script type=\"text/javascript\" src=\"app.js\"&gt;&lt;/script&gt;\n&lt;/head&gt;\n&lt;body&gt;&lt;/body&gt;\n&lt;/html&gt;\n</code></pre>\n\n<p>Now open <code>index.html</code> in your browser and you should see your new theme in action. Try updating the base color in <code>my-ext-theme.sass</code> to something else, recompile your sass, and refresh your browser to see the change. Also try experimenting with other sass variables.</p>\n\n<h2 id='theming-section-7'>Component UIs</h2>\n\n<p>Every component in the Ext JS framework has a <code>ui</code> configuration (which defaults to <code>default</code>). This property can be changed to allow components in your application to have different styles.</p>\n\n<p>The <code>ui</code> of any component can be changed at any time, even after render, by using the <code>setUI</code> method. An example of this can be found in <code>examples/panel/bubble-panel.html</code>.</p>\n\n<h3>Creating new Ext JS UIs</h3>\n\n<p>Some Ext JS components have SASS <code>@mixin</code>'s which allow you to quickly generate new UIs. These include: <code><a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a></code>, <code><a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a></code>, <code><a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Ext.Toolbar</a></code> and <code><a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a></code>.</p>\n\n<p>Creating these new UIs is simple. Simply call the associated <code>@mixin</code> (found in the documentation) for the component you want to create a new UI for.</p>\n\n<p>Lets look at the Panel <code>@mixin</code> as an example (which can be found in <code>examples/panel/bubble-panel/sass/bubble-panel.scss</code>):</p>\n\n<pre><code>@include extjs-panel-ui(\n    'bubble',\n\n    $ui-header-font-size: 12px,\n    $ui-header-font-weight: bold,\n    $ui-header-color: #0D2A59,\n    $ui-header-background-color: #fff,\n    $ui-header-background-gradient: null,\n\n    $ui-border-color: #fff,\n    $ui-border-radius: 4px,\n    $ui-body-background-color: #fff,\n    $ui-body-font-size: 14px\n);\n</code></pre>\n\n<p>The above code will create a new <code>ui</code> for any <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a> component, which you can then use in your application by specifying the <code>ui</code> configuration:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('widget.panel', {\n    ui: 'bubble',\n    width: 300,\n    height: 300,\n    title: 'Panel with a bubble UI!'\n});\n</code></pre>\n\n<h2 id='theming-section-8'>Supporting Legacy Browsers</h2>\n\n<p>In most cases when creating new UI's, you will want to include background gradients or rounded corners. Unfortunately legacy browsers do not support the corresponding CSS3 properties, so we must use images instead.</p>\n\n<p>With Ext JS 4, we have included a Slicing tool which does the hard work for you. Simply pass it a manifest file of your new UI's (if you have created any) and run the tool from the command line.</p>\n\n<h3>How it works</h3>\n\n<p>The slicing tool creates a new browser instance, which loads Ext JS and a specified CSS file. Once loaded, it parses a JavaScript file which includes every Ext JS component that needs styling (panel, window, toolbar, etc.). It then analyzes each of those components and determines the size and location of each image that needs to be sliced. It then slices each of the images, sprites them together and saves them in the location defined in the manifest.</p>\n\n<p>The slicer too itself can be run from the command line and is installed as part of the SDK Tools package. It can be run by calling <code>sencha slice theme</code>. Example usage (assuming you are in your application root directory):</p>\n\n<pre><code>sencha slice theme -d extjs -c resources/css/my-ext-theme.css -o resources/images -v\n</code></pre>\n\n<p>It accepts several arguments:</p>\n\n<ul>\n<li><p><strong>--css[=]value, -c[=]value</strong></p>\n\n<blockquote><p>The path to your theme's complete CSS file, e.g., ext-all-access.css. Uses\nthe default Ext JS 4 theme CSS if not provided.</p></blockquote></li>\n<li><p><strong>--ext-dir[=]value, -d[=]value (required)</strong></p>\n\n<blockquote><p>The path to the root of your Ext JS 4 SDK directory.</p></blockquote></li>\n<li><p><strong>--manifest[=]value, -m[=]value</strong></p>\n\n<blockquote><p>The path to your Theme Generator JSON manifest file, e.g., manifest.json.\nUses the default packaged manifest if not provided.</p></blockquote></li>\n<li><p><strong>--output-dir[=]value, -o[=]value</strong></p>\n\n<blockquote><p>The destination path to save all generated theme images. This should be inside the <code>resources/themes/images/&lt;themename&gt;/</code> directory.\nDefaults to the current working directory.</p></blockquote></li>\n<li><p><strong>--verbose, -v</strong></p>\n\n<blockquote><p>Display a message for every image that is generated.</p></blockquote></li>\n</ul>\n\n\n<h3>Usage</h3>\n\n<ol>\n<li><p><strong>Compile your CSS</strong></p>\n\n<p>You must ensure your SASS theme file has been compiled as this is used for the slicer. Passing no CSS file would result in the slicer to revert to the default ext-all.css file, which would be pointless in most cases.</p></li>\n<li><p><strong>Creating your manifest file (optional)</strong></p>\n\n<p>The manifest file is a simple JavaScript file which tells the Slicing tool which custom UI's you would like to slice. This step is only necessary when you have created new UI's.</p>\n\n<p>Let's look at the bubble panel example again:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-onReady\" rel=\"Ext-method-onReady\" class=\"docClass\">Ext.onReady</a>(function() {\n    Ext.manifest = {\n        widgets: [\n            {\n                xtype: 'widget.header',\n                ui   : 'bubble'\n            },\n            {\n                xtype: 'widget.panel',\n                ui   : 'bubble'\n            }\n        ]\n    };\n});\n</code></pre>\n\n<p>As you can see, you define an Object called <code>Ext.manifest</code> and give it an Array property called <code>widgets</code>. In this Array you should insert an object containing the <code>xtype</code> and <code>ui</code> of the component you want to generate the images for.</p>\n\n<p><strong>It is important that the <code>Ext.manifest</code> Object is defined inside the <code><a href=\"#!/api/Ext-method-onReady\" rel=\"Ext-method-onReady\" class=\"docClass\">Ext.onReady</a></code> method.</strong></p></li>\n<li><p><strong>Generating your images</strong></p>\n\n<p> Now all that is left is to run the command, including the arguments to the Ext JS SDK folder, your theme CSS file and the output directory of the sliced images.</p>\n\n<pre><code> sencha slice theme -d extjs -c resources/css/my-ext-theme.css -o resources/images -v\n</code></pre></li>\n</ol>\n\n\n<h2 id='theming-section-9'>FAQ</h2>\n\n<ul>\n<li><p><strong>I am getting a '<code>error resources/sass/my-ext-theme.scss (Line 8: File to import not found or unreadable: ext4/default/all)</code>' error when I compile?</strong></p>\n\n<blockquote><p>This is because Compass cannot file the Ext JS 4 theme files. Ensure the <code>$ext_path</code> in the <code>sass/config.rb</code> file is correct.</p></blockquote></li>\n</ul>\n\n"});