/*
Copyright(c) 2011 Sencha Inc.
licensing@sencha.com
*/
Ext.define("Ext.util.Observable",{requires:["Ext.util.Event"],statics:{releaseCapture:function(a){a.fireEvent=this.prototype.fireEvent},capture:function(c,b,a){c.fireEvent=Ext.Function.createInterceptor(c.fireEvent,b,a)},observe:function(a,b){if(a){if(!a.isObservable){Ext.applyIf(a,new this());this.capture(a.prototype,a.fireEvent,a)}if(Ext.isObject(b)){a.on(b)}}return a},prepareClass:function(d,c){if(!d.HasListeners){var b=Ext.util.Observable,e=function(){},a=d.superclass.HasListeners||(c&&c.HasListeners)||b.HasListeners;d.prototype.HasListeners=d.HasListeners=e;e.prototype=d.hasListeners=new a()}}},isObservable:true,eventsSuspended:0,constructor:function(a){var b=this;Ext.apply(b,a);if(!b.hasListeners){b.hasListeners=new b.HasListeners()}b.events=b.events||{};if(b.listeners){b.on(b.listeners);b.listeners=null}if(b.bubbleEvents){b.enableBubble(b.bubbleEvents)}},onClassExtended:function(a){if(!a.HasListeners){Ext.util.Observable.prepareClass(a)}},eventOptionsRe:/^(?:scope|delay|buffer|single|stopEvent|preventDefault|stopPropagation|normalized|args|delegate|element|vertical|horizontal|freezeEvent)$/,addManagedListener:function(h,d,f,e,c){var g=this,a=g.managedListeners=g.managedListeners||[],b;if(typeof d!=="string"){c=d;for(d in c){if(c.hasOwnProperty(d)){b=c[d];if(!g.eventOptionsRe.test(d)){g.addManagedListener(h,d,b.fn||b,b.scope||c.scope,b.fn?b:c)}}}}else{a.push({item:h,ename:d,fn:f,scope:e,options:c});h.on(d,f,e,c)}},removeManagedListener:function(h,c,f,j){var e=this,k,b,g,a,d;if(typeof c!=="string"){k=c;for(c in k){if(k.hasOwnProperty(c)){b=k[c];if(!e.eventOptionsRe.test(c)){e.removeManagedListener(h,c,b.fn||b,b.scope||k.scope)}}}}g=e.managedListeners?e.managedListeners.slice():[];for(d=0,a=g.length;d<a;d++){e.removeManagedListenerItem(false,g[d],h,c,f,j)}},fireEvent:function(a){a=a.toLowerCase();var e=this,c=e.events,d=c&&c[a],b=true;if(d&&e.hasListeners[a]){b=e.continueFireEvent(a,Ext.Array.slice(arguments,1),d.bubble)}return b},continueFireEvent:function(c,e,b){var g=this,a,f,d=true;do{if(g.eventsSuspended){if((a=g.eventQueue)){a.push([c,e,b])}return d}else{f=g.events[c];if(f&&f!=true){if((d=f.fire.apply(f,e))===false){break}}}}while(b&&(g=g.getBubbleParent()));return d},getBubbleParent:function(){var b=this,a=b.getBubbleTarget&&b.getBubbleTarget();if(a&&a.isObservable){return a}return null},addListener:function(c,f,h,i){var e=this,b,a,d,g=0;if(typeof c!=="string"){i=c;for(c in i){if(i.hasOwnProperty(c)){b=i[c];if(!e.eventOptionsRe.test(c)){e.addListener(c,b.fn||b,b.scope||i.scope,b.fn?b:i)}}}}else{c=c.toLowerCase();a=e.events[c];if(a&&a.isEvent){g=a.listeners.length}else{e.events[c]=a=new Ext.util.Event(e,c)}if(typeof f==="string"){f=h[f]||e[f]}a.addListener(f,h,i);if(a.listeners.length!==g){d=e.hasListeners;if(d.hasOwnProperty(c)){++d[c]}else{d[c]=1}}}},removeListener:function(c,e,d){var g=this,b,f,a;if(typeof c!=="string"){a=c;for(c in a){if(a.hasOwnProperty(c)){b=a[c];if(!g.eventOptionsRe.test(c)){g.removeListener(c,b.fn||b,b.scope||a.scope)}}}}else{c=c.toLowerCase();f=g.events[c];if(f&&f.isEvent){if(f.removeListener(e,d)&&!--g.hasListeners[c]){delete g.hasListeners[c]}}}},clearListeners:function(){var b=this.events,c,a;for(a in b){if(b.hasOwnProperty(a)){c=b[a];if(c.isEvent){c.clearListeners()}}}this.clearManagedListeners()},clearManagedListeners:function(){var b=this.managedListeners||[],c=0,a=b.length;for(;c<a;c++){this.removeManagedListenerItem(true,b[c])}this.managedListeners=[]},removeManagedListenerItem:function(b,a,f,c,e,d){if(b||(a.item===f&&a.ename===c&&(!e||a.fn===e)&&(!d||a.scope===d))){a.item.un(a.ename,a.fn,a.scope);if(!b){Ext.Array.remove(this.managedListeners,a)}}},addEvents:function(f){var e=this,d=e.events||(e.events={}),a,b,c;if(typeof f=="string"){for(b=arguments,c=b.length;c--;){a=b[c];if(!d[a]){d[a]=true}}}else{Ext.applyIf(e.events,f)}},hasListener:function(a){return !!this.hasListeners[a.toLowerCase()]},suspendEvents:function(a){this.eventsSuspended+=1;if(a&&!this.eventQueue){this.eventQueue=[]}},resumeEvents:function(){var a=this,d=a.eventQueue,c,b;if(a.eventsSuspended&&!--a.eventsSuspended){delete a.eventQueue;if(d){c=d.length;for(b=0;b<c;b++){a.continueFireEvent.apply(a,d[b])}}}},relayEvents:function(c,e,h){var g=this,a=e.length,d=0,f,b;for(;d<a;d++){f=e[d];b=h?h+f:f;g.mon(c,f,g.createRelayer(b))}},createRelayer:function(a,b){var c=this;return function(){return c.fireEvent.apply(c,[a].concat(Array.prototype.slice.apply(arguments,b||[0,-1])))}},enableBubble:function(h){if(h){var f=this,g=(typeof h=="string")?arguments:h,e=g.length,c=f.events,b,d,a;for(a=0;a<e;++a){b=g[a].toLowerCase();d=c[b];if(!d||typeof d=="boolean"){c[b]=d=new Ext.util.Event(f,b)}f.hasListeners[b]=(f.hasListeners[b]||0)+1;d.bubble=true}}}},function(){var a=this,d=a.prototype,b=function(){},e=function(f){if(!f.HasListeners){var g=f.prototype;a.prepareClass(f,this);f.onExtended(function(h){a.prepareClass(h)});if(g.onClassMixedIn){Ext.override(f,{onClassMixedIn:function(h){e.call(this,h);this.callParent(arguments)}})}else{g.onClassMixedIn=function(h){e.call(this,h)}}}};b.prototype={};d.HasListeners=a.HasListeners=b;a.createAlias({on:"addListener",un:"removeListener",mon:"addManagedListener",mun:"removeManagedListener"});a.observeClass=a.observe;function c(l){var k=(this.methodEvents=this.methodEvents||{})[l],h,g,i,j=this,f;if(!k){this.methodEvents[l]=k={};k.originalFn=this[l];k.methodName=l;k.before=[];k.after=[];f=function(o,n,m){if((g=o.apply(n||j,m))!==undefined){if(typeof g=="object"){if(g.returnValue!==undefined){h=g.returnValue}else{h=g}i=!!g.cancel}else{if(g===false){i=true}else{h=g}}}};this[l]=function(){var o=Array.prototype.slice.call(arguments,0),n,p,m;h=g=undefined;i=false;for(p=0,m=k.before.length;p<m;p++){n=k.before[p];f(n.fn,n.scope,o);if(i){return h}}if((g=k.originalFn.apply(j,o))!==undefined){h=g}for(p=0,m=k.after.length;p<m;p++){n=k.after[p];f(n.fn,n.scope,o);if(i){return h}}return h}}return k}Ext.apply(d,{onClassMixedIn:e,beforeMethod:function(h,g,f){c.call(this,h).before.push({fn:g,scope:f})},afterMethod:function(h,g,f){c.call(this,h).after.push({fn:g,scope:f})},removeMethodListener:function(l,j,h){var k=this.getMethodEvent(l),g,f;for(g=0,f=k.before.length;g<f;g++){if(k.before[g].fn==j&&k.before[g].scope==h){Ext.Array.erase(k.before,g,1);return}}for(g=0,f=k.after.length;g<f;g++){if(k.after[g].fn==j&&k.after[g].scope==h){Ext.Array.erase(k.after,g,1);return}}},toggleEventLogging:function(f){Ext.util.Observable[f?"capture":"releaseCapture"](this,function(g){if(Ext.isDefined(Ext.global.console)){Ext.global.console.log(g,arguments)}})}})});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("Ext.ux.desktop.Module",{mixins:{observable:"Ext.util.Observable"},constructor:function(a){this.mixins.observable.constructor.call(this,a);this.init()},init:Ext.emptyFn});Ext.define("Ext.chart.Callout",{constructor:function(a){if(a.callouts){a.callouts.styles=Ext.applyIf(a.callouts.styles||{},{color:"#000",font:"11px Helvetica, sans-serif"});this.callouts=Ext.apply(this.callouts||{},a.callouts);this.calloutsArray=[]}},renderCallouts:function(){if(!this.callouts){return}var u=this,l=u.items,a=u.chart.animate,t=u.callouts,g=t.styles,e=u.calloutsArray,b=u.chart.store,r=b.getCount(),d=l.length/r,k=[],q,c,o,m,s,f,h,n;for(q=0,c=0;q<r;q++){for(o=0;o<d;o++){s=l[c];f=e[c];h=b.getAt(q);n=t.filter(h);if(!n&&!f){c++;continue}if(!f){e[c]=f=u.onCreateCallout(h,s,q,n,o,c)}for(m in f){if(f[m]&&f[m].setAttributes){f[m].setAttributes(g,true)}}if(!n){for(m in f){if(f[m]){if(f[m].setAttributes){f[m].setAttributes({hidden:true},true)}else{if(f[m].setVisible){f[m].setVisible(false)}}}}}t.renderer(f,h);u.onPlaceCallout(f,h,s,q,n,a,o,c,k);k.push(f);c++}}this.hideCallouts(c)},onCreateCallout:function(f,m,e,h){var j=this,k=j.calloutsGroup,d=j.callouts,n=d.styles,c=n.width,l=n.height,g=j.chart,b=g.surface,a={lines:false};a.lines=b.add(Ext.apply({},{type:"path",path:"M0,0",stroke:j.getLegendColor()||"#555"},n));if(d.items){a.panel=new Ext.Panel({style:"position: absolute;",width:c,height:l,items:d.items,renderTo:g.el})}return a},hideCallouts:function(b){var d=this.calloutsArray,a=d.length,e,c;while(a-->b){e=d[a];for(c in e){if(e[c]){e[c].hide(true)}}}}});Ext.define("Ext.chart.Navigation",{constructor:function(){this.originalStore=this.store},setZoom:function(j){var h=this,f=h.axes,a=f.items,e,g,c,o=h.chartBBox,n=1/o.width,b=1/o.height,d={x:j.x*n,y:j.y*b,width:j.width*n,height:j.height*b},k,m,l;for(e=0,g=a.length;e<g;e++){c=a[e];k=c.calcEnds();if(c.position=="bottom"||c.position=="top"){m=(k.to-k.from)*d.x+k.from;l=(k.to-k.from)*d.width+m;c.minimum=m;c.maximum=l}else{l=(k.to-k.from)*(1-d.y)+k.from;m=l-(k.to-k.from)*d.height;c.minimum=m;c.maximum=l}}h.redraw(false)},restoreZoom:function(){if(this.originalStore){this.store=this.substore=this.originalStore;this.redraw(true)}}});Ext.define("Ext.chart.Shape",{singleton:true,circle:function(a,b){return a.add(Ext.apply({type:"circle",x:b.x,y:b.y,stroke:null,radius:b.radius},b))},line:function(a,b){return a.add(Ext.apply({type:"rect",x:b.x-b.radius,y:b.y-b.radius,height:2*b.radius,width:2*b.radius/5},b))},square:function(a,b){return a.add(Ext.applyIf({type:"rect",x:b.x-b.radius,y:b.y-b.radius,height:2*b.radius,width:2*b.radius,radius:null},b))},triangle:function(a,b){b.radius*=1.75;return a.add(Ext.apply({type:"path",stroke:null,path:"M".concat(b.x,",",b.y,"m0-",b.radius*0.58,"l",b.radius*0.5,",",b.radius*0.87,"-",b.radius,",0z")},b))},diamond:function(a,c){var b=c.radius;b*=1.5;return a.add(Ext.apply({type:"path",stroke:null,path:["M",c.x,c.y-b,"l",b,b,-b,b,-b,-b,b,-b,"z"]},c))},cross:function(a,c){var b=c.radius;b=b/1.7;return a.add(Ext.apply({type:"path",stroke:null,path:"M".concat(c.x-b,",",c.y,"l",[-b,-b,b,-b,b,b,b,-b,b,b,-b,b,b,b,-b,b,-b,-b,-b,b,-b,-b,"z"])},c))},plus:function(a,c){var b=c.radius/1.3;return a.add(Ext.apply({type:"path",stroke:null,path:"M".concat(c.x-b/2,",",c.y-b/2,"l",[0,-b,b,0,0,b,b,0,0,b,-b,0,0,b,-b,0,0,-b,-b,0,0,-b,"z"])},c))},arrow:function(a,c){var b=c.radius;return a.add(Ext.apply({type:"path",path:"M".concat(c.x-b*0.7,",",c.y-b*0.4,"l",[b*0.6,0,0,-b*0.4,b,b*0.8,-b,b*0.8,0,-b*0.4,-b*0.6,0],"z")},c))},drop:function(b,a,f,e,c,d){c=c||30;d=d||0;b.add({type:"path",path:["M",a,f,"l",c,0,"A",c*0.4,c*0.4,0,1,0,a+c*0.7,f-c*0.7,"z"],fill:"#000",stroke:"none",rotate:{degrees:22.5-d,x:a,y:f}});d=(d+90)*Math.PI/180;b.add({type:"text",x:a+c*Math.sin(d)-10,y:f+c*Math.cos(d)+5,text:e,"font-size":c*12/40,stroke:"none",fill:"#fff"})}});Ext.define("Ext.form.field.VTypes",(function(){var c=/^[a-zA-Z_]+$/,d=/^[a-zA-Z0-9_]+$/,b=/^(\w+)([\-+.][\w]+)*@(\w[\-\w]*\.){1,5}([A-Za-z]){2,6}$/,a=/(((^https?)|(^ftp)):\/\/([\-\w]+\.)+\w{2,3}(\/[%\-\w]+(\.\w{2,})?)*(([\w\-\.\?\\\/+@&#;`~=%!]*)(\.\w{2,})?)*\/?)/i;return{singleton:true,alternateClassName:"Ext.form.VTypes",email:function(e){return b.test(e)},emailText:'This field should be an e-mail address in the format "user@example.com"',emailMask:/[a-z0-9_\.\-@\+]/i,url:function(e){return a.test(e)},urlText:'This field should be a URL in the format "http://www.example.com"',alpha:function(e){return c.test(e)},alphaText:"This field should only contain letters and _",alphaMask:/[a-z_]/i,alphanum:function(e){return d.test(e)},alphanumText:"This field should only contain letters, numbers and _",alphanumMask:/[a-z0-9_]/i}}()));Ext.define("Ext.util.ClickRepeater",{extend:"Ext.util.Observable",constructor:function(b,a){var c=this;c.el=Ext.get(b);c.el.unselectable();Ext.apply(c,a);c.callParent();c.addEvents("mousedown","click","mouseup");if(!c.disabled){c.disabled=true;c.enable()}if(c.handler){c.on("click",c.handler,c.scope||c)}},interval:20,delay:250,preventDefault:true,stopDefault:false,timer:0,enable:function(){if(this.disabled){this.el.on("mousedown",this.handleMouseDown,this);if(Ext.isIE&&!(Ext.isStrict&&Ext.isIE9)){this.el.on("dblclick",this.handleDblClick,this)}if(this.preventDefault||this.stopDefault){this.el.on("click",this.eventOptions,this)}}this.disabled=false},disable:function(a){if(a||!this.disabled){clearTimeout(this.timer);if(this.pressedCls){this.el.removeCls(this.pressedCls)}Ext.getDoc().un("mouseup",this.handleMouseUp,this);this.el.removeAllListeners()}this.disabled=true},setDisabled:function(a){this[a?"disable":"enable"]()},eventOptions:function(a){if(this.preventDefault){a.preventDefault()}if(this.stopDefault){a.stopEvent()}},destroy:function(){this.disable(true);Ext.destroy(this.el);this.clearListeners()},handleDblClick:function(a){clearTimeout(this.timer);this.el.blur();this.fireEvent("mousedown",this,a);this.fireEvent("click",this,a)},handleMouseDown:function(a){clearTimeout(this.timer);this.el.blur();if(this.pressedCls){this.el.addCls(this.pressedCls)}this.mousedownTime=new Date();Ext.getDoc().on("mouseup",this.handleMouseUp,this);this.el.on("mouseout",this.handleMouseOut,this);this.fireEvent("mousedown",this,a);this.fireEvent("click",this,a);if(this.accelerate){this.delay=400}a=new Ext.EventObjectImpl(a);this.timer=Ext.defer(this.click,this.delay||this.interval,this,[a])},click:function(a){this.fireEvent("click",this,a);this.timer=Ext.defer(this.click,this.accelerate?this.easeOutExpo(Ext.Date.getElapsed(this.mousedownTime),400,-390,12000):this.interval,this,[a])},easeOutExpo:function(e,a,g,f){return(e==f)?a+g:g*(-Math.pow(2,-10*e/f)+1)+a},handleMouseOut:function(){clearTimeout(this.timer);if(this.pressedCls){this.el.removeCls(this.pressedCls)}this.el.on("mouseover",this.handleMouseReturn,this)},handleMouseReturn:function(){this.el.un("mouseover",this.handleMouseReturn,this);if(this.pressedCls){this.el.addCls(this.pressedCls)}this.click()},handleMouseUp:function(a){clearTimeout(this.timer);this.el.un("mouseover",this.handleMouseReturn,this);this.el.un("mouseout",this.handleMouseOut,this);Ext.getDoc().un("mouseup",this.handleMouseUp,this);if(this.pressedCls){this.el.removeCls(this.pressedCls)}this.fireEvent("mouseup",this,a)}});Ext.define("Ext.util.TextMetrics",{statics:{shared:null,measure:function(a,d,e){var b=this,c=b.shared;if(!c){c=b.shared=new b(a,e)}c.bind(a);c.setFixedWidth(e||"auto");return c.getSize(d)},destroy:function(){var a=this;Ext.destroy(a.shared);a.shared=null}},constructor:function(a,c){var b=this.measure=Ext.getBody().createChild({cls:Ext.baseCSSPrefix+"textmetrics"});this.el=Ext.get(a);b.position("absolute");b.setLeftTop(-1000,-1000);b.hide();if(c){b.setWidth(c)}},getSize:function(c){var b=this.measure,a;b.update(c);a=b.getSize();b.update("");return a},bind:function(a){var b=this;b.el=Ext.get(a);b.measure.setStyle(b.el.getStyles("font-size","font-style","font-weight","font-family","line-height","text-transform","letter-spacing"))},setFixedWidth:function(a){this.measure.setWidth(a)},getWidth:function(a){this.measure.dom.style.width="auto";return this.getSize(a).width},getHeight:function(a){return this.getSize(a).height},destroy:function(){var a=this;a.measure.remove();delete a.el;delete a.measure}},function(){Ext.Element.addMethods({getTextWidth:function(c,b,a){return Ext.Number.constrain(Ext.util.TextMetrics.measure(this.dom,Ext.value(c,this.dom.innerHTML,true)).width,b||0,a||1000000)}})});Ext.define("Ext.util.KeyMap",{alternateClassName:"Ext.KeyMap",eventName:"keydown",constructor:function(a){var b=this;if((arguments.length!==1)||(typeof a==="string")||a.dom||a.tagName||a===document||a.isComponent){b.legacyConstructor.apply(b,arguments);return}Ext.apply(b,a);b.bindings=[];if(!b.target.isComponent){b.target=Ext.get(b.target)}if(b.binding){b.addBinding(b.binding)}else{if(a.key){b.addBinding(a)}}b.enable()},legacyConstructor:function(b,d,a){var c=this;Ext.apply(c,{target:Ext.get(b),eventName:a||c.eventName,bindings:[]});if(d){c.addBinding(d)}c.enable()},addBinding:function(g){var f=g.key,h=false,d,e,b,c,a;if(Ext.isArray(g)){for(c=0,a=g.length;c<a;c++){this.addBinding(g[c])}return}if(Ext.isString(f)){e=[];b=f.toUpperCase();for(c=0,a=b.length;c<a;++c){e.push(b.charCodeAt(c))}f=e;h=true}if(!Ext.isArray(f)){f=[f]}if(!h){for(c=0,a=f.length;c<a;++c){d=f[c];if(Ext.isString(d)){f[c]=d.toUpperCase().charCodeAt(0)}}}this.bindings.push(Ext.apply({keyCode:f},g))},handleTargetEvent:(function(){var a=/input|textarea/i;return function(f){var e=this,h,c,b,g,d;if(this.enabled){h=this.bindings;c=0;b=h.length;f=e.processEvent.apply(e||e.processEventScope,arguments);if(e.ignoreInputFields){g=f.target;d=g.contentEditable;if(a.test(g.tagName)||(d===""||d==="true")){return}}if(!f.getKey){return f}for(;c<b;++c){this.processBinding(h[c],f)}}}}()),processEvent:function(a){return a},processBinding:function(f,a){if(this.checkModifiers(f,a)){var g=a.getKey(),j=f.fn||f.handler,k=f.scope||this,h=f.keyCode,b=f.defaultEventAction,c,e,d=new Ext.EventObjectImpl(a);for(c=0,e=h.length;c<e;++c){if(g===h[c]){if(j.call(k,g,a)!==true&&b){d[b]()}break}}}},checkModifiers:function(h,f){var d=["shift","ctrl","alt"],c=0,a=d.length,g,b;for(;c<a;++c){b=d[c];g=h[b];if(!(g===undefined||(g===f[b+"Key"]))){return false}}return true},on:function(b,d,c){var g,a,e,f;if(Ext.isObject(b)&&!Ext.isArray(b)){g=b.key;a=b.shift;e=b.ctrl;f=b.alt}else{g=b}this.addBinding({key:g,shift:a,ctrl:e,alt:f,fn:d,scope:c})},isEnabled:function(){return this.enabled},enable:function(){var a=this;if(!a.enabled){a.target.on(a.eventName,a.handleTargetEvent,a);a.enabled=true}},disable:function(){var a=this;if(a.enabled){a.target.removeListener(a.eventName,a.handleTargetEvent,a);a.enabled=false}},setDisabled:function(a){if(a){this.disable()}else{this.enable()}},destroy:function(c){var a=this,b=a.target;a.bindings=[];a.disable();if(c===true){if(b.isComponent){b.destroy()}else{b.remove()}}delete a.target}});Ext.define("Ext.Template",{requires:["Ext.dom.Helper","Ext.util.Format"],inheritableStatics:{from:function(b,a){b=Ext.getDom(b);return new this(b.value||b.innerHTML,a||"")}},constructor:function(d){var f=this,b=arguments,a=[],c=0,e=b.length,g;f.initialConfig={};if(e===1&&Ext.isArray(d)){b=d;e=b.length}if(e>1){for(;c<e;c++){g=b[c];if(typeof g=="object"){Ext.apply(f.initialConfig,g);Ext.apply(f,g)}else{a.push(g)}}}else{a.push(d)}f.html=a.join("");if(f.compiled){f.compile()}},isTemplate:true,disableFormats:false,re:/\{([\w\-]+)(?:\:([\w\.]*)(?:\((.*?)?\))?)?\}/g,apply:function(a){var g=this,d=g.disableFormats!==true,f=Ext.util.Format,c=g,b;if(g.compiled){return g.compiled(a).join("")}function e(h,j,k,i){if(k&&d){if(i){i=[a[j]].concat(Ext.functionFactory("return ["+i+"];")())}else{i=[a[j]]}if(k.substr(0,5)=="this."){return c[k.substr(5)].apply(c,i)}else{return f[k].apply(f,i)}}else{return a[j]!==undefined?a[j]:""}}b=g.html.replace(g.re,e);return b},applyOut:function(a,b){var c=this;if(c.compiled){b.push.apply(b,c.compiled(a))}else{b.push(c.apply(a))}return b},applyTemplate:function(){return this.apply.apply(this,arguments)},set:function(a,c){var b=this;b.html=a;b.compiled=null;return c?b.compile():b},compileARe:/\\/g,compileBRe:/(\r\n|\n)/g,compileCRe:/'/g,compile:function(){var me=this,fm=Ext.util.Format,useFormat=me.disableFormats!==true,body,bodyReturn;function fn(m,name,format,args){if(format&&useFormat){args=args?","+args:"";if(format.substr(0,5)!="this."){format="fm."+format+"("}else{format="this."+format.substr(5)+"("}}else{args="";format="(values['"+name+"'] == undefined ? '' : "}return"',"+format+"values['"+name+"']"+args+") ,'"}bodyReturn=me.html.replace(me.compileARe,"\\\\").replace(me.compileBRe,"\\n").replace(me.compileCRe,"\\'").replace(me.re,fn);body="this.compiled = function(values){ return ['"+bodyReturn+"'];};";eval(body);return me},insertFirst:function(b,a,c){return this.doInsert("afterBegin",b,a,c)},insertBefore:function(b,a,c){return this.doInsert("beforeBegin",b,a,c)},insertAfter:function(b,a,c){return this.doInsert("afterEnd",b,a,c)},append:function(b,a,c){return this.doInsert("beforeEnd",b,a,c)},doInsert:function(b,d,a,e){var c=Ext.DomHelper.insertHtml(b,Ext.getDom(d),this.apply(a));return e?Ext.get(c):c},overwrite:function(c,a,d){var b=Ext.DomHelper.overwrite(Ext.getDom(c),this.apply(a));return d?Ext.get(b):b}});Ext.define("Ext.data.IdGenerator",{isGenerator:true,constructor:function(a){var b=this;Ext.apply(b,a);if(b.id){Ext.data.IdGenerator.all[b.id]=b}},getRecId:function(a){return a.modelName+"-"+a.internalId},statics:{all:{},get:function(a){var c,d,b;if(typeof a=="string"){d=b=a;a=null}else{if(a.isGenerator){return a}else{d=a.id||a.type;b=a.type}}c=this.all[d];if(!c){c=Ext.create("idgen."+b,a)}return c}}});Ext.define("Ext.data.Operation",{synchronous:true,action:undefined,filters:undefined,sorters:undefined,groupers:undefined,start:undefined,limit:undefined,batch:undefined,callback:undefined,scope:undefined,started:false,running:false,complete:false,success:undefined,exception:false,error:undefined,actionCommitRecordsRe:/^(?:create|update)$/i,actionSkipSyncRe:/^destroy$/i,constructor:function(a){Ext.apply(this,a||{})},commitRecords:function(j){var g=this,h,f,a,c,b,d,e;if(!g.actionSkipSyncRe.test(g.action)){a=g.records;if(a&&a.length){if(a.length>1){if(g.action=="update"||a[0].clientIdProperty){h=new Ext.util.MixedCollection();h.addAll(j);for(f=a.length;f--;){b=a[f];c=h.findBy(g.matchClientRec,b);b.copyFrom(c)}}else{for(d=0,e=a.length;d<e;++d){b=a[d];c=j[d];if(b&&c){g.updateRecord(b,c)}}}}else{this.updateRecord(a[0],j[0])}if(g.actionCommitRecordsRe.test(g.action)){for(f=a.length;f--;){a[f].commit()}}}}},updateRecord:function(a,b){if(b&&(a.phantom||a.getId()===b.getId())){a.copyFrom(b)}},matchClientRec:function(c){var a=this,b=a.getId();if(b&&c.getId()===b){return true}return c.internalId===a.internalId},setStarted:function(){this.started=true;this.running=true},setCompleted:function(){this.complete=true;this.running=false},setSuccessful:function(){this.success=true},setException:function(a){this.exception=true;this.success=false;this.running=false;this.error=a},hasException:function(){return this.exception===true},getError:function(){return this.error},getRecords:function(){var a=this.getResultSet();return this.records||(a?a.records:null)},getResultSet:function(){return this.resultSet},isStarted:function(){return this.started===true},isRunning:function(){return this.running===true},isComplete:function(){return this.complete===true},wasSuccessful:function(){return this.isComplete()&&this.success===true},setBatch:function(a){this.batch=a},allowWrite:function(){return this.action!="read"}});Ext.define("Ext.data.validations",{singleton:true,presenceMessage:"must be present",lengthMessage:"is the wrong length",formatMessage:"is the wrong format",inclusionMessage:"is not included in the list of acceptable values",exclusionMessage:"is not an acceptable value",emailMessage:"is not a valid email address",emailRe:/^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/,presence:function(a,b){if(arguments.length===1){b=a}return !!b||b===0},length:function(b,e){if(e===undefined||e===null){return false}var d=e.length,c=b.min,a=b.max;if((c&&d<c)||(a&&d>a)){return false}else{return true}},email:function(b,a){return Ext.data.validations.emailRe.test(a)},format:function(a,b){return !!(a.matcher&&a.matcher.test(b))},inclusion:function(a,b){return a.list&&Ext.Array.indexOf(a.list,b)!=-1},exclusion:function(a,b){return a.list&&Ext.Array.indexOf(a.list,b)==-1}});Ext.define("Ext.util.Bindable",{bindStore:function(a,b){var c=this,d=c.store;if(!b&&c.store){c.onUnbindStore(d,b);if(a!==d&&d.autoDestroy){d.destroyStore()}else{c.unbindStoreListeners(d)}}if(a){a=Ext.data.StoreManager.lookup(a);c.bindStoreListeners(a);c.onBindStore(a,b)}c.store=a||null;return c},getStore:function(){return this.store},unbindStoreListeners:function(a){var b=this.storeListeners;if(b){a.un(b)}},bindStoreListeners:function(a){var c=this,b=Ext.apply({},c.getStoreListeners());if(!b.scope){b.scope=c}c.storeListeners=b;a.on(b)},getStoreListeners:Ext.emptyFn,onUnbindStore:Ext.emptyFn,onBindStore:Ext.emptyFn});Ext.define("Ext.draw.Color",{colorToHexRe:/(.*?)rgb\((\d+),\s*(\d+),\s*(\d+)\)/,rgbRe:/\s*rgb\s*\(\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\s*\)\s*/,hexRe:/\s*#([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)\s*/,lightnessFactor:0.2,constructor:function(d,c,a){var b=this,e=Ext.Number.constrain;b.r=e(d,0,255);b.g=e(c,0,255);b.b=e(a,0,255)},getRed:function(){return this.r},getGreen:function(){return this.g},getBlue:function(){return this.b},getRGB:function(){var a=this;return[a.r,a.g,a.b]},getHSL:function(){var i=this,a=i.r/255,f=i.g/255,j=i.b/255,k=Math.max(a,f,j),d=Math.min(a,f,j),m=k-d,e,n=0,c=0.5*(k+d);if(d!=k){n=(c<0.5)?m/(k+d):m/(2-k-d);if(a==k){e=60*(f-j)/m}else{if(f==k){e=120+60*(j-a)/m}else{e=240+60*(a-f)/m}}if(e<0){e+=360}if(e>=360){e-=360}}return[e,n,c]},getLighter:function(b){var a=this.getHSL();b=b||this.lightnessFactor;a[2]=Ext.Number.constrain(a[2]+b,0,1);return this.fromHSL(a[0],a[1],a[2])},getDarker:function(a){a=a||this.lightnessFactor;return this.getLighter(-a)},toString:function(){var f=this,c=Math.round,e=c(f.r).toString(16),d=c(f.g).toString(16),a=c(f.b).toString(16);e=(e.length==1)?"0"+e:e;d=(d.length==1)?"0"+d:d;a=(a.length==1)?"0"+a:a;return["#",e,d,a].join("")},toHex:function(b){if(Ext.isArray(b)){b=b[0]}if(!Ext.isString(b)){return""}if(b.substr(0,1)==="#"){return b}var e=this.colorToHexRe.exec(b),f,d,a,c;if(Ext.isArray(e)){f=parseInt(e[2],10);d=parseInt(e[3],10);a=parseInt(e[4],10);c=a|(d<<8)|(f<<16);return e[1]+"#"+("000000"+c.toString(16)).slice(-6)}else{return b}},fromString:function(h){var c,e,d,a,f=parseInt;if((h.length==4||h.length==7)&&h.substr(0,1)==="#"){c=h.match(this.hexRe);if(c){e=f(c[1],16)>>0;d=f(c[2],16)>>0;a=f(c[3],16)>>0;if(h.length==4){e+=(e*16);d+=(d*16);a+=(a*16)}}}else{c=h.match(this.rgbRe);if(c){e=c[1];d=c[2];a=c[3]}}return(typeof e=="undefined")?undefined:new Ext.draw.Color(e,d,a)},getGrayscale:function(){return this.r*0.3+this.g*0.59+this.b*0.11},fromHSL:function(f,n,d){var a,b,c,e,j=[],k=Math.abs,g=Math.floor;if(n==0||f==null){j=[d,d,d]}else{f/=60;a=n*(1-k(2*d-1));b=a*(1-k(f-2*g(f/2)-1));c=d-a/2;switch(g(f)){case 0:j=[a,b,0];break;case 1:j=[b,a,0];break;case 2:j=[0,a,b];break;case 3:j=[0,b,a];break;case 4:j=[b,0,a];break;case 5:j=[a,0,b];break}j=[j[0]+c,j[1]+c,j[2]+c]}return new Ext.draw.Color(j[0]*255,j[1]*255,j[2]*255)}},function(){var a=this.prototype;this.addStatics({fromHSL:function(){return a.fromHSL.apply(a,arguments)},fromString:function(){return a.fromString.apply(a,arguments)},toHex:function(){return a.toHex.apply(a,arguments)}})});Ext.define("Ext.draw.Draw",{singleton:true,requires:["Ext.draw.Color"],pathToStringRE:/,?([achlmqrstvxz]),?/gi,pathCommandRE:/([achlmqstvz])[\s,]*((-?\d*\.?\d*(?:e[-+]?\d+)?\s*,?\s*)+)/ig,pathValuesRE:/(-?\d*\.?\d*(?:e[-+]?\d+)?)\s*,?\s*/ig,stopsRE:/^(\d+%?)$/,radian:Math.PI/180,availableAnimAttrs:{along:"along",blur:null,"clip-rect":"csv",cx:null,cy:null,fill:"color","fill-opacity":null,"font-size":null,height:null,opacity:null,path:"path",r:null,rotation:"csv",rx:null,ry:null,scale:"csv",stroke:"color","stroke-opacity":null,"stroke-width":null,translation:"csv",width:null,x:null,y:null},is:function(b,a){a=String(a).toLowerCase();return(a=="object"&&b===Object(b))||(a=="undefined"&&typeof b==a)||(a=="null"&&b===null)||(a=="array"&&Array.isArray&&Array.isArray(b))||(Object.prototype.toString.call(b).toLowerCase().slice(8,-1))==a},ellipsePath:function(b){var a=b.attr;return Ext.String.format("M{0},{1}A{2},{3},0,1,1,{0},{4}A{2},{3},0,1,1,{0},{1}z",a.x,a.y-a.ry,a.rx,a.ry,a.y+a.ry)},rectPath:function(b){var a=b.attr;if(a.radius){return Ext.String.format("M{0},{1}l{2},0a{3},{3},0,0,1,{3},{3}l0,{5}a{3},{3},0,0,1,{4},{3}l{6},0a{3},{3},0,0,1,{4},{4}l0,{7}a{3},{3},0,0,1,{3},{4}z",a.x+a.radius,a.y,a.width-a.radius*2,a.radius,-a.radius,a.height-a.radius*2,a.radius*2-a.width,a.radius*2-a.height)}else{return Ext.String.format("M{0},{1}L{2},{1},{2},{3},{0},{3}z",a.x,a.y,a.width+a.x,a.height+a.y)}},path2string:function(){return this.join(",").replace(Ext.draw.Draw.pathToStringRE,"$1")},pathToString:function(a){return a.join(",").replace(Ext.draw.Draw.pathToStringRE,"$1")},parsePathString:function(a){if(!a){return null}var d={a:7,c:6,h:1,l:2,m:2,q:4,s:4,t:2,v:1,z:0},c=[],b=this;if(b.is(a,"array")&&b.is(a[0],"array")){c=b.pathClone(a)}if(!c.length){String(a).replace(b.pathCommandRE,function(f,e,i){var h=[],g=e.toLowerCase();i.replace(b.pathValuesRE,function(k,j){j&&h.push(+j)});if(g=="m"&&h.length>2){c.push([e].concat(Ext.Array.splice(h,0,2)));g="l";e=(e=="m")?"l":"L"}while(h.length>=d[g]){c.push([e].concat(Ext.Array.splice(h,0,d[g])));if(!d[g]){break}}})}c.toString=b.path2string;return c},mapPath:function(k,f){if(!f){return k}var g,e,c,h,a,d,b;k=this.path2curve(k);for(c=0,h=k.length;c<h;c++){b=k[c];for(a=1,d=b.length;a<d-1;a+=2){g=f.x(b[a],b[a+1]);e=f.y(b[a],b[a+1]);b[a]=g;b[a+1]=e}}return k},pathClone:function(f){var c=[],a,e,b,d;if(!this.is(f,"array")||!this.is(f&&f[0],"array")){f=this.parsePathString(f)}for(b=0,d=f.length;b<d;b++){c[b]=[];for(a=0,e=f[b].length;a<e;a++){c[b][a]=f[b][a]}}c.toString=this.path2string;return c},pathToAbsolute:function(c){if(!this.is(c,"array")||!this.is(c&&c[0],"array")){c=this.parsePathString(c)}var h=[],l=0,k=0,n=0,m=0,f=0,g=c.length,b,d,e,a;if(g&&c[0][0]=="M"){l=+c[0][1];k=+c[0][2];n=l;m=k;f++;h[0]=["M",l,k]}for(;f<g;f++){b=h[f]=[];d=c[f];if(d[0]!=d[0].toUpperCase()){b[0]=d[0].toUpperCase();switch(b[0]){case"A":b[1]=d[1];b[2]=d[2];b[3]=d[3];b[4]=d[4];b[5]=d[5];b[6]=+(d[6]+l);b[7]=+(d[7]+k);break;case"V":b[1]=+d[1]+k;break;case"H":b[1]=+d[1]+l;break;case"M":n=+d[1]+l;m=+d[2]+k;default:e=1;a=d.length;for(;e<a;e++){b[e]=+d[e]+((e%2)?l:k)}}}else{e=0;a=d.length;for(;e<a;e++){h[f][e]=d[e]}}switch(b[0]){case"Z":l=n;k=m;break;case"H":l=b[1];break;case"V":k=b[1];break;case"M":d=h[f];a=d.length;n=d[a-2];m=d[a-1];default:d=h[f];a=d.length;l=d[a-2];k=d[a-1]}}h.toString=this.path2string;return h},pathToRelative:function(d){if(!this.is(d,"array")||!this.is(d&&d[0],"array")){d=this.parsePathString(d)}var m=[],o=0,n=0,s=0,q=0,c=0,a,p,g,f,e,l,t,h,b;if(d[0][0]=="M"){o=d[0][1];n=d[0][2];s=o;q=n;c++;m.push(["M",o,n])}for(g=c,t=d.length;g<t;g++){a=m[g]=[];p=d[g];if(p[0]!=p[0].toLowerCase()){a[0]=p[0].toLowerCase();switch(a[0]){case"a":a[1]=p[1];a[2]=p[2];a[3]=p[3];a[4]=p[4];a[5]=p[5];a[6]=+(p[6]-o).toFixed(3);a[7]=+(p[7]-n).toFixed(3);break;case"v":a[1]=+(p[1]-n).toFixed(3);break;case"m":s=p[1];q=p[2];default:for(f=1,h=p.length;f<h;f++){a[f]=+(p[f]-((f%2)?o:n)).toFixed(3)}}}else{a=m[g]=[];if(p[0]=="m"){s=p[1]+o;q=p[2]+n}for(e=0,b=p.length;e<b;e++){m[g][e]=p[e]}}l=m[g].length;switch(m[g][0]){case"z":o=s;n=q;break;case"h":o+=+m[g][l-1];break;case"v":n+=+m[g][l-1];break;default:o+=+m[g][l-2];n+=+m[g][l-1]}}m.toString=this.path2string;return m},path2curve:function(j){var d=this,g=d.pathToAbsolute(j),c=g.length,h={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null},b,a,f,e;for(b=0;b<c;b++){g[b]=d.command2curve(g[b],h);if(g[b].length>7){g[b].shift();e=g[b];while(e.length){Ext.Array.splice(g,b++,0,["C"].concat(Ext.Array.splice(e,0,6)))}Ext.Array.erase(g,b,1);c=g.length;b--}a=g[b];f=a.length;h.x=a[f-2];h.y=a[f-1];h.bx=parseFloat(a[f-4])||h.x;h.by=parseFloat(a[f-3])||h.y}return g},interpolatePaths:function(q,k){var h=this,d=h.pathToAbsolute(q),l=h.pathToAbsolute(k),m={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null},a={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null},b=function(p,r){if(p[r].length>7){p[r].shift();var s=p[r];while(s.length){Ext.Array.splice(p,r++,0,["C"].concat(Ext.Array.splice(s,0,6)))}Ext.Array.erase(p,r,1);n=Math.max(d.length,l.length||0)}},c=function(u,t,r,p,s){if(u&&t&&u[s][0]=="M"&&t[s][0]!="M"){Ext.Array.splice(t,s,0,["M",p.x,p.y]);r.bx=0;r.by=0;r.x=u[s][1];r.y=u[s][2];n=Math.max(d.length,l.length||0)}},g,n,f,o,e,j;for(g=0,n=Math.max(d.length,l.length||0);g<n;g++){d[g]=h.command2curve(d[g],m);b(d,g);(l[g]=h.command2curve(l[g],a));b(l,g);c(d,l,m,a,g);c(l,d,a,m,g);f=d[g];o=l[g];e=f.length;j=o.length;m.x=f[e-2];m.y=f[e-1];m.bx=parseFloat(f[e-4])||m.x;m.by=parseFloat(f[e-3])||m.y;a.bx=(parseFloat(o[j-4])||a.x);a.by=(parseFloat(o[j-3])||a.y);a.x=o[j-2];a.y=o[j-1]}return[d,l]},command2curve:function(c,b){var a=this;if(!c){return["C",b.x,b.y,b.x,b.y,b.x,b.y]}if(c[0]!="T"&&c[0]!="Q"){b.qx=b.qy=null}switch(c[0]){case"M":b.X=c[1];b.Y=c[2];break;case"A":c=["C"].concat(a.arc2curve.apply(a,[b.x,b.y].concat(c.slice(1))));break;case"S":c=["C",b.x+(b.x-(b.bx||b.x)),b.y+(b.y-(b.by||b.y))].concat(c.slice(1));break;case"T":b.qx=b.x+(b.x-(b.qx||b.x));b.qy=b.y+(b.y-(b.qy||b.y));c=["C"].concat(a.quadratic2curve(b.x,b.y,b.qx,b.qy,c[1],c[2]));break;case"Q":b.qx=c[1];b.qy=c[2];c=["C"].concat(a.quadratic2curve(b.x,b.y,c[1],c[2],c[3],c[4]));break;case"L":c=["C"].concat(b.x,b.y,c[1],c[2],c[1],c[2]);break;case"H":c=["C"].concat(b.x,b.y,c[1],b.y,c[1],b.y);break;case"V":c=["C"].concat(b.x,b.y,b.x,c[1],b.x,c[1]);break;case"Z":c=["C"].concat(b.x,b.y,b.X,b.Y,b.X,b.Y);break}return c},quadratic2curve:function(b,d,g,e,a,c){var f=1/3,h=2/3;return[f*b+h*g,f*d+h*e,f*a+h*g,f*c+h*e,a,c]},rotate:function(b,g,a){var d=Math.cos(a),c=Math.sin(a),f=b*d-g*c,e=b*c+g*d;return{x:f,y:e}},arc2curve:function(u,ag,I,G,A,n,g,s,af,B){var w=this,e=Math.PI,z=w.radian,F=e*120/180,b=z*(+A||0),N=[],K=Math,U=K.cos,a=K.sin,W=K.sqrt,v=K.abs,o=K.asin,J,c,q,P,O,ab,d,S,V,D,C,m,l,r,j,ae,f,ad,Q,T,R,ac,aa,Z,X,M,Y,L,E,H,p;if(!B){J=w.rotate(u,ag,-b);u=J.x;ag=J.y;J=w.rotate(s,af,-b);s=J.x;af=J.y;c=U(z*A);q=a(z*A);P=(u-s)/2;O=(ag-af)/2;ab=(P*P)/(I*I)+(O*O)/(G*G);if(ab>1){ab=W(ab);I=ab*I;G=ab*G}d=I*I;S=G*G;V=(n==g?-1:1)*W(v((d*S-d*O*O-S*P*P)/(d*O*O+S*P*P)));D=V*I*O/G+(u+s)/2;C=V*-G*P/I+(ag+af)/2;m=o(((ag-C)/G).toFixed(7));l=o(((af-C)/G).toFixed(7));m=u<D?e-m:m;l=s<D?e-l:l;if(m<0){m=e*2+m}if(l<0){l=e*2+l}if(g&&m>l){m=m-e*2}if(!g&&l>m){l=l-e*2}}else{m=B[0];l=B[1];D=B[2];C=B[3]}r=l-m;if(v(r)>F){E=l;H=s;p=af;l=m+F*(g&&l>m?1:-1);s=D+I*U(l);af=C+G*a(l);N=w.arc2curve(s,af,I,G,A,0,g,H,p,[l,E,D,C])}r=l-m;j=U(m);ae=a(m);f=U(l);ad=a(l);Q=K.tan(r/4);T=4/3*I*Q;R=4/3*G*Q;ac=[u,ag];aa=[u+T*ae,ag-R*j];Z=[s+T*ad,af-R*f];X=[s,af];aa[0]=2*ac[0]-aa[0];aa[1]=2*ac[1]-aa[1];if(B){return[aa,Z,X].concat(N)}else{N=[aa,Z,X].concat(N).join().split(",");M=[];L=N.length;for(Y=0;Y<L;Y++){M[Y]=Y%2?w.rotate(N[Y-1],N[Y],b).y:w.rotate(N[Y],N[Y+1],b).x}return M}},rotateAndTranslatePath:function(h){var c=h.rotation.degrees,d=h.rotation.x,b=h.rotation.y,n=h.translation.x,k=h.translation.y,m,f,a,l,e,g=[];if(!c&&!n&&!k){return this.pathToAbsolute(h.attr.path)}n=n||0;k=k||0;m=this.pathToAbsolute(h.attr.path);for(f=m.length;f--;){a=g[f]=m[f].slice();if(a[0]=="A"){l=this.rotatePoint(a[6],a[7],c,d,b);a[6]=l.x+n;a[7]=l.y+k}else{e=1;while(a[e+1]!=null){l=this.rotatePoint(a[e],a[e+1],c,d,b);a[e]=l.x+n;a[e+1]=l.y+k;e+=2}}}return g},rotatePoint:function(b,g,e,a,f){if(!e){return{x:b,y:g}}a=a||0;f=f||0;b=b-a;g=g-f;e=e*this.radian;var d=Math.cos(e),c=Math.sin(e);return{x:b*d-g*c+a,y:b*c+g*d+f}},pathDimensions:function(l){if(!l||!(l+"")){return{x:0,y:0,width:0,height:0}}l=this.path2curve(l);var j=0,h=0,d=[],b=[],e=0,g=l.length,c,a,k,f;for(;e<g;e++){c=l[e];if(c[0]=="M"){j=c[1];h=c[2];d.push(j);b.push(h)}else{f=this.curveDim(j,h,c[1],c[2],c[3],c[4],c[5],c[6]);d=d.concat(f.min.x,f.max.x);b=b.concat(f.min.y,f.max.y);j=c[5];h=c[6]}}a=Math.min.apply(0,d);k=Math.min.apply(0,b);return{x:a,y:k,path:l,width:Math.max.apply(0,d)-a,height:Math.max.apply(0,b)-k}},intersectInside:function(b,c,a){return(a[0]-c[0])*(b[1]-c[1])>(a[1]-c[1])*(b[0]-c[0])},intersectIntersection:function(m,l,f,d){var c=[],b=f[0]-d[0],a=f[1]-d[1],j=m[0]-l[0],h=m[1]-l[1],k=f[0]*d[1]-f[1]*d[0],i=m[0]*l[1]-m[1]*l[0],g=1/(b*h-a*j);c[0]=(k*j-i*b)*g;c[1]=(k*h-i*a)*g;return c},intersect:function(n,c){var m=this,h=0,l=c.length,g=c[l-1],p=n,f,q,k,o,a,b,d;for(;h<l;++h){f=c[h];b=p;p=[];q=b[b.length-1];d=0;a=b.length;for(;d<a;d++){k=b[d];if(m.intersectInside(k,g,f)){if(!m.intersectInside(q,g,f)){p.push(m.intersectIntersection(q,k,g,f))}p.push(k)}else{if(m.intersectInside(q,g,f)){p.push(m.intersectIntersection(q,k,g,f))}}q=k}g=f}return p},bezier:function(g,f,l,k,e){if(e===0){return g}else{if(e===1){return k}}var i=1-e,h=i*i*i,j=e/i;return h*(g+j*(3*f+j*(3*l+k*j)))},bezierDim:function(q,p,m,l){var u=[],f,h,o,g,t,e,v,j,n,k;if(q+3*m==l+3*p){f=q-p;f/=2*(q-p-p+m);if(f<1&&f>0){u.push(f)}}else{h=q-3*p+3*m-l;o=2*(q-p-p+m);g=q-p;t=o*o-4*h*g;e=h+h;if(t===0){f=o/e;if(f<1&&f>0){u.push(f)}}else{if(t>0){v=Math.sqrt(t);f=(v+o)/e;if(f<1&&f>0){u.push(f)}f=(o-v)/e;if(f<1&&f>0){u.push(f)}}}}j=Math.min(q,l);n=Math.max(q,l);for(k=0;k<u.length;k++){j=Math.min(j,this.bezier(q,p,m,l,u[k]));n=Math.max(n,this.bezier(q,p,m,l,u[k]))}return[j,n]},curveDim:function(b,a,d,c,j,i,g,e){var h=this.bezierDim(b,d,j,g),f=this.bezierDim(a,c,i,e);return{min:{x:h[0],y:f[0]},max:{x:h[1],y:f[1]}}},getAnchors:function(e,d,j,i,u,t,p){p=p||4;var h=Math,o=h.PI,q=o/2,l=h.abs,a=h.sin,b=h.cos,f=h.atan,s,r,g,k,n,m,w,v,c;s=(j-e)/p;r=(u-j)/p;if((i>=d&&i>=t)||(i<=d&&i<=t)){g=k=q}else{g=f((j-e)/l(i-d));if(d<i){g=o-g}k=f((u-j)/l(i-t));if(t<i){k=o-k}}c=q-((g+k)%(o*2))/2;if(c>q){c-=o}g+=c;k+=c;n=j-s*a(g);m=i+s*b(g);w=j+r*a(k);v=i+r*b(k);if((i>d&&m<d)||(i<d&&m>d)){n+=l(d-m)*(n-j)/(m-i);m=d}if((i>t&&v<t)||(i<t&&v>t)){w-=l(t-v)*(w-j)/(v-i);v=t}return{x1:n,y1:m,x2:w,y2:v}},smooth:function(a,q){var p=this.path2curve(a),e=[p[0]],h=p[0][1],g=p[0][2],r,t,u=1,k=p.length,f=1,m=h,l=g,c=0,b=0,z,w,v,n,s,o,d;for(;u<k;u++){z=p[u];w=z.length;v=p[u-1];n=v.length;s=p[u+1];o=s&&s.length;if(z[0]=="M"){m=z[1];l=z[2];r=u+1;while(p[r][0]!="C"){r++}c=p[r][5];b=p[r][6];e.push(["M",m,l]);f=e.length;h=m;g=l;continue}if(z[w-2]==m&&z[w-1]==l&&(!s||s[0]=="M")){d=e[f].length;t=this.getAnchors(v[n-2],v[n-1],m,l,e[f][d-2],e[f][d-1],q);e[f][1]=t.x2;e[f][2]=t.y2}else{if(!s||s[0]=="M"){t={x1:z[w-2],y1:z[w-1]}}else{t=this.getAnchors(v[n-2],v[n-1],z[w-2],z[w-1],s[o-2],s[o-1],q)}}e.push(["C",h,g,t.x1,t.y1,z[w-2],z[w-1]]);h=t.x2;g=t.y2}return e},findDotAtSegment:function(b,a,d,c,i,h,g,f,j){var e=1-j;return{x:Math.pow(e,3)*b+Math.pow(e,2)*3*j*d+e*3*j*j*i+Math.pow(j,3)*g,y:Math.pow(e,3)*a+Math.pow(e,2)*3*j*c+e*3*j*j*h+Math.pow(j,3)*f}},snapEnds:function(q,r,d,l){if(Ext.isDate(q)){return this.snapEndsByDate(q,r,d)}var c=(r-q)/d,a=Math.floor(Math.log(c)/Math.LN10)+1,e=Math.pow(10,a),s,o=Math.round((c%e)*Math.pow(10,2-a)),b=[[0,15],[20,4],[30,2],[40,4],[50,9],[60,4],[70,2],[80,4],[100,15]],g=0,p,j,h,f,k=1000000000,n=b.length;s=q=Math.floor(q/e)*e;if(l){for(h=0;h<n;h++){p=b[h][0];j=(p-o)<0?1000000:(p-o)/b[h][1];if(j<k){f=p;k=j}}c=Math.floor(c*Math.pow(10,-a))*Math.pow(10,a)+f*Math.pow(10,a-2);while(s<r){s+=c;g++}r=+s.toFixed(10)}else{g=d}return{from:q,to:r,power:a,step:c,steps:g}},snapEndsByDate:function(i,k,b,l){var e=false,g=[[Ext.Date.MILLI,[1,2,3,5,10,20,30,50,100,200,300,500]],[Ext.Date.SECOND,[1,2,3,5,10,15,30]],[Ext.Date.MINUTE,[1,2,3,5,10,20,30]],[Ext.Date.HOUR,[1,2,3,4,6,12]],[Ext.Date.DAY,[1,2,3,7,14]],[Ext.Date.MONTH,[1,2,3,4,6]]],f=g.length,h=false,c,d,a,m;for(m=0;m<f;m++){c=g[m];if(!h){for(d=0;d<c[1].length;d++){if(k<Ext.Date.add(i,c[0],c[1][d]*b)){e=[c[0],c[1][d]];h=true;break}}}}if(!e){a=this.snapEnds(i.getFullYear(),k.getFullYear()+1,b,l);e=[Date.YEAR,Math.round(a.step)]}return this.snapEndsByDateAndStep(i,k,e,l)},snapEndsByDateAndStep:function(h,g,e,a){var d=[h.getFullYear(),h.getMonth(),h.getDate(),h.getHours(),h.getMinutes(),h.getSeconds(),h.getMilliseconds()],b=0,f,c;if(a){f=h}else{switch(e[0]){case Ext.Date.MILLI:f=new Date(d[0],d[1],d[2],d[3],d[4],d[5],Math.floor(d[6]/e[1])*e[1]);break;case Ext.Date.SECOND:f=new Date(d[0],d[1],d[2],d[3],d[4],Math.floor(d[5]/e[1])*e[1],0);break;case Ext.Date.MINUTE:f=new Date(d[0],d[1],d[2],d[3],Math.floor(d[4]/e[1])*e[1],0,0);break;case Ext.Date.HOUR:f=new Date(d[0],d[1],d[2],Math.floor(d[3]/e[1])*e[1],0,0,0);break;case Ext.Date.DAY:f=new Date(d[0],d[1],Math.floor(d[2]-1/e[1])*e[1]+1,0,0,0,0);break;case Ext.Date.MONTH:f=new Date(d[0],Math.floor(d[1]/e[1])*e[1],1,0,0,0,0);break;default:f=new Date(Math.floor(d[0]/e[1])*e[1],0,1,0,0,0,0);break}}c=f;while(c<g){c=Ext.Date.add(c,e[0],e[1]);b++}if(a){c=g}return{from:+f,to:+c,step:(c-f)/b,steps:b}},sorter:function(d,c){return d.offset-c.offset},rad:function(a){return a%360*Math.PI/180},degrees:function(a){return a*180/Math.PI%360},withinBox:function(a,c,b){b=b||{};return(a>=b.x&&a<=(b.x+b.width)&&c>=b.y&&c<=(b.y+b.height))},parseGradient:function(j){var e=this,f=j.type||"linear",c=j.angle||0,h=e.radian,k=j.stops,a=[],i,b,g,d;if(f=="linear"){b=[0,0,Math.cos(c*h),Math.sin(c*h)];g=1/(Math.max(Math.abs(b[2]),Math.abs(b[3]))||1);b[2]*=g;b[3]*=g;if(b[2]<0){b[0]=-b[2];b[2]=0}if(b[3]<0){b[1]=-b[3];b[3]=0}}for(i in k){if(k.hasOwnProperty(i)&&e.stopsRE.test(i)){d={offset:parseInt(i,10),color:Ext.draw.Color.toHex(k[i].color)||"#ffffff",opacity:k[i].opacity||1};a.push(d)}}Ext.Array.sort(a,e.sorter);if(f=="linear"){return{id:j.id,type:f,vector:b,stops:a}}else{return{id:j.id,type:f,centerX:j.centerX,centerY:j.centerY,focalX:j.focalX,focalY:j.focalY,radius:j.radius,vector:b,stops:a}}}});Ext.define("Ext.util.Sorter",{direction:"ASC",constructor:function(a){var b=this;Ext.apply(b,a);b.updateSortFunction()},createSortFunction:function(b){var c=this,d=c.property,e=c.direction||"ASC",a=e.toUpperCase()=="DESC"?-1:1;return function(g,f){return a*b.call(c,g,f)}},defaultSorterFn:function(d,c){var b=this,a=b.transform,f=b.getRoot(d)[b.property],e=b.getRoot(c)[b.property];if(a){f=a(f);e=a(e)}return f>e?1:(f<e?-1:0)},getRoot:function(a){return this.root===undefined?a:a[this.root]},setDirection:function(b){var a=this;a.direction=b?b.toUpperCase():b;a.updateSortFunction()},toggle:function(){var a=this;a.direction=Ext.String.toggle(a.direction,"ASC","DESC");a.updateSortFunction()},updateSortFunction:function(a){var b=this;a=a||b.sorterFn||b.defaultSorterFn;b.sort=b.createSortFunction(a)}});Ext.define("Ext.data.Tree",{alias:"data.tree",mixins:{observable:"Ext.util.Observable"},root:null,constructor:function(a){var b=this;b.mixins.observable.constructor.call(b);if(a){b.setRootNode(a)}},getRootNode:function(){return this.root},setRootNode:function(b){var a=this;a.root=b;if(a.fireEvent("beforeappend",null,b)!==false){b.set("root",true);b.updateInfo();b.commit();b.on({scope:a,insert:a.onNodeInsert,append:a.onNodeAppend,remove:a.onNodeRemove});a.relayEvents(b,["append","remove","move","insert","beforeappend","beforeremove","beforemove","beforeinsert","expand","collapse","beforeexpand","beforecollapse","sort","rootchange"]);a.nodeHash={};a.registerNode(b);a.fireEvent("append",null,b);a.fireEvent("rootchange",b)}return b},flatten:function(){return Ext.Object.getValues(this.nodeHash)},onNodeInsert:function(a,b){this.registerNode(b,true)},onNodeAppend:function(a,b){this.registerNode(b,true)},onNodeRemove:function(a,b){this.unregisterNode(b,true)},onNodeIdChanged:function(c,d,a){var b=this.nodeHash;b[a]=c;delete b[d||c.internalId]},getNodeById:function(a){return this.nodeHash[a]},registerNode:function(c,a){var b=this;b.nodeHash[c.getId()||c.internalId]=c;c.on("idchanged",b.onNodeIdChanged,b);if(a===true){c.eachChild(function(d){b.registerNode(d,true)})}},unregisterNode:function(b,a){delete this.nodeHash[b.getId()||b.internalId];if(a===true){b.eachChild(function(c){this.unregisterNode(c,true)},this)}},sort:function(b,a){this.getRootNode().sort(b,a)},filter:function(b,a){this.getRootNode().filter(b,a)}});Ext.define("Ext.form.field.Field",{isFormField:true,disabled:false,submitValue:true,validateOnChange:true,suspendCheckChange:0,initField:function(){this.addEvents("change","validitychange","dirtychange");this.initValue()},initValue:function(){var a=this;a.value=a.transformOriginalValue(a.value);a.originalValue=a.lastValue=a.value;a.suspendCheckChange++;a.setValue(a.value);a.suspendCheckChange--},transformOriginalValue:function(a){return a},getName:function(){return this.name},getValue:function(){return this.value},setValue:function(b){var a=this;a.value=b;a.checkChange();return a},isEqual:function(b,a){return String(b)===String(a)},isEqualAsString:function(b,a){return String(Ext.value(b,""))===String(Ext.value(a,""))},getSubmitData:function(){var a=this,b=null;if(!a.disabled&&a.submitValue&&!a.isFileUpload()){b={};b[a.getName()]=""+a.getValue()}return b},getModelData:function(){var a=this,b=null;if(!a.disabled&&!a.isFileUpload()){b={};b[a.getName()]=a.getValue()}return b},reset:function(){var a=this;a.beforeReset();a.setValue(a.originalValue);a.clearInvalid();delete a.wasValid},beforeReset:Ext.emptyFn,resetOriginalValue:function(){this.originalValue=this.getValue();this.checkDirty()},checkChange:function(){if(!this.suspendCheckChange){var c=this,b=c.getValue(),a=c.lastValue;if(!c.isEqual(b,a)&&!c.isDestroyed){c.lastValue=b;c.fireEvent("change",c,b,a);c.onChange(b,a)}}},onChange:function(b,a){if(this.validateOnChange){this.validate()}this.checkDirty()},isDirty:function(){var a=this;return !a.disabled&&!a.isEqual(a.getValue(),a.originalValue)},checkDirty:function(){var a=this,b=a.isDirty();if(b!==a.wasDirty){a.fireEvent("dirtychange",a,b);a.onDirtyChange(b);a.wasDirty=b}},onDirtyChange:Ext.emptyFn,getErrors:function(a){return[]},isValid:function(){var a=this;return a.disabled||Ext.isEmpty(a.getErrors())},validate:function(){var a=this,b=a.isValid();if(b!==a.wasValid){a.wasValid=b;a.fireEvent("validitychange",a,b)}return b},batchChanges:function(a){try{this.suspendCheckChange++;a()}catch(b){throw b}finally{this.suspendCheckChange--}this.checkChange()},isFileUpload:function(){return false},extractFileInput:function(){return null},markInvalid:Ext.emptyFn,clearInvalid:Ext.emptyFn});Ext.define("Ext.util.Memento",(function(){function d(h,g,i,f){h[f?f+i:i]=g[i]}function c(g,f,h){delete g[h]}function e(j,i,k,h){var f=h?h+k:k,g=j[f];if(g||j.hasOwnProperty(f)){a(i,k,g)}}function a(g,h,f){if(Ext.isDefined(f)){g[h]=f}else{delete g[h]}}function b(g,l,k,h,i){if(l){if(Ext.isArray(h)){var j,f=h.length;for(j=0;j<f;j++){g(l,k,h[j],i)}}else{g(l,k,h,i)}}}return{data:null,target:null,constructor:function(g,f){if(g){this.target=g;if(f){this.capture(f)}}},capture:function(f,i,h){var g=this;b(d,g.data||(g.data={}),i||g.target,f,h)},remove:function(f){b(c,this.data,null,f)},restore:function(g,f,i,h){b(e,this.data,i||this.target,g,h);if(f!==false){this.remove(g)}},restoreAll:function(f,j){var h=this,g=j||this.target,i=h.data,k;for(k in i){if(i.hasOwnProperty(k)){a(g,k,i[k])}}if(f!==false){delete h.data}}}}()));Ext.define("Ext.dd.DragTracker",{uses:["Ext.util.Region"],mixins:{observable:"Ext.util.Observable"},active:false,trackOver:false,tolerance:5,autoStart:false,constructor:function(a){var b=this;Ext.apply(b,a);b.addEvents("mouseover","mouseout","mousedown","mouseup","mousemove","beforedragstart","dragstart","dragend","drag");b.dragRegion=new Ext.util.Region(0,0,0,0);if(b.el){b.initEl(b.el)}b.mixins.observable.constructor.call(b);if(b.disabled){b.disable()}},initEl:function(a){var b=this;b.el=Ext.get(a);b.handle=Ext.get(b.delegate);b.delegate=b.handle?undefined:b.delegate;if(!b.handle){b.handle=b.el}b.mon(b.handle,{mousedown:b.onMouseDown,delegate:b.delegate,scope:b});if(b.trackOver||b.overCls){b.mon(b.handle,{mouseover:b.onMouseOver,mouseout:b.onMouseOut,delegate:b.delegate,scope:b})}},disable:function(){this.disabled=true},enable:function(){this.disabled=false},destroy:function(){this.clearListeners();delete this.el},onMouseOver:function(c,b){var a=this;if(!a.disabled){if(Ext.EventManager.contains(c)||a.delegate){a.mouseIsOut=false;if(a.overCls){a.el.addCls(a.overCls)}a.fireEvent("mouseover",a,c,a.delegate?c.getTarget(a.delegate,b):a.handle)}}},onMouseOut:function(b){var a=this;if(a.mouseIsDown){a.mouseIsOut=true}else{if(a.overCls){a.el.removeCls(a.overCls)}a.fireEvent("mouseout",a,b)}},onMouseDown:function(d,c){var b=this,a;if(b.disabled||d.dragTracked){return}b.dragTarget=b.delegate?c:b.handle.dom;b.startXY=b.lastXY=d.getXY();b.startRegion=Ext.fly(b.dragTarget).getRegion();if(b.fireEvent("mousedown",b,d)===false||b.fireEvent("beforedragstart",b,d)===false||b.onBeforeStart(d)===false){return}b.mouseIsDown=true;d.dragTracked=true;a=b.el.dom;if(Ext.isIE&&a.setCapture){a.setCapture()}if(b.preventDefault!==false){d.preventDefault()}Ext.getDoc().on({scope:b,mouseup:b.onMouseUp,mousemove:b.onMouseMove,selectstart:b.stopSelect});if(b.autoStart){b.timer=Ext.defer(b.triggerStart,b.autoStart===true?1000:b.autoStart,b,[d])}},onMouseMove:function(f,d){var b=this,c=f.getXY(),a=b.startXY;f.preventDefault();b.lastXY=c;if(!b.active){if(Math.max(Math.abs(a[0]-c[0]),Math.abs(a[1]-c[1]))>b.tolerance){b.triggerStart(f)}else{return}}if(b.fireEvent("mousemove",b,f)===false){b.onMouseUp(f)}else{b.onDrag(f);b.fireEvent("drag",b,f)}},onMouseUp:function(b){var a=this;a.mouseIsDown=false;if(a.mouseIsOut){a.mouseIsOut=false;a.onMouseOut(b)}b.preventDefault();if(Ext.isIE&&document.releaseCapture){document.releaseCapture()}a.fireEvent("mouseup",a,b);a.endDrag(b)},endDrag:function(d){var b=this,c=Ext.getDoc(),a=b.active;c.un("mousemove",b.onMouseMove,b);c.un("mouseup",b.onMouseUp,b);c.un("selectstart",b.stopSelect,b);b.clearStart();b.active=false;if(a){b.onEnd(d);b.fireEvent("dragend",b,d)}delete b._constrainRegion;delete Ext.EventObject.dragTracked},triggerStart:function(b){var a=this;a.clearStart();a.active=true;a.onStart(b);a.fireEvent("dragstart",a,b)},clearStart:function(){var a=this.timer;if(a){clearTimeout(a);delete this.timer}},stopSelect:function(a){a.stopEvent();return false},onBeforeStart:function(a){},onStart:function(a){},onDrag:function(a){},onEnd:function(a){},getDragTarget:function(){return this.dragTarget},getDragCt:function(){return this.el},getConstrainRegion:function(){var a=this;if(a.constrainTo){if(a.constrainTo instanceof Ext.util.Region){return a.constrainTo}if(!a._constrainRegion){a._constrainRegion=Ext.fly(a.constrainTo).getViewRegion()}}else{if(!a._constrainRegion){a._constrainRegion=a.getDragCt().getViewRegion()}}return a._constrainRegion},getXY:function(a){return a?this.constrainModes[a](this,this.lastXY):this.lastXY},getOffset:function(c){var b=this.getXY(c),a=this.startXY;return[b[0]-a[0],b[1]-a[1]]},constrainModes:{point:function(b,d){var c=b.dragRegion,a=b.getConstrainRegion();if(!a){return d}c.x=c.left=c[0]=c.right=d[0];c.y=c.top=c[1]=c.bottom=d[1];c.constrainTo(a);return[c.left,c.top]},dragTarget:function(c,f){var b=c.startXY,e=c.startRegion.copy(),a=c.getConstrainRegion(),d;if(!a){return f}e.translateBy(f[0]-b[0],f[1]-b[1]);if(e.right>a.right){f[0]+=d=(a.right-e.right);e.left+=d}if(e.left<a.left){f[0]+=(a.left-e.left)}if(e.bottom>a.bottom){f[1]+=d=(a.bottom-e.bottom);e.top+=d}if(e.top<a.top){f[1]+=(a.top-e.top)}return f}}});Ext.define("Ext.util.Offset",{statics:{fromObject:function(a){return new this(a.x,a.y)}},constructor:function(a,b){this.x=(a!=null&&!isNaN(a))?a:0;this.y=(b!=null&&!isNaN(b))?b:0;return this},copy:function(){return new Ext.util.Offset(this.x,this.y)},copyFrom:function(a){this.x=a.x;this.y=a.y},toString:function(){return"Offset["+this.x+","+this.y+"]"},equals:function(a){return(this.x==a.x&&this.y==a.y)},round:function(b){if(!isNaN(b)){var a=Math.pow(10,b);this.x=Math.round(this.x*a)/a;this.y=Math.round(this.y*a)/a}else{this.x=Math.round(this.x);this.y=Math.round(this.y)}},isZero:function(){return this.x==0&&this.y==0}});Ext.define("Ext.util.Floating",{uses:["Ext.Layer","Ext.window.Window"],focusOnToFront:true,shadow:"sides",constructor:function(b){var a=this;a.el=new Ext.Layer(Ext.apply({hideMode:a.hideMode,hidden:a.hidden,shadow:(typeof a.shadow!="undefined")?a.shadow:"sides",shadowOffset:a.shadowOffset,constrain:false,shim:(a.shim===false)?false:undefined},a.floating),b);a.floating=true;a.registerWithOwnerCt()},registerWithOwnerCt:function(){var a=this;if(a.zIndexParent){a.zIndexParent.unregisterFloatingItem(a)}a.zIndexParent=a.up("[floating]");a.setFloatParent(a.ownerCt);delete a.ownerCt;if(a.zIndexParent){a.zIndexParent.registerFloatingItem(a)}else{Ext.WindowManager.register(a)}},setFloatParent:function(b){var a=this;if(a.floatParent){a.mun(a.floatParent,{hide:a.onFloatParentHide,show:a.onFloatParentShow,scope:a})}a.floatParent=b;if(b){a.mon(a.floatParent,{hide:a.onFloatParentHide,show:a.onFloatParentShow,scope:a})}if((a.constrain||a.constrainHeader)&&!a.constrainTo){a.constrainTo=b?b.getTargetEl():a.container}},onAfterFloatLayout:function(){this.syncShadow()},onFloatParentHide:function(){var a=this;if(a.hideOnParentHide!==false&&a.isVisible()){a.hide();a.showOnParentShow=true}},onFloatParentShow:function(){if(this.showOnParentShow){delete this.showOnParentShow;this.show()}},setZIndex:function(a){var b=this;b.el.setZIndex(a);a+=10;if(b.floatingDescendants){a=Math.floor(b.floatingDescendants.setBase(a)/100)*100+10000}return a},doConstrain:function(b){var c=this,a=c.getConstrainVector(b),d;if(a){d=c.getPosition(!!c.floatParent);d[0]+=a[0];d[1]+=a[1];c.setPosition(d)}},getConstrainVector:function(a){var b=this;if(b.constrain||b.constrainHeader){a=a||(b.floatParent&&b.floatParent.getTargetEl())||b.container||b.el.getScopeParent();return(b.constrainHeader?b.header.el:b.el).getConstrainVector(a)}},alignTo:function(b,a,c){this.setPagePosition(this.el.getAlignToXY(b.el||b,a,c));return this},toFront:function(b){var a=this;if(a.zIndexParent&&a.bringParentToFront!==false){a.zIndexParent.toFront(true)}if(!Ext.isDefined(b)){b=!a.focusOnToFront}if(b){a.preventFocusOnActivate=true}if(a.zIndexManager.bringToFront(a)){if(!b){a.focus(false,true)}}delete a.preventFocusOnActivate;return a},setActive:function(b,c){var a=this;if(b){if(a.el.shadow&&!a.maximized){a.el.enableShadow(true)}if(a.modal&&!a.preventFocusOnActivate){a.focus(false,true)}a.fireEvent("activate",a)}else{if(a.isWindow&&(c&&c.isWindow)){a.el.disableShadow()}a.fireEvent("deactivate",a)}},toBack:function(){this.zIndexManager.sendToBack(this);return this},center:function(){var a=this,b;if(a.isVisible()){b=a.el.getAlignToXY(a.container,"c-c");a.setPagePosition(b)}else{a.needsCenter=true}return a},onFloatShow:function(){if(this.needsCenter){this.center()}delete this.needsCenter},syncShadow:function(){if(this.floating){this.el.sync(true)}},fitContainer:function(){var c=this,b=c.floatParent,a=b?b.getTargetEl():c.container;c.setSize(a.getViewSize(false));c.setPosition.apply(c,b?[0,0]:a.getXY())}});Ext.define("Ext.util.ElementContainer",{childEls:[],constructor:function(){var b=this,a;if(b.hasOwnProperty("childEls")){a=b.childEls;delete b.childEls;b.addChildEls.apply(b,a)}},destroy:function(){var e=this,d=e.getChildEls(),f,a,c,b;for(c=d.length;c--;){a=d[c];if(typeof a!="string"){a=a.name}f=e[a];if(f){e[a]=null;f.remove()}}},addChildEls:function(){var b=this,a=arguments;if(b.hasOwnProperty("childEls")){b.childEls.push.apply(b.childEls,a)}else{b.childEls=b.getChildEls().concat(Array.prototype.slice.call(a))}b.prune(b.childEls,false)},applyChildEls:function(b,a){var e=this,f=e.getChildEls(),h,j,d,c,g;h=(a||e.id)+"-";for(d=f.length;d--;){j=f[d];if(typeof j=="string"){g=b.getById(h+j)}else{if((c=j.select)){g=Ext.select(c,true,b.dom)}else{if((c=j.selectNode)){g=Ext.get(Ext.DomQuery.selectNode(c,b.dom))}else{g=b.getById(j.id||(h+j.itemId))}}j=j.name}e[j]=g}},getChildEls:function(){var b=this,a;if(b.hasOwnProperty("childEls")){return b.childEls}a=b.self;return a.$childEls||b.getClassChildEls(a)},getClassChildEls:function(n){var j=this,o=n.$childEls,l,d,b,h,m,g,a,c,e,f,k;if(!o){f=n.superclass;if(f){f=f.self;c=[f.$childEls||j.getClassChildEls(f)];k=f.prototype.mixins||{}}else{c=[];k={}}e=n.prototype;g=e.mixins;for(a in g){if(g.hasOwnProperty(a)&&!k.hasOwnProperty(a)){m=g[a].self;c.push(m.$childEls||j.getClassChildEls(m))}}c.push(e.hasOwnProperty("childEls")&&e.childEls);for(d=0,b=c.length;d<b;++d){l=c[d];if(l&&l.length){if(!o){o=l}else{if(!h){h=true;o=o.slice(0)}o.push.apply(o,l)}}}n.$childEls=o=(o?j.prune(o,!h):[])}return o},prune:function(c,e){var b=c.length,d={},a;while(b--){a=c[b];if(typeof a!="string"){a=a.name}if(!d[a]){d[a]=1}else{if(e){e=false;c=c.slice(0)}Ext.Array.erase(c,b,1)}}return c},removeChildEls:function(f){var e=this,a=e.getChildEls(),d=(e.childEls=[]),g,b,c;for(b=0,g=a.length;b<g;++b){c=a[b];if(!f(c)){d.push(c)}}}});Ext.define("Ext.layout.container.boxOverflow.None",{alternateClassName:"Ext.layout.boxOverflow.None",constructor:function(b,a){this.layout=b;Ext.apply(this,a)},handleOverflow:Ext.emptyFn,clearOverflow:Ext.emptyFn,beginLayout:Ext.emptyFn,beginLayoutCycle:Ext.emptyFn,finishedLayout:Ext.emptyFn,completeLayout:function(b){var a=this,c=b.state.boxPlan,d;if(c&&c.tooNarrow){d=a.handleOverflow(b);if(d){if(d.reservedSpace){a.layout.publishInnerCtSize(b,d.reservedSpace)}}}else{a.clearOverflow()}},onRemove:Ext.emptyFn,getItem:function(a){return this.layout.owner.getComponent(a)},getOwnerType:function(a){var b;if(a.isToolbar){b="toolbar"}else{if(a.isTabBar){b="tabbar"}else{if(a.isMenu){b="menu"}else{b=a.getXType()}}}return b},getPrefixConfig:Ext.emptyFn,getSuffixConfig:Ext.emptyFn,getOverflowCls:function(){return""}});Ext.define("Ext.layout.container.boxOverflow.Scroller",{extend:"Ext.layout.container.boxOverflow.None",requires:["Ext.util.ClickRepeater","Ext.Element"],alternateClassName:"Ext.layout.boxOverflow.Scroller",mixins:{observable:"Ext.util.Observable"},animateScroll:false,scrollIncrement:20,wheelIncrement:10,scrollRepeatInterval:60,scrollDuration:400,scrollerCls:Ext.baseCSSPrefix+"box-scroller",constructor:function(c,a){var b=this;b.layout=c;Ext.apply(b,a||{});b.mixins.observable.constructor.call(b);b.addEvents("scroll");b.scrollPosition=0;b.scrollSize=0},getPrefixConfig:function(){var a=this;a.initCSSClasses();return{cls:Ext.layout.container.Box.prototype.innerCls+" "+a.beforeCtCls,cn:{id:a.layout.owner.id+"-before-scroller",cls:a.scrollerCls+" "+a.beforeScrollerCls,style:"display:none"}}},getSuffixConfig:function(){var a=this;return{cls:Ext.layout.container.Box.prototype.innerCls+" "+a.afterCtCls,cn:{id:a.layout.owner.id+"-after-scroller",cls:a.scrollerCls+" "+a.afterScrollerCls,style:"display:none"}}},getOverflowCls:function(){return Ext.baseCSSPrefix+this.layout.direction+"-box-overflow-body"},initCSSClasses:function(){var d=this,e=Ext.baseCSSPrefix,c=d.layout,f=c.getNames(),a=f.left,g=f.right,b=d.getOwnerType(c.owner);d.beforeCtCls=d.beforeCtCls||e+"box-scroller-"+a;d.afterCtCls=d.afterCtCls||e+"box-scroller-"+g;d.beforeScrollerCls=d.beforeScrollerCls||e+b+"-scroll-"+a;d.afterScrollerCls=d.afterScrollerCls||e+b+"-scroll-"+g},beginLayout:function(b){var a=this.layout,c=a.getNames();b.innerCtScrollPos=a.innerCt.dom["scroll"+c.leftCap];this.callParent(arguments)},completeLayout:function(a){this.scrollSize=a.props["content"+this.layout.getNames().widthCap];this.callParent(arguments)},finishedLayout:function(c){var b=this,a=b.layout,d=a.getNames(),e=Math.min(b.getMaxScrollPosition(),c.innerCtScrollPos);a.innerCt.dom["scroll"+d.leftCap]=e},handleOverflow:function(d){var c=this,b=c.layout,e=b.getNames(),a="get"+e.widthCap;c.captureChildElements();c.showScrollers();return{reservedSpace:c.beforeCt[a]()+c.afterCt[a]()}},captureChildElements:function(){var b=this,a=b.layout.owner.el,c,d;if(!b.beforeCt){c=b.beforeScroller=a.getById(b.layout.owner.id+"-before-scroller");d=b.afterScroller=a.getById(b.layout.owner.id+"-after-scroller");b.beforeCt=c.up("");b.afterCt=d.up("");b.createWheelListener();c.addClsOnOver(b.beforeScrollerCls+"-hover");d.addClsOnOver(b.afterScrollerCls+"-hover");c.setVisibilityMode(Ext.Element.DISPLAY);d.setVisibilityMode(Ext.Element.DISPLAY);b.beforeRepeater=new Ext.util.ClickRepeater(c,{interval:b.scrollRepeatInterval,handler:b.scrollLeft,scope:b});b.afterRepeater=new Ext.util.ClickRepeater(d,{interval:b.scrollRepeatInterval,handler:b.scrollRight,scope:b})}},createWheelListener:function(){this.layout.innerCt.on({mousewheel:function(a){this.scrollBy(a.getWheelDelta()*this.wheelIncrement*-1,false)},stopEvent:true,scope:this})},clearOverflow:function(){var a=this.layout;this.hideScrollers()},showScrollers:function(){var a=this;a.captureChildElements();a.beforeScroller.show();a.afterScroller.show();a.updateScrollButtons();a.layout.owner.addClsWithUI("scroller")},hideScrollers:function(){var a=this;if(a.beforeScroller!==undefined){a.beforeScroller.hide();a.afterScroller.hide();a.layout.owner.removeClsWithUI("scroller")}},destroy:function(){var a=this;Ext.destroy(a.beforeRepeater,a.afterRepeater,a.beforeScroller,a.afterScroller,a.beforeCt,a.afterCt)},scrollBy:function(b,a){this.scrollTo(this.getScrollPosition()+b,a)},getScrollAnim:function(){return{duration:this.scrollDuration,callback:this.updateScrollButtons,scope:this}},updateScrollButtons:function(){var d=this,e,c,a,b;if(d.beforeScroller===undefined||d.afterScroller===undefined){return}e=d.atExtremeBefore()?"addCls":"removeCls";c=d.atExtremeAfter()?"addCls":"removeCls";a=d.beforeScrollerCls+"-disabled";b=d.afterScrollerCls+"-disabled";d.beforeScroller[e](a);d.afterScroller[c](b);d.scrolling=false},atExtremeBefore:function(){return !this.getScrollPosition()},scrollLeft:function(){this.scrollBy(-this.scrollIncrement,false)},scrollRight:function(){this.scrollBy(this.scrollIncrement,false)},getScrollPosition:function(){var c=this,b=c.layout,a;if(c.hasOwnProperty("scrollPosition")){a=c.scrollPosition}else{a=parseInt(b.innerCt.dom["scroll"+b.getNames().leftCap],10)||0}return a},getMaxScrollPosition:function(){var b=this,a=b.layout,c=a.getNames(),d=b.scrollSize-a.innerCt["get"+c.widthCap]();return(d<0)?0:d},atExtremeAfter:function(){return this.getScrollPosition()>=this.getMaxScrollPosition()},scrollTo:function(a,b){var f=this,e=f.layout,g=e.getNames(),d=f.getScrollPosition(),c=Ext.Number.constrain(a,0,f.getMaxScrollPosition());if(c!=d&&!f.scrolling){delete f.scrollPosition;if(b===undefined){b=f.animateScroll}e.innerCt.scrollTo(g.left,c,b?f.getScrollAnim():false);if(b){f.scrolling=true}else{f.updateScrollButtons()}f.fireEvent("scroll",f,c,b?f.getScrollAnim():false)}},scrollToItem:function(g,b){var f=this,e=f.layout,h=e.getNames(),a,d,c;g=f.getItem(g);if(g!==undefined){a=f.getItemVisibility(g);if(!a.fullyVisible){d=g.getBox(true,true);c=d[h.x];if(a.hiddenEnd){c-=(f.layout.innerCt["get"+h.widthCap]()-d[h.width])}f.scrollTo(c,b)}}},getItemVisibility:function(i){var g=this,b=g.getItem(i).getBox(true,true),c=g.layout,f=c.getNames(),e=b[f.x],d=e+b[f.width],a=g.getScrollPosition(),h=a+c.innerCt["get"+f.widthCap]();return{hiddenStart:e<a,hiddenEnd:d>h,fullyVisible:e>a&&d<h}}});Ext.define("Ext.data.association.Association",{alternateClassName:"Ext.data.Association",primaryKey:"id",defaultReaderType:"json",isAssociation:true,initialConfig:null,statics:{AUTO_ID:1000,create:function(a){if(Ext.isString(a)){a={type:a}}switch(a.type){case"belongsTo":return new Ext.data.association.BelongsTo(a);case"hasMany":return new Ext.data.association.HasMany(a);case"hasOne":return new Ext.data.association.HasOne(a);default:}return a}},constructor:function(a){Ext.apply(this,a);var d=this,b=Ext.ModelManager.types,c=a.ownerModel,f=a.associatedModel,e=b[c],g=b[f];d.initialConfig=a;d.ownerModel=e;d.associatedModel=g;Ext.applyIf(d,{ownerName:c,associatedName:f});d.associationId="association"+(++d.statics().AUTO_ID)},getReader:function(){var c=this,a=c.reader,b=c.associatedModel;if(a){if(Ext.isString(a)){a={type:a}}if(a.isReader){a.setModel(b)}else{Ext.applyIf(a,{model:b,type:c.defaultReaderType})}c.reader=Ext.createByAlias("reader."+a.type,a)}return c.reader||null}});Ext.define("Ext.data.SortTypes",{singleton:true,none:function(a){return a},stripTagsRE:/<\/?[^>]+>/gi,asText:function(a){return String(a).replace(this.stripTagsRE,"")},asUCText:function(a){return String(a).toUpperCase().replace(this.stripTagsRE,"")},asUCString:function(a){return String(a).toUpperCase()},asDate:function(a){if(!a){return 0}if(Ext.isDate(a)){return a.getTime()}return Date.parse(String(a))},asFloat:function(a){var b=parseFloat(String(a).replace(/,/g,""));return isNaN(b)?0:b},asInt:function(a){var b=parseInt(String(a).replace(/,/g,""),10);return isNaN(b)?0:b}});Ext.define("Ext.util.Sortable",{isSortable:true,defaultSortDirection:"ASC",requires:["Ext.util.Sorter"],initSortable:function(){var a=this,b=a.sorters;a.sorters=new Ext.util.AbstractMixedCollection(false,function(c){return c.id||c.property});if(b){a.sorters.addAll(a.decodeSorters(b))}},sort:function(g,f,c,e){var d=this,h,b,a;if(Ext.isArray(g)){e=c;c=f;a=g}else{if(Ext.isObject(g)){e=c;c=f;a=[g]}else{if(Ext.isString(g)){h=d.sorters.get(g);if(!h){h={property:g,direction:f};a=[h]}else{if(f===undefined){h.toggle()}else{h.setDirection(f)}}}}}if(a&&a.length){a=d.decodeSorters(a);if(Ext.isString(c)){if(c==="prepend"){g=d.sorters.clone().items;d.sorters.clear();d.sorters.addAll(a);d.sorters.addAll(g)}else{d.sorters.addAll(a)}}else{d.sorters.clear();d.sorters.addAll(a)}}if(e!==false){d.onBeforeSort(a);g=d.sorters.items;if(g.length){d.doSort(d.generateComparator())}}return g},generateComparator:function(){var a=this.sorters.getRange();return a.length?this.createComparator(a):this.emptyComparator},createComparator:function(a){return function(d,c){var b=a[0].sort(d,c),f=a.length,e=1;for(;e<f;e++){b=b||a[e].sort.call(this,d,c)}return b}},emptyComparator:function(){return 0},onBeforeSort:Ext.emptyFn,decodeSorters:function(f){if(!Ext.isArray(f)){if(f===undefined){f=[]}else{f=[f]}}var d=f.length,g=Ext.util.Sorter,a=this.model?this.model.prototype.fields:null,e,b,c;for(c=0;c<d;c++){b=f[c];if(!(b instanceof g)){if(Ext.isString(b)){b={property:b}}Ext.applyIf(b,{root:this.sortRoot,direction:"ASC"});if(b.fn){b.sorterFn=b.fn}if(typeof b=="function"){b={sorterFn:b}}if(a&&!b.transform){e=a.get(b.property);b.transform=e?e.sortType:undefined}f[c]=new Ext.util.Sorter(b)}}return f},getSorters:function(){return this.sorters.items},getFirstSorter:function(){var c=this.sorters.items,a=c.length,b=0,d;for(;b<a;++b){d=c[b];if(!d.isGrouper){return d}}return null}});Ext.define("Ext.fx.CubicBezier",{singleton:true,cubicBezierAtTime:function(n,d,b,m,l,h){var i=3*d,k=3*(m-d)-i,a=1-i-k,g=3*b,j=3*(l-b)-g,o=1-g-j;function f(p){return((a*p+k)*p+i)*p}function c(p,r){var q=e(p,r);return((o*q+j)*q+g)*q}function e(p,w){var v,u,s,q,t,r;for(s=p,r=0;r<8;r++){q=f(s)-p;if(Math.abs(q)<w){return s}t=(3*a*s+2*k)*s+i;if(Math.abs(t)<0.000001){break}s=s-q/t}v=0;u=1;s=p;if(s<v){return v}if(s>u){return u}while(v<u){q=f(s);if(Math.abs(q-p)<w){return s}if(p>q){v=s}else{u=s}s=(u-v)/2+v}return s}return c(n,1/(200*h))},cubicBezier:function(b,e,a,c){var d=function(f){return Ext.fx.CubicBezier.cubicBezierAtTime(f,b,e,a,c,1)};d.toCSS3=function(){return"cubic-bezier("+[b,e,a,c].join(",")+")"};d.reverse=function(){return Ext.fx.CubicBezier.cubicBezier(1-a,1-c,1-b,1-e)};return d}});Ext.define("Ext.fx.PropertyHandler",{requires:["Ext.draw.Draw"],statics:{defaultHandler:{pixelDefaultsRE:/width|height|top$|bottom$|left$|right$/i,unitRE:/^(-?\d*\.?\d*){1}(em|ex|px|in|cm|mm|pt|pc|%)*$/,scrollRE:/^scroll/i,computeDelta:function(i,c,a,f,h){a=(typeof a=="number")?a:1;var g=this.unitRE,d=g.exec(i),b,e;if(d){i=d[1];e=d[2];if(!this.scrollRE.test(h)&&!e&&this.pixelDefaultsRE.test(h)){e="px"}}i=+i||0;d=g.exec(c);if(d){c=d[1];e=d[2]||e}c=+c||0;b=(f!=null)?f:i;return{from:i,delta:(c-b)*a,units:e}},get:function(n,b,a,m,h){var l=n.length,d=[],e,g,k,c,f;for(e=0;e<l;e++){if(m){g=m[e][1].from}if(Ext.isArray(n[e][1])&&Ext.isArray(b)){k=[];c=0;f=n[e][1].length;for(;c<f;c++){k.push(this.computeDelta(n[e][1][c],b[c],a,g,h))}d.push([n[e][0],k])}else{d.push([n[e][0],this.computeDelta(n[e][1],b,a,g,h)])}}return d},set:function(k,f){var g=k.length,c=[],d,a,h,e,b;for(d=0;d<g;d++){a=k[d][1];if(Ext.isArray(a)){h=[];b=0;e=a.length;for(;b<e;b++){h.push(a[b].from+a[b].delta*f+(a[b].units||0))}c.push([k[d][0],h])}else{c.push([k[d][0],a.from+a.delta*f+(a.units||0)])}}return c}},stringHandler:{computeDelta:function(e,b,d,c,a){return{from:e,delta:b}},get:function(n,b,a,m,h){var l=n.length,d=[],e,g,k,c,f;for(e=0;e<l;e++){d.push([n[e][0],this.computeDelta(n[e][1],b,a,g,h)])}return d},set:function(k,f){var g=k.length,c=[],d,a,h,e,b;for(d=0;d<g;d++){a=k[d][1];c.push([k[d][0],a.delta])}return c}},color:{rgbRE:/^rgb\(([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\)$/i,hexRE:/^#?([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$/i,hex3RE:/^#?([0-9A-F]{1})([0-9A-F]{1})([0-9A-F]{1})$/i,parseColor:function(e,a){a=(typeof a=="number")?a:1;var f=false,c=[this.hexRE,this.rgbRE,this.hex3RE],d=c.length,h,b,j,g;for(g=0;g<d;g++){j=c[g];b=(g%2===0)?16:10;h=j.exec(e);if(h&&h.length===4){if(g===2){h[1]+=h[1];h[2]+=h[2];h[3]+=h[3]}f={red:parseInt(h[1],b),green:parseInt(h[2],b),blue:parseInt(h[3],b)};break}}return f||e},computeDelta:function(g,a,e,c){g=this.parseColor(g);a=this.parseColor(a,e);var f=c?c:g,b=typeof f,d=typeof a;if(b=="string"||b=="undefined"||d=="string"||d=="undefined"){return a||f}return{from:g,delta:{red:Math.round((a.red-f.red)*e),green:Math.round((a.green-f.green)*e),blue:Math.round((a.blue-f.blue)*e)}}},get:function(h,a,f,d){var g=h.length,c=[],e,b;for(e=0;e<g;e++){if(d){b=d[e][1].from}c.push([h[e][0],this.computeDelta(h[e][1],a,f,b)])}return c},set:function(j,e){var f=j.length,c=[],d,b,a,g,h;for(d=0;d<f;d++){b=j[d][1];if(b){g=b.from;h=b.delta;b=(typeof b=="object"&&"red" in b)?"rgb("+b.red+", "+b.green+", "+b.blue+")":b;b=(typeof b=="object"&&b.length)?b[0]:b;if(typeof b=="undefined"){return[]}a=typeof b=="string"?b:"rgb("+[(g.red+Math.round(h.red*e))%256,(g.green+Math.round(h.green*e))%256,(g.blue+Math.round(h.blue*e))%256].join(",")+")";c.push([j[d][0],a])}}return c}},object:{interpolate:function(d,b){b=(typeof b=="number")?b:1;var a={},c;for(c in d){a[c]=parseFloat(d[c])*b}return a},computeDelta:function(g,a,c,b){g=this.interpolate(g);a=this.interpolate(a,c);var f=b?b:g,e={},d;for(d in a){e[d]=a[d]-f[d]}return{from:g,delta:e}},get:function(h,a,f,d){var g=h.length,c=[],e,b;for(e=0;e<g;e++){if(d){b=d[e][1].from}c.push([h[e][0],this.computeDelta(h[e][1],a,f,b)])}return c},set:function(k,f){var g=k.length,c=[],e={},d,h,j,b,a;for(d=0;d<g;d++){b=k[d][1];h=b.from;j=b.delta;for(a in h){e[a]=h[a]+j[a]*f}c.push([k[d][0],e])}return c}},path:{computeDelta:function(e,a,c,b){c=(typeof c=="number")?c:1;var d;e=+e||0;a=+a||0;d=(b!=null)?b:e;return{from:e,delta:(a-d)*c}},forcePath:function(a){if(!Ext.isArray(a)&&!Ext.isArray(a[0])){a=Ext.draw.Draw.parsePathString(a)}return a},get:function(b,h,a,p){var c=this.forcePath(h),m=[],r=b.length,d,g,n,f,o,l,e,s,q;for(n=0;n<r;n++){q=this.forcePath(b[n][1]);f=Ext.draw.Draw.interpolatePaths(q,c);q=f[0];c=f[1];d=q.length;s=[];for(l=0;l<d;l++){f=[q[l][0]];g=q[l].length;for(e=1;e<g;e++){o=p&&p[0][1][l][e].from;f.push(this.computeDelta(q[l][e],c[l][e],a,o))}s.push(f)}m.push([b[n][0],s])}return m},set:function(o,m){var n=o.length,e=[],g,f,d,h,l,c,a,b;for(g=0;g<n;g++){c=o[g][1];h=[];a=c.length;for(f=0;f<a;f++){l=[c[f][0]];b=c[f].length;for(d=1;d<b;d++){l.push(c[f][d].from+c[f][d].delta*m)}h.push(l.join(","))}e.push([o[g][0],h.join(",")])}return e}}}},function(){var b=["outlineColor","backgroundColor","borderColor","borderTopColor","borderRightColor","borderBottomColor","borderLeftColor","fill","stroke"],c=b.length,a=0,d;for(;a<c;a++){d=b[a];this[d]=this.color}b=["cursor"];c=b.length;a=0;for(;a<c;a++){d=b[a];this[d]=this.stringHandler}});Ext.define("Ext.util.Animate",{uses:["Ext.fx.Manager","Ext.fx.Anim"],animate:function(a){var b=this;if(Ext.fx.Manager.hasFxBlock(b.id)){return b}Ext.fx.Manager.queueFx(new Ext.fx.Anim(b.anim(a)));return this},anim:function(a){if(!Ext.isObject(a)){return(a)?{}:false}var b=this;if(a.stopAnimation){b.stopAnimation()}Ext.applyIf(a,Ext.fx.Manager.getFxDefaults(b.id));return Ext.apply({target:b,paused:true},a)},stopFx:Ext.Function.alias(Ext.util.Animate,"stopAnimation"),stopAnimation:function(){Ext.fx.Manager.stopAnimation(this.id);return this},syncFx:function(){Ext.fx.Manager.setFxDefaults(this.id,{concurrent:true});return this},sequenceFx:function(){Ext.fx.Manager.setFxDefaults(this.id,{concurrent:false});return this},hasActiveFx:Ext.Function.alias(Ext.util.Animate,"getActiveAnimation"),getActiveAnimation:function(){return Ext.fx.Manager.getActiveAnimation(this.id)}},function(){Ext.applyIf(Ext.Element.prototype,this.prototype);Ext.CompositeElementLite.importElementMethods()});Ext.define("Ext.util.KeyNav",{alternateClassName:"Ext.KeyNav",requires:["Ext.util.KeyMap"],statics:{keyOptions:{left:37,right:39,up:38,down:40,space:32,pageUp:33,pageDown:34,del:46,backspace:8,home:36,end:35,enter:13,esc:27,tab:9}},constructor:function(a){var b=this;if(arguments.length===2){b.legacyConstructor.apply(b,arguments);return}b.setConfig(a)},legacyConstructor:function(b,a){this.setConfig(Ext.apply({target:b},a))},setConfig:function(b){var e=this,c={target:b.target,ignoreInputFields:b.ignoreInputFields,eventName:e.getKeyEvent("forceKeyDown" in b?b.forceKeyDown:e.forceKeyDown,b.eventName)},f,a,h,d,g;if(e.map){e.map.destroy()}if(b.processEvent){c.processEvent=b.processEvent;c.processEventScope=b.processEventScope||e}f=e.map=new Ext.util.KeyMap(c);a=Ext.util.KeyNav.keyOptions;h=b.scope||e;for(d in a){if(a.hasOwnProperty(d)){if(g=b[d]){if(typeof g==="function"){g={handler:g,defaultAction:(b.defaultEventAction!==undefined)?b.defaultEventAction:e.defaultEventAction}}f.addBinding({key:a[d],handler:Ext.Function.bind(e.handleEvent,g.scope||h,g.handler||g.fn,true),defaultEventAction:(g.defaultEventAction!==undefined)?g.defaultAction:e.defaultEventAction})}}}f.disable();if(!b.disabled){f.enable()}},handleEvent:function(c,b,a){return a.call(this,b)},disabled:false,defaultEventAction:"stopEvent",forceKeyDown:false,eventName:"keypress",destroy:function(a){this.map.destroy(a);delete this.map},enable:function(){this.map.enable();this.disabled=false},disable:function(){this.map.disable();this.disabled=true},setDisabled:function(a){this.map.setDisabled(a);this.disabled=a},getKeyEvent:function(b,a){if(b||(Ext.EventManager.useKeyDown&&!a)){return"keydown"}else{return a||this.eventName}}});Ext.define("Ext.data.proxy.Proxy",{alias:"proxy.proxy",alternateClassName:["Ext.data.DataProxy","Ext.data.Proxy"],uses:["Ext.data.Batch","Ext.data.Operation","Ext.data.Model"],mixins:{observable:"Ext.util.Observable"},batchOrder:"create,update,destroy",batchActions:true,defaultReaderType:"json",defaultWriterType:"json",isProxy:true,constructor:function(a){a=a||{};if(a.model===undefined){delete a.model}this.mixins.observable.constructor.call(this,a);if(this.model!==undefined&&!(this.model instanceof Ext.data.Model)){this.setModel(this.model)}},setModel:function(b,c){this.model=Ext.ModelManager.getModel(b);var a=this.reader,d=this.writer;this.setReader(a);this.setWriter(d);if(c&&this.store){this.store.setModel(this.model)}},getModel:function(){return this.model},setReader:function(a){var c=this,b=true;if(a===undefined||typeof a=="string"){a={type:a};b=false}if(a.isReader){a.setModel(c.model)}else{if(b){a=Ext.apply({},a)}Ext.applyIf(a,{proxy:c,model:c.model,type:c.defaultReaderType});a=Ext.createByAlias("reader."+a.type,a)}if(a.onMetaChange){a.onMetaChange=Ext.Function.createSequence(a.onMetaChange,this.onMetaChange,this)}c.reader=a;return c.reader},getReader:function(){return this.reader},onMetaChange:function(a){this.fireEvent("metachange",this,a)},setWriter:function(c){var b=this,a=true;if(c===undefined||typeof c=="string"){c={type:c};a=false}if(!c.isWriter){if(a){c=Ext.apply({},c)}Ext.applyIf(c,{model:b.model,type:b.defaultWriterType});c=Ext.createByAlias("writer."+c.type,c)}b.writer=c;return b.writer},getWriter:function(){return this.writer},create:Ext.emptyFn,read:Ext.emptyFn,update:Ext.emptyFn,destroy:Ext.emptyFn,batch:function(n,k){var j=this,i=j.batchActions,g,c,f,d,e,l,b,m,h;if(n.operations===undefined){n={operations:n,listeners:k}}if(n.batch){if(Ext.isDefined(n.batch.runOperation)){g=Ext.applyIf(n.batch,{proxy:j,listeners:{}})}}else{n.batch={proxy:j,listeners:n.listeners||{}}}if(!g){g=new Ext.data.Batch(n.batch)}g.on("complete",Ext.bind(j.onBatchComplete,j,[n],0));f=j.batchOrder.split(",");d=f.length;for(l=0;l<d;l++){e=f[l];c=n.operations[e];if(c){if(i){g.add(new Ext.data.Operation({action:e,records:c}))}else{m=c.length;for(b=0;b<m;b++){h=c[b];g.add(new Ext.data.Operation({action:e,records:[h]}))}}}}g.start();return g},onBatchComplete:function(a,b){var c=a.scope||this;if(b.hasException){if(Ext.isFunction(a.failure)){Ext.callback(a.failure,c,[b,a])}}else{if(Ext.isFunction(a.success)){Ext.callback(a.success,c,[b,a])}}if(Ext.isFunction(a.callback)){Ext.callback(a.callback,c,[b,a])}}},function(){Ext.data.DataProxy=this});Ext.define("Ext.util.Filter",{anyMatch:false,exactMatch:false,caseSensitive:false,constructor:function(a){var b=this;Ext.apply(b,a);b.filter=b.filter||b.filterFn;if(b.filter===undefined){if(b.property===undefined||b.value===undefined){}else{b.filter=b.createFilterFn()}b.filterFn=b.filter}},createFilterFn:function(){var a=this,c=a.createValueMatcher(),b=a.property;return function(d){var e=a.getRoot.call(a,d)[b];return c===null?e===null:c.test(e)}},getRoot:function(b){var a=this.root;return a===undefined?b:b[a]},createValueMatcher:function(){var d=this,e=d.value,f=d.anyMatch,c=d.exactMatch,a=d.caseSensitive,b=Ext.String.escapeRegex;if(e===null){return e}if(!e.exec){e=String(e);if(f===true){e=b(e)}else{e="^"+b(e);if(c===true){e+="$"}}e=new RegExp(e,a?"":"i")}return e}});Ext.define("Ext.ZIndexManager",{alternateClassName:"Ext.WindowGroup",statics:{zBase:9000},constructor:function(a){var b=this;b.list={};b.zIndexStack=[];b.front=null;if(a){if(a.isContainer){a.on("resize",b._onContainerResize,b);b.zseed=Ext.Number.from(b.rendered?a.getEl().getStyle("zIndex"):undefined,b.getNextZSeed());b.targetEl=a.getTargetEl();b.container=a}else{Ext.EventManager.onWindowResize(b._onContainerResize,b);b.zseed=b.getNextZSeed();b.targetEl=Ext.get(a)}}else{Ext.EventManager.onWindowResize(b._onContainerResize,b);b.zseed=b.getNextZSeed();Ext.onDocumentReady(function(){b.targetEl=Ext.getBody()})}},getNextZSeed:function(){return(Ext.ZIndexManager.zBase+=10000)},setBase:function(b){this.zseed=b;var a=this.assignZIndices();this._activateLast();return a},assignZIndices:function(){var c=this.zIndexStack,b=c.length,e=0,f=this.zseed,d;for(;e<b;e++){d=c[e];if(d&&!d.hidden){f=d.setZIndex(f)}}this._activateLast();return f},_setActiveChild:function(b,a){var c=this.front;if(b!==c){if(c&&!c.destroying){c.setActive(false,b)}this.front=b;if(b&&b!=a){b.setActive(true);if(b.modal){this._showModalMask(b)}}}},onComponentHide:function(a){a.setActive(false);this._activateLast()},_activateLast:function(){var e=this,a=e.zIndexStack,d=a.length-1,c=e.front,b;e.front=undefined;for(;d>=0&&a[d].hidden;--d){}if((b=a[d])){e._setActiveChild(b,c);if(b.modal){return}}for(;d>=0;--d){b=a[d];if(b.isVisible()&&b.modal){e._showModalMask(b);return}}e._hideModalMask()},_showModalMask:function(a){var c=this,e=a.el.getStyle("zIndex")-4,b=a.floatParent?a.floatParent.getTargetEl():a.container,d=b.getBox();if(b.dom===document.body){d.height=Math.max(document.body.scrollHeight,Ext.dom.Element.getDocumentHeight());d.width=Math.max(document.body.scrollWidth,d.width)}if(!c.mask){c.mask=Ext.getBody().createChild({cls:Ext.baseCSSPrefix+"mask"});c.mask.setVisibilityMode(Ext.Element.DISPLAY);c.mask.on("click",c._onMaskClick,c)}c.mask.maskTarget=b;b.addCls(Ext.baseCSSPrefix+"body-masked");c.mask.setStyle("zIndex",e);c.mask.show();c.mask.setBox(d)},_hideModalMask:function(){var a=this.mask;if(a&&a.isVisible()){a.maskTarget.removeCls(Ext.baseCSSPrefix+"body-masked");a.maskTarget=undefined;a.hide()}},_onMaskClick:function(){if(this.front){this.front.focus()}},_onContainerResize:function(){var a=this.mask,b,c;if(a&&a.isVisible()){a.hide();b=a.maskTarget;if(b.dom===document.body){c={height:Math.max(document.body.scrollHeight,Ext.dom.Element.getDocumentHeight()),width:Math.max(document.body.scrollWidth,document.documentElement.clientWidth)}}else{c=b.getViewSize(true)}a.setSize(c);a.show()}},register:function(a){var b=this;if(a.zIndexManager){a.zIndexManager.unregister(a)}a.zIndexManager=b;b.list[a.id]=a;b.zIndexStack.push(a);a.on("hide",b.onComponentHide,b)},unregister:function(a){var b=this,c=b.list;delete a.zIndexManager;if(c&&c[a.id]){delete c[a.id];a.un("hide",b.onComponentHide);Ext.Array.remove(b.zIndexStack,a);b._activateLast()}},get:function(a){return a.isComponent?a:this.list[a]},bringToFront:function(b){var c=this,a=false,d=c.zIndexStack;b=c.get(b);if(b!==c.front){Ext.Array.remove(d,b);if(b.preventBringToFront){d.unshift(b)}else{d.push(b)}c.assignZIndices();a=true;this.front=b}if(a&&b.modal){c._showModalMask(b)}return a},sendToBack:function(a){var b=this;a=b.get(a);Ext.Array.remove(b.zIndexStack,a);b.zIndexStack.unshift(a);b.assignZIndices();this._activateLast();return a},hideAll:function(){var b=this.list,a,c;for(c in b){if(b.hasOwnProperty(c)){a=b[c];if(a.isComponent&&a.isVisible()){a.hide()}}}},hide:function(){var f=this,c=f.mask,e=0,b=f.zIndexStack,a=b.length,d;f.tempHidden=f.tempHidden||[];for(;e<a;e++){d=b[e];if(d.isVisible()){f.tempHidden.push(d);d.el.hide()}}if(c){c.hide()}},show:function(){var e=this,b=e.mask,d=0,f=e.tempHidden,a=f?f.length:0,c;for(;d<a;d++){c=f[d];c.el.show();c.setPosition(c.x,c.y)}e.tempHidden.length=0;if(b){b.show();b.alignTo(b.maskTarget,"tl-tl")}},getActive:function(){return this.front},getBy:function(f,e){var g=[],d=0,b=this.zIndexStack,a=b.length,c;for(;d<a;d++){c=b[d];if(f.call(e||c,c)!==false){g.push(c)}}return g},each:function(c,b){var d=this.list,e,a;for(e in d){if(d.hasOwnProperty(e)){a=d[e];if(a.isComponent&&c.call(b||a,a)===false){return}}}},eachBottomUp:function(f,e){var b=this.zIndexStack,d=0,a=b.length,c;for(;d<a;d++){c=b[d];if(c.isComponent&&f.call(e||c,c)===false){return}}},eachTopDown:function(e,d){var a=this.zIndexStack,c=a.length,b;for(;c-->0;){b=a[c];if(b.isComponent&&e.call(d||b,b)===false){return}}},destroy:function(){var b=this,c=b.list,a,d;for(d in c){if(c.hasOwnProperty(d)){a=c[d];if(a.isComponent){a.destroy()}}}delete b.zIndexStack;delete b.list;delete b.container;delete b.targetEl}},function(){Ext.WindowManager=Ext.WindowMgr=new this()});Ext.define("Ext.panel.Proxy",{alternateClassName:"Ext.dd.PanelProxy",moveOnDrag:true,constructor:function(a,b){var c=this;c.panel=a;c.id=c.panel.id+"-ddproxy";Ext.apply(c,b)},insertProxy:true,setStatus:Ext.emptyFn,reset:Ext.emptyFn,update:Ext.emptyFn,stop:Ext.emptyFn,sync:Ext.emptyFn,getEl:function(){return this.ghost.el},getGhost:function(){return this.ghost},getProxy:function(){return this.proxy},hide:function(){var a=this;if(a.ghost){if(a.proxy){a.proxy.remove();delete a.proxy}a.panel.unghost(null,a.moveOnDrag);delete a.ghost}},show:function(){var b=this,a;if(!b.ghost){a=b.panel.getSize();b.panel.el.setVisibilityMode(Ext.Element.DISPLAY);b.ghost=b.panel.ghost();if(b.insertProxy){b.proxy=b.panel.el.insertSibling({cls:Ext.baseCSSPrefix+"panel-dd-spacer"});b.proxy.setSize(a)}}},repair:function(b,c,a){this.hide();Ext.callback(c,a||this)},moveProxy:function(a,b){if(this.proxy){a.insertBefore(this.proxy.dom,b)}}});Ext.define("Ext.XTemplateParser",{constructor:function(a){Ext.apply(this,a)},doTpl:Ext.emptyFn,parse:function(k){var u=this,o=k.length,n={elseif:"elif"},p=u.topRe,c=u.actionsRe,e,d,i,l,g,j,h,r,q,b,f,a;u.level=0;u.stack=d=[];for(e=0;e<o;e=b){p.lastIndex=e;l=p.exec(k);if(!l){u.doText(k.substring(e,o));break}q=l.index;b=p.lastIndex;if(e<q){u.doText(k.substring(e,q))}if(l[1]){b=k.indexOf("%}",q+2);u.doEval(k.substring(q+2,b));b+=2}else{if(l[2]){b=k.indexOf("]}",q+2);u.doExpr(k.substring(q+2,b));b+=2}else{if(l[3]){u.doTag(l[3])}else{if(l[4]){f=null;while((r=c.exec(l[4]))!==null){i=r[2]||r[3];if(i){i=Ext.String.htmlDecode(i);g=r[1];g=n[g]||g;f=f||{};j=f[g];if(typeof j=="string"){f[g]=[j,i]}else{if(j){f[g].push(i)}else{f[g]=i}}}}if(!f){if(u.elseRe.test(l[4])){u.doElse()}else{if(u.defaultRe.test(l[4])){u.doDefault()}else{u.doTpl();d.push({type:"tpl"})}}}else{if(f["if"]){u.doIf(f["if"],f);d.push({type:"if"})}else{if(f["switch"]){u.doSwitch(f["switch"],f);d.push({type:"switch"})}else{if(f["case"]){u.doCase(f["case"],f)}else{if(f.elif){u.doElseIf(f.elif,f)}else{if(f["for"]){++u.level;if(a=u.propRe.exec(l[4])){f.propName=a[1]||a[2]}u.doFor(f["for"],f);d.push({type:"for",actions:f})}else{if(f.exec){u.doExec(f.exec,f);d.push({type:"exec",actions:f})}}}}}}}}else{if(l[0].length===5){d.push({type:"tpl"})}else{h=d.pop();u.doEnd(h.type,h.actions);if(h.type=="for"){--u.level}}}}}}}},topRe:/(?:(\{\%)|(\{\[)|\{([^{}]*)\})|(?:<tpl([^>]*)\>)|(?:<\/tpl>)/g,actionsRe:/\s*(elif|elseif|if|for|exec|switch|case|eval)\s*\=\s*(?:(?:"([^"]*)")|(?:'([^']*)'))\s*/g,propRe:/prop=(?:(?:"([^"]*)")|(?:'([^']*)'))/,defaultRe:/^\s*default\s*$/,elseRe:/^\s*else\s*$/});Ext.define("Ext.util.Renderable",{requires:["Ext.dom.Element"],frameCls:Ext.baseCSSPrefix+"frame",frameIdRegex:/[\-]frame\d+[TMB][LCR]$/,frameElementCls:{tl:[],tc:[],tr:[],ml:[],mc:[],mr:[],bl:[],bc:[],br:[]},frameElNames:["TL","TC","TR","ML","MC","MR","BL","BC","BR"],frameTpl:["{%this.renderDockedItems(out,values,0);%}",'<tpl if="top">','<tpl if="left"><div id="{fgid}TL" class="{frameCls}-tl {baseCls}-tl {baseCls}-{ui}-tl<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-tl</tpl>" style="background-position: {tl}; padding-left: {frameWidth}px" role="presentation"></tpl>','<tpl if="right"><div id="{fgid}TR" class="{frameCls}-tr {baseCls}-tr {baseCls}-{ui}-tr<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-tr</tpl>" style="background-position: {tr}; padding-right: {frameWidth}px" role="presentation"></tpl>','<div id="{fgid}TC" class="{frameCls}-tc {baseCls}-tc {baseCls}-{ui}-tc<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-tc</tpl>" style="background-position: {tc}; height: {frameWidth}px" role="presentation"></div>','<tpl if="right"></div></tpl>','<tpl if="left"></div></tpl>',"</tpl>",'<tpl if="left"><div id="{fgid}ML" class="{frameCls}-ml {baseCls}-ml {baseCls}-{ui}-ml<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-ml</tpl>" style="background-position: {ml}; padding-left: {frameWidth}px" role="presentation"></tpl>','<tpl if="right"><div id="{fgid}MR" class="{frameCls}-mr {baseCls}-mr {baseCls}-{ui}-mr<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-mr</tpl>" style="background-position: {mr}; padding-right: {frameWidth}px" role="presentation"></tpl>','<div id="{fgid}MC" class="{frameCls}-mc {baseCls}-mc {baseCls}-{ui}-mc<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-mc</tpl>" role="presentation">',"{%this.applyRenderTpl(out, values)%}","</div>",'<tpl if="right"></div></tpl>','<tpl if="left"></div></tpl>','<tpl if="bottom">','<tpl if="left"><div id="{fgid}BL" class="{frameCls}-bl {baseCls}-bl {baseCls}-{ui}-bl<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-bl</tpl>" style="background-position: {bl}; padding-left: {frameWidth}px" role="presentation"></tpl>','<tpl if="right"><div id="{fgid}BR" class="{frameCls}-br {baseCls}-br {baseCls}-{ui}-br<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-br</tpl>" style="background-position: {br}; padding-right: {frameWidth}px" role="presentation"></tpl>','<div id="{fgid}BC" class="{frameCls}-bc {baseCls}-bc {baseCls}-{ui}-bc<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-bc</tpl>" style="background-position: {bc}; height: {frameWidth}px" role="presentation"></div>','<tpl if="right"></div></tpl>','<tpl if="left"></div></tpl>',"</tpl>","{%this.renderDockedItems(out,values,1);%}"],frameTableTpl:["{%this.renderDockedItems(out,values,0);%}","<table><tbody>",'<tpl if="top">',"<tr>",'<tpl if="left"><td id="{fgid}TL" class="{frameCls}-tl {baseCls}-tl {baseCls}-{ui}-tl<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-tl</tpl>" style="background-position: {tl}; padding-left:{frameWidth}px" role="presentation"></td></tpl>','<td id="{fgid}TC" class="{frameCls}-tc {baseCls}-tc {baseCls}-{ui}-tc<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-tc</tpl>" style="background-position: {tc}; height: {frameWidth}px" role="presentation"></td>','<tpl if="right"><td id="{fgid}TR" class="{frameCls}-tr {baseCls}-tr {baseCls}-{ui}-tr<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-tr</tpl>" style="background-position: {tr}; padding-left: {frameWidth}px" role="presentation"></td></tpl>',"</tr>","</tpl>","<tr>",'<tpl if="left"><td id="{fgid}ML" class="{frameCls}-ml {baseCls}-ml {baseCls}-{ui}-ml<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-ml</tpl>" style="background-position: {ml}; padding-left: {frameWidth}px" role="presentation"></td></tpl>','<td id="{fgid}MC" class="{frameCls}-mc {baseCls}-mc {baseCls}-{ui}-mc<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-mc</tpl>" style="background-position: 0 0;" role="presentation">',"{%this.applyRenderTpl(out, values)%}","</td>",'<tpl if="right"><td id="{fgid}MR" class="{frameCls}-mr {baseCls}-mr {baseCls}-{ui}-mr<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-mr</tpl>" style="background-position: {mr}; padding-left: {frameWidth}px" role="presentation"></td></tpl>',"</tr>",'<tpl if="bottom">',"<tr>",'<tpl if="left"><td id="{fgid}BL" class="{frameCls}-bl {baseCls}-bl {baseCls}-{ui}-bl<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-bl</tpl>" style="background-position: {bl}; padding-left: {frameWidth}px" role="presentation"></td></tpl>','<td id="{fgid}BC" class="{frameCls}-bc {baseCls}-bc {baseCls}-{ui}-bc<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-bc</tpl>" style="background-position: {bc}; height: {frameWidth}px" role="presentation"></td>','<tpl if="right"><td id="{fgid}BR" class="{frameCls}-br {baseCls}-br {baseCls}-{ui}-br<tpl for="uiCls"> {parent.baseCls}-{parent.ui}-{.}-br</tpl>" style="background-position: {br}; padding-left: {frameWidth}px" role="presentation"></td></tpl>',"</tr>","</tpl>","</tbody></table>","{%this.renderDockedItems(out,values,1);%}"],afterRender:function(){var b=this,c={},e=b.protoEl,d=b.getTargetEl(),a;b.finishRenderChildren();if(b.styleHtmlContent){d.addCls(b.styleHtmlCls)}e.writeTo(c);a=c.removed;if(a){d.removeCls(a)}a=c.cls;if(a.length){d.addCls(a)}a=c.style;if(c.style){d.setStyle(a)}b.protoEl=null;if(!b.ownerCt){b.updateLayout()}},afterFirstLayout:function(d,a){var e=this,c=Ext.isDefined(e.x),b=Ext.isDefined(e.y),g,f;if(e.floating&&(!c||!b)){if(e.floatParent){g=e.floatParent.getTargetEl().getViewRegion();f=e.el.getAlignToXY(e.floatParent.getTargetEl(),"c-c");g.left=f[0]-g.left;g.top=f[1]-g.top}else{f=e.el.getAlignToXY(e.container,"c-c");g=e.container.translatePoints(f[0],f[1])}e.x=c?e.x:g.left;e.y=b?e.y:g.top;c=b=true}if(c||b){e.setPosition(e.x,e.y)}e.onBoxReady(d,a);if(e.hasListeners.boxready){e.fireEvent("boxready",e,d,a)}},onBoxReady:Ext.emptyFn,applyRenderSelectors:function(){var d=this,b=d.renderSelectors,c=d.el,e=c.dom,a;d.applyChildEls(c);if(b){for(a in b){if(b.hasOwnProperty(a)&&b[a]){d[a]=Ext.get(Ext.DomQuery.selectNode(b[a],e))}}}},beforeRender:function(){var b=this,c=b.getTargetEl(),a=b.getComponentLayout();b.frame=b.frame||b.alwaysFramed;if(!a.initialized){a.initLayout()}if(c){c.setStyle(b.getOverflowStyle());b.overflowStyleSet=true}b.setUI(b.ui);if(b.disabled){b.disable(true)}},doApplyRenderTpl:function(c,a){var d=a.$comp,b;if(!d.rendered){b=d.initRenderTpl();b.applyOut(a.renderData,c)}},doAutoRender:function(){var a=this;if(!a.rendered){if(a.floating){a.render(document.body)}else{a.render(Ext.isBoolean(a.autoRender)?Ext.getBody():a.autoRender)}}},doRenderContent:function(a,c){var b=c.$comp;if(b.html){Ext.DomHelper.generateMarkup(b.html,a);delete b.html}if(b.tpl){if(!b.tpl.isTemplate){b.tpl=new Ext.XTemplate(b.tpl)}if(b.data){b.tpl.applyOut(b.data,a);delete b.data}}},doRenderFramingDockedItems:function(a,c,d){var b=c.$comp;if(!b.rendered&&b.doRenderDockedItems){c.renderData.$skipDockedItems=true;b.doRenderDockedItems.call(this,a,c,d)}},finishRender:function(a){var f=this,b,g,e,d,h,c;if(!f.el||f.$pid){if(f.container){d=f.container.getById(f.id,true)}else{d=Ext.getDom(f.id)}if(!f.el){f.wrapPrimaryEl(d)}else{delete f.$pid;if(!f.el.dom){f.wrapPrimaryEl(f.el)}d.parentNode.insertBefore(f.el.dom,d);Ext.removeNode(d)}}else{if(!f.rendering){b=f.initRenderTpl();if(b){g=f.initRenderData();b.insertFirst(f.getTargetEl(),g)}}}if(!f.container){f.container=Ext.get(f.el.dom.parentNode)}if(f.ctCls){f.container.addCls(f.ctCls)}f.onRender(f.container,a);if(!f.overflowStyleSet){f.getTargetEl().setStyle(f.getOverflowStyle())}f.el.setVisibilityMode(Ext.Element[f.hideMode.toUpperCase()]);if(f.overCls){f.el.hover(f.addOverCls,f.removeOverCls,f)}if(f.hasListeners.render){f.fireEvent("render",f)}if(f.contentEl){h=Ext.baseCSSPrefix;c=h+"hide-";e=Ext.get(f.contentEl);e.removeCls([h+"hidden",c+"display",c+"offsets",c+"nosize"]);f.getTargetEl().appendChild(e.dom)}f.afterRender();if(f.hasListeners.afterrender){f.fireEvent("afterrender",f)}f.initEvents();if(f.hidden){f.el.hide()}},finishRenderChildren:function(){var a=this.getComponentLayout();a.finishRender()},getElConfig:function(){var g=this,h=g.autoEl,e=g.getFrameInfo(),a={tag:"div",tpl:e?g.initFramingTpl(e.table):g.initRenderTpl()},b,d,f,j,c;g.initStyles(g.protoEl);g.protoEl.writeTo(a);g.protoEl.flush();if(Ext.isString(h)){a.tag=h}else{Ext.apply(a,h)}a.id=g.id;if(a.tpl){if(e){d=g.frameElNames;f=d.length;c=g.id+"-frame1";g.frameGenId=1;a.tplData=Ext.apply({},{$comp:g,fgid:c,ui:g.ui,uiCls:g.uiCls,frameCls:g.frameCls,baseCls:g.baseCls,frameWidth:e.maxWidth,top:!!e.top,left:!!e.left,right:!!e.right,bottom:!!e.bottom,renderData:g.initRenderData()},g.getFramePositions(e));for(b=0;b<f;b++){j=d[b];g.addChildEls({name:"frame"+j,id:c+j})}g.addChildEls({name:"frameBody",id:c+"MC"})}else{a.tplData=g.initRenderData()}}return a},initFramingTpl:function(b){var a=b?this.getTpl("frameTableTpl"):this.getTpl("frameTpl");if(a&&!a.applyRenderTpl){this.setupFramingTpl(a)}return a},setupFramingTpl:function(a){a.applyRenderTpl=this.doApplyRenderTpl;a.renderDockedItems=this.doRenderFramingDockedItems},getInsertPosition:function(a){if(a!==undefined){if(Ext.isNumber(a)){a=this.container.dom.childNodes[a]}else{a=Ext.getDom(a)}}return a},getRenderTree:function(){var a=this;if(!a.hasListeners.beforerender||a.fireEvent("beforerender",a)!==false){a.beforeRender();a.rendering=true;if(a.el){return{tag:"div",id:(a.$pid=Ext.id())}}return a.getElConfig()}return null},initContainer:function(a){var b=this;if(!a&&b.el){a=b.el.dom.parentNode;b.allowDomMove=false}b.container=a.dom?a:Ext.get(a);return b.container},initRenderData:function(){var a=this;return Ext.apply({$comp:a,id:a.id,ui:a.ui,uiCls:a.uiCls,baseCls:a.baseCls,componentCls:a.componentCls,frame:a.frame},a.renderData)},initRenderTpl:function(){var a=this.getTpl("renderTpl");if(a&&!a.renderContent){this.setupRenderTpl(a)}return a},onRender:function(d,e){var g=this,i=g.x,h=g.y,c,a,j,b=g.el,f=Ext.getBody().dom;if(Ext.scopeResetCSS&&!g.ownerCt){if(b.dom===f){b.parent().addCls(Ext.resetCls)}else{if(g.floating&&g.el.dom.parentNode===f){Ext.resetElement.appendChild(g.el)}else{g.resetEl=b.wrap(Ext.resetElementSpec,false,Ext.supports.CSS3LinearGradient?undefined:"*")}}}g.applyRenderSelectors();delete g.rendering;g.rendered=true;c=null;if(i!==undefined){c=c||{};c.x=i}if(h!==undefined){c=c||{};c.y=h}if(!g.getFrameInfo()&&Ext.isBorderBox){a=g.width;j=g.height;if(typeof a=="number"){c=c||{};c.width=a}if(typeof j=="number"){c=c||{};c.height=j}}g.lastBox=g.el.lastBox=c},render:function(c,b){var e=this,d=e.el&&(e.el=Ext.get(e.el)),g,a,f;Ext.suspendLayouts();c=e.initContainer(c);f=e.getInsertPosition(b);if(!d){a=e.getRenderTree();if(e.ownerLayout&&e.ownerLayout.transformItemRenderTree){a=e.ownerLayout.transformItemRenderTree(a)}if(a){if(f){d=Ext.DomHelper.insertBefore(f,a)}else{d=Ext.DomHelper.append(c,a)}e.wrapPrimaryEl(d)}}else{if(!e.hasListeners.beforerender||e.fireEvent("beforerender",e)!==false){e.initStyles(d);if(e.allowDomMove!==false){if(f){c.dom.insertBefore(d.dom,f)}else{c.dom.appendChild(d.dom)}}}else{g=true}}if(d&&!g){e.finishRender(b)}Ext.resumeLayouts(!c.isDetachedBody)},ensureAttachedToBody:function(c){var b=this,a;while(b.ownerCt){b=b.ownerCt}if(b.container.isDetachedBody){b.container=a=Ext.resetElement;a.appendChild(b.el.dom);if(c){b.updateLayout()}if(typeof b.x=="number"||typeof b.y=="number"){b.setPosition(b.x,b.y)}}},setupRenderTpl:function(a){a.renderBody=a.renderContent=this.doRenderContent},wrapPrimaryEl:function(a){this.el=Ext.get(a,true)},initFrame:function(){if(Ext.supports.CSS3BorderRadius||!this.frame){return}var g=this,e=g.getFrameInfo(),h,a,c,b,d=g.frameElNames,f=d.length,j;if(e){h=e.maxWidth;a=g.getFrameTpl(e.table);g.frameGenId=c=(g.frameGenId||0)+1;c=g.id+"-frame"+c;a.insertFirst(g.el,Ext.apply({$comp:g,fgid:c,ui:g.ui,uiCls:g.uiCls,frameCls:g.frameCls,baseCls:g.baseCls,frameWidth:h,top:!!e.top,left:!!e.left,right:!!e.right,bottom:!!e.bottom},g.getFramePositions(e)));g.frameBody=g.el.down("."+g.frameCls+"-mc");g.removeChildEls(function(i){return i.id&&g.frameIdRegex.test(i.id)});for(b=0;b<f;b++){j=d[b];g["frame"+j]=g.el.getById(c+j)}}},updateFrame:function(){if(Ext.supports.CSS3BorderRadius||!this.frame){return}var e=this,g=this.frameSize&&this.frameSize.table,f=this.frameTL,d=this.frameBL,c=this.frameML,a=this.frameMC,b;this.initFrame();if(a){if(e.frame){b=this.frameMC.dom.className;a.insertAfter(this.frameMC);this.frameMC.remove();this.frameBody=this.frameMC=a;a.dom.className=b;if(g){e.el.query("> table")[1].remove()}else{if(f){f.remove()}if(d){d.remove()}if(c){c.remove()}}}}else{if(e.frame){this.applyRenderSelectors()}}},getFrameInfo:function(){if(Ext.supports.CSS3BorderRadius||!this.frame){return false}var f=this,h=f.frameInfoCache,a=f.el||f.protoEl,i=a.dom?a.dom.className:a.classList.join(" "),d=h[i],e,c,g,b;if(d==null){e=Ext.fly(f.getStyleProxy(i),"frame-style-el");c=e.getStyle("background-position-x");g=e.getStyle("background-position-y");if(!c&&!g){b=e.getStyle("background-position").split(" ");c=b[0];g=b[1]}d=f.calculateFrame(c,g);if(d){a.setStyle("background-image","none")}h[i]=d}f.frame=!!d;f.frameSize=d;return d},calculateFrame:function(g,f){if(!(parseInt(g,10)>=1000000&&parseInt(f,10)>=1000000)){return false}var a=Math.max,b=parseInt(g.substr(3,2),10),e=parseInt(g.substr(5,2),10),c=parseInt(f.substr(3,2),10),h=parseInt(f.substr(5,2),10),d={table:g.substr(0,3)=="110",vertical:f.substr(0,3)=="110",top:a(b,e),right:a(e,c),bottom:a(h,c),left:a(b,h)};d.maxWidth=a(d.top,d.right,d.bottom,d.left);d.width=d.left+d.right;d.height=d.top+d.bottom;return d},getStyleProxy:function(b){var a=this.styleProxyEl||(Ext.AbstractComponent.prototype.styleProxyEl=Ext.resetElement.createChild({style:{position:"absolute",top:"-10000px"}},null,true));a.className=b;return a},getFramePositions:function(e){var g=this,h=e.maxWidth,i=g.dock,d,b,f,c,a;if(e.vertical){b="0 -"+(h*0)+"px";f="0 -"+(h*1)+"px";if(i&&i=="right"){b="right -"+(h*0)+"px";f="right -"+(h*1)+"px"}d={tl:"0 -"+(h*0)+"px",tr:"0 -"+(h*1)+"px",bl:"0 -"+(h*2)+"px",br:"0 -"+(h*3)+"px",ml:"-"+(h*1)+"px 0",mr:"right 0",tc:b,bc:f}}else{c="-"+(h*0)+"px 0";a="right 0";if(i&&i=="bottom"){c="left bottom";a="right bottom"}d={tl:"0 -"+(h*2)+"px",tr:"right -"+(h*3)+"px",bl:"0 -"+(h*4)+"px",br:"right -"+(h*5)+"px",ml:c,mr:a,tc:"0 -"+(h*0)+"px",bc:"0 -"+(h*1)+"px"}}return d},getFrameTpl:function(a){return this.getTpl(a?"frameTableTpl":"frameTpl")},frameInfoCache:{}});Ext.define("Ext.ComponentQuery",{singleton:true,uses:["Ext.ComponentManager"]},function(){var g=this,j=["var r = [],","i = 0,","it = items,","l = it.length,","c;","for (; i < l; i++) {","c = it[i];","if (c.{0}) {","r.push(c);","}","}","return r;"].join(""),e=function(o,n){return n.method.apply(this,[o].concat(n.args))},a=function(p,t){var n=[],q=0,s=p.length,r,o=t!==">";for(;q<s;q++){r=p[q];if(r.getRefItems){n=n.concat(r.getRefItems(o))}}return n},f=function(o){var n=[],p=0,r=o.length,q;for(;p<r;p++){q=o[p];while(!!(q=(q.ownerCt||q.floatParent))){n.push(q)}}return n},l=function(o,t,s){if(t==="*"){return o.slice()}else{var n=[],p=0,r=o.length,q;for(;p<r;p++){q=o[p];if(q.isXType(t,s)){n.push(q)}}return n}},i=function(o,r){var t=Ext.Array,n=[],p=0,s=o.length,q;for(;p<s;p++){q=o[p];if(q.hasCls(r)){n.push(q)}}return n},m=function(p,u,o,t){var n=[],q=0,s=p.length,r;for(;q<s;q++){r=p[q];if(!t?!!r[u]:(String(r[u])===t)){n.push(r)}}return n},d=function(o,s){var n=[],p=0,r=o.length,q;for(;p<r;p++){q=o[p];if(q.getItemId()===s){n.push(q)}}return n},k=function(n,o,p){return g.pseudos[o](n,p)},h=/^(\s?([>\^])\s?|\s|$)/,c=/^(#)?([\w\-]+|\*)(?:\((true|false)\))?/,b=[{re:/^\.([\w\-]+)(?:\((true|false)\))?/,method:l},{re:/^(?:[\[](?:@)?([\w\-]+)\s?(?:(=|.=)\s?['"]?(.*?)["']?)?[\]])/,method:m},{re:/^#([\w\-]+)/,method:d},{re:/^\:([\w\-]+)(?:\(((?:\{[^\}]+\})|(?:(?!\{)[^\s>\/]*?(?!\})))\))?/,method:k},{re:/^(?:\{([^\}]+)\})/,method:j}];g.Query=Ext.extend(Object,{constructor:function(n){n=n||{};Ext.apply(this,n)},execute:function(o){var q=this.operations,r=0,s=q.length,p,n;if(!o){n=Ext.ComponentManager.all.getArray()}else{if(Ext.isArray(o)){n=o}else{if(o.isMixedCollection){n=o.items}}}for(;r<s;r++){p=q[r];if(p.mode==="^"){n=f(n||[o])}else{if(p.mode){n=a(n||[o],p.mode)}else{n=e(n||a([o]),p)}}if(r===s-1){return n}}return[]},is:function(p){var o=this.operations,s=Ext.isArray(p)?p:[p],n=s.length,t=o[o.length-1],r,q;s=e(s,t);if(s.length===n){if(o.length>1){for(q=0,r=s.length;q<r;q++){if(Ext.Array.indexOf(this.execute(),s[q])===-1){return false}}}return true}return false}});Ext.apply(this,{cache:{},pseudos:{not:function(t,n){var u=Ext.ComponentQuery,r=0,s=t.length,q=[],p=-1,o;for(;r<s;++r){o=t[r];if(!u.is(o,n)){q[++p]=o}}return q},first:function(o){var n=[];if(o.length>0){n.push(o[0])}return n},last:function(p){var n=p.length,o=[];if(n>0){o.push(p[n-1])}return o}},query:function(o,v){var w=o.split(","),n=w.length,p=0,q=[],x=[],u={},s,r,t;for(;p<n;p++){o=Ext.String.trim(w[p]);s=this.cache[o]||(this.cache[o]=this.parse(o));q=q.concat(s.execute(v))}if(n>1){r=q.length;for(p=0;p<r;p++){t=q[p];if(!u[t.id]){x.push(t);u[t.id]=true}}q=x}return q},is:function(o,n){if(!n){return true}var q=n.split(","),r=q.length,p=0,s;for(;p<r;p++){n=Ext.String.trim(q[p]);s=this.cache[n]||(this.cache[n]=this.parse(n));if(s.is(o)){return true}}return false},parse:function(q){var o=[],p=b.length,u,r,v,w,x,s,t,n;while(q&&u!==q){u=q;r=q.match(c);if(r){v=r[1];if(v==="#"){o.push({method:d,args:[Ext.String.trim(r[2])]})}else{if(v==="."){o.push({method:i,args:[Ext.String.trim(r[2])]})}else{o.push({method:l,args:[Ext.String.trim(r[2]),Boolean(r[3])]})}}q=q.replace(r[0],"")}while(!(w=q.match(h))){for(s=0;q&&s<p;s++){t=b[s];x=q.match(t.re);n=t.method;if(x){o.push({method:Ext.isString(t.method)?Ext.functionFactory("items",Ext.String.format.apply(Ext.String,[n].concat(x.slice(1)))):t.method,args:x.slice(1)});q=q.replace(x[0],"");break}if(s===(p-1)){Ext.Error.raise('Invalid ComponentQuery selector: "'+arguments[0]+'"')}}}if(w[1]){o.push({mode:w[2]||w[1]});q=q.replace(w[0],"")}}return new g.Query({operations:o})}})});Ext.define("Ext.util.ProtoElement",(function(){var b=Ext.String.splitWords,a=Ext.Array.toMap;return{isProtoEl:true,clsProp:"cls",styleProp:"style",removedProp:"removed",styleIsText:false,constructor:function(c){var d=this;Ext.apply(d,c);d.classList=b(d.cls);d.classMap=a(d.classList);delete d.cls;if(Ext.isFunction(d.style)){d.styleFn=d.style;delete d.style}else{if(typeof d.style=="string"){d.style=Ext.Element.parseStyles(d.style)}else{if(d.style){d.style=Ext.apply({},d.style)}}}},flush:function(){this.flushClassList=[];this.removedClasses={};delete this.style},addCls:function(m){var k=this,l=b(m),e=l.length,h=k.classList,d=k.classMap,f=k.flushClassList,g=0,j;for(;g<e;++g){j=l[g];if(!d[j]){d[j]=true;h.push(j);if(f){f.push(j);delete k.removedClasses[j]}}}return k},hasCls:function(c){return c in this.classMap},removeCls:function(n){var m=this,k=m.classList,f=(m.classList=[]),h=a(b(n)),e=k.length,d=m.classMap,j=m.removedClasses,g,l;for(g=0;g<e;++g){l=k[g];if(h[l]){if(j){if(d[l]){j[l]=true;Ext.Array.remove(m.flushClassList,l)}}delete d[l]}else{f.push(l)}}return m},setStyle:function(f,e){var d=this,c=d.style||(d.style={});if(typeof f=="string"){if(arguments.length===1){d.setStyle(Ext.Element.parseStyles(f))}else{c[f]=e}}else{Ext.apply(c,f)}return d},writeTo:function(g){var e=this,f=e.flushClassList||e.classList,d=e.removedClasses,c;if(e.styleFn){c=Ext.apply({},e.styleFn());Ext.apply(c,e.style)}else{c=e.style}g[e.clsProp]=f.join(" ");if(c){g[e.styleProp]=e.styleIsText?Ext.DomHelper.generateStyles(c):c}if(d){d=Ext.Object.getKeys(d);if(d.length){g[e.removedProp]=d.join(" ")}}return g}}}()));Ext.define("Ext.util.HashMap",{mixins:{observable:"Ext.util.Observable"},constructor:function(a){a=a||{};var c=this,b=a.keyFn;c.addEvents("add","clear","remove","replace");c.mixins.observable.constructor.call(c,a);c.clear(true);if(b){c.getKey=b}},getCount:function(){return this.length},getData:function(a,b){if(b===undefined){b=a;a=this.getKey(b)}return[a,b]},getKey:function(a){return a.id},add:function(a,c){var b=this;if(c===undefined){c=a;a=b.getKey(c)}if(b.containsKey(a)){return b.replace(a,c)}b.map[a]=c;++b.length;if(b.hasListeners.add){b.fireEvent("add",b,a,c)}return c},replace:function(b,d){var c=this,e=c.map,a;if(d===undefined){d=b;b=c.getKey(d)}if(!c.containsKey(b)){c.add(b,d)}a=e[b];e[b]=d;if(c.hasListeners.replace){c.fireEvent("replace",c,b,d,a)}return d},remove:function(b){var a=this.findKey(b);if(a!==undefined){return this.removeAtKey(a)}return false},removeAtKey:function(a){var b=this,c;if(b.containsKey(a)){c=b.map[a];delete b.map[a];--b.length;if(b.hasListeners.remove){b.fireEvent("remove",b,a,c)}return true}return false},get:function(a){return this.map[a]},clear:function(a){var b=this;b.map={};b.length=0;if(a!==true&&b.hasListeners.clear){b.fireEvent("clear",b)}return b},containsKey:function(a){return this.map[a]!==undefined},contains:function(a){return this.containsKey(this.findKey(a))},getKeys:function(){return this.getArray(true)},getValues:function(){return this.getArray(false)},getArray:function(d){var a=[],b,c=this.map;for(b in c){if(c.hasOwnProperty(b)){a.push(d?b:c[b])}}return a},each:function(d,c){var a=Ext.apply({},this.map),b,e=this.length;c=c||this;for(b in a){if(a.hasOwnProperty(b)){if(d.call(c,b,a[b],e)===false){break}}}return this},clone:function(){var c=new this.self(),b=this.map,a;c.suspendEvents();for(a in b){if(b.hasOwnProperty(a)){c.add(a,b[a])}}c.resumeEvents();return c},findKey:function(b){var a,c=this.map;for(a in c){if(c.hasOwnProperty(a)&&c[a]===b){return a}}return undefined}});Ext.define("Ext.fx.Queue",{requires:["Ext.util.HashMap"],constructor:function(){this.targets=new Ext.util.HashMap();this.fxQueue={}},getFxDefaults:function(a){var b=this.targets.get(a);if(b){return b.fxDefaults}return{}},setFxDefaults:function(a,c){var b=this.targets.get(a);if(b){b.fxDefaults=Ext.apply(b.fxDefaults||{},c)}},stopAnimation:function(b){var d=this,a=d.getFxQueue(b),c=a.length;while(c){a[c-1].end();c--}},getActiveAnimation:function(b){var a=this.getFxQueue(b);return(a&&!!a.length)?a[0]:false},hasFxBlock:function(b){var a=this.getFxQueue(b);return a&&a[0]&&a[0].block},getFxQueue:function(b){if(!b){return false}var c=this,a=c.fxQueue[b],d=c.targets.get(b);if(!d){return false}if(!a){c.fxQueue[b]=[];if(d.type!="element"){d.target.on("destroy",function(){c.fxQueue[b]=[]})}}return c.fxQueue[b]},queueFx:function(d){var c=this,e=d.target,a,b;if(!e){return}a=c.getFxQueue(e.getId());b=a.length;if(b){if(d.concurrent){d.paused=false}else{a[b-1].on("afteranimate",function(){d.paused=false})}}else{d.paused=false}d.on("afteranimate",function(){Ext.Array.remove(a,d);if(d.remove){if(e.type=="element"){var f=Ext.get(e.id);if(f){f.remove()}}}},this);a.push(d)}});Ext.define("Ext.data.proxy.Server",{extend:"Ext.data.proxy.Proxy",alias:"proxy.server",alternateClassName:"Ext.data.ServerProxy",uses:["Ext.data.Request"],pageParam:"page",startParam:"start",limitParam:"limit",groupParam:"group",groupDirectionParam:"groupDir",sortParam:"sort",filterParam:"filter",directionParam:"dir",simpleSortMode:false,simpleGroupMode:false,noCache:true,cacheString:"_dc",timeout:30000,constructor:function(a){var b=this;a=a||{};b.callParent([a]);b.extraParams=a.extraParams||{};b.api=Ext.apply({},a.api||b.api);b.nocache=b.noCache},create:function(){return this.doRequest.apply(this,arguments)},read:function(){return this.doRequest.apply(this,arguments)},update:function(){return this.doRequest.apply(this,arguments)},destroy:function(){return this.doRequest.apply(this,arguments)},setExtraParam:function(a,b){this.extraParams[a]=b},buildRequest:function(a){var c=this,d=Ext.applyIf(a.params||{},c.extraParams||{}),b;d=Ext.applyIf(d,c.getParams(a));if(a.id!==undefined&&d.id===undefined){d.id=a.id}b=new Ext.data.Request({params:d,action:a.action,records:a.records,operation:a,url:a.url,proxy:c});b.url=c.buildUrl(b);a.request=b;return b},processResponse:function(g,a,c,b,f,h){var e=this,d,i;if(g===true){d=e.getReader();d.applyDefaults=a.action==="read";i=d.read(e.extractResponseData(b));if(i.success!==false){Ext.apply(a,{response:b,resultSet:i});a.commitRecords(i.records);a.setCompleted();a.setSuccessful()}else{a.setException(i.message);e.fireEvent("exception",this,b,a)}}else{e.setException(a,b);e.fireEvent("exception",this,b,a)}if(typeof f=="function"){f.call(h||e,a)}e.afterRequest(c,g)},setException:function(b,a){b.setException({status:a.status,statusText:a.statusText})},extractResponseData:function(a){return a},applyEncoding:function(a){return Ext.encode(a)},encodeSorters:function(d){var b=[],c=d.length,a=0;for(;a<c;a++){b[a]={property:d[a].property,direction:d[a].direction}}return this.applyEncoding(b)},encodeFilters:function(d){var b=[],c=d.length,a=0;for(;a<c;a++){b[a]={property:d[a].property,value:d[a].value}}return this.applyEncoding(b)},getParams:function(m){var t=this,s={},p=Ext.isDefined,q=m.groupers,a=m.sorters,k=m.filters,h=m.page,g=m.start,r=m.limit,i=t.simpleSortMode,d=t.simpleGroupMode,o=t.pageParam,f=t.startParam,b=t.limitParam,c=t.groupParam,j=t.groupDirectionParam,e=t.sortParam,n=t.filterParam,l=t.directionParam;if(o&&p(h)){s[o]=h}if(f&&p(g)){s[f]=g}if(b&&p(r)){s[b]=r}if(c&&q&&q.length>0){if(d){s[c]=q[0].property;s[j]=q[0].direction||"ASC"}else{s[c]=t.encodeSorters(q)}}if(e&&a&&a.length>0){if(i){s[e]=a[0].property;s[l]=a[0].direction}else{s[e]=t.encodeSorters(a)}}if(n&&k&&k.length>0){s[n]=t.encodeFilters(k)}return s},buildUrl:function(c){var b=this,a=b.getUrl(c);if(b.noCache){a=Ext.urlAppend(a,Ext.String.format("{0}={1}",b.cacheString,Ext.Date.now()))}return a},getUrl:function(a){return a.url||this.api[a.action]||this.url},doRequest:function(a,c,b){},afterRequest:Ext.emptyFn,onDestroy:function(){Ext.destroy(this.reader,this.writer)}});Ext.define("Ext.data.writer.Writer",{alias:"writer.base",alternateClassName:["Ext.data.DataWriter","Ext.data.Writer"],writeAllFields:true,nameProperty:"name",isWriter:true,constructor:function(a){Ext.apply(this,a)},write:function(e){var c=e.operation,b=c.records||[],a=b.length,d=0,f=[];for(;d<a;d++){f.push(this.getRecordData(b[d],c))}return this.writeRecords(e,f)},getRecordData:function(g,d){var n=g.phantom===true,b=this.writeAllFields||n,c=this.nameProperty,h=g.fields,p=h.items,e={},l=g.clientIdProperty,k,a,j,o,m,i,q;if(b){q=p.length;for(i=0;i<q;i++){j=p[i];if(j.persist){a=j[c]||j.name;m=g.get(j.name);if(j.serialize){e[a]=j.serialize(m,g)}else{if(j.type===Ext.data.Types.DATE&&j.dateFormat){e[a]=Ext.Date.format(m,j.dateFormat)}else{e[a]=m}}}}}else{k=g.getChanges();for(o in k){if(k.hasOwnProperty(o)){j=h.get(o);if(j.persist){a=j[c]||j.name;m=g.get(j.name);if(j.serialize){e[a]=j.serialize(m,g)}else{if(j.type===Ext.data.Types.DATE&&j.dateFormat){e[a]=Ext.Date.format(m,j.dateFormat)}else{e[a]=m}}}}}}if(n){if(l&&d&&d.records.length>1){e[l]=g.internalId}}else{e[g.idProperty]=g.getId()}return e}});Ext.define("Ext.fx.target.Target",{isAnimTarget:true,constructor:function(a){this.target=a;this.id=this.getId()},getId:function(){return this.target.id}});Ext.define("Ext.data.Connection",{mixins:{observable:"Ext.util.Observable"},statics:{requestId:0},url:null,async:true,method:null,username:"",password:"",disableCaching:true,withCredentials:false,cors:false,disableCachingParam:"_dc",timeout:30000,useDefaultHeader:true,defaultPostHeader:"application/x-www-form-urlencoded; charset=UTF-8",useDefaultXhrHeader:true,defaultXhrHeader:"XMLHttpRequest",constructor:function(a){a=a||{};Ext.apply(this,a);this.requests={};this.mixins.observable.constructor.call(this)},request:function(j){j=j||{};var f=this,i=j.scope||window,e=j.username||f.username,g=j.password||f.password||"",b,c,d,a,h;if(f.fireEvent("beforerequest",f,j)!==false){c=f.setOptions(j,i);if(f.isFormUpload(j)){f.upload(j.form,c.url,c.data,j);return null}if(j.autoAbort||f.autoAbort){f.abort()}b=j.async!==false?(j.async||f.async):false;h=f.openRequest(j,c,b,e,g);a=f.setupHeaders(h,j,c.data,c.params);d={id:++Ext.data.Connection.requestId,xhr:h,headers:a,options:j,async:b,timeout:setTimeout(function(){d.timedout=true;f.abort(d)},j.timeout||f.timeout)};f.requests[d.id]=d;f.latestId=d.id;if(b){h.onreadystatechange=Ext.Function.bind(f.onStateChange,f,[d])}h.send(c.data);if(!b){return f.onComplete(d)}return d}else{Ext.callback(j.callback,j.scope,[j,undefined,undefined]);return null}},upload:function(b,f,r,e){b=Ext.getDom(b);e=e||{};var m=Ext.id(),k=document.createElement("iframe"),c=[],d="multipart/form-data",q={target:b.target,method:b.method,encoding:b.encoding,enctype:b.enctype,action:b.action},a=function(h,t){g=document.createElement("input");Ext.fly(g).set({type:"hidden",value:t,name:h});b.appendChild(g);c.push(g)},g,j,o,s,n,i,l,p;Ext.fly(k).set({id:m,name:m,cls:Ext.baseCSSPrefix+"hide-display",src:Ext.SSL_SECURE_URL});document.body.appendChild(k);if(document.frames){document.frames[m].name=m}Ext.fly(b).set({target:m,method:"POST",enctype:d,encoding:d,action:f||q.action});if(r){j=Ext.Object.fromQueryString(r)||{};for(s in j){if(j.hasOwnProperty(s)){o=j[s];if(Ext.isArray(o)){n=o.length;for(i=0;i<n;i++){a(s,o[i])}}else{a(s,o)}}}}Ext.fly(k).on("load",Ext.Function.bind(this.onUploadComplete,this,[k,e]),null,{single:true});b.submit();Ext.fly(b).set(q);l=c.length;for(p=0;p<l;p++){Ext.removeNode(c[p])}},onUploadComplete:function(h,c){var d=this,b={responseText:"",responseXML:null},g,a;try{g=h.contentWindow.document||h.contentDocument||window.frames[h.id].document;if(g){if(g.body){if((a=g.body.firstChild)&&/pre/i.test(a.tagName)){b.responseText=a.innerText}else{if(a=g.getElementsByTagName("textarea")[0]){b.responseText=a.value}else{b.responseText=g.body.textContent||g.body.innerText}}}b.responseXML=g.XMLDocument||g}}catch(f){}d.fireEvent("requestcomplete",d,b,c);Ext.callback(c.success,c.scope,[b,c]);Ext.callback(c.callback,c.scope,[c,true,b]);setTimeout(function(){Ext.removeNode(h)},100)},isFormUpload:function(a){var b=this.getForm(a);if(b){return(a.isUpload||(/multipart\/form-data/i).test(b.getAttribute("enctype")))}return false},getForm:function(a){return Ext.getDom(a.form)||null},setOptions:function(k,j){var h=this,e=k.params||{},g=h.extraParams,d=k.urlParams,c=k.url||h.url,i=k.jsonData,b,a,f;if(Ext.isFunction(e)){e=e.call(j,k)}if(Ext.isFunction(c)){c=c.call(j,k)}c=this.setupUrl(k,c);f=k.rawData||k.xmlData||i||null;if(i&&!Ext.isPrimitive(i)){f=Ext.encode(f)}if(Ext.isObject(e)){e=Ext.Object.toQueryString(e)}if(Ext.isObject(g)){g=Ext.Object.toQueryString(g)}e=e+((g)?((e)?"&":"")+g:"");d=Ext.isObject(d)?Ext.Object.toQueryString(d):d;e=this.setupParams(k,e);b=(k.method||h.method||((e||f)?"POST":"GET")).toUpperCase();this.setupMethod(k,b);a=k.disableCaching!==false?(k.disableCaching||h.disableCaching):false;if(b==="GET"&&a){c=Ext.urlAppend(c,(k.disableCachingParam||h.disableCachingParam)+"="+(new Date().getTime()))}if((b=="GET"||f)&&e){c=Ext.urlAppend(c,e);e=null}if(d){c=Ext.urlAppend(c,d)}return{url:c,method:b,data:f||e||null}},setupUrl:function(b,a){var c=this.getForm(b);if(c){a=a||c.action}return a},setupParams:function(a,d){var c=this.getForm(a),b;if(c&&!this.isFormUpload(a)){b=Ext.Element.serializeForm(c);d=d?(d+"&"+b):b}return d},setupMethod:function(a,b){if(this.isFormUpload(a)){return"POST"}return b},setupHeaders:function(l,m,d,c){var h=this,b=Ext.apply({},m.headers||{},h.defaultHeaders||{}),k=h.defaultPostHeader,i=m.jsonData,a=m.xmlData,j,f;if(!b["Content-Type"]&&(d||c)){if(d){if(m.rawData){k="text/plain"}else{if(a&&Ext.isDefined(a)){k="text/xml"}else{if(i&&Ext.isDefined(i)){k="application/json"}}}}b["Content-Type"]=k}if(h.useDefaultXhrHeader&&!b["X-Requested-With"]){b["X-Requested-With"]=h.defaultXhrHeader}try{for(j in b){if(b.hasOwnProperty(j)){f=b[j];l.setRequestHeader(j,f)}}}catch(g){h.fireEvent("exception",j,f)}return b},newRequest:function(a){var b;if((a.cors||this.cors)&&Ext.isIE&&Ext.ieVersion>=8){b=new XDomainRequest()}else{b=this.getXhrInstance()}return b},openRequest:function(c,a,d,f,b){var e=this.newRequest(c);if(f){e.open(a.method,a.url,d,f,b)}else{e.open(a.method,a.url,d)}if(c.withCredentials||this.withCredentials){e.withCredentials=true}return e},getXhrInstance:(function(){var b=[function(){return new XMLHttpRequest()},function(){return new ActiveXObject("MSXML2.XMLHTTP.3.0")},function(){return new ActiveXObject("MSXML2.XMLHTTP")},function(){return new ActiveXObject("Microsoft.XMLHTTP")}],c=0,a=b.length,f;for(;c<a;++c){try{f=b[c];f();break}catch(d){}}return f}()),isLoading:function(a){if(!a){a=this.getLatest()}if(!(a&&a.xhr)){return false}var b=a.xhr.readyState;return !(b===0||b==4)},abort:function(b){var a=this,d;if(!b){b=a.getLatest()}if(b&&a.isLoading(b)){d=b.xhr;try{d.onreadystatechange=null}catch(c){d=Ext.emptyFn}d.abort();a.clearTimeout(b);if(!b.timedout){b.aborted=true}a.onComplete(b);a.cleanup(b)}},abortAll:function(){var b=this.requests,a;for(a in b){if(b.hasOwnProperty(a)){this.abort(b[a])}}},getLatest:function(){var b=this.latestId,a;if(b){a=this.requests[b]}return a||null},onStateChange:function(a){if(a.xhr.readyState==4){this.clearTimeout(a);this.onComplete(a);this.cleanup(a)}},clearTimeout:function(a){clearTimeout(a.timeout);delete a.timeout},cleanup:function(a){a.xhr=null;delete a.xhr},onComplete:function(f){var d=this,c=f.options,a,h,b;try{a=d.parseStatus(f.xhr.status)}catch(g){a={success:false,isException:false}}h=a.success;if(h){b=d.createResponse(f);d.fireEvent("requestcomplete",d,b,c);Ext.callback(c.success,c.scope,[b,c])}else{if(a.isException||f.aborted||f.timedout){b=d.createException(f)}else{b=d.createResponse(f)}d.fireEvent("requestexception",d,b,c);Ext.callback(c.failure,c.scope,[b,c])}Ext.callback(c.callback,c.scope,[c,h,b]);delete d.requests[f.id];return b},parseStatus:function(a){a=a==1223?204:a;var c=(a>=200&&a<300)||a==304,b=false;if(!c){switch(a){case 12002:case 12029:case 12030:case 12031:case 12152:case 13030:b=true;break}}return{success:c,isException:b}},createResponse:function(c){var h=c.xhr,a={},i=h.getAllResponseHeaders().replace(/\r\n/g,"\n").split("\n"),d=i.length,j,e,g,f,b;while(d--){j=i[d];e=j.indexOf(":");if(e>=0){g=j.substr(0,e).toLowerCase();if(j.charAt(e+1)==" "){++e}a[g]=j.substr(e+1)}}c.xhr=null;delete c.xhr;b={request:c,requestId:c.id,status:h.status,statusText:h.statusText,getResponseHeader:function(k){return a[k.toLowerCase()]},getAllResponseHeaders:function(){return a},responseText:h.responseText,responseXML:h.responseXML};h=null;return b},createException:function(a){return{request:a,requestId:a.id,status:a.aborted?-1:0,statusText:a.aborted?"transaction aborted":"communication failure",aborted:a.aborted,timedout:a.timedout}}});Ext.define("Ext.data.ResultSet",{loaded:true,count:0,total:0,success:false,constructor:function(a){Ext.apply(this,a);this.totalRecords=this.total;if(a.count===undefined){this.count=this.records.length}}});Ext.define("Ext.AbstractPlugin",{disabled:false,constructor:function(a){this.initialConfig=a;Ext.apply(this,a)},clone:function(){return new this.self(this.initialConfig)},getCmp:function(){return this.cmp},init:Ext.emptyFn,destroy:Ext.emptyFn,enable:function(){this.disabled=false},disable:function(){this.disabled=true}});Ext.define("Ext.state.Provider",{mixins:{observable:"Ext.util.Observable"},prefix:"ext-",constructor:function(a){a=a||{};var b=this;Ext.apply(b,a);b.addEvents("statechange");b.state={};b.mixins.observable.constructor.call(b)},get:function(b,a){return typeof this.state[b]=="undefined"?a:this.state[b]},clear:function(a){var b=this;delete b.state[a];b.fireEvent("statechange",b,a,null)},set:function(a,c){var b=this;b.state[a]=c;b.fireEvent("statechange",b,a,c)},decodeValue:function(f){var c=this,j=/^(a|n|d|b|s|o|e)\:(.*)$/,b=j.exec(unescape(f)),g,d,a,i,e,h;if(!b||!b[1]){return}d=b[1];f=b[2];switch(d){case"e":return null;case"n":return parseFloat(f);case"d":return new Date(Date.parse(f));case"b":return(f=="1");case"a":g=[];if(f!=""){i=f.split("^");e=i.length;for(h=0;h<e;h++){f=i[h];g.push(c.decodeValue(f))}}return g;case"o":g={};if(f!=""){i=f.split("^");e=i.length;for(h=0;h<e;h++){f=i[h];a=f.split("=");g[a[0]]=c.decodeValue(a[1])}}return g;default:return f}},encodeValue:function(e){var f="",d=0,b,a,c;if(e==null){return"e:1"}else{if(typeof e=="number"){b="n:"+e}else{if(typeof e=="boolean"){b="b:"+(e?"1":"0")}else{if(Ext.isDate(e)){b="d:"+e.toGMTString()}else{if(Ext.isArray(e)){for(a=e.length;d<a;d++){f+=this.encodeValue(e[d]);if(d!=a-1){f+="^"}}b="a:"+f}else{if(typeof e=="object"){for(c in e){if(typeof e[c]!="function"&&e[c]!==undefined){f+=c+"="+this.encodeValue(e[c])+"^"}}b="o:"+f.substring(0,f.length-1)}else{b="s:"+e}}}}}}return escape(b)}});Ext.define("Ext.dd.Registry",{singleton:true,constructor:function(){this.elements={};this.handles={};this.autoIdSeed=0},getId:function(b,a){if(typeof b=="string"){return b}var c=b.id;if(!c&&a!==false){c="extdd-"+(++this.autoIdSeed);b.id=c}return c},register:function(d,e){e=e||{};if(typeof d=="string"){d=document.getElementById(d)}e.ddel=d;this.elements[this.getId(d)]=e;if(e.isHandle!==false){this.handles[e.ddel.id]=e}if(e.handles){var c=e.handles,b,a;for(b=0,a=c.length;b<a;b++){this.handles[this.getId(c[b])]=e}}},unregister:function(d){var f=this.getId(d,false),e=this.elements[f],c,b,a;if(e){delete this.elements[f];if(e.handles){c=e.handles;for(b=0,a=c.length;b<a;b++){delete this.handles[this.getId(c[b],false)]}}}},getHandle:function(a){if(typeof a!="string"){a=a.id}return this.handles[a]},getHandleFromEvent:function(b){var a=b.getTarget();return a?this.handles[a.id]:null},getTarget:function(a){if(typeof a!="string"){a=a.id}return this.elements[a]},getTargetFromEvent:function(b){var a=b.getTarget();return a?this.elements[a.id]||this.handles[a.id]:null}});
/*
* Ext JS Library 4.0
* Copyright(c) 2006-2011 Sencha Inc.
* licensing@sencha.com
* http://www.sencha.com/license
*/
Ext.define("MyDesktop.VideoWindow",{extend:"Ext.ux.desktop.Module",uses:["Ext.ux.desktop.Video"],id:"video",windowId:"video-window",tipWidth:160,tipHeight:96,init:function(){this.launcher={text:"About Ext JS",iconCls:"video"}},createWindow:function(){var a=this,c=a.app.getDesktop(),b=c.getWindow(a.windowId);if(!b){b=c.createWindow({id:a.windowId,title:"About Ext JS",width:740,height:480,iconCls:"video",animCollapse:false,border:false,layout:"fit",items:[{xtype:"video",id:"video-player",src:[{src:"http://dev.sencha.com/desktopvideo.mp4",type:"video/mp4"},{src:"http://dev.sencha.com/desktopvideo.ogv",type:"video/ogg"},{src:"http://dev.sencha.com/desktopvideo.mov",type:"video/quicktime"}],autobuffer:true,autoplay:true,controls:true,listeners:{afterrender:function(d){a.videoEl=d.video.dom;if(d.supported){a.tip=new Ext.tip.ToolTip({anchor:"bottom",dismissDelay:0,height:a.tipHeight,width:a.tipWidth,renderTpl:['<canvas width="',a.tipWidth,'" height="',a.tipHeight,'">'],renderSelectors:{body:"canvas"},listeners:{afterrender:a.onTooltipRender,show:a.renderPreview,scope:a}})}}}}],listeners:{beforedestroy:function(){a.tip=a.ctx=a.videoEl=null}}})}if(a.tip){a.tip.setTarget(b.taskButton.el)}return b},onTooltipRender:function(c){var a=c.body.dom,b=this;b.ctx=a.getContext&&a.getContext("2d")},renderPreview:function(){var a=this;if((a.tip&&!a.tip.isVisible())||!a.videoEl){return}if(a.ctx){try{a.ctx.drawImage(a.videoEl,0,0,a.tipWidth,a.tipHeight)}catch(b){}}Ext.Function.defer(a.renderPreview,20,a)}});
/*
* Ext JS Library 4.0
* Copyright(c) 2006-2011 Sencha Inc.
* licensing@sencha.com
* http://www.sencha.com/license
*/
var windowIndex=0;Ext.define("MyDesktop.BogusModule",{extend:"Ext.ux.desktop.Module",init:function(){this.launcher={text:"Window "+(++windowIndex),iconCls:"bogus",handler:this.createWindow,scope:this,windowId:windowIndex}},createWindow:function(b){var c=this.app.getDesktop();var a=c.getWindow("bogus"+b.windowId);if(!a){a=c.createWindow({id:"bogus"+b.windowId,title:b.text,width:640,height:480,html:"<p>Something useful would be in here.</p>",iconCls:"bogus",animCollapse:false,constrainHeader:true})}a.show();return a}});
/*
* Ext JS Library 4.0
* Copyright(c) 2006-2011 Sencha Inc.
* licensing@sencha.com
* http://www.sencha.com/license
*/
Ext.define("MyDesktop.BogusMenuModule",{extend:"MyDesktop.BogusModule",init:function(){this.launcher={text:"More items",iconCls:"bogus",handler:function(){return false},menu:{items:[]}};for(var a=0;a<5;++a){this.launcher.menu.items.push({text:"Window "+(++windowIndex),iconCls:"bogus",handler:this.createWindow,scope:this,windowId:windowIndex})}}});Ext.define("Ext.chart.Label",{requires:["Ext.draw.Color"],colorStringRe:/url\s*\(\s*#([^\/)]+)\s*\)/,constructor:function(a){var b=this;b.label=Ext.applyIf(b.label||{},{display:"none",color:"#000",field:"name",minMargin:50,font:"11px Helvetica, sans-serif",orientation:"horizontal",renderer:function(c){return c}});if(b.label.display!=="none"){b.labelsGroup=b.chart.surface.getGroup(b.seriesId+"-labels")}},renderLabels:function(){var n=this,K=n.chart,w=K.gradients,q=n.items,G=K.animate,z=n.label,t=z.display,u=z.color,d=[].concat(z.field),p=n.labelsGroup,h=(p||0)&&p.length,b=n.chart.getChartStore(),o=b.getCount(),g=(q||0)&&q.length,C=g/o,y=(w||0)&&w.length,l=Ext.draw.Color,J=[],m,I,D,c,x,H,F,e,f,s,v,E,L,r,M,B,A,a;if(t=="none"){return}if(g==0){while(h--){J.push(h)}}else{for(I=0,D=0,c=0;I<o;I++){x=0;for(H=0;H<C;H++){v=q[D];E=p.getAt(c);L=b.getAt(I);while(this.__excludes&&this.__excludes[x]){x++}if(!v&&E){E.hide(true);c++}if(v&&d[H]){if(!E){E=n.onCreateLabel(L,v,I,t,H,x)}n.onPlaceLabel(E,L,v,I,t,G,H,x);c++;if(z.contrast&&v.sprite){r=v.sprite;if(r._endStyle){a=r._endStyle.fill}else{if(r._to){a=r._to.fill}else{a=r.attr.fill}}a=a||r.attr.fill;M=l.fromString(a);if(a&&!M){a=a.match(n.colorStringRe)[1];for(F=0;F<y;F++){m=w[F];if(m.id==a){s=0;e=0;for(f in m.stops){s++;e+=l.fromString(m.stops[f].color).getGrayscale()}B=(e/s)/255;break}}}else{B=M.getGrayscale()/255}if(E.isOutside){B=1}A=l.fromString(E.attr.color||E.attr.fill).getHSL();A[2]=B>0.5?0.2:0.8;E.setAttributes({fill:String(l.fromHSL.apply({},A))},true)}}D++;x++}}h=p.length;while(h>c){J.push(c);c++}}n.hideLabels(J)},hideLabels:function(b){var a=this.labelsGroup,c=!!b&&b.length;if(!a){return}if(c===false){c=a.getCount();while(c--){a.getAt(c).hide(true)}}else{while(c--){a.getAt(b[c]).hide(true)}}}});Ext.define("Ext.chart.theme.Theme",{requires:["Ext.draw.Color"],theme:"Base",themeAttrs:false,initTheme:function(e){var d=this,b=Ext.chart.theme,c,a;if(e){e=e.split(":");for(c in b){if(c==e[0]){a=e[1]=="gradients";d.themeAttrs=new b[c]({useGradients:a});if(a){d.gradients=d.themeAttrs.gradients}if(d.themeAttrs.background){d.background=d.themeAttrs.background}return}}}}},function(){(function(){Ext.chart.theme=function(c,b){c=c||{};var k=0,o=+new Date(),h,a,j,q,r,f,n,p,m=[],e,g;if(c.baseColor){e=Ext.draw.Color.fromString(c.baseColor);g=e.getHSL()[2];if(g<0.15){e=e.getLighter(0.3)}else{if(g<0.3){e=e.getLighter(0.15)}else{if(g>0.85){e=e.getDarker(0.3)}else{if(g>0.7){e=e.getDarker(0.15)}}}}c.colors=[e.getDarker(0.3).toString(),e.getDarker(0.15).toString(),e.toString(),e.getLighter(0.15).toString(),e.getLighter(0.3).toString()];delete c.baseColor}if(c.colors){a=c.colors.slice();r=b.markerThemes;q=b.seriesThemes;h=a.length;b.colors=a;for(;k<h;k++){j=a[k];n=r[k]||{};f=q[k]||{};n.fill=f.fill=n.stroke=f.stroke=j;r[k]=n;q[k]=f}b.markerThemes=r.slice(0,h);b.seriesThemes=q.slice(0,h)}for(p in b){if(p in c){if(Ext.isObject(c[p])&&Ext.isObject(b[p])){Ext.apply(b[p],c[p])}else{b[p]=c[p]}}}if(c.useGradients){a=b.colors||(function(){var d=[];for(k=0,q=b.seriesThemes,h=q.length;k<h;k++){d.push(q[k].fill||q[k].stroke)}return d}());for(k=0,h=a.length;k<h;k++){e=Ext.draw.Color.fromString(a[k]);if(e){j=e.getDarker(0.1).toString();e=e.toString();p="theme-"+e.substr(1)+"-"+j.substr(1)+"-"+o;m.push({id:p,angle:45,stops:{0:{color:e.toString()},100:{color:j.toString()}}});a[k]="url(#"+p+")"}}b.gradients=m;b.colors=a}Ext.apply(this,b)}}())});Ext.define("Ext.chart.theme.Base",{requires:["Ext.chart.theme.Theme"],constructor:function(a){Ext.chart.theme.call(this,a,{background:false,axis:{stroke:"#444","stroke-width":1},axisLabelTop:{fill:"#444",font:"12px Arial, Helvetica, sans-serif",spacing:2,padding:5,renderer:function(b){return b}},axisLabelRight:{fill:"#444",font:"12px Arial, Helvetica, sans-serif",spacing:2,padding:5,renderer:function(b){return b}},axisLabelBottom:{fill:"#444",font:"12px Arial, Helvetica, sans-serif",spacing:2,padding:5,renderer:function(b){return b}},axisLabelLeft:{fill:"#444",font:"12px Arial, Helvetica, sans-serif",spacing:2,padding:5,renderer:function(b){return b}},axisTitleTop:{font:"bold 18px Arial",fill:"#444"},axisTitleRight:{font:"bold 18px Arial",fill:"#444",rotate:{x:0,y:0,degrees:270}},axisTitleBottom:{font:"bold 18px Arial",fill:"#444"},axisTitleLeft:{font:"bold 18px Arial",fill:"#444",rotate:{x:0,y:0,degrees:270}},series:{"stroke-width":0},seriesLabel:{font:"12px Arial",fill:"#333"},marker:{stroke:"#555",radius:3,size:3},colors:["#94ae0a","#115fa6","#a61120","#ff8809","#ffd13e","#a61187","#24ad9a","#7c7474","#a66111"],seriesThemes:[{fill:"#115fa6"},{fill:"#94ae0a"},{fill:"#a61120"},{fill:"#ff8809"},{fill:"#ffd13e"},{fill:"#a61187"},{fill:"#24ad9a"},{fill:"#7c7474"},{fill:"#115fa6"},{fill:"#94ae0a"},{fill:"#a61120"},{fill:"#ff8809"},{fill:"#ffd13e"},{fill:"#a61187"},{fill:"#24ad9a"},{fill:"#7c7474"},{fill:"#a66111"}],markerThemes:[{fill:"#115fa6",type:"circle"},{fill:"#94ae0a",type:"cross"},{fill:"#115fa6",type:"plus"},{fill:"#94ae0a",type:"circle"},{fill:"#a61120",type:"cross"}]})}},function(){var c=["#b1da5a","#4ce0e7","#e84b67","#da5abd","#4d7fe6","#fec935"],h=["Green","Sky","Red","Purple","Blue","Yellow"],g=0,f=0,b=c.length,a=Ext.chart.theme,d=[["#f0a50a","#c20024","#2044ba","#810065","#7eae29"],["#6d9824","#87146e","#2a9196","#d39006","#1e40ac"],["#fbbc29","#ce2e4e","#7e0062","#158b90","#57880e"],["#ef5773","#fcbd2a","#4f770d","#1d3eaa","#9b001f"],["#7eae29","#fdbe2a","#910019","#27b4bc","#d74dbc"],["#44dce1","#0b2592","#996e05","#7fb325","#b821a1"]],e=d.length;for(;g<b;g++){a[h[g]]=(function(i){return Ext.extend(a.Base,{constructor:function(j){a.Base.prototype.constructor.call(this,Ext.apply({baseColor:i},j))}})}(c[g]))}for(g=0;g<e;g++){a["Category"+(g+1)]=(function(i){return Ext.extend(a.Base,{constructor:function(j){a.Base.prototype.constructor.call(this,Ext.apply({colors:i},j))}})}(d[g]))}});Ext.define("Ext.util.ComponentDragger",{extend:"Ext.dd.DragTracker",autoStart:500,constructor:function(a,b){this.comp=a;this.initialConstrainTo=b.constrainTo;this.callParent([b])},onStart:function(c){var b=this,a=b.comp;this.startPosition=a.el.getXY();if(a.ghost&&!a.liveDrag){b.proxy=a.ghost();b.dragTarget=b.proxy.header.el}if(b.constrain||b.constrainDelegate){b.constrainTo=b.calculateConstrainRegion()}if(a.beginDrag){a.beginDrag()}},calculateConstrainRegion:function(){var e=this,b=e.comp,h=e.initialConstrainTo,f,g,a=e.proxy?e.proxy.el:b.el,d=(!e.constrainDelegate&&a.shadow&&!a.shadowDisabled)?a.shadow.getShadowSize():0;if(!(h instanceof Ext.util.Region)){h=Ext.fly(h).getViewRegion()}if(d){h.adjust(d[0],-d[1],-d[2],d[3])}if(!e.constrainDelegate){f=Ext.fly(e.dragTarget).getRegion();g=a.getRegion();h.adjust(f.top-g.top,f.right-g.right,f.bottom-g.bottom,f.left-g.left)}return h},onDrag:function(c){var b=this,a=(b.proxy&&!b.comp.liveDrag)?b.proxy:b.comp,d=b.getOffset(b.constrain||b.constrainDelegate?"dragTarget":null);a.setPagePosition(b.startPosition[0]+d[0],b.startPosition[1]+d[1])},onEnd:function(b){var a=this.comp;if(this.proxy&&!a.liveDrag){a.unghost()}if(a.endDrag){a.endDrag()}}});Ext.define("Ext.util.Region",{requires:["Ext.util.Offset"],statics:{getRegion:function(a){return Ext.fly(a).getPageBox(true)},from:function(a){return new this(a.top,a.right,a.bottom,a.left)}},constructor:function(d,f,a,c){var e=this;e.y=e.top=e[1]=d;e.right=f;e.bottom=a;e.x=e.left=e[0]=c},contains:function(b){var a=this;return(b.x>=a.x&&b.right<=a.right&&b.y>=a.y&&b.bottom<=a.bottom)},intersect:function(g){var f=this,d=Math.max(f.y,g.y),e=Math.min(f.right,g.right),a=Math.min(f.bottom,g.bottom),c=Math.max(f.x,g.x);if(a>d&&e>c){return new this.self(d,e,a,c)}else{return false}},union:function(g){var f=this,d=Math.min(f.y,g.y),e=Math.max(f.right,g.right),a=Math.max(f.bottom,g.bottom),c=Math.min(f.x,g.x);return new this.self(d,e,a,c)},constrainTo:function(b){var a=this,c=Ext.Number.constrain;a.top=a.y=c(a.top,b.y,b.bottom);a.bottom=c(a.bottom,b.y,b.bottom);a.left=a.x=c(a.left,b.x,b.right);a.right=c(a.right,b.x,b.right);return a},adjust:function(d,f,a,c){var e=this;e.top=e.y+=d;e.left=e.x+=c;e.right+=f;e.bottom+=a;return e},getOutOfBoundOffset:function(a,b){if(!Ext.isObject(a)){if(a=="x"){return this.getOutOfBoundOffsetX(b)}else{return this.getOutOfBoundOffsetY(b)}}else{b=a;var c=new Ext.util.Offset();c.x=this.getOutOfBoundOffsetX(b.x);c.y=this.getOutOfBoundOffsetY(b.y);return c}},getOutOfBoundOffsetX:function(a){if(a<=this.x){return this.x-a}else{if(a>=this.right){return this.right-a}}return 0},getOutOfBoundOffsetY:function(a){if(a<=this.y){return this.y-a}else{if(a>=this.bottom){return this.bottom-a}}return 0},isOutOfBound:function(a,b){if(!Ext.isObject(a)){if(a=="x"){return this.isOutOfBoundX(b)}else{return this.isOutOfBoundY(b)}}else{b=a;return(this.isOutOfBoundX(b.x)||this.isOutOfBoundY(b.y))}},isOutOfBoundX:function(a){return(a<this.x||a>this.right)},isOutOfBoundY:function(a){return(a<this.y||a>this.bottom)},restrict:function(b,d,a){if(Ext.isObject(b)){var c;a=d;d=b;if(d.copy){c=d.copy()}else{c={x:d.x,y:d.y}}c.x=this.restrictX(d.x,a);c.y=this.restrictY(d.y,a);return c}else{if(b=="x"){return this.restrictX(d,a)}else{return this.restrictY(d,a)}}},restrictX:function(b,a){if(!a){a=1}if(b<=this.x){b-=(b-this.x)*a}else{if(b>=this.right){b-=(b-this.right)*a}}return b},restrictY:function(b,a){if(!a){a=1}if(b<=this.y){b-=(b-this.y)*a}else{if(b>=this.bottom){b-=(b-this.bottom)*a}}return b},getSize:function(){return{width:this.right-this.x,height:this.bottom-this.y}},copy:function(){return new this.self(this.y,this.right,this.bottom,this.x)},copyFrom:function(b){var a=this;a.top=a.y=a[1]=b.y;a.right=b.right;a.bottom=b.bottom;a.left=a.x=a[0]=b.x;return this},toString:function(){return"Region["+this.top+","+this.right+","+this.bottom+","+this.left+"]"},translateBy:function(a,c){if(arguments.length==1){c=a.y;a=a.x}var b=this;b.top=b.y+=c;b.right+=a;b.bottom+=c;b.left=b.x+=a;return b},round:function(){var a=this;a.top=a.y=Math.round(a.y);a.right=Math.round(a.right);a.bottom=Math.round(a.bottom);a.left=a.x=Math.round(a.x);return a},equals:function(a){return(this.top==a.top&&this.right==a.right&&this.bottom==a.bottom&&this.left==a.left)}});Ext.define("Ext.XTemplateCompiler",{extend:"Ext.XTemplateParser",useEval:Ext.isGecko,useIndex:Ext.isIE6||Ext.isIE7,useFormat:true,propNameRe:/^[\w\d\$]*$/,compile:function(a){var c=this,b=c.generate(a);return c.useEval?c.evalTpl(b):(new Function("Ext",b))(Ext)},generate:function(a){var d=this,b="var fm=Ext.util.Format,ts=Object.prototype.toString;",c;d.maxLevel=0;d.body=["var c0=values, a0="+d.createArrayTest(0)+", p0=parent, n0=xcount, i0=xindex, v;\n"];if(d.definitions){if(typeof d.definitions==="string"){d.definitions=[d.definitions,b]}else{d.definitions.push(b)}}else{d.definitions=[b]}d.switches=[];d.parse(a);d.definitions.push((d.useEval?"$=":"return")+" function ("+d.fnArgs+") {",d.body.join(""),"}");c=d.definitions.join("\n");d.definitions.length=d.body.length=d.switches.length=0;delete d.definitions;delete d.body;delete d.switches;return c},doText:function(c){var b=this,a=b.body;c=c.replace(b.aposRe,"\\'").replace(b.newLineRe,"\\n");if(b.useIndex){a.push("out[out.length]='",c,"'\n")}else{a.push("out.push('",c,"')\n")}},doExpr:function(b){var a=this.body;a.push("if ((v="+b+")!==undefined) out");if(this.useIndex){a.push("[out.length]=v+''\n")}else{a.push(".push(v+'')\n")}},doTag:function(a){this.doExpr(this.parseTag(a))},doElse:function(){this.body.push("} else {\n")},doEval:function(a){this.body.push(a,"\n")},doIf:function(b,c){var a=this;if(b==="."){a.body.push("if (values) {\n")}else{if(a.propNameRe.test(b)){a.body.push("if (",a.parseTag(b),") {\n")}else{a.body.push("if (",a.addFn(b),a.callFn,") {\n")}}if(c.exec){a.doExec(c.exec)}},doElseIf:function(b,c){var a=this;if(b==="."){a.body.push("else if (values) {\n")}else{if(a.propNameRe.test(b)){a.body.push("} else if (",a.parseTag(b),") {\n")}else{a.body.push("} else if (",a.addFn(b),a.callFn,") {\n")}}if(c.exec){a.doExec(c.exec)}},doSwitch:function(b){var a=this;if(b==="."){a.body.push("switch (values) {\n")}else{if(a.propNameRe.test(b)){a.body.push("switch (",a.parseTag(b),") {\n")}else{a.body.push("switch (",a.addFn(b),a.callFn,") {\n")}}a.switches.push(0)},doCase:function(e){var d=this,c=Ext.isArray(e)?e:[e],f=d.switches.length-1,a,b;if(d.switches[f]){d.body.push("break;\n")}else{d.switches[f]++}for(b=0,f=c.length;b<f;++b){a=d.intRe.exec(c[b]);c[b]=a?a[1]:("'"+c[b].replace(d.aposRe,"\\'")+"'")}d.body.push("case ",c.join(": case "),":\n")},doDefault:function(){var a=this,b=a.switches.length-1;if(a.switches[b]){a.body.push("break;\n")}else{a.switches[b]++}a.body.push("default:\n")},doEnd:function(b,d){var c=this,a=c.level-1;if(b=="for"){if(d.exec){c.doExec(d.exec)}c.body.push("}\n");c.body.push("parent=p",a,";values=r",a+1,";xcount=n",a,";xindex=i",a,"\n")}else{if(b=="if"||b=="switch"){c.body.push("}\n")}}},doFor:function(f,h){var e=this,d,b=e.level,a=b-1,c="p"+b,g;if(f==="."){d="values"}else{if(e.propNameRe.test(f)){d=e.parseTag(f)}else{d=e.addFn(f)+e.callFn}}if(e.maxLevel<b){e.maxLevel=b;e.body.push("var ")}if(f=="."){g="c"+b}else{g="a"+a+"?c"+a+"[i"+a+"]:p"+b}e.body.push("i",b,"=0,n",b,"=0,c",b,"=",d,",a",b,"=",e.createArrayTest(b),",p",b,"=c",a,",r",b,"=values;\n","parent=",g,"\n","if (c",b,"){if(a",b,"){n",b,"=c",b,".length;}else if (c",b,".isMixedCollection){c",b,"=c",b,".items;n",b,"=c",b,".length;}else if(c",b,".isStore){c",b,"=c",b,".data.items;n",b,"=c",b,".length;}else{c",b,"=[c",b,"];n",b,"=1;}}\n","for (xcount=n",b,";i",b,"<n"+b+";++i",b,"){\n","values=c",b,"[i",b,"]");if(h.propName){e.body.push(".",h.propName)}e.body.push("\n","xindex=i",b,"+1\n")},createArrayTest:("isArray" in Array)?function(a){return"Array.isArray(c"+a+")"}:function(a){return"ts.call(c"+a+')==="[object Array]"'},doExec:function(c,d){var b=this,a="f"+b.definitions.length;b.definitions.push("function "+a+"("+b.fnArgs+") {"," try { with(values) {","  "+c," }} catch(e) {","}","}");b.body.push(a+b.callFn+"\n")},addFn:function(a){var c=this,b="f"+c.definitions.length;if(a==="."){c.definitions.push("function "+b+"("+c.fnArgs+") {"," return values","}")}else{if(a===".."){c.definitions.push("function "+b+"("+c.fnArgs+") {"," return parent","}")}else{c.definitions.push("function "+b+"("+c.fnArgs+") {"," try { with(values) {","  return("+a+")"," }} catch(e) {","}","}")}}return b},parseTag:function(b){var g=this,a=g.tagRe.exec(b),e=a[1],h=a[2],d=a[3],f=a[4],c;if(e=="."){if(!g.validTypes){g.definitions.push("var validTypes={string:1,number:1,boolean:1};");g.validTypes=true}c='validTypes[typeof values] || ts.call(values) === "[object Date]" ? values : ""'}else{if(e=="#"){c="xindex"}else{if(e.substr(0,7)=="parent."){c=e}else{if(isNaN(e)&&e.indexOf("-")==-1&&e.indexOf(".")!=-1){c="values."+e}else{c="values['"+e+"']"}}}}if(f){c="("+c+f+")"}if(h&&g.useFormat){d=d?","+d:"";if(h.substr(0,5)!="this."){h="fm."+h+"("}else{h+="("}}else{return c}return h+c+d+")"},evalTpl:function($){eval($);return $},newLineRe:/\r\n|\r|\n/g,aposRe:/[']/g,intRe:/^\s*(\d+)\s*$/,tagRe:/([\w-\.\#]+)(?:\:([\w\.]*)(?:\((.*?)?\))?)?(\s?[\+\-\*\/]\s?[\d\.\+\-\*\/\(\)]+)?/},function(){var a=this.prototype;a.fnArgs="out,values,parent,xindex,xcount";a.callFn=".call(this,"+a.fnArgs+")"});Ext.define("Ext.XTemplate",{extend:"Ext.Template",requires:"Ext.XTemplateCompiler",emptyObj:{},apply:function(a,b){return this.applyOut(a,[],b).join("")},applyOut:function(a,b,d){var f=this,c;if(!f.fn){c=new Ext.XTemplateCompiler({useFormat:f.disableFormats!==true,definitions:f.definitions});f.fn=c.compile(f.html)}try{f.fn.call(f,b,a,d||f.emptyObj,1,1)}catch(g){}return b},compile:function(){return this},statics:{getTpl:function(a,c){var b=a[c],d;if(b&&!b.isTemplate){b=Ext.ClassManager.dynInstantiate("Ext.XTemplate",b);if(a.hasOwnProperty(c)){a[c]=b}else{for(d=a.self.prototype;d;d=d.superclass){if(d.hasOwnProperty(c)){d[c]=b;break}}}}return b||null}}});Ext.define("Ext.form.Labelable",{requires:["Ext.XTemplate"],autoEl:{tag:"table",cellpadding:0},childEls:["labelCell","labelEl","bodyEl","sideErrorCell","errorEl","inputRow","bottomPlaceHolder"],labelableRenderTpl:['<tr id="{id}-inputRow" <tpl if="inFormLayout">id="{id}"</tpl>>','<tpl if="labelOnLeft">','<td id="{id}-labelCell" style="{labelCellStyle}" {labelCellAttrs}>',"{beforeLabelTpl}",'<label id="{id}-labelEl" {labelAttrTpl}<tpl if="inputId"> for="{inputId}"</tpl> class="{labelCls}"','<tpl if="labelStyle"> style="{labelStyle}"</tpl>>',"{beforeLabelTextTpl}",'<tpl if="fieldLabel">{fieldLabel}{labelSeparator}</tpl>',"{afterLabelTextTpl}","</label>","{afterLabelTpl}","</td>","</tpl>",'<td class="{baseBodyCls} {fieldBodyCls}" id="{id}-bodyEl" colspan="{bodyColspan}" role="presentation">',"{beforeBodyEl}","<tpl if=\"labelAlign=='top'\">","{beforeLabelTpl}",'<div id="{id}-labelCell" style="{labelCellStyle}">','<label id="{id}-labelEl" {labelAttrTpl}<tpl if="inputId"> for="{inputId}"</tpl> class="{labelCls}"','<tpl if="labelStyle"> style="{labelStyle}"</tpl>>',"{beforeLabelTextTpl}",'<tpl if="fieldLabel">{fieldLabel}{labelSeparator}</tpl>',"{afterLabelTextTpl}","</label>","</div>","{afterLabelTpl}","</tpl>","{beforeSubTpl}","{[values.$comp.getSubTplMarkup()]}","{afterSubTpl}","<tpl if=\"msgTarget==='side'\">","{afterBodyEl}","</td>","<td id=\"{id}-sideErrorCell\" vAlign=\"{[values.labelAlign==='top' && !values.hideLabel ? 'bottom' : 'middle']}\" style=\"{[values.autoFitErrors ? 'display:none' : '']}\" width=\"{errorIconWidth}\">",'<div id="{id}-errorEl" class="{errorMsgCls}" style="display:none;width:{errorIconWidth}px"></div>',"</td>","<tpl elseif=\"msgTarget=='under'\">",'<div id="{id}-errorEl" class="{errorMsgClass}" colspan="2" style="display:none"></div>',"{afterBodyEl}","</td>","</tpl>","</tr>",{disableFormats:true}],activeErrorsTpl:['<tpl if="errors && errors.length">','<ul><tpl for="errors"><li>{.}</li></tpl></ul>',"</tpl>"],isFieldLabelable:true,formItemCls:Ext.baseCSSPrefix+"form-item",labelCls:Ext.baseCSSPrefix+"form-item-label",errorMsgCls:Ext.baseCSSPrefix+"form-error-msg",baseBodyCls:Ext.baseCSSPrefix+"form-item-body",fieldBodyCls:"",clearCls:Ext.baseCSSPrefix+"clear",invalidCls:Ext.baseCSSPrefix+"form-invalid",fieldLabel:undefined,labelAlign:"left",labelWidth:100,labelPad:5,labelSeparator:":",hideLabel:false,hideEmptyLabel:true,preventMark:false,autoFitErrors:true,msgTarget:"qtip",noWrap:true,labelableInsertions:["beforeBodyEl","afterBodyEl","beforeLabelTpl","afterLabelTpl","beforeSubTpl","afterSubTpl","beforeLabelTextTpl","afterLabelTextTpl","labelAttrTpl"],labelableRenderProps:["allowBlank","id","labelAlign","fieldBodyCls","baseBodyCls","clearCls","labelSeparator","msgTarget"],initLabelable:function(){var a=this,b=a.padding;if(b){a.padding=undefined;a.extraMargins=Ext.Element.parseBox(b)}a.addCls(a.formItemCls);a.lastActiveError="";a.addEvents("errorchange")},trimLabelSeparator:function(){var c=this,d=c.labelSeparator,a=c.fieldLabel||"",b=a.substr(a.length-1);return b===d?a.slice(0,-1):a},getFieldLabel:function(){return this.trimLabelSeparator()},setFieldLabel:function(b){b=b||"";var c=this,d=c.labelSeparator,a=c.labelEl;c.fieldLabel=b;if(c.rendered){if(Ext.isEmpty(b)&&c.hideEmptyLabel){a.parent().setDisplayed("none")}else{if(d){b=c.trimLabelSeparator()+d}a.update(b);a.parent().setDisplayed("")}c.updateLayout()}},getInsertionRenderData:function(d,e){var b=e.length,a,c;while(b--){a=e[b];c=this[a];if(c){if(typeof c!="string"){if(!c.isTemplate){c=Ext.XTemplate.getTpl(this,a)}c=c.apply(d)}}d[a]=c||""}return d},getLabelableRenderData:function(){var b=this,c,d,a=b.labelAlign==="top";if(!Ext.form.Labelable.errorIconWidth){Ext.form.Labelable.errorIconWidth=(d=Ext.resetElement.createChild({style:"position:absolute",cls:Ext.baseCSSPrefix+"form-invalid-icon"})).getWidth();d.remove()}c=Ext.copyTo({inFormLayout:b.ownerLayout&&b.ownerLayout.type==="form",inputId:b.getInputId(),labelOnLeft:!a,hideLabel:!b.hasVisibleLabel(),fieldLabel:b.getFieldLabel(),labelCellStyle:b.getLabelCellStyle(),labelCellAttrs:b.getLabelCellAttrs(),labelCls:b.getLabelCls(),labelStyle:b.getLabelStyle(),bodyColspan:b.getBodyColspan(),externalError:!b.autoFitErrors,errorMsgCls:b.getErrorMsgCls(),errorIconWidth:Ext.form.Labelable.errorIconWidth},b,b.labelableRenderProps,true);b.getInsertionRenderData(c,b.labelableInsertions);return c},beforeLabelableRender:function(){var a=this;if(a.ownerLayout){a.addCls(Ext.baseCSSPrefix+a.ownerLayout.type+"-form-item")}},onLabelableRender:function(){var c=this,d,a,b={};if(c.extraMargins){d=c.el.getMargin();for(a in d){if(d.hasOwnProperty(a)){b["margin-"+a]=(d[a]+c.extraMargins[a])+"px"}}c.el.setStyle(b)}},hasVisibleLabel:function(){if(this.hideLabel){return false}return !(this.hideEmptyLabel&&!this.getFieldLabel())},getBodyColspan:function(){var b=this,a;if(b.msgTarget==="side"&&(!b.autoFitErrors||b.hasActiveError())){a=1}else{a=2}if(b.labelAlign!=="top"&&!b.hasVisibleLabel()){a++}return a},getLabelCls:function(){var b=this.labelCls,a=this.labelClsExtra;if(this.labelAlign==="top"){b+="-top"}return a?b+" "+a:b},getLabelCellStyle:function(){var b=this,a=b.hideLabel||(!b.fieldLabel&&b.hideEmptyLabel);return a?"display:none;":""},getErrorMsgCls:function(){var b=this,a=(b.hideLabel||(!b.fieldLabel&&b.hideEmptyLabel));return b.errorMsgCls+(!a&&b.labelAlign==="top"?" "+Ext.baseCSSPrefix+"lbl-top-err-icon":"")},getLabelCellAttrs:function(){var c=this,b=c.labelAlign,a="";if(b!=="top"){a='valign="top" halign="'+b+'" width="'+(c.labelWidth+c.labelPad)+'"'}return a+' class="'+Ext.baseCSSPrefix+'field-label-cell"'},getLabelStyle:function(){var c=this,b=c.labelPad,a="";if(c.labelAlign!=="top"){if(c.labelWidth){a="width:"+c.labelWidth+"px;"}a+="margin-right:"+b+"px;"}return a+(c.labelStyle||"")},getSubTplMarkup:function(){return""},getInputId:function(){return""},getActiveError:function(){return this.activeError||""},hasActiveError:function(){return !!this.getActiveError()},setActiveError:function(a){this.setActiveErrors(a)},getActiveErrors:function(){return this.activeErrors||[]},setActiveErrors:function(a){a=Ext.Array.from(a);this.activeError=a[0];this.activeErrors=a;this.activeError=this.getTpl("activeErrorsTpl").apply({errors:a});this.renderActiveError()},unsetActiveError:function(){delete this.activeError;delete this.activeErrors;this.renderActiveError()},renderActiveError:function(){var c=this,b=c.getActiveError(),a=!!b;if(b!==c.lastActiveError){c.fireEvent("errorchange",c,b);c.lastActiveError=b}if(c.rendered&&!c.isDestroyed&&!c.preventMark){c.el[a?"addCls":"removeCls"](c.invalidCls);c.getActionEl().dom.setAttribute("aria-invalid",a);if(c.errorEl){c.errorEl.dom.innerHTML=b}}},setFieldDefaults:function(c){var b=this,d,a;for(a in c){if(c.hasOwnProperty(a)){d=c[a];if(!b.hasOwnProperty(a)){b[a]=d}}}}});Ext.define("Ext.layout.Layout",{requires:["Ext.XTemplate"],uses:["Ext.layout.Context"],isLayout:true,initialized:false,running:false,autoSizePolicy:{setsWidth:0,setsHeight:0},statics:{layoutsByType:{},create:function(f,e){var j=Ext.ClassManager,c=this.layoutsByType,d,g,b,a,h,i;if(!f||typeof f==="string"){h=f||e;b={}}else{if(f.isLayout){return f}else{b=f;h=f.type||e}}if(!(a=c[h])){d="layout."+h;g=j.getNameByAlias(d);if(!g){i=true}a=j.get(g);if(i||!a){return j.instantiateByAlias(d,b||{})}c[h]=a}return new a(b)}},constructor:function(a){var b=this;b.id=Ext.id(null,b.type+"-");Ext.apply(b,a);b.layoutCount=0},beginLayout:Ext.emptyFn,beginLayoutCycle:function(c){var b=this,a=b.context,d;if(b.lastWidthModel!=c.widthModel){if(b.lastWidthModel){d=true}b.lastWidthModel=c.widthModel}if(b.lastHeightModel!=c.heightModel){if(b.lastWidthModel){d=true}b.lastHeightModel=c.heightModel}if(d){(a=c.context).clearTriggers(b,false);a.clearTriggers(b,true);b.triggerCount=0}},finishedLayout:function(){this.ownerContext=null},redoLayout:Ext.emptyFn,undoLayout:Ext.emptyFn,getAnimatePolicy:function(){return this.animatePolicy},getItemSizePolicy:function(a){return this.autoSizePolicy},isItemBoxParent:function(a){return false},isItemLayoutRoot:function(d){var c=d.getSizeModel(),b=c.width,a=c.height;if(!d.componentLayout.lastComponentSize&&(b.calculated||a.calculated)){return false}return !b.shrinkWrap&&!a.shrinkWrap},isItemShrinkWrap:function(a){return a.shrinkWrap},isRunning:function(){return !!this.ownerContext},getItemsRenderTree:function(d,b){var g=d.length,e,f,c,a;if(g){a=[];for(e=0;e<g;++e){f=d[e];if(!f.rendered){if(b&&(b[f.id]!==undefined)){c=b[f.id]}else{this.configureItem(f);c=f.getRenderTree();if(b){b[f.id]=c}}if(c){a.push(c)}}}}return a},finishRender:Ext.emptyFn,finishRenderItems:function(e,a){var d=a.length,b,c;for(b=0;b<d;b++){c=a[b];if(c.rendering){c.finishRender(b);this.afterRenderItem(c)}}},renderChildren:function(){var b=this,a=b.getLayoutItems(),c=b.getRenderTarget();b.renderItems(a,c)},renderItems:function(a,f){var e=this,d=a.length,b=0,c;if(d){Ext.suspendLayouts();for(;b<d;b++){c=a[b];if(c&&!c.rendered){e.renderItem(c,f,b)}else{if(!e.isValidParent(c,f,b)){e.moveItem(c,f,b)}else{e.configureItem(c)}}}Ext.resumeLayouts(true)}},isValidParent:function(d,e,a){var b=d.el?d.el.dom:Ext.getDom(d),c=(e&&e.dom)||e;if(b.parentNode&&b.parentNode.className.indexOf(Ext.baseCSSPrefix+"resizable-wrap")!==-1){b=b.parentNode}if(b&&c){if(typeof a=="number"){return b===c.childNodes[a]}return b.parentNode===c}return false},configureItem:function(a){a.ownerLayout=this},renderItem:function(c,d,a){var b=this;if(!c.rendered){b.configureItem(c);c.render(d,a);b.afterRenderItem(c)}},moveItem:function(b,c,a){c=c.dom||c;if(typeof a=="number"){a=c.childNodes[a]}c.insertBefore(b.el.dom,a||null);b.container=Ext.get(c);this.configureItem(b)},onContentChange:function(){this.owner.updateLayout();return true},initLayout:function(){this.initialized=true},setOwner:function(a){this.owner=a},getLayoutItems:function(){return[]},afterRenderItem:Ext.emptyFn,onAdd:Ext.emptyFn,onRemove:Ext.emptyFn,onDestroy:Ext.emptyFn,afterRemove:function(e){var d=this,c=e.el,b=d.owner,a;if(e.rendered){a=[].concat(d.itemCls||[]);if(b.itemCls){a=Ext.Array.push(a,b.itemCls)}if(a.length){c.removeCls(a)}}delete e.ownerLayout},destroy:function(){var a=this,b;if(a.targetCls){b=a.getTarget();if(b){b.removeCls(a.targetCls)}}a.onDestroy()},sortWeightedItems:function(a,d){for(var b=0,c=a.length;b<c;++b){a[b].$i=b}Ext.Array.sort(a,function(f,e){var g=e.weight-f.weight;if(!g){g=f.$i-e.$i;if(f[d]){g=-g}}return g});for(b=0;b<c;++b){delete a[b].$i}}},function(){var k=this,h={},l=[],f,e,b,a,d;k.prototype.sizeModels=k.sizeModels=h;var g=function(j){var m=this,i=j.name;Ext.apply(Ext.apply(m,c),j);m[i]=true;g[i]=h[i]=m;m.fixed=!(m.auto=m.natural||m.shrinkWrap);m.ordinal=l.length;l.push(m)};Ext.layout.SizeModel=g;var c={calculated:false,configured:false,constrainedMax:false,constrainedMin:false,natural:false,shrinkWrap:false,calculatedFromConfigured:false,calculatedFromNatural:false,calculatedFromShrinkWrap:false,names:null};new g({name:"calculated"});new g({name:"configured",names:{width:"width",height:"height"}});new g({name:"natural"});new g({name:"shrinkWrap"});new g({name:"calculatedFromConfigured",configured:true,names:{width:"width",height:"height"}});new g({name:"calculatedFromNatural",natural:true});new g({name:"calculatedFromShrinkWrap",shrinkWrap:true});new g({name:"constrainedMax",configured:true,constrained:true,names:{width:"maxWidth",height:"maxHeight"}});new g({name:"constrainedMin",configured:true,constrained:true,names:{width:"minWidth",height:"minHeight"}});for(f=0,b=l.length;f<b;++f){d=l[f];d.pairsByHeightOrdinal=a=[];for(e=0;e<b;++e){a.push({width:d,height:l[e]})}}});Ext.define("Ext.layout.container.Container",{extend:"Ext.layout.Layout",alternateClassName:"Ext.layout.ContainerLayout",mixins:{elementCt:"Ext.util.ElementContainer"},requires:["Ext.XTemplate"],type:"container",manageOverflow:0,beginCollapse:Ext.emptyFn,beginExpand:Ext.emptyFn,animatePolicy:null,childEls:["overflowPadderEl"],renderTpl:["{%this.renderBody(out,values)%}"],usesContainerHeight:true,usesContainerWidth:true,usesHeight:true,usesWidth:true,reserveScrollbar:false,lastOverflowAdjust:{width:0,height:0},constructor:function(){this.callParent(arguments);this.mixins.elementCt.constructor.call(this)},destroy:function(){this.callParent();this.mixins.elementCt.destroy.call(this)},initLayout:function(){var b=this,a=Ext.getScrollbarSize().width;b.callParent();if(a&&b.manageOverflow&&!b.hasOwnProperty("lastOverflowAdjust")){if(b.owner.autoScroll||b.reserveScrollbar){b.lastOverflowAdjust={width:a,height:0}}}},beginLayout:function(a){this.callParent(arguments);a.targetContext=a.getEl("getTarget",this);this.cacheChildItems(a)},beginLayoutCycle:function(c,a){var b=this,d=b.overflowPadderEl;b.callParent(arguments);if(!c.state.overflowAdjust){c.state.overflowAdjust=b.lastOverflowAdjust}if(a){if(b.usesContainerHeight){++c.consumersContainerHeight}if(b.usesContainerWidth){++c.consumersContainerWidth}}if(d){d.setStyle("display","none")}},completeLayout:function(a){this.lastOverflowAdjust=a.state.overflowAdjust},cacheChildItems:function(e){var c=e.context,f=[],a=this.getVisibleItems(),d=a.length,b;e.childItems=f;e.visibleItems=a;for(b=0;b<d;++b){f.push(c.getCmp(a[b]))}},cacheElements:function(){var a=this.owner;this.applyChildEls(a.el,a.id)},calculateContentSize:function(p,l){var A=this,d=(l||0)|A.manageOverflow|((p.widthModel.shrinkWrap?1:0)|(p.heightModel.shrinkWrap?2:0)),c=(d&1)||undefined,h=(d&2)||undefined,b=p.childItems,f=b.length,v=0,t=0,m=0,e=p.props,q,o,n,z,g,k,s,y,x,r,w,a,u,j;if(c){if(isNaN(e.contentWidth)){++m}else{c=undefined}}if(h){if(isNaN(e.contentHeight)){++m}else{h=undefined}}if(m){for(w=0;w<f;++w){s=b[w];k=s.target;r=h&&s.getProp("height");u=c&&s.getProp("width");a=s.getMarginInfo();if((c&&isNaN(k.x))||(h&&isNaN(k.y))){j=k.el.getXY();if(!q){q=p.targetContext.el.getXY();g=p.targetContext.getBorderInfo();o=q[0]+g.left;n=q[1]+g.top}y=j[0]-o;x=j[1]-n}else{y=k.x;x=k.y}r+=a.bottom;u+=a.right;v=Math.max(v,x+r);t=Math.max(t,y+u);if(isNaN(v)&&isNaN(t)){A.done=false;return}}if(c||h){z=p.targetContext.getPaddingInfo()}if(c&&!p.setContentWidth(t+z.right)){A.done=false}if(h&&!p.setContentHeight(v+z.bottom)){A.done=false}}},calculateOverflow:function(m,r,g){var v=this,a=v.owner,k=v.manageOverflow,d=m.state,l=d.overflowAdjust,f,j,c,n,b,p,s,i,q,e,o,t,h,u;if(k&&!d.secondPass&&!v.reserveScrollbar){if(a.autoScroll){h=u=true}else{if(a.overflowX){h=a.overflowX=="auto"}else{p=m.targetContext.getStyle("overflow-x");h=p&&p!="hidden"&&p!="scroll"}if(a.overflowY){u=a.overflowY=="auto"}else{p=m.targetContext.getStyle("overflow-y");u=p&&p!="hidden"&&p!="scroll"}}if(!r.gotWidth){h=false}if(!r.gotHeight){u=false}if(h||u){s=Ext.getScrollbarSize();i=m.peek("contentWidth");q=m.peek("contentHeight");e=r.width;o=r.height;t=v.getScrollbarsNeeded(e,o,i,q);d.overflowState=t;if(typeof g=="number"){t&=~g}l={width:(h&&(t&2))?s.width:0,height:(u&&(t&1))?s.height:0};if(l.width!==v.lastOverflowAdjust.width||l.height!==v.lastOverflowAdjust.height){v.done=false;m.invalidate({state:{overflowAdjust:l,overflowState:d.overflowState,secondPass:true}})}}}if(!v.done){return}c=m.padElContext||(m.padElContext=m.getEl("overflowPadderEl",v));if(c){t=d.overflowState;f=r.width;j=0;if(t){n=m.targetContext.getPaddingInfo();b=v.scrollRangeFlags;if((t&2)&&(b&1)){j+=n.bottom}if((t&1)&&(b&4)){f+=n.right}c.setProp("display","");c.setSize(f,j)}else{c.setProp("display","none")}}},configureItem:function(c){var b=this,a=b.owner.itemCls,d=[].concat(b.itemCls||[]);b.callParent(arguments);if(a){d=Ext.Array.push(d,a)}c.addCls(d)},doRenderBody:function(a,b){this.renderItems(a,b);this.renderContent(a,b)},doRenderContainer:function(b,e){var c=e.$comp.layout,a=c.getRenderTpl(),d=c.getRenderData();a.applyOut(d,b)},doRenderItems:function(b,d){var c=d.$layout,a=c.getRenderTree();if(a){Ext.DomHelper.generateMarkup(a,b)}},doRenderPadder:function(b,d){var c=d.$layout,a=c.owner,e=c.getScrollRangeFlags();if(c.manageOverflow==2){if(e&5){b.push('<div id="',a.id,'-overflowPadderEl" ','style="font-size: 1px; width:1px; height: 1px;');b.push('"></div>');c.scrollRangeFlags=e}}},finishRender:function(){var b=this,c,a;b.callParent();b.cacheElements();c=b.getRenderTarget();a=b.getLayoutItems();if(b.targetCls){b.getTarget().addCls(b.targetCls)}b.finishRenderItems(c,a)},notifyOwner:function(){this.owner.afterLayout(this)},getContainerSize:function(c,g){var d=c.targetContext,f=d.getFrameInfo(),j=d.getPaddingInfo(),i=0,k=0,a=c.state.overflowAdjust,e,h,b,l;if(!c.widthModel.shrinkWrap){++k;b=g?d.getDomProp("width"):d.getProp("width");e=(typeof b=="number");if(e){++i;b-=f.width+j.width;if(a){b-=a.width}}}if(!c.heightModel.shrinkWrap){++k;l=g?d.getDomProp("height"):d.getProp("height");h=(typeof l=="number");if(h){++i;l-=f.height+j.height;if(a){l-=a.height}}}return{width:b,height:l,needed:k,got:i,gotAll:i==k,gotWidth:e,gotHeight:h}},getLayoutItems:function(){var a=this.owner,b=a&&a.items;return(b&&b.items)||[]},getRenderData:function(){var a=this.owner;return{$comp:a,$layout:this,ownerId:a.id}},getRenderedItems:function(){var e=this,g=e.getRenderTarget(),a=e.getLayoutItems(),d=a.length,f=[],b,c;for(b=0;b<d;b++){c=a[b];if(c.rendered&&e.isValidParent(c,g,b)){f.push(c)}}return f},getRenderTarget:function(){return this.owner.getTargetEl()},getElementTarget:function(){return this.getRenderTarget()},getRenderTpl:function(){var a=this,b=Ext.XTemplate.getTpl(this,"renderTpl");if(!b.renderContent){a.owner.setupRenderTpl(b)}return b},getRenderTree:function(){var a,c=this.owner.items,d,b={};do{d=c.generation;a=this.getItemsRenderTree(this.getLayoutItems(),b)}while(c.generation!==d);return a},getScrollbarsNeeded:function(c,h,b,g){var a=Ext.getScrollbarSize(),e=typeof c=="number",i=typeof h=="number",f=0,d=0;if(!a.width){return 0}if(i&&h<g){d=2;c-=a.width}if(e&&c<b){f=1;if(!d&&i){h-=a.height;if(h<g){d=2}}}return d+f},getScrollRangeFlags:(function(){var a=-1;return function(){if(a<0){var f=Ext.getBody().createChild({cls:Ext.baseCSSPrefix+"border-box",style:{width:"100px",height:"100px",padding:"10px",overflow:"auto"},children:[{style:{border:"1px solid red",width:"150px",height:"150px",margin:"0 5px 5px 0"}}]}),d=f.dom.scrollHeight,c=f.dom.scrollWidth,e={175:0,165:1,170:2,160:3},b={175:0,165:4,170:8,160:12};a=(e[d]||0)|(b[c]||0);f.remove()}return a}}()),getTarget:function(){return this.owner.getTargetEl()},getVisibleItems:function(){var f=this.getRenderTarget(),b=this.getLayoutItems(),e=b.length,a=[],c,d;for(c=0;c<e;c++){d=b[c];if(d.rendered&&this.isValidParent(d,f,c)&&d.hidden!==true){a.push(d)}}return a},setupRenderTpl:function(b){var a=this;b.renderBody=a.doRenderBody;b.renderContainer=a.doRenderContainer;b.renderItems=a.doRenderItems;b.renderPadder=a.doRenderPadder}});Ext.define("Ext.layout.container.Anchor",{alias:"layout.anchor",extend:"Ext.layout.container.Container",alternateClassName:"Ext.layout.AnchorLayout",type:"anchor",manageOverflow:2,renderTpl:["{%this.renderBody(out,values);this.renderPadder(out,values)%}"],defaultAnchor:"100%",parseAnchorRE:/^(r|right|b|bottom)$/i,beginLayout:function(c){var h=this,a=0,f,j,e,d,b,g;h.callParent(arguments);e=c.childItems;b=e.length;for(d=0;d<b;++d){j=e[d];f=j.target.anchorSpec;if(f){if(j.widthModel.calculated&&f.right){a|=1}if(j.heightModel.calculated&&f.bottom){a|=2}if(a==3){break}}}c.anchorDimensions=a;if(!Ext.supports.RightMargin&&!h.rightMarginCleanerFn){g=c.targetContext.el;h.rightMarginCleanerFn=Ext.Element.getRightMarginFixCleaner(g);g.addCls(Ext.baseCSSPrefix+"inline-children")}},calculate:function(b){var a=this,c=a.getContainerSize(b);if(b.anchorDimensions!==b.state.calculatedAnchors){a.calculateAnchors(b,c)}if(b.hasDomProp("containerChildrenDone")){if(!c.gotAll){a.done=false}a.calculateContentSize(b,b.anchorDimensions);if(a.done){a.calculateOverflow(b,c,b.anchorDimensions);return}}a.done=false},calculateAnchors:function(g,a){var o=this,k=g.childItems,f=k.length,n=a.gotHeight,h=a.gotWidth,e=a.height,c=a.width,b=g.state,p=(h?1:0)|(n?2:0),l,r,m,q,j,d;b.calculatedAnchors=(b.calculatedAnchors||0)|p;for(j=0;j<f;j++){r=k[j];m=r.getMarginInfo();l=r.target.anchorSpec;if(h&&r.widthModel.calculated){d=l.right(c)-m.width;d=o.adjustWidthAnchor(d,r);r.setWidth(d)}if(n&&r.heightModel.calculated){q=l.bottom(e)-m.height;q=o.adjustHeightAnchor(q,r);r.setHeight(q)}}},finishedLayout:function(b){var a=this.rightMarginCleanerFn;if(a){delete this.rightMarginCleanerFn;b.targetContext.el.removeCls(Ext.baseCSSPrefix+"inline-children");a()}},anchorFactory:{offset:function(a){return function(b){return b+a}},ratio:function(a){return function(b){return Math.floor(b*a)}},standard:function(a){return function(b){return b-a}}},parseAnchor:function(c,f,b){if(c&&c!="none"){var d=this.anchorFactory,e;if(this.parseAnchorRE.test(c)){return d.standard(b-f)}if(c.indexOf("%")!=-1){return d.ratio(parseFloat(c.replace("%",""))*0.01)}e=parseInt(c,10);if(!isNaN(e)){return d.offset(e)}}return null},adjustWidthAnchor:function(b,a){return b},adjustHeightAnchor:function(b,a){return b},configureItem:function(f){var e=this,a=e.owner,d=f.anchor,b,c,g;e.callParent(arguments);if(!f.anchor&&f.items&&!Ext.isNumber(f.width)&&!(Ext.isIE6&&Ext.isStrict)){f.anchor=d=e.defaultAnchor}if(a.anchorSize){if(typeof a.anchorSize=="number"){c=a.anchorSize}else{c=a.anchorSize.width;g=a.anchorSize.height}}else{c=a.initialConfig.width;g=a.initialConfig.height}if(d){b=d.split(" ");f.anchorSpec={right:e.parseAnchor(b[0],f.initialConfig.width,c),bottom:e.parseAnchor(b[1],f.initialConfig.height,g)}}},sizePolicy:{"":{setsWidth:0,setsHeight:0},b:{setsWidth:0,setsHeight:1},r:{"":{setsWidth:1,setsHeight:0},b:{setsWidth:1,setsHeight:1}}},getItemSizePolicy:function(c){var e=c.anchorSpec,a="",d=this.sizePolicy,b;if(e){b=this.owner.getSizeModel();if(e.right&&!b.width.shrinkWrap){d=d.r}if(e.bottom&&!b.height.shrinkWrap){a="b"}}return d[a]}});Ext.define("Ext.dd.DragDropManager",{singleton:true,requires:["Ext.util.Region"],uses:["Ext.tip.QuickTipManager"],alternateClassName:["Ext.dd.DragDropMgr","Ext.dd.DDM"],ids:{},handleIds:{},dragCurrent:null,dragOvers:{},deltaX:0,deltaY:0,preventDefault:true,stopPropagation:true,initialized:false,locked:false,init:function(){this.initialized=true},POINT:0,INTERSECT:1,mode:0,notifyOccluded:false,_execOnAll:function(c,b){var d,a,e;for(d in this.ids){for(a in this.ids[d]){e=this.ids[d][a];if(!this.isTypeOfDD(e)){continue}e[c].apply(e,b)}}},_onLoad:function(){this.init();var a=Ext.EventManager;a.on(document,"mouseup",this.handleMouseUp,this,true);a.on(document,"mousemove",this.handleMouseMove,this,true);a.on(window,"unload",this._onUnload,this,true);a.on(window,"resize",this._onResize,this,true)},_onResize:function(a){this._execOnAll("resetConstraints",[])},lock:function(){this.locked=true},unlock:function(){this.locked=false},isLocked:function(){return this.locked},locationCache:{},useCache:true,clickPixelThresh:3,clickTimeThresh:350,dragThreshMet:false,clickTimeout:null,startX:0,startY:0,regDragDrop:function(b,a){if(!this.initialized){this.init()}if(!this.ids[a]){this.ids[a]={}}this.ids[a][b.id]=b},removeDDFromGroup:function(c,a){if(!this.ids[a]){this.ids[a]={}}var b=this.ids[a];if(b&&b[c.id]){delete b[c.id]}},_remove:function(b){for(var a in b.groups){if(a&&this.ids[a]&&this.ids[a][b.id]){delete this.ids[a][b.id]}}delete this.handleIds[b.id]},regHandle:function(b,a){if(!this.handleIds[b]){this.handleIds[b]={}}this.handleIds[b][a]=a},isDragDrop:function(a){return(this.getDDById(a))?true:false},getRelated:function(f,b){var e=[],d,c,a;for(d in f.groups){for(c in this.ids[d]){a=this.ids[d][c];if(!this.isTypeOfDD(a)){continue}if(!b||a.isTarget){e[e.length]=a}}}return e},isLegalTarget:function(e,d){var b=this.getRelated(e,true),c,a;for(c=0,a=b.length;c<a;++c){if(b[c].id==d.id){return true}}return false},isTypeOfDD:function(a){return(a&&a.__ygDragDrop)},isHandle:function(b,a){return(this.handleIds[b]&&this.handleIds[b][a])},getDDById:function(d){var c=this,b,a;for(b in this.ids){a=this.ids[b][d];if(a instanceof Ext.dd.DDTarget){return a}}return null},handleMouseDown:function(c,b){if(Ext.tip.QuickTipManager){Ext.tip.QuickTipManager.ddDisable()}if(this.dragCurrent){this.handleMouseUp(c)}this.currentTarget=c.getTarget();this.dragCurrent=b;var a=b.getEl();if(Ext.isIE&&a.setCapture){a.setCapture()}this.startX=c.getPageX();this.startY=c.getPageY();this.deltaX=this.startX-a.offsetLeft;this.deltaY=this.startY-a.offsetTop;this.dragThreshMet=false;this.clickTimeout=setTimeout(function(){var d=Ext.dd.DragDropManager;d.startDrag(d.startX,d.startY)},this.clickTimeThresh)},startDrag:function(a,b){clearTimeout(this.clickTimeout);if(this.dragCurrent){this.dragCurrent.b4StartDrag(a,b);this.dragCurrent.startDrag(a,b)}this.dragThreshMet=true},handleMouseUp:function(b){var a=this.dragCurrent;if(Ext.tip&&Ext.tip.QuickTipManager){Ext.tip.QuickTipManager.ddEnable()}if(!a){return}if(Ext.isIE&&document.releaseCapture){document.releaseCapture()}clearTimeout(this.clickTimeout);if(this.dragThreshMet){this.fireEvents(b,true)}this.stopDrag(b);this.stopEvent(b)},stopEvent:function(a){if(this.stopPropagation){a.stopPropagation()}if(this.preventDefault){a.preventDefault()}},stopDrag:function(a){if(this.dragCurrent){if(this.dragThreshMet){this.dragCurrent.b4EndDrag(a);this.dragCurrent.endDrag(a)}this.dragCurrent.onMouseUp(a)}this.dragCurrent=null;this.dragOvers={}},handleMouseMove:function(d){var c=this,b,a;if(!c.dragCurrent){return true}if(!c.dragThreshMet){b=Math.abs(c.startX-d.getPageX());a=Math.abs(c.startY-d.getPageY());if(b>c.clickPixelThresh||a>c.clickPixelThresh){c.startDrag(c.startX,c.startY)}}if(c.dragThreshMet){c.dragCurrent.b4Drag(d);c.dragCurrent.onDrag(d);if(!c.dragCurrent.moveOnly){c.fireEvents(d,false)}}c.stopEvent(d);return true},fireEvents:function(m,p){var o=this,j=o.dragCurrent,q=m.getPoint(),b,s,d=[],a=[],f=[],k=[],h=[],c=[],n,g,l,r;if(!j||j.isLocked()){return}for(g in o.dragOvers){b=o.dragOvers[g];if(!o.isTypeOfDD(b)){continue}if(!this.isOverTarget(q,b,o.mode)){f.push(b)}a[g]=true;delete o.dragOvers[g]}for(r in j.groups){if("string"!=typeof r){continue}for(g in o.ids[r]){b=o.ids[r][g];if(o.isTypeOfDD(b)&&(s=b.getEl())&&(b.isTarget)&&(!b.isLocked())&&(Ext.fly(s).isVisible(true))&&((b!=j)||(j.ignoreSelf===false))){if((b.zIndex=o.getZIndex(s))!==-1){n=true}d.push(b)}}}if(n){Ext.Array.sort(d,o.byZIndex)}for(g=0,l=d.length;g<l;g++){b=d[g];if(o.isOverTarget(q,b,o.mode)){if(p){h.push(b)}else{if(!a[b.id]){c.push(b)}else{k.push(b)}o.dragOvers[b.id]=b}if(!o.notifyOccluded){break}}}if(o.mode){if(f.length){j.b4DragOut(m,f);j.onDragOut(m,f)}if(c.length){j.onDragEnter(m,c)}if(k.length){j.b4DragOver(m,k);j.onDragOver(m,k)}if(h.length){j.b4DragDrop(m,h);j.onDragDrop(m,h)}}else{for(g=0,l=f.length;g<l;++g){j.b4DragOut(m,f[g].id);j.onDragOut(m,f[g].id)}for(g=0,l=c.length;g<l;++g){j.onDragEnter(m,c[g].id)}for(g=0,l=k.length;g<l;++g){j.b4DragOver(m,k[g].id);j.onDragOver(m,k[g].id)}for(g=0,l=h.length;g<l;++g){j.b4DragDrop(m,h[g].id);j.onDragDrop(m,h[g].id)}}if(p&&!h.length){j.onInvalidDrop(m)}},getZIndex:function(b){var a=document.body,c,d=-1;b=Ext.getDom(b);while(b!==a){if(!isNaN(c=Number(Ext.fly(b).getStyle("zIndex")))){d=c}b=b.parentNode}return d},byZIndex:function(b,a){return b.zIndex<a.zIndex},getBestMatch:function(c){var e=null,b=c.length,d,a;if(b==1){e=c[0]}else{for(d=0;d<b;++d){a=c[d];if(a.cursorIsOver){e=a;break}else{if(!e||e.overlap.getArea()<a.overlap.getArea()){e=a}}}}return e},refreshCache:function(b){var a,c,d,e;for(a in b){if("string"!=typeof a){continue}for(c in this.ids[a]){d=this.ids[a][c];if(this.isTypeOfDD(d)){e=this.getLocation(d);if(e){this.locationCache[d.id]=e}else{delete this.locationCache[d.id]}}}}},verifyEl:function(b){if(b){var a;if(Ext.isIE){try{a=b.offsetParent}catch(c){}}else{a=b.offsetParent}if(a){return true}}return false},getLocation:function(h){if(!this.isTypeOfDD(h)){return null}if(h.getRegion){return h.getRegion()}var f=h.getEl(),k,d,c,n,m,o,a,j,g;try{k=Ext.Element.getXY(f)}catch(i){}if(!k){return null}d=k[0];c=d+f.offsetWidth;n=k[1];m=n+f.offsetHeight;o=n-h.padding[0];a=c+h.padding[1];j=m+h.padding[2];g=d-h.padding[3];return new Ext.util.Region(o,a,j,g)},isOverTarget:function(i,a,c){var e=this.locationCache[a.id],h,f,b,d,g;if(!e||!this.useCache){e=this.getLocation(a);this.locationCache[a.id]=e}if(!e){return false}a.cursorIsOver=e.contains(i);h=this.dragCurrent;if(!h||!h.getTargetCoord||(!c&&!h.constrainX&&!h.constrainY)){return a.cursorIsOver}a.overlap=null;f=h.getTargetCoord(i.x,i.y);b=h.getDragEl();d=new Ext.util.Region(f.y,f.x+b.offsetWidth,f.y+b.offsetHeight,f.x);g=d.intersect(e);if(g){a.overlap=g;return(c)?true:a.cursorIsOver}else{return false}},_onUnload:function(b,a){Ext.dd.DragDropManager.unregAll()},unregAll:function(){if(this.dragCurrent){this.stopDrag();this.dragCurrent=null}this._execOnAll("unreg",[]);for(var a in this.elementCache){delete this.elementCache[a]}this.elementCache={};this.ids={}},elementCache:{},getElWrapper:function(b){var a=this.elementCache[b];if(!a||!a.el){a=this.elementCache[b]=new this.ElementWrapper(Ext.getDom(b))}return a},getElement:function(a){return Ext.getDom(a)},getCss:function(b){var a=Ext.getDom(b);return(a)?a.style:null},ElementWrapper:function(a){this.el=a||null;this.id=this.el&&a.id;this.css=this.el&&a.style},getPosX:function(a){return Ext.Element.getX(a)},getPosY:function(a){return Ext.Element.getY(a)},swapNode:function(c,a){if(c.swapNode){c.swapNode(a)}else{var d=a.parentNode,b=a.nextSibling;if(b==c){d.insertBefore(c,a)}else{if(a==c.nextSibling){d.insertBefore(a,c)}else{c.parentNode.replaceChild(a,c);d.insertBefore(c,b)}}}},getScroll:function(){var d=window.document,e=d.documentElement,a=d.body,c=0,b=0;if(Ext.isGecko4){c=window.scrollYOffset;b=window.scrollXOffset}else{if(e&&(e.scrollTop||e.scrollLeft)){c=e.scrollTop;b=e.scrollLeft}else{if(a){c=a.scrollTop;b=a.scrollLeft}}}return{top:c,left:b}},getStyle:function(b,a){return Ext.fly(b).getStyle(a)},getScrollTop:function(){return this.getScroll().top},getScrollLeft:function(){return this.getScroll().left},moveToEl:function(a,c){var b=Ext.Element.getXY(c);Ext.Element.setXY(a,b)},numericSort:function(d,c){return(d-c)},_timeoutCount:0,_addListeners:function(){if(document){this._onLoad()}else{if(this._timeoutCount<=2000){setTimeout(this._addListeners,10);if(document&&document.body){this._timeoutCount+=1}}}},handleWasClicked:function(a,c){if(this.isHandle(c,a.id)){return true}else{var b=a.parentNode;while(b){if(this.isHandle(c,b.id)){return true}else{b=b.parentNode}}}return false}},function(){this._addListeners()});Ext.define("Ext.AbstractManager",{requires:["Ext.util.HashMap"],typeName:"type",constructor:function(a){Ext.apply(this,a||{});this.all=new Ext.util.HashMap();this.types={}},get:function(a){return this.all.get(a)},register:function(a){this.all.add(a)},unregister:function(a){this.all.remove(a)},registerType:function(b,a){this.types[b]=a;a[this.typeName]=b},isRegistered:function(a){return this.types[a]!==undefined},create:function(a,d){var b=a[this.typeName]||a.type||d,c=this.types[b];return new c(a)},onAvailable:function(f,c,b){var a=this.all,d,e;if(a.containsKey(f)){d=a.get(f);c.call(b||d,d)}else{e=function(i,g,h){if(g==f){c.call(b||h,h);a.un("add",e)}};a.on("add",e)}},each:function(b,a){this.all.each(b,a||this)},getCount:function(){return this.all.getCount()}});Ext.define("Ext.ModelManager",{extend:"Ext.AbstractManager",alternateClassName:"Ext.ModelMgr",requires:["Ext.data.association.Association"],singleton:true,typeName:"mtype",associationStack:[],registerType:function(c,b){var d=b.prototype,a;if(d&&d.isModel){a=b}else{if(!b.extend){b.extend="Ext.data.Model"}a=Ext.define(c,b)}this.types[c]=a;return a},onModelDefined:function(c){var a=this.associationStack,f=a.length,e=[],b,d,g;for(d=0;d<f;d++){b=a[d];if(b.associatedModel==c.modelName){e.push(b)}}for(d=0,f=e.length;d<f;d++){g=e[d];this.types[g.ownerModel].prototype.associations.add(Ext.data.association.Association.create(g));Ext.Array.remove(a,g)}},registerDeferredAssociation:function(a){this.associationStack.push(a)},getModel:function(b){var a=b;if(typeof a=="string"){a=this.types[a]}return a},create:function(b,a,d){var c=typeof a=="function"?a:this.types[a||b.name];return new c(b,d)}},function(){Ext.regModel=function(){return this.ModelManager.registerType.apply(this.ModelManager,arguments)}});Ext.define("Ext.data.Types",{singleton:true,requires:["Ext.data.SortTypes"]},function(){var a=Ext.data.SortTypes;Ext.apply(Ext.data.Types,{stripRe:/[\$,%]/g,AUTO:{sortType:a.none,type:"auto"},STRING:{convert:function(c){var b=this.useNull?null:"";return(c===undefined||c===null)?b:String(c)},sortType:a.asUCString,type:"string"},INT:{convert:function(b){return b!==undefined&&b!==null&&b!==""?parseInt(String(b).replace(Ext.data.Types.stripRe,""),10):(this.useNull?null:0)},sortType:a.none,type:"int"},FLOAT:{convert:function(b){return b!==undefined&&b!==null&&b!==""?parseFloat(String(b).replace(Ext.data.Types.stripRe,""),10):(this.useNull?null:0)},sortType:a.none,type:"float"},BOOL:{convert:function(b){if(this.useNull&&(b===undefined||b===null||b==="")){return null}return b===true||b==="true"||b==1},sortType:a.none,type:"bool"},DATE:{convert:function(c){var d=this.dateFormat,b;if(!c){return null}if(Ext.isDate(c)){return c}if(d){if(d=="timestamp"){return new Date(c*1000)}if(d=="time"){return new Date(parseInt(c,10))}return Ext.Date.parse(c,d)}b=Date.parse(c);return b?new Date(b):null},sortType:a.asDate,type:"date"}});Ext.apply(Ext.data.Types,{BOOLEAN:this.BOOL,INTEGER:this.INT,NUMBER:this.FLOAT})});Ext.define("Ext.data.Field",{requires:["Ext.data.Types","Ext.data.SortTypes"],alias:"data.field",isField:true,constructor:function(b){var d=this,c=Ext.data.Types,a;if(Ext.isString(b)){b={name:b}}Ext.apply(d,b);a=d.sortType;if(d.type){if(Ext.isString(d.type)){d.type=c[d.type.toUpperCase()]||c.AUTO}}else{d.type=c.AUTO}if(Ext.isString(a)){d.sortType=Ext.data.SortTypes[a]}else{if(Ext.isEmpty(a)){d.sortType=d.type.sortType}}if(!b.hasOwnProperty("convert")){d.convert=d.type.convert}else{if(!d.convert&&d.type.convert&&!b.hasOwnProperty("defaultValue")){d.defaultValue=d.type.convert(d.defaultValue)}}if(b.convert){d.hasCustomConvert=true}},dateFormat:null,useNull:false,defaultValue:"",mapping:null,sortType:null,sortDir:"ASC",allowBlank:true,persist:true});Ext.define("Ext.data.NodeInterface",{requires:["Ext.data.Field"],statics:{decorate:function(b){var a,c;if(typeof b=="string"){b=Ext.ModelManager.getModel(b)}else{if(b.isModel){b=Ext.ModelManager.getModel(b.modelName)}}if(b.prototype.isNode){return}a=b.prototype.idProperty;idField=b.prototype.fields.get(a);c=b.prototype.fields.get(a).type.type;b.override(this.getPrototypeBody());this.applyFields(b,[{name:"parentId",type:c,defaultValue:null,useNull:idField.useNull},{name:"index",type:"int",defaultValue:null,persist:false},{name:"depth",type:"int",defaultValue:0,persist:false},{name:"expanded",type:"bool",defaultValue:false,persist:false},{name:"expandable",type:"bool",defaultValue:true,persist:false},{name:"checked",type:"auto",defaultValue:null,persist:false},{name:"leaf",type:"bool",defaultValue:false},{name:"cls",type:"string",defaultValue:null,persist:false},{name:"iconCls",type:"string",defaultValue:null,persist:false},{name:"icon",type:"string",defaultValue:null,persist:false},{name:"root",type:"boolean",defaultValue:false,persist:false},{name:"isLast",type:"boolean",defaultValue:false,persist:false},{name:"isFirst",type:"boolean",defaultValue:false,persist:false},{name:"allowDrop",type:"boolean",defaultValue:true,persist:false},{name:"allowDrag",type:"boolean",defaultValue:true,persist:false},{name:"loaded",type:"boolean",defaultValue:false,persist:false},{name:"loading",type:"boolean",defaultValue:false,persist:false},{name:"href",type:"string",defaultValue:null,persist:false},{name:"hrefTarget",type:"string",defaultValue:null,persist:false},{name:"qtip",type:"string",defaultValue:null,persist:false},{name:"qtitle",type:"string",defaultValue:null,persist:false},{name:"children",type:"auto",defaultValue:null,persist:false}])},applyFields:function(c,b){var g=c.prototype,a=g.fields,f=a.keys,e=b.length,h,d;for(d=0;d<e;d++){h=b[d];if(!Ext.Array.contains(f,h.name)){a.add(new Ext.data.Field(h))}}},getPrototypeBody:function(){return{isNode:true,constructor:function(){var a=this;this.callParent(arguments);Ext.applyIf(a,{firstChild:null,lastChild:null,parentNode:null,previousSibling:null,nextSibling:null,childNodes:[]});a.enableBubble(["append","remove","move","insert","beforeappend","beforeremove","beforemove","beforeinsert","expand","collapse","beforeexpand","beforecollapse","sort"]);return a},createNode:function(a){if(Ext.isObject(a)&&!a.isModel){a=Ext.ModelManager.create(a,this.modelName)}if(!a.childNodes){Ext.applyIf(a,{firstChild:null,lastChild:null,parentNode:null,previousSibling:null,nextSibling:null,childNodes:[]})}return a},isLeaf:function(){return this.get("leaf")===true},setFirstChild:function(a){this.firstChild=a},setLastChild:function(a){this.lastChild=a},updateInfo:function(f){var l=this,b=l.isRoot(),j=l.parentNode,d=(!j||b?true:j.firstChild===l),h=(!j||b?true:j.lastChild===l),g=0,m=l,a=l.childNodes,k=a.length,e=0,c=l.phantom;while(m.parentNode){++g;m=m.parentNode}l.beginEdit();l.set({isFirst:d,isLast:h,depth:g,index:j?j.indexOf(l):0,parentId:j?j.getId():null});l.endEdit(true);if(f){l.commit();l.phantom=c}for(e=0;e<k;e++){a[e].updateInfo(f)}},isLast:function(){return this.get("isLast")},isFirst:function(){return this.get("isFirst")},hasChildNodes:function(){return !this.isLeaf()&&this.childNodes.length>0},isExpandable:function(){var a=this;if(a.get("expandable")){return !(a.isLeaf()||(a.isLoaded()&&!a.hasChildNodes()))}return false},triggerUIUpdate:function(){this.afterEdit([])},appendChild:function(b,j,c){var g=this,d,f,e,h,a;if(Ext.isArray(b)){g.callStore("suspendAutoSync");for(d=0,f=b.length-1;d<f;d++){g.appendChild(b[d])}g.callStore("resumeAutoSync");g.appendChild(b[f])}else{b=g.createNode(b);if(j!==true&&(!g.hasListeners.beforeappend||g.fireEvent("beforeappend",g,b)===false)){return false}e=g.childNodes.length;h=b.parentNode;if(h){if(j!==true&&(!g.hasListeners.beforeremove||b.fireEvent("beforemove",b,h,g,e)===false)){return false}h.removeChild(b,false,false,true)}e=g.childNodes.length;if(e===0){g.setFirstChild(b)}g.childNodes.push(b);b.parentNode=g;b.nextSibling=null;g.setLastChild(b);a=g.childNodes[e-1];if(a){b.previousSibling=a;a.nextSibling=b;a.updateInfo(c)}else{b.previousSibling=null}b.updateInfo(c);if(!g.isLoaded()){g.set("loaded",true)}else{if(g.childNodes.length===1){g.triggerUIUpdate()}}if(!b.isLeaf()&&b.phantom){b.set("loaded",true)}if(j!==true){g.fireEvent("append",g,b,e);if(h){b.fireEvent("move",b,h,g,e)}}return b}},getBubbleTarget:function(){return this.parentNode},removeChild:function(h,e,f,b){var g=this,c=g.indexOf(h),d,a;if(c==-1||(f!==true&&(!g.hasListeners.beforeremove||g.fireEvent("beforeremove",g,h,!!b)===false))){return false}Ext.Array.erase(g.childNodes,c,1);if(g.firstChild==h){g.setFirstChild(h.nextSibling)}if(g.lastChild==h){g.setLastChild(h.previousSibling)}if(h.previousSibling){h.previousSibling.nextSibling=h.nextSibling}if(h.nextSibling){h.nextSibling.previousSibling=h.previousSibling}for(d=c>0?c-1:0,a=g.childNodes.length;d<a;d++){g.childNodes[d].updateInfo()}if(!g.childNodes.length){g.triggerUIUpdate()}if(f!==true){if(g.hasListeners.remove){g.fireEvent("remove",g,h,!!b)}}if(e){h.destroy(true)}else{h.clear()}return h},copy:function(d,c){var f=this,b=f.callOverridden(arguments),a=f.childNodes?f.childNodes.length:0,e;if(c){for(e=0;e<a;e++){b.appendChild(f.childNodes[e].copy(true))}}return b},clear:function(a){var b=this;b.parentNode=b.previousSibling=b.nextSibling=null;if(a){b.firstChild=b.lastChild=null}},destroy:function(b){var d=this,c=d.destroyOptions,a=d.childNodes,e=a.length,f;if(b===true){d.clear(true);for(f=0;f<e;f++){a[f].destroy(true)}d.childNodes=null;delete d.destroyOptions;d.callOverridden([c])}else{d.destroyOptions=b;d.remove(true)}},insertBefore:function(b,f,k){var g=this,e=g.indexOf(f),h=b.parentNode,j=e,c,a,d;if(!f){return g.appendChild(b)}if(b==f){return false}b=g.createNode(b);if(k!==true&&(!g.hasListeners.beforeinsert||g.fireEvent("beforeinsert",g,b,f)===false)){return false}if(h==g&&g.indexOf(b)<e){j--}if(h){if(k!==true&&(!g.hasListeners.beforeremove||b.fireEvent("beforemove",b,h,g,e,f)===false)){return false}h.removeChild(b,false,false,true)}if(j===0){g.setFirstChild(b)}Ext.Array.splice(g.childNodes,j,0,b);b.parentNode=g;b.nextSibling=f;f.previousSibling=b;a=g.childNodes[j-1];if(a){b.previousSibling=a;a.nextSibling=b}else{b.previousSibling=null}for(d=j>0?j-1:0,c=g.childNodes.length;d<c;d++){g.childNodes[d].updateInfo()}if(!g.isLoaded()){g.set("loaded",true)}else{if(g.childNodes.length===1){g.triggerUIUpdate()}}if(!b.isLeaf()&&b.phantom){b.set("loaded",true)}if(k!==true){if(g.hasListeners.insert){g.fireEvent("insert",g,b,f)}if(h&&g.hasListeners.move){b.fireEvent("move",b,h,g,j,f)}}return b},insertChild:function(a,c){var b=this.childNodes[a];if(b){return this.insertBefore(c,b)}else{return this.appendChild(c)}},remove:function(b,c){var a=this.parentNode;if(a){a.removeChild(this,b,c)}return this},removeAll:function(a,b){var d=this.childNodes,c;while((c=d[0])){this.removeChild(c,a,b)}return this},getChildAt:function(a){return this.childNodes[a]},replaceChild:function(a,d,c){var b=d?d.nextSibling:null;this.removeChild(d,false,c);this.insertBefore(a,b,c);return d},indexOf:function(a){return Ext.Array.indexOf(this.childNodes,a)},indexOfId:function(d){var c=this.childNodes,a=c.length,b=0;for(;b<a;++b){if(c[b].getId()===d){return b}}return -1},getPath:function(d,c){d=d||this.idProperty;c=c||"/";var b=[this.get(d)],a=this.parentNode;while(a){b.unshift(a.get(d));a=a.parentNode}return c+b.join(c)},getDepth:function(){return this.get("depth")},bubble:function(c,b,a){var d=this;while(d){if(c.apply(b||d,a||[d])===false){break}d=d.parentNode}},cascade:function(){if(Ext.isDefined(Ext.global.console)){Ext.global.console.warn("Ext.data.Node: cascade has been deprecated. Please use cascadeBy instead.")}return this.cascadeBy.apply(this,arguments)},cascadeBy:function(d,c,a){if(d.apply(c||this,a||[this])!==false){var f=this.childNodes,e=f.length,b;for(b=0;b<e;b++){f[b].cascadeBy(d,c,a)}}},eachChild:function(d,c,a){var f=this.childNodes,e=f.length,b;for(b=0;b<e;b++){if(d.apply(c||this,a||[f[b]])===false){break}}},findChild:function(b,c,a){return this.findChildBy(function(){return this.get(b)==c},null,a)},findChildBy:function(g,f,b){var e=this.childNodes,a=e.length,d=0,h,c;for(;d<a;d++){h=e[d];if(g.call(f||h,h)===true){return h}else{if(b){c=h.findChildBy(g,f,b);if(c!==null){return c}}}}return null},contains:function(a){return a.isAncestor(this)},isAncestor:function(a){var b=this.parentNode;while(b){if(b==a){return true}b=b.parentNode}return false},sort:function(f,b,a){var d=this.childNodes,e=d.length,c,g;if(e>0){Ext.Array.sort(d,f);for(c=0;c<e;c++){g=d[c];g.previousSibling=d[c-1];g.nextSibling=d[c+1];if(c===0){this.setFirstChild(g)}if(c==e-1){this.setLastChild(g)}g.updateInfo();if(b&&!g.isLeaf()){g.sort(f,true,true)}}if(a!==true){this.fireEvent("sort",this,d)}}},isExpanded:function(){return this.get("expanded")},isLoaded:function(){return this.get("loaded")},isLoading:function(){return this.get("loading")},isRoot:function(){return !this.parentNode},isVisible:function(){var a=this.parentNode;while(a){if(!a.isExpanded()){return false}a=a.parentNode}return true},expand:function(a,d,b){var c=this;if(!c.isLeaf()){if(c.isLoading()){c.on("expand",function(){c.expand(a,d,b)},c,{single:true})}else{if(!c.isExpanded()){c.fireEvent("beforeexpand",c,function(){c.set("expanded",true);if(c.hasListeners.expand){c.fireEvent("expand",c,c.childNodes,false)}if(a){c.expandChildren(true,d,b)}else{Ext.callback(d,b||c,[c.childNodes])}},c)}else{if(a){c.expandChildren(true,d,b)}else{Ext.callback(d,b||c,[c.childNodes])}}}}else{Ext.callback(d,b||c)}},expandChildren:function(d,h,j){var g=this,e=0,a=g.childNodes,f=a.length,c,b=0;for(;e<f;++e){c=a[e];if(!c.isLeaf()){b++;a[e].expand(d,function(){b--;if(h&&!b){Ext.callback(h,j||g,[g.childNodes])}})}}if(!b&&h){Ext.callback(h,j||g,[g.childNodes])}},collapse:function(a,d,b){var c=this;if(!c.isLeaf()){if(!c.collapsing&&c.isExpanded()){c.fireEvent("beforecollapse",c,function(){c.set("expanded",false);if(c.hasListeners.collapse){c.fireEvent("collapse",c,c.childNodes,false)}if(a){c.collapseChildren(true,d,b)}else{Ext.callback(d,b||c,[c.childNodes])}},c)}else{if(a){c.collapseChildren(true,d,b)}else{Ext.callback(d,b||c,[c.childNodes])}}}else{Ext.callback(d,b||c,[c.childNodes])}},collapseChildren:function(d,h,j){var g=this,e=0,b=g.childNodes,f=b.length,c,a=0;for(;e<f;++e){c=b[e];if(!c.isLeaf()){a++;b[e].collapse(d,function(){a--;if(h&&!a){Ext.callback(h,j||g,[g.childNodes])}})}}if(!a&&h){Ext.callback(h,j||g,[g.childNodes])}}}}}});Ext.define("Ext.util.AbstractMixedCollection",{requires:["Ext.util.Filter"],mixins:{observable:"Ext.util.Observable"},isMixedCollection:true,generation:0,constructor:function(b,a){var c=this;c.items=[];c.map={};c.keys=[];c.length=0;c.allowFunctions=b===true;if(a){c.getKey=a}c.mixins.observable.constructor.call(c)},allowFunctions:false,add:function(b,e){var d=this,f=e,c=b,a;if(arguments.length==1){f=c;c=d.getKey(f)}if(typeof c!="undefined"&&c!==null){a=d.map[c];if(typeof a!="undefined"){return d.replace(c,f)}d.map[c]=f}d.generation++;d.length++;d.items.push(f);d.keys.push(c);if(d.hasListeners.add){d.fireEvent("add",d.length-1,f,c)}return f},getKey:function(a){return a.id},replace:function(c,e){var d=this,a,b;if(arguments.length==1){e=arguments[0];c=d.getKey(e)}a=d.map[c];if(typeof c=="undefined"||c===null||typeof a=="undefined"){return d.add(c,e)}d.generation++;b=d.indexOfKey(c);d.items[b]=e;d.map[c]=e;if(d.hasListeners.replace){d.fireEvent("replace",c,a,e)}return e},addAll:function(f){var e=this,d=0,b,a,c;if(arguments.length>1||Ext.isArray(f)){b=arguments.length>1?arguments:f;for(a=b.length;d<a;d++){e.add(b[d])}}else{for(c in f){if(f.hasOwnProperty(c)){if(e.allowFunctions||typeof f[c]!="function"){e.add(c,f[c])}}}}},each:function(e,d){var b=[].concat(this.items),c=0,a=b.length,f;for(;c<a;c++){f=b[c];if(e.call(d||f,f,c,a)===false){break}}},eachKey:function(e,d){var f=this.keys,b=this.items,c=0,a=f.length;for(;c<a;c++){e.call(d||window,f[c],b[c],c,a)}},findBy:function(e,d){var f=this.keys,b=this.items,c=0,a=b.length;for(;c<a;c++){if(e.call(d||window,b[c],f[c])){return b[c]}}return null},find:function(){if(Ext.isDefined(Ext.global.console)){Ext.global.console.warn("Ext.util.MixedCollection: find has been deprecated. Use findBy instead.")}return this.findBy.apply(this,arguments)},insert:function(a,b,e){var d=this,c=b,f=e;if(arguments.length==2){f=c;c=d.getKey(f)}if(d.containsKey(c)){d.suspendEvents();d.removeAtKey(c);d.resumeEvents()}if(a>=d.length){return d.add(c,f)}d.generation++;d.length++;Ext.Array.splice(d.items,a,0,f);if(typeof c!="undefined"&&c!==null){d.map[c]=f}Ext.Array.splice(d.keys,a,0,c);if(d.hasListeners.add){d.fireEvent("add",a,f,c)}return f},remove:function(a){this.generation++;return this.removeAt(this.indexOf(a))},removeAll:function(b){b=[].concat(b);var c,a=b.length;for(c=0;c<a;c++){this.remove(b[c])}return this},removeAt:function(a){var c=this,d,b;if(a<c.length&&a>=0){c.length--;d=c.items[a];Ext.Array.erase(c.items,a,1);b=c.keys[a];if(typeof b!="undefined"){delete c.map[b]}Ext.Array.erase(c.keys,a,1);if(c.hasListeners.remove){c.fireEvent("remove",d,b)}c.generation++;return d}return false},removeAtKey:function(a){return this.removeAt(this.indexOfKey(a))},getCount:function(){return this.length},indexOf:function(a){return Ext.Array.indexOf(this.items,a)},indexOfKey:function(a){return Ext.Array.indexOf(this.keys,a)},get:function(b){var d=this,a=d.map[b],c=a!==undefined?a:(typeof b=="number")?d.items[b]:undefined;return typeof c!="function"||d.allowFunctions?c:null},getAt:function(a){return this.items[a]},getByKey:function(a){return this.map[a]},contains:function(a){return typeof this.map[this.getKey(a)]!="undefined"},containsKey:function(a){return typeof this.map[a]!="undefined"},clear:function(){var a=this;a.length=0;a.items=[];a.keys=[];a.map={};a.generation++;if(a.hasListeners.clear){a.fireEvent("clear")}},first:function(){return this.items[0]},last:function(){return this.items[this.length-1]},sum:function(g,b,h,a){var c=this.extractValues(g,b),f=c.length,e=0,d;h=h||0;a=(a||a===0)?a:f-1;for(d=h;d<=a;d++){e+=c[d]}return e},collect:function(j,e,g){var k=this.extractValues(j,e),a=k.length,b={},c=[],h,f,d;for(d=0;d<a;d++){h=k[d];f=String(h);if((g||!Ext.isEmpty(h))&&!b[f]){b[f]=true;c.push(h)}}return c},extractValues:function(c,a){var b=this.items;if(a){b=Ext.Array.pluck(b,a)}return Ext.Array.pluck(b,c)},getRange:function(f,a){var e=this,c=e.items,b=[],d;if(c.length<1){return b}f=f||0;a=Math.min(typeof a=="undefined"?e.length-1:a,e.length-1);if(f<=a){for(d=f;d<=a;d++){b[b.length]=c[d]}}else{for(d=f;d>=a;d--){b[b.length]=c[d]}}return b},filter:function(d,c,f,a){var b=[],e;if(Ext.isString(d)){b.push(new Ext.util.Filter({property:d,value:c,anyMatch:f,caseSensitive:a}))}else{if(Ext.isArray(d)||d instanceof Ext.util.Filter){b=b.concat(d)}}e=function(g){var m=true,n=b.length,h,l,k,j;for(h=0;h<n;h++){l=b[h];k=l.filterFn;j=l.scope;m=m&&k.call(j,g)}return m};return this.filterBy(e)},filterBy:function(e,d){var h=this,a=new this.self(),g=h.keys,b=h.items,f=b.length,c;a.getKey=h.getKey;for(c=0;c<f;c++){if(e.call(d||h,b[c],g[c])){a.add(g[c],b[c])}}return a},findIndex:function(c,b,e,d,a){if(Ext.isEmpty(b,false)){return -1}b=this.createValueMatcher(b,d,a);return this.findIndexBy(function(f){return f&&b.test(f[c])},null,e)},findIndexBy:function(e,d,h){var g=this,f=g.keys,b=g.items,c=h||0,a=b.length;for(;c<a;c++){if(e.call(d||g,b[c],f[c])){return c}}return -1},createValueMatcher:function(c,e,a,b){if(!c.exec){var d=Ext.String.escapeRegex;c=String(c);if(e===true){c=d(c)}else{c="^"+d(c);if(b===true){c+="$"}}c=new RegExp(c,a?"":"i")}return c},clone:function(){var e=this,f=new this.self(),d=e.keys,b=e.items,c=0,a=b.length;for(;c<a;c++){f.add(d[c],b[c])}f.getKey=e.getKey;return f}});Ext.define("Ext.util.MixedCollection",{extend:"Ext.util.AbstractMixedCollection",mixins:{sortable:"Ext.util.Sortable"},constructor:function(){var a=this;a.callParent(arguments);a.addEvents("sort");a.mixins.sortable.initSortable.call(a)},doSort:function(a){this.sortBy(a)},_sort:function(k,a,j){var h=this,d,e,b=String(a).toUpperCase()=="DESC"?-1:1,g=[],l=h.keys,f=h.items;j=j||function(i,c){return i-c};for(d=0,e=f.length;d<e;d++){g[g.length]={key:l[d],value:f[d],index:d}}Ext.Array.sort(g,function(i,c){var m=j(i[k],c[k])*b;if(m===0){m=(i.index<c.index?-1:1)}return m});for(d=0,e=g.length;d<e;d++){f[d]=g[d].value;l[d]=g[d].key}h.fireEvent("sort",h)},sortBy:function(c){var g=this,b=g.items,f=g.keys,e=b.length,a=[],d;for(d=0;d<e;d++){a[d]={key:f[d],value:b[d],index:d}}Ext.Array.sort(a,function(i,h){var j=c(i.value,h.value);if(j===0){j=(i.index<h.index?-1:1)}return j});for(d=0;d<e;d++){b[d]=a[d].value;f[d]=a[d].key}g.fireEvent("sort",g,b,f)},findInsertionIndex:function(e,d){var f=this,b=f.items,h=0,a=b.length-1,c,g;if(!d){d=f.generateComparator()}while(h<=a){c=(h+a)>>1;g=d(e,b[c]);if(g>=0){h=c+1}else{if(g<0){a=c-1}}}return h},reorder:function(d){var g=this,b=g.items,c=0,f=b.length,a=[],e=[],h;g.suspendEvents();for(h in d){a[d[h]]=b[h]}for(c=0;c<f;c++){if(d[c]==undefined){e.push(b[c])}}for(c=0;c<f;c++){if(a[c]==undefined){a[c]=e.shift()}}g.clear();g.addAll(a);g.resumeEvents();g.fireEvent("sort",g)},sortByKey:function(a,b){this._sort("key",a,b||function(d,c){var f=String(d).toUpperCase(),e=String(c).toUpperCase();return f>e?1:(f<e?-1:0)})}});Ext.define("Ext.menu.Manager",{singleton:true,requires:["Ext.util.MixedCollection","Ext.util.KeyMap"],alternateClassName:"Ext.menu.MenuMgr",uses:["Ext.menu.Menu"],menus:{},groups:{},attached:false,lastShow:new Date(),init:function(){var a=this;a.active=new Ext.util.MixedCollection();Ext.getDoc().addKeyListener(27,function(){if(a.active.length>0){a.hideAll()}},a)},hideAll:function(){var c=this.active,e,b,a,d;if(c&&c.length>0){e=c.clone();b=e.items;d=b.length;for(a=0;a<d;a++){b[a].hide()}return true}return false},onHide:function(a){var b=this,c=b.active;c.remove(a);if(c.length<1){Ext.getDoc().un("mousedown",b.onMouseDown,b);b.attached=false}},onShow:function(a){var e=this,f=e.active,d=f.last(),c=e.attached,b=a.getEl(),g;e.lastShow=new Date();f.add(a);if(!c){Ext.getDoc().on("mousedown",e.onMouseDown,e,{buffer:Ext.isIE?10:undefined});e.attached=true}a.toFront()},onBeforeHide:function(a){if(a.activeChild){a.activeChild.hide()}if(a.autoHideTimer){clearTimeout(a.autoHideTimer);delete a.autoHideTimer}},onBeforeShow:function(a){var c=this.active,b=a.parentMenu;c.remove(a);if(!b&&!a.allowOtherMenus){this.hideAll()}else{if(b&&b.activeChild&&a!=b.activeChild){b.activeChild.hide()}}},onMouseDown:function(d){var b=this,c=b.active,a=b.lastShow;if(Ext.Date.getElapsed(a)>50&&c.length>0&&!d.getTarget("."+Ext.baseCSSPrefix+"menu")){b.hideAll()}},register:function(b){var a=this;if(!a.active){a.init()}if(b.floating){a.menus[b.id]=b;b.on({beforehide:a.onBeforeHide,hide:a.onHide,beforeshow:a.onBeforeShow,show:a.onShow,scope:a})}},get:function(b){var a=this.menus;if(typeof b=="string"){if(!a){return null}return a[b]}else{if(b.isMenu){return b}else{if(Ext.isArray(b)){return new Ext.menu.Menu({items:b})}else{return Ext.ComponentManager.create(b,"menu")}}}},unregister:function(d){var a=this,b=a.menus,c=a.active;delete b[d.id];c.remove(d);d.un({beforehide:a.onBeforeHide,hide:a.onHide,beforeshow:a.onBeforeShow,show:a.onShow,scope:a})},registerCheckable:function(c){var a=this.groups,b=c.group;if(b){if(!a[b]){a[b]=[]}a[b].push(c)}},unregisterCheckable:function(c){var a=this.groups,b=c.group;if(b){Ext.Array.remove(a[b],c)}},onCheckChange:function(d,f){var a=this.groups,c=d.group,b=0,h,e,g;if(c&&f){h=a[c];e=h.length;for(;b<e;b++){g=h[b];if(g!=d){g.setChecked(false)}}}}});Ext.define("Ext.data.Errors",{extend:"Ext.util.MixedCollection",isValid:function(){return this.length===0},getByField:function(e){var d=[],a,c,b;for(b=0;b<this.length;b++){a=this.items[b];if(a.field==e){d.push(a)}}return d}});Ext.define("Ext.data.Model",{alternateClassName:"Ext.data.Record",mixins:{observable:"Ext.util.Observable"},requires:["Ext.ModelManager","Ext.data.IdGenerator","Ext.data.Field","Ext.data.Errors","Ext.data.Operation","Ext.data.validations","Ext.util.MixedCollection"],compareConvertFields:function(a,d){var c=a.convert&&a.type&&a.convert!==a.type.convert,b=d.convert&&d.type&&d.convert!==d.type.convert;if(c&&!b){return 1}if(!c&&b){return -1}return 0},itemNameFn:function(a){return a.name},onClassExtended:function(b,c,a){var d=a.onBeforeCreated;a.onBeforeCreated=function(f,C){var B=this,D=Ext.getClassName(f),q=f.prototype,w=f.prototype.superclass,h=C.validations||[],s=C.fields||[],g,l=C.associations||[],e=function(F,H){var G=0,E,I;if(F){F=Ext.Array.from(F);for(E=F.length;G<E;++G){I=F[G];if(!Ext.isObject(I)){I={model:I}}I.type=H;l.push(I)}}},t=C.idgen,z=new Ext.util.MixedCollection(false,q.itemNameFn),x=new Ext.util.MixedCollection(false,q.itemNameFn),p=w.validations,A=w.fields,k=w.associations,y,v,n,o=[],m=C.idProperty||f.prototype.idProperty,u=function(F,E,i){var G,H;if(z.events.add.firing){H=F;G=E}else{G=i;H=E.originalIndex}G.originalIndex=H;if(G.mapping===m||(G.mapping==null&&G.name===m)){G.defaultValue=undefined}},r=C.proxy||f.prototype.proxy||f.prototype.defaultProxyType,j=function(){z.sortBy(q.compareConvertFields)};f.modelName=D;q.modelName=D;if(p){h=p.concat(h)}C.validations=h;if(A){s=A.items.concat(s)}z.on({add:u,replace:u});for(v=0,n=s.length;v<n;++v){g=s[v];z.add(g.isField?g:new Ext.data.Field(g))}if(!z.get(m)){z.add(new Ext.data.Field(m))}j();z.on({add:j,replace:j});C.fields=z;if(t){C.idgen=Ext.data.IdGenerator.get(t)}e(C.belongsTo,"belongsTo");delete C.belongsTo;e(C.hasMany,"hasMany");delete C.hasMany;e(C.hasOne,"hasOne");delete C.hasOne;if(k){l=k.items.concat(l)}for(v=0,n=l.length;v<n;++v){o.push("association."+l[v].type.toLowerCase())}if(r&&!r.isProxy){o.push("proxy."+(typeof r==="string"?r:r.type))}Ext.require(o,function(){Ext.ModelManager.registerType(D,f);for(v=0,n=l.length;v<n;++v){y=l[v];if(y.isAssociation){y=Ext.applyIf({ownerModel:D,associatedModel:y.model},y.initialConfig)}else{Ext.apply(y,{ownerModel:D,associatedModel:y.model})}if(Ext.ModelManager.getModel(y.model)===undefined){Ext.ModelManager.registerDeferredAssociation(y)}else{x.add(Ext.data.association.Association.create(y))}}C.associations=x;d.call(B,f,C,a);f.setProxy(r);Ext.ModelManager.onModelDefined(f)})}},inheritableStatics:{setProxy:function(a){if(!a.isProxy){if(typeof a=="string"){a={type:a}}a=Ext.createByAlias("proxy."+a.type,a)}a.setModel(this);this.proxy=this.prototype.proxy=a;return a},getProxy:function(){return this.proxy},setFields:function(c,d,b){var h=this,g=h.prototype,f=g.fields,a=c?c.length:0,e=0;if(d){g.idProperty=d}if(b){g.clientIdProperty=b}if(f){f.clear()}else{f=h.prototype.fields=new Ext.util.MixedCollection(false,function(i){return i.name})}for(;e<a;e++){f.add(new Ext.data.Field(c[e]))}if(!f.get(g.idProperty)){f.add(new Ext.data.Field(g.idProperty))}h.fields=f;return f},getFields:function(){return this.prototype.fields.items},load:function(f,c){c=Ext.apply({},c);c=Ext.applyIf(c,{action:"read",id:f});var b=new Ext.data.Operation(c),d=c.scope||this,a=null,e;e=function(g){if(g.wasSuccessful()){a=g.getRecords()[0];Ext.callback(c.success,d,[a,g])}else{Ext.callback(c.failure,d,[a,g])}Ext.callback(c.callback,d,[a,g])};this.proxy.read(b,e,this)}},statics:{PREFIX:"ext-record",AUTO_ID:1,EDIT:"edit",REJECT:"reject",COMMIT:"commit",id:function(a){var b=[this.PREFIX,"-",this.AUTO_ID++].join("");a.phantom=true;a.internalId=b;return b}},idgen:{isGenerator:true,type:"default",generate:function(){return null},getRecId:function(a){return a.modelName+"-"+a.internalId}},editing:false,dirty:false,persistenceProperty:"data",evented:false,isModel:true,phantom:false,idProperty:"id",clientIdProperty:null,defaultProxyType:"ajax",constructor:function(h,d,n,b){h=h||{};var k=this,j,e,l,a,m,f,c,g;k.internalId=(d||d===0)?d:Ext.data.Model.id(k);k.raw=n||h;if(!k.data){k.data={}}k.modified={};if(k.persistanceProperty){k.persistenceProperty=k.persistanceProperty}k[k.persistenceProperty]=b||{};k.mixins.observable.constructor.call(k);if(!b){j=k.fields.items;e=j.length;g=0;c=k[k.persistenceProperty];if(Ext.isArray(h)){for(;g<e;g++){l=j[g];a=l.name;m=h[l.originalIndex];if(m===undefined){m=l.defaultValue}if(l.convert){m=l.convert(m,k)}if(m!==undefined){c[a]=m}}}else{for(;g<e;g++){l=j[g];a=l.name;m=h[a];if(m===undefined){m=l.defaultValue}if(l.convert){m=l.convert(m,k)}if(m!==undefined){c[a]=m}}}}k.stores=[];if(k.getId()){k.phantom=false}else{if(k.phantom){f=k.idgen.generate();if(f!==null){k.setId(f)}}}k.dirty=false;k.modified={};if(typeof k.init=="function"){k.init()}k.id=k.idgen.getRecId(k)},get:function(a){return this[this.persistenceProperty][a]},_singleProp:{},set:function(q,b){var i=this,g=i[i.persistenceProperty],h=i.fields,p=i.modified,n=(typeof q=="string"),o,j,f,m,e,a,c,d,k,l;if(n){l=i._singleProp;l[q]=b}else{l=q}for(a in l){if(l.hasOwnProperty(a)){k=l[a];if(h&&(j=h.get(a))&&j.convert){k=j.convert(k,i)}o=g[a];if(i.isEqual(o,k)){continue}g[a]=k;(e||(e=[])).push(a);if(j&&j.persist){if(p.hasOwnProperty(a)){if(i.isEqual(p[a],k)){delete p[a];i.dirty=false;for(m in p){if(p.hasOwnProperty(m)){i.dirty=true;break}}}}else{i.dirty=true;p[a]=o}}if(a==i.idProperty){f=true;c=o;d=k}}}if(n){delete l[q]}if(f){i.fireEvent("idchanged",i,c,d)}if(!i.editing&&e){i.afterEdit(e)}return e||null},copyFrom:function(f){if(f){var e=this,c=e.fields.items,j=c.length,g,a=0,d=e[e.persistenceProperty],b=f[f.persistenceProperty],h;for(;a<j;a++){g=c[a];h=b[g.name];if(h!==undefined){d[g.name]=h}}if(e.phantom&&!f.phantom){e.setId(f.getId())}}},isEqual:function(d,c){if(Ext.isDate(d)&&Ext.isDate(c)){return Ext.Date.isEqual(d,c)}return d===c},beginEdit:function(){var a=this;if(!a.editing){a.editing=true;a.dirtySave=a.dirty;a.dataSave=Ext.apply({},a[a.persistenceProperty]);a.modifiedSave=Ext.apply({},a.modified)}},cancelEdit:function(){var a=this;if(a.editing){a.editing=false;a.modified=a.modifiedSave;a[a.persistenceProperty]=a.dataSave;a.dirty=a.dirtySave;delete a.modifiedSave;delete a.dataSave;delete a.dirtySave}},endEdit:function(a,c){var b=this,d;if(b.editing){b.editing=false;if(!c){c=b.getModifiedFieldNames()}d=b.dirty||c.length>0;delete b.modifiedSave;delete b.dataSave;delete b.dirtySave;if(d&&a!==true){b.afterEdit(c)}}},getModifiedFieldNames:function(){var d=this,c=d.dataSave,e=d[d.persistenceProperty],a=[],b;for(b in e){if(e.hasOwnProperty(b)){if(!d.isEqual(e[b],c[b])){a.push(b)}}}return a},getChanges:function(){var a=this.modified,b={},c;for(c in a){if(a.hasOwnProperty(c)){b[c]=this.get(c)}}return b},isModified:function(a){return this.modified.hasOwnProperty(a)},setDirty:function(){var c=this,a=c.fields.items,g=a.length,e,b,d;c.dirty=true;for(d=0;d<g;d++){e=a[d];if(e.persist){b=e.name;c.modified[b]=c.get(b)}}},reject:function(a){var c=this,b=c.modified,d;for(d in b){if(b.hasOwnProperty(d)){if(typeof b[d]!="function"){c[c.persistenceProperty][d]=b[d]}}}c.dirty=false;c.editing=false;c.modified={};if(a!==true){c.afterReject()}},commit:function(a){var b=this;b.phantom=b.dirty=b.editing=false;b.modified={};if(a!==true){b.afterCommit()}},copy:function(a){var b=this;return new b.self(b.raw,a,null,Ext.apply({},b[b.persistenceProperty]))},setProxy:function(a){if(!a.isProxy){if(typeof a==="string"){a={type:a}}a=Ext.createByAlias("proxy."+a.type,a)}a.setModel(this.self);this.proxy=a;return a},getProxy:function(){return this.proxy},validate:function(){var j=new Ext.data.Errors(),c=this.validations,e=Ext.data.validations,b,d,h,a,g,f;if(c){b=c.length;for(f=0;f<b;f++){d=c[f];h=d.field||d.name;g=d.type;a=e[g](d,this.get(h));if(!a){j.add({field:h,message:d.message||e[g+"Message"]})}}}return j},isValid:function(){return this.validate().isValid()},save:function(l){l=Ext.apply({},l);var f=this,b=f.phantom?"create":"update",k=l.scope||f,h=f.stores,c=0,e,g,d,a,j;Ext.apply(l,{records:[f],action:b});a=new Ext.data.Operation(l);j=function(i){d=[f,i];if(i.wasSuccessful()){for(e=h.length;c<e;c++){g=h[c];g.fireEvent("write",g,i);g.fireEvent("datachanged",g)}Ext.callback(l.success,k,d)}else{Ext.callback(l.failure,k,d)}Ext.callback(l.callback,k,d)};f.getProxy()[b](a,j,f);return f},destroy:function(k){k=Ext.apply({},k);var e=this,j=k.scope||e,g=e.stores,b=0,d,f,c,a,h;Ext.apply(k,{records:[e],action:"destroy"});a=new Ext.data.Operation(k);h=function(i){c=[e,i];if(i.wasSuccessful()){for(d=g.length;b<d;b++){f=g[b];f.fireEvent("write",f,i);f.fireEvent("datachanged",f)}e.clearListeners();Ext.callback(k.success,j,c)}else{Ext.callback(k.failure,j,c)}Ext.callback(k.callback,j,c)};e.getProxy().destroy(a,h,e);return e},getId:function(){return this.get(this.idProperty)},getObservableId:function(){return this.id},setId:function(a){this.set(this.idProperty,a);this.phantom=!(a||a===0)},join:function(a){Ext.Array.include(this.stores,a);this.store=this.stores[0]},unjoin:function(a){Ext.Array.remove(this.stores,a);this.store=this.stores[0]||null},afterEdit:function(a){this.callStore("afterEdit",a)},afterReject:function(){this.callStore("afterReject")},afterCommit:function(){this.callStore("afterCommit")},callStore:function(f){var d=Ext.Array.clone(arguments),b=this.stores,e=0,a=b.length,c,g;d[0]=this;for(;e<a;++e){c=b[e];if(c&&typeof c[f]=="function"){c[f].apply(c,d)}g=c.treeStore;if(g&&typeof g[f]=="function"){g[f].apply(g,d)}}},getData:function(c){var d=this,a=d.fields.items,h=a.length,g={},b,e;for(e=0;e<h;e++){b=a[e].name;g[b]=d.get(b)}if(c===true){Ext.apply(g,d.getAssociatedData())}return g},getAssociatedData:function(){return this.prepareAssociatedData({},1)},prepareAssociatedData:function(v,y){var x=this,s=x.associations.items,e=s.length,w={},p=[],u=[],l=[],n,b,a,m,f,k,h,t,g,c,r,q,d,z;for(r=0;r<e;r++){c=s[r];t=c.associationId;h=v[t];if(h&&h!==y){continue}v[t]=y;d=c.type;z=c.name;if(d=="hasMany"){n=x[c.storeName];w[z]=[];if(n&&n.getCount()>0){b=n.data.items;g=b.length;for(q=0;q<g;q++){a=b[q];w[z][q]=a.getData();p.push(a);u.push(z);l.push(q)}}}else{if(d=="belongsTo"||d=="hasOne"){a=x[c.instanceName];if(a!==undefined){w[z]=a.getData();p.push(a);u.push(z);l.push(-1)}}}}for(r=0,g=p.length;r<g;++r){a=p[r];m=w[u[r]];f=l[r];k=a.prepareAssociatedData(v,y+1);if(f===-1){Ext.apply(m,k)}else{Ext.apply(m[f],k)}}return w}});Ext.define("Ext.data.StoreManager",{extend:"Ext.util.MixedCollection",alternateClassName:["Ext.StoreMgr","Ext.data.StoreMgr","Ext.StoreManager"],singleton:true,uses:["Ext.data.ArrayStore"],register:function(){for(var a=0,b;(b=arguments[a]);a++){this.add(b)}},unregister:function(){for(var a=0,b;(b=arguments[a]);a++){this.remove(this.lookup(b))}},lookup:function(c){if(Ext.isArray(c)){var b=["field1"],e=!Ext.isArray(c[0]),f=c,d,a;if(e){f=[];for(d=0,a=c.length;d<a;++d){f.push([c[d]])}}else{for(d=2,a=c[0].length;d<=a;++d){b.push("field"+d)}}return new Ext.data.ArrayStore({data:f,fields:b,autoDestroy:true,autoCreated:true,expanded:e})}if(Ext.isString(c)){return this.get(c)}else{return Ext.data.AbstractStore.create(c)}},getKey:function(a){return a.storeId}},function(){Ext.regStore=function(c,b){var a;if(Ext.isObject(c)){b=c}else{b.storeId=c}if(b instanceof Ext.data.Store){a=b}else{a=new Ext.data.Store(b)}return Ext.data.StoreManager.register(a)};Ext.getStore=function(a){return Ext.data.StoreManager.lookup(a)}});Ext.define("Ext.draw.CompositeSprite",{extend:"Ext.util.MixedCollection",mixins:{animate:"Ext.util.Animate"},autoDestroy:false,isCompositeSprite:true,constructor:function(a){var b=this;a=a||{};Ext.apply(b,a);b.addEvents("mousedown","mouseup","mouseover","mouseout","click");b.id=Ext.id(null,"ext-sprite-group-");b.callParent()},onClick:function(a){this.fireEvent("click",a)},onMouseUp:function(a){this.fireEvent("mouseup",a)},onMouseDown:function(a){this.fireEvent("mousedown",a)},onMouseOver:function(a){this.fireEvent("mouseover",a)},onMouseOut:function(a){this.fireEvent("mouseout",a)},attachEvents:function(b){var a=this;b.on({scope:a,mousedown:a.onMouseDown,mouseup:a.onMouseUp,mouseover:a.onMouseOver,mouseout:a.onMouseOut,click:a.onClick})},add:function(b,c){var a=this.callParent(arguments);this.attachEvents(a);return a},insert:function(a,b,c){return this.callParent(arguments)},remove:function(b){var a=this;b.un({scope:a,mousedown:a.onMouseDown,mouseup:a.onMouseUp,mouseover:a.onMouseOver,mouseout:a.onMouseOut,click:a.onClick});return a.callParent(arguments)},getBBox:function(){var e=0,m,h,j=this.items,f=this.length,g=Infinity,c=g,l=-g,b=g,k=-g,d,a;for(;e<f;e++){m=j[e];if(m.el&&!m.bboxExcluded){h=m.getBBox();c=Math.min(c,h.x);b=Math.min(b,h.y);l=Math.max(l,h.height+h.y);k=Math.max(k,h.width+h.x)}}return{x:c,y:b,height:l-b,width:k-c}},setAttributes:function(c,e){var d=0,b=this.items,a=this.length;for(;d<a;d++){b[d].setAttributes(c,e)}return this},hide:function(d){var c=0,b=this.items,a=this.length;for(;c<a;c++){b[c].hide(d)}return this},show:function(d){var c=0,b=this.items,a=this.length;for(;c<a;c++){b[c].show(d)}return this},redraw:function(){var e=this,d=0,c=e.items,b=e.getSurface(),a=e.length;if(b){for(;d<a;d++){b.renderItem(c[d])}}return e},setStyle:function(f){var c=0,b=this.items,a=this.length,e,d;for(;c<a;c++){e=b[c];d=e.el;if(d){d.setStyle(f)}}},addCls:function(e){var d=0,c=this.items,b=this.getSurface(),a=this.length;if(b){for(;d<a;d++){b.addCls(c[d],e)}}},removeCls:function(e){var d=0,c=this.items,b=this.getSurface(),a=this.length;if(b){for(;d<a;d++){b.removeCls(c[d],e)}}},getSurface:function(){var a=this.first();if(a){return a.surface}return null},destroy:function(){var d=this,a=d.getSurface(),c=d.autoDestroy,b;if(a){while(d.getCount()>0){b=d.first();d.remove(b);a.remove(b,c)}}d.clearListeners()}});Ext.define("Ext.chart.LegendItem",{extend:"Ext.draw.CompositeSprite",requires:["Ext.chart.Shape"],x:0,y:0,zIndex:500,boldRe:/bold\s\d{1,}.*/i,constructor:function(a){this.callParent(arguments);this.createLegend(a)},createLegend:function(r){var s=this,h=r.yFieldIndex,k=s.series,a=k.type,l=s.yFieldIndex,d=s.legend,o=s.surface,p=d.x+s.x,m=d.y+s.y,c,j=s.zIndex,b,i,q,e,n=false,g=Ext.apply(k.seriesStyle,k.style);function f(t){var u=k[t];return(Ext.isArray(u)?u[l]:u)}i=s.add("label",o.add({type:"text",x:20,y:0,zIndex:(j||0)+2,fill:d.labelColor,font:d.labelFont,text:f("title")||f("yField"),style:{cursor:"pointer"}}));if(a==="line"||a==="scatter"){if(a==="line"){s.add("line",o.add({type:"path",path:"M0.5,0.5L16.5,0.5",zIndex:(j||0)+2,"stroke-width":k.lineWidth,"stroke-linejoin":"round","stroke-dasharray":k.dash,stroke:g.stroke||k.getLegendColor(h)||"#000",style:{cursor:"pointer"}}))}if(k.showMarkers||a==="scatter"){b=Ext.apply(k.markerStyle,k.markerConfig||{},{fill:k.getLegendColor(h)});s.add("marker",Ext.chart.Shape[b.type](o,{fill:b.fill,x:8.5,y:0.5,zIndex:(j||0)+2,radius:b.radius||b.size,style:{cursor:"pointer"}}))}}else{s.add("box",o.add({type:"rect",zIndex:(j||0)+2,x:0,y:0,width:12,height:12,fill:k.getLegendColor(h),style:{cursor:"pointer"}}))}s.setAttributes({hidden:false},true);c=s.getBBox();q=s.add("mask",o.add({type:"rect",x:c.x,y:c.y,width:c.width||20,height:c.height||20,zIndex:(j||0)+1,fill:s.legend.boxFill,style:{cursor:"pointer"}}));s.on("mouseover",function(){i.setStyle({"font-weight":"bold"});q.setStyle({cursor:"pointer"});k._index=h;k.highlightItem()},s);s.on("mouseout",function(){i.setStyle({"font-weight":d.labelFont&&s.boldRe.test(d.labelFont)?"bold":"normal"});k._index=h;k.unHighlightItem()},s);if(!k.visibleInLegend(h)){n=true;i.setAttributes({opacity:0.5},true)}s.on("mousedown",function(){if(!n){k.hideAll(h);i.setAttributes({opacity:0.5},true)}else{k.showAll(h);i.setAttributes({opacity:1},true)}n=!n;s.legend.chart.redraw()},s);s.updatePosition({x:0,y:0})},updatePosition:function(c){var f=this,a=f.items,e=a.length,b=0,d;if(!c){c=f.legend}for(;b<e;b++){d=a[b];switch(d.type){case"text":d.setAttributes({x:20+c.x+f.x,y:c.y+f.y},true);break;case"rect":d.setAttributes({translate:{x:c.x+f.x,y:c.y+f.y-6}},true);break;default:d.setAttributes({translate:{x:c.x+f.x,y:c.y+f.y}},true)}}}});Ext.define("Ext.chart.Legend",{requires:["Ext.chart.LegendItem"],visible:true,update:true,position:"bottom",x:0,y:0,labelColor:"#000",labelFont:"12px Helvetica, sans-serif",boxStroke:"#000",boxStrokeWidth:1,boxFill:"#FFF",itemSpacing:10,padding:5,width:0,height:0,boxZIndex:100,constructor:function(a){var b=this;if(a){Ext.apply(b,a)}b.items=[];b.isVertical=("left|right|float".indexOf(b.position)!==-1);b.origX=b.x;b.origY=b.y},create:function(){var e=this,a=e.chart.series.items,c,d,b;e.createBox();if(e.rebuild!==false){e.createItems()}if(!e.created&&e.isDisplayed()){e.created=true;for(c=0,d=a.length;c<d;c++){b=a[c];b.on("titlechange",function(){e.create();e.updatePosition()})}}},isDisplayed:function(){return this.visible&&this.chart.series.findIndex("showInLegend",true)!==-1},createItems:function(){var G=this,r=G.chart,b=r.series.items,n,p,z=r.surface,t=G.items,q=G.padding,J=G.itemSpacing,l=2,D=0,w=0,g=0,F=0,d=G.isVertical,f=Math,e=f.floor,I=f.max,k=0,B=0,C=t?t.length:0,o,m,h,E,a,s,v,u,c,H,A;if(C){for(;B<C;B++){t[B].destroy()}}t.length=[];for(B=0,n=b.length;B<n;B++){p=b[B];if(p.showInLegend){u=[].concat(p.yField);for(A=0,H=u.length;A<H;A++){c=u[A];E=new Ext.chart.LegendItem({legend:this,series:p,surface:r.surface,yFieldIndex:A});a=E.getBBox();v=a.width;s=a.height;if(B+A===0){h=d?q+s/2:q}else{h=J/(d?2:1)}E.x=e(d?q:g+h);E.y=e(d?F+h:q+s/2);g+=v+h;F+=s+h;D=I(D,v);w=I(w,s);t.push(E)}}}G.width=e((d?D:g)+q*2);if(d&&t.length===1){l=1}G.height=e((d?F-l*h:w)+(q*2));G.itemHeight=w},getBBox:function(){var a=this;return{x:Math.round(a.x)-a.boxStrokeWidth/2,y:Math.round(a.y)-a.boxStrokeWidth/2,width:a.width,height:a.height}},createBox:function(){var b=this,a,c;if(b.boxSprite){b.boxSprite.destroy()}c=b.getBBox();if(isNaN(c.width)||isNaN(c.height)){b.boxSprite=false;return}a=b.boxSprite=b.chart.surface.add(Ext.apply({type:"rect",stroke:b.boxStroke,"stroke-width":b.boxStrokeWidth,fill:b.boxFill,zIndex:b.boxZIndex},c));a.redraw()},updatePosition:function(){var t=this,o=t.items,q,h,k,g,m=t.width||0,c=t.height||0,l=t.padding,n=t.chart,j=n.chartBBox,r=n.insetPadding,s=j.width-(r*2),d=j.height-(r*2),f=j.x+r,e=j.y+r,p=n.surface,b=Math.floor,a;if(t.isDisplayed()){switch(t.position){case"left":k=r;g=b(e+d/2-c/2);break;case"right":k=b(p.width-m)-r;g=b(e+d/2-c/2);break;case"top":k=b(f+s/2-m/2);g=r;break;case"bottom":k=b(f+s/2-m/2);g=b(p.height-c)-r;break;default:k=b(t.origX)+r;g=b(t.origY)+r}t.x=k;t.y=g;for(q=0,h=o.length;q<h;q++){o[q].updatePosition()}a=t.getBBox();if(isNaN(a.width)||isNaN(a.height)){if(t.boxSprite){t.boxSprite.hide(true)}}else{if(!t.boxSprite){t.createBox()}t.boxSprite.setAttributes(a,true);t.boxSprite.show(true)}}},toggle:function(b){var e=this,d=0,c=e.items,a=c.length;if(e.boxSprite){if(b){e.boxSprite.show(true)}else{e.boxSprite.hide(true)}}for(;d<a;++d){if(b){c[d].show(true)}else{c[d].hide(true)}}e.visible=b}});Ext.define("Ext.data.AbstractStore",{requires:["Ext.util.MixedCollection","Ext.data.proxy.Proxy","Ext.data.Operation","Ext.util.Filter"],mixins:{observable:"Ext.util.Observable",sortable:"Ext.util.Sortable"},statics:{create:function(a){if(!a.isStore){if(!a.type){a.type="store"}a=Ext.createByAlias("store."+a.type,a)}return a}},remoteSort:false,remoteFilter:false,autoLoad:undefined,autoSync:false,batchUpdateMode:"operation",filterOnLoad:true,sortOnLoad:true,implicitModel:false,defaultProxyType:"memory",isDestroyed:false,isStore:true,sortRoot:"data",constructor:function(a){var c=this,b;Ext.apply(c,a);c.removed=[];c.mixins.observable.constructor.apply(c,arguments);c.model=Ext.ModelManager.getModel(c.model);Ext.applyIf(c,{modelDefaults:{}});if(!c.model&&c.fields){c.model=Ext.define("Ext.data.Store.ImplicitModel-"+(c.storeId||Ext.id()),{extend:"Ext.data.Model",fields:c.fields,proxy:c.proxy||c.defaultProxyType});delete c.fields;c.implicitModel=true}c.setProxy(c.proxy||c.model.getProxy());c.proxy.on("metachange",c.onMetaChange,c);if(c.id&&!c.storeId){c.storeId=c.id;delete c.id}if(c.storeId){Ext.data.StoreManager.register(c)}c.mixins.sortable.initSortable.call(c);b=c.decodeFilters(c.filters);c.filters=new Ext.util.MixedCollection();c.filters.addAll(b)},setProxy:function(a){var b=this;if(a instanceof Ext.data.proxy.Proxy){a.setModel(b.model)}else{if(Ext.isString(a)){a={type:a}}Ext.applyIf(a,{model:b.model});a=Ext.createByAlias("proxy."+a.type,a)}b.proxy=a;return b.proxy},getProxy:function(){return this.proxy},onMetaChange:function(a,b){this.fireEvent("metachange",this,b)},create:function(e,c){var d=this,a=Ext.ModelManager.create(Ext.applyIf(e,d.modelDefaults),d.model.modelName),b;c=c||{};Ext.applyIf(c,{action:"create",records:[a]});b=new Ext.data.Operation(c);d.proxy.create(b,d.onProxyWrite,d);return a},read:function(){return this.load.apply(this,arguments)},update:function(b){var c=this,a;b=b||{};Ext.applyIf(b,{action:"update",records:c.getUpdatedRecords()});a=new Ext.data.Operation(b);return c.proxy.update(a,c.onProxyWrite,c)},onProxyWrite:function(b){var c=this,d=b.wasSuccessful(),a=b.getRecords();switch(b.action){case"create":c.onCreateRecords(a,b,d);break;case"update":c.onUpdateRecords(a,b,d);break;case"destroy":c.onDestroyRecords(a,b,d);break}if(d){c.fireEvent("write",c,b);c.fireEvent("datachanged",c);c.fireEvent("refresh",c)}Ext.callback(b.callback,b.scope||c,[a,b,d])},onCreateRecords:Ext.emptyFn,onUpdateRecords:Ext.emptyFn,onDestroyRecords:function(b,a,c){if(c){this.removed=[]}},destroy:function(b){var c=this,a;b=b||{};Ext.applyIf(b,{action:"destroy",records:c.getRemovedRecords()});a=new Ext.data.Operation(b);return c.proxy.destroy(a,c.onProxyWrite,c)},onBatchOperationComplete:function(b,a){return this.onProxyWrite(a)},onBatchComplete:function(c,a){var f=this,b=c.operations,e=b.length,d;f.suspendEvents();for(d=0;d<e;d++){f.onProxyWrite(b[d])}f.resumeEvents();f.fireEvent("datachanged",f);f.fireEvent("refresh",f)},onBatchException:function(b,a){},filterNew:function(a){return a.phantom===true&&a.isValid()},getNewRecords:function(){return[]},getUpdatedRecords:function(){return[]},getModifiedRecords:function(){return[].concat(this.getNewRecords(),this.getUpdatedRecords())},filterUpdated:function(a){return a.dirty===true&&a.phantom!==true&&a.isValid()},getRemovedRecords:function(){return this.removed},filter:function(a,b){},decodeFilters:function(e){if(!Ext.isArray(e)){if(e===undefined){e=[]}else{e=[e]}}var d=e.length,a=Ext.util.Filter,b,c;for(c=0;c<d;c++){b=e[c];if(!(b instanceof a)){Ext.apply(b,{root:"data"});if(b.fn){b.filterFn=b.fn}if(typeof b=="function"){b={filterFn:b}}e[c]=new a(b)}}return e},clearFilter:function(a){},isFiltered:function(){},filterBy:function(b,a){},sync:function(c){var e=this,b={},f=e.getNewRecords(),d=e.getUpdatedRecords(),a=e.getRemovedRecords(),g=false;if(f.length>0){b.create=f;g=true}if(d.length>0){b.update=d;g=true}if(a.length>0){b.destroy=a;g=true}if(g&&e.fireEvent("beforesync",b)!==false){c=c||{};e.proxy.batch(Ext.apply(c,{operations:b,listeners:e.getBatchListeners()}))}return e},getBatchListeners:function(){var b=this,a={scope:b,exception:b.onBatchException};if(b.batchUpdateMode=="operation"){a.operationcomplete=b.onBatchOperationComplete}else{a.complete=b.onBatchComplete}return a},save:function(){return this.sync.apply(this,arguments)},load:function(b){var c=this,a;b=Ext.apply({action:"read",filters:c.filters.items,sorters:c.getSorters()},b);c.lastOptions=b;a=new Ext.data.Operation(b);if(c.fireEvent("beforeload",c,a)!==false){c.loading=true;c.proxy.read(a,c.onProxyLoad,c)}return c},reload:function(a){return this.load(Ext.apply(this.lastOptions,a))},afterEdit:function(a,e){var d=this,b,c;if(d.autoSync&&!d.autoSyncSuspended){for(b=e.length;b--;){if(a.fields.get(e[b]).persist){c=true;break}}if(c){d.sync()}}d.fireEvent("update",d,a,Ext.data.Model.EDIT,e)},afterReject:function(a){this.fireEvent("update",this,a,Ext.data.Model.REJECT,null)},afterCommit:function(a){this.fireEvent("update",this,a,Ext.data.Model.COMMIT,null)},destroyStore:function(){var a=this;if(!a.isDestroyed){if(a.storeId){Ext.data.StoreManager.unregister(a)}a.clearData();a.data=a.tree=a.sorters=a.filters=a.groupers=null;if(a.reader){a.reader.destroyReader()}a.proxy=a.reader=a.writer=null;a.clearListeners();a.isDestroyed=true;if(a.implicitModel){Ext.destroy(a.model)}else{a.model=null}}},doSort:function(a){var b=this;if(b.remoteSort){b.load()}else{b.data.sortBy(a);b.fireEvent("datachanged",b);b.fireEvent("refresh",b)}},clearData:Ext.emptyFn,getCount:Ext.emptyFn,getById:Ext.emptyFn,removeAll:Ext.emptyFn,isLoading:function(){return !!this.loading},suspendAutoSync:function(){this.autoSyncSuspended=true},resumeAutoSync:function(){this.autoSyncSuspended=false}});Ext.define("Ext.data.TreeStore",{extend:"Ext.data.AbstractStore",alias:"store.tree",requires:["Ext.util.Sorter","Ext.data.Tree","Ext.data.NodeInterface"],clearOnLoad:true,clearRemovedOnLoad:true,nodeParam:"node",defaultRootId:"root",defaultRootProperty:"children",rootProperty:"children",folderSort:false,constructor:function(c){var e=this,b,a,d;c=Ext.apply({},c);a=c.fields||e.fields;if(!a){c.fields=[{name:"text",type:"string"}];d=c.defaultRootProperty||e.defaultRootProperty;if(d!==e.defaultRootProperty){c.fields.push({name:d,type:"auto",defaultValue:null,persist:false})}}e.callParent([c]);e.tree=new Ext.data.Tree();e.relayEvents(e.tree,["append","remove","move","insert","beforeappend","beforeremove","beforemove","beforeinsert","expand","collapse","beforeexpand","beforecollapse","sort","rootchange"]);e.tree.on({scope:e,remove:e.onNodeRemove,beforeexpand:e.onBeforeNodeExpand,beforecollapse:e.onBeforeNodeCollapse,append:e.onNodeAdded,insert:e.onNodeAdded,sort:e.onNodeSort});e.onBeforeSort();b=e.root;if(b){delete e.root;e.setRootNode(b)}if(Ext.isDefined(e.nodeParameter)){if(Ext.isDefined(Ext.global.console)){Ext.global.console.warn("Ext.data.TreeStore: nodeParameter has been deprecated. Please use nodeParam instead.")}e.nodeParam=e.nodeParameter;delete e.nodeParameter}},setProxy:function(c){var a,b;if(c instanceof Ext.data.proxy.Proxy){b=Ext.isEmpty(c.getReader().root)}else{if(Ext.isString(c)){b=true}else{a=c.reader;b=!(a&&!Ext.isEmpty(a.root))}}c=this.callParent(arguments);if(b){a=c.getReader();a.root=this.defaultRootProperty;a.buildExtractors(true)}},onBeforeSort:function(){if(this.folderSort){this.sort({property:"leaf",direction:"ASC"},"prepend",false)}},onBeforeNodeExpand:function(b,c,a){if(b.isLoaded()){Ext.callback(c,a||b,[b.childNodes])}else{if(b.isLoading()){this.on("load",function(){Ext.callback(c,a||b,[b.childNodes])},this,{single:true})}else{this.read({node:b,callback:function(){Ext.callback(c,a||b,[b.childNodes])}})}}},getNewRecords:function(){return Ext.Array.filter(this.tree.flatten(),this.filterNew)},getUpdatedRecords:function(){return Ext.Array.filter(this.tree.flatten(),this.filterUpdated)},onBeforeNodeCollapse:function(b,c,a){c.call(a||b,b.childNodes)},onNodeRemove:function(b,d,a){var c=this,e=c.removed;if(!d.isReplace&&Ext.Array.indexOf(e,d)==-1){e.push(d)}if(c.autoSync&&!c.autoSyncSuspended&&!a){c.sync()}},onNodeAdded:function(c,e){var d=this,b=d.getProxy(),a=b.getReader(),f=e.raw||e[e.persistenceProperty],g;Ext.Array.remove(d.removed,e);if(!e.isLeaf()){g=a.getRoot(f);if(g){d.fillNode(e,a.extractData(g));delete f[a.root]}}if(d.autoSync&&!d.autoSyncSuspended&&(e.phantom||e.dirty)){d.sync()}},onNodeSort:function(){if(this.autoSync&&!this.autoSyncSuspended){this.sync()}},setRootNode:function(a,e){var d=this,c=d.model,b=c.prototype.idProperty;a=a||{};if(!a.isModel){Ext.applyIf(a,{id:d.defaultRootId,text:"Root",allowDrag:false});if(a[b]===undefined){a[b]=d.defaultRootId}Ext.data.NodeInterface.decorate(c);a=Ext.ModelManager.create(a,c)}else{if(a.isModel&&!a.isNode){Ext.data.NodeInterface.decorate(c)}}d.getProxy().getReader().buildExtractors(true);d.tree.setRootNode(a);if(e!==true&&!a.isLoaded()&&(d.autoLoad===true||a.isExpanded())){d.load({node:a})}return a},getRootNode:function(){return this.tree.getRootNode()},getNodeById:function(a){return this.tree.getNodeById(a)},getById:function(a){return this.getNodeById(a)},load:function(a){a=a||{};a.params=a.params||{};var c=this,b=a.node||c.tree.getRootNode();if(!b){b=c.setRootNode({expanded:true},true)}a.id=b.getId();if(c.clearOnLoad){if(c.clearRemovedOnLoad){c.clearRemoved(b)}c.tree.un("remove",c.onNodeRemove,c);b.removeAll(false);c.tree.on("remove",c.onNodeRemove,c)}Ext.applyIf(a,{node:b});a.params[c.nodeParam]=b?b.getId():"root";if(b){b.set("loading",true)}return c.callParent([a])},clearRemoved:function(b){var j=this,e=j.removed,a=b.getId(),d=e.length,c=d,m={},g=[],l={},h,f,k;if(b===j.getRootNode()){j.removed=[];return}for(;c--;){h=e[c];l[h.getId()]=h}for(c=d;c--;){h=e[c];f=h;while(f&&f.getId()!==a){k=f.get("parentId");f=f.parentNode||j.getNodeById(k)||l[k]}if(f){m[h.getId()]=h}}for(c=0;c<d;c++){h=e[c];if(!m[h.getId()]){g.push(h)}}j.removed=g},fillNode:function(b,c){var g=this,e=c?c.length:0,f=g.sorters,d,j,h=false,a=e&&g.sortOnLoad&&!g.remoteSort&&f&&f.items&&f.items.length,l,k;for(d=1;d<e;d++){l=c[d];k=c[d-1];h=l[l.persistenceProperty].index!=k[k.persistenceProperty].index;if(h){break}}if(a){if(h){g.sorters.insert(0,g.indexSorter)}j=new Ext.util.MixedCollection();j.addAll(c);j.sort(g.sorters.items);c=j.items;g.sorters.remove(g.indexSorter)}else{if(h){Ext.Array.sort(c,g.sortByIndex)}}b.set("loaded",true);for(d=0;d<e;d++){b.appendChild(c[d],undefined,true)}return c},sortByIndex:function(b,a){return b[b.persistenceProperty].index-a[a.persistenceProperty].index},onProxyLoad:function(b){var d=this,e=b.wasSuccessful(),a=b.getRecords(),c=b.node;d.loading=false;c.set("loading",false);if(e){if(!d.clearOnLoad){a=d.cleanRecords(c,a)}a=d.fillNode(c,a)}d.fireEvent("read",d,b.node,a,e);d.fireEvent("load",d,b.node,a,e);Ext.callback(b.callback,b.scope||d,[a,b,e])},onCreateRecords:function(c){this.callParent(arguments);var d=0,b=c.length,a=this.tree,e;for(;d<b;++d){e=c[d];a.onNodeIdChanged(e,null,e.getId())}},cleanRecords:function(f,b){var e={},h=f.childNodes,d=0,a=h.length,c=[],g;for(;d<a;++d){e[h[d].getId()]=true}for(d=0,a=b.length;d<a;++d){g=b[d];if(!e[g.getId()]){c.push(g)}}return c},removeAll:function(){var a=this.getRootNode();if(a){a.destroy(true)}this.fireEvent("clear",this)},doSort:function(a){var b=this;if(b.remoteSort){b.load()}else{b.tree.sort(a,true);b.fireEvent("datachanged",b);b.fireEvent("refresh",b)}b.fireEvent("sort",b)}},function(){var a=this.prototype;a.indexSorter=new Ext.util.Sorter({sorterFn:a.sortByIndex})});Ext.define("Ext.draw.Surface",{mixins:{observable:"Ext.util.Observable"},requires:["Ext.draw.CompositeSprite"],uses:["Ext.draw.engine.Svg","Ext.draw.engine.Vml","Ext.draw.engine.SvgExporter","Ext.draw.engine.ImageExporter"],separatorRe:/[, ]+/,statics:{create:function(b,d){d=d||["Svg","Vml"];var c=0,a=d.length,e;for(;c<a;c++){if(Ext.supports[d[c]]!==false){return Ext.create("Ext.draw.engine."+d[c],b)}}return false},save:function(a,b){b=b||{};var e={"image/png":"Image","image/jpeg":"Image","image/svg+xml":"Svg"},d=e[b.type]||"Svg",c=Ext.draw.engine[d+"Exporter"];return c.generate(a,b)}},availableAttrs:{blur:0,"clip-rect":"0 0 1e9 1e9",cursor:"default",cx:0,cy:0,"dominant-baseline":"auto",fill:"none","fill-opacity":1,font:'10px "Arial"',"font-family":'"Arial"',"font-size":"10","font-style":"normal","font-weight":400,gradient:"",height:0,hidden:false,href:"http://sencha.com/",opacity:1,path:"M0,0",radius:0,rx:0,ry:0,scale:"1 1",src:"",stroke:"none","stroke-dasharray":"","stroke-linecap":"butt","stroke-linejoin":"butt","stroke-miterlimit":0,"stroke-opacity":1,"stroke-width":1,target:"_blank",text:"","text-anchor":"middle",title:"Ext Draw",width:0,x:0,y:0,zIndex:0},container:undefined,height:352,width:512,x:0,y:0,orderSpritesByZIndex:true,constructor:function(a){var b=this;a=a||{};Ext.apply(b,a);b.domRef=Ext.getDoc().dom;b.customAttributes={};b.addEvents("mousedown","mouseup","mouseover","mouseout","mousemove","mouseenter","mouseleave","click","dblclick");b.mixins.observable.constructor.call(b);b.getId();b.initGradients();b.initItems();if(b.renderTo){b.render(b.renderTo);delete b.renderTo}b.initBackground(a.background)},initSurface:Ext.emptyFn,renderItem:Ext.emptyFn,renderItems:Ext.emptyFn,setViewBox:function(b,d,c,a){if(isFinite(b)&&isFinite(d)&&isFinite(c)&&isFinite(a)){this.viewBox={x:b,y:d,width:c,height:a};this.applyViewBox()}},addCls:Ext.emptyFn,removeCls:Ext.emptyFn,setStyle:Ext.emptyFn,initGradients:function(){if(this.hasOwnProperty("gradients")){var a=this.gradients,d=a.length,b=this.addGradient,c;if(a){for(c=0;c<d;c++){if(b.call(this,a[c],c,d)===false){break}}}}},initItems:function(){var a=this.items;this.items=new Ext.draw.CompositeSprite();this.items.autoDestroy=true;this.groups=new Ext.draw.CompositeSprite();if(a){this.add(a)}},initBackground:function(b){var e=this,d=e.width,a=e.height,f,g,c;if(Ext.isString(b)){b={fill:b}}if(b){if(b.gradient){g=b.gradient;f=g.id;e.addGradient(g);e.background=e.add({type:"rect",x:0,y:0,width:d,height:a,fill:"url(#"+f+")",zIndex:-1})}else{if(b.fill){e.background=e.add({type:"rect",x:0,y:0,width:d,height:a,fill:b.fill,zIndex:-1})}else{if(b.image){e.background=e.add({type:"image",x:0,y:0,width:d,height:a,src:b.image,zIndex:-1})}}}e.background.bboxExcluded=true}},setSize:function(a,b){this.applyViewBox()},scrubAttrs:function(d){var c,b={},a={},e=d.attr;for(c in e){if(this.translateAttrs.hasOwnProperty(c)){b[this.translateAttrs[c]]=e[c];a[this.translateAttrs[c]]=true}else{if(this.availableAttrs.hasOwnProperty(c)&&!a[c]){b[c]=e[c]}}}return b},onClick:function(a){this.processEvent("click",a)},onDblClick:function(a){this.processEvent("dblclick",a)},onMouseUp:function(a){this.processEvent("mouseup",a)},onMouseDown:function(a){this.processEvent("mousedown",a)},onMouseOver:function(a){this.processEvent("mouseover",a)},onMouseOut:function(a){this.processEvent("mouseout",a)},onMouseMove:function(a){this.fireEvent("mousemove",a)},onMouseEnter:Ext.emptyFn,onMouseLeave:Ext.emptyFn,addGradient:Ext.emptyFn,add:function(){var f=Array.prototype.slice.call(arguments),h,d,a=f.length>1,g,b,c,e,j;if(a||Ext.isArray(f[0])){g=a?f:f[0];b=[];for(c=0,e=g.length;c<e;c++){j=g[c];j=this.add(j);b.push(j)}return b}h=this.prepareItems(f[0],true)[0];this.insertByZIndex(h);this.onAdd(h);return h},insertByZIndex:function(i){var f=this,d=f.items.items,c=d.length,j=Math.ceil,g=i.attr.zIndex,h=c,b=h-1,e=0,a;if(f.orderSpritesByZIndex&&c&&g<d[b].attr.zIndex){while(e<=b){h=j((e+b)/2);a=d[h].attr.zIndex;if(a>g){b=h-1}else{if(a<g){e=h+1}else{break}}}while(h<c&&d[h].attr.zIndex<=g){h++}}f.items.insert(h,i);return h},onAdd:function(d){var f=d.group,b=d.draggable,a,e,c;if(f){a=[].concat(f);e=a.length;for(c=0;c<e;c++){f=a[c];this.getGroup(f).add(d)}delete d.group}if(b){d.initDraggable()}},remove:function(b,e){if(b){this.items.remove(b);var a=[].concat(this.groups.items),d=a.length,c;for(c=0;c<d;c++){a[c].remove(b)}b.onRemove();if(e===true){b.destroy()}}},removeAll:function(d){var a=this.items.items,c=a.length,b;for(b=c-1;b>-1;b--){this.remove(a[b],d)}},onRemove:Ext.emptyFn,onDestroy:Ext.emptyFn,applyViewBox:function(){var d=this,k=d.viewBox,a=d.width||1,g=d.height||1,f,e,i,b,h,c,j;if(k&&(a||g)){f=k.x;e=k.y;i=k.width;b=k.height;h=g/b;c=a/i;j=Math.min(c,h);if(i*j<a){f-=(a-i*j)/2/j}if(b*j<g){e-=(g-b*j)/2/j}d.viewBoxShift={dx:-f,dy:-e,scale:j};if(d.background){d.background.setAttributes(Ext.apply({},{x:f,y:e,width:a/j,height:g/j},{hidden:false}),true)}}else{if(d.background&&a&&g){d.background.setAttributes(Ext.apply({x:0,y:0,width:a,height:g},{hidden:false}),true)}}},getBBox:function(a,b){var c=this["getPath"+a.type](a);if(b){a.bbox.plain=a.bbox.plain||Ext.draw.Draw.pathDimensions(c);return a.bbox.plain}if(a.dirtyTransform){this.applyTransformations(a,true)}a.bbox.transform=a.bbox.transform||Ext.draw.Draw.pathDimensions(Ext.draw.Draw.mapPath(c,a.matrix));return a.bbox.transform},transformToViewBox:function(a,d){if(this.viewBoxShift){var c=this,b=c.viewBoxShift;return[a/b.scale-b.dx,d/b.scale-b.dy]}else{return[a,d]}},applyTransformations:function(b,d){if(b.type=="text"){b.bbox.transform=0;this.transform(b,false)}b.dirtyTransform=false;var c=this,a=b.attr;if(a.translation.x!=null||a.translation.y!=null){c.translate(b)}if(a.scaling.x!=null||a.scaling.y!=null){c.scale(b)}if(a.rotation.degrees!=null){c.rotate(b)}b.bbox.transform=0;this.transform(b,d);b.transformations=[]},rotate:function(a){var e,b=a.attr.rotation.degrees,d=a.attr.rotation.x,c=a.attr.rotation.y;if(!Ext.isNumber(d)||!Ext.isNumber(c)){e=this.getBBox(a,true);d=!Ext.isNumber(d)?e.x+e.width/2:d;c=!Ext.isNumber(c)?e.y+e.height/2:c}a.transformations.push({type:"rotate",degrees:b,x:d,y:c})},translate:function(b){var a=b.attr.translation.x||0,c=b.attr.translation.y||0;b.transformations.push({type:"translate",x:a,y:c})},scale:function(b){var e,a=b.attr.scaling.x||1,f=b.attr.scaling.y||1,d=b.attr.scaling.centerX,c=b.attr.scaling.centerY;if(!Ext.isNumber(d)||!Ext.isNumber(c)){e=this.getBBox(b,true);d=!Ext.isNumber(d)?e.x+e.width/2:d;c=!Ext.isNumber(c)?e.y+e.height/2:c}b.transformations.push({type:"scale",x:a,y:f,centerX:d,centerY:c})},rectPath:function(a,e,b,c,d){if(d){return[["M",a+d,e],["l",b-d*2,0],["a",d,d,0,0,1,d,d],["l",0,c-d*2],["a",d,d,0,0,1,-d,d],["l",d*2-b,0],["a",d,d,0,0,1,-d,-d],["l",0,d*2-c],["a",d,d,0,0,1,d,-d],["z"]]}return[["M",a,e],["l",b,0],["l",0,c],["l",-b,0],["z"]]},ellipsePath:function(a,d,c,b){if(b==null){b=c}return[["M",a,d],["m",0,-b],["a",c,b,0,1,1,0,2*b],["a",c,b,0,1,1,0,-2*b],["z"]]},getPathpath:function(a){return a.attr.path},getPathcircle:function(c){var b=c.attr;return this.ellipsePath(b.x,b.y,b.radius,b.radius)},getPathellipse:function(c){var b=c.attr;return this.ellipsePath(b.x,b.y,b.radiusX||(b.width/2)||0,b.radiusY||(b.height/2)||0)},getPathrect:function(c){var b=c.attr;return this.rectPath(b.x||0,b.y||0,b.width||0,b.height||0,b.r||0)},getPathimage:function(c){var b=c.attr;return this.rectPath(b.x||0,b.y||0,b.width,b.height)},getPathtext:function(a){var b=this.getBBoxText(a);return this.rectPath(b.x,b.y,b.width,b.height)},createGroup:function(b){var a=this.groups.get(b);if(!a){a=new Ext.draw.CompositeSprite({surface:this});a.id=b||Ext.id(null,"ext-surface-group-");this.groups.add(a)}return a},getGroup:function(b){var a;if(typeof b=="string"){a=this.groups.get(b);if(!a){a=this.createGroup(b)}}else{a=b}return a},prepareItems:function(a,c){a=[].concat(a);var e,b,d;for(b=0,d=a.length;b<d;b++){e=a[b];if(!(e instanceof Ext.draw.Sprite)){e.surface=this;a[b]=this.createItem(e)}else{e.surface=this}}return a},setText:Ext.emptyFn,createItem:Ext.emptyFn,getId:function(){return this.id||(this.id=Ext.id(null,"ext-surface-"))},destroy:function(){var a=this;delete a.domRef;if(a.background){a.background.destroy()}a.removeAll(true);Ext.destroy(a.groups.items)}});Ext.ns("Ext.fx");Ext.require("Ext.fx.CubicBezier",function(){var e=Math,g=e.PI,d=e.pow,b=e.sin,f=e.sqrt,a=e.abs,c=1.70158;Ext.fx.Easing={};Ext.apply(Ext.fx.Easing,{linear:function(h){return h},ease:function(k){var h=0.07813-k/2,l=-0.25,m=f(0.0066+h*h),p=m-h,j=d(a(p),1/3)*(p<0?-1:1),o=-m-h,i=d(a(o),1/3)*(o<0?-1:1),r=j+i+0.25;return d(1-r,2)*3*r*0.1+(1-r)*3*r*r+r*r*r},easeIn:function(h){return d(h,1.7)},easeOut:function(h){return d(h,0.48)},easeInOut:function(p){var k=0.48-p/1.04,j=f(0.1734+k*k),h=j-k,o=d(a(h),1/3)*(h<0?-1:1),m=-j-k,l=d(a(m),1/3)*(m<0?-1:1),i=o+l+0.5;return(1-i)*3*i*i+i*i*i},backIn:function(h){return h*h*((c+1)*h-c)},backOut:function(h){h=h-1;return h*h*((c+1)*h+c)+1},elasticIn:function(j){if(j===0||j===1){return j}var i=0.3,h=i/4;return d(2,-10*j)*b((j-h)*(2*g)/i)+1},elasticOut:function(h){return 1-Ext.fx.Easing.elasticIn(1-h)},bounceIn:function(h){return 1-Ext.fx.Easing.bounceOut(1-h)},bounceOut:function(k){var i=7.5625,j=2.75,h;if(k<(1/j)){h=i*k*k}else{if(k<(2/j)){k-=(1.5/j);h=i*k*k+0.75}else{if(k<(2.5/j)){k-=(2.25/j);h=i*k*k+0.9375}else{k-=(2.625/j);h=i*k*k+0.984375}}}return h}});Ext.apply(Ext.fx.Easing,{"back-in":Ext.fx.Easing.backIn,"back-out":Ext.fx.Easing.backOut,"ease-in":Ext.fx.Easing.easeIn,"ease-out":Ext.fx.Easing.easeOut,"elastic-in":Ext.fx.Easing.elasticIn,"elastic-out":Ext.fx.Easing.elasticIn,"bounce-in":Ext.fx.Easing.bounceIn,"bounce-out":Ext.fx.Easing.bounceOut,"ease-in-out":Ext.fx.Easing.easeInOut})});Ext.define("Ext.data.writer.Json",{extend:"Ext.data.writer.Writer",alternateClassName:"Ext.data.JsonWriter",alias:"writer.json",root:undefined,encode:false,allowSingle:true,writeRecords:function(b,c){var a=this.root;if(this.allowSingle&&c.length==1){c=c[0]}if(this.encode){if(a){b.params[a]=Ext.encode(c)}else{}}else{b.jsonData=b.jsonData||{};if(a){b.jsonData[a]=c}else{b.jsonData=c}}return b}});Ext.define("Ext.util.LruCache",{extend:"Ext.util.HashMap",constructor:function(a){Ext.apply(this,a);this.callParent([a])},add:function(b,e){var d=this,a=d.findKey(e),c;if(a){d.unlinkEntry(c=d.map[a]);c.prev=d.last;c.next=null}else{c={prev:d.last,next:null,key:b,value:e}}if(d.last){d.last.next=c}else{d.first=c}d.last=c;d.callParent([b,c]);d.prune();return e},insertBefore:function(b,f,c){var e=this,a,d;if(c=this.map[this.findKey(c)]){a=e.findKey(f);if(a){e.unlinkEntry(d=e.map[a])}else{d={prev:c.prev,next:c,key:b,value:f}}if(c.prev){d.prev.next=d}else{e.first=d}d.next=c;c.prev=d;e.prune();return f}else{return e.add(b,f)}},get:function(a){var b=this.map[a];if(b){if(b.next){this.moveToEnd(b)}return b.value}},removeAtKey:function(a){this.unlinkEntry(this.map[a]);return this.callParent(arguments)},clear:function(a){this.first=this.last=null;return this.callParent(arguments)},unlinkEntry:function(a){if(a){if(a.next){a.next.prev=a.prev}else{this.last=a.prev}if(a.prev){a.prev.next=a.next}else{this.first=a.next}a.prev=a.next=null}},moveToEnd:function(a){this.unlinkEntry(a);if(a.prev=this.last){this.last.next=a}else{this.first=a}this.last=a},getArray:function(c){var a=[],b=this.first;while(b){a.push(c?b.key:b.value);b=b.next}return a},each:function(c,b,a){var f=this,e=a?f.last:f.first,d=f.length;b=b||f;while(e){if(c.call(b,e.key,e.value,d)===false){break}e=a?e.prev:e.next}return f},findKey:function(b){var a,c=this.map;for(a in c){if(c.hasOwnProperty(a)&&c[a].value===b){return a}}return undefined},prune:function(){var a=this,b=a.maxSize?(a.length-a.maxSize):0;if(b>0){for(;a.first&&b;b--){a.removeAtKey(a.first.key)}}}});Ext.define("Ext.data.proxy.Client",{extend:"Ext.data.proxy.Proxy",alternateClassName:"Ext.data.ClientProxy",isSynchronous:true,clear:function(){}});Ext.define("Ext.data.proxy.Memory",{extend:"Ext.data.proxy.Client",alias:"proxy.memory",alternateClassName:"Ext.data.MemoryProxy",constructor:function(a){this.callParent([a]);this.setReader(this.reader)},updateOperation:function(b,f,d){var c=0,e=b.getRecords(),a=e.length;for(c;c<a;c++){e[c].commit()}b.setCompleted();b.setSuccessful();Ext.callback(f,d||this,[b])},create:function(){this.updateOperation.apply(this,arguments)},update:function(){this.updateOperation.apply(this,arguments)},destroy:function(){this.updateOperation.apply(this,arguments)},read:function(a,d,b){var c=this;a.resultSet=c.getReader().read(c.data);a.setCompleted();a.setSuccessful();Ext.callback(d,b||c,[a])},clear:Ext.emptyFn});Ext.define("Ext.layout.container.Fit",{extend:"Ext.layout.container.Container",alternateClassName:"Ext.layout.FitLayout",alias:"layout.fit",itemCls:Ext.baseCSSPrefix+"fit-item",targetCls:Ext.baseCSSPrefix+"layout-fit",type:"fit",defaultMargins:{top:0,right:0,bottom:0,left:0},manageMargins:true,sizePolicies:{0:{setsWidth:0,setsHeight:0},1:{setsWidth:1,setsHeight:0},2:{setsWidth:0,setsHeight:1},3:{setsWidth:1,setsHeight:1}},getItemSizePolicy:function(b,c){var a=c||this.owner.getSizeModel(),d=(a.width.shrinkWrap?0:1)|(a.height.shrinkWrap?0:2);return this.sizePolicies[d]},beginLayoutCycle:function(j,f){var s=this,t=s.lastHeightModel&&s.lastHeightModel.calculated,g=s.lastWidthModel&&s.lastWidthModel.calculated,n=g||t,k=0,l=0,r,b,o,q,e,a,h,m,p,d;s.callParent(arguments);if(n&&j.targetContext.el.dom.tagName.toUpperCase()!="TD"){n=g=t=false}b=j.childItems;e=b.length;for(o=0;o<e;++o){q=b[o];if(f){r=q.target;h=r.minHeight;m=r.minWidth;if(m||h){a=q.marginInfo||q.getMarginInfo();h+=a.height;m+=a.height;if(k<h){k=h}if(l<m){l=m}}}if(n){p=q.el.dom.style;if(t){p.height=""}if(g){p.width=""}}}if(f){j.maxChildMinHeight=k;j.maxChildMinWidth=l}r=j.target;j.overflowX=(!j.widthModel.shrinkWrap&&j.maxChildMinWidth&&(r.autoScroll||r.overflowX))||d;j.overflowY=(!j.heightModel.shrinkWrap&&j.maxChildMinHeight&&(r.autoScroll||r.overflowY))||d},calculate:function(f){var n=this,k=f.childItems,d=k.length,c=n.getContainerSize(f),e={length:d,ownerContext:f,targetSize:c},q=f.widthModel.shrinkWrap,l=f.heightModel.shrinkWrap,j=f.overflowX,g=f.overflowY,m,b,o,h,a,p;if(j||g){m=n.getScrollbarsNeeded(j&&c.width,g&&c.height,f.maxChildMinWidth,f.maxChildMinHeight);if(m){b=Ext.getScrollbarSize();if(m&1){c.height-=b.height}if(m&2){c.width-=b.width}}}for(h=0;h<d;++h){e.index=h;n.fitItem(k[h],e)}if(l||q){o=f.targetContext.getPaddingInfo();if(q){if(g&&!c.gotHeight){n.done=false}else{a=e.contentWidth+o.width;if(m&2){a+=b.width}if(!f.setContentWidth(a)){n.done=false}}}if(l){if(j&&!c.gotWidth){n.done=false}else{p=e.contentHeight+o.height;if(m&1){p+=b.height}if(!f.setContentHeight(p)){n.done=false}}}}},fitItem:function(b,c){var a=this;if(b.invalid){a.done=false;return}c.margins=b.getMarginInfo();c.needed=c.got=0;a.fitItemWidth(b,c);a.fitItemHeight(b,c);if(c.got!=c.needed){a.done=false}},fitItemWidth:function(c,d){var a,b;if(d.ownerContext.widthModel.shrinkWrap){b=c.getProp("width")+d.margins.width;a=d.contentWidth;if(a===undefined){d.contentWidth=b}else{d.contentWidth=Math.max(a,b)}}else{if(c.widthModel.calculated){++d.needed;if(d.targetSize.gotWidth){++d.got;this.setItemWidth(c,d)}}}this.positionItemX(c,d)},fitItemHeight:function(c,d){var b,a;if(d.ownerContext.heightModel.shrinkWrap){a=c.getProp("height")+d.margins.height;b=d.contentHeight;if(b===undefined){d.contentHeight=a}else{d.contentHeight=Math.max(b,a)}}else{if(c.heightModel.calculated){++d.needed;if(d.targetSize.gotHeight){++d.got;this.setItemHeight(c,d)}}}this.positionItemY(c,d)},positionItemX:function(a,c){var b=c.margins;if(c.index||b.left){a.setProp("x",b.left)}if(b.width){a.setProp("margin-right",b.width)}},positionItemY:function(a,c){var b=c.margins;if(c.index||b.top){a.setProp("y",b.top)}if(b.height){a.setProp("margin-bottom",b.height)}},setItemHeight:function(a,b){a.setHeight(b.targetSize.height-b.margins.height)},setItemWidth:function(a,b){a.setWidth(b.targetSize.width-b.margins.width)}});Ext.define("Ext.layout.container.Card",{extend:"Ext.layout.container.Fit",alternateClassName:"Ext.layout.CardLayout",alias:"layout.card",type:"card",hideInactive:true,deferredRender:false,getRenderTree:function(){var a=this,b=a.getActiveItem();if(b){if(b.hasListeners.beforeactivate&&b.fireEvent("beforeactivate",b)===false){b=a.activeItem=a.owner.activeItem=null}else{if(b.hasListeners.activate){b.on({boxready:function(){b.fireEvent("activate",b)},single:true})}}if(a.deferredRender){if(b){return a.getItemsRenderTree([b])}}else{return a.callParent(arguments)}}},renderChildren:function(){var a=this,b=a.getActiveItem();if(!a.deferredRender){a.callParent()}else{if(b){a.renderItems([b],a.getRenderTarget())}}},isValidParent:function(c,d,a){var b=c.el?c.el.dom:Ext.getDom(c);return(b&&b.parentNode===(d.dom||d))||false},getActiveItem:function(){var b=this,a=b.parseActiveItem(b.activeItem||(b.owner&&b.owner.activeItem));if(a&&b.owner.items.indexOf(a)!=-1){b.activeItem=a}else{b.activeItem=null}return b.activeItem},parseActiveItem:function(a){if(a&&a.isComponent){return a}else{if(typeof a=="number"||a===undefined){return this.getLayoutItems()[a||0]}else{return this.owner.getComponent(a)}}},configureItem:function(a){if(a===this.getActiveItem()){a.hidden=false}else{a.hidden=true}this.callParent(arguments)},onRemove:function(a){var b=this;if(a===b.activeItem){b.activeItem=null}},getAnimation:function(b,a){var c=(b||{}).cardSwitchAnimation;if(c===false){return false}return c||a.cardSwitchAnimation},getNext:function(){var c=arguments[0],a=this.getLayoutItems(),b=Ext.Array.indexOf(a,this.activeItem);return a[b+1]||(c?a[0]:false)},next:function(){var b=arguments[0],a=arguments[1];return this.setActiveItem(this.getNext(a),b)},getPrev:function(){var c=arguments[0],a=this.getLayoutItems(),b=Ext.Array.indexOf(a,this.activeItem);return a[b-1]||(c?a[a.length-1]:false)},prev:function(){var b=arguments[0],a=arguments[1];return this.setActiveItem(this.getPrev(a),b)},setActiveItem:function(b){var e=this,a=e.owner,d=e.activeItem,f=a.rendered,c;b=e.parseActiveItem(b);c=a.items.indexOf(b);if(c==-1){c=a.items.items.length;Ext.suspendLayouts();b=a.add(b);Ext.resumeLayouts()}if(b&&d!=b){if(b.fireEvent("beforeactivate",b,d)===false){return false}if(d&&d.fireEvent("beforedeactivate",d,b)===false){return false}if(f){Ext.suspendLayouts();if(!b.rendered){e.renderItem(b,e.getRenderTarget(),a.items.length)}if(d){if(e.hideInactive){d.hide();d.hiddenByLayout=true}d.fireEvent("deactivate",d,b)}if(b.hidden){b.show()}if(!b.hidden){e.activeItem=b}Ext.resumeLayouts(true)}else{e.activeItem=b}b.fireEvent("activate",b,d);return e.activeItem}return false}});Ext.define("Ext.layout.container.Auto",{alias:["layout.auto","layout.autocontainer"],extend:"Ext.layout.container.Container",type:"autocontainer",childEls:["clearEl"],renderTpl:["{%this.renderBody(out,values)%}",'<div id="{ownerId}-clearEl" class="',Ext.baseCSSPrefix,'clear" role="presentation"></div>'],calculate:function(b){var a=this,c;if(!b.hasDomProp("containerChildrenDone")){a.done=false}else{c=a.getContainerSize(b);if(!c.gotAll){a.done=false}a.calculateContentSize(b)}}});Ext.define("Ext.container.DockingContainer",{requires:["Ext.util.MixedCollection","Ext.Element"],isDockingContainer:true,defaultDockWeights:{top:{render:1,visual:1},left:{render:3,visual:5},right:{render:5,visual:7},bottom:{render:7,visual:3}},dockOrder:{top:-1,left:-1,right:1,bottom:1},addDocked:function(a,f){var e=this,b=0,d,c;a=e.prepareItems(a);c=a.length;for(;b<c;b++){d=a[b];d.dock=d.dock||"top";if(f!==undefined){e.dockedItems.insert(f+b,d)}else{e.dockedItems.add(d)}if(d.onAdded!==Ext.emptyFn){d.onAdded(e,b)}if(e.onDockedAdd!==Ext.emptyFn){e.onDockedAdd(d)}}if(e.rendered&&!e.suspendLayout){e.updateLayout()}return a},destroyDockedItems:function(){var a=this.dockedItems,b;if(a){while((b=a.first())){this.removeDocked(b,true)}}},doRenderDockedItems:function(c,f,g){var e=f.$comp,d=e.componentLayout,b,a;if(d.getDockedItems&&!f.$skipDockedItems){b=d.getDockedItems("render",!g);a=b&&d.getItemsRenderTree(b);if(a){Ext.DomHelper.generateMarkup(a,c)}}},getDockedComponent:function(a){if(Ext.isObject(a)){a=a.getItemId()}return this.dockedItems.get(a)},getDockedItems:function(a,c){var b=this.getComponentLayout().getDockedItems("render",c);if(a&&b.length){b=Ext.ComponentQuery.query(a,b)}return b},getDockingRefItems:function(b,e){var a=b&&"*,* *",d=this.getDockedItems(a,true),c;d.push.apply(d,e);c=this.getDockedItems(a,false);d.push.apply(d,c);return d},initDockingItems:function(){var b=this,a=b.dockedItems;b.dockedItems=new Ext.util.AbstractMixedCollection(false,b.getComponentId);if(a){b.addDocked(a)}},insertDocked:function(b,a){this.addDocked(a,b)},onDockedAdd:Ext.emptyFn,onDockedRemove:Ext.emptyFn,removeDocked:function(e,b){var d=this,c,a;if(!d.dockedItems.contains(e)){return e}c=d.componentLayout;a=c&&d.rendered;if(a){c.onRemove(e)}d.dockedItems.remove(e);e.onRemoved();d.onDockedRemove(e);if(b===true||(b!==false&&d.autoDestroy)){e.destroy()}else{if(a){c.afterRemove(e)}}if(!d.destroying&&!d.suspendLayout){d.updateLayout()}return e},setupDockingRenderTpl:function(a){a.renderDockedItems=this.doRenderDockedItems}});Ext.define("Ext.layout.component.Component",{extend:"Ext.layout.Layout",type:"component",isComponentLayout:true,nullBox:{},usesContentHeight:true,usesContentWidth:true,usesHeight:true,usesWidth:true,beginLayoutCycle:function(c,o){var j=this,b=j.owner,e=c.ownerCtContext,f=c.heightModel,g=c.widthModel,h=b.el.dom===document.body,d=b.lastBox||j.nullBox,m=b.el.lastBox||j.nullBox,a=!h,l,n,k,i;j.callParent(arguments);if(o){if(j.usesContentWidth){++c.consumersContentWidth}if(j.usesContentHeight){++c.consumersContentHeight}if(j.usesWidth){++c.consumersWidth}if(j.usesHeight){++c.consumersHeight}if(e&&!e.hasRawContent){l=b.ownerLayout;if(l.usesWidth){++c.consumersWidth}if(l.usesHeight){++c.consumersHeight}}}if(g.configured){k=g.names.width;if(!h){a=o?b[k]!==m.width:g.constrained}c.setWidth(b[k],a)}else{if(c.isTopLevel){if(g.calculated){n=d.width;c.setWidth(n,n!=m.width)}n=d.x;c.setProp("x",n,n!=m.x)}}if(f.configured){i=f.names.height;if(!h){a=o?b[i]!==m.height:f.constrained}c.setHeight(b[i],a)}else{if(c.isTopLevel){if(f.calculated){n=d.height;c.setHeight(n,n!=m.height)}n=d.y;c.setProp("y",n,n!=m.y)}}},finishedLayout:function(b){var g=this,k=b.children,a=g.owner,e,c,j,d,f,h;if(k){e=k.length;for(c=0;c<e;c++){j=k[c];j.el.lastBox=j.props}}b.previousSize=g.lastComponentSize;g.lastComponentSize=a.el.lastBox=f=b.props;a.lastBox=d={};h=f.x;if(h!==undefined){d.x=h}h=f.y;if(h!==undefined){d.y=h}h=f.width;if(h!==undefined){d.width=h}h=f.height;if(h!==undefined){d.height=h}g.callParent(arguments)},notifyOwner:function(d){var c=this,a=c.lastComponentSize,e=d.previousSize,b=[a.width,a.height];if(e){b.push(e.width,e.height)}c.owner.afterComponentLayout.apply(c.owner,b)},getTarget:function(){return this.owner.el},getRenderTarget:function(){return this.owner.el},cacheTargetInfo:function(b){var a=this,d=a.targetInfo,c;if(!d){c=b.getEl("getTarget",a);a.targetInfo=d={padding:c.getPaddingInfo(),border:c.getBorderInfo()}}return d},measureAutoDimensions:function(l,h){var s=this,a=s.owner,p=a.layout,d=l.heightModel,g=l.widthModel,c=l.boxParent,m=l.isBoxParent,b=l.props,i,t={gotWidth:false,gotHeight:false,isContainer:(i=!l.hasRawContent)},r=h||3,o,e,j=0,f=0,k,n,q;if(g.shrinkWrap&&l.consumersContentWidth){++j;o=!(r&1);if(i){if(o){t.contentWidth=0;t.gotWidth=true;++f}else{if((t.contentWidth=l.getProp("contentWidth"))!==undefined){t.gotWidth=true;++f}}}else{n=b.contentWidth;if(typeof n=="number"){t.contentWidth=n;t.gotWidth=true;++f}else{if(o){k=true}else{if(!l.hasDomProp("containerChildrenDone")){k=false}else{if(m||!c||c.widthModel.shrinkWrap){k=true}else{k=c.hasDomProp("width")}}}if(k){if(o){q=0}else{if(p&&p.measureContentWidth){q=p.measureContentWidth(l)}else{q=s.measureContentWidth(l)}}if(!isNaN(t.contentWidth=q)){l.setContentWidth(q,true);t.gotWidth=true;++f}}}}}else{if(g.natural&&l.consumersWidth){++j;n=b.width;if(typeof n=="number"){t.width=n;t.gotWidth=true;++f}else{if(m||!c){k=true}else{k=c.hasDomProp("width")}if(k){if(!isNaN(t.width=s.measureOwnerWidth(l))){l.setWidth(t.width,false);t.gotWidth=true;++f}}}}}if(d.shrinkWrap&&l.consumersContentHeight){++j;e=!(r&2);if(i){if(e){t.contentHeight=0;t.gotHeight=true;++f}else{if((t.contentHeight=l.getProp("contentHeight"))!==undefined){t.gotHeight=true;++f}}}else{n=b.contentHeight;if(typeof n=="number"){t.contentHeight=n;t.gotHeight=true;++f}else{if(e){k=true}else{if(!l.hasDomProp("containerChildrenDone")){k=false}else{if(a.noWrap){k=true}else{if(!g.shrinkWrap){k=(l.bodyContext||l).hasDomProp("width")}else{if(m||!c||c.widthModel.shrinkWrap){k=true}else{k=c.hasDomProp("width")}}}}}if(k){if(e){q=0}else{if(p&&p.measureContentHeight){q=p.measureContentHeight(l)}else{q=s.measureContentHeight(l)}}if(!isNaN(t.contentHeight=q)){l.setContentHeight(q,true);t.gotHeight=true;++f}}}}}else{if(d.natural&&l.consumersHeight){++j;n=b.height;if(typeof n=="number"){t.height=n;t.gotHeight=true;++f}else{if(m||!c){k=true}else{k=c.hasDomProp("width")}if(k){if(!isNaN(t.height=s.measureOwnerHeight(l))){l.setHeight(t.height,false);t.gotHeight=true;++f}}}}}if(c){l.onBoxMeasured()}t.gotAll=f==j;return t},measureContentWidth:function(a){return a.el.getWidth()-a.getFrameInfo().width},measureContentHeight:function(a){return a.el.getHeight()-a.getFrameInfo().height},measureOwnerHeight:function(a){return a.el.getHeight()},measureOwnerWidth:function(a){return a.el.getWidth()}});Ext.define("Ext.layout.component.Dock",{extend:"Ext.layout.component.Component",alias:"layout.dock",alternateClassName:"Ext.layout.component.AbstractDock",type:"dock",initializedBorders:-1,horizontalCollapsePolicy:{width:true,x:true},verticalCollapsePolicy:{height:true,y:true},finishRender:function(){var b=this,c,a;b.callParent();c=b.getRenderTarget();a=b.getDockedItems();b.finishRenderItems(c,a)},isItemBoxParent:function(a){return true},isItemShrinkWrap:function(a){return true},dockOpposites:{top:"bottom",right:"left",bottom:"top",left:"right"},handleItemBorders:function(){var l=this,a=l.owner,k,o,e=l.borders,g=l.dockOpposites,b=a.dockedItems.generation,f,j,n,m,h,c,d=l.collapsed;if(l.initializedBorders==b||(a.border&&!a.manageBodyBorders)){return}l.initializedBorders=b;l.collapsed=false;o=l.getLayoutItems();l.collapsed=d;k={top:[],right:[],bottom:[],left:[]};for(f=0,j=o.length;f<j;f++){n=o[f];m=n.dock;if(n.ignoreBorderManagement){continue}if(!k[m].satisfied){k[m].push(n);k[m].satisfied=true}if(!k.top.satisfied&&g[m]!=="top"){k.top.push(n)}if(!k.right.satisfied&&g[m]!=="right"){k.right.push(n)}if(!k.bottom.satisfied&&g[m]!=="bottom"){k.bottom.push(n)}if(!k.left.satisfied&&g[m]!=="left"){k.left.push(n)}}if(e){for(h in e){if(e.hasOwnProperty(h)){j=e[h].length;if(!a.manageBodyBorders){for(f=0;f<j;f++){c=e[h][f];if(!c.isDestroyed){c.removeCls(Ext.baseCSSPrefix+"docked-noborder-"+h)}}if(!e[h].satisfied&&!a.bodyBorder){a.removeBodyCls(Ext.baseCSSPrefix+"docked-noborder-"+h)}}else{if(e[h].satisfied){a.setBodyStyle("border-"+h+"-width","")}}}}}for(h in k){if(k.hasOwnProperty(h)){j=k[h].length;if(!a.manageBodyBorders){for(f=0;f<j;f++){k[h][f].addCls(Ext.baseCSSPrefix+"docked-noborder-"+h)}if((!k[h].satisfied&&!a.bodyBorder)||a.bodyBorder===false){a.addBodyCls(Ext.baseCSSPrefix+"docked-noborder-"+h)}}else{if(k[h].satisfied){a.setBodyStyle("border-"+h+"-width","1px")}}}}l.borders=k},beforeLayoutCycle:function(e){var c=this,b=c.owner,f=c.sizeModels.shrinkWrap,d,a;if(b.collapsed){if(b.collapsedVertical()){a=true;e.measureDimensions=1}else{d=true;e.measureDimensions=2}}e.collapsedVert=a;e.collapsedHorz=d;if(a){e.heightModel=f}else{if(d){e.widthModel=f}}},beginLayout:function(d){var j=this,c=j.owner,m=j.getLayoutItems(),b=d.context,f=m.length,k,h,l,a,e,g;j.callParent(arguments);j.handleItemBorders();g=c.getCollapsed();if(g!==j.lastCollapsedState&&Ext.isDefined(j.lastCollapsedState)){if(j.owner.collapsed){d.isCollapsingOrExpanding=1;c.addClsWithUI(c.collapsedCls)}else{d.isCollapsingOrExpanding=2;c.removeClsWithUI(c.collapsedCls);d.lastCollapsedState=j.lastCollapsedState}}j.lastCollapsedState=g;d.dockedItems=k=[];for(h=0;h<f;h++){l=m[h];if(l.rendered){a=b.getCmp(l);a.dockedAt={x:0,y:0};a.offsets=e=Ext.Element.parseBox(l.offsets||{});e.width=e.left+e.right;e.height=e.top+e.bottom;k.push(a)}}d.bodyContext=d.getEl("body")},beginLayoutCycle:function(b){var e=this,k=b.dockedItems,d=k.length,a=e.owner,f=a.frameBody,j=e.lastHeightModel,c,h,g;e.callParent(arguments);if(j&&j.shrinkWrap&&!b.heightModel.shrinkWrap&&!e.owner.manageHeight){a.body.dom.style.marginBottom=""}if(b.widthModel.auto){if(b.widthModel.shrinkWrap){a.el.setWidth(null)}a.body.setWidth(null);if(f){f.setWidth(null)}}if(b.heightModel.auto){a.body.setHeight(null);if(f){f.setHeight(null)}}if(b.collapsedVert){b.setContentHeight(0)}else{if(b.collapsedHorz){b.setContentWidth(0)}}for(c=0;c<d;c++){h=k[c].target;g=h.dock;if(g=="right"){h.el.setLeft(0)}else{if(g!="left"){continue}}}},calculate:function(d){var j=this,c=j.measureAutoDimensions(d,d.measureDimensions),b=d.state,i=b.horzDone,e=b.vertDone,f=d.bodyContext,a,h,g,k;d.borderInfo||d.getBorderInfo();d.paddingInfo||d.getPaddingInfo();d.framingInfo||d.getFraming();f.borderInfo||f.getBorderInfo();f.paddingInfo||f.getPaddingInfo();a=!i&&j.createAxis(d,c.contentWidth,d.widthModel,"left","right","x","width","Width",d.collapsedHorz);h=!e&&j.createAxis(d,c.contentHeight,d.heightModel,"top","bottom","y","height","Height",d.collapsedVert);for(g=0,k=d.dockedItems.length;k--;++g){if(a){j.dockChild(d,a,k,g)}if(h){j.dockChild(d,h,k,g)}}if(a&&j.finishAxis(d,a)){b.horzDone=i=a}if(h&&j.finishAxis(d,h)){b.vertDone=e=h}if(i&&e&&j.finishConstraints(d,i,e)){j.finishPositions(d,i,e)}else{j.done=false}},createAxis:function(n,i,e,m,h,r,l,j,d){var t=0,b=this.owner,f=b["max"+j],c=b["min"+j]||0,k=f!=null,s="set"+j,p,a,q,o,g;if(e.shrinkWrap){if(d){g=0}else{a=n.bodyContext;g=i+a.borderInfo[l]}}else{p=n.borderInfo;q=n.framingInfo;o=n.paddingInfo;g=n.getProp(l);g-=p[h]+o[h]+q[h];t=p[m]+o[m]+q[m]}return{shrinkWrap:e.shrinkWrap,sizeModel:e,begin:t,end:g,collapsed:d,horizontal:r=="x",ignoreFrameBegin:false,ignoreFrameEnd:false,initialSize:g-t,hasMinMaxConstraints:(c||k)&&e.shrinkWrap,minSize:c,maxSize:k?f:1000000000,bodyPosProp:this.owner.manageHeight?r:("margin-"+m),dockBegin:m,dockEnd:h,posProp:r,sizeProp:l,sizePropCap:j,setSize:s,dockedPixelsEnd:0}},dockChild:function(b,c,i,d){var e=this,a=b.dockedItems[c.shrinkWrap?i:d],g=a.target,h=g.dock,f;if(g.ignoreParentFrame&&b.isCollapsingOrExpanding){a.clearMarginCache()}if(h==c.dockBegin){if(c.shrinkWrap){f=e.dockOutwardBegin(b,a,g,c)}else{f=e.dockInwardBegin(b,a,g,c)}}else{if(h==c.dockEnd){if(c.shrinkWrap){f=e.dockOutwardEnd(b,a,g,c)}else{f=e.dockInwardEnd(b,a,g,c)}}else{f=e.dockStretch(b,a,g,c)}}a.dockedAt[c.posProp]=f},dockInwardBegin:function(f,e,d,b){var h=b.begin,g=b.sizeProp,a,c;if(d.ignoreParentFrame){c=d.dock;h-=f.borderInfo[c]+f.paddingInfo[c]+f.framingInfo[c]}if(!d.overlay){a=e.getProp(g)+e.getMarginInfo()[g];b.begin+=a}return h},dockInwardEnd:function(e,d,c,b){var g=b.sizeProp,a=d.getProp(g)+d.getMarginInfo()[g],f=b.end-a;if(!c.overlay){b.end=f}if(c.ignoreParentFrame){f+=e.borderInfo[c.dock]+e.paddingInfo[c.dock]+e.framingInfo[c.dock]}return f},dockOutwardBegin:function(f,e,d,b){var h=b.begin,g=b.sizeProp,c,a;if(b.collapsed){b.ignoreFrameBegin=b.ignoreFrameEnd=true}else{if(d.ignoreParentFrame){c=d.dock;h-=f.borderInfo[c]+f.paddingInfo[c]+f.framingInfo[c];b.ignoreFrameBegin=true}}if(!d.overlay){a=e.getProp(g)+e.getMarginInfo()[g];h-=a;b.begin=h}return h},dockOutwardEnd:function(f,e,d,b){var h=b.end,g=b.sizeProp,c,a;a=e.getProp(g)+e.getMarginInfo()[g];if(b.collapsed){b.ignoreFrameBegin=b.ignoreFrameEnd=true}else{if(d.ignoreParentFrame){c=d.dock;h+=f.borderInfo[c]+f.paddingInfo[c]+f.framingInfo[c];b.ignoreFrameEnd=true}}if(!d.overlay){b.end=h+a;b.dockedPixelsEnd+=a}return h},dockStretch:function(c,b,m,d){var n=m.dock,i=d.sizeProp,a=n=="top"||n=="bottom",e=b.offsets,h=c.borderInfo,l=c.paddingInfo,g=a?"right":"bottom",p=a?"left":"top",k=d.begin+e[p],f,o,j;if(m.stretch!==false){o=d.end-k-e[g];if(m.ignoreParentFrame){j=c.framingInfo;k-=h[p]+l[p]+j[p];o+=h[i]+l[i]+j[i]}f=b.getMarginInfo();o-=f[i];b[d.setSize](o)}return k},finishAxis:function(c,e){var n=e.end-e.begin,k=e.setSize,d=e.dockBegin,h=e.dockEnd,i=c.borderInfo,l=c.paddingInfo,j=c.framingInfo,g=l[d]+i[d]+j[d],f=c.bodyContext,m,a,b;if(e.shrinkWrap){e.delta=-e.begin;a=e.initialSize;if(e.ignoreFrameBegin){e.delta-=i[d];m=-e.begin-g}else{n+=g;e.delta+=l[d]+j[d];m=-e.begin}if(!e.ignoreFrameEnd){n+=l[h]+i[h]+j[h]}e.size=n;if(!e.horizontal&&!this.owner.manageHeight){b=false}}else{e.delta=-i[e.dockBegin];a=n;m=e.begin-g}f[k](a,b);f.setProp(e.bodyPosProp,m);return !isNaN(n)},finishConstraints:function(e,a,g){var i=this.sizeModels,k=a.shrinkWrap,b=g.shrinkWrap,c,j,d,f,h,l;if(k){l=a.size;if(l<a.minSize){h=i.constrainedMin;d=a.minSize}else{if(l>a.maxSize){h=i.constrainedMax;d=a.maxSize}else{d=l}}}if(b){l=g.size;if(l<g.minSize){f=i.constrainedMin;j=g.minSize}else{if(l>g.maxSize){f=i.constrainedMax;j=g.maxSize}else{if(!e.collapsedVert&&!this.owner.manageHeight){c=false;e.bodyContext.setProp("margin-bottom",g.dockedPixelsEnd)}j=l}}}if(h||f){if(h&&f&&h.constrainedMax&&f.constrainedMin){e.invalidate({widthModel:h});return false}if(!e.widthModel.calculatedFromShrinkWrap&&!e.heightModel.calculatedFromShrinkWrap){e.invalidate({widthModel:h,heightModel:f});return false}}if(k){e.setWidth(d);if(h){e.widthModel=h}}if(b){e.setHeight(j,c);if(f){e.heightModel=f}}return true},finishPositions:function(d,a,g){var i=d.dockedItems,c=i.length,f=a.delta,e=g.delta,h,b;for(h=0;h<c;++h){b=i[h];b.setProp("x",f+b.dockedAt.x);b.setProp("y",e+b.dockedAt.y)}},finishedLayout:function(b){var a=this,c=b.target;a.callParent(arguments);if(!b.animatePolicy){if(b.isCollapsingOrExpanding===1){c.afterCollapse(false)}else{if(b.isCollapsingOrExpanding===2){c.afterExpand(false)}}}},getAnimatePolicy:function(c){var b=this,a,d;if(c.isCollapsingOrExpanding==1){a=b.lastCollapsedState}else{if(c.isCollapsingOrExpanding==2){a=c.lastCollapsedState}}if(a=="left"||a=="right"){d=b.horizontalCollapsePolicy}else{if(a=="top"||a=="bottom"){d=b.verticalCollapsePolicy}}return d},getDockedItems:function(c,m){var h=this,e=(c==="visual"),j=e?Ext.ComponentQuery.query("[rendered]",h.owner.dockedItems.items):h.owner.dockedItems.items,g=j&&j.length&&c!==false,b,l,k,f,d,a;if(m==null){k=g&&!e?j.slice():j}else{k=[];for(f=0,a=j.length;f<a;++f){l=j[f].dock;d=(l=="top"||l=="left");if(m?d:!d){k.push(j[f])}}g=g&&k.length}if(g){b=(c=c||"render")=="render";Ext.Array.sort(k,function(n,i){var o,p;if(b&&((o=h.owner.dockOrder[n.dock])!==(p=h.owner.dockOrder[i.dock]))){if(!(o+p)){return o-p}}o=h.getItemWeight(n,c);p=h.getItemWeight(i,c);if((o!==undefined)&&(p!==undefined)){return o-p}return 0})}return k||[]},getItemWeight:function(b,a){var c=b.weight||this.owner.defaultDockWeights[b.dock];return c[a]||c},getLayoutItems:function(){var e=this,b,f,d,c,a;if(e.owner.collapsed){a=e.owner.getCollapsedDockedItems()}else{b=e.getDockedItems("visual");f=b.length;a=[];for(c=0;c<f;c++){d=b[c];if(!d.hidden){a.push(d)}}}return a},measureContentWidth:function(a){var b=a.bodyContext;return b.el.getWidth()-b.getBorderInfo().width},measureContentHeight:function(a){var b=a.bodyContext;return b.el.getHeight()-b.getBorderInfo().height},redoLayout:function(c){var b=this,a=b.owner;if(c.isCollapsingOrExpanding==1){if(a.reExpander){a.reExpander.el.show()}a.addClsWithUI(a.collapsedCls);c.redo(true)}else{if(c.isCollapsingOrExpanding==2){a.removeClsWithUI(a.collapsedCls);c.bodyContext.redo()}}},renderChildren:function(){var b=this,a=b.getDockedItems(),c=b.getRenderTarget();b.renderItems(a,c)},renderItems:function(h,g){var k=this,c=h.length,a=0,b=0,o=0,l=k.getRenderTarget().dom.childNodes,m=l.length,f,d,e,n;for(f=0,d=0;f<m;f++){e=l[f];if(Ext.fly(e).hasCls("x-resizable-handle")){break}for(d=0;d<c;d++){n=h[d];if(n.rendered&&n.el.dom===e){break}}if(d===c){o++}}for(;a<c;a++,b++){n=h[a];if(a===b&&(n.dock==="right"||n.dock==="bottom")){b+=o}if(n&&!n.rendered){k.renderItem(n,g,b)}else{if(!k.isValidParent(n,g,b)){k.moveItem(n,g,b)}}}},undoLayout:function(c){var b=this,a=b.owner;if(c.isCollapsingOrExpanding==1){if(a.reExpander){a.reExpander.el.hide()}a.removeClsWithUI(a.collapsedCls);c.undo(true)}else{if(c.isCollapsingOrExpanding==2){a.addClsWithUI(a.collapsedCls);c.bodyContext.undo()}}},sizePolicy:{nostretch:{setsWidth:0,setsHeight:0},stretchH:{setsWidth:1,setsHeight:0},stretchV:{setsWidth:0,setsHeight:1},autoStretchH:{readsWidth:1,setsWidth:1,setsHeight:0},autoStretchV:{readsHeight:1,setsWidth:0,setsHeight:1}},getItemSizePolicy:function(c){var d=this.sizePolicy,b,a;if(c.stretch===false){return d.nostretch}b=c.dock;a=(b=="left"||b=="right");if(a){return d.stretchV}return d.stretchH},configureItem:function(a,b){this.callParent(arguments);a.addCls(Ext.baseCSSPrefix+"docked");a.addClsWithUI("docked-"+a.dock)},afterRemove:function(a){this.callParent(arguments);if(this.itemCls){a.el.removeCls(this.itemCls+"-"+a.dock)}var b=a.el.dom;if(!a.destroying&&b){b.parentNode.removeChild(b)}this.childrenChanged=true}});Ext.define("Ext.layout.component.Auto",{alias:"layout.autocomponent",extend:"Ext.layout.component.Component",type:"autocomponent",setHeightInDom:false,setWidthInDom:false,waitForOuterHeightInDom:false,waitForOuterWidthInDom:false,beginLayoutCycle:function(d,b){var c=this,f=c.lastWidthModel,e=c.lastHeightModel,a=c.owner;c.callParent(arguments);if(f&&f.fixed&&d.widthModel.shrinkWrap){a.el.setWidth(null)}if(e&&e.fixed&&d.heightModel.shrinkWrap){a.el.setHeight(null)}},calculate:function(g){var f=this,e=f.measureAutoDimensions(g),b=g.heightModel,c=g.widthModel,d,a;if(e.gotWidth){if(c.shrinkWrap){f.publishOwnerWidth(g,e.contentWidth)}else{if(f.publishInnerWidth){f.publishInnerWidth(g,e.width)}}}else{if(!c.auto&&f.publishInnerWidth){d=f.waitForOuterWidthInDom?g.getDomProp("width"):g.getProp("width");if(d===undefined){f.done=false}else{f.publishInnerWidth(g,d)}}}if(e.gotHeight){if(b.shrinkWrap){f.publishOwnerHeight(g,e.contentHeight)}else{if(f.publishInnerHeight){f.publishInnerHeight(g,e.height)}}}else{if(!b.auto&&f.publishInnerHeight){a=f.waitForOuterHeightInDom?g.getDomProp("height"):g.getProp("height");if(a===undefined){f.done=false}else{f.publishInnerHeight(g,a)}}}if(!e.gotAll){f.done=false}},calculateOwnerHeightFromContentHeight:function(b,a){return a+b.getFrameInfo().height},calculateOwnerWidthFromContentWidth:function(b,a){return a+b.getFrameInfo().width},publishOwnerHeight:function(h,f){var e=this,b=e.owner,a=e.calculateOwnerHeightFromContentHeight(h,f),g,d,c;if(isNaN(a)){e.done=false}else{g=Ext.Number.constrain(a,b.minHeight,b.maxHeight);if(g==a){d=e.setHeightInDom}else{c=e.sizeModels[(g<a)?"constrainedMax":"constrainedMin"];a=g;if(h.heightModel.calculatedFromShrinkWrap){h.heightModel=c}else{h.invalidate({heightModel:c})}}h.setHeight(a,d)}},publishOwnerWidth:function(g,b){var f=this,a=f.owner,e=f.calculateOwnerWidthFromContentWidth(g,b),h,d,c;if(isNaN(e)){f.done=false}else{h=Ext.Number.constrain(e,a.minWidth,a.maxWidth);if(h==e){d=f.setWidthInDom}else{c=f.sizeModels[(h<e)?"constrainedMax":"constrainedMin"];e=h;if(g.widthModel.calculatedFromShrinkWrap){g.widthModel=c}else{g.invalidate({widthModel:c})}}g.setWidth(e,d)}}});Ext.define("Ext.layout.component.Button",{alias:["layout.button"],extend:"Ext.layout.component.Auto",type:"button",cellClsRE:/-btn-(tl|br)\b/,htmlRE:/<.*>/,constructor:function(){this.callParent(arguments);this.hackWidth=Ext.isIE&&(!Ext.isStrict||Ext.isIE6||Ext.isIE7||Ext.isIE8);this.heightIncludesPadding=Ext.isIE6&&Ext.isStrict},beginLayout:function(a){this.callParent(arguments);this.cacheTargetInfo(a)},beginLayoutCycle:function(e){var c=this,d="",a=c.owner,b=a.btnEl,h=a.btnInnerEl,f=a.text,g;c.callParent(arguments);h.setStyle("overflow",d);if(!e.widthModel.natural){a.el.setStyle("width",d)}g=e.heightModel.shrinkWrap&&f&&c.htmlRE.test(f);b.setStyle("width",d);b.setStyle("height",g?"auto":d);h.setStyle("width",d);h.setStyle("height",g?"auto":d);h.setStyle("line-height",g?"normal":d);h.setStyle("padding-top",d);a.btnIconEl.setStyle("width",d)},calculateOwnerHeightFromContentHeight:function(b,a){return a},calculateOwnerWidthFromContentWidth:function(b,a){return a},measureContentWidth:function(c){var h=this,b=h.owner,f=b.btnEl,d=b.btnInnerEl,k=b.text,l,i,g,a,j,e;if(b.text&&h.hackWidth&&f){l=h.btnFrameWidth;if(k.indexOf(">")===-1){k=k.replace(/</g,"&lt;")}i=Ext.util.TextMetrics.measure(d,k);a=i.width+l+h.adjWidth;j=c.getEl("btnEl");e=c.getEl("btnInnerEl");g=(b.icon||b.iconCls)&&(b.iconAlign=="top"||b.iconAlign=="bottom");c.setWidth(a);j.setWidth(i.width+l);e.setWidth(i.width+l);if(g){b.btnIconEl.setWidth(i.width+l)}}else{a=c.el.getWidth()}return a},measureContentHeight:function(d){var i=this,b=i.owner,e=b.btnInnerEl,h=d.getEl("btnEl"),f=d.getEl("btnInnerEl"),c=i.minTextHeight,g=i.adjHeight,l=b.getText(),k,j,a;if(b.vertical){k=Ext.util.TextMetrics.measure(e,b.text).width;k+=i.btnFrameHeight+g;d.setHeight(k,true,true)}else{if(l&&i.htmlRE.test(l)){j=e.getHeight();if(j<c){a=Math.floor((c-j)/2);f.setHeight(c-(i.heightIncludesPadding?a:0));f.setProp("padding-top",a);j=c}k=j+g}else{k=d.el.getHeight()}}h.setHeight(k-g);return k},publishInnerHeight:function(c,l){var i=this,a=i.owner,f=Ext.isNumber,h=c.getEl("btnEl"),d=a.btnInnerEl,g=c.getEl("btnInnerEl"),e=f(l)?l-i.adjHeight:l,b=i.btnFrameHeight,k=a.getText(),j,m;h.setHeight(e);g.setHeight(e);if(!a.vertical&&e>=0){g.setProp("line-height",e-b+"px")}if(k&&i.htmlRE.test(k)){g.setProp("line-height","normal");d.setStyle("line-height","normal");j=Ext.util.TextMetrics.measure(d,k).height;m=Math.floor(Math.max(e-b-j,0)/2);g.setProp("padding-top",i.btnFrameTop+m);g.setHeight(e-(i.heightIncludesPadding?m:0))}},publishInnerWidth:function(f,c){var e=this,g=Ext.isNumber,a=f.getEl("btnEl"),b=f.getEl("btnInnerEl"),d=g(c)?c-e.adjWidth:c;a.setWidth(d);b.setWidth(d)},clearTargetCache:function(){delete this.adjWidth},cacheTargetInfo:function(b){var f=this,a=f.owner,d=a.scale,h,e,i,c,g;if(!("adjWidth" in f)||f.lastScale!==d){if(f.lastScale){a.btnInnerEl.setStyle("line-height","")}f.lastScale=d;h=b.getPaddingInfo();e=b.getFrameInfo();i=b.getEl("btnWrap").getPaddingInfo();c=b.getEl("btnInnerEl");g=c.getPaddingInfo();Ext.apply(f,{adjWidth:i.width+e.width+h.width,adjHeight:i.height+e.height+h.height,btnFrameWidth:g.width,btnFrameHeight:g.height,btnFrameTop:g.top,minTextHeight:parseInt(c.getStyle("line-height"),10)})}f.callParent(arguments)},finishedLayout:function(){var a=this.owner;this.callParent(arguments);if(Ext.isWebKit){a.el.dom.offsetWidth}}});Ext.define("Ext.layout.component.ProgressBar",{alias:["layout.progressbar"],extend:"Ext.layout.component.Auto",type:"progressbar",beginLayout:function(d){var b=this,a,c;b.callParent(arguments);if(!d.textEls){c=b.owner.textEl;if(c.isComposite){d.textEls=[];c=c.elements;for(a=c.length;a--;){d.textEls[a]=d.getEl(Ext.get(c[a]))}}else{d.textEls=[d.getEl("textEl")]}}},calculate:function(e){var c=this,a,d,b;c.callParent(arguments);if(Ext.isNumber(b=e.getProp("width"))){b-=e.getBorderInfo().width;d=e.textEls;for(a=d.length;a--;){d[a].setWidth(b)}}else{c.done=false}}});Ext.define("Ext.layout.component.field.Field",{extend:"Ext.layout.component.Auto",alias:"layout.field",uses:["Ext.tip.QuickTip","Ext.util.TextMetrics","Ext.util.CSS"],type:"field",naturalSizingProp:"size",beginLayout:function(f){var e=this,a=e.owner,c=f.widthModel,b=a[e.naturalSizingProp],d;e.callParent(arguments);f.labelStrategy=e.getLabelStrategy();f.errorStrategy=e.getErrorStrategy();f.labelContext=f.getEl("labelEl");f.bodyCellContext=f.getEl("bodyEl");f.inputContext=f.getEl("inputEl");f.errorContext=f.getEl("errorEl");if((Ext.isIE6||Ext.isIE7)&&Ext.isStrict&&f.inputContext){e.ieInputWidthAdjustment=f.inputContext.getPaddingInfo().width+f.inputContext.getBorderInfo().width}f.labelStrategy.prepare(f,a);f.errorStrategy.prepare(f,a);if(c.shrinkWrap){e.beginLayoutShrinkWrap(f)}else{if(c.natural){if(typeof b=="number"&&!a.inputWidth){e.beginLayoutFixed(f,(d=b*6.5+20),"px")}else{e.beginLayoutShrinkWrap(f)}f.setWidth(d,false)}else{e.beginLayoutFixed(f,"100","%")}}},beginLayoutFixed:function(c,b,e){var a=c.target,d=a.inputEl,f=a.inputWidth;a.el.setStyle("table-layout","fixed");a.bodyEl.setStyle("width",b+e);if(d&&f){d.setStyle("width",f+"px")}c.isFixed=true},beginLayoutShrinkWrap:function(b){var a=b.target,c=a.inputEl,d=a.inputWidth;if(c&&c.dom){c.dom.removeAttribute("size");if(d){c.setStyle("width",d+"px")}}a.el.setStyle("table-layout","auto");a.bodyEl.setStyle("width","")},finishedLayout:function(b){var a=this.owner;this.callParent(arguments);b.labelStrategy.finishedLayout(b,a);b.errorStrategy.finishedLayout(b,a)},calculateOwnerHeightFromContentHeight:function(b,a){return a},measureContentHeight:function(a){return a.el.getHeight()},measureContentWidth:function(a){return a.el.getWidth()},measureLabelErrorHeight:function(a){return a.labelStrategy.getHeight(a)+a.errorStrategy.getHeight(a)},onFocus:function(){this.getErrorStrategy().onFocus(this.owner)},getLabelStrategy:function(){var b=this,c=b.labelStrategies,a=b.owner.labelAlign;return c[a]||c.base},getErrorStrategy:function(){var c=this,a=c.owner,d=c.errorStrategies,b=a.msgTarget;return !a.preventMark&&Ext.isString(b)?(d[b]||d.elementId):d.none},labelStrategies:(function(){var a={prepare:function(e,b){var c=b.labelCls+"-"+b.labelAlign,d=b.labelEl;if(d){d.addCls(c)}},getHeight:function(){return 0},finishedLayout:Ext.emptyFn};return{base:a,top:Ext.applyIf({getHeight:function(e){var c=e.labelContext,d=c.props,b=d.height;if(b===undefined){d.height=b=c.el.getHeight()}return b}},a),left:a,right:a}}()),errorStrategies:(function(){function d(g){var h=Ext.layout.component.field.Field.tip,i;if(h&&h.isVisible()){i=h.activeTarget;if(i&&i.el===g.getActionEl().dom){h.toFront(true)}}}var c=Ext.applyIf,b=Ext.emptyFn,a=Ext.baseCSSPrefix+"form-invalid-icon",f,e={prepare:function(i,g){var h=g.errorEl;if(h){h.setDisplayed(false)}},getHeight:function(){return 0},onFocus:b,finishedLayout:b};return{none:e,side:c({prepare:function(j,h){var l=h.errorEl,i=h.sideErrorCell,g=h.hasActiveError(),k;if(!f){f=(k=Ext.getBody().createChild({style:"position:absolute",cls:a})).getWidth();k.remove()}l.addCls(a);l.set({"data-errorqtip":h.getActiveError()||""});if(h.autoFitErrors){l.setDisplayed(g)}else{l.setVisible(g)}if(i&&h.autoFitErrors){i.setDisplayed(g)}h.bodyEl.dom.colSpan=h.getBodyColspan();Ext.layout.component.field.Field.initTip()},onFocus:d},e),under:c({prepare:function(i,g){var j=g.errorEl,h=Ext.baseCSSPrefix+"form-invalid-under";j.addCls(h);j.setDisplayed(g.hasActiveError())},getHeight:function(j){var g=0,h,i;if(j.target.hasActiveError()){h=j.errorContext;i=h.props;g=i.height;if(g===undefined){i.height=g=h.el.getHeight()}}return g}},e),qtip:c({prepare:function(h,g){Ext.layout.component.field.Field.initTip();g.getActionEl().set({"data-errorqtip":g.getActiveError()||""})},onFocus:d},e),title:c({prepare:function(h,g){g.el.set({title:g.getActiveError()||""})}},e),elementId:c({prepare:function(h,g){var i=Ext.fly(g.msgTarget);if(i){i.dom.innerHTML=g.getActiveError()||"";i.setDisplayed(g.hasActiveError())}}},e)}}()),statics:{initTip:function(){var a=this.tip;if(!a){a=this.tip=Ext.create("Ext.tip.QuickTip",{baseCls:Ext.baseCSSPrefix+"form-invalid-tip"});a.tagConfig=Ext.apply({},{attribute:"errorqtip"},a.tagConfig)}},destroyTip:function(){var a=this.tip;if(a){a.destroy();delete this.tip}}}});Ext.define("Ext.layout.component.field.Text",{extend:"Ext.layout.component.field.Field",alias:"layout.textfield",requires:["Ext.util.TextMetrics"],type:"textfield",canGrowWidth:true,beginLayoutCycle:function(b){var a=this;a.callParent(arguments);if(b.shrinkWrap){b.inputContext.el.setStyle("height","")}},measureContentWidth:function(c){var g=this,b=g.owner,a=g.callParent(arguments),f=c.inputContext,j,i,d,h,e;if(b.grow&&g.canGrowWidth&&!c.state.growHandled){j=b.inputEl;i=Ext.util.Format.htmlEncode(j.dom.value||(b.hasFocus?"":b.emptyText)||"");i+=b.growAppend;d=j.getTextWidth(i)+f.getFrameInfo().width;h=b.growMax;e=Math.min(h,a);h=Math.max(b.growMin,h,e);d=Ext.Number.constrain(d,b.growMin,h);f.setWidth(d);c.state.growHandled=true;f.domBlock(g,"width");a=NaN}return a},publishInnerHeight:function(b,a){b.inputContext.setHeight(a-this.measureLabelErrorHeight(b))},beginLayoutFixed:function(d,a,e){var b=this,c=b.ieInputWidthAdjustment;if(c){b.owner.bodyEl.setStyle("padding-right",c+"px");if(e==="px"){a-=c}}b.callParent(arguments)}});Ext.define("Ext.layout.component.field.TextArea",{extend:"Ext.layout.component.field.Text",alias:"layout.textareafield",type:"textareafield",canGrowWidth:false,naturalSizingProp:"cols",beginLayout:function(a){this.callParent(arguments);a.target.inputEl.setStyle("height","")},measureContentHeight:function(b){var e=this,a=e.owner,j=e.callParent(arguments),c,h,g,f,d,i;if(a.grow&&!b.state.growHandled){c=b.inputContext;h=a.inputEl;d=h.getWidth(true);g=Ext.util.Format.htmlEncode(h.dom.value)||"&#160;";g+=a.growAppend;g=g.replace(/\n/g,"<br/>");i=Ext.util.TextMetrics.measure(h,g,d).height+c.getBorderInfo().height+c.getPaddingInfo().height;i=Ext.Number.constrain(i,a.growMin,a.growMax);c.setHeight(i);b.state.growHandled=true;c.domBlock(e,"height");j=NaN}return j}});Ext.define("Ext.layout.component.field.HtmlEditor",{extend:"Ext.layout.component.field.Field",alias:["layout.htmleditor"],type:"htmleditor",toolbarSizePolicy:{setsWidth:0,setsHeight:0},beginLayout:function(a){this.callParent(arguments);a.textAreaContext=a.getEl("textareaEl");a.iframeContext=a.getEl("iframeEl");a.toolbarContext=a.context.getCmp(this.owner.getToolbar())},renderItems:Ext.emptyFn,getItemSizePolicy:function(a){return this.toolbarSizePolicy},getLayoutItems:function(){var a=this.owner.getToolbar();return a?[a]:[]},getRenderTarget:function(){return this.owner.bodyEl},publishInnerHeight:function(c,a){var b=this,d=a-b.measureLabelErrorHeight(c)-c.toolbarContext.getProp("height")-c.bodyCellContext.getPaddingInfo().height;if(Ext.isNumber(d)){c.textAreaContext.setHeight(d);c.iframeContext.setHeight(d)}else{b.done=false}}});Ext.define("Ext.layout.component.Draw",{alias:"layout.draw",extend:"Ext.layout.component.Auto",type:"draw",measureContentWidth:function(b){var c=b.target,a=b.getPaddingInfo(),d=this.getBBox(b);if(!c.viewBox){if(c.autoSize){return d.width+a.width}else{return d.x+d.width+a.width}}else{if(b.heightModel.shrinkWrap){return a.width}else{return d.width/d.height*(b.getProp("contentHeight")-a.height)+a.width}}},measureContentHeight:function(b){var c=b.target,a=b.getPaddingInfo(),d=this.getBBox(b);if(!b.target.viewBox){if(c.autoSize){return d.height+a.height}else{return d.y+d.height+a.height}}else{if(b.widthModel.shrinkWrap){return a.height}else{return d.height/d.width*(b.getProp("contentWidth")-a.width)+a.height}}},getBBox:function(a){var b=a.surfaceBBox;if(!b){b=a.target.surface.items.getBBox();if(b.width===-Infinity&&b.height===-Infinity){b.width=b.height=b.x=b.y=0}a.surfaceBBox=b}return b},publishInnerWidth:function(b,a){b.setContentWidth(a-b.getFrameInfo().width,true)},publishInnerHeight:function(b,a){b.setContentHeight(a-b.getFrameInfo().height,true)},finishedLayout:function(c){var b=c.props,a=c.getPaddingInfo();this.owner.setSurfaceSize(b.contentWidth-a.width,b.contentHeight-a.height);this.callParent(arguments)}});Ext.define("Ext.grid.ColumnComponentLayout",{extend:"Ext.layout.component.Auto",alias:"layout.columncomponent",type:"columncomponent",setWidthInDom:true,getContentHeight:function(a){return this.owner.isGroupHeader?a.getProp("contentHeight"):this.callParent(arguments)},calculateOwnerHeightFromContentHeight:function(c,b){var a=this.callParent(arguments);if(this.owner.isGroupHeader){a+=this.owner.titleEl.dom.offsetHeight}return a},getContentWidth:function(a){return this.owner.isGroupHeader?a.getProp("contentWidth"):this.callParent(arguments)},calculateOwnerWidthFromContentWidth:function(b,a){return a+b.getPaddingInfo().width}});Ext.define("Ext.ComponentManager",{extend:"Ext.AbstractManager",alternateClassName:"Ext.ComponentMgr",singleton:true,typeName:"xtype",create:function(a,b){if(typeof a=="string"){return Ext.widget(a)}if(a.isComponent){return a}return Ext.widget(a.xtype||b,a)},registerType:function(b,a){this.types[b]=a;a[this.typeName]=b;a.prototype[this.typeName]=b}});Ext.define("Ext.fx.target.Element",{extend:"Ext.fx.target.Target",type:"element",getElVal:function(b,a,c){if(c==undefined){if(a==="x"){c=b.getX()}else{if(a==="y"){c=b.getY()}else{if(a==="scrollTop"){c=b.getScroll().top}else{if(a==="scrollLeft"){c=b.getScroll().left}else{if(a==="height"){c=b.getHeight()}else{if(a==="width"){c=b.getWidth()}else{c=b.getStyle(a)}}}}}}}return c},getAttr:function(a,c){var b=this.target;return[[b,this.getElVal(b,a,c)]]},setAttr:function(k){var f=this.target,h=k.length,m,g,b,e,c,a,d,l;for(e=0;e<h;e++){m=k[e].attrs;for(g in m){if(m.hasOwnProperty(g)){a=m[g].length;for(c=0;c<a;c++){b=m[g][c];d=b[0];l=b[1];if(g==="x"){d.setX(l)}else{if(g==="y"){d.setY(l)}else{if(g==="scrollTop"){d.scrollTo("top",l)}else{if(g==="scrollLeft"){d.scrollTo("left",l)}else{if(g==="width"){d.setWidth(l)}else{if(g==="height"){d.setHeight(l)}else{d.setStyle(g,l)}}}}}}}}}}}});Ext.define("Ext.fx.target.ElementCSS",{extend:"Ext.fx.target.Element",setAttr:function(m,e){var p={attrs:[],duration:[],easing:[]},l=m.length,f,n,h,k,c,b,g,d,a;for(g=0;g<l;g++){n=m[g];c=n.duration;k=n.easing;n=n.attrs;for(h in n){if(Ext.Array.indexOf(p.attrs,h)==-1){p.attrs.push(h.replace(/[A-Z]/g,function(i){return"-"+i.toLowerCase()}));p.duration.push(c+"ms");p.easing.push(k)}}}f=p.attrs.join(",");c=p.duration.join(",");k=p.easing.join(", ");for(g=0;g<l;g++){n=m[g].attrs;for(h in n){a=n[h].length;for(d=0;d<a;d++){b=n[h][d];b[0].setStyle(Ext.supports.CSS3Prefix+"TransitionProperty",e?"":f);b[0].setStyle(Ext.supports.CSS3Prefix+"TransitionDuration",e?"":c);b[0].setStyle(Ext.supports.CSS3Prefix+"TransitionTimingFunction",e?"":k);b[0].setStyle(h,b[1]);if(e){b=b[0].dom.offsetWidth}else{b[0].on(Ext.supports.CSS3TransitionEnd,function(){this.setStyle(Ext.supports.CSS3Prefix+"TransitionProperty",null);this.setStyle(Ext.supports.CSS3Prefix+"TransitionDuration",null);this.setStyle(Ext.supports.CSS3Prefix+"TransitionTimingFunction",null)},b[0],{single:true})}}}}}});Ext.define("Ext.fx.target.CompositeElement",{extend:"Ext.fx.target.Element",isComposite:true,constructor:function(a){a.id=a.id||Ext.id(null,"ext-composite-");this.callParent([a])},getAttr:function(a,g){var b=[],f=this.target.elements,e=f.length,c,d;for(c=0;c<e;c++){d=f[c];if(d){d=this.target.getElement(d);b.push([d,this.getElVal(d,a,g)])}}return b}});Ext.define("Ext.fx.target.CompositeElementCSS",{extend:"Ext.fx.target.CompositeElement",requires:["Ext.fx.target.ElementCSS"],setAttr:function(){return Ext.fx.target.ElementCSS.prototype.setAttr.apply(this,arguments)}});Ext.define("Ext.fx.target.Sprite",{extend:"Ext.fx.target.Target",type:"draw",getFromPrim:function(b,a){var c;switch(a){case"rotate":case"rotation":c=b.attr.rotation;return{x:c.x||0,y:c.y||0,degrees:c.degrees||0};case"scale":case"scaling":c=b.attr.scaling;return{x:c.x||1,y:c.y||1,cx:c.cx||0,cy:c.cy||0};case"translate":case"translation":c=b.attr.translation;return{x:c.x||0,y:c.y||0};default:return b.attr[a]}},getAttr:function(a,b){return[[this.target,b!=undefined?b:this.getFromPrim(this.target,a)]]},setAttr:function(l){var f=l.length,h=[],b,e,o,q,p,n,m,d,c,k,g,a;for(d=0;d<f;d++){b=l[d].attrs;for(e in b){o=b[e];a=o.length;for(c=0;c<a;c++){p=o[c][0];q=o[c][1];if(e==="translate"||e==="translation"){m={x:q.x,y:q.y}}else{if(e==="rotate"||e==="rotation"){k=q.x;if(isNaN(k)){k=null}g=q.y;if(isNaN(g)){g=null}m={degrees:q.degrees,x:k,y:g}}else{if(e==="scale"||e==="scaling"){k=q.x;if(isNaN(k)){k=null}g=q.y;if(isNaN(g)){g=null}m={x:k,y:g,cx:q.cx,cy:q.cy}}else{if(e==="width"||e==="height"||e==="x"||e==="y"){m=parseFloat(q)}else{m=q}}}}n=Ext.Array.indexOf(h,p);if(n==-1){h.push([p,{}]);n=h.length-1}h[n][1][e]=m}}}f=h.length;for(d=0;d<f;d++){h[d][0].setAttributes(h[d][1])}this.target.redraw()}});Ext.define("Ext.fx.target.CompositeSprite",{extend:"Ext.fx.target.Sprite",getAttr:function(a,g){var b=[],f=[].concat(this.target.items),e=f.length,d,c;for(d=0;d<e;d++){c=f[d];b.push([c,g!=undefined?g:this.getFromPrim(c,a)])}return b}});Ext.define("Ext.fx.target.Component",{extend:"Ext.fx.target.Target",type:"component",getPropMethod:{top:function(){return this.getPosition(true)[1]},left:function(){return this.getPosition(true)[0]},x:function(){return this.getPosition()[0]},y:function(){return this.getPosition()[1]},height:function(){return this.getHeight()},width:function(){return this.getWidth()},opacity:function(){return this.el.getStyle("opacity")}},compMethod:{top:"setPosition",left:"setPosition",x:"setPagePosition",y:"setPagePosition",height:"setSize",width:"setSize",opacity:"setOpacity"},getAttr:function(a,b){return[[this.target,b!==undefined?b:this.getPropMethod[a].call(this.target)]]},setAttr:function(s,e,b){var q=this,l=q.target,p=s.length,u,m,a,f,d,n,k,c,r,t,g;for(f=0;f<p;f++){u=s[f].attrs;for(m in u){k=u[m].length;n={setPosition:{},setPagePosition:{},setSize:{},setOpacity:{}};for(d=0;d<k;d++){a=u[m][d];n[q.compMethod[m]].target=a[0];n[q.compMethod[m]][m]=a[1]}if(n.setPosition.target){a=n.setPosition;c=(a.left===undefined)?undefined:parseFloat(a.left);r=(a.top===undefined)?undefined:parseFloat(a.top);a.target.setPosition(c,r)}if(n.setPagePosition.target){a=n.setPagePosition;a.target.setPagePosition(a.x,a.y)}if(n.setSize.target){a=n.setSize;t=(a.width===undefined)?a.target.getWidth():parseFloat(a.width);g=(a.height===undefined)?a.target.getHeight():parseFloat(a.height);if(b||q.dynamic){a.target.setSize(t,g)}else{a.target.el.setSize(t,g)}}if(n.setOpacity.target){a=n.setOpacity;a.target.el.setStyle("opacity",a.opacity)}}}}});Ext.define("Ext.fx.Manager",{singleton:true,requires:["Ext.util.MixedCollection","Ext.fx.target.Element","Ext.fx.target.ElementCSS","Ext.fx.target.CompositeElement","Ext.fx.target.CompositeElementCSS","Ext.fx.target.Sprite","Ext.fx.target.CompositeSprite","Ext.fx.target.Component"],mixins:{queue:"Ext.fx.Queue"},constructor:function(){this.items=new Ext.util.MixedCollection();this.mixins.queue.constructor.call(this)},interval:16,forceJS:true,createTarget:function(d){var b=this,c=!b.forceJS&&Ext.supports.Transitions,a;b.useCSS3=c;if(d){if(d.tagName||Ext.isString(d)||d.isFly){d=Ext.get(d);a=new Ext.fx.target["Element"+(c?"CSS":"")](d)}else{if(d.dom){a=new Ext.fx.target["Element"+(c?"CSS":"")](d)}else{if(d.isComposite){a=new Ext.fx.target["CompositeElement"+(c?"CSS":"")](d)}else{if(d.isSprite){a=new Ext.fx.target.Sprite(d)}else{if(d.isCompositeSprite){a=new Ext.fx.target.CompositeSprite(d)}else{if(d.isComponent){a=new Ext.fx.target.Component(d)}else{if(d.isAnimTarget){return d}else{return null}}}}}}}b.targets.add(a);return a}else{return null}},addAnim:function(c){var b=this.items,a=this.task;b.add(c.id,c);if(!a&&b.length){a=this.task={run:this.runner,interval:this.interval,scope:this};Ext.TaskManager.start(a)}},removeAnim:function(d){var c=this,b=c.items,a=c.task;b.removeAtKey(d.id);if(a&&!b.length){Ext.TaskManager.stop(a);delete c.task}},runner:function(){var d=this,b=d.items.getRange(),c=0,a=b.length,e;d.targetArr={};d.timestamp=new Date();for(;c<a;c++){e=b[c];if(e.isReady()){d.startAnim(e)}}for(c=0;c<a;c++){e=b[c];if(e.isRunning()){d.runAnim(e)}}d.applyPendingAttrs()},startAnim:function(a){a.start(this.timestamp)},runAnim:function(e){if(!e){return}var d=this,b=e.target.getId(),g=d.useCSS3&&e.target.type=="element",a=d.timestamp-e.startTime,c=(a>=e.duration),f,h;f=this.collectTargetData(e,a,g,c);if(g){e.target.setAttr(f.anims[e.id].attributes,true);d.collectTargetData(e,e.duration,g,c);e.paused=true;f=e.target.target;if(e.target.isComposite){f=e.target.target.last()}h={};h[Ext.supports.CSS3TransitionEnd]=e.lastFrame;h.scope=e;h.single=true;f.on(h)}},collectTargetData:function(c,a,e,f){var b=c.target.getId(),d=this.targetArr[b];if(!d){d=this.targetArr[b]={id:b,el:c.target,anims:{}}}d.anims[c.id]={id:c.id,anim:c,elapsed:a,isLastFrame:f,attributes:[{duration:c.duration,easing:(e&&c.reverse)?c.easingFn.reverse().toCSS3():c.easing,attrs:c.runAnim(a)}]};return d},applyPendingAttrs:function(){var e=this.targetArr,f,c,b,d,a;for(c in e){if(e.hasOwnProperty(c)){f=e[c];for(a in f.anims){if(f.anims.hasOwnProperty(a)){b=f.anims[a];d=b.anim;if(b.attributes&&d.isRunning()){f.el.setAttr(b.attributes,false,b.isLastFrame);if(b.isLastFrame){d.lastFrame()}}}}}}}});Ext.define("Ext.fx.Animator",{mixins:{observable:"Ext.util.Observable"},requires:["Ext.fx.Manager"],isAnimator:true,duration:250,delay:0,delayStart:0,dynamic:false,easing:"ease",running:false,paused:false,damper:1,iterations:1,currentIteration:0,keyframeStep:0,animKeyFramesRE:/^(from|to|\d+%?)$/,constructor:function(a){var b=this;a=Ext.apply(b,a||{});b.config=a;b.id=Ext.id(null,"ext-animator-");b.addEvents("beforeanimate","keyframe","afteranimate");b.mixins.observable.constructor.call(b,a);b.timeline=[];b.createTimeline(b.keyframes);if(b.target){b.applyAnimator(b.target);Ext.fx.Manager.addAnim(b)}},sorter:function(d,c){return d.pct-c.pct},createTimeline:function(f){var j=this,m=[],k=j.to||{},c=j.duration,n,a,e,h,l,b,d,g;for(l in f){if(f.hasOwnProperty(l)&&j.animKeyFramesRE.test(l)){g={attrs:Ext.apply(f[l],k)};if(l=="from"){l=0}else{if(l=="to"){l=100}}g.pct=parseInt(l,10);m.push(g)}}Ext.Array.sort(m,j.sorter);h=m.length;for(e=0;e<h;e++){n=(m[e-1])?c*(m[e-1].pct/100):0;a=c*(m[e].pct/100);j.timeline.push({duration:a-n,attrs:m[e].attrs})}},applyAnimator:function(e){var j=this,k=[],n=j.timeline,f=j.reverse,h=n.length,b,g,a,d,m,l,c;if(j.fireEvent("beforeanimate",j)!==false){for(c=0;c<h;c++){b=n[c];m=b.attrs;g=m.easing||j.easing;a=m.damper||j.damper;delete m.easing;delete m.damper;b=new Ext.fx.Anim({target:e,easing:g,damper:a,duration:b.duration,paused:true,to:m});k.push(b)}j.animations=k;j.target=b.target;for(c=0;c<h-1;c++){b=k[c];b.nextAnim=k[c+1];b.on("afteranimate",function(){this.nextAnim.paused=false});b.on("afteranimate",function(){this.fireEvent("keyframe",this,++this.keyframeStep)},j)}k[h-1].on("afteranimate",function(){this.lastFrame()},j)}},start:function(d){var e=this,c=e.delay,b=e.delayStart,a;if(c){if(!b){e.delayStart=d;return}else{a=d-b;if(a<c){return}else{d=new Date(b.getTime()+c)}}}if(e.fireEvent("beforeanimate",e)!==false){e.startTime=d;e.running=true;e.animations[e.keyframeStep].paused=false}},lastFrame:function(){var c=this,a=c.iterations,b=c.currentIteration;b++;if(b<a){c.startTime=new Date();c.currentIteration=b;c.keyframeStep=0;c.applyAnimator(c.target);c.animations[c.keyframeStep].paused=false}else{c.currentIteration=0;c.end()}},end:function(){var a=this;a.fireEvent("afteranimate",a,a.startTime,new Date()-a.startTime)},isReady:function(){return this.paused===false&&this.running===false&&this.iterations>0},isRunning:function(){return false}});Ext.define("Ext.fx.Anim",{mixins:{observable:"Ext.util.Observable"},requires:["Ext.fx.Manager","Ext.fx.Animator","Ext.fx.Easing","Ext.fx.CubicBezier","Ext.fx.PropertyHandler"],isAnimation:true,duration:250,delay:0,delayStart:0,dynamic:false,easing:"ease",damper:1,bezierRE:/^(?:cubic-)?bezier\(([^,]+),([^,]+),([^,]+),([^\)]+)\)/,reverse:false,running:false,paused:false,iterations:1,alternate:false,currentIteration:0,startTime:0,frameCount:0,constructor:function(a){var b=this,c;a=a||{};if(a.keyframes){return new Ext.fx.Animator(a)}Ext.apply(b,a);if(b.from===undefined){b.from={}}b.propHandlers={};b.config=a;b.target=Ext.fx.Manager.createTarget(b.target);b.easingFn=Ext.fx.Easing[b.easing];b.target.dynamic=b.dynamic;if(!b.easingFn){b.easingFn=String(b.easing).match(b.bezierRE);if(b.easingFn&&b.easingFn.length==5){c=b.easingFn;b.easingFn=Ext.fx.CubicBezier.cubicBezier(+c[1],+c[2],+c[3],+c[4])}}b.id=Ext.id(null,"ext-anim-");b.addEvents("beforeanimate","afteranimate","lastframe");b.mixins.observable.constructor.call(b);Ext.fx.Manager.addAnim(b)},setAttr:function(a,b){return Ext.fx.Manager.items.get(this.id).setAttr(this.target,a,b)},initAttrs:function(){var e=this,g=e.from,h=e.to,f=e.initialFrom||{},c={},a,b,i,d;for(d in h){if(h.hasOwnProperty(d)){a=e.target.getAttr(d,g[d]);b=h[d];if(!Ext.fx.PropertyHandler[d]){if(Ext.isObject(b)){i=e.propHandlers[d]=Ext.fx.PropertyHandler.object}else{i=e.propHandlers[d]=Ext.fx.PropertyHandler.defaultHandler}}else{i=e.propHandlers[d]=Ext.fx.PropertyHandler[d]}c[d]=i.get(a,b,e.damper,f[d],d)}}e.currentAttrs=c},start:function(d){var e=this,c=e.delay,b=e.delayStart,a;if(c){if(!b){e.delayStart=d;return}else{a=d-b;if(a<c){return}else{d=new Date(b.getTime()+c)}}}if(e.fireEvent("beforeanimate",e)!==false){e.startTime=d;if(!e.paused&&!e.currentAttrs){e.initAttrs()}e.running=true;e.frameCount=0}},runAnim:function(k){var h=this,j=h.currentAttrs,d=h.duration,c=h.easingFn,b=h.propHandlers,f={},g,i,e,a;if(k>=d){k=d;a=true}if(h.reverse){k=d-k}for(e in j){if(j.hasOwnProperty(e)){i=j[e];g=a?1:c(k/d);f[e]=b[e].set(i,g)}}h.frameCount++;return f},lastFrame:function(){var c=this,a=c.iterations,b=c.currentIteration;b++;if(b<a){if(c.alternate){c.reverse=!c.reverse}c.startTime=new Date();c.currentIteration=b;c.paused=false}else{c.currentIteration=0;c.end();c.fireEvent("lastframe",c,c.startTime)}},endWasCalled:0,end:function(){if(this.endWasCalled++){return}var a=this;a.startTime=0;a.paused=false;a.running=false;Ext.fx.Manager.removeAnim(a);a.fireEvent("afteranimate",a,a.startTime);Ext.callback(a.callback,a.scope,[a,a.startTime])},isReady:function(){return this.paused===false&&this.running===false&&this.iterations>0},isRunning:function(){return this.paused===false&&this.running===true&&this.isAnimator!==true}});Ext.enableFx=true;Ext.define("Ext.chart.Highlight",{requires:["Ext.fx.Anim"],highlight:false,highlightCfg:{fill:"#fdd","stroke-width":5,stroke:"#f55"},constructor:function(a){if(a.highlight){if(a.highlight!==true){this.highlightCfg=Ext.merge(this.highlightCfg,a.highlight)}}},highlightItem:function(j){if(!j){return}var f=this,i=j.sprite,a=Ext.merge({},f.highlightCfg,f.highlight),d=f.chart.surface,c=f.chart.animate,b,h,g,e;if(!f.highlight||!i||i._highlighted){return}if(i._anim){i._anim.paused=true}i._highlighted=true;if(!i._defaults){i._defaults=Ext.apply({},i.attr);h={};g={};for(b in a){if(!(b in i._defaults)){i._defaults[b]=d.availableAttrs[b]}h[b]=i._defaults[b];g[b]=a[b];if(Ext.isObject(a[b])){h[b]={};g[b]={};Ext.apply(i._defaults[b],i.attr[b]);Ext.apply(h[b],i._defaults[b]);for(e in i._defaults[b]){if(!(e in a[b])){g[b][e]=h[b][e]}else{g[b][e]=a[b][e]}}for(e in a[b]){if(!(e in g[b])){g[b][e]=a[b][e]}}}}i._from=h;i._to=g;i._endStyle=g}if(c){i._anim=new Ext.fx.Anim({target:i,from:i._from,to:i._to,duration:150})}else{i.setAttributes(i._to,true)}},unHighlightItem:function(){if(!this.highlight||!this.items){return}var h=this,g=h.items,f=g.length,a=Ext.merge({},h.highlightCfg,h.highlight),c=h.chart.animate,e=0,d,b,j;for(;e<f;e++){if(!g[e]){continue}j=g[e].sprite;if(j&&j._highlighted){if(j._anim){j._anim.paused=true}d={};for(b in a){if(Ext.isObject(j._defaults[b])){d[b]={};Ext.apply(d[b],j._defaults[b])}else{d[b]=j._defaults[b]}}if(c){j._endStyle=d;j._anim=new Ext.fx.Anim({target:j,to:d,duration:150})}else{j.setAttributes(d,true)}delete j._highlighted}}},cleanHighlights:function(){if(!this.highlight){return}var d=this.group,c=this.markerGroup,b=0,a;for(a=d.getCount();b<a;b++){delete d.getAt(b)._defaults}if(c){for(a=c.getCount();b<a;b++){delete c.getAt(b)._defaults}}}});Ext.define("Ext.Ajax",{extend:"Ext.data.Connection",singleton:true,autoAbort:false});Ext.define("Ext.data.proxy.Ajax",{requires:["Ext.util.MixedCollection","Ext.Ajax"],extend:"Ext.data.proxy.Server",alias:"proxy.ajax",alternateClassName:["Ext.data.HttpProxy","Ext.data.AjaxProxy"],actionMethods:{create:"POST",read:"GET",update:"POST",destroy:"POST"},doRequest:function(a,e,b){var d=this.getWriter(),c=this.buildRequest(a,e,b);if(a.allowWrite()){c=d.write(c)}Ext.apply(c,{headers:this.headers,timeout:this.timeout,scope:this,callback:this.createRequestCallback(c,a,e,b),method:this.getMethod(c),disableCaching:false});Ext.Ajax.request(c);return c},getMethod:function(a){return this.actionMethods[a.action]},createRequestCallback:function(d,a,e,b){var c=this;return function(g,h,f){c.processResponse(h,a,d,f,e,b)}}},function(){Ext.data.HttpProxy=this});Ext.define("Ext.data.reader.Reader",{requires:["Ext.data.ResultSet","Ext.XTemplate"],alternateClassName:["Ext.data.Reader","Ext.data.DataReader"],mixins:{observable:"Ext.util.Observable"},totalProperty:"total",successProperty:"success",root:"",implicitIncludes:true,readRecordsOnFailure:true,isReader:true,applyDefaults:true,lastFieldGeneration:null,constructor:function(a){var b=this;b.mixins.observable.constructor.call(b,a);b.fieldCount=0;b.model=Ext.ModelManager.getModel(b.model);b.accessExpressionFn=Ext.Function.bind(b.createFieldAccessExpression,b);if(b.model&&b.model.prototype.fields){b.buildExtractors()}this.addEvents("exception")},setModel:function(a,c){var b=this;b.model=Ext.ModelManager.getModel(a);b.buildExtractors(true);if(c&&b.proxy){b.proxy.setModel(b.model,true)}},read:function(a){var b;if(a){b=a.responseText?this.getResponseData(a):this.readRecords(a)}return b||this.nullResultSet},readRecords:function(c){var d=this,h,b,a,f,e,g,i;if(d.lastFieldGeneration!==d.model.prototype.fields.generation){d.buildExtractors(true)}d.rawData=c;c=d.getData(c);h=true;b=0;a=[];if(d.successProperty){g=d.getSuccess(c);if(g===false||g==="false"){h=false}}if(d.messageProperty){i=d.getMessage(c)}if(d.readRecordsOnFailure||h){f=Ext.isArray(c)?c:d.getRoot(c);if(f){e=f.length}if(d.totalProperty){g=parseInt(d.getTotal(c),10);if(!isNaN(g)){e=g}}if(f){a=d.extractData(f);b=a.length}}return new Ext.data.ResultSet({total:e||b,count:b,records:a,success:h,message:i})},extractData:function(j){var h=this,d=[],b=h.model,a=j.length,e,c,g,f;if(!j.length&&Ext.isObject(j)){j=[j];a=1}for(f=0;f<a;f++){c=j[f];if(!c.isModel){g=new b(undefined,h.getId(c),c,e={});g.phantom=false;h.convertRecordData(e,c,g);d.push(g);if(h.implicitIncludes){h.readAssociated(g,c)}}else{d.push(c)}}return d},readAssociated:function(g,e){var d=g.associations.items,f=0,a=d.length,c,b,j,h;for(;f<a;f++){c=d[f];b=this.getAssociatedDataRoot(e,c.associationKey||c.name);if(b){h=c.getReader();if(!h){j=c.associatedModel.proxy;if(j){h=j.getReader()}else{h=new this.constructor({model:c.associatedName})}}c.read(g,h,b)}}},getAssociatedDataRoot:function(b,a){return b[a]},getFields:function(){return this.model.prototype.fields.items},getData:function(a){return a},getRoot:function(a){return a},getResponseData:function(a){},onMetaChange:function(e){var d=this,b=e.fields||d.getFields(),c,a;d.metaData=e;d.root=e.root||d.root;d.idProperty=e.idProperty||d.idProperty;d.totalProperty=e.totalProperty||d.totalProperty;d.successProperty=e.successProperty||d.successProperty;d.messageProperty=e.messageProperty||d.messageProperty;a=e.clientIdProperty;if(d.model){d.model.setFields(b,d.idProperty,a);d.setModel(d.model,true)}else{c=Ext.define("Ext.data.reader.Json-Model"+Ext.id(),{extend:"Ext.data.Model",fields:b,clientIdProperty:a});if(d.idProperty){c.idProperty=d.idProperty}d.setModel(c,true)}},getIdProperty:function(){return this.idProperty||this.model.prototype.idProperty},buildExtractors:function(b){var f=this,i=f.getIdProperty(),h=f.totalProperty,e=f.successProperty,g=f.messageProperty,d,c,a;if(b===true){delete f.convertRecordData}if(f.convertRecordData){return}if(h){f.getTotal=f.createAccessor(h)}if(e){f.getSuccess=f.createAccessor(e)}if(g){f.getMessage=f.createAccessor(g)}if(i){c=f.model.prototype.fields.get(i);if(c){a=c.mapping;i=(a!==undefined&&a!==null)?a:i}d=f.createAccessor(i);f.getId=function(j){var k=d.call(f,j);return(k===undefined||k==="")?null:k}}else{f.getId=function(){return null}}f.convertRecordData=f.buildRecordDataExtractor();f.lastFieldGeneration=f.model.prototype.fields.generation},recordDataExtractorTemplate:["var me = this\n","    ,fields = me.model.prototype.fields\n","    ,value\n","    ,internalId\n",'<tpl for="fields">','    ,__field{#} = fields.get("{name}")\n',"</tpl>",";\n","return function(dest, source, record) {\n",'<tpl for="fields">','    value = {[ this.createFieldAccessExpression(values, "__field" + xindex, "source") ]};\n','<tpl if="hasCustomConvert">','    dest["{name}"] = value === undefined ? __field{#}.convert(__field{#}.defaultValue, record) : __field{#}.convert(value, record);\n','<tpl elseif="defaultValue !== undefined">',"    if (value === undefined) {\n","        if (me.applyDefaults) {\n",'<tpl if="convert">','            dest["{name}"] = __field{#}.convert(__field{#}.defaultValue, record);\n',"<tpl else>",'            dest["{name}"] = __field{#}.defaultValue\n',"</tpl>","        };\n","    } else {\n",'<tpl if="convert">','        dest["{name}"] = __field{#}.convert(value, record);\n',"<tpl else>",'        dest["{name}"] = value;\n',"</tpl>","    };","<tpl else>","    if (value !== undefined) {\n",'<tpl if="convert">','        dest["{name}"] = __field{#}.convert(value, record);\n',"<tpl else>",'        dest["{name}"] = value;\n',"</tpl>","    }\n","</tpl>","</tpl>",'<tpl if="clientIdProp">','    if (record && (internalId = {[ this.createFieldAccessExpression({mapping: values.clientIdProp}, null, "source") ]})) {\n','        record.{["internalId"]} = internalId;\n',"    }\n","</tpl>","};"],buildRecordDataExtractor:function(){var c=this,a=c.model.prototype,b={clientIdProp:a.clientIdProperty,fields:a.fields.items};c.recordDataExtractorTemplate.createFieldAccessExpression=c.accessExpressionFn;return Ext.functionFactory(c.recordDataExtractorTemplate.apply(b)).call(c)},destroyReader:function(){var a=this;delete a.proxy;delete a.model;delete a.convertRecordData;delete a.getId;delete a.getTotal;delete a.getSuccess;delete a.getMessage}},function(){var a=this.prototype;Ext.apply(a,{nullResultSet:new Ext.data.ResultSet({total:0,count:0,records:[],success:true}),recordDataExtractorTemplate:new Ext.XTemplate(a.recordDataExtractorTemplate)})});Ext.define("Ext.data.reader.Json",{extend:"Ext.data.reader.Reader",alternateClassName:"Ext.data.JsonReader",alias:"reader.json",root:"",useSimpleAccessors:false,readRecords:function(a){if(a.metaData){this.onMetaChange(a.metaData)}this.jsonData=a;return this.callParent([a])},getResponseData:function(a){var d,b;try{d=Ext.decode(a.responseText);return this.readRecords(d)}catch(c){b=new Ext.data.ResultSet({total:0,count:0,records:[],success:false,message:c.message});this.fireEvent("exception",this,a,b);Ext.Logger.warn("Unable to parse the JSON returned by the server");return b}},buildExtractors:function(){var a=this;a.callParent(arguments);if(a.root){a.getRoot=a.createAccessor(a.root)}else{a.getRoot=function(b){return b}}},extractData:function(a){var e=this.record,d=[],c,b;if(e){c=a.length;if(!c&&Ext.isObject(a)){c=1;a=[a]}for(b=0;b<c;b++){d[b]=a[b][e]}}else{d=a}return this.callParent([d])},createAccessor:(function(){var a=/[\[\.]/;return function(c){if(Ext.isEmpty(c)){return Ext.emptyFn}if(Ext.isFunction(c)){return c}if(this.useSimpleAccessors!==true){var b=String(c).search(a);if(b>=0){return Ext.functionFactory("obj","return obj"+(b>0?".":"")+c)}}return function(d){return d[c]}}}()),createFieldAccessExpression:(function(){var a=/[\[\.]/;return function(h,d,c){var e=this,f=(h.mapping!==null),g=f?h.mapping:h.name,b,i;if(typeof g==="function"){b=d+".mapping("+c+", this)"}else{if(this.useSimpleAccessors===true||((i=String(g).search(a))<0)){if(!f||isNaN(g)){g='"'+g+'"'}b=c+"["+g+"]"}else{b=c+(i>0?".":"")+g}}return b}}())});Ext.define("Ext.data.Store",{extend:"Ext.data.AbstractStore",alias:"store.store",requires:["Ext.data.StoreManager","Ext.data.Model","Ext.data.proxy.Ajax","Ext.data.proxy.Memory","Ext.data.reader.Json","Ext.data.writer.Json","Ext.util.LruCache"],uses:["Ext.ModelManager","Ext.util.Grouper"],remoteSort:false,remoteFilter:false,remoteGroup:false,groupField:undefined,groupDir:"ASC",trailingBufferZone:25,leadingBufferZone:200,pageSize:undefined,currentPage:1,clearOnPageLoad:true,loading:false,sortOnFilter:true,buffered:false,purgePageCount:5,clearRemovedOnLoad:true,defaultPageSize:25,addRecordsOptions:{addRecords:true},statics:{recordIdFn:function(a){return a.internalId},recordIndexFn:function(a){return a.index}},onClassExtended:function(b,d,a){var c=d.model,e;if(typeof c=="string"){e=a.onBeforeCreated;a.onBeforeCreated=function(){var g=this,f=arguments;Ext.require(c,function(){e.apply(g,f)})}}},constructor:function(b){b=Ext.Object.merge({},b);var d=this,f=b.groupers||d.groupers,a=b.groupField||d.groupField,c,e;e=b.data||d.data;d.data=new Ext.util.MixedCollection(false,Ext.data.Store.recordIdFn);if(e){d.inlineData=e;delete b.data}if(!f&&a){f=[{property:a,direction:b.groupDir||d.groupDir}]}delete b.groupers;d.groupers=new Ext.util.MixedCollection();d.groupers.addAll(d.decodeGroupers(f));this.callParent([b]);if(d.buffered){d.pageMap=new d.PageMap({pageSize:d.pageSize,maxSize:d.purgePageCount,listeners:{clear:d.cancelAllPrefetches,scope:d}});d.pageRequests={};d.sortOnLoad=false;d.filterOnLoad=false}if(d.remoteGroup){d.remoteSort=true}if(d.groupers.items.length&&!d.remoteGroup){d.sort(d.groupers.items,"prepend",false)}c=d.proxy;e=d.inlineData;if(!d.buffered&&!d.pageSize){d.pageSize=d.defaultPageSize}if(e){if(c instanceof Ext.data.proxy.Memory){c.data=e;d.read()}else{d.add.apply(d,[e])}d.sort();delete d.inlineData}else{if(d.autoLoad){Ext.defer(d.load,10,d,[typeof d.autoLoad==="object"?d.autoLoad:undefined])}}},destroyStore:function(){this.callParent(arguments);if(this.pageMap){this.pageMap.clear()}},onBeforeSort:function(){var a=this.groupers;if(a.getCount()>0){this.sort(a.items,"prepend",false)}},decodeGroupers:function(e){if(!Ext.isArray(e)){if(e===undefined){e=[]}else{e=[e]}}var d=e.length,f=Ext.util.Grouper,b,c,a=[];for(c=0;c<d;c++){b=e[c];if(!(b instanceof f)){if(Ext.isString(b)){b={property:b}}b=Ext.apply({root:"data",direction:"ASC"},b);if(b.fn){b.sorterFn=b.fn}if(typeof b=="function"){b={sorterFn:b}}a.push(new f(b))}else{a.push(b)}}return a},group:function(e,f){var d=this,c=false,b,a;if(Ext.isArray(e)){a=e}else{if(Ext.isObject(e)){a=[e]}else{if(Ext.isString(e)){b=d.groupers.get(e);if(!b){b={property:e,direction:f};a=[b]}else{if(f===undefined){b.toggle()}else{b.setDirection(f)}}}}}if(a&&a.length){c=true;a=d.decodeGroupers(a);d.groupers.clear();d.groupers.addAll(a)}if(d.remoteGroup){if(d.buffered){d.pageMap.clear();d.loadPage(1,{groupChange:true})}else{d.load({scope:d,callback:d.fireGroupChange})}}else{d.sort(null,null,null,c);d.fireGroupChange()}},clearGrouping:function(){var d=this,e=d.groupers.items,c=e.length,a,b;for(b=0;b<c;b++){a=e[b];d.sorters.remove(a)}d.groupers.clear();if(d.remoteGroup){if(d.buffered){d.pageMap.clear();d.loadPage(1,{groupChange:true})}else{d.load({scope:d,callback:d.fireGroupChange})}}else{d.sort();d.fireGroupChange()}},isGrouped:function(){return this.groupers.getCount()>0},fireGroupChange:function(){this.fireEvent("groupchange",this,this.groupers)},getGroups:function(b){var d=this.data.items,a=d.length,c=[],j={},f,g,h,e;for(e=0;e<a;e++){f=d[e];g=this.getGroupString(f);h=j[g];if(h===undefined){h={name:g,children:[]};c.push(h);j[g]=h}h.children.push(f)}return b?j[b]:c},getGroupsForGrouper:function(f,b){var d=f.length,e=[],a,c,h,j,g;for(g=0;g<d;g++){h=f[g];c=b.getGroupString(h);if(c!==a){j={name:c,grouper:b,records:[]};e.push(j)}j.records.push(h);a=c}return e},getGroupsForGrouperIndex:function(c,h){var f=this,g=f.groupers,b=g.getAt(h),a=f.getGroupsForGrouper(c,b),e=a.length,d;if(h+1<g.length){for(d=0;d<e;d++){a[d].children=f.getGroupsForGrouperIndex(a[d].records,h+1)}}for(d=0;d<e;d++){a[d].depth=h}return a},getGroupData:function(a){var b=this;if(a!==false){b.sort()}return b.getGroupsForGrouperIndex(b.data.items,0)},getGroupString:function(a){var b=this.groupers.first();if(b){return a.get(b.property)}return""},insert:function(d,c){var g=this,f=false,e,b,a;c=[].concat(c);for(e=0,a=c.length;e<a;e++){b=g.createModel(c[e]);b.set(g.modelDefaults);c[e]=b;g.data.insert(d+e,b);b.join(g);f=f||b.phantom===true}if(g.snapshot){g.snapshot.addAll(c)}if(g.requireSort){g.suspendEvents();g.sort();g.resumeEvents()}g.fireEvent("add",g,c,d);g.fireEvent("datachanged",g);if(g.autoSync&&f&&!g.autoSyncSuspended){g.sync()}},add:function(b){if(!Ext.isArray(b)){b=Array.prototype.slice.apply(arguments)}else{b=b.slice(0)}var e=this,c=0,d=b.length,a,f=!e.remoteSort&&e.sorters&&e.sorters.items.length;if(f&&d===1){return[e.addSorted(e.createModel(b[0]))]}for(;c<d;c++){a=e.createModel(b[c]);b[c]=a}if(f){e.requireSort=true}e.insert(e.data.length,b);delete e.requireSort;return b},addSorted:function(a){var c=this,b=c.data.findInsertionIndex(a,c.generateComparator());c.insert(b,a);return a},createModel:function(a){if(!a.isModel){a=Ext.ModelManager.create(a,this.model)}return a},each:function(e,c){var f=this.data.items,b=f.length,a,g;for(g=0;g<b;g++){a=f[g];if(e.call(c||a,a,g,b)===false){break}}},remove:function(c,j){if(!Ext.isArray(c)){c=[c]}j=j===true;var g=this,h=false,d=0,a=c.length,b,f,e;for(;d<a;d++){e=c[d];f=g.data.indexOf(e);if(g.snapshot){g.snapshot.remove(e)}if(f>-1){b=e.phantom!==true;if(!j&&b){e.removedFrom=f;g.removed.push(e)}e.unjoin(g);g.data.remove(e);h=h||b;g.fireEvent("remove",g,e,f)}}g.fireEvent("datachanged",g);if(!j&&g.autoSync&&h&&!g.autoSyncSuspended){g.sync()}},removeAt:function(b){var a=this.getAt(b);if(a){this.remove(a)}},load:function(a){var b=this;a=a||{};if(typeof a=="function"){a={callback:a}}a.groupers=a.groupers||b.groupers.items;a.page=a.page||b.currentPage;a.start=(a.start!==undefined)?a.start:(a.page-1)*b.pageSize;a.limit=a.limit||b.pageSize;a.addRecords=a.addRecords||false;if(b.buffered){return b.loadToPrefetch(a)}return b.callParent([a])},reload:function(k){var f=this,g,b,e,j,d,a,h,c;if(!k){k={}}if(f.buffered){delete f.totalCount;a=function(){if(f.rangeCached(g,b)){f.loading=false;f.pageMap.un("pageAdded",a);c=f.pageMap.getRange(g,b);f.loadRecords(c,{start:g});f.fireEvent("load",f,c,true)}};h=Math.ceil((f.leadingBufferZone+f.trailingBufferZone)/2);g=k.start||f.getAt(0).index;b=g+(k.count||f.getCount())-1;e=f.getPageFromRecordIndex(Math.max(g-h,0));j=f.getPageFromRecordIndex(b+h);f.pageMap.clear(true);if(f.fireEvent("beforeload",f,k)!==false){f.loading=true;for(d=e;d<=j;d++){f.prefetchPage(d,k)}f.pageMap.on("pageAdded",a)}}else{return f.callParent(arguments)}},onProxyLoad:function(b){var d=this,c=b.getResultSet(),a=b.getRecords(),e=b.wasSuccessful();if(c){d.totalCount=c.total}if(e){d.loadRecords(a,b)}d.loading=false;if(d.hasListeners.load){d.fireEvent("load",d,a,e)}if(d.hasListeners.read){d.fireEvent("read",d,a,e)}Ext.callback(b.callback,b.scope||d,[a,b,e])},getNewRecords:function(){return this.data.filterBy(this.filterNew).items},getUpdatedRecords:function(){return this.data.filterBy(this.filterUpdated).items},filter:function(e,f){if(Ext.isString(e)){e={property:e,value:f}}var d=this,a=d.decodeFilters(e),b=0,g=d.sorters.length&&d.sortOnFilter&&!d.remoteSort,c=a.length;for(;b<c;b++){d.filters.replace(a[b])}if(d.remoteFilter){delete d.totalCount;if(d.buffered){d.pageMap.clear();d.loadPage(1)}else{d.currentPage=1;d.load()}}else{if(d.filters.getCount()){d.snapshot=d.snapshot||d.data.clone();d.data=d.data.filter(d.filters.items);if(g){d.sort()}else{d.fireEvent("datachanged",d);d.fireEvent("refresh",d)}}}},clearFilter:function(a){var b=this;b.filters.clear();if(b.remoteFilter){if(a){return}delete b.totalCount;if(b.buffered){b.pageMap.clear();b.loadPage(1)}else{b.currentPage=1;b.load()}}else{if(b.isFiltered()){b.data=b.snapshot.clone();delete b.snapshot;if(a!==true){b.fireEvent("datachanged",b);b.fireEvent("refresh",b)}}}},isFiltered:function(){var a=this.snapshot;return !!a&&a!==this.data},filterBy:function(b,a){var c=this;c.snapshot=c.snapshot||c.data.clone();c.data=c.queryBy(b,a||c);c.fireEvent("datachanged",c);c.fireEvent("refresh",c)},queryBy:function(b,a){var c=this,d=c.snapshot||c.data;return d.filterBy(b,a||c)},query:function(g,f,h,a,e){var d=this,b=d.createFilterFn(g,f,h,a,e),c=d.queryBy(b);if(!c){c=new Ext.util.MixedCollection()}return c},loadData:function(h,a){var g=this,c=g.model,f=h.length,e=[],d,b;for(d=0;d<f;d++){b=h[d];if(!(b.isModel)){b=Ext.ModelManager.create(b,c)}e.push(b)}g.loadRecords(e,a?g.addRecordsOptions:undefined)},loadRawData:function(e,b){var d=this,a=d.proxy.reader.read(e),c=a.records;if(a.success){d.totalCount=a.total;d.loadRecords(c,b?d.addRecordsOptions:undefined);d.fireEvent("load",d,c,true)}},loadRecords:function(b,c){var g=this,d=0,f=b.length,h,e,a=g.snapshot;if(c){h=c.start;e=c.addRecords}if(!e){delete g.snapshot;g.clearData(true)}else{if(a){a.addAll(b)}}g.data.addAll(b);if(h!==undefined){for(;d<f;d++){b[d].index=h+d;b[d].join(g)}}else{for(;d<f;d++){b[d].join(g)}}g.suspendEvents();if(g.filterOnLoad&&!g.remoteFilter){g.filter()}if(g.sortOnLoad&&!g.remoteSort){g.sort(undefined,undefined,undefined,true)}g.resumeEvents();g.fireEvent("datachanged",g);g.fireEvent("refresh",g)},loadPage:function(c,a){var b=this;b.currentPage=c;a=Ext.apply({page:c,start:(c-1)*b.pageSize,limit:b.pageSize,addRecords:!b.clearOnPageLoad},a);if(b.buffered){return b.loadToPrefetch(a)}b.read(a)},nextPage:function(a){this.loadPage(this.currentPage+1,a)},previousPage:function(a){this.loadPage(this.currentPage-1,a)},clearData:function(d){var c=this,a=c.data.items,b=a.length;while(b--){a[b].unjoin(c)}c.data.clear();if(d!==true||c.clearRemovedOnLoad){c.removed.length=0}},loadToPrefetch:function(k){var g=this,d,b,h=k.start,a=k.start+k.limit-1,e=k.start+(g.viewSize||k.limit)-1,f=g.getPageFromRecordIndex(Math.max(h-g.trailingBufferZone,0)),j=g.getPageFromRecordIndex(a+g.leadingBufferZone),c=function(){if(g.rangeCached(h,e)){g.loading=false;b=g.pageMap.getRange(h,e);g.pageMap.un("pageAdded",c);if(g.hasListeners.guaranteedrange){g.guaranteeRange(h,e,k.callback,k.scope)}else{g.loadRecords(b,{start:h})}g.fireEvent("load",g,b,true);if(k.groupChange){g.fireGroupChange()}}};if(g.fireEvent("beforeload",g,k)!==false){delete g.totalCount;g.loading=true;g.pageMap.on("pageAdded",c);g.on("prefetch",function(){for(d=f+1;d<=j;++d){g.prefetchPage(d,k)}},null,{single:true});g.prefetchPage(f,k)}},prefetch:function(c){var e=this,a=e.pageSize,d,b;if(a){if(e.lastPageSize&&a!=e.lastPageSize){Ext.error.raise("pageSize cannot be dynamically altered")}if(!e.pageMap.pageSize){e.pageMap.pageSize=a}}else{e.pageSize=e.pageMap.pageSize=a=c.limit}e.lastPageSize=a;if(!c.page){c.page=e.getPageFromRecordIndex(c.start);c.start=(c.page-1)*a;c.limit=Math.ceil(c.limit/a)*a}if(!e.pageRequests[c.page]){c=Ext.apply({action:"read",filters:e.filters.items,sorters:e.sorters.items,groupers:e.groupers.items,generation:e.pageMap.generation},c);b=new Ext.data.Operation(c);if(e.fireEvent("beforeprefetch",e,b)!==false){e.loading=true;d=e.proxy;e.pageRequests[c.page]=d.read(b,e.onProxyPrefetch,e);if(d.isSynchronous){delete e.pageRequests[c.page]}}}return e},cancelAllPrefetches:function(){var c=this,a=c.pageRequests,b,d;if(c.pageMap.events.pageadded){c.pageMap.events.pageadded.clearListeners()}for(d in a){if(a.hasOwnProperty(d)){b=a[d];delete a[d];delete b.callback}}},prefetchPage:function(e,b){var d=this,a=d.pageSize||d.defaultPageSize,f=(e-1)*d.pageSize,c=d.totalCount;if(c!==undefined&&d.getCount()===c){return}d.prefetch(Ext.applyIf({page:e,start:f,limit:a},b))},onProxyPrefetch:function(b){var d=this,c=b.getResultSet(),a=b.getRecords(),f=b.wasSuccessful(),e=b.page;if(b.generation===d.pageMap.generation){if(c){d.totalCount=c.total;d.fireEvent("totalcountchange",d.totalCount)}if(e!==undefined){delete d.pageRequests[e]}if(f){d.cachePage(a,b.page)}d.loading=false;d.fireEvent("prefetch",d,a,f,b);Ext.callback(b.callback,b.scope||d,[a,b,f])}},cachePage:function(a,c){var b=this;if(!Ext.isDefined(b.totalCount)){b.totalCount=a.length;b.fireEvent("totalcountchange",b.totalCount)}b.pageMap.addPage(c,a)},rangeCached:function(b,a){return this.pageMap&&this.pageMap.hasRange(b,a)},pageCached:function(a){return this.pageMap&&this.pageMap.hasPage(a)},rangeSatisfied:function(b,a){return this.rangeCached(b,a)},getPageFromRecordIndex:function(a){return Math.floor(a/this.pageSize)+1},onGuaranteedRange:function(d){var e=this,b=e.getTotalCount(),f=d.prefetchStart,a=((b-1)<d.prefetchEnd)?b-1:d.prefetchEnd,c;a=Math.max(0,a);c=e.pageMap.getRange(f,a);e.fireEvent("guaranteedrange",c,f,a);if(d.cb){d.cb.call(d.scope||e,c,f,a)}},prefetchRange:function(f,b){var d=this,c,a,e;if(!d.rangeCached(f,b)){c=d.getPageFromRecordIndex(f);a=d.getPageFromRecordIndex(b);d.pageMap.maxSize=d.purgePageCount?(a-c+1)+d.purgePageCount:0;for(e=c;e<=a;e++){if(!d.pageCached(e)){d.prefetchPage(e)}}}},guaranteeRange:function(h,c,a,f){c=(c>this.totalCount)?this.totalCount-1:c;var g=this,e=g.lastRequestStart,d={prefetchStart:h,prefetchEnd:c,cb:a,scope:f},b;g.lastRequestStart=h;if(g.rangeCached(h,c)){if(h<e){h=Math.max(h-g.leadingBufferZone,0);c=Math.min(c+g.trailingBufferZone,g.totalCount-1)}else{h=Math.max(Math.min(h-g.trailingBufferZone,g.totalCount-g.pageSize),0);c=Math.min(c+g.leadingBufferZone,g.totalCount-1)}if(!g.rangeCached(h,c)){g.prefetchRange(h,c)}g.onGuaranteedRange(d)}else{g.fireEvent("cachemiss",g,h,c);h=Math.min(Math.max(Math.floor(h-((g.leadingBufferZone+g.trailingBufferZone)/2)),0),g.totalCount-g.pageSize);c=Math.min(Math.max(Math.ceil(c+((g.leadingBufferZone+g.trailingBufferZone)/2)),0),g.totalCount-1);b=function(j,i){if(g.rangeCached(d.prefetchStart,d.prefetchEnd)){g.fireEvent("cachefilled",g,h,c);g.pageMap.un("pageAdded",b);g.onGuaranteedRange(d)}};g.pageMap.on("pageAdded",b);g.prefetchRange(d.prefetchStart,d.prefetchEnd);g.prefetchRange(h,c)}},sort:function(){var b=this,a=b.pageMap;if(b.buffered){if(b.remoteSort){a.clear();b.callParent(arguments)}else{b.callParent(arguments)}}else{b.callParent(arguments)}},doSort:function(b){var e=this,a,d,c;if(e.remoteSort){if(e.buffered){e.pageMap.clear();e.loadPage(1)}else{e.load()}}else{e.data.sortBy(b);if(!e.buffered){a=e.getRange();d=a.length;for(c=0;c<d;c++){a[c].index=c}}e.fireEvent("datachanged",e);e.fireEvent("refresh",e)}},find:function(e,d,g,f,a,c){var b=this.createFilterFn(e,d,f,a,c);return b?this.data.findIndexBy(b,null,g):-1},findRecord:function(){var b=this,a=b.find.apply(b,arguments);return a!==-1?b.getAt(a):null},createFilterFn:function(d,c,e,a,b){if(Ext.isEmpty(c)){return false}c=this.data.createValueMatcher(c,e,a,b);return function(f){return c.test(f.data[d])}},findExact:function(b,a,c){return this.data.findIndexBy(function(d){return d.isEqual(d.get(b),a)},this,c)},findBy:function(b,a,c){return this.data.findIndexBy(b,a,c)},collect:function(b,a,c){var d=this,e=(c===true&&d.snapshot)?d.snapshot:d.data;return e.collect(b,"data",a)},getCount:function(){return this.data.length||0},getTotalCount:function(){return this.totalCount||0},getAt:function(a){return this.data.getAt(a)},getRange:function(b,a){return this.data.getRange(b,a)},getById:function(a){return(this.snapshot||this.data).findBy(function(b){return b.getId()===a})},indexOf:function(a){return this.data.indexOf(a)},indexOfTotal:function(a){var b=a.index;if(b||b===0){return b}return this.indexOf(a)},indexOfId:function(a){return this.indexOf(this.getById(a))},removeAll:function(a){var b=this;b.clearData();if(b.snapshot){b.snapshot.clear()}if(b.pageMap){b.pageMap.clear()}if(a!==true){b.fireEvent("clear",b)}},first:function(a){var b=this;if(a&&b.isGrouped()){return b.aggregate(function(c){return c.length?c[0]:undefined},b,true)}else{return b.data.first()}},last:function(a){var b=this;if(a&&b.isGrouped()){return b.aggregate(function(d){var c=d.length;return c?d[c-1]:undefined},b,true)}else{return b.data.last()}},sum:function(c,a){var b=this;if(a&&b.isGrouped()){return b.aggregate(b.getSum,b,true,[c])}else{return b.getSum(b.data.items,c)}},getSum:function(b,e){var d=0,c=0,a=b.length;for(;c<a;++c){d+=b[c].get(e)}return d},count:function(a){var b=this;if(a&&b.isGrouped()){return b.aggregate(function(c){return c.length},b,true)}else{return b.getCount()}},min:function(c,a){var b=this;if(a&&b.isGrouped()){return b.aggregate(b.getMin,b,true,[c])}else{return b.getMin(b.data.items,c)}},getMin:function(b,f){var d=1,a=b.length,e,c;if(a>0){c=b[0].get(f)}for(;d<a;++d){e=b[d].get(f);if(e<c){c=e}}return c},max:function(c,a){var b=this;if(a&&b.isGrouped()){return b.aggregate(b.getMax,b,true,[c])}else{return b.getMax(b.data.items,c)}},getMax:function(c,f){var d=1,b=c.length,e,a;if(b>0){a=c[0].get(f)}for(;d<b;++d){e=c[d].get(f);if(e>a){a=e}}return a},average:function(c,a){var b=this;if(a&&b.isGrouped()){return b.aggregate(b.getAverage,b,true,[c])}else{return b.getAverage(b.data.items,c)}},getAverage:function(b,e){var c=0,a=b.length,d=0;if(b.length>0){for(;c<a;++c){d+=b[c].get(e)}return d/a}return 0},aggregate:function(g,j,e,f){f=f||[];if(e&&this.isGrouped()){var a=this.getGroups(),c=0,d=a.length,b={},h;for(;c<d;++c){h=a[c];b[h.name]=g.apply(j||this,[h.children].concat(f))}return b}else{return g.apply(j||this,[this.data.items].concat(f))}},commitChanges:function(){var c=this,d=c.getModifiedRecords(),a=d.length,b=0;for(;b<a;b++){d[b].commit()}c.removed.length=0},filterNewOnly:function(a){return a.phantom===true},getRejectRecords:function(){return Ext.Array.push(this.data.filterBy(this.filterNewOnly).items,this.getUpdatedRecords())},rejectChanges:function(){var c=this,d=c.getRejectRecords(),a=d.length,b=0,e;for(;b<a;b++){e=d[b];e.reject();if(e.phantom){c.remove(e)}}d=c.removed;a=d.length;for(b=0;b<a;b++){e=d[b];c.insert(e.removedFrom||0,e);e.reject()}c.removed.length=0}},function(){Ext.regStore("ext-empty-store",{fields:[],proxy:"memory"});this.prototype.PageMap=new Ext.Class({extend:"Ext.util.LruCache",clear:function(a){this.generation=(this.generation||0)+1;this.callParent(arguments)},getPageFromRecordIndex:this.prototype.getPageFromRecordIndex,addPage:function(b,a){this.add(b,a);this.fireEvent("pageAdded",b,a)},getPage:function(a){return this.get(a)},hasRange:function(d,b){var c=this.getPageFromRecordIndex(d),a=this.getPageFromRecordIndex(b);for(;c<=a;c++){if(!this.hasPage(c)){return false}}return true},hasPage:function(a){return !!this.get(a)},getRange:function(a,b){if(!this.hasRange(a,b)){Ext.Error.raise("PageMap asked for range which it does not have")}var j=this,f=j.getPageFromRecordIndex(a),m=j.getPageFromRecordIndex(b),c=(f-1)*j.pageSize,n=(m*j.pageSize)-1,h=f,o=[],l,g,k,d=0,e;for(;h<=m;h++){if(h==f){l=a-c;k=true}else{l=0;k=false}if(h==m){g=j.pageSize-(n-b);k=true}if(k){Ext.Array.push(o,Ext.Array.slice(j.getPage(h),l,g))}else{Ext.Array.push(o,j.getPage(h))}}for(e=o.length;d<e;d++){o[d].index=a++}return o}})});Ext.define("Ext.data.reader.Array",{extend:"Ext.data.reader.Json",alternateClassName:"Ext.data.ArrayReader",alias:"reader.array",totalProperty:undefined,successProperty:undefined,createFieldAccessExpression:function(e,c,b){var d=(e.mapping==null)?e.originalIndex:e.mapping,a;if(typeof d==="function"){a=c+".mapping("+b+", this)"}else{if(isNaN(d)){d='"'+d+'"'}a=b+"["+d+"]"}return a}});Ext.define("Ext.data.ArrayStore",{extend:"Ext.data.Store",alias:"store.array",requires:["Ext.data.proxy.Memory","Ext.data.reader.Array"],constructor:function(a){a=Ext.apply({proxy:{type:"memory",reader:"array"}},a);this.callParent([a])},loadData:function(e,a){if(this.expandData===true){var d=[],b=0,c=e.length;for(;b<c;b++){d[d.length]=[e[b]]}e=d}this.callParent([e,a])}},function(){Ext.data.SimpleStore=Ext.data.ArrayStore});Ext.define("Ext.data.NodeStore",{extend:"Ext.data.Store",alias:"store.node",requires:["Ext.data.NodeInterface"],node:null,recursive:false,rootVisible:false,constructor:function(a){var c=this,b;a=a||{};Ext.apply(c,a);a.proxy={type:"proxy"};c.callParent([a]);b=c.node;if(b){c.node=null;c.setNode(b)}},setNode:function(b){var a=this;if(a.node&&a.node!=b){a.mun(a.node,{expand:a.onNodeExpand,collapse:a.onNodeCollapse,append:a.onNodeAppend,insert:a.onNodeInsert,remove:a.onNodeRemove,sort:a.onNodeSort,scope:a});a.node=null}if(b){Ext.data.NodeInterface.decorate(b.self);a.removeAll();if(a.rootVisible){a.add(b)}else{if(!b.isExpanded()&&a.treeStore.autoLoad!==false){b.expand()}}a.mon(b,{expand:a.onNodeExpand,collapse:a.onNodeCollapse,append:a.onNodeAppend,insert:a.onNodeInsert,remove:a.onNodeRemove,sort:a.onNodeSort,scope:a});a.node=b;if(b.isExpanded()&&b.isLoaded()){a.onNodeExpand(b,b.childNodes,true)}}},onNodeSort:function(b,c){var a=this;if((a.indexOf(b)!==-1||(b===a.node&&!a.rootVisible)&&b.isExpanded())){a.onNodeCollapse(b,c,true);a.onNodeExpand(b,c,true)}},onNodeExpand:function(f,d,c){var h=this,a=h.indexOf(f)+1,g=d?d.length:0,e,b;if(!h.recursive&&f!==h.node){return}if(f!==this.node&&!h.isVisible(f)){return}if(!c&&h.fireEvent("beforeexpand",f,d,a)===false){return}if(g){h.insert(a,d);for(e=0;e<g;e++){b=d[e];if(b.isExpanded()){if(b.isLoaded()){h.onNodeExpand(b,b.childNodes,true)}else{b.set("expanded",false);b.expand()}}}}if(!c){h.fireEvent("expand",f,d)}},onNodeCollapse:function(f,c,b){var h=this,g=c.length,e=h.indexOf(f)+1,d,a;if(!h.recursive&&f!==h.node){return}if(!b&&h.fireEvent("beforecollapse",f,c,e)===false){return}for(d=0;d<g;d++){a=c[d];h.remove(a);if(a.isExpanded()){h.onNodeCollapse(a,a.childNodes,true)}}if(!b){h.fireEvent("collapse",f,c,e)}},onNodeAppend:function(d,f,b){var e=this,a,c;if(e.isVisible(f)){if(b===0){a=d}else{c=f.previousSibling;while(c.isExpanded()&&c.lastChild){c=c.lastChild}a=c}e.insert(e.indexOf(a)+1,f);if(!f.isLeaf()&&f.isExpanded()){if(f.isLoaded()){e.onNodeExpand(f,f.childNodes,true)}else{f.set("expanded",false);f.expand()}}}},onNodeInsert:function(c,e,a){var d=this,b=this.indexOf(a);if(b!=-1&&d.isVisible(e)){d.insert(b,e);if(!e.isLeaf()&&e.isExpanded()){if(e.isLoaded()){d.onNodeExpand(e,e.childNodes,true)}else{e.set("expanded",false);e.expand()}}}},onNodeRemove:function(b,d,a){var c=this;if(c.indexOf(d)!=-1){if(!d.isLeaf()&&d.isExpanded()){c.onNodeCollapse(d,d.childNodes,true)}c.remove(d)}},isVisible:function(b){var a=b.parentNode;while(a){if(a===this.node&&!this.rootVisible&&a.isExpanded()){return true}if(this.indexOf(a)===-1||!a.isExpanded()){return false}a=a.parentNode}return true}});Ext.define("Ext.grid.plugin.HeaderResizer",{extend:"Ext.AbstractPlugin",requires:["Ext.dd.DragTracker","Ext.util.Region"],alias:"plugin.gridheaderresizer",disabled:false,config:{dynamic:false},colHeaderCls:Ext.baseCSSPrefix+"column-header",minColWidth:40,maxColWidth:1000,wResizeCursor:"col-resize",eResizeCursor:"col-resize",init:function(a){this.headerCt=a;a.on("render",this.afterHeaderRender,this,{single:true})},destroy:function(){if(this.tracker){this.tracker.destroy()}},afterHeaderRender:function(){var b=this.headerCt,a=b.el;b.mon(a,"mousemove",this.onHeaderCtMouseMove,this);this.tracker=new Ext.dd.DragTracker({disabled:this.disabled,onBeforeStart:Ext.Function.bind(this.onBeforeStart,this),onStart:Ext.Function.bind(this.onStart,this),onDrag:Ext.Function.bind(this.onDrag,this),onEnd:Ext.Function.bind(this.onEnd,this),tolerance:3,autoStart:300,el:a})},onHeaderCtMouseMove:function(b,j){var d=this,a,h,i,f,c,g;if(d.headerCt.dragging){if(d.activeHd){d.activeHd.el.dom.style.cursor="";delete d.activeHd}}else{h=b.getTarget("."+d.colHeaderCls,3,true);if(h){i=Ext.getCmp(h.id);if(i.isOnLeftEdge(b)){f=i.previousNode("gridcolumn:not([hidden]):not([isGroupHeader])");if(f){g=d.headerCt.up("tablepanel");c=f.up("tablepanel");if(!((c===g)||((g.ownerCt.isXType("tablepanel"))&&g.ownerCt.view.lockedGrid===c))){f=null}}}else{if(i.isOnRightEdge(b)){f=i}else{f=null}}if(f){if(f.isGroupHeader){a=f.getGridColumns();f=a[a.length-1]}if(f&&!(f.fixed||(f.resizable===false)||d.disabled)){d.activeHd=f;i.el.dom.style.cursor=d.eResizeCursor}}else{i.el.dom.style.cursor="";delete d.activeHd}}}},onBeforeStart:function(b){var a=b.getTarget();this.dragHd=this.activeHd;if(!!this.dragHd&&!Ext.fly(a).hasCls(Ext.baseCSSPrefix+"column-header-trigger")&&!this.headerCt.dragging){this.tracker.constrainTo=this.getConstrainRegion();return true}else{this.headerCt.dragging=false;return false}},getConstrainRegion:function(){var c=this,a=c.dragHd.el,d=Ext.util.Region.getRegion(a),b;if(c.headerCt.forceFit){b=c.dragHd.nextNode("gridcolumn:not([hidden]):not([isGroupHeader])")}return d.adjust(0,c.headerCt.forceFit?(b?b.getWidth()-c.minColWidth:0):c.maxColWidth-a.getWidth(),0,c.minColWidth)},onStart:function(s){var u=this,g=u.dragHd,b=g.el,n=b.getWidth(),i=u.headerCt,k=s.getTarget(),d,q,f,j,c,m,a,h,r,p,o,l;if(u.dragHd&&!Ext.fly(k).hasCls(Ext.baseCSSPrefix+"column-header-trigger")){i.dragging=true}u.origWidth=n;if(!u.dynamic){d=b.getXY();q=i.up("[scrollerOwner]");f=u.dragHd.up(":not([isGroupHeader])");j=f.up();c=q.getLhsMarker();m=q.getRhsMarker();a=m.parent();h=a.getLocalX();r=a.getLocalY();p=a.translatePoints(d);o=j.body.getHeight()+i.getHeight();l=p.top-r;c.setTop(l);m.setTop(l);c.setHeight(o);m.setHeight(o);c.setLeft(p.left-h);m.setLeft(p.left+n-h)}},onDrag:function(g){if(!this.dynamic){var f=this.tracker.getXY("point"),a=this.headerCt.up("[scrollerOwner]"),h=a.getRhsMarker(),c=h.parent(),b=c.translatePoints(f),d=c.getLocalX();h.setLeft(b.left-d)}else{this.doResize()}},onEnd:function(f){this.headerCt.dragging=false;if(this.dragHd){if(!this.dynamic){var d=this.dragHd,b=this.headerCt.up("[scrollerOwner]"),c=b.getLhsMarker(),g=b.getRhsMarker(),a=-9999;c.setLeft(a);g.setLeft(a)}this.doResize()}},doResize:function(){if(this.dragHd){var b=this.dragHd,a,c=this.tracker.getOffset("point");if(b.flex){delete b.flex}Ext.suspendLayouts();b.setWidth(this.origWidth+c[0]);if(this.headerCt.forceFit){a=b.nextNode("gridcolumn:not([hidden]):not([isGroupHeader])");if(a){delete a.flex;a.setWidth(a.getWidth()-c[0])}}Ext.resumeLayouts(true)}},disable:function(){this.disabled=true;if(this.tracker){this.tracker.disable()}},enable:function(){this.disabled=false;if(this.tracker){this.tracker.enable()}}});Ext.define("Ext.layout.component.Tab",{extend:"Ext.layout.component.Button",alias:"layout.tab",beginLayout:function(c){var b=this,a=b.owner.closable;if(b.lastClosable!==a){b.lastClosable=a;b.clearTargetCache()}b.callParent(arguments)}});Ext.define("Ext.selection.Model",{extend:"Ext.util.Observable",alternateClassName:"Ext.AbstractSelectionModel",requires:["Ext.data.StoreManager"],mixins:{bindable:"Ext.util.Bindable"},allowDeselect:false,selected:null,pruneRemoved:true,constructor:function(a){var b=this;a=a||{};Ext.apply(b,a);b.addEvents("selectionchange","focuschange");b.modes={SINGLE:true,SIMPLE:true,MULTI:true};b.setSelectionMode(a.mode||b.mode);b.selected=new Ext.util.MixedCollection();b.callParent(arguments)},bindStore:function(a,b){var c=this;c.mixins.bindable.bindStore.apply(c,arguments);if(c.store&&!b){c.refresh()}},getStoreListeners:function(){var a=this;return{add:a.onStoreAdd,clear:a.onStoreClear,remove:a.onStoreRemove,update:a.onStoreUpdate}},selectAll:function(b){var e=this,d=e.store.getRange(),c=0,a=d.length,f=e.getSelection().length;e.bulkChange=true;for(;c<a;c++){e.doSelect(d[c],true,b)}delete e.bulkChange;e.maybeFireSelectionChange(e.getSelection().length!==f)},deselectAll:function(b){var e=this,d=e.getSelection(),c=0,a=d.length,f=e.getSelection().length;e.bulkChange=true;for(;c<a;c++){e.doDeselect(d[c],b)}delete e.bulkChange;e.maybeFireSelectionChange(e.getSelection().length!==f)},selectWithEvent:function(a,d,c){var b=this;switch(b.selectionMode){case"MULTI":if(d.ctrlKey&&b.isSelected(a)){b.doDeselect(a,false)}else{if(d.shiftKey&&b.lastFocused){b.selectRange(b.lastFocused,a,d.ctrlKey)}else{if(d.ctrlKey){b.doSelect(a,true,false)}else{if(b.isSelected(a)&&!d.shiftKey&&!d.ctrlKey&&b.selected.getCount()>1){b.doSelect(a,c,false)}else{b.doSelect(a,false)}}}}break;case"SIMPLE":if(b.isSelected(a)){b.doDeselect(a)}else{b.doSelect(a,true)}break;case"SINGLE":if(b.allowDeselect&&b.isSelected(a)){b.doDeselect(a)}else{b.doSelect(a,false)}break}},selectRange:function(k,e,l,c){var h=this,j=h.store,d=0,g,f,a,b=[];if(h.isLocked()){return}if(!l){h.deselectAll(true)}if(!Ext.isNumber(k)){k=j.indexOf(k)}if(!Ext.isNumber(e)){e=j.indexOf(e)}if(k>e){f=e;e=k;k=f}for(g=k;g<=e;g++){if(h.isSelected(j.getAt(g))){d++}}if(!c){a=-1}else{a=(c=="up")?k:e}for(g=k;g<=e;g++){if(d==(e-k+1)){if(g!=a){h.doDeselect(g,true)}}else{b.push(j.getAt(g))}}h.doMultiSelect(b,true)},select:function(b,c,a){if(Ext.isDefined(b)){this.doSelect(b,c,a)}},deselect:function(b,a){this.doDeselect(b,a)},doSelect:function(c,e,b){var d=this,a;if(d.locked||!d.store){return}if(typeof c==="number"){c=[d.store.getAt(c)]}if(d.selectionMode=="SINGLE"&&c){a=c.length?c[0]:c;d.doSingleSelect(a,b)}else{d.doMultiSelect(c,e,b)}},doMultiSelect:function(a,k,j){var g=this,b=g.selected,h=false,d=0,f,e;if(g.locked){return}a=!Ext.isArray(a)?[a]:a;f=a.length;if(!k&&b.getCount()>0){if(g.doDeselect(g.getSelection(),j)===false){return}}function c(){b.add(e);h=true}for(;d<f;d++){e=a[d];if(k&&g.isSelected(e)){continue}g.lastSelected=e;g.onSelectChange(e,true,j,c)}if(!g.preventFocus){g.setLastFocused(e,j)}g.maybeFireSelectionChange(h&&!j)},doDeselect:function(a,j){var h=this,b=h.selected,d=0,g,e,k=0,f=0;if(h.locked||!h.store){return false}if(typeof a==="number"){a=[h.store.getAt(a)]}else{if(!Ext.isArray(a)){a=[a]}}function c(){++f;b.remove(e)}g=a.length;for(;d<g;d++){e=a[d];if(h.isSelected(e)){if(h.lastSelected==e){h.lastSelected=b.last()}++k;h.onSelectChange(e,false,j,c)}}h.maybeFireSelectionChange(f>0&&!j);return f===k},doSingleSelect:function(a,b){var d=this,f=false,c=d.selected;if(d.locked){return}if(d.isSelected(a)){return}function e(){d.bulkChange=true;if(c.getCount()>0&&d.doDeselect(d.lastSelected,b)===false){delete d.bulkChange;return false}delete d.bulkChange;c.add(a);d.lastSelected=a;f=true}d.onSelectChange(a,true,b,e);if(f){if(!b){d.setLastFocused(a)}d.maybeFireSelectionChange(!b)}},setLastFocused:function(c,b){var d=this,a=d.lastFocused;d.lastFocused=c;if(c!==a){d.onLastFocusChanged(a,c,b)}},isFocused:function(a){return a===this.getLastFocused()},maybeFireSelectionChange:function(a){var b=this;if(a&&!b.bulkChange){b.fireEvent("selectionchange",b,b.getSelection())}},getLastSelected:function(){return this.lastSelected},getLastFocused:function(){return this.lastFocused},getSelection:function(){return this.selected.getRange()},getSelectionMode:function(){return this.selectionMode},setSelectionMode:function(a){a=a?a.toUpperCase():"SINGLE";this.selectionMode=this.modes[a]?a:"SINGLE"},isLocked:function(){return this.locked},setLocked:function(a){this.locked=!!a},isSelected:function(a){a=Ext.isNumber(a)?this.store.getAt(a):a;return this.selected.indexOf(a)!==-1},hasSelection:function(){return this.selected.getCount()>0},refresh:function(){var e=this,h=e.store,c=[],a=e.getSelection(),d=a.length,g,f,b=0,j=e.getLastFocused();if(!h){return}for(;b<d;b++){g=a[b];if(!e.pruneRemoved||h.indexOf(g)!==-1){c.push(g)}}if(e.selected.getCount()!=c.length){f=true}e.clearSelections();if(h.indexOf(j)!==-1){e.setLastFocused(j,true)}if(c.length){e.doSelect(c,false,true)}e.maybeFireSelectionChange(f)},clearSelections:function(){this.selected.clear();this.lastSelected=null;this.setLastFocused(null)},onStoreAdd:Ext.emptyFn,onStoreClear:function(){if(this.selected.getCount>0){this.clearSelections();this.maybeFireSelectionChange(true)}},onStoreRemove:function(b,a,c){var e=this,d=e.selected;if(e.locked||!e.pruneRemoved){return}if(d.remove(a)){if(e.lastSelected==a){e.lastSelected=null}if(e.getLastFocused()==a){e.setLastFocused(null)}e.maybeFireSelectionChange(true)}},getCount:function(){return this.selected.getCount()},destroy:Ext.emptyFn,onStoreUpdate:Ext.emptyFn,onStoreLoad:Ext.emptyFn,onSelectChange:Ext.emptyFn,onLastFocusChanged:function(b,a){this.fireEvent("focuschange",this,b,a)},onEditorKey:Ext.emptyFn,bindComponent:Ext.emptyFn,beforeViewRender:Ext.emptyFn});Ext.define("Ext.selection.RowModel",{extend:"Ext.selection.Model",alias:"selection.rowmodel",requires:["Ext.util.KeyNav"],deltaScroll:5,enableKeyNav:true,ignoreRightMouseSelection:false,constructor:function(){this.addEvents("beforedeselect","beforeselect","deselect","select");this.views=[];this.callParent(arguments)},bindComponent:function(a){var b=this;b.views=b.views||[];b.views.push(a);b.bindStore(a.getStore(),true);a.on({itemmousedown:b.onRowMouseDown,scope:b});if(b.enableKeyNav){b.initKeyNav(a)}},initKeyNav:function(a){var b=this;if(!a.rendered){a.on("render",Ext.Function.bind(b.initKeyNav,b,[a],0),b,{single:true});return}a.el.set({tabIndex:-1});b.keyNav=new Ext.util.KeyNav({target:a,ignoreInputFields:true,eventName:"itemkeydown",processEvent:function(d,c,g,e,f){f.record=c;f.recordIndex=e;return f},up:b.onKeyUp,down:b.onKeyDown,right:b.onKeyRight,left:b.onKeyLeft,pageDown:b.onKeyPageDown,pageUp:b.onKeyPageUp,home:b.onKeyHome,end:b.onKeyEnd,space:b.onKeySpace,enter:b.onKeyEnter,scope:b})},getRowsVisible:function(){var e=false,a=this.views[0],d=a.getNode(0),b,c;if(d){b=Ext.fly(d).getHeight();c=a.el.getHeight();e=Math.floor(c/b)}return e},onKeyEnd:function(c){var b=this,a=b.store.getAt(b.store.getCount()-1);if(a){if(c.shiftKey){b.selectRange(a,b.lastFocused||0);b.setLastFocused(a)}else{if(c.ctrlKey){b.setLastFocused(a)}else{b.doSelect(a)}}}},onKeyHome:function(b){var a=this,c=a.store.getAt(0);if(c){if(b.shiftKey){a.selectRange(c,a.lastFocused||0);a.setLastFocused(c)}else{if(b.ctrlKey){a.setLastFocused(c)}else{a.doSelect(c,false)}}}},onKeyPageUp:function(f){var d=this,g=d.getRowsVisible(),b,c,a;if(g){b=f.recordIndex;c=b-g;if(c<0){c=0}a=d.store.getAt(c);if(f.shiftKey){d.selectRange(a,f.record,f.ctrlKey,"up");d.setLastFocused(a)}else{if(f.ctrlKey){f.preventDefault();d.setLastFocused(a)}else{d.doSelect(a)}}}},onKeyPageDown:function(f){var c=this,g=c.getRowsVisible(),a,d,b;if(g){a=f.recordIndex;d=a+g;if(d>=c.store.getCount()){d=c.store.getCount()-1}b=c.store.getAt(d);if(f.shiftKey){c.selectRange(b,f.record,f.ctrlKey,"down");c.setLastFocused(b)}else{if(f.ctrlKey){f.preventDefault();c.setLastFocused(b)}else{c.doSelect(b)}}}},onKeySpace:function(c){var b=this,a=b.lastFocused;if(a){if(b.isSelected(a)){b.doDeselect(a,false)}else{b.doSelect(a,true)}}},onKeyEnter:Ext.emptyFn,onKeyUp:function(d){var c=this,a=c.store.indexOf(c.lastFocused),b;if(a>0){b=c.store.getAt(a-1);if(d.shiftKey&&c.lastFocused){if(c.isSelected(c.lastFocused)&&c.isSelected(b)){c.doDeselect(c.lastFocused,true);c.setLastFocused(b)}else{if(!c.isSelected(c.lastFocused)){c.doSelect(c.lastFocused,true);c.doSelect(b,true)}else{c.doSelect(b,true)}}}else{if(d.ctrlKey){c.setLastFocused(b)}else{c.doSelect(b)}}}},onKeyDown:function(d){var c=this,a=c.store.indexOf(c.lastFocused),b;if(a+1<c.store.getCount()){b=c.store.getAt(a+1);if(c.selected.getCount()===0){if(!d.ctrlKey){c.doSelect(b)}else{c.setLastFocused(b)}}else{if(d.shiftKey&&c.lastFocused){if(c.isSelected(c.lastFocused)&&c.isSelected(b)){c.doDeselect(c.lastFocused,true);c.setLastFocused(b)}else{if(!c.isSelected(c.lastFocused)){c.doSelect(c.lastFocused,true);c.doSelect(b,true)}else{c.doSelect(b,true)}}}else{if(d.ctrlKey){c.setLastFocused(b)}else{c.doSelect(b)}}}}},scrollByDeltaX:function(d){var a=this.views[0],c=a.up(),b=c.horizontalScroller;if(b){b.scrollByDeltaX(d)}},onKeyLeft:function(a){this.scrollByDeltaX(-this.deltaScroll)},onKeyRight:function(a){this.scrollByDeltaX(this.deltaScroll)},onRowMouseDown:function(b,a,d,c,f){if(!this.allowRightMouseSelection(f)){return}if(f.button===0||!this.isSelected(a)){this.selectWithEvent(a,f)}},allowRightMouseSelection:function(a){var b=this.ignoreRightMouseSelection&&a.button!==0;if(b){b=this.hasSelection()}return !b},onSelectChange:function(f,c,k,a){var h=this,l=h.views,d=l.length,j=h.store,b=j.indexOf(f),g=c?"select":"deselect",e=0;if((k||h.fireEvent("before"+g,h,f,b))!==false&&a()!==false){for(;e<d;e++){if(c){l[e].onRowSelect(b,k)}else{l[e].onRowDeselect(b,k)}}if(!k){h.fireEvent(g,h,f,b)}}},onLastFocusChanged:function(h,d,b){var a=this.views,g=a.length,c=this.store,f,e=0;if(h){f=c.indexOf(h);if(f!=-1){for(;e<g;e++){a[e].onRowFocus(f,false)}}}if(d){f=c.indexOf(d);if(f!=-1){for(e=0;e<g;e++){a[e].onRowFocus(f,true,b)}}}this.callParent()},onEditorTab:function(d,h){var f=this,c=f.views[0],b=d.getActiveRecord(),i=d.getActiveColumn(),a=c.getPosition(b,i),g=h.shiftKey?"left":"right";do{a=c.walkCells(a,g,h,f.preventWrap)}while(a&&!c.headerCt.getHeaderAtIndex(a.column).getEditor());if(a){d.startEditByPosition(a)}},getCurrentPosition:function(){var a=this.selected.items[0];if(a){return{row:this.store.indexOf(a),column:0}}},selectByPosition:function(a){var b=this.store.getAt(a.row);this.select(b)},selectNext:function(g,c){var f=this,b=f.store,e=f.getSelection(),a=e[e.length-1],d=b.indexOf(a)+1,h;if(d===b.getCount()||d===0){h=false}else{f.doSelect(d,g,c);h=true}return h},selectPrevious:function(f,b){var e=this,d=e.getSelection(),a=d[0],c=e.store.indexOf(a)-1,g;if(c<0){g=false}else{e.doSelect(c,f,b);g=true}return g}});Ext.define("Ext.selection.TreeModel",{extend:"Ext.selection.RowModel",alias:"selection.treemodel",pruneRemoved:false,onKeyRight:function(d,b){var c=this.getLastFocused(),a=this.view;if(c){if(c.isExpanded()){this.onKeyDown(d,b)}else{if(c.isExpandable()){a.expand(c)}}}},onKeyLeft:function(h,d){var g=this.getLastFocused(),c=this.view,b=c.getSelectionModel(),a,f;if(g){a=g.parentNode;if(g.isExpanded()){c.collapse(g)}else{if(a&&!a.isRoot()){if(h.shiftKey){b.selectRange(a,g,h.ctrlKey,"up");b.setLastFocused(a)}else{if(h.ctrlKey){b.setLastFocused(a)}else{b.select(a)}}}}}},onKeySpace:function(b,a){this.toggleCheck(b)},onKeyEnter:function(b,a){this.toggleCheck(b)},toggleCheck:function(b){b.stopEvent();var a=this.getLastSelected();if(a){this.view.onCheckChange(a)}}});Ext.define("Ext.state.Manager",{singleton:true,requires:["Ext.state.Provider"],constructor:function(){this.provider=new Ext.state.Provider()},setProvider:function(a){this.provider=a},get:function(b,a){return this.provider.get(b,a)},set:function(a,b){this.provider.set(a,b)},clear:function(a){this.provider.clear(a)},getProvider:function(){return this.provider}});Ext.define("Ext.state.Stateful",{mixins:{observable:"Ext.util.Observable"},requires:["Ext.state.Manager"],stateful:false,saveDelay:100,constructor:function(a){var b=this;a=a||{};if(a.stateful!==undefined){b.stateful=a.stateful}if(a.saveDelay!==undefined){b.saveDelay=a.saveDelay}b.stateId=b.stateId||a.stateId;if(!b.stateEvents){b.stateEvents=[]}if(a.stateEvents){b.stateEvents.concat(a.stateEvents)}this.addEvents("beforestaterestore","staterestore","beforestatesave","statesave");b.mixins.observable.constructor.call(b);if(b.stateful!==false){b.addStateEvents(b.stateEvents);b.initState()}},addStateEvents:function(c){var e=this,b,d,a;if(e.stateful&&e.getStateId()){if(typeof c=="string"){c=Array.prototype.slice.call(arguments,0)}a=e.stateEventsByName||(e.stateEventsByName={});for(b=c.length;b--;){d=c[b];if(!a[d]){a[d]=1;e.on(d,e.onStateChange,e)}}}},onStateChange:function(){var c=this,a=c.saveDelay,d,b;if(!c.stateful){return}if(a){if(!c.stateTask){d=Ext.state.Stateful;b=d.runner||(d.runner=new Ext.util.TaskRunner());c.stateTask=b.newTask({run:c.saveState,scope:c,interval:a,repeat:1})}c.stateTask.start()}else{c.saveState()}},saveState:function(){var b=this,d=b.stateful&&b.getStateId(),a=b.hasListeners,c;if(d){c=b.getState()||{};if(!a.beforestatesave||b.fireEvent("beforestatesave",b,c)!==false){Ext.state.Manager.set(d,c);if(a.statesave){b.fireEvent("statesave",b,c)}}}},getState:function(){return null},applyState:function(a){if(a){Ext.apply(this,a)}},getStateId:function(){var a=this;return a.stateId||(a.autoGenId?null:a.id)},initState:function(){var b=this,d=b.stateful&&b.getStateId(),a=b.hasListeners,c;if(d){c=Ext.state.Manager.get(d);if(c){c=Ext.apply({},c);if(!a.beforestaterestore||b.fireEvent("beforestaterestore",b,c)!==false){b.applyState(c);if(a.staterestore){b.fireEvent("staterestore",b,c)}}}}},savePropToState:function(f,e,d){var b=this,c=b[f],a=b.initialConfig;if(b.hasOwnProperty(f)){if(!a||a[f]!==c){if(e){e[d||f]=c}return true}}return false},savePropsToState:function(e,c){var b=this,a,d;if(typeof e=="string"){b.savePropToState(e,c)}else{for(a=0,d=e.length;a<d;++a){b.savePropToState(e[a],c)}}return c},destroy:function(){var b=this,a=b.stateTask;if(a){a.destroy();b.stateTask=null}b.clearListeners()}});Ext.define("Ext.AbstractComponent",{requires:["Ext.ComponentQuery","Ext.ComponentManager","Ext.util.ProtoElement"],mixins:{observable:"Ext.util.Observable",animate:"Ext.util.Animate",elementCt:"Ext.util.ElementContainer",renderable:"Ext.util.Renderable",state:"Ext.state.Stateful"},uses:["Ext.PluginManager","Ext.Element","Ext.DomHelper","Ext.XTemplate","Ext.ComponentQuery","Ext.ComponentLoader","Ext.EventManager","Ext.layout.Context","Ext.layout.Layout","Ext.layout.component.Auto","Ext.LoadMask","Ext.ZIndexManager"],statics:{AUTO_ID:1000,pendingLayouts:null,layoutSuspendCount:0,cancelLayout:function(a,c){var b=this.runningLayoutContext||this.pendingLayouts;if(b){b.cancelComponent(a,false,c)}},flushLayouts:function(){var b=this,a=b.pendingLayouts;if(a&&a.invalidQueue.length){b.pendingLayouts=null;b.runningLayoutContext=a;Ext.override(a,{runComplete:function(){b.runningLayoutContext=null;return this.callParent()}});a.run()}},resumeLayouts:function(a){if(this.layoutSuspendCount&&!--this.layoutSuspendCount){if(a){this.flushLayouts()}}},suspendLayouts:function(){++this.layoutSuspendCount},updateLayout:function(b,e){var c=this,a=c.runningLayoutContext,d;if(a){a.queueInvalidate(b)}else{d=c.pendingLayouts||(c.pendingLayouts=new Ext.layout.Context());d.queueInvalidate(b);if(!e&&!c.layoutSuspendCount&&!b.isLayoutSuspended()){c.flushLayouts()}}}},isComponent:true,getAutoId:function(){this.autoGenId=true;return ++Ext.AbstractComponent.AUTO_ID},deferLayouts:false,autoGenId:false,renderTpl:"{%this.renderContent(out,values)%}",frameSize:{left:0,top:0,right:0,bottom:0,width:0,height:0},tplWriteMode:"overwrite",baseCls:Ext.baseCSSPrefix+"component",disabledCls:Ext.baseCSSPrefix+"item-disabled",ui:"default",uiCls:[],hidden:false,disabled:false,draggable:false,floating:false,hideMode:"display",styleHtmlContent:false,styleHtmlCls:Ext.baseCSSPrefix+"html",autoShow:false,autoRender:false,allowDomMove:true,rendered:false,componentLayoutCounter:0,shrinkWrap:2,weight:0,maskOnDisable:true,_isLayoutRoot:false,constructor:function(c){var e=this,d,a,b;if(c){Ext.apply(e,c);b=e.xhooks;if(b){delete e.xhooks;Ext.override(e,b)}}else{c={}}e.initialConfig=c;e.mixins.elementCt.constructor.call(e);e.addEvents("beforeactivate","activate","beforedeactivate","deactivate","added","disable","enable","beforeshow","show","beforehide","hide","removed","beforerender","render","afterrender","boxready","beforedestroy","destroy","resize","move","focus","blur");e.getId();e.setupProtoEl();if(e.cls){e.initialCls=e.cls;e.protoEl.addCls(e.cls)}if(e.style){e.initialStyle=e.style;e.protoEl.setStyle(e.style)}e.mons=[];e.renderData=e.renderData||{};e.renderSelectors=e.renderSelectors||{};if(e.plugins){e.plugins=e.constructPlugins()}if(!e.hasListeners){e.hasListeners=new e.HasListeners()}e.initComponent();Ext.ComponentManager.register(e);e.mixins.observable.constructor.call(e);e.mixins.state.constructor.call(e,c);this.addStateEvents("resize");if(e.plugins){for(d=0,a=e.plugins.length;d<a;d++){e.plugins[d]=e.initPlugin(e.plugins[d])}}e.loader=e.getLoader();if(e.renderTo){e.render(e.renderTo)}if(e.autoShow&&!e.isContained){e.show()}},initComponent:function(){this.plugins=this.constructPlugins();this.setSize(this.width,this.height)},getState:function(){var b=this,c=null,a=b.getSizeModel();if(a.width.configured){c=b.addPropertyToState(c,"width")}if(a.height.configured){c=b.addPropertyToState(c,"height")}return c},addPropertyToState:function(e,d,c){var b=this,a=arguments.length;if(a==3||b.hasOwnProperty(d)){if(a<3){c=b[d]}if(c!==b.initialConfig[d]){(e||(e={}))[d]=c}}return e},show:Ext.emptyFn,animate:function(b){var j=this,e,f,d,o,n,l,k,i,m,g,c,a;b=b||{};n=b.to||{};if(Ext.fx.Manager.hasFxBlock(j.id)){return j}e=Ext.isDefined(n.width);if(e){o=Ext.Number.constrain(n.width,j.minWidth,j.maxWidth)}f=Ext.isDefined(n.height);if(f){d=Ext.Number.constrain(n.height,j.minHeight,j.maxHeight)}if(!b.dynamic&&(e||f)){i=(b.from?b.from.width:undefined)||j.getWidth();m=i;g=(b.from?b.from.height:undefined)||j.getHeight();c=g;a=false;if(f&&d>g){c=d;a=true}if(e&&o>i){m=o;a=true}if(a){l=!Ext.isNumber(j.width);k=!Ext.isNumber(j.height);j.setSize(m,c);j.el.setSize(i,g);if(l){delete j.width}if(k){delete j.height}}if(e){n.width=o}if(f){n.height=d}}return j.mixins.animate.animate.apply(j,arguments)},onHide:function(){this.updateLayout({isRoot:false})},onShow:function(){this.updateLayout({isRoot:false})},constructPlugin:function(a){if(a.ptype&&typeof a.init!="function"){a.cmp=this;a=Ext.PluginManager.create(a)}else{if(typeof a=="string"){a=Ext.PluginManager.create({ptype:a,cmp:this})}}return a},constructPlugins:function(){var e=this,c,b=[],d,a;if(e.plugins){c=Ext.isArray(e.plugins)?e.plugins:[e.plugins];for(d=0,a=c.length;d<a;d++){b[d]=e.constructPlugin(c[d])}return b}},initPlugin:function(a){a.init(this);return a},updateAria:Ext.emptyFn,registerFloatingItem:function(b){var a=this;if(!a.floatingDescendants){a.floatingDescendants=new Ext.ZIndexManager(a)}a.floatingDescendants.register(b)},unregisterFloatingItem:function(b){var a=this;if(a.floatingDescendants){a.floatingDescendants.unregister(b)}},layoutSuspendCount:0,suspendLayouts:function(){var a=this;if(!a.rendered){return}if(++a.layoutSuspendCount==1){a.suspendLayout=true}},resumeLayouts:function(b){var a=this;if(!a.rendered){return}if(!--a.layoutSuspendCount){a.suspendLayout=false;if(b&&!a.isLayoutSuspended()){a.updateLayout(b)}}},setupProtoEl:function(){var b=this,a=[b.baseCls,b.getComponentLayout().targetCls];if(Ext.isDefined(b.cmpCls)){if(Ext.isDefined(Ext.global.console)){Ext.global.console.warn("Ext.Component: cmpCls has been deprecated. Please use componentCls.")}b.componentCls=b.cmpCls;delete b.cmpCls}if(b.componentCls){a.push(b.componentCls)}else{b.componentCls=b.baseCls}b.protoEl=new Ext.util.ProtoElement({cls:a.join(" ")})},setUI:function(f){var e=this,b=Ext.Array.clone(e.uiCls),g=[],d=[],a,c;for(c=0;c<b.length;c++){a=b[c];d=d.concat(e.removeClsWithUI(a,true));g.push(a)}if(d.length){e.removeCls(d)}e.removeUIFromElement();e.ui=f;e.addUIToElement();d=[];for(c=0;c<g.length;c++){a=g[c];d=d.concat(e.addClsWithUI(a,true))}if(d.length){e.addCls(d)}if(e.rendered){e.updateLayout()}},addClsWithUI:function(c,g){var f=this,e=[],d,b=0,a;if(typeof c==="string"){c=(c.indexOf(" ")<0)?[c]:Ext.String.splitWords(c)}d=c.length;f.uiCls=Ext.Array.clone(f.uiCls);for(;b<d;b++){a=c[b];if(a&&!f.hasUICls(a)){f.uiCls.push(a);e=e.concat(f.addUIClsToElement(a))}}if(g!==true){f.addCls(e)}return e},removeClsWithUI:function(c,g){var f=this,e=[],b=0,d,a;if(typeof c==="string"){c=(c.indexOf(" ")<0)?[c]:Ext.String.splitWords(c)}d=c.length;for(b=0;b<d;b++){a=c[b];if(a&&f.hasUICls(a)){f.uiCls=Ext.Array.remove(f.uiCls,a);e=e.concat(f.removeUIClsFromElement(a))}}if(g!==true){f.removeCls(e)}return e},hasUICls:function(a){var b=this,c=b.uiCls||[];return Ext.Array.contains(c,a)},frameElementsArray:["tl","tc","tr","ml","mc","mr","bl","bc","br"],addUIClsToElement:function(l){var j=this,b=j.baseCls+"-"+j.ui+"-"+l,m=[Ext.baseCSSPrefix+l,j.baseCls+"-"+l,b],k=j.frameElementCls,g,f,e,a,d,h;if(j.frame&&!Ext.supports.CSS3BorderRadius){g=j.frameElementsArray;f=g.length;e=0;for(;e<f;e++){d=g[e];a=j["frame"+d.toUpperCase()];h=b+"-"+d;if(a&&a.dom){a.addCls(h)}else{if(Ext.Array.indexOf(k[d],h)==-1){k[d].push(h)}}}}j.frameElementCls=k;return m},removeUIClsFromElement:function(l){var j=this,b=j.baseCls+"-"+j.ui+"-"+l,m=[Ext.baseCSSPrefix+l,j.baseCls+"-"+l,b],k=j.frameElementCls,g,f,e,a,d,h;if(j.frame&&!Ext.supports.CSS3BorderRadius){g=j.frameElementsArray;f=g.length;e=0;for(;e<f;e++){d=g[e];a=j["frame"+d.toUpperCase()];h=b+"-"+d;if(a&&a.dom){a.addCls(h)}else{Ext.Array.remove(k[d],h)}}}j.frameElementCls=k;return m},addUIToElement:function(){var h=this,j=h.baseCls+"-"+h.ui,k=h.frameElementCls,f,e,d,a,b,g;h.addCls(j);if(h.frame&&!Ext.supports.CSS3BorderRadius){f=h.frameElementsArray;e=f.length;d=0;for(;d<e;d++){b=f[d];a=h["frame"+b.toUpperCase()];g=j+"-"+b;if(a){a.addCls(g)}else{if(!Ext.Array.contains(k[b],g)){k[b].push(g)}}}}},removeUIFromElement:function(){var h=this,j=h.baseCls+"-"+h.ui,k=h.frameElementCls,f,e,d,a,b,g;h.removeCls(j);if(h.frame&&!Ext.supports.CSS3BorderRadius){f=h.frameElementsArray;e=f.length;d=0;for(;d<e;d++){b=f[d];a=h["frame"+b.toUpperCase()];g=j+"-"+b;if(a){a.removeCls(g)}else{Ext.Array.remove(k[b],g)}}}},getTpl:function(a){return Ext.XTemplate.getTpl(this,a)},initStyles:function(i){var d=this,b=Ext.Element,f=d.padding,c=d.margin,g=d.x,e=d.y,a,h;if(f!==undefined){i.setStyle("padding",b.unitizeBox((f===true)?5:f))}if(c!==undefined){i.setStyle("margin",b.unitizeBox((c===true)?5:c))}if(d.border!==undefined){d.setBorder(d.border,i)}if(d.cls&&d.cls!=d.initialCls){i.addCls(d.cls);delete d.cls;delete d.initialCls}if(d.style&&d.style!=d.initialStyle){i.setStyle(d.style);delete d.style;delete d.initialStyle}if(g!==undefined){i.setStyle("left",(typeof g=="number")?(g+"px"):g)}if(e!==undefined){i.setStyle("top",(typeof e=="number")?(e+"px"):e)}if(!d.getFrameInfo()){a=d.width;h=d.height;if(a!==undefined){if(typeof a==="number"){if(Ext.isBorderBox){i.setStyle("width",a+"px")}}else{i.setStyle("width",a)}}if(h!==undefined){if(typeof h==="number"){if(Ext.isBorderBox){i.setStyle("height",h+"px")}}else{i.setStyle("height",h)}}}},initEvents:function(){var c=this,e=c.afterRenderEvents,b,d,a=function(f){c.mon(b,f)};if(e){for(d in e){if(e.hasOwnProperty(d)){b=c[d];if(b&&b.on){Ext.each(e[d],a)}}}}c.addFocusListener()},addFocusListener:function(){var c=this,b=c.getFocusEl(),a;if(b){if(b.isComponent){return b.addFocusListener()}a=b.needsTabIndex();if(!c.focusListenerAdded&&(!a||Ext.FocusManager.enabled)){if(a){b.dom.tabIndex=-1}b.on({focus:c.onFocus,blur:c.onBlur,scope:c});c.focusListenerAdded=true}}},getFocusEl:Ext.emptyFn,isFocusable:function(d){var b=this,a;if((b.focusable!==false)&&(a=b.getFocusEl())&&b.rendered&&!b.destroying&&!b.isDestroyed&&!b.disabled&&b.isVisible(true)){if(a.isComponent){return a.isFocusable()}return a&&a.dom&&a.isVisible()}},preFocus:Ext.emptyFn,onFocus:function(d){var c=this,b=c.focusCls,a=c.getFocusEl();if(!c.disabled){c.preFocus(d);if(b&&a){a.addCls(c.addClsWithUI(b,true))}if(!c.hasFocus){c.hasFocus=true;c.fireEvent("focus",c,d)}}},beforeBlur:Ext.emptyFn,onBlur:function(d){var c=this,b=c.focusCls,a=c.getFocusEl();if(c.destroying){return}c.beforeBlur(d);if(b&&a){a.removeCls(c.removeClsWithUI(b,true))}if(c.validateOnBlur){c.validate()}c.hasFocus=false;c.fireEvent("blur",c,d);c.postBlur(d)},postBlur:Ext.emptyFn,is:function(a){return Ext.ComponentQuery.is(this,a)},up:function(b){var a=this.getBubbleTarget();if(b){for(;a;a=a.getBubbleTarget()){if(Ext.ComponentQuery.is(a,b)){return a}}}return a},nextSibling:function(b){var f=this.ownerCt,d,e,a,g;if(f){d=f.items;a=d.indexOf(this)+1;if(a){if(b){for(e=d.getCount();a<e;a++){if((g=d.getAt(a)).is(b)){return g}}}else{if(a<d.getCount()){return d.getAt(a)}}}}return null},previousSibling:function(b){var e=this.ownerCt,d,a,f;if(e){d=e.items;a=d.indexOf(this);if(a!=-1){if(b){for(--a;a>=0;a--){if((f=d.getAt(a)).is(b)){return f}}}else{if(a){return d.getAt(--a)}}}}return null},previousNode:function(b,d){var h=this,g=h.ownerCt,a,f,e,c;if(d&&h.is(b)){return h}if(g){for(f=g.items.items,e=Ext.Array.indexOf(f,h)-1;e>-1;e--){c=f[e];if(c.query){a=c.query(b);a=a[a.length-1];if(a){return a}}if(c.is(b)){return c}}return g.previousNode(b,true)}return null},nextNode:function(d,h){var b=this,c=b.ownerCt,j,e,g,f,a;if(h&&b.is(d)){return b}if(c){for(e=c.items.items,f=Ext.Array.indexOf(e,b)+1,g=e.length;f<g;f++){a=e[f];if(a.is(d)){return a}if(a.down){j=a.down(d);if(j){return j}}}return c.nextNode(d)}return null},getId:function(){return this.id||(this.id="ext-comp-"+(this.getAutoId()))},getItemId:function(){return this.itemId||this.id},getEl:function(){return this.el},getTargetEl:function(){return this.frameBody||this.el},getOverflowStyle:function(){var b=this,a=null;if(typeof b.autoScroll=="boolean"){a={overflow:b.autoScroll?"auto":""}}else{if(b.overflowX!==undefined||b.overflowY!==undefined){a={"overflow-x":(b.overflowX||""),"overflow-y":(b.overflowY||"")}}}if(a&&(Ext.isIE6||Ext.isIE7)){a.position="relative"}return a},isXType:function(b,a){if(a){return this.xtype===b}else{return this.xtypesMap[b]}},getXTypes:function(){var c=this.self,d,b,a;if(!c.xtypes){d=[];b=this;while(b){a=b.xtypes;if(a!==undefined){d.unshift.apply(d,a)}b=b.superclass}c.xtypeChain=d;c.xtypes=d.join("/")}return c.xtypes},update:function(b,c,a){var d=this;if(d.tpl&&!Ext.isString(b)){d.data=b;if(d.rendered){d.tpl[d.tplWriteMode](d.getTargetEl(),b||{})}}else{d.html=Ext.isObject(b)?Ext.DomHelper.markup(b):b;if(d.rendered){d.getTargetEl().update(d.html,c,a)}}if(d.rendered){d.updateLayout()}},setVisible:function(a){return this[a?"show":"hide"]()},isVisible:function(a){var c=this,e=c,d=c.rendered&&!c.hidden,b=c.ownerCt;c.hiddenAncestor=false;if(c.destroyed){return false}if(a&&d&&b){while(b){if(b.hidden||(b.collapsed&&!(b.getDockedItems&&Ext.Array.contains(b.getDockedItems(),e)))){c.hiddenAncestor=b;d=false;break}e=b;b=b.ownerCt}}return d},onBoxReady:function(){var a=this;if(a.disableOnBoxReady){a.onDisable()}else{if(a.enableOnBoxReady){a.onEnable()}}if(a.resizable){a.initResizable(a.resizable)}if(a.draggable){a.initDraggable()}},enable:function(a){var b=this;delete b.disableOnBoxReady;b.removeCls(b.disabledCls);if(b.rendered){b.onEnable()}else{b.enableOnBoxReady=true}b.disabled=false;delete b.resetDisable;if(a!==true){b.fireEvent("enable",b)}return b},disable:function(a){var b=this;delete b.enableOnBoxReady;b.addCls(b.disabledCls);if(b.rendered){b.onDisable()}else{b.disableOnBoxReady=true}b.disabled=true;if(a!==true){delete b.resetDisable;b.fireEvent("disable",b)}return b},onEnable:function(){if(this.maskOnDisable){this.el.dom.disabled=false;this.unmask()}},onDisable:function(){var c=this,b=c.focusCls,a=c.getFocusEl();if(b&&a){a.removeCls(c.removeClsWithUI(b,true))}if(c.maskOnDisable){c.el.dom.disabled=true;c.mask()}},mask:function(){var b=this.lastBox,c=this.getMaskTarget(),a=[];if(b){a[2]=b.height}c.mask.apply(c,a)},unmask:function(){this.getMaskTarget().unmask()},getMaskTarget:function(){return this.el},isDisabled:function(){return this.disabled},setDisabled:function(a){return this[a?"disable":"enable"]()},isHidden:function(){return this.hidden},addCls:function(a){var c=this,b=c.rendered?c.el:c.protoEl;b.addCls.apply(b,arguments);return c},addClass:function(){return this.addCls.apply(this,arguments)},hasCls:function(a){var c=this,b=c.rendered?c.el:c.protoEl;return b.hasCls.apply(b,arguments)},removeCls:function(a){var c=this,b=c.rendered?c.el:c.protoEl;b.removeCls.apply(b,arguments);return c},addOverCls:function(){var a=this;if(!a.disabled){a.el.addCls(a.overCls)}},removeOverCls:function(){this.el.removeCls(this.overCls)},addListener:function(b,f,e,a){var g=this,d,c;if(Ext.isString(b)&&(Ext.isObject(f)||a&&a.element)){if(a.element){d=f;f={};f[b]=d;b=a.element;if(e){f.scope=e}for(c in a){if(a.hasOwnProperty(c)){if(g.eventOptionsRe.test(c)){f[c]=a[c]}}}}if(g[b]&&g[b].on){g.mon(g[b],f)}else{g.afterRenderEvents=g.afterRenderEvents||{};if(!g.afterRenderEvents[b]){g.afterRenderEvents[b]=[]}g.afterRenderEvents[b].push(f)}}return g.mixins.observable.addListener.apply(g,arguments)},removeManagedListenerItem:function(b,a,h,d,f,e){var g=this,c=a.options?a.options.element:null;if(c){c=g[c];if(c&&c.un){if(b||(a.item===h&&a.ename===d&&(!f||a.fn===f)&&(!e||a.scope===e))){c.un(a.ename,a.fn,a.scope);if(!b){Ext.Array.remove(g.managedListeners,a)}}}}else{return g.mixins.observable.removeManagedListenerItem.apply(g,arguments)}},getBubbleTarget:function(){return this.ownerCt},isFloating:function(){return this.floating},isDraggable:function(){return !!this.draggable},isDroppable:function(){return !!this.droppable},onAdded:function(a,c){var b=this;b.ownerCt=a;if(b.hasListeners.added){b.fireEvent("added",b,a,c)}},onRemoved:function(b){var a=this;if(a.hasListeners.removed){a.fireEvent("removed",a,a.ownerCt)}delete a.ownerCt;delete a.ownerLayout},beforeDestroy:Ext.emptyFn,onResize:Ext.emptyFn,setSize:function(b,a){var c=this;if(b&&typeof b=="object"){a=b.height;b=b.width}if(typeof b=="number"){c.width=Ext.Number.constrain(b,c.minWidth,c.maxWidth)}else{if(b===null){delete c.width}}if(typeof a=="number"){c.height=Ext.Number.constrain(a,c.minHeight,c.maxHeight)}else{if(a===null){delete c.height}}if(c.rendered&&c.isVisible()){c.updateLayout({isRoot:false})}return c},isLayoutRoot:function(){var a=this,b=a.ownerLayout;if(!b||a._isLayoutRoot||a.floating){return true}return b.isItemLayoutRoot(a)},isLayoutSuspended:function(){var a=this,b;while(a){if(a.layoutSuspendCount||a.suspendLayout){return true}b=a.ownerLayout;if(!b){break}a=b.owner}return false},updateLayout:function(b){var c=this,d,a=b&&b.isRoot;if(!c.rendered||c.layoutSuspendCount||c.suspendLayout){return}if(c.hidden){Ext.AbstractComponent.cancelLayout(c)}else{if(typeof a!="boolean"){a=c.isLayoutRoot()}}if(a||!c.ownerLayout||!c.ownerLayout.onContentChange(c)){if(!c.isLayoutSuspended()){d=(b&&b.hasOwnProperty("defer"))?b.defer:c.deferLayouts;Ext.AbstractComponent.updateLayout(c,d)}}},getSizeModel:function(i){var m=this,a=Ext.layout.SizeModel,d=m.componentLayout.ownerContext,b=m.width,o=m.height,p,c,f,e,g,n,k,l,j,h;if(d){h=d.widthModel;g=d.heightModel}if(!h||!g){f=((p=typeof b)=="number");e=((c=typeof o)=="number");j=m.floating||!(n=m.ownerLayout);if(j){k=Ext.layout.Layout.prototype.autoSizePolicy;l=m.floating?3:m.shrinkWrap;if(f){h=a.configured}if(e){g=a.configured}}else{k=n.getItemSizePolicy(m,i);l=n.isItemShrinkWrap(m)}l=(l===true)?3:(l||0);if(j&&l){if(b&&p=="string"){l&=2}if(o&&c=="string"){l&=1}}if(l!==3){if(!i){i=m.ownerCt&&m.ownerCt.getSizeModel()}if(i){l|=(i.width.shrinkWrap?1:0)|(i.height.shrinkWrap?2:0)}}if(!h){if(!k.setsWidth){if(f){h=a.configured}else{h=(l&1)?a.shrinkWrap:a.natural}}else{if(k.readsWidth){if(f){h=a.calculatedFromConfigured}else{h=(l&1)?a.calculatedFromShrinkWrap:a.calculatedFromNatural}}else{h=a.calculated}}}if(!g){if(!k.setsHeight){if(e){g=a.configured}else{g=(l&2)?a.shrinkWrap:a.natural}}else{if(k.readsHeight){if(e){g=a.calculatedFromConfigured}else{g=(l&2)?a.calculatedFromShrinkWrap:a.calculatedFromNatural}}else{g=a.calculated}}}}return h.pairsByHeightOrdinal[g.ordinal]},isDescendant:function(a){if(a.isContainer){for(var b=this.ownerCt;b;b=b.ownerCt){if(b===a){return true}}}return false},doComponentLayout:function(){this.updateLayout();return this},forceComponentLayout:function(){this.updateLayout()},setComponentLayout:function(b){var a=this.componentLayout;if(a&&a.isLayout&&a!=b){a.setOwner(null)}this.componentLayout=b;b.setOwner(this)},getComponentLayout:function(){var a=this;if(!a.componentLayout||!a.componentLayout.isLayout){a.setComponentLayout(Ext.layout.Layout.create(a.componentLayout,"autocomponent"))}return a.componentLayout},afterComponentLayout:function(a,j,b,h){var f=this,g,d,c,e;if(++f.componentLayoutCounter===1){f.afterFirstLayout(a,j)}if(f.floatingItems){g=f.floatingItems.items;d=g.length;for(c=0;c<d;c++){e=g[c];if(!e.rendered&&e.autoShow){e.show()}}}if(f.hasListeners.resize&&(a!==b||j!==h)){f.fireEvent("resize",f,a,j,b,h)}},beforeComponentLayout:function(b,a){return true},setPosition:function(a,e,b){var c=this,d=c.beforeSetPosition.apply(c,arguments);if(d&&c.rendered){d=c.convertPosition(d);if(d.left!==c.el.getLeft()||d.top!==c.el.getTop()){if(b){c.stopAnimation();c.animate(Ext.apply({duration:1000,listeners:{afteranimate:Ext.Function.bind(c.afterSetPosition,c,[d.left,d.top])},to:d},b))}else{if(d.left!==undefined&&d.top!==undefined){c.el.setLeftTop(d.left,d.top)}else{if(d.left!==undefined){c.el.setLeft(d.left)}else{if(d.top!==undefined){c.el.setTop(d.top)}}}c.afterSetPosition(d.left,d.top)}}}return c},beforeSetPosition:function(a,e,b){var d,c;if(!a||Ext.isNumber(a)){d={x:a,y:e,anim:b}}else{if(Ext.isNumber(c=a[0])){d={x:c,y:a[1],anim:e}}else{d={x:a.x,y:a.y,anim:e}}}d.hasX=Ext.isNumber(d.x);d.hasY=Ext.isNumber(d.y);this.x=d.x;this.y=d.y;return(d.hasX||d.hasY)?d:null},afterSetPosition:function(a,c){var b=this;b.onPosition(a,c);if(b.hasListeners.move){b.fireEvent("move",b,a,c)}},convertPosition:function(d,b){var a={},c=Ext.Element;if(d.hasX){a.left=b?c.addUnits(d.x):d.x}if(d.hasY){a.top=b?c.addUnits(d.y):d.y}return a},onPosition:Ext.emptyFn,setWidth:function(a){return this.setSize(a)},setHeight:function(a){return this.setSize(undefined,a)},getSize:function(){return this.el.getSize()},getWidth:function(){return this.el.getWidth()},getHeight:function(){return this.el.getHeight()},getLoader:function(){var c=this,b=c.autoLoad?(Ext.isObject(c.autoLoad)?c.autoLoad:{url:c.autoLoad}):null,a=c.loader||b;if(a){if(!a.isLoader){c.loader=new Ext.ComponentLoader(Ext.apply({target:c,autoLoad:b},a))}else{a.setTarget(c)}return c.loader}return null},setDocked:function(b,c){var a=this;a.dock=b;if(c&&a.ownerCt&&a.rendered){a.ownerCt.updateLayout()}return a},setBorder:function(b,d){var c=this,a=!!d;if(c.rendered||a){if(!a){d=c.el}if(!b){b=0}else{b=Ext.Element.unitizeBox((b===true)?1:b)}d.setStyle("border-width",b);if(!a){c.updateLayout()}}c.border=b},onDestroy:function(){var a=this;if(a.monitorResize&&Ext.EventManager.resizeEvent){Ext.EventManager.resizeEvent.removeListener(a.setSize,a)}Ext.destroy(a.componentLayout,a.loadMask,a.floatingDescendants)},destroy:function(){var d=this,b=d.renderSelectors,a,c;if(!d.isDestroyed){if(!d.hasListeners.beforedestroy||d.fireEvent("beforedestroy",d)!==false){d.destroying=true;d.beforeDestroy();if(d.floating){delete d.floatParent;if(d.zIndexManager){d.zIndexManager.unregister(d)}}else{if(d.ownerCt&&d.ownerCt.remove){d.ownerCt.remove(d,false)}}d.onDestroy();Ext.destroy(d.plugins);if(d.hasListeners.destroy){d.fireEvent("destroy",d)}Ext.ComponentManager.unregister(d);d.mixins.state.destroy.call(d);d.clearListeners();if(d.rendered){if(!d.preserveElOnDestroy){d.el.remove()}d.mixins.elementCt.destroy.call(d);if(b){for(a in b){if(b.hasOwnProperty(a)){c=d[a];if(c){delete d[a];c.remove()}}}}delete d.el;delete d.frameBody;delete d.rendered}d.destroying=false;d.isDestroyed=true}}},getPlugin:function(b){var c=0,a=this.plugins,d=a.length;for(;c<d;c++){if(a[c].pluginId===b){return a[c]}}},isDescendantOf:function(a){return !!this.findParentBy(function(b){return b===a})}},function(){var a=this;a.createAlias({on:"addListener",prev:"previousSibling",next:"nextSibling"});Ext.resumeLayouts=function(b){a.resumeLayouts(b)};Ext.suspendLayouts=function(){a.suspendLayouts()};Ext.batchLayouts=function(c,b){a.suspendLayouts();c.call(b);a.resumeLayouts(true)}});Ext.define("Ext.Component",{alias:["widget.component","widget.box"],extend:"Ext.AbstractComponent",requires:["Ext.util.DelayedTask"],uses:["Ext.Layer","Ext.resizer.Resizer","Ext.util.ComponentDragger"],mixins:{floating:"Ext.util.Floating"},statics:{DIRECTION_TOP:"top",DIRECTION_RIGHT:"right",DIRECTION_BOTTOM:"bottom",DIRECTION_LEFT:"left",VERTICAL_DIRECTION_Re:/^(?:top|bottom)$/,INVALID_ID_CHARS_Re:/[\.,\s]/g},resizeHandles:"all",floating:false,toFrontOnShow:true,hideMode:"display",bubbleEvents:[],monPropRe:/^(?:scope|delay|buffer|single|stopEvent|preventDefault|stopPropagation|normalized|args|delegate)$/,constructor:function(a){var b=this;a=a||{};if(a.initialConfig){if(a.isAction){b.baseAction=a}a=a.initialConfig}else{if(a.tagName||a.dom||Ext.isString(a)){a={applyTo:a,id:a.id||a}}}b.callParent([a]);if(b.baseAction){b.baseAction.addComponent(b)}},initComponent:function(){var a=this;a.callParent();if(a.listeners){a.on(a.listeners);a.listeners=null}a.enableBubble(a.bubbleEvents);a.mons=[]},afterRender:function(){var a=this;a.callParent();if(!(a.x&&a.y)&&(a.pageX||a.pageY)){a.setPagePosition(a.pageX,a.pageY)}},setAutoScroll:function(a){var b=this;b.autoScroll=!!a;if(b.rendered){b.getTargetEl().setStyle(b.getOverflowStyle())}b.updateLayout();return b},setOverflowXY:function(b,a){var c=this,d=arguments.length;if(d){c.overflowX=b||"";if(d>1){c.overflowY=a||""}}if(c.rendered){c.getTargetEl().setStyle(c.getOverflowStyle())}c.updateLayout();return c},beforeRender:function(){var b=this,c=b.floating,a;if(c){b.addCls(Ext.baseCSSPrefix+"layer");a=c.cls;if(a){b.addCls(a)}}return b.callParent()},afterComponentLayout:function(){this.callParent(arguments);if(this.floating){this.onAfterFloatLayout()}},makeFloating:function(a){this.mixins.floating.constructor.call(this,a)},wrapPrimaryEl:function(a){if(this.floating){this.makeFloating(a)}else{this.callParent(arguments)}},initResizable:function(a){var b=this;a=Ext.apply({target:b,dynamic:false,constrainTo:b.constrainTo||(b.floatParent?b.floatParent.getTargetEl():null),handles:b.resizeHandles},a);a.target=b;b.resizer=new Ext.resizer.Resizer(a)},getDragEl:function(){return this.el},initDraggable:function(){var c=this,a=(c.resizer&&c.resizer.el!==c.el)?c.resizerComponent=new Ext.Component({el:c.resizer.el,rendered:true,container:c.container}):c,b=Ext.applyIf({el:a.getDragEl(),constrainTo:c.constrain?(c.constrainTo||(c.floatParent?c.floatParent.getTargetEl():c.el.getScopeParent())):undefined},c.draggable);if(c.constrain||c.constrainDelegate){b.constrain=c.constrain;b.constrainDelegate=c.constrainDelegate}c.dd=new Ext.util.ComponentDragger(a,b)},scrollBy:function(b,a,c){var d;if((d=this.getTargetEl())&&d.dom){d.scrollBy.apply(d,arguments)}},setLoading:function(c,d){var b=this,a;if(b.rendered){Ext.destroy(b.loadMask);b.loadMask=null;if(c!==false&&!b.collapsed){if(Ext.isObject(c)){a=Ext.apply({},c)}else{if(Ext.isString(c)){a={msg:c}}else{a={}}}if(d){Ext.applyIf(a,{useTargetEl:true})}b.loadMask=new Ext.LoadMask(b,a);b.loadMask.show()}}return b.loadMask},beforeSetPosition:function(){var b=this,c=b.callParent(arguments),a;if(c){a=b.adjustPosition(c.x,c.y);c.x=a.x;c.y=a.y}return c||null},afterSetPosition:function(b,a){this.onPosition(b,a);this.fireEvent("move",this,b,a)},showAt:function(a,d,b){var c=this;if(!c.rendered&&(c.autoRender||c.floating)){c.doAutoRender();c.hidden=true}if(c.floating){c.setPosition(a,d,b)}else{c.setPagePosition(a,d,b)}c.show()},setPagePosition:function(a,f,b){var c=this,d,e;if(Ext.isArray(a)){f=a[1];a=a[0]}c.pageX=a;c.pageY=f;if(c.floating){if(c.isContainedFloater()){e=c.floatParent.getTargetEl().getViewRegion();if(Ext.isNumber(a)&&Ext.isNumber(e.left)){a-=e.left}if(Ext.isNumber(f)&&Ext.isNumber(e.top)){f-=e.top}}else{d=c.el.translatePoints(a,f);a=d.left;f=d.top}c.setPosition(a,f,b)}else{d=c.el.translatePoints(a,f);c.setPosition(d.left,d.top,b)}return c},isContainedFloater:function(){return(this.floating&&this.floatParent)},getBox:function(b){var c=b?this.getPosition(b):this.el.getXY(),a=this.getSize();a.x=c[0];a.y=c[1];return a},updateBox:function(a){this.setSize(a.width,a.height);this.setPagePosition(a.x,a.y);return this},getOuterSize:function(){var a=this.el;return{width:a.getWidth()+a.getMargin("lr"),height:a.getHeight()+a.getMargin("tb")}},adjustPosition:function(a,d){var b=this,c;if(b.isContainedFloater()){c=b.floatParent.getTargetEl().getViewRegion();a+=c.left;d+=c.top}return{x:a,y:d}},getPosition:function(a){var c=this,b=c.el,e,d=c.isContainedFloater(),f;if((a===true)&&!d){return[b.getLocalX(),b.getLocalY()]}e=c.el.getXY();if((a===true)&&d){f=c.floatParent.getTargetEl().getViewRegion();e[0]-=f.left;e[1]-=f.top}return e},getId:function(){var a=this,b;if(!a.id){b=a.getXType();if(b){b=b.replace(Ext.Component.INVALID_ID_CHARS_Re,"-")}else{b=Ext.name.toLowerCase()+"-comp"}a.id=b+"-"+a.getAutoId()}return a.id},show:function(d,a,b){var c=this,e=c.rendered;if(e&&c.isVisible()){if(c.toFrontOnShow&&c.floating){c.toFront()}}else{if(c.fireEvent("beforeshow",c)!==false){c.hidden=false;if(!e&&(c.autoRender||c.floating)){c.doAutoRender();e=c.rendered}if(e){c.beforeShow();c.onShow.apply(c,arguments);c.afterShow.apply(c,arguments)}}else{c.onShowVeto()}}return c},onShowVeto:Ext.emptyFn,beforeShow:Ext.emptyFn,onShow:function(){var a=this;a.el.show();a.callParent(arguments);if(a.floating){if(a.maximized){a.fitContainer()}else{if(a.constrain){a.doConstrain()}}}},afterShow:function(g,b,e){var f=this,a,c,d;g=g||f.animateTarget;if(!f.ghost){g=null}if(g){g=g.el?g.el:Ext.get(g);c=f.el.getBox();a=g.getBox();f.el.addCls(Ext.baseCSSPrefix+"hide-offsets");d=f.ghost();d.el.stopAnimation();d.el.setX(-10000);d.el.animate({from:a,to:c,listeners:{afteranimate:function(){delete d.componentLayout.lastComponentSize;f.unghost();f.el.removeCls(Ext.baseCSSPrefix+"hide-offsets");f.onShowComplete(b,e)}}})}else{f.onShowComplete(b,e)}},onShowComplete:function(a,b){var c=this;if(c.floating){c.toFront();c.onFloatShow()}Ext.callback(a,b||c);c.fireEvent("show",c);delete c.hiddenByLayout},hide:function(){var a=this;a.showOnParentShow=false;if(!(a.rendered&&!a.isVisible())&&a.fireEvent("beforehide",a)!==false){a.hidden=true;if(a.rendered){a.onHide.apply(a,arguments)}}return a},onHide:function(f,a,d){var e=this,c,b;f=f||e.animateTarget;if(!e.ghost){f=null}if(f){f=f.el?f.el:Ext.get(f);c=e.ghost();c.el.stopAnimation();b=f.getBox();b.width+="px";b.height+="px";c.el.animate({to:b,listeners:{afteranimate:function(){delete c.componentLayout.lastComponentSize;c.el.hide();e.afterHide(a,d)}}})}e.el.hide();if(!f){e.afterHide(a,d)}},afterHide:function(a,b){var c=this;delete c.hiddenByLayout;Ext.AbstractComponent.prototype.onHide.call(this);Ext.callback(a,b||c);c.fireEvent("hide",c)},onDestroy:function(){var a=this;if(a.rendered){Ext.destroy(a.proxy,a.proxyWrap,a.resizer,a.resizerComponent)}delete a.focusTask;a.callParent()},deleteMembers:function(){var b=arguments,a=b.length,c=0;for(;c<a;++c){delete this[b[c]]}},focus:function(e,c){var d=this,a,f,b;if(c){if(!d.focusTask){d.focusTask=new Ext.util.DelayedTask(d.focus)}d.focusTask.delay(Ext.isNumber(c)?c:10,null,d,[e,false]);return d}if(d.rendered&&!d.isDestroyed&&d.isVisible(true)&&(a=d.getFocusEl())){if(a.isComponent){return a.focus(e,c)}if((f=a.dom)){if(a.needsTabIndex()){f.tabIndex=-1}if(d.floating){b=d.container.dom.scrollTop}a.focus();if(e===true){f.select()}}if(d.floating){d.toFront(true);if(b!==undefined){d.container.dom.scrollTop=b}}}return d},cancelFocus:function(){var a=this.focusTask;if(a){a.cancel()}},blur:function(){var a;if(this.rendered&&(a=this.getFocusEl())){a.blur()}return this},getEl:function(){return this.el},getResizeEl:function(){return this.el},getPositionEl:function(){return this.el},getActionEl:function(){return this.el},getVisibilityEl:function(){return this.el},onResize:Ext.emptyFn,getBubbleTarget:function(){return this.ownerCt||this.floatParent},getContentTarget:function(){return this.el},cloneConfig:function(c){c=c||{};var d=c.id||Ext.id(),a=Ext.applyIf(c,this.initialConfig),b;a.id=d;b=Ext.getClass(this);return new b(a)},getXType:function(){return this.self.xtype},findParentBy:function(a){var b;for(b=this.getBubbleTarget();b&&!a(b,this);b=b.getBubbleTarget()){}return b||null},findParentByType:function(a){return Ext.isFunction(a)?this.findParentBy(function(b){return b.constructor===a}):this.up(a)},bubble:function(c,b,a){var d=this;while(d){if(c.apply(b||d,a||[d])===false){break}d=d.getBubbleTarget()}return this},getProxy:function(){var a=this,b;if(!a.proxy){b=Ext.getBody();if(Ext.scopeResetCSS){a.proxyWrap=b=Ext.getBody().createChild({cls:Ext.resetCls})}a.proxy=a.el.createProxy(Ext.baseCSSPrefix+"proxy-el",b,true)}return a.proxy}});Ext.define("Ext.button.Button",{alias:"widget.button",extend:"Ext.Component",requires:["Ext.menu.Manager","Ext.util.ClickRepeater","Ext.layout.component.Button","Ext.util.TextMetrics","Ext.util.KeyMap"],alternateClassName:"Ext.Button",isButton:true,componentLayout:"button",hidden:false,disabled:false,pressed:false,enableToggle:false,menuAlign:"tl-bl?",textAlign:"center",type:"button",clickEvent:"click",preventDefault:true,handleMouseEvents:true,tooltipType:"qtip",baseCls:Ext.baseCSSPrefix+"btn",pressedCls:"pressed",overCls:"over",focusCls:"focus",menuActiveCls:"menu-active",hrefTarget:"_blank",border:true,childEls:["btnEl","btnWrap","btnInnerEl","btnIconEl"],renderTpl:['<em id="{id}-btnWrap"<tpl if="splitCls"> class="{splitCls}"</tpl>>','<tpl if="href">','<a id="{id}-btnEl" href="{href}" class="{btnCls}" target="{hrefTarget}"','<tpl if="tabIndex"> tabIndex="{tabIndex}"</tpl>','<tpl if="disabled"> disabled="disabled"</tpl>',' role="link">','<span id="{id}-btnInnerEl" class="{baseCls}-inner">',"{text}","</span>",'<span id="{id}-btnIconEl" class="{baseCls}-icon {iconCls}"<tpl if="iconUrl"> style="background-image:url({iconUrl})"</tpl>></span>',"</a>","<tpl else>",'<button id="{id}-btnEl" type="{type}" class="{btnCls}" hidefocus="true"','<tpl if="tabIndex"> tabIndex="{tabIndex}"</tpl>','<tpl if="disabled"> disabled="disabled"</tpl>',' role="button" autocomplete="off">','<span id="{id}-btnInnerEl" class="{baseCls}-inner" style="{innerSpanStyle}">',"{text}","</span>",'<span id="{id}-btnIconEl" class="{baseCls}-icon {iconCls}"<tpl if="iconUrl"> style="background-image:url({iconUrl})"</tpl>></span>',"</button>","</tpl>","</em>",'<tpl if="closable">','<a id="{id}-closeEl" href="#" class="{baseCls}-close-btn" title="{closeText}"></a>',"</tpl>"],scale:"small",allowedScales:["small","medium","large"],iconAlign:"left",arrowAlign:"right",arrowCls:"arrow",maskOnDisable:false,persistentPadding:undefined,shrinkWrap:3,frame:true,initComponent:function(){var a=this;a.callParent(arguments);a.addEvents("click","toggle","mouseover","mouseout","menushow","menuhide","menutriggerover","menutriggerout");if(a.menu){a.split=true;a.menu=Ext.menu.Manager.get(a.menu);a.menu.ownerButton=a}if(a.url){a.href=a.url}if(a.href&&!a.hasOwnProperty("preventDefault")){a.preventDefault=false}if(Ext.isString(a.toggleGroup)&&a.toggleGroup!==""){a.enableToggle=true}if(a.html&&!a.text){a.text=a.html;delete a.html}},getActionEl:function(){return this.btnEl},getFocusEl:function(){return this.useElForFocus?this.el:this.btnEl},onFocus:function(b){var a=this;a.useElForFocus=true;a.callParent(arguments);a.useElForFocus=false},onBlur:function(a){this.useElForFocus=true;this.callParent(arguments);this.useElForFocus=false},onDisable:function(){this.useElForFocus=true;this.callParent(arguments);this.useElForFocus=false},setComponentCls:function(){var b=this,a=b.getComponentCls();if(!Ext.isEmpty(b.oldCls)){b.removeClsWithUI(b.oldCls);b.removeClsWithUI(b.pressedCls)}b.oldCls=a;b.addClsWithUI(a)},getComponentCls:function(){var b=this,a=[];if(b.iconCls||b.icon){if(b.text){a.push("icon-text-"+b.iconAlign)}else{a.push("icon")}}else{if(b.text){a.push("noicon")}}if(b.pressed){a.push(b.pressedCls)}return a},beforeRender:function(){var a=this;a.callParent();a.oldCls=a.getComponentCls();a.addClsWithUI(a.oldCls);Ext.applyIf(a.renderData,a.getTemplateArgs());if(a.scale){a.setScale(a.scale)}},onRender:function(){var c=this,d,a,b;c.doc=Ext.getDoc();c.callParent(arguments);if(c.split&&c.arrowTooltip){c.arrowEl.dom.setAttribute(c.getTipAttr(),c.arrowTooltip)}a=c.el;if(c.tooltip){c.setTooltip(c.tooltip,true)}if(c.handleMouseEvents){b={scope:c,mouseover:c.onMouseOver,mouseout:c.onMouseOut,mousedown:c.onMouseDown};if(c.split){b.mousemove=c.onMouseMove}}else{b={scope:c}}if(c.menu){c.mon(c.menu,{scope:c,show:c.onMenuShow,hide:c.onMenuHide});c.keyMap=new Ext.util.KeyMap({target:c.el,key:Ext.EventObject.DOWN,handler:c.onDownKey,scope:c})}if(c.repeat){c.mon(new Ext.util.ClickRepeater(a,Ext.isObject(c.repeat)?c.repeat:{}),"click",c.onRepeatClick,c)}else{if(b[c.clickEvent]){d=true}else{b[c.clickEvent]=c.onClick}}c.mon(a,b);if(d){c.mon(a,c.clickEvent,c.onClick,c)}Ext.ButtonToggleManager.register(c)},getTemplateArgs:function(){var c=this,b=c.getPersistentPadding(),a="";if(Math.max.apply(Math,b)>0){a="margin:"+Ext.Array.map(b,function(d){return -d+"px"}).join(" ")}return{href:c.getHref(),disabled:c.disabled,hrefTarget:c.hrefTarget,type:c.type,btnCls:c.getBtnCls(),splitCls:c.getSplitCls(),iconUrl:c.icon,iconCls:c.iconCls,text:c.text||"&#160;",tabIndex:c.tabIndex,innerSpanStyle:a}},getHref:function(){var a=this,b=Ext.apply({},a.baseParams);b=Ext.apply(b,a.params);return a.href?Ext.urlAppend(a.href,Ext.Object.toQueryString(b)):false},setParams:function(a){this.params=a;this.btnEl.dom.href=this.getHref()},getSplitCls:function(){var a=this;return a.split?(a.baseCls+"-"+a.arrowCls)+" "+(a.baseCls+"-"+a.arrowCls+"-"+a.arrowAlign):""},getBtnCls:function(){return this.textAlign?this.baseCls+"-"+this.textAlign:""},setIconCls:function(b){var d=this,a=d.btnIconEl,c=d.iconCls;d.iconCls=b;if(a){a.removeCls(c);a.addCls(b||"");d.setComponentCls();if(d.didIconStateChange(c,b)){d.updateLayout()}}return d},setTooltip:function(c,a){var b=this;if(b.rendered){if(!a){b.clearTip()}if(Ext.isObject(c)){Ext.tip.QuickTipManager.register(Ext.apply({target:b.btnEl.id},c));b.tooltip=c}else{b.btnEl.dom.setAttribute(b.getTipAttr(),c)}}else{b.tooltip=c}return b},setTextAlign:function(c){var b=this,a=b.btnEl;if(a){a.removeCls(b.baseCls+"-"+b.textAlign);a.addCls(b.baseCls+"-"+c)}b.textAlign=c;return b},getTipAttr:function(){return this.tooltipType=="qtip"?"data-qtip":"title"},getRefItems:function(a){var c=this.menu,b;if(c){b=c.getRefItems(a);b.unshift(c)}return b||[]},clearTip:function(){if(Ext.isObject(this.tooltip)){Ext.tip.QuickTipManager.unregister(this.btnEl)}},beforeDestroy:function(){var a=this;if(a.rendered){a.clearTip()}if(a.menu&&a.destroyMenu!==false){Ext.destroy(a.menu)}Ext.destroy(a.btnInnerEl,a.repeater);a.callParent()},onDestroy:function(){var a=this;if(a.rendered){a.doc.un("mouseover",a.monitorMouseOver,a);a.doc.un("mouseup",a.onMouseUp,a);delete a.doc;Ext.ButtonToggleManager.unregister(a);Ext.destroy(a.keyMap);delete a.keyMap}a.callParent()},setHandler:function(b,a){this.handler=b;this.scope=a;return this},setText:function(b){var a=this;a.text=b;if(a.rendered){a.btnInnerEl.update(b||"&#160;");a.setComponentCls();if(Ext.isStrict&&Ext.isIE8){a.el.repaint()}a.updateLayout()}return a},setIcon:function(b){var c=this,a=c.btnIconEl,d=c.icon;c.icon=b;if(a){a.setStyle("background-image",b?"url("+b+")":"");c.setComponentCls();if(c.didIconStateChange(d,b)){c.updateLayout()}}return c},didIconStateChange:function(a,c){var b=Ext.isEmpty(c);return Ext.isEmpty(a)?!b:b},getText:function(){return this.text},toggle:function(c,a){var b=this;c=c===undefined?!b.pressed:!!c;if(c!==b.pressed){if(b.rendered){b[c?"addClsWithUI":"removeClsWithUI"](b.pressedCls)}b.pressed=c;if(!a){b.fireEvent("toggle",b,c);Ext.callback(b.toggleHandler,b.scope||b,[b,c])}}return b},maybeShowMenu:function(){var a=this;if(a.menu&&!a.hasVisibleMenu()&&!a.ignoreNextClick){a.showMenu()}},showMenu:function(){var a=this;if(a.rendered&&a.menu){if(a.tooltip&&a.getTipAttr()!="title"){Ext.tip.QuickTipManager.getQuickTip().cancelShow(a.btnEl)}if(a.menu.isVisible()){a.menu.hide()}a.menu.showBy(a.el,a.menuAlign,((!Ext.isStrict&&Ext.isIE)||Ext.isIE6)?[-2,-2]:undefined)}return a},hideMenu:function(){if(this.hasVisibleMenu()){this.menu.hide()}return this},hasVisibleMenu:function(){var a=this.menu;return a&&a.rendered&&a.isVisible()},onRepeatClick:function(a,b){this.onClick(b)},onClick:function(b){var a=this;if(a.preventDefault||(a.disabled&&a.getHref())&&b){b.preventDefault()}if(b.button!==0){return}if(!a.disabled){a.doToggle();a.maybeShowMenu();a.fireHandler(b)}},fireHandler:function(c){var b=this,a=b.handler;if(b.fireEvent("click",b,c)!==false){if(a){a.call(b.scope||b,b,c)}b.blur()}},doToggle:function(){var a=this;if(a.enableToggle&&(a.allowDepress!==false||!a.pressed)){a.toggle()}},onMouseOver:function(b){var a=this;if(!a.disabled&&!b.within(a.el,true,true)){a.onMouseEnter(b)}},onMouseOut:function(b){var a=this;if(!b.within(a.el,true,true)){if(a.overMenuTrigger){a.onMenuTriggerOut(b)}a.onMouseLeave(b)}},onMouseMove:function(g){var d=this,c=d.el,f=d.overMenuTrigger,b,a;if(d.split){if(d.arrowAlign==="right"){b=g.getX()-c.getX();a=c.getWidth()}else{b=g.getY()-c.getY();a=c.getHeight()}if(b>(a-d.getTriggerSize())){if(!f){d.onMenuTriggerOver(g)}}else{if(f){d.onMenuTriggerOut(g)}}}},getTriggerSize:function(){var e=this,c=e.triggerSize,b,a,d;if(c===d){b=e.arrowAlign;a=b.charAt(0);c=e.triggerSize=e.el.getFrameWidth(a)+e.btnWrap.getFrameWidth(a)+e.frameSize[b]}return c},onMouseEnter:function(b){var a=this;a.addClsWithUI(a.overCls);a.fireEvent("mouseover",a,b)},onMouseLeave:function(b){var a=this;a.removeClsWithUI(a.overCls);a.fireEvent("mouseout",a,b)},onMenuTriggerOver:function(b){var a=this;a.overMenuTrigger=true;a.fireEvent("menutriggerover",a,a.menu,b)},onMenuTriggerOut:function(b){var a=this;delete a.overMenuTrigger;a.fireEvent("menutriggerout",a,a.menu,b)},enable:function(a){var b=this;b.callParent(arguments);if(b.btnEl){b.btnEl.dom.disabled=false}b.removeClsWithUI("disabled");return b},disable:function(a){var b=this;b.callParent(arguments);if(b.btnEl){b.btnEl.dom.disabled=true}b.addClsWithUI("disabled");b.removeClsWithUI(b.overCls);if(b.btnInnerEl&&(Ext.isIE6||Ext.isIE7)){b.btnInnerEl.repaint()}return b},setScale:function(c){var a=this,b=a.ui.replace("-"+a.scale,"");if(!Ext.Array.contains(a.allowedScales,c)){throw ("#setScale: scale must be an allowed scale ("+a.allowedScales.join(", ")+")")}a.scale=c;a.setUI(b)},setUI:function(b){var a=this;if(a.scale&&!b.match(a.scale)){b=b+"-"+a.scale}a.callParent([b])},onMouseDown:function(b){var a=this;if(!a.disabled&&b.button===0){a.addClsWithUI(a.pressedCls);a.doc.on("mouseup",a.onMouseUp,a)}},onMouseUp:function(b){var a=this;if(b.button===0){if(!a.pressed){a.removeClsWithUI(a.pressedCls)}a.doc.un("mouseup",a.onMouseUp,a)}},onMenuShow:function(b){var a=this;a.ignoreNextClick=0;a.addClsWithUI(a.menuActiveCls);a.fireEvent("menushow",a,a.menu)},onMenuHide:function(b){var a=this;a.removeClsWithUI(a.menuActiveCls);a.ignoreNextClick=Ext.defer(a.restoreClick,250,a);a.fireEvent("menuhide",a,a.menu)},restoreClick:function(){this.ignoreNextClick=0},onDownKey:function(){var a=this;if(!a.disabled){if(a.menu){a.showMenu()}}},getPersistentPadding:function(){var f=this,e=Ext.scopeResetCSS,g=f.persistentPadding,b,a,d,h,c;if(!g){g=f.self.prototype.persistentPadding=[0,0,0,0];if(!Ext.isIE){b=new Ext.button.Button({text:"test",style:"position:absolute;top:-999px;"});b.el=Ext.DomHelper.append(Ext.resetElement,b.getRenderTree(),true);b.applyChildEls(b.el);d=b.btnEl;h=b.btnInnerEl;d.setSize(null,null);a=h.getOffsetsTo(d);g[0]=a[1];g[1]=d.getWidth()-h.getWidth()-a[0];g[2]=d.getHeight()-h.getHeight()-a[1];g[3]=a[0];b.destroy();b.el.remove()}}return g}},function(){var a={},b=function(d,h){if(h){var f=a[d.toggleGroup],e=f.length,c;for(c=0;c<e;c++){if(f[c]!==d){f[c].toggle(false)}}}};Ext.ButtonToggleManager={register:function(c){if(!c.toggleGroup){return}var d=a[c.toggleGroup];if(!d){d=a[c.toggleGroup]=[]}d.push(c);c.on("toggle",b)},unregister:function(c){if(!c.toggleGroup){return}var d=a[c.toggleGroup];if(d){Ext.Array.remove(d,c);c.un("toggle",b)}},getPressed:function(f){var e=a[f],d=0,c;if(e){for(c=e.length;d<c;d++){if(e[d].pressed===true){return e[d]}}}return null}}});Ext.define("Ext.ProgressBar",{extend:"Ext.Component",alias:"widget.progressbar",requires:["Ext.Template","Ext.CompositeElement","Ext.TaskManager","Ext.layout.component.ProgressBar"],uses:["Ext.fx.Anim"],baseCls:Ext.baseCSSPrefix+"progress",animate:false,text:"",waitTimer:null,childEls:["bar"],renderTpl:['<tpl if="internalText">','<div class="{baseCls}-text {baseCls}-text-back">{text}</div>',"</tpl>",'<div id="{id}-bar" class="{baseCls}-bar" style="width:{percentage}%">','<tpl if="internalText">','<div class="{baseCls}-text">',"<div>{text}</div>","</div>","</tpl>","</div>"],componentLayout:"progressbar",initComponent:function(){this.callParent();this.addEvents("update")},initRenderData:function(){var a=this;return Ext.apply(a.callParent(),{internalText:!a.hasOwnProperty("textEl"),text:a.text||"&#160;",percentage:a.value?a.value*100:0})},onRender:function(){var a=this;a.callParent(arguments);if(a.textEl){a.textEl=Ext.get(a.textEl);a.updateText(a.text)}else{a.textEl=a.el.select("."+a.baseCls+"-text")}},updateProgress:function(d,e,a){var c=this,b=c.value;c.value=d||0;if(e){c.updateText(e)}if(c.rendered&&!c.isDestroyed){if(a===true||(a!==false&&c.animate)){c.bar.stopAnimation();c.bar.animate(Ext.apply({from:{width:(b*100)+"%"},to:{width:(c.value*100)+"%"}},c.animate))}else{c.bar.setStyle("width",(c.value*100)+"%")}}c.fireEvent("update",c,c.value,e);return c},updateText:function(b){var a=this;a.text=b;if(a.rendered){a.textEl.update(a.text)}return a},applyText:function(a){this.updateText(a)},getText:function(){return this.text},wait:function(c){var b=this,a;if(!b.waitTimer){a=b;c=c||{};b.updateText(c.text);b.waitTimer=Ext.TaskManager.start({run:function(d){var e=c.increment||10;d-=1;b.updateProgress(((((d+e)%e)+1)*(100/e))*0.01,null,c.animate)},interval:c.interval||1000,duration:c.duration,onStop:function(){if(c.fn){c.fn.apply(c.scope||b)}b.reset()},scope:a})}return b},isWaiting:function(){return this.waitTimer!==null},reset:function(a){var b=this;b.updateProgress(0);b.clearTimer();if(a===true){b.hide()}return b},clearTimer:function(){var a=this;if(a.waitTimer){a.waitTimer.onStop=null;Ext.TaskManager.stop(a.waitTimer);a.waitTimer=null}},onDestroy:function(){var a=this;a.clearTimer();if(a.rendered){if(a.textEl.isComposite){a.textEl.clear()}Ext.destroyMembers(a,"textEl","progressBar")}a.callParent()}});Ext.define("Ext.chart.MaskLayer",{extend:"Ext.Component",constructor:function(a){a=Ext.apply(a||{},{style:"position:absolute;background-color:#888;cursor:move;opacity:0.6;border:1px solid #222;"});this.callParent([a])},initComponent:function(){var a=this;a.callParent(arguments);a.addEvents("mousedown","mouseup","mousemove","mouseenter","mouseleave")},initDraggable:function(){this.callParent(arguments);this.dd.onStart=function(c){var b=this,a=b.comp;this.startPosition=a.getPosition(true);if(a.ghost&&!a.liveDrag){b.proxy=a.ghost();b.dragTarget=b.proxy.header.el}if(b.constrain||b.constrainDelegate){b.constrainTo=b.calculateConstrainRegion()}}}});Ext.define("Ext.chart.Mask",{requires:["Ext.chart.MaskLayer"],constructor:function(a){var c=this,b;c.addEvents("select");if(a){Ext.apply(c,a)}if(c.enableMask){c.on("afterrender",function(){var d=new Ext.chart.MaskLayer({renderTo:c.el,hidden:true});d.el.on({mousemove:function(f){c.onMouseMove(f)},mouseup:function(f){c.resized(f)}});b=new Ext.resizer.Resizer({el:d.el,handles:"all",pinned:true});b.on({resize:function(f){c.resized(f)}});d.initDraggable();c.maskType=c.mask;c.mask=d;c.maskSprite=c.surface.add({type:"path",path:["M",0,0],zIndex:1001,opacity:0.7,hidden:true,stroke:"#444"})},c,{single:true})}},resized:function(d){var f=this,k=f.bbox||f.chartBBox,i=k.x,h=k.y,a=k.width,l=k.height,c=f.mask.getBox(true),g=Math.max,b=Math.min,m=c.x-i,j=c.y-h;m=g(m,i);j=g(j,h);m=b(m,a);j=b(j,l);c.x=m;c.y=j;f.fireEvent("select",f,c)},onMouseUp:function(c){var a=this,d=a.bbox||a.chartBBox,b=a.maskSelection;a.maskMouseDown=false;a.mouseDown=false;if(a.mouseMoved){a.onMouseMove(c);a.mouseMoved=false;a.fireEvent("select",a,{x:b.x-d.x,y:b.y-d.y,width:b.width,height:b.height})}},onMouseDown:function(b){var a=this;a.mouseDown=true;a.mouseMoved=false;a.maskMouseDown={x:b.getPageX()-a.el.getX(),y:b.getPageY()-a.el.getY()}},onMouseMove:function(s){var t=this,n=t.maskType,a=t.bbox||t.chartBBox,h=a.x,g=a.y,b=Math,p=b.floor,i=b.abs,m=b.min,o=b.max,j=p(g+a.height),l=p(h+a.width),d=s.getPageX(),c=s.getPageY(),r=d-t.el.getX(),q=c-t.el.getY(),f=t.maskMouseDown,k;t.mouseMoved=t.mouseDown;r=o(r,h);q=o(q,g);r=m(r,l);q=m(q,j);if(f&&t.mouseDown){if(n=="horizontal"){q=g;f.y=j;c=t.el.getY()+a.height+t.insetPadding}else{if(n=="vertical"){r=h;f.x=l}}l=f.x-r;j=f.y-q;k=["M",r,q,"l",l,0,0,j,-l,0,"z"];t.maskSelection={x:l>0?r:r+l,y:j>0?q:q+j,width:i(l),height:i(j)};t.mask.updateBox(t.maskSelection);t.mask.show();t.maskSprite.setAttributes({hidden:true},true)}else{if(n=="horizontal"){k=["M",r,g,"L",r,j]}else{if(n=="vertical"){k=["M",h,q,"L",l,q]}else{k=["M",r,g,"L",r,j,"M",h,q,"L",l,q]}}t.maskSprite.setAttributes({path:k,fill:t.maskMouseDown?t.maskSprite.stroke:false,"stroke-width":n===true?1:3,hidden:false},true)}},onMouseLeave:function(b){var a=this;a.mouseMoved=false;a.mouseDown=false;a.maskMouseDown=false;a.mask.hide();a.maskSprite.hide(true)}});Ext.define("Ext.toolbar.Spacer",{extend:"Ext.Component",alias:"widget.tbspacer",alternateClassName:"Ext.Toolbar.Spacer",baseCls:Ext.baseCSSPrefix+"toolbar-spacer",focusable:false});Ext.define("Ext.toolbar.Fill",{extend:"Ext.Component",alias:"widget.tbfill",alternateClassName:"Ext.Toolbar.Fill",isFill:true,flex:1});Ext.define("Ext.form.field.Base",{extend:"Ext.Component",mixins:{labelable:"Ext.form.Labelable",field:"Ext.form.field.Field"},alias:"widget.field",alternateClassName:["Ext.form.Field","Ext.form.BaseField"],requires:["Ext.util.DelayedTask","Ext.XTemplate","Ext.layout.component.field.Field"],fieldSubTpl:['<input id="{id}" type="{type}" {inputAttrTpl}',' size="1"','<tpl if="name"> name="{name}"</tpl>','<tpl if="value"> value="{[Ext.util.Format.htmlEncode(values.value)]}"</tpl>','<tpl if="placeholder"> placeholder="{placeholder}"</tpl>','{%if (values.maxLength !== undefined){%} maxlength="{maxLength}"{%}%}','<tpl if="readOnly"> readonly="readonly"</tpl>','<tpl if="disabled"> disabled="disabled"</tpl>','<tpl if="tabIdx"> tabIndex="{tabIdx}"</tpl>','<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',' class="{fieldCls} {typeCls} {editableCls}" autocomplete="off"/>',{disableFormats:true}],subTplInsertions:["inputAttrTpl"],inputType:"text",invalidText:"The value in this field is invalid",fieldCls:Ext.baseCSSPrefix+"form-field",focusCls:"form-focus",dirtyCls:Ext.baseCSSPrefix+"form-dirty",checkChangeEvents:Ext.isIE&&(!document.documentMode||document.documentMode<9)?["change","propertychange"]:["change","input","textInput","keyup","dragdrop"],checkChangeBuffer:50,componentLayout:"field",readOnly:false,readOnlyCls:Ext.baseCSSPrefix+"form-readonly",validateOnBlur:true,hasFocus:false,baseCls:Ext.baseCSSPrefix+"field",maskOnDisable:false,initComponent:function(){var a=this;a.callParent();a.subTplData=a.subTplData||{};a.addEvents("specialkey","writeablechange");a.initLabelable();a.initField();if(!a.name){a.name=a.getInputId()}},beforeRender:function(){var a=this;a.callParent(arguments);a.beforeLabelableRender(arguments);if(a.readOnly){a.addCls(a.readOnlyCls)}},getInputId:function(){return this.inputId||(this.inputId=this.id+"-inputEl")},getSubTplData:function(){var c=this,b=c.inputType,a=c.getInputId(),d;d=Ext.apply({id:a,cmpId:c.id,name:c.name||a,disabled:c.disabled,readOnly:c.readOnly,value:c.getRawValue(),type:b,fieldCls:c.fieldCls,fieldStyle:c.getFieldStyle(),tabIdx:c.tabIndex,typeCls:Ext.baseCSSPrefix+"form-"+(b==="password"?"text":b)},c.subTplData);c.getInsertionRenderData(d,c.subTplInsertions);return d},afterFirstLayout:function(){this.callParent();var a=this.inputEl;if(a){a.selectable()}},applyRenderSelectors:function(){var a=this;a.callParent();a.inputEl=a.el.getById(a.getInputId())},getSubTplMarkup:function(){return this.getTpl("fieldSubTpl").apply(this.getSubTplData())},initRenderTpl:function(){var a=this;if(!a.hasOwnProperty("renderTpl")){a.renderTpl=a.getTpl("labelableRenderTpl")}return a.callParent()},initRenderData:function(){return Ext.applyIf(this.callParent(),this.getLabelableRenderData())},setFieldStyle:function(a){var b=this,c=b.inputEl;if(c){c.applyStyles(a)}b.fieldStyle=a},getFieldStyle:function(){return"width:100%;"+(Ext.isObject(this.fieldStyle)?Ext.DomHelper.generateStyles(this.fieldStyle):this.fieldStyle||"")},onRender:function(){var a=this;a.callParent(arguments);a.onLabelableRender();a.renderActiveError()},getFocusEl:function(){return this.inputEl},isFileUpload:function(){return this.inputType==="file"},extractFileInput:function(){var b=this,a=b.isFileUpload()?b.inputEl.dom:null,c;if(a){c=a.cloneNode(true);a.parentNode.replaceChild(c,a);b.inputEl=Ext.get(c)}return a},getSubmitData:function(){var a=this,b=null,c;if(!a.disabled&&a.submitValue&&!a.isFileUpload()){c=a.getSubmitValue();if(c!==null){b={};b[a.getName()]=c}}return b},getSubmitValue:function(){return this.processRawValue(this.getRawValue())},getRawValue:function(){var b=this,a=(b.inputEl?b.inputEl.getValue():Ext.value(b.rawValue,""));b.rawValue=a;return a},setRawValue:function(b){var a=this;b=Ext.value(a.transformRawValue(b),"");a.rawValue=b;if(a.inputEl){a.inputEl.dom.value=b}return b},transformRawValue:function(a){return a},valueToRaw:function(a){return""+Ext.value(a,"")},rawToValue:function(a){return a},processRawValue:function(a){return a},getValue:function(){var a=this,b=a.rawToValue(a.processRawValue(a.getRawValue()));a.value=b;return b},setValue:function(b){var a=this;a.setRawValue(a.valueToRaw(b));return a.mixins.field.setValue.call(a,b)},onBoxReady:function(){var a=this;a.callParent();if(a.setReadOnlyOnBoxReady){a.setReadOnly(a.readOnly)}},onDisable:function(){var a=this,b=a.inputEl;a.callParent();if(b){b.dom.disabled=true;if(a.hasActiveError()){a.clearInvalid();a.needsValidateOnEnable=true}}},onEnable:function(){var a=this,b=a.inputEl;a.callParent();if(b){b.dom.disabled=false;if(a.needsValidateOnEnable){delete a.needsValidateOnEnable;a.forceValidation=true;a.isValid();delete a.forceValidation}}},setReadOnly:function(c){var a=this,b=a.inputEl;c=!!c;a[c?"addCls":"removeCls"](a.readOnlyCls);a.readOnly=c;if(b){b.dom.readOnly=c}else{if(a.rendering){a.setReadOnlyOnBoxReady=true}}a.fireEvent("writeablechange",a,c)},fireKey:function(a){if(a.isSpecialKey()){this.fireEvent("specialkey",this,new Ext.EventObjectImpl(a))}},initEvents:function(){var f=this,h=f.inputEl,b,i,c=f.checkChangeEvents,g,a=c.length,d;if(f.inEditor){f.onBlur=Ext.Function.createBuffered(f.onBlur,10)}if(h){f.mon(h,Ext.EventManager.getKeyEvent(),f.fireKey,f);b=new Ext.util.DelayedTask(f.checkChange,f);f.onChangeEvent=i=function(){b.delay(f.checkChangeBuffer)};for(g=0;g<a;g++){d=c[g];if(d==="propertychange"){f.usesPropertychange=true}f.mon(h,d,i)}}f.callParent()},doComponentLayout:function(){var c=this,d=c.inputEl,a=c.usesPropertychange,b="propertychange",e=c.onChangeEvent;if(a){c.mun(d,b,e)}c.callParent(arguments);if(a){c.mon(d,b,e)}},onDirtyChange:function(a){this[a?"addCls":"removeCls"](this.dirtyCls)},isValid:function(){var b=this,a=b.disabled,c=b.forceValidation||!a;return c?b.validateValue(b.processRawValue(b.getRawValue())):a},validateValue:function(b){var a=this,d=a.getErrors(b),c=Ext.isEmpty(d);if(!a.preventMark){if(c){a.clearInvalid()}else{a.markInvalid(d)}}return c},markInvalid:function(c){var b=this,a=b.getActiveError();b.setActiveErrors(Ext.Array.from(c));if(a!==b.getActiveError()){b.updateLayout()}},clearInvalid:function(){var b=this,a=b.hasActiveError();b.unsetActiveError();if(a){b.updateLayout()}},renderActiveError:function(){var b=this,a=b.hasActiveError();if(b.inputEl){b.inputEl[a?"addCls":"removeCls"](b.invalidCls+"-field")}b.mixins.labelable.renderActiveError.call(b)},getActionEl:function(){return this.inputEl||this.el}});Ext.define("Ext.form.field.Text",{extend:"Ext.form.field.Base",alias:"widget.textfield",requires:["Ext.form.field.VTypes","Ext.layout.component.field.Text"],alternateClassName:["Ext.form.TextField","Ext.form.Text"],size:20,growMin:30,growMax:800,growAppend:"W",allowBlank:true,minLength:0,maxLength:Number.MAX_VALUE,minLengthText:"The minimum length for this field is {0}",maxLengthText:"The maximum length for this field is {0}",blankText:"This field is required",regexText:"",emptyCls:Ext.baseCSSPrefix+"form-empty-field",requiredCls:Ext.baseCSSPrefix+"form-required-field",componentLayout:"textfield",valueContainsPlaceholder:false,initComponent:function(){var a=this;a.callParent();a.addEvents("autosize","keydown","keyup","keypress");a.addStateEvents("change");a.setGrowSizePolicy()},setGrowSizePolicy:function(){if(this.grow){this.shrinkWrap|=1}},initEvents:function(){var b=this,a=b.inputEl;b.callParent();if(b.selectOnFocus||b.emptyText){b.mon(a,"mousedown",b.onMouseDown,b)}if(b.maskRe||(b.vtype&&b.disableKeyFilter!==true&&(b.maskRe=Ext.form.field.VTypes[b.vtype+"Mask"]))){b.mon(a,"keypress",b.filterKeys,b)}if(b.enableKeyEvents){b.mon(a,{scope:b,keyup:b.onKeyUp,keydown:b.onKeyDown,keypress:b.onKeyPress})}},isEqual:function(b,a){return this.isEqualAsString(b,a)},onChange:function(){this.callParent();this.autoSize()},getSubTplData:function(){var b=this,c=b.getRawValue(),e=b.emptyText&&c.length<1,a=b.maxLength,d;if(b.enforceMaxLength){if(a===Number.MAX_VALUE){a=undefined}}else{a=undefined}if(e){if(Ext.supports.Placeholder){d=b.emptyText}else{c=b.emptyText;b.valueContainsPlaceholder=true}}return Ext.apply(b.callParent(),{maxLength:a,readOnly:b.readOnly,placeholder:d,value:c,fieldCls:b.fieldCls+((e&&(d||c))?" "+b.emptyCls:"")+(b.allowBlank?"":" "+b.requiredCls)})},afterRender:function(){this.autoSize();this.callParent()},onMouseDown:function(b){var a=this;if(!a.hasFocus){a.mon(a.inputEl,"mouseup",Ext.emptyFn,a,{single:true,preventDefault:true})}},processRawValue:function(b){var a=this,d=a.stripCharsRe,c;if(d){c=b.replace(d,"");if(c!==b){a.setRawValue(c);b=c}}return b},onDisable:function(){this.callParent();if(Ext.isIE){this.inputEl.dom.unselectable="on"}},onEnable:function(){this.callParent();if(Ext.isIE){this.inputEl.dom.unselectable=""}},onKeyDown:function(a){this.fireEvent("keydown",this,a)},onKeyUp:function(a){this.fireEvent("keyup",this,a)},onKeyPress:function(a){this.fireEvent("keypress",this,a)},reset:function(){this.callParent();this.applyEmptyText()},applyEmptyText:function(){var b=this,a=b.emptyText,c;if(b.rendered&&a){c=b.getRawValue().length<1&&!b.hasFocus;if(Ext.supports.Placeholder){b.inputEl.dom.placeholder=a}else{if(c){b.setRawValue(a);b.valueContainsPlaceholder=true}}if(c){b.inputEl.addCls(b.emptyCls)}b.autoSize()}},afterFirstLayout:function(){this.callParent();if(Ext.isIE&&this.disabled){var a=this.inputEl;if(a){a.dom.unselectable="on"}}},preFocus:function(){var b=this,c=b.inputEl,a=b.emptyText,d;b.callParent(arguments);if((a&&!Ext.supports.Placeholder)&&(c.dom.value===b.emptyText&&b.valueContainsPlaceholder)){b.setRawValue("");d=true;c.removeCls(b.emptyCls);b.valueContainsPlaceholder=false}else{if(Ext.supports.Placeholder){b.inputEl.removeCls(b.emptyCls)}}if(b.selectOnFocus||d){c.dom.select()}},onFocus:function(){var a=this;a.callParent(arguments);if(a.emptyText){a.autoSize()}},postBlur:function(){this.callParent(arguments);this.applyEmptyText()},filterKeys:function(c){if(c.ctrlKey&&!c.altKey){return}var b=c.getKey(),a=String.fromCharCode(c.getCharCode());if((Ext.isGecko||Ext.isOpera)&&(c.isNavKeyPress()||b===c.BACKSPACE||(b===c.DELETE&&c.button===-1))){return}if((!Ext.isGecko&&!Ext.isOpera)&&c.isSpecialKey()&&!a){return}if(!this.maskRe.test(a)){c.stopEvent()}},getState:function(){return this.addPropertyToState(this.callParent(),"value")},applyState:function(a){this.callParent(arguments);if(a.hasOwnProperty("value")){this.setValue(a.value)}},getRawValue:function(){var b=this,a=b.callParent();if(a===b.emptyText&&b.valueContainsPlaceholder){a=""}return a},setValue:function(b){var a=this,c=a.inputEl;if(c&&a.emptyText&&!Ext.isEmpty(b)){c.removeCls(a.emptyCls);a.valueContainsPlaceholder=false}a.callParent(arguments);a.applyEmptyText();return a},getErrors:function(k){var f=this,j=f.callParent(arguments),a=f.validator,d=f.emptyText,c=f.allowBlank,e=f.vtype,g=Ext.form.field.VTypes,h=f.regex,i=Ext.String.format,b;k=k||f.processRawValue(f.getRawValue());if(Ext.isFunction(a)){b=a.call(f,k);if(b!==true){j.push(b)}}if(k.length<1||(k===f.emptyText&&f.valueContainsPlaceholder)){if(!c){j.push(f.blankText)}return j}if(k.length<f.minLength){j.push(i(f.minLengthText,f.minLength))}if(k.length>f.maxLength){j.push(i(f.maxLengthText,f.maxLength))}if(e){if(!g[e](k,f)){j.push(f.vtypeText||g[e+"Text"])}}if(h&&!h.test(k)){j.push(f.regexText||f.invalidText)}return j},selectText:function(h,a){var g=this,c=g.getRawValue(),d=true,f=g.inputEl.dom,e,b;if(c.length>0){h=h===e?0:h;a=a===e?c.length:a;if(f.setSelectionRange){f.setSelectionRange(h,a)}else{if(f.createTextRange){b=f.createTextRange();b.moveStart("character",h);b.moveEnd("character",a-c.length);b.select()}}d=Ext.isGecko||Ext.isOpera}if(d){g.focus()}},autoSize:function(){var a=this;if(a.grow&&a.rendered){a.autoSizing=true;a.updateLayout()}},afterComponentLayout:function(){var b=this,a;b.callParent(arguments);if(b.autoSizing){a=b.inputEl.getWidth();if(a!==b.lastInputWidth){b.fireEvent("autosize",b,a);b.lastInputWidth=a;delete b.autoSizing}}}});Ext.define("Ext.form.field.TextArea",{extend:"Ext.form.field.Text",alias:["widget.textareafield","widget.textarea"],alternateClassName:"Ext.form.TextArea",requires:["Ext.XTemplate","Ext.layout.component.field.TextArea","Ext.util.DelayedTask"],fieldSubTpl:['<textarea id="{id}" {inputAttrTpl}','<tpl if="name"> name="{name}"</tpl>','<tpl if="rows"> rows="{rows}" </tpl>','<tpl if="cols"> cols="{cols}" </tpl>','<tpl if="placeholder"> placeholder="{placeholder}"</tpl>','<tpl if="size"> size="{size}"</tpl>','<tpl if="maxLength !== undefined"> maxlength="{maxLength}"</tpl>','<tpl if="readOnly"> readonly="readonly"</tpl>','<tpl if="disabled"> disabled="disabled"</tpl>','<tpl if="tabIdx"> tabIndex="{tabIdx}"</tpl>',' class="{fieldCls} {typeCls}" ','<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',' autocomplete="off">\n','<tpl if="value">{[Ext.util.Format.htmlEncode(values.value)]}</tpl>',"</textarea>",{disableFormats:true}],growMin:60,growMax:1000,growAppend:"\n-",cols:20,rows:4,enterIsSpecial:false,preventScrollbars:false,componentLayout:"textareafield",setGrowSizePolicy:Ext.emptyFn,returnRe:/\r/g,getSubTplData:function(){var c=this,b=c.getFieldStyle(),a=c.callParent();if(c.grow){if(c.preventScrollbars){a.fieldStyle=(b||"")+";overflow:hidden;height:"+c.growMin+"px"}}Ext.applyIf(a,{cols:c.cols,rows:c.rows});return a},afterRender:function(){var a=this;a.callParent(arguments);a.needsMaxCheck=a.enforceMaxLength&&a.maxLength!==Number.MAX_VALUE&&!Ext.supports.TextAreaMaxLength;if(a.needsMaxCheck){a.inputEl.on("paste",a.onPaste,a)}},transformRawValue:function(a){return this.stripReturns(a)},transformOriginalValue:function(a){return this.stripReturns(a)},valueToRaw:function(a){a=this.stripReturns(a);return this.callParent([a])},stripReturns:function(a){if(a){a=a.replace(this.returnRe,"")}return a},onPaste:function(b){var a=this;if(!a.pasteTask){a.pasteTask=new Ext.util.DelayedTask(a.pasteCheck,a)}a.pasteTask.delay(1)},pasteCheck:function(){var b=this,c=b.getValue(),a=b.maxLength;if(c.length>a){c=c.substr(0,a);b.setValue(c)}},fireKey:function(d){var b=this,a=d.getKey(),c;if(d.isSpecialKey()&&(b.enterIsSpecial||(a!==d.ENTER||d.hasModifier()))){b.fireEvent("specialkey",b,d)}if(b.needsMaxCheck&&a!==d.BACKSPACE&&a!==d.DELETE&&!d.isNavKeyPress()&&!b.isCutCopyPasteSelectAll(d,a)){c=b.getValue();if(c.length>=b.maxLength){d.stopEvent()}}},isCutCopyPasteSelectAll:function(b,a){if(b.CTRL){return a===b.A||a===b.C||a===b.V||a===b.X}return false},autoSize:function(){var b=this,a;if(b.grow&&b.rendered){b.updateLayout();a=b.inputEl.getHeight();if(a!==b.lastInputHeight){b.fireEvent("autosize",b,a);b.lastInputHeight=a}}},initAria:function(){this.callParent(arguments);this.getActionEl().dom.setAttribute("aria-multiline",true)},beforeDestroy:function(){var a=this.pasteTask;if(a){a.delay()}this.callParent()}});Ext.define("Ext.form.field.Display",{extend:"Ext.form.field.Base",alias:"widget.displayfield",requires:["Ext.util.Format","Ext.XTemplate"],alternateClassName:["Ext.form.DisplayField","Ext.form.Display"],fieldSubTpl:['<div id="{id}"','<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',' class="{fieldCls}">{value}</div>',{compiled:true,disableFormats:true}],fieldCls:Ext.baseCSSPrefix+"form-display-field",htmlEncode:false,validateOnChange:false,initEvents:Ext.emptyFn,submitValue:false,isDirty:function(){return false},isValid:function(){return true},validate:function(){return true},getRawValue:function(){return this.rawValue},setRawValue:function(b){var a=this,c;b=Ext.value(b,"");a.rawValue=b;if(a.rendered){a.inputEl.dom.innerHTML=a.getDisplayValue();a.updateLayout()}return b},getDisplayValue:function(){var a=this,b=this.getRawValue(),c;if(a.renderer){c=a.renderer.call(a.scope||a,b,a)}else{c=a.htmlEncode?Ext.util.Format.htmlEncode(b):b}return c},getSubTplData:function(){var a=this.callParent(arguments);a.value=this.getDisplayValue();return a}});Ext.define("Ext.draw.Component",{alias:"widget.draw",extend:"Ext.Component",requires:["Ext.draw.Surface","Ext.layout.component.Draw"],enginePriority:["Svg","Vml"],baseCls:Ext.baseCSSPrefix+"surface",componentLayout:"draw",viewBox:true,shrinkWrap:3,autoSize:false,initComponent:function(){this.callParent(arguments);this.addEvents("mousedown","mouseup","mousemove","mouseenter","mouseleave","click","dblclick")},onRender:function(){var d=this,i=d.viewBox,b=d.autoSize,g,c,a,h,f,e;d.callParent(arguments);if(d.createSurface()!==false){c=d.surface.items;if(i||b){g=c.getBBox();a=g.width;h=g.height;f=g.x;e=g.y;if(d.viewBox){d.surface.setViewBox(f,e,a,h)}else{d.autoSizeSurface()}}}},autoSizeSurface:function(){var a=this.surface.items.getBBox();this.setSurfaceSize(a.width,a.height)},setSurfaceSize:function(b,a){this.surface.setSize(b,a);if(this.autoSize){var c=this.surface.items.getBBox();this.surface.setViewBox(c.x,c.y-(+Ext.isOpera),b,a)}},createSurface:function(){var d=this,b=Ext.applyIf({renderTo:d.el,height:d.height,width:d.width,items:d.items},d.initialConfig),a;delete b.listeners;a=Ext.draw.Surface.create(b);if(!a){return false}d.surface=a;function c(e){return function(f){d.fireEvent(e,f)}}a.on({scope:d,mouseup:c("mouseup"),mousedown:c("mousedown"),mousemove:c("mousemove"),mouseenter:c("mouseenter"),mouseleave:c("mouseleave"),click:c("click"),dblclick:c("dblclick")})},onDestroy:function(){Ext.destroy(this.surface);this.callParent(arguments)}});Ext.define("Ext.chart.Chart",{alias:"widget.chart",extend:"Ext.draw.Component",mixins:{themeManager:"Ext.chart.theme.Theme",mask:"Ext.chart.Mask",navigation:"Ext.chart.Navigation",bindable:"Ext.util.Bindable",observable:"Ext.util.Observable"},uses:["Ext.chart.series.Series"],requires:["Ext.util.MixedCollection","Ext.data.StoreManager","Ext.chart.Legend","Ext.chart.theme.Base","Ext.chart.theme.Theme","Ext.util.DelayedTask"],viewBox:false,animate:false,legend:false,insetPadding:10,enginePriority:["Svg","Vml"],background:false,constructor:function(b){var c=this,a;b=Ext.apply({},b);c.initTheme(b.theme||c.theme);if(c.gradients){Ext.apply(b,{gradients:c.gradients})}if(c.background){Ext.apply(b,{background:c.background})}if(b.animate){a={easing:"ease",duration:500};if(Ext.isObject(b.animate)){b.animate=Ext.applyIf(b.animate,a)}else{b.animate=a}}c.mixins.observable.constructor.call(c,b);if(b.enableMask){c.mixins.mask.constructor.call(c)}c.mixins.navigation.constructor.call(c);c.callParent([b])},getChartStore:function(){return this.substore||this.store},initComponent:function(){var b=this,c,a;b.callParent();b.addEvents("itemmousedown","itemmouseup","itemmouseover","itemmouseout","itemclick","itemdblclick","itemdragstart","itemdrag","itemdragend","beforerefresh","refresh");Ext.applyIf(b,{zoom:{width:1,height:1,x:0,y:0}});b.maxGutter=[0,0];b.store=Ext.data.StoreManager.lookup(b.store);c=b.axes;b.axes=new Ext.util.MixedCollection(false,function(d){return d.position});if(c){b.axes.addAll(c)}a=b.series;b.series=new Ext.util.MixedCollection(false,function(d){return d.seriesId||(d.seriesId=Ext.id(null,"ext-chart-series-"))});if(a){b.series.addAll(a)}if(b.legend!==false){b.legend=new Ext.chart.Legend(Ext.applyIf({chart:b},b.legend))}b.on({mousemove:b.onMouseMove,mouseleave:b.onMouseLeave,mousedown:b.onMouseDown,mouseup:b.onMouseUp,click:b.onClick,dblclick:b.onDblClick,scope:b})},afterComponentLayout:function(b,a){var c=this;if(Ext.isNumber(b)&&Ext.isNumber(a)){if(b!==c.curWidth||a!==c.curHeight){c.curWidth=b;c.curHeight=a;c.redraw(true)}else{if(c.needsRedraw){delete c.needsRedraw;c.redraw()}}}this.callParent(arguments)},redraw:function(b){var g=this,f=g.series.items,d=f.length,a=g.axes.items,c=a.length,e,j=g.chartBBox={x:0,y:0,height:g.curHeight,width:g.curWidth},h=g.legend;g.surface.setSize(j.width,j.height);for(e=0;e<d;e++){g.initializeSeries(f[e],e)}for(e=0;e<c;e++){g.initializeAxis(a[e])}for(e=0;e<c;e++){a[e].processView()}for(e=0;e<c;e++){a[e].drawAxis(true)}if(h!==false&&h.visible){if(h.update||!h.created){h.create()}}g.alignAxes();if(h!==false&&h.visible){h.updatePosition()}g.getMaxGutter();g.resizing=!!b;for(e=0;e<c;e++){a[e].drawAxis()}for(e=0;e<d;e++){g.drawCharts(f[e])}g.resizing=false},afterRender:function(){var b,a=this;this.callParent();if(a.categoryNames){a.setCategoryNames(a.categoryNames)}if(a.tipRenderer){b=a.getFunctionRef(a.tipRenderer);a.setTipRenderer(b.fn,b.scope)}a.bindStore(a.store,true);a.refresh();if(a.surface.engine==="Vml"){a.on("added",a.onAddedVml,a);a.mon(Ext.container.Container.hierarchyEventSource,"added",a.onContainerAddedVml,a)}},onAddedVml:function(){this.needsRedraw=true},onContainerAddedVml:function(a){if(this.isDescendantOf(a)){this.needsRedraw=true}},getEventXY:function(d){var c=this,b=this.surface.getRegion(),g=d.getXY(),a=g[0]-b.left,f=g[1]-b.top;return[a,f]},onClick:function(a){this.handleClick("itemclick",a)},onDblClick:function(a){this.handleClick("itemdblclick",a)},handleClick:function(a,g){var j=this,f=j.getEventXY(g),d=j.series.items,b,h,c,k;for(b=0,h=d.length;b<h;b++){c=d[b];if(Ext.draw.Draw.withinBox(f[0],f[1],c.bbox)){if(c.getItemForPoint){k=c.getItemForPoint(f[0],f[1]);if(k){c.fireEvent(a,k)}}}}},onMouseDown:function(j){var h=this,a=h.getEventXY(j),b=h.series.items,d,g,c,f;if(h.enableMask){h.mixins.mask.onMouseDown.call(h,j)}for(d=0,g=b.length;d<g;d++){c=b[d];if(Ext.draw.Draw.withinBox(a[0],a[1],c.bbox)){if(c.getItemForPoint){f=c.getItemForPoint(a[0],a[1]);if(f){c.fireEvent("itemmousedown",f)}}}}},onMouseUp:function(j){var h=this,a=h.getEventXY(j),b=h.series.items,d,g,c,f;if(h.enableMask){h.mixins.mask.onMouseUp.call(h,j)}for(d=0,g=b.length;d<g;d++){c=b[d];if(Ext.draw.Draw.withinBox(a[0],a[1],c.bbox)){if(c.getItemForPoint){f=c.getItemForPoint(a[0],a[1]);if(f){c.fireEvent("itemmouseup",f)}}}}},onMouseMove:function(g){var j=this,d=j.getEventXY(g),c=j.series.items,a,h,b,m,k,f,l;if(j.enableMask){j.mixins.mask.onMouseMove.call(j,g)}for(a=0,h=c.length;a<h;a++){b=c[a];if(Ext.draw.Draw.withinBox(d[0],d[1],b.bbox)){if(b.getItemForPoint){m=b.getItemForPoint(d[0],d[1]);k=b._lastItemForPoint;f=b._lastStoreItem;l=b._lastStoreField;if(m!==k||m&&(m.storeItem!=f||m.storeField!=l)){if(k){b.fireEvent("itemmouseout",k);delete b._lastItemForPoint;delete b._lastStoreField;delete b._lastStoreItem}if(m){b.fireEvent("itemmouseover",m);b._lastItemForPoint=m;b._lastStoreItem=m.storeItem;b._lastStoreField=m.storeField}}}}else{k=b._lastItemForPoint;if(k){b.fireEvent("itemmouseout",k);delete b._lastItemForPoint;delete b._lastStoreField;delete b._lastStoreItem}}}},onMouseLeave:function(g){var f=this,a=f.series.items,c,d,b;if(f.enableMask){f.mixins.mask.onMouseLeave.call(f,g)}for(c=0,d=a.length;c<d;c++){b=a[c];delete b._lastItemForPoint}},delayRefresh:function(){var a=this;if(!a.refreshTask){a.refreshTask=new Ext.util.DelayedTask(a.refresh,a)}a.refreshTask.delay(a.refreshBuffer)},refresh:function(){var a=this;if(a.rendered&&a.curWidth!==undefined&&a.curHeight!==undefined){if(!a.isVisible(true)&&!a.refreshPending){a.setShowListeners("mon");a.refreshPending=true;return}if(a.fireEvent("beforerefresh",a)!==false){a.redraw();a.fireEvent("refresh",a)}}},onShow:function(){var a=this;a.callParent(arguments);if(a.refreshPending){a.delayRefresh();a.setShowListeners("mun")}delete a.refreshPending},setShowListeners:function(b){var a=this;a[b](Ext.container.Container.hierarchyEventSource,{scope:a,single:true,show:a.forceRefresh,expand:a.forceRefresh})},forceRefresh:function(a){var b=this;if(b.isDescendantOf(a)&&b.refreshPending){b.setShowListeners("mun");b.delayRefresh()}delete b.refreshPending},bindStore:function(a,b){var c=this;c.mixins.bindable.bindStore.apply(c,arguments);if(c.store&&!b){c.refresh()}},getStoreListeners:function(){var b=this.refresh,a=this.delayRefresh;return{refresh:b,add:a,remove:a,update:a,clear:b}},initializeAxis:function(b){var e=this,j=e.chartBBox,i=j.width,d=j.height,g=j.x,f=j.y,c=e.themeAttrs,a={chart:e};if(c){a.axisStyle=Ext.apply({},c.axis);a.axisLabelLeftStyle=Ext.apply({},c.axisLabelLeft);a.axisLabelRightStyle=Ext.apply({},c.axisLabelRight);a.axisLabelTopStyle=Ext.apply({},c.axisLabelTop);a.axisLabelBottomStyle=Ext.apply({},c.axisLabelBottom);a.axisTitleLeftStyle=Ext.apply({},c.axisTitleLeft);a.axisTitleRightStyle=Ext.apply({},c.axisTitleRight);a.axisTitleTopStyle=Ext.apply({},c.axisTitleTop);a.axisTitleBottomStyle=Ext.apply({},c.axisTitleBottom)}switch(b.position){case"top":Ext.apply(a,{length:i,width:d,x:g,y:f});break;case"bottom":Ext.apply(a,{length:i,width:d,x:g,y:d});break;case"left":Ext.apply(a,{length:d,width:i,x:g,y:d});break;case"right":Ext.apply(a,{length:d,width:i,x:i,y:d});break}if(!b.chart){Ext.apply(a,b);b=e.axes.replace(Ext.createByAlias("axis."+b.type.toLowerCase(),a))}else{Ext.apply(b,a)}},alignAxes:function(){var k=this,j=k.axes,a=j.items,e,o=k.legend,f=["top","right","bottom","left"],b,g,h,q,n=k.insetPadding,d={top:n,right:n,bottom:n,left:n},m,p,l;function c(s){var r=j.findIndex("position",s);return(r<0)?null:j.getAt(r)}for(g=0,h=f.length;g<h;g++){b=f[g];m=(b==="left"||b==="right");e=c(b);if(o!==false){if(o.position===b){p=o.getBBox();d[b]+=(m?p.width:p.height)+d[b]}}if(e&&e.bbox){p=e.bbox;d[b]+=(m?p.width:p.height)}}q={x:d.left,y:d.top,width:k.curWidth-d.left-d.right,height:k.curHeight-d.top-d.bottom};k.chartBBox=q;for(g=0,h=a.length;g<h;g++){e=a[g];l=e.position;m=(l==="left"||l==="right");e.x=(l==="right"?q.x+q.width:q.x);e.y=(l==="top"?q.y:q.y+q.height);e.width=(m?q.width:q.height);e.length=(m?q.height:q.width)}},initializeSeries:function(g,j){var h=this,d=h.themeAttrs,c,e,m,o,n,k=[],f=0,b,a={chart:h,seriesId:g.seriesId};if(d){m=d.seriesThemes;n=d.markerThemes;c=Ext.apply({},d.series);e=Ext.apply({},d.marker);a.seriesStyle=Ext.apply(c,m[j%m.length]);a.seriesLabelStyle=Ext.apply({},d.seriesLabel);a.markerStyle=Ext.apply(e,n[j%n.length]);if(d.colors){a.colorArrayStyle=d.colors}else{k=[];for(b=m.length;f<b;f++){o=m[f];if(o.fill||o.stroke){k.push(o.fill||o.stroke)}}if(k.length){a.colorArrayStyle=k}}a.seriesIdx=j}if(g instanceof Ext.chart.series.Series){Ext.apply(g,a)}else{Ext.applyIf(a,g);g=h.series.replace(Ext.createByAlias("series."+g.type.toLowerCase(),a))}if(g.initialize){g.initialize()}},getMaxGutter:function(){var f=this,a=f.series.items,d,e,c,b=[0,0],g;for(d=0,e=a.length;d<e;d++){c=a[d];g=c.getGutters&&c.getGutters()||[0,0];b[0]=Math.max(b[0],g[0]);b[1]=Math.max(b[1],g[1])}f.maxGutter=b},drawAxis:function(a){a.drawAxis()},drawCharts:function(a){a.triggerafterrender=false;a.drawSeries();if(!this.animate){a.fireEvent("afterrender")}},save:function(a){return Ext.draw.Surface.save(this.surface,a)},destroy:function(){Ext.destroy(this.surface);this.bindStore(null);this.callParent(arguments)}});Ext.define("Ext.chart.TipSurface",{extend:"Ext.draw.Component",spriteArray:false,renderFirst:true,constructor:function(a){this.callParent([a]);if(a.sprites){this.spriteArray=[].concat(a.sprites);delete a.sprites}},onRender:function(){var c=this,b=0,a=0,d,e;this.callParent(arguments);e=c.spriteArray;if(c.renderFirst&&e){c.renderFirst=false;for(a=e.length;b<a;b++){d=c.surface.add(e[b]);d.setAttributes({hidden:false},true)}}}});Ext.define("Ext.chart.axis.Abstract",{requires:["Ext.chart.Chart"],constructor:function(a){a=a||{};var b=this,c=a.position||"left";c=c.charAt(0).toUpperCase()+c.substring(1);a.label=Ext.apply(a["axisLabel"+c+"Style"]||{},a.label||{});a.axisTitleStyle=Ext.apply(a["axisTitle"+c+"Style"]||{},a.labelTitle||{});Ext.apply(b,a);b.fields=Ext.Array.from(b.fields);this.callParent();b.labels=[];b.getId();b.labelGroup=b.chart.surface.getGroup(b.axisId+"-labels")},alignment:null,grid:false,steps:10,x:0,y:0,minValue:0,maxValue:0,getId:function(){return this.axisId||(this.axisId=Ext.id(null,"ext-axis-"))},processView:Ext.emptyFn,drawAxis:Ext.emptyFn,addDisplayAndLabels:Ext.emptyFn});Ext.define("Ext.chart.axis.Axis",{extend:"Ext.chart.axis.Abstract",alternateClassName:"Ext.chart.Axis",requires:["Ext.draw.Draw"],forceMinMax:false,dashSize:3,position:"bottom",skipFirst:false,length:0,width:0,adjustEnd:true,majorTickSteps:false,applyData:Ext.emptyFn,getRange:function(){var B=this,o=B.chart,h=o.getChartStore(),D=h.data.items,n=o.series.items,C=B.position,p,a=Ext.chart.series,u=[],t=Infinity,x=-Infinity,c=B.position==="left"||B.position==="right",y,m,d,w,v,l=D.length,f,A={},s={},z=true,q,g,e,b,r;q=B.fields;for(w=0,m=q.length;w<m;w++){s[q[w]]=true}for(y=0,m=n.length;y<m;y++){if(n[y].seriesIsHidden){continue}if(!n[y].getAxesForXAndYFields){continue}p=n[y].getAxesForXAndYFields();if(p.xAxis&&p.xAxis!==C&&p.yAxis&&p.yAxis!==C){continue}if(a.Bar&&n[y] instanceof a.Bar&&!n[y].column){q=c?Ext.Array.from(n[y].xField):Ext.Array.from(n[y].yField)}else{q=c?Ext.Array.from(n[y].yField):Ext.Array.from(n[y].xField)}if(B.fields.length){for(w=0,d=q.length;w<d;w++){if(s[q[w]]){break}}if(w==d){continue}}if(f=n[y].stacked){if(a.Bar&&n[y] instanceof a.Bar){if(n[y].column!=c){f=false;z=false}}else{if(!c){f=false;z=false}}}if(f){g={};for(w=0;w<q.length;w++){if(z&&n[y].__excludes&&n[y].__excludes[w]){continue}if(!s[q[w]]){Ext.Logger.warn("Field `"+q[w]+"` is not included in the "+C+" axis config.")}s[q[w]]=g[q[w]]=true}u.push({fields:g,value:0})}else{if(!q||q.length==0){q=B.fields}for(w=0;w<q.length;w++){if(z&&n[y].__excludes&&n[y].__excludes[w]){continue}s[q[w]]=A[q[w]]=true}}}for(y=0;y<l;y++){e=D[y];for(v=0;v<u.length;v++){u[v].value=0}for(b in s){r=e.get(b);if(isNaN(r)){continue}if(r===undefined){r=0}if(A[b]){if(t>r){t=r}if(x<r){x=r}}for(v=0;v<u.length;v++){if(u[v].fields[b]){u[v].value+=r;if(t>0){t=0}if(x<u[v].value){x=u[v].value}}}}}if(!isFinite(x)){x=B.prevMax||0}if(!isFinite(t)){t=B.prevMin||0}if(t!=x&&(x!=Math.floor(x))){x=Math.floor(x)+1}if(!isNaN(B.minimum)){t=B.minimum}if(!isNaN(B.maximum)){x=B.maximum}if(t>=x){x=t+1}return{min:t,max:x}},calcEnds:function(){var g=this,d=g.getRange(),f=d.min,a=d.max,c,h,e,b;c=(Ext.isNumber(g.majorTickSteps)?g.majorTickSteps+1:g.steps);h=!(Ext.isNumber(g.maximum)&&Ext.isNumber(g.minimum)&&Ext.isNumber(g.majorTickSteps)&&g.majorTickSteps>0);e=Ext.draw.Draw.snapEnds(f,a,c,h);if(Ext.isNumber(g.maximum)){e.to=g.maximum;b=true}if(Ext.isNumber(g.minimum)){e.from=g.minimum;b=true}if(g.adjustMaximumByMajorUnit){e.to=Math.ceil(e.to/e.step)*e.step;b=true}if(g.adjustMinimumByMajorUnit){e.from=Math.floor(e.from/e.step)*e.step;b=true}if(b){e.steps=Math.ceil((e.to-e.from)/e.step)}g.prevMin=(f==a?0:f);g.prevMax=a;return e},drawAxis:function(q){var B=this,r,h=B.x,g=B.y,z=B.chart.maxGutter[0],w=B.chart.maxGutter[1],e=B.dashSize,v=B.minorTickSteps||0,u=B.minorTickSteps||0,b=B.length,C=B.position,f=[],l=false,c=B.applyData(),d=c.step,s=c.steps,p=c.from,a=c.to,t,o,n,m,k,j,A;if(B.hidden||isNaN(d)||(p>a)){return}B.from=c.from;B.to=c.to;if(C=="left"||C=="right"){o=Math.floor(h)+0.5;m=["M",o,g,"l",0,-b];t=b-(w*2)}else{n=Math.floor(g)+0.5;m=["M",h,n,"l",b,0];t=b-(z*2)}A=s&&t/s;k=Math.max(v+1,0);j=Math.max(u+1,0);if(B.type=="Numeric"||B.type=="Time"){l=true;B.labels=[c.from]}if(C=="right"||C=="left"){n=g-w;o=h-((C=="left")*e*2);while(n>=g-w-t){m.push("M",o,Math.floor(n)+0.5,"l",e*2+1,0);if(n!=g-w){for(r=1;r<j;r++){m.push("M",o+e,Math.floor(n+A*r/j)+0.5,"l",e+1,0)}}f.push([Math.floor(h),Math.floor(n)]);n-=A;if(l){B.labels.push(B.labels[B.labels.length-1]+d)}if(A===0){break}}if(Math.round(n+A-(g-w-t))){m.push("M",o,Math.floor(g-b+w)+0.5,"l",e*2+1,0);for(r=1;r<j;r++){m.push("M",o+e,Math.floor(g-b+w+A*r/j)+0.5,"l",e+1,0)}f.push([Math.floor(h),Math.floor(n)]);if(l){B.labels.push(B.labels[B.labels.length-1]+d)}}}else{o=h+z;n=g-((C=="top")*e*2);while(o<=h+z+t){m.push("M",Math.floor(o)+0.5,n,"l",0,e*2+1);if(o!=h+z){for(r=1;r<k;r++){m.push("M",Math.floor(o-A*r/k)+0.5,n,"l",0,e+1)}}f.push([Math.floor(o),Math.floor(g)]);o+=A;if(l){B.labels.push(B.labels[B.labels.length-1]+d)}if(A===0){break}}if(Math.round(o-A-(h+z+t))){m.push("M",Math.floor(h+b-z)+0.5,n,"l",0,e*2+1);for(r=1;r<k;r++){m.push("M",Math.floor(h+b-z-A*r/k)+0.5,n,"l",0,e+1)}f.push([Math.floor(o),Math.floor(g)]);if(l){B.labels.push(B.labels[B.labels.length-1]+d)}}}if(l){B.labels[f.length-1]=+(B.labels[f.length-1]).toFixed(10)}if(!B.axis){B.axis=B.chart.surface.add(Ext.apply({type:"path",path:m},B.axisStyle))}B.axis.setAttributes({path:m},true);B.inflections=f;if(!q&&B.grid){B.drawGrid()}B.axisBBox=B.axis.getBBox();B.drawLabel()},drawGrid:function(){var s=this,n=s.chart.surface,b=s.grid,d=b.odd,e=b.even,g=s.inflections,h=g.length-((d||e)?0:1),t=s.position,c=s.chart.maxGutter,m=s.width-2,o,p,q=1,l=[],f,a,j,k=[],r=[];if((c[1]!==0&&(t=="left"||t=="right"))||(c[0]!==0&&(t=="top"||t=="bottom"))){q=0;h++}for(;q<h;q++){o=g[q];p=g[q-1];if(d||e){l=(q%2)?k:r;f=((q%2)?d:e)||{};a=(f.lineWidth||f["stroke-width"]||0)/2;j=2*a;if(t=="left"){l.push("M",p[0]+1+a,p[1]+0.5-a,"L",p[0]+1+m-a,p[1]+0.5-a,"L",o[0]+1+m-a,o[1]+0.5+a,"L",o[0]+1+a,o[1]+0.5+a,"Z")}else{if(t=="right"){l.push("M",p[0]-a,p[1]+0.5-a,"L",p[0]-m+a,p[1]+0.5-a,"L",o[0]-m+a,o[1]+0.5+a,"L",o[0]-a,o[1]+0.5+a,"Z")}else{if(t=="top"){l.push("M",p[0]+0.5+a,p[1]+1+a,"L",p[0]+0.5+a,p[1]+1+m-a,"L",o[0]+0.5-a,o[1]+1+m-a,"L",o[0]+0.5-a,o[1]+1+a,"Z")}else{l.push("M",p[0]+0.5+a,p[1]-a,"L",p[0]+0.5+a,p[1]-m+a,"L",o[0]+0.5-a,o[1]-m+a,"L",o[0]+0.5-a,o[1]-a,"Z")}}}}else{if(t=="left"){l=l.concat(["M",o[0]+0.5,o[1]+0.5,"l",m,0])}else{if(t=="right"){l=l.concat(["M",o[0]-0.5,o[1]+0.5,"l",-m,0])}else{if(t=="top"){l=l.concat(["M",o[0]+0.5,o[1]+0.5,"l",0,m])}else{l=l.concat(["M",o[0]+0.5,o[1]-0.5,"l",0,-m])}}}}}if(d||e){if(k.length){if(!s.gridOdd&&k.length){s.gridOdd=n.add({type:"path",path:k})}s.gridOdd.setAttributes(Ext.apply({path:k,hidden:false},d||{}),true)}if(r.length){if(!s.gridEven){s.gridEven=n.add({type:"path",path:r})}s.gridEven.setAttributes(Ext.apply({path:r,hidden:false},e||{}),true)}}else{if(l.length){if(!s.gridLines){s.gridLines=s.chart.surface.add({type:"path",path:l,"stroke-width":s.lineWidth||1,stroke:s.gridColor||"#ccc"})}s.gridLines.setAttributes({hidden:false,path:l},true)}else{if(s.gridLines){s.gridLines.hide(true)}}}},getOrCreateLabel:function(c,f){var d=this,b=d.labelGroup,e=b.getAt(c),a=d.chart.surface;if(e){if(f!=e.attr.text){e.setAttributes(Ext.apply({text:f},d.label),true);e._bbox=e.getBBox()}}else{e=a.add(Ext.apply({group:b,type:"text",x:0,y:0,text:f},d.label));a.renderItem(e);e._bbox=e.getBBox()}if(d.label.rotation){e.setAttributes({rotation:{degrees:0}},true);e._ubbox=e.getBBox();e.setAttributes(d.label,true)}else{e._ubbox=e._bbox}return e},rect2pointArray:function(k){var b=this.chart.surface,f=b.getBBox(k,true),l=[f.x,f.y],d=l.slice(),j=[f.x+f.width,f.y],a=j.slice(),i=[f.x+f.width,f.y+f.height],e=i.slice(),h=[f.x,f.y+f.height],c=h.slice(),g=k.matrix;l[0]=g.x.apply(g,d);l[1]=g.y.apply(g,d);j[0]=g.x.apply(g,a);j[1]=g.y.apply(g,a);i[0]=g.x.apply(g,e);i[1]=g.y.apply(g,e);h[0]=g.x.apply(g,c);h[1]=g.y.apply(g,c);return[l,j,i,h]},intersect:function(c,a){var d=this.rect2pointArray(c),b=this.rect2pointArray(a);return !!Ext.draw.Draw.intersect(d,b).length},drawHorizontalLabels:function(){var B=this,e=B.label,v=Math.floor,t=Math.max,u=B.chart.axes,f=B.chart.insetPadding,C=B.position,h=B.inflections,m=h.length,z=B.labels,q=0,g,c,r,n,b,A=B.adjustEnd,a=u.findIndex("position","left")!=-1,l=u.findIndex("position","right")!=-1,w,p,k,o,j,s,d;k=m-1;r=h[0];d=B.getOrCreateLabel(0,B.label.renderer(z[0]));g=Math.floor(Math.abs(Math.sin(e.rotate&&(e.rotate.degrees*Math.PI/180)||0)));for(s=0;s<m;s++){r=h[s];p=B.label.renderer(z[s]);w=B.getOrCreateLabel(s,p);c=w._bbox;q=t(q,c.height+B.dashSize+B.label.padding);o=v(r[0]-(g?c.height:c.width)/2);if(A&&B.chart.maxGutter[0]==0){if(s==0&&!a){o=r[0]}else{if(s==k&&!l){o=Math.min(o,r[0]-c.width+f)}}}if(C=="top"){j=r[1]-(B.dashSize*2)-B.label.padding-(c.height/2)}else{j=r[1]+(B.dashSize*2)+B.label.padding+(c.height/2)}w.setAttributes({hidden:false,x:o,y:j},true);if(s!=0&&(B.intersect(w,n)||B.intersect(w,d))){if(s===k&&b!==0){n.hide(true)}else{w.hide(true);continue}}n=w;b=s}return q},drawVerticalLabels:function(){var B=this,e=B.inflections,C=B.position,h=e.length,n=B.chart,d=n.insetPadding,A=B.labels,t=0,q=Math.max,s=Math.floor,c=Math.ceil,r=B.chart.axes,v=B.chart.maxGutter[1],b,o,j,a,m=r.findIndex("position","top")!=-1,u=r.findIndex("position","bottom")!=-1,z=B.adjustEnd,w,l,g=h-1,k,f,p;for(p=0;p<h;p++){o=e[p];l=B.label.renderer(A[p]);w=B.getOrCreateLabel(p,l);b=w._bbox;t=q(t,b.width+B.dashSize+B.label.padding);f=o[1];if(z&&v<b.height/2){if(p==g&&!m){f=Math.max(f,B.y-B.length+c(b.height/2)-d)}else{if(p==0&&!u){f=B.y+v-s(b.height/2)}}}if(C=="left"){k=o[0]-b.width-B.dashSize-B.label.padding-2}else{k=o[0]+B.dashSize+B.label.padding+2}w.setAttributes(Ext.apply({hidden:false,x:k,y:f},B.label),true);if(p!=0&&B.intersect(w,j)){if(p===g&&a!==0){j.hide(true)}else{w.hide(true);continue}}j=w;a=p}return t},drawLabel:function(){var g=this,a=g.position,b=g.labelGroup,h=g.inflections,f=0,e=0,d,c;if(a=="left"||a=="right"){f=g.drawVerticalLabels()}else{e=g.drawHorizontalLabels()}d=b.getCount();c=h.length;for(;c<d;c++){b.getAt(c).hide(true)}g.bbox={};Ext.apply(g.bbox,g.axisBBox);g.bbox.height=e;g.bbox.width=f;if(Ext.isString(g.title)){g.drawTitle(f,e)}},setTitle:function(a){this.title=a;this.drawLabel()},drawTitle:function(k,l){var g=this,f=g.position,b=g.chart.surface,c=g.displaySprite,j=g.title,e=(f=="left"||f=="right"),i=g.x,h=g.y,a,m,d;if(c){c.setAttributes({text:j},true)}else{a={type:"text",x:0,y:0,text:j};c=g.displaySprite=b.add(Ext.apply(a,g.axisTitleStyle,g.labelTitle));b.renderItem(c)}m=c.getBBox();d=g.dashSize+g.label.padding;if(e){h-=((g.length/2)-(m.height/2));if(f=="left"){i-=(k+d+(m.width/2))}else{i+=(k+d+m.width-(m.width/2))}g.bbox.width+=m.width+10}else{i+=(g.length/2)-(m.width*0.5);if(f=="top"){h-=(l+d+(m.height*0.3))}else{h+=(l+d+(m.height*0.8))}g.bbox.height+=m.height+10}c.setAttributes({translate:{x:i,y:h}},true)}});Ext.define("Ext.chart.axis.Category",{extend:"Ext.chart.axis.Axis",alternateClassName:"Ext.chart.CategoryAxis",alias:"axis.category",categoryNames:null,calculateCategoryCount:false,setLabels:function(){var c=this.chart.getChartStore(),h=c.data.items,j,f,b,a=this.fields,g=a.length,e;this.labels=[];for(j=0,f=h.length;j<f;j++){b=h[j];for(e=0;e<g;e++){this.labels.push(b.get(a[e]))}}},applyData:function(){this.callParent();this.setLabels();var a=this.chart.getChartStore().getCount();return{from:0,to:a-1,power:1,step:1,steps:a-1}}});Ext.define("Ext.chart.axis.Gauge",{extend:"Ext.chart.axis.Abstract",position:"gauge",alias:"axis.gauge",drawAxis:function(p){var h=this.chart,a=h.surface,o=h.chartBBox,d=o.x+(o.width/2),b=o.y+o.height,c=this.margin||10,l=Math.min(o.width,2*o.height)/2+c,g=[],m,k=this.steps,e,f=Math.PI,n=Math.cos,j=Math.sin;if(this.sprites&&!h.resizing){this.drawLabel();return}if(this.margin>=0){if(!this.sprites){for(e=0;e<=k;e++){m=a.add({type:"path",path:["M",d+(l-c)*n(e/k*f-f),b+(l-c)*j(e/k*f-f),"L",d+l*n(e/k*f-f),b+l*j(e/k*f-f),"Z"],stroke:"#ccc"});m.setAttributes({hidden:false},true);g.push(m)}}else{g=this.sprites;for(e=0;e<=k;e++){g[e].setAttributes({path:["M",d+(l-c)*n(e/k*f-f),b+(l-c)*j(e/k*f-f),"L",d+l*n(e/k*f-f),b+l*j(e/k*f-f),"Z"],stroke:"#ccc"},true)}}}this.sprites=g;this.drawLabel();if(this.title){this.drawTitle()}},drawTitle:function(){var e=this,d=e.chart,a=d.surface,f=d.chartBBox,c=e.titleSprite,b;if(!c){e.titleSprite=c=a.add({type:"text",zIndex:2})}c.setAttributes(Ext.apply({text:e.title},e.label||{}),true);b=c.getBBox();c.setAttributes({x:f.x+(f.width/2)-(b.width/2),y:f.y+f.height-(b.height/2)-4},true)},setTitle:function(a){this.title=a;this.drawTitle()},drawLabel:function(){var k=this.chart,o=k.surface,b=k.chartBBox,h=b.x+(b.width/2),g=b.y+b.height,l=this.margin||10,d=Math.min(b.width,2*b.height)/2+2*l,t=Math.round,m=[],f,r=this.maximum||0,j=this.minimum||0,q=this.steps,p=0,u,s=Math.PI,c=Math.cos,a=Math.sin,e=this.label,n=e.renderer||function(i){return i};if(!this.labelArray){for(p=0;p<=q;p++){u=(p===0||p===q)?7:0;f=o.add({type:"text",text:n(t(j+p/q*(r-j))),x:h+d*c(p/q*s-s),y:g+d*a(p/q*s-s)-u,"text-anchor":"middle","stroke-width":0.2,zIndex:10,stroke:"#333"});f.setAttributes({hidden:false},true);m.push(f)}}else{m=this.labelArray;for(p=0;p<=q;p++){u=(p===0||p===q)?7:0;m[p].setAttributes({text:n(t(j+p/q*(r-j))),x:h+d*c(p/q*s-s),y:g+d*a(p/q*s-s)-u},true)}}this.labelArray=m}});Ext.define("Ext.chart.axis.Numeric",{extend:"Ext.chart.axis.Axis",alternateClassName:"Ext.chart.NumericAxis",type:"numeric",alias:"axis.numeric",uses:["Ext.data.Store"],constructor:function(c){var d=this,a=!!(c.label&&c.label.renderer),b;d.callParent([c]);b=d.label;if(c.constrain==null){d.constrain=(c.minimum!=null&&c.maximum!=null)}if(!a){b.renderer=function(e){return d.roundToDecimal(e,d.decimals)}}},roundToDecimal:function(a,c){var b=Math.pow(10,c||0);return Math.round(a*b)/b},minimum:NaN,maximum:NaN,constrain:true,decimals:2,scale:"linear",doConstrain:function(){var s=this,b=s.chart.store,g=b.data.items,r,t,a,e=s.chart.series.items,h=s.fields,c=h.length,f=s.calcEnds(),k=f.from,o=f.to,p,m,q=false,j,u=[],n;for(p=0,m=e.length;p<m;p++){if(e[p].type==="bar"&&e[p].stacked){return}}for(r=0,t=g.length;r<t;r++){n=true;a=g[r];for(p=0;p<c;p++){j=a.get(h[p]);if(+j<+k){n=false;break}if(+j>+o){n=false;break}}if(n){u.push(a)}}s.chart.substore=Ext.create("Ext.data.Store",{model:b.model});s.chart.substore.loadData(u)},position:"left",adjustMaximumByMajorUnit:false,adjustMinimumByMajorUnit:false,processView:function(){var a=this,b=a.constrain;if(b){a.doConstrain()}},applyData:function(){this.callParent();return this.calcEnds()}});Ext.define("Ext.chart.axis.Radial",{extend:"Ext.chart.axis.Abstract",position:"radial",alias:"axis.radial",drawAxis:function(t){var k=this.chart,a=k.surface,s=k.chartBBox,p=k.store,b=p.getCount(),e=s.x+(s.width/2),c=s.y+(s.height/2),o=Math.min(s.width,s.height)/2,h=[],q,n=this.steps,f,d,g=Math.PI*2,r=Math.cos,m=Math.sin;if(this.sprites&&!k.resizing){this.drawLabel();return}if(!this.sprites){for(f=1;f<=n;f++){q=a.add({type:"circle",x:e,y:c,radius:Math.max(o*f/n,0),stroke:"#ccc"});q.setAttributes({hidden:false},true);h.push(q)}for(f=0;f<b;f++){q=a.add({type:"path",path:["M",e,c,"L",e+o*r(f/b*g),c+o*m(f/b*g),"Z"],stroke:"#ccc"});q.setAttributes({hidden:false},true);h.push(q)}}else{h=this.sprites;for(f=0;f<n;f++){h[f].setAttributes({x:e,y:c,radius:Math.max(o*(f+1)/n,0),stroke:"#ccc"},true)}for(d=0;d<b;d++){h[f+d].setAttributes({path:["M",e,c,"L",e+o*r(d/b*g),c+o*m(d/b*g),"Z"],stroke:"#ccc"},true)}}this.sprites=h;this.drawLabel()},drawLabel:function(){var v=this.chart,c=v.series.items,q,A=v.surface,b=v.chartBBox,k=v.store,I=k.data.items,o,h,n=b.x+(b.width/2),m=b.y+(b.height/2),g=Math.min(b.width,b.height)/2,E=Math.max,H=Math.round,w=[],l,y=[],d,z=[],f,u=!this.maximum,G=this.maximum||0,F=this.steps,D=0,C,s,r,x=Math.PI*2,e=Math.cos,a=Math.sin,B=this.label.display,p=B!=="none",t=10;if(!p){return}for(D=0,o=c.length;D<o;D++){q=c[D];y.push(q.yField);f=q.xField}for(C=0,o=I.length;C<o;C++){h=I[C];if(u){for(D=0,d=y.length;D<d;D++){G=E(+h.get(y[D]),G)}}z.push(h.get(f))}if(!this.labelArray){if(B!="categories"){for(D=1;D<=F;D++){l=A.add({type:"text",text:H(D/F*G),x:n,y:m-g*D/F,"text-anchor":"middle","stroke-width":0.1,stroke:"#333"});l.setAttributes({hidden:false},true);w.push(l)}}if(B!="scale"){for(C=0,F=z.length;C<F;C++){s=e(C/F*x)*(g+t);r=a(C/F*x)*(g+t);l=A.add({type:"text",text:z[C],x:n+s,y:m+r,"text-anchor":s*s<=0.001?"middle":(s<0?"end":"start")});l.setAttributes({hidden:false},true);w.push(l)}}}else{w=this.labelArray;if(B!="categories"){for(D=0;D<F;D++){w[D].setAttributes({text:H((D+1)/F*G),x:n,y:m-g*(D+1)/F,"text-anchor":"middle","stroke-width":0.1,stroke:"#333"},true)}}if(B!="scale"){for(C=0,F=z.length;C<F;C++){s=e(C/F*x)*(g+t);r=a(C/F*x)*(g+t);if(w[D+C]){w[D+C].setAttributes({type:"text",text:z[C],x:n+s,y:m+r,"text-anchor":s*s<=0.001?"middle":(s<0?"end":"start")},true)}}}}this.labelArray=w}});Ext.define("Ext.chart.axis.Time",{extend:"Ext.chart.axis.Numeric",alternateClassName:"Ext.chart.TimeAxis",alias:"axis.time",uses:["Ext.data.Store"],dateFormat:false,fromDate:false,toDate:false,step:[Ext.Date.DAY,1],constrain:false,constructor:function(b){var c=this,a,d,e;c.callParent([b]);a=c.label||{};e=this.dateFormat;if(e){if(a.renderer){d=a.renderer;a.renderer=function(f){f=d(f);return Ext.Date.format(new Date(d(f)),e)}}else{a.renderer=function(f){return Ext.Date.format(new Date(f>>0),e)}}}},processView:function(){var a=this;if(a.fromDate){a.minimum=+a.fromDate}if(a.toDate){a.maximum=+a.toDate}if(a.constrain){a.doConstrain()}},calcEnds:function(){var c=this,a,b=c.step;if(b){a=c.getRange();a=Ext.draw.Draw.snapEndsByDateAndStep(new Date(a.min),new Date(a.max),Ext.isNumber(b)?[Date.MILLI,b]:b);if(c.minimum){a.from=c.minimum}if(c.maximum){a.to=c.maximum}a.step=(a.to-a.from)/a.steps;return a}else{return c.callParent(arguments)}}});Ext.define("Ext.picker.Color",{extend:"Ext.Component",requires:"Ext.XTemplate",alias:"widget.colorpicker",alternateClassName:"Ext.ColorPalette",componentCls:Ext.baseCSSPrefix+"color-picker",selectedCls:Ext.baseCSSPrefix+"color-picker-selected",value:null,clickEvent:"click",allowReselect:false,colors:["000000","993300","333300","003300","003366","000080","333399","333333","800000","FF6600","808000","008000","008080","0000FF","666699","808080","FF0000","FF9900","99CC00","339966","33CCCC","3366FF","800080","969696","FF00FF","FFCC00","FFFF00","00FF00","00FFFF","00CCFF","993366","C0C0C0","FF99CC","FFCC99","FFFF99","CCFFCC","CCFFFF","99CCFF","CC99FF","FFFFFF"],colorRe:/(?:^|\s)color-(.{6})(?:\s|$)/,renderTpl:['<tpl for="colors">','<a href="#" class="color-{.}" hidefocus="on">','<em><span style="background:#{.}" unselectable="on">&#160;</span></em>',"</a>","</tpl>"],initComponent:function(){var a=this;a.callParent(arguments);a.addEvents("select");if(a.handler){a.on("select",a.handler,a.scope,true)}},initRenderData:function(){var a=this;return Ext.apply(a.callParent(),{itemCls:a.itemCls,colors:a.colors})},onRender:function(){var b=this,a=b.clickEvent;b.callParent(arguments);b.mon(b.el,a,b.handleClick,b,{delegate:"a"});if(a!="click"){b.mon(b.el,"click",Ext.emptyFn,b,{delegate:"a",stopEvent:true})}},afterRender:function(){var a=this,b;a.callParent(arguments);if(a.value){b=a.value;a.value=null;a.select(b,true)}},handleClick:function(c,d){var b=this,a;c.stopEvent();if(!b.disabled){a=d.className.match(b.colorRe)[1];b.select(a.toUpperCase())}},select:function(b,a){var d=this,f=d.selectedCls,e=d.value,c;b=b.replace("#","");if(!d.rendered){d.value=b;return}if(b!=e||d.allowReselect){c=d.el;if(d.value){c.down("a.color-"+e).removeCls(f)}c.down("a.color-"+b).addCls(f);d.value=b;if(a!==true){d.fireEvent("select",d,b)}}},getValue:function(){return this.value||null}});Ext.define("Ext.toolbar.Item",{extend:"Ext.Component",alias:"widget.tbitem",alternateClassName:"Ext.Toolbar.Item",enable:Ext.emptyFn,disable:Ext.emptyFn,focus:Ext.emptyFn});Ext.define("Ext.container.AbstractContainer",{extend:"Ext.Component",requires:["Ext.util.MixedCollection","Ext.layout.container.Auto","Ext.ZIndexManager"],renderTpl:"{%this.renderContainer(out,values)%}",suspendLayout:false,autoDestroy:true,defaultType:"panel",detachOnRemove:true,isContainer:true,layoutCounter:0,baseCls:Ext.baseCSSPrefix+"container",bubbleEvents:["add","remove"],initComponent:function(){var a=this;a.addEvents("afterlayout","beforeadd","beforeremove","add","remove");a.callParent();a.getLayout();a.initItems()},initItems:function(){var b=this,a=b.items;b.items=new Ext.util.AbstractMixedCollection(false,b.getComponentId);if(a){if(!Ext.isArray(a)){a=[a]}b.add(a)}},getFocusEl:function(){return this.getTargetEl()},finishRenderChildren:function(){this.callParent();var a=this.getLayout();if(a){a.finishRender()}},beforeRender:function(){var b=this,a=b.getLayout();b.callParent();if(!a.initialized){a.initLayout()}},setupRenderTpl:function(b){var a=this.getLayout();this.callParent(arguments);a.setupRenderTpl(b)},setLayout:function(b){var a=this.layout;if(a&&a.isLayout&&a!=b){a.setOwner(null)}this.layout=b;b.setOwner(this)},getLayout:function(){var a=this;if(!a.layout||!a.layout.isLayout){a.setLayout(Ext.layout.Layout.create(a.layout,a.self.prototype.layout||"autocontainer"))}return a.layout},doLayout:function(){this.updateLayout();return this},afterLayout:function(b){var a=this;++a.layoutCounter;if(a.hasListeners.afterlayout){a.fireEvent("afterlayout",a,b)}},prepareItems:function(b,d){if(Ext.isArray(b)){b=b.slice()}else{b=[b]}var f=this,c=0,a=b.length,e;for(;c<a;c++){e=b[c];if(e==null){Ext.Array.erase(b,c,1);--c;--a}else{if(d){e=this.applyDefaults(e)}e.isContained=f;b[c]=f.lookupComponent(e);delete e.isContained}}return b},applyDefaults:function(a){var b=this.defaults;if(b){if(Ext.isFunction(b)){b=b.call(this,a)}if(Ext.isString(a)){a=Ext.ComponentManager.get(a)}Ext.applyIf(a,b)}return a},lookupComponent:function(a){return(typeof a=="string")?Ext.ComponentManager.get(a):Ext.ComponentManager.create(a,this.defaultType)},getComponentId:function(a){return a.getItemId()},add:function(){var h=this,f=Ext.Array.slice(arguments),d=(typeof f[0]=="number")?f.shift():-1,c=h.getLayout(),k,g,b,a,l,j,e;if(f.length==1&&Ext.isArray(f[0])){g=f[0];k=true}else{g=f}e=g=h.prepareItems(g,true);a=g.length;if(h.rendered){Ext.suspendLayouts()}if(!k&&a==1){e=g[0]}for(b=0;b<a;b++){l=g[b];j=(d<0)?h.items.length:(d+b);if(l.floating){h.floatingItems=h.floatingItems||new Ext.util.MixedCollection();h.floatingItems.add(l);l.onAdded(h,j)}else{if((!h.hasListeners.beforeadd||h.fireEvent("beforeadd",h,l,j)!==false)&&h.onBeforeAdd(l)!==false){h.items.insert(j,l);l.onAdded(h,j);h.onAdd(l,j);c.onAdd(l,j);if(h.hasListeners.add){h.fireEvent("add",h,l,j)}}}}h.updateLayout();if(h.rendered){Ext.resumeLayouts(true)}return e},onAdd:Ext.emptyFn,onRemove:Ext.emptyFn,insert:function(b,a){return this.add(b,a)},move:function(b,d){var a=this.items,c;c=a.removeAt(b);if(c===false){return false}a.insert(d,c);this.doLayout();return c},onBeforeAdd:function(c){var b=this,a=c.border;if(c.ownerCt&&c.ownerCt!==b){c.ownerCt.remove(c,false)}if(b.border===false||b.border===0){c.border=Ext.isDefined(a)&&a!==false&&a!==0}},remove:function(a,b){var d=this,e=d.getComponent(a);if(e&&(!d.hasListeners.beforeremove||d.fireEvent("beforeremove",d,e)!==false)){d.doRemove(e,b);if(d.hasListeners.remove){d.fireEvent("remove",d,e)}if(!d.destroying){d.doLayout()}}return e},doRemove:function(c,b){var e=this,d=e.layout,a=d&&e.rendered,f=b===true||(b!==false&&e.autoDestroy);b=b===true||(b!==false&&e.autoDestroy);e.items.remove(c);if(a){if(d.running){Ext.AbstractComponent.cancelLayout(c,f)}d.onRemove(c,f)}c.onRemoved(f);e.onRemove(c,f);if(f){c.destroy()}else{if(a){d.afterRemove(c)}if(e.detachOnRemove&&c.rendered){Ext.getDetachedBody().appendChild(c.getEl())}}},removeAll:function(c){var g=this,e=g.items.items.slice(),b=[],d=0,a=e.length,f;g.suspendLayouts();for(;d<a;d++){f=e[d];g.remove(f,c);if(f.ownerCt!==g){b.push(f)}}g.resumeLayouts(!!a);return b},getRefItems:function(c){var g=this,d=g.items.items,b=d.length,e=0,f,a=[];for(;e<b;e++){f=d[e];a.push(f);if(c&&f.getRefItems){a.push.apply(a,f.getRefItems(true))}}if(g.floatingItems){a.push.apply(a,g.floatingItems.items)}return a},cascade:function(k,l,a){var j=this,e=j.items?j.items.items:[],f=e.length,d=0,h,g=a?a.concat(j):[j],b=g.length-1;if(k.apply(l||j,g)!==false){for(;d<f;d++){h=e[d];if(h.cascade){h.cascade(k,l,a)}else{g[b]=h;k.apply(l||e,g)}}}return this},isAncestor:function(a){while(a){if(a.ownerCt===this){return true}a=a.ownerCt}},getComponent:function(a){if(Ext.isObject(a)){a=a.getItemId()}return this.items.get(a)},query:function(a){a=a||"*";return Ext.ComponentQuery.query(a,this)},queryBy:function(f,e){var c=[],b=this.getRefItems(true),d=0,a=b.length,g;for(;d<a;++d){g=b[d];if(f.call(e||g,g)!==false){c.push(g)}}return c},queryById:function(a){return this.down("#"+a)},child:function(a){a=a||"";return this.query("> "+a)[0]||null},nextChild:function(e,b){var c=this,a,d=c.items.indexOf(e);if(d!==-1){a=b?Ext.ComponentQuery(b,c.items.items.slice(d+1)):c.items.getAt(d+1);if(!a&&c.ownerCt){a=c.ownerCt.nextChild(c,b)}}return a},prevChild:function(e,b){var c=this,a,d=c.items.indexOf(e);if(d!==-1){a=b?Ext.ComponentQuery(b,c.items.items.slice(d+1)):c.items.getAt(d+1);if(!a&&c.ownerCt){a=c.ownerCt.nextChild(c,b)}}return a},down:function(a){return this.query(a)[0]||null},enable:function(){this.callParent(arguments);var d=this.getChildItemsToDisable(),c=d.length,b,a;for(a=0;a<c;a++){b=d[a];if(b.resetDisable){b.enable()}}return this},disable:function(){this.callParent(arguments);var d=this.getChildItemsToDisable(),c=d.length,b,a;for(a=0;a<c;a++){b=d[a];if(b.resetDisable!==false&&!b.disabled){b.disable();b.resetDisable=true}}return this},getChildItemsToDisable:function(){return this.query("[isFormField],button")},beforeLayout:function(){return true},beforeDestroy:function(){var b=this,a=b.items,d;if(a){while((d=a.first())){b.doRemove(d,true)}}Ext.destroy(b.layout);b.callParent()}});Ext.define("Ext.container.Container",{extend:"Ext.container.AbstractContainer",alias:"widget.container",alternateClassName:"Ext.Container",fireHierarchyEvent:function(a){this.hierarchyEventSource.fireEvent(a,this)},afterHide:function(){this.callParent(arguments);this.fireHierarchyEvent("hide")},afterShow:function(){this.callParent(arguments);this.fireHierarchyEvent("show")},onAdded:function(){this.callParent(arguments);if(this.hierarchyEventSource.hasListeners.added){this.fireHierarchyEvent("added")}},getChildByElement:function(e,a){var g,c,b=0,d=this.getRefItems(),f=d.length;e=Ext.getDom(e);for(;b<f;b++){g=d[b];c=g.getEl();if(c&&((c.dom===e)||c.contains(e))){return(a&&g.getChildByElement)?g.getChildByElement(e,a):g}}return null}},function(){this.hierarchyEventSource=this.prototype.hierarchyEventSource=new Ext.util.Observable({events:{hide:true,show:true,collapse:true,expand:true,added:true}})});Ext.define("Ext.container.Viewport",{extend:"Ext.container.Container",alias:"widget.viewport",requires:["Ext.EventManager"],alternateClassName:"Ext.Viewport",isViewport:true,ariaRole:"application",preserveElOnDestroy:true,initComponent:function(){var c=this,a=document.body.parentNode,b;Ext.getScrollbarSize();c.width=c.height=undefined;c.callParent(arguments);Ext.fly(a).addCls(Ext.baseCSSPrefix+"viewport");if(c.autoScroll){delete c.autoScroll;Ext.fly(a).setStyle("overflow","auto")}c.el=b=Ext.getBody();b.setHeight=Ext.emptyFn;b.setWidth=Ext.emptyFn;b.setSize=Ext.emptyFn;b.dom.scroll="no";c.allowDomMove=false;c.renderTo=c.el},onRender:function(){var a=this;a.callParent(arguments);a.width=Ext.Element.getViewportWidth();a.height=Ext.Element.getViewportHeight()},afterFirstLayout:function(){var a=this;a.callParent(arguments);setTimeout(function(){Ext.EventManager.onWindowResize(a.fireResize,a)},1)},fireResize:function(b,a){if(b!=this.width||a!=this.height){this.setSize(b,a)}}});Ext.define("Ext.panel.Header",{extend:"Ext.container.Container",uses:["Ext.panel.Tool","Ext.draw.Component","Ext.util.CSS","Ext.layout.component.Body","Ext.Img"],alias:"widget.header",isHeader:true,defaultType:"tool",indicateDrag:false,weight:-1,componentLayout:"body",titleAlign:"left",childEls:["body"],renderTpl:['<div id="{id}-body" class="{baseCls}-body {bodyCls}','<tpl for="uiCls"> {parent.baseCls}-body-{parent.ui}-{.}</tpl>"','<tpl if="bodyStyle"> style="{bodyStyle}"</tpl>>',"{%this.renderContainer(out,values)%}","</div>"],headingTpl:'<span id="{id}-textEl" class="{cls}-text {cls}-text-{ui}">{title}</span>',shrinkWrap:3,initComponent:function(){var b=this,e,d,a,c,f;b.addEvents("click","dblclick");b.indicateDragCls=b.baseCls+"-draggable";b.title=b.title||"&#160;";b.tools=b.tools||[];b.items=b.items||[];b.orientation=b.orientation||"horizontal";b.dock=(b.dock)?b.dock:(b.orientation=="horizontal")?"top":"left";b.addClsWithUI([b.orientation,b.dock]);if(b.indicateDrag){b.addCls(b.indicateDragCls)}if(!Ext.isEmpty(b.iconCls)||!Ext.isEmpty(b.icon)){b.initIconCmp();b.items.push(b.iconCmp)}if(b.orientation=="vertical"){b.layout={type:"vbox",align:"center"};b.textConfig={width:16,cls:b.baseCls+"-text",type:"text",text:b.title,rotate:{degrees:90}};c=b.ui;if(Ext.isArray(c)){c=c[0]}e="."+b.baseCls+"-text-"+c;if(Ext.scopeResetCSS){e="."+Ext.baseCSSPrefix+"reset "+e}d=Ext.util.CSS.getRule(e);if(d){a=d.style}else{a=(f=Ext.resetElement.createChild({style:"position:absolute",cls:b.baseCls+"-text-"+c})).getStyles("fontFamily","fontWeight","fontSize","color");f.remove()}if(a){Ext.apply(b.textConfig,{"font-family":a.fontFamily,"font-weight":a.fontWeight,"font-size":a.fontSize,fill:a.color})}b.titleCmp=new Ext.draw.Component({width:16,ariaRole:"heading",focusable:false,viewBox:false,flex:1,id:b.id+"_hd",autoSize:true,items:b.textConfig,xhooks:{setSize:function(g){this.callParent([g])}},childEls:[{name:"textEl",select:"."+b.baseCls+"-text"}]})}else{b.layout={type:"hbox",align:"middle"};b.titleCmp=new Ext.Component({ariaRole:"heading",focusable:false,noWrap:true,flex:1,id:b.id+"_hd",style:"text-align:"+b.titleAlign,cls:b.baseCls+"-text-container",renderTpl:b.getTpl("headingTpl"),renderData:{title:b.title,cls:b.baseCls,ui:b.ui},childEls:["textEl"]})}b.items.push(b.titleCmp);b.items=b.items.concat(b.tools);b.callParent();b.on({dblclick:b.onDblClick,click:b.onClick,element:"el",scope:b})},initIconCmp:function(){var b=this,a={focusable:false,src:Ext.BLANK_IMAGE_URL,cls:[b.baseCls+"-icon",b.iconCls],id:b.id+"-iconEl",iconCls:b.iconCls};if(!Ext.isEmpty(b.icon)){delete a.iconCls;a.src=b.icon}b.iconCmp=new Ext.Img(a)},afterRender:function(){this.el.unselectable();this.callParent()},addUIClsToElement:function(b){var e=this,a=e.callParent(arguments),d=[e.baseCls+"-body-"+b,e.baseCls+"-body-"+e.ui+"-"+b],f,c;if(e.bodyCls){f=e.bodyCls.split(" ");for(c=0;c<d.length;c++){if(!Ext.Array.contains(f,d[c])){f.push(d[c])}}e.bodyCls=f.join(" ")}else{e.bodyCls=d.join(" ")}return a},removeUIClsFromElement:function(b){var e=this,a=e.callParent(arguments),d=[e.baseCls+"-body-"+b,e.baseCls+"-body-"+e.ui+"-"+b],f,c;if(e.bodyCls){f=e.bodyCls.split(" ");for(c=0;c<d.length;c++){Ext.Array.remove(f,d[c])}e.bodyCls=f.join(" ")}return a},addUIToElement:function(){var b=this,c,a;b.callParent(arguments);a=b.baseCls+"-body-"+b.ui;if(b.rendered){if(b.bodyCls){b.body.addCls(b.bodyCls)}else{b.body.addCls(a)}}else{if(b.bodyCls){c=b.bodyCls.split(" ");if(!Ext.Array.contains(c,a)){c.push(a)}b.bodyCls=c.join(" ")}else{b.bodyCls=a}}if(b.titleCmp&&b.titleCmp.rendered&&b.titleCmp.textEl){b.titleCmp.textEl.addCls(b.baseCls+"-text-"+b.ui)}},removeUIFromElement:function(){var b=this,c,a;b.callParent(arguments);a=b.baseCls+"-body-"+b.ui;if(b.rendered){if(b.bodyCls){b.body.removeCls(b.bodyCls)}else{b.body.removeCls(a)}}else{if(b.bodyCls){c=b.bodyCls.split(" ");Ext.Array.remove(c,a);b.bodyCls=c.join(" ")}else{b.bodyCls=a}}if(b.titleCmp&&b.titleCmp.rendered&&b.titleCmp.textEl){b.titleCmp.textEl.removeCls(b.baseCls+"-text-"+b.ui)}},onClick:function(a){this.fireClickEvent("click",a)},onDblClick:function(a){this.fireClickEvent("dblclick",a)},fireClickEvent:function(a,c){var b="."+Ext.panel.Tool.prototype.baseCls;if(!c.getTarget(b)){this.fireEvent(a,this,c)}},getFocusEl:function(){return this.el},getTargetEl:function(){return this.body||this.frameBody||this.el},setTitle:function(d){var c=this,b,a;if(c.rendered){if(c.titleCmp.rendered){if(c.titleCmp.surface){c.title=d||"";b=c.titleCmp.surface.items.items[0];a=c.titleCmp.surface;a.remove(b);c.textConfig.type="text";c.textConfig.text=d;b=a.add(c.textConfig);b.setAttributes({rotate:{degrees:90}},true);c.titleCmp.autoSizeSurface()}else{c.title=d;c.titleCmp.textEl.update(c.title||"&#160;")}c.titleCmp.updateLayout()}else{c.titleCmp.on({render:function(){c.setTitle(d)},single:true})}}else{c.title=d}},getMinWidth:function(){var e=this,d=e.titleCmp.textEl.dom,a,f=e.tools,b,c;d.style.display="inline";a=d.offsetWidth;d.style.display="";if(f&&(b=f.length)){for(c=0;c<b;c++){if(f[c].el){a+=f[c].el.dom.offsetWidth}}}if(e.iconCmp){a+=e.iconCmp.el.dom.offsetWidth}return a+10},setIconCls:function(a){var b=this,d=!a||!a.length,c=b.iconCmp;b.iconCls=a;if(!b.iconCmp&&!d){b.initIconCmp();b.insert(0,b.iconCmp)}else{if(c){if(d){b.iconCmp.destroy();delete b.iconCmp}else{c.removeCls(c.iconCls);c.addCls(a);c.iconCls=a}}}},setIcon:function(a){var b=this,d=!a||!a.length,c=b.iconCmp;b.icon=a;if(!b.iconCmp&&!d){b.initIconCmp();b.insert(0,b.iconCmp)}else{if(c){if(d){b.iconCmp.destroy();delete b.iconCmp}else{c.setSrc(b.icon)}}}},addTool:function(a){this.tools.push(this.add(a))},onAdd:function(b,a){this.callParent(arguments);if(b instanceof Ext.panel.Tool){b.bindTo(this.ownerCt);this.tools[b.type]=b}},initRenderData:function(){return Ext.applyIf(this.callParent(),{bodyCls:this.bodyCls})}});Ext.define("Ext.tab.Tab",{extend:"Ext.button.Button",alias:"widget.tab",requires:["Ext.layout.component.Tab","Ext.util.KeyNav"],componentLayout:"tab",isTab:true,baseCls:Ext.baseCSSPrefix+"tab",activeCls:"active",closableCls:"closable",closable:true,closeText:"Close Tab",active:false,childEls:["closeEl"],scale:false,position:"top",initComponent:function(){var a=this;a.addEvents("activate","deactivate","beforeclose","close");a.callParent(arguments);if(a.card){a.setCard(a.card)}},getTemplateArgs:function(){var b=this,a=b.callParent();a.closable=b.closable;a.closeText=b.closeText;return a},beforeRender:function(){var b=this,a=b.up("tabbar"),c=b.up("tabpanel");b.callParent();b.addClsWithUI(b.position);b.syncClosableUI();if(!b.minWidth){b.minWidth=(a)?a.minTabWidth:b.minWidth;if(!b.minWidth&&c){b.minWidth=c.minTabWidth}if(b.minWidth&&b.iconCls){b.minWidth+=25}}if(!b.maxWidth){b.maxWidth=(a)?a.maxTabWidth:b.maxWidth;if(!b.maxWidth&&c){b.maxWidth=c.maxTabWidth}}},onRender:function(){var a=this;a.callParent(arguments);a.keyNav=new Ext.util.KeyNav(a.el,{enter:a.onEnterKey,del:a.onDeleteKey,scope:a})},enable:function(a){var b=this;b.callParent(arguments);b.removeClsWithUI(b.position+"-disabled");return b},disable:function(a){var b=this;b.callParent(arguments);b.addClsWithUI(b.position+"-disabled");return b},onDestroy:function(){var a=this;Ext.destroy(a.keyNav);delete a.keyNav;a.callParent(arguments)},setClosable:function(a){var b=this;a=(!arguments.length||!!a);if(b.closable!=a){b.closable=a;if(b.card){b.card.closable=a}b.syncClosableUI();if(b.rendered){b.syncClosableElements();b.updateLayout()}}},syncClosableElements:function(){var a=this,b=a.closeEl;if(a.closable){if(!b){a.closeEl=a.btnWrap.insertSibling({tag:"a",cls:a.baseCls+"-close-btn",href:"#",title:a.closeText},"after")}}else{if(b){b.remove();delete a.closeEl}}},syncClosableUI:function(){var b=this,a=[b.closableCls,b.closableCls+"-"+b.position];if(b.closable){b.addClsWithUI(a)}else{b.removeClsWithUI(a)}},setCard:function(a){var b=this;b.card=a;b.setText(b.title||a.title);b.setIconCls(b.iconCls||a.iconCls);b.setIcon(b.icon||a.icon)},onCloseClick:function(){var a=this;if(a.fireEvent("beforeclose",a)!==false){if(a.tabBar){if(a.tabBar.closeTab(a)===false){return}}else{a.fireClose()}}},fireClose:function(){this.fireEvent("close",this)},onEnterKey:function(b){var a=this;if(a.tabBar){a.tabBar.onClick(b,a.el)}},onDeleteKey:function(a){if(this.closable){this.onCloseClick()}},activate:function(b){var a=this;a.active=true;a.addClsWithUI([a.activeCls,a.position+"-"+a.activeCls]);if(b!==true){a.fireEvent("activate",a)}},deactivate:function(b){var a=this;a.active=false;a.removeClsWithUI([a.activeCls,a.position+"-"+a.activeCls]);if(b!==true){a.fireEvent("deactivate",a)}}});Ext.define("Ext.tab.Bar",{extend:"Ext.panel.Header",alias:"widget.tabbar",baseCls:Ext.baseCSSPrefix+"tab-bar",requires:["Ext.tab.Tab"],isTabBar:true,defaultType:"tab",plain:false,childEls:["body","strip"],renderTpl:['<div id="{id}-body" class="{baseCls}-body {bodyCls}<tpl if="ui"> {baseCls}-body-{ui}<tpl for="uiCls"> {parent.baseCls}-body-{parent.ui}-{.}</tpl></tpl>"<tpl if="bodyStyle"> style="{bodyStyle}"</tpl>>',"{%this.renderContainer(out,values)%}","</div>",'<div id="{id}-strip" class="{baseCls}-strip<tpl if="ui"> {baseCls}-strip-{ui}<tpl for="uiCls"> {parent.baseCls}-strip-{parent.ui}-{.}</tpl></tpl>"></div>'],initComponent:function(){var a=this;if(a.plain){a.setUI(a.ui+"-plain")}a.addClsWithUI(a.dock);a.addEvents("change");a.callParent(arguments);a.layout.align=(a.orientation=="vertical")?"left":"top";a.layout.overflowHandler=new Ext.layout.container.boxOverflow.Scroller(a.layout);a.remove(a.titleCmp);delete a.titleCmp;Ext.apply(a.renderData,{bodyCls:a.bodyCls})},getLayout:function(){var a=this;a.layout.type=(a.dock==="top"||a.dock==="bottom")?"hbox":"vbox";return a.callParent(arguments)},onAdd:function(a){a.position=this.dock;this.callParent(arguments)},onRemove:function(a){var b=this;if(a===b.previousTab){b.previousTab=null}b.callParent(arguments)},afterComponentLayout:function(a){this.callParent(arguments);this.strip.setWidth(a)},onClick:function(f,d){var c=this,h=f.getTarget("."+Ext.tab.Tab.prototype.baseCls),b=h&&Ext.getCmp(h.id),g=c.tabPanel,a=b&&b.closeEl&&(d===b.closeEl.dom);if(a){f.preventDefault()}if(b&&b.isDisabled&&!b.isDisabled()){if(b.closable&&a){b.onCloseClick()}else{if(g){g.setActiveTab(b.card)}else{c.setActiveTab(b)}b.focus()}}},closeTab:function(c){var d=this,b=c.card,e=d.tabPanel,a;if(b&&b.fireEvent("beforeclose",b)===false){return false}a=d.findNextActivatable(c);Ext.suspendLayouts();if(e&&b){delete c.ownerCt;b.fireEvent("close",b);e.remove(b);if(!e.getComponent(b)){c.fireClose();d.remove(c)}else{c.ownerCt=d;Ext.resumeLayouts(true);return false}}if(a){if(e){e.setActiveTab(a.card)}else{d.setActiveTab(a)}a.focus()}Ext.resumeLayouts(true)},findNextActivatable:function(a){var b=this;if(a.active&&b.items.getCount()>1){return(b.previousTab&&b.previousTab!==a&&!b.previousTab.disabled)?b.previousTab:(a.next("tab[disabled=false]")||a.prev("tab[disabled=false]"))}},setActiveTab:function(a){var b=this;if(!a.disabled&&a!==b.activeTab){if(b.activeTab){if(b.activeTab.isDestroyed){b.previousTab=null}else{b.previousTab=b.activeTab;b.activeTab.deactivate()}}a.activate();b.activeTab=a;b.fireEvent("change",b,a,a.card);b.on({afterlayout:b.afterTabActivate,scope:b,single:true});b.updateLayout()}},afterTabActivate:function(){this.layout.overflowHandler.scrollToItem(this.activeTab)}});Ext.define("Ext.toolbar.Separator",{extend:"Ext.toolbar.Item",alias:"widget.tbseparator",alternateClassName:"Ext.Toolbar.Separator",baseCls:Ext.baseCSSPrefix+"toolbar-separator",focusable:false,border:true});Ext.define("Ext.layout.container.boxOverflow.Menu",{extend:"Ext.layout.container.boxOverflow.None",requires:["Ext.toolbar.Separator","Ext.button.Button"],alternateClassName:"Ext.layout.boxOverflow.Menu",noItemsMenuText:'<div class="'+Ext.baseCSSPrefix+'toolbar-no-items">(None)</div>',constructor:function(b){var a=this;a.callParent(arguments);a.triggerButtonCls=a.triggerButtonCls||Ext.baseCSSPrefix+"box-menu-"+b.getNames().right;a.menuItems=[]},beginLayout:function(a){this.callParent(arguments);this.clearOverflow(a)},beginLayoutCycle:function(b,a){this.callParent(arguments);if(!a){this.clearOverflow(b);this.layout.cacheChildItems(b)}},onRemove:function(a){Ext.Array.remove(this.menuItems,a)},getSuffixConfig:function(){var c=this,b=c.layout,a=b.owner.id;c.menu=new Ext.menu.Menu({listeners:{scope:c,beforeshow:c.beforeMenuShow}});c.menuTrigger=new Ext.button.Button({id:a+"-menu-trigger",cls:Ext.layout.container.Box.prototype.innerCls+" "+c.triggerButtonCls,hidden:true,ownerCt:b.owner,ownerLayout:b,iconCls:Ext.baseCSSPrefix+c.getOwnerType(b.owner)+"-more-icon",ui:b.owner instanceof Ext.toolbar.Toolbar?"default-toolbar":"default",menu:c.menu,getSplitCls:function(){return""}});return c.menuTrigger.getRenderTree()},getOverflowCls:function(){return Ext.baseCSSPrefix+this.layout.direction+"-box-overflow-body"},handleOverflow:function(d){var c=this,b=c.layout,f=b.getNames(),e=d.state.boxPlan,a=[null,null];c.showTrigger(d);a[f.heightIndex]=(e.maxSize-c.menuTrigger[f.getHeight]())/2;c.menuTrigger.setPosition.apply(c.menuTrigger,a);return{reservedSpace:c.menuTrigger[f.getWidth]()}},captureChildElements:function(){var a=this.menuTrigger;if(a.rendering){a.finishRender()}},_asLayoutRoot:{isRoot:true},clearOverflow:function(g){var f=this,b=f.menuItems,e,c=0,d=b.length,a=f.layout.owner,h=f._asLayoutRoot;a.suspendLayouts();f.captureChildElements();f.hideTrigger();a.resumeLayouts();for(;c<d;c++){e=b[c];e.suspendLayouts();e.show();e.resumeLayouts(h)}b.length=0},showTrigger:function(c){var n=this,j=n.layout,a=j.owner,m=j.getNames(),q=m.x,e=m.width,o=c.state.boxPlan,b=o.targetSize[e],g=c.childItems,k=g.length,f=n.menuTrigger,p,h,d,l;f.suspendLayouts();f.show();f.resumeLayouts(n._asLayoutRoot);b-=n.menuTrigger.getWidth();a.suspendLayouts();n.menuItems.length=0;for(d=0;d<k;d++){p=g[d];l=p.props;if(l[q]+l[e]>b){h=p.target;n.menuItems.push(h);h.hide()}}a.resumeLayouts()},hideTrigger:function(){var a=this.menuTrigger;if(a){a.hide()}},beforeMenuShow:function(h){var g=this,b=g.menuItems,d=0,a=b.length,f,e,c=function(j,i){return j.isXType("buttongroup")&&!(i instanceof Ext.toolbar.Separator)};h.suspendLayouts();g.clearMenu();h.removeAll();for(;d<a;d++){f=b[d];if(!d&&(f instanceof Ext.toolbar.Separator)){continue}if(e&&(c(f,e)||c(e,f))){h.add("-")}g.addComponentToMenu(h,f);e=f}if(h.items.length<1){h.add(g.noItemsMenuText)}h.resumeLayouts()},createMenuConfig:function(c,a){var b=Ext.apply({},c.initialConfig),d=c.toggleGroup;Ext.copyTo(b,c,["iconCls","icon","itemId","disabled","handler","scope","menu"]);Ext.apply(b,{text:c.overflowText||c.text,hideOnClick:a,destroyMenu:false});if(c.isFormField){b.value=c.getValue();if(!b.listeners){b.listeners={}}b.listeners.change=function(g,f,e){c.setValue(f)}}else{if(d||c.enableToggle){Ext.apply(b,{iconAlign:"right",hideOnClick:false,group:d,checked:c.pressed,listeners:{checkchange:function(f,e){c.toggle(e)}}})}}delete b.ownerCt;delete b.xtype;delete b.id;return b},addComponentToMenu:function(f,c){var e=this,d,b,a;if(c instanceof Ext.toolbar.Separator){f.add("-")}else{if(c.isComponent){if(c.isXType("splitbutton")){f.add(e.createMenuConfig(c,true))}else{if(c.isXType("button")){f.add(e.createMenuConfig(c,!c.menu))}else{if(c.isXType("buttongroup")){b=c.items.items;a=b.length;for(d=0;d<a;d++){e.addComponentToMenu(f,b[d])}}else{f.add(Ext.create(Ext.getClassName(c),e.createMenuConfig(c)))}}}}}},clearMenu:function(){var e=this.menu,b,c,a,d;if(e&&e.items){b=e.items.items;a=b.length;for(c=0;c<a;c++){d=b[c];if(d.setMenu){d.setMenu(null)}}}},destroy:function(){var a=this.menuTrigger;if(a&&!this.layout.owner.items.contains(a)){delete a.ownerCt}Ext.destroy(this.menu,a)}});Ext.define("Ext.layout.container.Box",{alias:["layout.box"],extend:"Ext.layout.container.Container",alternateClassName:"Ext.layout.BoxLayout",requires:["Ext.layout.container.boxOverflow.None","Ext.layout.container.boxOverflow.Menu","Ext.layout.container.boxOverflow.Scroller","Ext.util.Format","Ext.dd.DragDropManager"],defaultMargins:{top:0,right:0,bottom:0,left:0},padding:0,pack:"start",flex:undefined,stretchMaxPartner:undefined,type:"box",scrollOffset:0,itemCls:Ext.baseCSSPrefix+"box-item",targetCls:Ext.baseCSSPrefix+"box-layout-ct",innerCls:Ext.baseCSSPrefix+"box-inner",availableSpaceOffset:0,reserveOffset:true,manageMargins:true,childEls:["innerCt","targetEl"],renderTpl:["{%var oc,l=values.$comp.layout,oh=l.overflowHandler;","if (oh.getPrefixConfig!==Ext.emptyFn) {","if(oc=oh.getPrefixConfig())dh.generateMarkup(oc, out)","}%}",'<div id="{ownerId}-innerCt" class="{[l.innerCls]} {[oh.getOverflowCls()]}" role="presentation">','<div id="{ownerId}-targetEl" style="position:absolute;',"width:20000px;","left:0px;top:0px;",'height:1px">',"{%this.renderBody(out, values)%}","</div>","</div>","{%if (oh.getSuffixConfig!==Ext.emptyFn) {","if(oc=oh.getSuffixConfig())dh.generateMarkup(oc, out)","}%}",{disableFormats:true,definitions:"var dh=Ext.DomHelper;"}],constructor:function(a){var c=this,b;c.callParent(arguments);c.flexSortFn=Ext.Function.bind(c.flexSort,c);c.initOverflowHandler();b=typeof c.padding;if(b=="string"||b=="number"){c.padding=Ext.util.Format.parseBox(c.padding);c.padding.height=c.padding.top+c.padding.bottom;c.padding.width=c.padding.left+c.padding.right}},getNames:function(){return this.names},_percentageRe:/^\s*(\d+(?:\.\d*)?)\s*[%]\s*$/,getItemSizePolicy:function(l,m){var i=this,g=i.sizePolicy,f=i.align,e=l.flex,j=f,h=i.names,a=l[h.width],k=l[h.height],c=i._percentageRe,b=c.test(a),d=(f=="stretch");if((d||e||b)&&!m){m=i.owner.getSizeModel()}if(d){if(!c.test(k)&&m[h.height].shrinkWrap){j="stretchmax"}}else{if(f!="stretchmax"){if(c.test(k)){j="stretch"}else{j=""}}}if(e||b){if(!m[h.width].shrinkWrap){g=g.flex}}return g[j]},flexSort:function(d,c){var e=this.getNames().maxWidth,f=Infinity;d=d.target[e]||f;c=c.target[e]||f;if(!isFinite(d)&&!isFinite(c)){return 0}return d-c},isItemBoxParent:function(a){return true},isItemShrinkWrap:function(a){return true},minSizeSortFn:function(d,c){return c.available-d.available},roundFlex:function(a){return Math.ceil(a)},beginCollapse:function(b){var a=this;if(a.direction==="vertical"&&b.collapsedVertical()){b.collapseMemento.capture(["flex"]);delete b.flex}else{if(a.direction==="horizontal"&&b.collapsedHorizontal()){b.collapseMemento.capture(["flex"]);delete b.flex}}},beginExpand:function(a){a.collapseMemento.restore(["flex"])},beginLayout:function(c){var b=this,e=b.owner.stretchMaxPartner,a=b.innerCt.dom.style,d=b.getNames();c.boxNames=d;b.overflowHandler.beginLayout(c);if(typeof e==="string"){e=Ext.getCmp(e)||b.owner.query(e)[0]}c.stretchMaxPartner=e&&c.context.getCmp(e);b.callParent(arguments);c.innerCtContext=c.getEl("innerCt",b);b.scrollParallel=!!(b.owner.autoScroll||b.owner[d.overflowX]);b.scrollPerpendicular=!!(b.owner.autoScroll||b.owner[d.overflowY]);if(b.scrollParallel){b.scrollPos=b.owner.getTargetEl().dom[d.scrollLeft]}a.width="";a.height=""},beginLayoutCycle:function(e,a){var d=this,g=d.align,f=e.boxNames,b=d.pack,c=f.heightModel;d.overflowHandler.beginLayoutCycle(e,a);d.callParent(arguments);e.parallelSizeModel=e[f.widthModel];e.perpendicularSizeModel=e[c];e.boxOptions={align:g={stretch:g=="stretch",stretchmax:g=="stretchmax",center:g==f.center},pack:b={center:b=="center",end:b=="end"}};if(g.stretch&&e.perpendicularSizeModel.shrinkWrap){g.stretchmax=true;g.stretch=false}g.nostretch=!(g.stretch||g.stretchmax);if(e.parallelSizeModel.shrinkWrap){b.center=b.end=false}d.cacheFlexes(e);if(Ext.isWebKit){d.targetEl.setWidth(20000)}},cacheFlexes:function(j){var t=this,k=j.boxNames,a=k.widthModel,d=k.heightModel,c=j.boxOptions.align.nostretch,n=0,b=j.childItems,p=b.length,r=[],l=0,h=k.minWidth,f=t._percentageRe,q=0,s=0,e,m,o,g;while(p--){m=b[p];e=m.target;if(m[a].calculated){m.flex=o=e.flex;if(o){n+=o;r.push(m);l+=e[h]||0}else{g=f.exec(e[k.width]);m.percentageParallel=parseFloat(g[1])/100;++q}}if(c&&m[d].calculated){g=f.exec(e[k.height]);m.percentagePerpendicular=parseFloat(g[1])/100;++s}}j.flexedItems=r;j.flexedMinSize=l;j.totalFlex=n;j.percentageWidths=q;j.percentageHeights=s;Ext.Array.sort(r,t.flexSortFn)},calculate:function(d){var b=this,a=b.getContainerSize(d),f=d.boxNames,c=d.state,e=c.boxPlan||(c.boxPlan={});e.targetSize=a;if(!d.parallelSizeModel.shrinkWrap&&!a[f.gotWidth]){b.done=false;return}if(!c.parallelDone){c.parallelDone=b.calculateParallel(d,f,e)}if(!c.perpendicularDone){c.perpendicularDone=b.calculatePerpendicular(d,f,e)}if(c.parallelDone&&c.perpendicularDone){if(b.owner.dock&&(Ext.isIE6||Ext.isIE7||Ext.isIEQuirks)&&!b.owner.width&&!b.horizontal){e.isIEVerticalDock=true;e.calculatedWidth=e.maxSize+d.getPaddingInfo().width+d.getFrameInfo().width}b.publishInnerCtSize(d,b.reserveOffset?b.availableSpaceOffset:0);if(b.done&&d.childItems.length>1&&d.boxOptions.align.stretchmax&&!c.stretchMaxDone){b.calculateStretchMax(d,f,e);c.stretchMaxDone=true}}else{b.done=false}},calculateParallel:function(j,m,b){var E=this,y=m.width,a=j.childItems,d=m.left,q=m.right,p=m.setWidth,z=a.length,w=j.flexedItems,r=w.length,u=j.boxOptions.pack,l=E.padding,g=b.targetSize[y],A=0,e=l[d],D=e+l[q]+E.scrollOffset+(E.reserveOffset?E.availableSpaceOffset:0),v=Ext.getScrollbarSize()[m.width],t,k,f,x,n,s,C,o,B,c,h;if(v&&E.scrollPerpendicular&&j.parallelSizeModel.shrinkWrap&&!j.boxOptions.align.stretch&&!j.perpendicularSizeModel.shrinkWrap){if(!j.state.perpendicularDone){return false}B=true}for(t=0;t<z;++t){n=a[t];k=n.marginInfo||n.getMarginInfo();A+=k[y];if(!n[m.widthModel].calculated){c=n.getProp(y);D+=c;if(isNaN(D)){return false}}}D+=A;if(j.percentageWidths){h=g-A;if(isNaN(h)){return false}for(t=0;t<z;++t){n=a[t];if(n.percentageParallel){c=Math.ceil(h*n.percentageParallel);c=n.setWidth(c);D+=c}}}if(j.parallelSizeModel.shrinkWrap){b.availableSpace=0;b.tooNarrow=false}else{b.availableSpace=g-D;b.tooNarrow=b.availableSpace<j.flexedMinSize;if(b.tooNarrow&&Ext.getScrollbarSize()[m.height]&&E.scrollParallel&&j.state.perpendicularDone){j.state.perpendicularDone=false;for(t=0;t<z;++t){a[t].invalidate()}}}o=D;f=b.availableSpace;x=j.totalFlex;for(t=0;t<r;t++){n=w[t];s=n.flex;C=E.roundFlex((s/x)*f);C=n[p](C);o+=C;f=Math.max(0,f-C);x-=s}if(u.center){e+=f/2;if(e<0){e=0}}else{if(u.end){e+=f}}for(t=0;t<z;++t){n=a[t];k=n.marginInfo;e+=k[d];n.setProp(m.x,e);e+=k[q]+n.props[y]}o+=j.targetContext.getPaddingInfo()[y];j.state.contentWidth=o;if(B&&(j.peek(m.contentHeight)>b.targetSize[m.height])){o+=v;j[m.hasOverflowY]=true;j.target.componentLayout[m.setWidthInDom]=true;j[m.invalidateScrollY]=(Ext.isStrict&&Ext.isIE8)}j[m.setContentWidth](o);return true},calculatePerpendicular:function(q,u,c){var F=this,a=q.perpendicularSizeModel.shrinkWrap,d=c.targetSize,b=q.childItems,D=b.length,I=Math.max,G=u.height,l=u.setHeight,o=u.top,E=u.y,t=F.padding,v=t[o],g=d[G]-v-t[u.bottom],A=q.boxOptions.align,n=A.stretch,y=A.stretchmax,m=A.center,z=0,f=0,k=Ext.getScrollbarSize().height,H,B,e,s,r,x,w,j,h,p,C;if(n||(m&&!a)){if(isNaN(g)){return false}}if(F.scrollParallel&&c.tooNarrow){if(a){p=true}else{g-=k;c.targetSize[G]-=k}}if(n){x=g}else{for(B=0;B<D;B++){w=b[B];s=(w.marginInfo||w.getMarginInfo())[G];if(!(C=w.percentagePerpendicular)){e=w.getProp(G)}else{++f;if(a){continue}else{e=C*g-s;e=w[u.setHeight](e)}}if(isNaN(z=I(z,e+s,w.target[u.minHeight]||0))){return false}}if(p){z+=k;q[u.hasOverflowX]=true;q.target.componentLayout[u.setHeightInDom]=true;q[u.invalidateScrollX]=(Ext.isStrict&&Ext.isIE8)}j=q.stretchMaxPartner;if(j){q.setProp("maxChildHeight",z);h=j.childItems;if(h&&h.length){z=I(z,j.getProp("maxChildHeight"));if(isNaN(z)){return false}}}q[u.setContentHeight](z+F.padding[G]+q.targetContext.getPaddingInfo()[G]);if(p){z-=k}c.maxSize=z;if(y){x=z}else{if(m||f){x=a?z:I(g,z);x-=q.innerCtContext.getBorderInfo()[G]}}}for(B=0;B<D;B++){w=b[B];s=w.marginInfo||w.getMarginInfo();H=v+s[o];if(n){w[l](x-s[G])}else{C=w.percentagePerpendicular;if(a&&C){s=w.marginInfo||w.getMarginInfo();e=C*x-s[G];e=w.setHeight(e)}if(m){r=x-w.props[G];if(r>0){H=v+Math.round(r/2)}}}w.setProp(E,H)}return true},calculateStretchMax:function(d,j,l){var k=this,g=j.height,m=j.width,f=d.childItems,b=f.length,n=l.maxSize,a=k.onBeforeInvalidateChild,p=k.onAfterInvalidateChild,o,h,e,c;for(e=0;e<b;++e){o=f[e];h=o.props;c=n-o.getMarginInfo()[g];if(c!=h[g]||o[j.heightModel].constrained){o.invalidate({before:a,after:p,layout:k,childWidth:h[m],childHeight:c,childX:h.x,childY:h.y,names:j})}}},completeLayout:function(b){var i=this,h=b.boxNames,g=b.invalidateScrollX,f=b.invalidateScrollY,d,a,e,c,j;i.overflowHandler.completeLayout(b);if(g||f){a=i.getTarget();d=a.dom;j=d.style;if(g){e=a.getStyle("overflowX");if(e=="auto"){e=j.overflowX;j.overflowX="scroll"}else{g=false}}if(f){c=a.getStyle("overflowY");if(c=="auto"){c=j.overflowY;j.overflowY="scroll"}else{f=false}}if(g||f){d.scrollWidth;if(g){j.overflowX=e}if(f){j.overflowY=c}}}if(i.scrollParallel){i.owner.getTargetEl().dom[h.scrollLeft]=i.scrollPos}},finishedLayout:function(a){this.overflowHandler.finishedLayout(a);this.callParent(arguments);if(Ext.isWebKit){this.targetEl.setWidth(a.innerCtContext.props.width)}},onBeforeInvalidateChild:function(b,a){var c=a.names.heightModel;if(!b[c].constrainedMax){b[c]=Ext.layout.SizeModel.calculated}},onAfterInvalidateChild:function(d,c){var f=c.names,e=Ext.getScrollbarSize(),a=c.childHeight,b=c.childWidth;d.setProp("x",c.childX);d.setProp("y",c.childY);if(d[f.heightModel].calculated){d[f.setHeight](a)}if(d[f.widthModel].calculated){d[f.setWidth](b)}},publishInnerCtSize:function(a,d){var h=this,g=a.boxNames,f=g.height,j=g.width,e=a.boxOptions.align,n=h.owner.dock,k=h.padding,i=a.state.boxPlan,c=i.targetSize,m=c[f],o=a.innerCtContext,b=(a.parallelSizeModel.shrinkWrap||(i.tooNarrow&&h.scrollParallel)?a.state.contentWidth:c[j])-(d||0),l;if(e.stretch){l=m}else{l=i.maxSize+k[g.top]+k[g.bottom]+o.getBorderInfo()[f];if(!a.perpendicularSizeModel.shrinkWrap&&e.center){l=Math.max(m,l)}}o[g.setWidth](b);o[g.setHeight](l);if(isNaN(b+l)){h.done=false}if(i.calculatedWidth&&(n=="left"||n=="right")){a.setWidth(i.calculatedWidth,true,true)}},onRemove:function(a){var b=this;b.callParent(arguments);if(b.overflowHandler){b.overflowHandler.onRemove(a)}if(a.layoutMarginCap==b.id){delete a.layoutMarginCap}},initOverflowHandler:function(){var d=this,c=d.overflowHandler,b,a;if(typeof c=="string"){c={type:c}}b="None";if(c&&c.type!==undefined){b=c.type}a=Ext.layout.container.boxOverflow[b];if(a[d.type]){a=a[d.type]}d.overflowHandler=Ext.create("Ext.layout.container.boxOverflow."+b,d,c)},getRenderTarget:function(){return this.targetEl},getElementTarget:function(){return this.innerCt},destroy:function(){Ext.destroy(this.innerCt,this.overflowHandler);this.callParent(arguments)}});Ext.define("Ext.layout.container.HBox",{alias:["layout.hbox"],extend:"Ext.layout.container.Box",alternateClassName:"Ext.layout.HBoxLayout",align:"top",type:"hbox",direction:"horizontal",horizontal:true,names:{lr:"lr",left:"left",leftCap:"Left",right:"right",position:"left",width:"width",contentWidth:"contentWidth",minWidth:"minWidth",maxWidth:"maxWidth",widthCap:"Width",widthModel:"widthModel",widthIndex:0,x:"x",scrollLeft:"scrollLeft",overflowX:"overflowX",hasOverflowX:"hasOverflowX",invalidateScrollX:"invalidateScrollX",center:"middle",top:"top",topPosition:"top",bottom:"bottom",height:"height",contentHeight:"contentHeight",minHeight:"minHeight",maxHeight:"maxHeight",heightCap:"Height",heightModel:"heightModel",heightIndex:1,y:"y",scrollTop:"scrollTop",overflowY:"overflowY",hasOverflowY:"hasOverflowY",invalidateScrollY:"invalidateScrollY",getWidth:"getWidth",getHeight:"getHeight",setWidth:"setWidth",setHeight:"setHeight",gotWidth:"gotWidth",gotHeight:"gotHeight",setContentWidth:"setContentWidth",setContentHeight:"setContentHeight",setWidthInDom:"setWidthInDom",setHeightInDom:"setHeightInDom"},sizePolicy:{flex:{"":{setsWidth:1,setsHeight:0},stretch:{setsWidth:1,setsHeight:1},stretchmax:{readsHeight:1,setsWidth:1,setsHeight:1}},"":{setsWidth:0,setsHeight:0},stretch:{setsWidth:0,setsHeight:1},stretchmax:{readsHeight:1,setsWidth:0,setsHeight:1}}});Ext.define("Ext.layout.container.VBox",{alias:["layout.vbox"],extend:"Ext.layout.container.Box",alternateClassName:"Ext.layout.VBoxLayout",align:"left",type:"vbox",direction:"vertical",horizontal:false,names:{lr:"tb",left:"top",leftCap:"Top",right:"bottom",position:"top",width:"height",contentWidth:"contentHeight",minWidth:"minHeight",maxWidth:"maxHeight",widthCap:"Height",widthModel:"heightModel",widthIndex:1,x:"y",scrollLeft:"scrollTop",overflowX:"overflowY",hasOverflowX:"hasOverflowY",invalidateScrollX:"invalidateScrollY",center:"center",top:"left",topPosition:"left",bottom:"right",height:"width",contentHeight:"contentWidth",minHeight:"minWidth",maxHeight:"maxWidth",heightCap:"Width",heightModel:"widthModel",heightIndex:0,y:"x",scrollTop:"scrollLeft",overflowY:"overflowX",hasOverflowY:"hasOverflowX",invalidateScrollY:"invalidateScrollX",getWidth:"getHeight",getHeight:"getWidth",setWidth:"setHeight",setHeight:"setWidth",gotWidth:"gotHeight",gotHeight:"gotWidth",setContentWidth:"setContentHeight",setContentHeight:"setContentWidth",setWidthInDom:"setHeightInDom",setHeightInDom:"setWidthInDom"},sizePolicy:{flex:{"":{setsWidth:0,setsHeight:1},stretch:{setsWidth:1,setsHeight:1},stretchmax:{readsWidth:1,setsWidth:1,setsHeight:1}},"":{setsWidth:0,setsHeight:0},stretch:{setsWidth:1,setsHeight:0},stretchmax:{readsWidth:1,setsWidth:1,setsHeight:0}}});Ext.define("Ext.toolbar.Toolbar",{extend:"Ext.container.Container",requires:["Ext.toolbar.Fill","Ext.layout.container.HBox","Ext.layout.container.VBox"],uses:["Ext.toolbar.Separator"],alias:"widget.toolbar",alternateClassName:"Ext.Toolbar",isToolbar:true,baseCls:Ext.baseCSSPrefix+"toolbar",ariaRole:"toolbar",defaultType:"button",vertical:false,enableOverflow:false,menuTriggerCls:Ext.baseCSSPrefix+"toolbar-more-icon",trackMenus:true,itemCls:Ext.baseCSSPrefix+"toolbar-item",statics:{shortcuts:{"-":"tbseparator"," ":"tbspacer"},shortcutsHV:{0:{"->":{xtype:"tbfill",height:0}},1:{"->":{xtype:"tbfill",width:0}}}},initComponent:function(){var b=this,a;if(!b.layout&&b.enableOverflow){b.layout={overflowHandler:"Menu"}}if(b.dock==="right"||b.dock==="left"){b.vertical=true}b.layout=Ext.applyIf(Ext.isString(b.layout)?{type:b.layout}:b.layout||{},{type:b.vertical?"vbox":"hbox",align:b.vertical?"stretchmax":"middle"});if(b.vertical){b.addClsWithUI("vertical")}if(b.ui==="footer"){b.ignoreBorderManagement=true}b.callParent();b.addEvents("overflowchange")},getRefItems:function(a){var e=this,b=e.callParent(arguments),d=e.layout,c;if(a&&e.enableOverflow){c=d.overflowHandler;if(c&&c.menu){b=b.concat(c.menu.getRefItems(a))}}return b},lookupComponent:function(d){if(typeof d=="string"){var b=Ext.toolbar.Toolbar,a=b.shortcutsHV[this.vertical?1:0][d]||b.shortcuts[d];if(typeof a=="string"){d={xtype:a}}else{if(a){d=Ext.apply({},a)}else{d={xtype:"tbtext",text:d}}}this.applyDefaults(d)}return this.callParent(arguments)},applyDefaults:function(a){if(!Ext.isString(a)){a=this.callParent(arguments)}return a},trackMenu:function(c,a){if(this.trackMenus&&c.menu){var d=a?"mun":"mon",b=this;b[d](c,"mouseover",b.onButtonOver,b);b[d](c,"menushow",b.onButtonMenuShow,b);b[d](c,"menuhide",b.onButtonMenuHide,b)}},constructButton:function(a){return a.events?a:Ext.widget(a.split?"splitbutton":this.defaultType,a)},onBeforeAdd:function(a){if(a.is("field")||(a.is("button")&&this.ui!="footer")){a.ui=a.ui+"-toolbar"}if(a instanceof Ext.toolbar.Separator){a.setUI((this.vertical)?"vertical":"horizontal")}this.callParent(arguments)},onAdd:function(a){this.callParent(arguments);this.trackMenu(a)},onRemove:function(a){this.callParent(arguments);this.trackMenu(a,true)},getChildItemsToDisable:function(){return this.items.getRange()},onButtonOver:function(a){if(this.activeMenuBtn&&this.activeMenuBtn!=a){this.activeMenuBtn.hideMenu();a.showMenu();this.activeMenuBtn=a}},onButtonMenuShow:function(a){this.activeMenuBtn=a},onButtonMenuHide:function(a){delete this.activeMenuBtn}});Ext.define("Ext.layout.container.Accordion",{extend:"Ext.layout.container.VBox",alias:["layout.accordion"],alternateClassName:"Ext.layout.AccordionLayout",itemCls:[Ext.baseCSSPrefix+"box-item",Ext.baseCSSPrefix+"accordion-item"],align:"stretch",fill:true,titleCollapse:true,hideCollapseTool:false,collapseFirst:false,animate:true,activeOnTop:false,multi:false,defaultAnimatePolicy:{y:true,height:true},constructor:function(){var a=this;a.callParent(arguments);if(a.animate){a.animatePolicy=Ext.apply({},a.defaultAnimatePolicy)}else{a.animatePolicy=null}},beforeRenderItems:function(b){var e=this,d=b.length,c=0,a;for(;c<d;c++){a=b[c];if(!a.rendered){if(e.collapseFirst){a.collapseFirst=e.collapseFirst}if(e.hideCollapseTool){a.hideCollapseTool=e.hideCollapseTool;a.titleCollapse=true}else{if(e.titleCollapse){a.titleCollapse=e.titleCollapse}}delete a.hideHeader;delete a.width;a.collapsible=true;a.title=a.title||"&#160;";a.addBodyCls(Ext.baseCSSPrefix+"accordion-body");if(!e.multi){if(e.expandedItem!==undefined){a.collapsed=true}else{if(a.hasOwnProperty("collapsed")&&a.collapsed===false){e.expandedItem=c}else{a.collapsed=true}}e.owner.mon(a,{show:e.onComponentShow,beforeexpand:e.onComponentExpand,scope:e})}if(e.fill){e.owner.mon(a,{beforecollapse:e.onComponentCollapse,scope:e})}}}if(d&&e.expandedItem===undefined){e.expandedItem=0;b[0].collapsed=false}},getItemsRenderTree:function(a){this.beforeRenderItems(a);return this.callParent(arguments)},renderItems:function(a,b){this.beforeRenderItems(a);this.callParent(arguments)},configureItem:function(a){this.callParent(arguments);a.animCollapse=a.border=false;if(this.fill){a.flex=1}},onChildPanelRender:function(a){a.header.addCls(Ext.baseCSSPrefix+"accordion-hd")},beginLayout:function(a){this.callParent(arguments);this.updatePanelClasses(a)},updatePanelClasses:function(e){var c=e.visibleItems,d=c.length,a=true,b,g,f;for(b=0;b<d;b++){g=c[b];f=g.header;f.addCls(Ext.baseCSSPrefix+"accordion-hd");if(a){f.removeCls(Ext.baseCSSPrefix+"accordion-hd-sibling-expanded")}else{f.addCls(Ext.baseCSSPrefix+"accordion-hd-sibling-expanded")}if(b+1==d&&g.collapsed){f.addCls(Ext.baseCSSPrefix+"accordion-hd-last-collapsed")}else{f.removeCls(Ext.baseCSSPrefix+"accordion-hd-last-collapsed")}a=g.collapsed}},onComponentExpand:function(g){var e=this,a=e.owner,c,f,d,b;if(!e.processing){e.processing=true;b=a.deferLayouts;a.deferLayouts=true;c=e.multi?[]:a.query(">panel:not([collapsed])");f=c.length;for(d=0;d<f;d++){c[d].collapse()}a.deferLayouts=b;e.processing=false}},onComponentCollapse:function(d){var e=this,a=e.owner,f,c,b;if(e.owner.items.getCount()===1){return false}if(!e.processing){e.processing=true;b=a.deferLayouts;a.deferLayouts=true;f=d.next()||d.prev();if(e.multi){c=e.owner.query(">panel:not([collapsed])");if(c.length===1){f.expand()}}else{if(f){f.expand()}}a.deferLayouts=b;e.processing=false}},onComponentShow:function(a){this.onComponentExpand(a)}});Ext.define("Ext.panel.AbstractPanel",{extend:"Ext.container.Container",mixins:{docking:"Ext.container.DockingContainer"},requires:["Ext.util.MixedCollection","Ext.Element","Ext.toolbar.Toolbar"],baseCls:Ext.baseCSSPrefix+"panel",isPanel:true,componentLayout:"dock",childEls:["body"],renderTpl:["{% this.renderDockedItems(out,values,0); %}",(Ext.isIE6||Ext.isIE7||Ext.isIEQuirks)?"<div></div>":"",'<div id="{id}-body" class="{baseCls}-body<tpl if="bodyCls"> {bodyCls}</tpl>',' {baseCls}-body-{ui}<tpl if="uiCls">','<tpl for="uiCls"> {parent.baseCls}-body-{parent.ui}-{.}</tpl>','</tpl>"<tpl if="bodyStyle"> style="{bodyStyle}"</tpl>>',"{%this.renderContainer(out,values);%}","</div>","{% this.renderDockedItems(out,values,1); %}"],bodyPosProps:{x:"x",y:"y"},border:true,emptyArray:[],initComponent:function(){var a=this;if(a.frame&&a.border&&a.bodyBorder===undefined){a.bodyBorder=false}if(a.frame&&a.border&&(a.bodyBorder===false||a.bodyBorder===0)){a.manageBodyBorders=true}a.callParent()},beforeDestroy:function(){this.destroyDockedItems();this.callParent()},initItems:function(){this.callParent();this.initDockingItems()},initRenderData:function(){var a=this,b=a.callParent();a.initBodyStyles();a.protoBody.writeTo(b);delete a.protoBody;return b},getComponent:function(a){var b=this.callParent(arguments);if(b===undefined&&!Ext.isNumber(a)){b=this.getDockedComponent(a)}return b},getProtoBody:function(){var b=this,a=b.protoBody;if(!a){b.protoBody=a=new Ext.util.ProtoElement({cls:b.bodyCls,style:b.bodyStyle,clsProp:"bodyCls",styleProp:"bodyStyle",styleIsText:true})}return a},initBodyStyles:function(){var c=this,a=c.getProtoBody(),b=Ext.Element;if(c.bodyPadding!==undefined){a.setStyle("padding",b.unitizeBox((c.bodyPadding===true)?5:c.bodyPadding))}if(c.frame&&c.bodyBorder){if(!Ext.isNumber(c.bodyBorder)){c.bodyBorder=1}a.setStyle("border-width",b.unitizeBox(c.bodyBorder))}},getCollapsedDockedItems:function(){var a=this;return a.collapseMode=="placeholder"?a.emptyArray:[a.getReExpander()]},setBodyStyle:function(b,d){var c=this,a=c.rendered?c.body:c.getProtoBody();if(Ext.isFunction(b)){b=b()}if(arguments.length==1){if(Ext.isString(b)){b=Ext.Element.parseStyles(b)}a.setStyle(b)}else{a.setStyle(b,d)}return c},addBodyCls:function(b){var c=this,a=c.rendered?c.body:c.getProtoBody();a.addCls(b);return c},removeBodyCls:function(b){var c=this,a=c.rendered?c.body:c.getProtoBody();a.removeCls(b);return c},addUIClsToElement:function(b){var c=this,a=c.callParent(arguments);c.addBodyCls([Ext.baseCSSPrefix+b,c.baseCls+"-body-"+b,c.baseCls+"-body-"+c.ui+"-"+b]);return a},removeUIClsFromElement:function(b){var c=this,a=c.callParent(arguments);c.removeBodyCls([Ext.baseCSSPrefix+b,c.baseCls+"-body-"+b,c.baseCls+"-body-"+c.ui+"-"+b]);return a},addUIToElement:function(){var a=this;a.callParent(arguments);a.addBodyCls(a.baseCls+"-body-"+a.ui)},removeUIFromElement:function(){var a=this;a.callParent(arguments);a.removeBodyCls(a.baseCls+"-body-"+a.ui)},getTargetEl:function(){return this.body},getRefItems:function(a){var b=this.callParent(arguments);return this.getDockingRefItems(a,b)},setupRenderTpl:function(a){this.callParent(arguments);this.setupDockingRenderTpl(a)}});Ext.define("Ext.grid.ColumnLayout",{extend:"Ext.layout.container.HBox",alias:"layout.gridcolumn",type:"gridcolumn",reserveOffset:false,firstHeaderCls:Ext.baseCSSPrefix+"column-header-first",lastHeaderCls:Ext.baseCSSPrefix+"column-header-last",initLayout:function(){this.grid=this.owner.up("[scrollerOwner]");this.callParent()},beginLayout:function(h){var g=this,e=g.grid,b=e.view,d=0,c=g.getVisibleItems(),a=c.length,f;h.gridContext=h.context.getCmp(g.grid);if(e.lockable){if(g.owner.up("tablepanel")===b.normalGrid){b=b.normalGrid.getView()}else{b=null}}g.callParent(arguments);for(;d<a;d++){f=c[d];f.removeCls([g.firstHeaderCls,g.lastHeaderCls]);f.el.setStyle({height:"auto"});f.titleEl.setStyle({height:"auto",paddingTop:""})}if(a>0){c[0].addCls(g.firstHeaderCls);c[a-1].addCls(g.lastHeaderCls)}if(!g.owner.isHeader&&Ext.getScrollbarSize().width&&!e.collapsed&&b&&b.table.dom&&(b.autoScroll||b.overflowY)){h.viewContext=h.context.getCmp(b)}},roundFlex:function(a){return Math.floor(a)},calculate:function(e){var d=this,c=e.viewContext,b,a;d.callParent(arguments);if(e.state.parallelDone){e.setProp("columnWidthsDone",true)}if(c&&!e.state.overflowAdjust.width&&!e.gridContext.heightModel.shrinkWrap){b=c.tableContext.getProp("height");a=c.getProp("height");if(isNaN(b+a)){d.done=false}else{if(b>=a){e.gridContext.invalidate({after:function(){e.state.overflowAdjust={width:Ext.getScrollbarSize().width,height:0}}})}}}},completeLayout:function(c){var h=this,b=h.owner,a=c.state,f=false,j=h.sizeModels.calculated,e,g,d,l,k;h.callParent(arguments);if(!a.flexesCalculated&&b.forceFit&&!b.isHeader){e=c.childItems;g=e.length;for(d=0;d<g;d++){l=e[d];k=l.target;if(k.width){k.flex=c.childItems[d].flex=k.width;delete k.width;l.widthModel=j;f=true}}if(f){h.cacheFlexes(c);c.invalidate({state:{flexesCalculated:true}})}}},finalizeLayout:function(){var f=this,e=0,d,b,g,a=f.owner,c=a.titleEl;d=f.getVisibleItems();b=d.length;g=a.el.getViewSize().height;if(c){g-=c.getHeight()}for(;e<b;e++){d[e].setPadding(g)}},publishInnerCtSize:function(e){var d=this,c=e.state.boxPlan.targetSize,b=e.peek("contentWidth"),a;if((b!=null)&&!d.owner.isHeader){c.width=b;a=d.owner.ownerCt.view;if(a.autoScroll||a.overflowY){c.width+=Ext.getScrollbarSize().width}}return d.callParent(arguments)}});Ext.define("Ext.dd.StatusProxy",{extend:"Ext.Component",animRepair:false,childEls:["ghost"],renderTpl:['<div class="'+Ext.baseCSSPrefix+'dd-drop-icon"></div><div id="{id}-ghost" class="'+Ext.baseCSSPrefix+'dd-drag-ghost"></div>'],constructor:function(a){var b=this;a=a||{};Ext.apply(b,{hideMode:"visibility",hidden:true,floating:true,id:b.id||Ext.id(),cls:Ext.baseCSSPrefix+"dd-drag-proxy "+this.dropNotAllowed,shadow:a.shadow||false,renderTo:Ext.getDetachedBody()});b.callParent(arguments);this.dropStatus=this.dropNotAllowed},dropAllowed:Ext.baseCSSPrefix+"dd-drop-ok",dropNotAllowed:Ext.baseCSSPrefix+"dd-drop-nodrop",setStatus:function(a){a=a||this.dropNotAllowed;if(this.dropStatus!=a){this.el.replaceCls(this.dropStatus,a);this.dropStatus=a}},reset:function(b){var c=this,a=Ext.baseCSSPrefix+"dd-drag-proxy ";c.el.replaceCls(a+c.dropAllowed,a+c.dropNotAllowed);c.dropStatus=c.dropNotAllowed;if(b){c.ghost.update("")}},update:function(a){if(typeof a=="string"){this.ghost.update(a)}else{this.ghost.update("");a.style.margin="0";this.ghost.dom.appendChild(a)}var b=this.ghost.dom.firstChild;if(b){Ext.fly(b).setStyle("float","none")}},getGhost:function(){return this.ghost},hide:function(a){this.callParent();if(a){this.reset(true)}},stop:function(){if(this.anim&&this.anim.isAnimated&&this.anim.isAnimated()){this.anim.stop()}},sync:function(){this.el.sync()},repair:function(c,d,a){var b=this;b.callback=d;b.scope=a;if(c&&b.animRepair!==false){b.el.addCls(Ext.baseCSSPrefix+"dd-drag-repair");b.el.hideUnders(true);b.anim=b.el.animate({duration:b.repairDuration||500,easing:"ease-out",to:{x:c[0],y:c[1]},stopAnimation:true,callback:b.afterRepair,scope:b})}else{b.afterRepair()}},afterRepair:function(){var a=this;a.hide(true);a.el.removeCls(Ext.baseCSSPrefix+"dd-drag-repair");if(typeof a.callback=="function"){a.callback.call(a.scope||a)}delete a.callback;delete a.scope}});Ext.define("Ext.LoadMask",{extend:"Ext.Component",alias:"widget.loadmask",mixins:{floating:"Ext.util.Floating",bindable:"Ext.util.Bindable"},uses:["Ext.data.StoreManager"],msg:"Loading...",msgCls:Ext.baseCSSPrefix+"mask-loading",maskCls:Ext.baseCSSPrefix+"mask",useMsg:true,useTargetEl:false,baseCls:Ext.baseCSSPrefix+"mask-msg",childEls:["msgEl"],renderTpl:'<div id="{id}-msgEl" style="position:relative" class="{[values.$comp.msgCls]}"></div>',floating:{shadow:"frame"},focusOnToFront:false,bringParentToFront:false,constructor:function(a,b){var c=this;if(!a.isComponent){a=Ext.get(a);this.isElement=true}c.ownerCt=a;if(!this.isElement){c.bindComponent(a)}c.callParent([b]);if(c.store){c.bindStore(c.store,true)}},bindComponent:function(a){var c=this,b={scope:this,resize:c.sizeMask,added:c.onComponentAdded,removed:c.onComponentRemoved},d=Ext.container.Container.hierarchyEventSource;if(a.floating){b.move=c.sizeMask;c.activeOwner=a}else{if(a.ownerCt){c.onComponentAdded(a.ownerCt)}else{c.preventBringToFront=true}}c.mon(a,b);c.mon(d,{show:c.onContainerShow,hide:c.onContainerHide,expand:c.onContainerExpand,collapse:c.onContainerCollapse,scope:c})},onComponentAdded:function(a){var b=this;delete b.activeOwner;b.floatParent=a;if(!a.floating){a=a.up("[floating]")}if(a){b.activeOwner=a;b.mon(a,"move",b.sizeMask,b)}a=b.floatParent.ownerCt;if(b.rendered&&b.isVisible()&&a){b.floatOwner=a;b.mon(a,"afterlayout",b.sizeMask,b,{single:true})}},onComponentRemoved:function(a){var c=this,d=c.activeOwner,b=c.floatOwner;if(d){c.mun(d,"move",c.sizeMask,c)}if(b){c.mun(b,"afterlayout",c.sizeMask,c)}delete c.activeOwner;delete c.floatOwner},afterRender:function(){this.callParent(arguments);this.container=this.floatParent.getContentTarget()},onContainerShow:function(a){if(this.isActiveContainer(a)){this.onComponentShow()}},onContainerHide:function(a){if(this.isActiveContainer(a)){this.onComponentHide()}},onContainerExpand:function(a){if(this.isActiveContainer(a)){this.onComponentShow()}},onContainerCollapse:function(a){if(this.isActiveContainer(a)){this.onComponentHide()}},isActiveContainer:function(a){return this.isDescendantOf(a)},onComponentHide:function(){var a=this;if(a.rendered&&a.isVisible()){a.hide();a.showNext=true}},onComponentShow:function(){if(this.showNext){this.show()}delete this.showNext},sizeMask:function(){var a=this,b;if(a.rendered&&a.isVisible()){a.center();b=a.getMaskTarget();a.getMaskEl().show().setSize(b.getSize()).alignTo(b,"tl-tl")}},bindStore:function(a,b){var c=this;c.mixins.bindable.bindStore.apply(c,arguments);a=c.store;if(a&&a.isLoading()){c.onBeforeLoad()}},getStoreListeners:function(){return{beforeload:this.onBeforeLoad,load:this.onLoad,exception:this.onLoad,cachemiss:this.onBeforeLoad,cachefilled:this.onLoad}},onDisable:function(){this.callParent(arguments);if(this.loading){this.onLoad()}},getOwner:function(){return this.ownerCt||this.floatParent},getMaskTarget:function(){var a=this.getOwner();return this.useTargetEl?a.getTargetEl():a.getEl()},onBeforeLoad:function(){var c=this,a=c.getOwner(),b;if(!c.disabled){c.loading=true;if(a.componentLayoutCounter){c.maybeShow()}else{b=a.afterComponentLayout;a.afterComponentLayout=function(){a.afterComponentLayout=b;b.apply(a,arguments);c.maybeShow()}}}},maybeShow:function(){var b=this,a=b.getOwner();if(!a.isVisible(true)){b.showNext=true}else{if(b.loading&&a.rendered){b.show()}}},getMaskEl:function(){var a=this;return a.maskEl||(a.maskEl=a.el.insertSibling({cls:a.maskCls,style:{zIndex:a.el.getStyle("zIndex")-2}},"before"))},onShow:function(){var b=this,a=b.msgEl;b.callParent(arguments);b.loading=true;if(b.useMsg){a.show().update(b.msg)}else{a.parent().hide()}},hide:function(){if(this.isElement){this.ownerCt.unmask();this.fireEvent("hide",this);return}delete this.showNext;return this.callParent(arguments)},onHide:function(){this.callParent();this.getMaskEl().hide()},show:function(){if(this.isElement){this.ownerCt.mask(this.useMsg?this.msg:"",this.msgCls);this.fireEvent("show",this);return}return this.callParent(arguments)},afterShow:function(){this.callParent(arguments);this.sizeMask()},setZIndex:function(b){var c=this,a=c.activeOwner;if(a){b=parseInt(a.el.getStyle("zIndex"),10)+1}c.getMaskEl().setStyle("zIndex",b-1);return c.mixins.floating.setZIndex.apply(c,arguments)},onLoad:function(){this.loading=false;this.hide()},onDestroy:function(){var a=this;if(a.isElement){a.ownerCt.unmask()}Ext.destroy(a.maskEl);a.callParent()}});Ext.define("Ext.selection.DataViewModel",{extend:"Ext.selection.Model",requires:["Ext.util.KeyNav"],deselectOnContainerClick:true,enableKeyNav:true,constructor:function(a){this.addEvents("beforedeselect","beforeselect","deselect","select");this.callParent(arguments)},bindComponent:function(a){var b=this,c={refresh:b.refresh,scope:b};b.view=a;b.bindStore(a.getStore());c[a.triggerEvent]=b.onItemClick;c[a.triggerCtEvent]=b.onContainerClick;a.on(c);if(b.enableKeyNav){b.initKeyNav(a)}},onItemClick:function(b,a,d,c,f){this.selectWithEvent(a,f)},onContainerClick:function(){if(this.deselectOnContainerClick){this.deselectAll()}},initKeyNav:function(a){var b=this;if(!a.rendered){a.on({render:Ext.Function.bind(b.initKeyNav,b,[a]),single:true});return}a.el.set({tabIndex:-1});b.keyNav=new Ext.util.KeyNav({target:a.el,ignoreInputFields:true,down:Ext.pass(b.onNavKey,[1],b),right:Ext.pass(b.onNavKey,[1],b),left:Ext.pass(b.onNavKey,[-1],b),up:Ext.pass(b.onNavKey,[-1],b),scope:b})},onNavKey:function(f){f=f||1;var e=this,b=e.view,d=e.getSelection()[0],c=e.view.store.getCount(),a;if(d){a=b.indexOf(b.getNode(d))+f}else{a=0}if(a<0){a=c-1}else{if(a>=c){a=0}}e.select(a)},onSelectChange:function(b,e,d,g){var f=this,a=f.view,c=e?"select":"deselect";if((d||f.fireEvent("before"+c,f,b))!==false&&g()!==false){if(a){if(e){a.onItemSelect(b)}else{a.onItemDeselect(b)}}if(!d){f.fireEvent(c,f,b)}}},destroy:function(){Ext.destroy(this.keyNav);this.callParent()}});Ext.define("Ext.view.AbstractView",{extend:"Ext.Component",requires:["Ext.LoadMask","Ext.data.StoreManager","Ext.CompositeElementLite","Ext.DomQuery","Ext.selection.DataViewModel"],mixins:{bindable:"Ext.util.Bindable"},inheritableStatics:{getRecord:function(a){return this.getBoundView(a).getRecord(a)},getBoundView:function(a){return Ext.getCmp(a.boundView)}},deferInitialRefresh:true,itemCls:Ext.baseCSSPrefix+"dataview-item",loadingText:"Loading...",loadMask:true,loadingUseMsg:true,selectedItemCls:Ext.baseCSSPrefix+"item-selected",emptyText:"",deferEmptyText:true,trackOver:false,blockRefresh:false,preserveScrollOnRefresh:false,last:false,triggerEvent:"itemclick",triggerCtEvent:"containerclick",addCmpEvents:function(){},initComponent:function(){var c=this,a=Ext.isDefined,d=c.itemTpl,b={};if(d){if(Ext.isArray(d)){d=d.join("")}else{if(Ext.isObject(d)){b=Ext.apply(b,d.initialConfig);d=d.html}}if(!c.itemSelector){c.itemSelector="."+c.itemCls}d=Ext.String.format('<tpl for="."><div class="{0}">{1}</div></tpl>',c.itemCls,d);c.tpl=new Ext.XTemplate(d,b)}c.callParent();if(Ext.isString(c.tpl)||Ext.isArray(c.tpl)){c.tpl=new Ext.XTemplate(c.tpl)}c.addEvents("beforerefresh","refresh","viewready","itemupdate","itemadd","itemremove");c.addCmpEvents();c.store=Ext.data.StoreManager.lookup(c.store||"ext-empty-store");c.bindStore(c.store,true);c.all=new Ext.CompositeElementLite();c.scrollState={top:0,left:0};c.on({scroll:c.onViewScroll,element:"el",scope:c})},onRender:function(){var c=this,b=c.loadMask,a={msg:c.loadingText,msgCls:c.loadingCls,useMsg:c.loadingUseMsg,store:c.getMaskStore()};c.callParent(arguments);if(b){if(Ext.isObject(b)){a=Ext.apply(a,b)}c.loadMask=new Ext.LoadMask(c,a);c.loadMask.on({scope:c,beforeshow:c.onMaskBeforeShow,hide:c.onMaskHide})}},finishRender:function(){var a=this;a.callParent(arguments);if(!a.up("[collapsed],[hidden]")){a.doFirstRefresh(a.store)}},onBoxReady:function(){var a=this;a.callParent(arguments);if(!a.firstRefreshDone){a.doFirstRefresh(a.store)}},getMaskStore:function(){return this.store},onMaskBeforeShow:function(){var b=this,a=b.loadingHeight;b.getSelectionModel().deselectAll();b.all.clear();if(a&&a>b.getHeight()){b.hasLoadingHeight=true;b.oldMinHeight=b.minHeight;b.minHeight=a;b.updateLayout()}},onMaskHide:function(){var a=this;if(!a.destroying&&a.hasLoadingHeight){a.minHeight=a.oldMinHeight;a.updateLayout();delete a.hasLoadingHeight}},beforeRender:function(){this.callParent(arguments);this.getSelectionModel().beforeViewRender(this)},afterRender:function(){this.callParent(arguments);this.getSelectionModel().bindComponent(this)},getSelectionModel:function(){var a=this,b="SINGLE";if(!a.selModel){a.selModel={}}if(a.simpleSelect){b="SIMPLE"}else{if(a.multiSelect){b="MULTI"}}Ext.applyIf(a.selModel,{allowDeselect:a.allowDeselect,mode:b});if(!a.selModel.events){a.selModel=new Ext.selection.DataViewModel(a.selModel)}if(!a.selModel.hasRelaySetup){a.relayEvents(a.selModel,["selectionchange","beforeselect","beforedeselect","select","deselect","focuschange"]);a.selModel.hasRelaySetup=true}if(a.disableSelection){a.selModel.locked=true}return a.selModel},refresh:function(){var c=this,g,b,e,d,f,a;if(!c.rendered||c.isDestroyed){return}if(!c.hasListeners.beforerefresh||c.fireEvent("beforerefresh",c)!==false){g=c.getTargetEl();a=c.store.getRange();f=g.dom;if(!c.preserveScrollOnRefresh){b=f.parentNode;e=f.style.display;f.style.display="none";d=f.nextSibling;b.removeChild(f)}if(c.refreshCounter){c.clearViewEl()}else{c.fixedNodes=g.dom.childNodes.length;c.refreshCounter=1}c.tpl.append(g,c.collectData(a,0));if(a.length<1){if(!c.deferEmptyText||c.hasSkippedEmptyText){Ext.core.DomHelper.insertHtml("beforeEnd",g.dom,c.emptyText)}c.all.clear()}else{c.all.fill(Ext.query(c.getItemSelector(),g.dom));c.updateIndexes(0)}c.selModel.refresh();c.hasSkippedEmptyText=true;if(!c.preserveScrollOnRefresh){b.insertBefore(f,d);f.style.display=e}this.refreshSize();c.fireEvent("refresh",c);if(!c.viewReady){c.viewReady=true;c.fireEvent("viewready",c)}}},refreshSize:function(){var a=this.getSizeModel();if(a.height.shrinkWrap||a.width.shrinkWrap){this.updateLayout()}},clearViewEl:function(){var b=this,a=b.getTargetEl();if(b.fixedNodes){while(a.dom.childNodes[b.fixedNodes]){a.dom.removeChild(a.dom.childNodes[b.fixedNodes])}}else{a.update("")}b.refreshCounter++},onViewScroll:Ext.emptyFn,saveScrollState:function(){if(this.rendered){var b=this.el.dom,a=this.scrollState;a.left=b.scrollLeft;a.top=b.scrollTop}},restoreScrollState:function(){if(this.rendered){var b=this.el.dom,a=this.scrollState;b.scrollLeft=a.left;b.scrollTop=a.top}},prepareData:function(e,d,c){var b,a;if(c){b=c.getAssociatedData();for(a in b){if(b.hasOwnProperty(a)){e[a]=b[a]}}}return e},collectData:function(c,f){var e=[],d=0,a=c.length,b;for(;d<a;d++){b=c[d];e[d]=this.prepareData(b.data,f+d,b)}return e},bufferRender:function(a,b){var c=this,d=c.renderBuffer||(c.renderBuffer=document.createElement("div"));c.tpl.overwrite(d,c.collectData(a,b));return Ext.query(c.getItemSelector(),d)},onUpdate:function(e,a){var d=this,b,c;if(d.viewReady){b=d.store.indexOf(a);if(b>-1){c=d.bufferRender([a],b)[0];if(d.getNode(a)){d.all.replaceElement(b,c,true);d.updateIndexes(b,b);d.selModel.refresh();if(d.hasListeners.itemupdate){d.fireEvent("itemupdate",a,b,c)}return c}}}},onAdd:function(e,b,c){var d=this,a;if(d.rendered){if(d.all.getCount()===0){d.refresh();return}a=d.bufferRender(b,c);d.doAdd(a,b,c);d.selModel.refresh();d.updateIndexes(c);d.refreshSize();if(d.hasListeners.itemadd){d.fireEvent("itemadd",b,c,a)}}},doAdd:function(b,a,c){var d=this.all,e=d.getCount();if(e===0){this.clearViewEl();this.getTargetEl().appendChild(b)}else{if(c<e){if(c===0){d.item(c).insertSibling(b,"before",true)}else{d.item(c-1).insertSibling(b,"after",true)}}else{d.last().insertSibling(b,"after",true)}}Ext.Array.insert(d.elements,c,b)},onRemove:function(d,a,b){var c=this;if(c.all.getCount()){if(c.store.getCount()===0){c.refresh()}else{c.doRemove(a,b);if(c.selModel.refreshOnRemove){c.selModel.refresh()}c.updateIndexes(b)}this.refreshSize();if(c.hasListeners.itemremove){c.fireEvent("itemremove",a,b)}}},doRemove:function(a,b){this.all.removeElement(b,true)},refreshNode:function(a){this.onUpdate(this.store,this.store.getAt(a))},updateIndexes:function(e,d){var c=this.all.elements,a=this.store.getRange(),b;e=e||0;d=d||((d===0)?0:(c.length-1));for(b=e;b<=d;b++){c[b].viewIndex=b;c[b].viewRecordId=a[b].internalId;if(!c[b].boundView){c[b].boundView=this.id}}},getStore:function(){return this.store},bindStore:function(a,b){var c=this;c.mixins.bindable.bindStore.apply(c,arguments);if(!b){c.getSelectionModel().bindStore(c.store)}if(c.componentLayoutCounter){c.doFirstRefresh(a)}},doFirstRefresh:function(a){var b=this;b.firstRefreshDone=true;if(a&&!a.loading){if(b.deferInitialRefresh){b.applyFirstRefresh()}else{b.refresh()}}},applyFirstRefresh:function(){var a=this;if(a.isDestroyed){return}if(a.up("[isCollapsingOrExpanding]")){Ext.Function.defer(a.applyFirstRefresh,100,a)}else{Ext.Function.defer(function(){if(!a.isDestroyed){a.refresh()}},1)}},onUnbindStore:function(a){this.setMaskBind(null)},onBindStore:function(a){this.setMaskBind(a)},setMaskBind:function(b){var a=this.loadMask;if(a&&a.bindStore){a.bindStore(b)}},getStoreListeners:function(){var a=this;return{refresh:a.onDataRefresh,add:a.onAdd,remove:a.onRemove,update:a.onUpdate,clear:a.refresh}},onDataRefresh:function(){var a=this,b=!a.firstRefreshDone&&(!a.rendered||a.up("[collapsed],[isCollapsingOrExpanding],[hidden]"));if(b){a.deferInitialRefresh=false}else{if(a.blockRefresh!==true){a.firstRefreshDone=true;a.refresh.apply(a,arguments)}}},findItemByChild:function(a){return Ext.fly(a).findParent(this.getItemSelector(),this.getTargetEl())},findTargetByEvent:function(a){return a.getTarget(this.getItemSelector(),this.getTargetEl())},getSelectedNodes:function(){var b=[],a=this.selModel.getSelection(),d=a.length,c=0;for(;c<d;c++){b.push(this.getNode(a[c]))}return b},getRecords:function(c){var b=[],d=0,a=c.length,e=this.store.data;for(;d<a;d++){b[b.length]=e.getByKey(c[d].viewRecordId)}return b},getRecord:function(a){return this.store.data.getByKey(Ext.getDom(a).viewRecordId)},isSelected:function(b){var a=this.getRecord(b);return this.selModel.isSelected(a)},select:function(b,c,a){this.selModel.select(b,c,a)},deselect:function(b,a){this.selModel.deselect(b,a)},getNode:function(a){if((!a&&a!==0)||!this.rendered){return null}if(Ext.isString(a)){return document.getElementById(a)}if(Ext.isNumber(a)){return this.all.elements[a]}if(a.isModel){return this.getNodeByRecord(a)}return a},getNodeByRecord:function(a){var c=this.all.elements,d=c.length,b=0;for(;b<d;b++){if(c[b].viewRecordId===a.internalId){return c[b]}}return null},getNodes:function(c,a){var b=this.all.elements;if(a===undefined){a=b.length}else{a++}return this.all.elements.slice(c||0,a)},indexOf:function(a){a=this.getNode(a);if(!a&&a!==0){return -1}if(Ext.isNumber(a.viewIndex)){return a.viewIndex}return this.all.indexOf(a)},onDestroy:function(){var a=this;a.all.clear();a.callParent();a.bindStore(null);a.selModel.destroy()},onItemSelect:function(a){var b=this.getNode(a);if(b){Ext.fly(b).addCls(this.selectedItemCls)}},onItemDeselect:function(a){var b=this.getNode(a);if(b){Ext.fly(b).removeCls(this.selectedItemCls)}},getItemSelector:function(){return this.itemSelector}},function(){Ext.deprecate("extjs","4.0",function(){Ext.view.AbstractView.override({getSelectionCount:function(){if(Ext.global.console){Ext.global.console.warn("DataView: getSelectionCount will be removed, please interact with the Ext.selection.DataViewModel")}return this.selModel.getSelection().length},getSelectedRecords:function(){if(Ext.global.console){Ext.global.console.warn("DataView: getSelectedRecords will be removed, please interact with the Ext.selection.DataViewModel")}return this.selModel.getSelection()},select:function(a,b,d){if(Ext.global.console){Ext.global.console.warn("DataView: select will be removed, please access select through a DataView's SelectionModel, ie: view.getSelectionModel().select()")}var c=this.getSelectionModel();return c.select.apply(c,arguments)},clearSelections:function(){if(Ext.global.console){Ext.global.console.warn("DataView: clearSelections will be removed, please access deselectAll through DataView's SelectionModel, ie: view.getSelectionModel().deselectAll()")}var a=this.getSelectionModel();return a.deselectAll()}})})});Ext.define("Ext.view.View",{extend:"Ext.view.AbstractView",alternateClassName:"Ext.DataView",alias:"widget.dataview",deferHighlight:(Ext.isIE6||Ext.isIE7)?100:0,inputTagRe:/^textarea$|^input$/i,inheritableStatics:{EventMap:{mousedown:"MouseDown",mouseup:"MouseUp",click:"Click",dblclick:"DblClick",contextmenu:"ContextMenu",mouseover:"MouseOver",mouseout:"MouseOut",mouseenter:"MouseEnter",mouseleave:"MouseLeave",keydown:"KeyDown",focus:"Focus"}},initComponent:function(){var a=this;a.callParent();if(a.deferHighlight){a.setHighlightedItem=Ext.Function.createBuffered(a.setHighlightedItem,a.deferHighlight,a)}},addCmpEvents:function(){this.addEvents("beforeitemmousedown","beforeitemmouseup","beforeitemmouseenter","beforeitemmouseleave","beforeitemclick","beforeitemdblclick","beforeitemcontextmenu","beforeitemkeydown","itemmousedown","itemmouseup","itemmouseenter","itemmouseleave","itemclick","itemdblclick","itemcontextmenu","itemkeydown","beforecontainermousedown","beforecontainermouseup","beforecontainermouseover","beforecontainermouseout","beforecontainerclick","beforecontainerdblclick","beforecontainercontextmenu","beforecontainerkeydown","containermouseup","containermouseover","containermouseout","containerclick","containerdblclick","containercontextmenu","containerkeydown","selectionchange","beforeselect","beforedeselect","select","deselect","focuschange","highlightitem","unhighlightitem")},getFocusEl:function(){return this.getTargetEl()},afterRender:function(){var a=this;a.callParent();a.mon(a.getTargetEl(),{scope:a,freezeEvent:true,click:a.handleEvent,mousedown:a.handleEvent,mouseup:a.handleEvent,dblclick:a.handleEvent,contextmenu:a.handleEvent,mouseover:a.handleEvent,mouseout:a.handleEvent,keydown:a.handleEvent})},handleEvent:function(c){var b=this,a=c.type=="keydown"&&c.getKey();if(b.processUIEvent(c)!==false){b.processSpecialEvent(c)}if(a===c.SPACE){if(!b.inputTagRe.test(c.getTarget().tagName)){c.stopEvent()}}},processItemEvent:Ext.emptyFn,processContainerEvent:Ext.emptyFn,processSpecialEvent:Ext.emptyFn,stillOverItem:function(b,a){var c;if(a&&typeof(a.offsetParent)==="object"){c=(b.type=="mouseout")?b.getRelatedTarget():b.getTarget();return Ext.fly(a).contains(c)}return false},processUIEvent:function(g){var h=this,j=g.getTarget(h.getItemSelector(),h.getTargetEl()),a=this.statics().EventMap,f,c,i=g.type,d=h.mouseOverItem,b;if(!j){if(i=="mouseover"&&h.stillOverItem(g,d)){j=d}if(i=="keydown"){c=h.getSelectionModel().getLastSelected();if(c){j=h.getNode(c)}}}if(j){f=h.indexOf(j);if(!c){c=h.getRecord(j)}if(!c||h.processItemEvent(c,j,f,g)===false){return false}b=h.isNewItemEvent(j,g);if(b===false){return false}if((h["onBeforeItem"+a[b]](c,j,f,g)===false)||(h.fireEvent("beforeitem"+b,h,c,j,f,g)===false)||(h["onItem"+a[b]](c,j,f,g)===false)){return false}h.fireEvent("item"+b,h,c,j,f,g)}else{if((h.processContainerEvent(g)===false)||(h["onBeforeContainer"+a[i]](g)===false)||(h.fireEvent("beforecontainer"+i,h,g)===false)||(h["onContainer"+a[i]](g)===false)){return false}h.fireEvent("container"+i,h,g)}return true},isNewItemEvent:function(d,f){var c=this,a=c.mouseOverItem,b=f.type;switch(b){case"mouseover":if(d===a){return false}c.mouseOverItem=d;return"mouseenter";case"mouseout":if(c.stillOverItem(f,a)){return false}c.mouseOverItem=null;return"mouseleave"}return b},onItemMouseEnter:function(a,c,b,d){if(this.trackOver){this.highlightItem(c)}},onItemMouseLeave:function(a,c,b,d){if(this.trackOver){this.clearHighlight()}},onItemMouseDown:Ext.emptyFn,onItemMouseUp:Ext.emptyFn,onItemFocus:Ext.emptyFn,onItemClick:Ext.emptyFn,onItemDblClick:Ext.emptyFn,onItemContextMenu:Ext.emptyFn,onItemKeyDown:Ext.emptyFn,onBeforeItemMouseDown:Ext.emptyFn,onBeforeItemMouseUp:Ext.emptyFn,onBeforeItemFocus:Ext.emptyFn,onBeforeItemMouseEnter:Ext.emptyFn,onBeforeItemMouseLeave:Ext.emptyFn,onBeforeItemClick:Ext.emptyFn,onBeforeItemDblClick:Ext.emptyFn,onBeforeItemContextMenu:Ext.emptyFn,onBeforeItemKeyDown:Ext.emptyFn,onContainerMouseDown:Ext.emptyFn,onContainerMouseUp:Ext.emptyFn,onContainerMouseOver:Ext.emptyFn,onContainerMouseOut:Ext.emptyFn,onContainerClick:Ext.emptyFn,onContainerDblClick:Ext.emptyFn,onContainerContextMenu:Ext.emptyFn,onContainerKeyDown:Ext.emptyFn,onBeforeContainerMouseDown:Ext.emptyFn,onBeforeContainerMouseUp:Ext.emptyFn,onBeforeContainerMouseOver:Ext.emptyFn,onBeforeContainerMouseOut:Ext.emptyFn,onBeforeContainerClick:Ext.emptyFn,onBeforeContainerDblClick:Ext.emptyFn,onBeforeContainerContextMenu:Ext.emptyFn,onBeforeContainerKeyDown:Ext.emptyFn,setHighlightedItem:function(c){var b=this,a=b.highlightedItem;if(a!=c){if(a){Ext.fly(a).removeCls(b.overItemCls);b.fireEvent("unhighlightitem",b,a)}b.highlightedItem=c;if(c){Ext.fly(c).addCls(b.overItemCls);b.fireEvent("highlightitem",b,c)}}},highlightItem:function(a){this.setHighlightedItem(a)},clearHighlight:function(){this.setHighlightedItem(undefined)},onUpdate:function(b,a){var f=this,e,c,d;if(f.viewReady){e=f.getNode(a);c=f.callParent(arguments);d=f.highlightedItem;if(d&&d===e){delete f.highlightedItem;if(c){f.highlightItem(c)}}}},refresh:function(){this.clearHighlight();this.callParent(arguments)}});Ext.define("Ext.view.Table",{extend:"Ext.view.View",alias:"widget.tableview",uses:["Ext.view.TableLayout","Ext.view.TableChunker","Ext.util.DelayedTask","Ext.util.MixedCollection"],componentLayout:"tableview",baseCls:Ext.baseCSSPrefix+"grid-view",itemSelector:"tr."+Ext.baseCSSPrefix+"grid-row",cellSelector:"td."+Ext.baseCSSPrefix+"grid-cell",rowSelector:"tr."+Ext.baseCSSPrefix+"grid-row",firstCls:Ext.baseCSSPrefix+"grid-cell-first",lastCls:Ext.baseCSSPrefix+"grid-cell-last",headerRowSelector:"tr."+Ext.baseCSSPrefix+"grid-header-row",selectedItemCls:Ext.baseCSSPrefix+"grid-row-selected",selectedCellCls:Ext.baseCSSPrefix+"grid-cell-selected",focusedItemCls:Ext.baseCSSPrefix+"grid-row-focused",overItemCls:Ext.baseCSSPrefix+"grid-row-over",altRowCls:Ext.baseCSSPrefix+"grid-row-alt",rowClsRe:new RegExp("(?:^|\\s*)"+Ext.baseCSSPrefix+"grid-row-(first|last|alt)(?:\\s+|$)","g"),cellRe:new RegExp(Ext.baseCSSPrefix+"grid-cell-([^\\s]+) ",""),trackOver:true,getRowClass:null,stripeRows:true,markDirty:true,initialTpl:"<div></div>",initComponent:function(){var b=this,a=b.scroll;b.table=new Ext.dom.Element.Fly();b.table.id=b.id+"gridTable";b.autoScroll=undefined;if(a===true||a==="both"){b.autoScroll=true}else{if(a==="horizontal"){b.overflowX="auto"}else{if(a==="vertical"){b.overflowY="auto"}}}b.selModel.view=b;b.headerCt.view=b;b.headerCt.markDirty=b.markDirty;b.initFeatures(b.grid);delete b.grid;b.tpl=b.getTpl("initialTpl");b.callParent()},moveColumn:function(a,o,d){var m=this,k=(d>1)?document.createDocumentFragment():undefined,c=o,p=m.getGridColumns().length,n=p-1,b=(m.firstCls||m.lastCls)&&(o===0||o==p||a===0||a==n),f,e,q,h,l,g;if(m.rendered){g=m.el.query(m.headerRowSelector);q=m.el.query(m.rowSelector);if(o>a&&k){c-=d}for(f=0,h=g.length;f<h;++f){l=g[f];if(k){for(e=0;e<d;e++){k.appendChild(l.cells[a])}l.insertBefore(k,l.cells[c]||null)}else{l.insertBefore(l.cells[a],l.cells[c]||null)}}for(f=0,h=q.length;f<h;f++){l=q[f];if(b){if(a===0){Ext.fly(l.cells[0]).removeCls(m.firstCls);Ext.fly(l.cells[1]).addCls(m.firstCls)}else{if(a===n){Ext.fly(l.cells[n]).removeCls(m.lastCls);Ext.fly(l.cells[n-1]).addCls(m.lastCls)}}if(o===0){Ext.fly(l.cells[0]).removeCls(m.firstCls);Ext.fly(l.cells[a]).addCls(m.firstCls)}else{if(o===p){Ext.fly(l.cells[n]).removeCls(m.lastCls);Ext.fly(l.cells[a]).addCls(m.lastCls)}}}if(k){for(e=0;e<d;e++){k.appendChild(l.cells[a])}l.insertBefore(k,l.cells[c]||null)}else{l.insertBefore(l.cells[a],l.cells[c]||null)}}m.setNewTemplate()}},scrollToTop:Ext.emptyFn,addElListener:function(a,c,b){this.mon(this,a,c,b,{element:"el"})},getGridColumns:function(){return this.headerCt.getGridColumns()},getHeaderAtIndex:function(a){return this.headerCt.getHeaderAtIndex(a)},getCell:function(a,b){var c=this.getNode(a);return Ext.fly(c).down(b.getCellSelector())},getFeature:function(b){var a=this.featuresMC;if(a){return a.get(b)}},initFeatures:function(d){var f=this,c,e,b,a;f.featuresMC=new Ext.util.MixedCollection();e=f.features=f.constructFeatures();a=e?e.length:0;for(c=0;c<a;c++){b=e[c];b.view=f;b.grid=d;f.featuresMC.add(b);b.init()}},constructFeatures:function(){var f=this,e=f.features,d,b,c=0,a;if(e){b=[];a=e.length;for(;c<a;c++){d=e[c];if(!d.isFeature){d=Ext.create("feature."+d.ftype,d)}b[c]=d}}return b},attachEventsForFeatures:function(){var b=this.features,c=b.length,a=0;for(;a<c;a++){if(b[a].isFeature){b[a].attachEvents()}}},afterRender:function(){var a=this;a.callParent();if(!a.enableTextSelection){a.el.unselectable()}a.attachEventsForFeatures()},onViewScroll:function(b,a){this.callParent(arguments);this.fireEvent("bodyscroll",b,a)},prepareData:function(b,g,d){var f=this,j=f.headerCt.prepareData(b,g,d,f,f.ownerCt),a=f.features,e=a.length,c=0,h;for(;c<e;c++){h=a[c];if(h.isFeature){Ext.apply(j,h.getAdditionalData(b,g,d,j,f))}}return j},collectData:function(d,p){var m=this,r=m.callParent(arguments),c=m.headerCt,n=c.getFullWidth(),b=m.features,k=b.length,a={rows:r,fullWidth:n},g=0,s,f=0,l,h,e,q;l=r.length;if(m.getRowClass){for(;f<l;f++){h={};e=r[f];q=e.rowCls||"";e.rowCls=this.getRowClass(d[f],f,h,m.store)+" "+q}}for(;g<k;g++){s=b[g];if(s.isFeature&&s.collectData&&!s.disabled){a=s.collectData(d,r,p,n,a);break}}return a},refreshSize:function(){var b=this,a;b.table.attach(b.el.child("table",true));if(!b.hasLoadingHeight){a=b.up("tablepanel");Ext.suspendLayouts();b.callParent();if(a&&Ext.getScrollbarSize().width&&(b.autoScroll||b.overflowY)){a.updateLayout()}Ext.resumeLayouts(true)}},setNewTemplate:function(){var b=this,a=b.headerCt.getColumnsForTpl(true);b.tpl=b.getTableChunker().getTableTpl({rowCount:b.store.getCount(),columns:a,features:b.features,enableTextSelection:b.enableTextSelection})},getTableChunker:function(){return this.chunker||Ext.view.TableChunker},addRowCls:function(b,a){var c=this.getNode(b);if(c){Ext.fly(c).addCls(a)}},removeRowCls:function(b,a){var c=this.getNode(b);if(c){Ext.fly(c).removeCls(a)}},onRowSelect:function(a){this.addRowCls(a,this.selectedItemCls)},onRowDeselect:function(b){var a=this;a.removeRowCls(b,a.selectedItemCls);a.removeRowCls(b,a.focusedItemCls)},onCellSelect:function(b){var a=this.getCellByPosition(b,true);if(a){Ext.fly(a).addCls(this.selectedCellCls)}},onCellDeselect:function(b){var a=this.getCellByPosition(b,true);if(a){Ext.fly(a).removeCls(this.selectedCellCls)}},onCellFocus:function(a){this.focusCell(a)},getCellByPosition:function(a,b){if(a){var c=this.getNode(a.row),d=this.headerCt.getHeaderAtIndex(a.column);if(d&&c){return Ext.fly(c).down(d.getCellSelector(),b)}}return false},onRowFocus:function(d,b,a){var c=this;if(b){c.addRowCls(d,c.focusedItemCls);if(!a){c.focusRow(d)}}else{c.removeRowCls(d,c.focusedItemCls)}},focusRow:function(b){var f=this,j=f.getNode(b),c=f.el,h=0,a=f.ownerCt,i,g,e,d;if(j&&c){g=c.getY();e=g+c.dom.clientHeight;i=Ext.fly(j).getRegion();if(i.top<g){h=i.top-g}else{if(i.bottom>e){h=i.bottom-e}}d=f.getRecord(j);b=f.store.indexOf(d);if(h){a.scrollByDeltaY(h)}f.fireEvent("rowfocus",d,j,b)}},focusCell:function(g){var i=this,j=i.getCellByPosition(g),b=i.el,d=0,e=0,c=b.getRegion(),a=i.ownerCt,h,f;c.bottom=c.top+b.dom.clientHeight;c.right=c.left+b.dom.clientWidth;if(j){h=j.getRegion();if(h.top<c.top){d=h.top-c.top}else{if(h.bottom>c.bottom){d=h.bottom-c.bottom}}if(h.left<c.left){e=h.left-c.left}else{if(h.right>c.right){e=h.right-c.right}}if(d){a.scrollByDeltaY(d)}if(e){a.scrollByDeltaX(e)}b.focus();i.fireEvent("cellfocus",f,j,g)}},scrollByDelta:function(c,b){b=b||"scrollTop";var a=this.el.dom;a[b]=(a[b]+=c)},onUpdate:function(f,e,j,o){var u=this,h,d,k,r,q,t,p,b,c,v,s,q,a,m,l,g,n=u.editingPlugin&&u.editingPlugin.editing;if(u.viewReady){h=u.store.indexOf(e);a=u.headerCt.getGridColumns();m=u.overItemCls;if(a.length&&h>-1){d=u.bufferRender([e],h)[0];p=u.all.item(h);if(p){b=p.dom;l=p.hasCls(m);if(b.mergeAttributes){b.mergeAttributes(d,true)}else{k=d.attributes;r=k.length;for(q=0;q<r;q++){t=k[q].name;if(t!=="id"){b.setAttribute(t,k[q].value)}}}if(l){p.addCls(m)}c=p.query(u.cellSelector);v=Ext.fly(d).query(u.cellSelector);s=v.length;g=c[0].parentNode;for(q=0;q<s;q++){if(u.shouldUpdateCell(a[q],o)){if(n){Ext.fly(c[q]).syncContent(v[q])}else{g.insertBefore(v[q],c[q]);g.removeChild(c[q])}}}}u.fireEvent("itemupdate",e,h,d)}}},shouldUpdateCell:function(b,a){if(b.hasCustomRenderer){return true}return !a||Ext.Array.contains(a,b.dataIndex)},refresh:function(){var a=this;a.setNewTemplate();a.callParent(arguments);a.doStripeRows(0);a.headerCt.setSortState()},clearViewEl:function(){this.callParent();delete this.table.dom},processItemEvent:function(b,l,i,d){var g=this,j=d.getTarget(g.cellSelector,l),h=j?j.cellIndex:-1,a=g.statics().EventMap,c=g.getSelectionModel(),f=d.type,k;if(f=="keydown"&&!j&&c.getCurrentPosition){j=g.getCellByPosition(c.getCurrentPosition());if(j){j=j.dom;h=j.cellIndex}}k=g.fireEvent("uievent",f,g,j,i,h,d,b,l);if(k===false||g.callParent(arguments)===false){return false}if(f=="mouseover"||f=="mouseout"){return true}if(!j){return true}return !((g["onBeforeCell"+a[f]](j,h,b,l,i,d)===false)||(g.fireEvent("beforecell"+f,g,j,h,b,l,i,d)===false)||(g["onCell"+a[f]](j,h,b,l,i,d)===false)||(g.fireEvent("cell"+f,g,j,h,b,l,i,d)===false))},processSpecialEvent:function(j){var m=this,b=m.statics().EventMap,d=m.features,l=d.length,n=j.type,f,o,g,h,c,k,a=m.ownerCt;m.callParent(arguments);if(n=="mouseover"||n=="mouseout"){return}for(f=0;f<l;f++){o=d[f];if(o.hasFeatureEvent){h=j.getTarget(o.eventSelector,m.getTargetEl());if(h){g=o.eventPrefix;c=o.getFireEventArgs("before"+g+n,m,h,j);k=o.getFireEventArgs(g+n,m,h,j);if((m.fireEvent.apply(m,c)===false)||(a.fireEvent.apply(a,c)===false)||(m.fireEvent.apply(m,k)===false)||(a.fireEvent.apply(a,k)===false)){return false}}}}return true},onCellMouseDown:Ext.emptyFn,onCellMouseUp:Ext.emptyFn,onCellClick:Ext.emptyFn,onCellDblClick:Ext.emptyFn,onCellContextMenu:Ext.emptyFn,onCellKeyDown:Ext.emptyFn,onBeforeCellMouseDown:Ext.emptyFn,onBeforeCellMouseUp:Ext.emptyFn,onBeforeCellClick:Ext.emptyFn,onBeforeCellDblClick:Ext.emptyFn,onBeforeCellContextMenu:Ext.emptyFn,onBeforeCellKeyDown:Ext.emptyFn,expandToFit:function(b){if(b){var a=this.getMaxContentWidth(b);delete b.flex;b.setWidth(a)}},getMaxContentWidth:function(g){var a=g.getCellInnerSelector(),c=this.el.query(a),d=0,f=c.length,e=g.el.dom.scrollWidth,b;for(;d<f;d++){b=c[d].scrollWidth;if(b>e){e=b}}return e},getPositionByEvent:function(f){var d=this,b=f.getTarget(d.cellSelector),c=f.getTarget(d.itemSelector),a=d.getRecord(c),g=d.getHeaderByCell(b);return d.getPosition(a,g)},getHeaderByCell:function(b){if(b){var a=b.className.match(this.cellRe);if(a&&a[1]){return Ext.getCmp(a[1])}}return false},walkCells:function(k,l,g,m,a,n){if(!k){return}var i=this,o=k.row,d=k.column,j=i.store.getCount(),f=i.getFirstVisibleColumnIndex(),b=i.getLastVisibleColumnIndex(),h={row:o,column:d},c=i.headerCt.getHeaderAtIndex(d);if(!c||c.hidden){return false}g=g||{};l=l.toLowerCase();switch(l){case"right":if(d===b){if(m||o===j-1){return false}if(!g.ctrlKey){h.row=o+1;h.column=f}}else{if(!g.ctrlKey){h.column=d+i.getRightGap(c)}else{h.column=b}}break;case"left":if(d===f){if(m||o===0){return false}if(!g.ctrlKey){h.row=o-1;h.column=b}}else{if(!g.ctrlKey){h.column=d+i.getLeftGap(c)}else{h.column=f}}break;case"up":if(o===0){return false}else{if(!g.ctrlKey){h.row=o-1}else{h.row=0}}break;case"down":if(o===j-1){return false}else{if(!g.ctrlKey){h.row=o+1}else{h.row=j-1}}break}if(a&&a.call(n||window,h)!==true){return false}else{return h}},getFirstVisibleColumnIndex:function(){var a=this.getHeaderCt().getVisibleGridColumns()[0];return a?a.getIndex():-1},getLastVisibleColumnIndex:function(){var b=this.getHeaderCt().getVisibleGridColumns(),a=b[b.length-1];return a.getIndex()},getHeaderCt:function(){return this.headerCt},getPosition:function(a,e){var d=this,b=d.store,c=d.headerCt.getGridColumns();return{row:b.indexOf(a),column:Ext.Array.indexOf(c,e)}},getRightGap:function(a){var f=this.getHeaderCt(),e=f.getGridColumns(),b=Ext.Array.indexOf(e,a),c=b+1,d;for(;c<=e.length;c++){if(!e[c].hidden){d=c;break}}return d-b},beforeDestroy:function(){if(this.rendered){this.el.removeAllListeners()}this.callParent(arguments)},getLeftGap:function(a){var f=this.getHeaderCt(),e=f.getGridColumns(),c=Ext.Array.indexOf(e,a),d=c-1,b;for(;d>=0;d--){if(!e[d].hidden){b=d;break}}return b-c},onAdd:function(c,a,b){this.callParent(arguments);this.doStripeRows(b)},onRemove:function(c,a,b){this.callParent(arguments);this.doStripeRows(b)},doStripeRows:function(b,a){var d=this,e,g,c,f;if(d.rendered&&d.stripeRows){e=d.getNodes(b,a);for(c=0,g=e.length;c<g;c++){f=e[c];f.className=f.className.replace(d.rowClsRe," ");b++;if(b%2===0){f.className+=(" "+d.altRowCls)}}}}});Ext.define("Ext.grid.View",{extend:"Ext.view.Table",alias:"widget.gridview",stripeRows:true,autoScroll:true});Ext.define("Ext.tree.View",{extend:"Ext.view.Table",alias:"widget.treeview",requires:["Ext.data.NodeStore"],loadingCls:Ext.baseCSSPrefix+"grid-tree-loading",expandedCls:Ext.baseCSSPrefix+"grid-tree-node-expanded",leafCls:Ext.baseCSSPrefix+"grid-tree-node-leaf",expanderSelector:"."+Ext.baseCSSPrefix+"tree-expander",checkboxSelector:"."+Ext.baseCSSPrefix+"tree-checkbox",expanderIconOverCls:Ext.baseCSSPrefix+"tree-expander-over",nodeAnimWrapCls:Ext.baseCSSPrefix+"tree-animator-wrap",blockRefresh:true,loadMask:false,rootVisible:true,deferInitialRefresh:false,expandDuration:250,collapseDuration:250,toggleOnDblClick:true,stripeRows:false,uiFields:["expanded","loaded","checked","expandable","leaf","icon","iconCls","loading","qtip","qtitle"],initComponent:function(){var a=this,b=a.panel.getStore();if(a.initialConfig.animate===undefined){a.animate=Ext.enableFx}a.store=new Ext.data.NodeStore({treeStore:b,recursive:true,rootVisible:a.rootVisible,listeners:{beforeexpand:a.onBeforeExpand,expand:a.onExpand,beforecollapse:a.onBeforeCollapse,collapse:a.onCollapse,write:a.onStoreWrite,datachanged:a.onStoreDataChanged,scope:a}});if(a.node){a.setRootNode(a.node)}a.animQueue={};a.animWraps={};a.addEvents("afteritemexpand","afteritemcollapse");a.callParent(arguments);a.on({element:"el",scope:a,delegate:a.expanderSelector,mouseover:a.onExpanderMouseOver,mouseout:a.onExpanderMouseOut});a.on({element:"el",scope:a,delegate:a.checkboxSelector,click:a.onCheckboxChange})},getMaskStore:function(){return this.panel.getStore()},afterComponentLayout:function(){this.callParent(arguments);var a=this.stretcher;if(a){a.setWidth((this.getWidth()-Ext.getScrollbarSize().width))}},processUIEvent:function(a){if(a.getTarget("."+this.nodeAnimWrapCls,this.el)){return false}return this.callParent(arguments)},onClear:function(){this.store.removeAll()},setRootNode:function(b){var a=this;a.store.setNode(b);a.node=b},onCheckboxChange:function(d,a){var c=this,b=d.getTarget(c.getItemSelector(),c.getTargetEl());if(b){c.onCheckChange(c.getRecord(b))}},onCheckChange:function(a){var b=a.get("checked");if(Ext.isBoolean(b)){b=!b;a.set("checked",b);this.fireEvent("checkchange",a,b)}},getChecked:function(){var a=[];this.node.cascadeBy(function(b){if(b.get("checked")){a.push(b)}});return a},isItemChecked:function(a){return a.get("checked")},createAnimWrap:function(h,j){var f="",e=this.panel.headerCt,b=e.getGridColumns(),g=0,k=b.length,l,d=this.getNode(h),a,c;for(;g<k;g++){l=b[g];f+='<th style="width: '+(l.hidden?0:l.getDesiredWidth())+'px; height: 0px;"></th>'}c=Ext.get(d);a=c.insertSibling({tag:"tr",html:['<td colspan="'+e.getColumnCount()+'">','<div class="'+this.nodeAnimWrapCls+'">','<table class="'+Ext.baseCSSPrefix+'grid-table" style="width: '+e.getFullWidth()+'px;"><tbody>',f,"</tbody></table>","</div>","</td>"].join("")},"after");return{record:h,node:d,el:a,expanding:false,collapsing:false,animating:false,animateEl:a.down("div"),targetEl:a.down("tbody")}},getAnimWrap:function(d,a){if(!this.animate){return null}var b=this.animWraps,c=b[d.internalId];if(a!==false){while(!c&&d){d=d.parentNode;if(d){c=b[d.internalId]}}}return c},doAdd:function(b,d,h){var i=this,f=d[0],k=f.parentNode,j=i.all.elements,m=0,e=i.getAnimWrap(k),l,c,g;if(!e||!e.expanding){return i.callParent(arguments)}k=e.record;l=e.targetEl;c=l.dom.childNodes;g=c.length-1;m=h-i.indexOf(k)-1;if(!g||m>=g){l.appendChild(b)}else{Ext.fly(c[m+1]).insertSibling(b,"before",true)}Ext.Array.insert(j,h,b);if(e.isAnimating){i.onExpand(k)}},beginBulkUpdate:function(){this.bulkUpdate=true},endBulkUpdate:function(){this.bulkUpdate=false},onRemove:function(e,a,b){var d=this,c=d.bulkUpdate;if(d.viewReady){d.doRemove(a,b);if(!c){d.updateIndexes(b)}if(d.store.getCount()===0){d.refresh()}if(!c){d.fireEvent("itemremove",a,b)}}},doRemove:function(a,c){var g=this,d=g.all,b=g.getAnimWrap(a),f=d.item(c),e=f?f.dom:null;if(!e||!b||!b.collapsing){return g.callParent(arguments)}b.targetEl.appendChild(e);d.removeElement(c)},onBeforeExpand:function(d,b,c){var e=this,a;if(!e.rendered||!e.animate){return}if(e.getNode(d)){a=e.getAnimWrap(d,false);if(!a){a=e.animWraps[d.internalId]=e.createAnimWrap(d);a.animateEl.setHeight(0)}else{if(a.collapsing){a.targetEl.select(e.itemSelector).remove()}}a.expanding=true;a.collapsing=false}},onExpand:function(h){var g=this,e=g.animQueue,a=h.getId(),c=g.getNode(h),f=c?g.indexOf(c):-1,d,b,i;if(g.singleExpand){g.ensureSingleExpand(h)}if(f===-1){return}d=g.getAnimWrap(h,false);if(!d){g.isExpandingOrCollapsing=false;g.fireEvent("afteritemexpand",h,f,c);return}b=d.animateEl;i=d.targetEl;b.stopAnimation();e[a]=true;b.slideIn("t",{duration:g.expandDuration,listeners:{scope:g,lastframe:function(){d.el.insertSibling(i.query(g.itemSelector),"before");d.el.remove();g.refreshSize();delete g.animWraps[d.record.internalId];delete e[a]}},callback:function(){g.isExpandingOrCollapsing=false;g.fireEvent("afteritemexpand",h,f,c)}});d.isAnimating=true},onBeforeCollapse:function(d,b,c){var e=this,a;if(!e.rendered||!e.animate){return}if(e.getNode(d)){a=e.getAnimWrap(d);if(!a){a=e.animWraps[d.internalId]=e.createAnimWrap(d,c)}else{if(a.expanding){a.targetEl.select(this.itemSelector).remove()}}a.expanding=false;a.collapsing=true}},onCollapse:function(h){var g=this,e=g.animQueue,a=h.getId(),c=g.getNode(h),f=c?g.indexOf(c):-1,d=g.getAnimWrap(h),b,i;if(f===-1){return}if(!d){g.isExpandingOrCollapsing=false;g.fireEvent("afteritemcollapse",h,f,c);return}b=d.animateEl;i=d.targetEl;e[a]=true;b.stopAnimation();b.slideOut("t",{duration:g.collapseDuration,listeners:{scope:g,lastframe:function(){d.el.remove();g.refreshSize();delete g.animWraps[d.record.internalId];delete e[a]}},callback:function(){g.isExpandingOrCollapsing=false;g.fireEvent("afteritemcollapse",h,f,c)}});d.isAnimating=true},isAnimating:function(a){return !!this.animQueue[a.getId()]},collectData:function(c){var f=this.callParent(arguments),e=f.rows,a=e.length,d=0,g,b;for(;d<a;d++){g=e[d];b=c[d];if(b.get("qtip")){g.rowAttr='data-qtip="'+b.get("qtip")+'"';if(b.get("qtitle")){g.rowAttr+=' data-qtitle="'+b.get("qtitle")+'"'}}if(b.isExpanded()){g.rowCls=(g.rowCls||"")+" "+this.expandedCls}if(b.isLeaf()){g.rowCls=(g.rowCls||"")+" "+this.leafCls}if(b.isLoading()){g.rowCls=(g.rowCls||"")+" "+this.loadingCls}}return f},expand:function(b,a,d,c){return b.expand(a,d,c)},collapse:function(b,a,d,c){return b.collapse(a,d,c)},toggle:function(c,b,f,d){var e=this,a=!!this.animate;if(!a||!this.isExpandingOrCollapsing){if(!c.isLeaf()){this.isExpandingOrCollapsing=a}if(c.isExpanded()){e.collapse(c,b,f,d)}else{e.expand(c,b,f,d)}}},onItemDblClick:function(a,e,c){var d=this,b=d.editingPlugin;d.callParent(arguments);if(d.toggleOnDblClick&&a.isExpandable()&&!(b&&b.clicksToEdit===2)){d.toggle(a)}},onBeforeItemMouseDown:function(a,c,b,d){if(d.getTarget(this.expanderSelector,c)){return false}return this.callParent(arguments)},onItemClick:function(a,c,b,d){if(d.getTarget(this.expanderSelector,c)&&a.isExpandable()){this.toggle(a,d.ctrlKey);return false}return this.callParent(arguments)},onExpanderMouseOver:function(b,a){b.getTarget(this.cellSelector,10,true).addCls(this.expanderIconOverCls)},onExpanderMouseOut:function(b,a){b.getTarget(this.cellSelector,10,true).removeCls(this.expanderIconOverCls)},getTreeStore:function(){return this.panel.store},ensureSingleExpand:function(b){var a=b.parentNode;if(a){a.eachChild(function(c){if(c!==b&&c.isExpanded()){c.collapse()}})}},shouldUpdateCell:function(d,c){if(c){var b=0,a=c.length;for(;b<a;++b){if(Ext.Array.contains(this.uiFields,c[b])){return true}}}return this.callParent(arguments)},onStoreWrite:function(b,a){var c=this.panel.store;c.fireEvent("write",c,a)},onStoreDataChanged:function(b,a){var c=this.panel.store;c.fireEvent("datachanged",c)}});Ext.define("Ext.dd.DragDrop",{requires:["Ext.dd.DragDropManager"],constructor:function(c,a,b){if(c){this.init(c,a,b)}},id:null,config:null,dragElId:null,handleElId:null,invalidHandleTypes:null,invalidHandleIds:null,invalidHandleClasses:null,startPageX:0,startPageY:0,groups:null,locked:false,lock:function(){this.locked=true},moveOnly:false,unlock:function(){this.locked=false},isTarget:true,padding:null,_domRef:null,__ygDragDrop:true,constrainX:false,constrainY:false,minX:0,maxX:0,minY:0,maxY:0,maintainOffset:false,xTicks:null,yTicks:null,primaryButtonOnly:true,available:false,hasOuterHandles:false,b4StartDrag:function(a,b){},startDrag:function(a,b){},b4Drag:function(a){},onDrag:function(a){},onDragEnter:function(a,b){},b4DragOver:function(a){},onDragOver:function(a,b){},b4DragOut:function(a){},onDragOut:function(a,b){},b4DragDrop:function(a){},onDragDrop:function(a,b){},onInvalidDrop:function(a){},b4EndDrag:function(a){},endDrag:function(a){},b4MouseDown:function(a){},onMouseDown:function(a){},onMouseUp:function(a){},onAvailable:function(){},defaultPadding:{left:0,right:0,top:0,bottom:0},constrainTo:function(h,f,m){if(Ext.isNumber(f)){f={left:f,right:f,top:f,bottom:f}}f=f||this.defaultPadding;var j=Ext.get(this.getEl()).getBox(),a=Ext.get(h),l=a.getScroll(),i,d=a.dom,k,g,e;if(d==document.body){i={x:l.left,y:l.top,width:Ext.Element.getViewWidth(),height:Ext.Element.getViewHeight()}}else{k=a.getXY();i={x:k[0],y:k[1],width:d.clientWidth,height:d.clientHeight}}g=j.y-i.y;e=j.x-i.x;this.resetConstraints();this.setXConstraint(e-(f.left||0),i.width-e-j.width-(f.right||0),this.xTickSize);this.setYConstraint(g-(f.top||0),i.height-g-j.height-(f.bottom||0),this.yTickSize)},getEl:function(){if(!this._domRef){this._domRef=Ext.getDom(this.id)}return this._domRef},getDragEl:function(){return Ext.getDom(this.dragElId)},init:function(c,a,b){this.initTarget(c,a,b);Ext.EventManager.on(this.id,"mousedown",this.handleMouseDown,this)},initTarget:function(c,a,b){this.config=b||{};this.DDMInstance=Ext.dd.DragDropManager;this.groups={};if(typeof c!=="string"){c=Ext.id(c)}this.id=c;this.addToGroup((a)?a:"default");this.handleElId=c;this.setDragElId(c);this.invalidHandleTypes={A:"A"};this.invalidHandleIds={};this.invalidHandleClasses=[];this.applyConfig();this.handleOnAvailable()},applyConfig:function(){this.padding=this.config.padding||[0,0,0,0];this.isTarget=(this.config.isTarget!==false);this.maintainOffset=(this.config.maintainOffset);this.primaryButtonOnly=(this.config.primaryButtonOnly!==false)},handleOnAvailable:function(){this.available=true;this.resetConstraints();this.onAvailable()},setPadding:function(c,a,d,b){if(!a&&0!==a){this.padding=[c,c,c,c]}else{if(!d&&0!==d){this.padding=[c,a,c,a]}else{this.padding=[c,a,d,b]}}},setInitPosition:function(d,c){var e=this.getEl(),b,a,f;if(!this.DDMInstance.verifyEl(e)){return}b=d||0;a=c||0;f=Ext.Element.getXY(e);this.initPageX=f[0]-b;this.initPageY=f[1]-a;this.lastPageX=f[0];this.lastPageY=f[1];this.setStartPosition(f)},setStartPosition:function(b){var a=b||Ext.Element.getXY(this.getEl());this.deltaSetXY=null;this.startPageX=a[0];this.startPageY=a[1]},addToGroup:function(a){this.groups[a]=true;this.DDMInstance.regDragDrop(this,a)},removeFromGroup:function(a){if(this.groups[a]){delete this.groups[a]}this.DDMInstance.removeDDFromGroup(this,a)},setDragElId:function(a){this.dragElId=a},setHandleElId:function(a){if(typeof a!=="string"){a=Ext.id(a)}this.handleElId=a;this.DDMInstance.regHandle(this.id,a)},setOuterHandleElId:function(a){if(typeof a!=="string"){a=Ext.id(a)}Ext.EventManager.on(a,"mousedown",this.handleMouseDown,this);this.setHandleElId(a);this.hasOuterHandles=true},unreg:function(){Ext.EventManager.un(this.id,"mousedown",this.handleMouseDown,this);this._domRef=null;this.DDMInstance._remove(this)},destroy:function(){this.unreg()},isLocked:function(){return(this.DDMInstance.isLocked()||this.locked)},handleMouseDown:function(b,a){if(this.primaryButtonOnly&&b.button!=0){return}if(this.isLocked()){return}this.DDMInstance.refreshCache(this.groups);if(this.hasOuterHandles||this.DDMInstance.isOverTarget(b.getPoint(),this)){if(this.clickValidator(b)){this.setStartPosition();this.b4MouseDown(b);this.onMouseDown(b);this.DDMInstance.handleMouseDown(b,this);this.DDMInstance.stopEvent(b)}}},clickValidator:function(b){var a=b.getTarget();return(this.isValidHandleChild(a)&&(this.id==this.handleElId||this.DDMInstance.handleWasClicked(a,this.id)))},addInvalidHandleType:function(a){var b=a.toUpperCase();this.invalidHandleTypes[b]=b},addInvalidHandleId:function(a){if(typeof a!=="string"){a=Ext.id(a)}this.invalidHandleIds[a]=a},addInvalidHandleClass:function(a){this.invalidHandleClasses.push(a)},removeInvalidHandleType:function(a){var b=a.toUpperCase();delete this.invalidHandleTypes[b]},removeInvalidHandleId:function(a){if(typeof a!=="string"){a=Ext.id(a)}delete this.invalidHandleIds[a]},removeInvalidHandleClass:function(b){for(var c=0,a=this.invalidHandleClasses.length;c<a;++c){if(this.invalidHandleClasses[c]==b){delete this.invalidHandleClasses[c]}}},isValidHandleChild:function(d){var c=true,g,b,a;try{g=d.nodeName.toUpperCase()}catch(f){g=d.nodeName}c=c&&!this.invalidHandleTypes[g];c=c&&!this.invalidHandleIds[d.id];for(b=0,a=this.invalidHandleClasses.length;c&&b<a;++b){c=!Ext.fly(d).hasCls(this.invalidHandleClasses[b])}return c},setXTicks:function(d,a){this.xTicks=[];this.xTickSize=a;var c={},b;for(b=this.initPageX;b>=this.minX;b=b-a){if(!c[b]){this.xTicks[this.xTicks.length]=b;c[b]=true}}for(b=this.initPageX;b<=this.maxX;b=b+a){if(!c[b]){this.xTicks[this.xTicks.length]=b;c[b]=true}}Ext.Array.sort(this.xTicks,this.DDMInstance.numericSort)},setYTicks:function(d,a){this.yTicks=[];this.yTickSize=a;var c={},b;for(b=this.initPageY;b>=this.minY;b=b-a){if(!c[b]){this.yTicks[this.yTicks.length]=b;c[b]=true}}for(b=this.initPageY;b<=this.maxY;b=b+a){if(!c[b]){this.yTicks[this.yTicks.length]=b;c[b]=true}}Ext.Array.sort(this.yTicks,this.DDMInstance.numericSort)},setXConstraint:function(c,b,a){this.leftConstraint=c;this.rightConstraint=b;this.minX=this.initPageX-c;this.maxX=this.initPageX+b;if(a){this.setXTicks(this.initPageX,a)}this.constrainX=true},clearConstraints:function(){this.constrainX=false;this.constrainY=false;this.clearTicks()},clearTicks:function(){this.xTicks=null;this.yTicks=null;this.xTickSize=0;this.yTickSize=0},setYConstraint:function(a,c,b){this.topConstraint=a;this.bottomConstraint=c;this.minY=this.initPageY-a;this.maxY=this.initPageY+c;if(b){this.setYTicks(this.initPageY,b)}this.constrainY=true},resetConstraints:function(){if(this.initPageX||this.initPageX===0){var b=(this.maintainOffset)?this.lastPageX-this.initPageX:0,a=(this.maintainOffset)?this.lastPageY-this.initPageY:0;this.setInitPosition(b,a)}else{this.setInitPosition()}if(this.constrainX){this.setXConstraint(this.leftConstraint,this.rightConstraint,this.xTickSize)}if(this.constrainY){this.setYConstraint(this.topConstraint,this.bottomConstraint,this.yTickSize)}},getTick:function(g,d){if(!d){return g}else{if(d[0]>=g){return d[0]}else{var b,a,c,f,e;for(b=0,a=d.length;b<a;++b){c=b+1;if(d[c]&&d[c]>=g){f=g-d[b];e=d[c]-g;return(e>f)?d[b]:d[c]}}return d[d.length-1]}}},toString:function(){return("DragDrop "+this.id)}});Ext.define("Ext.dd.DD",{extend:"Ext.dd.DragDrop",requires:["Ext.dd.DragDropManager"],constructor:function(c,a,b){if(c){this.init(c,a,b)}},scroll:true,autoOffset:function(c,b){var a=c-this.startPageX,d=b-this.startPageY;this.setDelta(a,d)},setDelta:function(b,a){this.deltaX=b;this.deltaY=a},setDragElPos:function(c,b){var a=this.getDragEl();this.alignElWithMouse(a,c,b)},alignElWithMouse:function(b,e,c){var f=this.getTargetCoord(e,c),d=b.dom?b:Ext.fly(b,"_dd"),k=d.getSize(),h=Ext.Element,i,a,j,g;if(!this.deltaSetXY){i=this.cachedViewportSize={width:h.getDocumentWidth(),height:h.getDocumentHeight()};a=[Math.max(0,Math.min(f.x,i.width-k.width)),Math.max(0,Math.min(f.y,i.height-k.height))];d.setXY(a);j=d.getLocalX();g=d.getLocalY();this.deltaSetXY=[j-f.x,g-f.y]}else{i=this.cachedViewportSize;d.setLeftTop(Math.max(0,Math.min(f.x+this.deltaSetXY[0],i.width-k.width)),Math.max(0,Math.min(f.y+this.deltaSetXY[1],i.height-k.height)))}this.cachePosition(f.x,f.y);this.autoScroll(f.x,f.y,b.offsetHeight,b.offsetWidth);return f},cachePosition:function(b,a){if(b){this.lastPageX=b;this.lastPageY=a}else{var c=Ext.Element.getXY(this.getEl());this.lastPageX=c[0];this.lastPageY=c[1]}},autoScroll:function(k,j,e,l){if(this.scroll){var m=Ext.Element.getViewHeight(),b=Ext.Element.getViewWidth(),o=this.DDMInstance.getScrollTop(),d=this.DDMInstance.getScrollLeft(),i=e+j,n=l+k,g=(m+o-j-this.deltaY),f=(b+d-k-this.deltaX),c=40,a=(document.all)?80:30;if(i>m&&g<c){window.scrollTo(d,o+a)}if(j<o&&o>0&&j-o<c){window.scrollTo(d,o-a)}if(n>b&&f<c){window.scrollTo(d+a,o)}if(k<d&&d>0&&k-d<c){window.scrollTo(d-a,o)}}},getTargetCoord:function(c,b){var a=c-this.deltaX,d=b-this.deltaY;if(this.constrainX){if(a<this.minX){a=this.minX}if(a>this.maxX){a=this.maxX}}if(this.constrainY){if(d<this.minY){d=this.minY}if(d>this.maxY){d=this.maxY}}a=this.getTick(a,this.xTicks);d=this.getTick(d,this.yTicks);return{x:a,y:d}},applyConfig:function(){this.callParent();this.scroll=(this.config.scroll!==false)},b4MouseDown:function(a){this.autoOffset(a.getPageX(),a.getPageY())},b4Drag:function(a){this.setDragElPos(a.getPageX(),a.getPageY())},toString:function(){return("DD "+this.id)}});Ext.define("Ext.dd.DDProxy",{extend:"Ext.dd.DD",statics:{dragElId:"ygddfdiv"},constructor:function(c,a,b){if(c){this.init(c,a,b);this.initFrame()}},resizeFrame:true,centerFrame:false,createFrame:function(){var b=this,a=document.body,d,c;if(!a||!a.firstChild){setTimeout(function(){b.createFrame()},50);return}d=this.getDragEl();if(!d){d=document.createElement("div");d.id=this.dragElId;c=d.style;c.position="absolute";c.visibility="hidden";c.cursor="move";c.border="2px solid #aaa";c.zIndex=999;a.insertBefore(d,a.firstChild)}},initFrame:function(){this.createFrame()},applyConfig:function(){this.callParent();this.resizeFrame=(this.config.resizeFrame!==false);this.centerFrame=(this.config.centerFrame);this.setDragElId(this.config.dragElId||Ext.dd.DDProxy.dragElId)},showFrame:function(e,d){var c=this.getEl(),a=this.getDragEl(),b=a.style;this._resizeProxy();if(this.centerFrame){this.setDelta(Math.round(parseInt(b.width,10)/2),Math.round(parseInt(b.height,10)/2))}this.setDragElPos(e,d);Ext.fly(a).show()},_resizeProxy:function(){if(this.resizeFrame){var a=this.getEl();Ext.fly(this.getDragEl()).setSize(a.offsetWidth,a.offsetHeight)}},b4MouseDown:function(b){var a=b.getPageX(),c=b.getPageY();this.autoOffset(a,c);this.setDragElPos(a,c)},b4StartDrag:function(a,b){this.showFrame(a,b)},b4EndDrag:function(a){Ext.fly(this.getDragEl()).hide()},endDrag:function(c){var b=this.getEl(),a=this.getDragEl();a.style.visibility="";this.beforeMove();b.style.visibility="hidden";Ext.dd.DDM.moveToEl(b,a);a.style.visibility="hidden";b.style.visibility="";this.afterDrag()},beforeMove:function(){},afterDrag:function(){},toString:function(){return("DDProxy "+this.id)}});Ext.define("Ext.dd.DragSource",{extend:"Ext.dd.DDProxy",requires:["Ext.dd.StatusProxy","Ext.dd.DragDropManager"],dropAllowed:Ext.baseCSSPrefix+"dd-drop-ok",dropNotAllowed:Ext.baseCSSPrefix+"dd-drop-nodrop",animRepair:true,repairHighlightColor:"c3daf9",constructor:function(b,a){this.el=Ext.get(b);if(!this.dragData){this.dragData={}}Ext.apply(this,a);if(!this.proxy){this.proxy=new Ext.dd.StatusProxy({id:this.el.id+"-drag-status-proxy",animRepair:this.animRepair})}this.callParent([this.el.dom,this.ddGroup||this.group,{dragElId:this.proxy.id,resizeFrame:false,isTarget:false,scroll:this.scroll===true}]);this.dragging=false},getDragData:function(a){return this.dragData},onDragEnter:function(c,d){var b=Ext.dd.DragDropManager.getDDById(d),a;this.cachedTarget=b;if(this.beforeDragEnter(b,c,d)!==false){if(b.isNotifyTarget){a=b.notifyEnter(this,c,this.dragData);this.proxy.setStatus(a)}else{this.proxy.setStatus(this.dropAllowed)}if(this.afterDragEnter){this.afterDragEnter(b,c,d)}}},beforeDragEnter:function(b,a,c){return true},onDragOver:function(c,d){var b=this.cachedTarget||Ext.dd.DragDropManager.getDDById(d),a;if(this.beforeDragOver(b,c,d)!==false){if(b.isNotifyTarget){a=b.notifyOver(this,c,this.dragData);this.proxy.setStatus(a)}if(this.afterDragOver){this.afterDragOver(b,c,d)}}},beforeDragOver:function(b,a,c){return true},onDragOut:function(b,c){var a=this.cachedTarget||Ext.dd.DragDropManager.getDDById(c);if(this.beforeDragOut(a,b,c)!==false){if(a.isNotifyTarget){a.notifyOut(this,b,this.dragData)}this.proxy.reset();if(this.afterDragOut){this.afterDragOut(a,b,c)}}this.cachedTarget=null},beforeDragOut:function(b,a,c){return true},onDragDrop:function(b,c){var a=this.cachedTarget||Ext.dd.DragDropManager.getDDById(c);if(this.beforeDragDrop(a,b,c)!==false){if(a.isNotifyTarget){if(a.notifyDrop(this,b,this.dragData)!==false){this.onValidDrop(a,b,c)}else{this.onInvalidDrop(a,b,c)}}else{this.onValidDrop(a,b,c)}if(this.afterDragDrop){this.afterDragDrop(a,b,c)}}delete this.cachedTarget},beforeDragDrop:function(b,a,c){return true},onValidDrop:function(b,a,c){this.hideProxy();if(this.afterValidDrop){this.afterValidDrop(b,a,c)}},getRepairXY:function(b,a){return this.el.getXY()},onInvalidDrop:function(b,a,c){if(!a){a=b;b=null;c=a.getTarget().id}this.beforeInvalidDrop(b,a,c);if(this.cachedTarget){if(this.cachedTarget.isNotifyTarget){this.cachedTarget.notifyOut(this,a,this.dragData)}this.cacheTarget=null}this.proxy.repair(this.getRepairXY(a,this.dragData),this.afterRepair,this);if(this.afterInvalidDrop){this.afterInvalidDrop(a,c)}},afterRepair:function(){var a=this;if(Ext.enableFx){a.el.highlight(a.repairHighlightColor)}a.dragging=false},beforeInvalidDrop:function(b,a,c){return true},handleMouseDown:function(b){if(this.dragging){return}var a=this.getDragData(b);if(a&&this.onBeforeDrag(a,b)!==false){this.dragData=a;this.proxy.stop();this.callParent(arguments)}},onBeforeDrag:function(a,b){return true},onStartDrag:Ext.emptyFn,alignElWithMouse:function(){this.proxy.ensureAttachedToBody(true);return this.callParent(arguments)},startDrag:function(a,b){this.proxy.reset();this.proxy.hidden=false;this.dragging=true;this.proxy.update("");this.onInitDrag(a,b);this.proxy.show()},onInitDrag:function(a,c){var b=this.el.dom.cloneNode(true);b.id=Ext.id();this.proxy.update(b);this.onStartDrag(a,c);return true},getProxy:function(){return this.proxy},hideProxy:function(){this.proxy.hide();this.proxy.reset(true);this.dragging=false},triggerCacheRefresh:function(){Ext.dd.DDM.refreshCache(this.groups)},b4EndDrag:function(a){},endDrag:function(a){this.onEndDrag(this.dragData,a)},onEndDrag:function(a,b){},autoOffset:function(a,b){this.setDelta(-12,-20)},destroy:function(){this.callParent();Ext.destroy(this.proxy)}});Ext.define("Ext.panel.DD",{extend:"Ext.dd.DragSource",requires:["Ext.panel.Proxy"],constructor:function(b,a){var c=this;c.panel=b;c.dragData={panel:b};c.panelProxy=new Ext.panel.Proxy(b,a);c.proxy=c.panelProxy.proxy;c.callParent([b.el,a]);c.setupEl(b)},setupEl:function(a){var c=this,d=a.header,b=a.body;if(d){c.setHandleElId(d.id);b=d.el}if(b){b.setStyle("cursor","move");c.scroll=false}else{a.on("boxready",c.setupEl,c,{single:true})}},showFrame:Ext.emptyFn,startDrag:Ext.emptyFn,b4StartDrag:function(a,b){this.panelProxy.show()},b4MouseDown:function(b){var a=b.getPageX(),c=b.getPageY();this.autoOffset(a,c)},onInitDrag:function(a,b){this.onStartDrag(a,b);return true},createFrame:Ext.emptyFn,getDragEl:function(a){return this.panelProxy.ghost.el.dom},endDrag:function(a){this.panelProxy.hide();this.panel.saveState()},autoOffset:function(a,b){a-=this.startPageX;b-=this.startPageY;this.setDelta(a,b)},onInvalidDrop:function(c,b,d){var a=this;a.beforeInvalidDrop(c,b,d);if(a.cachedTarget){if(a.cachedTarget.isNotifyTarget){a.cachedTarget.notifyOut(a,b,a.dragData)}a.cacheTarget=null}if(a.afterInvalidDrop){a.afterInvalidDrop(b,d)}}});Ext.define("Ext.panel.Panel",{extend:"Ext.panel.AbstractPanel",requires:["Ext.panel.Header","Ext.fx.Anim","Ext.util.KeyMap","Ext.panel.DD","Ext.XTemplate","Ext.layout.component.Dock","Ext.util.Memento"],alias:"widget.panel",alternateClassName:"Ext.Panel",collapsedCls:"collapsed",animCollapse:Ext.enableFx,minButtonWidth:75,collapsed:false,collapseFirst:true,hideCollapseTool:false,titleCollapse:false,floatable:true,collapsible:false,closable:false,closeAction:"destroy",placeholderCollapseHideMode:Ext.Element.VISIBILITY,preventHeader:false,header:undefined,headerPosition:"top",frame:false,frameHeader:true,titleAlign:"left",manageHeight:true,initComponent:function(){var a=this;a.addEvents("beforeclose","close","beforeexpand","beforecollapse","expand","collapse","titlechange","iconchange","iconclschange");if(a.collapsible){this.addStateEvents(["expand","collapse"])}if(a.unstyled){a.setUI("plain")}if(a.frame){a.setUI(a.ui+"-framed")}a.bridgeToolbars();a.callParent();a.collapseDirection=a.collapseDirection||a.headerPosition||Ext.Component.DIRECTION_TOP;a.hiddenOnCollapse=new Ext.dom.CompositeElement()},beforeDestroy:function(){var a=this;Ext.destroy(a.placeholder,a.ghostPanel,a.dd);a.callParent()},initAria:function(){this.callParent();this.initHeaderAria()},getFocusEl:function(){return this.el},initHeaderAria:function(){var b=this,a=b.el,c=b.header;if(a&&c){a.dom.setAttribute("aria-labelledby",c.titleCmp.id)}},getHeader:function(){return this.header},setTitle:function(f){var c=this,b=c.title,e=c.header,a=c.reExpander,d=c.placeholder;c.title=f;if(e){if(e.isHeader){e.setTitle(f)}else{e.title=f}}else{c.updateHeader()}if(a){a.setTitle(f)}if(d&&d.setTitle){d.setTitle(f)}c.fireEvent("titlechange",c,f,b)},setIconCls:function(a){var c=this,b=c.iconCls,e=c.header,d=c.placeholder;c.iconCls=a;if(e){if(e.isHeader){e.setIconCls(a)}else{e.iconCls=a}}else{c.updateHeader()}if(d&&d.setIconCls){d.setIconCls(a)}c.fireEvent("iconclschange",c,a,b)},setIcon:function(a){var b=this,c=b.icon,e=b.header,d=b.placeholder;b.icon=a;if(e){if(e.isHeader){e.setIcon(a)}else{e.icon=a}}else{b.updateHeader()}if(d&&d.setIcon){d.setIcon(a)}b.fireEvent("iconchange",b,a,c)},bridgeToolbars:function(){var a=this,f=[],c,b,e=a.minButtonWidth;function d(g,i,h){if(Ext.isArray(g)){g={xtype:"toolbar",items:g}}else{if(!g.xtype){g.xtype="toolbar"}}g.dock=i;if(i=="left"||i=="right"){g.vertical=true}if(h){g.layout=Ext.applyIf(g.layout||{},{pack:{left:"start",center:"center"}[a.buttonAlign]||"end"})}return g}if(a.tbar){f.push(d(a.tbar,"top"));a.tbar=null}if(a.bbar){f.push(d(a.bbar,"bottom"));a.bbar=null}if(a.buttons){a.fbar=a.buttons;a.buttons=null}if(a.fbar){c=d(a.fbar,"bottom",true);c.ui="footer";if(e){b=c.defaults;c.defaults=function(g){var h=b||{};if((!g.xtype||g.xtype==="button"||(g.isComponent&&g.isXType("button")))&&!("minWidth" in h)){h=Ext.apply({minWidth:e},h)}return h}}f.push(c);a.fbar=null}if(a.lbar){f.push(d(a.lbar,"left"));a.lbar=null}if(a.rbar){f.push(d(a.rbar,"right"));a.rbar=null}if(a.dockedItems){if(!Ext.isArray(a.dockedItems)){a.dockedItems=[a.dockedItems]}a.dockedItems=a.dockedItems.concat(f)}else{a.dockedItems=f}},isPlaceHolderCollapse:function(){return this.collapseMode=="placeholder"},onBoxReady:function(){this.callParent();if(this.collapsed){this.setHiddenDocked()}},beforeRender:function(){var b=this,a;b.callParent();b.initTools();if(!(b.preventHeader||(b.header===false))){b.updateHeader()}if(b.collapsed){if(b.isPlaceHolderCollapse()){b.hidden=true;b.placeholderCollapse();a=b.collapsed;b.collapsed=false}else{b.beginCollapse();b.addClsWithUI(b.collapsedCls)}}if(a){b.collapsed=a}},initTools:function(){var a=this;a.tools=a.tools?Ext.Array.clone(a.tools):[];if(a.collapsible&&!(a.hideCollapseTool||a.header===false||a.preventHeader)){a.collapseDirection=a.collapseDirection||a.headerPosition||"top";a.collapseTool=a.expandTool=Ext.widget({xtype:"tool",type:(a.collapsed&&!a.isPlaceHolderCollapse())?("expand-"+a.getOppositeDirection(a.collapseDirection)):("collapse-"+a.collapseDirection),handler:a.toggleCollapse,scope:a});if(a.collapseFirst){a.tools.unshift(a.collapseTool)}}a.addTools();if(a.closable){a.addClsWithUI("closable");a.addTool({type:"close",handler:Ext.Function.bind(a.close,a,[])})}if(a.collapseTool&&!a.collapseFirst){a.addTool(a.collapseTool)}},addTools:Ext.emptyFn,close:function(){if(this.fireEvent("beforeclose",this)!==false){this.doClose()}},doClose:function(){this.fireEvent("close",this);this[this.closeAction]()},updateHeader:function(d){var c=this,g=c.header,f=c.title,e=c.tools,b=c.icon||c.iconCls,a=c.headerPosition=="left"||c.headerPosition=="right";if((g!==false)&&(d||(f||b)||(e&&e.length)||(c.collapsible&&!c.titleCollapse))){if(g&&g.isHeader){g.show()}else{g=c.header=Ext.widget(Ext.apply({xtype:"header",title:f,titleAlign:c.titleAlign,orientation:a?"vertical":"horizontal",dock:c.headerPosition||"top",textCls:c.headerTextCls,iconCls:c.iconCls,icon:c.icon,baseCls:c.baseCls+"-header",tools:e,ui:c.ui,id:c.id+"_header",indicateDrag:c.draggable,frame:(c.frame||c.alwaysFramed)&&c.frameHeader,ignoreParentFrame:c.frame||c.overlapHeader,ignoreBorderManagement:c.frame||c.ignoreHeaderBorderManagement,listeners:c.collapsible&&c.titleCollapse?{click:c.toggleCollapse,scope:c}:null},c.header));c.addDocked(g,0);c.tools=g.tools}c.initHeaderAria()}else{if(g){g.hide()}}},setUI:function(b){var a=this;a.callParent(arguments);if(a.header&&a.header.rendered){a.header.setUI(b)}},getContentTarget:function(){return this.body},getTargetEl:function(){var a=this;return a.body||a.protoBody||a.frameBody||a.el},isVisible:function(a){var b=this;if(b.collapsed&&b.placeholder){return b.placeholder.isVisible(a)}return b.callParent(arguments)},onHide:function(){var a=this;if(a.collapsed&&a.placeholder){a.placeholder.hide()}else{a.callParent(arguments)}},onShow:function(){var a=this;if(a.collapsed&&a.placeholder){a.hidden=true;a.placeholder.show()}else{a.callParent(arguments)}},onRemoved:function(b){var a=this;a.callParent(arguments);if(a.placeholder&&!b){a.ownerCt.remove(a.placeholder,false)}},addTool:function(e){e=[].concat(e);var d=this,f=d.header,c,a=e.length,b;for(c=0;c<a;c++){b=e[c];d.tools.push(b);if(f&&f.isHeader){f.addTool(b)}}d.updateHeader()},getOppositeDirection:function(a){var b=Ext.Component;switch(a){case b.DIRECTION_TOP:return b.DIRECTION_BOTTOM;case b.DIRECTION_RIGHT:return b.DIRECTION_LEFT;case b.DIRECTION_BOTTOM:return b.DIRECTION_TOP;case b.DIRECTION_LEFT:return b.DIRECTION_RIGHT}},getWidthAuthority:function(){if(this.collapsed&&this.collapsedHorizontal()){return 1}return this.callParent()},getHeightAuthority:function(){if(this.collapsed&&this.collapsedVertical()){return 1}return this.callParent()},collapsedHorizontal:function(){var a=this.getCollapsed();return a=="left"||a=="right"},collapsedVertical:function(){var a=this.getCollapsed();return a=="top"||a=="bottom"},restoreDimension:function(){var a=this.collapseDirection;return(a==="top"||a==="bottom")?"height":"width"},getCollapsed:function(){var a=this;if(a.collapsed===true){return a.collapseDirection}return a.collapsed},getState:function(){var a=this,b=a.callParent(),c;b=a.addPropertyToState(b,"collapsed");if(a.collapsed){c=a.collapseMemento;c=c&&c.data;if(a.collapsedVertical()){if(b){delete b.height}if(c){b=a.addPropertyToState(b,"height",c.height)}}else{if(b){delete b.width}if(c){b=a.addPropertyToState(b,"width",c.width)}}}return b},findReExpander:function(g){var f=this,h=Ext.Component,e=f.dockedItems.items,a=e.length,b,d;if(f.collapseMode=="mini"){return}switch(g){case h.DIRECTION_TOP:case h.DIRECTION_BOTTOM:for(d=0;d<a;d++){b=e[d];if(!b.hidden){if(b.isHeader&&(!b.dock||b.dock=="top"||b.dock=="bottom")){return b}}}break;case h.DIRECTION_LEFT:case h.DIRECTION_RIGHT:for(d=0;d<a;d++){b=e[d];if(!b.hidden){if(b.isHeader&&(b.dock=="left"||b.dock=="right")){return b}}}break;default:throw ("Panel#findReExpander must be passed a valid collapseDirection")}},getReExpander:function(c){var b=this,d=c||b.collapseDirection,a=b.reExpander||b.findReExpander(d);b.expandDirection=b.getOppositeDirection(d);if(!a){b.reExpander=a=b.createReExpander(d,{dock:d,cls:Ext.baseCSSPrefix+"docked "+b.baseCls+"-"+b.ui+"-collapsed",ownerCt:b,ownerLayout:b.componentLayout});b.dockedItems.insert(0,a)}return a},createReExpander:function(f,e){var d=this,h=f=="left",c=f=="right",g=h||c,b,a=Ext.apply({hideMode:"offsets",title:d.title,orientation:g?"vertical":"horizontal",textCls:d.headerTextCls,icon:d.icon,iconCls:d.iconCls,baseCls:d.baseCls+"-header",ui:d.ui,frame:d.frame&&d.frameHeader,ignoreParentFrame:d.frame||d.overlapHeader,indicateDrag:d.draggable},e);if(d.collapseMode=="mini"){if(g){a.width=1}else{a.height=1}}if(!d.hideCollapseTool){b=h||(c&&d.isPlaceHolderCollapse());a[b?"items":"tools"]=[{xtype:"tool",type:"expand-"+d.getOppositeDirection(f),uiCls:["top"],handler:d.toggleCollapse,scope:d}]}a=new Ext.panel.Header(a);a.addClsWithUI(d.getHeaderCollapsedClasses(a));return a},getHeaderCollapsedClasses:function(d){var b=this,c=b.collapsedCls,a;a=[c,c+"-"+d.dock];if(b.border&&(!b.frame||(b.frame&&Ext.supports.CSS3BorderRadius))){a.push(c+"-border-"+d.dock)}return a},beginCollapse:function(){var e=this,c=e.lastBox,f=e.rendered,b=e.collapseMemento||(e.collapseMemento=new Ext.util.Memento(e)),d=e.getSizeModel(),a;b.capture(["height","minHeight","width","minWidth"]);if(c){b.capture(e.restoreDimension(),c,"last.")}if(e.collapsedVertical()){if(d.width.shrinkWrap){e.width=f?e.getWidth():e.width||e.minWidth||100}delete e.height;e.minHeight=0}else{if(e.collapsedHorizontal()){if(d.height.shrinkWrap){e.height=f?e.getHeight():e.height||e.minHeight||100}delete e.width;e.minWidth=0}}if(e.ownerCt){e.ownerCt.getLayout().beginCollapse(e)}if(!e.isPlaceHolderCollapse()){if(e.header===(a=e.getReExpander())){e.header.addClsWithUI(e.getHeaderCollapsedClasses(e.header));if(e.header.rendered){e.header.updateFrame()}}else{if(a.el){a.el.show();a.hidden=false}}}if(e.resizer){e.resizer.disable()}},beginExpand:function(){var e=this,d=e.lastBox,c=e.collapseMemento,a=this.restoreDimension(),b;c.restore(["minHeight","minWidth",a]);if(d){c.restore(a,true,d,"last.")}if(e.ownerCt){e.ownerCt.getLayout().beginExpand(e)}if(!e.isPlaceHolderCollapse()){if(e.header===(b=e.getReExpander())){e.header.removeClsWithUI(e.getHeaderCollapsedClasses(e.header));if(e.header.rendered){e.header.updateFrame()}}else{b.hidden=true;b.el.hide()}}if(e.resizer){e.resizer.enable()}},collapse:function(d,a){var c=this,e=d||c.collapseDirection,b=c.ownerCt;if(c.isCollapsingOrExpanding){return c}if(arguments.length<2){a=c.animCollapse}if(c.collapsed||c.fireEvent("beforecollapse",c,d,a)===false){return c}if(b&&c.isPlaceHolderCollapse()){return c.placeholderCollapse(d,a)}c.collapsed=e;c.beginCollapse();c.fireHierarchyEvent("collapse");return c.doCollapseExpand(1,a)},doCollapseExpand:function(a,b){var d=this,c=d.animCollapse,e=d.ownerLayout;d.animCollapse=b;d.isCollapsingOrExpanding=a;if(e&&!b){e.onContentChange(d)}else{d.updateLayout({isRoot:true})}d.animCollapse=c;return d},afterCollapse:function(b){var a=this,c=a.ownerLayout;a.isCollapsingOrExpanding=0;if(a.collapseTool){a.collapseTool.setType("expand-"+a.getOppositeDirection(a.collapseDirection))}if(c&&b){c.onContentChange(a)}a.setHiddenDocked();a.fireEvent("collapse",a)},setHiddenDocked:function(){var g=this,d=g.hiddenOnCollapse,b=g.getReExpander(),c=g.getDockedItems(),a=c.length,e=0,f;d.add(g.body);for(;e<a;e++){f=c[e];if(f&&f!==b&&f.el){d.add(f.el)}}d.setStyle("visibility","hidden")},restoreHiddenDocked:function(){var a=this.hiddenOnCollapse;a.setStyle("visibility","");a.clear()},getPlaceholder:function(c){var b=this,e=c||b.collapseDirection,a=null,d=b.placeholder;if(!d){if(b.floatable||(b.collapsible&&b.titleCollapse)){a={click:{fn:b.floatable?b.floatCollapsedPanel:b.toggleCollapse,element:"el",scope:b}}}b.placeholder=d=Ext.widget(b.createReExpander(e,{id:b.id+"-placeholder",listeners:a}))}if(!d.placeholderFor){if(!d.isComponent){b.placeholder=d=b.lookupComponent(d)}Ext.applyIf(d,{margins:b.margins,placeholderFor:b});d.addCls([Ext.baseCSSPrefix+"region-collapsed-placeholder",Ext.baseCSSPrefix+"region-collapsed-"+e+"-placeholder",b.collapsedCls])}return d},placeholderCollapse:function(e,a){var d=this,c=d.ownerCt,g=e||d.collapseDirection,b=Ext.baseCSSPrefix+"border-region-slide-in",f=d.getPlaceholder(e);d.isCollapsingOrExpanding=1;d.hidden=true;d.collapsed=g;if(f.rendered){if(f.el.dom.parentNode!==d.el.dom.parentNode){d.el.dom.parentNode.insertBefore(f.el.dom,d.el.dom)}f.hidden=false;f.el.show();c.updateLayout()}else{c.insert(c.items.indexOf(d),f)}if(d.rendered){d.el.setVisibilityMode(d.placeholderCollapseHideMode);if(a){d.el.addCls(b);f.el.hide();d.el.slideOut(g.substr(0,1),{preserveScroll:true,duration:Ext.Number.from(a,Ext.fx.Anim.prototype.duration),listeners:{afteranimate:function(){d.el.removeCls(b);f.el.show().setStyle("display","none").slideIn(g.substr(0,1),{easing:"linear",duration:100,listeners:{afteranimate:function(){f.focus();d.isCollapsingOrExpanding=0;d.fireEvent("collapse",d)}}})}}})}else{d.el.hide();d.isCollapsingOrExpanding=0;d.fireEvent("collapse",d)}}else{d.isCollapsingOrExpanding=0;d.fireEvent("collapse",d)}return d},floatCollapsedPanel:function(){var f=this,h=f.placeholder,g=h.getBox(true),d,e=Ext.baseCSSPrefix+"border-region-slide-in",b=f.collapsed,i=f.ownerCt||f,a;if(f.el.hasCls(e)){f.slideOutFloatedPanel();return}if(f.isSliding){return}f.isSliding=true;function c(k){if(!f.isDestroyed){var j=f.el.getRegion().union(h.el.getRegion()).adjust(1,-1,-1,1);if(!j.contains(k.getPoint())){f.slideOutFloatedPanel()}}}f.placeholder.el.hide();f.placeholder.hidden=true;f.el.show();f.hidden=false;f.collapsed=false;i.updateLayout();d=f.getBox(true);f.placeholder.el.show();f.placeholder.hidden=false;f.el.hide();f.hidden=true;f.collapsed=b;i.updateLayout();f.placeholderMouseMon=h.el.monitorMouseLeave(500,c);f.panelMouseMon=f.el.monitorMouseLeave(500,c);f.el.addCls(e);if(f.collapseTool){f.collapseTool.el.hide()}switch(f.collapsed){case"top":f.el.setLeftTop(g.x,g.y+g.height-1);a="t";break;case"right":f.el.setLeftTop(g.x-d.width+1,g.y);a="r";break;case"bottom":f.el.setLeftTop(g.x,g.y-d.height+1);a="b";break;case"left":f.el.setLeftTop(g.x+g.width-1,g.y);a="l";break}f.floatedFromCollapse=f.collapsed;f.collapsed=f.hidden=false;f.el.slideIn(a,{preserveScroll:true,listeners:{afteranimate:function(){f.isSliding=false}}})},isLayoutRoot:function(){if(this.floatedFromCollapse){return true}return this.callParent()},slideOutFloatedPanel:function(){var a=this,c=this.el,b;if(a.isSliding){return}a.isSliding=true;a.slideOutFloatedPanelBegin();if(typeof a.collapsed=="string"){b=a.collapsed.charAt(0)}c.slideOut(b,{preserveScroll:true,listeners:{afteranimate:function(){a.slideOutFloatedPanelEnd();a.el.removeCls(Ext.baseCSSPrefix+"border-region-slide-in");a.isSliding=false}}})},slideOutFloatedPanelBegin:function(){var a=this,b=this.el;a.collapsed=a.floatedFromCollapse;a.hidden=true;a.floatedFromCollapse=null;b.un(a.panelMouseMon);a.placeholder.el.un(a.placeholderMouseMon)},slideOutFloatedPanelEnd:function(){if(this.collapseTool){this.collapseTool.el.show()}},expand:function(a){var b=this;if(b.isCollapsingOrExpanding){return b}if(!arguments.length){a=b.animCollapse}if(!b.collapsed&&!b.floatedFromCollapse){return b}if(b.fireEvent("beforeexpand",b,a)===false){return b}if(b.isPlaceHolderCollapse()){return b.placeholderExpand(a)}b.restoreHiddenDocked();b.beginExpand();b.collapsed=false;b.fireHierarchyEvent("expand");return b.doCollapseExpand(2,a)},placeholderExpand:function(b){var d=this,g=d.collapsed,c=Ext.baseCSSPrefix+"border-region-slide-in",e,a,f;if(d.floatedFromCollapse){a=d.getPosition(true);d.slideOutFloatedPanelBegin();d.slideOutFloatedPanelEnd()}d.isCollapsingOrExpanding=2;d.placeholder.hidden=true;d.placeholder.el.hide();d.collapsed=false;d.show();if(b){if(a){e=d.el.getXY();d.el.setLeftTop(a[0],a[1]);d.el.moveTo(e[0],e[1],{duration:Ext.Number.from(b,Ext.fx.Anim.prototype.duration),listeners:{afteranimate:function(){d.el.removeCls(c);d.isCollapsingOrExpanding=0;d.fireEvent("expand",d)}}})}else{d.hidden=true;d.el.addCls(c);d.el.hide();d.collapsed=g;d.placeholder.show();f=g.substr(0,1);d.hidden=false;d.el.slideIn(f,{preserveScroll:true,duration:Ext.Number.from(b,Ext.fx.Anim.prototype.duration),listeners:{afteranimate:function(){d.collapsed=false;d.el.removeCls(c);d.placeholder.hide();d.isCollapsingOrExpanding=0;d.fireEvent("expand",d)}}})}}else{d.isCollapsingOrExpanding=0;d.fireEvent("expand",d)}return d},afterExpand:function(b){var a=this,c=a.ownerLayout;a.isCollapsingOrExpanding=0;if(a.collapseTool){a.collapseTool.setType("collapse-"+a.collapseDirection)}if(c&&b){c.onContentChange(a)}a.fireEvent("expand",a)},setBorder:function(a,c){if(c){return}var b=this,d=b.header;if(!a){a=0}else{a=Ext.Element.unitizeBox((a===true)?1:a)}if(d){if(d.isHeader){d.setBorder(a)}else{d.border=a}}if(b.rendered&&b.bodyBorder!==false){b.body.setStyle("border-width",a)}b.updateLayout();b.border=a},toggleCollapse:function(){return(this.collapsed||this.floatedFromCollapse)?this.expand():this.collapse()},getKeyMap:function(){return this.keyMap||(this.keyMap=new Ext.util.KeyMap(Ext.apply({target:this.el},this.keys)))},initDraggable:function(){this.dd=new Ext.panel.DD(this,Ext.isBoolean(this.draggable)?null:this.draggable)},ghostTools:function(){var e=[],f=this.header,d=f?f.query("tool[hidden=false]"):[],c,a,b;if(d.length){c=0;a=d.length;for(;c<a;c++){b=d[c];e.push({type:b.type})}}else{e=[{type:"placeholder"}]}return e},ghost:function(a){var d=this,b=d.ghostPanel,c=d.getBox(),e;if(!b){b=new Ext.panel.Panel({renderTo:document.body,floating:{shadow:false},frame:d.frame&&!d.alwaysFramed,alwaysFramed:d.alwaysFramed,overlapHeader:d.overlapHeader,headerPosition:d.headerPosition,baseCls:d.baseCls,cls:d.baseCls+"-ghost "+(a||"")});d.ghostPanel=b}else{b.el.show()}b.floatParent=d.floatParent;if(d.floating){b.setZIndex(Ext.Number.from(d.el.getStyle("zIndex"),0))}else{b.toFront()}if(!(d.preventHeader||(d.header===false))){e=b.header;if(e){e.suspendLayouts();Ext.Array.forEach(e.query("tool"),e.remove,e);e.resumeLayouts()}b.addTool(d.ghostTools());b.setTitle(d.title);b.setIconCls(d.iconCls)}b.setPagePosition(c.x,c.y);b.setSize(c.width,c.height);d.el.hide();return b},unghost:function(b,a){var c=this;if(!c.ghostPanel){return}if(b!==false){c.el.show();if(a!==false){c.setPagePosition(c.ghostPanel.el.getXY());if(c.hideMode=="offsets"){delete c.el.hideModeStyles}}Ext.defer(c.focus,10,c)}c.ghostPanel.el.hide()},beginDrag:function(){if(this.floatingDescendants){this.floatingDescendants.hide()}},endDrag:function(){if(this.floatingDescendants){this.floatingDescendants.show()}},initResizable:function(a){if(this.collapsed){a.disabled=true}this.callParent([a])}},function(){this.prototype.animCollapse=Ext.enableFx});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("Ext.ux.desktop.Desktop",{extend:"Ext.panel.Panel",alias:"widget.desktop",uses:["Ext.util.MixedCollection","Ext.menu.Menu","Ext.view.View","Ext.window.Window","Ext.ux.desktop.TaskBar","Ext.ux.desktop.Wallpaper"],activeWindowCls:"ux-desktop-active-win",inactiveWindowCls:"ux-desktop-inactive-win",lastActiveWindow:null,border:false,html:"&#160;",layout:"fit",xTickSize:1,yTickSize:1,app:null,shortcuts:null,shortcutItemSelector:"div.ux-desktop-shortcut",shortcutTpl:['<tpl for=".">','<div class="ux-desktop-shortcut" id="{name}-shortcut">','<div class="ux-desktop-shortcut-icon {iconCls}">','<img src="',Ext.BLANK_IMAGE_URL,'" title="{name}">',"</div>",'<span class="ux-desktop-shortcut-text">{name}</span>',"</div>","</tpl>",'<div class="x-clear"></div>'],taskbarConfig:null,windowMenu:null,initComponent:function(){var b=this;b.windowMenu=new Ext.menu.Menu(b.createWindowMenu());b.bbar=b.taskbar=new Ext.ux.desktop.TaskBar(b.taskbarConfig);b.taskbar.windowMenu=b.windowMenu;b.windows=new Ext.util.MixedCollection();b.contextMenu=new Ext.menu.Menu(b.createDesktopMenu());b.items=[{xtype:"wallpaper",id:b.id+"_wallpaper"},b.createDataView()];b.callParent();b.shortcutsView=b.items.getAt(1);b.shortcutsView.on("itemclick",b.onShortcutItemClick,b);var a=b.wallpaper;b.wallpaper=b.items.getAt(0);if(a){b.setWallpaper(a,b.wallpaperStretch)}},afterRender:function(){var a=this;a.callParent();a.el.on("contextmenu",a.onDesktopMenu,a)},createDataView:function(){var a=this;return{xtype:"dataview",overItemCls:"x-view-over",trackOver:true,itemSelector:a.shortcutItemSelector,store:a.shortcuts,style:{position:"absolute"},x:0,y:0,tpl:new Ext.XTemplate(a.shortcutTpl)}},createDesktopMenu:function(){var b=this,a={items:b.contextMenuItems||[]};if(a.items.length){a.items.push("-")}a.items.push({text:"Tile",handler:b.tileWindows,scope:b,minWindows:1},{text:"Cascade",handler:b.cascadeWindows,scope:b,minWindows:1});return a},createWindowMenu:function(){var a=this;return{defaultAlign:"br-tr",items:[{text:"Restore",handler:a.onWindowMenuRestore,scope:a},{text:"Minimize",handler:a.onWindowMenuMinimize,scope:a},{text:"Maximize",handler:a.onWindowMenuMaximize,scope:a},"-",{text:"Close",handler:a.onWindowMenuClose,scope:a}],listeners:{beforeshow:a.onWindowMenuBeforeShow,hide:a.onWindowMenuHide,scope:a}}},onDesktopMenu:function(b){var a=this,c=a.contextMenu;b.stopEvent();if(!c.rendered){c.on("beforeshow",a.onDesktopMenuBeforeShow,a)}c.showAt(b.getXY());c.doConstrain()},onDesktopMenuBeforeShow:function(c){var b=this,a=b.windows.getCount();c.items.each(function(e){var d=e.minWindows||0;e.setDisabled(a<d)})},onShortcutItemClick:function(e,a){var c=this,b=c.app.getModule(a.data.module),d=b&&b.createWindow();if(d){c.restoreWindow(d)}},onWindowClose:function(b){var a=this;a.windows.remove(b);a.taskbar.removeTaskButton(b.taskButton);a.updateActiveWindow()},onWindowMenuBeforeShow:function(c){var a=c.items.items,b=c.theWin;a[0].setDisabled(b.maximized!==true&&b.hidden!==true);a[1].setDisabled(b.minimized===true);a[2].setDisabled(b.maximized===true||b.hidden===true)},onWindowMenuClose:function(){var a=this,b=a.windowMenu.theWin;b.close()},onWindowMenuHide:function(a){a.theWin=null},onWindowMenuMaximize:function(){var a=this,b=a.windowMenu.theWin;b.maximize();b.toFront()},onWindowMenuMinimize:function(){var a=this,b=a.windowMenu.theWin;b.minimize()},onWindowMenuRestore:function(){var a=this,b=a.windowMenu.theWin;a.restoreWindow(b)},getWallpaper:function(){return this.wallpaper.wallpaper},setTickSize:function(b,c){var e=this,a=e.xTickSize=b,d=e.yTickSize=(arguments.length>1)?c:a;e.windows.each(function(g){var f=g.dd,h=g.resizer;f.xTickSize=a;f.yTickSize=d;h.widthIncrement=a;h.heightIncrement=d})},setWallpaper:function(b,a){this.wallpaper.setWallpaper(b,a);return this},cascadeWindows:function(){var a=0,c=0,b=this.getDesktopZIndexManager();b.eachBottomUp(function(d){if(d.isWindow&&d.isVisible()&&!d.maximized){d.setPosition(a,c);a+=20;c+=20}})},createWindow:function(c,b){var d=this,e,a=Ext.applyIf(c||{},{stateful:false,isWindow:true,constrainHeader:true,minimizable:true,maximizable:true});b=b||Ext.window.Window;e=d.add(new b(a));d.windows.add(e);e.taskButton=d.taskbar.addTaskButton(e);e.animateTarget=e.taskButton.el;e.on({activate:d.updateActiveWindow,beforeshow:d.updateActiveWindow,deactivate:d.updateActiveWindow,minimize:d.minimizeWindow,destroy:d.onWindowClose,scope:d});e.on({boxready:function(){e.dd.xTickSize=d.xTickSize;e.dd.yTickSize=d.yTickSize;if(e.resizer){e.resizer.widthIncrement=d.xTickSize;e.resizer.heightIncrement=d.yTickSize}},single:true});e.doClose=function(){e.doClose=Ext.emptyFn;e.el.disableShadow();e.el.fadeOut({listeners:{afteranimate:function(){e.destroy()}}})};return e},getActiveWindow:function(){var b=null,a=this.getDesktopZIndexManager();if(a){a.eachTopDown(function(c){if(c.isWindow&&!c.hidden){b=c;return false}return true})}return b},getDesktopZIndexManager:function(){var a=this.windows;return(a.getCount()&&a.getAt(0).zIndexManager)||null},getWindow:function(a){return this.windows.get(a)},minimizeWindow:function(a){a.minimized=true;a.hide()},restoreWindow:function(a){if(a.isVisible()){a.restore();a.toFront()}else{a.show()}return a},tileWindows:function(){var b=this,e=b.body.getWidth(true);var a=b.xTickSize,d=b.yTickSize,c=d;b.windows.each(function(g){if(g.isVisible()&&!g.maximized){var f=g.el.getWidth();if(a>b.xTickSize&&a+f>e){a=b.xTickSize;d=c}g.setPosition(a,d);a+=f+b.xTickSize;c=Math.max(c,d+g.el.getHeight()+b.yTickSize)}})},updateActiveWindow:function(){var b=this,c=b.getActiveWindow(),a=b.lastActiveWindow;if(c===a){return}if(a){if(a.el.dom){a.addCls(b.inactiveWindowCls);a.removeCls(b.activeWindowCls)}a.active=false}b.lastActiveWindow=c;if(c){c.addCls(b.activeWindowCls);c.removeCls(b.inactiveWindowCls);c.minimized=false;c.active=true}b.taskbar.setActiveButton(c&&c.taskButton)}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("Ext.ux.desktop.App",{mixins:{observable:"Ext.util.Observable"},requires:["Ext.container.Viewport","Ext.ux.desktop.Desktop"],isReady:false,modules:null,useQuickTips:true,constructor:function(a){var b=this;b.addEvents("ready","beforeunload");b.mixins.observable.constructor.call(this,a);if(Ext.isReady){Ext.Function.defer(b.init,10,b)}else{Ext.onReady(b.init,b)}},init:function(){var b=this,a;if(b.useQuickTips){Ext.QuickTips.init()}b.modules=b.getModules();if(b.modules){b.initModules(b.modules)}a=b.getDesktopConfig();b.desktop=new Ext.ux.desktop.Desktop(a);b.viewport=new Ext.container.Viewport({layout:"fit",items:[b.desktop]});Ext.EventManager.on(window,"beforeunload",b.onUnload,b);b.isReady=true;b.fireEvent("ready",b)},getDesktopConfig:function(){var b=this,a={app:b,taskbarConfig:b.getTaskbarConfig()};Ext.apply(a,b.desktopConfig);return a},getModules:Ext.emptyFn,getStartConfig:function(){var b=this,a={app:b,menu:[]},c;Ext.apply(a,b.startConfig);Ext.each(b.modules,function(d){c=d.launcher;if(c){c.handler=c.handler||Ext.bind(b.createWindow,b,[d]);a.menu.push(d.launcher)}});return a},createWindow:function(a){var b=a.createWindow();b.show()},getTaskbarConfig:function(){var b=this,a={app:b,startConfig:b.getStartConfig()};Ext.apply(a,b.taskbarConfig);return a},initModules:function(a){var b=this;Ext.each(a,function(c){c.app=b})},getModule:function(d){var c=this.modules;for(var e=0,b=c.length;e<b;e++){var a=c[e];if(a.id==d||a.appType==d){return a}}return null},onReady:function(b,a){if(this.isReady){b.call(a,this)}else{this.on({ready:b,scope:a,single:true})}},getDesktop:function(){return this.desktop},onUnload:function(a){if(this.fireEvent("beforeunload",this)===false){a.stopEvent()}}});Ext.define("Ext.window.Window",{extend:"Ext.panel.Panel",alternateClassName:"Ext.Window",requires:["Ext.util.ComponentDragger","Ext.util.Region","Ext.EventManager"],alias:"widget.window",baseCls:Ext.baseCSSPrefix+"window",resizable:true,draggable:true,constrain:false,constrainHeader:false,plain:false,minimizable:false,maximizable:false,minHeight:50,minWidth:50,expandOnShow:true,collapsible:false,closable:true,hidden:true,autoRender:true,hideMode:"offsets",floating:true,ariaRole:"alertdialog",itemCls:Ext.baseCSSPrefix+"window-item",initialAlphaNum:/^[a-z0-9]/,overlapHeader:true,ignoreHeaderBorderManagement:true,alwaysFramed:true,isWindow:true,initComponent:function(){var a=this;a.frame=false;a.callParent();a.addEvents("resize","maximize","minimize","restore");if(a.plain){a.addClsWithUI("plain")}if(a.modal){a.ariaRole="dialog"}if(a.floating){a.on({element:"el",mousedown:a.onMouseDown,scope:a})}a.addStateEvents(["maximize","restore","resize","dragend"])},getElConfig:function(){var b=this,a;a=b.callParent();a.tabIndex=-1;return a},getState:function(){var b=this,c=b.callParent()||{},a=!!b.maximized;c.maximized=a;Ext.apply(c,{size:a?b.restoreSize:b.getSize(),pos:a?b.restorePos:b.getPosition()});return c},applyState:function(b){var a=this;if(b){a.maximized=b.maximized;if(a.maximized){a.hasSavedRestore=true;a.restoreSize=b.size;a.restorePos=b.pos}else{Ext.apply(a,{width:b.size.width,height:b.size.height,x:b.pos[0],y:b.pos[1]})}}},onMouseDown:function(b){var a;if(this.floating){if(Ext.fly(b.getTarget()).focusable()){a=true}this.toFront(a)}},onRender:function(b,a){var c=this;c.callParent(arguments);c.focusEl=c.el;if(c.maximizable){c.header.on({scope:c,dblclick:c.toggleMaximize})}},afterRender:function(){var a=this,b;a.callParent();if(a.maximized){a.maximized=false;a.maximize()}if(a.closable){b=a.getKeyMap();b.on(27,a.onEsc,a)}else{b=a.keyMap}if(b&&a.hidden){b.disable()}},initDraggable:function(){var b=this,a;if(!b.header){b.updateHeader(true)}if(b.header){a=Ext.applyIf({el:b.el,delegate:"#"+Ext.escapeId(b.header.id)},b.draggable);if(b.constrain||b.constrainHeader){a.constrain=b.constrain;a.constrainDelegate=b.constrainHeader;a.constrainTo=b.constrainTo||b.container}b.dd=new Ext.util.ComponentDragger(this,a);b.relayEvents(b.dd,["dragstart","drag","dragend"])}},onEsc:function(a,b){if(!Ext.FocusManager||!Ext.FocusManager.enabled||Ext.FocusManager.focusedCmp===this){b.stopEvent();this.close()}},beforeDestroy:function(){var a=this;if(a.rendered){delete this.animateTarget;a.hide();Ext.destroy(a.keyMap)}a.callParent()},addTools:function(){var a=this;a.callParent();if(a.minimizable){a.addTool({type:"minimize",handler:Ext.Function.bind(a.minimize,a,[])})}if(a.maximizable){a.addTool({type:"maximize",handler:Ext.Function.bind(a.maximize,a,[])});a.addTool({type:"restore",handler:Ext.Function.bind(a.restore,a,[]),hidden:true})}},getFocusEl:function(){return this.getDefaultFocus()},getDefaultFocus:function(){var c=this,b,d=c.defaultButton||c.defaultFocus,a;if(d!==undefined){if(Ext.isNumber(d)){b=c.query("button")[d]}else{if(Ext.isString(d)){a=d;if(a.match(c.initialAlphaNum)){b=c.down("#"+a)}if(!b){b=c.down(a)}}else{if(d.focus){b=d}}}}return b||c.el},onFocus:function(){var b=this,a;if((Ext.FocusManager&&Ext.FocusManager.enabled)||((a=b.getDefaultFocus())===b)){b.callParent(arguments)}else{a.focus()}},beforeLayout:function(){var a=this.el.shadow;this.callParent();if(a){a.hide()}},onShow:function(){var a=this;a.callParent(arguments);if(a.expandOnShow){a.expand(false)}a.syncMonitorWindowResize();if(a.keyMap){a.keyMap.enable()}},doClose:function(){var a=this;if(a.hidden){a.fireEvent("close",a);if(a.closeAction=="destroy"){this.destroy()}}else{a.hide(a.animateTarget,a.doClose,a)}},afterHide:function(){var a=this;a.syncMonitorWindowResize();if(a.keyMap){a.keyMap.disable()}a.callParent(arguments)},onWindowResize:function(){var b=this,a;if(b.maximized){b.fitContainer()}else{a=b.getSizeModel();if(a.width.natural||a.height.natural){b.updateLayout()}}b.doConstrain()},minimize:function(){this.fireEvent("minimize",this);return this},afterCollapse:function(){var a=this;if(a.maximizable){a.tools.maximize.hide();a.tools.restore.hide()}if(a.resizer){a.resizer.disable()}a.callParent(arguments)},afterExpand:function(){var a=this;if(a.maximized){a.tools.restore.show()}else{if(a.maximizable){a.tools.maximize.show()}}if(a.resizer){a.resizer.enable()}a.callParent(arguments)},maximize:function(){var a=this;if(!a.maximized){a.expand(false);if(!a.hasSavedRestore){a.restoreSize=a.getSize();a.restorePos=a.getPosition(true)}if(a.maximizable){a.tools.maximize.hide();a.tools.restore.show()}a.maximized=true;a.el.disableShadow();if(a.dd){a.dd.disable()}if(a.resizer){a.resizer.disable()}if(a.collapseTool){a.collapseTool.hide()}a.el.addCls(Ext.baseCSSPrefix+"window-maximized");a.container.addCls(Ext.baseCSSPrefix+"window-maximized-ct");a.syncMonitorWindowResize();a.fitContainer();a.fireEvent("maximize",a)}return a},restore:function(){var a=this,b=a.tools;if(a.maximized){delete a.hasSavedRestore;a.removeCls(Ext.baseCSSPrefix+"window-maximized");if(b.restore){b.restore.hide()}if(b.maximize){b.maximize.show()}if(a.collapseTool){a.collapseTool.show()}a.maximized=false;a.setPosition(a.restorePos);a.setSize(a.restoreSize);delete a.restorePos;delete a.restoreSize;a.el.enableShadow(true);if(a.dd){a.dd.enable()}if(a.resizer){a.resizer.enable()}a.container.removeCls(Ext.baseCSSPrefix+"window-maximized-ct");a.syncMonitorWindowResize();a.doConstrain();a.fireEvent("restore",a)}return a},syncMonitorWindowResize:function(){var b=this,c=b._monitoringResize,d=b.monitorResize||b.constrain||b.constrainHeader||b.maximized,a=b.hidden||b.destroying||b.isDestroyed;if(d&&!a){if(!c){Ext.EventManager.onWindowResize(b.onWindowResize,b);b._monitoringResize=true}}else{if(c){Ext.EventManager.removeResizeListener(b.onWindowResize,b);b._monitoringResize=false}}},toggleMaximize:function(){return this[this.maximized?"restore":"maximize"]()}});Ext.define("Ext.window.MessageBox",{extend:"Ext.window.Window",requires:["Ext.toolbar.Toolbar","Ext.form.field.Text","Ext.form.field.TextArea","Ext.form.field.Display","Ext.button.Button","Ext.layout.container.Anchor","Ext.layout.container.HBox","Ext.ProgressBar"],alias:"widget.messagebox",OK:1,YES:2,NO:4,CANCEL:8,OKCANCEL:9,YESNO:6,YESNOCANCEL:14,INFO:Ext.baseCSSPrefix+"message-box-info",WARNING:Ext.baseCSSPrefix+"message-box-warning",QUESTION:Ext.baseCSSPrefix+"message-box-question",ERROR:Ext.baseCSSPrefix+"message-box-error",hideMode:"offsets",closeAction:"hide",resizable:false,title:"&#160;",width:600,height:500,minWidth:250,maxWidth:600,minHeight:110,maxHeight:500,constrain:true,cls:Ext.baseCSSPrefix+"message-box",layout:{type:"vbox",align:"stretch"},defaultTextHeight:75,minProgressWidth:250,minPromptWidth:250,buttonText:{ok:"OK",yes:"Yes",no:"No",cancel:"Cancel"},buttonIds:["ok","yes","no","cancel"],titleText:{confirm:"Confirm",prompt:"Prompt",wait:"Loading...",alert:"Attention"},iconHeight:35,makeButton:function(a){var b=this.buttonIds[a];return new Ext.button.Button({handler:this.btnCallback,itemId:b,scope:this,text:this.buttonText[b],minWidth:75})},btnCallback:function(a){var b=this,c,d;if(b.cfg.prompt||b.cfg.multiline){if(b.cfg.multiline){d=b.textArea}else{d=b.textField}c=d.getValue();d.reset()}a.blur();b.hide();b.userCallback(a.itemId,c,b.cfg)},hide:function(){var a=this;a.dd.endDrag();a.progressBar.reset();a.removeCls(a.cfg.cls);a.callParent(arguments)},initComponent:function(){var e=this,a=e.id,c,b,d;e.title="&#160;";e.topContainer=new Ext.container.Container({layout:"hbox",style:{padding:"10px",overflow:"hidden"},items:[e.iconComponent=new Ext.Component({cls:e.baseCls+"-icon",width:50,height:e.iconHeight}),e.promptContainer=new Ext.container.Container({flex:1,layout:{type:"anchor"},items:[e.msg=new Ext.form.field.Display({id:a+"-displayfield",cls:e.baseCls+"-text"}),e.textField=new Ext.form.field.Text({id:a+"-testfield",anchor:"100%",enableKeyEvents:true,listeners:{keydown:e.onPromptKey,scope:e}}),e.textArea=new Ext.form.field.TextArea({id:a+"-textarea",anchor:"100%",height:75})]})]});e.progressBar=new Ext.ProgressBar({id:a+"-progressbar",margins:"0 10 0 10"});e.items=[e.topContainer,e.progressBar];e.msgButtons=[];for(c=0;c<4;c++){b=e.makeButton(c);e.msgButtons[b.itemId]=b;e.msgButtons.push(b)}e.bottomTb=new Ext.toolbar.Toolbar({id:a+"-toolbar",ui:"footer",dock:"bottom",layout:{pack:"center"},items:[e.msgButtons[0],e.msgButtons[1],e.msgButtons[2],e.msgButtons[3]]});e.dockedItems=[e.bottomTb];d=e.bottomTb.getLayout();d.finishedLayout=Ext.Function.createInterceptor(d.finishedLayout,function(f){e.tbWidth=f.getProp("contentWidth")});e.on("close",e.onClose,e);e.callParent()},onClose:function(){var a=this.header.child("[type=close]");a.itemId="cancel";this.btnCallback(a);delete a.itemId},onPromptKey:function(a,c){var b=this,d;if(c.keyCode===Ext.EventObject.RETURN||c.keyCode===10){if(b.msgButtons.ok.isVisible()){d=true;b.msgButtons.ok.handler.call(b,b.msgButtons.ok)}else{if(b.msgButtons.yes.isVisible()){b.msgButtons.yes.handler.call(b,b.msgButtons.yes);d=true}}if(d){b.textField.blur()}}},reconfigure:function(a){var d=this,c=0,g=true,f=d.maxWidth,e=d.buttonText,b;d.updateButtonText();a=a||{};d.cfg=a;if(a.width){f=a.width}delete d.defaultFocus;d.animateTarget=a.animateTarget||undefined;d.modal=a.modal!==false;if(a.title){d.setTitle(a.title||"&#160;")}if(Ext.isObject(a.buttons)){d.buttonText=a.buttons;c=0}else{d.buttonText=a.buttonText||d.buttonText;c=Ext.isNumber(a.buttons)?a.buttons:0}c=c|d.updateButtonText();d.buttonText=e;Ext.suspendLayouts();d.hidden=false;if(!d.rendered){d.width=f;d.render(Ext.getBody())}else{d.setSize(f,d.maxHeight)}d.closable=a.closable&&!a.wait;d.header.child("[type=close]").setVisible(a.closable!==false);if(!a.title&&!d.closable){d.header.hide()}else{d.header.show()}d.liveDrag=!a.proxyDrag;d.userCallback=Ext.Function.bind(a.callback||a.fn||Ext.emptyFn,a.scope||Ext.global);d.setIcon(a.icon);if(a.msg){d.msg.setValue(a.msg);d.msg.show()}else{d.msg.hide()}Ext.resumeLayouts(true);Ext.suspendLayouts();if(a.prompt||a.multiline){d.multiline=a.multiline;if(a.multiline){d.textArea.setValue(a.value);d.textArea.setHeight(a.defaultTextHeight||d.defaultTextHeight);d.textArea.show();d.textField.hide();d.defaultFocus=d.textArea}else{d.textField.setValue(a.value);d.textArea.hide();d.textField.show();d.defaultFocus=d.textField}}else{d.textArea.hide();d.textField.hide()}if(a.progress||a.wait){d.progressBar.show();d.updateProgress(0,a.progressText);if(a.wait===true){d.progressBar.wait(a.waitConfig)}}else{d.progressBar.hide()}for(b=0;b<4;b++){if(c&Math.pow(2,b)){if(!d.defaultFocus){d.defaultFocus=d.msgButtons[b]}d.msgButtons[b].show();g=false}else{d.msgButtons[b].hide()}}if(g){d.bottomTb.hide()}else{d.bottomTb.show()}Ext.resumeLayouts(true)},updateButtonText:function(){var d=this,c=d.buttonText,b=0,e,a;for(e in c){if(c.hasOwnProperty(e)){a=d.msgButtons[e];if(a){if(d.cfg&&d.cfg.buttonText){b=b|Math.pow(2,Ext.Array.indexOf(d.buttonIds,e))}if(a.text!=c[e]){a.setText(c[e])}}}}return b},show:function(a){var b=this;b.reconfigure(a);b.addCls(a.cls);b.doAutoSize();b.hidden=true;b.callParent();return b},onShow:function(){this.callParent(arguments);this.center()},doAutoSize:function(){var d=this,e=d.header.rendered&&d.header.isVisible(),c=d.bottomTb.rendered&&d.bottomTb.isVisible(),b,a;if(!Ext.isDefined(d.frameWidth)){d.frameWidth=d.el.getWidth()-d.body.getWidth()}d.minWidth=d.cfg.minWidth||Ext.getClass(this).prototype.minWidth;b=Math.max(e?d.header.getMinWidth():0,d.cfg.width||d.msg.getWidth()+d.iconComponent.getWidth()+25,(c?d.tbWidth:0));a=(e?d.header.getHeight():0)+d.topContainer.getHeight()+d.progressBar.getHeight()+(c?d.bottomTb.getHeight()+d.bottomTb.el.getMargin("tb"):0);d.setSize(b+d.frameWidth,a+d.frameWidth);return d},updateText:function(a){this.msg.setValue(a);return this.doAutoSize(true)},setIcon:function(a){var b=this;b.iconComponent.removeCls(b.messageIconCls);if(a){b.iconComponent.show();b.iconComponent.addCls(Ext.baseCSSPrefix+"dlg-icon");b.iconComponent.addCls(b.messageIconCls=a)}else{b.iconComponent.removeCls(Ext.baseCSSPrefix+"dlg-icon");b.iconComponent.hide()}return b},updateProgress:function(b,a,c){this.progressBar.updateProgress(b,a);if(c){this.updateText(c)}return this},onEsc:function(){if(this.closable!==false){this.callParent(arguments)}},confirm:function(a,d,c,b){if(Ext.isString(a)){a={title:a,icon:this.QUESTION,msg:d,buttons:this.YESNO,callback:c,scope:b}}return this.show(a)},prompt:function(b,f,d,c,a,e){if(Ext.isString(b)){b={prompt:true,title:b,minWidth:this.minPromptWidth,msg:f,buttons:this.OKCANCEL,callback:d,scope:c,multiline:a,value:e}}return this.show(b)},wait:function(a,c,b){if(Ext.isString(a)){a={title:c,msg:a,closable:false,wait:true,modal:true,minWidth:this.minProgressWidth,waitConfig:b}}return this.show(a)},alert:function(a,d,c,b){if(Ext.isString(a)){a={title:a,msg:d,buttons:this.OK,fn:c,scope:b,minWidth:this.minWidth}}return this.show(a)},progress:function(a,c,b){if(Ext.isString(a)){a={title:a,msg:c,progress:true,progressText:b}}return this.show(a)}},function(){Ext.MessageBox=Ext.Msg=new this()});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("MyDesktop.Settings",{extend:"Ext.window.Window",uses:["Ext.tree.Panel","Ext.tree.View","Ext.form.field.Checkbox","Ext.layout.container.Anchor","Ext.layout.container.Border","Ext.ux.desktop.Wallpaper","MyDesktop.WallpaperModel"],layout:"anchor",title:"Change Settings",modal:true,width:640,height:480,border:false,initComponent:function(){var a=this;a.selected=a.desktop.getWallpaper();a.stretch=a.desktop.wallpaper.stretch;a.preview=Ext.create("widget.wallpaper");a.preview.setWallpaper(a.selected);a.tree=a.createTree();a.buttons=[{text:"OK",handler:a.onOK,scope:a},{text:"Cancel",handler:a.close,scope:a}];a.items=[{anchor:"0 -30",border:false,layout:"border",items:[a.tree,{xtype:"panel",title:"Preview",region:"center",layout:"fit",items:[a.preview]}]},{xtype:"checkbox",boxLabel:"Stretch to fit",checked:a.stretch,listeners:{change:function(b){a.stretch=b.checked}}}];a.callParent()},createTree:function(){var b=this;function c(d){return{img:d,text:b.getTextOfWallpaper(d),iconCls:"",leaf:true}}var a=new Ext.tree.Panel({title:"Desktop Background",rootVisible:false,lines:false,autoScroll:true,width:150,region:"west",split:true,minWidth:100,listeners:{afterrender:{fn:this.setInitialSelection,delay:100},select:this.onSelect,scope:this},store:new Ext.data.TreeStore({model:"MyDesktop.WallpaperModel",root:{text:"Wallpaper",expanded:true,children:[{text:"None",iconCls:"",leaf:true},c("Blue-Sencha.jpg"),c("Dark-Sencha.jpg"),c("Wood-Sencha.jpg"),c("blue.jpg"),c("desk.jpg"),c("desktop.jpg"),c("desktop2.jpg"),c("sky.jpg")]}})});return a},getTextOfWallpaper:function(c){var d=c,b=c.lastIndexOf("/");if(b>=0){d=d.substring(b+1)}var a=d.lastIndexOf(".");d=Ext.String.capitalize(d.substring(0,a));d=d.replace(/[-]/g," ");return d},onOK:function(){var a=this;if(a.selected){a.desktop.setWallpaper(a.selected,a.stretch)}a.destroy()},onSelect:function(a,b){var c=this;if(b.data.img){c.selected="wallpapers/"+b.data.img}else{c.selected=Ext.BLANK_IMAGE_URL}c.preview.setWallpaper(c.selected)},setInitialSelection:function(){var a=this.desktop.getWallpaper();if(a){var b="/Wallpaper/"+this.getTextOfWallpaper(a);this.tree.selectPath(b,"text")}}});Ext.define("Ext.tab.Panel",{extend:"Ext.panel.Panel",alias:"widget.tabpanel",alternateClassName:["Ext.TabPanel"],requires:["Ext.layout.container.Card","Ext.tab.Bar"],tabPosition:"top",removePanelHeader:true,plain:false,itemCls:Ext.baseCSSPrefix+"tabpanel-child",minTabWidth:undefined,maxTabWidth:undefined,deferredRender:true,initComponent:function(){var c=this,b=[].concat(c.dockedItems||[]),a=c.activeTab||(c.activeTab=0);c.layout=new Ext.layout.container.Card(Ext.apply({owner:c,deferredRender:c.deferredRender,itemCls:c.itemCls,activeItem:c.activeTab},c.layout));c.tabBar=new Ext.tab.Bar(Ext.apply({dock:c.tabPosition,plain:c.plain,border:c.border,cardLayout:c.layout,tabPanel:c},c.tabBar));b.push(c.tabBar);c.dockedItems=b;c.addEvents("beforetabchange","tabchange");c.callParent(arguments);c.activeTab=c.getComponent(a);if(c.activeTab){c.activeTab.tab.activate(true);c.tabBar.activeTab=c.activeTab.tab}},setActiveTab:function(a){var c=this,b;a=c.getComponent(a);if(a){b=c.getActiveTab();if(b!==a&&c.fireEvent("beforetabchange",c,a,b)===false){return false}if(!a.isComponent){Ext.suspendLayouts();a=c.add(a);Ext.resumeLayouts()}c.activeTab=a;Ext.suspendLayouts();c.layout.setActiveItem(a);a=c.activeTab=c.layout.getActiveItem();if(a&&a!==b){c.tabBar.setActiveTab(a.tab);Ext.resumeLayouts(true);if(b!==a){c.fireEvent("tabchange",c,a,b)}}else{Ext.resumeLayouts(true)}return a}},getActiveTab:function(){var b=this,a=b.getComponent(b.activeTab);if(a&&b.items.indexOf(a)!=-1){b.activeTab=a}else{b.activeTab=null}return b.activeTab},getTabBar:function(){return this.tabBar},onAdd:function(e,c){var d=this,b=e.tabConfig||{},a={xtype:"tab",card:e,disabled:e.disabled,closable:e.closable,hidden:e.hidden&&!e.hiddenByLayout,tooltip:e.tooltip,tabBar:d.tabBar,closeText:e.closeText};b=Ext.applyIf(b,a);e.tab=d.tabBar.insert(c,b);e.on({scope:d,enable:d.onItemEnable,disable:d.onItemDisable,beforeshow:d.onItemBeforeShow,iconchange:d.onItemIconChange,iconclschange:d.onItemIconClsChange,titlechange:d.onItemTitleChange});if(e.isPanel){if(d.removePanelHeader){if(e.rendered){if(e.header){e.header.hide()}}else{e.header=false}}if(e.isPanel&&d.border){e.setBorder(false)}}},onItemEnable:function(a){a.tab.enable()},onItemDisable:function(a){a.tab.disable()},onItemBeforeShow:function(a){if(a!==this.activeTab){this.setActiveTab(a);return false}},onItemIconChange:function(b,a){b.tab.setIcon(a)},onItemIconClsChange:function(b,a){b.tab.setIconCls(a)},onItemTitleChange:function(a,b){a.tab.setText(b)},doRemove:function(d,b){var c=this,a;if(c.destroying||c.items.getCount()==1){c.activeTab=null}else{if((a=c.tabBar.items.indexOf(c.tabBar.findNextActivatable(d.tab)))!==-1){c.setActiveTab(a)}}this.callParent(arguments);delete d.tab.card;delete d.tab},onRemove:function(b,c){var a=this;b.un({scope:a,enable:a.onItemEnable,disable:a.onItemDisable,beforeshow:a.onItemBeforeShow});if(!a.destroying&&b.tab.ownerCt===a.tabBar){a.tabBar.remove(b.tab)}}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("MyDesktop.TabWindow",{extend:"Ext.ux.desktop.Module",requires:["Ext.tab.Panel"],id:"tab-win",init:function(){this.launcher={text:"Tab Window",iconCls:"tabs"}},createWindow:function(){var b=this.app.getDesktop();var a=b.getWindow("tab-win");if(!a){a=b.createWindow({id:"tab-win",title:"Tab Window",width:740,height:480,iconCls:"tabs",animCollapse:false,border:false,constrainHeader:true,layout:"fit",items:[{xtype:"tabpanel",activeTab:0,bodyStyle:"padding: 5px;",items:[{title:"Tab Text 1",header:false,html:"<p>Something useful would be in here.</p>",border:false},{title:"Tab Text 2",header:false,html:"<p>Something useful would be in here.</p>",border:false},{title:"Tab Text 3",header:false,html:"<p>Something useful would be in here.</p>",border:false},{title:"Tab Text 4",header:false,html:"<p>Something useful would be in here.</p>",border:false}]}]})}return a}});Ext.define("Ext.panel.Table",{extend:"Ext.panel.Panel",alias:"widget.tablepanel",uses:["Ext.selection.RowModel","Ext.selection.CellModel","Ext.selection.CheckboxModel","Ext.grid.PagingScroller","Ext.grid.header.Container","Ext.grid.Lockable"],extraBaseCls:Ext.baseCSSPrefix+"grid",extraBodyCls:Ext.baseCSSPrefix+"grid-body",layout:"fit",hasView:false,viewType:null,selType:"rowmodel",scroll:true,deferRowRender:true,sortableColumns:true,enableLocking:false,scrollerOwner:true,enableColumnMove:true,sealedColumns:false,enableColumnResize:true,enableColumnHide:true,rowLines:true,initComponent:function(){var g=this,j=g.scroll,b=false,a=false,f=g.columns||g.colModel,h,c=g.border,d,e;if(g.columnLines){g.addCls(Ext.baseCSSPrefix+"grid-with-col-lines")}if(g.rowLines){g.addCls(Ext.baseCSSPrefix+"grid-with-row-lines")}g.store=Ext.data.StoreManager.lookup(g.store||"ext-empty-store");if(f instanceof Ext.grid.header.Container){g.headerCt=f;g.headerCt.border=c;g.columns=g.headerCt.items.items}else{if(Ext.isArray(f)){f={items:f,border:c}}Ext.apply(f,{forceFit:g.forceFit,sortable:g.sortableColumns,enableColumnMove:g.enableColumnMove,enableColumnResize:g.enableColumnResize,enableColumnHide:g.enableColumnHide,border:c,sealed:g.sealedColumns});g.columns=f.items;if(g.enableLocking||Ext.ComponentQuery.query("{locked !== undefined}{processed != true}",g.columns).length){g.self.mixin("lockable",Ext.grid.Lockable);g.injectLockable()}}g.scrollTask=new Ext.util.DelayedTask(g.syncHorizontalScroll,g);g.addEvents("reconfigure","viewready");g.bodyCls=g.bodyCls||"";g.bodyCls+=(" "+g.extraBodyCls);g.cls=g.cls||"";g.cls+=(" "+g.extraBaseCls);delete g.autoScroll;if(!g.hasView){if(!g.headerCt){g.headerCt=new Ext.grid.header.Container(f)}g.columns=g.headerCt.items.items;if(g.store.buffered&&!g.store.remoteSort){for(d=0,e=g.columns.length;d<e;d++){g.columns[d].sortable=false}}if(g.hideHeaders){g.headerCt.height=0;g.headerCt.addCls(Ext.baseCSSPrefix+"grid-header-ct-hidden");g.addCls(Ext.baseCSSPrefix+"grid-header-hidden");if(Ext.isIEQuirks){g.headerCt.style={display:"none"}}}if(j===true||j==="both"){b=a=true}else{if(j==="horizontal"){a=true}else{if(j==="vertical"){b=true}}}g.relayHeaderCtEvents(g.headerCt);g.features=g.features||[];if(!Ext.isArray(g.features)){g.features=[g.features]}g.dockedItems=[].concat(g.dockedItems||[]);g.dockedItems.unshift(g.headerCt);g.viewConfig=g.viewConfig||{};if(g.store&&g.store.buffered){g.viewConfig.preserveScrollOnRefresh=true}else{if(g.invalidateScrollerOnRefresh!==undefined){g.viewConfig.preserveScrollOnRefresh=!g.invalidateScrollerOnRefresh}}h=g.getView();g.items=[h];g.hasView=true;if(b){if(g.store.buffered){g.verticalScroller=new Ext.grid.PagingScroller(Ext.apply({panel:g,store:g.store,view:g.view},g.verticalScroller))}}if(a){if(!g.hideHeaders){h.on({scroll:{fn:g.onHorizontalScroll,element:"el",scope:g}})}}g.mon(h.store,{load:g.onStoreLoad,scope:g});g.mon(h,{viewready:g.onViewReady,refresh:g.onRestoreHorzScroll,scope:g})}this.relayEvents(g.view,["beforeitemmousedown","beforeitemmouseup","beforeitemmouseenter","beforeitemmouseleave","beforeitemclick","beforeitemdblclick","beforeitemcontextmenu","itemmousedown","itemmouseup","itemmouseenter","itemmouseleave","itemclick","itemdblclick","itemcontextmenu","beforecontainermousedown","beforecontainermouseup","beforecontainermouseover","beforecontainermouseout","beforecontainerclick","beforecontainerdblclick","beforecontainercontextmenu","containermouseup","containermouseover","containermouseout","containerclick","containerdblclick","containercontextmenu","selectionchange","beforeselect","select","beforedeselect","deselect"]);g.callParent(arguments);g.addStateEvents(["columnresize","columnmove","columnhide","columnshow","sortchange"]);if(g.headerCt){g.headerCt.on("afterlayout",g.onRestoreHorzScroll,g)}},relayHeaderCtEvents:function(a){this.relayEvents(a,["columnresize","columnmove","columnhide","columnshow","sortchange"])},getState:function(){var a=this,b=a.callParent(),c=a.store.sorters.first();b=a.addPropertyToState(b,"columns",(a.headerCt||a).getColumnsState());if(c){b=a.addPropertyToState(b,"sort",{property:c.property,direction:c.direction,root:c.root})}return b},applyState:function(d){var c=this,e=d.sort,a=c.store,b=d.columns;delete d.columns;c.callParent(arguments);if(b){(c.headerCt||c).applyColumnsState(b)}if(e){if(a.remoteSort){a.sort({property:e.property,direction:e.direction,root:e.root},null,false)}else{a.sort(e.property,e.direction)}}},getStore:function(){return this.store},getView:function(){var a=this,b;if(!a.view){b=a.getSelectionModel();a.view=Ext.widget(Ext.apply({},a.viewConfig,{grid:a,deferInitialRefresh:a.deferRowRender!==false,scroll:a.scroll,xtype:a.viewType,store:a.store,headerCt:a.headerCt,selModel:b,features:a.features,panel:a,emptyText:a.emptyText?'<div class="'+Ext.baseCSSPrefix+'grid-empty">'+a.emptyText+"</div>":""}));a.view.getComponentLayout().headerCt=a.headerCt;a.mon(a.view,{uievent:a.processEvent,scope:a});b.view=a.view;a.headerCt.view=a.view;a.relayEvents(a.view,["cellclick","celldblclick"])}return a.view},setAutoScroll:Ext.emptyFn,processEvent:function(f,b,a,c,d,h){var g=this,i;if(d!==-1){i=g.headerCt.getGridColumns()[d];return i.processEvent.apply(i,arguments)}},determineScrollbars:function(){},invalidateScroller:function(){},scrollByDeltaY:function(b,a){this.getView().scrollBy(0,b,a)},scrollByDeltaX:function(b,a){this.getView().scrollBy(b,0,a)},afterCollapse:function(){var a=this;a.saveScrollPos();a.saveScrollPos();a.callParent(arguments)},afterExpand:function(){var a=this;a.callParent(arguments);a.restoreScrollPos();a.restoreScrollPos()},saveScrollPos:Ext.emptyFn,restoreScrollPos:Ext.emptyFn,onHeaderResize:function(){this.delayScroll()},onHeaderMove:function(e,f,a,b,d){var c=this;if(c.optimizedColumnMove===false){c.view.refresh()}else{c.view.moveColumn(b,d,a)}c.delayScroll()},onHeaderHide:function(a,b){this.delayScroll()},onHeaderShow:function(a,b){this.delayScroll()},delayScroll:function(){var a=this.getScrollTarget().el;if(a){this.scrollTask.delay(10,null,null,[a.dom.scrollLeft])}},onViewReady:function(){this.fireEvent("viewready",this)},onRestoreHorzScroll:function(){var a=this.scrollLeftPos;if(a){this.syncHorizontalScroll(a,true)}},getScrollerOwner:function(){var a=this;if(!this.scrollerOwner){a=this.up("[scrollerOwner]")}return a},getLhsMarker:function(){var a=this;return a.lhsMarker||(a.lhsMarker=Ext.DomHelper.append(a.el,{cls:Ext.baseCSSPrefix+"grid-resize-marker"},true))},getRhsMarker:function(){var a=this;return a.rhsMarker||(a.rhsMarker=Ext.DomHelper.append(a.el,{cls:Ext.baseCSSPrefix+"grid-resize-marker"},true))},getSelectionModel:function(){if(!this.selModel){this.selModel={}}var b="SINGLE",a;if(this.simpleSelect){b="SIMPLE"}else{if(this.multiSelect){b="MULTI"}}Ext.applyIf(this.selModel,{allowDeselect:this.allowDeselect,mode:b});if(!this.selModel.events){a=this.selModel.selType||this.selType;this.selModel=Ext.create("selection."+a,this.selModel)}if(!this.selModel.hasRelaySetup){this.relayEvents(this.selModel,["selectionchange","beforeselect","beforedeselect","select","deselect"]);this.selModel.hasRelaySetup=true}if(this.disableSelection){this.selModel.locked=true}return this.selModel},getScrollTarget:function(){var a=this.getScrollerOwner(),b=a.query("tableview");return b[1]||b[0]},onHorizontalScroll:function(a,b){this.syncHorizontalScroll(b.scrollLeft)},syncHorizontalScroll:function(d,b){var c=this,a;b=b===true;if(c.rendered&&(b||d!==c.scrollLeftPos)){if(b){a=c.getScrollTarget();a.el.dom.scrollLeft=d}c.headerCt.el.dom.scrollLeft=d;c.scrollLeftPos=d}},onStoreLoad:Ext.emptyFn,getEditorParent:function(){return this.body},bindStore:function(a){var b=this;b.store=a;b.getView().bindStore(a)},beforeDestroy:function(){Ext.destroy(this.verticalScroller);this.callParent()},reconfigure:function(a,b){var c=this,d=c.headerCt;if(c.lockable){c.reconfigureLockable(a,b)}else{Ext.suspendLayouts();if(b){delete c.scrollLeftPos;d.removeAll();d.add(b)}if(a){a=Ext.StoreManager.lookup(a);c.bindStore(a)}else{c.getView().refresh()}d.setSortState();Ext.resumeLayouts(true)}c.fireEvent("reconfigure",c,a,b)}});Ext.define("Ext.grid.Panel",{extend:"Ext.panel.Table",requires:["Ext.grid.View"],alias:["widget.gridpanel","widget.grid"],alternateClassName:["Ext.list.ListView","Ext.ListView","Ext.grid.GridPanel"],viewType:"gridview",lockable:false,bothCfgCopy:["invalidateScrollerOnRefresh","hideHeaders","enableColumnHide","enableColumnMove","enableColumnResize","sortableColumns"],normalCfgCopy:["verticalScroller","verticalScrollDock","verticalScrollerType","scroll"],lockedCfgCopy:[],rowLines:true});Ext.define("Ext.tip.Tip",{extend:"Ext.panel.Panel",alternateClassName:"Ext.Tip",minWidth:40,maxWidth:300,shadow:"sides",defaultAlign:"tl-bl?",constrainPosition:true,autoRender:true,hidden:true,baseCls:Ext.baseCSSPrefix+"tip",floating:{shadow:true,shim:true,constrain:true},focusOnToFront:false,closeAction:"hide",ariaRole:"tooltip",alwaysFramed:true,frameHeader:false,initComponent:function(){var a=this;a.floating=Ext.apply({},{shadow:a.shadow},a.self.prototype.floating);a.callParent(arguments);a.constrain=a.constrain||a.constrainPosition},showAt:function(b){var a=this;this.callParent(arguments);if(a.isVisible()){a.setPagePosition(b[0],b[1]);if(a.constrainPosition||a.constrain){a.doConstrain()}a.toFront(true)}},showBy:function(a,b){this.showAt(this.el.getAlignToXY(a,b||this.defaultAlign))},initDraggable:function(){var a=this;a.draggable={el:a.getDragEl(),delegate:a.header.el,constrain:a,constrainTo:a.el.getScopeParent()};Ext.Component.prototype.initDraggable.call(a)},ghost:undefined,unghost:undefined});Ext.define("Ext.tip.ToolTip",{extend:"Ext.tip.Tip",alias:"widget.tooltip",alternateClassName:"Ext.ToolTip",autoHide:true,showDelay:500,hideDelay:200,dismissDelay:5000,trackMouse:false,anchorToTarget:true,anchorOffset:0,targetCounter:0,quickShowInterval:250,initComponent:function(){var a=this;a.callParent(arguments);a.lastActive=new Date();a.setTarget(a.target);a.origAnchor=a.anchor},onRender:function(b,a){var c=this;c.callParent(arguments);c.anchorCls=Ext.baseCSSPrefix+"tip-anchor-"+c.getAnchorPosition();c.anchorEl=c.el.createChild({cls:Ext.baseCSSPrefix+"tip-anchor "+c.anchorCls})},setTarget:function(d){var b=this,a=Ext.get(d),c;if(b.target){c=Ext.get(b.target);b.mun(c,"mouseover",b.onTargetOver,b);b.mun(c,"mouseout",b.onTargetOut,b);b.mun(c,"mousemove",b.onMouseMove,b)}b.target=a;if(a){b.mon(a,{freezeEvent:true,mouseover:b.onTargetOver,mouseout:b.onTargetOut,mousemove:b.onMouseMove,scope:b})}if(b.anchor){b.anchorTarget=b.target}},onMouseMove:function(d){var b=this,a=b.delegate?d.getTarget(b.delegate):b.triggerElement=true,c;if(a){b.targetXY=d.getXY();if(a===b.triggerElement){if(!b.hidden&&b.trackMouse){c=b.getTargetXY();if(b.constrainPosition){c=b.el.adjustForConstraints(c,b.el.getScopeParent())}b.setPagePosition(c)}}else{b.hide();b.lastActive=new Date(0);b.onTargetOver(d)}}else{if((!b.closable&&b.isVisible())&&b.autoHide!==false){b.hide()}}},getTargetXY:function(){var i=this,d,c,m,a,h,k,e,l,j,b,g,f;if(i.delegate){i.anchorTarget=i.triggerElement}if(i.anchor){i.targetCounter++;c=i.getOffsets();m=(i.anchorToTarget&&!i.trackMouse)?i.el.getAlignToXY(i.anchorTarget,i.getAnchorAlign()):i.targetXY;a=Ext.Element.getViewWidth()-5;h=Ext.Element.getViewHeight()-5;k=document.documentElement;e=document.body;l=(k.scrollLeft||e.scrollLeft||0)+5;j=(k.scrollTop||e.scrollTop||0)+5;b=[m[0]+c[0],m[1]+c[1]];g=i.getSize();f=i.constrainPosition;i.anchorEl.removeCls(i.anchorCls);if(i.targetCounter<2&&f){if(b[0]<l){if(i.anchorToTarget){i.defaultAlign="l-r";if(i.mouseOffset){i.mouseOffset[0]*=-1}}i.anchor="left";return i.getTargetXY()}if(b[0]+g.width>a){if(i.anchorToTarget){i.defaultAlign="r-l";if(i.mouseOffset){i.mouseOffset[0]*=-1}}i.anchor="right";return i.getTargetXY()}if(b[1]<j){if(i.anchorToTarget){i.defaultAlign="t-b";if(i.mouseOffset){i.mouseOffset[1]*=-1}}i.anchor="top";return i.getTargetXY()}if(b[1]+g.height>h){if(i.anchorToTarget){i.defaultAlign="b-t";if(i.mouseOffset){i.mouseOffset[1]*=-1}}i.anchor="bottom";return i.getTargetXY()}}i.anchorCls=Ext.baseCSSPrefix+"tip-anchor-"+i.getAnchorPosition();i.anchorEl.addCls(i.anchorCls);i.targetCounter=0;return b}else{d=i.getMouseOffset();return(i.targetXY)?[i.targetXY[0]+d[0],i.targetXY[1]+d[1]]:d}},getMouseOffset:function(){var a=this,b=a.anchor?[0,0]:[15,18];if(a.mouseOffset){b[0]+=a.mouseOffset[0];b[1]+=a.mouseOffset[1]}return b},getAnchorPosition:function(){var b=this,a;if(b.anchor){b.tipAnchor=b.anchor.charAt(0)}else{a=b.defaultAlign.match(/^([a-z]+)-([a-z]+)(\?)?$/);b.tipAnchor=a[1].charAt(0)}switch(b.tipAnchor){case"t":return"top";case"b":return"bottom";case"r":return"right"}return"left"},getAnchorAlign:function(){switch(this.anchor){case"top":return"tl-bl";case"left":return"tl-tr";case"right":return"tr-tl";default:return"bl-tl"}},getOffsets:function(){var c=this,d,b,a=c.getAnchorPosition().charAt(0);if(c.anchorToTarget&&!c.trackMouse){switch(a){case"t":b=[0,9];break;case"b":b=[0,-13];break;case"r":b=[-13,0];break;default:b=[9,0];break}}else{switch(a){case"t":b=[-15-c.anchorOffset,30];break;case"b":b=[-19-c.anchorOffset,-13-c.el.dom.offsetHeight];break;case"r":b=[-15-c.el.dom.offsetWidth,-13-c.anchorOffset];break;default:b=[25,-13-c.anchorOffset];break}}d=c.getMouseOffset();b[0]+=d[0];b[1]+=d[1];return b},onTargetOver:function(c){var b=this,a;if(b.disabled||c.within(b.target.dom,true)){return}a=c.getTarget(b.delegate);if(a){b.triggerElement=a;b.clearTimer("hide");b.targetXY=c.getXY();b.delayShow()}},delayShow:function(){var a=this;if(a.hidden&&!a.showTimer){if(Ext.Date.getElapsed(a.lastActive)<a.quickShowInterval){a.show()}else{a.showTimer=Ext.defer(a.show,a.showDelay,a)}}else{if(!a.hidden&&a.autoHide!==false){a.show()}}},onShowVeto:function(){this.callParent();this.clearTimer("show")},onTargetOut:function(b){var a=this;if(a.disabled||b.within(a.target.dom,true)){return}a.clearTimer("show");if(a.autoHide!==false){a.delayHide()}},delayHide:function(){var a=this;if(!a.hidden&&!a.hideTimer){a.hideTimer=Ext.defer(a.hide,a.hideDelay,a)}},hide:function(){var a=this;a.clearTimer("dismiss");a.lastActive=new Date();if(a.anchorEl){a.anchorEl.hide()}a.callParent(arguments);delete a.triggerElement},show:function(){var a=this;this.callParent();if(this.hidden===false){a.setPagePosition(-10000,-10000);if(a.anchor){a.anchor=a.origAnchor}if(!a.calledFromShowAt){a.showAt(a.getTargetXY())}if(a.anchor){a.syncAnchor();a.anchorEl.show()}else{a.anchorEl.hide()}}},showAt:function(b){var a=this;a.lastActive=new Date();a.clearTimers();a.calledFromShowAt=true;if(!a.isVisible()){this.callParent(arguments)}if(a.isVisible()){a.setPagePosition(b[0],b[1]);if(a.constrainPosition||a.constrain){a.doConstrain()}a.toFront(true);a.el.sync(true);if(a.dismissDelay&&a.autoHide!==false){a.dismissTimer=Ext.defer(a.hide,a.dismissDelay,a)}if(a.anchor){a.syncAnchor();if(!a.anchorEl.isVisible()){a.anchorEl.show()}}else{a.anchorEl.hide()}}delete a.calledFromShowAt},syncAnchor:function(){var c=this,a,b,d;switch(c.tipAnchor.charAt(0)){case"t":a="b";b="tl";d=[20+c.anchorOffset,1];break;case"r":a="l";b="tr";d=[-1,12+c.anchorOffset];break;case"b":a="t";b="bl";d=[20+c.anchorOffset,-1];break;default:a="r";b="tl";d=[1,12+c.anchorOffset];break}c.anchorEl.alignTo(c.el,a+"-"+b,d);c.anchorEl.setStyle("z-index",parseInt(c.el.getZIndex(),10)||0+1).setVisibilityMode(Ext.Element.DISPLAY)},setPagePosition:function(a,c){var b=this;b.callParent(arguments);if(b.anchor){b.syncAnchor()}},clearTimer:function(a){a=a+"Timer";clearTimeout(this[a]);delete this[a]},clearTimers:function(){var a=this;a.clearTimer("show");a.clearTimer("dismiss");a.clearTimer("hide")},onShow:function(){var a=this;a.callParent();a.mon(Ext.getDoc(),"mousedown",a.onDocMouseDown,a)},onHide:function(){var a=this;a.callParent();a.mun(Ext.getDoc(),"mousedown",a.onDocMouseDown,a)},onDocMouseDown:function(b){var a=this;if(!a.closable&&!b.within(a.el.dom)){a.disable();Ext.defer(a.doEnable,100,a)}},doEnable:function(){if(!this.isDestroyed){this.enable()}},onDisable:function(){this.callParent();this.clearTimers();this.hide()},beforeDestroy:function(){var a=this;a.clearTimers();Ext.destroy(a.anchorEl);delete a.anchorEl;delete a.target;delete a.anchorTarget;delete a.triggerElement;a.callParent()},onDestroy:function(){Ext.getDoc().un("mousedown",this.onDocMouseDown,this);this.callParent()}});Ext.define("Ext.chart.Tip",{requires:["Ext.tip.ToolTip","Ext.chart.TipSurface"],constructor:function(b){var c=this,a,d,e;if(b.tips){c.tipTimeout=null;c.tipConfig=Ext.apply({},b.tips,{renderer:Ext.emptyFn,constrainPosition:true,autoHide:true});c.tooltip=new Ext.tip.ToolTip(c.tipConfig);c.chart.surface.on("mousemove",c.tooltip.onMouseMove,c.tooltip);c.chart.surface.on("mouseleave",function(){c.hideTip()});if(c.tipConfig.surface){a=c.tipConfig.surface;d=a.sprites;e=new Ext.chart.TipSurface({id:"tipSurfaceComponent",sprites:d});if(a.width&&a.height){e.setSize(a.width,a.height)}c.tooltip.add(e);c.spriteTip=e}}},showTip:function(k){var e=this,l,a,c,d,j,b,i,g,h,f;if(!e.tooltip){return}clearTimeout(e.tipTimeout);l=e.tooltip;a=e.spriteTip;c=e.tipConfig;d=l.trackMouse;if(!d){l.trackMouse=true;j=k.sprite;b=j.surface;i=Ext.get(b.getId());if(i){g=i.getXY();h=g[0]+(j.attr.x||0)+(j.attr.translation&&j.attr.translation.x||0);f=g[1]+(j.attr.y||0)+(j.attr.translation&&j.attr.translation.y||0);l.targetXY=[h,f]}}if(a){c.renderer.call(l,k.storeItem,k,a.surface)}else{c.renderer.call(l,k.storeItem,k)}l.show();l.trackMouse=d},hideTip:function(a){var b=this.tooltip;if(!b){return}clearTimeout(this.tipTimeout);this.tipTimeout=setTimeout(function(){b.hide()},0)}});Ext.define("Ext.chart.series.Series",{mixins:{observable:"Ext.util.Observable",labels:"Ext.chart.Label",highlights:"Ext.chart.Highlight",tips:"Ext.chart.Tip",callouts:"Ext.chart.Callout"},type:null,title:null,showInLegend:true,renderer:function(e,a,c,d,b){return c},shadowAttributes:null,animating:false,constructor:function(a){var b=this;if(a){Ext.apply(b,a)}b.shadowGroups=[];b.mixins.labels.constructor.call(b,a);b.mixins.highlights.constructor.call(b,a);b.mixins.tips.constructor.call(b,a);b.mixins.callouts.constructor.call(b,a);b.addEvents({scope:b,itemmouseover:true,itemmouseout:true,itemmousedown:true,itemmouseup:true,mouseleave:true,afterdraw:true,titlechange:true});b.mixins.observable.constructor.call(b,a);b.on({scope:b,itemmouseover:b.onItemMouseOver,itemmouseout:b.onItemMouseOut,mouseleave:b.onMouseLeave});if(b.style){Ext.apply(b.seriesStyle,b.style)}},eachRecord:function(c,b){var a=this.chart;(a.substore||a.store).each(c,b)},getRecordCount:function(){var b=this.chart,a=b.substore||b.store;return a?a.getCount():0},isExcluded:function(a){var b=this.__excludes;return !!(b&&b[a])},setBBox:function(a){var e=this,c=e.chart,b=c.chartBBox,f=a?0:c.maxGutter[0],d=a?0:c.maxGutter[1],g,h;g={x:b.x,y:b.y,width:b.width,height:b.height};e.clipBox=g;h={x:(g.x+f)-(c.zoom.x*c.zoom.width),y:(g.y+d)-(c.zoom.y*c.zoom.height),width:(g.width-(f*2))*c.zoom.width,height:(g.height-(d*2))*c.zoom.height};e.bbox=h},onAnimate:function(b,a){var c=this;b.stopAnimation();if(c.animating){return b.animate(Ext.applyIf(a,c.chart.animate))}else{c.animating=true;return b.animate(Ext.apply(Ext.applyIf(a,c.chart.animate),{listeners:{afteranimate:function(){c.animating=false;c.fireEvent("afterrender")}}}))}},getGutters:function(){return[0,0]},onItemMouseOver:function(b){var a=this;if(b.series===a){if(a.highlight){a.highlightItem(b)}if(a.tooltip){a.showTip(b)}}},onItemMouseOut:function(b){var a=this;if(b.series===a){a.unHighlightItem();if(a.tooltip){a.hideTip(b)}}},onMouseLeave:function(){var a=this;a.unHighlightItem();if(a.tooltip){a.hideTip()}},getItemForPoint:function(a,h){if(!this.items||!this.items.length||this.seriesIsHidden){return null}var f=this,b=f.items,g=f.bbox,e,c,d;if(!Ext.draw.Draw.withinBox(a,h,g)){return null}for(c=0,d=b.length;c<d;c++){if(b[c]&&this.isItemInPoint(a,h,b[c],c)){return b[c]}}return null},isItemInPoint:function(a,d,c,b){return false},hideAll:function(){var g=this,f=g.items,k,e,d,c,a,h,b;g.seriesIsHidden=true;g._prevShowMarkers=g.showMarkers;g.showMarkers=false;g.hideLabels(0);for(d=0,e=f.length;d<e;d++){k=f[d];h=k.sprite;if(h){h.setAttributes({hidden:true},true)}if(h&&h.shadows){b=h.shadows;for(c=0,a=b.length;c<a;++c){b[c].setAttributes({hidden:true},true)}}}},showAll:function(){var a=this,b=a.chart.animate;a.chart.animate=false;a.seriesIsHidden=false;a.showMarkers=a._prevShowMarkers;a.drawSeries();a.chart.animate=b},hide:function(){if(this.items){var g=this,b=g.items,d,c,a,f,e;if(b&&b.length){for(d=0,f=b.length;d<f;++d){if(b[d].sprite){b[d].sprite.hide(true);e=b[d].shadows||b[d].sprite.shadows;if(e){for(c=0,a=e.length;c<a;++c){e[c].hide(true)}}}}g.hideLabels()}}},getLegendColor:function(a){var b=this,d,c;if(b.seriesStyle){d=b.seriesStyle.fill;c=b.seriesStyle.stroke;if(d&&d!="none"){return d}if(c){return c}}return(b.colorArrayStyle)?b.colorArrayStyle[b.seriesIdx%b.colorArrayStyle.length]:"#000"},visibleInLegend:function(a){var b=this.__excludes;if(b){return !b[a]}return !this.seriesIsHidden},setTitle:function(a,d){var c=this,b=c.title;if(Ext.isString(a)){d=a;a=0}if(Ext.isArray(b)){b[a]=d}else{c.title=d}c.fireEvent("titlechange",d,a)}});Ext.define("Ext.chart.series.Cartesian",{extend:"Ext.chart.series.Series",alternateClassName:["Ext.chart.CartesianSeries","Ext.chart.CartesianChart"],xField:null,yField:null,axis:"left",getLegendLabels:function(){var h=this,e=[],f,d,g,j=h.combinations,k,a,c,b;f=[].concat(h.yField);for(d=0,g=f.length;d<g;d++){k=h.title;e.push((Ext.isArray(k)?k[d]:k)||f[d])}if(j){j=Ext.Array.from(j);for(d=0,g=j.length;d<g;d++){a=j[d];c=e[a[0]];b=e[a[1]];e[a[1]]=c+" & "+b;e.splice(a[0],1)}}return e},eachYValue:function(b,e,d){var h=this,g=h.getYValueAccessors(),c,f,a;for(c=0,f=g.length;c<f;c++){a=g[c];e.call(d,a(b),c)}},getYValueCount:function(){return this.getYValueAccessors().length},combine:function(f,e){var d=this,c=d.getYValueAccessors(),b=c[f],a=c[e];c[e]=function(g){return b(g)+a(g)};c.splice(f,1);d.callParent([f,e])},clearCombinations:function(){delete this.yValueAccessors;this.callParent()},getYValueAccessors:function(){var e=this,a=e.yValueAccessors,f,c,b,d;if(!a){a=e.yValueAccessors=[];f=[].concat(e.yField);for(b=0,d=f.length;b<d;b++){c=f[b];a.push(function(g){return g.get(c)})}}return a},getMinMaxXValues:function(){var j=this,h=j.chart,l=h.getChartStore(),d=l.data.items,e,g,f,c,k,a=j.xField,b;if(j.getRecordCount()>0){c=Infinity;k=-c;for(e=0,g=d.length;e<g;e++){f=d[e];b=f.get(a);if(b>k){k=b}if(b<c){c=b}}}else{c=k=0}return[c,k]},getMinMaxYValues:function(){var j=this,h=j.chart,n=h.getChartStore(),c=n.data.items,d,g,e,f=j.stacked,b,k,m,l;function a(q,p){if(!j.isExcluded(p)){if(q<0){l+=q}else{m+=q}}}function o(q,p){if(!j.isExcluded(p)){if(q>k){k=q}if(q<b){b=q}}}if(j.getRecordCount()>0){b=Infinity;k=-b;for(d=0,g=c.length;d<g;d++){e=c[d];if(f){m=0;l=0;j.eachYValue(e,a);if(m>k){k=m}if(l<b){b=l}}else{j.eachYValue(e,o)}}}else{b=k=0}return[b,k]},getAxesForXAndYFields:function(){var l=this,k=l.chart.axes,d=[].concat(l.axis),c={},e=[].concat(l.yField),m={},n=[].concat(l.xField),h,b,a,g,j,f;f=l.type==="bar"&&l.column===false;if(f){h=e;e=n;n=h}if(Ext.Array.indexOf(d,"top")>-1){b="top"}else{if(Ext.Array.indexOf(d,"bottom")>-1){b="bottom"}else{if(k.get("top")&&k.get("bottom")){for(g=0,j=n.length;g<j;g++){m[n[g]]=true}h=[].concat(k.get("bottom").fields);for(g=0,j=h.length;g<j;g++){if(m[h[g]]){b="bottom";break}}h=[].concat(k.get("top").fields);for(g=0,j=h.length;g<j;g++){if(m[h[g]]){b="top";break}}}else{if(k.get("top")){b="top"}else{if(k.get("bottom")){b="bottom"}}}}}if(Ext.Array.indexOf(d,"left")>-1){a="left"}else{if(Ext.Array.indexOf(d,"right")>-1){a="right"}else{if(k.get("left")&&k.get("right")){for(g=0,j=e.length;g<j;g++){c[e[g]]=true}h=[].concat(k.get("right").fields);for(g=0,j=h.length;g<j;g++){if(c[h[g]]){break}}h=[].concat(k.get("left").fields);for(g=0,j=h.length;g<j;g++){if(c[h[g]]){a="left";break}}}else{if(k.get("left")){a="left"}else{if(k.get("right")){a="right"}}}}}return f?{xAxis:a,yAxis:b}:{xAxis:b,yAxis:a}}});Ext.define("Ext.chart.series.Area",{extend:"Ext.chart.series.Cartesian",alias:"series.area",requires:["Ext.chart.axis.Axis","Ext.draw.Color","Ext.fx.Anim"],type:"area",stacked:true,style:{},constructor:function(c){this.callParent(arguments);var e=this,a=e.chart.surface,d,b;c.highlightCfg=Ext.Object.merge({},{lineWidth:3,stroke:"#55c",opacity:0.8,color:"#f00"},c.highlightCfg);Ext.apply(e,c,{__excludes:[]});if(e.highlight){e.highlightSprite=a.add({type:"path",path:["M",0,0],zIndex:1000,opacity:0.3,lineWidth:5,hidden:true,stroke:"#444"})}e.group=a.getGroup(e.seriesId)},shrink:function(b,m,n){var h=b.length,l=Math.floor(h/n),g,f,d=0,k=this.areas.length,a=[],e=[],c=[];for(f=0;f<k;++f){a[f]=0}for(g=0;g<h;++g){d+=+b[g];for(f=0;f<k;++f){a[f]+=+m[g][f]}if(g%l==0){e.push(d/l);for(f=0;f<k;++f){a[f]/=l}c.push(a);d=0;for(f=0,a=[];f<k;++f){a[f]=0}}}return{x:e,y:c}},getBounds:function(){var h=this,L=h.chart,a=L.getChartStore(),K=a.data.items,H,E,w,u=[].concat(h.yField),z=u.length,y=[],C=[],f=Infinity,B=f,A=f,m=-f,k=-f,r=Math,v=r.min,e=r.max,o=h.getAxesForXAndYFields(),I=o.xAxis,t=o.yAxis,F,q,j,g,D,p,M,J,b,s,G,c,d,n,x;h.setBBox();j=h.bbox;if(n=L.axes.get(I)){if(n.type==="Time"){q=true}F=n.applyData();B=F.from;m=F.to}if(n=L.axes.get(t)){F=n.applyData();A=F.from;k=F.to}if(h.xField&&!Ext.isNumber(B)){n=h.getMinMaxXValues();q=true;B=n[0];m=n[1]}if(h.yField&&!Ext.isNumber(A)){n=h.getMinMaxYValues();A=n[0];k=n[1]}if(!Ext.isNumber(A)){A=0}if(!Ext.isNumber(k)){k=0}for(H=0,E=K.length;H<E;H++){w=K[H];p=w.get(h.xField);M=[];if(typeof p!="number"){if(q){p=+p}else{p=H}}y.push(p);b=0;for(J=0;J<z;J++){if(h.__excludes[J]){continue}d=w.get(u[J]);if(typeof d=="number"){M.push(d)}}C.push(M)}g=j.width/((m-B)||1);D=j.height/((k-A)||1);s=y.length;if((s>j.width)&&h.areas){G=h.shrink(y,C,j.width);y=G.x;C=G.y}return{bbox:j,minX:B,minY:A,xValues:y,yValues:C,xScale:g,yScale:D,areasLen:z}},getPaths:function(){var v=this,l=v.chart,c=l.getChartStore(),e=true,f=v.getBounds(),a=f.bbox,m=v.items=[],u=[],b,d=0,o=[],r,h,j,g,p,s,k,w,q,t,n;h=f.xValues.length;for(r=0;r<h;r++){p=f.xValues[r];s=f.yValues[r];j=a.x+(p-f.minX)*f.xScale;k=0;d=0;for(w=0;w<f.areasLen;w++){if(v.__excludes[w]){continue}if(!u[w]){u[w]=[]}t=s[d];k+=t;g=a.y+a.height-(k-f.minY)*f.yScale;if(!o[w]){o[w]=["M",j,g];u[w].push(["L",j,g])}else{o[w].push("L",j,g);u[w].push(["L",j,g])}if(!m[w]){m[w]={pointsUp:[],pointsDown:[],series:v}}m[w].pointsUp.push([j,g]);d++}}for(w=0;w<f.areasLen;w++){if(v.__excludes[w]){continue}n=o[w];if(w==0||e){e=false;n.push("L",j,a.y+a.height,"L",a.x,a.y+a.height,"Z")}else{b=u[q];b.reverse();n.push("L",j,b[0][2]);for(r=0;r<h;r++){n.push(b[r][0],b[r][1],b[r][2]);m[w].pointsDown[h-r-1]=[b[r][1],b[r][2]]}n.push("L",a.x,n[2],"Z")}q=w}return{paths:o,areasLen:f.areasLen}},drawSeries:function(){var g=this,f=g.chart,h=f.getChartStore(),c=f.surface,b=f.animate,j=g.group,a=Ext.apply(g.seriesStyle,g.style),k=g.colorArrayStyle,n=k&&k.length||0,d,e,m,l,i;g.unHighlightItem();g.cleanHighlights();if(!h||!h.getCount()||g.seriesIsHidden){g.hide();g.items=[];return}m=g.getPaths();if(!g.areas){g.areas=[]}for(d=0;d<m.areasLen;d++){if(g.__excludes[d]){continue}if(!g.areas[d]){g.items[d].sprite=g.areas[d]=c.add(Ext.apply({},{type:"path",group:j,path:m.paths[d],stroke:a.stroke||k[d%n],fill:k[d%n]},a||{}))}e=g.areas[d];l=m.paths[d];if(b){i=g.renderer(e,false,{path:l,fill:k[d%n],stroke:a.stroke||k[d%n]},d,h);g.animation=g.onAnimate(e,{to:i})}else{i=g.renderer(e,false,{path:l,hidden:false,fill:k[d%n],stroke:a.stroke||k[d%n]},d,h);g.areas[d].setAttributes(i,true)}}g.renderLabels();g.renderCallouts()},onAnimate:function(b,a){b.show();return this.callParent(arguments)},onCreateLabel:function(d,j,c,e){var f=this,g=f.labelsGroup,a=f.label,h=f.bbox,b=Ext.apply(a,f.seriesLabelStyle);return f.chart.surface.add(Ext.apply({type:"text","text-anchor":"middle",group:g,x:j.point[0],y:h.y+h.height/2},b||{}))},onPlaceLabel:function(f,j,r,o,n,c,e){var t=this,k=t.chart,q=k.resizing,s=t.label,p=s.renderer,b=s.field,a=t.bbox,h=r.point[0],g=r.point[1],d,m,l;f.setAttributes({text:p(j.get(b[e])),hidden:true},true);d=f.getBBox();m=d.width/2;l=d.height/2;h=h-m<a.x?a.x+m:h;h=(h+m>a.x+a.width)?(h-(h+m-a.x-a.width)):h;g=g-l<a.y?a.y+l:g;g=(g+l>a.y+a.height)?(g-(g+l-a.y-a.height)):g;if(t.chart.animate&&!t.chart.resizing){f.show(true);t.onAnimate(f,{to:{x:h,y:g}})}else{f.setAttributes({x:h,y:g},true);if(q){t.animation.on("afteranimate",function(){f.show(true)})}else{f.show(true)}}},onPlaceCallout:function(l,q,I,F,E,d,j){var L=this,r=L.chart,C=r.surface,G=r.resizing,K=L.callouts,s=L.items,u=(F==0)?false:s[F-1].point,w=(F==s.length-1)?false:s[F+1].point,c=I.point,z,f,M,J,n,o,b=l.label.getBBox(),H=30,B=10,A=3,g,e,h,v,t,D=L.clipRect,m,k;if(!u){u=c}if(!w){w=c}J=(w[1]-u[1])/(w[0]-u[0]);n=(c[1]-u[1])/(c[0]-u[0]);o=(w[1]-c[1])/(w[0]-c[0]);f=Math.sqrt(1+J*J);z=[1/f,J/f];M=[-z[1],z[0]];if(n>0&&o<0&&M[1]<0||n<0&&o>0&&M[1]>0){M[0]*=-1;M[1]*=-1}else{if(Math.abs(n)<Math.abs(o)&&M[0]<0||Math.abs(n)>Math.abs(o)&&M[0]>0){M[0]*=-1;M[1]*=-1}}m=c[0]+M[0]*H;k=c[1]+M[1]*H;g=m+(M[0]>0?0:-(b.width+2*A));e=k-b.height/2-A;h=b.width+2*A;v=b.height+2*A;if(g<D[0]||(g+h)>(D[0]+D[2])){M[0]*=-1}if(e<D[1]||(e+v)>(D[1]+D[3])){M[1]*=-1}m=c[0]+M[0]*H;k=c[1]+M[1]*H;g=m+(M[0]>0?0:-(b.width+2*A));e=k-b.height/2-A;h=b.width+2*A;v=b.height+2*A;l.lines.setAttributes({path:["M",c[0],c[1],"L",m,k,"Z"]},true);l.box.setAttributes({x:g,y:e,width:h,height:v},true);l.label.setAttributes({x:m+(M[0]>0?A:-(b.width+A)),y:k},true);for(t in l){l[t].show(true)}},isItemInPoint:function(h,g,l,c){var f=this,b=l.pointsUp,d=l.pointsDown,o=Math.abs,n=false,k=false,e=Infinity,a,m,j;for(a=0,m=b.length;a<m;a++){j=[b[a][0],b[a][1]];n=false;k=a==m-1;if(e>o(h-j[0])){e=o(h-j[0]);n=true;if(k){++a}}if(!n||(n&&k)){j=b[a-1];if(g>=j[1]&&(!d.length||g<=(d[a-1][1]))){l.storeIndex=a-1;l.storeField=f.yField[c];l.storeItem=f.chart.store.getAt(a-1);l._points=d.length?[j,d[a-1]]:[j];return true}else{break}}}return false},highlightSeries:function(){var a,c,b;if(this._index!==undefined){a=this.areas[this._index];if(a.__highlightAnim){a.__highlightAnim.paused=true}a.__highlighted=true;a.__prevOpacity=a.__prevOpacity||a.attr.opacity||1;a.__prevFill=a.__prevFill||a.attr.fill;a.__prevLineWidth=a.__prevLineWidth||a.attr.lineWidth;b=Ext.draw.Color.fromString(a.__prevFill);c={lineWidth:(a.__prevLineWidth||0)+2};if(b){c.fill=b.getLighter(0.2).toString()}else{c.opacity=Math.max(a.__prevOpacity-0.3,0)}if(this.chart.animate){a.__highlightAnim=new Ext.fx.Anim(Ext.apply({target:a,to:c},this.chart.animate))}else{a.setAttributes(c,true)}}},unHighlightSeries:function(){var a;if(this._index!==undefined){a=this.areas[this._index];if(a.__highlightAnim){a.__highlightAnim.paused=true}if(a.__highlighted){a.__highlighted=false;a.__highlightAnim=new Ext.fx.Anim({target:a,to:{fill:a.__prevFill,opacity:a.__prevOpacity,lineWidth:a.__prevLineWidth}})}}},highlightItem:function(c){var b=this,a,d;if(!c){this.highlightSeries();return}a=c._points;d=a.length==2?["M",a[0][0],a[0][1],"L",a[1][0],a[1][1]]:["M",a[0][0],a[0][1],"L",a[0][0],b.bbox.y+b.bbox.height];b.highlightSprite.setAttributes({path:d,hidden:false},true)},unHighlightItem:function(a){if(!a){this.unHighlightSeries()}if(this.highlightSprite){this.highlightSprite.hide(true)}},hideAll:function(a){var b=this;a=(isNaN(b._index)?a:b._index)||0;b.__excludes[a]=true;b.areas[a].hide(true);b.redraw()},showAll:function(a){var b=this;a=(isNaN(b._index)?a:b._index)||0;b.__excludes[a]=false;b.areas[a].show(true);b.redraw()},redraw:function(){var a=this,b;b=a.chart.legend.rebuild;a.chart.legend.rebuild=false;a.chart.redraw();a.chart.legend.rebuild=b},hide:function(){if(this.areas){var g=this,b=g.areas,d,c,a,f,e;if(b&&b.length){for(d=0,f=b.length;d<f;++d){if(b[d]){b[d].hide(true)}}g.hideLabels()}}},getLegendColor:function(a){var b=this;return b.colorArrayStyle[a%b.colorArrayStyle.length]}});Ext.define("Ext.chart.series.Bar",{extend:"Ext.chart.series.Cartesian",alternateClassName:["Ext.chart.BarSeries","Ext.chart.BarChart","Ext.chart.StackedBarChart"],requires:["Ext.chart.axis.Axis","Ext.fx.Anim"],type:"bar",alias:"series.bar",column:false,style:{},gutter:38.2,groupGutter:38.2,xPadding:0,yPadding:10,constructor:function(c){this.callParent(arguments);var e=this,a=e.chart.surface,f=e.chart.shadow,d,b;c.highlightCfg=Ext.Object.merge({lineWidth:3,stroke:"#55c",opacity:0.8,color:"#f00"},c.highlightCfg);Ext.apply(e,c,{shadowAttributes:[{"stroke-width":6,"stroke-opacity":0.05,stroke:"rgb(200, 200, 200)",translate:{x:1.2,y:1.2}},{"stroke-width":4,"stroke-opacity":0.1,stroke:"rgb(150, 150, 150)",translate:{x:0.9,y:0.9}},{"stroke-width":2,"stroke-opacity":0.15,stroke:"rgb(100, 100, 100)",translate:{x:0.6,y:0.6}}]});e.group=a.getGroup(e.seriesId+"-bars");if(f){for(d=0,b=e.shadowAttributes.length;d<b;d++){e.shadowGroups.push(a.getGroup(e.seriesId+"-shadows"+d))}}},getBarGirth:function(){var d=this,a=d.chart.getChartStore(),b=d.column,c=a.getCount(),e=d.gutter/100;return(d.chart.chartBBox[b?"width":"height"]-d[b?"xPadding":"yPadding"]*2)/(c*(e+1)-e)},getGutters:function(){var b=this,a=b.column,c=Math.ceil(b[a?"xPadding":"yPadding"]+b.getBarGirth()/2);return b.column?[c,0]:[0,c]},getBounds:function(){var n=this,N=n.chart,b=N.getChartStore(),M=b.data.items,L,w,C,u=[].concat(n.yField),o=u.length,k=o,c=n.groupGutter/100,G=n.column,g=n.xPadding,l=n.yPadding,I=n.stacked,s=n.getBarGirth(),x=G?"width":"height",t=Math,A=t.min,h=t.max,m=t.abs,F=n.getAxesForXAndYFields(),z=F.yAxis,K,B,e,p,E,q,r,D,y,a,v,H,J,d,f;n.setBBox(true);p=n.bbox;if(n.__excludes){for(J=0,v=n.__excludes.length;J<v;J++){if(n.__excludes[J]){k--}}}r=N.axes.get(z);if(r){K=r.applyData();E=K.from;q=K.to}if(n.yField&&!Ext.isNumber(E)){D=n.getMinMaxYValues();E=D[0];q=D[1]}if(!Ext.isNumber(E)){E=0}if(!Ext.isNumber(q)){q=0}y=(G?p.height-l*2:p.width-g*2)/(q-E);B=s;e=(s/((I?1:k)*(c+1)-c));if(x in n.style){e=A(e,n.style[x]);B=e*((I?1:k)*(c+1)-c)}a=(G)?p.y+p.height-l:p.x+g;if(I){v=[[],[]];for(L=0,w=M.length;L<w;L++){C=M[L];v[0][L]=v[0][L]||0;v[1][L]=v[1][L]||0;for(J=0;J<o;J++){if(n.__excludes&&n.__excludes[J]){continue}H=C.get(u[J]);v[+(H>0)][L]+=m(H)}}v[+(q>0)].push(m(q));v[+(E>0)].push(m(E));f=h.apply(t,v[0]);d=h.apply(t,v[1]);y=(G?p.height-l*2:p.width-g*2)/(d+f);a=a+f*y*(G?-1:1)}else{if(E/q<0){a=a-E*y*(G?-1:1)}}return{bars:u,bbox:p,shrunkBarWidth:B,barsLen:o,groupBarsLen:k,barWidth:s,groupBarWidth:e,scale:y,zero:a,xPadding:g,yPadding:l,signed:E/q<0,minY:E,maxY:q}},getPaths:function(){var u=this,W=u.chart,b=W.getChartStore(),V=b.data.items,U,D,K,F=u.bounds=u.getBounds(),y=u.items=[],O=u.yField,k=u.gutter/100,c=u.groupGutter/100,S=W.animate,M=u.column,w=u.group,l=W.shadow,Q=u.shadowGroups,P=u.shadowAttributes,p=Q.length,x=F.bbox,A=F.barWidth,J=F.shrunkBarWidth,m=u.xPadding,q=u.yPadding,R=u.stacked,v=F.barsLen,N=u.colorArrayStyle,g=N&&N.length||0,B=Math,n=B.max,H=B.min,t=B.abs,T,X,e,I,C,a,h,s,r,o,f,d,E,z,L,G;for(U=0,D=V.length;U<D;U++){K=V[U];a=F.zero;h=F.zero;I=0;C=0;s=false;for(T=0,f=0;T<v;T++){if(u.__excludes&&u.__excludes[T]){continue}X=K.get(F.bars[T]);e=Math.round((X-n(F.minY,0))*F.scale);r={fill:N[(v>1?T:0)%g]};if(M){Ext.apply(r,{height:e,width:n(F.groupBarWidth,0),x:(x.x+m+(A-J)*0.5+U*A*(1+k)+f*F.groupBarWidth*(1+c)*!R),y:a-e})}else{L=(D-1)-U;Ext.apply(r,{height:n(F.groupBarWidth,0),width:e+(a==F.zero),x:a+(a!=F.zero),y:(x.y+q+(A-J)*0.5+L*A*(1+k)+f*F.groupBarWidth*(1+c)*!R+1)})}if(e<0){if(M){r.y=h;r.height=t(e)}else{r.x=h+e;r.width=t(e)}}if(R){if(e<0){h+=e*(M?-1:1)}else{a+=e*(M?-1:1)}I+=t(e);if(e<0){C+=t(e)}}r.x=Math.floor(r.x)+1;G=Math.floor(r.y);if(!Ext.isIE9&&r.y>G){G--}r.y=G;r.width=Math.floor(r.width);r.height=Math.floor(r.height);y.push({series:u,yField:O[T],storeItem:K,value:[K.get(u.xField),X],attr:r,point:M?[r.x+r.width/2,X>=0?r.y:r.y+r.height]:[X>=0?r.x+r.width:r.x,r.y+r.height/2]});if(S&&W.resizing){o=M?{x:r.x,y:F.zero,width:r.width,height:0}:{x:F.zero,y:r.y,width:0,height:r.height};if(l&&(R&&!s||!R)){s=true;for(d=0;d<p;d++){E=Q[d].getAt(R?U:(U*v+T));if(E){E.setAttributes(o,true)}}}z=w.getAt(U*v+T);if(z){z.setAttributes(o,true)}}f++}if(R&&y.length){y[U*f].totalDim=I;y[U*f].totalNegDim=C}}if(R&&f==0){for(U=0,D=V.length;U<D;U++){for(d=0;d<p;d++){E=Q[d].getAt(U);if(E){E.hide(true)}}}}},renderShadows:function(t,u,x,k){var y=this,o=y.chart,r=o.surface,f=o.animate,w=y.stacked,a=y.shadowGroups,v=y.shadowAttributes,n=a.length,g=o.getChartStore(),d=y.column,q=y.items,b=[],l=k.zero,e,p,h,z,m,s,c;if((w&&(t%k.groupBarsLen===0))||!w){s=t/k.groupBarsLen;for(e=0;e<n;e++){p=Ext.apply({},v[e]);h=a[e].getAt(w?s:t);Ext.copyTo(p,u,"x,y,width,height");if(!h){h=r.add(Ext.apply({type:"rect",group:a[e]},Ext.apply({},x,p)))}if(w){z=q[t].totalDim;m=q[t].totalNegDim;if(d){p.y=l+m-z-1;p.height=z}else{p.x=l-m;p.width=z}}c=y.renderer(h,g.getAt(s),p,t,g);c.hidden=!!u.hidden;if(f){y.onAnimate(h,{to:c})}else{h.setAttributes(c,true)}b.push(h)}}return b},drawSeries:function(){var B=this,q=B.chart,l=q.getChartStore(),u=q.surface,h=q.animate,z=B.stacked,d=B.column,b=q.shadow,a=B.shadowGroups,p=a.length,n=B.group,f=B.seriesStyle,r,o,x,w,A,s,c,e,g,m,k,y,t,v;if(!l||!l.getCount()||B.seriesIsHidden){B.hide();B.items=[];return}k=Ext.apply({},this.style,f);delete k.fill;delete k.x;delete k.y;delete k.width;delete k.height;B.unHighlightItem();B.cleanHighlights();B.getPaths();m=B.bounds;r=B.items;A=d?{y:m.zero,height:0}:{x:m.zero,width:0};o=r.length;for(x=0;x<o;x++){s=n.getAt(x);y=r[x].attr;if(b){r[x].shadows=B.renderShadows(x,y,A,m)}if(!s){t=Ext.apply({},A,y);t=Ext.apply(t,k||{});s=u.add(Ext.apply({},{type:"rect",group:n},t))}if(h){c=B.renderer(s,l.getAt(x),y,x,l);s._to=c;v=B.onAnimate(s,{to:Ext.apply(c,k)});if(b&&z&&(x%m.barsLen===0)){w=x/m.barsLen;for(e=0;e<p;e++){v.on("afteranimate",function(){this.show(true)},a[e].getAt(w))}}}else{c=B.renderer(s,l.getAt(x),Ext.apply(y,{hidden:false}),x,l);s.setAttributes(Ext.apply(c,k),true)}r[x].sprite=s}o=n.getCount();for(w=x;w<o;w++){n.getAt(w).hide(true)}if(B.stacked){x=l.getCount()}if(b){for(e=0;e<p;e++){g=a[e];o=g.getCount();for(w=x;w<o;w++){g.getAt(w).hide(true)}}}B.renderLabels()},onCreateLabel:function(e,k,d,f){var g=this,a=g.chart.surface,j=g.labelsGroup,b=g.label,c=Ext.apply({},b,g.seriesLabelStyle||{}),h;return a.add(Ext.apply({type:"text",group:j},c||{}))},onPlaceLabel:function(F,M,r,I,o,G,H,u){var l=this,m=l.bounds,d=m.groupBarWidth,E=l.column,K=l.chart,t=K.chartBBox,z=K.resizing,n=r.value[0],N=r.value[1],k=r.attr,w=l.label,J=w.orientation=="vertical",g=[].concat(w.field),s=w.renderer,q=s(M.get(g[u])),f=l.getLabelSize(q),a=f.width,c=f.height,b=m.zero,h="outside",p="insideStart",L="insideEnd",D=10,B=6,e=m.signed,C,A,v;F.setAttributes({text:q});F.isOutside=false;if(E){if(o==h){if(c+B+k.height>(N>=0?b-t.y:t.y+t.height-b)){o=L}}else{if(c+B>k.height){o=h;F.isOutside=true}}C=k.x+d/2;A=o==p?(b+((c/2+3)*(N>=0?-1:1))):(N>=0?(k.y+((c/2+3)*(o==h?-1:1))):(k.y+k.height+((c/2+3)*(o===h?1:-1))))}else{if(o==h){if(a+D+k.width>(N>=0?t.x+t.width-b:b-t.x)){o=L}}else{if(a+D>k.width){o=h;F.isOutside=true}}C=o==p?(b+((a/2+5)*(N>=0?1:-1))):(N>=0?(k.x+k.width+((a/2+5)*(o===h?1:-1))):(k.x+((a/2+5)*(o===h?-1:1))));A=k.y+d/2}v={x:C,y:A};if(J){v.rotate={x:C,y:A,degrees:270}}if(G&&z){if(E){C=k.x+k.width/2;A=b}else{C=b;A=k.y+k.height/2}F.setAttributes({x:C,y:A},true);if(J){F.setAttributes({rotate:{x:C,y:A,degrees:270}},true)}}if(G){l.onAnimate(F,{to:v})}else{F.setAttributes(Ext.apply(v,{hidden:false}),true)}},getLabelSize:function(f){var j=this.testerLabel,a=this.label,d=Ext.apply({},a,this.seriesLabelStyle||{}),b=a.orientation==="vertical",i,g,e,c;if(!j){j=this.testerLabel=this.chart.surface.add(Ext.apply({type:"text",opacity:0},d))}j.setAttributes({text:f},true);i=j.getBBox();g=i.width;e=i.height;return{width:b?e:g,height:b?g:e}},onAnimate:function(b,a){b.show();return this.callParent(arguments)},isItemInPoint:function(a,d,b){var c=b.sprite.getBBox();return c.x<=a&&c.y<=d&&(c.x+c.width)>=a&&(c.y+c.height)>=d},hideAll:function(a){var e=this.chart.axes,c=e.items,d=c.length,b=0;a=(isNaN(this._index)?a:this._index)||0;if(!this.__excludes){this.__excludes=[]}this.__excludes[a]=true;this.drawSeries();for(b;b<d;b++){c[b].drawAxis()}},showAll:function(a){var e=this.chart.axes,c=e.items,d=c.length,b=0;a=(isNaN(this._index)?a:this._index)||0;if(!this.__excludes){this.__excludes=[]}this.__excludes[a]=false;this.drawSeries();for(b;b<d;b++){c[b].drawAxis()}},getLegendColor:function(a){var c=this,b=c.colorArrayStyle.length;if(c.style&&c.style.fill){return c.style.fill}else{return c.colorArrayStyle[a%b]}},highlightItem:function(a){this.callParent(arguments);this.renderLabels()},unHighlightItem:function(){this.callParent(arguments);this.renderLabels()},cleanHighlights:function(){this.callParent(arguments);this.renderLabels()}});Ext.define("Ext.chart.series.Column",{alternateClassName:["Ext.chart.ColumnSeries","Ext.chart.ColumnChart","Ext.chart.StackedColumnChart"],extend:"Ext.chart.series.Bar",type:"column",alias:"series.column",column:true,xPadding:10,yPadding:0});Ext.define("Ext.chart.series.Gauge",{extend:"Ext.chart.series.Series",type:"gauge",alias:"series.gauge",rad:Math.PI/180,highlightDuration:150,angleField:false,needle:false,donut:false,showInLegend:false,style:{},constructor:function(b){this.callParent(arguments);var g=this,f=g.chart,a=f.surface,h=f.store,j=f.shadow,d,c,e;Ext.apply(g,b,{shadowAttributes:[{"stroke-width":6,"stroke-opacity":1,stroke:"rgb(200, 200, 200)",translate:{x:1.2,y:2}},{"stroke-width":4,"stroke-opacity":1,stroke:"rgb(150, 150, 150)",translate:{x:0.9,y:1.5}},{"stroke-width":2,"stroke-opacity":1,stroke:"rgb(100, 100, 100)",translate:{x:0.6,y:1}}]});g.group=a.getGroup(g.seriesId);if(j){for(d=0,c=g.shadowAttributes.length;d<c;d++){g.shadowGroups.push(a.getGroup(g.seriesId+"-shadows"+d))}}a.customAttributes.segment=function(i){return g.getSegment(i)}},initialize:function(){var d=this,a=d.chart.getChartStore(),e=a.data.items,b,c,f;d.yField=[];if(d.label.field){for(b=0,c=e.length;b<c;b++){f=e[b];d.yField.push(f.get(d.label.field))}}},getSegment:function(b){var B=this,A=B.rad,d=Math.cos,a=Math.sin,m=Math.abs,j=B.centerX,h=B.centerY,v=0,u=0,t=0,q=0,g=0,f=0,e=0,c=0,w=0.01,l=b.endRho-b.startRho,p=b.startAngle,o=b.endAngle,i=(p+o)/2*A,k=b.margin||0,s=m(o-p)>180,C=Math.min(p,o)*A,z=Math.max(p,o)*A,n=false;j+=k*d(i);h+=k*a(i);v=j+b.startRho*d(C);g=h+b.startRho*a(C);u=j+b.endRho*d(C);f=h+b.endRho*a(C);t=j+b.startRho*d(z);e=h+b.startRho*a(z);q=j+b.endRho*d(z);c=h+b.endRho*a(z);if(m(v-t)<=w&&m(g-e)<=w){n=true}if(n){return{path:[["M",v,g],["L",u,f],["A",b.endRho,b.endRho,0,+s,1,q,c],["Z"]]}}else{return{path:[["M",v,g],["L",u,f],["A",b.endRho,b.endRho,0,+s,1,q,c],["L",t,e],["A",b.startRho,b.startRho,0,+s,0,v,g],["Z"]]}}},calcMiddle:function(o){var j=this,k=j.rad,n=o.slice,m=j.centerX,l=j.centerY,i=n.startAngle,e=n.endAngle,h=Math.max(("rho" in n)?n.rho:j.radius,j.label.minMargin),g=+j.donut,b=Math.min(i,e)*k,a=Math.max(i,e)*k,d=-(b+(a-b)/2),f=m+(o.endRho+o.startRho)/2*Math.cos(d),c=l-(o.endRho+o.startRho)/2*Math.sin(d);o.middle={x:f,y:c}},drawSeries:function(){var v=this,V=v.chart,b=V.getChartStore(),z=v.group,R=v.chart.animate,C=v.chart.axes.get(0),D=C&&C.minimum||v.minimum||0,H=C&&C.maximum||v.maximum||0,m=v.angleField||v.field||v.xField,L=V.surface,G=V.chartBBox,g=v.rad,c=+v.donut,W={},A=[],l=v.seriesStyle,a=v.seriesLabelStyle,f=v.colorArrayStyle,y=f&&f.length||0,J=V.maxGutter[0],I=V.maxGutter[1],h=Math.cos,r=Math.sin,s,e,d,u,q,B,N,E,F,K,T,S,k,U,w,n,P,Q,o,x,t,O,M;Ext.apply(l,v.style||{});v.setBBox();x=v.bbox;if(v.colorSet){f=v.colorSet;y=f.length}if(!b||!b.getCount()||v.seriesIsHidden){v.hide();v.items=[];return}e=v.centerX=G.x+(G.width/2);d=v.centerY=G.y+G.height;v.radius=Math.min(e-G.x,d-G.y);v.slices=q=[];v.items=A=[];if(!v.value){K=b.getAt(0);v.value=K.get(m)}N=v.value;if(v.needle){O={series:v,value:N,startAngle:-180,endAngle:0,rho:v.radius};t=-180*(1-(N-D)/(H-D));q.push(O)}else{t=-180*(1-(N-D)/(H-D));O={series:v,value:N,startAngle:-180,endAngle:t,rho:v.radius};M={series:v,value:v.maximum-N,startAngle:t,endAngle:0,rho:v.radius};q.push(O,M)}for(T=0,F=q.length;T<F;T++){u=q[T];B=z.getAt(T);s=Ext.apply({segment:{startAngle:u.startAngle,endAngle:u.endAngle,margin:0,rho:u.rho,startRho:u.rho*+c/100,endRho:u.rho}},Ext.apply(l,f&&{fill:f[T%y]}||{}));E=Ext.apply({},s.segment,{slice:u,series:v,storeItem:K,index:T});A[T]=E;if(!B){o=Ext.apply({type:"path",group:z},Ext.apply(l,f&&{fill:f[T%y]}||{}));B=L.add(Ext.apply(o,s))}u.sprite=u.sprite||[];E.sprite=B;u.sprite.push(B);if(R){s=v.renderer(B,K,s,T,b);B._to=s;v.onAnimate(B,{to:s})}else{s=v.renderer(B,K,Ext.apply(s,{hidden:false}),T,b);B.setAttributes(s,true)}}if(v.needle){t=t*Math.PI/180;if(!v.needleSprite){v.needleSprite=v.chart.surface.add({type:"path",path:["M",e+(v.radius*+c/100)*h(t),d+-Math.abs((v.radius*+c/100)*r(t)),"L",e+v.radius*h(t),d+-Math.abs(v.radius*r(t))],"stroke-width":4,stroke:"#222"})}else{if(R){v.onAnimate(v.needleSprite,{to:{path:["M",e+(v.radius*+c/100)*h(t),d+-Math.abs((v.radius*+c/100)*r(t)),"L",e+v.radius*h(t),d+-Math.abs(v.radius*r(t))]}})}else{v.needleSprite.setAttributes({type:"path",path:["M",e+(v.radius*+c/100)*h(t),d+-Math.abs((v.radius*+c/100)*r(t)),"L",e+v.radius*h(t),d+-Math.abs(v.radius*r(t))]})}}v.needleSprite.setAttributes({hidden:false},true)}delete v.value},setValue:function(a){this.value=a;this.drawSeries()},onCreateLabel:function(c,b,a,d){},onPlaceLabel:function(c,f,e,d,g,a,b){},onPlaceCallout:function(){},onAnimate:function(b,a){b.show();return this.callParent(arguments)},isItemInPoint:function(k,h,m,e){var g=this,d=g.centerX,c=g.centerY,o=Math.abs,n=o(k-d),l=o(h-c),f=m.startAngle,a=m.endAngle,j=Math.sqrt(n*n+l*l),b=Math.atan2(h-c,k-d)/g.rad;return(e===0)&&(b>=f&&b<a&&j>=m.startRho&&j<=m.endRho)},showAll:function(){if(!isNaN(this._index)){this.__excludes[this._index]=false;this.drawSeries()}},getLegendColor:function(a){var b=this;return b.colorArrayStyle[a%b.colorArrayStyle.length]}});Ext.define("Ext.chart.series.Line",{extend:"Ext.chart.series.Cartesian",alternateClassName:["Ext.chart.LineSeries","Ext.chart.LineChart"],requires:["Ext.chart.axis.Axis","Ext.chart.Shape","Ext.draw.Draw","Ext.fx.Anim"],type:"line",alias:"series.line",selectionTolerance:20,showMarkers:true,markerConfig:{},style:{},smooth:false,defaultSmoothness:3,fill:false,constructor:function(c){this.callParent(arguments);var e=this,a=e.chart.surface,f=e.chart.shadow,d,b;c.highlightCfg=Ext.Object.merge({"stroke-width":3},c.highlightCfg);Ext.apply(e,c,{shadowAttributes:[{"stroke-width":6,"stroke-opacity":0.05,stroke:"rgb(0, 0, 0)",translate:{x:1,y:1}},{"stroke-width":4,"stroke-opacity":0.1,stroke:"rgb(0, 0, 0)",translate:{x:1,y:1}},{"stroke-width":2,"stroke-opacity":0.15,stroke:"rgb(0, 0, 0)",translate:{x:1,y:1}}]});e.group=a.getGroup(e.seriesId);if(e.showMarkers){e.markerGroup=a.getGroup(e.seriesId+"-markers")}if(f){for(d=0,b=e.shadowAttributes.length;d<b;d++){e.shadowGroups.push(a.getGroup(e.seriesId+"-shadows"+d))}}},shrink:function(b,j,k){var g=b.length,h=Math.floor(g/k),f=1,d=0,a=0,e=[+b[0]],c=[+j[0]];for(;f<g;++f){d+=+b[f]||0;a+=+j[f]||0;if(f%h==0){e.push(d/h);c.push(a/h);d=0;a=0}}return{x:e,y:c}},drawSeries:function(){var am=this,az=am.chart,U=az.axes,au=az.getChartStore(),z=au.data.items,aq,X=au.getCount(),v=am.chart.surface,at={},T=am.group,M=am.showMarkers,aF=am.markerGroup,F=az.shadow,E=am.shadowGroups,aa=am.shadowAttributes,Q=am.smooth,q=E.length,ax=["M"],V=["M"],d=["M"],b=["M"],L=az.markerIndex,al=[].concat(am.axis),ak,aA=[],aj={},ad=[],w={},K=false,S=[],aE=am.markerStyle,ac=am.seriesStyle,u=am.colorArrayStyle,R=u&&u.length||0,N=Ext.isNumber,aB=am.seriesIdx,g=am.getAxesForXAndYFields(),l=g.xAxis,aD=g.yAxis,af,h,ae,ag,C,c,ah,J,I,f,e,t,r,Z,P,O,ay,m,H,G,aG,n,p,D,a,ab,ai,B,aw,A,av,o,aC,ar,ap,W,k,s,an,ao,Y;if(am.fireEvent("beforedraw",am)===false){return}if(!X||am.seriesIsHidden){am.hide();am.items=[];if(am.line){am.line.hide(true);if(am.line.shadows){af=am.line.shadows;for(O=0,q=af.length;O<q;O++){h=af[O];h.hide(true)}}if(am.fillPath){am.fillPath.hide(true)}}am.line=null;am.fillPath=null;return}ar=Ext.apply(aE||{},am.markerConfig,{fill:am.seriesStyle.fill||u[aB%u.length]});W=ar.type;delete ar.type;ap=ac;if(!ap["stroke-width"]){ap["stroke-width"]=0.5}s="opacity" in ap?ap.opacity:1;Y="opacity" in ap?ap.opacity:0.3;an="lineOpacity" in ap?ap.lineOpacity:s;ao="fillOpacity" in ap?ap.fillOpacity:Y;if(L&&aF&&aF.getCount()){for(P=0;P<L;P++){G=aF.getAt(P);aF.remove(G);aF.add(G);aG=aF.getAt(aF.getCount()-2);G.setAttributes({x:0,y:0,translate:{x:aG.attr.translation.x,y:aG.attr.translation.y}},true)}}am.unHighlightItem();am.cleanHighlights();am.setBBox();at=am.bbox;am.clipRect=[at.x,at.y,at.width,at.height];if(m=U.get(l)){H=m.applyData();B=H.from;aw=H.to}if(m=U.get(aD)){H=m.applyData();A=H.from;av=H.to}if(am.xField&&!Ext.isNumber(B)){m=am.getMinMaxXValues();B=m[0];aw=m[1]}if(am.yField&&!Ext.isNumber(A)){m=am.getMinMaxYValues();A=m[0];av=m[1]}if(isNaN(B)){B=0;ab=at.width/((X-1)||1)}else{ab=at.width/((aw-B)||(X-1)||1)}if(isNaN(A)){A=0;ai=at.height/((X-1)||1)}else{ai=at.height/((av-A)||(X-1)||1)}for(P=0,ay=z.length;P<ay;P++){aq=z[P];p=aq.get(am.xField);if(typeof p=="string"||typeof p=="object"&&!Ext.isDate(p)||l&&U.get(l)&&U.get(l).type=="Category"){if(p in aj){p=aj[p]}else{p=aj[p]=P}}D=aq.get(am.yField);if(typeof D=="undefined"||(typeof D=="string"&&!D)){continue}if(typeof D=="string"||typeof D=="object"&&!Ext.isDate(D)||aD&&U.get(aD)&&U.get(aD).type=="Category"){D=P}S.push(P);aA.push(p);ad.push(D)}ay=aA.length;if(ay>at.width){a=am.shrink(aA,ad,at.width);aA=a.x;ad=a.y}am.items=[];k=0;ay=aA.length;for(P=0;P<ay;P++){p=aA[P];D=ad[P];if(D===false){if(V.length==1){V=[]}K=true;am.items.push(false);continue}else{J=(at.x+(p-B)*ab).toFixed(2);I=((at.y+at.height)-(D-A)*ai).toFixed(2);if(K){K=false;V.push("M")}V=V.concat([J,I])}if((typeof r=="undefined")&&(typeof I!="undefined")){r=I;t=J}if(!am.line||az.resizing){ax=ax.concat([J,at.y+at.height/2])}if(az.animate&&az.resizing&&am.line){am.line.setAttributes({path:ax,opacity:an},true);if(am.fillPath){am.fillPath.setAttributes({path:ax,opacity:ao},true)}if(am.line.shadows){af=am.line.shadows;for(O=0,q=af.length;O<q;O++){h=af[O];h.setAttributes({path:ax},true)}}}if(M){G=aF.getAt(k++);if(!G){G=Ext.chart.Shape[W](v,Ext.apply({group:[T,aF],x:0,y:0,translate:{x:+(f||J),y:e||(at.y+at.height/2)},value:'"'+p+", "+D+'"',zIndex:4000},ar));G._to={translate:{x:+J,y:+I}}}else{G.setAttributes({value:'"'+p+", "+D+'"',x:0,y:0,hidden:false},true);G._to={translate:{x:+J,y:+I}}}}am.items.push({series:am,value:[p,D],point:[J,I],sprite:G,storeItem:au.getAt(S[P])});f=J;e=I}if(V.length<=1){return}if(am.smooth){b=Ext.draw.Draw.smooth(V,N(Q)?Q:am.defaultSmoothness)}d=Q?b:V;if(az.markerIndex&&am.previousPath){ag=am.previousPath;if(!Q){Ext.Array.erase(ag,1,2)}}else{ag=V}if(!am.line){am.line=v.add(Ext.apply({type:"path",group:T,path:ax,stroke:ap.stroke||ap.fill},ap||{}));am.line.setAttributes({opacity:an},true);if(F){am.line.setAttributes(Ext.apply({},am.shadowOptions),true)}am.line.setAttributes({fill:"none",zIndex:3000});if(!ap.stroke&&R){am.line.setAttributes({stroke:u[aB%R]},true)}if(F){af=am.line.shadows=[];for(ae=0;ae<q;ae++){ak=aa[ae];ak=Ext.apply({},ak,{path:ax});h=v.add(Ext.apply({},{type:"path",group:E[ae]},ak));af.push(h)}}}if(am.fill){c=d.concat([["L",J,at.y+at.height],["L",t,at.y+at.height],["L",t,r]]);if(!am.fillPath){am.fillPath=v.add({group:T,type:"path",fill:ap.fill||u[aB%R],path:ax})}}Z=M&&aF.getCount();if(az.animate){C=am.fill;o=am.line;ah=am.renderer(o,false,{path:d},P,au);Ext.apply(ah,ap||{},{stroke:ap.stroke||ap.fill});delete ah.fill;o.show(true);if(az.markerIndex&&am.previousPath){am.animation=aC=am.onAnimate(o,{to:ah,from:{path:ag}})}else{am.animation=aC=am.onAnimate(o,{to:ah})}if(F){af=o.shadows;for(O=0;O<q;O++){af[O].show(true);if(az.markerIndex&&am.previousPath){am.onAnimate(af[O],{to:{path:d},from:{path:ag}})}else{am.onAnimate(af[O],{to:{path:d}})}}}if(C){am.fillPath.show(true);am.onAnimate(am.fillPath,{to:Ext.apply({},{path:c,fill:ap.fill||u[aB%R],"stroke-width":0,opacity:ao},ap||{})})}if(M){k=0;for(P=0;P<ay;P++){if(am.items[P]){n=aF.getAt(k++);if(n){ah=am.renderer(n,au.getAt(P),n._to,P,au);am.onAnimate(n,{to:Ext.apply(ah,ar||{})});n.show(true)}}}for(;k<Z;k++){n=aF.getAt(k);n.hide(true)}}}else{ah=am.renderer(am.line,false,{path:d,hidden:false},P,au);Ext.apply(ah,ap||{},{stroke:ap.stroke||ap.fill});delete ah.fill;am.line.setAttributes(ah,true);am.line.setAttributes({opacity:an},true);if(F){af=am.line.shadows;for(O=0;O<q;O++){af[O].setAttributes({path:d,hidden:false},true)}}if(am.fill){am.fillPath.setAttributes({path:c,hidden:false,opacity:ao},true)}if(M){k=0;for(P=0;P<ay;P++){if(am.items[P]){n=aF.getAt(k++);if(n){ah=am.renderer(n,au.getAt(P),n._to,P,au);n.setAttributes(Ext.apply(ar||{},ah||{}),true);if(!n.attr.hidden){n.show(true)}}}}for(;k<Z;k++){n=aF.getAt(k);n.hide(true)}}}if(az.markerIndex){if(am.smooth){Ext.Array.erase(V,1,2)}else{Ext.Array.splice(V,1,0,V[1],V[2])}am.previousPath=V}am.renderLabels();am.renderCallouts();am.fireEvent("draw",am)},onCreateLabel:function(d,j,c,e){var f=this,g=f.labelsGroup,a=f.label,h=f.bbox,b=Ext.apply(a,f.seriesLabelStyle);return f.chart.surface.add(Ext.apply({type:"text","text-anchor":"middle",group:g,x:j.point[0],y:h.y+h.height/2},b||{}))},onPlaceLabel:function(f,j,r,o,n,d){var t=this,k=t.chart,q=k.resizing,s=t.label,p=s.renderer,b=s.field,a=t.bbox,h=r.point[0],g=r.point[1],c=r.sprite.attr.radius,e,m,l;f.setAttributes({text:p(j.get(b)),hidden:true},true);if(n=="rotate"){f.setAttributes({"text-anchor":"start",rotation:{x:h,y:g,degrees:-45}},true);e=f.getBBox();m=e.width;l=e.height;h=h<a.x?a.x:h;h=(h+m>a.x+a.width)?(h-(h+m-a.x-a.width)):h;g=(g-l<a.y)?a.y+l:g}else{if(n=="under"||n=="over"){e=r.sprite.getBBox();e.width=e.width||(c*2);e.height=e.height||(c*2);g=g+(n=="over"?-e.height:e.height);e=f.getBBox();m=e.width/2;l=e.height/2;h=h-m<a.x?a.x+m:h;h=(h+m>a.x+a.width)?(h-(h+m-a.x-a.width)):h;g=g-l<a.y?a.y+l:g;g=(g+l>a.y+a.height)?(g-(g+l-a.y-a.height)):g}}if(t.chart.animate&&!t.chart.resizing){f.show(true);t.onAnimate(f,{to:{x:h,y:g}})}else{f.setAttributes({x:h,y:g},true);if(q&&t.animation){t.animation.on("afteranimate",function(){f.show(true)})}else{f.show(true)}}},highlightItem:function(){var a=this;a.callParent(arguments);if(a.line&&!a.highlighted){if(!("__strokeWidth" in a.line)){a.line.__strokeWidth=parseFloat(a.line.attr["stroke-width"])||0}if(a.line.__anim){a.line.__anim.paused=true}a.line.__anim=Ext.create("Ext.fx.Anim",{target:a.line,to:{"stroke-width":a.line.__strokeWidth+3}});a.highlighted=true}},unHighlightItem:function(){var a=this;a.callParent(arguments);if(a.line&&a.highlighted){a.line.__anim=Ext.create("Ext.fx.Anim",{target:a.line,to:{"stroke-width":a.line.__strokeWidth}});a.highlighted=false}},onPlaceCallout:function(l,q,I,F,E,d,j){if(!E){return}var L=this,r=L.chart,C=r.surface,G=r.resizing,K=L.callouts,s=L.items,u=F==0?false:s[F-1].point,w=(F==s.length-1)?false:s[F+1].point,c=[+I.point[0],+I.point[1]],z,f,M,J,n,o,H=K.offsetFromViz||30,B=K.offsetToSide||10,A=K.offsetBox||3,g,e,h,v,t,D=L.clipRect,b={width:K.styles.width||10,height:K.styles.height||10},m,k;if(!u){u=c}if(!w){w=c}J=(w[1]-u[1])/(w[0]-u[0]);n=(c[1]-u[1])/(c[0]-u[0]);o=(w[1]-c[1])/(w[0]-c[0]);f=Math.sqrt(1+J*J);z=[1/f,J/f];M=[-z[1],z[0]];if(n>0&&o<0&&M[1]<0||n<0&&o>0&&M[1]>0){M[0]*=-1;M[1]*=-1}else{if(Math.abs(n)<Math.abs(o)&&M[0]<0||Math.abs(n)>Math.abs(o)&&M[0]>0){M[0]*=-1;M[1]*=-1}}m=c[0]+M[0]*H;k=c[1]+M[1]*H;g=m+(M[0]>0?0:-(b.width+2*A));e=k-b.height/2-A;h=b.width+2*A;v=b.height+2*A;if(g<D[0]||(g+h)>(D[0]+D[2])){M[0]*=-1}if(e<D[1]||(e+v)>(D[1]+D[3])){M[1]*=-1}m=c[0]+M[0]*H;k=c[1]+M[1]*H;g=m+(M[0]>0?0:-(b.width+2*A));e=k-b.height/2-A;h=b.width+2*A;v=b.height+2*A;if(r.animate){L.onAnimate(l.lines,{to:{path:["M",c[0],c[1],"L",m,k,"Z"]}});if(l.panel){l.panel.setPosition(g,e,true)}}else{l.lines.setAttributes({path:["M",c[0],c[1],"L",m,k,"Z"]},true);if(l.panel){l.panel.setPosition(g,e)}}for(t in l){l[t].show(true)}},isItemInPoint:function(h,f,z,p){var B=this,m=B.items,r=B.selectionTolerance,j=null,w,c,o,u,g,v,b,s,a,k,A,e,d,n,t,q,C=Math.sqrt,l=Math.abs;c=m[p];w=p&&m[p-1];if(p>=g){w=m[g-1]}o=w&&w.point;u=c&&c.point;v=w?o[0]:u[0]-r;b=w?o[1]:u[1];s=c?u[0]:o[0]+r;a=c?u[1]:o[1];e=C((h-v)*(h-v)+(f-b)*(f-b));d=C((h-s)*(h-s)+(f-a)*(f-a));n=Math.min(e,d);if(n<=r){return n==e?w:c}return false},toggleAll:function(a){var e=this,b,d,f,c;if(!a){Ext.chart.series.Cartesian.prototype.hideAll.call(e)}else{Ext.chart.series.Cartesian.prototype.showAll.call(e)}if(e.line){e.line.setAttributes({hidden:!a},true);if(e.line.shadows){for(b=0,c=e.line.shadows,d=c.length;b<d;b++){f=c[b];f.setAttributes({hidden:!a},true)}}}if(e.fillPath){e.fillPath.setAttributes({hidden:!a},true)}},hideAll:function(){this.toggleAll(false)},showAll:function(){this.toggleAll(true)}});Ext.define("Ext.chart.series.Pie",{alternateClassName:["Ext.chart.PieSeries","Ext.chart.PieChart"],extend:"Ext.chart.series.Series",type:"pie",alias:"series.pie",accuracy:100000,rad:Math.PI*2/100000,highlightDuration:150,angleField:false,lengthField:false,donut:false,showInLegend:false,style:{},constructor:function(b){this.callParent(arguments);var g=this,f=g.chart,a=f.surface,h=f.store,j=f.shadow,d,c,e;b.highlightCfg=Ext.merge({segment:{margin:20}},b.highlightCfg);Ext.apply(g,b,{shadowAttributes:[{"stroke-width":6,"stroke-opacity":1,stroke:"rgb(200, 200, 200)",translate:{x:1.2,y:2}},{"stroke-width":4,"stroke-opacity":1,stroke:"rgb(150, 150, 150)",translate:{x:0.9,y:1.5}},{"stroke-width":2,"stroke-opacity":1,stroke:"rgb(100, 100, 100)",translate:{x:0.6,y:1}}]});g.group=a.getGroup(g.seriesId);if(j){for(d=0,c=g.shadowAttributes.length;d<c;d++){g.shadowGroups.push(a.getGroup(g.seriesId+"-shadows"+d))}}a.customAttributes.segment=function(k){var i=g.getSegment(k);if(!i.path||i.path.length===0){i.path=["M",0,0]}return i};g.__excludes=g.__excludes||[]},initialize:function(){var d=this,a=d.chart.getChartStore(),e=a.data.items,b,c,f;d.yField=[];if(d.label.field){for(b=0,c=e.length;b<c;b++){f=e[b];d.yField.push(f.get(d.label.field))}}},getSegment:function(d){var I=this,H=I.rad,h=Math.cos,a=Math.sin,o=I.centerX,m=I.centerY,D=0,C=0,B=0,z=0,k=0,j=0,i=0,f=0,v=0,c=0,u=0,b=0,F=0.01,w=d.startAngle,t=d.endAngle,n=(w+t)/2*H,q=d.margin||0,J=Math.min(w,t)*H,G=Math.max(w,t)*H,s=h(J),g=a(J),r=h(G),e=a(G),l=h(n),E=a(n),A=0,p=0.7071067811865476;if(G-J<F){return{path:""}}if(q!==0){o+=q*l;m+=q*E}C=o+d.endRho*s;j=m+d.endRho*g;z=o+d.endRho*r;f=m+d.endRho*e;u=o+d.endRho*l;b=m+d.endRho*E;if(d.startRho!==0){D=o+d.startRho*s;k=m+d.startRho*g;B=o+d.startRho*r;i=m+d.startRho*e;v=o+d.startRho*l;c=m+d.startRho*E;return{path:[["M",C,j],["A",d.endRho,d.endRho,0,0,1,u,b],["L",u,b],["A",d.endRho,d.endRho,0,A,1,z,f],["L",z,f],["L",B,i],["A",d.startRho,d.startRho,0,A,0,v,c],["L",v,c],["A",d.startRho,d.startRho,0,0,0,D,k],["L",D,k],["Z"]]}}else{return{path:[["M",o,m],["L",C,j],["A",d.endRho,d.endRho,0,0,1,u,b],["L",u,b],["A",d.endRho,d.endRho,0,A,1,z,f],["L",z,f],["L",o,m],["Z"]]}}},calcMiddle:function(m){var h=this,i=h.rad,l=m.slice,k=h.centerX,j=h.centerY,g=l.startAngle,d=l.endAngle,f=+h.donut,c=-(g+d)*i/2,a=(m.endRho+m.startRho)/2,e=k+a*Math.cos(c),b=j-a*Math.sin(c);m.middle={x:e,y:b}},drawSeries:function(){var r=this,a=r.chart.getChartStore(),V=a.data.items,H,w=r.group,R=r.chart.animate,h=r.angleField||r.field||r.xField,z=[].concat(r.lengthField),Q=0,W=r.chart,I=W.surface,F=W.chartBBox,f=W.shadow,P=r.shadowGroups,O=r.shadowAttributes,Z=P.length,J=z.length,A=0,b=+r.donut,Y=[],x=[],t=0,L=0,s=0,g=r.seriesStyle,e=r.colorArrayStyle,v=e&&e.length||0,n,X,B,G,D,d,c,o,k=0,q,m,y,K,C,aa,E,T,S,U,M,N,l,u;Ext.apply(g,r.style||{});r.setBBox();u=r.bbox;if(r.colorSet){e=r.colorSet;v=e.length}if(!a||!a.getCount()||r.seriesIsHidden){r.hide();r.items=[];return}r.unHighlightItem();r.cleanHighlights();d=r.centerX=F.x+(F.width/2);c=r.centerY=F.y+(F.height/2);r.radius=Math.min(d-F.x,c-F.y);r.slices=m=[];r.items=x=[];for(T=0,E=V.length;T<E;T++){H=V[T];if(this.__excludes&&this.__excludes[T]){continue}t+=+H.get(h);if(z[0]){for(S=0,Q=0;S<J;S++){Q+=+H.get(z[S])}Y[T]=Q;L=Math.max(L,Q)}}t=t||1;for(T=0,E=V.length;T<E;T++){H=V[T];if(this.__excludes&&this.__excludes[T]){K=0}else{K=H.get(h);if(k==0){k=1}}if(k==1){k=2;r.firstAngle=s=r.accuracy*K/t/2;for(S=0;S<T;S++){m[S].startAngle=m[S].endAngle=r.firstAngle}}U=s-r.accuracy*K/t;q={series:r,value:K,startAngle:s,endAngle:U,storeItem:H};if(z[0]){aa=+Y[T];q.rho=Math.floor(r.radius/L*aa)}else{q.rho=r.radius}m[T]=q;(function(){s=U})()}if(f){for(T=0,E=m.length;T<E;T++){q=m[T];q.shadowAttrs=[];for(S=0,A=0,B=[];S<J;S++){y=w.getAt(T*J+S);o=z[S]?a.getAt(T).get(z[S])/Y[T]*q.rho:q.rho;n={segment:{startAngle:q.startAngle,endAngle:q.endAngle,margin:0,rho:q.rho,startRho:A+(o*b/100),endRho:A+o},hidden:!q.value&&(q.startAngle%r.accuracy)==(q.endAngle%r.accuracy)};for(D=0,B=[];D<Z;D++){X=O[D];G=P[D].getAt(T);if(!G){G=W.surface.add(Ext.apply({},{type:"path",group:P[D],strokeLinejoin:"round"},n,X))}X=r.renderer(G,a.getAt(T),Ext.apply({},n,X),T,a);if(R){r.onAnimate(G,{to:X})}else{G.setAttributes(X,true)}B.push(G)}q.shadowAttrs[S]=B}}}for(T=0,E=m.length;T<E;T++){q=m[T];for(S=0,A=0;S<J;S++){y=w.getAt(T*J+S);o=z[S]?a.getAt(T).get(z[S])/Y[T]*q.rho:q.rho;n=Ext.apply({segment:{startAngle:q.startAngle,endAngle:q.endAngle,margin:0,rho:q.rho,startRho:A+(o*b/100),endRho:A+o},hidden:(!q.value&&(q.startAngle%r.accuracy)==(q.endAngle%r.accuracy))},Ext.apply(g,e&&{fill:e[(J>1?S:T)%v]}||{}));C=Ext.apply({},n.segment,{slice:q,series:r,storeItem:q.storeItem,index:T});r.calcMiddle(C);if(f){C.shadows=q.shadowAttrs[S]}x[T]=C;if(!y){l=Ext.apply({type:"path",group:w,middle:C.middle},Ext.apply(g,e&&{fill:e[(J>1?S:T)%v]}||{}));y=I.add(Ext.apply(l,n))}q.sprite=q.sprite||[];C.sprite=y;q.sprite.push(y);q.point=[C.middle.x,C.middle.y];if(R){n=r.renderer(y,a.getAt(T),n,T,a);y._to=n;y._animating=true;r.onAnimate(y,{to:n,listeners:{afteranimate:{fn:function(){this._animating=false},scope:y}}})}else{n=r.renderer(y,a.getAt(T),Ext.apply(n,{hidden:false}),T,a);y.setAttributes(n,true)}A+=o}}E=w.getCount();for(T=0;T<E;T++){if(!m[(T/J)>>0]&&w.getAt(T)){w.getAt(T).hide(true)}}if(f){Z=P.length;for(D=0;D<E;D++){if(!m[(D/J)>>0]){for(S=0;S<Z;S++){if(P[S].getAt(D)){P[S].getAt(D).hide(true)}}}}}r.renderLabels();r.renderCallouts()},onCreateLabel:function(f,k,e,g){var h=this,j=h.labelsGroup,a=h.label,d=h.centerX,c=h.centerY,l=k.middle,b=Ext.apply(h.seriesLabelStyle||{},a||{});return h.chart.surface.add(Ext.apply({type:"text","text-anchor":"middle",group:j,x:l.x,y:l.y},b))},onPlaceLabel:function(j,o,w,s,r,e,f){var A=this,p=A.chart,v=p.resizing,z=A.label,t=z.renderer,c=[].concat(z.field),l=A.centerX,k=A.centerY,B=w.middle,b={x:B.x,y:B.y},n=B.x-l,m=B.y-k,q={},d=1,h=Math.atan2(m,n||1),u=h*180/Math.PI,g;b.hidden=false;if(this.__excludes&&this.__excludes[s]){b.hidden=true}function a(i){if(i<0){i+=360}return i%360}j.setAttributes({text:t(o.get(c[f]))},true);switch(r){case"outside":d=Math.sqrt(n*n+m*m)*2;b.x=d*Math.cos(h)+l;b.y=d*Math.sin(h)+k;break;case"rotate":u=a(u);u=(u>90&&u<270)?u+180:u;g=j.attr.rotation.degrees;if(g!=null&&Math.abs(g-u)>180*0.5){if(u>g){u-=360}else{u+=360}u=u%360}else{u=a(u)}b.rotate={degrees:u,x:b.x,y:b.y};break;default:break}b.translate={x:0,y:0};if(e&&!v&&(r!="rotate"||g!=null)){A.onAnimate(j,{to:b})}else{j.setAttributes(b,true)}j._from=q},onPlaceCallout:function(k,n,w,u,t,d,e){var z=this,o=z.chart,h=z.centerX,g=z.centerY,A=w.middle,b={x:A.x,y:A.y},l=A.x-h,j=A.y-g,c=1,m,f=Math.atan2(j,l||1),a=k.label.getBBox(),v=20,s=10,r=10,q;c=w.endRho+v;m=(w.endRho+w.startRho)/2+(w.endRho-w.startRho)/3;b.x=c*Math.cos(f)+h;b.y=c*Math.sin(f)+g;l=m*Math.cos(f);j=m*Math.sin(f);if(o.animate){z.onAnimate(k.lines,{to:{path:["M",l+h,j+g,"L",b.x,b.y,"Z","M",b.x,b.y,"l",l>0?s:-s,0,"z"]}});z.onAnimate(k.box,{to:{x:b.x+(l>0?s:-(s+a.width+2*r)),y:b.y+(j>0?(-a.height-r/2):(-a.height-r/2)),width:a.width+2*r,height:a.height+2*r}});z.onAnimate(k.label,{to:{x:b.x+(l>0?(s+r):-(s+a.width+r)),y:b.y+(j>0?-a.height/4:-a.height/4)}})}else{k.lines.setAttributes({path:["M",l+h,j+g,"L",b.x,b.y,"Z","M",b.x,b.y,"l",l>0?s:-s,0,"z"]},true);k.box.setAttributes({x:b.x+(l>0?s:-(s+a.width+2*r)),y:b.y+(j>0?(-a.height-r/2):(-a.height-r/2)),width:a.width+2*r,height:a.height+2*r},true);k.label.setAttributes({x:b.x+(l>0?(s+r):-(s+a.width+r)),y:b.y+(j>0?-a.height/4:-a.height/4)},true)}for(q in k){k[q].show(true)}},onAnimate:function(b,a){b.show();return this.callParent(arguments)},isItemInPoint:function(k,h,m,e){var g=this,d=g.centerX,c=g.centerY,o=Math.abs,n=o(k-d),l=o(h-c),f=m.startAngle,a=m.endAngle,j=Math.sqrt(n*n+l*l),b=Math.atan2(h-c,k-d)/g.rad;if(b>g.firstAngle){b-=g.accuracy}return(b<=f&&b>a&&j>=m.startRho&&j<=m.endRho)},hideAll:function(c){var f,b,h,g,e,a,d;c=(isNaN(this._index)?c:this._index)||0;this.__excludes=this.__excludes||[];this.__excludes[c]=true;d=this.slices[c].sprite;for(e=0,a=d.length;e<a;e++){d[e].setAttributes({hidden:true},true)}if(this.slices[c].shadowAttrs){for(f=0,g=this.slices[c].shadowAttrs,b=g.length;f<b;f++){h=g[f];for(e=0,a=h.length;e<a;e++){h[e].setAttributes({hidden:true},true)}}}this.drawSeries()},showAll:function(a){a=(isNaN(this._index)?a:this._index)||0;this.__excludes[a]=false;this.drawSeries()},highlightItem:function(q){var t=this,s=t.rad,v,d,n,p,a,e,j,b,l,c,f,o,g,u,m,k,h;q=q||this.items[this._index];this.unHighlightItem();if(!q||t.animating||(q.sprite&&q.sprite._animating)){return}t.callParent([q]);if(!t.highlight){return}if("segment" in t.highlightCfg){v=t.highlightCfg.segment;d=t.chart.animate;if(t.labelsGroup){f=t.labelsGroup;o=t.label.display;g=f.getAt(q.index);u=(q.startAngle+q.endAngle)/2*s;m=v.margin||0;k=m*Math.cos(u);h=m*Math.sin(u);if(Math.abs(k)<1e-10){k=0}if(Math.abs(h)<1e-10){h=0}if(d){g.stopAnimation();g.animate({to:{translate:{x:k,y:h}},duration:t.highlightDuration})}else{g.setAttributes({translate:{x:k,y:h}},true)}}if(t.chart.shadow&&q.shadows){p=0;a=q.shadows;j=a.length;for(;p<j;p++){e=a[p];b={};l=q.sprite._from.segment;for(c in l){if(!(c in v)){b[c]=l[c]}}n={segment:Ext.applyIf(b,t.highlightCfg.segment)};if(d){e.stopAnimation();e.animate({to:n,duration:t.highlightDuration})}else{e.setAttributes(n,true)}}}}},unHighlightItem:function(){var v=this,k,e,d,h,s,r,q,o,w,l,c,a,u,m,b,f,t,g,n;if(!v.highlight){return}if(("segment" in v.highlightCfg)&&v.items){k=v.items;e=v.chart.animate;d=!!v.chart.shadow;h=v.labelsGroup;s=k.length;r=0;q=0;o=v.label.display;for(;r<s;r++){t=k[r];if(!t){continue}m=t.sprite;if(m&&m._highlighted){if(h){g=h.getAt(t.index);n=Ext.apply({translate:{x:0,y:0}},o=="rotate"?{rotate:{x:g.attr.x,y:g.attr.y,degrees:g.attr.rotation.degrees}}:{});if(e){g.stopAnimation();g.animate({to:n,duration:v.highlightDuration})}else{g.setAttributes(n,true)}}if(d){b=t.shadows;w=b.length;for(;q<w;q++){c={};a=t.sprite._to.segment;u=t.sprite._from.segment;Ext.apply(c,u);for(l in a){if(!(l in u)){c[l]=a[l]}}f=b[q];if(e){f.stopAnimation();f.animate({to:{segment:c},duration:v.highlightDuration})}else{f.setAttributes({segment:c},true)}}}}}}v.callParent(arguments)},getLegendColor:function(a){var b=this;return(b.colorSet&&b.colorSet[a%b.colorSet.length])||b.colorArrayStyle[a%b.colorArrayStyle.length]}});Ext.define("Ext.chart.series.Radar",{extend:"Ext.chart.series.Series",requires:["Ext.chart.Shape","Ext.fx.Anim"],type:"radar",alias:"series.radar",rad:Math.PI/180,showInLegend:false,style:{},constructor:function(c){this.callParent(arguments);var e=this,a=e.chart.surface,d,b;e.group=a.getGroup(e.seriesId);if(e.showMarkers){e.markerGroup=a.getGroup(e.seriesId+"-markers")}},drawSeries:function(){var v=this,c=v.chart.getChartStore(),R=c.data.items,S,H,w=v.group,A,T=v.chart,K=T.series.items,L,u,k,P=T.animate,n=v.field||v.yField,J=T.surface,E=T.chartBBox,D=v.seriesIdx,h=v.colorArrayStyle,f,e,z,M,q=0,a=[],C=Math.max,j=Math.cos,r=Math.sin,p=Math.PI*2,O=c.getCount(),g,N,I,G,F,Q,t,m=v.seriesStyle,b=v.seriesLabelStyle,o=T.resizing||!v.radar,B=T.axes&&T.axes.get(0),U=!(B&&B.maximum);v.setBBox();q=U?0:(B.maximum||0);Ext.apply(m,v.style||{});if(!c||!c.getCount()||v.seriesIsHidden){v.hide();v.items=[];if(v.radar){v.radar.hide(true)}v.radar=null;return}if(!m.stroke){m.stroke=h[D%h.length]}v.unHighlightItem();v.cleanHighlights();f=v.centerX=E.x+(E.width/2);e=v.centerY=E.y+(E.height/2);v.radius=M=Math.min(E.width,E.height)/2;v.items=z=[];if(U){for(L=0,u=K.length;L<u;L++){k=K[L];a.push(k.yField)}for(S=0;S<O;S++){H=R[S];for(Q=0,t=a.length;Q<t;Q++){q=C(+H.get(a[Q]),q)}}}q=q||1;g=[];N=[];for(Q=0;Q<O;Q++){H=R[Q];F=M*H.get(n)/q;I=F*j(Q/O*p);G=F*r(Q/O*p);if(Q==0){N.push("M",I+f,G+e);g.push("M",0.01*I+f,0.01*G+e)}else{N.push("L",I+f,G+e);g.push("L",0.01*I+f,0.01*G+e)}z.push({sprite:false,point:[f+I,e+G],storeItem:H,series:v})}N.push("Z");if(!v.radar){v.radar=J.add(Ext.apply({type:"path",group:w,path:g},m||{}))}if(T.resizing){v.radar.setAttributes({path:g},true)}if(T.animate){v.onAnimate(v.radar,{to:Ext.apply({path:N},m||{})})}else{v.radar.setAttributes(Ext.apply({path:N},m||{}),true)}if(v.showMarkers){v.drawMarkers()}v.renderLabels();v.renderCallouts()},drawMarkers:function(){var m=this,j=m.chart,a=j.surface,b=Ext.apply({},m.markerStyle||{}),h=Ext.apply(b,m.markerConfig,{fill:m.colorArrayStyle[m.seriesIdx%m.colorArrayStyle.length]}),k=m.items,n=h.type,p=m.markerGroup,e=m.centerX,d=m.centerY,o,g,c,f;delete h.type;for(g=0,c=k.length;g<c;g++){o=k[g];f=p.getAt(g);if(!f){f=Ext.chart.Shape[n](a,Ext.apply({group:p,x:0,y:0,translate:{x:e,y:d}},h))}else{f.show()}o.sprite=f;if(j.resizing){f.setAttributes({x:0,y:0,translate:{x:e,y:d}},true)}f._to={translate:{x:o.point[0],y:o.point[1]}};if(j.animate){m.onAnimate(f,{to:f._to})}else{f.setAttributes(Ext.apply(f._to,h||{}),true)}}},isItemInPoint:function(c,f,e){var b,d=10,a=Math.abs;b=e.point;return(a(b[0]-c)<=d&&a(b[1]-f)<=d)},onCreateLabel:function(f,l,e,g){var h=this,k=h.labelsGroup,a=h.label,d=h.centerX,c=h.centerY,j=l.point,b=Ext.apply(h.seriesLabelStyle||{},a);return h.chart.surface.add(Ext.apply({type:"text","text-anchor":"middle",group:k,x:d,y:c},a||{}))},onPlaceLabel:function(p,g,r,f,j,b){var l=this,k=l.chart,h=k.resizing,c=l.label,q=c.renderer,o=c.field,e=l.centerX,d=l.centerY,a={x:r.point[0],y:r.point[1]},n=a.x-e,m=a.y-d;p.setAttributes({text:q(g.get(o)),hidden:true},true);if(h){p.setAttributes({x:e,y:d},true)}if(b){p.show(true);l.onAnimate(p,{to:a})}else{p.setAttributes(a,true);p.show(true)}},toggleAll:function(a){var e=this,b,d,f,c;if(!a){Ext.chart.series.Radar.superclass.hideAll.call(e)}else{Ext.chart.series.Radar.superclass.showAll.call(e)}if(e.radar){e.radar.setAttributes({hidden:!a},true);if(e.radar.shadows){for(b=0,c=e.radar.shadows,d=c.length;b<d;b++){f=c[b];f.setAttributes({hidden:!a},true)}}}},hideAll:function(){this.toggleAll(false);this.hideMarkers(0)},showAll:function(){this.toggleAll(true)},hideMarkers:function(a){var d=this,c=d.markerGroup&&d.markerGroup.getCount()||0,b=a||0;for(;b<c;b++){d.markerGroup.getAt(b).hide(true)}}});Ext.define("Ext.chart.series.Scatter",{extend:"Ext.chart.series.Cartesian",requires:["Ext.chart.axis.Axis","Ext.chart.Shape","Ext.fx.Anim"],type:"scatter",alias:"series.scatter",constructor:function(c){this.callParent(arguments);var e=this,f=e.chart.shadow,a=e.chart.surface,d,b;Ext.apply(e,c,{style:{},markerConfig:{},shadowAttributes:[{"stroke-width":6,"stroke-opacity":0.05,stroke:"rgb(0, 0, 0)"},{"stroke-width":4,"stroke-opacity":0.1,stroke:"rgb(0, 0, 0)"},{"stroke-width":2,"stroke-opacity":0.15,stroke:"rgb(0, 0, 0)"}]});e.group=a.getGroup(e.seriesId);if(f){for(d=0,b=e.shadowAttributes.length;d<b;d++){e.shadowGroups.push(a.getGroup(e.seriesId+"-shadows"+d))}}},getBounds:function(){var r=this,h=r.chart,d=h.getChartStore(),n=h.axes,k=r.getAxesForXAndYFields(),j=k.xAxis,e=k.yAxis,a,s,c,f,q,o,p,m,l,b,g;r.setBBox();a=r.bbox;if(b=n.get(j)){g=b.applyData();q=g.from;p=g.to}if(b=n.get(e)){g=b.applyData();o=g.from;m=g.to}if(r.xField&&!Ext.isNumber(q)){b=r.getMinMaxXValues();q=b[0];p=b[1]}if(r.yField&&!Ext.isNumber(o)){b=r.getMinMaxYValues();o=b[0];m=b[1]}if(isNaN(q)){q=0;p=d.getCount()-1;s=a.width/(d.getCount()-1)}else{s=a.width/(p-q)}if(isNaN(o)){o=0;m=d.getCount()-1;c=a.height/(d.getCount()-1)}else{c=a.height/(m-o)}return{bbox:a,minX:q,minY:o,xScale:s,yScale:c}},getPaths:function(){var w=this,m=w.chart,b=m.shadow,e=m.getChartStore(),A=e.data.items,r,k,d,h=w.group,f=w.bounds=w.getBounds(),a=w.bbox,B=f.xScale,c=f.yScale,u=f.minX,t=f.minY,z=a.x,v=a.y,g=a.height,n=w.items=[],p=[],l,j,q,s,o;for(r=0,k=A.length;r<k;r++){d=A[r];q=d.get(w.xField);s=d.get(w.yField);if(typeof s=="undefined"||(typeof s=="string"&&!s)||q==null||s==null){continue}if(typeof q=="string"||typeof q=="object"&&!Ext.isDate(q)){q=r}if(typeof s=="string"||typeof s=="object"&&!Ext.isDate(s)){s=r}l=z+(q-u)*B;j=v+g-(s-t)*c;p.push({x:l,y:j});w.items.push({series:w,value:[q,s],point:[l,j],storeItem:d});if(m.animate&&m.resizing){o=h.getAt(r);if(o){w.resetPoint(o);if(b){w.resetShadow(o)}}}}return p},resetPoint:function(a){var b=this.bbox;a.setAttributes({translate:{x:(b.x+b.width)/2,y:(b.y+b.height)/2}},true)},resetShadow:function(c){var f=this,e=c.shadows,h=f.shadowAttributes,d=f.shadowGroups.length,g=f.bbox,b,a;for(b=0;b<d;b++){a=Ext.apply({},h[b]);if(a.translate){a.translate.x+=(g.x+g.width)/2;a.translate.y+=(g.y+g.height)/2}else{a.translate={x:(g.x+g.width)/2,y:(g.y+g.height)/2}}e[b].setAttributes(a,true)}},createPoint:function(a,c){var d=this,b=d.chart,e=d.group,f=d.bbox;return Ext.chart.Shape[c](b.surface,Ext.apply({},{x:0,y:0,group:e,translate:{x:(f.x+f.width)/2,y:(f.y+f.height)/2}},a))},createShadow:function(m,f,j){var h=this,g=h.chart,k=h.shadowGroups,d=h.shadowAttributes,a=k.length,n=h.bbox,c,l,b,e;m.shadows=b=[];for(c=0;c<a;c++){e=Ext.apply({},d[c]);if(e.translate){e.translate.x+=(n.x+n.width)/2;e.translate.y+=(n.y+n.height)/2}else{Ext.apply(e,{translate:{x:(n.x+n.width)/2,y:(n.y+n.height)/2}})}Ext.apply(e,f);l=Ext.chart.Shape[j](g.surface,Ext.apply({},{x:0,y:0,group:k[c]},e));b.push(l)}},drawSeries:function(){var t=this,k=t.chart,g=k.getChartStore(),h=t.group,c=k.shadow,a=t.shadowGroups,p=t.shadowAttributes,q=a.length,l,m,n,j,o,s,e,f,b,d,r;s=Ext.apply(t.markerStyle,t.markerConfig);f=s.type;delete s.type;if(!g||!g.getCount()){t.hide();t.items=[];return}t.unHighlightItem();t.cleanHighlights();m=t.getPaths();j=m.length;for(o=0;o<j;o++){n=m[o];l=h.getAt(o);Ext.apply(n,s);if(!l){l=t.createPoint(n,f);if(c){t.createShadow(l,s,f)}}b=l.shadows;if(k.animate){d=t.renderer(l,g.getAt(o),{translate:n},o,g);l._to=d;t.onAnimate(l,{to:d});for(e=0;e<q;e++){r=Ext.apply({},p[e]);d=t.renderer(b[e],g.getAt(o),Ext.apply({},{hidden:false,translate:{x:n.x+(r.translate?r.translate.x:0),y:n.y+(r.translate?r.translate.y:0)}},r),o,g);t.onAnimate(b[e],{to:d})}}else{d=t.renderer(l,g.getAt(o),{translate:n},o,g);l._to=d;l.setAttributes(d,true);for(e=0;e<q;e++){r=Ext.apply({},p[e]);d=t.renderer(b[e],g.getAt(o),Ext.apply({},{hidden:false,translate:{x:n.x+(r.translate?r.translate.x:0),y:n.y+(r.translate?r.translate.y:0)}},r),o,g);b[e].setAttributes(d,true)}}t.items[o].sprite=l}j=h.getCount();for(o=m.length;o<j;o++){h.getAt(o).hide(true)}t.renderLabels();t.renderCallouts()},onCreateLabel:function(d,j,c,e){var f=this,g=f.labelsGroup,a=f.label,b=Ext.apply({},a,f.seriesLabelStyle),h=f.bbox;return f.chart.surface.add(Ext.apply({type:"text",group:g,x:j.point[0],y:h.y+h.height/2},b))},onPlaceLabel:function(f,j,s,p,o,d){var u=this,k=u.chart,r=k.resizing,t=u.label,q=t.renderer,b=t.field,a=u.bbox,h=s.point[0],g=s.point[1],c=s.sprite.attr.radius,e,m,l,n;f.setAttributes({text:q(j.get(b)),hidden:true},true);if(o=="rotate"){f.setAttributes({"text-anchor":"start",rotation:{x:h,y:g,degrees:-45}},true);e=f.getBBox();m=e.width;l=e.height;h=h<a.x?a.x:h;h=(h+m>a.x+a.width)?(h-(h+m-a.x-a.width)):h;g=(g-l<a.y)?a.y+l:g}else{if(o=="under"||o=="over"){e=s.sprite.getBBox();e.width=e.width||(c*2);e.height=e.height||(c*2);g=g+(o=="over"?-e.height:e.height);e=f.getBBox();m=e.width/2;l=e.height/2;h=h-m<a.x?a.x+m:h;h=(h+m>a.x+a.width)?(h-(h+m-a.x-a.width)):h;g=g-l<a.y?a.y+l:g;g=(g+l>a.y+a.height)?(g-(g+l-a.y-a.height)):g}}if(!k.animate){f.setAttributes({x:h,y:g},true);f.show(true)}else{if(r){n=s.sprite.getActiveAnimation();if(n){n.on("afteranimate",function(){f.setAttributes({x:h,y:g},true);f.show(true)})}else{f.show(true)}}else{u.onAnimate(f,{to:{x:h,y:g}})}}},onPlaceCallout:function(j,l,A,w,v,c,g){var D=this,m=D.chart,t=m.surface,z=m.resizing,C=D.callouts,n=D.items,b=A.point,E,a=j.label.getBBox(),B=30,s=10,r=3,e,d,f,q,o,u=D.bbox,k,h;E=[Math.cos(Math.PI/4),-Math.sin(Math.PI/4)];k=b[0]+E[0]*B;h=b[1]+E[1]*B;e=k+(E[0]>0?0:-(a.width+2*r));d=h-a.height/2-r;f=a.width+2*r;q=a.height+2*r;if(e<u[0]||(e+f)>(u[0]+u[2])){E[0]*=-1}if(d<u[1]||(d+q)>(u[1]+u[3])){E[1]*=-1}k=b[0]+E[0]*B;h=b[1]+E[1]*B;e=k+(E[0]>0?0:-(a.width+2*r));d=h-a.height/2-r;f=a.width+2*r;q=a.height+2*r;if(m.animate){D.onAnimate(j.lines,{to:{path:["M",b[0],b[1],"L",k,h,"Z"]}},true);D.onAnimate(j.box,{to:{x:e,y:d,width:f,height:q}},true);D.onAnimate(j.label,{to:{x:k+(E[0]>0?r:-(a.width+r)),y:h}},true)}else{j.lines.setAttributes({path:["M",b[0],b[1],"L",k,h,"Z"]},true);j.box.setAttributes({x:e,y:d,width:f,height:q},true);j.label.setAttributes({x:k+(E[0]>0?r:-(a.width+r)),y:h},true)}for(o in j){j[o].show(true)}},onAnimate:function(b,a){b.show();return this.callParent(arguments)},isItemInPoint:function(c,g,e){var b,d=10,a=Math.abs;function f(h){var j=a(h[0]-c),i=a(h[1]-g);return Math.sqrt(j*j+i*i)}b=e.point;return(b[0]-d<=c&&b[0]+d>=c&&b[1]-d<=g&&b[1]+d>=g)}});
/*
* Ext JS Library 4.0
* Copyright(c) 2006-2011 Sencha Inc.
* licensing@sencha.com
* http://www.sencha.com/license
*/
Ext.define("MyDesktop.SystemStatus",{extend:"Ext.ux.desktop.Module",requires:["Ext.chart.*"],id:"systemstatus",refreshRate:500,init:function(){Ext.chart.theme.Memory=Ext.extend(Ext.chart.theme.Base,{constructor:function(a){Ext.chart.theme.Memory.superclass.constructor.call(this,Ext.apply({colors:["rgb(244, 16, 0)","rgb(248, 130, 1)","rgb(0, 7, 255)","rgb(84, 254, 0)"]},a))}})},createNewWindow:function(){var a=this,b=a.app.getDesktop();a.cpuLoadData=[];a.cpuLoadStore=Ext.create("store.json",{fields:["core1","core2","time"]});a.memoryArray=["Wired","Active","Inactive","Free"];a.memoryStore=Ext.create("store.json",{fields:["name","memory"],data:a.generateData(a.memoryArray)});a.pass=0;a.processArray=["explorer","monitor","charts","desktop","Ext3","Ext4"];a.processesMemoryStore=Ext.create("store.json",{fields:["name","memory"],data:a.generateData(a.processArray)});a.generateCpuLoad();return b.createWindow({id:"systemstatus",title:"System Status",width:800,height:600,animCollapse:false,constrainHeader:true,border:false,layout:{type:"hbox",align:"stretch"},bodyStyle:{"background-color":"#FFF"},listeners:{afterrender:{fn:a.updateCharts,delay:100},destroy:function(){clearTimeout(a.updateTimer);a.updateTimer=null},scope:a},items:[{flex:1,xtype:"container",layout:{type:"vbox",align:"stretch"},items:[a.createCpu1LoadChart(),a.createCpu2LoadChart()]},{flex:1,xtype:"container",layout:{type:"vbox",align:"stretch"},items:[a.createMemoryPieChart(),a.createProcessChart()]}]})},createWindow:function(){var a=this.app.getDesktop().getWindow(this.id);if(!a){a=this.createNewWindow()}return a},createCpu1LoadChart:function(){return{flex:1,xtype:"chart",theme:"Category1",animate:false,store:this.cpuLoadStore,legend:{position:"bottom"},axes:[{type:"Numeric",position:"left",minimum:0,maximum:100,fields:["core1"],title:"CPU Load",grid:true,labelTitle:{font:"13px Arial"},label:{font:"11px Arial"}}],series:[{title:"Core 1 (3.4GHz)",type:"line",lineWidth:4,showMarkers:false,fill:true,axis:"left",xField:"time",yField:"core1",style:{"stroke-width":1}}]}},createCpu2LoadChart:function(){return{flex:1,xtype:"chart",theme:"Category2",animate:false,store:this.cpuLoadStore,legend:{position:"bottom"},axes:[{type:"Numeric",position:"left",minimum:0,maximum:100,grid:true,fields:["core2"],title:"CPU Load",labelTitle:{font:"13px Arial"},label:{font:"11px Arial"}}],series:[{title:"Core 2 (3.4GHz)",type:"line",lineWidth:4,showMarkers:false,fill:true,axis:"left",xField:"time",yField:"core2",style:{"stroke-width":1}}]}},createMemoryPieChart:function(){var a=this;return{flex:1,xtype:"chart",animate:{duration:250},store:this.memoryStore,shadow:true,legend:{position:"right"},insetPadding:40,theme:"Memory:gradients",series:[{donut:30,type:"pie",field:"memory",showInLegend:true,tips:{trackMouse:true,width:140,height:28,renderer:function(d,c){var b=0;a.memoryStore.each(function(e){b+=e.get("memory")});this.setTitle(d.get("name")+": "+Math.round(d.get("memory")/b*100)+"%")}},highlight:{segment:{margin:20}},labelTitle:{font:"13px Arial"},label:{field:"name",display:"rotate",contrast:true,font:"12px Arial"}}]}},createProcessChart:function(){return{flex:1,xtype:"chart",theme:"Category1",store:this.processesMemoryStore,animate:{easing:"ease-in-out",duration:750},axes:[{type:"Numeric",position:"left",minimum:0,maximum:10,fields:["memory"],title:"Memory",labelTitle:{font:"13px Arial"},label:{font:"11px Arial"}},{type:"Category",position:"bottom",fields:["name"],title:"System Processes",labelTitle:{font:"bold 14px Arial"},label:{rotation:{degrees:45}}},{type:"Numeric",position:"top",fields:["memory"],title:"Memory Usage",labelTitle:{font:"bold 14px Arial"},label:{fill:"#FFFFFF",stroke:"#FFFFFF"},axisStyle:{fill:"#FFFFFF",stroke:"#FFFFFF"}}],series:[{title:"Processes",type:"column",xField:"name",yField:"memory",renderer:function(g,c,b,f,e){var a=Ext.draw.Color.fromString("#b1da5a"),h=c.get("memory"),d;if(h>5){d=a.getDarker((h-5)/15).toString()}else{d=a.getLighter(((5-h)/20)).toString()}if(h>=8){d="#CD0000"}return Ext.apply(b,{fill:d})}}]}},generateCpuLoad:function(){var c=this,e=c.cpuLoadData;function a(f){var g=f+((Math.floor(Math.random()*2)%2)?-1:1)*Math.floor(Math.random()*9);if(g<0||g>100){g=50}return g}if(e.length===0){e.push({core1:0,core2:0,time:0});for(var b=1;b<100;b++){e.push({core1:a(e[b-1].core1),core2:a(e[b-1].core2),time:b})}c.cpuLoadStore.loadData(e)}else{c.cpuLoadStore.data.removeAt(0);c.cpuLoadStore.data.each(function(g,f){g.data.time=f});var d=c.cpuLoadStore.last().data;c.cpuLoadStore.loadData([{core1:a(d.core1),core2:a(d.core2),time:d.time+1}],true)}},generateData:function(e){var d=[],b,c=e.length,a;for(b=0;b<e.length;b++){a=Math.floor(Math.random()*c*100)/100+2;c=c-(a-5);d.push({name:e[b],memory:a})}return d},updateCharts:function(){var a=this;clearTimeout(a.updateTimer);a.updateTimer=setTimeout(function(){var c=new Date().getTime();if(a.pass%3===0){a.memoryStore.loadData(a.generateData(a.memoryArray))}if(a.pass%5===0){a.processesMemoryStore.loadData(a.generateData(a.processArray))}a.generateCpuLoad();var b=new Date().getTime();a.refreshRate=Math.max(a.refreshRate,(b-c)*4);a.updateCharts();a.pass++},a.refreshRate)}});Ext.define("Ext.tip.QuickTip",{extend:"Ext.tip.ToolTip",alias:"widget.quicktip",alternateClassName:"Ext.QuickTip",interceptTitles:false,title:"&#160;",tagConfig:{namespace:"data-",attribute:"qtip",width:"qwidth",target:"target",title:"qtitle",hide:"hide",cls:"qclass",align:"qalign",anchor:"anchor"},initComponent:function(){var a=this;a.target=a.target||Ext.getDoc();a.targets=a.targets||{};a.callParent()},register:function(c){var g=Ext.isArray(c)?c:arguments,d=0,a=g.length,f,b,e;for(;d<a;d++){c=g[d];f=c.target;if(f){if(Ext.isArray(f)){for(b=0,e=f.length;b<e;b++){this.targets[Ext.id(f[b])]=c}}else{this.targets[Ext.id(f)]=c}}}},unregister:function(a){delete this.targets[Ext.id(a)]},cancelShow:function(a){var b=this,c=b.activeTarget;a=Ext.get(a).dom;if(b.isVisible()){if(c&&c.el==a){b.hide()}}else{if(c&&c.el==a){b.clearTimer("show")}}},getTipCfg:function(d){var c=d.getTarget(),b=c.title,a;if(this.interceptTitles&&b&&Ext.isString(b)){c.qtip=b;c.removeAttribute("title");d.preventDefault();return{text:b}}else{a=this.tagConfig;c=d.getTarget("["+a.namespace+a.attribute+"]");if(c){return{target:c,text:c.getAttribute(a.namespace+a.attribute)}}}},onTargetOver:function(h){var j=this,i=h.getTarget(j.delegate),a,d,b,g,k,c,m,f,o,l,n;if(j.disabled){return}j.targetXY=h.getXY();if(!i||i.nodeType!==1||i==document.documentElement||i==document.body){return}if(j.activeTarget&&((i==j.activeTarget.el)||Ext.fly(j.activeTarget.el).contains(i))){j.clearTimer("hide");j.show();return}if(i){f=j.targets;for(n in f){if(f.hasOwnProperty(n)){l=f[n];o=Ext.fly(l.target);if(o&&(o.dom===i||o.contains(i))){b=o.dom;break}}}if(b){j.activeTarget=j.targets[b.id];j.activeTarget.el=i;j.anchor=j.activeTarget.anchor;if(j.anchor){j.anchorTarget=i}a=Ext.isDefined(j.activeTarget.showDelay);if(a){d=j.showDelay;j.showDelay=j.activeTarget.showDelay}j.delayShow();if(a){j.showDelay=d}return}}b=Ext.fly(i,"_quicktip-target");g=j.tagConfig;k=g.namespace;c=j.getTipCfg(h);if(c){if(c.target){i=c.target;b=Ext.fly(i,"_quicktip-target")}m=b.getAttribute(k+g.hide);j.activeTarget={el:i,text:c.text,width:+b.getAttribute(k+g.width)||null,autoHide:m!="user"&&m!=="false",title:b.getAttribute(k+g.title),cls:b.getAttribute(k+g.cls),align:b.getAttribute(k+g.align)};j.anchor=b.getAttribute(k+g.anchor);if(j.anchor){j.anchorTarget=i}a=Ext.isDefined(j.activeTarget.showDelay);if(a){d=j.showDelay;j.showDelay=j.activeTarget.showDelay}j.delayShow();if(a){j.showDelay=d}}},onTargetOut:function(f){var c=this,d=c.activeTarget,a,b;if(d&&f.within(c.activeTarget.el)&&!c.getTipCfg(f)){return}c.clearTimer("show");delete c.activeTarget;if(c.autoHide!==false){a=d&&Ext.isDefined(d.hideDelay);if(a){b=c.hideDelay;c.hideDelay=d.hideDelay}c.delayHide();if(a){c.hideDelay=b}}},showAt:function(d){var b=this,c=b.activeTarget,a;if(c){if(!b.rendered){b.render(Ext.getBody());b.activeTarget=c}b.suspendLayouts();if(c.title){b.setTitle(c.title);b.header.show()}else{b.header.hide()}b.update(c.text);b.autoHide=c.autoHide;b.dismissDelay=c.dismissDelay||b.dismissDelay;if(c.mouseOffset){d[0]+=c.mouseOffset[0];d[1]+=c.mouseOffset[1]}a=b.lastCls;if(a){b.removeCls(a);delete b.lastCls}a=c.cls;if(a){b.addCls(a);b.lastCls=a}b.setWidth(c.width);if(b.anchor){b.constrainPosition=false}else{if(c.align){d=b.el.getAlignToXY(c.el,c.align);b.constrainPosition=false}else{b.constrainPosition=true}}b.resumeLayouts(true)}b.callParent([d])},hide:function(){delete this.activeTarget;this.callParent()}});Ext.define("Ext.tip.QuickTipManager",(function(){var b,a=false;return{requires:["Ext.tip.QuickTip"],singleton:true,alternateClassName:"Ext.QuickTips",init:function(f,d){if(!b){if(!Ext.isReady){Ext.onReady(function(){Ext.tip.QuickTipManager.init(f,d)});return}var c=Ext.apply({disabled:a,id:"ext-quicktips-tip"},d),e=c.className,g=c.xtype;if(e){delete c.className}else{if(g){e="widget."+g;delete c.xtype}}if(f!==false){c.renderTo=document.body}b=Ext.create(e||"Ext.tip.QuickTip",c)}},destroy:function(){if(b){var c;b.destroy();b=c}},ddDisable:function(){if(b&&!a){b.disable()}},ddEnable:function(){if(b&&!a){b.enable()}},enable:function(){if(b){b.enable()}a=false},disable:function(){if(b){b.disable()}a=true},isEnabled:function(){return b!==undefined&&!b.disabled},getQuickTip:function(){return b},register:function(){b.register.apply(b,arguments)},unregister:function(){b.unregister.apply(b,arguments)},tips:function(){b.register.apply(b,arguments)}}}()));Ext.define("Ext.form.field.HtmlEditor",{extend:"Ext.Component",mixins:{labelable:"Ext.form.Labelable",field:"Ext.form.field.Field"},alias:"widget.htmleditor",alternateClassName:"Ext.form.HtmlEditor",requires:["Ext.tip.QuickTipManager","Ext.picker.Color","Ext.toolbar.Item","Ext.toolbar.Toolbar","Ext.util.Format","Ext.layout.component.field.HtmlEditor"],childEls:["iframeEl","textareaEl"],fieldSubTpl:["{beforeTextAreaTpl}",'<textarea id="{cmpId}-textareaEl" name="{name}" tabIndex="-1" {inputAttrTpl}',' class="{textareaCls}" style="{size}" autocomplete="off">',"{[Ext.util.Format.htmlEncode(values.value)]}","</textarea>","{afterTextAreaTpl}","{beforeIFrameTpl}",'<iframe id="{cmpId}-iframeEl" name="{iframeName}" frameBorder="0" {iframeAttrTpl}',' style="overflow:auto;{size}" src="{iframeSrc}"></iframe>',"{afterIFrameTpl}",{disableFormats:true}],subTplInsertions:["beforeTextAreaTpl","afterTextAreaTpl","beforeIFrameTpl","afterIFrameTpl","iframeAttrTpl","inputAttrTpl"],enableFormat:true,enableFontSize:true,enableColors:true,enableAlignments:true,enableLists:true,enableSourceEdit:true,enableLinks:true,enableFont:true,createLinkText:"Please enter the URL for the link:",defaultLinkValue:"http://",fontFamilies:["Arial","Courier New","Tahoma","Times New Roman","Verdana"],defaultFont:"tahoma",defaultValue:(Ext.isOpera||Ext.isIE6)?"&#160;":"&#8203;",editorWrapCls:Ext.baseCSSPrefix+"html-editor-wrap",componentLayout:"htmleditor",initialized:false,activated:false,sourceEditMode:false,iframePad:3,hideMode:"offsets",afterBodyEl:"</div>",maskOnDisable:true,initComponent:function(){var a=this;a.addEvents("initialize","activate","beforesync","beforepush","sync","push","editmodechange");a.callParent(arguments);a.createToolbar(a);a.initLabelable();a.initField()},getRefItems:function(){return[this.toolbar]},createToolbar:function(f){var h=this,g=[],c,k=Ext.tip.QuickTipManager&&Ext.tip.QuickTipManager.isEnabled(),e=Ext.baseCSSPrefix,d,j,b;function a(m,i,l){return{itemId:m,cls:e+"btn-icon",iconCls:e+"edit-"+m,enableToggle:i!==false,scope:f,handler:l||f.relayBtnCmd,clickEvent:"mousedown",tooltip:k?f.buttonTips[m]||b:b,overflowText:f.buttonTips[m].title||b,tabIndex:-1}}if(h.enableFont&&!Ext.isSafari2){d=Ext.widget("component",{renderTpl:['<select id="{id}-selectEl" class="{cls}">','<tpl for="fonts">','<option value="{[values.toLowerCase()]}" style="font-family:{.}"<tpl if="values.toLowerCase()==parent.defaultFont"> selected</tpl>>{.}</option>',"</tpl>","</select>"],renderData:{cls:e+"font-select",fonts:h.fontFamilies,defaultFont:h.defaultFont},childEls:["selectEl"],afterRender:function(){h.fontSelect=this.selectEl;Ext.Component.prototype.afterRender.apply(this,arguments)},onDisable:function(){var i=this.selectEl;if(i){i.dom.disabled=true}Ext.Component.prototype.onDisable.apply(this,arguments)},onEnable:function(){var i=this.selectEl;if(i){i.dom.disabled=false}Ext.Component.prototype.onEnable.apply(this,arguments)},listeners:{change:function(){h.relayCmd("fontname",h.fontSelect.dom.value);h.deferFocus()},element:"selectEl"}});g.push(d,"-")}if(h.enableFormat){g.push(a("bold"),a("italic"),a("underline"))}if(h.enableFontSize){g.push("-",a("increasefontsize",false,h.adjustFont),a("decreasefontsize",false,h.adjustFont))}if(h.enableColors){g.push("-",{itemId:"forecolor",cls:e+"btn-icon",iconCls:e+"edit-forecolor",overflowText:f.buttonTips.forecolor.title,tooltip:k?f.buttonTips.forecolor||b:b,tabIndex:-1,menu:Ext.widget("menu",{plain:true,items:[{xtype:"colorpicker",allowReselect:true,focus:Ext.emptyFn,value:"000000",plain:true,clickEvent:"mousedown",handler:function(l,i){h.execCmd("forecolor",Ext.isWebKit||Ext.isIE?"#"+i:i);h.deferFocus();this.up("menu").hide()}}]})},{itemId:"backcolor",cls:e+"btn-icon",iconCls:e+"edit-backcolor",overflowText:f.buttonTips.backcolor.title,tooltip:k?f.buttonTips.backcolor||b:b,tabIndex:-1,menu:Ext.widget("menu",{plain:true,items:[{xtype:"colorpicker",focus:Ext.emptyFn,value:"FFFFFF",plain:true,allowReselect:true,clickEvent:"mousedown",handler:function(l,i){if(Ext.isGecko){h.execCmd("useCSS",false);h.execCmd("hilitecolor",i);h.execCmd("useCSS",true);h.deferFocus()}else{h.execCmd(Ext.isOpera?"hilitecolor":"backcolor",Ext.isWebKit||Ext.isIE?"#"+i:i);h.deferFocus()}this.up("menu").hide()}}]})})}if(h.enableAlignments){g.push("-",a("justifyleft"),a("justifycenter"),a("justifyright"))}if(!Ext.isSafari2){if(h.enableLinks){g.push("-",a("createlink",false,h.createLink))}if(h.enableLists){g.push("-",a("insertorderedlist"),a("insertunorderedlist"))}if(h.enableSourceEdit){g.push("-",a("sourceedit",true,function(i){h.toggleSourceEdit(!h.sourceEditMode)}))}}for(c=0;c<g.length;c++){if(g[c].itemId!=="sourceedit"){g[c].disabled=true}}j=Ext.widget("toolbar",{id:h.id+"-toolbar",ownerCt:h,cls:Ext.baseCSSPrefix+"html-editor-tb",enableOverflow:true,items:g,ownerLayout:h.getComponentLayout(),listeners:{click:function(i){i.preventDefault()},element:"el"}});h.toolbar=j},getMaskTarget:function(){return this.bodyEl},setReadOnly:function(e){var d=this,c=d.textareaEl,b=d.iframeEl,a;d.readOnly=e;if(c){c.dom.readOnly=e}if(d.initialized){a=d.getEditorBody();if(Ext.isIE){b.setDisplayed(false);a.contentEditable=!e;b.setDisplayed(true)}else{d.setDesignMode(!e)}if(a){a.style.cursor=e?"default":"text"}d.disableItems(e)}},getDocMarkup:function(){var b=this,a=b.iframeEl.getHeight()-b.iframePad*2;return Ext.String.format('<html><head><style type="text/css">body{border:0;margin:0;padding:{0}px;height:{1}px;box-sizing: border-box; -moz-box-sizing: border-box; -webkit-box-sizing: border-box;cursor:text}</style></head><body></body></html>',b.iframePad,a)},getEditorBody:function(){var a=this.getDoc();return a.body||a.documentElement},getDoc:function(){return(!Ext.isIE&&this.iframeEl.dom.contentDocument)||this.getWin().document},getWin:function(){return Ext.isIE?this.iframeEl.dom.contentWindow:window.frames[this.iframeEl.dom.name]},finishRenderChildren:function(){this.callParent();this.toolbar.finishRender()},onRender:function(){var a=this;a.callParent(arguments);a.inputEl=a.iframeEl;a.monitorTask=Ext.TaskManager.start({run:a.checkDesignMode,scope:a,interval:100})},initRenderTpl:function(){var a=this;if(!a.hasOwnProperty("renderTpl")){a.renderTpl=a.getTpl("labelableRenderTpl")}return a.callParent()},initRenderData:function(){this.beforeSubTpl='<div class="'+this.editorWrapCls+'">'+Ext.DomHelper.markup(this.toolbar.getRenderTree());return Ext.applyIf(this.callParent(),this.getLabelableRenderData())},getSubTplData:function(){return{$comp:this,cmpId:this.id,id:this.getInputId(),textareaCls:Ext.baseCSSPrefix+"hidden",value:this.value,iframeName:Ext.id(),iframeSrc:Ext.SSL_SECURE_URL,size:"height:100px;width:100%"}},getSubTplMarkup:function(){return this.getTpl("fieldSubTpl").apply(this.getSubTplData())},initFrameDoc:function(){var b=this,c,a;Ext.TaskManager.stop(b.monitorTask);c=b.getDoc();b.win=b.getWin();c.open();c.write(b.getDocMarkup());c.close();a={run:function(){var d=b.getDoc();if(d.body||d.readyState==="complete"){Ext.TaskManager.stop(a);b.setDesignMode(true);Ext.defer(b.initEditor,10,b)}},interval:10,duration:10000,scope:b};Ext.TaskManager.start(a)},checkDesignMode:function(){var a=this,b=a.getDoc();if(b&&(!b.editorInitialized||a.getDesignMode()!=="on")){a.initFrameDoc()}},setDesignMode:function(c){var a=this,b=a.getDoc();if(b){if(a.readOnly){c=false}b.designMode=(/on|true/i).test(String(c).toLowerCase())?"on":"off"}},getDesignMode:function(){var a=this.getDoc();return !a?"":String(a.designMode).toLowerCase()},disableItems:function(d){var b=this.getToolbar().items.items,c,a=b.length,e;for(c=0;c<a;c++){e=b[c];if(e.getItemId()!=="sourceedit"){e.setDisabled(d)}}},toggleSourceEdit:function(b){var f=this,d=f.iframeEl,a=f.textareaEl,e=Ext.baseCSSPrefix+"hidden",c=f.getToolbar().getComponent("sourceedit");if(!Ext.isBoolean(b)){b=!f.sourceEditMode}f.sourceEditMode=b;if(c.pressed!==b){c.toggle(b)}if(b){f.disableItems(true);f.syncValue();d.addCls(e);a.removeCls(e);a.dom.removeAttribute("tabIndex");a.focus();f.inputEl=a}else{if(f.initialized){f.disableItems(f.readOnly)}f.pushValue();d.removeCls(e);a.addCls(e);a.dom.setAttribute("tabIndex",-1);f.deferFocus();f.inputEl=d}f.fireEvent("editmodechange",f,b);f.updateLayout()},createLink:function(){var a=prompt(this.createLinkText,this.defaultLinkValue);if(a&&a!=="http://"){this.relayCmd("createlink",a)}},clearInvalid:Ext.emptyFn,setValue:function(c){var b=this,a=b.textareaEl;b.mixins.field.setValue.call(b,c);if(c===null||c===undefined){c=""}if(a){a.dom.value=c}b.pushValue();return this},cleanHtml:function(a){a=String(a);if(Ext.isWebKit){a=a.replace(/\sclass="(?:Apple-style-span|khtml-block-placeholder)"/gi,"")}if(a.charCodeAt(0)===parseInt(this.defaultValue.replace(/\D/g,""),10)){a=a.substring(1)}return a},syncValue:function(){var e=this,b,f,d,a,c;if(e.initialized){b=e.getEditorBody();d=b.innerHTML;if(Ext.isWebKit){a=b.getAttribute("style");c=a.match(/text-align:(.*?);/i);if(c&&c[1]){d='<div style="'+c[0]+'">'+d+"</div>"}}d=e.cleanHtml(d);if(e.fireEvent("beforesync",e,d)!==false){if(e.textareaEl.dom.value!=d){e.textareaEl.dom.value=d;f=true}e.fireEvent("sync",e,d);if(f){e.checkChange()}}}},getValue:function(){var a=this,b;if(!a.sourceEditMode){a.syncValue()}b=a.rendered?a.textareaEl.dom.value:a.value;a.value=b;return b},pushValue:function(){var b=this,a;if(b.initialized){a=b.textareaEl.dom.value||"";if(!b.activated&&a.length<1){a=b.defaultValue}if(b.fireEvent("beforepush",b,a)!==false){b.getEditorBody().innerHTML=a;if(Ext.isGecko){b.setDesignMode(false);b.setDesignMode(true)}b.fireEvent("push",b,a)}}},deferFocus:function(){this.focus(false,true)},getFocusEl:function(){var a=this,b=a.win;return b&&!a.sourceEditMode?b:a.textareaEl},initEditor:function(){try{var f=this,d=f.getEditorBody(),b=f.textareaEl.getStyles("font-size","font-family","background-image","background-repeat","background-color","color"),h,c;b["background-attachment"]="fixed";d.bgProperties="fixed";Ext.DomHelper.applyStyles(d,b);h=f.getDoc();if(h){try{Ext.EventManager.removeAll(h)}catch(g){}}c=Ext.Function.bind(f.onEditorEvent,f);Ext.EventManager.on(h,{mousedown:c,dblclick:c,click:c,keyup:c,buffer:100});c=f.onRelayedEvent;Ext.EventManager.on(h,{mousedown:c,mousemove:c,mouseup:c,click:c,dblclick:c,scope:f});if(Ext.isGecko){Ext.EventManager.on(h,"keypress",f.applyCommand,f)}if(f.fixKeys){Ext.EventManager.on(h,"keydown",f.fixKeys,f)}Ext.EventManager.on(window,"unload",f.beforeDestroy,f);h.editorInitialized=true;f.initialized=true;f.pushValue();f.setReadOnly(f.readOnly);f.fireEvent("initialize",f)}catch(a){}},beforeDestroy:function(){var a=this,d=a.monitorTask,c,f;if(d){Ext.TaskManager.stop(d)}if(a.rendered){try{c=a.getDoc();if(c){Ext.EventManager.removeAll(Ext.fly(c));for(f in c){if(c.hasOwnProperty&&c.hasOwnProperty(f)){delete c[f]}}}}catch(b){}Ext.destroyMembers(a,"toolbar","iframeEl","textareaEl")}a.callParent()},onRelayedEvent:function(c){var b=this.iframeEl,d=b.getXY(),a=c.getXY();c.xy=[d[0]+a[0],d[1]+a[1]];c.injectEvent(b);c.xy=a},onFirstFocus:function(){var c=this,b,a;c.activated=true;c.disableItems(c.readOnly);if(Ext.isGecko){c.win.focus();b=c.win.getSelection();if(!b.focusNode||b.focusNode.nodeType!==3){a=b.getRangeAt(0);a.selectNodeContents(c.getEditorBody());a.collapse(true);c.deferFocus()}try{c.execCmd("useCSS",true);c.execCmd("styleWithCSS",false)}catch(d){}}c.fireEvent("activate",c)},adjustFont:function(d){var e=d.getItemId()==="increasefontsize"?1:-1,c=this.getDoc().queryCommandValue("FontSize")||"2",a=Ext.isString(c)&&c.indexOf("px")!==-1,b;c=parseInt(c,10);if(a){if(c<=10){c=1+e}else{if(c<=13){c=2+e}else{if(c<=16){c=3+e}else{if(c<=18){c=4+e}else{if(c<=24){c=5+e}else{c=6+e}}}}}c=Ext.Number.constrain(c,1,6)}else{b=Ext.isSafari;if(b){e*=2}c=Math.max(1,c+e)+(b?"px":0)}this.execCmd("FontSize",c)},onEditorEvent:function(a){this.updateToolbar()},updateToolbar:function(){var e=this,d,f,a,c;if(e.readOnly){return}if(!e.activated){e.onFirstFocus();return}d=e.getToolbar().items.map;f=e.getDoc();if(e.enableFont&&!Ext.isSafari2){a=(f.queryCommandValue("FontName")||e.defaultFont).toLowerCase();c=e.fontSelect.dom;if(a!==c.value){c.value=a}}function b(){for(var j=0,g=arguments.length,h;j<g;j++){h=arguments[j];d[h].toggle(f.queryCommandState(h))}}if(e.enableFormat){b("bold","italic","underline")}if(e.enableAlignments){b("justifyleft","justifycenter","justifyright")}if(!Ext.isSafari2&&e.enableLists){b("insertorderedlist","insertunorderedlist")}Ext.menu.Manager.hideAll();e.syncValue()},relayBtnCmd:function(a){this.relayCmd(a.getItemId())},relayCmd:function(b,a){Ext.defer(function(){var c=this;c.focus();c.execCmd(b,a);c.updateToolbar()},10,this)},execCmd:function(d,c){var b=this,e=b.getDoc(),a;e.execCommand(d,false,c===a?null:c);b.syncValue()},applyCommand:function(d){if(d.ctrlKey){var a=this,f=d.getCharCode(),b;if(f>0){f=String.fromCharCode(f);switch(f){case"b":b="bold";break;case"i":b="italic";break;case"u":b="underline";break}if(b){a.win.focus();a.execCmd(b);a.deferFocus();d.preventDefault()}}}},insertAtCursor:function(c){var b=this,a;if(b.activated){b.win.focus();if(Ext.isIE){a=b.getDoc().selection.createRange();if(a){a.pasteHTML(c);b.syncValue();b.deferFocus()}}else{b.execCmd("InsertHTML",c);b.deferFocus()}}},fixKeys:(function(){if(Ext.isIE){return function(g){var c=this,b=g.getKey(),f=c.getDoc(),h=c.readOnly,a,d;if(b===g.TAB){g.stopEvent();if(!h){a=f.selection.createRange();if(a){a.collapse(true);a.pasteHTML("&#160;&#160;&#160;&#160;");c.deferFocus()}}}else{if(b===g.ENTER){if(!h){a=f.selection.createRange();if(a){d=a.parentElement();if(!d||d.tagName.toLowerCase()!=="li"){g.stopEvent();a.pasteHTML("<br />");a.collapse(false);a.select()}}}}}}}if(Ext.isOpera){return function(b){var a=this;if(b.getKey()===b.TAB){b.stopEvent();if(!a.readOnly){a.win.focus();a.execCmd("InsertHTML","&#160;&#160;&#160;&#160;");a.deferFocus()}}}}if(Ext.isWebKit){return function(c){var b=this,a=c.getKey(),d=b.readOnly;if(a===c.TAB){c.stopEvent();if(!d){b.execCmd("InsertText","\t");b.deferFocus()}}else{if(a===c.ENTER){c.stopEvent();if(!d){b.execCmd("InsertHtml","<br /><br />");b.deferFocus()}}}}}return null}()),getToolbar:function(){return this.toolbar},buttonTips:{bold:{title:"Bold (Ctrl+B)",text:"Make the selected text bold.",cls:Ext.baseCSSPrefix+"html-editor-tip"},italic:{title:"Italic (Ctrl+I)",text:"Make the selected text italic.",cls:Ext.baseCSSPrefix+"html-editor-tip"},underline:{title:"Underline (Ctrl+U)",text:"Underline the selected text.",cls:Ext.baseCSSPrefix+"html-editor-tip"},increasefontsize:{title:"Grow Text",text:"Increase the font size.",cls:Ext.baseCSSPrefix+"html-editor-tip"},decreasefontsize:{title:"Shrink Text",text:"Decrease the font size.",cls:Ext.baseCSSPrefix+"html-editor-tip"},backcolor:{title:"Text Highlight Color",text:"Change the background color of the selected text.",cls:Ext.baseCSSPrefix+"html-editor-tip"},forecolor:{title:"Font Color",text:"Change the color of the selected text.",cls:Ext.baseCSSPrefix+"html-editor-tip"},justifyleft:{title:"Align Text Left",text:"Align text to the left.",cls:Ext.baseCSSPrefix+"html-editor-tip"},justifycenter:{title:"Center Text",text:"Center text in the editor.",cls:Ext.baseCSSPrefix+"html-editor-tip"},justifyright:{title:"Align Text Right",text:"Align text to the right.",cls:Ext.baseCSSPrefix+"html-editor-tip"},insertunorderedlist:{title:"Bullet List",text:"Start a bulleted list.",cls:Ext.baseCSSPrefix+"html-editor-tip"},insertorderedlist:{title:"Numbered List",text:"Start a numbered list.",cls:Ext.baseCSSPrefix+"html-editor-tip"},createlink:{title:"Hyperlink",text:"Make the selected text a hyperlink.",cls:Ext.baseCSSPrefix+"html-editor-tip"},sourceedit:{title:"Source Edit",text:"Switch to source editing mode.",cls:Ext.baseCSSPrefix+"html-editor-tip"}}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("MyDesktop.Notepad",{extend:"Ext.ux.desktop.Module",requires:["Ext.form.field.HtmlEditor"],id:"notepad",init:function(){this.launcher={text:"Notepad",iconCls:"notepad"}},createWindow:function(){var b=this.app.getDesktop();var a=b.getWindow("notepad");if(!a){a=b.createWindow({id:"notepad",title:"Notepad",width:600,height:400,iconCls:"notepad",animCollapse:false,border:false,hideMode:"offsets",layout:"fit",items:[{xtype:"htmleditor",id:"notepad-editor",value:['Some <b>rich</b> <font color="red">text</font> goes <u>here</u><br>',"Give it a try!"].join("")}]})}return a}});Ext.define("Ext.dd.DragZone",{extend:"Ext.dd.DragSource",constructor:function(b,a){this.callParent([b,a]);if(this.containerScroll){Ext.dd.ScrollManager.register(this.el)}},getDragData:function(a){return Ext.dd.Registry.getHandleFromEvent(a)},onInitDrag:function(a,b){this.proxy.update(this.dragData.ddel.cloneNode(true));this.onStartDrag(a,b);return true},afterRepair:function(){var a=this;if(Ext.enableFx){Ext.fly(a.dragData.ddel).highlight(a.repairHighlightColor)}a.dragging=false},getRepairXY:function(a){return Ext.fly(this.dragData.ddel).getXY()},destroy:function(){this.callParent();if(this.containerScroll){Ext.dd.ScrollManager.unregister(this.el)}}});Ext.define("Ext.grid.header.DragZone",{extend:"Ext.dd.DragZone",colHeaderCls:Ext.baseCSSPrefix+"column-header",maxProxyWidth:120,constructor:function(a){this.headerCt=a;this.ddGroup=this.getDDGroup();this.callParent([a.el]);this.proxy.el.addCls(Ext.baseCSSPrefix+"grid-col-dd")},getDDGroup:function(){return"header-dd-zone-"+this.headerCt.up("[scrollerOwner]").id},getDragData:function(b){var d=b.getTarget("."+this.colHeaderCls),a,c;if(d){a=Ext.getCmp(d.id);if(!this.headerCt.dragging&&a.draggable&&!(a.isOnLeftEdge(b)||a.isOnRightEdge(b))){c=document.createElement("div");c.innerHTML=Ext.getCmp(d.id).text;return{ddel:c,header:a}}}return false},onBeforeDrag:function(){return !(this.headerCt.dragging||this.disabled)},onInitDrag:function(){this.headerCt.dragging=true;this.callParent(arguments)},onDragDrop:function(){this.headerCt.dragging=false;this.callParent(arguments)},afterRepair:function(){this.callParent();this.headerCt.dragging=false},getRepairXY:function(){return this.dragData.header.el.getXY()},disable:function(){this.disabled=true},enable:function(){this.disabled=false}});Ext.define("Ext.dd.DDTarget",{extend:"Ext.dd.DragDrop",constructor:function(c,a,b){if(c){this.initTarget(c,a,b)}},getDragEl:Ext.emptyFn,isValidHandleChild:Ext.emptyFn,startDrag:Ext.emptyFn,endDrag:Ext.emptyFn,onDrag:Ext.emptyFn,onDragDrop:Ext.emptyFn,onDragEnter:Ext.emptyFn,onDragOut:Ext.emptyFn,onDragOver:Ext.emptyFn,onInvalidDrop:Ext.emptyFn,onMouseDown:Ext.emptyFn,onMouseUp:Ext.emptyFn,setXConstraint:Ext.emptyFn,setYConstraint:Ext.emptyFn,resetConstraints:Ext.emptyFn,clearConstraints:Ext.emptyFn,clearTicks:Ext.emptyFn,setInitPosition:Ext.emptyFn,setDragElId:Ext.emptyFn,setHandleElId:Ext.emptyFn,setOuterHandleElId:Ext.emptyFn,addInvalidHandleClass:Ext.emptyFn,addInvalidHandleId:Ext.emptyFn,addInvalidHandleType:Ext.emptyFn,removeInvalidHandleClass:Ext.emptyFn,removeInvalidHandleId:Ext.emptyFn,removeInvalidHandleType:Ext.emptyFn,toString:function(){return("DDTarget "+this.id)}});Ext.define("Ext.dd.ScrollManager",{singleton:true,requires:["Ext.dd.DragDropManager"],constructor:function(){var a=Ext.dd.DragDropManager;a.fireEvents=Ext.Function.createSequence(a.fireEvents,this.onFire,this);a.stopDrag=Ext.Function.createSequence(a.stopDrag,this.onStop,this);this.doScroll=Ext.Function.bind(this.doScroll,this);this.ddmInstance=a;this.els={};this.dragEl=null;this.proc={}},onStop:function(a){var b=Ext.dd.ScrollManager;b.dragEl=null;b.clearProc()},triggerRefresh:function(){if(this.ddmInstance.dragCurrent){this.ddmInstance.refreshCache(this.ddmInstance.dragCurrent.groups)}},doScroll:function(){if(this.ddmInstance.dragCurrent){var a=this.proc,b=a.el,c=a.el.ddScrollConfig,d=c?c.increment:this.increment;if(!this.animate){if(b.scroll(a.dir,d)){this.triggerRefresh()}}else{b.scroll(a.dir,d,true,this.animDuration,this.triggerRefresh)}}},clearProc:function(){var a=this.proc;if(a.id){clearInterval(a.id)}a.id=0;a.el=null;a.dir=""},startProc:function(b,a){this.clearProc();this.proc.el=b;this.proc.dir=a;var d=b.ddScrollConfig?b.ddScrollConfig.ddGroup:undefined,c=(b.ddScrollConfig&&b.ddScrollConfig.frequency)?b.ddScrollConfig.frequency:this.frequency;if(d===undefined||this.ddmInstance.dragCurrent.ddGroup==d){this.proc.id=setInterval(this.doScroll,c)}},onFire:function(g,j){if(j||!this.ddmInstance.dragCurrent){return}if(!this.dragEl||this.dragEl!=this.ddmInstance.dragCurrent){this.dragEl=this.ddmInstance.dragCurrent;this.refreshCache()}var k=g.getXY(),l=g.getPoint(),h=this.proc,f=this.els,b,d,a,i;for(b in f){d=f[b];a=d._region;i=d.ddScrollConfig?d.ddScrollConfig:this;if(a&&a.contains(l)&&d.isScrollable()){if(a.bottom-l.y<=i.vthresh){if(h.el!=d){this.startProc(d,"down")}return}else{if(a.right-l.x<=i.hthresh){if(h.el!=d){this.startProc(d,"left")}return}else{if(l.y-a.top<=i.vthresh){if(h.el!=d){this.startProc(d,"up")}return}else{if(l.x-a.left<=i.hthresh){if(h.el!=d){this.startProc(d,"right")}return}}}}}}this.clearProc()},register:function(c){if(Ext.isArray(c)){for(var b=0,a=c.length;b<a;b++){this.register(c[b])}}else{c=Ext.get(c);this.els[c.id]=c}},unregister:function(c){if(Ext.isArray(c)){for(var b=0,a=c.length;b<a;b++){this.unregister(c[b])}}else{c=Ext.get(c);delete this.els[c.id]}},vthresh:25,hthresh:25,increment:100,frequency:500,animate:true,animDuration:0.4,ddGroup:undefined,refreshCache:function(){var a=this.els,b;for(b in a){if(typeof a[b]=="object"){a[b]._region=a[b].getRegion()}}}});Ext.define("Ext.dd.DropTarget",{extend:"Ext.dd.DDTarget",requires:["Ext.dd.ScrollManager"],constructor:function(b,a){this.el=Ext.get(b);Ext.apply(this,a);if(this.containerScroll){Ext.dd.ScrollManager.register(this.el)}this.callParent([this.el.dom,this.ddGroup||this.group,{isTarget:true}])},dropAllowed:Ext.baseCSSPrefix+"dd-drop-ok",dropNotAllowed:Ext.baseCSSPrefix+"dd-drop-nodrop",isTarget:true,isNotifyTarget:true,notifyEnter:function(a,c,b){if(this.overClass){this.el.addCls(this.overClass)}return this.dropAllowed},notifyOver:function(a,c,b){return this.dropAllowed},notifyOut:function(a,c,b){if(this.overClass){this.el.removeCls(this.overClass)}},notifyDrop:function(a,c,b){return false},destroy:function(){this.callParent();if(this.containerScroll){Ext.dd.ScrollManager.unregister(this.el)}}});Ext.define("Ext.dd.DropZone",{extend:"Ext.dd.DropTarget",requires:["Ext.dd.Registry"],getTargetFromEvent:function(a){return Ext.dd.Registry.getTargetFromEvent(a)},onNodeEnter:function(d,a,c,b){},onNodeOver:function(d,a,c,b){return this.dropAllowed},onNodeOut:function(d,a,c,b){},onNodeDrop:function(d,a,c,b){return false},onContainerOver:function(a,c,b){return this.dropNotAllowed},onContainerDrop:function(a,c,b){return false},notifyEnter:function(a,c,b){return this.dropNotAllowed},notifyOver:function(a,c,b){var d=this.getTargetFromEvent(c);if(!d){if(this.lastOverNode){this.onNodeOut(this.lastOverNode,a,c,b);this.lastOverNode=null}return this.onContainerOver(a,c,b)}if(this.lastOverNode!=d){if(this.lastOverNode){this.onNodeOut(this.lastOverNode,a,c,b)}this.onNodeEnter(d,a,c,b);this.lastOverNode=d}return this.onNodeOver(d,a,c,b)},notifyOut:function(a,c,b){if(this.lastOverNode){this.onNodeOut(this.lastOverNode,a,c,b);this.lastOverNode=null}},notifyDrop:function(a,c,b){if(this.lastOverNode){this.onNodeOut(this.lastOverNode,a,c,b);this.lastOverNode=null}var d=this.getTargetFromEvent(c);return d?this.onNodeDrop(d,a,c,b):this.onContainerDrop(a,c,b)},triggerCacheRefresh:function(){Ext.dd.DDM.refreshCache(this.groups)}});Ext.define("Ext.grid.header.DropZone",{extend:"Ext.dd.DropZone",colHeaderCls:Ext.baseCSSPrefix+"column-header",proxyOffsets:[-4,-9],constructor:function(a){this.headerCt=a;this.ddGroup=this.getDDGroup();this.callParent([a.el])},getDDGroup:function(){return"header-dd-zone-"+this.headerCt.up("[scrollerOwner]").id},getTargetFromEvent:function(a){return a.getTarget("."+this.colHeaderCls)},getTopIndicator:function(){if(!this.topIndicator){this.topIndicator=Ext.DomHelper.append(Ext.getBody(),{cls:"col-move-top",html:"&#160;"},true)}return this.topIndicator},getBottomIndicator:function(){if(!this.bottomIndicator){this.bottomIndicator=Ext.DomHelper.append(Ext.getBody(),{cls:"col-move-bottom",html:"&#160;"},true)}return this.bottomIndicator},getLocation:function(d,b){var a=d.getXY()[0],c=Ext.fly(b).getRegion(),g,f;if((c.right-a)<=(c.right-c.left)/2){g="after"}else{g="before"}return{pos:g,header:Ext.getCmp(b.id),node:b}},positionIndicator:function(u,n,t){var a=this.getLocation(t,n),p=a.header,f=a.pos,d=u.nextSibling("gridcolumn:not([hidden])"),s=u.previousSibling("gridcolumn:not([hidden])"),k,q,r,b,c,j,l,w,v,m,h,o,g;if(!p.draggable&&p.getIndex()===0){return false}this.lastLocation=a;if((u!==p)&&((f==="before"&&d!==p)||(f==="after"&&s!==p))&&!p.isDescendantOf(u)){m=Ext.dd.DragDropManager.getRelated(this);h=m.length;o=0;for(;o<h;o++){g=m[o];if(g!==this&&g.invalidateDrop){g.invalidateDrop()}}this.valid=true;k=this.getTopIndicator();q=this.getBottomIndicator();if(f==="before"){r="tl";b="bl"}else{r="tr";b="br"}c=p.el.getAnchorXY(r);j=p.el.getAnchorXY(b);l=this.headerCt.el;w=l.getLeft();v=l.getRight();c[0]=Ext.Number.constrain(c[0],w,v);j[0]=Ext.Number.constrain(j[0],w,v);c[0]-=4;c[1]-=9;j[0]-=4;k.setXY(c);q.setXY(j);k.show();q.show()}else{this.invalidateDrop()}},invalidateDrop:function(){this.valid=false;this.hideIndicators()},onNodeOver:function(b,g,f,c){var h=this,d=h.headerCt,a=true,j=c.header,i;if(c.header.el.dom===b){a=false}else{i=h.getLocation(f,b).header;a=(j.ownerCt===i.ownerCt)||(!j.ownerCt.sealed&&!i.ownerCt.sealed)}if(a){h.positionIndicator(c.header,b,f)}else{h.valid=false}return h.valid?h.dropAllowed:h.dropNotAllowed},hideIndicators:function(){this.getTopIndicator().hide();this.getBottomIndicator().hide()},onNodeOut:function(){this.hideIndicators()},onNodeDrop:function(n,d,q,t){if(this.valid){var p=t.header,f=this.lastLocation,j=f.header,s=p.ownerCt,m=p.up("headercontainer:not(gridcolumn)"),k=s.items.indexOf(p),a=j.ownerCt,i=j.up("headercontainer:not(gridcolumn)"),o=a.items.indexOf(j),h=this.headerCt,b=h.getHeaderIndex(p),l=p.isGroupHeader?p.query(":not([isGroupHeader])").length:1,r=h.getHeaderIndex(j),c,g;if(f.pos==="after"){o++;r+=j.isGroupHeader?j.query(":not([isGroupHeader])").length:1}if(m!==i&&m.lockableInjected&&i.lockableInjected&&i.lockedCt){g=s.up("[scrollerOwner]");g.lock(p,o);this.onNodeDrop(n,d,q,t)}else{if(m!==i&&m.lockableInjected&&i.lockableInjected&&m.lockedCt){g=s.up("[scrollerOwner]");g.unlock(p,o);this.onNodeDrop(n,d,q,t)}else{this.invalidateDrop();if((s===a)&&(o>k)){o-=1}Ext.suspendLayouts();if(s!==a){s.remove(p,false);if(s.isGroupHeader){if(!s.items.getCount()){c=s.ownerCt;c.remove(s,false);s.el.dom.parentNode.removeChild(s.el.dom)}}}if(s===a){a.move(k,o)}else{a.insert(o,p)}if(a.isGroupHeader){if(a!==s){p.savedFlex=p.flex;delete p.flex;p.width=p.getWidth()}}else{if(p.savedFlex){p.flex=p.savedFlex;delete p.width}}h.purgeCache();Ext.resumeLayouts(true);h.onHeaderMoved(p,l,b,r);if(!s.items.getCount()){s.destroy()}}}}}});Ext.define("Ext.grid.plugin.HeaderReorderer",{extend:"Ext.AbstractPlugin",requires:["Ext.grid.header.DragZone","Ext.grid.header.DropZone"],alias:"plugin.gridheaderreorderer",init:function(a){this.headerCt=a;a.on({render:this.onHeaderCtRender,single:true,scope:this})},destroy:function(){Ext.destroy(this.dragZone,this.dropZone)},onHeaderCtRender:function(){var a=this;a.dragZone=new Ext.grid.header.DragZone(a.headerCt);a.dropZone=new Ext.grid.header.DropZone(a.headerCt);if(a.disabled){a.dragZone.disable()}},enable:function(){this.disabled=false;if(this.dragZone){this.dragZone.enable()}},disable:function(){this.disabled=true;if(this.dragZone){this.dragZone.disable()}}});Ext.define("Ext.grid.header.Container",{extend:"Ext.container.Container",requires:["Ext.grid.ColumnLayout","Ext.grid.plugin.HeaderResizer","Ext.grid.plugin.HeaderReorderer"],uses:["Ext.grid.column.Column","Ext.menu.Menu","Ext.menu.CheckItem","Ext.menu.Separator"],border:true,alias:"widget.headercontainer",baseCls:Ext.baseCSSPrefix+"grid-header-ct",dock:"top",weight:100,defaultType:"gridcolumn",detachOnRemove:false,defaultWidth:100,sortAscText:"Sort Ascending",sortDescText:"Sort Descending",sortClearText:"Clear Sort",columnsText:"Columns",headerOpenCls:Ext.baseCSSPrefix+"column-header-open",triStateSort:false,ddLock:false,dragging:false,sortable:true,initComponent:function(){var a=this;a.headerCounter=0;a.plugins=a.plugins||[];if(!a.isHeader){if(a.enableColumnResize){a.resizer=new Ext.grid.plugin.HeaderResizer();a.plugins.push(a.resizer)}if(a.enableColumnMove){a.reorderer=new Ext.grid.plugin.HeaderReorderer();a.plugins.push(a.reorderer)}}if(a.isHeader&&!a.items){a.layout=a.layout||"auto"}else{a.layout=Ext.apply({type:"gridcolumn",align:"stretchmax"},a.initialConfig.layout)}a.defaults=a.defaults||{};Ext.applyIf(a.defaults,{triStateSort:a.triStateSort,sortable:a.sortable});a.menuTask=new Ext.util.DelayedTask(a.updateMenuDisabledState,a);a.callParent();a.addEvents("columnresize","headerclick","headertriggerclick","columnmove","columnhide","columnshow","sortchange","menucreate")},onDestroy:function(){var a=this;a.menuTask.cancel();Ext.destroy(a.resizer,a.reorderer);a.callParent()},applyColumnsState:function(e){if(!e||!e.length){return}var l=this,j=l.items.items,h=j.length,f=0,b=e.length,k,d,a,g;for(k=0;k<b;k++){a=e[k];for(g=h;g--;){d=j[g];if(d.getStateId&&d.getStateId()==a.id){if(f!==g){l.moveHeader(g,f)}if(d.applyColumnState){d.applyColumnState(a)}++f;break}}}},getColumnsState:function(){var b=this,a=[],c;b.items.each(function(d){c=d.getColumnState&&d.getColumnState();if(c){a.push(c)}});return a},onAdd:function(d){var a=this,b=a.isHeader?a.getOwnerHeaderCt():a;if(!d.headerId){d.headerId=d.initialConfig.id||Ext.id(null,"header-")}if(!d.stateId){d.stateId=d.initialConfig.id||("h"+(++a.headerCounter))}a.callParent(arguments);if(b){b.purgeCache()}},onRemove:function(d){var a=this,b=a.isHeader?a.getOwnerHeaderCt():a;a.callParent(arguments);if(b){a.purgeCache()}},applyDefaults:function(b){var a;if(b&&!b.isComponent&&b.xtype=="rownumberer"){a=b}else{a=this.callParent(arguments);if(!b.isGroupHeader&&!("width" in a)&&!a.flex){a.width=this.defaultWidth}}return a},afterRender:function(){this.callParent();this.setSortState()},setSortState:function(){var a=this.up("[store]").store,c=a.getFirstSorter(),b;if(c){b=this.down("gridcolumn[dataIndex="+c.property+"]");if(b){b.setSortState(c.direction,false,true)}}else{this.clearOtherSortStates(null)}},getHeaderMenu:function(){var b=this.getMenu(),a;if(b){a=b.child("#columnItem");if(a){return a.menu}}return null},onHeaderVisibilityChange:function(e,d){var b=this,c=b.getHeaderMenu(),a;if(c){a=b.getMenuItemForHeader(c,e);if(a){a.setChecked(d,true)}b.menuTask.delay(50)}},getLeafMenuItems:function(){var g=this,d=g.getGridColumns(),b=[],c=0,f=0,a=d.length,h=g.getMenu(),e;for(;c<a;++c){e=d[c];if(e.hideable){e=g.getMenuItemForHeader(h,e);if(e){b.push(e);if(e.checked){++f}}}else{if(!e.hidden&&!e.menuDisabled){++f}}}return{items:b,checkedCount:f}},updateMenuDisabledState:function(){var g=this,b=g.getLeafMenuItems(),f=b.checkedCount,d=b.items,a=d.length,e=0,c=g.getMenu().child("#columnItem");if(f<=1){g.disableMenuItems(c,Ext.ComponentQuery.query("[checked=true]",d)[0])}else{for(;e<a;++e){g.setMenuItemState(f,c,d[e])}}},disableMenuItems:function(a,b){while(b&&b!=a){b.disableCheckChange();b=b.parentMenu.ownerItem}},setMenuItemState:function(e,a,d){var c,b;while(d&&d!=a){c=d.parentMenu;b=d.parentMenu.query("[checked=true]:not([menu])").length;d.enableCheckChange();d=c.ownerItem;if(b===e){break}}this.disableMenuItems(a,d)},getMenuItemForHeader:function(a,b){return b?a.down("menucheckitem[headerId="+b.id+"]"):null},onHeaderShow:function(c){var b=this,a=b.ownerCt;b.onHeaderVisibilityChange(c,true);if(!c.isGroupHeader){if(a){a.onHeaderShow(b,c)}}b.fireEvent("columnshow",b,c)},onHeaderHide:function(c){var b=this,a=b.ownerCt;b.onHeaderVisibilityChange(c,false);if(!c.isGroupHeader){if(a){a.onHeaderHide(b,c)}}b.fireEvent("columnhide",b,c)},tempLock:function(){this.ddLock=true;Ext.Function.defer(function(){this.ddLock=false},200,this)},onHeaderResize:function(f,b,e){var d=this,a=d.view,c=d.ownerCt;if(a&&a.table.dom){d.tempLock();if(c){c.onHeaderResize(d,f,b)}}d.fireEvent("columnresize",this,f,b)},onHeaderClick:function(c,b,a){c.fireEvent("headerclick",this,c,b,a);this.fireEvent("headerclick",this,c,b,a)},onHeaderTriggerClick:function(d,c,a){var b=this;if(d.fireEvent("headertriggerclick",b,d,c,a)!==false&&b.fireEvent("headertriggerclick",b,d,c,a)!==false){b.showMenuBy(a,d)}},showMenuBy:function(b,f){var d=this.getMenu(),e=d.down("#ascItem"),c=d.down("#descItem"),a;d.activeHeader=d.ownerCt=f;d.setFloatParent(f);f.titleEl.addCls(this.headerOpenCls);a=f.sortable?"enable":"disable";if(e){e[a]()}if(c){c[a]()}d.showBy(b)},onMenuDeactivate:function(){var a=this.getMenu();a.activeHeader.titleEl.removeCls(this.headerOpenCls)},moveHeader:function(a,b){this.tempLock();this.onHeaderMoved(this.move(a,b),1,a,b)},purgeCache:function(){var a=this;delete a.gridDataColumns;delete a.hideableColumns;if(a.menu){a.menu.hide();a.menu.destroy();delete a.menu}},onHeaderMoved:function(f,a,c,e){var d=this,b=d.ownerCt;if(b&&b.onHeaderMove){b.onHeaderMove(d,f,a,c,e)}d.fireEvent("columnmove",d,f,c,e)},getMenu:function(){var a=this;if(!a.menu){a.menu=new Ext.menu.Menu({hideOnParentHide:false,items:a.getMenuItems(),listeners:{deactivate:a.onMenuDeactivate,scope:a}});a.updateMenuDisabledState();a.fireEvent("menucreate",a,a.menu)}return a.menu},getMenuItems:function(){var c=this,b=[],a=c.enableColumnHide?c.getColumnMenu(c):null;if(c.sortable){b=[{itemId:"ascItem",text:c.sortAscText,cls:Ext.baseCSSPrefix+"hmenu-sort-asc",handler:c.onSortAscClick,scope:c},{itemId:"descItem",text:c.sortDescText,cls:Ext.baseCSSPrefix+"hmenu-sort-desc",handler:c.onSortDescClick,scope:c}]}if(a&&a.length){b.push("-",{itemId:"columnItem",text:c.columnsText,cls:Ext.baseCSSPrefix+"cols-icon",menu:a})}return b},onSortAscClick:function(){var b=this.getMenu(),a=b.activeHeader;a.setSortState("ASC")},onSortDescClick:function(){var b=this.getMenu(),a=b.activeHeader;a.setSortState("DESC")},getColumnMenu:function(f){var c=[],b=0,e,a=f.query(">gridcolumn[hideable]"),g=a.length,d;for(;b<g;b++){e=a[b];d=new Ext.menu.CheckItem({text:e.menuText||e.text,checked:!e.hidden,hideOnClick:false,headerId:e.id,menu:e.isGroupHeader?this.getColumnMenu(e):undefined,checkHandler:this.onColumnCheckChange,scope:this});c.push(d);e.on({destroy:Ext.Function.bind(d.destroy,d)})}return c},onColumnCheckChange:function(a,b){var c=Ext.getCmp(a.headerId);c[b?"show":"hide"]()},getColumnsForTpl:function(e){var c=[],d=this.getGridColumns(e),g=d.length,a=0,f,b;for(;a<g;a++){f=d[a];if(f.hidden||f.up("headercontainer[hidden=true]")){b=0}else{b=f.getDesiredWidth()}c.push({dataIndex:f.dataIndex,align:f.align,width:b,id:f.id,cls:f.tdCls,columnId:f.getItemId()})}return c},getColumnCount:function(){return this.getGridColumns().length},getFullWidth:function(d){var c=0,b=this.getVisibleGridColumns(d),f=b.length,a=0,e;for(;a<f;a++){e=b[a];if(e.getDesiredWidth){c+=e.getDesiredWidth()||0}else{c+=e.getWidth()}}return c},clearOtherSortStates:function(a){var c=this.getGridColumns(),d=c.length,b=0;for(;b<d;b++){if(c[b]!==a){c[b].setSortState(null,true)}}},getVisibleGridColumns:function(a){return Ext.ComponentQuery.query(":not([hidden])",this.getGridColumns(a))},getGridColumns:function(b){var c=this,a=b?null:c.gridDataColumns;if(!a){c.gridDataColumns=a=[];c.cascade(function(d){if((d!==c)&&!d.isGroupHeader){a.push(d)}})}return a},getHideableColumns:function(b){var c=this,a=b?null:c.hideableColumns;if(!a){a=c.hideableColumns=c.query("[hideable]")}return a},getHeaderIndex:function(a){if(a.isGroupHeader){a=a.down(":not([isgroupHeader])")}return Ext.Array.indexOf(this.getGridColumns(),a)},getHeaderAtIndex:function(a){var b=this.getGridColumns();return b.length?b[a]:null},getVisibleHeaderClosestToIndex:function(b){var a=this.getHeaderAtIndex(b);if(a&&a.hidden){a=a.next(":not([hidden])")||a.prev(":not([hidden])")}return a},prepareData:function(h,c,j,m,a){var l=this,g={},d=l.gridDataColumns||l.getGridColumns(),e=d.length,f=0,i,p,k,o,b,n=a.store;for(;f<e;f++){b={tdCls:"",style:""};i=d[f];p=i.id;k=i.renderer;o=h[i.dataIndex];if(typeof k=="function"){o=k.call(i.scope||l.ownerCt,o,b,j,c,f,n,m)}if(l.markDirty){g[p+"-modified"]=j.isModified(i.dataIndex)?Ext.baseCSSPrefix+"grid-dirty-cell":""}g[p+"-tdCls"]=b.tdCls;g[p+"-tdAttr"]=b.tdAttr;g[p+"-style"]=b.style;if(typeof o==="undefined"||o===null||o===""){o=i.emptyCellText}g[p]=o}return g},expandToFit:function(b){var a=this.view;if(a){a.expandToFit(b)}}});Ext.define("Ext.grid.column.Column",{extend:"Ext.grid.header.Container",alias:"widget.gridcolumn",requires:["Ext.util.KeyNav","Ext.grid.ColumnComponentLayout","Ext.grid.ColumnLayout"],alternateClassName:"Ext.grid.Column",baseCls:Ext.baseCSSPrefix+"column-header "+Ext.baseCSSPrefix+"unselectable",hoverCls:Ext.baseCSSPrefix+"column-header-over",handleWidth:5,sortState:null,possibleSortStates:["ASC","DESC"],childEls:["titleEl","triggerEl","textEl"],renderTpl:'<div id="{id}-titleEl" {tipMarkup}class="'+Ext.baseCSSPrefix+'column-header-inner"><span id="{id}-textEl" class="'+Ext.baseCSSPrefix+'column-header-text">{text}</span><tpl if="!menuDisabled"><div id="{id}-triggerEl" class="'+Ext.baseCSSPrefix+'column-header-trigger"></div></tpl></div>{%this.renderContainer(out,values)%}',dataIndex:null,text:"&#160;",menuText:null,emptyCellText:"&#160;",sortable:true,resizable:true,hideable:true,menuDisabled:false,renderer:false,editRenderer:false,align:"left",draggable:true,tooltipType:"qtip",initDraggable:Ext.emptyFn,isHeader:true,componentLayout:"columncomponent",initResizable:Ext.emptyFn,initComponent:function(){var a=this,b;if(Ext.isDefined(a.header)){a.text=a.header;delete a.header}if(!a.triStateSort){a.possibleSortStates.length=2}if(Ext.isDefined(a.columns)){a.isGroupHeader=true;a.items=a.columns;delete a.columns;delete a.flex;delete a.width;a.cls=(a.cls||"")+" "+Ext.baseCSSPrefix+"group-header";a.sortable=false;a.resizable=false;a.align="center"}else{a.isContainer=false;if(a.flex){a.minWidth=a.minWidth||Ext.grid.plugin.HeaderResizer.prototype.minColWidth}}a.addCls(Ext.baseCSSPrefix+"column-header-align-"+a.align);b=a.renderer;if(b){if(typeof b=="string"){a.renderer=Ext.util.Format[b]}a.hasCustomRenderer=true}else{if(a.defaultRenderer){a.scope=a;a.renderer=a.defaultRenderer}}a.callParent(arguments);a.on({element:"el",click:a.onElClick,dblclick:a.onElDblClick,scope:a});a.on({element:"titleEl",mouseenter:a.onTitleMouseOver,mouseleave:a.onTitleMouseOut,scope:a})},onAdd:function(a){a.isSubHeader=true;a.addCls(Ext.baseCSSPrefix+"group-sub-header");this.callParent(arguments)},onRemove:function(a){a.isSubHeader=false;a.removeCls(Ext.baseCSSPrefix+"group-sub-header");this.callParent(arguments)},initRenderData:function(){var b=this,d="",c=b.tooltip,a=b.tooltipType=="qtip"?"data-qtip":"title";if(!Ext.isEmpty(c)){d=a+'="'+c+'" '}return Ext.applyIf(b.callParent(arguments),{text:b.text,menuDisabled:b.menuDisabled,tipMarkup:d})},applyColumnState:function(b){var a=this,c=Ext.isDefined;a.applyColumnsState(b.columns);if(c(b.hidden)){a.hidden=b.hidden}if(c(b.locked)){a.locked=b.locked}if(c(b.sortable)){a.sortable=b.sortable}if(c(b.width)){delete a.flex;a.width=b.width}else{if(c(b.flex)){delete a.width;a.flex=b.flex}}},getColumnState:function(){var e=this,b=e.items.items,a=b?b.length:0,d,c=[],f={id:e.getStateId()};e.savePropsToState(["hidden","sortable","locked","flex","width"],f);if(e.isGroupHeader){for(d=0;d<a;d++){c.push(b[d].getColumnState())}if(c.length){f.columns=c}}else{if(e.isSubHeader&&e.ownerCt.hidden){delete e.hidden}}if("width" in f){delete f.flex}return f},getStateId:function(){return this.stateId||this.headerId},setText:function(a){this.text=a;if(this.rendered){this.textEl.update(a)}},getOwnerHeaderCt:function(){return this.up(":not([isHeader])")},getIndex:function(){return this.isGroupColumn?false:this.getOwnerHeaderCt().getHeaderIndex(this)},getVisibleIndex:function(){return this.isGroupColumn?false:Ext.Array.indexOf(this.getOwnerHeaderCt().getVisibleGridColumns(),this)},beforeRender:function(){var b=this,a=b.up("tablepanel");b.callParent();if(a&&(!b.sortable||a.sortableColumns===false)&&!b.groupable&&!b.lockable&&(a.enableColumnHide===false||!b.getOwnerHeaderCt().getHideableColumns().length)){b.menuDisabled=true}},afterRender:function(){var b=this,a=b.el;b.callParent(arguments);if(b.overCls){a.addClsOnOver(b.overCls)}if(!Ext.isIE8||!Ext.isStrict){b.mon(b.getFocusEl(),{focus:b.onTitleMouseOver,blur:b.onTitleMouseOut,scope:b})}b.keyNav=new Ext.util.KeyNav(a,{enter:b.onEnterKey,down:b.onDownKey,scope:b})},afterComponentLayout:function(d,a,c,f){var e=this,b=e.getOwnerHeaderCt();e.callParent(arguments);if(b&&(c!=null||e.flex)&&d!==c){b.onHeaderResize(e,d,true)}},setPadding:function(a){var e=this,d=parseInt(e.textEl.getStyle("line-height"),10),g=e.textEl.dom.offsetHeight,b=e.titleEl,f=a-e.el.getBorderWidth("tb"),c;if(!e.isGroupHeader){if(b.getHeight()<f){b.setHeight(f);e.ownerCt.layout.innerCt.setHeight(a)}}c=b.getViewSize().height;if(g){if(d){g=Math.ceil(g/d)*d}b.setStyle({paddingTop:Math.floor(Math.max(((c-g)/2),0))+"px"})}if(Ext.isIE&&e.triggerEl){e.triggerEl.setHeight(c)}},onDestroy:function(){var a=this;Ext.destroy(a.textEl,a.keyNav,a.field);delete a.keyNav;a.callParent(arguments)},onTitleMouseOver:function(){this.titleEl.addCls(this.hoverCls)},onTitleMouseOut:function(){this.titleEl.removeCls(this.hoverCls)},onDownKey:function(a){if(this.triggerEl){this.onElClick(a,this.triggerEl.dom||this.el.dom)}},onEnterKey:function(a){this.onElClick(a,this.el.dom)},onElDblClick:function(d,a){var c=this,b=c.ownerCt;if(b&&Ext.Array.indexOf(b.items,c)!==0&&c.isOnLeftEdge(d)){b.expandToFit(c.previousSibling("gridcolumn"))}},onElClick:function(d,b){var c=this,a=c.getOwnerHeaderCt();if(a&&!a.ddLock){if(c.triggerEl&&(d.target===c.triggerEl.dom||b===c.triggerEl.dom||d.within(c.triggerEl))){a.onHeaderTriggerClick(c,d,b)}else{if(d.getKey()||(!c.isOnLeftEdge(d)&&!c.isOnRightEdge(d))){c.toggleSortState();a.onHeaderClick(c,d,b)}}}},processEvent:function(f,b,a,c,d,g){return this.fireEvent.apply(this,arguments)},toggleSortState:function(){var b=this,a,c;if(b.sortable){a=Ext.Array.indexOf(b.possibleSortStates,b.sortState);c=(a+1)%b.possibleSortStates.length;b.setSortState(b.possibleSortStates[c])}},doSort:function(b){var a=this.up("tablepanel").store;a.sort({property:this.getSortParam(),direction:b})},getSortParam:function(){return this.dataIndex},setSortState:function(a,j,f){var g=this,h=Ext.baseCSSPrefix+"column-header-sort-",i=h+"ASC",c=h+"DESC",b=h+"null",e=g.getOwnerHeaderCt(),d=g.sortState;if(d!==a&&g.getSortParam()){g.addCls(h+a);if(a&&!f){g.doSort(a)}switch(a){case"DESC":g.removeCls([i,b]);break;case"ASC":g.removeCls([c,b]);break;case null:g.removeCls([i,c]);break}if(e&&!g.triStateSort&&!j){e.clearOtherSortStates(g)}g.sortState=a;if(g.triStateSort||a!=null){e.fireEvent("sortchange",e,g,a)}}},hide:function(c){var h=this,e=h.getOwnerHeaderCt(),b=h.ownerCt,a=b.isGroupHeader,j,g,f,d;if(a&&!c){g=b.query(">:not([hidden])");if(g.length===1&&g[0]==h){h.ownerCt.hide();return}}Ext.suspendLayouts();if(h.isGroupHeader){g=h.items.items;for(d=0,f=g.length;d<f;d++){j=g[d];if(!j.hidden){j.hide(true)}}}h.callParent();e.onHeaderHide(h);Ext.resumeLayouts(true)},show:function(d,b){var h=this,f=h.ownerCt,c,a,e,g;Ext.suspendLayouts();if(h.isSubHeader&&f.hidden){f.show(false,true)}h.callParent(arguments);if(h.isGroupHeader&&b!==true&&!h.query(":not([hidden])").length){c=h.query(">*");for(e=0,a=c.length;e<a;e++){g=c[e];if(g.hidden){g.show(true)}}}Ext.resumeLayouts(true);f=h.getOwnerHeaderCt();if(f){f.onHeaderShow(h)}},getDesiredWidth:function(){var a=this;if(a.rendered&&a.componentLayout&&a.componentLayout.lastComponentSize){return a.componentLayout.lastComponentSize.width}else{if(a.flex){return a.width}else{return a.width}}},getCellSelector:function(){return"."+Ext.baseCSSPrefix+"grid-cell-"+this.getItemId()},getCellInnerSelector:function(){return this.getCellSelector()+" ."+Ext.baseCSSPrefix+"grid-cell-inner"},isOnLeftEdge:function(a){return(a.getXY()[0]-this.el.getLeft()<=this.handleWidth)},isOnRightEdge:function(a){return(this.el.getRight()-a.getXY()[0]<=this.handleWidth)}});Ext.define("Ext.grid.RowNumberer",{extend:"Ext.grid.column.Column",alias:"widget.rownumberer",text:"&#160",width:23,sortable:false,draggable:false,align:"right",constructor:function(a){this.width=this.width;this.callParent(arguments);if(this.rowspan){this.renderer=Ext.Function.bind(this.renderer,this)}},resizable:false,hideable:false,menuDisabled:true,dataIndex:"",cls:Ext.baseCSSPrefix+"row-numberer",rowspan:undefined,renderer:function(e,b,a,d,f,c){if(this.rowspan){b.cellAttr='rowspan="'+this.rowspan+'"'}b.tdCls=Ext.baseCSSPrefix+"grid-cell-special";return c.indexOfTotal(a)+1}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("MyDesktop.GridWindow",{extend:"Ext.ux.desktop.Module",requires:["Ext.data.ArrayStore","Ext.util.Format","Ext.grid.Panel","Ext.grid.RowNumberer"],id:"grid-win",init:function(){this.launcher={text:"Grid Window",iconCls:"icon-grid"}},createWindow:function(){var b=this.app.getDesktop();var a=b.getWindow("grid-win");if(!a){a=b.createWindow({id:"grid-win",title:"Grid Window",width:740,height:480,iconCls:"icon-grid",animCollapse:false,constrainHeader:true,layout:"fit",items:[{border:false,xtype:"grid",store:new Ext.data.ArrayStore({fields:[{name:"company"},{name:"price",type:"float"},{name:"change",type:"float"},{name:"pctChange",type:"float"}],data:MyDesktop.GridWindow.getDummyData()}),columns:[new Ext.grid.RowNumberer(),{text:"Company",flex:1,sortable:true,dataIndex:"company"},{text:"Price",width:70,sortable:true,renderer:Ext.util.Format.usMoney,dataIndex:"price"},{text:"Change",width:70,sortable:true,dataIndex:"change"},{text:"% Change",width:70,sortable:true,dataIndex:"pctChange"}]}],tbar:[{text:"Add Something",tooltip:"Add a new row",iconCls:"add"},"-",{text:"Options",tooltip:"Modify options",iconCls:"option"},"-",{text:"Remove Something",tooltip:"Remove the selected item",iconCls:"remove"}]})}return a},statics:{getDummyData:function(){return[["3m Co",71.72,0.02,0.03,"9/1 12:00am"],["Alcoa Inc",29.01,0.42,1.47,"9/1 12:00am"],["American Express Company",52.55,0.01,0.02,"9/1 12:00am"],["American International Group, Inc.",64.13,0.31,0.49,"9/1 12:00am"],["AT&T Inc.",31.61,-0.48,-1.54,"9/1 12:00am"],["Caterpillar Inc.",67.27,0.92,1.39,"9/1 12:00am"],["Citigroup, Inc.",49.37,0.02,0.04,"9/1 12:00am"],["Exxon Mobil Corp",68.1,-0.43,-0.64,"9/1 12:00am"],["General Electric Company",34.14,-0.08,-0.23,"9/1 12:00am"],["General Motors Corporation",30.27,1.09,3.74,"9/1 12:00am"],["Hewlett-Packard Co.",36.53,-0.03,-0.08,"9/1 12:00am"],["Honeywell Intl Inc",38.77,0.05,0.13,"9/1 12:00am"],["Intel Corporation",19.88,0.31,1.58,"9/1 12:00am"],["Johnson & Johnson",64.72,0.06,0.09,"9/1 12:00am"],["Merck & Co., Inc.",40.96,0.41,1.01,"9/1 12:00am"],["Microsoft Corporation",25.84,0.14,0.54,"9/1 12:00am"],["The Coca-Cola Company",45.07,0.26,0.58,"9/1 12:00am"],["The Procter & Gamble Company",61.91,0.01,0.02,"9/1 12:00am"],["Wal-Mart Stores, Inc.",45.45,0.73,1.63,"9/1 12:00am"],["Walt Disney Company (The) (Holding Company)",29.89,0.24,0.81,"9/1 12:00am"]]}}});Ext.define("Ext.tree.Column",{extend:"Ext.grid.column.Column",alias:"widget.treecolumn",tdCls:Ext.baseCSSPrefix+"grid-cell-treecolumn",treePrefix:Ext.baseCSSPrefix+"tree-",elbowPrefix:Ext.baseCSSPrefix+"tree-elbow-",expanderCls:Ext.baseCSSPrefix+"tree-expander",imgText:'<img src="{1}" class="{0}" />',checkboxText:'<input type="button" role="checkbox" class="{0}" {1} />',initComponent:function(){var a=this;a.origRenderer=a.renderer||a.defaultRenderer;a.origScope=a.scope||window;a.renderer=a.treeRenderer;a.scope=a;a.callParent()},treeRenderer:function(k,m,c,b,j,e,i){var r=this,q=[],o=Ext.String.format,t=c.getDepth(),p=r.treePrefix,d=r.elbowPrefix,l=r.expanderCls,h=r.imgText,u=r.checkboxText,g=r.origRenderer.apply(r.origScope,arguments),f=Ext.BLANK_IMAGE_URL,n=c.get("href"),s=c.get("hrefTarget"),a=c.get("cls");while(c){if(!c.isRoot()||(c.isRoot()&&i.rootVisible)){if(c.getDepth()===t){q.unshift(o(h,p+"icon "+p+"icon"+(c.get("icon")?"-inline ":(c.isLeaf()?"-leaf ":"-parent "))+(c.get("iconCls")||""),c.get("icon")||f));if(c.get("checked")!==null){q.unshift(o(u,(p+"checkbox")+(c.get("checked")?" "+p+"checkbox-checked":""),c.get("checked")?'aria-checked="true"':""));if(c.get("checked")){m.tdCls+=(" "+p+"checked")}}if(c.isLast()){if(c.isExpandable()){q.unshift(o(h,(d+"end-plus "+l),f))}else{q.unshift(o(h,(d+"end"),f))}}else{if(c.isExpandable()){q.unshift(o(h,(d+"plus "+l),f))}else{q.unshift(o(h,(p+"elbow"),f))}}}else{if(c.isLast()||c.getDepth()===0){q.unshift(o(h,(d+"empty"),f))}else{if(c.getDepth()!==0){q.unshift(o(h,(d+"line"),f))}}}}c=c.parentNode}if(n){q.push('<a href="',n,'" target="',s,'">',g,"</a>")}else{q.push(g)}if(a){m.tdCls+=" "+a}return q.join("")},defaultRenderer:function(a){return a}});Ext.define("Ext.tree.Panel",{extend:"Ext.panel.Table",alias:"widget.treepanel",alternateClassName:["Ext.tree.TreePanel","Ext.TreePanel"],requires:["Ext.tree.View","Ext.selection.TreeModel","Ext.tree.Column","Ext.data.TreeStore"],viewType:"treeview",selType:"treemodel",treeCls:Ext.baseCSSPrefix+"tree-panel",deferRowRender:false,rowLines:false,lines:true,useArrows:false,singleExpand:false,ddConfig:{enableDrag:true,enableDrop:true},rootVisible:true,displayField:"text",root:null,normalCfgCopy:["displayField","root","singleExpand","useArrows","lines","rootVisible","scroll"],lockedCfgCopy:["displayField","root","singleExpand","useArrows","lines","rootVisible"],isTree:true,constructor:function(a){a=a||{};if(a.animate===undefined){a.animate=Ext.isDefined(this.animate)?this.animate:Ext.enableFx}this.enableAnimations=a.animate;delete a.animate;this.callParent([a])},initComponent:function(){var c=this,b=[c.treeCls],a;if(c.useArrows){b.push(Ext.baseCSSPrefix+"tree-arrows");c.lines=false}if(c.lines){b.push(Ext.baseCSSPrefix+"tree-lines")}else{if(!c.useArrows){b.push(Ext.baseCSSPrefix+"tree-no-lines")}}if(Ext.isString(c.store)){c.store=Ext.StoreMgr.lookup(c.store)}else{if(!c.store||Ext.isObject(c.store)&&!c.store.isStore){c.store=new Ext.data.TreeStore(Ext.apply({},c.store||{},{root:c.root,fields:c.fields,model:c.model,folderSort:c.folderSort}))}else{if(c.root){c.store=Ext.data.StoreManager.lookup(c.store);c.store.setRootNode(c.root);if(c.folderSort!==undefined){c.store.folderSort=c.folderSort;c.store.sort()}}}}c.viewConfig=Ext.apply({},c.viewConfig);c.viewConfig=Ext.applyIf(c.viewConfig,{rootVisible:c.rootVisible,animate:c.enableAnimations,singleExpand:c.singleExpand,node:c.store.getRootNode(),hideHeaders:c.hideHeaders});c.mon(c.store,{scope:c,rootchange:c.onRootChange,clear:c.onClear});c.relayEvents(c.store,["beforeload","load"]);c.mon(c.store,{append:c.createRelayer("itemappend"),remove:c.createRelayer("itemremove"),move:c.createRelayer("itemmove",[0,4]),insert:c.createRelayer("iteminsert"),beforeappend:c.createRelayer("beforeitemappend"),beforeremove:c.createRelayer("beforeitemremove"),beforemove:c.createRelayer("beforeitemmove"),beforeinsert:c.createRelayer("beforeiteminsert"),expand:c.createRelayer("itemexpand",[0,1]),collapse:c.createRelayer("itemcollapse",[0,1]),beforeexpand:c.createRelayer("beforeitemexpand",[0,1]),beforecollapse:c.createRelayer("beforeitemcollapse",[0,1])});if(!c.columns){if(c.initialConfig.hideHeaders===undefined){c.hideHeaders=true}c.addCls(Ext.baseCSSPrefix+"autowidth-table");c.columns=[{xtype:"treecolumn",text:"Name",width:Ext.isIE6?null:10000,dataIndex:c.displayField}]}if(c.cls){b.push(c.cls)}c.cls=b.join(" ");c.callParent();a=c.getView();c.relayEvents(a,["checkchange","afteritemexpand","afteritemcollapse"]);if(!a.rootVisible&&!c.getRootNode()){c.setRootNode({expanded:true})}},onClear:function(){this.view.onClear()},setRootNode:function(){return this.store.setRootNode.apply(this.store,arguments)},getRootNode:function(){return this.store.getRootNode()},onRootChange:function(a){this.view.setRootNode(a)},getChecked:function(){return this.getView().getChecked()},isItemChecked:function(a){return a.get("checked")},expandNode:function(b,a,d,c){return this.getView().expand(b,a,d,c||this)},collapseNode:function(b,a,d,c){return this.getView().collapse(b,a,d,c||this)},expandAll:function(f,d){var e=this,b=e.getRootNode(),c=e.enableAnimations,a=e.getView();if(b){if(!c){a.beginBulkUpdate()}b.expand(true,f,d||e);if(!c){a.endBulkUpdate()}}},collapseAll:function(f,d){var e=this,b=e.getRootNode(),c=e.enableAnimations,a=e.getView();if(b){if(!c){a.beginBulkUpdate()}d=d||e;if(a.rootVisible){b.collapse(true,f,d)}else{b.collapseChildren(true,f,d)}if(!c){a.endBulkUpdate()}}},expandPath:function(k,f,a,g,j){var d=this,c=d.getRootNode(),b=1,e=d.getView(),i,h;f=f||d.getRootNode().idProperty;a=a||"/";if(Ext.isEmpty(k)){Ext.callback(g,j||d,[false,null]);return}i=k.split(a);if(c.get(f)!=i[1]){Ext.callback(g,j||d,[false,c]);return}h=function(){if(++b===i.length){Ext.callback(g,j||d,[true,c]);return}var l=c.findChild(f,i[b]);if(!l){Ext.callback(g,j||d,[false,c]);return}c=l;c.expand(false,h)};c.expand(false,h)},selectPath:function(i,d,a,f,h){var b=this,c,g,e;d=d||b.getRootNode().idProperty;a=a||"/";g=i.split(a);e=g.pop();if(g.length>1){b.expandPath(g.join(a),d,a,function(l,k){var j=k;if(l&&k){k=k.findChild(d,e);if(k){b.getSelectionModel().select(k);Ext.callback(f,h||b,[true,k]);return}}Ext.callback(f,h||b,[false,j])},b)}else{c=b.getRootNode();if(c.getId()===e){b.getSelectionModel().select(c);Ext.callback(f,h||b,[true,c])}else{Ext.callback(f,h||b,[false,null])}}}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("MyDesktop.AccordionWindow",{extend:"Ext.ux.desktop.Module",requires:["Ext.data.TreeStore","Ext.layout.container.Accordion","Ext.toolbar.Spacer","Ext.tree.Panel"],id:"acc-win",init:function(){this.launcher={text:"Accordion Window",iconCls:"accordion"}},createTree:function(){var a=Ext.create("Ext.tree.Panel",{id:"im-tree",title:"Online Users",rootVisible:false,lines:false,autoScroll:true,tools:[{type:"refresh",handler:function(e,d){a.setLoading(true,a.body);var b=a.getRootNode();b.collapseChildren(true,false);Ext.Function.defer(function(){a.setLoading(false);b.expand(true,true)},1000)}}],store:Ext.create("Ext.data.TreeStore",{root:{text:"Online",expanded:true,children:[{text:"Friends",expanded:true,children:[{text:"Brian",iconCls:"user",leaf:true},{text:"Kevin",iconCls:"user",leaf:true},{text:"Mark",iconCls:"user",leaf:true},{text:"Matt",iconCls:"user",leaf:true},{text:"Michael",iconCls:"user",leaf:true},{text:"Mike Jr",iconCls:"user",leaf:true},{text:"Mike Sr",iconCls:"user",leaf:true},{text:"JR",iconCls:"user",leaf:true},{text:"Rich",iconCls:"user",leaf:true},{text:"Nige",iconCls:"user",leaf:true},{text:"Zac",iconCls:"user",leaf:true}]},{text:"Family",expanded:true,children:[{text:"Kiana",iconCls:"user-girl",leaf:true},{text:"Aubrey",iconCls:"user-girl",leaf:true},{text:"Cale",iconCls:"user-kid",leaf:true}]}]}})});return a},createWindow:function(){var b=this.app.getDesktop();var a=b.getWindow("acc-win");if(!a){a=b.createWindow({id:"acc-win",title:"Accordion Window",width:250,height:400,iconCls:"accordion",animCollapse:false,constrainHeader:true,bodyBorder:true,tbar:{xtype:"toolbar",ui:"plain",items:[{tooltip:{title:"Rich Tooltips",text:"Let your users know what they can do!"},iconCls:"connect"},"-",{tooltip:"Add a new user",iconCls:"user-add"}," ",{tooltip:"Remove the selected user",iconCls:"user-delete"}]},layout:"accordion",border:false,items:[this.createTree(),{title:"Settings",html:"<p>Something useful would be in here.</p>",autoScroll:true},{title:"Even More Stuff",html:"<p>Something useful would be in here.</p>"},{title:"My Stuff",html:"<p>Something useful would be in here.</p>"}]})}return a}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("Ext.ux.desktop.ShortcutModel",{extend:"Ext.data.Model",fields:[{name:"name"},{name:"iconCls"},{name:"module"}]});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("MyDesktop.App",{extend:"Ext.ux.desktop.App",requires:["Ext.window.MessageBox","Ext.ux.desktop.ShortcutModel","MyDesktop.SystemStatus","MyDesktop.VideoWindow","MyDesktop.GridWindow","MyDesktop.TabWindow","MyDesktop.AccordionWindow","MyDesktop.Notepad","MyDesktop.BogusMenuModule","MyDesktop.BogusModule","MyDesktop.Settings"],init:function(){this.callParent()},getModules:function(){return[new MyDesktop.VideoWindow(),new MyDesktop.SystemStatus(),new MyDesktop.GridWindow(),new MyDesktop.TabWindow(),new MyDesktop.AccordionWindow(),new MyDesktop.Notepad(),new MyDesktop.BogusMenuModule(),new MyDesktop.BogusModule()]},getDesktopConfig:function(){var b=this,a=b.callParent();return Ext.apply(a,{contextMenuItems:[{text:"Change Settings",handler:b.onSettings,scope:b}],shortcuts:Ext.create("Ext.data.Store",{model:"Ext.ux.desktop.ShortcutModel",data:[{name:"Grid Window",iconCls:"grid-shortcut",module:"grid-win"},{name:"Accordion Window",iconCls:"accordion-shortcut",module:"acc-win"},{name:"Notepad",iconCls:"notepad-shortcut",module:"notepad"},{name:"System Status",iconCls:"cpu-shortcut",module:"systemstatus"}]}),wallpaper:"wallpapers/Blue-Sencha.jpg",wallpaperStretch:false})},getStartConfig:function(){var b=this,a=b.callParent();return Ext.apply(a,{title:"Don Griffin",iconCls:"user",height:300,toolConfig:{width:100,items:[{text:"Settings",iconCls:"settings",handler:b.onSettings,scope:b},"-",{text:"Logout",iconCls:"logout",handler:b.onLogout,scope:b}]}})},getTaskbarConfig:function(){var a=this.callParent();return Ext.apply(a,{quickStart:[{name:"Accordion Window",iconCls:"accordion",module:"acc-win"},{name:"Grid Window",iconCls:"icon-grid",module:"grid-win"}],trayItems:[{xtype:"trayclock",flex:1}]})},onLogout:function(){Ext.Msg.confirm("Logout","Are you sure you want to logout?")},onSettings:function(){var a=new MyDesktop.Settings({desktop:this.desktop});a.show()}});Ext.define("Ext.util.Point",{extend:"Ext.util.Region",statics:{fromEvent:function(a){a=(a.changedTouches&&a.changedTouches.length>0)?a.changedTouches[0]:a;return new this(a.pageX,a.pageY)}},constructor:function(a,b){this.callParent([b,a,b,a])},toString:function(){return"Point["+this.x+","+this.y+"]"},equals:function(a){return(this.x==a.x&&this.y==a.y)},isWithin:function(b,a){if(!Ext.isObject(a)){a={x:a,y:a}}return(this.x<=b.x+a.x&&this.x>=b.x-a.x&&this.y<=b.y+a.y&&this.y>=b.y-a.y)},roundedEquals:function(a){return(Math.round(this.x)==Math.round(a.x)&&Math.round(this.y)==Math.round(a.y))}},function(){this.prototype.translate=Ext.util.Region.prototype.translateBy});Ext.define("Ext.Layer",{extend:"Ext.Element",uses:["Ext.Shadow"],statics:{shims:[]},isLayer:true,constructor:function(b,a){b=b||{};var c=this,d=Ext.DomHelper,f=b.parentEl,e=f?Ext.getDom(f):document.body,g=b.hideMode;if(a){c.dom=Ext.getDom(a)}if(!c.dom){c.dom=d.append(e,b.dh||{tag:"div",cls:Ext.baseCSSPrefix+"layer"})}else{c.addCls(Ext.baseCSSPrefix+"layer");if(!c.dom.parentNode){e.appendChild(c.dom)}}if(b.id){c.id=c.dom.id=b.id}else{c.id=Ext.id(c.dom)}Ext.Element.addToCache(c);if(b.cls){c.addCls(b.cls)}c.constrain=b.constrain!==false;if(g){c.setVisibilityMode(Ext.Element[g.toUpperCase()]);if(c.visibilityMode==Ext.Element.ASCLASS){c.visibilityCls=b.visibilityCls}}else{if(b.useDisplay){c.setVisibilityMode(Ext.Element.DISPLAY)}else{c.setVisibilityMode(Ext.Element.VISIBILITY)}}if(b.shadow){c.shadowOffset=b.shadowOffset||4;c.shadow=new Ext.Shadow({offset:c.shadowOffset,mode:b.shadow});c.disableShadow()}else{c.shadowOffset=0}c.useShim=b.shim!==false&&Ext.useShims;if(b.hidden===true){c.hide()}else{c.show()}},getZIndex:function(){return parseInt((this.getShim()||this).getStyle("z-index"),10)},getShim:function(){var b=this,c,a;if(!b.useShim){return null}if(!b.shim){c=b.self.shims.shift();if(!c){c=b.createShim();c.enableDisplayMode("block");c.hide()}a=b.dom.parentNode;if(c.dom.parentNode!=a){a.insertBefore(c.dom,b.dom)}b.shim=c}return b.shim},hideShim:function(){var a=this;if(a.shim){a.shim.setDisplayed(false);a.self.shims.push(a.shim);delete a.shim}},disableShadow:function(){var a=this;if(a.shadow&&!a.shadowDisabled){a.shadowDisabled=true;a.shadow.hide();a.lastShadowOffset=a.shadowOffset;a.shadowOffset=0}},enableShadow:function(a){var b=this;if(b.shadow&&b.shadowDisabled){b.shadowDisabled=false;b.shadowOffset=b.lastShadowOffset;delete b.lastShadowOffset;if(a){b.sync(true)}}},sync:function(b){var i=this,m=i.shadow,g,e,a,d,c,n,k,f,j;if(!i.updating&&i.isVisible()&&(m||i.useShim)){d=i.getShim();c=i.getLocalX();n=i.getLocalY();k=i.dom.offsetWidth;f=i.dom.offsetHeight;if(m&&!i.shadowDisabled){if(b&&!m.isVisible()){m.show(i)}else{m.realign(c,n,k,f)}if(d){j=d.getStyle("z-index");if(j>i.zindex){i.shim.setStyle("z-index",i.zindex-2)}d.show();if(m.isVisible()){g=m.el.getXY();e=d.dom.style;a=m.el.getSize();if(Ext.supports.CSS3BoxShadow){a.height+=6;a.width+=4;g[0]-=2;g[1]-=4}e.left=(g[0])+"px";e.top=(g[1])+"px";e.width=(a.width)+"px";e.height=(a.height)+"px"}else{d.setSize(k,f);d.setLeftTop(c,n)}}}else{if(d){j=d.getStyle("z-index");if(j>i.zindex){i.shim.setStyle("z-index",i.zindex-2)}d.show();d.setSize(k,f);d.setLeftTop(c,n)}}}return i},remove:function(){this.hideUnders();this.callParent()},beginUpdate:function(){this.updating=true},endUpdate:function(){this.updating=false;this.sync(true)},hideUnders:function(){if(this.shadow){this.shadow.hide()}this.hideShim()},constrainXY:function(){if(this.constrain){var f=Ext.Element.getViewWidth(),b=Ext.Element.getViewHeight(),k=Ext.getDoc().getScroll(),j=this.getXY(),g=j[0],e=j[1],a=this.shadowOffset,i=this.dom.offsetWidth+a,c=this.dom.offsetHeight+a,d=false;if((g+i)>f+k.left){g=f-i-a;d=true}if((e+c)>b+k.top){e=b-c-a;d=true}if(g<k.left){g=k.left;d=true}if(e<k.top){e=k.top;d=true}if(d){Ext.Layer.superclass.setXY.call(this,[g,e]);this.sync()}}return this},getConstrainOffset:function(){return this.shadowOffset},setVisible:function(e,b,d,g,f){var c=this,a;a=function(){if(e){c.sync(true)}if(g){g()}};if(!e){c.hideUnders(true)}c.callParent([e,b,d,g,f]);if(!b){a()}return c},beforeFx:function(){this.beforeAction();return this.callParent(arguments)},afterFx:function(){this.callParent(arguments);this.sync(this.isVisible())},beforeAction:function(){if(!this.updating&&this.shadow){this.shadow.hide()}},setLeft:function(a){this.callParent(arguments);return this.sync()},setTop:function(a){this.callParent(arguments);return this.sync()},setLeftTop:function(b,a){this.callParent(arguments);return this.sync()},setXY:function(d,a,c,f,e){var b=this;f=b.createCB(f);b.fixDisplay();b.beforeAction();b.callParent([d,a,c,f,e]);if(!a){f()}return b},createCB:function(c){var a=this,b=a.shadow&&a.shadow.isVisible();return function(){a.constrainXY();a.sync(b);if(c){c()}}},setX:function(a,b,c,e,d){this.setXY([a,this.getY()],b,c,e,d);return this},setY:function(e,a,b,d,c){this.setXY([this.getX(),e],a,b,d,c);return this},setSize:function(a,c,b,e,g,f){var d=this;g=d.createCB(g);d.beforeAction();d.callParent([a,c,b,e,g,f]);if(!b){g()}return d},setWidth:function(a,b,d,f,e){var c=this;f=c.createCB(f);c.beforeAction();c.callParent([a,b,d,f,e]);if(!b){f()}return c},setHeight:function(b,a,d,f,e){var c=this;f=c.createCB(f);c.beforeAction();c.callParent([b,a,d,f,e]);if(!a){f()}return c},setBounds:function(g,f,a,i,b,c,h,d){var e=this;h=e.createCB(h);e.beforeAction();if(!b){Ext.Layer.superclass.setXY.call(e,[g,f]);Ext.Layer.superclass.setSize.call(e,a,i);h()}else{e.callParent([g,f,a,i,b,c,h,d])}return e},setZIndex:function(a){var b=this;b.zindex=a;if(b.getShim()){b.shim.setStyle("z-index",a++)}if(b.shadow){b.shadow.setZIndex(a++)}return b.setStyle("z-index",a)},onOpacitySet:function(a){var b=this.shadow;if(b){b.setOpacity(a)}}});Ext.define("Ext.data.Batch",{mixins:{observable:"Ext.util.Observable"},autoStart:false,pauseOnException:false,current:-1,total:0,isRunning:false,isComplete:false,hasException:false,constructor:function(a){var b=this;b.mixins.observable.constructor.call(b,a);b.operations=[];b.exceptions=[]},add:function(a){this.total++;a.setBatch(this);this.operations.push(a);return this},start:function(a){var b=this;if(b.isRunning){return b}b.exceptions.length=0;b.hasException=false;b.isRunning=true;return b.runOperation(Ext.isDefined(a)?a:b.current+1)},retry:function(){return this.start(this.current)},runNextOperation:function(){return this.runOperation(this.current+1)},pause:function(){this.isRunning=false;return this},runOperation:function(d){var e=this,c=e.operations,b=c[d],a;if(b===undefined){e.isRunning=false;e.isComplete=true;e.fireEvent("complete",e,c[c.length-1])}else{e.current=d;a=function(f){var g=f.hasException();if(g){e.hasException=true;e.exceptions.push(f);e.fireEvent("exception",e,f)}if(g&&e.pauseOnException){e.pause()}else{f.setCompleted();e.fireEvent("operationcomplete",e,f);e.runNextOperation()}};b.setStarted();e.proxy[b.action](b,a,e)}return e}});Ext.define("Ext.data.Request",{action:undefined,params:undefined,method:"GET",url:undefined,constructor:function(a){Ext.apply(this,a)}});
/*
* Ext JS Library 4.0
* Copyright(c) 2006-2011 Sencha Inc.
* licensing@sencha.com
* http://www.sencha.com/license
*/
Ext.define("Ext.ux.desktop.Video",{extend:"Ext.panel.Panel",alias:"widget.video",layout:"fit",autoplay:false,controls:true,bodyStyle:"background-color:#000;color:#fff",html:"",initComponent:function(){this.callParent()},afterRender:function(){var g;if(this.fallbackHTML){g=this.fallbackHTML}else{g="Your browser does not support HTML5 Video. ";if(Ext.isChrome){g+="Upgrade Chrome."}else{if(Ext.isGecko){g+="Upgrade to Firefox 3.5 or newer."}else{var b='<a href="http://www.google.com/chrome">Chrome</a>';g+='Please try <a href="http://www.mozilla.com">Firefox</a>';if(Ext.isIE){g+=", "+b+' or <a href="http://www.apple.com/safari/">Safari</a>.'}else{g+=" or "+b+"."}}}}var e=this.getSize();var c=Ext.copyTo({tag:"video",width:e.width,height:e.height},this,"poster,start,loopstart,loopend,playcount,autobuffer,loop");if(this.autoplay){c.autoplay=1}if(this.controls){c.controls=1}if(Ext.isArray(this.src)){c.children=[];for(var d=0,a=this.src.length;d<a;d++){if(!Ext.isObject(this.src[d])){Ext.Error.raise('The src list passed to "video" must be an array of objects')}c.children.push(Ext.applyIf({tag:"source"},this.src[d]))}c.children.push({html:g})}else{c.src=this.src;c.html=g}this.video=this.body.createChild(c);var f=this.video.dom;this.supported=(f&&f.tagName.toLowerCase()=="video")},afterComponentLayout:function(){var a=this;a.callParent(arguments);if(a.video){a.video.setSize(a.body.getSize())}},onDestroy:function(){var b=this.video;if(b){var a=b.dom;if(a&&a.pause){a.pause()}b.remove();this.video=null}this.callParent()}});Ext.define("Ext.draw.engine.SvgExporter",function(){var b=/,/g,c=/(-?\d*\.?\d*){1}(em|ex|px|in|cm|mm|pt|pc|%)\s('*.*'*)/,i=/rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/g,g=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,([\d\.]+)\)/g,f,h,e,l,m=function(n){f=n;h=f.length;e=f.width;l=f.height},j={path:function(r){var n=r.attr,u=n.path,q="",s,t,o;if(Ext.isArray(u[0])){o=u.length;for(t=0;t<o;t++){q+=u[t].join(" ")}}else{if(Ext.isArray(u)){q=u.join(" ")}else{q=u.replace(b," ")}}s=d({d:q,fill:n.fill||"none",stroke:n.stroke,"fill-opacity":n.opacity,"stroke-width":n["stroke-width"],"stroke-opacity":n["stroke-opacity"],"z-index":n.zIndex,transform:r.matrix.toSvg()});return"<path "+s+"/>"},text:function(t){var q=t.attr,p=c.exec(q.font),v=(p&&p[1])||"12",o=(p&&p[3])||"Arial",u=q.text,s=(Ext.isFF3_0||Ext.isFF3_5)?2:4,n="",r;t.getBBox();n+='<tspan x="'+(q.x||"")+'" dy="';n+=(v/s)+'">';n+=Ext.htmlEncode(u)+"</tspan>";r=d({x:q.x,y:q.y,"font-size":v,"font-family":o,"font-weight":q["font-weight"],"text-anchor":q["text-anchor"],fill:q.fill||"#000","fill-opacity":q.opacity,transform:t.matrix.toSvg()});return"<text "+r+">"+n+"</text>"},rect:function(o){var n=o.attr,p=d({x:n.x,y:n.y,rx:n.rx,ry:n.ry,width:n.width,height:n.height,fill:n.fill||"none","fill-opacity":n.opacity,stroke:n.stroke,"stroke-opacity":n["stroke-opacity"],"stroke-width":n["stroke-width"],transform:o.matrix&&o.matrix.toSvg()});return"<rect "+p+"/>"},circle:function(o){var n=o.attr,p=d({cx:n.x,cy:n.y,r:n.radius,fill:n.translation.fill||n.fill||"none","fill-opacity":n.opacity,stroke:n.stroke,"stroke-opacity":n["stroke-opacity"],"stroke-width":n["stroke-width"],transform:o.matrix.toSvg()});return"<circle "+p+" />"},image:function(o){var n=o.attr,p=d({x:n.x-(n.width/2>>0),y:n.y-(n.height/2>>0),width:n.width,height:n.height,"xlink:href":n.src,transform:o.matrix.toSvg()});return"<image "+p+" />"}},a=function(){var n='<?xml version="1.0" standalone="yes"?>';n+='<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">';return n},k=function(){var v='<svg width="'+e+'px" height="'+l+'px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1">',o="",G,E,u,p,F,I,y,w,s,x,A,n,J,t,D,B,H,C,r,q;u=f.items.items;E=u.length;F=function(N){var U=N.childNodes,R=U.length,Q=0,O,P,K="",L,T,M,S;for(;Q<R;Q++){L=U[Q];T=L.attributes;M=L.tagName;K+="<"+M;for(P=0,O=T.length;P<O;P++){S=T.item(P);K+=" "+S.name+'="'+S.value+'"'}K+=">";if(L.childNodes.length>0){K+=F(L)}K+="</"+M+">"}return K};if(f.getDefs){o=F(f.getDefs())}else{w=f.gradientsColl;if(w){s=w.keys;x=w.items;A=0;n=s.length}for(;A<n;A++){J=s[A];t=x[A];p=f.gradientsColl.getByKey(J);o+='<linearGradient id="'+J+'" x1="0" y1="0" x2="1" y2="1">';var z=p.colors.replace(i,"rgb($1|$2|$3)");z=z.replace(g,"rgba($1|$2|$3|$4)");I=z.split(",");for(D=0,H=I.length;D<H;D++){y=I[D].split(" ");z=Ext.draw.Color.fromString(y[1].replace(/\|/g,","));o+='<stop offset="'+y[0]+'" stop-color="'+z.toString()+'" stop-opacity="1"></stop>'}o+="</linearGradient>"}}v+="<defs>"+o+"</defs>";v+=j.rect({attr:{width:"100%",height:"100%",fill:"#fff",stroke:"none",opacity:"0"}});C=new Array(E);for(D=0;D<E;D++){C[D]=D}C.sort(function(L,K){r=u[L].attr.zIndex||0;q=u[K].attr.zIndex||0;if(r==q){return L-K}return r-q});for(D=0;D<E;D++){G=u[C[D]];if(!G.attr.hidden){v+=j[G.type](G)}}v+="</svg>";return v},d=function(p){var o="",n;for(n in p){if(p.hasOwnProperty(n)&&p[n]!=null){o+=n+'="'+p[n]+'" '}}return o};return{singleton:true,generate:function(n,o){o=o||{};m(n);return a()+k()}}});Ext.define("Ext.draw.engine.ImageExporter",{singleton:true,defaultUrl:"http://svg.sencha.io",supportedTypes:["image/png","image/jpeg"],widthParam:"width",heightParam:"height",typeParam:"type",svgParam:"svg",formCls:Ext.baseCSSPrefix+"hide-display",generate:function(a,b){b=b||{};var e=this,c=b.type,d;if(Ext.Array.indexOf(e.supportedTypes,c)===-1){return false}d=Ext.getBody().createChild({tag:"form",method:"POST",action:b.url||e.defaultUrl,cls:e.formCls,children:[{tag:"input",type:"hidden",name:b.widthParam||e.widthParam,value:b.width||a.width},{tag:"input",type:"hidden",name:b.heightParam||e.heightParam,value:b.height||a.height},{tag:"input",type:"hidden",name:b.typeParam||e.typeParam,value:c},{tag:"input",type:"hidden",name:b.svgParam||e.svgParam}]});d.last(null,true).value=Ext.draw.engine.SvgExporter.generate(a);d.dom.submit();d.remove();return true}});Ext.define("Ext.util.CSS",(function(){var d=null,c=document,b=/(-[a-z])/gi,a=function(e,f){return f.charAt(1).toUpperCase()};return{singleton:true,constructor:function(){this.rules={};this.initialized=false},createStyleSheet:function(h,k){var g,f=c.getElementsByTagName("head")[0],j=c.createElement("style");j.setAttribute("type","text/css");if(k){j.setAttribute("id",k)}if(Ext.isIE){f.appendChild(j);g=j.styleSheet;g.cssText=h}else{try{j.appendChild(c.createTextNode(h))}catch(i){j.cssText=h}f.appendChild(j);g=j.styleSheet?j.styleSheet:(j.sheet||c.styleSheets[c.styleSheets.length-1])}this.cacheStyleSheet(g);return g},removeStyleSheet:function(f){var e=document.getElementById(f);if(e){e.parentNode.removeChild(e)}},swapStyleSheet:function(h,e){var g=document,f;this.removeStyleSheet(h);f=g.createElement("link");f.setAttribute("rel","stylesheet");f.setAttribute("type","text/css");f.setAttribute("id",h);f.setAttribute("href",e);g.getElementsByTagName("head")[0].appendChild(f)},refreshCache:function(){return this.getRules(true)},cacheStyleSheet:function(k){if(!d){d={}}try{var n=k.cssRules||k.rules,l,h=n.length-1,f,g;for(;h>=0;--h){l=n[h].selectorText;if(l){l=l.split(",");g=l.length;for(f=0;f<g;f++){d[Ext.String.trim(l[f]).toLowerCase()]=n[h]}}}}catch(m){}},getRules:function(g){if(d===null||g){d={};var j=c.styleSheets,h=0,f=j.length;for(;h<f;h++){try{if(!j[h].disabled){this.cacheStyleSheet(j[h])}}catch(k){}}}return d},getRule:function(e,g){var f=this.getRules(g),h;if(!Ext.isArray(e)){return f[e.toLowerCase()]}for(h=0;h<e.length;h++){if(f[e[h]]){return f[e[h].toLowerCase()]}}return null},updateRule:function(e,h,g){var j,f;if(!Ext.isArray(e)){j=this.getRule(e);if(j){j.style[h.replace(b,a)]=g;return true}}else{for(f=0;f<e.length;f++){if(this.updateRule(e[f],h,g)){return true}}}return false}}}()));Ext.define("Ext.util.Grouper",{extend:"Ext.util.Sorter",isGrouper:true,getGroupString:function(a){return a.get(this.property)}});Ext.define("Ext.PluginManager",{extend:"Ext.AbstractManager",alternateClassName:"Ext.PluginMgr",singleton:true,typeName:"ptype",create:function(a,b){if(a.init){return a}else{return Ext.createByAlias("plugin."+(a.ptype||b),a)}},findByType:function(c,f){var e=[],b=this.types,a,d;for(a in b){if(!b.hasOwnProperty(a)){continue}d=b[a];if(d.type==c&&(!f||(f===true&&d.isDefault))){e.push(d)}}return e}},function(){Ext.preg=function(){return Ext.PluginManager.registerType.apply(Ext.PluginManager,arguments)}});Ext.define("Ext.resizer.Resizer",{mixins:{observable:"Ext.util.Observable"},uses:["Ext.resizer.ResizeTracker","Ext.Component"],alternateClassName:"Ext.Resizable",handleCls:Ext.baseCSSPrefix+"resizable-handle",pinnedCls:Ext.baseCSSPrefix+"resizable-pinned",overCls:Ext.baseCSSPrefix+"resizable-over",wrapCls:Ext.baseCSSPrefix+"resizable-wrap",dynamic:true,handles:"s e se",height:null,width:null,heightIncrement:0,widthIncrement:0,minHeight:20,minWidth:20,maxHeight:10000,maxWidth:10000,pinned:false,preserveRatio:false,transparent:false,possiblePositions:{n:"north",s:"south",e:"east",w:"west",se:"southeast",sw:"southwest",nw:"northwest",ne:"northeast"},constructor:function(b){var j=this,h,n,p,o=j.handles,c,m,f,d=0,l,k=[],g,a,e;j.addEvents("beforeresize","resizedrag","resize");if(Ext.isString(b)||Ext.isElement(b)||b.dom){h=b;b=arguments[1]||{};b.target=h}j.mixins.observable.constructor.call(j,b);h=j.target;if(h){if(h.isComponent){j.el=h.getEl();if(h.minWidth){j.minWidth=h.minWidth}if(h.minHeight){j.minHeight=h.minHeight}if(h.maxWidth){j.maxWidth=h.maxWidth}if(h.maxHeight){j.maxHeight=h.maxHeight}if(h.floating){if(!j.hasOwnProperty("handles")){j.handles="n ne e se s sw w nw"}}}else{j.el=j.target=Ext.get(h)}}else{j.target=j.el=Ext.get(j.el)}p=j.el.dom.tagName.toUpperCase();if(p=="TEXTAREA"||p=="IMG"||p=="TABLE"){j.originalTarget=j.target;n=j.el;e=n.getBox();j.target=j.el=j.el.wrap({cls:j.wrapCls,id:j.el.id+"-rzwrap",style:n.getStyles("margin-top","margin-bottom")});j.el.setPositioning(n.getPositioning());n.clearPositioning();j.el.setBox(e);n.setStyle("position","absolute")}j.el.position();if(j.pinned){j.el.addCls(j.pinnedCls)}j.resizeTracker=new Ext.resizer.ResizeTracker({disabled:j.disabled,target:j.target,constrainTo:j.constrainTo,overCls:j.overCls,throttle:j.throttle,originalTarget:j.originalTarget,delegate:"."+j.handleCls,dynamic:j.dynamic,preserveRatio:j.preserveRatio,heightIncrement:j.heightIncrement,widthIncrement:j.widthIncrement,minHeight:j.minHeight,maxHeight:j.maxHeight,minWidth:j.minWidth,maxWidth:j.maxWidth});j.resizeTracker.on({mousedown:j.onBeforeResize,drag:j.onResize,dragend:j.onResizeEnd,scope:j});if(j.handles=="all"){j.handles="n s e w ne nw se sw"}o=j.handles=j.handles.split(/ |\s*?[,;]\s*?/);m=j.possiblePositions;f=o.length;c=j.handleCls+" "+(j.target.isComponent?(j.target.baseCls+"-handle "):"")+j.handleCls+"-";g=Ext.isIE6?' style="height:'+j.el.getHeight()+'px"':"";for(;d<f;d++){if(o[d]&&m[o[d]]){l=m[o[d]];if(l==="east"||l==="west"){a=g}else{a=""}k.push('<div id="'+j.el.id+"-"+l+'-handle" class="'+c+l+" "+Ext.baseCSSPrefix+'unselectable"'+a+"></div>")}}Ext.DomHelper.append(j.el,k.join(""));for(d=0;d<f;d++){if(o[d]&&m[o[d]]){l=m[o[d]];j[l]=j.el.getById(j.el.id+"-"+l+"-handle");j[l].region=l;j[l].unselectable();if(j.transparent){j[l].setOpacity(0)}}}if(Ext.isNumber(j.width)){j.width=Ext.Number.constrain(j.width,j.minWidth,j.maxWidth)}if(Ext.isNumber(j.height)){j.height=Ext.Number.constrain(j.height,j.minHeight,j.maxHeight)}if(j.width!==null||j.height!==null){if(j.originalTarget){j.originalTarget.setWidth(j.width);j.originalTarget.setHeight(j.height)}j.resizeTo(j.width,j.height)}j.forceHandlesHeight()},disable:function(){this.resizeTracker.disable()},enable:function(){this.resizeTracker.enable()},onBeforeResize:function(b,c){var a=this.el.getBox();return this.fireEvent("beforeresize",this,a.width,a.height,c)},onResize:function(c,d){var b=this,a=b.el.getBox();b.forceHandlesHeight();return b.fireEvent("resizedrag",b,a.width,a.height,d)},onResizeEnd:function(c,d){var b=this,a=b.el.getBox();b.forceHandlesHeight();return b.fireEvent("resize",b,a.width,a.height,d)},resizeTo:function(b,a){var c=this;c.target.setSize(b,a);c.fireEvent("resize",c,b,a,null)},getEl:function(){return this.el},getTarget:function(){return this.target},destroy:function(){var d=0,c=this.handles,a=c.length,b=this.possiblePositions;for(;d<a;d++){this[b[c[d]]].remove()}},forceHandlesHeight:function(){var a=this,b;if(Ext.isIE6){b=a.east;if(b){b.setHeight(a.el.getHeight())}b=a.west;if(b){b.setHeight(a.el.getHeight())}a.el.repaint()}}});Ext.define("Ext.panel.Tool",{extend:"Ext.Component",requires:["Ext.tip.QuickTipManager"],alias:"widget.tool",baseCls:Ext.baseCSSPrefix+"tool",disabledCls:Ext.baseCSSPrefix+"tool-disabled",toolPressedCls:Ext.baseCSSPrefix+"tool-pressed",toolOverCls:Ext.baseCSSPrefix+"tool-over",ariaRole:"button",childEls:["toolEl"],renderTpl:['<img id="{id}-toolEl" src="{blank}" class="{baseCls}-{type}" role="presentation"/>'],tooltipType:"qtip",stopEvent:true,height:15,width:15,initComponent:function(){var a=this;a.addEvents("click");a.type=a.type||a.id;Ext.applyIf(a.renderData,{baseCls:a.baseCls,blank:Ext.BLANK_IMAGE_URL,type:a.type});a.tooltip=a.tooltip||a.qtip;a.callParent();a.on({element:"toolEl",click:a.onClick,mousedown:a.onMouseDown,mouseover:a.onMouseOver,mouseout:a.onMouseOut,scope:a})},afterRender:function(){var b=this,a;b.callParent(arguments);if(b.tooltip){if(Ext.isObject(b.tooltip)){Ext.tip.QuickTipManager.register(Ext.apply({target:b.id},b.tooltip))}else{a=b.tooltipType=="qtip"?"data-qtip":"title";b.toolEl.dom.setAttribute(a,b.tooltip)}}},getFocusEl:function(){return this.el},setType:function(a){var b=this;b.type=a;if(b.rendered){b.toolEl.dom.className=b.baseCls+"-"+a}return b},bindTo:function(a){this.owner=a},onClick:function(d,c){var b=this,a;if(b.disabled){return false}a=b.owner||b.ownerCt;b.el.removeCls(b.toolPressedCls);b.el.removeCls(b.toolOverCls);if(b.stopEvent!==false){d.stopEvent()}Ext.callback(b.handler,b.scope||b,[d,c,a,b]);b.fireEvent("click",b,d);return true},onDestroy:function(){if(Ext.isObject(this.tooltip)){Ext.tip.QuickTipManager.unregister(this.id)}this.callParent()},onMouseDown:function(){if(this.disabled){return false}this.el.addCls(this.toolPressedCls)},onMouseOver:function(){if(this.disabled){return false}this.el.addCls(this.toolOverCls)},onMouseOut:function(){this.el.removeCls(this.toolOverCls)}});Ext.define("Ext.layout.component.Body",{alias:["layout.body"],extend:"Ext.layout.component.Auto",type:"body",beginLayout:function(a){this.callParent(arguments);a.bodyContext=a.getEl("body")},calculateOwnerHeightFromContentHeight:function(c,b){var a=this.callParent(arguments);if(c.targetContext!=c){a+=c.getPaddingInfo().height}return a},calculateOwnerWidthFromContentWidth:function(c,a){var b=this.callParent(arguments);if(c.targetContext!=c){b+=c.getPaddingInfo().width}return b},measureContentWidth:function(a){return a.bodyContext.setWidth(a.bodyContext.el.dom.offsetWidth,false)},measureContentHeight:function(a){return a.bodyContext.setHeight(a.bodyContext.el.dom.offsetHeight,false)},publishInnerHeight:function(c,a){var d=a-c.getFrameInfo().height,b=c.targetContext;if(b!=c){d-=c.getPaddingInfo().height}return c.bodyContext.setHeight(d,!c.heightModel.natural)},publishInnerWidth:function(d,c){var a=c-d.getFrameInfo().width,b=d.targetContext;if(b!=d){a-=d.getPaddingInfo().width}d.bodyContext.setWidth(a,!d.widthModel.natural)}});Ext.define("Ext.Img",{extend:"Ext.Component",alias:["widget.image","widget.imagecomponent"],autoEl:"img",src:"",alt:"",imgCls:"",getElConfig:function(){var c=this,b=c.callParent(),a;if(c.autoEl=="img"){a=b}else{b.cn=[a={tag:"img",id:c.id+"-img"}]}if(c.imgCls){a.cls=(a.cls?a.cls+" ":"")+c.imgCls}a.src=c.src||Ext.BLANK_IMAGE_URL;if(c.alt){a.alt=c.alt}return b},onRender:function(){var b=this,a;b.callParent(arguments);a=b.el;b.imgEl=(b.autoEl=="img")?a:a.getById(b.id+"-img")},onDestroy:function(){Ext.destroy(this.imgEl);this.imgEl=null;this.callParent()},setSrc:function(c){var a=this,b=a.imgEl;a.src=c;if(b){b.dom.src=c||Ext.BLANK_IMAGE_URL}}});Ext.define("Ext.view.TableLayout",{extend:"Ext.layout.component.Auto",alias:["layout.tableview"],type:"tableview",beginLayout:function(b){var a=this;a.callParent(arguments);if(a.owner.table.dom){b.tableContext=b.getEl(a.owner.table);b.headerContext=b.context.getCmp(a.headerCt)}},calculate:function(b){var a=this;a.callParent(arguments);if(b.tableContext){if(b.state.columnWidthsSynced){if(b.hasProp("columnWidthsFlushed")){b.tableContext.setHeight(b.tableContext.el.dom.offsetHeight,false)}else{a.done=false}}else{if(b.headerContext.hasProp("columnWidthsDone")){b.context.queueFlush(a);b.state.columnWidthsSynced=true}a.done=false}}},measureContentHeight:function(a){if(!a.headerContext||a.hasProp("columnWidthsFlushed")){return this.callParent(arguments)}},flush:function(){var h=this,e=h.ownerContext.context,d=h.headerCt.getGridColumns(),c=0,b=d.length,g=h.owner.el,a=0,f;e.currentLayout=h;for(c=0;c<b;c++){f=d[c].hidden?0:e.getCmp(d[c]).props.width;a+=f;g.select(h.getColumnSelector(d[c])).setWidth(f)}g.select("table."+Ext.baseCSSPrefix+"grid-table-resizer").setWidth(a);h.ownerContext.setProp("columnWidthsFlushed",true)},finishedLayout:function(){var a=this,b;a.callParent(arguments);if(Ext.isGecko){b=a.headerCt.getGridColumns()[0];if(b){b=a.owner.el.down(a.getColumnSelector(b));if(b){b.setStyle("display","none");b.dom.scrollWidth;b.setStyle("display","")}}}},getColumnSelector:function(a){return"th."+Ext.baseCSSPrefix+"grid-col-resizer-"+a.id}});Ext.define("Ext.view.TableChunker",{singleton:true,requires:["Ext.XTemplate"],metaTableTpl:["{%if (this.openTableWrap)out.push(this.openTableWrap())%}",'<table class="'+Ext.baseCSSPrefix+"grid-table "+Ext.baseCSSPrefix+'grid-table-resizer" border="0" cellspacing="0" cellpadding="0" {[this.embedFullWidth(values)]}>',"<tbody>",'<tr class="'+Ext.baseCSSPrefix+'grid-header-row">','<tpl for="columns">','<th class="'+Ext.baseCSSPrefix+'grid-col-resizer-{id}" style="width: {width}px; height: 0px;"></th>',"</tpl>","</tr>","{[this.openRows()]}","{row}",'<tpl for="features">',"{[this.embedFeature(values, parent, xindex, xcount)]}","</tpl>","{[this.closeRows()]}","</tbody>","</table>","{%if (this.closeTableWrap)out.push(this.closeTableWrap())%}"],constructor:function(){Ext.XTemplate.prototype.recurse=function(b,a){return this.apply(a?b[a]:b)}},embedFeature:function(b,d,a,e){var c="";if(!b.disabled){c=b.getFeatureTpl(b,d,a,e)}return c},embedFullWidth:function(b){var a='style="width:{fullWidth}px;';if(!b.rowCount){a+="height:1px;"}return a+'"'},openRows:function(){return'<tpl for="rows">'},closeRows:function(){return"</tpl>"},metaRowTpl:['<tr class="'+Ext.baseCSSPrefix+'grid-row {[this.embedRowCls()]}" {[this.embedRowAttr()]}>','<tpl for="columns">','<td class="{cls} '+Ext.baseCSSPrefix+"grid-cell "+Ext.baseCSSPrefix+'grid-cell-{columnId} {{id}-modified} {{id}-tdCls} {[this.firstOrLastCls(xindex, xcount)]}" {{id}-tdAttr}>','<div {unselectableAttr} class="'+Ext.baseCSSPrefix+'grid-cell-inner {unselectableCls}" style="text-align: {align}; {{id}-style};">{{id}}</div>',"</td>","</tpl>","</tr>"],firstOrLastCls:function(a,b){if(a===1){return Ext.view.Table.prototype.firstCls}else{if(a===b){return Ext.view.Table.prototype.lastCls}}},embedRowCls:function(){return"{rowCls}"},embedRowAttr:function(){return"{rowAttr}"},openTableWrap:undefined,closeTableWrap:undefined,getTableTpl:function(j,b){var h,g={openRows:this.openRows,closeRows:this.closeRows,embedFeature:this.embedFeature,embedFullWidth:this.embedFullWidth,openTableWrap:this.openTableWrap,closeTableWrap:this.closeTableWrap},f={},c=j.features||[],l=c.length,e=0,k={embedRowCls:this.embedRowCls,embedRowAttr:this.embedRowAttr,firstOrLastCls:this.firstOrLastCls,unselectableAttr:j.enableTextSelection?"":'unselectable="on"',unselectableCls:j.enableTextSelection?"":Ext.baseCSSPrefix+"unselectable"},d=Array.prototype.slice.call(this.metaRowTpl,0),a;for(;e<l;e++){if(!c[e].disabled){c[e].mutateMetaRowTpl(d);Ext.apply(k,c[e].getMetaRowTplFragments());Ext.apply(f,c[e].getFragmentTpl());Ext.apply(g,c[e].getTableFragments())}}d=new Ext.XTemplate(d.join(""),k);j.row=d.applyTemplate(j);a=new Ext.XTemplate(this.metaTableTpl.join(""),g);h=a.applyTemplate(j);if(!b){h=new Ext.XTemplate(h,f)}return h}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("Ext.ux.desktop.Wallpaper",{extend:"Ext.Component",alias:"widget.wallpaper",cls:"ux-wallpaper",html:'<img src="'+Ext.BLANK_IMAGE_URL+'">',stretch:false,wallpaper:null,stateful:true,stateId:"desk-wallpaper",afterRender:function(){var a=this;a.callParent();a.setWallpaper(a.wallpaper,a.stretch)},applyState:function(){var b=this,a=b.wallpaper;b.callParent(arguments);if(a!=b.wallpaper){b.setWallpaper(b.wallpaper)}},getState:function(){return this.wallpaper&&{wallpaper:this.wallpaper}},setWallpaper:function(b,a){var c=this,e,d;c.stretch=(a!==false);c.wallpaper=b;if(c.rendered){e=c.el.dom.firstChild;if(!b||b==Ext.BLANK_IMAGE_URL){Ext.fly(e).hide()}else{if(c.stretch){e.src=b;c.el.removeCls("ux-wallpaper-tiled");Ext.fly(e).setStyle({width:"100%",height:"100%"}).show()}else{Ext.fly(e).hide();d="url("+b+")";c.el.addCls("ux-wallpaper-tiled")}}c.el.setStyle({backgroundImage:d||""});if(c.stateful){c.saveState()}}return c}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("MyDesktop.WallpaperModel",{extend:"Ext.data.Model",fields:[{name:"text"},{name:"img"}]});Ext.define("Ext.selection.CellModel",{extend:"Ext.selection.Model",alias:"selection.cellmodel",requires:["Ext.util.KeyNav"],isCellModel:true,enableKeyNav:true,preventWrap:false,noSelection:{row:-1,column:-1},constructor:function(){this.addEvents("deselect","select");this.callParent(arguments)},bindComponent:function(a){var c=this,b=a.ownerCt;c.primaryView=a;c.views=c.views||[];c.views.push(a);c.bindStore(a.getStore(),true);a.on({cellmousedown:c.onMouseDown,refresh:c.onViewRefresh,scope:c});if(b.optimizedColumnMove!==false){b.on("columnmove",c.onColumnMove,c)}if(c.enableKeyNav){c.initKeyNav(a)}},initKeyNav:function(a){var b=this;if(!a.rendered){a.on("render",Ext.Function.bind(b.initKeyNav,b,[a],0),b,{single:true});return}a.el.set({tabIndex:-1});b.keyNav=new Ext.util.KeyNav({target:a.el,ignoreInputFields:true,up:b.onKeyUp,down:b.onKeyDown,right:b.onKeyRight,left:b.onKeyLeft,tab:b.onKeyTab,scope:b})},getHeaderCt:function(){var b=this.getCurrentPosition(),a=b?b.view:this.primaryView;return a.headerCt},onKeyUp:function(b,a){this.keyNavigation=true;this.move("up",b);this.keyNavigation=false},onKeyDown:function(b,a){this.keyNavigation=true;this.move("down",b);this.keyNavigation=false},onKeyLeft:function(b,a){this.keyNavigation=true;this.move("left",b);this.keyNavigation=false},onKeyRight:function(b,a){this.keyNavigation=true;this.move("right",b);this.keyNavigation=false},move:function(a,d){var c=this,f=c.getCurrentPosition(),b=f.view.walkCells(f,a,d,c.preventWrap);if(b){b.view=f.view;return c.setCurrentPosition(b)}},getCurrentPosition:function(){return this.selection},setCurrentPosition:function(b){var a=this;a.lastSelection=a.selection;if(a.selection){a.onCellDeselect(a.selection)}if(b){a.nextSelection=new a.Selection(a);a.nextSelection.setPosition(b);a.onCellSelect(a.nextSelection);return a.selection=a.nextSelection}},onStoreRemove:function(b,a,c){var d=this,e=d.getCurrentPosition();d.callParent(arguments);if(e){if(e.row==c){if(c<b.getCount()-1){e.setPosition(c,e.column);d.setCurrentPosition(e)}else{delete d.selection}}else{if(c<e.row){e.setPosition(e.row-1,e.column);d.setCurrentPosition(e)}}}},onMouseDown:function(c,a,d,b,g,h,f){this.setCurrentPosition({view:c,row:h,column:d})},onCellSelect:function(a,b){if(a&&a.row!==undefined&&a.row>-1){this.doSelect(a.view.getStore().getAt(a.row),false,b)}},onCellDeselect:function(a,b){if(a&&a.row!==undefined){this.doDeselect(a.view.getStore().getAt(a.row),b)}},onSelectChange:function(b,e,d,g){var f=this,h,c,a;if(e){h=f.nextSelection;c="select"}else{h=f.lastSelection||f.noSelection;c="deselect"}a=h.view||f.primaryView;if((d||f.fireEvent("before"+c,f,b,h.row,h.column))!==false&&g()!==false){if(e){a.onCellSelect(h);a.onCellFocus(h)}else{a.onCellDeselect(h);delete f.selection}if(!d){f.fireEvent(c,f,b,h.row,h.column)}}},onKeyTab:function(d,b){var c=this,a=c.getCurrentPosition().view.editingPlugin;if(a&&c.wasEditing){c.onEditorTab(a,d)}else{c.move(d.shiftKey?"left":"right",d)}},onEditorTab:function(b,f){var c=this,d=f.shiftKey?"left":"right",a=c.move(d,f);if(a){if(b.startEditByPosition(a)){c.wasEditing=false}else{c.wasEditing=true;if(!a.columnHeader.dataIndex){c.onEditorTab(b,f)}}}},refresh:function(){var b=this.getCurrentPosition(),a;if(b&&(a=this.store.indexOf(this.selected.last()))!==-1){b.row=a}},onColumnMove:function(d,e,b,c){var a=d.up("tablepanel");if(a){this.onViewRefresh(a.view)}},onViewRefresh:function(b){var c=this,f=c.getCurrentPosition(),e=b.headerCt,a,d;if(f&&f.view===b){a=f.record;d=f.columnHeader;if(!d.isDescendantOf(e)){d=e.queryById(d.id)||e.down('[text="'+d.text+'"]')||e.down('[dataIndex="'+d.dataIndex+'"]')}if(d&&(b.store.indexOfId(a.getId())!==-1)){c.setCurrentPosition({row:a,column:d,view:b})}}},selectByPosition:function(a){this.setCurrentPosition(a)}},function(){var a=this.prototype.Selection=function(b){this.model=b};a.prototype.setPosition=function(e,c){var d=this,b;if(arguments.length===1){if(e.view){d.view=b=e.view}c=e.column;e=e.row}if(!b){d.view=b=d.model.primaryView}if(typeof e==="number"){d.row=e;d.record=b.store.getAt(e)}else{if(e.isModel){d.record=e;d.row=b.indexOf(e)}else{if(e.tagName){d.record=b.getRecord(e);d.row=b.indexOf(d.record)}}}if(typeof c==="number"){d.column=c;d.columnHeader=b.getHeaderAtIndex(c)}else{d.columnHeader=c;d.column=c.getIndex()}return d}});Ext.define("Ext.selection.CheckboxModel",{alias:"selection.checkboxmodel",extend:"Ext.selection.RowModel",mode:"MULTI",injectCheckbox:0,checkOnly:false,showHeaderCheckbox:true,headerWidth:24,checkerOnCls:Ext.baseCSSPrefix+"grid-hd-checker-on",refreshOnRemove:true,beforeViewRender:function(a){var b=this;b.callParent(arguments);if(!b.hasLockedHeader()||a.headerCt.lockedCt){if(b.showHeaderCheckbox!==false){a.headerCt.on("headerclick",b.onHeaderClick,b)}b.addCheckbox(a,true);b.mon(a.ownerCt,"reconfigure",b.onReconfigure,b)}},bindComponent:function(a){var b=this;b.sortable=false;b.callParent(arguments)},hasLockedHeader:function(){var a=this.views,c=a.length,b;for(b=0;b<c;b++){if(a[b].headerCt.lockedCt){return true}}return false},addCheckbox:function(a,b){var c=this,d=c.injectCheckbox,e=a.headerCt;if(d!==false){if(d=="first"){d=0}else{if(d=="last"){d=e.getColumnCount()}}Ext.suspendLayouts();e.add(d,c.getHeaderConfig());Ext.resumeLayouts()}if(b!==true){a.refresh()}},onReconfigure:function(c,a,b){if(b){this.addCheckbox(this.views[0])}},toggleUiHeader:function(d){var a=this.views[0],c=a.headerCt,b=c.child("gridcolumn[isCheckerHd]");if(b){if(d){b.el.addCls(this.checkerOnCls)}else{b.el.removeCls(this.checkerOnCls)}}},onHeaderClick:function(c,f,b){if(f.isCheckerHd){b.stopEvent();var a=this,d=f.el.hasCls(Ext.baseCSSPrefix+"grid-hd-checker-on");a.preventFocus=true;if(d){a.deselectAll()}else{a.selectAll()}delete a.preventFocus}},getHeaderConfig:function(){var a=this,b=a.showHeaderCheckbox!==false;return{isCheckerHd:b,text:"&#160;",width:a.headerWidth,sortable:false,draggable:false,resizable:false,hideable:false,menuDisabled:true,dataIndex:"",cls:b?Ext.baseCSSPrefix+"column-header-checkbox ":"",renderer:Ext.Function.bind(a.renderer,a),editRenderer:a.editRenderer||a.renderEmpty,locked:a.hasLockedHeader()}},renderEmpty:function(){return"&#160;"},renderer:function(g,c,b,h,e,d,a){var f=Ext.baseCSSPrefix;c.tdCls=f+"grid-cell-special "+f+"grid-cell-row-checker";return'<div class="'+f+'grid-row-checker">&#160;</div>'},onRowMouseDown:function(b,a,g,d,h){b.el.focus();var f=this,c=h.getTarget("."+Ext.baseCSSPrefix+"grid-row-checker"),i;if(!f.allowRightMouseSelection(h)){return}if(f.checkOnly&&!c){return}if(c){i=f.getSelectionMode();if(i!=="SINGLE"){f.setSelectionMode("SIMPLE")}f.selectWithEvent(a,h);f.setSelectionMode(i)}else{f.selectWithEvent(a,h)}},onSelectChange:function(){var a=this;a.callParent(arguments);a.updateHeaderState()},onStoreLoad:function(){var a=this;a.callParent(arguments);a.updateHeaderState()},updateHeaderState:function(){var a=this.selected.getCount()===this.store.getCount();this.toggleUiHeader(a)}});Ext.define("Ext.grid.PagingScroller",{percentageFromEdge:0.35,numFromEdge:2,trailingBufferZone:5,leadingBufferZone:15,scrollToLoadBuffer:200,viewSize:0,rowHeight:21,tableStart:0,tableEnd:0,constructor:function(a){var b=this;b.variableRowHeight=a.variableRowHeight;b.bindView(a.view);Ext.apply(b,a);b.callParent(arguments)},bindView:function(b){var f=this,d={scroll:{fn:f.onViewScroll,element:"el",scope:f},render:f.onViewRender,resize:f.onViewResize,boxready:{fn:f.onViewResize,scope:f,single:true},beforerefresh:f.beforeViewRefresh,refresh:f.onViewRefresh,scope:f},a={guaranteedrange:f.onGuaranteedRange,scope:f},c={reconfigure:f.onGridReconfigure,scope:f},e;if(f.view){if(f.view.el){f.view.el.un("scroll",f.onViewScroll,f)}e=b.lockingPartner;if(e){e.un("refresh",f.onLockRefresh,f)}f.view.un(d);f.store.un(a);if(f.grid){f.grid.un(c)}delete f.view.refreshSize}f.view=b;f.grid=f.view.up("tablepanel");f.store=b.store;if(b.rendered){f.viewSize=f.store.viewSize=Math.ceil(b.getHeight()/f.rowHeight)+f.trailingBufferZone+(f.numFromEdge*2)+f.leadingBufferZone}e=b.lockingPartner;if(e){e.on("refresh",f.onLockRefresh,f)}f.view.mon(f.store.pageMap,{scope:f,clear:f.onCacheClear});f.view.refreshSize=Ext.Function.createInterceptor(f.view.refreshSize,f.beforeViewrefreshSize,f);f.position=0;if(f.grid){f.grid.on(c)}else{f.view.on({added:function(){f.grid=f.view.up("tablepanel");f.grid.on(c)},single:true})}f.view.on(f.viewListeners=d);f.store.on(a)},onCacheClear:function(){var a=this;if(a.view.rendered&&!a.store.isDestroyed){a.ignoreNextScrollEvent=a.view.el.dom.scrollTop!==0;a.view.el.dom.scrollTop=0;delete a.lastScrollDirection;delete a.scrollOffset;delete a.scrollProportion}},onGridReconfigure:function(a){this.bindView(a.view)},onViewRender:function(){var d=this,a=d.view,c=d.view.el,b;d.stretcher=d.createStretcher(a);a=a.lockingPartner;if(a){b=d.stretcher;d.stretcher=new Ext.CompositeElement(b);d.stretcher.add(d.createStretcher(a))}},createStretcher:function(a){var b=a.el;b.setStyle("position","relative");return b.createChild({style:{position:"absolute",width:"1px",height:0,top:0,left:0}},b.dom.firstChild)},onViewResize:function(b,d,a){var e=this,c;c=Math.ceil(a/e.rowHeight)+e.trailingBufferZone+(e.numFromEdge*2)+e.leadingBufferZone;if(c>e.viewSize){e.viewSize=e.store.viewSize=c;e.handleViewScroll(e.lastScrollDirection||1)}},beforeViewRefresh:function(){var b=this,a=b.view,c,d;b.focusOnRefresh=Ext.Element.getActiveElement===a.el.dom;if(b.variableRowHeight){d=b.lastScrollDirection;b.commonRecordIndex=undefined;if(d&&(b.previousStart!==undefined)&&(b.scrollProportion===undefined)&&(c=a.getNodes()).length){if(d===1){if(b.tableStart<=b.previousEnd){b.commonRecordIndex=c.length-1}}else{if(d===-1){if(b.tableEnd>=b.previousStart){b.commonRecordIndex=0}}}b.scrollOffset=-a.el.getOffsetsTo(c[b.commonRecordIndex])[1];b.commonRecordIndex-=(b.tableStart-b.previousStart)}else{b.scrollOffset=undefined}}},onLockRefresh:function(a){a.table.dom.style.position="absolute"},onViewRefresh:function(){var d=this,f=d.store,c,e=d.view,i=e.el,j=i.dom,l,h,b,k=e.table.dom,g,a;if(d.focusOnRefresh){i.focus();d.focusOnRefresh=false}d.disabled=true;if(f.getCount()===f.getTotalCount()||(f.isFiltered()&&!f.remoteFilter)){d.stretcher.setHeight(0);d.position=j.scrollTop=0;d.setTablePosition("absolute");return}d.stretcher.setHeight(c=d.getScrollHeight());a=j.scrollTop;d.isScrollRefresh=(a>0);if(d.scrollProportion!==undefined){d.setTablePosition("absolute");d.setTableTop((d.scrollProportion?(c*d.scrollProportion)-(k.offsetHeight*d.scrollProportion):0)+"px")}else{d.setTablePosition("absolute");d.setTableTop((g=(d.tableStart||0)*d.rowHeight)+"px");if(d.scrollOffset){l=e.getNodes();h=-i.getOffsetsTo(l[d.commonRecordIndex])[1];b=h-d.scrollOffset;d.position=(j.scrollTop+=b)}else{if((g>a)||((g+k.offsetHeight)<a+j.clientHeight)){d.lastScrollDirection=-1;d.position=j.scrollTop=g}}}d.disabled=false},setTablePosition:function(a){this.setViewTableStyle(this.view,"position",a)},setTableTop:function(a){this.setViewTableStyle(this.view,"top",a)},setViewTableStyle:function(a,c,b){a.el.child("table",true).style[c]=b;a=a.lockingPartner;if(a){a.el.child("table",true).style[c]=b}},beforeViewrefreshSize:function(){if(this.isScrollRefresh){this.view.table.attach(this.view.el.child("table",true));return(this.isScrollRefresh=false)}},onGuaranteedRange:function(b,e,a){var c=this,d=c.store;if(b.length&&c.visibleStart<b[0].index){return}c.previousStart=c.tableStart;c.previousEnd=c.tableEnd;c.tableStart=e;c.tableEnd=a;d.loadRecords(b,{start:e})},onViewScroll:function(f,c){var d=this,a=d.view,b=d.position;d.position=a.el.dom.scrollTop;if(d.ignoreNextScrollEvent){d.ignoreNextScrollEvent=false;return}if(!d.disabled){d.lastScrollDirection=d.position>b?1:-1;if(b!==d.position){d.handleViewScroll(d.lastScrollDirection)}}},handleViewScroll:function(h){var e=this,j=e.store,g=e.view,f=e.viewSize,k=j.getTotalCount(),d=k-f,c=e.getFirstVisibleRowIndex(),i=e.getLastVisibleRowIndex(),a=g.el.dom,b,l;if(k>=f){e.scrollProportion=undefined;if(h==-1){if(e.tableStart){if(c!==undefined){if(c<(e.tableStart+e.numFromEdge)){b=Math.max(0,i+e.trailingBufferZone-f)}}else{e.scrollProportion=a.scrollTop/(a.scrollHeight-a.clientHeight);b=Math.max(0,k*e.scrollProportion-(f/2)-e.numFromEdge-((e.leadingBufferZone+e.trailingBufferZone)/2))}}}else{if(c!==undefined){if(i>(e.tableEnd-e.numFromEdge)){b=Math.max(0,c-e.trailingBufferZone)}}else{e.scrollProportion=a.scrollTop/(a.scrollHeight-a.clientHeight);b=k*e.scrollProportion-(f/2)-e.numFromEdge-((e.leadingBufferZone+e.trailingBufferZone)/2)}}if(b!==undefined){if(b>d){b=d&~1;l=k-1}else{b=b&~1;l=b+f-1}if(j.rangeCached(b,l)){e.cancelLoad();j.guaranteeRange(b,l)}else{e.attemptLoad(b,l)}}}},getFirstVisibleRowIndex:function(){var d=this,a=d.view,g=a.el.dom.scrollTop,e,c,b,f;if(d.variableRowHeight){e=a.getNodes();c=e.length;if(!c){return}f=Ext.fly(e[0]).getOffsetsTo(a.el)[1];for(b=0;b<c;b++){f+=e[b].offsetHeight;if(f>a.el.dom.clientHeight){return}if(f>0){return a.getRecord(e[b]).index}}}else{return Math.floor(g/d.rowHeight)}},getLastVisibleRowIndex:function(){var g=this,c=g.store,a=g.view,b=a.el.dom.clientHeight,h,f,e,d;if(g.variableRowHeight){h=a.getNodes();if(!h.length){return}f=c.getCount()-1;d=Ext.fly(h[f]).getOffsetsTo(a.el)[1]+h[f].offsetHeight;for(e=f;e>=0;e--){d-=h[e].offsetHeight;if(d<0){return}if(d<b){return a.getRecord(h[e]).index}}}else{return g.getFirstVisibleRowIndex()+Math.ceil(b/g.rowHeight)+1}},getScrollHeight:function(){var e=this,a=e.view,d,g,b=e.store,f=0,c=!e.hasOwnProperty("rowHeight");if(e.variableRowHeight){d=e.view.table.dom;if(c){e.initialTableHeight=d.offsetHeight;e.rowHeight=e.initialTableHeight/e.store.getCount()}else{f=d.offsetHeight-e.initialTableHeight;if(b.getCount()>e.viewSize){f-=e.rowHeight}}}else{if(c){g=a.el.down(a.getItemSelector());if(g){e.rowHeight=g.getHeight(false,true)}}}return Math.floor(b.getTotalCount()*e.rowHeight)+f},attemptLoad:function(c,a){var b=this;if(b.scrollToLoadBuffer){if(!b.loadTask){b.loadTask=new Ext.util.DelayedTask(b.doAttemptLoad,b,[])}b.loadTask.delay(b.scrollToLoadBuffer,b.doAttemptLoad,b,[c,a])}else{b.store.guaranteeRange(c,a)}},cancelLoad:function(){if(this.loadTask){this.loadTask.cancel()}},doAttemptLoad:function(b,a){this.store.guaranteeRange(b,a)},destroy:function(){var b=this,a=b.viewListeners.scroll;b.store.un({guaranteedrange:b.onGuaranteedRange,scope:b});b.view.un(b.viewListeners);if(b.view.rendered){b.stretcher.remove();b.view.el.un("scroll",a.fn,a.scope)}}});Ext.define("Ext.util.Queue",{constructor:function(){this.clear()},add:function(c){var b=this,a=b.getKey(c);if(!b.map[a]){++b.length;b.items.push(c);b.map[a]=c}return c},clear:function(){var b=this,a=b.items;b.items=[];b.map={};b.length=0;return a},contains:function(b){var a=this.getKey(b);return this.map.hasOwnProperty(a)},getCount:function(){return this.length},getKey:function(a){return a.id},remove:function(e){var d=this,c=d.getKey(e),a=d.items,b;if(d.map[c]){b=Ext.Array.indexOf(a,e);Ext.Array.erase(a,b,1);delete d.map[c];--d.length}return e}});Ext.define("Ext.menu.Item",{extend:"Ext.Component",alias:"widget.menuitem",alternateClassName:"Ext.menu.TextItem",activeCls:Ext.baseCSSPrefix+"menu-item-active",ariaRole:"menuitem",canActivate:true,clickHideDelay:1,destroyMenu:true,disabledCls:Ext.baseCSSPrefix+"menu-item-disabled",hideOnClick:true,isMenuItem:true,menuAlign:"tl-tr?",menuExpandDelay:200,menuHideDelay:200,tooltipType:"qtip",arrowCls:Ext.baseCSSPrefix+"menu-item-arrow",childEls:["itemEl","iconEl","textEl","arrowEl"],renderTpl:['<tpl if="plain">',"{text}","<tpl else>",'<a id="{id}-itemEl" class="'+Ext.baseCSSPrefix+'menu-item-link" href="{href}" <tpl if="hrefTarget">target="{hrefTarget}"</tpl> hidefocus="true" unselectable="on">','<img id="{id}-iconEl" src="{icon}" class="'+Ext.baseCSSPrefix+'menu-item-icon {iconCls}" />','<span id="{id}-textEl" class="'+Ext.baseCSSPrefix+'menu-item-text" <tpl if="arrowCls">style="margin-right: 17px;"</tpl> >{text}</span>','<img id="{id}-arrowEl" src="{blank}" class="{arrowCls}" />',"</a>","</tpl>"],maskOnDisable:false,activate:function(){var a=this;if(!a.activated&&a.canActivate&&a.rendered&&!a.isDisabled()&&a.isVisible()){a.el.addCls(a.activeCls);a.focus();a.activated=true;a.fireEvent("activate",a)}},getFocusEl:function(){return this.itemEl},deactivate:function(){var a=this;if(a.activated){a.el.removeCls(a.activeCls);a.blur();a.hideMenu();a.activated=false;a.fireEvent("deactivate",a)}},deferExpandMenu:function(){var a=this;if(a.activated&&(!a.menu.rendered||!a.menu.isVisible())){a.parentMenu.activeChild=a.menu;a.menu.parentItem=a;a.menu.parentMenu=a.menu.ownerCt=a.parentMenu;a.menu.showBy(a,a.menuAlign)}},deferHideMenu:function(){if(this.menu.isVisible()){this.menu.hide()}},cancelDeferHide:function(){clearTimeout(this.hideMenuTimer)},deferHideParentMenus:function(){var a;Ext.menu.Manager.hideAll();if(!Ext.Element.getActiveElement()){a=this.up(":not([hidden])");if(a){a.focus()}}},expandMenu:function(a){var b=this;if(b.menu){b.cancelDeferHide();if(a===0){b.deferExpandMenu()}else{b.expandMenuTimer=Ext.defer(b.deferExpandMenu,Ext.isNumber(a)?a:b.menuExpandDelay,b)}}},getRefItems:function(a){var c=this.menu,b;if(c){b=c.getRefItems(a);b.unshift(c)}return b||[]},hideMenu:function(a){var b=this;if(b.menu){clearTimeout(b.expandMenuTimer);b.hideMenuTimer=Ext.defer(b.deferHideMenu,Ext.isNumber(a)?a:b.menuHideDelay,b)}},initComponent:function(){var b=this,c=Ext.baseCSSPrefix,a=[c+"menu-item"],d;b.addEvents("activate","click","deactivate");if(b.plain){a.push(c+"menu-item-plain")}if(b.cls){a.push(b.cls)}b.cls=a.join(" ");if(b.menu){d=b.menu;delete b.menu;b.setMenu(d)}b.callParent(arguments)},onClick:function(b){var a=this;if(!a.href){b.stopEvent()}if(a.disabled){return}if(a.hideOnClick){a.deferHideParentMenusTimer=Ext.defer(a.deferHideParentMenus,a.clickHideDelay,a)}Ext.callback(a.handler,a.scope||a,[a,b]);a.fireEvent("click",a,b);if(!a.hideOnClick){a.focus()}},onRemoved:function(){var a=this;if(a.activated&&a.parentMenu.activeItem===a){a.parentMenu.deactivateActiveItem()}a.callParent(arguments);delete a.parentMenu;delete a.ownerButton},beforeDestroy:function(){var a=this;if(a.rendered){a.clearTip()}a.callParent()},onDestroy:function(){var a=this;clearTimeout(a.expandMenuTimer);a.cancelDeferHide();clearTimeout(a.deferHideParentMenusTimer);a.setMenu(null);a.callParent(arguments)},beforeRender:function(){var b=this,d=Ext.BLANK_IMAGE_URL,a,c;b.callParent();if(b.iconAlign==="right"){a=b.checkChangeDisabled?b.disabledCls:"";c=Ext.baseCSSPrefix+"menu-item-icon-right "+b.iconCls}else{a=b.iconCls+(b.checkChangeDisabled?" "+b.disabledCls:"");c=b.menu?b.arrowCls:""}Ext.applyIf(b.renderData,{href:b.href||"#",hrefTarget:b.hrefTarget,icon:b.icon||d,iconCls:a,plain:b.plain,text:b.text,arrowCls:c,blank:d})},onRender:function(){var a=this;a.callParent(arguments);if(a.tooltip){a.setTooltip(a.tooltip,true)}},setMenu:function(e,d){var c=this,b=c.menu,a=c.arrowEl;if(b){delete b.parentItem;delete b.parentMenu;delete b.ownerCt;delete b.ownerItem;if(d===true||(d!==false&&c.destroyMenu)){Ext.destroy(b)}}if(e){c.menu=Ext.menu.Manager.get(e);c.menu.ownerItem=c}else{c.menu=null}if(c.rendered&&!c.destroying&&a){a[c.menu?"addCls":"removeCls"](c.arrowCls)}},setHandler:function(b,a){this.handler=b||null;this.scope=a},setIcon:function(b){var a=this.iconEl;if(a){a.src=b||Ext.BLANK_IMAGE_URL}this.icon=b},setIconCls:function(b){var c=this,a=c.iconEl;if(a){if(c.iconCls){a.removeCls(c.iconCls)}if(b){a.addCls(b)}}c.iconCls=b},setText:function(c){var b=this,a=b.textEl||b.el;b.text=c;if(b.rendered){a.update(c||"");b.ownerCt.updateLayout()}},getTipAttr:function(){return this.tooltipType=="qtip"?"data-qtip":"title"},clearTip:function(){if(Ext.isObject(this.tooltip)){Ext.tip.QuickTipManager.unregister(this.itemEl)}},setTooltip:function(c,a){var b=this;if(b.rendered){if(!a){b.clearTip()}if(Ext.isObject(c)){Ext.tip.QuickTipManager.register(Ext.apply({target:b.itemEl.id},c));b.tooltip=c}else{b.itemEl.dom.setAttribute(b.getTipAttr(),c)}}else{b.tooltip=c}return b}});Ext.define("Ext.draw.Matrix",{requires:["Ext.draw.Draw"],constructor:function(h,g,l,k,j,i){if(h!=null){this.matrix=[[h,l,j],[g,k,i],[0,0,1]]}else{this.matrix=[[1,0,0],[0,1,0],[0,0,1]]}},add:function(s,p,m,k,i,h){var n=this,g=[[],[],[]],r=[[s,m,i],[p,k,h],[0,0,1]],q,o,l,j;for(q=0;q<3;q++){for(o=0;o<3;o++){j=0;for(l=0;l<3;l++){j+=n.matrix[q][l]*r[l][o]}g[q][o]=j}}n.matrix=g},prepend:function(s,p,m,k,i,h){var n=this,g=[[],[],[]],r=[[s,m,i],[p,k,h],[0,0,1]],q,o,l,j;for(q=0;q<3;q++){for(o=0;o<3;o++){j=0;for(l=0;l<3;l++){j+=r[q][l]*n.matrix[l][o]}g[q][o]=j}}n.matrix=g},invert:function(){var j=this.matrix,i=j[0][0],h=j[1][0],n=j[0][1],m=j[1][1],l=j[0][2],k=j[1][2],g=i*m-h*n;return new Ext.draw.Matrix(m/g,-h/g,-n/g,i/g,(n*k-m*l)/g,(h*l-i*k)/g)},clone:function(){var i=this.matrix,h=i[0][0],g=i[1][0],m=i[0][1],l=i[1][1],k=i[0][2],j=i[1][2];return new Ext.draw.Matrix(h,g,m,l,k,j)},translate:function(a,b){this.prepend(1,0,0,1,a,b)},scale:function(b,e,a,d){var c=this;if(e==null){e=b}c.add(b,0,0,e,a*(1-b),d*(1-e))},rotate:function(c,b,g){c=Ext.draw.Draw.rad(c);var e=this,f=+Math.cos(c).toFixed(9),d=+Math.sin(c).toFixed(9);e.add(f,d,-d,f,b-f*b+d*g,-(d*b)+g-f*g)},x:function(a,c){var b=this.matrix;return a*b[0][0]+c*b[0][1]+b[0][2]},y:function(a,c){var b=this.matrix;return a*b[1][0]+c*b[1][1]+b[1][2]},get:function(b,a){return +this.matrix[b][a].toFixed(4)},toString:function(){var a=this;return[a.get(0,0),a.get(0,1),a.get(1,0),a.get(1,1),0,0].join()},toSvg:function(){var a=this;return"matrix("+[a.get(0,0),a.get(1,0),a.get(0,1),a.get(1,1),a.get(0,2),a.get(1,2)].join()+")"},toFilter:function(b,a){var c=this;b=b||0;a=a||0;return"progid:DXImageTransform.Microsoft.Matrix(sizingMethod='auto expand', filterType='bilinear', M11="+c.get(0,0)+", M12="+c.get(0,1)+", M21="+c.get(1,0)+", M22="+c.get(1,1)+", Dx="+(c.get(0,2)+b)+", Dy="+(c.get(1,2)+a)+")"},offset:function(){var a=this.matrix;return[(a[0][2]||0).toFixed(4),(a[1][2]||0).toFixed(4)]},split:function(){function d(f){return f[0]*f[0]+f[1]*f[1]}function b(f){var g=Math.sqrt(d(f));f[0]/=g;f[1]/=g}var a=this.matrix,c={translateX:a[0][2],translateY:a[1][2]},e;e=[[a[0][0],a[0][1]],[a[1][1],a[1][1]]];c.scaleX=Math.sqrt(d(e[0]));b(e[0]);c.shear=e[0][0]*e[1][0]+e[0][1]*e[1][1];e[1]=[e[1][0]-e[0][0]*c.shear,e[1][1]-e[0][1]*c.shear];c.scaleY=Math.sqrt(d(e[1]));b(e[1]);c.shear/=c.scaleY;c.rotate=Math.asin(-e[0][1]);c.isSimple=!+c.shear.toFixed(9)&&(c.scaleX.toFixed(9)==c.scaleY.toFixed(9)||!c.rotate);return c}});Ext.define("Ext.ElementLoader",{mixins:{observable:"Ext.util.Observable"},uses:["Ext.data.Connection","Ext.Ajax"],statics:{Renderer:{Html:function(a,b,c){a.getTarget().update(b.responseText,c.scripts===true);return true}}},url:null,params:null,baseParams:null,autoLoad:false,target:null,loadMask:false,ajaxOptions:null,scripts:false,isLoader:true,constructor:function(b){var c=this,a;b=b||{};Ext.apply(c,b);c.setTarget(c.target);c.addEvents("beforeload","exception","load");c.mixins.observable.constructor.call(c);if(c.autoLoad){a=c.autoLoad;if(a===true){a={}}c.load(a)}},setTarget:function(b){var a=this;b=Ext.get(b);if(a.target&&a.target!=b){a.abort()}a.target=b},getTarget:function(){return this.target||null},abort:function(){var a=this.active;if(a!==undefined){Ext.Ajax.abort(a.request);if(a.mask){this.removeMask()}delete this.active}},removeMask:function(){this.target.unmask()},addMask:function(a){this.target.mask(a===true?null:a)},load:function(h){h=Ext.apply({},h);var e=this,d=e.target,i=Ext.isDefined(h.loadMask)?h.loadMask:e.loadMask,b=Ext.apply({},h.params),a=Ext.apply({},h.ajaxOptions),f=h.callback||e.callback,g=h.scope||e.scope||e,c;Ext.applyIf(a,e.ajaxOptions);Ext.applyIf(h,a);Ext.applyIf(b,e.params);Ext.apply(b,e.baseParams);Ext.applyIf(h,{url:e.url});Ext.apply(h,{scope:e,params:b,callback:e.onComplete});if(e.fireEvent("beforeload",e,h)===false){return}if(i){e.addMask(i)}c=Ext.Ajax.request(h);e.active={request:c,options:h,mask:i,scope:g,callback:f,success:h.success||e.success,failure:h.failure||e.failure,renderer:h.renderer||e.renderer,scripts:Ext.isDefined(h.scripts)?h.scripts:e.scripts};e.setOptions(e.active,h)},setOptions:Ext.emptyFn,onComplete:function(b,g,a){var d=this,f=d.active,c=f.scope,e=d.getRenderer(f.renderer);if(g){g=e.call(d,d,a,f)!==false}if(g){Ext.callback(f.success,c,[d,a,b]);d.fireEvent("load",d,a,b)}else{Ext.callback(f.failure,c,[d,a,b]);d.fireEvent("exception",d,a,b)}Ext.callback(f.callback,c,[d,g,a,b]);if(f.mask){d.removeMask()}delete d.active},getRenderer:function(a){if(Ext.isFunction(a)){return a}return this.statics().Renderer.Html},startAutoRefresh:function(a,b){var c=this;c.stopAutoRefresh();c.autoRefresh=setInterval(function(){c.load(b)},a)},stopAutoRefresh:function(){clearInterval(this.autoRefresh);delete this.autoRefresh},isAutoRefreshing:function(){return Ext.isDefined(this.autoRefresh)},destroy:function(){var a=this;a.stopAutoRefresh();delete a.target;a.abort();a.clearListeners()}});Ext.define("Ext.resizer.Splitter",{extend:"Ext.Component",requires:["Ext.XTemplate"],uses:["Ext.resizer.SplitterTracker"],alias:"widget.splitter",childEls:["collapseEl"],renderTpl:['<tpl if="collapsible===true">','<div id="{id}-collapseEl" class="',Ext.baseCSSPrefix,"collapse-el ",Ext.baseCSSPrefix,'layout-split-{collapseDir}">&#160;</div>',"</tpl>"],baseCls:Ext.baseCSSPrefix+"splitter",collapsedClsInternal:Ext.baseCSSPrefix+"splitter-collapsed",canResize:true,collapsible:false,collapseOnDblClick:true,defaultSplitMin:40,defaultSplitMax:1000,collapseTarget:"next",horizontal:false,vertical:false,getTrackerConfig:function(){return{xclass:"Ext.resizer.SplitterTracker",el:this.el,splitter:this}},beforeRender:function(){var d=this,e=d.getCollapseTarget(),f=d.getCollapseDirection(),c=d.vertical,b=c?"width":"height",g=c?"height":"width",a;d.callParent();if(!d.hasOwnProperty(g)){d[g]="100%"}if(!d.hasOwnProperty(b)){d[b]=5}if(e.collapsed){d.addCls(d.collapsedClsInternal)}a=d.baseCls+"-"+d.orientation;d.addCls(a);if(!d.canResize){d.addCls(a+"-noresize")}Ext.applyIf(d.renderData,{collapseDir:f,collapsible:d.collapsible||e.collapsible})},onRender:function(){var a=this;a.callParent(arguments);if(a.performCollapse!==false){if(a.renderData.collapsible){a.mon(a.collapseEl,"click",a.toggleTargetCmp,a)}if(a.collapseOnDblClick){a.mon(a.el,"dblclick",a.toggleTargetCmp,a)}}a.mon(a.getCollapseTarget(),{collapse:a.onTargetCollapse,expand:a.onTargetExpand,scope:a});a.el.unselectable();if(a.canResize){a.tracker=Ext.create(a.getTrackerConfig());a.relayEvents(a.tracker,["beforedragstart","dragstart","dragend"])}},getCollapseDirection:function(){var f=this,c=f.collapseDirection,e,a,b,d;if(!c){e=f.collapseTarget;if(e.isComponent){c=e.collapseDirection}if(!c){d=f.ownerCt.layout.type;if(e.isComponent){b=f.ownerCt.items;a=Number(b.indexOf(e)==b.indexOf(f)-1)<<1|Number(d=="hbox")}else{a=Number(f.collapseTarget=="prev")<<1|Number(d=="hbox")}c=["bottom","right","top","left"][a]}f.collapseDirection=c}f.orientation=(c=="top"||c=="bottom")?"horizontal":"vertical";f[f.orientation]=true;return c},getCollapseTarget:function(){var a=this;return a.collapseTarget.isComponent?a.collapseTarget:a.collapseTarget=="prev"?a.previousSibling():a.nextSibling()},onTargetCollapse:function(a){this.el.addCls([this.collapsedClsInternal,this.collapsedCls])},onTargetExpand:function(a){this.el.removeCls([this.collapsedClsInternal,this.collapsedCls])},toggleTargetCmp:function(d,b){var c=this.getCollapseTarget(),f=c.placeholder,a;if(f&&!f.hidden){a=true}else{a=!c.hidden}if(a){if(c.collapsed){c.expand()}else{if(c.collapseDirection){c.collapse()}else{c.collapse(this.renderData.collapseDir)}}}},setSize:function(){var a=this;a.callParent(arguments);if(Ext.isIE&&a.el){a.el.repaint()}},beforeDestroy:function(){Ext.destroy(this.tracker);this.callParent()}});Ext.define("Ext.toolbar.TextItem",{extend:"Ext.toolbar.Item",requires:["Ext.XTemplate"],alias:"widget.tbtext",alternateClassName:"Ext.Toolbar.TextItem",text:"",renderTpl:"{text}",baseCls:Ext.baseCSSPrefix+"toolbar-text",beforeRender:function(){var a=this;a.callParent();Ext.apply(a.renderData,{text:a.text})},setText:function(b){var a=this;if(a.rendered){a.el.update(b);a.updateLayout()}else{this.text=b}}});Ext.define("Ext.form.CheckboxManager",{extend:"Ext.util.MixedCollection",singleton:true,getByName:function(a){return this.filterBy(function(b){return b.name==a})},getWithValue:function(a,b){return this.filterBy(function(c){return c.name==a&&c.inputValue==b})},getChecked:function(a){return this.filterBy(function(b){return b.name==a&&b.checked})}});Ext.define("Ext.resizer.BorderSplitter",{extend:"Ext.resizer.Splitter",uses:["Ext.resizer.BorderSplitterTracker"],alias:"widget.bordersplitter",collapseTarget:null,getTrackerConfig:function(){var a=this.callParent();a.xclass="Ext.resizer.BorderSplitterTracker";return a}});Ext.define("Ext.grid.LockingView",{mixins:{observable:"Ext.util.Observable"},eventRelayRe:/^(beforeitem|beforecontainer|item|container|cell)/,constructor:function(c){var f=this,h=[],a=f.eventRelayRe,b=c.locked.getView(),g=c.normal.getView(),d,e;Ext.apply(f,{lockedView:b,normalView:g,lockedGrid:c.locked,normalGrid:c.normal,panel:c.panel});f.mixins.observable.constructor.call(f,c);d=b.events;for(e in d){if(d.hasOwnProperty(e)&&a.test(e)){h.push(e)}}f.relayEvents(b,h);f.relayEvents(g,h);g.on({scope:f,itemmouseleave:f.onItemMouseLeave,itemmouseenter:f.onItemMouseEnter});b.on({scope:f,itemmouseleave:f.onItemMouseLeave,itemmouseenter:f.onItemMouseEnter})},getGridColumns:function(){var a=this.lockedGrid.headerCt.getGridColumns();return a.concat(this.normalGrid.headerCt.getGridColumns())},getEl:function(a){return this.getViewForColumn(a).getEl()},getViewForColumn:function(b){var a=this.lockedView,c;a.headerCt.cascade(function(d){if(d===b){c=true;return false}});return c?a:this.normalView},onItemMouseEnter:function(c,b){var f=this,d=f.lockedView,a=f.normalView,e;if(c.trackOver){if(c!==d){a=d}e=a.getNode(b);a.highlightItem(e)}},onItemMouseLeave:function(c,b){var e=this,d=e.lockedView,a=e.normalView;if(c.trackOver){if(c!==d){a=d}a.clearHighlight()}},relayFn:function(c,b){b=b||[];var a=this.lockedView;a[c].apply(a,b||[]);a=this.normalView;a[c].apply(a,b||[])},getSelectionModel:function(){return this.panel.getSelectionModel()},getStore:function(){return this.panel.store},getNode:function(a){return this.normalView.getNode(a)},getCell:function(b,c){var a=this.getViewForColumn(c),d;d=a.getNode(b);return Ext.fly(d).down(c.getCellSelector())},getRecord:function(b){var a=this.lockedView.getRecord(b);if(!b){a=this.normalView.getRecord(b)}return a},addElListener:function(a,c,b){this.relayFn("addElListener",arguments)},refreshNode:function(){this.relayFn("refreshNode",arguments)},refresh:function(){this.relayFn("refresh",arguments)},bindStore:function(){this.relayFn("bindStore",arguments)},addRowCls:function(){this.relayFn("addRowCls",arguments)},removeRowCls:function(){this.relayFn("removeRowCls",arguments)}});Ext.define("Ext.layout.ClassList",(function(){var b=Ext.String.splitWords,a=Ext.Array.toMap;return{dirty:false,constructor:function(c){this.owner=c;this.map=a(this.classes=b(c.el.className))},add:function(c){var d=this;if(!d.map[c]){d.map[c]=true;d.classes.push(c);if(!d.dirty){d.dirty=true;d.owner.markDirty()}}},addMany:function(c){Ext.each(b(c),this.add,this)},contains:function(c){return this.map[c]},flush:function(){this.owner.el.className=this.classes.join(" ");this.dirty=false},remove:function(c){var d=this;if(d.map[c]){delete d.map[c];d.classes=Ext.Array.filter(d.classes,function(e){return e!=c});if(!d.dirty){d.dirty=true;d.owner.markDirty()}}},removeMany:function(d){var e=this,c=a(b(d));e.classes=Ext.Array.filter(e.classes,function(f){if(!c[f]){return true}delete e.map[f];if(!e.dirty){e.dirty=true;e.owner.markDirty()}return false})}}}()));Ext.define("Ext.FocusManager",{singleton:true,alternateClassName:["Ext.FocusMgr"],mixins:{observable:"Ext.util.Observable"},requires:["Ext.AbstractComponent","Ext.Component","Ext.ComponentManager","Ext.ComponentQuery","Ext.util.HashMap","Ext.util.KeyNav"],enabled:false,focusElementCls:Ext.baseCSSPrefix+"focus-element",focusFrameCls:Ext.baseCSSPrefix+"focus-frame",whitelist:["textfield"],constructor:function(a){var b=this,c=Ext.ComponentQuery;b.mixins.observable.constructor.call(b,a);b.addEvents("beforecomponentfocus","componentfocus","disable","enable");b.focusTask=new Ext.util.DelayedTask(b.handleComponentFocus,b);Ext.override(Ext.AbstractComponent,{onFocus:function(){this.callParent(arguments);if(b.enabled&&this.hasFocus){Array.prototype.unshift.call(arguments,this);b.onComponentFocus.apply(b,arguments)}},onBlur:function(){this.callParent(arguments);if(b.enabled&&!this.hasFocus){Array.prototype.unshift.call(arguments,this);b.onComponentBlur.apply(b,arguments)}},onDestroy:function(){this.callParent(arguments);if(b.enabled){Array.prototype.unshift.call(arguments,this);b.onComponentDestroy.apply(b,arguments)}}});Ext.override(Ext.Component,{afterHide:function(){this.callParent(arguments);if(b.enabled){Array.prototype.unshift.call(arguments,this);b.onComponentHide.apply(b,arguments)}}});b.keyNav=new Ext.util.KeyNav(Ext.getDoc(),{disabled:true,scope:b,backspace:b.focusLast,enter:b.navigateIn,esc:b.navigateOut,tab:b.navigateSiblings,space:b.navigateIn,del:b.focusLast,left:b.navigateSiblings,right:b.navigateSiblings,down:b.navigateSiblings,up:b.navigateSiblings});b.focusData={};b.subscribers=new Ext.util.HashMap();b.focusChain={};Ext.apply(c.pseudos,{focusable:function(e){var d=e.length,g=[],f=0,h;for(;f<d;f++){h=e[f];if(h.isFocusable()){g.push(h)}}return g},nextFocus:function(f,e,h){h=h||1;e=parseInt(e,10);var d=f.length,g=e,j;for(;;){if((g+=h)>=d){g=0}else{if(g<0){g=d-1}}if(g===e){return[]}if((j=f[g]).isFocusable()){return[j]}}return[]},prevFocus:function(e,d){return this.nextFocus(e,d,-1)},root:function(e){var d=e.length,g=[],f=0,h;for(;f<d;f++){h=e[f];if(!h.ownerCt){g.push(h)}}return g}})},addXTypeToWhitelist:function(b){var a=this;if(Ext.isArray(b)){Ext.Array.forEach(b,a.addXTypeToWhitelist,a);return}if(!Ext.Array.contains(a.whitelist,b)){a.whitelist.push(b)}},clearComponent:function(a){clearTimeout(this.cmpFocusDelay);if(!a.isDestroyed){a.blur()}},disable:function(){var a=this;if(!a.enabled){return}delete a.options;a.enabled=false;a.removeDOM();a.keyNav.disable();a.fireEvent("disable",a)},enable:function(a){var b=this;if(a===true){a={focusFrame:true}}b.options=a=a||{};if(b.enabled){return}b.enabled=true;b.initDOM(a);b.keyNav.enable();b.focusEl.focus();delete b.focusedCmp;b.fireEvent("enable",b)},focusLast:function(b){var a=this;if(a.isWhitelisted(a.focusedCmp)){return true}if(a.previousFocusedCmp){a.previousFocusedCmp.focus()}},getRootComponents:function(){var a=this,c=Ext.ComponentQuery,b=c.query(":focusable:root:not([floating])"),d=c.query(":focusable:root[floating]");d.sort(function(f,e){return f.el.getZIndex()>e.el.getZIndex()});return d.concat(b)},initDOM:function(c){var f=this,b=f.focusFrameCls,e=Ext.ComponentQuery.query("{getFocusEl()}:not([focusListenerAdded])"),d=0,a=e.length;if(!Ext.isReady){return Ext.onReady(f.initDOM,f)}for(;d<a;d++){e[d].addFocusListener()}if(!f.focusEl){f.focusEl=Ext.getBody();f.focusEl.dom.tabIndex=-1}if(!f.focusFrame&&c.focusFrame){f.focusFrame=Ext.getBody().createChild({cls:b,children:[{cls:b+"-top"},{cls:b+"-bottom"},{cls:b+"-left"},{cls:b+"-right"}],style:"top: -100px; left: -100px;"});f.focusFrame.setVisibilityMode(Ext.Element.DISPLAY);f.focusFrame.hide().setLeftTop(0,0)}},isWhitelisted:function(a){return a&&Ext.Array.some(this.whitelist,function(b){return a.isXType(b)})},navigateIn:function(f){var c=this,a=c.focusedCmp,b,d;if(c.isWhitelisted(a)){return true}if(!a){b=c.getRootComponents()[0];if(b){if(b.getFocusEl()===c.focusEl){c.focusEl.blur()}b.focus()}}else{d=a.hasFocus?Ext.ComponentQuery.query(">:focusable",a)[0]:a;if(d){d.focus()}else{if(Ext.isFunction(a.onClick)){f.button=0;a.onClick(f);if(a.isVisible(true)){a.focus()}else{c.navigateOut()}}}}},navigateOut:function(c){var b=this,a;if(!b.focusedCmp||!(a=b.focusedCmp.up(":focusable"))){b.focusEl.focus()}else{a.focus()}return true},navigateSiblings:function(h,b,n){var i=this,a=b||i,o=h.getKey(),f=Ext.EventObject,j=h.shiftKey||o==f.LEFT||o==f.UP,c=o==f.LEFT||o==f.RIGHT||o==f.UP||o==f.DOWN,g=j?"prev":"next",m,d,l,k;l=(a.focusedCmp&&a.focusedCmp.comp)||a.focusedCmp;if(!l&&!n){return true}if(c&&i.isWhitelisted(l)){return true}if(!l||l.is(":root")){k=i.getRootComponents()}else{n=n||l.up();if(n){k=n.getRefItems()}}if(k){m=l?Ext.Array.indexOf(k,l):-1;d=Ext.ComponentQuery.query(":"+g+"Focus("+m+")",k)[0];if(d&&l!==d){d.focus();return d}}},onComponentBlur:function(b,c){var a=this;if(a.focusedCmp===b){a.previousFocusedCmp=b;delete a.focusedCmp}if(a.focusFrame){a.focusFrame.hide()}},onComponentFocus:function(d,f){var c=this,a=c.focusChain,b;if(!d.isFocusable()){c.clearComponent(d);if(a[d.id]){return}b=d.up();if(b){a[d.id]=true;b.focus()}return}c.focusChain={};c.focusTask.delay(10,null,null,[d,d.getFocusEl()])},handleComponentFocus:function(l,h){var j=this,o,a,d,g,n,b,k,e,f,c,m,i;if(j.fireEvent("beforecomponentfocus",j,l,j.previousFocusedCmp)===false){j.clearComponent(l);return}j.focusedCmp=l;if(j.shouldShowFocusFrame(l)){o="."+j.focusFrameCls+"-";a=j.focusFrame;g=h.getPageBox();n=g.top;b=g.left;k=g.width;e=g.height;f=a.child(o+"top");c=a.child(o+"bottom");m=a.child(o+"left");i=a.child(o+"right");f.setWidth(k).setLeftTop(b,n);c.setWidth(k).setLeftTop(b,n+e-2);m.setHeight(e-2).setLeftTop(b,n+2);i.setHeight(e-2).setLeftTop(b+k-2,n+2);a.show()}j.fireEvent("componentfocus",j,l,j.previousFocusedCmp)},onComponentHide:function(e){var d=this,b=false,a=d.focusedCmp,c;if(a){b=e.hasFocus||(e.isContainer&&e.isAncestor(d.focusedCmp))}d.clearComponent(e);if(b&&(c=e.up(":focusable"))){c.focus()}else{d.focusEl.focus()}},onComponentDestroy:function(){},removeDOM:function(){var a=this;if(a.enabled||a.subscribers.length){return}Ext.destroy(a.focusFrame);delete a.focusEl;delete a.focusFrame},removeXTypeFromWhitelist:function(b){var a=this;if(Ext.isArray(b)){Ext.Array.forEach(b,a.removeXTypeFromWhitelist,a);return}Ext.Array.remove(a.whitelist,b)},setupSubscriberKeys:function(a,f){var e=this,d=a.getFocusEl(),c=f.scope,b={backspace:e.focusLast,enter:e.navigateIn,esc:e.navigateOut,scope:e},g=function(h){if(e.focusedCmp===a){return e.navigateSiblings(h,e,a)}else{return e.navigateSiblings(h)}};Ext.iterate(f,function(i,h){b[i]=function(k){var j=g(k);if(Ext.isFunction(h)&&h.call(c||a,k,j)===true){return true}return j}},e);return new Ext.util.KeyNav(d,b)},shouldShowFocusFrame:function(c){var b=this,a=b.options||{},e=c.getFocusEl(),d=Ext.getDom(e).tagName;if(!b.focusFrame||!c){return false}if(a.focusFrame){return true}if(b.focusData[c.id].focusFrame){return true}return false}});Ext.define("Ext.draw.SpriteDD",{extend:"Ext.dd.DragSource",constructor:function(b,a){var d=this,c=b.el;d.sprite=b;d.el=c;d.dragData={el:c,sprite:b};d.callParent([c,a]);d.sprite.setStyle("cursor","move")},showFrame:Ext.emptyFn,createFrame:Ext.emptyFn,getDragEl:function(a){return this.el},getRegion:function(){var i=this,f=i.el,k,d,c,n,m,q,a,j,g,p,o;o=i.sprite;p=o.getBBox();try{k=Ext.Element.getXY(f)}catch(h){}if(!k){return null}d=k[0];c=d+p.width;n=k[1];m=n+p.height;return new Ext.util.Region(n,c,m,d)},startDrag:function(b,d){var c=this,a=c.sprite.attr;c.prev=c.sprite.surface.transformToViewBox(b,d)},onDrag:function(h){var g=h.getXY(),f=this,d=f.sprite,a=d.attr,c,b;g=f.sprite.surface.transformToViewBox(g[0],g[1]);c=g[0]-f.prev[0];b=g[1]-f.prev[1];d.setAttributes({translate:{x:a.translation.x+c,y:a.translation.y+b}},true);f.prev=g},setDragElPos:function(){return false}});Ext.define("Ext.ComponentLoader",{extend:"Ext.ElementLoader",statics:{Renderer:{Data:function(a,b,d){var f=true;try{a.getTarget().update(Ext.decode(b.responseText))}catch(c){f=false}return f},Component:function(a,c,g){var h=true,f=a.getTarget(),b=[];try{b=Ext.decode(c.responseText)}catch(d){h=false}if(h){f.suspendLayouts();if(g.removeAll){f.removeAll()}f.add(b);f.resumeLayouts(true)}return h}}},target:null,loadMask:false,renderer:"html",setTarget:function(b){var a=this;if(Ext.isString(b)){b=Ext.getCmp(b)}if(a.target&&a.target!=b){a.abort()}a.target=b},removeMask:function(){this.target.setLoading(false)},addMask:function(a){this.target.setLoading(a)},setOptions:function(b,a){b.removeAll=Ext.isDefined(a.removeAll)?a.removeAll:this.removeAll},getRenderer:function(b){if(Ext.isFunction(b)){return b}var a=this.statics().Renderer;switch(b){case"component":return a.Component;case"data":return a.Data;default:return Ext.ElementLoader.Renderer.Html}}});Ext.define("Ext.form.field.Checkbox",{extend:"Ext.form.field.Base",alias:["widget.checkboxfield","widget.checkbox"],alternateClassName:"Ext.form.Checkbox",requires:["Ext.XTemplate","Ext.form.CheckboxManager"],componentLayout:"field",childEls:["boxLabelEl"],fieldSubTpl:["<tpl if=\"boxLabel && boxLabelAlign == 'before'\">","{beforeBoxLabelTpl}",'<label id="{cmpId}-boxLabelEl" {boxLabelAttrTpl} class="{boxLabelCls} {boxLabelCls}-{boxLabelAlign}" for="{id}">',"{beforeBoxLabelTextTpl}","{boxLabel}","{afterBoxLabelTextTpl}","</label>","{afterBoxLabelTpl}","</tpl>",'<input type="button" id="{id}" {inputAttrTpl}','<tpl if="tabIdx"> tabIndex="{tabIdx}"</tpl>','<tpl if="disabled"> disabled="disabled"</tpl>','<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',' class="{fieldCls} {typeCls}" autocomplete="off" hidefocus="true" />',"<tpl if=\"boxLabel && boxLabelAlign == 'after'\">","{beforeBoxLabelTpl}",'<label id="{cmpId}-boxLabelEl" {boxLabelAttrTpl} class="{boxLabelCls} {boxLabelCls}-{boxLabelAlign}" for="{id}">',"{beforeBoxLabelTextTpl}","{boxLabel}","{afterBoxLabelTextTpl}","</label>","{afterBoxLabelTpl}","</tpl>",{disableFormats:true,compiled:true}],subTplInsertions:["beforeBoxLabelTpl","afterBoxLabelTpl","beforeBoxLabelTextTpl","afterBoxLabelTextTpl","boxLabelAttrTpl","inputAttrTpl"],isCheckbox:true,focusCls:"form-cb-focus",fieldBodyCls:Ext.baseCSSPrefix+"form-cb-wrap",checked:false,checkedCls:Ext.baseCSSPrefix+"form-cb-checked",boxLabelCls:Ext.baseCSSPrefix+"form-cb-label",boxLabelAlign:"after",inputValue:"on",checkChangeEvents:[],inputType:"checkbox",onRe:/^on$/i,initComponent:function(){this.callParent(arguments);this.getManager().add(this)},initValue:function(){var b=this,a=!!b.checked;b.originalValue=b.lastValue=a;b.setValue(a)},getElConfig:function(){var a=this;if(a.isChecked(a.rawValue,a.inputValue)){a.addCls(a.checkedCls)}return a.callParent()},getFieldStyle:function(){return Ext.isObject(this.fieldStyle)?Ext.DomHelper.generateStyles(this.fieldStyle):this.fieldStyle||""},getSubTplData:function(){var a=this;return Ext.apply(a.callParent(),{disabled:a.readOnly||a.disabled,boxLabel:a.boxLabel,boxLabelCls:a.boxLabelCls,boxLabelAlign:a.boxLabelAlign})},initEvents:function(){var a=this;a.callParent();a.mon(a.inputEl,"click",a.onBoxClick,a)},onBoxClick:function(b){var a=this;if(!a.disabled&&!a.readOnly){this.setValue(!this.checked)}},getRawValue:function(){return this.checked},getValue:function(){return this.checked},getSubmitValue:function(){var a=this.uncheckedValue,b=Ext.isDefined(a)?a:null;return this.checked?this.inputValue:b},isChecked:function(b,a){return(b===true||b==="true"||b==="1"||b===1||(((Ext.isString(b)||Ext.isNumber(b))&&a)?b==a:this.onRe.test(b)))},setRawValue:function(c){var b=this,d=b.inputEl,a=b.isChecked(c,b.inputValue);if(d){b[a?"addCls":"removeCls"](b.checkedCls)}b.checked=b.rawValue=a;return a},setValue:function(f){var e=this,c,b,a,d;if(Ext.isArray(f)){c=e.getManager().getByName(e.name,e.getFormId()).items;a=c.length;for(b=0;b<a;++b){d=c[b];d.setValue(Ext.Array.contains(f,d.inputValue))}}else{e.callParent(arguments)}return e},valueToRaw:function(a){return a},onChange:function(b,a){var d=this,c=d.handler;if(c){c.call(d.scope||d,d,b)}d.callParent(arguments)},resetOriginalValue:function(b){var f=this,d,e,a,c;if(!b){d=f.getManager().getByName(f.name,f.getFormId()).items;a=d.length;for(c=0;c<a;++c){e=d[c];if(e!==f){d[c].resetOriginalValue(true)}}}f.callParent()},beforeDestroy:function(){this.callParent();this.getManager().removeAtKey(this.id)},getManager:function(){return Ext.form.CheckboxManager},onEnable:function(){var a=this,b=a.inputEl;a.callParent();if(b){b.dom.disabled=a.readOnly}},setReadOnly:function(c){var a=this,b=a.inputEl;if(b){b.dom.disabled=!!c||a.disabled}a.callParent(arguments)},getFormId:function(){var b=this,a;if(!b.formId){a=b.up("form");if(a){b.formId=a.id}}return b.formId}});Ext.define("Ext.layout.container.Border",{alias:"layout.border",extend:"Ext.layout.container.Container",requires:["Ext.resizer.BorderSplitter","Ext.Component","Ext.fx.Anim"],alternateClassName:"Ext.layout.BorderLayout",targetCls:Ext.baseCSSPrefix+"border-layout-ct",itemCls:[Ext.baseCSSPrefix+"border-item",Ext.baseCSSPrefix+"box-item"],type:"border",padding:undefined,percentageRe:/(\d+)%/,axisProps:{horz:{borderBegin:"west",borderEnd:"east",horizontal:true,posProp:"x",sizeProp:"width",sizePropCap:"Width"},vert:{borderBegin:"north",borderEnd:"south",horizontal:false,posProp:"y",sizeProp:"height",sizePropCap:"Height"}},centerRegion:null,collapseDirections:{north:"top",south:"bottom",east:"right",west:"left"},manageMargins:true,panelCollapseAnimate:true,panelCollapseMode:"placeholder",regionWeights:{north:20,south:10,center:0,west:-10,east:-20},beginAxis:function(l,b,v){var t=this,c=t.axisProps[v],q=!c.horizontal,k=c.sizeProp,o=0,a=l.childItems,f=a.length,s,p,n,g,r,e,j,m,d,u,h;for(p=0;p<f;++p){n=a[p];r=n.target;n.layoutPos={};if(r.region){n.region=e=r.region;n.isCenter=r.isCenter;n.isHorz=r.isHorz;n.isVert=r.isVert;n.weight=r.weight||t.regionWeights[e]||0;b[r.id]=n;if(r.isCenter){s=n;g=r.flex;l.centerRegion=s;continue}if(q!==n.isVert){continue}n.reverseWeighting=(e==c.borderEnd);m=r[k];d=typeof m;if(!r.collapsed){if(d=="string"&&(j=t.percentageRe.exec(m))){n.percentage=parseInt(j[1],10)}else{if(r.flex){o+=n.flex=r.flex}}}}}if(s){u=s.target;if(h=u.placeholderFor){if(!g&&q===h.collapsedVertical()){g=0;s.collapseAxis=v}}else{if(u.collapsed&&(q===u.collapsedVertical())){g=0;s.collapseAxis=v}}}if(g==null){g=1}o+=g;return Ext.apply({before:q?"top":"left",totalFlex:o},c)},beginLayout:function(d){var k=this,j=k.getLayoutItems(),e=k.padding,l=typeof e,o=false,p,n,b,g,f,a,c,h,m;if(e){if(l=="string"||l=="number"){e=Ext.util.Format.parseBox(e)}}else{e=d.getEl("getTargetEl").getPaddingInfo();o=true}d.outerPad=e;d.padOnContainer=o;for(g=0,b=j.length;g<b;++g){n=j[g];a=k.getSplitterTarget(n);if(a){h=!!n.hidden;if(!a.split){if(a.isCollapsingOrExpanding){c=!!a.collapsed}}else{if(h!==a.hidden){c=!a.hidden}}if(c===true){n.show()}else{if(c===false){n.hide()}}}}k.callParent(arguments);j=d.childItems;b=j.length;f={};d.borderAxisHorz=k.beginAxis(d,f,"horz");d.borderAxisVert=k.beginAxis(d,f,"vert");for(g=0;g<b;++g){p=j[g];a=k.getSplitterTarget(p.target);if(a){m=f[a.id];if(!m){m=d.getEl(a.el,k);m.region=a.region}p.collapseTarget=a=m;p.weight=a.weight;p.reverseWeighting=a.reverseWeighting;a.splitter=p;p.isHorz=a.isHorz;p.isVert=a.isVert}}k.sortWeightedItems(j,"reverseWeighting");k.setupSplitterNeighbors(j)},calculate:function(d){var l=this,a=l.getContainerSize(d),h=d.childItems,c=h.length,b=d.borderAxisHorz,j=d.borderAxisVert,e=d.outerPad,n=d.padOnContainer,g,p,k,o,m,f;b.begin=e.left;j.begin=e.top;m=b.end=b.flexSpace=a.width+(n?e.left:-e.right);f=j.end=j.flexSpace=a.height+(n?e.top:-e.bottom);for(g=0;g<c;++g){p=h[g];k=p.getMarginInfo();if(p.isHorz||p.isCenter){b.addUnflexed(k.width);m-=k.width}if(p.isVert||p.isCenter){j.addUnflexed(k.height);f-=k.height}if(!p.flex&&!p.percentage){if(p.isHorz||(p.isCenter&&p.collapseAxis==="horz")){o=p.getProp("width");b.addUnflexed(o);if(p.collapseTarget){m-=o}}else{if(p.isVert||(p.isCenter&&p.collapseAxis==="vert")){o=p.getProp("height");j.addUnflexed(o);if(p.collapseTarget){f-=o}}}}}for(g=0;g<c;++g){p=h[g];k=p.getMarginInfo();if(p.percentage){if(p.isHorz){o=Math.ceil(m*p.percentage/100);o=p.setWidth(o);b.addUnflexed(o)}else{if(p.isVert){o=Math.ceil(f*p.percentage/100);o=p.setHeight(o);j.addUnflexed(o)}}}}for(g=0;g<c;++g){p=h[g];if(!p.isCenter){l.calculateChildAxis(p,b);l.calculateChildAxis(p,j)}}if(l.finishAxis(d,j)+l.finishAxis(d,b)<2){l.done=false}else{l.finishPositions(h)}},calculateChildAxis:function(k,c){var a=k.collapseTarget,g="set"+c.sizePropCap,e=c.sizeProp,d=k.getMarginInfo()[e],i,b,f,h,j;if(a){i=a.region}else{i=k.region;f=k.flex}b=i==c.borderBegin;if(!b&&i!=c.borderEnd){k[g](c.end-c.begin-d);h=c.begin}else{if(f){j=Math.ceil(c.flexSpace*(f/c.totalFlex));j=k[g](j)}else{if(k.percentage){j=k.peek(e)}else{j=k.getProp(e)}}j+=d;if(b){h=c.begin;c.begin+=j}else{c.end=h=c.end-j}}k.layoutPos[c.posProp]=h},finishAxis:function(d,c){var b=c.end-c.begin,a=d.centerRegion;if(a){a["set"+c.sizePropCap](b-a.getMarginInfo()[c.sizeProp]);a.layoutPos[c.posProp]=c.begin}return Ext.isNumber(b)?1:0},finishPositions:function(d){var c=d.length,b,a;for(b=0;b<c;++b){a=d[b];a.setProp("x",a.layoutPos.x+a.marginInfo.left);a.setProp("y",a.layoutPos.y+a.marginInfo.top)}},getPlaceholder:function(a){return a.getPlaceholder&&a.getPlaceholder()},getSplitterTarget:function(b){var a=b.collapseTarget;if(a&&a.collapsed){return a.placeholder||a}return a},isItemBoxParent:function(a){return true},isItemShrinkWrap:function(a){return true},insertSplitter:function(c,b,e){var f=c.region,d={xtype:"bordersplitter",collapseTarget:c,id:c.id+"-splitter",hidden:e,canResize:c.splitterResize!==false},a=b+((f=="south"||f=="east")?0:1);if(c.isHorz){d.height=null}else{d.width=null}if(c.collapseMode=="mini"){d.collapsedCls=c.collapsedCls}c.splitter=this.owner.add(a,d)},onAdd:function(d,a){var c=this,g=d.placeholderFor,f=d.region,b,e;c.callParent(arguments);if(f){Ext.apply(d,c.regionFlags[f]);if(f=="center"){c.centerRegion=d}else{d.collapseDirection=this.collapseDirections[f];b=d.split;e=!!d.hidden;if((d.isHorz||d.isVert)&&(b||d.collapseMode=="mini")){c.insertSplitter(d,a,e||!b)}}if(!d.hasOwnProperty("collapseMode")){d.collapseMode=c.panelCollapseMode}if(!d.hasOwnProperty("animCollapse")){if(d.collapseMode!="placeholder"){d.animCollapse=false}else{d.animCollapse=c.panelCollapseAnimate}}}else{if(g){Ext.apply(d,c.regionFlags[g.region]);d.region=g.region;d.weight=g.weight}}},onDestroy:function(){this.centerRegion=null;this.callParent()},onRemove:function(b){var a=this,d=b.region,c=b.splitter;if(d){if(b.isCenter){a.centerRegion=null}delete b.isCenter;delete b.isHorz;delete b.isVert;if(c){a.owner.doRemove(c,true);delete b.splitter}}a.callParent(arguments)},regionFlags:{center:{isCenter:true,isHorz:false,isVert:false},north:{isCenter:false,isHorz:false,isVert:true},south:{isCenter:false,isHorz:false,isVert:true},west:{isCenter:false,isHorz:true,isVert:false},east:{isCenter:false,isHorz:true,isVert:false}},setupSplitterNeighbors:function(l){var o={},e=l.length,n=this.touchedRegions,g,f,a,k,d,h,m,b,c;for(g=0;g<e;++g){h=l[g].target;m=h.region;if(h.isCenter){a=h}else{if(m){c=n[m];for(f=0,k=c.length;f<k;++f){d=o[c[f]];if(d){d.neighbors.push(h)}}if(h.placeholderFor){b=h.placeholderFor.splitter}else{b=h.splitter}if(b){b.neighbors=[]}o[m]=b}}}if(a){c=n.center;for(f=0,k=c.length;f<k;++f){d=o[c[f]];if(d){d.neighbors.push(a)}}}},touchedRegions:{center:["north","south","east","west"],north:["north","east","west"],south:["south","east","west"],east:["east","north","south"],west:["west","north","south"]},sizePolicies:{vert:{setsWidth:1,setsHeight:0},horz:{setsWidth:0,setsHeight:1},flexAll:{setsWidth:1,setsHeight:1}},getItemSizePolicy:function(e){var d=this,a=this.sizePolicies,c,b,f,g;if(e.isCenter){g=e.placeholderFor;if(g){if(g.collapsedVertical()){return a.vert}return a.horz}if(e.collapsed){if(e.collapsedVertical()){return a.vert}return a.horz}return a.flexAll}c=e.collapseTarget;if(c){return c.isVert?a.vert:a.horz}if(e.region){if(e.isVert){b=e.height;f=a.vert}else{b=e.width;f=a.horz}if(e.flex||(typeof b=="string"&&d.percentageRe.test(b))){return a.flexAll}return f}return d.autoSizePolicy}},function(){var a={addUnflexed:function(c){this.flexSpace=Math.max(this.flexSpace-c,0)}},b=this.prototype.axisProps;Ext.apply(b.horz,a);Ext.apply(b.vert,a)});Ext.define("Ext.grid.Lockable",{requires:["Ext.grid.LockingView","Ext.view.Table"],syncRowHeight:true,headerCounter:0,scrollDelta:40,unlockText:"Unlock",lockText:"Lock",determineXTypeToCreate:function(){var c=this,f,d,b,e,a;if(c.subGridXType){f=c.subGridXType}else{d=this.getXTypes().split("/");b=d.length;e=d[b-1];a=d[b-2];if(a!=="tablepanel"){f=a}else{f=e}}return f},injectLockable:function(){this.lockable=true;this.hasView=true;var s=this,b=Ext.getScrollbarSize().width===0,d=s.store=Ext.StoreManager.lookup(s.store),c=s.determineXTypeToCreate(),h=s.getSelectionModel(),k,o,p,n,r,g,l,m,a,e,q,f,t,j;k=s.constructFeatures();s.cloneFeatures();o=s.constructFeatures();p=s.constructPlugins();s.clonePlugins();n=s.constructPlugins();delete s.features;delete s.plugins;for(l=0,m=(k?k.length:0);l<m;l++){k[l].lockingPartner=o[l];o[l].lockingPartner=k[l]}r=Ext.apply({xtype:c,store:d,scrollerOwner:false,enableAnimations:false,scroll:b?"vertical":false,selModel:h,border:false,cls:Ext.baseCSSPrefix+"grid-inner-locked",isLayoutRoot:function(){return false},features:k,plugins:p},s.lockedGridConfig);g=Ext.apply({xtype:c,store:d,scrollerOwner:false,enableAnimations:false,selModel:h,border:false,isLayoutRoot:function(){return false},features:o,plugins:n},s.normalGridConfig);s.addCls(Ext.baseCSSPrefix+"grid-locked");Ext.copyTo(g,s,s.bothCfgCopy);Ext.copyTo(r,s,s.bothCfgCopy);Ext.copyTo(g,s,s.normalCfgCopy);Ext.copyTo(r,s,s.lockedCfgCopy);for(l=0;l<s.normalCfgCopy.length;l++){delete s[s.normalCfgCopy[l]]}for(l=0;l<s.lockedCfgCopy.length;l++){delete s[s.lockedCfgCopy[l]]}s.addEvents("lockcolumn","unlockcolumn");s.addStateEvents(["lockcolumn","unlockcolumn"]);s.lockedHeights=[];s.normalHeights=[];a=s.processColumns(s.columns);r.width=a.lockedWidth+Ext.num(h.headerWidth,0);r.columns=a.locked;g.columns=a.normal;g.flex=1;r.viewConfig=s.lockedViewConfig||{};r.viewConfig.loadingUseMsg=false;g.viewConfig=s.normalViewConfig||{};Ext.applyIf(r.viewConfig,s.viewConfig);Ext.applyIf(g.viewConfig,s.viewConfig);s.lockedGrid=Ext.ComponentManager.create(r);f=s.lockedGrid.getView();g.viewConfig.lockingPartner=f;s.normalGrid=Ext.ComponentManager.create(g);t=s.normalGrid.getView();s.view=new Ext.grid.LockingView({locked:s.lockedGrid,normal:s.normalGrid,panel:s});j={scroll:{fn:s.onLockedViewScroll,element:"el",scope:s}};if(!b){j.mousewheel={fn:s.onLockedViewMouseWheel,element:"el",scope:s}}if(s.syncRowHeight){j.refresh=s.onLockedViewRefresh;j.itemupdate=s.onLockedViewItemUpdate;j.scope=s}f.on(j);j={scroll:{fn:s.onNormalViewScroll,element:"el",scope:s},refresh:s.syncRowHeight?s.onNormalViewRefresh:s.updateSpacer,scope:s};t.on(j);e=s.lockedGrid.headerCt;q=s.normalGrid.headerCt;e.lockedCt=true;e.lockableInjected=true;q.lockableInjected=true;e.on({columnshow:s.onLockedHeaderShow,columnhide:s.onLockedHeaderHide,columnmove:s.onLockedHeaderMove,sortchange:s.onLockedHeaderSortChange,columnresize:s.onLockedHeaderResize,scope:s});q.on({columnmove:s.onNormalHeaderMove,sortchange:s.onNormalHeaderSortChange,scope:s});s.modifyHeaderCt();s.items=[s.lockedGrid,s.normalGrid];s.relayHeaderCtEvents(e);s.relayHeaderCtEvents(q);s.layout={type:"hbox",align:"stretch"}},processColumns:function(f){var e=0,a=f.length,b=0,d=[],c=[],g;for(;e<a;++e){g=f[e];if(!g.isComponent){g=Ext.apply({},f[e])}g.processed=true;if(g.locked){if(!g.hidden){b+=g.width||Ext.grid.header.Container.prototype.defaultWidth}d.push(g)}else{c.push(g)}if(!g.headerId){g.headerId=(g.initialConfig||g).id||("L"+(++this.headerCounter))}}return{lockedWidth:b,locked:{items:d,itemId:"lockedHeaderCt",stretchMaxPartner:"^^>>#normalHeaderCt"},normal:{items:c,itemId:"normalHeaderCt",stretchMaxPartner:"^^>>#lockedHeaderCt"}}},onLockedViewMouseWheel:function(h){var d=this,g=-d.scrollDelta,a=g*h.getWheelDeltas().y,b=d.lockedGrid.getView().el.dom,c,f;if(b){c=b.scrollTop!==b.scrollHeight-b.clientHeight;f=b.scrollTop!==0}if((a<0&&f)||(a>0&&c)){h.stopEvent();d.scrolling=true;b.scrollTop+=a;d.normalGrid.getView().el.dom.scrollTop=b.scrollTop;d.scrolling=false;d.onNormalViewScroll()}},onLockedViewScroll:function(){var e=this,d=e.lockedGrid.getView(),c=e.normalGrid.getView(),a,b;if(!e.scrolling){e.scrolling=true;c.el.dom.scrollTop=d.el.dom.scrollTop;if(e.store.buffered){b=d.el.child("table",true);a=c.el.child("table",true);b.style.position="absolute"}e.scrolling=false}},onNormalViewScroll:function(){var e=this,d=e.lockedGrid.getView(),c=e.normalGrid.getView(),a,b;if(!e.scrolling){e.scrolling=true;d.el.dom.scrollTop=c.el.dom.scrollTop;if(e.store.buffered){b=d.el.child("table",true);a=c.el.child("table",true);b.style.position="absolute";b.style.top=a.style.top}e.scrolling=false}},onLockedHeaderMove:function(){if(this.syncRowHeight){this.onNormalViewRefresh()}},onNormalHeaderMove:function(){if(this.syncRowHeight){this.onLockedViewRefresh()}},updateSpacer:function(){var d=this,b=d.lockedGrid.getView().el,c=d.normalGrid.getView().el.dom,a=b.dom.id+"-spacer",e=(c.offsetHeight-c.clientHeight)+"px";d.spacerEl=Ext.getDom(a);if(d.spacerEl){d.spacerEl.style.height=e}else{Ext.core.DomHelper.append(b,{id:a,style:"height: "+e})}},onLockedViewRefresh:function(){if(this.normalGrid.headerCt.getGridColumns().length){var e=this,a=e.lockedGrid.getView(),c=a.el,f=c.query(a.getItemSelector()),d=f.length,b=0;e.lockedHeights=[];for(;b<d;b++){e.lockedHeights[b]=f[b].offsetHeight}e.syncRowHeights();e.updateSpacer()}},onNormalViewRefresh:function(){if(this.lockedGrid.headerCt.getGridColumns().length){var e=this,a=e.normalGrid.getView(),c=a.el,f=c.query(a.getItemSelector()),d=f.length,b=0;e.normalHeights=[];for(;b<d;b++){e.normalHeights[b]=f[b].offsetHeight}e.syncRowHeights();e.updateSpacer()}},onLockedViewItemUpdate:function(a,b,c){if(this.normalGrid.headerCt.getGridColumns().length){this.lockedHeights[b]=c.offsetHeight;this.syncRowHeights()}},onNormalViewItemUpdate:function(a,b,c){if(this.lockedGrid.headerCt.getGridColumns().length){this.normalHeights[b]=c.offsetHeight;this.syncRowHeights()}},syncRowHeights:function(){var h=this,a=h.lockedHeights,j=h.normalHeights,g=a.length,e=0,k,c,d,f,b;if(a.length&&j.length){k=h.lockedGrid.getView();c=h.normalGrid.getView();d=k.el.query(k.getItemSelector());f=c.el.query(c.getItemSelector());for(;e<g;e++){if(!isNaN(a[e])&&!isNaN(j[e])){if(a[e]>j[e]){Ext.fly(f[e]).setHeight(a[e])}else{if(a[e]<j[e]){Ext.fly(d[e]).setHeight(j[e])}}}}b=c.el.dom.scrollTop;c.el.dom.scrollTop=b;k.el.dom.scrollTop=b;h.lockedHeights=[];h.normalHeights=[]}},modifyHeaderCt:function(){var a=this;a.lockedGrid.headerCt.getMenuItems=a.getMenuItems(a.lockedGrid.headerCt.getMenuItems,true);a.normalGrid.headerCt.getMenuItems=a.getMenuItems(a.normalGrid.headerCt.getMenuItems,false)},onUnlockMenuClick:function(){this.unlock()},onLockMenuClick:function(){this.lock()},getMenuItems:function(f,c){var g=this,h=g.unlockText,a=g.lockText,i=Ext.baseCSSPrefix+"hmenu-unlock",b=Ext.baseCSSPrefix+"hmenu-lock",e=Ext.Function.bind(g.onUnlockMenuClick,g),d=Ext.Function.bind(g.onLockMenuClick,g);return function(){var j=f.call(this);j.push("-",{cls:i,text:h,handler:e,disabled:!c});j.push({cls:b,text:a,handler:d,disabled:c});return j}},lock:function(a,d){var c=this,e=c.normalGrid,g=c.lockedGrid,f=e.headerCt,b=g.headerCt;a=a||f.getMenu().activeHeader;if(a.flex){a.width=a.getWidth();delete a.flex}Ext.suspendLayouts();a.ownerCt.remove(a,false);a.locked=true;if(Ext.isDefined(d)){b.insert(d,a)}else{b.add(a)}c.syncLockedSection();Ext.resumeLayouts(true);c.updateSpacer();c.fireEvent("lockcolumn",c,a)},syncLockedSection:function(){var a=this;a.syncLockedWidth();a.lockedGrid.getView().refresh();a.normalGrid.getView().refresh()},syncLockedWidth:function(){var c=this,a=c.lockedGrid,b=a.headerCt.getFullWidth(true);Ext.suspendLayouts();if(b>0){a.setWidth(b);a.show()}else{a.hide()}Ext.resumeLayouts(true);return b>0},onLockedHeaderResize:function(){this.syncLockedWidth()},onLockedHeaderHide:function(){this.syncLockedWidth()},onLockedHeaderShow:function(){this.syncLockedWidth()},onLockedHeaderSortChange:function(b,c,a){if(a){this.normalGrid.headerCt.clearOtherSortStates(null,true)}},onNormalHeaderSortChange:function(b,c,a){if(a){this.lockedGrid.headerCt.clearOtherSortStates(null,true)}},unlock:function(a,e){var d=this,f=d.normalGrid,h=d.lockedGrid,g=f.headerCt,c=h.headerCt,b=false;if(!Ext.isDefined(e)){e=0}a=a||c.getMenu().activeHeader;Ext.suspendLayouts();a.ownerCt.remove(a,false);if(d.syncLockedWidth()){b=true}a.locked=false;g.insert(e,a);d.normalGrid.getView().refresh();if(b){d.lockedGrid.getView().refresh()}Ext.resumeLayouts(true);d.fireEvent("unlockcolumn",d,a)},applyColumnsState:function(g){var o=this,e=o.lockedGrid,f=e.headerCt,m=o.normalGrid.headerCt,p=Ext.Array.toMap(f.items,"headerId"),h=Ext.Array.toMap(m.items,"headerId"),l=[],n=[],k=1,b=g.length,j,a,d,c;for(j=0;j<b;j++){c=g[j];d=p[c.id];a=d||h[c.id];if(a){if(a.applyColumnState){a.applyColumnState(c)}if(a.locked===undefined){a.locked=!!d}if(a.locked){l.push(a);if(!a.hidden&&typeof a.width=="number"){k+=a.width}}else{n.push(a)}}}if(l.length+n.length==f.items.getCount()+m.items.getCount()){f.removeAll(false);m.removeAll(false);f.add(l);m.add(n);e.setWidth(k)}},getColumnsState:function(){var b=this,a=b.lockedGrid.headerCt.getColumnsState(),c=b.normalGrid.headerCt.getColumnsState();return a.concat(c)},reconfigureLockable:function(a,b){var c=this,e=c.lockedGrid,d=c.normalGrid;if(b){Ext.suspendLayouts();e.headerCt.removeAll();d.headerCt.removeAll();b=c.processColumns(b);e.setWidth(b.lockedWidth);e.headerCt.add(b.locked.items);d.headerCt.add(b.normal.items);Ext.resumeLayouts(true)}if(a){a=Ext.data.StoreManager.lookup(a);c.store=a;e.bindStore(a);d.bindStore(a)}else{e.getView().refresh();d.getView().refresh()}},cloneFeatures:function(){var e=this,d=e.features,c,b=0,a;if(d){a=d.length;for(;b<a;b++){c=d[b];if(c.isFeature){d[b]=c.clone()}}}},clonePlugins:function(){var e=this,b=e.plugins,d,c=0,a;if(b){a=b.length;for(;c<a;c++){d=b[c];if(typeof d.init==="function"){b[c]=d.clone()}}}}},function(){this.borrow(Ext.view.Table,["constructFeatures"]);this.borrow(Ext.AbstractComponent,["constructPlugins","constructPlugin"])});Ext.define("Ext.menu.CheckItem",{extend:"Ext.menu.Item",alias:"widget.menucheckitem",checkedCls:Ext.baseCSSPrefix+"menu-item-checked",uncheckedCls:Ext.baseCSSPrefix+"menu-item-unchecked",groupCls:Ext.baseCSSPrefix+"menu-group-icon",hideOnClick:false,checkChangeDisabled:false,afterRender:function(){var a=this;a.callParent();a.checked=!a.checked;a.setChecked(!a.checked,true);if(a.checkChangeDisabled){a.disableCheckChange()}},initComponent:function(){var a=this;a.addEvents("beforecheckchange","checkchange");a.callParent(arguments);Ext.menu.Manager.registerCheckable(a);if(a.group){if(!a.iconCls){a.iconCls=a.groupCls}if(a.initialConfig.hideOnClick!==false){a.hideOnClick=true}}},disableCheckChange:function(){var b=this,a=b.iconEl;if(a){a.addCls(b.disabledCls)}if(!(Ext.isIE9&&Ext.isStrict)&&b.rendered){b.el.repaint()}b.checkChangeDisabled=true},enableCheckChange:function(){var b=this,a=b.iconEl;if(a){a.removeCls(b.disabledCls)}b.checkChangeDisabled=false},onClick:function(b){var a=this;if(!a.disabled&&!a.checkChangeDisabled&&!(a.checked&&a.group)){a.setChecked(!a.checked)}this.callParent([b])},onDestroy:function(){Ext.menu.Manager.unregisterCheckable(this);this.callParent(arguments)},setChecked:function(c,a){var b=this;if(b.checked!==c&&(a||b.fireEvent("beforecheckchange",b,c)!==false)){if(b.el){b.el[c?"addCls":"removeCls"](b.checkedCls)[!c?"addCls":"removeCls"](b.uncheckedCls)}b.checked=c;Ext.menu.Manager.onCheckChange(b,c);if(!a){Ext.callback(b.checkHandler,b.scope,[b,c]);b.fireEvent("checkchange",b,c)}}}});Ext.define("Ext.menu.Separator",{extend:"Ext.menu.Item",alias:"widget.menuseparator",canActivate:false,focusable:false,hideOnClick:false,plain:true,separatorCls:Ext.baseCSSPrefix+"menu-item-separator",text:"&#160;",beforeRender:function(a,c){var b=this;b.callParent();b.addCls(b.separatorCls)}});Ext.define("Ext.layout.ContextItem",{requires:["Ext.layout.ClassList"],heightModel:null,widthModel:null,sizeModel:null,boxChildren:null,boxParent:null,children:[],dirty:null,dirtyCount:0,hasRawContent:true,isContextItem:true,isTopLevel:false,consumersContentHeight:0,consumersContentWidth:0,consumersContainerHeight:0,consumersContainerWidth:0,consumersHeight:0,consumersWidth:0,ownerCtContext:null,remainingChildLayouts:0,remainingComponentChildLayouts:0,remainingContainerChildLayouts:0,props:null,state:null,wrapsComponent:false,constructor:function(b){var f=this,e,d,a,c,g;Ext.apply(f,b);e=f.el;f.id=e.id;f.lastBox=e.lastBox;f.flushedProps={};f.props={};f.styles={};g=f.target;if(g.isComponent){f.wrapsComponent=true;d=g.ownerCt;if(d&&(a=f.context.items[d.el.id])){f.ownerCtContext=a}f.sizeModel=c=g.getSizeModel(a&&a.widthModel.pairsByHeightOrdinal[a.heightModel.ordinal]);f.widthModel=c.width;f.heightModel=c.height}},init:function(h,c){var r=this,a=r.props,d=r.dirty,k=r.ownerCtContext,o=r.target.ownerLayout,g=!r.state,s=h||g,e,m,l,p,b,t,u=r.heightModel,f=r.widthModel,j,q;r.dirty=r.invalid=false;r.props={};if(r.boxChildren){r.boxChildren.length=0}if(!g){r.clearAllBlocks("blocks");r.clearAllBlocks("domBlocks")}if(!r.wrapsComponent){return s}t=r.target;r.state={};if(g){if(t.beforeLayout){t.beforeLayout()}if(!k&&(p=t.ownerCt)){k=r.context.items[p.el.id]}if(k){r.ownerCtContext=k;r.isBoxParent=t.ownerLayout.isItemBoxParent(r)}else{r.isTopLevel=true}r.frameBodyContext=r.getEl("frameBody")}else{k=r.ownerCtContext;r.isTopLevel=!k;e=r.children;for(m=0,l=e.length;m<l;++m){e[m].init(true)}}r.hasRawContent=!(t.isContainer&&t.items.items.length>0);if(h){r.widthModel=r.heightModel=null;b=t.getSizeModel(k&&k.widthModel.pairsByHeightOrdinal[k.heightModel.ordinal]);if(g){r.sizeModel=b}r.widthModel=b.width;r.heightModel=b.height}else{if(a){r.recoverProp("x",a,d);r.recoverProp("y",a,d);if(r.widthModel.calculated){r.recoverProp("width",a,d)}if(r.heightModel.calculated){r.recoverProp("height",a,d)}}}if(a&&o&&o.manageMargins){r.recoverProp("margin-top",a,d);r.recoverProp("margin-right",a,d);r.recoverProp("margin-bottom",a,d);r.recoverProp("margin-left",a,d)}if(c){j=c.heightModel;q=c.widthModel;if(q&&j&&f&&u){if(f.shrinkWrap&&u.shrinkWrap){if(q.constrainedMax&&j.constrainedMin){j=null}}}if(q){r.widthModel=q}if(j){r.heightModel=j}if(c.state){Ext.apply(r.state,c.state)}}return s},initContinue:function(d){var e=this,c=e.ownerCtContext,b=e.widthModel,a;if(d){if(c&&b.shrinkWrap){a=c.isBoxParent?c:c.boxParent;if(a){a.addBoxChild(e)}}else{if(b.natural){e.boxParent=c}}}return d},initDone:function(b,f,a,g){var d=this,c=d.props,e=d.state;if(f){c.componentChildrenDone=true}if(a){c.containerChildrenDone=true}if(g){c.containerLayoutDone=true}if(d.boxChildren&&d.boxChildren.length&&d.widthModel.shrinkWrap){d.el.setWidth(10000);e.blocks=(e.blocks||0)+1}},initAnimation:function(){var b=this,c=b.target,a=b.ownerCtContext;if(a&&a.isTopLevel){b.animatePolicy=c.ownerLayout.getAnimatePolicy(b)}else{if(!a&&c.isCollapsingOrExpanding&&c.animCollapse){b.animatePolicy=c.componentLayout.getAnimatePolicy(b)}}if(b.animatePolicy){b.context.queueAnimation(b)}},noFraming:{left:0,top:0,right:0,bottom:0,width:0,height:0},addCls:function(a){this.getClassList().addMany(a)},removeCls:function(a){this.getClassList().removeMany(a)},addBlock:function(b,d,e){var c=this,f=c[b]||(c[b]={}),a=f[e]||(f[e]={});if(!a[d.id]){a[d.id]=d;++d.blockCount;++c.context.blockCount}},addBoxChild:function(d){var c=this,b,a=d.widthModel;d.boxParent=this;d.measuresBox=a.shrinkWrap?d.hasRawContent:a.natural;if(d.measuresBox){b=c.boxChildren;if(b){b.push(d)}else{c.boxChildren=[d]}}},addTrigger:function(f,g){var e=this,a=g?"domTriggers":"triggers",h=e[a]||(e[a]={}),b=e.context,d=b.currentLayout,c=h[f]||(h[f]={});if(!c[d.id]){c[d.id]=d;++d.triggerCount;c=b.triggers[g?"dom":"data"];(c[d.id]||(c[d.id]=[])).push({item:this,prop:f});if(e.props[f]!==undefined){if(!g||!(e.dirty&&(f in e.dirty))){++d.firedTriggers}}}},boxChildMeasured:function(){var b=this,c=b.state,a=(c.boxesMeasured=(c.boxesMeasured||0)+1);if(a==b.boxChildren.length){c.clearBoxWidth=1;++b.context.progressCount;b.markDirty()}},borderNames:["border-top-width","border-right-width","border-bottom-width","border-left-width"],marginNames:["margin-top","margin-right","margin-bottom","margin-left"],paddingNames:["padding-top","padding-right","padding-bottom","padding-left"],trblNames:["top","right","bottom","left"],cacheMissHandlers:{borderInfo:function(a){var b=a.getStyles(a.borderNames,a.trblNames);b.width=b.left+b.right;b.height=b.top+b.bottom;return b},marginInfo:function(a){var b=a.getStyles(a.marginNames,a.trblNames);b.width=b.left+b.right;b.height=b.top+b.bottom;return b},paddingInfo:function(b){var a=b.frameBodyContext||b,c=a.getStyles(b.paddingNames,b.trblNames);c.width=c.left+c.right;c.height=c.top+c.bottom;return c}},checkCache:function(a){return this.cacheMissHandlers[a](this)},clearAllBlocks:function(a){var c=this[a],b;if(c){for(b in c){this.clearBlocks(a,b)}}},clearBlocks:function(c,f){var g=this[c],b=g&&g[f],d,e,a;if(b){delete g[f];d=this.context;for(a in b){e=b[a];--d.blockCount;if(!--e.blockCount&&!e.pending&&!e.done){d.queueLayout(e)}}}},block:function(a,b){this.addBlock("blocks",a,b)},domBlock:function(a,b){this.addBlock("domBlocks",a,b)},fireTriggers:function(b,f){var g=this[b],d=g&&g[f],c=this.context,e,a;if(d){for(a in d){e=d[a];++e.firedTriggers;if(!e.done&&!e.blockCount&&!e.pending){c.queueLayout(e)}}}},flush:function(){var b=this,a=b.dirty,c=b.state,d=b.el;b.dirtyCount=0;if(b.classList&&b.classList.dirty){b.classList.flush()}if("attributes" in b){d.set(b.attributes);delete b.attributes}if("innerHTML" in b){d.innerHTML=b.innerHTML;delete b.innerHTML}if(c&&c.clearBoxWidth){c.clearBoxWidth=0;b.el.setStyle("width",null);if(!--c.blocks){b.context.queueItemLayouts(b)}}if(a){delete b.dirty;b.writeProps(a,true)}},flushAnimations:function(){var n=this,c=n.lastBox,k,m,e,g,f,d,h,l,i,a,b;if(c){k=n.target;m=k.layout&&k.layout.animate;if(m){e=Ext.isNumber(m)?m:m.duration}g=Ext.Object.getKeys(n.animatePolicy);f=Ext.apply({},{from:{},to:{},duration:e||Ext.fx.Anim.prototype.duration},m);for(d=0,h=0,l=g.length;h<l;h++){i=g[h];a=c[i];b=n.peek(i);if(a!=b){i=n.translateProps[i]||i;f.from[i]=a;f.to[i]=b;++d}}if(d){if(n.isCollapsingOrExpanding===1){k.componentLayout.undoLayout(n)}else{n.writeProps(f.from)}n.el.animate(f);Ext.fx.Manager.getFxQueue(n.el.id)[0].on({afteranimate:function(){if(n.isCollapsingOrExpanding===1){k.componentLayout.redoLayout(n);k.afterCollapse(true)}else{if(n.isCollapsingOrExpanding===2){k.afterExpand(true)}}}})}}},getBorderInfo:function(){var a=this,b=a.borderInfo;if(!b){a.borderInfo=b=a.checkCache("borderInfo")}return b},getClassList:function(){return this.classList||(this.classList=new Ext.layout.ClassList(this))},getEl:function(c,a){var e=this,f,d,b;if(c){if(c.dom){d=c}else{f=e.target;if(a){f=a}d=f[c];if(typeof d=="function"){d=d.call(f);if(d===e.el){return this}}}if(d){b=e.context.getEl(e,d)}}return b||null},getFraming:function(){var a=this;if(!a.framingInfo){a.framingInfo=a.target.frameSize||a.noFraming}return a.framingInfo},getFrameInfo:function(){var b=this,c=b.frameInfo,d,a;if(!c){d=b.getFraming();a=b.getBorderInfo();b.frameInfo=c={top:d.top+a.top,right:d.right+a.right,bottom:d.bottom+a.bottom,left:d.left+a.left,width:d.width+a.width,height:d.height+a.height}}return c},getMarginInfo:function(){var d=this,g=d.marginInfo,b,a,f,e,c;if(!g){if(!d.wrapsComponent){g=d.checkCache("marginInfo")}else{b=d.target;e=b.ownerLayout;c=e?e.id:null;a=e&&e.manageMargins;g=b.margin$;if(g&&g.ownerId!==c){g=null}if(!g){g=d.parseMargins(b.margin)||d.checkCache("marginInfo");if(a){f=d.parseMargins(b.margins,e.defaultMargins);if(f){g={top:g.top+f.top,right:g.right+f.right,bottom:g.bottom+f.bottom,left:g.left+f.left}}d.setProp("margin-top",0);d.setProp("margin-right",0);d.setProp("margin-bottom",0);d.setProp("margin-left",0)}g.ownerId=c;b.margin$=g}g.width=g.left+g.right;g.height=g.top+g.bottom}d.marginInfo=g}return g},clearMarginCache:function(){delete this.marginInfo;delete this.target.margin$},getPaddingInfo:function(){var a=this,b=a.paddingInfo;if(!b){a.paddingInfo=b=a.checkCache("paddingInfo")}return b},getProp:function(c){var b=this,a=b.props[c];b.addTrigger(c);return a},getDomProp:function(c){var b=this,a=(b.dirty&&(c in b.dirty))?undefined:b.props[c];b.addTrigger(c,true);return a},getStyle:function(a){var c=this,b=c.styles,e,d;if(a in b){d=b[a]}else{e=c.styleInfo[a];d=c.el.getStyle(a);if(e&&e.parseInt){d=parseInt(d,10)||0}b[a]=d}return d},getStyles:function(o,b){var l=this,e=l.styles,p={},f=0,d=o.length,j,h,k,a,c,g,q,m;b=b||o;for(j=0;j<d;++j){a=o[j];if(a in e){p[b[j]]=e[a];++f;if(j&&f==1){h=o.slice(0,j);k=b.slice(0,j)}}else{if(f){(h||(h=[])).push(a);(k||(k=[])).push(b[j])}}}if(f<d){h=h||o;k=k||b;g=l.styleInfo;q=l.el.getStyle(h);for(j=h.length;j--;){a=h[j];c=g[a];m=q[a];if(c&&c.parseInt){m=parseInt(m,10)||0}p[k[j]]=m;e[a]=m}}return p},hasProp:function(b){var a=this.getProp(b);return typeof a!="undefined"},hasDomProp:function(b){var a=this.getDomProp(b);return typeof a!="undefined"},invalidate:function(a){this.context.queueInvalidate(this,a)},markDirty:function(){if(++this.dirtyCount==1){this.context.queueFlush(this)}},onBoxMeasured:function(){var a=this.boxParent,b=this.state;if(a&&a.widthModel.shrinkWrap&&!b.boxMeasured&&this.measuresBox){b.boxMeasured=1;a.boxChildMeasured()}},parseMargins:function(d,c){if(d===true){d=5}var b=typeof d,a;if(b=="string"||b=="number"){a=Ext.util.Format.parseBox(d)}else{if(d||c){a={top:0,right:0,bottom:0,left:0};if(c){Ext.apply(a,this.parseMargins(c))}Ext.apply(a,d)}}return a},peek:function(a){return this.props[a]},recoverProp:function(f,b,a){var e=this,d=e.props,c;if(f in b){d[f]=b[f];if(a&&f in a){c=e.dirty||(e.dirty={});c[f]=a[f]}}},redo:function(b){var e=this,c,a,d;e.revertProps(e.props);if(b&&e.wrapsComponent){if(e.childItems){for(d=0,c=e.childItems,a=c.length;d<a;d++){c[d].redo(b)}}for(d=0,c=e.children,a=c.length;d<a;d++){c[d].redo()}}},revertProps:function(d){var a,b=this.flushedProps,c={};for(a in d){if(b.hasOwnProperty(a)){c[a]=d[a]}}this.writeProps(c)},setAttribute:function(a,c){var b=this;if(!b.attributes){b.attributes={}}b.attributes[a]=c;b.markDirty()},setBox:function(b){var a=this;if("left" in b){a.setProp("x",b.left)}if("top" in b){a.setProp("y",b.top)}a.setSize(b.width,b.height)},setContentHeight:function(a,b){if(!b&&this.hasRawContent){return 1}return this.setProp("contentHeight",a)},setContentWidth:function(b,a){if(!a&&this.hasRawContent){return 1}return this.setProp("contentWidth",b)},setContentSize:function(c,a,b){return this.setContentWidth(c,b)+this.setContentHeight(a,b)==2},setProp:function(d,c,a){var b=this,g=typeof c,f,e;if(g=="undefined"||(g==="number"&&isNaN(c))){return 0}if(b.props[d]===c){return 1}b.props[d]=c;++b.context.progressCount;if(a===false){b.fireTriggers("domTriggers",d);b.clearBlocks("domBlocks",d)}else{e=b.styleInfo[d];if(e){if(!b.dirty){b.dirty={}}if(d=="width"||d=="height"){f=b.isBorderBoxValue;if(f==null){b.isBorderBoxValue=f=!!b.el.isBorderBox()}if(!f){b.borderInfo||b.getBorderInfo();b.paddingInfo||b.getPaddingInfo()}}b.dirty[d]=c;b.markDirty()}}b.fireTriggers("triggers",d);b.clearBlocks("blocks",d);return 1},setHeight:function(a,c){var e=this,b=e.target,g,d,f;if(a<0){a=0}if(!e.wrapsComponent){if(!e.setProp("height",a,c)){return NaN}}else{a=Ext.Number.constrain(a,b.minHeight||0,b.maxHeight);if(!e.setProp("height",a,c)){return NaN}g=e.frameBodyContext;if(g){d=e.getFrameInfo();g.setHeight(a-d.height,c)}}return a},setWidth:function(c,b){var e=this,a=e.target,g,d,f;if(c<0){c=0}if(!e.wrapsComponent){if(!e.setProp("width",c,b)){return NaN}}else{c=Ext.Number.constrain(c,a.minWidth||0,a.maxWidth);if(!e.setProp("width",c,b)){return NaN}g=e.frameBodyContext;if(g){d=e.getFrameInfo();g.setWidth(c-d.width,b)}}return c},setSize:function(c,a,b){this.setWidth(c,b);this.setHeight(a,b)},translateProps:{x:"left",y:"top"},undo:function(b){var e=this,c,a,d;e.revertProps(e.lastBox);if(b&&e.wrapsComponent){if(e.childItems){for(d=0,c=e.childItems,a=c.length;d<a;d++){c[d].undo(b)}}for(d=0,c=e.children,a=c.length;d<a;d++){c[d].undo()}}},unsetProp:function(b){var a=this.dirty;delete this.props[b];if(a){delete a[b]}},writeProps:function(e,d){if(!(e&&typeof e=="object")){return}var B=this,c=B.el,h={},g=0,b=B.styleInfo,A,m,q,l="x" in e,k="y" in e,j=e.x,i=e.y,s=e.width,o=e.height,z=B.isBorderBoxValue,C=B.target,u=Math.max,w=0,n=0,f,a,r,t,v,p;if("displayed" in e){c.setDisplayed(e.displayed)}for(m in e){if(d){B.fireTriggers("domTriggers",m);B.clearBlocks("domBlocks",m);B.flushedProps[m]=1}A=b[m];if(A&&A.dom){if(A.suffix&&(q=parseInt(e[m],10))){h[m]=q+A.suffix}else{h[m]=e[m]}++g}}if(l||k){if(C.isComponent){C.setPosition(j||B.props.x,i||B.props.y)}else{if(l){h.left=j+"px";++g}if(k){h.top=i+"px";++g}}}if(!z&&(s>0||o>0)){if(!B.frameBodyContext){w=B.paddingInfo.width;n=B.paddingInfo.height}if(s){s=u(parseInt(s,10)-(B.borderInfo.width+w),0);h.width=s+"px";++g}if(o){o=u(parseInt(o,10)-(B.borderInfo.height+n),0);h.height=o+"px";++g}}if(B.wrapsComponent&&Ext.isIE9&&Ext.isStrict){if((f=s!==undefined&&B.hasOverflowY)||(a=o!==undefined&&B.hasOverflowX)){r=B.isAbsolute;if(r===undefined){r=false;p=B.target.getTargetEl();v=p.getStyle("position");if(v=="absolute"){v=p.getStyle("box-sizing");r=(v=="border-box")}B.isAbsolute=r}if(r){t=Ext.getScrollbarSize();if(f){s=parseInt(s,10)+t.width;h.width=s+"px";++g}if(a){o=parseInt(o,10)+t.height;h.height=o+"px";++g}}}}if(g){c.setStyle(h)}}},function(){var c={dom:true,parseInt:true,suffix:"px"},b={dom:true},a={dom:false};this.prototype.styleInfo={childrenDone:a,componentChildrenDone:a,containerChildrenDone:a,containerLayoutDone:a,displayed:a,done:a,x:a,y:a,columnWidthsDone:a,left:c,top:c,right:c,bottom:c,width:c,height:c,"border-top-width":c,"border-right-width":c,"border-bottom-width":c,"border-left-width":c,"margin-top":c,"margin-right":c,"margin-bottom":c,"margin-left":c,"padding-top":c,"padding-right":c,"padding-bottom":c,"padding-left":c,"line-height":b,display:b}});Ext.define("Ext.layout.Context",{requires:["Ext.util.Queue","Ext.layout.ContextItem","Ext.layout.Layout","Ext.fx.Anim","Ext.fx.Manager"],remainingLayouts:0,state:0,constructor:function(a){var b=this;Ext.apply(b,a);b.items={};b.layouts={};b.blockCount=0;b.cycleCount=0;b.flushCount=0;b.calcCount=0;b.animateQueue=b.newQueue();b.completionQueue=b.newQueue();b.finalizeQueue=b.newQueue();b.finishQueue=b.newQueue();b.flushQueue=b.newQueue();b.invalidateData={};b.layoutQueue=b.newQueue();b.invalidQueue=[];b.triggers={data:{},dom:{}}},callLayout:function(b,a){this.currentLayout=b;b[a](this.getCmp(b.owner))},cancelComponent:function(h,a,l){var o=this,g=h,j=!h.isComponent,b=j?g.length:1,d,c,n,m,f,r,p,q,s,e;for(d=0;d<b;++d){if(j){h=g[d]}if(l&&h.ownerCt){e=this.items[h.ownerCt.el.id];if(e){Ext.Array.remove(e.childItems,o.getCmp(h))}}if(!a){p=o.invalidQueue;n=p.length;if(n){o.invalidQueue=r=[];for(c=0;c<n;++c){q=p[c];s=q.item.target;if(s!=h&&!s.isDescendant(h)){r.push(q)}}}}f=h.componentLayout;o.cancelLayout(f);if(f.getLayoutItems){m=f.getLayoutItems();if(m.length){o.cancelComponent(m,true)}}if(h.isContainer&&!h.collapsed){f=h.layout;o.cancelLayout(f);m=f.getVisibleItems();if(m.length){o.cancelComponent(m,true)}}}},cancelLayout:function(b){var a=this;a.completionQueue.remove(b);a.finalizeQueue.remove(b);a.finishQueue.remove(b);a.layoutQueue.remove(b);if(b.running){a.layoutDone(b)}b.ownerContext=null},clearTriggers:function(f,g){var a=f.id,e=this.triggers[g?"dom":"data"],h=e&&e[a],b=(h&&h.length)||0,e,d,j,c;for(d=0;d<b;++d){c=h[d];j=c.item;e=g?j.domTriggers:j.triggers;delete e[c.prop][a]}},flush:function(){var d=this,a=d.flushQueue.clear(),c=a.length,b;if(c){++d.flushCount;for(b=0;b<c;++b){a[b].flush()}}},flushAnimations:function(){var d=this,b=d.animateQueue.clear(),a=b.length,c;if(a){for(c=0;c<a;c++){if(b[c].target.animate!==false){b[c].flushAnimations()}}Ext.fx.Manager.runner()}},flushInvalidates:function(){var g=this,a=g.invalidQueue,f=a&&a.length,b,e,d,c;g.invalidQueue=[];if(f){e=[];for(c=0;c<f;++c){b=(d=a[c]).item.target;if(!b.container.isDetachedBody){e.push(b);if(d.options){g.invalidateData[b.id]=d.options}}}g.invalidate(e,null)}},flushLayouts:function(g,a,c){var f=this,h=c?f[g].items:f[g].clear(),e=h.length,b,d;if(e){for(b=0;b<e;++b){d=h[b];if(!d.running){f.callLayout(d,a)}}f.currentLayout=null}},getCmp:function(a){return this.getItem(a,a.el)},getEl:function(b,a){var c=this.getItem(a,a);if(!c.parent){c.parent=b;if(b.children.length){b.children.push(c)}else{b.children=[c]}}return c},getItem:function(d,b){var e=b.id,a=this.items,c=a[e]||(a[e]=new Ext.layout.ContextItem({context:this,target:d,el:b}));return c},handleFailure:function(){var c=this.layouts,b,a;Ext.failedLayouts=(Ext.failedLayouts||0)+1;for(a in c){b=c[a];if(c.hasOwnProperty(a)){b.running=false;b.ownerContext=null}}},invalidate:function(m,o){var q=this,n=!m.isComponent,e,f,c,a,h,l,r,p,b,j,k,g,d;for(h=0,b=n?m.length:1;h<b;++h){l=n?m[h]:m;if(l.rendered&&!l.hidden){r=q.getCmp(l);j=l.componentLayout;a=!j.ownerContext;k=(l.isContainer&&!l.collapsed)?l.layout:null;g=q.invalidateData[r.id];delete q.invalidateData[r.id];d=r.init(o,g);if(g){q.processInvalidate(g,r,"before")}if(j.beforeLayoutCycle){j.beforeLayoutCycle(r)}d=r.initContinue(d);e=f=c=true;if(j.getLayoutItems){j.renderChildren();p=j.getLayoutItems();if(p.length){q.invalidate(p,true);e=false}}if(k){c=false;k.renderChildren();p=k.getVisibleItems();if(p.length){q.invalidate(p,true);f=false}}r.initDone(d,e,f,c);q.resetLayout(j,r,a);if(k){q.resetLayout(k,r,a)}r.initAnimation();if(g){q.processInvalidate(g,r,"after")}}}q.currentLayout=null},layoutDone:function(b){var c=b.ownerContext,a;b.running=false;if(b.isComponentLayout){if(c.measuresBox){c.onBoxMeasured()}c.setProp("done",true);a=c.ownerCtContext;if(a){if(c.target.ownerLayout.isComponentLayout){if(!--a.remainingComponentChildLayouts){a.setProp("componentChildrenDone",true)}}else{if(!--a.remainingContainerChildLayouts){a.setProp("containerChildrenDone",true)}}if(!--a.remainingChildLayouts){a.setProp("childrenDone",true)}}}else{c.setProp("containerLayoutDone",true)}--this.remainingLayouts;++this.progressCount},newQueue:function(){return new Ext.util.Queue()},processInvalidate:function(b,e,a){if(b[a]){var d=this,c=d.currentLayout;d.currentLayout=b.layout||null;b[a](e,b);d.currentLayout=c}},queueAnimation:function(a){this.animateQueue.add(a)},queueCompletion:function(a){this.completionQueue.add(a)},queueFinalize:function(a){this.finalizeQueue.add(a)},queueFlush:function(a){this.flushQueue.add(a)},chainFns:function(a,h,f){var d=this,c=a.layout,e=h.layout,b=a[f],g=h[f];return function(i){var j=d.currentLayout;if(b){d.currentLayout=c;b.call(a.scope||a,i,a)}d.currentLayout=e;g.call(h.scope||h,i,h);d.currentLayout=j}},queueInvalidate:function(j,k){var g=this,i=[],h=g.invalidQueue,f=h.length,d,b,e,a,c;if(j.isComponent){j=g.getCmp(d=j)}else{d=j.target}j.invalid=true;while(f--){b=h[f];e=b.item.target;if(d.isDescendant(e)){return}if(e==d){if(!(a=b.options)){b.options=k}else{if(k){if(k.widthModel){a.widthModel=k.widthModel}if(k.heightModel){a.heightModel=k.heightModel}if(!(c=a.state)){a.state=k.state}else{if(k.state){Ext.apply(c,k.state)}}if(k.before){a.before=g.chainFns(a,k,"before")}if(k.after){a.after=g.chainFns(a,k,"after")}}}return}if(!e.isDescendant(d)){i.push(b)}}i.push({item:j,options:k});g.invalidQueue=i},queueItemLayouts:function(c){var a=c.isComponent?c:c.target,b=a.componentLayout;if(!b.pending&&!b.invalid&&!b.done){this.queueLayout(b)}b=a.layout;if(b&&!b.pending&&!b.invalid&&!b.done){this.queueLayout(b)}},queueLayout:function(a){this.layoutQueue.add(a);a.pending=true},resetLayout:function(c,d,e){var b=this,a;b.currentLayout=c;c.done=false;c.pending=true;c.firedTriggers=0;b.layoutQueue.add(c);if(e){b.layouts[c.id]=c;c.running=true;if(c.finishedLayout){b.finishQueue.add(c)}++b.remainingLayouts;++c.layoutCount;c.ownerContext=d;c.beginCount=0;c.blockCount=0;c.calcCount=0;c.triggerCount=0;if(c.isComponentLayout&&(a=d.ownerCtContext)){if(d.target.ownerLayout.isComponentLayout){++a.remainingComponentChildLayouts}else{++a.remainingContainerChildLayouts}++a.remainingChildLayouts}if(!c.initialized){c.initLayout()}c.beginLayout(d)}else{++c.beginCount;if(!c.running){++b.remainingLayouts;c.running=true;if(c.isComponentLayout){d.unsetProp("done");a=d.ownerCtContext;if(a){if(d.target.ownerLayout.isComponentLayout){if(++a.remainingComponentChildLayouts==1){a.unsetProp("componentChildrenDone")}}else{if(++a.remainingContainerChildLayouts==1){a.unsetProp("containerChildrenDone")}}if(++a.remainingChildLayouts==1){a.unsetProp("childrenDone")}}}b.completionQueue.remove(c);b.finalizeQueue.remove(c)}}c.beginLayoutCycle(d,e)},run:function(){var c=this,b=false,a=100;c.flushInvalidates();c.state=1;c.totalCount=c.layoutQueue.getCount();c.flush();while((c.remainingLayouts||c.invalidQueue.length)&&a--){if(c.invalidQueue.length){c.flushInvalidates()}if(c.runCycle()){b=false}else{if(!b){c.flush();b=true;c.flushLayouts("completionQueue","completeLayout")}else{c.state=2;break}}if(!(c.remainingLayouts||c.invalidQueue.length)){c.flush();c.flushLayouts("completionQueue","completeLayout");c.flushLayouts("finalizeQueue","finalizeLayout")}}return c.runComplete()},runComplete:function(){var a=this;a.state=2;if(a.remainingLayouts){a.handleFailure();return false}a.flush();a.flushLayouts("finishQueue","finishedLayout",true);a.flushLayouts("finishQueue","notifyOwner");a.flush();a.flushAnimations();return true},runCycle:function(){var c=this,d=c.layoutQueue.clear(),b=d.length,a;++c.cycleCount;c.progressCount=0;for(a=0;a<b;++a){c.runLayout(c.currentLayout=d[a])}c.currentLayout=null;return c.progressCount>0},runLayout:function(b){var a=this,c=a.getCmp(b.owner);b.pending=false;if(c.state.blocks){return}b.done=true;++b.calcCount;++a.calcCount;b.calculate(c);if(b.done){a.layoutDone(b);if(b.completeLayout){a.queueCompletion(b)}if(b.finalizeLayout){a.queueFinalize(b)}}else{if(!b.pending&&!b.invalid&&!(b.blockCount+b.triggerCount-b.firedTriggers)){a.queueLayout(b)}}},setItemSize:function(g,f,b){var d=g,a=1,c,e;if(g.isComposite){d=g.elements;a=d.length;g=d[0]}else{if(!g.dom&&!g.el){a=d.length;g=d[0]}}for(e=0;e<a;){c=this.get(g);c.setSize(f,b);g=d[++e]}}});Ext.define("Ext.menu.KeyNav",{extend:"Ext.util.KeyNav",requires:["Ext.FocusManager"],constructor:function(b){var a=this;a.menu=b;a.callParent([b.el,{down:a.down,enter:a.enter,esc:a.escape,left:a.left,right:a.right,space:a.enter,tab:a.tab,up:a.up}])},down:function(b){var a=this,c=a.menu.focusedItem;if(c&&b.getKey()==Ext.EventObject.DOWN&&a.isWhitelisted(c)){return true}a.focusNextItem(1)},enter:function(b){var c=this.menu,a=c.focusedItem;if(c.activeItem){c.onClick(b)}else{if(a&&a.isFormField){return true}}},escape:function(a){Ext.menu.Manager.hideAll()},focusNextItem:function(f){var g=this.menu,b=g.items,d=g.focusedItem,c=d?b.indexOf(d):-1,a=c+f,e;while(a!=c){if(a<0){a=b.length-1}else{if(a>=b.length){a=0}}e=b.getAt(a);if(g.canActivateItem(e)){g.setActiveItem(e);break}a+=f}},isWhitelisted:function(a){return Ext.FocusManager.isWhitelisted(a)},left:function(b){var c=this.menu,d=c.focusedItem,a=c.activeItem;if(d&&this.isWhitelisted(d)){return true}c.hide();if(c.parentMenu){c.parentMenu.focus()}},right:function(c){var d=this.menu,f=d.focusedItem,a=d.activeItem,b;if(f&&this.isWhitelisted(f)){return true}if(a){b=d.activeItem.menu;if(b){a.expandMenu(0);Ext.defer(function(){b.setActiveItem(b.items.getAt(0))},25)}}},tab:function(b){var a=this;if(b.shiftKey){a.up(b)}else{a.down(b)}},up:function(b){var a=this,c=a.menu.focusedItem;if(c&&b.getKey()==Ext.EventObject.UP&&a.isWhitelisted(c)){return true}a.focusNextItem(-1)}});Ext.define("Ext.menu.Menu",{extend:"Ext.panel.Panel",alias:"widget.menu",requires:["Ext.layout.container.Fit","Ext.layout.container.VBox","Ext.menu.CheckItem","Ext.menu.Item","Ext.menu.KeyNav","Ext.menu.Manager","Ext.menu.Separator"],enableKeyNav:true,allowOtherMenus:false,ariaRole:"menu",defaultAlign:"tl-bl?",floating:true,constrain:true,hidden:true,hideMode:"visibility",ignoreParentClicks:false,isMenu:true,showSeparator:true,minWidth:undefined,defaultMinWidth:120,initComponent:function(){var b=this,d=Ext.baseCSSPrefix,a=[d+"menu"],c=b.bodyCls?[b.bodyCls]:[],e=b.floating!==false;b.addEvents("click","mouseenter","mouseleave","mouseover");Ext.menu.Manager.register(b);if(b.plain){a.push(d+"menu-plain")}b.cls=a.join(" ");c.unshift(d+"menu-body");b.bodyCls=c.join(" ");if(!b.layout){b.layout={type:"vbox",align:"stretchmax",overflowHandler:"Scroller"}}if(e&&b.minWidth===undefined){b.minWidth=b.defaultMinWidth}if(!e&&b.initialConfig.hidden!==true){b.hidden=false}b.callParent(arguments);b.on("beforeshow",function(){var f=!!b.items.length;if(f&&b.rendered){b.el.setStyle("visibility",null)}return f})},beforeRender:function(){this.callParent(arguments);if(!this.getSizeModel().width.shrinkWrap){this.layout.align="stretch"}},onBoxReady:function(){var a=this,b;a.callParent(arguments);if(a.showSeparator){b={cls:Ext.baseCSSPrefix+"menu-icon-separator",html:"&#160;"};if((!Ext.isStrict&&Ext.isIE)||Ext.isIE6){b.style="height:"+a.el.getHeight()+"px"}a.iconSepEl=a.layout.getElementTarget().insertFirst(b)}a.mon(a.el,{click:a.onClick,mouseover:a.onMouseOver,scope:a});a.mouseMonitor=a.el.monitorMouseLeave(100,a.onMouseLeave,a);if(a.enableKeyNav){a.keyNav=new Ext.menu.KeyNav(a)}},getBubbleTarget:function(){return this.parentMenu||this.ownerButton||this.callParent(arguments)},canActivateItem:function(a){return a&&!a.isDisabled()&&a.isVisible()&&(a.canActivate||a.getXTypes().indexOf("menuitem")<0)},deactivateActiveItem:function(b){var c=this,d=c.activeItem,a=c.focusedItem;if(d){d.deactivate();if(!d.activated){delete c.activeItem}}if(a&&b){a.blur();delete c.focusedItem}},getFocusEl:function(){return this.focusedItem||this.el},hide:function(){this.deactivateActiveItem(true);this.callParent(arguments)},getItemFromEvent:function(a){return this.getChildByElement(a.getTarget())},lookupComponent:function(b){var a=this;if(typeof b=="string"){b=a.lookupItemFromString(b)}else{if(Ext.isObject(b)){b=a.lookupItemFromObject(b)}}b.minWidth=b.minWidth||a.minWidth;return b},lookupItemFromObject:function(c){var b=this,d=Ext.baseCSSPrefix,a;if(!c.isComponent){if(!c.xtype){c=Ext.create("Ext.menu."+(Ext.isBoolean(c.checked)?"Check":"")+"Item",c)}else{c=Ext.ComponentManager.create(c,c.xtype)}}if(c.isMenuItem){c.parentMenu=b}if(!c.isMenuItem&&!c.dock){a=[d+"menu-item",d+"menu-item-cmp"];if(!b.plain&&(c.indent===true||c.iconCls==="no-icon")){a.push(d+"menu-item-indent")}if(c.rendered){c.el.addCls(a)}else{c.cls=(c.cls?c.cls:"")+" "+a.join(" ")}}return c},lookupItemFromString:function(a){return(a=="separator"||a=="-")?new Ext.menu.Separator():new Ext.menu.Item({canActivate:false,hideOnClick:false,plain:true,text:a})},onClick:function(c){var b=this,a;if(b.disabled){c.stopEvent();return}a=(c.type==="click")?b.getItemFromEvent(c):b.activeItem;if(a&&a.isMenuItem){if(!a.menu||!b.ignoreParentClicks){a.onClick(c)}else{c.stopEvent()}}if(!a||a.disabled){a=undefined}b.fireEvent("click",b,a,c)},onDestroy:function(){var a=this;Ext.menu.Manager.unregister(a);delete a.parentMenu;delete a.ownerButton;if(a.rendered){a.el.un(a.mouseMonitor);Ext.destroy(a.keyNav);delete a.keyNav}a.callParent(arguments)},onMouseLeave:function(b){var a=this;a.deactivateActiveItem();if(a.disabled){return}a.fireEvent("mouseleave",a,b)},onMouseOver:function(g){var f=this,h=g.getRelatedTarget(),b=!f.el.contains(h),d=f.getItemFromEvent(g),c=f.parentMenu,a=f.parentItem;if(b&&c){c.setActiveItem(a);a.cancelDeferHide();c.mouseMonitor.mouseenter()}if(f.disabled){return}if(d&&!d.activated){f.setActiveItem(d);if(d.activated&&d.expandMenu){d.expandMenu()}}if(b){f.fireEvent("mouseenter",f,g)}f.fireEvent("mouseover",f,d,g)},setActiveItem:function(b){var a=this;if(b&&(b!=a.activeItem)){a.deactivateActiveItem();if(a.canActivateItem(b)){if(b.activate){b.activate();if(b.activated){a.activeItem=b;a.focusedItem=b;a.focus()}}else{b.focus();a.focusedItem=b}}b.el.scrollIntoView(a.layout.getRenderTarget())}},showBy:function(b,d,c){var a=this;if(a.floating&&b){a.show();a.setPagePosition(a.el.getAlignToXY(b.el||b,d||a.defaultAlign,c));a.setVerticalPosition()}return a},show:function(){var d=this,c,b,a,e=d.maxHeight;if(!d.rendered){d.doAutoRender()}if(d.floating){c=Ext.fly(d.el.getScopeParent());b=c.getViewSize().height;d.maxHeight=Math.min(e||b,b)}a=d.callParent(arguments);d.maxHeight=e;return a},afterComponentLayout:function(c,a,b,e){var d=this;d.callParent(arguments);if(d.showSeparator){d.iconSepEl.setHeight(d.componentLayout.lastComponentSize.contentHeight)}},setVerticalPosition:function(){var d=this,f,e=d.el.getY(),g=e,i=d.getHeight(),b=Ext.Element.getViewportHeight().height,c=Ext.fly(d.el.getScopeParent()),a=c.getViewSize().height,h=e-c.getScroll().top;c=null;if(d.floating){f=d.maxHeight?d.maxHeight:a-h;if(i>a){g=e-h}else{if(f<i){g=e-(i-f)}else{if((e+i)>b){g=b-i}}}}d.el.setY(g)}});Ext.define("Ext.draw.Sprite",{mixins:{observable:"Ext.util.Observable",animate:"Ext.util.Animate"},requires:["Ext.draw.SpriteDD"],dirty:false,dirtyHidden:false,dirtyTransform:false,dirtyPath:true,dirtyFont:true,zIndexDirty:true,isSprite:true,zIndex:0,fontProperties:["font","font-size","font-weight","font-style","font-family","text-anchor","text"],pathProperties:["x","y","d","path","height","width","radius","r","rx","ry","cx","cy"],constructor:function(a){var b=this;a=Ext.merge({},a||{});b.id=Ext.id(null,"ext-sprite-");b.transformations=[];Ext.copyTo(this,a,"surface,group,type,draggable");b.bbox={};b.attr={zIndex:0,translation:{x:null,y:null},rotation:{degrees:null,x:null,y:null},scaling:{x:null,y:null,cx:null,cy:null}};delete a.surface;delete a.group;delete a.type;delete a.draggable;b.setAttributes(a);b.addEvents("beforedestroy","destroy","render","mousedown","mouseup","mouseover","mouseout","mousemove","click");b.mixins.observable.constructor.apply(this,arguments)},initDraggable:function(){var a=this;a.draggable=true;if(!a.el){a.surface.createSpriteElement(a)}a.dd=new Ext.draw.SpriteDD(a,Ext.isBoolean(a.draggable)?null:a.draggable);a.on("beforedestroy",a.dd.destroy,a.dd)},setAttributes:function(k,n){var s=this,h=s.fontProperties,p=h.length,g=s.pathProperties,f=g.length,q=!!s.surface,a=q&&s.surface.customAttributes||{},c=s.attr,b=false,l,o,j,d,r,m,t,e;k=Ext.apply({},k);for(l in a){if(k.hasOwnProperty(l)&&typeof a[l]=="function"){Ext.apply(k,a[l].apply(s,[].concat(k[l])))}}if(!!k.hidden!==!!c.hidden){s.dirtyHidden=true}for(o=0;o<f;o++){l=g[o];if(l in k&&k[l]!==c[l]){s.dirtyPath=true;b=true;break}}if("zIndex" in k){s.zIndexDirty=true}if("text" in k){s.dirtyFont=true;b=true}for(o=0;o<p;o++){l=h[o];if(l in k&&k[l]!==c[l]){s.dirtyFont=true;b=true;break}}j=k.translation||k.translate;delete k.translate;delete k.translation;d=c.translation;if(j){if(("x" in j&&j.x!==d.x)||("y" in j&&j.y!==d.y)){s.dirtyTransform=true;d.x=j.x;d.y=j.y}}r=k.rotation||k.rotate;m=c.rotation;delete k.rotate;delete k.rotation;if(r){if(("x" in r&&r.x!==m.x)||("y" in r&&r.y!==m.y)||("degrees" in r&&r.degrees!==m.degrees)){s.dirtyTransform=true;m.x=r.x;m.y=r.y;m.degrees=r.degrees}}t=k.scaling||k.scale;e=c.scaling;delete k.scale;delete k.scaling;if(t){if(("x" in t&&t.x!==e.x)||("y" in t&&t.y!==e.y)||("cx" in t&&t.cx!==e.cx)||("cy" in t&&t.cy!==e.cy)){s.dirtyTransform=true;e.x=t.x;e.y=t.y;e.cx=t.cx;e.cy=t.cy}}if(!s.dirtyTransform&&b){if(c.scaling.x===null||c.scaling.y===null||c.rotation.y===null||c.rotation.y===null){s.dirtyTransform=true}}Ext.apply(c,k);s.dirty=true;if(n===true&&q){s.redraw()}return this},getBBox:function(){return this.surface.getBBox(this)},setText:function(a){return this.surface.setText(this,a)},hide:function(a){this.setAttributes({hidden:true},a);return this},show:function(a){this.setAttributes({hidden:false},a);return this},remove:function(){if(this.surface){this.surface.remove(this);return true}return false},onRemove:function(){this.surface.onRemove(this)},destroy:function(){var a=this;if(a.fireEvent("beforedestroy",a)!==false){a.remove();a.surface.onDestroy(a);a.clearListeners();a.fireEvent("destroy")}},redraw:function(){this.surface.renderItem(this);return this},setStyle:function(){this.el.setStyle.apply(this.el,arguments);return this},addCls:function(a){this.surface.addCls(this,a);return this},removeCls:function(a){this.surface.removeCls(this,a);return this}});Ext.define("Ext.draw.engine.Svg",{extend:"Ext.draw.Surface",requires:["Ext.draw.Draw","Ext.draw.Sprite","Ext.draw.Matrix","Ext.Element"],engine:"Svg",trimRe:/^\s+|\s+$/g,spacesRe:/\s+/,xlink:"http://www.w3.org/1999/xlink",translateAttrs:{radius:"r",radiusX:"rx",radiusY:"ry",path:"d",lineWidth:"stroke-width",fillOpacity:"fill-opacity",strokeOpacity:"stroke-opacity",strokeLinejoin:"stroke-linejoin"},parsers:{},minDefaults:{circle:{cx:0,cy:0,r:0,fill:"none",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},ellipse:{cx:0,cy:0,rx:0,ry:0,fill:"none",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},rect:{x:0,y:0,width:0,height:0,rx:0,ry:0,fill:"none",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},text:{x:0,y:0,"text-anchor":"start","font-family":null,"font-size":null,"font-weight":null,"font-style":null,fill:"#000",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},path:{d:"M0,0",fill:"none",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},image:{x:0,y:0,width:0,height:0,preserveAspectRatio:"none",opacity:null}},createSvgElement:function(d,a){var c=this.domRef.createElementNS("http://www.w3.org/2000/svg",d),b;if(a){for(b in a){c.setAttribute(b,String(a[b]))}}return c},createSpriteElement:function(a){var b=this.createSvgElement(a.type);b.id=a.id;if(b.style){b.style.webkitTapHighlightColor="rgba(0,0,0,0)"}a.el=Ext.get(b);this.applyZIndex(a);a.matrix=new Ext.draw.Matrix();a.bbox={plain:0,transform:0};this.applyAttrs(a);this.applyTransformations(a);a.fireEvent("render",a);return b},getBBoxText:function(h){var j={},f,k,a,c,g,b;if(h&&h.el){b=h.el.dom;try{j=b.getBBox();return j}catch(d){}j={x:j.x,y:Infinity,width:0,height:0};g=b.getNumberOfChars();for(c=0;c<g;c++){f=b.getExtentOfChar(c);j.y=Math.min(f.y,j.y);k=f.y+f.height-j.y;j.height=Math.max(j.height,k);a=f.x+f.width-j.x;j.width=Math.max(j.width,a)}return j}},hide:function(){Ext.get(this.el).hide()},show:function(){Ext.get(this.el).show()},hidePrim:function(a){this.addCls(a,Ext.baseCSSPrefix+"hide-visibility")},showPrim:function(a){this.removeCls(a,Ext.baseCSSPrefix+"hide-visibility")},getDefs:function(){return this._defs||(this._defs=this.createSvgElement("defs"))},transform:function(j,a){var g=this,h=new Ext.draw.Matrix(),e=j.transformations,d=e.length,c=0,b,f;for(;c<d;c++){b=e[c];f=b.type;if(f=="translate"){h.translate(b.x,b.y)}else{if(f=="rotate"){h.rotate(b.degrees,b.x,b.y)}else{if(f=="scale"){h.scale(b.x,b.y,b.centerX,b.centerY)}}}}j.matrix=h;if(!a){j.el.set({transform:h.toSvg()})}},setSize:function(c,a){var d=this,b=d.el;c=+c||d.width;a=+a||d.height;d.width=c;d.height=a;b.setSize(c,a);b.set({width:c,height:a});d.callParent([c,a])},getRegion:function(){var e=this.el.getXY(),c=this.bgRect.getXY(),b=Math.max,a=b(e[0],c[0]),d=b(e[1],c[1]);return{left:a,top:d,right:a+this.width,bottom:d+this.height}},onRemove:function(a){if(a.el){a.el.destroy();delete a.el}this.callParent(arguments)},setViewBox:function(b,d,c,a){if(isFinite(b)&&isFinite(d)&&isFinite(c)&&isFinite(a)){this.callParent(arguments);this.el.dom.setAttribute("viewBox",[b,d,c,a].join(" "))}},render:function(c){var f=this,e,b,d,a,g,h;if(!f.el){e=f.width||0;b=f.height||0;d=f.createSvgElement("svg",{xmlns:"http://www.w3.org/2000/svg",version:1.1,width:e,height:b});a=f.getDefs();g=f.createSvgElement("rect",{width:"100%",height:"100%",fill:"#000",stroke:"none",opacity:0});if(Ext.isSafari3){h=f.createSvgElement("rect",{x:-10,y:-10,width:"110%",height:"110%",fill:"none",stroke:"#000"})}d.appendChild(a);if(Ext.isSafari3){d.appendChild(h)}d.appendChild(g);c.appendChild(d);f.el=Ext.get(d);f.bgRect=Ext.get(g);if(Ext.isSafari3){f.webkitRect=Ext.get(h);f.webkitRect.hide()}f.el.on({scope:f,mouseup:f.onMouseUp,mousedown:f.onMouseDown,mouseover:f.onMouseOver,mouseout:f.onMouseOut,mousemove:f.onMouseMove,mouseenter:f.onMouseEnter,mouseleave:f.onMouseLeave,click:f.onClick,dblclick:f.onDblClick})}f.renderAll()},onMouseEnter:function(a){if(this.el.parent().getRegion().contains(a.getPoint())){this.fireEvent("mouseenter",a)}},onMouseLeave:function(a){if(!this.el.parent().getRegion().contains(a.getPoint())){this.fireEvent("mouseleave",a)}},processEvent:function(b,f){var d=f.getTarget(),a=this.surface,c;this.fireEvent(b,f);if(d.nodeName=="tspan"&&d.parentNode){d=d.parentNode}c=this.items.get(d.id);if(c){c.fireEvent(b,c,f)}},tuneText:function(j,k){var a=j.el.dom,b=[],m,g,l,d,e,c,f,h;if(k.hasOwnProperty("text")){l=j.tspans&&Ext.Array.map(j.tspans,function(i){return i.textContent}).join("");if(!j.tspans||k.text!=l){b=this.setText(j,k.text);j.tspans=b}else{b=j.tspans||[]}}if(b.length){m=this.getBBoxText(j).height;h=j.el.dom.getAttribute("x");for(d=0,e=b.length;d<e;d++){f=(Ext.isFF3_0||Ext.isFF3_5)?2:4;b[d].setAttribute("x",h);b[d].setAttribute("dy",d?m*1.2:m/f)}j.dirty=true}},setText:function(j,d){var g=this,a=j.el.dom,b=[],l,h,k,e,f,c;while(a.firstChild){a.removeChild(a.firstChild)}c=String(d).split("\n");for(e=0,f=c.length;e<f;e++){k=c[e];if(k){h=g.createSvgElement("tspan");h.appendChild(document.createTextNode(Ext.htmlDecode(k)));a.appendChild(h);b[e]=h}}return b},renderAll:function(){this.items.each(this.renderItem,this)},renderItem:function(a){if(!this.el){return}if(!a.el){this.createSpriteElement(a)}if(a.zIndexDirty){this.applyZIndex(a)}if(a.dirty){this.applyAttrs(a);if(a.dirtyTransform){this.applyTransformations(a)}}},redraw:function(a){a.dirty=a.zIndexDirty=true;this.renderItem(a)},applyAttrs:function(q){var l=this,c=q.el,p=q.group,h=q.attr,r=l.parsers,f=l.gradientsMap||{},j=Ext.isSafari&&!Ext.isStrict,e,g,k,o,d,n,b,a,m;if(p){e=[].concat(p);k=e.length;for(g=0;g<k;g++){p=e[g];l.getGroup(p).add(q)}delete q.group}o=l.scrubAttrs(q)||{};q.bbox.plain=0;q.bbox.transform=0;if(q.type=="circle"||q.type=="ellipse"){o.cx=o.cx||o.x;o.cy=o.cy||o.y}else{if(q.type=="rect"){o.rx=o.ry=o.r}else{if(q.type=="path"&&o.d){o.d=Ext.draw.Draw.pathToString(Ext.draw.Draw.pathToAbsolute(o.d))}}}q.dirtyPath=false;if(o["clip-rect"]){l.setClip(q,o);delete o["clip-rect"]}if(q.type=="text"&&o.font&&q.dirtyFont){c.set({style:"font: "+o.font})}if(q.type=="image"){c.dom.setAttributeNS(l.xlink,"href",o.src)}Ext.applyIf(o,l.minDefaults[q.type]);if(q.dirtyHidden){(h.hidden)?l.hidePrim(q):l.showPrim(q);q.dirtyHidden=false}for(n in o){if(o.hasOwnProperty(n)&&o[n]!=null){if(j&&("color|stroke|fill".indexOf(n)>-1)&&(o[n] in f)){o[n]=f[o[n]]}if(n=="hidden"&&q.type=="text"){continue}if(n in r){c.dom.setAttribute(n,r[n](o[n],q,l))}else{c.dom.setAttribute(n,o[n])}}}if(q.type=="text"){l.tuneText(q,o)}q.dirtyFont=false;b=h.style;if(b){c.setStyle(b)}q.dirty=false;if(Ext.isSafari3){l.webkitRect.show();setTimeout(function(){l.webkitRect.hide()})}},setClip:function(b,f){var e=this,d=f["clip-rect"],a,c;if(d){if(b.clip){b.clip.parentNode.parentNode.removeChild(b.clip.parentNode)}a=e.createSvgElement("clipPath");c=e.createSvgElement("rect");a.id=Ext.id(null,"ext-clip-");c.setAttribute("x",d.x);c.setAttribute("y",d.y);c.setAttribute("width",d.width);c.setAttribute("height",d.height);a.appendChild(c);e.getDefs().appendChild(a);b.el.dom.setAttribute("clip-path","url(#"+a.id+")");b.clip=c}},applyZIndex:function(d){var f=this,b=f.items,a=b.indexOf(d),e=d.el,c;if(f.el.dom.childNodes[a+2]!==e.dom){if(a>0){do{c=b.getAt(--a).el}while(!c&&a>0)}e.insertAfter(c||f.bgRect)}d.zIndexDirty=false},createItem:function(a){var b=new Ext.draw.Sprite(a);b.surface=this;return b},addGradient:function(g){g=Ext.draw.Draw.parseGradient(g);var e=this,d=g.stops.length,a=g.vector,k=Ext.isSafari&&!Ext.isStrict,h,f,j,c,b;b=e.gradientsMap||{};if(!k){if(g.type=="linear"){h=e.createSvgElement("linearGradient");h.setAttribute("x1",a[0]);h.setAttribute("y1",a[1]);h.setAttribute("x2",a[2]);h.setAttribute("y2",a[3])}else{h=e.createSvgElement("radialGradient");h.setAttribute("cx",g.centerX);h.setAttribute("cy",g.centerY);h.setAttribute("r",g.radius);if(Ext.isNumber(g.focalX)&&Ext.isNumber(g.focalY)){h.setAttribute("fx",g.focalX);h.setAttribute("fy",g.focalY)}}h.id=g.id;e.getDefs().appendChild(h);for(c=0;c<d;c++){f=g.stops[c];j=e.createSvgElement("stop");j.setAttribute("offset",f.offset+"%");j.setAttribute("stop-color",f.color);j.setAttribute("stop-opacity",f.opacity);h.appendChild(j)}}else{b["url(#"+g.id+")"]=g.stops[0].color}e.gradientsMap=b},hasCls:function(a,b){return b&&(" "+(a.el.dom.getAttribute("class")||"")+" ").indexOf(" "+b+" ")!=-1},addCls:function(e,g){var f=e.el,d,a,c,b=[],h=f.getAttribute("class")||"";if(!Ext.isArray(g)){if(typeof g=="string"&&!this.hasCls(e,g)){f.set({"class":h+" "+g})}}else{for(d=0,a=g.length;d<a;d++){c=g[d];if(typeof c=="string"&&(" "+h+" ").indexOf(" "+c+" ")==-1){b.push(c)}}if(b.length){f.set({"class":" "+b.join(" ")})}}},removeCls:function(j,f){var g=this,b=j.el,d=b.getAttribute("class")||"",c,h,e,k,a;if(!Ext.isArray(f)){f=[f]}if(d){a=d.replace(g.trimRe," ").split(g.spacesRe);for(c=0,e=f.length;c<e;c++){k=f[c];if(typeof k=="string"){k=k.replace(g.trimRe,"");h=Ext.Array.indexOf(a,k);if(h!=-1){Ext.Array.erase(a,h,1)}}}b.set({"class":a.join(" ")})}},destroy:function(){var a=this;a.callParent();if(a.el){a.el.remove()}if(a._defs){Ext.get(a._defs).destroy()}if(a.bgRect){Ext.get(a.bgRect).destroy()}if(a.webkitRect){Ext.get(a.webkitRect).destroy()}delete a.el}});Ext.define("Ext.draw.engine.Vml",{extend:"Ext.draw.Surface",requires:["Ext.draw.Draw","Ext.draw.Color","Ext.draw.Sprite","Ext.draw.Matrix","Ext.Element"],engine:"Vml",map:{M:"m",L:"l",C:"c",Z:"x",m:"t",l:"r",c:"v",z:"x"},bitesRe:/([clmz]),?([^clmz]*)/gi,valRe:/-?[^,\s\-]+/g,fillUrlRe:/^url\(\s*['"]?([^\)]+?)['"]?\s*\)$/i,pathlike:/^(path|rect)$/,NonVmlPathRe:/[ahqstv]/ig,partialPathRe:/[clmz]/g,fontFamilyRe:/^['"]+|['"]+$/g,baseVmlCls:Ext.baseCSSPrefix+"vml-base",vmlGroupCls:Ext.baseCSSPrefix+"vml-group",spriteCls:Ext.baseCSSPrefix+"vml-sprite",measureSpanCls:Ext.baseCSSPrefix+"vml-measure-span",zoom:21600,coordsize:1000,coordorigin:"0 0",zIndexShift:0,orderSpritesByZIndex:false,path2vml:function(s){var m=this,t=m.NonVmlPathRe,b=m.map,e=m.valRe,q=m.zoom,d=m.bitesRe,f=Ext.Function.bind(Ext.draw.Draw.pathToAbsolute,Ext.draw.Draw),l,n,c,a,h,o,g,k;if(String(s).match(t)){f=Ext.Function.bind(Ext.draw.Draw.path2curve,Ext.draw.Draw)}else{if(!String(s).match(m.partialPathRe)){l=String(s).replace(d,function(r,v,j){var u=[],i=v.toLowerCase()=="m",p=b[v];j.replace(e,function(w){if(i&&u.length===2){p+=u+b[v=="m"?"l":"L"];u=[]}u.push(Math.round(w*q))});return p+u});return l}}n=f(s);l=[];for(h=0,o=n.length;h<o;h++){c=n[h];a=n[h][0].toLowerCase();if(a=="z"){a="x"}for(g=1,k=c.length;g<k;g++){a+=Math.round(c[g]*m.zoom)+(g!=k-1?",":"")}l.push(a)}return l.join(" ")},translateAttrs:{radius:"r",radiusX:"rx",radiusY:"ry",lineWidth:"stroke-width",fillOpacity:"fill-opacity",strokeOpacity:"stroke-opacity",strokeLinejoin:"stroke-linejoin"},minDefaults:{circle:{fill:"none",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},ellipse:{cx:0,cy:0,rx:0,ry:0,fill:"none",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},rect:{x:0,y:0,width:0,height:0,rx:0,ry:0,fill:"none",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},text:{x:0,y:0,"text-anchor":"start",font:'10px "Arial"',fill:"#000",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},path:{d:"M0,0",fill:"none",stroke:null,"stroke-width":null,opacity:null,"fill-opacity":null,"stroke-opacity":null},image:{x:0,y:0,width:0,height:0,preserveAspectRatio:"none",opacity:null}},onMouseEnter:function(a){this.fireEvent("mouseenter",a)},onMouseLeave:function(a){this.fireEvent("mouseleave",a)},processEvent:function(b,f){var d=f.getTarget(),a=this.surface,c;this.fireEvent(b,f);c=this.items.get(d.id);if(c){c.fireEvent(b,c,f)}},createSpriteElement:function(g){var e=this,d=g.attr,f=g.type,i=e.zoom,b=g.vml||(g.vml={}),j=Math.round,c=(f==="image")?e.createNode("image"):e.createNode("shape"),k,h,a;c.coordsize=i+" "+i;c.coordorigin=d.coordorigin||"0 0";Ext.get(c).addCls(e.spriteCls);if(f=="text"){b.path=k=e.createNode("path");k.textpathok=true;b.textpath=a=e.createNode("textpath");a.on=true;c.appendChild(a);c.appendChild(k)}c.id=g.id;g.el=Ext.get(c);g.el.setStyle("zIndex",-e.zIndexShift);e.el.appendChild(c);if(f!=="image"){h=e.createNode("skew");h.on=true;c.appendChild(h);g.skew=h}g.matrix=new Ext.draw.Matrix();g.bbox={plain:null,transform:null};this.applyAttrs(g);this.applyTransformations(g);g.fireEvent("render",g);return g.el},getBBoxText:function(b){var a=b.vml;return{x:a.X+(a.bbx||0)-a.W/2,y:a.Y-a.H/2,width:a.W,height:a.H}},applyAttrs:function(l){var r=this,c=l.vml,h=l.group,a=l.attr,b=l.el,n=b.dom,o,t,q,m,j,p,k,s,e,d,g,f;if(h){q=[].concat(h);j=q.length;for(m=0;m<j;m++){h=q[m];r.getGroup(h).add(l)}delete l.group}p=r.scrubAttrs(l)||{};if(l.zIndexDirty){r.setZIndex(l)}Ext.applyIf(p,r.minDefaults[l.type]);if(l.type=="image"){Ext.apply(l.attr,{x:p.x,y:p.y,width:p.width,height:p.height});b.setStyle({width:p.width+"px",height:p.height+"px"});n.src=p.src}if(n.href){n.href=p.href}if(n.title){n.title=p.title}if(n.target){n.target=p.target}if(n.cursor){n.cursor=p.cursor}if(l.dirtyHidden){(p.hidden)?r.hidePrim(l):r.showPrim(l);l.dirtyHidden=false}if(l.dirtyPath){if(l.type=="circle"||l.type=="ellipse"){e=p.x;d=p.y;g=p.rx||p.r||0;f=p.ry||p.r||0;n.path=Ext.String.format("ar{0},{1},{2},{3},{4},{1},{4},{1}",Math.round((e-g)*r.zoom),Math.round((d-f)*r.zoom),Math.round((e+g)*r.zoom),Math.round((d+f)*r.zoom),Math.round(e*r.zoom));l.dirtyPath=false}else{if(l.type!=="text"&&l.type!=="image"){l.attr.path=p.path=r.setPaths(l,p)||p.path;n.path=r.path2vml(p.path);l.dirtyPath=false}}}if("clip-rect" in p){r.setClip(l,p)}if(l.type=="text"){r.setTextAttributes(l,p)}if(p.opacity||p["stroke-opacity"]||p.fill){r.setFill(l,p)}if(p.stroke||p["stroke-opacity"]||p.fill){r.setStroke(l,p)}o=a.style;if(o){b.setStyle(o)}l.dirty=false},setZIndex:function(e){var g=this,h=e.attr.zIndex,b=g.zIndexShift,c,a,f,d;if(h<b){c=g.items.items;a=c.length;for(d=0;d<a;d++){if((h=c[d].attr.zIndex)&&h<b){b=h}}g.zIndexShift=b;for(d=0;d<a;d++){f=c[d];if(f.el){f.el.setStyle("zIndex",f.attr.zIndex-b)}f.zIndexDirty=false}}else{if(e.el){e.el.setStyle("zIndex",h-b);e.zIndexDirty=false}}},setPaths:function(c,d){var a=c.attr,b=c.attr["stroke-width"]||1;c.bbox.plain=null;c.bbox.transform=null;if(c.type=="circle"){a.rx=a.ry=d.r;return Ext.draw.Draw.ellipsePath(c)}else{if(c.type=="ellipse"){a.rx=d.rx;a.ry=d.ry;return Ext.draw.Draw.ellipsePath(c)}else{if(c.type=="rect"){a.rx=a.ry=d.r;return Ext.draw.Draw.rectPath(c)}else{if(c.type=="path"&&a.path){return Ext.draw.Draw.pathToAbsolute(a.path)}}}}return false},setFill:function(j,e){var g=this,c=j.el.dom,i=c.fill,b=false,f,h,a,k,d;if(!i){i=c.fill=g.createNode("fill");b=true}if(Ext.isArray(e.fill)){e.fill=e.fill[0]}if(e.fill=="none"){i.on=false}else{if(typeof e.opacity=="number"){i.opacity=e.opacity}if(typeof e["fill-opacity"]=="number"){i.opacity=e["fill-opacity"]}i.on=true;if(typeof e.fill=="string"){a=e.fill.match(g.fillUrlRe);if(a){a=a[1];if(a.charAt(0)=="#"){h=g.gradientsColl.getByKey(a.substring(1))}if(h){k=e.rotation;d=-(h.angle+270+(k?k.degrees:0))%360;if(d===0){d=180}i.angle=d;i.type="gradient";i.method="sigma";if(i.colors){i.colors.value=h.colors}else{i.colors=h.colors}}else{i.src=a;i.type="tile"}}else{i.color=Ext.draw.Color.toHex(e.fill);i.src="";i.type="solid"}}}if(b){c.appendChild(i)}},setStroke:function(b,g){var e=this,d=b.el.dom,h=b.strokeEl,f=false,c,a;if(!h){h=b.strokeEl=e.createNode("stroke");f=true}if(Ext.isArray(g.stroke)){g.stroke=g.stroke[0]}if(!g.stroke||g.stroke=="none"||g.stroke==0||g["stroke-width"]==0){h.on=false}else{h.on=true;if(g.stroke&&!g.stroke.match(e.fillUrlRe)){h.color=Ext.draw.Color.toHex(g.stroke)}h.dashstyle=g["stroke-dasharray"]?"dash":"solid";h.joinstyle=g["stroke-linejoin"];h.endcap=g["stroke-linecap"]||"round";h.miterlimit=g["stroke-miterlimit"]||8;c=parseFloat(g["stroke-width"]||1)*0.75;a=g["stroke-opacity"]||1;if(Ext.isNumber(c)&&c<1){h.weight=1;h.opacity=a*c}else{h.weight=c;h.opacity=a}}if(f){d.appendChild(h)}},setClip:function(b,f){var e=this,c=b.el,a=b.clipEl,d=String(f["clip-rect"]).split(e.separatorRe);if(!a){a=b.clipEl=e.el.insertFirst(Ext.getDoc().dom.createElement("div"));a.addCls(Ext.baseCSSPrefix+"vml-sprite")}if(d.length==4){d[2]=+d[2]+(+d[0]);d[3]=+d[3]+(+d[1]);a.setStyle("clip",Ext.String.format("rect({1}px {2}px {3}px {0}px)",d[0],d[1],d[2],d[3]));a.setSize(e.el.width,e.el.height)}else{a.setStyle("clip","")}},setTextAttributes:function(h,c){var g=this,a=h.vml,e=a.textpath.style,f=g.span.style,i=g.zoom,j=Math.round,k={fontSize:"font-size",fontWeight:"font-weight",fontStyle:"font-style"},b,d;if(h.dirtyFont){if(c.font){e.font=f.font=c.font}if(c["font-family"]){e.fontFamily='"'+c["font-family"].split(",")[0].replace(g.fontFamilyRe,"")+'"';f.fontFamily=c["font-family"]}for(b in k){d=c[k[b]];if(d){e[b]=f[b]=d}}g.setText(h,c.text);if(a.textpath.string){g.span.innerHTML=String(a.textpath.string).replace(/</g,"&#60;").replace(/&/g,"&#38;").replace(/\n/g,"<br/>")}a.W=g.span.offsetWidth;a.H=g.span.offsetHeight+2;if(c["text-anchor"]=="middle"){e["v-text-align"]="center"}else{if(c["text-anchor"]=="end"){e["v-text-align"]="right";a.bbx=-Math.round(a.W/2)}else{e["v-text-align"]="left";a.bbx=Math.round(a.W/2)}}}a.X=c.x;a.Y=c.y;a.path.v=Ext.String.format("m{0},{1}l{2},{1}",Math.round(a.X*i),Math.round(a.Y*i),Math.round(a.X*i)+1);h.bbox.plain=null;h.bbox.transform=null;h.dirtyFont=false},setText:function(a,b){a.vml.textpath.string=Ext.htmlDecode(b)},hide:function(){this.el.hide()},show:function(){this.el.show()},hidePrim:function(a){a.el.addCls(Ext.baseCSSPrefix+"hide-visibility")},showPrim:function(a){a.el.removeCls(Ext.baseCSSPrefix+"hide-visibility")},setSize:function(b,a){var c=this;b=b||c.width;a=a||c.height;c.width=b;c.height=a;if(c.el){if(b!=undefined){c.el.setWidth(b)}if(a!=undefined){c.el.setHeight(a)}}c.callParent(arguments)},applyViewBox:function(){var f=this,g=f.viewBox,e=f.width,b=f.height,c,a,d;f.callParent();if(g&&(e||b)){c=f.items.items;a=c.length;for(d=0;d<a;d++){f.applyTransformations(c[d])}}},onAdd:function(a){this.callParent(arguments);if(this.el){this.renderItem(a)}},onRemove:function(a){if(a.el){a.el.remove();delete a.el}this.callParent(arguments)},render:function(a){var c=this,f=Ext.getDoc().dom,b;if(!c.createNode){try{if(!f.namespaces.rvml){f.namespaces.add("rvml","urn:schemas-microsoft-com:vml")}c.createNode=function(e){return f.createElement("<rvml:"+e+' class="rvml">')}}catch(d){c.createNode=function(e){return f.createElement("<"+e+' xmlns="urn:schemas-microsoft.com:vml" class="rvml">')}}}if(!c.el){b=f.createElement("div");c.el=Ext.get(b);c.el.addCls(c.baseVmlCls);c.span=f.createElement("span");Ext.get(c.span).addCls(c.measureSpanCls);b.appendChild(c.span);c.el.setSize(c.width||0,c.height||0);a.appendChild(b);c.el.on({scope:c,mouseup:c.onMouseUp,mousedown:c.onMouseDown,mouseover:c.onMouseOver,mouseout:c.onMouseOut,mousemove:c.onMouseMove,mouseenter:c.onMouseEnter,mouseleave:c.onMouseLeave,click:c.onClick,dblclick:c.onDblClick})}c.renderAll()},renderAll:function(){this.items.each(this.renderItem,this)},redraw:function(a){a.dirty=true;this.renderItem(a)},renderItem:function(a){if(!this.el){return}if(!a.el){this.createSpriteElement(a)}if(a.dirty){this.applyAttrs(a);if(a.dirtyTransform){this.applyTransformations(a)}}},rotationCompensation:function(d,c,a){var b=new Ext.draw.Matrix();b.rotate(-d,0.5,0.5);return{x:b.x(c,a),y:b.y(c,a)}},transform:function(w,H){var G=this,b=G.getBBox(w,true),h=b.x+b.width*0.5,g=b.y+b.height*0.5,A=new Ext.draw.Matrix(),p=w.transformations,u=p.length,B=0,n=0,d=1,c=1,m="",f=w.el,D=f.dom,x=D.style,a=G.zoom,j=w.skew,C=G.viewBoxShift,F,E,r,k,q,o,z,v,t,s,e,l;for(;B<u;B++){r=p[B];k=r.type;if(k=="translate"){A.translate(r.x,r.y)}else{if(k=="rotate"){A.rotate(r.degrees,r.x,r.y);n+=r.degrees}else{if(k=="scale"){A.scale(r.x,r.y,r.centerX,r.centerY);d*=r.x;c*=r.y}}}}w.matrix=A.clone();if(H){return}if(C){A.prepend(C.scale,0,0,C.scale,C.dx*C.scale,C.dy*C.scale)}if(w.type!="image"&&j){j.origin="0,0";j.matrix=A.toString();l=A.offset();if(l[0]>32767){l[0]=32767}else{if(l[0]<-32768){l[0]=-32768}}if(l[1]>32767){l[1]=32767}else{if(l[1]<-32768){l[1]=-32768}}j.offset=l}else{x.filter=A.toFilter();x.left=Math.min(A.x(b.x,b.y),A.x(b.x+b.width,b.y),A.x(b.x,b.y+b.height),A.x(b.x+b.width,b.y+b.height))+"px";x.top=Math.min(A.y(b.x,b.y),A.y(b.x+b.width,b.y),A.y(b.x,b.y+b.height),A.y(b.x+b.width,b.y+b.height))+"px"}},createItem:function(a){return Ext.create("Ext.draw.Sprite",a)},getRegion:function(){return this.el.getRegion()},addCls:function(a,b){if(a&&a.el){a.el.addCls(b)}},removeCls:function(a,b){if(a&&a.el){a.el.removeCls(b)}},addGradient:function(f){var d=this.gradientsColl||(this.gradientsColl=Ext.create("Ext.util.MixedCollection")),a=[],h=Ext.create("Ext.util.MixedCollection"),k,e,b,g,j,c;h.addAll(f.stops);h.sortByKey("ASC",function(l,i){l=parseInt(l,10);i=parseInt(i,10);return l>i?1:(l<i?-1:0)});k=h.keys;e=h.items;b=k.length;for(c=0;c<b;c++){g=k[c];j=e[c];a.push(g+"% "+j.color)}d.add(f.id,{colors:a.join(","),angle:f.angle})},destroy:function(){var a=this;a.callParent(arguments);if(a.el){a.el.remove()}delete a.el}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("Ext.ux.desktop.StartMenu",{extend:"Ext.panel.Panel",requires:["Ext.menu.Menu","Ext.toolbar.Toolbar"],ariaRole:"menu",cls:"x-menu ux-start-menu",defaultAlign:"bl-tl",iconCls:"user",floating:true,shadow:true,width:300,initComponent:function(){var a=this,b=a.menu;a.menu=new Ext.menu.Menu({cls:"ux-start-menu-body",border:false,floating:false,items:b});a.menu.layout.align="stretch";a.items=[a.menu];a.layout="fit";Ext.menu.Manager.register(a);a.callParent();a.toolbar=new Ext.toolbar.Toolbar(Ext.apply({dock:"right",cls:"ux-start-menu-toolbar",vertical:true,width:100},a.toolConfig));a.toolbar.layout.align="stretch";a.addDocked(a.toolbar);delete a.toolItems;a.on("deactivate",function(){a.hide()})},addMenuItem:function(){var a=this.menu;a.add.apply(a,arguments)},addToolItem:function(){var a=this.toolbar;a.add.apply(a,arguments)},showBy:function(c,f,e){var b=this;if(b.floating&&c){b.layout.autoSize=true;b.show();c=c.el||c;var d=b.el.getAlignToXY(c,f||b.defaultAlign,e);if(b.floatParent){var a=b.floatParent.getTargetEl().getViewRegion();d[0]-=a.x;d[1]-=a.y}b.showAt(d);b.doConstrain()}return b}});
/*
 * Ext JS Library 4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.define("Ext.ux.desktop.TaskBar",{extend:"Ext.toolbar.Toolbar",requires:["Ext.button.Button","Ext.resizer.Splitter","Ext.menu.Menu","Ext.ux.desktop.StartMenu"],alias:"widget.taskbar",cls:"ux-taskbar",startBtnText:"Start",initComponent:function(){var a=this;a.startMenu=new Ext.ux.desktop.StartMenu(a.startConfig);a.quickStart=new Ext.toolbar.Toolbar(a.getQuickStart());a.windowBar=new Ext.toolbar.Toolbar(a.getWindowBarConfig());a.tray=new Ext.toolbar.Toolbar(a.getTrayConfig());a.items=[{xtype:"button",cls:"ux-start-button",iconCls:"ux-start-button-icon",menu:a.startMenu,menuAlign:"bl-tl",text:a.startBtnText},a.quickStart,{xtype:"splitter",html:"&#160;",height:14,width:2,cls:"x-toolbar-separator x-toolbar-separator-horizontal"},a.windowBar,"-",a.tray];a.callParent()},afterLayout:function(){var a=this;a.callParent();a.windowBar.el.on("contextmenu",a.onButtonContextMenu,a)},getQuickStart:function(){var b=this,a={minWidth:20,width:60,items:[],enableOverflow:true};Ext.each(this.quickStart,function(c){a.items.push({tooltip:{text:c.name,align:"bl-tl"},overflowText:c.name,iconCls:c.iconCls,module:c.module,handler:b.onQuickStartClick,scope:b})});return a},getTrayConfig:function(){var a={width:80,items:this.trayItems};delete this.trayItems;return a},getWindowBarConfig:function(){return{flex:1,cls:"ux-desktop-windowbar",items:["&#160;"],layout:{overflowHandler:"Scroller"}}},getWindowBtnFromEl:function(a){var b=this.windowBar.getChildByElement(a);return b||null},onQuickStartClick:function(b){var a=this.app.getModule(b.module),c;if(a){c=a.createWindow();c.show()}},onButtonContextMenu:function(d){var c=this,b=d.getTarget(),a=c.getWindowBtnFromEl(b);if(a){d.stopEvent();c.windowMenu.theWin=a.win;c.windowMenu.showBy(b)}},onWindowBtnClick:function(a){var b=a.win;if(b.minimized||b.hidden){b.show()}else{if(b.active){b.minimize()}else{b.toFront()}}},addTaskButton:function(c){var a={iconCls:c.iconCls,enableToggle:true,toggleGroup:"all",width:140,margins:"0 2 0 3",text:Ext.util.Format.ellipsis(c.title,20),listeners:{click:this.onWindowBtnClick,scope:this},win:c};var b=this.windowBar.add(a);b.toggle(true);return b},removeTaskButton:function(a){var c,b=this;b.windowBar.items.each(function(d){if(d===a){c=d}return !c});if(c){b.windowBar.remove(c)}return c},setActiveButton:function(a){if(a){a.toggle(true)}else{this.windowBar.items.each(function(b){if(b.isButton){b.toggle(false)}})}}});Ext.define("Ext.ux.desktop.TrayClock",{extend:"Ext.toolbar.TextItem",alias:"widget.trayclock",cls:"ux-desktop-trayclock",html:"&#160;",timeFormat:"g:i A",tpl:"{time}",initComponent:function(){var a=this;a.callParent();if(typeof(a.tpl)=="string"){a.tpl=new Ext.XTemplate(a.tpl)}},afterRender:function(){var a=this;Ext.Function.defer(a.updateTime,100,a);a.callParent()},onDestroy:function(){var a=this;if(a.timer){window.clearTimeout(a.timer);a.timer=null}a.callParent()},updateTime:function(){var a=this,b=Ext.Date.format(new Date(),a.timeFormat),c=a.tpl.apply({time:b});if(a.lastText!=c){a.setText(c);a.lastText=c}a.timer=Ext.Function.defer(a.updateTime,10000,a)}});Ext.define("Ext.resizer.ResizeTracker",{extend:"Ext.dd.DragTracker",dynamic:true,preserveRatio:false,constrainTo:null,proxyCls:Ext.baseCSSPrefix+"resizable-proxy",constructor:function(b){var d=this,c,a,e;if(!b.el){if(b.target.isComponent){d.el=b.target.getEl()}else{d.el=b.target}}this.callParent(arguments);if(d.preserveRatio&&d.minWidth&&d.minHeight){c=d.minWidth/d.el.getWidth();a=d.minHeight/d.el.getHeight();if(a>c){d.minWidth=d.el.getWidth()*a}else{d.minHeight=d.el.getHeight()*c}}if(d.throttle){e=Ext.Function.createThrottled(function(){Ext.resizer.ResizeTracker.prototype.resize.apply(d,arguments)},d.throttle);d.resize=function(g,h,f){if(f){Ext.resizer.ResizeTracker.prototype.resize.apply(d,arguments)}else{e.apply(null,arguments)}}}},onBeforeStart:function(a){this.startBox=this.el.getBox()},getDynamicTarget:function(){var a=this,b=a.target;if(a.dynamic){return b}else{if(!a.proxy){a.proxy=a.createProxy(b)}}a.proxy.show();return a.proxy},createProxy:function(c){var b,a=this.proxyCls,d;if(c.isComponent){b=c.getProxy().addCls(a)}else{d=Ext.getBody();if(Ext.scopeResetCSS){d=Ext.getBody().createChild({cls:Ext.resetCls})}b=c.createProxy({tag:"div",cls:a,id:c.id+"-rzproxy"},d)}b.removeCls(Ext.baseCSSPrefix+"proxy-el");return b},onStart:function(a){this.activeResizeHandle=Ext.get(this.getDragTarget().id);if(!this.dynamic){this.resize(this.startBox,{horizontal:"none",vertical:"none"})}},onDrag:function(a){if(this.dynamic||this.proxy){this.updateDimensions(a)}},updateDimensions:function(r,l){var s=this,c=s.activeResizeHandle.region,f=s.getOffset(s.constrainTo?"dragTarget":null),j=s.startBox,g,o=0,t=0,i,p,a=0,v=0,u,m=f[0]<0?"right":"left",q=f[1]<0?"down":"up",h,b,d,n,k;switch(c){case"south":t=f[1];b=2;break;case"north":t=-f[1];v=-t;b=2;break;case"east":o=f[0];b=1;break;case"west":o=-f[0];a=-o;b=1;break;case"northeast":t=-f[1];v=-t;o=f[0];h=[j.x,j.y+j.height];b=3;break;case"southeast":t=f[1];o=f[0];h=[j.x,j.y];b=3;break;case"southwest":o=-f[0];a=-o;t=f[1];h=[j.x+j.width,j.y];b=3;break;case"northwest":t=-f[1];v=-t;o=-f[0];a=-o;h=[j.x+j.width,j.y+j.height];b=3;break}d={width:j.width+o,height:j.height+t,x:j.x+a,y:j.y+v};i=Ext.Number.snap(d.width,s.widthIncrement);p=Ext.Number.snap(d.height,s.heightIncrement);if(i!=d.width||p!=d.height){switch(c){case"northeast":d.y-=p-d.height;break;case"north":d.y-=p-d.height;break;case"southwest":d.x-=i-d.width;break;case"west":d.x-=i-d.width;break;case"northwest":d.x-=i-d.width;d.y-=p-d.height}d.width=i;d.height=p}if(d.width<s.minWidth||d.width>s.maxWidth){d.width=Ext.Number.constrain(d.width,s.minWidth,s.maxWidth);if(a){d.x=j.x+(j.width-d.width)}}else{s.lastX=d.x}if(d.height<s.minHeight||d.height>s.maxHeight){d.height=Ext.Number.constrain(d.height,s.minHeight,s.maxHeight);if(v){d.y=j.y+(j.height-d.height)}}else{s.lastY=d.y}if(s.preserveRatio||r.shiftKey){g=s.startBox.width/s.startBox.height;n=Math.min(Math.max(s.minHeight,d.width/g),s.maxHeight);k=Math.min(Math.max(s.minWidth,d.height*g),s.maxWidth);if(b==1){d.height=n}else{if(b==2){d.width=k}else{u=Math.abs(h[0]-this.lastXY[0])/Math.abs(h[1]-this.lastXY[1]);if(u>g){d.height=n}else{d.width=k}if(c=="northeast"){d.y=j.y-(d.height-j.height)}else{if(c=="northwest"){d.y=j.y-(d.height-j.height);d.x=j.x-(d.width-j.width)}else{if(c=="southwest"){d.x=j.x-(d.width-j.width)}}}}}}if(t===0){q="none"}if(o===0){m="none"}s.resize(d,{horizontal:m,vertical:q},l)},getResizeTarget:function(a){return a?this.target:this.getDynamicTarget()},resize:function(b,d,a){var c=this.getResizeTarget(a);if(c.isComponent){c.setSize(b.width,b.height);if(c.floating){c.setPagePosition(b.x,b.y)}}else{c.setBox(b)}c=this.originalTarget;if(c&&(this.dynamic||a)){if(c.isComponent){c.setSize(b.width,b.height);if(c.floating){c.setPagePosition(b.x,b.y)}}else{c.setBox(b)}}},onEnd:function(a){this.updateDimensions(a,true);if(this.proxy){this.proxy.hide()}}});Ext.define("Ext.resizer.SplitterTracker",{extend:"Ext.dd.DragTracker",requires:["Ext.util.Region"],enabled:true,overlayCls:Ext.baseCSSPrefix+"resizable-overlay",createDragOverlay:function(){var a;a=this.overlay=Ext.getBody().createChild({cls:this.overlayCls,html:"&#160;"});a.unselectable();a.setSize(Ext.Element.getViewWidth(true),Ext.Element.getViewHeight(true));a.show()},getPrevCmp:function(){var a=this.getSplitter();return a.previousSibling()},getNextCmp:function(){var a=this.getSplitter();return a.nextSibling()},onBeforeStart:function(h){var d=this,f=d.getPrevCmp(),a=d.getNextCmp(),c=d.getSplitter().collapseEl,g=h.getTarget(),b;if(c&&g===d.getSplitter().collapseEl.dom){return false}if(a.collapsed||f.collapsed){return false}d.prevBox=f.getEl().getBox();d.nextBox=a.getEl().getBox();d.constrainTo=b=d.calculateConstrainRegion();if(!b){return false}d.createDragOverlay();return b},onStart:function(b){var a=this.getSplitter();a.addCls(a.baseCls+"-active")},calculateConstrainRegion:function(){var f=this,a=f.getSplitter(),g=a.getWidth(),h=a.defaultSplitMin,b=a.orientation,d=f.prevBox,i=f.getPrevCmp(),c=f.nextBox,e=f.getNextCmp(),k,j;if(b==="vertical"){k=new Ext.util.Region(d.y,(i.maxWidth?d.x+i.maxWidth:c.right-(e.minWidth||h))+g,d.bottom,d.x+(i.minWidth||h));j=new Ext.util.Region(c.y,c.right-(e.minWidth||h),c.bottom,(e.maxWidth?c.right-e.maxWidth:d.x+(d.minWidth||h))-g)}else{k=new Ext.util.Region(d.y+(i.minHeight||h),d.right,(i.maxHeight?d.y+i.maxHeight:c.bottom-(e.minHeight||h))+g,d.x);j=new Ext.util.Region((e.maxHeight?c.bottom-e.maxHeight:d.y+(i.minHeight||h))-g,c.right,c.bottom-(e.minHeight||h),c.x)}return k.intersect(j)},performResize:function(l,f){var n=this,a=n.getSplitter(),g=a.orientation,o=n.getPrevCmp(),m=n.getNextCmp(),b=a.ownerCt,j=b.query(">[flex]"),k=j.length,h=0,d,p,c=0;for(;h<k;h++){p=j[h].getWidth();c+=p;j[h].flex=p}f=f||n.getOffset("dragTarget");if(g==="vertical"){f=f[0];d="width"}else{d="height";f=f[1]}if(o){p=n.prevBox[d]+f;if(o.flex){o.flex=p}else{o[d]=p}}if(m){p=n.nextBox[d]-f;if(m.flex){m.flex=p}else{m[d]=p}}b.updateLayout()},endDrag:function(){var a=this;if(a.overlay){a.overlay.remove();delete a.overlay}a.callParent(arguments)},onEnd:function(c){var a=this,b=a.getSplitter();b.removeCls(b.baseCls+"-active");a.performResize(c,a.getOffset("dragTarget"))},onDrag:function(f){var c=this,g=c.getOffset("dragTarget"),d=c.getSplitter(),b=d.getEl(),a=d.orientation;if(a==="vertical"){b.setX(c.startRegion.left+g[0])}else{b.setY(c.startRegion.top+g[1])}},getSplitter:function(){return this.splitter}});Ext.define("Ext.resizer.BorderSplitterTracker",{extend:"Ext.resizer.SplitterTracker",requires:["Ext.util.Region"],getPrevCmp:null,getNextCmp:null,calculateConstrainRegion:function(){var x=this,a=x.splitter,n=a.collapseTarget,d=a.defaultSplitMin,g=a.vertical?"Width":"Height",c="min"+g,t="max"+g,h="get"+g,s=a.neighbors,e=s.length,m=n.el.getBox(),f=m.x,o=m.y,w=m.right,j=m.bottom,q=a.vertical?(w-f):(j-o),v,k,l,u,r,p,b;l=(n[c]||Math.min(q,d))-q;u=n[t];if(!u){u=1000000000}else{u-=q}b=q;for(v=0;v<e;++v){k=s[v];q=k[h]();r=q-k[t];p=q-(k[c]||Math.min(q,d));if(!isNaN(r)){if(l<r){l=r}}if(u>p){u=p}}if(u-l<2){return null}m=new Ext.util.Region(o,w,j,f);x.constraintAdjusters[a.collapseDirection](m,l,u,a);x.dragInfo={minRange:l,maxRange:u,targetSize:b};return m},constraintAdjusters:{left:function(c,a,b,d){c[0]=c.x=c.left=c.right+a;c.right+=b+d.getWidth()},top:function(c,a,b,d){c[1]=c.y=c.top=c.bottom+a;c.bottom+=b+d.getHeight()},bottom:function(c,a,b,d){c.bottom=c.top-a;c.top-=b+d.getHeight()},right:function(c,a,b,d){c.right=c.left-a;c.left-=b+d.getWidth()}},onBeforeStart:function(g){var j=this,b=j.splitter,a=b.collapseTarget,l=b.neighbors,d=j.getSplitter().collapseEl,h=g.getTarget(),c=l.length,f,k;if(d&&h===b.collapseEl.dom){return false}if(a.collapsed){return false}for(f=0;f<c;++f){k=l[f];if(k.collapsed&&k.isHorz===a.isHorz){return false}}if(!(j.constrainTo=j.calculateConstrainRegion())){return false}j.createDragOverlay();return true},performResize:function(i,h){var j=this,b=j.splitter,g=b.collapseDirection,a=b.collapseTarget,f=j.splitAdjusters[b.vertical?"horz":"vert"],k=h[f.index],d=j.dragInfo,c;if(g=="right"||g=="bottom"){k=-k}k=Math.min(Math.max(d.minRange,k),d.maxRange);if(k){(c=b.ownerCt).suspendLayouts();f.adjustTarget(a,d.targetSize,k);c.resumeLayouts(true)}},splitAdjusters:{horz:{index:0,adjustTarget:function(b,a,c){b.flex=null;b.setSize(a+c)}},vert:{index:1,adjustTarget:function(b,a,c){b.flex=null;b.setSize(undefined,a+c)}}}});Ext.define("Ext.ShadowPool",{singleton:true,requires:["Ext.DomHelper"],markup:(function(){return Ext.String.format('<div class="{0}{1}-shadow" role="presentation"></div>',Ext.baseCSSPrefix,Ext.isIE&&!Ext.supports.CSS3BoxShadow?"ie":"css")}()),shadows:[],pull:function(){var a=this.shadows.shift();if(!a){a=Ext.get(Ext.DomHelper.insertHtml("beforeBegin",document.body.firstChild,this.markup));a.autoBoxAdjust=false}return a},push:function(a){this.shadows.push(a)},reset:function(){var c=[].concat(this.shadows),b,a=c.length;for(b=0;b<a;b++){c[b].remove()}this.shadows=[]}});Ext.define("Ext.Shadow",{requires:["Ext.ShadowPool"],constructor:function(b){var c=this,d,e,a;Ext.apply(c,b);if(!Ext.isString(c.mode)){c.mode=c.defaultMode}e=c.offset;a=Math.floor(e/2);c.opacity=50;switch(c.mode.toLowerCase()){case"drop":if(Ext.supports.CSS3BoxShadow){d={t:e,l:e,h:-e,w:-e}}else{d={t:-a,l:-a,h:-a,w:-a}}break;case"sides":if(Ext.supports.CSS3BoxShadow){d={t:e,l:0,h:-e,w:0}}else{d={t:-(1+a),l:1+a-2*e,h:-1,w:a-1}}break;case"frame":if(Ext.supports.CSS3BoxShadow){d={t:0,l:0,h:0,w:0}}else{d={t:1+a-2*e,l:1+a-2*e,h:e-a-1,w:e-a-1}}break}c.adjusts=d},getShadowSize:function(){var b=this,d=b.el?b.offset:0,a=[d,d,d,d],c=b.mode.toLowerCase();if(b.el&&c!=="frame"){a[0]=0;if(c=="drop"){a[3]=0}}return a},offset:4,defaultMode:"drop",boxShadowProperty:(function(){var b="boxShadow",a=document.documentElement.style;if(!("boxShadow" in a)){if("WebkitBoxShadow" in a){b="WebkitBoxShadow"}else{if("MozBoxShadow" in a){b="MozBoxShadow"}}}return b}()),show:function(c){var b=this,a;c=Ext.get(c);if(!b.el){b.el=Ext.ShadowPool.pull();if(b.el.dom.nextSibling!=c.dom){b.el.insertBefore(c)}}a=(parseInt(c.getStyle("z-index"),10)-1)||0;b.el.setStyle("z-index",b.zIndex||a);if(Ext.isIE&&!Ext.supports.CSS3BoxShadow){b.el.dom.style.filter="progid:DXImageTransform.Microsoft.alpha(opacity="+b.opacity+") progid:DXImageTransform.Microsoft.Blur(pixelradius="+(b.offset)+")"}b.realign(c.getLocalX(),c.getLocalY(),c.dom.offsetWidth,c.dom.offsetHeight);b.el.dom.style.display="block"},isVisible:function(){return this.el?true:false},realign:function(b,m,j,f){if(!this.el){return}var a=this.adjusts,h=this.el.dom,i=h.style,c,e,g,k;i.left=(b+a.l)+"px";i.top=(m+a.t)+"px";c=Math.max(j+a.w,0);e=Math.max(f+a.h,0);g=c+"px";k=e+"px";if(i.width!=g||i.height!=k){i.width=g;i.height=k;if(Ext.supports.CSS3BoxShadow){i[this.boxShadowProperty]="0 0 "+this.offset+"px #888"}}},hide:function(){var a=this;if(a.el){a.el.dom.style.display="none";Ext.ShadowPool.push(a.el);delete a.el}},setZIndex:function(a){this.zIndex=a;if(this.el){this.el.setStyle("z-index",a)}},setOpacity:function(a){if(this.el){if(Ext.isIE&&!Ext.supports.CSS3BoxShadow){a=Math.floor(a*100/2)/100}this.opacity=a;this.el.setOpacity(a)}}});
