Ext.data.JsonP.Ext_grid_feature_GroupingSummary({"alternateClassNames":[],"aliases":{"feature":["groupingsummary"]},"enum":null,"parentMixins":["Ext.grid.feature.AbstractSummary"],"tagname":"class","subclasses":[],"extends":"Ext.grid.feature.Grouping","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><a href='#!/api/Ext.grid.feature.Feature' rel='Ext.grid.feature.Feature' class='docClass'>Ext.grid.feature.Feature</a><div class='subclass '><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='docClass'>Ext.grid.feature.Grouping</a><div class='subclass '><strong>Ext.grid.feature.GroupingSummary</strong></div></div></div></div></div><h4>Inherited mixins</h4><div class='dependency'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='docClass'>Ext.grid.feature.AbstractSummary</a></div><h4>Files</h4><div class='dependency'><a href='source/GroupingSummary.html#Ext-grid-feature-GroupingSummary' target='_blank'>GroupingSummary.js</a></div></pre><div class='doc-contents'><p>This feature adds an aggregate summary row at the bottom of each group that is provided\nby the <a href=\"#!/api/Ext.grid.feature.Grouping\" rel=\"Ext.grid.feature.Grouping\" class=\"docClass\">Ext.grid.feature.Grouping</a> feature. There are two aspects to the summary:</p>\n\n<h2>Calculation</h2>\n\n<p>The summary value needs to be calculated for each column in the grid. This is controlled\nby the summaryType option specified on the column. There are several built in summary types,\nwhich can be specified as a string on the column configuration. These call underlying methods\non the store:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.data.Store-method-count\" rel=\"Ext.data.Store-method-count\" class=\"docClass\">count</a></li>\n<li><a href=\"#!/api/Ext.data.Store-method-sum\" rel=\"Ext.data.Store-method-sum\" class=\"docClass\">sum</a></li>\n<li><a href=\"#!/api/Ext.data.Store-method-min\" rel=\"Ext.data.Store-method-min\" class=\"docClass\">min</a></li>\n<li><a href=\"#!/api/Ext.data.Store-method-max\" rel=\"Ext.data.Store-method-max\" class=\"docClass\">max</a></li>\n<li><a href=\"#!/api/Ext.data.Store-method-average\" rel=\"Ext.data.Store-method-average\" class=\"docClass\">average</a></li>\n</ul>\n\n\n<p>Alternatively, the summaryType can be a function definition. If this is the case,\nthe function is called with an array of records to calculate the summary value.</p>\n\n<h2>Rendering</h2>\n\n<p>Similar to a column, the summary also supports a summaryRenderer function. This\nsummaryRenderer is called before displaying a value. The function is optional, if\nnot specified the default calculated value is shown. The summaryRenderer is called with:</p>\n\n<ul>\n<li>value {Object} - The calculated value.</li>\n<li>summaryData {Object} - Contains all raw summary values for the row.</li>\n<li>field {String} - The name of the field we are calculating</li>\n</ul>\n\n\n<h2>Example Usage</h2>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('TestResult', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['student', 'subject', {\n        name: 'mark',\n        type: 'int'\n    }]\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Ext.grid.Panel</a>', {\n    width: 200,\n    height: 240,\n    renderTo: document.body,\n    features: [{\n        groupHeaderTpl: 'Subject: {name}',\n        ftype: 'groupingsummary'\n    }],\n    store: {\n        model: 'TestResult',\n        groupField: 'subject',\n        data: [{\n            student: 'Student 1',\n            subject: 'Math',\n            mark: 84\n        },{\n            student: 'Student 1',\n            subject: 'Science',\n            mark: 72\n        },{\n            student: 'Student 2',\n            subject: 'Math',\n            mark: 96\n        },{\n            student: 'Student 2',\n            subject: 'Science',\n            mark: 68\n        }]\n    },\n    columns: [{\n        dataIndex: 'student',\n        text: 'Name',\n        summaryType: 'count',\n        summaryRenderer: function(value){\n            return <a href=\"#!/api/Ext.String-method-format\" rel=\"Ext.String-method-format\" class=\"docClass\">Ext.String.format</a>('{0} student{1}', value, value !== 1 ? 's' : '');\n        }\n    }, {\n        dataIndex: 'mark',\n        text: 'Mark',\n        summaryType: 'average'\n    }]\n});\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-collapsible' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-cfg-collapsible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-cfg-collapsible' class='name expandable'>collapsible</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Set to false to disable collapsing groups from the UI. ...</div><div class='long'><p>Set to <code>false</code> to disable collapsing groups from the UI.</p>\n\n<p>This is set to <code>false</code> when the associated <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a> is\n<a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-depthToIndent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-cfg-depthToIndent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-cfg-depthToIndent' class='name expandable'>depthToIndent</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Number of pixels to indent per grouping level ...</div><div class='long'><p>Number of pixels to indent per grouping level</p>\n<p>Defaults to: <code>17</code></p></div></div></div><div id='cfg-enableGroupingMenu' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-cfg-enableGroupingMenu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-cfg-enableGroupingMenu' class='name expandable'>enableGroupingMenu</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to enable the grouping control in the header menu. ...</div><div class='long'><p>True to enable the grouping control in the header menu.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-enableNoGroups' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-cfg-enableNoGroups' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-cfg-enableNoGroups' class='name expandable'>enableNoGroups</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to allow the user to turn off grouping. ...</div><div class='long'><p>True to allow the user to turn off grouping.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-groupByText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-cfg-groupByText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-cfg-groupByText' class='name expandable'>groupByText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Text displayed in the grid header menu for grouping by header. ...</div><div class='long'><p>Text displayed in the grid header menu for grouping by header.</p>\n<p>Defaults to: <code>&quot;Group by this field&quot;</code></p></div></div></div><div id='cfg-groupHeaderTpl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-cfg-groupHeaderTpl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-cfg-groupHeaderTpl' class='name expandable'>groupHeaderTpl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a></span></div><div class='description'><div class='short'>A string Template snippet, an array of strings (optionally followed by an object containing Template methods) to be u...</div><div class='long'><p>A string Template snippet, an array of strings (optionally followed by an object containing Template methods) to be used to construct a Template, or a Template instance.</p>\n\n<ul>\n<li><p>Example 1 (Template snippet):</p>\n\n<pre><code>groupHeaderTpl: 'Group: {name}'\n</code></pre></li>\n<li><p>Example 2 (Array):</p>\n\n<pre><code>groupHeaderTpl: [\n    'Group: ',\n    '&lt;div&gt;{name:this.formatName}&lt;/div&gt;',\n    {\n        formatName: function(name) {\n            return <a href=\"#!/api/Ext.String-method-trim\" rel=\"Ext.String-method-trim\" class=\"docClass\">Ext.String.trim</a>(name);\n        }\n    }\n]\n</code></pre></li>\n<li><p>Example 3 (Template Instance):</p>\n\n<pre><code>groupHeaderTpl: <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>',\n    'Group: ',\n    '&lt;div&gt;{name:this.formatName}&lt;/div&gt;',\n    {\n        formatName: function(name) {\n            return <a href=\"#!/api/Ext.String-method-trim\" rel=\"Ext.String-method-trim\" class=\"docClass\">Ext.String.trim</a>(name);\n        }\n    }\n)\n</code></pre></li>\n</ul>\n\n<p>Defaults to: <code>'{columnName}: {name}'</code></p><ul><li><span class='pre'>groupField</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The field name being grouped by.</p>\n</div></li><li><span class='pre'>columnName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The column header associated with the field being grouped by <em>if there is a column for the field</em>, falls back to the groupField name.</p>\n</div></li><li><span class='pre'>groupValue</span> : Mixed<div class='sub-desc'><p>The value of the <a href=\"#!/api/Ext.data.Store-cfg-groupField\" rel=\"Ext.data.Store-cfg-groupField\" class=\"docClass\">groupField</a> for the group header being rendered.</p>\n</div></li><li><span class='pre'>renderedGroupValue</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The rendered value of the <a href=\"#!/api/Ext.data.Store-cfg-groupField\" rel=\"Ext.data.Store-cfg-groupField\" class=\"docClass\">groupField</a> for the group header being rendered, as produced by the column renderer.</p>\n</div></li><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>An alias for renderedGroupValue</p>\n</div></li><li><span class='pre'>rows</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>[]<div class='sub-desc'><p>Deprecated - use children instead. An array containing the child records for the group being rendered. <em>Not available if the store is <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a></em></p>\n</div></li><li><span class='pre'>children</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>[]<div class='sub-desc'><p>An array containing the child records for the group being rendered. <em>Not available if the store is <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a></em></p>\n</div></li></ul></div></div></div><div id='cfg-hideGroupedHeader' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-cfg-hideGroupedHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-cfg-hideGroupedHeader' class='name expandable'>hideGroupedHeader</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to hide the header that is currently grouped. ...</div><div class='long'><p>True to hide the header that is currently grouped.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>A config object containing one or more event handlers to be added to this object during initialization. ...</div><div class='long'><p>A config object containing one or more event handlers to be added to this object during initialization. This\nshould be a valid listeners config object as specified in the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple\nhandlers at once.</p>\n\n<p><strong>DOM events from Ext JS <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></strong></p>\n\n<p>While <em>some</em> Ext JS Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this is usually\nonly done when extra value can be added. For example the <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">DataView</a>'s <strong><code><a href=\"#!/api/Ext.view.View-event-itemclick\" rel=\"Ext.view.View-event-itemclick\" class=\"docClass\">itemclick</a></code></strong> event passing the node clicked on. To access DOM events directly from a\nchild element of a Component, we need to specify the <code>element</code> option to identify the Component property to add a\nDOM listener to:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    width: 400,\n    height: 200,\n    dockedItems: [{\n        xtype: 'toolbar'\n    }],\n    listeners: {\n        click: {\n            element: 'el', //bind to the underlying el property on the panel\n            fn: function(){ console.log('click el'); }\n        },\n        dblclick: {\n            element: 'body', //bind to the underlying body property on the panel\n            fn: function(){ console.log('dblclick body'); }\n        }\n    }\n});\n</code></pre>\n</div></div></div><div id='cfg-remoteRoot' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-cfg-remoteRoot' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-cfg-remoteRoot' class='name expandable'>remoteRoot</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the property which contains the Array of summary objects. ...</div><div class='long'><p>The name of the property which contains the Array of summary objects.\nIt allows to use server-side calculated summaries.</p>\n</div></div></div><div id='cfg-showGroupsText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-cfg-showGroupsText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-cfg-showGroupsText' class='name expandable'>showGroupsText</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Text displayed in the grid header for enabling/disabling grouping. ...</div><div class='long'><p>Text displayed in the grid header for enabling/disabling grouping.</p>\n<p>Defaults to: <code>&quot;Show in groups&quot;</code></p></div></div></div><div id='cfg-showSummaryRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.feature.GroupingSummary'>Ext.grid.feature.GroupingSummary</span><br/><a href='source/GroupingSummary.html#Ext-grid-feature-GroupingSummary-cfg-showSummaryRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.GroupingSummary-cfg-showSummaryRow' class='name expandable'>showSummaryRow</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to show the summary row. ...</div><div class='long'><p>True to show the summary row.</p>\n<p>Defaults to: <code>true</code></p><p>Overrides: <a href='#!/api/Ext.grid.feature.Grouping-cfg-showSummaryRow' rel='Ext.grid.feature.Grouping-cfg-showSummaryRow' class='docClass'>Ext.grid.feature.Grouping.showSummaryRow</a></p></div></div></div><div id='cfg-startCollapsed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-cfg-startCollapsed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-cfg-startCollapsed' class='name expandable'>startCollapsed</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to start all groups collapsed. ...</div><div class='long'><p>True to start all groups collapsed.</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Properties</h3><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-property-S-className' class='name expandable'>$className</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'Ext.Base'</code></p></div></div></div><div id='property-collapseTip' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-collapseTip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-collapseTip' class='name expandable'>collapseTip</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'><p><locale></p>\n<p>Defaults to: <code>'Click to collapse. CTRL/click collapses all others'</code></p></div></div></div><div id='property-collapsedCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-collapsedCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-collapsedCls' class='name expandable'>collapsedCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>Ext.baseCSSPrefix + 'grid-group-collapsed'</code></p></div></div></div><div id='property-collapsibleCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-collapsibleCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-collapsibleCls' class='name expandable'>collapsibleCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>Ext.baseCSSPrefix + 'grid-group-hd-collapsible'</code></p></div></div></div><div id='property-configMap' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-property-configMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-property-configMap' class='name expandable'>configMap</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-ctCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-ctCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-ctCls' class='name expandable'>ctCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>Ext.baseCSSPrefix + 'group-hd-container'</code></p></div></div></div><div id='property-disabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Feature' rel='Ext.grid.feature.Feature' class='defined-in docClass'>Ext.grid.feature.Feature</a><br/><a href='source/Feature.html#Ext-grid-feature-Feature-property-disabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Feature-property-disabled' class='name expandable'>disabled</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True when feature is disabled. ...</div><div class='long'><p>True when feature is disabled.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-eventPrefix' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-eventPrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-eventPrefix' class='name expandable'>eventPrefix</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Prefix to use when firing events on the view. ...</div><div class='long'><p>Prefix to use when firing events on the view.\nFor example a prefix of group would expose \"groupclick\", \"groupcontextmenu\", \"groupdblclick\".</p>\n<p>Defaults to: <code>'group'</code></p><p>Overrides: <a href='#!/api/Ext.grid.feature.Feature-property-eventPrefix' rel='Ext.grid.feature.Feature-property-eventPrefix' class='docClass'>Ext.grid.feature.Feature.eventPrefix</a></p></div></div></div><div id='property-eventSelector' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-eventSelector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-eventSelector' class='name expandable'>eventSelector</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Selector used to determine when to fire the event with the eventPrefix. ...</div><div class='long'><p>Selector used to determine when to fire the event with the eventPrefix.</p>\n<p>Defaults to: <code>'.' + Ext.baseCSSPrefix + 'grid-group-hd'</code></p><p>Overrides: <a href='#!/api/Ext.grid.feature.Feature-property-eventSelector' rel='Ext.grid.feature.Feature-property-eventSelector' class='docClass'>Ext.grid.feature.Feature.eventSelector</a></p></div></div></div><div id='property-eventsSuspended' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-property-eventsSuspended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-property-eventsSuspended' class='name expandable'>eventsSuspended</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Initial suspended call count. ...</div><div class='long'><p>Initial suspended call count. Incremented when <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a> is called, decremented when <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> is called.</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-expandTip' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-expandTip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-expandTip' class='name expandable'>expandTip</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'><p><locale></p>\n<p>Defaults to: <code>'Click to expand. CTRL key collapses all others'</code></p></div></div></div><div id='property-grid' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Feature' rel='Ext.grid.feature.Feature' class='defined-in docClass'>Ext.grid.feature.Feature</a><br/><a href='source/Feature.html#Ext-grid-feature-Feature-property-grid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Feature-property-grid' class='name not-expandable'>grid</a><span> : <a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Ext.grid.Panel</a></span></div><div class='description'><div class='short'><p>Reference to the grid panel</p>\n</div><div class='long'><p>Reference to the grid panel</p>\n</div></div></div><div id='property-groupCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-groupCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-groupCls' class='name expandable'>groupCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>Ext.baseCSSPrefix + 'grid-group-hd'</code></p></div></div></div><div id='property-groupInfo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-groupInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-groupInfo' class='name expandable'>groupInfo</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-groupTpl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-groupTpl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-groupTpl' class='name not-expandable'>groupTpl</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-hasFeatureEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Feature' rel='Ext.grid.feature.Feature' class='defined-in docClass'>Ext.grid.feature.Feature</a><br/><a href='source/Feature.html#Ext-grid-feature-Feature-property-hasFeatureEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Feature-property-hasFeatureEvent' class='name expandable'>hasFeatureEvent</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Most features will expose additional events, some may not and will\nneed to change this to false. ...</div><div class='long'><p>Most features will expose additional events, some may not and will\nneed to change this to false.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-hasListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-property-hasListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-property-hasListeners' class='name expandable'>hasListeners</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='readonly signature' >readonly</strong></div><div class='description'><div class='short'>This object holds a key for any event that has a listener. ...</div><div class='long'><p>This object holds a key for any event that has a listener. The listener may be set\ndirectly on the instance, or on its class or a super class (via <a href=\"#!/api/Ext.util.Observable-static-method-observe\" rel=\"Ext.util.Observable-static-method-observe\" class=\"docClass\">observe</a>) or\non the <a href=\"#!/api/Ext.app.EventBus\" rel=\"Ext.app.EventBus\" class=\"docClass\">MVC EventBus</a>. The values of this object are truthy\n(a non-zero number) and falsy (0 or undefined). They do not represent an exact count\nof listeners. The value for an event is truthy if the event must be fired and is\nfalsy if there is no need to fire the event.</p>\n\n<p>The intended use of this property is to avoid the expense of fireEvent calls when\nthere are no listeners. This can be particularly helpful when one would otherwise\nhave to call fireEvent hundreds or thousands of times. It is used like this:</p>\n\n<pre><code> if (this.hasListeners.foo) {\n     this.fireEvent('foo', this, arg1);\n }\n</code></pre>\n</div></div></div><div id='property-hdCollapsedCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-hdCollapsedCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-hdCollapsedCls' class='name expandable'>hdCollapsedCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>Ext.baseCSSPrefix + 'grid-group-hd-collapsed'</code></p></div></div></div><div id='property-hdNotCollapsibleCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-hdNotCollapsibleCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-hdNotCollapsibleCls' class='name expandable'>hdNotCollapsibleCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>Ext.baseCSSPrefix + 'grid-group-hd-not-collapsible'</code></p></div></div></div><div id='property-initConfigList' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-property-initConfigList' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-property-initConfigList' class='name expandable'>initConfigList</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-initConfigMap' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-property-initConfigMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-property-initConfigMap' class='name expandable'>initConfigMap</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-isFeature' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Feature' rel='Ext.grid.feature.Feature' class='defined-in docClass'>Ext.grid.feature.Feature</a><br/><a href='source/Feature.html#Ext-grid-feature-Feature-property-isFeature' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Feature-property-isFeature' class='name expandable'>isFeature</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>true in this class to identify an object as an instantiated Feature, or subclass thereof. ...</div><div class='long'><p><code>true</code> in this class to identify an object as an instantiated Feature, or subclass thereof.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-isInstance' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-property-isInstance' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-property-isInstance' class='name expandable'>isInstance</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-isObservable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-property-isObservable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-property-isObservable' class='name expandable'>isObservable</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>true in this class to identify an object as an instantiated Observable, or subclass thereof. ...</div><div class='long'><p><code>true</code> in this class to identify an object as an instantiated Observable, or subclass thereof.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-refreshData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-refreshData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-refreshData' class='name expandable'>refreshData</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-self' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-property-self' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); // dependent on 'this'\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div><div id='property-summaryRowCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-property-summaryRowCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-property-summaryRowCls' class='name expandable'>summaryRowCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>Ext.baseCSSPrefix + 'grid-row-summary'</code></p></div></div></div><div id='property-summaryRowSelector' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-property-summaryRowSelector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-property-summaryRowSelector' class='name expandable'>summaryRowSelector</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'.' + Ext.baseCSSPrefix + 'grid-row-summary'</code></p></div></div></div><div id='property-summaryRowTpl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-property-summaryRowTpl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-property-summaryRowTpl' class='name expandable'>summaryRowTpl</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>High priority rowTpl interceptor which sees summary rows early, and renders them correctly and then aborts the row re...</div><div class='long'><p>High priority rowTpl interceptor which sees summary rows early, and renders them correctly and then aborts the row rendering chain.\nThis will only see action when summary rows are being updated and Table.onUpdate->Table.bufferRender renders the individual updated sumary row.</p>\n</div></div></div><div id='property-summaryTableCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-property-summaryTableCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-property-summaryTableCls' class='name not-expandable'>summaryTableCls</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-tableTpl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-tableTpl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-tableTpl' class='name not-expandable'>tableTpl</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-view' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Feature' rel='Ext.grid.feature.Feature' class='defined-in docClass'>Ext.grid.feature.Feature</a><br/><a href='source/Feature.html#Ext-grid-feature-Feature-property-view' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Feature-property-view' class='name not-expandable'>view</a><span> : <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a></span></div><div class='description'><div class='short'><p>Reference to the TableView.</p>\n</div><div class='long'><p>Reference to the TableView.</p>\n</div></div></div><div id='property-wrapsItem' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-property-wrapsItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-property-wrapsItem' class='name expandable'>wrapsItem</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p><p>Overrides: <a href='#!/api/Ext.grid.feature.Feature-property-wrapsItem' rel='Ext.grid.feature.Feature-property-wrapsItem' class='docClass'>Ext.grid.feature.Feature.wrapsItem</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Properties</h3><div id='static-property-S-onExtended' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-property-S-onExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-property-S-onExtended' class='name expandable'>$onExtended</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[]</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.grid.feature.Grouping-method-constructor' class='name expandable'>Ext.grid.feature.GroupingSummary</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.grid.feature.Grouping\" rel=\"Ext.grid.feature.Grouping\" class=\"docClass\">Ext.grid.feature.Grouping</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.grid.feature.Grouping\" rel=\"Ext.grid.feature.Grouping\" class=\"docClass\">Ext.grid.feature.Grouping</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.feature.Feature-method-constructor' rel='Ext.grid.feature.Feature-method-constructor' class='docClass'>Ext.grid.feature.Feature.constructor</a></p></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>eventNames</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventNames</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>...<div class='sub-desc'><p>Either an object with event names as properties with\na value of <code>true</code>. For example:</p>\n\n<pre><code>this.addEvents({\n    storeloaded: true,\n    storecleared: true\n});\n</code></pre>\n\n<p>Or any number of event names as separate parameters. For example:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, [fn], [scope], [options]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.  For example:</p>\n\n<pre><code>myGridPanel.on(\"mouseover\", this.onMouseOver, this);\n</code></pre>\n\n<p>The method also allows for a single argument to be passed which is a config object\ncontaining properties which specify multiple events. For example:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: this.onCellClick,\n    mouseover: this.onMouseOver,\n    mouseout: this.onMouseOut,\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n<p>One can also specify options for each event handler separately:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: this.onCellClick, scope: this, single: true},\n    mouseover: {fn: panel.onMouseOver, scope: panel}\n});\n</code></pre>\n\n<p><em>Names</em> of methods in a specified scope may also be used. Note that\n<code>scope</code> MUST be specified to use this option:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: 'onCellClick', scope: this, single: true},\n    mouseover: {fn: 'onMouseOver', scope: panel}\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The name of the event to listen for.\nMay also be an object who's property names are event names.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>The method the event invokes, or <em>if <code>scope</code> is specified, the </em>name* of the method within\nthe specified <code>scope</code>.  Will be called with arguments\ngiven to <a href=\"#!/api/Ext.util.Observable-method-fireEvent\" rel=\"Ext.util.Observable-method-fireEvent\" class=\"docClass\">fireEvent</a> plus the <code>options</code> parameter described below.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is\nexecuted. <strong>If omitted, defaults to the object which fired the event.</strong></p>\n\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n\n\n\n\n<p><strong>Note:</strong> Unlike in ExtJS 3.x, the options object will also be passed as the last\nargument to every event handler.</p>\n\n\n\n\n<p>This object may contain any of the following properties:</p>\n\n<ul><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If omitted,\n  defaults to the object which fired the event.</strong></p>\n\n</div></li><li><span class='pre'>delay</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The number of milliseconds to delay the invocation of the handler after the event fires.</p>\n\n</div></li><li><span class='pre'>single</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to add a handler to handle just the next firing of the event, and then remove itself.</p>\n\n</div></li><li><span class='pre'>buffer</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\n  by the specified number of milliseconds. If the event fires again within that time,\n  the original handler is <em>not</em> invoked, but the new handler is scheduled in its place.</p>\n\n</div></li><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a><div class='sub-desc'><p>Only call the handler if the event was fired on the target Observable, <em>not</em> if the event\n  was bubbled up from a child Observable.</p>\n\n</div></li><li><span class='pre'>element</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p><strong>This option is only valid for listeners bound to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a>.</strong>\n  The name of a Component property which references an element to add a listener to.</p>\n\n\n\n\n<p>  This option is useful during Component construction to add DOM event listeners to elements of\n  <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a> which will exist only after the Component is rendered.\n  For example, to add a click listener to a Panel's body:</p>\n\n\n\n\n<pre><code>  new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n      title: 'The title',\n      listeners: {\n          click: this.handlePanelClick,\n          element: 'body'\n      }\n  });\n</code></pre>\n\n</div></li><li><span class='pre'>destroyable</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>When specified as <code>true</code>, the function returns A <code>Destroyable</code> object. An object which implements the <code>destroy</code> method which removes all listeners added in this call.</p>\n\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>priority</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>An optional numeric priority that determines the order in which event handlers\n  are run. Event handlers with no priority will be run as if they had a priority\n  of 0. Handlers with a higher priority will be prioritized to run sooner than\n  those with a lower priority.  Negative numbers can be used to set a priority\n  lower than the default. Internally, the framework uses a range of 1000 or\n  greater, and -1000 or lesser for handers that are intended to run before or\n  after all others, so it is recommended to stay within the range of -999 to 999\n  when setting the priority of event handlers in application-level code.</p>\n\n\n\n\n<p><strong>Combining Options</strong></p>\n\n\n\n\n<p>Using the options argument, it is possible to combine different types of listeners:</p>\n\n\n\n\n<p>A delayed, one-time listener.</p>\n\n\n\n\n<pre><code>myPanel.on('hide', this.handleClick, this, {\n    single: true,\n    delay: 100\n});\n</code></pre>\n\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p><strong>Only when the <code>destroyable</code> option is specified. </strong></p>\n\n\n\n\n<p> A <code>Destroyable</code> object. An object which implements the <code>destroy</code> method which removes all listeners added in this call. For example:</p>\n\n\n\n\n<pre><code>this.btnListeners =  = myButton.on({\n    destroyable: true\n    mouseover:   function() { console.log('mouseover'); },\n    mouseout:    function() { console.log('mouseout'); },\n    click:       function() { console.log('click'); }\n});\n</code></pre>\n\n\n\n\n<p>And when those listeners need to be removed:</p>\n\n\n\n\n<pre><code><a href=\"#!/api/Ext-method-destroy\" rel=\"Ext-method-destroy\" class=\"docClass\">Ext.destroy</a>(this.btnListeners);\n</code></pre>\n\n\n\n\n<p>or</p>\n\n\n\n\n<pre><code>this.btnListeners.destroy();\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addManagedListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addManagedListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addManagedListener' class='name expandable'>addManagedListener</a>( <span class='pre'>item, ename, [fn], [scope], [options]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Adds listeners to any Observable object (or Ext.Element) which are automatically removed when this Component is\ndestr...</div><div class='long'><p>Adds listeners to any Observable object (or <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a>) which are automatically removed when this Component is\ndestroyed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The item to which to add a listener/listeners.</p>\n\n</div></li><li><span class='pre'>ename</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the handler function.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the scope (<code>this</code> reference)\nin which the handler function is executed.</p>\n\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> options.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p><strong>Only when the <code>destroyable</code> option is specified. </strong></p>\n\n\n\n\n<p> A <code>Destroyable</code> object. An object which implements the <code>destroy</code> method which removes all listeners added in this call. For example:</p>\n\n\n\n\n<pre><code>this.btnListeners =  = myButton.mon({\n    destroyable: true\n    mouseover:   function() { console.log('mouseover'); },\n    mouseout:    function() { console.log('mouseout'); },\n    click:       function() { console.log('click'); }\n});\n</code></pre>\n\n\n\n\n<p>And when those listeners need to be removed:</p>\n\n\n\n\n<pre><code><a href=\"#!/api/Ext-method-destroy\" rel=\"Ext-method-destroy\" class=\"docClass\">Ext.destroy</a>(this.btnListeners);\n</code></pre>\n\n\n\n\n<p>or</p>\n\n\n\n\n<pre><code>this.btnListeners.destroy();\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-afterCollapseExpand' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-afterCollapseExpand' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-afterCollapseExpand' class='name expandable'>afterCollapseExpand</a>( <span class='pre'>collapsed, groupName, focus</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>collapsed</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>groupName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>focus</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterViewRender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-afterViewRender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-afterViewRender' class='name expandable'>afterViewRender</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Attach events to view ...</div><div class='long'><p>Attach events to view</p>\n</div></div></div><div id='method-block' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-block' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-block' class='name expandable'>block</a>( <span class='pre'>fromPartner</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromPartner</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-callOverridden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-callOverridden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'>args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated signature' >deprecated</strong><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>as of 4.1. Use <a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a> instead.</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callOverridden(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result of calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-callParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'>args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Call the \"parent\" method of the current method. ...</div><div class='long'><p>Call the \"parent\" method of the current method. That is the method previously\noverridden by derivation or by an override (see <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>).</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Base', {\n     constructor: function (x) {\n         this.x = x;\n     },\n\n     statics: {\n         method: function (x) {\n             return x;\n         }\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived', {\n     extend: 'My.Base',\n\n     constructor: function () {\n         this.callParent([21]);\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // alerts 21\n</code></pre>\n\n<p>This can be used with an override as follows:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.DerivedOverride', {\n     override: 'My.Derived',\n\n     constructor: function (x) {\n         this.callParent([x*2]); // calls original My.Derived constructor\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // now alerts 42\n</code></pre>\n\n<p>This also works with static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2', {\n     extend: 'My.Base',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Base.method\n         }\n     }\n });\n\n alert(My.Base.method(10);     // alerts 10\n alert(My.Derived2.method(10); // alerts 20\n</code></pre>\n\n<p>Lastly, it also works with overridden static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2Override', {\n     override: 'My.Derived2',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Derived2.method\n         }\n     }\n });\n\n alert(My.Derived2.method(10); // now alerts 40\n</code></pre>\n\n<p>To override a method and replace it and also call the superclass method, use\n<a href=\"#!/api/Ext.Base-method-callSuper\" rel=\"Ext.Base-method-callSuper\" class=\"docClass\">callSuper</a>. This is often done to patch a method to fix a bug.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result of calling the parent method</p>\n</div></li></ul></div></div></div><div id='method-callSuper' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-callSuper' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-callSuper' class='name expandable'>callSuper</a>( <span class='pre'>args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>This method is used by an override to call the superclass method but bypass any\noverridden method. ...</div><div class='long'><p>This method is used by an override to call the superclass method but bypass any\noverridden method. This is often done to \"patch\" a method that contains a bug\nbut for whatever reason cannot be fixed directly.</p>\n\n<p>Consider:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.some.Class', {\n     method: function () {\n         console.log('Good');\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.some.DerivedClass', {\n     method: function () {\n         console.log('Bad');\n\n         // ... logic but with a bug ...\n\n         this.callParent();\n     }\n });\n</code></pre>\n\n<p>To patch the bug in <code>DerivedClass.method</code>, the typical solution is to create an\noverride:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('App.paches.DerivedClass', {\n     override: 'Ext.some.DerivedClass',\n\n     method: function () {\n         console.log('Fixed');\n\n         // ... logic but with bug fixed ...\n\n         this.callSuper();\n     }\n });\n</code></pre>\n\n<p>The patch method cannot use <code>callParent</code> to call the superclass <code>method</code> since\nthat would call the overridden method containing the bug. In other words, the\nabove patch would only produce \"Fixed\" then \"Good\" in the console log, whereas,\nusing <code>callParent</code> would produce \"Fixed\" then \"Bad\" then \"Good\".</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callSuper(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result of calling the superclass method</p>\n</div></li></ul></div></div></div><div id='method-captureArgs' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-captureArgs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-captureArgs' class='name expandable'>captureArgs</a>( <span class='pre'>o, fn, scope</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-cleanup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-cleanup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-cleanup' class='name expandable'>cleanup</a>( <span class='pre'>rows, rowValues</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rows</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>rowValues</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-clearGroupCache' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-clearGroupCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-clearGroupCache' class='name expandable'>clearGroupCache</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-clearListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-clearListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-clearListeners' class='name expandable'>clearListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object including the managed listeners ...</div><div class='long'><p>Removes all listeners for this object including the managed listeners</p>\n</div></div></div><div id='method-clearManagedListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-clearManagedListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-clearManagedListeners' class='name expandable'>clearManagedListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all managed listeners for this object. ...</div><div class='long'><p>Removes all managed listeners for this object.</p>\n</div></div></div><div id='method-clone' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Feature' rel='Ext.grid.feature.Feature' class='defined-in docClass'>Ext.grid.feature.Feature</a><br/><a href='source/Feature.html#Ext-grid-feature-Feature-method-clone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Feature-method-clone' class='name expandable'>clone</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-collapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-collapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-collapse' class='name expandable'>collapse</a>( <span class='pre'>groupName, focus</span> )</div><div class='description'><div class='short'>Collapse a group ...</div><div class='long'><p>Collapse a group</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>groupName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group name</p>\n</div></li><li><span class='pre'>focus</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>Pass <code>true</code> to focus the group after expand.</p>\n</div></li></ul></div></div></div><div id='method-collapseAll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-collapseAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-collapseAll' class='name expandable'>collapseAll</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Collapse all groups ...</div><div class='long'><p>Collapse all groups</p>\n</div></div></div><div id='method-configClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-configClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-configClass' class='name expandable'>configClass</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-continueFireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-continueFireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-continueFireEvent' class='name expandable'>continueFireEvent</a>( <span class='pre'>eventName, args, bubbles</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Continue to fire event. ...</div><div class='long'><p>Continue to fire event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'>\n</div></li><li><span class='pre'>bubbles</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createGroupCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-createGroupCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-createGroupCls' class='name expandable'>createGroupCls</a>( <span class='pre'>group</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createGroupId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-createGroupId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-createGroupId' class='name expandable'>createGroupId</a>( <span class='pre'>group</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createRelayer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-createRelayer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-createRelayer' class='name expandable'>createRelayer</a>( <span class='pre'>newName, [beginEnd]</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Creates an event handling function which refires the event from this object as the passed event name. ...</div><div class='long'><p>Creates an event handling function which refires the event from this object as the passed event name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name under which to refire the passed parameters.</p>\n</div></li><li><span class='pre'>beginEnd</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The caller can specify on which indices to slice.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.grid.feature.Feature-method-destroy' rel='Ext.grid.feature.Feature-method-destroy' class='docClass'>Ext.grid.feature.Feature.destroy</a></p></div></div></div><div id='method-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-disable' class='name expandable'>disable</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Disables the feature. ...</div><div class='long'><p>Disables the feature.</p>\n<p>Overrides: <a href='#!/api/Ext.grid.feature.Feature-method-disable' rel='Ext.grid.feature.Feature-method-disable' class='docClass'>Ext.grid.feature.Feature.disable</a></p></div></div></div><div id='method-doCollapseExpand' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-doCollapseExpand' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-doCollapseExpand' class='name expandable'>doCollapseExpand</a>( <span class='pre'>collapsed, groupName, focus</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>collapsed</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>groupName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>focus</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-enable' class='name expandable'>enable</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Enables the feature. ...</div><div class='long'><p>Enables the feature.</p>\n<p>Overrides: <a href='#!/api/Ext.grid.feature.Feature-method-enable' rel='Ext.grid.feature.Feature-method-enable' class='docClass'>Ext.grid.feature.Feature.enable</a></p></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>eventNames</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling this.getBubbleTarget() if\npresent. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling <code>this.getBubbleTarget()</code> if\npresent. There is no implementation in the Observable base class.</p>\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers.\nSee <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>. The default implementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the\nComponent's immediate owner. But if a known target is required, this can be overridden to access the\nrequired target more quickly.</p>\n\n<p>Example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.overrides.form.field.Base', {\n    override: '<a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>',\n\n    //  Add functionality to Field's initComponent to enable the change event to bubble\n    initComponent: function () {\n        this.callParent();\n        this.enableBubble('change');\n    }\n});\n\nvar myForm = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>', {\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventNames</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-expand' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-expand' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-expand' class='name expandable'>expand</a>( <span class='pre'>groupName, focus</span> )</div><div class='description'><div class='short'>Expand a group ...</div><div class='long'><p>Expand a group</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>groupName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group name</p>\n</div></li><li><span class='pre'>focus</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>Pass <code>true</code> to focus the group after expand.</p>\n</div></li></ul></div></div></div><div id='method-expandAll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-expandAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-expandAll' class='name expandable'>expandAll</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Expand all groups ...</div><div class='long'><p>Expand all groups</p>\n</div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name, plus the options object passed\nto addList...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name, plus the <code>options</code> object passed\nto <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>).</p>\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>) by\ncalling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-fireEventArgs' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEventArgs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEventArgs' class='name expandable'>fireEventArgs</a>( <span class='pre'>eventName, args</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Fires the specified event with the passed parameter list. ...</div><div class='long'><p>Fires the specified event with the passed parameter list.</p>\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>) by\ncalling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]<div class='sub-desc'><p>An array of parameters which are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-generateSummaryData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-method-generateSummaryData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-method-generateSummaryData' class='name expandable'>generateSummaryData</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Used by the Grouping Feature when showSummaryRow is true. ...</div><div class='long'><p>Used by the Grouping Feature when <a href=\"#!/api/Ext.grid.feature.AbstractSummary-cfg-showSummaryRow\" rel=\"Ext.grid.feature.AbstractSummary-cfg-showSummaryRow\" class=\"docClass\">showSummaryRow</a> is <code>true</code>.</p>\n\n<p>Generates group summary data for the whole store.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>An object hash keyed by group name containing summary records.</p>\n</div></li></ul></div></div></div><div id='method-getBubbleParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-getBubbleParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-getBubbleParent' class='name expandable'>getBubbleParent</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Gets the bubbling parent for an Observable ...</div><div class='long'><p>Gets the bubbling parent for an Observable</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a></span><div class='sub-desc'><p>The bubble parent. null is returned if no bubble target exists</p>\n</div></li></ul></div></div></div><div id='method-getConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getConfig' class='name expandable'>getConfig</a>( <span class='pre'>name</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFireEventArgs' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-getFireEventArgs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-getFireEventArgs' class='name expandable'>getFireEventArgs</a>( <span class='pre'>eventName, view, featureTarget, e</span> )<strong class='template signature' >template</strong></div><div class='description'><div class='short'>Abstract method to be overriden when a feature should add additional\narguments to its event signature. ...</div><div class='long'><p>Abstract method to be overriden when a feature should add additional\narguments to its event signature. By default the event will fire:</p>\n\n<ul>\n<li>view - The underlying <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a></li>\n<li>featureTarget - The matched element by the defined <a href=\"#!/api/Ext.grid.feature.Grouping-property-eventSelector\" rel=\"Ext.grid.feature.Grouping-property-eventSelector\" class=\"docClass\">eventSelector</a></li>\n</ul>\n\n\n<p>The method must also return the eventName as the first index of the array\nto be passed to fireEvent.</p>\n      <div class='signature-box template'>\n      <p>This is a <a href=\"#!/guide/components\">template method</a>.\n         a hook into the functionality of this class.\n         Feel free to override it in child classes.</p>\n      </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>view</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>featureTarget</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.feature.Feature-method-getFireEventArgs' rel='Ext.grid.feature.Feature-method-getFireEventArgs' class='docClass'>Ext.grid.feature.Feature.getFireEventArgs</a></p></div></div></div><div id='method-getGroup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-getGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-getGroup' class='name expandable'>getGroup</a>( <span class='pre'>name</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getGroupField' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-getGroupField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-getGroupField' class='name expandable'>getGroupField</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getGroupName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-getGroupName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-getGroupName' class='name expandable'>getGroupName</a>( <span class='pre'>element</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getGroupedHeader' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-getGroupedHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-getGroupedHeader' class='name expandable'>getGroupedHeader</a>( <span class='pre'>groupField</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>groupField</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getHeaderNode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-getHeaderNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-getHeaderNode' class='name expandable'>getHeaderNode</a>( <span class='pre'>groupName</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>groupName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getInitialConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getInitialConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getInitialConfig' class='name expandable'>getInitialConfig</a>( <span class='pre'>[name]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/Mixed</div><div class='description'><div class='short'>Returns the initial configuration passed to constructor when instantiating\nthis class. ...</div><div class='long'><p>Returns the initial configuration passed to constructor when instantiating\nthis class.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Name of the config option to return.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/Mixed</span><div class='sub-desc'><p>The full config object or a single config value\nwhen <code>name</code> parameter specified.</p>\n</div></li></ul></div></div></div><div id='method-getMenuItem' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-getMenuItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-getMenuItem' class='name expandable'>getMenuItem</a>( <span class='pre'>dataIndex</span> ) : <a href=\"#!/api/Ext.grid.header.Container\" rel=\"Ext.grid.header.Container\" class=\"docClass\">Ext.grid.header.Container</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Gets the related menu item for a dataIndex ...</div><div class='long'><p>Gets the related menu item for a dataIndex</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dataIndex</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.grid.header.Container\" rel=\"Ext.grid.header.Container\" class=\"docClass\">Ext.grid.header.Container</a></span><div class='sub-desc'><p>The header</p>\n</div></li></ul></div></div></div><div id='method-getMenuItems' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-getMenuItems' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-getMenuItems' class='name expandable'>getMenuItems</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getRecordGroup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-getRecordGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-getRecordGroup' class='name expandable'>getRecordGroup</a>( <span class='pre'>record</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the group data object for the group to which the passed record belongs if the Store is grouped. ...</div><div class='long'><p>Returns the group data object for the group to which the passed record belongs <strong>if the Store is grouped</strong>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a><div class='sub-desc'><p>The record for which to return group information.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>A single group data block as returned from <a href=\"#!/api/Ext.data.Store-method-getGroups\" rel=\"Ext.data.Store-method-getGroups\" class=\"docClass\">Store.getGroups</a>. Returns\n<code>undefined</code> if the Store is not grouped.</p>\n</div></li></ul></div></div></div><div id='method-getSummary' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-method-getSummary' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-method-getSummary' class='name expandable'>getSummary</a>( <span class='pre'>store, type, field, group</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Get the summary data for a field. ...</div><div class='long'><p>Get the summary data for a field.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><div class='sub-desc'><p>The store to get the data from</p>\n</div></li><li><span class='pre'>type</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The type of aggregation. If a function is specified it will\nbe passed to the stores aggregate function.</p>\n</div></li><li><span class='pre'>field</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The field to aggregate on</p>\n</div></li><li><span class='pre'>group</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to aggregate in grouped mode</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>See the return type for the store functions.\nif the group parameter is <code>true</code> An object is returned with a property named for each group who's\nvalue is the summary value.</p>\n</div></li></ul></div></div></div><div id='method-hasConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-hasConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-hasConfig' class='name expandable'>hasConfig</a>( <span class='pre'>config</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event, or whether the event bubbles. ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event, or whether the event bubbles. The answer\nindicates whether the event needs firing or not.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p><code>true</code> if the event is being listened for or bubbles, else <code>false</code></p>\n</div></li></ul></div></div></div><div id='method-init' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-init' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-init' class='name expandable'>init</a>( <span class='pre'>grid</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>grid</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.feature.AbstractSummary-method-init' rel='Ext.grid.feature.AbstractSummary-method-init' class='docClass'>Ext.grid.feature.AbstractSummary.init</a></p></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-initConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='chainable signature' >chainable</strong><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-injectGroupingMenu' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-injectGroupingMenu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-injectGroupingMenu' class='name expandable'>injectGroupingMenu</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-isAllCollapsed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-isAllCollapsed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-isAllCollapsed' class='name expandable'>isAllCollapsed</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private\nReturns true if all groups are collapsed ...</div><div class='long'><p>private\nReturns true if all groups are collapsed</p>\n</div></div></div><div id='method-isAllExpanded' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-isAllExpanded' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-isAllExpanded' class='name expandable'>isAllExpanded</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private\nReturns true if all groups are expanded ...</div><div class='long'><p>private\nReturns true if all groups are expanded</p>\n</div></div></div><div id='method-isExpanded' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-isExpanded' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-isExpanded' class='name expandable'>isExpanded</a>( <span class='pre'>groupName</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the named group is expanded. ...</div><div class='long'><p>Returns <code>true</code> if the named group is expanded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>groupName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group name as returned from <a href=\"#!/api/Ext.data.Store-method-getGroupString\" rel=\"Ext.data.Store-method-getGroupString\" class=\"docClass\">getGroupString</a>. This is usually the value of\nthe <a href=\"#!/api/Ext.data.Store-cfg-groupField\" rel=\"Ext.data.Store-cfg-groupField\" class=\"docClass\">groupField</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p><code>true</code> if the group defined by that value is expanded.</p>\n</div></li></ul></div></div></div><div id='method-mon' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-mon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-mon' class='name expandable'>mon</a>( <span class='pre'>item, ename, [fn], [scope], [options]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Shorthand for addManagedListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-addManagedListener\" rel=\"Ext.util.Observable-method-addManagedListener\" class=\"docClass\">addManagedListener</a>.</p>\n\n<p>Adds listeners to any Observable object (or <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a>) which are automatically removed when this Component is\ndestroyed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The item to which to add a listener/listeners.</p>\n\n</div></li><li><span class='pre'>ename</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the handler function.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the scope (<code>this</code> reference)\nin which the handler function is executed.</p>\n\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> options.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p><strong>Only when the <code>destroyable</code> option is specified. </strong></p>\n\n\n\n\n<p> A <code>Destroyable</code> object. An object which implements the <code>destroy</code> method which removes all listeners added in this call. For example:</p>\n\n\n\n\n<pre><code>this.btnListeners =  = myButton.mon({\n    destroyable: true\n    mouseover:   function() { console.log('mouseover'); },\n    mouseout:    function() { console.log('mouseout'); },\n    click:       function() { console.log('click'); }\n});\n</code></pre>\n\n\n\n\n<p>And when those listeners need to be removed:</p>\n\n\n\n\n<pre><code><a href=\"#!/api/Ext-method-destroy\" rel=\"Ext-method-destroy\" class=\"docClass\">Ext.destroy</a>(this.btnListeners);\n</code></pre>\n\n\n\n\n<p>or</p>\n\n\n\n\n<pre><code>this.btnListeners.destroy();\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-mun' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-mun' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-mun' class='name expandable'>mun</a>( <span class='pre'>item, ename, [fn], [scope]</span> )</div><div class='description'><div class='short'>Shorthand for removeManagedListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeManagedListener\" rel=\"Ext.util.Observable-method-removeManagedListener\" class=\"docClass\">removeManagedListener</a>.</p>\n\n<p>Removes listeners that were added by the <a href=\"#!/api/Ext.util.Observable-method-mon\" rel=\"Ext.util.Observable-method-mon\" class=\"docClass\">mon</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The item from which to remove a listener/listeners.</p>\n\n</div></li><li><span class='pre'>ename</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the handler function.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the scope (<code>this</code> reference)\nin which the handler function is executed.</p>\n\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, [fn], [scope], [options]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Shorthand for addListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.</p>\n\n<p>Appends an event handler to this object.  For example:</p>\n\n<pre><code>myGridPanel.on(\"mouseover\", this.onMouseOver, this);\n</code></pre>\n\n<p>The method also allows for a single argument to be passed which is a config object\ncontaining properties which specify multiple events. For example:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: this.onCellClick,\n    mouseover: this.onMouseOver,\n    mouseout: this.onMouseOut,\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n<p>One can also specify options for each event handler separately:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: this.onCellClick, scope: this, single: true},\n    mouseover: {fn: panel.onMouseOver, scope: panel}\n});\n</code></pre>\n\n<p><em>Names</em> of methods in a specified scope may also be used. Note that\n<code>scope</code> MUST be specified to use this option:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: 'onCellClick', scope: this, single: true},\n    mouseover: {fn: 'onMouseOver', scope: panel}\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The name of the event to listen for.\nMay also be an object who's property names are event names.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>The method the event invokes, or <em>if <code>scope</code> is specified, the </em>name* of the method within\nthe specified <code>scope</code>.  Will be called with arguments\ngiven to <a href=\"#!/api/Ext.util.Observable-method-fireEvent\" rel=\"Ext.util.Observable-method-fireEvent\" class=\"docClass\">fireEvent</a> plus the <code>options</code> parameter described below.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is\nexecuted. <strong>If omitted, defaults to the object which fired the event.</strong></p>\n\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n\n\n\n\n<p><strong>Note:</strong> Unlike in ExtJS 3.x, the options object will also be passed as the last\nargument to every event handler.</p>\n\n\n\n\n<p>This object may contain any of the following properties:</p>\n\n<ul><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If omitted,\n  defaults to the object which fired the event.</strong></p>\n\n</div></li><li><span class='pre'>delay</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The number of milliseconds to delay the invocation of the handler after the event fires.</p>\n\n</div></li><li><span class='pre'>single</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to add a handler to handle just the next firing of the event, and then remove itself.</p>\n\n</div></li><li><span class='pre'>buffer</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\n  by the specified number of milliseconds. If the event fires again within that time,\n  the original handler is <em>not</em> invoked, but the new handler is scheduled in its place.</p>\n\n</div></li><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a><div class='sub-desc'><p>Only call the handler if the event was fired on the target Observable, <em>not</em> if the event\n  was bubbled up from a child Observable.</p>\n\n</div></li><li><span class='pre'>element</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p><strong>This option is only valid for listeners bound to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a>.</strong>\n  The name of a Component property which references an element to add a listener to.</p>\n\n\n\n\n<p>  This option is useful during Component construction to add DOM event listeners to elements of\n  <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a> which will exist only after the Component is rendered.\n  For example, to add a click listener to a Panel's body:</p>\n\n\n\n\n<pre><code>  new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n      title: 'The title',\n      listeners: {\n          click: this.handlePanelClick,\n          element: 'body'\n      }\n  });\n</code></pre>\n\n</div></li><li><span class='pre'>destroyable</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>When specified as <code>true</code>, the function returns A <code>Destroyable</code> object. An object which implements the <code>destroy</code> method which removes all listeners added in this call.</p>\n\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>priority</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>An optional numeric priority that determines the order in which event handlers\n  are run. Event handlers with no priority will be run as if they had a priority\n  of 0. Handlers with a higher priority will be prioritized to run sooner than\n  those with a lower priority.  Negative numbers can be used to set a priority\n  lower than the default. Internally, the framework uses a range of 1000 or\n  greater, and -1000 or lesser for handers that are intended to run before or\n  after all others, so it is recommended to stay within the range of -999 to 999\n  when setting the priority of event handlers in application-level code.</p>\n\n\n\n\n<p><strong>Combining Options</strong></p>\n\n\n\n\n<p>Using the options argument, it is possible to combine different types of listeners:</p>\n\n\n\n\n<p>A delayed, one-time listener.</p>\n\n\n\n\n<pre><code>myPanel.on('hide', this.handleClick, this, {\n    single: true,\n    delay: 100\n});\n</code></pre>\n\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p><strong>Only when the <code>destroyable</code> option is specified. </strong></p>\n\n\n\n\n<p> A <code>Destroyable</code> object. An object which implements the <code>destroy</code> method which removes all listeners added in this call. For example:</p>\n\n\n\n\n<pre><code>this.btnListeners =  = myButton.on({\n    destroyable: true\n    mouseover:   function() { console.log('mouseover'); },\n    mouseout:    function() { console.log('mouseout'); },\n    click:       function() { console.log('click'); }\n});\n</code></pre>\n\n\n\n\n<p>And when those listeners need to be removed:</p>\n\n\n\n\n<pre><code><a href=\"#!/api/Ext-method-destroy\" rel=\"Ext-method-destroy\" class=\"docClass\">Ext.destroy</a>(this.btnListeners);\n</code></pre>\n\n\n\n\n<p>or</p>\n\n\n\n\n<pre><code>this.btnListeners.destroy();\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-onColumnHideShow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-onColumnHideShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-onColumnHideShow' class='name expandable'>onColumnHideShow</a>( <span class='pre'>headerOwnerCt, header</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>headerOwnerCt</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>header</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onColumnMove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-onColumnMove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-onColumnMove' class='name expandable'>onColumnMove</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Update first and last records in groups when column moves\nBecause of the RowWrap template, this will update the group...</div><div class='long'><p>Update first and last records in groups when column moves\nBecause of the RowWrap template, this will update the groups' headers and footers</p>\n</div></div></div><div id='method-onConfigUpdate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-onConfigUpdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-onConfigUpdate' class='name expandable'>onConfigUpdate</a>( <span class='pre'>names, callback, scope</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>names</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onGroupChange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-onGroupChange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-onGroupChange' class='name expandable'>onGroupChange</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-onGroupClick' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-onGroupClick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-onGroupClick' class='name expandable'>onGroupClick</a>( <span class='pre'>view, rowElement, groupName, e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Toggle between expanded/collapsed state when clicking on\nthe group. ...</div><div class='long'><p>Toggle between expanded/collapsed state when clicking on\nthe group.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>view</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>rowElement</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>groupName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onGroupKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-onGroupKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-onGroupKey' class='name expandable'>onGroupKey</a>( <span class='pre'>keyCode, event</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>keyCode</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>event</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onGroupMenuItemClick' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-onGroupMenuItemClick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-onGroupMenuItemClick' class='name expandable'>onGroupMenuItemClick</a>( <span class='pre'>menuItem, e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Group by the header the user has clicked on. ...</div><div class='long'><p>Group by the header the user has clicked on.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>menuItem</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onGroupToggleMenuItemClick' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-onGroupToggleMenuItemClick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-onGroupToggleMenuItemClick' class='name expandable'>onGroupToggleMenuItemClick</a>( <span class='pre'>menuItem, checked</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Turn on and off grouping via the menu ...</div><div class='long'><p>Turn on and off grouping via the menu</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>menuItem</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>checked</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onReconfigure' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-onReconfigure' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-onReconfigure' class='name expandable'>onReconfigure</a>( <span class='pre'>grid, store, columns, oldStore, oldColumns</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>grid</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>store</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>columns</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>oldStore</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>oldColumns</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-outputSummaryRecord' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-method-outputSummaryRecord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-method-outputSummaryRecord' class='name expandable'>outputSummaryRecord</a>( <span class='pre'>summaryRecord, contextValues, out</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>summaryRecord</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>contextValues</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>out</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-populateRecord' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-method-populateRecord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-method-populateRecord' class='name expandable'>populateRecord</a>( <span class='pre'>group</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-populateRemoteRecord' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-method-populateRemoteRecord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-method-populateRemoteRecord' class='name expandable'>populateRemoteRecord</a>( <span class='pre'>group, data</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>data</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-prepareClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-prepareClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-prepareClass' class='name expandable'>prepareClass</a>( <span class='pre'>T</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Prepares a given class for observable instances. ...</div><div class='long'><p>Prepares a given class for observable instances. This method is called when a\nclass derives from this class or uses this class as a mixin.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>T</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The class constructor to prepare.</p>\n</div></li></ul></div></div></div><div id='method-pruneGroupedHeader' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-pruneGroupedHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-pruneGroupedHeader' class='name expandable'>pruneGroupedHeader</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Prunes the grouped header from the header container ...</div><div class='long'><p>Prunes the grouped header from the header container</p>\n</div></div></div><div id='method-refreshIf' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-refreshIf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-refreshIf' class='name expandable'>refreshIf</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>origin, events, [prefix]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <code>this</code>.</p>\n\n<p>For example if you are extending Grid, you might decide to forward some events from store.\nSo you can do this inside your initComponent:</p>\n\n<pre><code>this.relayEvents(this.getStore(), ['load']);\n</code></pre>\n\n<p>The grid instance will then have an observable 'load' event which will be passed the\nparameters of the store's load event and any function fired with the grid's load event\nwould have access to the grid using the <code>this</code> keyword.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>origin</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li><li><span class='pre'>prefix</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A common prefix to prepend to the event names. For example:</p>\n\n<pre><code>this.relayEvents(this.getStore(), ['load', 'clear'], 'store');\n</code></pre>\n\n<p>Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>A <code>Destroyable</code> object. An object which implements the <code>destroy</code> method which, when destroyed, removes all relayers. For example:</p>\n\n<pre><code>this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');\n</code></pre>\n\n<p>Can be undone by calling</p>\n\n<pre><code><a href=\"#!/api/Ext-method-destroy\" rel=\"Ext-method-destroy\" class=\"docClass\">Ext.destroy</a>(this.storeRelayers);\n</code></pre>\n\n<p>or</p>\n\n<pre><code>this.store.relayers.destroy();\n</code></pre>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, fn, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <strong>This must be a reference to the function passed into the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</strong></p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope originally specified for the handler. It must be the same as the\nscope argument specified in the original call to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> or the listener will not be removed.</p>\n\n</div></li></ul></div></div></div><div id='method-removeManagedListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeManagedListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeManagedListener' class='name expandable'>removeManagedListener</a>( <span class='pre'>item, ename, [fn], [scope]</span> )</div><div class='description'><div class='short'>Removes listeners that were added by the mon method. ...</div><div class='long'><p>Removes listeners that were added by the <a href=\"#!/api/Ext.util.Observable-method-mon\" rel=\"Ext.util.Observable-method-mon\" class=\"docClass\">mon</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The item from which to remove a listener/listeners.</p>\n\n</div></li><li><span class='pre'>ename</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the handler function.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the scope (<code>this</code> reference)\nin which the handler function is executed.</p>\n\n</div></li></ul></div></div></div><div id='method-removeManagedListenerItem' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeManagedListenerItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeManagedListenerItem' class='name expandable'>removeManagedListenerItem</a>( <span class='pre'>isClear, managedListener</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Remove a single managed listener item ...</div><div class='long'><p>Remove a single managed listener item</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>isClear</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True if this is being called during a clear</p>\n</div></li><li><span class='pre'>managedListener</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The managed listener item\nSee removeManagedListener for other args</p>\n</div></li></ul></div></div></div><div id='method-resumeEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvent' class='name expandable'>resumeEvent</a>( <span class='pre'>eventName</span> )</div><div class='description'><div class='short'>Resumes firing of the named event(s). ...</div><div class='long'><p>Resumes firing of the named event(s).</p>\n\n<p>After calling this method to resume events, the events will fire when requested to fire.</p>\n\n<p><strong>Note that if the <a href=\"#!/api/Ext.util.Observable-method-suspendEvent\" rel=\"Ext.util.Observable-method-suspendEvent\" class=\"docClass\">suspendEvent</a> method is called multiple times for a certain event,\nthis converse method will have to be called the same number of times for it to resume firing.</strong></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>...<div class='sub-desc'><p>Multiple event names to resume.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resumes firing events (see suspendEvents). ...</div><div class='long'><p>Resumes firing events (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>).</p>\n\n<p>If events were suspended using the <code>queueSuspended</code> parameter, then all events fired\nduring event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-setConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-setConfig' class='name expandable'>setConfig</a>( <span class='pre'>config, applyIfNotSet</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='chainable signature' >chainable</strong><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>applyIfNotSet</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-setup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-setup' class='name expandable'>setup</a>( <span class='pre'>rows, rowValues</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rows</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>rowValues</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setupRowData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-setupRowData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-setupRowData' class='name expandable'>setupRowData</a>( <span class='pre'>record, idx, rowValues</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>idx</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>rowValues</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-showMenuBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-showMenuBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-showMenuBy' class='name expandable'>showMenuBy</a>( <span class='pre'>t, header</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>t</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>header</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-statics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-suspendEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvent' class='name expandable'>suspendEvent</a>( <span class='pre'>eventName</span> )</div><div class='description'><div class='short'>Suspends firing of the named event(s). ...</div><div class='long'><p>Suspends firing of the named event(s).</p>\n\n<p>After calling this method to suspend events, the events will no longer fire when requested to fire.</p>\n\n<p><strong>Note that if this is called multiple times for a certain event, the converse method\n<a href=\"#!/api/Ext.util.Observable-method-resumeEvent\" rel=\"Ext.util.Observable-method-resumeEvent\" class=\"docClass\">resumeEvent</a> will have to be called the same number of times for it to resume firing.</strong></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>...<div class='sub-desc'><p>Multiple event names to suspend.</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspends the firing of all events. ...</div><div class='long'><p>Suspends the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events.</p>\n</div></li></ul></div></div></div><div id='method-toggleSummaryRow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.AbstractSummary' rel='Ext.grid.feature.AbstractSummary' class='defined-in docClass'>Ext.grid.feature.AbstractSummary</a><br/><a href='source/AbstractSummary.html#Ext-grid-feature-AbstractSummary-method-toggleSummaryRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.AbstractSummary-method-toggleSummaryRow' class='name expandable'>toggleSummaryRow</a>( <span class='pre'>visible</span> )</div><div class='description'><div class='short'>Toggle whether or not to show the summary row. ...</div><div class='long'><p>Toggle whether or not to show the summary row.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visible</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to show the summary row</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, fn, [scope]</span> )</div><div class='description'><div class='short'>Shorthand for removeListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.</p>\n\n<p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <strong>This must be a reference to the function passed into the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</strong></p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope originally specified for the handler. It must be the same as the\nscope argument specified in the original call to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> or the listener will not be removed.</p>\n\n</div></li></ul></div></div></div><div id='method-unblock' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-method-unblock' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-method-unblock' class='name expandable'>unblock</a>( <span class='pre'>fromPartner</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromPartner</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-vetoEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.grid.feature.GroupingSummary'>Ext.grid.feature.GroupingSummary</span><br/><a href='source/GroupingSummary.html#Ext-grid-feature-GroupingSummary-method-vetoEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.GroupingSummary-method-vetoEvent' class='name expandable'>vetoEvent</a>( <span class='pre'>record, row, rowIndex, e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>row</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>rowIndex</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.grid.feature.Grouping-method-vetoEvent' rel='Ext.grid.feature.Grouping-method-vetoEvent' class='docClass'>Ext.grid.feature.Grouping.vetoEvent</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-addConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addConfig' class='name expandable'>addConfig</a>( <span class='pre'>config</span> )<strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addInheritableStatics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addInheritableStatics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addInheritableStatics' class='name expandable'>addInheritableStatics</a>( <span class='pre'>members</span> )<strong class='chainable signature' >chainable</strong><strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addMember' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addMember' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addMember' class='name expandable'>addMember</a>( <span class='pre'>name, member</span> )<strong class='chainable signature' >chainable</strong><strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>member</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addMembers' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addMembers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addMembers' class='name expandable'>addMembers</a>( <span class='pre'>members</span> )<strong class='chainable signature' >chainable</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Add methods / properties to the prototype of this class. ...</div><div class='long'><p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.addMembers({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addStatics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addStatics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addStatics' class='name expandable'>addStatics</a>( <span class='pre'>members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='chainable signature' >chainable</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Add / override static properties of this class. ...</div><div class='long'><p>Add / override static properties of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-addXtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addXtype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addXtype' class='name expandable'>addXtype</a>( <span class='pre'>xtype</span> )<strong class='chainable signature' >chainable</strong><strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-borrow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-borrow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-borrow' class='name expandable'>borrow</a>( <span class='pre'>fromClass, members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='chainable signature' >chainable</strong><strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Borrow another class' members to the prototype of this class. ...</div><div class='long'><p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromClass</span> : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><div class='sub-desc'><p>The class to borrow members from</p>\n</div></li><li><span class='pre'>members</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The names of the members to borrow</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-create' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-create' class='name expandable'>create</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Create a new instance of this Class. ...</div><div class='long'><p>Create a new instance of this Class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the created instance.</p>\n</div></li></ul></div></div></div><div id='static-method-createAlias' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-createAlias' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-createAlias' class='name expandable'>createAlias</a>( <span class='pre'>alias, origin</span> )<strong class='static signature' >static</strong></div><div class='description'><div class='short'>Create aliases for existing prototype methods. ...</div><div class='long'><p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new method name, or an object to set multiple aliases. See\n<a href=\"#!/api/Ext.Function-method-flexSetter\" rel=\"Ext.Function-method-flexSetter\" class=\"docClass\">flexSetter</a></p>\n</div></li><li><span class='pre'>origin</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The original method name</p>\n</div></li></ul></div></div></div><div id='static-method-extend' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-extend' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-extend' class='name expandable'>extend</a>( <span class='pre'>config</span> )<strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-getName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-getName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Get the current class' name in string format. ...</div><div class='long'><p>Get the current class' name in string format.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='static-method-implement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-implement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-implement' class='name expandable'>implement</a>( <span class='pre'></span> )<strong class='deprecated signature' >deprecated</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Adds members to class. ...</div><div class='long'><p>Adds members to class.</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> since 4.1</p>\n        <p>Use <a href=\"#!/api/Ext.Base-static-method-addMembers\" rel=\"Ext.Base-static-method-addMembers\" class=\"docClass\">addMembers</a> instead.</p>\n\n        </div>\n</div></div></div><div id='static-method-mixin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-mixin' class='name expandable'>mixin</a>( <span class='pre'>name, mixinClass</span> )<strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Used internally by the mixins pre-processor ...</div><div class='long'><p>Used internally by the mixins pre-processor</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>mixinClass</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-onExtended' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-onExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-onExtended' class='name expandable'>onExtended</a>( <span class='pre'>fn, scope</span> )<strong class='chainable signature' >chainable</strong><strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-override' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-override' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-override' class='name expandable'>override</a>( <span class='pre'>members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='chainable signature' >chainable</strong><strong class='deprecated signature' >deprecated</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Override members of this class. ...</div><div class='long'><p>Override members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a>.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n\n<p>As of 4.1, direct use of this method is deprecated. Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>\ninstead:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.CatOverride', {\n    override: 'My.Cat',\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n    }\n});\n</code></pre>\n\n<p>The above accomplishes the same result but can be managed by the <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a>\nwhich can properly order the override and its target class and the build process\ncan determine whether the override is needed based on the required state of the\ntarget class (My.Cat).</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> since 4.1.0</p>\n        <p>Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a> instead</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The properties to add to this class. This should be\nspecified as an object literal containing one or more properties.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this class</p>\n</div></li></ul></div></div></div><div id='static-method-triggerExtended' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-triggerExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-triggerExtended' class='name expandable'>triggerExtended</a>( <span class='pre'></span> )<strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-groupclick' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-event-groupclick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-event-groupclick' class='name expandable'>groupclick</a>( <span class='pre'>view, node, group, e, eOpts</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>view</span> : <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a><div class='sub-desc'>\n</div></li><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'>\n</div></li><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the group</p>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-groupcollapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-event-groupcollapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-event-groupcollapse' class='name expandable'>groupcollapse</a>( <span class='pre'>view, node, group, eOpts</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>view</span> : <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a><div class='sub-desc'>\n</div></li><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'>\n</div></li><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the group</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-groupcontextmenu' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-event-groupcontextmenu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-event-groupcontextmenu' class='name expandable'>groupcontextmenu</a>( <span class='pre'>view, node, group, e, eOpts</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>view</span> : <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a><div class='sub-desc'>\n</div></li><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'>\n</div></li><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the group</p>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-groupdblclick' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-event-groupdblclick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-event-groupdblclick' class='name expandable'>groupdblclick</a>( <span class='pre'>view, node, group, e, eOpts</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>view</span> : <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a><div class='sub-desc'>\n</div></li><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'>\n</div></li><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the group</p>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-groupexpand' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.html#Ext-grid-feature-Grouping-event-groupexpand' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-event-groupexpand' class='name expandable'>groupexpand</a>( <span class='pre'>view, node, group, eOpts</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>view</span> : <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a><div class='sub-desc'>\n</div></li><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'>\n</div></li><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the group</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-css_var'>CSS Variables</h3><div class='subsection'><div id='css_var-S-grid-grouped-header-background-color' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-header-background-color' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-header-background-color' class='name expandable'>$grid-grouped-header-background-color</a><span> : color</span></div><div class='description'><div class='short'>The background color of group headers ...</div><div class='long'><p>The background color of group headers</p>\n<p>Defaults to: <code>#fff</code></p></div></div></div><div id='css_var-S-grid-grouped-header-border-color' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-header-border-color' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-header-border-color' class='name expandable'>$grid-grouped-header-border-color</a><span> : color</span></div><div class='description'><div class='short'>The border-color of group headers ...</div><div class='long'><p>The border-color of group headers</p>\n<p>Defaults to: <code>adjust-color ( $base-color , $hue : 0.844deg , $saturation : 7.644% , $lightness : - 8.627% )</code></p></div></div></div><div id='css_var-S-grid-grouped-header-border-style' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-header-border-style' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-header-border-style' class='name expandable'>$grid-grouped-header-border-style</a><span> : string</span></div><div class='description'><div class='short'>The border-style of group headers ...</div><div class='long'><p>The border-style of group headers</p>\n<p>Defaults to: <code>solid</code></p></div></div></div><div id='css_var-S-grid-grouped-header-border-width' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-header-border-width' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-header-border-width' class='name expandable'>$grid-grouped-header-border-width</a><span> : number/list</span></div><div class='description'><div class='short'>The border-width of group headers ...</div><div class='long'><p>The border-width of group headers</p>\n<p>Defaults to: <code>0 0 2px 0</code></p></div></div></div><div id='css_var-S-grid-grouped-header-cursor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-header-cursor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-header-cursor' class='name expandable'>$grid-grouped-header-cursor</a><span> : string</span></div><div class='description'><div class='short'>The cursor of group headers ...</div><div class='long'><p>The cursor of group headers</p>\n<p>Defaults to: <code>pointer</code></p></div></div></div><div id='css_var-S-grid-grouped-header-padding' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-header-padding' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-header-padding' class='name expandable'>$grid-grouped-header-padding</a><span> : number/list</span></div><div class='description'><div class='short'>The padding of group headers ...</div><div class='long'><p>The padding of group headers</p>\n<p>Defaults to: <code>10px 4px 4px 4px</code></p></div></div></div><div id='css_var-S-grid-grouped-icon-padding' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-icon-padding' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-icon-padding' class='name expandable'>$grid-grouped-icon-padding</a><span> : number/list</span></div><div class='description'><div class='short'>The amount of padding to add to the group title element. ...</div><div class='long'><p>The amount of padding to add to the group title element.  This is typically used\nto reserve space for an icon by setting the amountof space to be reserved for the icon\nas the left value and setting the remaining sides to 0.</p>\n<p>Defaults to: <code>0 0 0 14px</code></p></div></div></div><div id='css_var-S-grid-grouped-title-color' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-title-color' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-title-color' class='name expandable'>$grid-grouped-title-color</a><span> : color</span></div><div class='description'><div class='short'>The text color of group header titles ...</div><div class='long'><p>The text color of group header titles</p>\n<p>Defaults to: <code>adjust-color ( $base-color , $hue : 0.952deg , $saturation : - 6.718% , $lightness : - 41.961% )</code></p></div></div></div><div id='css_var-S-grid-grouped-title-font-family' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-title-font-family' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-title-font-family' class='name expandable'>$grid-grouped-title-font-family</a><span> : string</span></div><div class='description'><div class='short'>The font-family of group header titles ...</div><div class='long'><p>The font-family of group header titles</p>\n<p>Defaults to: <code>$font-family</code></p></div></div></div><div id='css_var-S-grid-grouped-title-font-size' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-title-font-size' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-title-font-size' class='name expandable'>$grid-grouped-title-font-size</a><span> : number</span></div><div class='description'><div class='short'>The font-size of group header titles ...</div><div class='long'><p>The font-size of group header titles</p>\n<p>Defaults to: <code>$font-size</code></p></div></div></div><div id='css_var-S-grid-grouped-title-font-weight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-title-font-weight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-title-font-weight' class='name expandable'>$grid-grouped-title-font-weight</a><span> : string</span></div><div class='description'><div class='short'>The font-weight of group header titles ...</div><div class='long'><p>The font-weight of group header titles</p>\n<p>Defaults to: <code>bold</code></p></div></div></div><div id='css_var-S-grid-grouped-title-line-height' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.grid.feature.Grouping' rel='Ext.grid.feature.Grouping' class='defined-in docClass'>Ext.grid.feature.Grouping</a><br/><a href='source/Grouping.scss3.html#Ext-grid-feature-Grouping-css_var-S-grid-grouped-title-line-height' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.grid.feature.Grouping-css_var-S-grid-grouped-title-line-height' class='name expandable'>$grid-grouped-title-line-height</a><span> : number</span></div><div class='description'><div class='short'>The line-height of group header titles ...</div><div class='long'><p>The line-height of group header titles</p>\n<p>Defaults to: <code>round ( $grid-grouped-title-font-size * 1.15 )</code></p></div></div></div></div></div></div></div>","superclasses":["Ext.Base","Ext.util.Observable","Ext.grid.feature.Feature","Ext.grid.feature.Grouping"],"meta":{},"code_type":"ext_define","requires":[],"html_meta":{},"statics":{"property":[{"tagname":"property","owner":"Ext.Base","meta":{"static":true,"private":true},"name":"$onExtended","id":"static-property-S-onExtended"}],"cfg":[],"css_var":[],"method":[{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"private":true},"name":"addConfig","id":"static-method-addConfig"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"chainable":true,"private":true},"name":"addInheritableStatics","id":"static-method-addInheritableStatics"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"chainable":true,"private":true},"name":"addMember","id":"static-method-addMember"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"chainable":true},"name":"addMembers","id":"static-method-addMembers"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"chainable":true},"name":"addStatics","id":"static-method-addStatics"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"chainable":true,"private":true},"name":"addXtype","id":"static-method-addXtype"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"chainable":true,"private":true},"name":"borrow","id":"static-method-borrow"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true},"name":"create","id":"static-method-create"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true},"name":"createAlias","id":"static-method-createAlias"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"private":true},"name":"extend","id":"static-method-extend"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true},"name":"getName","id":"static-method-getName"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"deprecated":{"text":"Use {@link #addMembers} instead.","version":"4.1"}},"name":"implement","id":"static-method-implement"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"private":true},"name":"mixin","id":"static-method-mixin"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"chainable":true,"private":true},"name":"onExtended","id":"static-method-onExtended"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"chainable":true,"markdown":true,"deprecated":{"text":"Use {@link Ext#define Ext.define} instead","version":"4.1.0"}},"name":"override","id":"static-method-override"},{"tagname":"method","owner":"Ext.Base","meta":{"static":true,"private":true},"name":"triggerExtended","id":"static-method-triggerExtended"}],"event":[],"css_mixin":[]},"files":[{"href":"GroupingSummary.html#Ext-grid-feature-GroupingSummary","filename":"GroupingSummary.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.Base","meta":{"private":true},"name":"$className","id":"property-S-className"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"collapseTip","id":"property-collapseTip"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"collapsedCls","id":"property-collapsedCls"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"collapsibleCls","id":"property-collapsibleCls"},{"tagname":"property","owner":"Ext.Base","meta":{"private":true},"name":"configMap","id":"property-configMap"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"ctCls","id":"property-ctCls"},{"tagname":"property","owner":"Ext.grid.feature.Feature","meta":{},"name":"disabled","id":"property-disabled"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{},"name":"eventPrefix","id":"property-eventPrefix"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{},"name":"eventSelector","id":"property-eventSelector"},{"tagname":"property","owner":"Ext.util.Observable","meta":{"private":true},"name":"eventsSuspended","id":"property-eventsSuspended"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"expandTip","id":"property-expandTip"},{"tagname":"property","owner":"Ext.grid.feature.Feature","meta":{},"name":"grid","id":"property-grid"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"groupCls","id":"property-groupCls"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"groupInfo","id":"property-groupInfo"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"groupTpl","id":"property-groupTpl"},{"tagname":"property","owner":"Ext.grid.feature.Feature","meta":{},"name":"hasFeatureEvent","id":"property-hasFeatureEvent"},{"tagname":"property","owner":"Ext.util.Observable","meta":{"readonly":true},"name":"hasListeners","id":"property-hasListeners"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"hdCollapsedCls","id":"property-hdCollapsedCls"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"hdNotCollapsibleCls","id":"property-hdNotCollapsibleCls"},{"tagname":"property","owner":"Ext.Base","meta":{"private":true},"name":"initConfigList","id":"property-initConfigList"},{"tagname":"property","owner":"Ext.Base","meta":{"private":true},"name":"initConfigMap","id":"property-initConfigMap"},{"tagname":"property","owner":"Ext.grid.feature.Feature","meta":{"private":true},"name":"isFeature","id":"property-isFeature"},{"tagname":"property","owner":"Ext.Base","meta":{"private":true},"name":"isInstance","id":"property-isInstance"},{"tagname":"property","owner":"Ext.util.Observable","meta":{},"name":"isObservable","id":"property-isObservable"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"refreshData","id":"property-refreshData"},{"tagname":"property","owner":"Ext.Base","meta":{"protected":true},"name":"self","id":"property-self"},{"tagname":"property","owner":"Ext.grid.feature.AbstractSummary","meta":{"private":true},"name":"summaryRowCls","id":"property-summaryRowCls"},{"tagname":"property","owner":"Ext.grid.feature.AbstractSummary","meta":{"private":true},"name":"summaryRowSelector","id":"property-summaryRowSelector"},{"tagname":"property","owner":"Ext.grid.feature.AbstractSummary","meta":{"private":true},"name":"summaryRowTpl","id":"property-summaryRowTpl"},{"tagname":"property","owner":"Ext.grid.feature.AbstractSummary","meta":{"private":true},"name":"summaryTableCls","id":"property-summaryTableCls"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"tableTpl","id":"property-tableTpl"},{"tagname":"property","owner":"Ext.grid.feature.Feature","meta":{},"name":"view","id":"property-view"},{"tagname":"property","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"wrapsItem","id":"property-wrapsItem"}],"cfg":[{"tagname":"cfg","owner":"Ext.grid.feature.Grouping","meta":{},"name":"collapsible","id":"cfg-collapsible"},{"tagname":"cfg","owner":"Ext.grid.feature.Grouping","meta":{},"name":"depthToIndent","id":"cfg-depthToIndent"},{"tagname":"cfg","owner":"Ext.grid.feature.Grouping","meta":{},"name":"enableGroupingMenu","id":"cfg-enableGroupingMenu"},{"tagname":"cfg","owner":"Ext.grid.feature.Grouping","meta":{},"name":"enableNoGroups","id":"cfg-enableNoGroups"},{"tagname":"cfg","owner":"Ext.grid.feature.Grouping","meta":{},"name":"groupByText","id":"cfg-groupByText"},{"tagname":"cfg","owner":"Ext.grid.feature.Grouping","meta":{},"name":"groupHeaderTpl","id":"cfg-groupHeaderTpl"},{"tagname":"cfg","owner":"Ext.grid.feature.Grouping","meta":{},"name":"hideGroupedHeader","id":"cfg-hideGroupedHeader"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.grid.feature.AbstractSummary","meta":{},"name":"remoteRoot","id":"cfg-remoteRoot"},{"tagname":"cfg","owner":"Ext.grid.feature.Grouping","meta":{},"name":"showGroupsText","id":"cfg-showGroupsText"},{"tagname":"cfg","owner":"Ext.grid.feature.GroupingSummary","meta":{},"name":"showSummaryRow","id":"cfg-showSummaryRow"},{"tagname":"cfg","owner":"Ext.grid.feature.Grouping","meta":{},"name":"startCollapsed","id":"cfg-startCollapsed"}],"css_var":[{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-header-background-color","id":"css_var-S-grid-grouped-header-background-color"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-header-border-color","id":"css_var-S-grid-grouped-header-border-color"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-header-border-style","id":"css_var-S-grid-grouped-header-border-style"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-header-border-width","id":"css_var-S-grid-grouped-header-border-width"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-header-cursor","id":"css_var-S-grid-grouped-header-cursor"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-header-padding","id":"css_var-S-grid-grouped-header-padding"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-icon-padding","id":"css_var-S-grid-grouped-icon-padding"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-title-color","id":"css_var-S-grid-grouped-title-color"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-title-font-family","id":"css_var-S-grid-grouped-title-font-family"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-title-font-size","id":"css_var-S-grid-grouped-title-font-size"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-title-font-weight","id":"css_var-S-grid-grouped-title-font-weight"},{"tagname":"css_var","owner":"Ext.grid.feature.Grouping","meta":{},"name":"$grid-grouped-title-line-height","id":"css_var-S-grid-grouped-title-line-height"}],"method":[{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addManagedListener","id":"method-addManagedListener"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"afterCollapseExpand","id":"method-afterCollapseExpand"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"afterViewRender","id":"method-afterViewRender"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"block","id":"method-block"},{"tagname":"method","owner":"Ext.Base","meta":{"protected":true,"deprecated":{"text":"as of 4.1. Use {@link #callParent} instead."}},"name":"callOverridden","id":"method-callOverridden"},{"tagname":"method","owner":"Ext.Base","meta":{"protected":true},"name":"callParent","id":"method-callParent"},{"tagname":"method","owner":"Ext.Base","meta":{"protected":true},"name":"callSuper","id":"method-callSuper"},{"tagname":"method","owner":"Ext.util.Observable","meta":{"private":true},"name":"captureArgs","id":"method-captureArgs"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"cleanup","id":"method-cleanup"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"clearGroupCache","id":"method-clearGroupCache"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"clearListeners","id":"method-clearListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"clearManagedListeners","id":"method-clearManagedListeners"},{"tagname":"method","owner":"Ext.grid.feature.Feature","meta":{"private":true},"name":"clone","id":"method-clone"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{},"name":"collapse","id":"method-collapse"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{},"name":"collapseAll","id":"method-collapseAll"},{"tagname":"method","owner":"Ext.Base","meta":{"private":true},"name":"configClass","id":"method-configClass"},{"tagname":"method","owner":"Ext.util.Observable","meta":{"private":true},"name":"continueFireEvent","id":"method-continueFireEvent"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"createGroupCls","id":"method-createGroupCls"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"createGroupId","id":"method-createGroupId"},{"tagname":"method","owner":"Ext.util.Observable","meta":{"private":true},"name":"createRelayer","id":"method-createRelayer"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{},"name":"disable","id":"method-disable"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"doCollapseExpand","id":"method-doCollapseExpand"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{},"name":"enable","id":"method-enable"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{},"name":"expand","id":"method-expand"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{},"name":"expandAll","id":"method-expandAll"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEventArgs","id":"method-fireEventArgs"},{"tagname":"method","owner":"Ext.grid.feature.AbstractSummary","meta":{"private":true},"name":"generateSummaryData","id":"method-generateSummaryData"},{"tagname":"method","owner":"Ext.util.Observable","meta":{"private":true},"name":"getBubbleParent","id":"method-getBubbleParent"},{"tagname":"method","owner":"Ext.Base","meta":{"private":true},"name":"getConfig","id":"method-getConfig"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"template":true},"name":"getFireEventArgs","id":"method-getFireEventArgs"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"getGroup","id":"method-getGroup"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"getGroupField","id":"method-getGroupField"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"getGroupName","id":"method-getGroupName"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"getGroupedHeader","id":"method-getGroupedHeader"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"getHeaderNode","id":"method-getHeaderNode"},{"tagname":"method","owner":"Ext.Base","meta":{},"name":"getInitialConfig","id":"method-getInitialConfig"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"getMenuItem","id":"method-getMenuItem"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"getMenuItems","id":"method-getMenuItems"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{},"name":"getRecordGroup","id":"method-getRecordGroup"},{"tagname":"method","owner":"Ext.grid.feature.AbstractSummary","meta":{"private":true},"name":"getSummary","id":"method-getSummary"},{"tagname":"method","owner":"Ext.Base","meta":{"private":true},"name":"hasConfig","id":"method-hasConfig"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"init","id":"method-init"},{"tagname":"method","owner":"Ext.Base","meta":{"chainable":true,"protected":true},"name":"initConfig","id":"method-initConfig"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"injectGroupingMenu","id":"method-injectGroupingMenu"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"isAllCollapsed","id":"method-isAllCollapsed"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"isAllExpanded","id":"method-isAllExpanded"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{},"name":"isExpanded","id":"method-isExpanded"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"mon","id":"method-mon"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"mun","id":"method-mun"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"onColumnHideShow","id":"method-onColumnHideShow"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"onColumnMove","id":"method-onColumnMove"},{"tagname":"method","owner":"Ext.Base","meta":{"private":true},"name":"onConfigUpdate","id":"method-onConfigUpdate"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"onGroupChange","id":"method-onGroupChange"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"onGroupClick","id":"method-onGroupClick"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"onGroupKey","id":"method-onGroupKey"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"onGroupMenuItemClick","id":"method-onGroupMenuItemClick"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"onGroupToggleMenuItemClick","id":"method-onGroupToggleMenuItemClick"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"onReconfigure","id":"method-onReconfigure"},{"tagname":"method","owner":"Ext.grid.feature.AbstractSummary","meta":{"private":true},"name":"outputSummaryRecord","id":"method-outputSummaryRecord"},{"tagname":"method","owner":"Ext.grid.feature.AbstractSummary","meta":{"private":true},"name":"populateRecord","id":"method-populateRecord"},{"tagname":"method","owner":"Ext.grid.feature.AbstractSummary","meta":{"private":true},"name":"populateRemoteRecord","id":"method-populateRemoteRecord"},{"tagname":"method","owner":"Ext.util.Observable","meta":{"private":true},"name":"prepareClass","id":"method-prepareClass"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"pruneGroupedHeader","id":"method-pruneGroupedHeader"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"refreshIf","id":"method-refreshIf"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeManagedListener","id":"method-removeManagedListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{"private":true},"name":"removeManagedListenerItem","id":"method-removeManagedListenerItem"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvent","id":"method-resumeEvent"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.Base","meta":{"chainable":true,"private":true},"name":"setConfig","id":"method-setConfig"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"setup","id":"method-setup"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"setupRowData","id":"method-setupRowData"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"showMenuBy","id":"method-showMenuBy"},{"tagname":"method","owner":"Ext.Base","meta":{"protected":true},"name":"statics","id":"method-statics"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvent","id":"method-suspendEvent"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.grid.feature.AbstractSummary","meta":{},"name":"toggleSummaryRow","id":"method-toggleSummaryRow"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.grid.feature.Grouping","meta":{"private":true},"name":"unblock","id":"method-unblock"},{"tagname":"method","owner":"Ext.grid.feature.GroupingSummary","meta":{"private":true},"name":"vetoEvent","id":"method-vetoEvent"}],"event":[{"tagname":"event","owner":"Ext.grid.feature.Grouping","meta":{},"name":"groupclick","id":"event-groupclick"},{"tagname":"event","owner":"Ext.grid.feature.Grouping","meta":{},"name":"groupcollapse","id":"event-groupcollapse"},{"tagname":"event","owner":"Ext.grid.feature.Grouping","meta":{},"name":"groupcontextmenu","id":"event-groupcontextmenu"},{"tagname":"event","owner":"Ext.grid.feature.Grouping","meta":{},"name":"groupdblclick","id":"event-groupdblclick"},{"tagname":"event","owner":"Ext.grid.feature.Grouping","meta":{},"name":"groupexpand","id":"event-groupexpand"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.grid.feature.GroupingSummary","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.grid.feature.GroupingSummary","mixins":[],"mixedInto":[]});