/*
 * Decompiled with CFR 0.152.
 */
import circuit.ParseSchem;
import export.ExportGraphic;
import globals.Globals;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class FidoMain {
    public static void main(String[] args) {
        String loadFile = "";
        String libDirectory = "";
        boolean commandLineOnly = false;
        boolean convertFile = false;
        int totx = 0;
        int toty = 0;
        String exportFormat = "";
        String outputFile = "";
        boolean headlessMode = false;
        boolean resolutionBasedExport = false;
        boolean printSize = false;
        double resolution = 1.0;
        if (args.length >= 1) {
            boolean loaded = false;
            boolean nextLib = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    if (args[i].startsWith("-n")) {
                        commandLineOnly = true;
                        System.setProperty("java.awt.headless", "true");
                        continue;
                    }
                    if (args[i].startsWith("-d")) {
                        nextLib = true;
                        continue;
                    }
                    if (args[i].startsWith("-c")) {
                        try {
                            if (args[++i].startsWith("r")) {
                                resolution = Double.parseDouble(args[i].substring(1));
                                resolutionBasedExport = true;
                                if (resolution <= 0.0) {
                                    System.err.println("Resolution should bea positive real number");
                                    System.exit(1);
                                }
                            } else {
                                totx = Integer.parseInt(args[i]);
                                toty = Integer.parseInt(args[++i]);
                            }
                            exportFormat = args[++i];
                            outputFile = args[++i];
                            convertFile = true;
                            headlessMode = true;
                        }
                        catch (Exception E) {
                            System.err.println("Unable to read the parameters given to -c");
                            System.exit(1);
                        }
                        convertFile = true;
                        continue;
                    }
                    if (args[i].startsWith("-h")) {
                        FidoMain.showCommandLineHelp();
                        System.exit(0);
                        continue;
                    }
                    if (args[i].startsWith("-s")) {
                        headlessMode = true;
                        printSize = true;
                        continue;
                    }
                    System.err.println("Unrecognized option: " + args[i]);
                    FidoMain.showCommandLineHelp();
                    System.exit(1);
                    continue;
                }
                if (nextLib) {
                    libDirectory = args[i];
                    System.out.println("Changed the library directory: " + args[i]);
                } else {
                    if (loaded) {
                        System.err.println("Only one file can be specified in the command line");
                    }
                    loadFile = args[i];
                    loaded = true;
                }
                nextLib = false;
            }
        }
        if (headlessMode) {
            ParseSchem P = new ParseSchem();
            if (loadFile.equals("")) {
                System.err.println("You should specify a FidoCadJ file to read");
                System.exit(1);
            }
            FidoMain.readLibraries(P, false, libDirectory);
            StringBuffer txt = new StringBuffer();
            try {
                FileReader input = new FileReader(loadFile);
                BufferedReader bufRead = new BufferedReader(input);
                String line = "";
                txt = new StringBuffer(bufRead.readLine());
                txt.append("\n");
                while (line != null) {
                    line = bufRead.readLine();
                    txt.append(line);
                    txt.append("\n");
                }
                bufRead.close();
                Vector layerDesc = Globals.createStandardLayers();
                P.setLayers(layerDesc);
                P.parseString(new StringBuffer(txt.toString()));
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Illegal filename");
            }
            catch (Exception e) {
                System.err.println("Unable to export: " + e);
            }
            if (convertFile) {
                try {
                    if (resolutionBasedExport) {
                        ExportGraphic.export(new File(outputFile), P, exportFormat, resolution, true, false, true, true);
                    } else {
                        ExportGraphic.exportSize(new File(outputFile), P, exportFormat, totx, toty, true, false, true, true);
                    }
                    System.out.println("Export completed");
                }
                catch (IOException ioe) {
                    System.err.println("Export error: " + ioe);
                }
            }
            if (printSize) {
                Dimension d = ExportGraphic.getImageSize(P, 1.0, true);
                System.out.println("" + d.width + " " + d.height);
            }
        }
        if (!commandLineOnly) {
            SwingUtilities.invokeLater(new CreateSwingInterface(libDirectory, loadFile));
        }
    }

    private static void showCommandLineHelp() {
        String help = "\nThis is FidoCadJ, version 0.24.\nBy Davide Bucci, 2007-2012.\n\nUse: java -jar fidocadj.jar [-options] [file] \nwhere options include:\n\n -n     Do not start the graphical user interface (headless mode)\n\n -d     Set the extern library directory\n        Usage: -d dir\n        where 'dir' is the path of the directory you want to use.\n\n -c     Convert the given file to a graphical format.\n        Usage: -c sx sy eps|pdf|svg|png|jpg|fcd|sch outfile\n        If you use this command line option, you *must* specify a FidoCadJ file to convert.\n        An alternative is to specify the resolution in pixels per logical unit by\n        preceding it by the letter 'r' (without spaces), instead of giving sx and sy.\n\n -s     Print the size  of the specified file in logical coordinates.\n\n -h     Print this help and exit.\n\n [file] The optional (except if you use the -d or -s options) FidoCadJ file to load at\n        startup time.\n\nExample: load and convert a FidoCadJ drawing to a 800x600 pixel png file without using the GUI.\njava -jar fidocadj.jar -n -c 800 600 png out1.png test1.fcd\n\nExample: load and convert a FidoCadJ drawing to a png file without using the GUI.\n         Each FidoCadJ logical unit will be converted in 2 pixels on the image.\njava -jar fidocadj.jar -n -c r2 png out2.png test2.fcd\n\n";
        System.out.println(help);
    }

    public static void readLibraries(ParseSchem P, boolean englishLibraries, String libDirectory) {
        P.loadLibraryDirectory(libDirectory);
        if (!new File(Globals.createCompleteFileName(libDirectory, "IHRAM.FCL")).exists()) {
            if (englishLibraries) {
                P.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM_en.FCL"), "ihram");
            } else {
                P.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM.FCL"), "ihram");
            }
        } else {
            System.out.println("IHRAM library got from external file");
        }
        if (!new File(Globals.createCompleteFileName(libDirectory, "FCDstdlib.fcl")).exists()) {
            if (englishLibraries) {
                P.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib_en.fcl"), "");
            } else {
                P.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib.fcl"), "");
            }
        } else {
            System.out.println("Standard library got from external file");
        }
        if (!new File(Globals.createCompleteFileName(libDirectory, "PCB.fcl")).exists()) {
            if (englishLibraries) {
                P.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB_en.fcl"), "pcb");
            } else {
                P.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB.fcl"), "pcb");
            }
        } else {
            System.out.println("Standard PCB library got from external file");
        }
        if (!new File(Globals.createCompleteFileName(libDirectory, "elettrotecnica.fcl")).exists()) {
            if (englishLibraries) {
                P.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica_en.fcl"), "elettrotecnica");
            } else {
                P.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica.fcl"), "elettrotecnica");
            }
        } else {
            System.out.println("Electrotechnics library got from external file");
        }
    }
}

