/*
 * Decompiled with CFR 0.152.
 */
import geom.MapCoordinates;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

class RulerPanel
extends JPanel
implements SwingConstants {
    private int dir;
    private int increment;
    private MapCoordinates sc;

    public RulerPanel(int direction, int width, int height, int incr, MapCoordinates m) {
        this.increment = incr;
        this.sc = m;
        this.dir = direction;
        this.setPreferredSize(new Dimension(width, height));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle d = g.getClipBounds();
        g.setColor(Color.white);
        g.fillRect(d.x, d.y, d.width, d.height);
        g.setColor(Color.black);
        if (this.dir == 0) {
            int x = 0;
            for (x = 0; x < this.sc.unmapXnosnap(this.sc.getXMax()); x += this.increment) {
                g.drawLine(this.sc.mapXi(x, 0.0, false), this.sc.mapYi(x, 0.0, false), this.sc.mapXi(x, 0.0, false), this.sc.mapYi(x, 0.0, false) + d.height * 4 / 10);
            }
            for (x = 0; x < this.sc.unmapXnosnap(this.sc.getXMax()); x += 5 * this.increment) {
                g.drawLine(this.sc.mapXi(x, 0.0, false), this.sc.mapYi(x, 0.0, false), this.sc.mapXi(x, 0.0, false), this.sc.mapYi(x, 0.0, false) + d.height * 6 / 10);
            }
            for (x = 0; x < this.sc.getXMax(); x += 10 * this.increment) {
                g.drawString("" + x, this.sc.mapXi(x, 0.0, false), d.height);
                g.drawLine(this.sc.mapXi(x, 0.0, false), this.sc.mapYi(x, 0.0, false), this.sc.mapXi(x, 0.0, false), this.sc.mapYi(x, 0.0, false) + d.height);
            }
        } else {
            int y = 0;
            int inc = this.sc.mapYi(this.increment, this.increment, false) - this.sc.mapYi(0.0, 0.0, false);
            for (y = 0; y < d.height; y += inc) {
                g.drawLine(0, y, d.width * 4 / 10, y);
            }
            for (y = 0; y < d.height; y += 5 * inc) {
                g.drawLine(0, y, d.width * 8 / 10, y);
            }
        }
    }
}

