/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.CircuitPanel;
import circuit.HasChangedListener;
import clipboard.TextTransfer;
import export.ExportGraphic;
import export.ExportInterface;
import geom.MapCoordinates;
import globals.Globals;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import layers.LayerDesc;
import primitives.GraphicPrimitive;
import primitives.MacroDesc;
import primitives.PrimitiveAdvText;
import primitives.PrimitiveBezier;
import primitives.PrimitiveComplexCurve;
import primitives.PrimitiveConnection;
import primitives.PrimitiveLine;
import primitives.PrimitiveMacro;
import primitives.PrimitiveOval;
import primitives.PrimitivePCBLine;
import primitives.PrimitivePCBPad;
import primitives.PrimitivePolygon;
import primitives.PrimitiveRectangle;
import undo.UndoManager;
import undo.UndoState;

public class ParseSchem {
    static final int MAX_TOKENS = 512;
    static final boolean useWindowsLineFeed = false;
    public String openFileName;
    private boolean changed = true;
    private boolean drawOnlyPads = false;
    private int drawOnlyLayer = -1;
    private String macroFont = "Courier New";
    private int macroFontSize;
    private boolean[] layersUsed;
    private int maxLayer;
    private boolean needHoles;
    private boolean hasFCJOriginVisible;
    private boolean firstDrag = false;
    private GraphicPrimitive primBeingDragged;
    private int handleBeingDragged = -1;
    private int opx;
    private int opy;
    private int oldpx;
    private int oldpy;
    private boolean hasMoved;
    private String[] tokens = new String[512];
    private int lineNum;
    Vector primitiveVector = new Vector(25);
    Vector layerV = new Vector(16);
    private Map library = new TreeMap();
    private UndoManager um = new UndoManager(100);
    private final int MAX_UNDO = 100;
    private boolean isModified;
    private HasChangedListener cl = null;
    private double oZ;
    private double oX;
    private double oY;
    private double oO;
    private GraphicPrimitive gg;
    private int i_index;
    private int j_index;
    private int la;
    private BufferedImage bufferedImage;
    private double oldZoom = -1.0;
    private TexturePaint tp;
    private int width;
    private int height;

    public ParseSchem() {
        this.layersUsed = new boolean[16];
    }

    public Vector getLayers() {
        return this.layerV;
    }

    public void setLayers(Vector v) {
        this.layerV = v;
        this.changed = true;
    }

    public Map getLibrary() {
        return this.library;
    }

    public void setLibrary(Map l) {
        this.library = l;
        this.changed = true;
    }

    public void resetLibrary() {
        this.setLibrary(new TreeMap());
    }

    public void loadLibraryDirectory(String s) {
        File dir = new File(s);
        String[] files = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".fcl");
            }
        });
        if (!dir.exists() || files == null) {
            if (!s.equals("")) {
                System.out.println("Warning! Library directory is incorrect:");
                System.out.println(s);
            }
            System.out.println("Activated FidoCadJ internal libraries and symbols.");
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir, files[i]);
            try {
                this.readLibraryFile(f.getPath());
                continue;
            }
            catch (IOException E) {
                System.out.println("Problems reading library " + f.getName() + " " + E);
            }
        }
    }

    public void loadLibraryInJar(URL s, String prefix) {
        try {
            this.readLibraryBufferedReader(new BufferedReader(new InputStreamReader(s.openStream(), "UTF8")), prefix);
        }
        catch (IOException E) {
            System.out.println("Problems reading library: " + s.toString());
        }
    }

    public void readLibraryFile(String openFileName) throws IOException {
        InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(openFileName), "UTF8");
        BufferedReader bufRead = new BufferedReader(input);
        String prefix = "";
        prefix = Globals.getFileNameOnly(openFileName);
        if (prefix.equals("FCDstdlib")) {
            prefix = "";
        }
        this.readLibraryBufferedReader(bufRead, prefix);
        bufRead.close();
    }

    public void readLibraryBufferedReader(BufferedReader bufRead, String prefix) throws IOException {
        String macroName = "";
        String longName = "";
        String categoryName = "";
        String libraryName = "";
        StringBuffer txt = new StringBuffer();
        String line = "";
        while ((line = bufRead.readLine()) != null) {
            int i;
            if ((line = line.trim()).length() <= 1) continue;
            if (line.charAt(0) == '{') {
                categoryName = "";
                for (i = 1; i < line.length() && line.charAt(i) != '}'; ++i) {
                    categoryName = categoryName + line.charAt(i);
                }
                if (i != line.length()) continue;
                IOException e = new IOException("Category non terminated with }.");
                throw e;
            }
            if (line.charAt(0) == '[') {
                int j;
                macroName = "";
                longName = "";
                for (i = 1; line.charAt(i) != ' ' && line.charAt(i) != ']' && i < line.length(); ++i) {
                    macroName = macroName + line.charAt(i);
                }
                for (j = i; j < line.length() && line.charAt(j) != ']'; ++j) {
                    longName = longName + line.charAt(j);
                }
                if (j == line.length()) {
                    IOException e = new IOException("Macro name non terminated with ].");
                    throw e;
                }
                if (macroName.equals("FIDOLIB")) {
                    libraryName = longName;
                    continue;
                }
                if (!prefix.equals("")) {
                    macroName = prefix + "." + macroName;
                }
                macroName = macroName.toLowerCase();
                this.library.put(macroName, new MacroDesc(macroName, "", "", "", ""));
                continue;
            }
            if (macroName.equals("")) continue;
            macroName = macroName.toLowerCase();
            this.library.put(macroName, new MacroDesc(macroName, longName, ((MacroDesc)this.library.get((Object)macroName)).description + "\n" + line, categoryName, libraryName));
        }
    }

    public void addPrimitive(GraphicPrimitive p, boolean save, boolean sort) {
        this.primitiveVector.add(p);
        if (save) {
            this.saveUndoState();
        }
        if (sort) {
            this.sortPrimitiveLayers();
        }
        this.changed = true;
    }

    public boolean containsLayer(int l) {
        return this.layersUsed[l];
    }

    public StringBuffer getText(boolean extensions) {
        StringBuffer s = this.registerConfiguration(extensions);
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            s.append(new StringBuffer(((GraphicPrimitive)this.primitiveVector.get(i)).toString(extensions)));
        }
        return s;
    }

    public StringBuffer registerConfiguration(boolean extensions) {
        StringBuffer s = new StringBuffer();
        if (extensions && 2.0 != Globals.diameterConnection) {
            s.append("FJC C " + Globals.diameterConnection + "\n");
        }
        Vector standardLayers = Globals.createStandardLayers();
        if (extensions) {
            for (int i = 0; i < this.layerV.size(); ++i) {
                LayerDesc l = (LayerDesc)this.layerV.get(i);
                String defaultName = ((LayerDesc)standardLayers.get(i)).getDescription();
                if (!l.getModified()) continue;
                int rgb = l.getColor().getRGB();
                float alpha = l.getAlpha();
                s.append("FJC L " + i + " " + rgb + " " + alpha + "\n");
                if (l.getDescription().equals(defaultName)) continue;
                s.append("FJC N " + i + " " + l.getDescription() + "\n");
            }
        }
        if (extensions && Globals.lineWidth != 0.5) {
            s.append("FJC A " + Globals.lineWidth + "\n");
        }
        if (extensions && Globals.lineWidthCircles != 0.35) {
            s.append("FJC B " + Globals.lineWidthCircles + "\n");
        }
        return s;
    }

    public final int getMaxLayer() {
        return this.maxLayer;
    }

    public synchronized void draw(Graphics2D G, MapCoordinates cs) {
        if (cs == null) {
            System.out.println("ParseSchem.draw: ouch... cs not initialized :-(");
            return;
        }
        if (this.changed || this.oZ != cs.getXMagnitude() || this.oX != cs.getXCenter() || this.oY != cs.getYCenter() || this.oO != (double)cs.getOrientation()) {
            this.oZ = cs.getXMagnitude();
            this.oX = cs.getXCenter();
            this.oY = cs.getYCenter();
            this.oO = cs.getOrientation();
            this.changed = false;
            this.i_index = 0;
            while (this.i_index < this.primitiveVector.size()) {
                ((GraphicPrimitive)this.primitiveVector.get(this.i_index)).setChanged(true);
                ++this.i_index;
            }
            if (!this.drawOnlyPads) {
                cs.resetMinMax();
            }
        }
        this.needHoles = this.drawOnlyPads;
        if (this.hasFCJOriginVisible) {
            G.setColor(Color.red);
            G.fillOval(cs.mapXi(100.0, 100.0, false) - 4, cs.mapYi(100.0, 100.0, false) - 4, 8, 8);
        }
        if (this.drawOnlyLayer >= 0 && !this.drawOnlyPads) {
            if (!this.layersUsed[this.drawOnlyLayer]) {
                return;
            }
            this.drawPrimitives(this.drawOnlyLayer, G, cs);
            return;
        }
        if (!this.drawOnlyPads) {
            this.j_index = 0;
            while (this.j_index < 16) {
                if (this.layersUsed[this.j_index]) {
                    this.drawPrimitives(this.j_index, G, cs);
                }
                ++this.j_index;
            }
        }
        if (this.needHoles) {
            this.i_index = 0;
            while (this.i_index < this.primitiveVector.size()) {
                this.gg = (GraphicPrimitive)this.primitiveVector.get(this.i_index);
                if (this.gg.needsHoles()) {
                    this.gg.setDrawOnlyPads(true);
                    this.gg.draw(G, cs, this.layerV);
                    this.gg.setDrawOnlyPads(false);
                }
                ++this.i_index;
            }
        }
    }

    private void drawPrimitives(int j_index, Graphics2D G, MapCoordinates cs) {
        for (int i_index = 0; i_index < this.primitiveVector.size(); ++i_index) {
            GraphicPrimitive gg = (GraphicPrimitive)this.primitiveVector.get(i_index);
            if (j_index > 0 && gg.layer > j_index) break;
            if (gg.containsLayer(j_index)) {
                gg.setDrawOnlyLayer(j_index);
                gg.draw(G, cs, this.layerV);
            }
            if (!gg.needsHoles()) continue;
            this.needHoles = true;
        }
    }

    public void setDrawOnlyPads(boolean pd) {
        this.drawOnlyPads = pd;
    }

    public void setDrawOnlyLayer(int la) {
        this.drawOnlyLayer = la;
    }

    public void drawGrid(Graphics2D G, MapCoordinates cs, int xmin, int ymin, int xmax, int ymax) {
        int dx = cs.getXGridStep();
        int dy = cs.getYGridStep();
        int mul = 1;
        double toll = 0.01;
        double z = cs.getYMagnitude();
        double m = 1.0;
        if (this.oldZoom != z || this.bufferedImage == null || this.tp == null) {
            for (double l = 1.0; l < 105.0; l += 1.0) {
                if (!(Math.abs(l * z - (double)Math.round(l * z)) < toll)) continue;
                mul = (int)l;
                break;
            }
            this.tp = null;
            double ddx = Math.abs(cs.mapXi(dx, 0.0, false) - cs.mapXi(0.0, 0.0, false));
            double ddy = Math.abs(cs.mapYi(0.0, dy, false) - cs.mapYi(0.0, 0.0, false));
            int d = 1;
            if (ddx > 50.0 || ddy > 50.0) {
                d = 2;
            } else if (ddx < 3.0 || ddy < 3.0) {
                dx = 5 * cs.getXGridStep();
                dy = 5 * cs.getYGridStep();
                ddx = Math.abs(cs.mapXi(dx, 0.0, false) - cs.mapXi(0.0, 0.0, false));
                ddy = Math.abs(cs.mapYi(0.0, dy, false) - cs.mapYi(0.0, 0.0, false));
            }
            this.width = Math.abs(cs.mapX(mul * dx, 0.0) - cs.mapX(0.0, 0.0));
            if (this.width <= 0) {
                this.width = 1;
            }
            this.height = Math.abs(cs.mapY(0.0, 0.0) - cs.mapY(0.0, mul * dy));
            if (this.height <= 0) {
                this.height = 1;
            }
            if (this.width > 1000 || this.height > 1000) {
                G.setColor(Color.white);
                G.fillRect(xmin, ymin, xmax, ymax);
                G.setColor(Color.gray);
                for (double x = (double)cs.unmapXsnap(xmin); x <= (double)cs.unmapXsnap(xmax); x += (double)dx) {
                    for (double y = (double)cs.unmapYsnap(ymin); y <= (double)cs.unmapYsnap(ymax); y += (double)dy) {
                        G.fillRect(cs.mapXi((int)x, (int)y, false), cs.mapYi((int)x, (int)y, false), d, d);
                    }
                }
                return;
            }
            try {
                this.bufferedImage = new BufferedImage(this.width, this.height, 4);
            }
            catch (OutOfMemoryError E) {
                System.out.println("Out of memory error when painting grid");
                return;
            }
            Graphics2D g2d = this.bufferedImage.createGraphics();
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, this.width, this.height);
            g2d.setColor(Color.gray);
            for (double x = 0.0; x <= (double)cs.unmapXsnap(this.width); x += (double)dx) {
                for (double y = 0.0; y <= (double)cs.unmapYsnap(this.height); y += (double)dy) {
                    g2d.fillRect(cs.mapX((int)x, (int)y), cs.mapY((int)x, (int)y), d, d);
                }
            }
            this.oldZoom = z;
            Rectangle anchor = new Rectangle(this.width, this.height);
            this.tp = new TexturePaint(this.bufferedImage, anchor);
        }
        G.setPaint(this.tp);
        G.fillRect(0, 0, xmax, ymax);
    }

    public void drawSelectedHandles(Graphics2D G, MapCoordinates cs) {
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            if (!((GraphicPrimitive)this.primitiveVector.get(i)).getSelected()) continue;
            ((GraphicPrimitive)this.primitiveVector.get(i)).drawHandles(G, cs);
        }
    }

    public void deselectAll() {
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            ((GraphicPrimitive)this.primitiveVector.get(i)).setSelected(false);
        }
    }

    public void selectAll() {
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            ((GraphicPrimitive)this.primitiveVector.get(i)).setSelected(true);
        }
    }

    public void deleteAllSelected() {
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            if (!((GraphicPrimitive)this.primitiveVector.get(i)).getSelected()) continue;
            this.primitiveVector.remove((GraphicPrimitive)this.primitiveVector.get(i--));
        }
        this.saveUndoState();
    }

    public void setTextFont(String f, int size) {
        this.macroFont = f;
        this.macroFontSize = size;
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            ((GraphicPrimitive)this.primitiveVector.get(i)).setMacroFont(f, size);
        }
        this.changed = true;
        this.isModified = true;
    }

    public String getTextFont() {
        return this.macroFont;
    }

    public int getTextFontSize() {
        int i = 0;
        if (i < this.primitiveVector.size()) {
            return ((GraphicPrimitive)this.primitiveVector.get(i)).getMacroFontSize();
        }
        return this.macroFontSize;
    }

    public void copySelected(boolean extensions, boolean splitNonStandard, int xstep, int ystep) {
        StringBuffer s = new StringBuffer("[FIDOCAD]\n");
        s.append(this.registerConfiguration(extensions));
        this.moveAllSelected(xstep, ystep);
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            if (!((GraphicPrimitive)this.primitiveVector.get(i)).getSelected()) continue;
            s.append(((GraphicPrimitive)this.primitiveVector.get(i)).toString(extensions));
        }
        this.moveAllSelected(-xstep, -ystep);
        if (splitNonStandard) {
            ParseSchem Q = new ParseSchem();
            Q.setLibrary(this.library);
            Q.setLayers(this.layerV);
            try {
                Q.parseString(s);
                File temp = File.createTempFile("copy", ".fcd");
                temp.deleteOnExit();
                ExportGraphic.export(temp, Q, "fcd", 1.0, true, false, extensions, false);
                FileInputStream input = new FileInputStream(temp);
                BufferedReader bufRead = new BufferedReader(new InputStreamReader((InputStream)input, "UTF8"));
                String line = "";
                StringBuffer txt = new StringBuffer(bufRead.readLine());
                txt.append("\n");
                while (line != null && (line = bufRead.readLine()) != null) {
                    txt.append(line);
                    txt.append("\n");
                }
                bufRead.close();
                s = txt;
            }
            catch (IOException e) {
                System.out.println("Error: " + e);
            }
        }
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferableText = new StringSelection(s.toString());
        systemClipboard.setContents(transferableText, null);
    }

    public void paste() {
        TextTransfer textTransfer = new TextTransfer();
        this.deselectAll();
        try {
            this.addString(new StringBuffer(textTransfer.getClipboardContents()), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveUndoState();
        this.setChanged(true);
    }

    public GraphicPrimitive getFirstSelectedPrimitive() {
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            GraphicPrimitive gp = (GraphicPrimitive)this.primitiveVector.get(i);
            if (!gp.getSelected()) continue;
            return gp;
        }
        return null;
    }

    public int distancePrimitive(int px, int py) {
        int mindistance = Integer.MAX_VALUE;
        int layer = 0;
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            GraphicPrimitive gg = (GraphicPrimitive)this.primitiveVector.get(i);
            int distance = gg.getDistanceToPoint(px, py);
            if (distance > mindistance) continue;
            layer = gg.getLayer();
            if (!((LayerDesc)this.layerV.get((int)layer)).isVisible) continue;
            mindistance = distance;
        }
        return mindistance;
    }

    public boolean selectPrimitive(int px, int py, int tolerance, boolean toggle) {
        int mindistance = Integer.MAX_VALUE;
        int isel = 0;
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            int distance;
            int layer = ((GraphicPrimitive)this.primitiveVector.get(i)).getLayer();
            if (!((LayerDesc)this.layerV.get((int)layer)).isVisible && !((GraphicPrimitive)this.primitiveVector.get(i) instanceof PrimitiveMacro) || (distance = ((GraphicPrimitive)this.primitiveVector.get(i)).getDistanceToPoint(px, py)) > mindistance) continue;
            isel = i;
            mindistance = distance;
        }
        if (mindistance < tolerance) {
            GraphicPrimitive gp = (GraphicPrimitive)this.primitiveVector.get(isel);
            if (!toggle) {
                gp.setSelected(true);
            } else {
                boolean sel = gp.getSelected();
                gp.setSelected(!sel);
            }
            return true;
        }
        return false;
    }

    public void rotateAllSelected() {
        int ix = 100;
        int iy = 100;
        boolean firstPrimitive = true;
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            if (!((GraphicPrimitive)this.primitiveVector.get(i)).getSelected()) continue;
            if (firstPrimitive) {
                ix = ((GraphicPrimitive)this.primitiveVector.get((int)i)).getFirstPoint().x;
                iy = ((GraphicPrimitive)this.primitiveVector.get((int)i)).getFirstPoint().y;
            }
            firstPrimitive = false;
            ((GraphicPrimitive)this.primitiveVector.get(i)).rotatePrimitive(false, ix, iy);
        }
        this.saveUndoState();
    }

    public void moveAllSelected(int dx, int dy) {
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            if (!((GraphicPrimitive)this.primitiveVector.get(i)).getSelected()) continue;
            ((GraphicPrimitive)this.primitiveVector.get(i)).movePrimitive(dx, dy);
        }
        this.saveUndoState();
    }

    public void mirrorAllSelected() {
        int ix = 100;
        boolean firstPrimitive = true;
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            if (!((GraphicPrimitive)this.primitiveVector.get(i)).getSelected()) continue;
            if (firstPrimitive) {
                ix = ((GraphicPrimitive)this.primitiveVector.get((int)i)).getFirstPoint().x;
            }
            firstPrimitive = false;
            ((GraphicPrimitive)this.primitiveVector.get(i)).mirrorPrimitive(ix);
        }
        this.saveUndoState();
    }

    public boolean selectRect(int px, int py, int w, int h) {
        int mindistance = Integer.MAX_VALUE;
        boolean isel = false;
        boolean s = false;
        if (w < 1 || h < 1) {
            return false;
        }
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            GraphicPrimitive gp = (GraphicPrimitive)this.primitiveVector.get(i);
            int layer = ((GraphicPrimitive)this.primitiveVector.get(i)).getLayer();
            if (layer < this.layerV.size() && !((LayerDesc)this.layerV.get((int)layer)).isVisible && !((GraphicPrimitive)this.primitiveVector.get(i) instanceof PrimitiveMacro) || !gp.selectRect(px, py, w, h)) continue;
            s = true;
        }
        return s;
    }

    public void dragHandleStart(int px, int py, int tolerance, boolean multiple, MapCoordinates cs) {
        int mindistance;
        int isel = 0;
        int distance = mindistance = Integer.MAX_VALUE;
        this.hasMoved = false;
        this.oldpx = cs.unmapXnosnap(px);
        this.oldpy = cs.unmapXnosnap(py);
        this.firstDrag = true;
        int sptol = Math.abs(cs.unmapXnosnap(px + tolerance) - cs.unmapXnosnap(px));
        if (sptol < 2) {
            sptol = 2;
        }
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            GraphicPrimitive gp = (GraphicPrimitive)this.primitiveVector.get(i);
            int layer = gp.getLayer();
            if (layer < this.layerV.size() && !((LayerDesc)this.layerV.get((int)layer)).isVisible && !(gp instanceof PrimitiveMacro)) continue;
            if (gp.selectedState) {
                this.handleBeingDragged = gp.onHandle(cs, px, py);
                if (this.handleBeingDragged != -1) {
                    this.primBeingDragged = gp;
                    continue;
                }
            }
            if ((distance = gp.getDistanceToPoint(this.oldpx, this.oldpy)) > mindistance) continue;
            isel = i;
            mindistance = distance;
        }
        if (mindistance < sptol && this.handleBeingDragged < 0) {
            this.primBeingDragged = (GraphicPrimitive)this.primitiveVector.get(isel);
            if (!multiple && !this.primBeingDragged.getSelected()) {
                this.deselectAll();
            }
            if (!multiple) {
                this.primBeingDragged.setSelected(true);
            }
            this.handleBeingDragged = -2;
            this.firstDrag = true;
            this.oldpx = cs.unmapXsnap(px);
            this.oldpy = cs.unmapXsnap(py);
        } else if (this.handleBeingDragged < 0) {
            this.oldpx = cs.unmapXsnap(px);
            this.oldpy = cs.unmapXsnap(py);
            this.handleBeingDragged = -3;
        }
    }

    public void dragHandleEnd(CircuitPanel P, int px, int py, boolean multiple, MapCoordinates cs) {
        P.setEvidenceRect(0, 0, -1, -1);
        if (this.handleBeingDragged < 0) {
            if (this.handleBeingDragged == -3) {
                int xa = Math.min(this.oldpx, cs.unmapXnosnap(px));
                int ya = Math.min(this.oldpy, cs.unmapYnosnap(py));
                int xb = Math.max(this.oldpx, cs.unmapXnosnap(px));
                int yb = Math.max(this.oldpy, cs.unmapYnosnap(py));
                if (!multiple) {
                    this.deselectAll();
                }
                this.selectRect(xa, ya, xb - xa, yb - ya);
            }
            if (this.handleBeingDragged == -2 && this.hasMoved) {
                this.saveUndoState();
            }
            this.handleBeingDragged = -1;
            return;
        }
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].x = cs.unmapXsnap(px);
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].y = cs.unmapYsnap(py);
        this.handleBeingDragged = -1;
        this.saveUndoState();
    }

    public void dragHandleDrag(CircuitPanel P, Graphics2D g, int px, int py, MapCoordinates cs) {
        this.hasMoved = true;
        if (this.handleBeingDragged < 0) {
            if (this.handleBeingDragged == -2) {
                this.dragPrimitives(P, g, px, py, cs);
            }
            if (this.handleBeingDragged == -3) {
                int xa = cs.mapXi(this.oldpx, this.oldpy, false);
                int ya = cs.mapYi(this.oldpx, this.oldpy, false);
                int xb = this.opx;
                int yb = this.opy;
                g.setStroke(new BasicStroke(1.0f));
                if (!this.firstDrag) {
                    boolean flip = false;
                    int a = Math.min(xa, xb);
                    int b = Math.min(ya, yb);
                    int c = Math.abs(xb - xa);
                    int d = Math.abs(yb - ya);
                    if (this.opx > xa && px < xa) {
                        flip = true;
                    }
                    if (this.opy > ya && py < ya) {
                        flip = true;
                    }
                    xb = px;
                    yb = py;
                    this.opx = px;
                    this.opy = py;
                    P.setEvidenceRect(Math.min(xa, xb), Math.min(ya, yb), Math.abs(xb - xa), Math.abs(yb - ya));
                    a = Math.min(a, Math.min(xa, xb));
                    b = Math.min(b, Math.min(ya, yb));
                    c = Math.max(c, Math.abs(xb - xa));
                    d = Math.max(d, Math.abs(yb - ya));
                    if (!flip) {
                        P.repaint(a, b, c + 10, d + 10);
                    } else {
                        P.repaint();
                    }
                    return;
                }
                xb = px;
                yb = py;
                this.opx = px;
                this.opy = py;
                this.firstDrag = false;
                g.setColor(Color.green);
                g.drawRect(Math.min(xa, xb), Math.min(ya, yb), Math.abs(xb - xa), Math.abs(yb - ya));
            }
            return;
        }
        if (!this.firstDrag) {
            P.repaint();
        }
        this.firstDrag = false;
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].x = cs.unmapXsnap(px);
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].y = cs.unmapYsnap(py);
        this.primBeingDragged.setChanged(true);
    }

    public void dragPrimitives(CircuitPanel P, Graphics2D g, int px, int py, MapCoordinates cs) {
        if (this.handleBeingDragged != -2) {
            return;
        }
        this.firstDrag = false;
        int dx = cs.unmapXsnap(px) - this.oldpx;
        int dy = cs.unmapYsnap(py) - this.oldpy;
        this.oldpx = cs.unmapXsnap(px);
        this.oldpy = cs.unmapXsnap(py);
        if (dx == 0 && dy == 0) {
            return;
        }
        for (int i = 0; i < this.primitiveVector.size(); ++i) {
            this.primBeingDragged = (GraphicPrimitive)this.primitiveVector.get(i);
            if (!this.primBeingDragged.getSelected()) continue;
            if (this.primBeingDragged instanceof PrimitiveMacro) {
                ((PrimitiveMacro)this.primBeingDragged).setDrawOnlyLayer(-1);
            }
            this.primBeingDragged.setChanged(true);
            if (!this.firstDrag) {
                P.repaint();
            }
            for (int j = 0; j < this.primBeingDragged.getControlPointNumber(); ++j) {
                this.primBeingDragged.virtualPoint[j].x += dx;
                this.primBeingDragged.virtualPoint[j].y += dy;
            }
        }
    }

    public void parseString(StringBuffer s) throws IOException {
        this.primitiveVector.clear();
        this.addString(s, false);
        this.setChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addString(StringBuffer s, boolean selectNew) throws IOException {
        boolean hasFCJ = false;
        StringBuffer token = new StringBuffer();
        GraphicPrimitive g = new PrimitiveLine();
        String[] old_tokens = new String[512];
        String[] name = new String[512];
        String[] value = new String[512];
        double newConnectionSize = -1.0;
        double newLineWidth = -1.0;
        double newLineWidthCircles = -1.0;
        int vn = 0;
        int vv = 0;
        int old_j = 0;
        int macro_counter = 0;
        token.ensureCapacity(256);
        char c = '\n';
        this.lineNum = 1;
        int j = 0;
        token.setLength(0);
        int len = s.length();
        ParseSchem parseSchem = this;
        synchronized (parseSchem) {
            for (int i = 0; i < len; ++i) {
                c = s.charAt(i);
                if (c == '\n' || c == '\r' || i == len - 1) {
                    if (i == len - 1 && c != '\n' && c != ' ') {
                        token.append(c);
                    }
                    ++this.lineNum;
                    this.tokens[j] = token.toString();
                    if (token.length() == 0) {
                        --j;
                    }
                    try {
                        int l;
                        if (hasFCJ && !this.tokens[0].equals("FCJ")) {
                            hasFCJ = this.registerPrimitivesWithFCJ(hasFCJ, this.tokens, g, old_tokens, old_j, selectNew);
                        }
                        if (this.tokens[0].equals("FCJ")) {
                            if (hasFCJ && old_tokens[0].equals("MC")) {
                                macro_counter = 2;
                                g = new PrimitiveMacro(this.library, this.layerV);
                                g.parseTokens(old_tokens, old_j + 1);
                            } else if (hasFCJ && old_tokens[0].equals("LI")) {
                                g = new PrimitiveLine();
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = this.tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 5 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.addPrimitive(g, false, false);
                                }
                            } else if (hasFCJ && old_tokens[0].equals("BE")) {
                                g = new PrimitiveBezier();
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = this.tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 5 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.addPrimitive(g, false, false);
                                }
                            } else if (hasFCJ && (old_tokens[0].equals("RV") || old_tokens[0].equals("RP"))) {
                                g = new PrimitiveRectangle();
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = this.tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 2 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.addPrimitive(g, false, false);
                                }
                            } else if (hasFCJ && (old_tokens[0].equals("EV") || old_tokens[0].equals("EP"))) {
                                g = new PrimitiveOval();
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = this.tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 2 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.addPrimitive(g, false, false);
                                }
                            } else if (hasFCJ && (old_tokens[0].equals("PV") || old_tokens[0].equals("PP"))) {
                                g = new PrimitivePolygon();
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = this.tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 2 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.addPrimitive(g, false, false);
                                }
                            } else if (hasFCJ && (old_tokens[0].equals("CV") || old_tokens[0].equals("CP"))) {
                                g = new PrimitiveComplexCurve();
                                for (l = 0; l < j + 1; ++l) {
                                    old_tokens[l + old_j + 1] = this.tokens[l];
                                }
                                g.parseTokens(old_tokens, (old_j += j + 1) + 1);
                                g.setSelected(selectNew);
                                if (old_j > 2 && old_tokens[old_j].equals("1")) {
                                    macro_counter = 2;
                                } else {
                                    this.addPrimitive(g, false, false);
                                }
                            } else if (hasFCJ && old_tokens[0].equals("PL")) {
                                macro_counter = 2;
                            } else if (hasFCJ && old_tokens[0].equals("PA")) {
                                macro_counter = 2;
                            } else if (hasFCJ && old_tokens[0].equals("SA")) {
                                macro_counter = 2;
                            }
                            hasFCJ = false;
                        } else if (this.tokens[0].equals("FJC")) {
                            if (this.tokens[1].equals("C")) {
                                newConnectionSize = Double.parseDouble(this.tokens[2]);
                            } else if (this.tokens[1].equals("L")) {
                                int layerNum = Integer.parseInt(this.tokens[2]);
                                if (layerNum >= 0 && layerNum < this.layerV.size()) {
                                    int rgb = Integer.parseInt(this.tokens[3]);
                                    float alpha = Float.parseFloat(this.tokens[4]);
                                    LayerDesc ll = (LayerDesc)this.layerV.get(layerNum);
                                    ll.setColor(new Color(rgb));
                                    ll.setAlpha(alpha);
                                    ll.setModified(true);
                                }
                            } else if (this.tokens[1].equals("N")) {
                                int layerNum = Integer.parseInt(this.tokens[2]);
                                if (layerNum >= 0 && layerNum < this.layerV.size()) {
                                    String lName = "";
                                    for (int t = 3; t < j + 1; ++t) {
                                        lName = lName + this.tokens[t] + " ";
                                    }
                                    LayerDesc ll = (LayerDesc)this.layerV.get(layerNum);
                                    ll.setDescription(lName);
                                    ll.setModified(true);
                                }
                            } else if (this.tokens[1].equals("A")) {
                                newLineWidth = Double.parseDouble(this.tokens[2]);
                            } else if (this.tokens[1].equals("B")) {
                                newLineWidthCircles = Double.parseDouble(this.tokens[2]);
                            }
                        } else if (this.tokens[0].equals("LI")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (this.tokens[0].equals("BE")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (this.tokens[0].equals("MC")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (this.tokens[0].equals("TE")) {
                            hasFCJ = false;
                            macro_counter = 0;
                            g = new PrimitiveAdvText();
                            g.parseTokens(this.tokens, j + 1);
                            g.setSelected(selectNew);
                            this.addPrimitive(g, false, false);
                        } else if (this.tokens[0].equals("TY")) {
                            hasFCJ = false;
                            if (macro_counter == 2) {
                                --macro_counter;
                                for (l = 0; l < j + 1; ++l) {
                                    name[l] = this.tokens[l];
                                }
                                vn = j;
                            } else if (macro_counter == 1) {
                                for (l = 0; l < j + 1; ++l) {
                                    value[l] = this.tokens[l];
                                }
                                vv = j;
                                g.setName(name, vn + 1);
                                g.setValue(value, vv + 1);
                                g.setSelected(selectNew);
                                this.addPrimitive(g, false, false);
                                macro_counter = 0;
                            } else {
                                g = new PrimitiveAdvText();
                                g.parseTokens(this.tokens, j + 1);
                                g.setSelected(selectNew);
                                this.addPrimitive(g, false, false);
                            }
                        } else if (this.tokens[0].equals("PL")) {
                            hasFCJ = true;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            macro_counter = 0;
                            old_j = j;
                            g = new PrimitivePCBLine();
                            g.parseTokens(this.tokens, j + 1);
                            g.setSelected(selectNew);
                        } else if (this.tokens[0].equals("PA")) {
                            hasFCJ = true;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            macro_counter = 0;
                            g = new PrimitivePCBPad();
                            old_j = j;
                            g.parseTokens(this.tokens, j + 1);
                            g.setSelected(selectNew);
                        } else if (this.tokens[0].equals("SA")) {
                            hasFCJ = true;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            old_j = j;
                            macro_counter = 0;
                            g = new PrimitiveConnection();
                            g.parseTokens(this.tokens, j + 1);
                            g.setSelected(selectNew);
                        } else if (this.tokens[0].equals("EV") || this.tokens[0].equals("EP")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (this.tokens[0].equals("RV") || this.tokens[0].equals("RP")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (this.tokens[0].equals("PV") || this.tokens[0].equals("PP")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        } else if (this.tokens[0].equals("CV") || this.tokens[0].equals("CP")) {
                            macro_counter = 0;
                            for (l = 0; l < j + 1; ++l) {
                                old_tokens[l] = this.tokens[l];
                            }
                            old_j = j;
                            hasFCJ = true;
                        }
                    }
                    catch (IOException E) {
                        System.out.println("Error encountered: " + E.toString());
                        System.out.println("string parsing line: " + this.lineNum);
                        hasFCJ = false;
                        macro_counter = 0;
                    }
                    catch (NumberFormatException F) {
                        System.out.println("I could not read a number at line: " + this.lineNum);
                        hasFCJ = false;
                        macro_counter = 0;
                    }
                    j = 0;
                    token.setLength(0);
                    continue;
                }
                if (c == ' ') {
                    this.tokens[j] = token.toString();
                    if (++j >= 512) {
                        IOException e = new IOException("Too much tokens!");
                        throw e;
                    }
                    token.setLength(0);
                    continue;
                }
                token.append(c);
            }
            try {
                this.registerPrimitivesWithFCJ(hasFCJ, this.tokens, g, old_tokens, old_j, selectNew);
            }
            catch (IOException E) {
                System.out.println("Error encountered: " + E.toString());
                System.out.println("string parsing line: " + this.lineNum);
            }
            catch (NumberFormatException F) {
                System.out.println("I could not read a number at line: " + this.lineNum);
            }
            if (newConnectionSize > 0.0) {
                Globals.diameterConnection = newConnectionSize;
            }
            if (newLineWidth > 0.0) {
                Globals.lineWidth = newLineWidth;
            }
            if (newLineWidthCircles > 0.0) {
                Globals.lineWidthCircles = newLineWidthCircles;
            }
            this.sortPrimitiveLayers();
        }
    }

    private boolean registerPrimitivesWithFCJ(boolean hasFCJ, String[] tokens, GraphicPrimitive g, String[] old_tokens, int old_j, boolean selectNew) throws IOException {
        boolean addPrimitive = false;
        if (hasFCJ && !tokens[0].equals("FCJ")) {
            if (old_tokens[0].equals("MC")) {
                g = new PrimitiveMacro(this.library, this.layerV);
                addPrimitive = true;
            } else if (old_tokens[0].equals("LI")) {
                g = new PrimitiveLine();
                addPrimitive = true;
            } else if (old_tokens[0].equals("BE")) {
                g = new PrimitiveBezier();
                addPrimitive = true;
            } else if (old_tokens[0].equals("RP") || old_tokens[0].equals("RV")) {
                g = new PrimitiveRectangle();
                addPrimitive = true;
            } else if (old_tokens[0].equals("EP") || old_tokens[0].equals("EV")) {
                g = new PrimitiveOval();
                addPrimitive = true;
            } else if (old_tokens[0].equals("PP") || old_tokens[0].equals("PV")) {
                g = new PrimitivePolygon();
                addPrimitive = true;
            } else if (old_tokens[0].equals("PL")) {
                g = new PrimitivePCBLine();
                addPrimitive = true;
            } else if (old_tokens[0].equals("CP") || old_tokens[0].equals("CV")) {
                g = new PrimitiveComplexCurve();
                addPrimitive = true;
            } else if (old_tokens[0].equals("PA")) {
                g = new PrimitivePCBPad();
                addPrimitive = true;
            } else if (old_tokens[0].equals("SA")) {
                g = new PrimitiveConnection();
                addPrimitive = true;
            }
        }
        if (addPrimitive) {
            g.parseTokens(old_tokens, old_j + 1);
            g.setSelected(selectNew);
            this.addPrimitive(g, false, false);
            hasFCJ = false;
        }
        return hasFCJ;
    }

    public void sortPrimitiveLayers() {
        int i;
        int l;
        boolean cont = true;
        this.maxLayer = 0;
        for (l = this.primitiveVector.size() / 2; l > 0; l /= 2) {
            for (int j = l; j < this.primitiveVector.size(); ++j) {
                for (i = j - l; i >= 0 && ((GraphicPrimitive)this.primitiveVector.get((int)(i + l))).layer < ((GraphicPrimitive)this.primitiveVector.get((int)i)).layer; i -= l) {
                    GraphicPrimitive s = (GraphicPrimitive)this.primitiveVector.get(i);
                    this.primitiveVector.set(i, this.primitiveVector.get(i + l));
                    this.primitiveVector.set(i + l, s);
                }
            }
        }
        this.maxLayer = -1;
        for (l = 0; l < 16; ++l) {
            this.layersUsed[l] = false;
            for (i = 0; i < this.primitiveVector.size(); ++i) {
                GraphicPrimitive g = (GraphicPrimitive)this.primitiveVector.get(i);
                if (g.containsLayer(l)) {
                    this.layersUsed[l] = true;
                }
                if (g.layer <= this.maxLayer) continue;
                this.maxLayer = g.layer;
            }
        }
    }

    public void exportDrawing(ExportInterface exp, boolean header, boolean exportInvisible, MapCoordinates mp) throws IOException {
        int l;
        GraphicPrimitive g;
        int i;
        if (header) {
            Dimension d = ExportGraphic.getImageSize(this, 1.0, true);
            d.width += 6;
            d.height += 6;
            d.width = (int)((double)d.width * mp.getXMagnitude());
            d.height = (int)((double)d.height * mp.getYMagnitude());
            exp.exportStart(d, this.layerV, mp.getXGridStep());
        }
        if (this.drawOnlyLayer >= 0 && !this.drawOnlyPads) {
            for (int i2 = 0; i2 < this.primitiveVector.size(); ++i2) {
                GraphicPrimitive g2 = (GraphicPrimitive)this.primitiveVector.get(i2);
                int l2 = g2.getLayer();
                if (l2 == this.drawOnlyLayer && !(g2 instanceof PrimitiveMacro)) {
                    if (!((LayerDesc)this.layerV.get((int)l2)).isVisible && !exportInvisible) continue;
                    g2.export(exp, mp);
                    continue;
                }
                if (!(g2 instanceof PrimitiveMacro)) continue;
                ((PrimitiveMacro)g2).setDrawOnlyLayer(this.drawOnlyLayer);
                ((PrimitiveMacro)g2).setExportInvisible(exportInvisible);
                if (!((LayerDesc)this.layerV.get((int)l2)).isVisible && !exportInvisible) continue;
                g2.export(exp, mp);
            }
            return;
        }
        if (!this.drawOnlyPads) {
            for (int j = 0; j < this.layerV.size(); ++j) {
                for (i = 0; i < this.primitiveVector.size(); ++i) {
                    g = (GraphicPrimitive)this.primitiveVector.get(i);
                    l = g.getLayer();
                    if (l == j && !(g instanceof PrimitiveMacro)) {
                        if (!((LayerDesc)this.layerV.get((int)l)).isVisible && !exportInvisible) continue;
                        g.export(exp, mp);
                        continue;
                    }
                    if (!(g instanceof PrimitiveMacro)) continue;
                    ((PrimitiveMacro)g).setDrawOnlyLayer(j);
                    ((PrimitiveMacro)g).setExportInvisible(exportInvisible);
                    if (!((LayerDesc)this.layerV.get((int)l)).isVisible && !exportInvisible) continue;
                    g.export(exp, mp);
                }
            }
        }
        for (i = 0; i < this.primitiveVector.size(); ++i) {
            g = (GraphicPrimitive)this.primitiveVector.get(i);
            if (g instanceof PrimitivePCBPad) {
                ((PrimitivePCBPad)g).setDrawOnlyPads(true);
                l = g.getLayer();
                if (((LayerDesc)this.layerV.get((int)l)).isVisible || exportInvisible) {
                    g.export(exp, mp);
                }
                ((PrimitivePCBPad)g).setDrawOnlyPads(false);
                continue;
            }
            if (!(g instanceof PrimitiveMacro)) continue;
            ((PrimitiveMacro)g).setExportInvisible(exportInvisible);
            ((PrimitiveMacro)g).setDrawOnlyPads(true);
            l = g.getLayer();
            if (((LayerDesc)this.layerV.get((int)l)).isVisible || exportInvisible) {
                g.export(exp, mp);
            }
            ((PrimitiveMacro)g).setDrawOnlyPads(false);
            ((PrimitiveMacro)g).resetExport();
        }
        if (header) {
            exp.exportEnd();
        }
    }

    public void undo() {
        try {
            UndoState r = (UndoState)this.um.undoPop();
            StringBuffer s = new StringBuffer(r.text);
            this.parseString(s);
            this.isModified = r.isModified;
            this.openFileName = r.fileName;
            if (this.cl != null) {
                this.cl.somethingHasChanged();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            UndoState r = (UndoState)this.um.undoRedo();
            StringBuffer s = new StringBuffer(r.text);
            this.parseString(s);
            this.isModified = r.isModified;
            this.openFileName = r.fileName;
            if (this.cl != null) {
                this.cl.somethingHasChanged();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveUndoState() {
        UndoState s = new UndoState();
        s.text = this.getText(true).toString();
        s.isModified = this.isModified;
        s.fileName = this.openFileName;
        this.um.undoPush(s);
        this.isModified = true;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    public boolean getModified() {
        return this.isModified;
    }

    public void setModified(boolean s) {
        this.isModified = s;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    public void setHasChangedListener(HasChangedListener l) {
        this.cl = l;
    }

    public void setMacroOriginVisible(boolean s) {
        this.hasFCJOriginVisible = s;
    }

    public boolean isEmpty() {
        return this.primitiveVector.size() == 0;
    }

    public final boolean getNeedHoles() {
        return this.needHoles;
    }

    public final void setChanged(boolean c) {
        this.changed = c;
    }
}

