/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import dialogs.DialogUtil;
import globals.Globals;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import layers.LayerDesc;

public class DialogEditLayer
extends JDialog
implements ComponentListener {
    private static final int MIN_WIDTH = 500;
    private static final int MIN_HEIGHT = 450;
    static final int ALPHA_MIN = 0;
    static final int ALPHA_MAX = 100;
    private JButton color;
    private JColorChooser tcc;
    private JCheckBox visibility;
    private JTextField description;
    private JSlider opacity;
    private boolean active;
    private LayerDesc ll;

    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean resize = false;
        if (width < 500) {
            resize = true;
            width = 500;
        }
        if (height < 450) {
            resize = true;
            height = 450;
        }
        if (resize) {
            this.setSize(width, height);
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public DialogEditLayer(JFrame parent, LayerDesc l) {
        super(parent, Globals.messages.getString("Layer_options") + l.getDescription(), true);
        this.ll = l;
        this.addComponentListener(this);
        this.active = false;
        Container contentPane = this.getContentPane();
        GridBagLayout bgl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        contentPane.setLayout(bgl);
        constraints.insets.right = 30;
        this.tcc = new JColorChooser(l.getColor());
        constraints = DialogUtil.createConst(0, 0, 3, 1, 100, 100, 10, 0, new Insets(20, 20, 6, 20));
        contentPane.add((Component)this.tcc, constraints);
        JLabel descrLabel = new JLabel(Globals.messages.getString("Description"));
        constraints = DialogUtil.createConst(1, 1, 1, 1, 100, 100, 13, 0, new Insets(0, 20, 0, 0));
        contentPane.add((Component)descrLabel, constraints);
        this.description = new JTextField();
        this.description.setText(l.getDescription());
        constraints = DialogUtil.createConst(2, 1, 1, 1, 100, 0, 17, 2, new Insets(0, 0, 0, 120));
        contentPane.add((Component)this.description, constraints);
        JLabel opacityLbl = new JLabel(Globals.messages.getString("Opacity"));
        constraints = DialogUtil.createConst(1, 3, 1, 1, 100, 0, 13, 0, new Insets(0, 0, 0, 20));
        contentPane.add((Component)opacityLbl, constraints);
        this.opacity = new JSlider(0, 0, 100, Math.round(l.getAlpha() * 100.0f));
        this.opacity.setMajorTickSpacing(20);
        this.opacity.setMinorTickSpacing(1);
        this.opacity.setPaintTicks(true);
        this.opacity.setPaintLabels(true);
        constraints = DialogUtil.createConst(2, 3, 1, 1, 100, 0, 17, 2, new Insets(0, 0, 0, 120));
        contentPane.add((Component)this.opacity, constraints);
        this.visibility = new JCheckBox(Globals.messages.getString("IsVisible"));
        this.visibility.setSelected(l.getVisible());
        constraints = DialogUtil.createConst(2, 4, 1, 1, 100, 0, 17, 2, new Insets(0, 0, 20, 120));
        contentPane.add((Component)this.visibility, constraints);
        JButton ok = new JButton(Globals.messages.getString("Ok_btn"));
        JButton cancel = new JButton(Globals.messages.getString("Cancel_btn"));
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        ok.setPreferredSize(cancel.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            b.add(ok);
            b.add(Box.createHorizontalStrut(12));
            b.add(cancel);
        } else {
            b.add(cancel);
            b.add(Box.createHorizontalStrut(12));
            b.add(ok);
        }
        constraints = DialogUtil.createConst(0, 5, 3, 1, 100, 0, 17, 2, new Insets(0, 20, 20, 20));
        contentPane.add((Component)b, constraints);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogEditLayer.this.active = true;
                DialogEditLayer.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(ok);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogEditLayer.this.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DialogEditLayer.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, cancelAction);
        this.pack();
        DialogUtil.center(this);
    }

    public void acceptLayer() {
        this.ll.setVisible(this.visibility.isSelected());
        this.ll.setDescription(this.description.getText());
        this.ll.setColor(this.tcc.getColor());
        this.ll.setAlpha((float)this.opacity.getValue() / 100.0f);
        this.ll.setModified(true);
    }

    public boolean getActive() {
        return this.active;
    }
}

