/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import dialogs.ActionDClick;
import dialogs.DialogEditLayer;
import dialogs.DialogUtil;
import dialogs.LayerCellRenderer;
import globals.Globals;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import layers.LayerDesc;

public class DialogLayer
extends JDialog
implements ComponentListener {
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 350;
    private Vector layers;
    public JList layerList;

    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean resize = false;
        if (width < 400) {
            resize = true;
            width = 400;
        }
        if (height < 350) {
            resize = true;
            height = 350;
        }
        if (resize) {
            this.setSize(width, height);
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public DialogLayer(JFrame parent, Vector l) {
        super(parent, Globals.messages.getString("Layer_editor"), true);
        DialogUtil.center(this, 0.4, 0.4, 400, 350);
        this.addComponentListener(this);
        this.layers = l;
        this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        GridBagLayout bgl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(bgl);
        this.layerList = new JList(new Vector(this.layers));
        JScrollPane sl = new JScrollPane(this.layerList);
        this.layerList.setCellRenderer(new LayerCellRenderer());
        constraints = DialogUtil.createConst(0, 0, 1, 1, 100, 100, 13, 1, new Insets(20, 20, 6, 20));
        contentPane.add((Component)sl, constraints);
        JButton ok = new JButton(Globals.messages.getString("Ok_btn"));
        JButton cancel = new JButton(Globals.messages.getString("Cancel_btn"));
        JButton edit = new JButton(Globals.messages.getString("Edit"));
        Box b = Box.createHorizontalBox();
        b.add(edit);
        b.add(Box.createHorizontalGlue());
        ok.setPreferredSize(cancel.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            b.add(ok);
            b.add(Box.createHorizontalStrut(12));
            b.add(cancel);
        } else {
            b.add(cancel);
            b.add(Box.createHorizontalStrut(12));
            b.add(ok);
        }
        constraints = DialogUtil.createConst(0, 1, 1, 1, 100, 0, 13, 2, new Insets(0, 20, 20, 20));
        contentPane.add((Component)b, constraints);
        this.layerList.addMouseListener(new ActionDClick(this));
        edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogLayer.this.activateLayerEditor(DialogLayer.this.layerList.getSelectedIndex());
            }
        });
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogLayer.this.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogLayer.this.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DialogLayer.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, cancelAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(ok);
    }

    public void activateLayerEditor(int index) {
        if (index >= 0) {
            DialogEditLayer del = new DialogEditLayer(null, (LayerDesc)this.layers.get(this.layerList.getSelectedIndex()));
            del.setVisible(true);
            if (del.getActive()) {
                del.acceptLayer();
                this.repaint();
            }
        } else {
            JOptionPane.showMessageDialog(null, Globals.messages.getString("Warning_select_layer"), Globals.messages.getString("Layer_editor"), 1, null);
        }
    }
}

