/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import dialogs.ArrowCellRenderer;
import dialogs.ArrowInfo;
import dialogs.DashCellRenderer;
import dialogs.DashInfo;
import dialogs.DialogUtil;
import dialogs.LayerCellRenderer;
import dialogs.LayerInfo;
import dialogs.ParameterDescription;
import globals.Globals;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class DialogParameters
extends JDialog
implements ComponentListener {
    private static final int MIN_WIDTH = 350;
    private static final int MIN_HEIGHT = 300;
    private static final int MAX = 20;
    private static final int MAX_ELEMENTS = 100;
    public boolean active;
    private JTextField[] jtf;
    private int tc;
    private JCheckBox[] jcb;
    private int cc;
    private boolean extStrict;
    private JComboBox[] jco;
    private int co;
    private Vector v;
    private Vector layers;

    public DialogParameters(JFrame parent, Vector vec, boolean strict, Vector l) {
        super(parent, Globals.messages.getString("Param_opt"), true);
        this.v = vec;
        this.layers = l;
        int ycount = 0;
        this.jtf = new JTextField[100];
        this.jcb = new JCheckBox[100];
        this.jco = new JComboBox[100];
        this.active = false;
        this.addComponentListener(this);
        this.setSize(400, 300);
        GridBagLayout bgl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(bgl);
        this.extStrict = strict;
        int top = 0;
        this.tc = 0;
        this.cc = 0;
        this.co = 0;
        for (ycount = 0; ycount < this.v.size() && ycount <= 20; ++ycount) {
            GraphicsEnvironment gE;
            ParameterDescription pd = (ParameterDescription)this.v.elementAt(ycount);
            JLabel lab = new JLabel(pd.description);
            constraints.weightx = 100.0;
            constraints.weighty = 100.0;
            constraints.gridx = 1;
            constraints.gridy = ycount;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            top = ycount == 0 ? 10 : 0;
            constraints.insets = new Insets(top, 20, 0, 6);
            constraints.fill = 3;
            constraints.anchor = 13;
            lab.setEnabled(!pd.isExtension || !this.extStrict);
            if (!(pd.parameter instanceof Boolean)) {
                contentPane.add((Component)lab, constraints);
            }
            constraints.anchor = 17;
            constraints.insets = new Insets(top, 0, 0, 0);
            constraints.fill = 2;
            if (pd.parameter instanceof Point) {
                this.jtf[this.tc] = new JTextField(10);
                this.jtf[this.tc].setText("" + ((Point)pd.parameter).x);
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.jtf[this.tc].setEnabled(!pd.isExtension || !this.extStrict);
                contentPane.add((Component)this.jtf[this.tc++], constraints);
                this.jtf[this.tc] = new JTextField(10);
                this.jtf[this.tc].setText("" + ((Point)pd.parameter).y);
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 3;
                constraints.gridy = ycount;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 6, 0, 20);
                constraints.fill = 2;
                this.jtf[this.tc].setEnabled(!pd.isExtension || !this.extStrict);
                contentPane.add((Component)this.jtf[this.tc++], constraints);
                continue;
            }
            if (pd.parameter instanceof String) {
                this.jtf[this.tc] = new JTextField(24);
                this.jtf[this.tc].setText((String)pd.parameter);
                if (ycount == 0) {
                    this.jtf[this.tc].selectAll();
                }
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jtf[this.tc].setEnabled(!pd.isExtension || !this.extStrict);
                contentPane.add((Component)this.jtf[this.tc++], constraints);
                continue;
            }
            if (pd.parameter instanceof Boolean) {
                this.jcb[this.cc] = new JCheckBox(pd.description);
                this.jcb[this.cc].setSelected((Boolean)pd.parameter);
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jcb[this.cc].setEnabled(!pd.isExtension || !this.extStrict);
                contentPane.add((Component)this.jcb[this.cc++], constraints);
                continue;
            }
            if (pd.parameter instanceof Integer) {
                this.jtf[this.tc] = new JTextField(24);
                this.jtf[this.tc].setText(((Integer)pd.parameter).toString());
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jtf[this.tc].setEnabled(!pd.isExtension || !this.extStrict);
                contentPane.add((Component)this.jtf[this.tc++], constraints);
                continue;
            }
            if (pd.parameter instanceof Font) {
                gE = GraphicsEnvironment.getLocalGraphicsEnvironment();
                String[] s = gE.getAvailableFontFamilyNames();
                this.jco[this.co] = new JComboBox();
                for (int i = 0; i < s.length; ++i) {
                    this.jco[this.co].addItem(s[i]);
                    if (!s[i].equals(((Font)pd.parameter).getFamily())) continue;
                    this.jco[this.co].setSelectedIndex(i);
                }
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jco[this.co].setEnabled(!pd.isExtension || !this.extStrict);
                contentPane.add((Component)this.jco[this.co++], constraints);
                continue;
            }
            if (pd.parameter instanceof LayerInfo) {
                gE = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this.jco[this.co] = new JComboBox(new Vector(this.layers));
                this.jco[this.co].setSelectedIndex(((LayerInfo)pd.parameter).layer);
                this.jco[this.co].setRenderer(new LayerCellRenderer());
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jco[this.co].setEnabled(!pd.isExtension || !this.extStrict);
                contentPane.add((Component)this.jco[this.co++], constraints);
                continue;
            }
            if (pd.parameter instanceof ArrowInfo) {
                gE = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this.jco[this.co] = new JComboBox();
                this.jco[this.co].addItem(new ArrowInfo(0));
                this.jco[this.co].addItem(new ArrowInfo(1));
                this.jco[this.co].addItem(new ArrowInfo(2));
                this.jco[this.co].addItem(new ArrowInfo(3));
                this.jco[this.co].setSelectedIndex(((ArrowInfo)pd.parameter).style);
                this.jco[this.co].setRenderer(new ArrowCellRenderer());
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jco[this.co].setEnabled(!pd.isExtension || !this.extStrict);
                contentPane.add((Component)this.jco[this.co++], constraints);
                continue;
            }
            if (!(pd.parameter instanceof DashInfo)) continue;
            gE = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.jco[this.co] = new JComboBox();
            for (int k = 0; k < 5; ++k) {
                this.jco[this.co].addItem(new DashInfo(k));
            }
            this.jco[this.co].setSelectedIndex(((DashInfo)pd.parameter).style);
            this.jco[this.co].setRenderer(new DashCellRenderer());
            constraints.weightx = 100.0;
            constraints.weighty = 100.0;
            constraints.gridx = 2;
            constraints.gridy = ycount;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            constraints.insets = new Insets(top, 0, 0, 20);
            constraints.fill = 2;
            this.jco[this.co].setEnabled(!pd.isExtension || !this.extStrict);
            contentPane.add((Component)this.jco[this.co++], constraints);
        }
        JButton ok = new JButton(Globals.messages.getString("Ok_btn"));
        JButton cancel = new JButton(Globals.messages.getString("Cancel_btn"));
        constraints.gridx = 0;
        constraints.gridy = ycount;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        constraints.insets = new Insets(6, 20, 20, 20);
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        ok.setPreferredSize(cancel.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            b.add(ok);
            b.add(Box.createHorizontalStrut(12));
            b.add(cancel);
        } else {
            b.add(cancel);
            b.add(Box.createHorizontalStrut(12));
            b.add(ok);
        }
        contentPane.add((Component)b, constraints);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    DialogParameters.this.tc = 0;
                    DialogParameters.this.cc = 0;
                    DialogParameters.this.co = 0;
                    for (int ycount = 0; ycount < DialogParameters.this.v.size() && ycount <= 20; ++ycount) {
                        ParameterDescription pd = (ParameterDescription)DialogParameters.this.v.elementAt(ycount);
                        if (pd.parameter instanceof Point) {
                            ((Point)pd.parameter).x = Integer.parseInt(DialogParameters.this.jtf[DialogParameters.this.tc++].getText());
                            ((Point)pd.parameter).y = Integer.parseInt(DialogParameters.this.jtf[DialogParameters.this.tc++].getText());
                            continue;
                        }
                        if (pd.parameter instanceof String) {
                            pd.parameter = DialogParameters.this.jtf[DialogParameters.this.tc++].getText();
                            continue;
                        }
                        if (pd.parameter instanceof Boolean) {
                            pd.parameter = new Boolean(DialogParameters.this.jcb[DialogParameters.this.cc++].isSelected());
                            continue;
                        }
                        if (pd.parameter instanceof Integer) {
                            pd.parameter = new Integer(Integer.parseInt(DialogParameters.this.jtf[DialogParameters.this.tc++].getText()));
                            continue;
                        }
                        if (pd.parameter instanceof Font) {
                            pd.parameter = new Font((String)DialogParameters.this.jco[DialogParameters.this.co++].getSelectedItem(), 0, 12);
                            continue;
                        }
                        if (pd.parameter instanceof LayerInfo) {
                            pd.parameter = new LayerInfo(DialogParameters.this.jco[DialogParameters.this.co++].getSelectedIndex());
                            continue;
                        }
                        if (pd.parameter instanceof ArrowInfo) {
                            pd.parameter = new ArrowInfo(DialogParameters.this.jco[DialogParameters.this.co++].getSelectedIndex());
                            continue;
                        }
                        if (!(pd.parameter instanceof DashInfo)) continue;
                        pd.parameter = new DashInfo(DialogParameters.this.jco[DialogParameters.this.co++].getSelectedIndex());
                    }
                }
                catch (NumberFormatException E) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("Format_invalid"), "", 1);
                    return;
                }
                DialogParameters.this.active = true;
                DialogParameters.this.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogParameters.this.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DialogParameters.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, cancelAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(ok);
    }

    public Vector getCharacteristics() {
        return this.v;
    }

    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean resize = false;
        if (width < 350) {
            resize = true;
            width = 350;
        }
        if (height < 300) {
            resize = true;
            height = 300;
        }
        if (resize) {
            this.setSize(width, height);
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }
}

