/*
 * Decompiled with CFR 0.152.
 */
package export;

import circuit.ParseSchem;
import export.ExportEPS;
import export.ExportEagle;
import export.ExportFidoCad;
import export.ExportInterface;
import export.ExportPDF;
import export.ExportPGF;
import export.ExportSVG;
import geom.MapCoordinates;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import layers.LayerDesc;

public class ExportGraphic {
    public static void export(File file, ParseSchem P, String format, double unitPerPixel, boolean antiAlias, boolean blackWhite, boolean ext, boolean shiftMin) throws IOException {
        ExportGraphic.exportSizeP(file, P, format, 0, 0, unitPerPixel, false, antiAlias, blackWhite, ext, shiftMin);
    }

    public static void exportSize(File file, ParseSchem P, String format, int width, int height, boolean antiAlias, boolean blackWhite, boolean ext, boolean shiftMin) throws IOException {
        ExportGraphic.exportSizeP(file, P, format, width, height, 1.0, true, antiAlias, blackWhite, ext, shiftMin);
    }

    private static void exportSizeP(File file, ParseSchem P, String format, int width, int height, double unitPerPixel, boolean setSize, boolean antiAlias, boolean blackWhite, boolean ext, boolean shiftMin) throws IOException {
        ExportInterface ef;
        Dimension d;
        MapCoordinates m = new MapCoordinates();
        P.deselectAll();
        Point org = new Point(0, 0);
        if (setSize) {
            d = ExportGraphic.getImageSize(P, 1.0, true);
            d.width += 6;
            d.height += 6;
            unitPerPixel = Math.min((double)width / (double)d.width, (double)height / (double)d.height);
        } else {
            d = ExportGraphic.getImageSize(P, 1.0, true);
            width = (int)((double)(d.width + 6) * unitPerPixel);
            height = (int)((double)(d.height + 6) * unitPerPixel);
        }
        org = ExportGraphic.getImageOrigin(P, 1.0);
        org.x = (int)((double)org.x * unitPerPixel);
        org.y = (int)((double)org.y * unitPerPixel);
        org.x = (int)((double)org.x - 6.0 * unitPerPixel / 2.0);
        org.y = (int)((double)org.y - 6.0 * unitPerPixel / 2.0);
        Vector ol = P.getLayers();
        if (blackWhite) {
            Vector<LayerDesc> v = new Vector<LayerDesc>();
            for (int i = 0; i < 16; ++i) {
                v.add(new LayerDesc(Color.black, ((LayerDesc)ol.get(i)).getVisible(), "B/W", ((LayerDesc)ol.get(i)).getAlpha()));
            }
            P.setLayers(v);
        }
        m.setMagnitudes(unitPerPixel, unitPerPixel);
        if (shiftMin) {
            m.setXCenter(-org.x);
            m.setYCenter(-org.y);
        }
        if (format.equals("png") || format.equals("jpg")) {
            try {
                BufferedImage bufferedImage = new BufferedImage(width, height, 1);
                Graphics2D g2d = bufferedImage.createGraphics();
                if (antiAlias) {
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                g2d.setColor(Color.white);
                g2d.fillRect(0, 0, width, height);
                P.draw(g2d, m);
                ImageIO.write((RenderedImage)bufferedImage, format, file);
                g2d.dispose();
            }
            catch (OutOfMemoryError E) {
                IOException D = new IOException("Memory Error");
                P.setLayers(ol);
                throw D;
            }
            catch (Exception E) {
                IOException D = new IOException("Size error" + E);
                P.setLayers(ol);
                throw D;
            }
        } else if (format.equals("svg")) {
            ExportSVG es = new ExportSVG(file);
            P.exportDrawing(es, true, false, m);
        } else if (format.equals("eps")) {
            ExportEPS ep = new ExportEPS(file);
            P.exportDrawing(ep, true, false, m);
        } else if (format.equals("pgf")) {
            ef = new ExportPGF(file);
            P.exportDrawing(ef, true, false, m);
        } else if (format.equals("pdf")) {
            ef = new ExportPDF(file);
            P.exportDrawing(ef, true, false, m);
        } else if (format.equals("scr")) {
            ef = new ExportEagle(file);
            P.exportDrawing(ef, true, false, m);
        } else if (format.equals("fcd")) {
            ef = new ExportFidoCad(file);
            ((ExportFidoCad)ef).setExtensions(ext);
            P.exportDrawing(ef, true, true, m);
        } else {
            IOException E = new IOException("Wrong file format");
            throw E;
        }
        P.setLayers(ol);
    }

    public static Dimension getImageSize(ParseSchem P, double unitperpixel, boolean countMin) {
        int height;
        int width;
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        MapCoordinates m = new MapCoordinates();
        m.setMagnitudes(unitperpixel, unitperpixel);
        m.setXCenter(0.0);
        m.setYCenter(0.0);
        m.resetMinMax();
        Graphics2D g2d = bufferedImage.createGraphics();
        P.setChanged(true);
        P.draw(g2d, m);
        g2d.dispose();
        if (countMin) {
            width = m.getXMax() - m.getXMin();
            height = m.getYMax() - m.getYMin();
        } else {
            width = m.getXMax();
            height = m.getYMax();
        }
        if (width <= 0 || height <= 0) {
            System.out.println("Warning: Image has a zerosized image");
            width = 100;
            height = 100;
        }
        return new Dimension(width, height);
    }

    public static Point getImageOrigin(ParseSchem P, double unitperpixel) {
        int originy;
        int originx;
        P.setChanged(true);
        BufferedImage bufferedImage = new BufferedImage(100, 100, 1);
        MapCoordinates m = new MapCoordinates();
        m.setMagnitudes(unitperpixel, unitperpixel);
        m.setXCenter(0.0);
        m.setYCenter(0.0);
        Graphics2D g2d = bufferedImage.createGraphics();
        P.draw(g2d, m);
        g2d.dispose();
        if (m.getXMax() >= m.getXMin() && m.getYMax() >= m.getYMin()) {
            originx = m.getXMin();
            originy = m.getYMin();
        } else {
            originx = 0;
            originy = 0;
        }
        return new Point(originx, originy);
    }

    public static MapCoordinates calculateZoomToFit(ParseSchem P, int sizex, int sizey, boolean forceCalc, boolean countMin) {
        double zoomy;
        double zoomx;
        Point org = new Point(0, 0);
        P.setChanged(true);
        MapCoordinates newZoom = new MapCoordinates();
        forceCalc = true;
        Dimension D = ExportGraphic.getImageSize(P, 1.0, countMin);
        double maxsizex = D.width;
        double maxsizey = D.height;
        if (countMin) {
            org = ExportGraphic.getImageOrigin(P, 1.0);
        }
        double z = (zoomx = 1.0 / (maxsizex / (double)sizex)) > (zoomy = 1.0 / (maxsizey / (double)sizey)) ? zoomy : zoomx;
        if ((z = (double)Math.round(z * 100.0) / 100.0) < 0.25) {
            z = 0.25;
        }
        newZoom.setMagnitudes(z, z);
        newZoom.setXCenter(-((double)org.x * z));
        newZoom.setYCenter(-((double)org.y * z));
        return newZoom;
    }
}

