/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.LayerInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.IOException;
import java.util.Vector;
import layers.LayerDesc;
import primitives.StrokeStyle;

public abstract class GraphicPrimitive {
    public static final int NO_DRAG = -1;
    public static final int DRAG_PRIMITIVE = -2;
    public static final int RECT_SELECTION = -3;
    private static final int HANDLE_WIDTH = 8;
    private static final int MAX_TOKENS = 120;
    protected static StrokeStyle strokeStyle;
    public boolean selectedState;
    protected static final float D_MIN = 0.5f;
    public int layer;
    public Point[] virtualPoint;
    protected boolean changed;
    protected int macroFontSize;
    protected String macroFont;
    protected String name;
    protected String value;
    private int z;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int h;
    private int th;
    private int w1;
    private int w2;
    private int t_h;
    private int t_th;
    private int t_w1;
    private int t_w2;
    private int x2;
    private int y2;
    private int x3;
    private int y3;
    private Font f;
    private FontMetrics fm;
    private LayerDesc l;
    private float alpha;
    private static float oldalpha;
    private int old_layer = -1;

    public void GraphicPrimitive() {
        this.selectedState = false;
        this.layer = 0;
        this.changed = true;
        this.name = "";
        this.value = "";
        this.macroFontSize = 3;
        this.macroFont = "Courier New";
    }

    public void setMacroFont(String f, int size) {
        this.macroFont = f;
        this.macroFontSize = size;
        this.changed = true;
    }

    public void initPrimitive(int number) {
        this.macroFontSize = 3;
        this.macroFont = "Courier New";
        this.name = "";
        this.value = "";
        if (number < 0) {
            number = this.getControlPointNumber();
        }
        this.virtualPoint = new Point[number];
        for (int i = 0; i < number; ++i) {
            this.virtualPoint[i] = new Point();
        }
    }

    public String getMacroFont() {
        return this.macroFont;
    }

    public int getMacroFontSize() {
        return this.macroFontSize;
    }

    protected void drawText(Graphics2D g, MapCoordinates coordSys, Vector layerV, int drawOnlyLayer) {
        if (this.value == null && this.name == null) {
            return;
        }
        if (drawOnlyLayer >= 0 && drawOnlyLayer != this.getLayer()) {
            return;
        }
        if (this.changed) {
            this.x2 = this.virtualPoint[this.getNameVirtualPointNumber()].x;
            this.y2 = this.virtualPoint[this.getNameVirtualPointNumber()].y;
            this.x3 = this.virtualPoint[this.getValueVirtualPointNumber()].x;
            this.y3 = this.virtualPoint[this.getValueVirtualPointNumber()].y;
            this.xa = coordSys.mapX(this.x2, this.y2);
            this.ya = coordSys.mapY(this.x2, this.y2);
            this.xb = coordSys.mapX(this.x3, this.y3);
            this.yb = coordSys.mapY(this.x3, this.y3);
            this.f = new Font(this.macroFont, 0, (int)((double)(this.macroFontSize * 12) * coordSys.getYMagnitude() / 7.0 + 0.5));
            this.fm = g.getFontMetrics(this.f);
            this.h = this.fm.getAscent();
            this.th = this.h + this.fm.getDescent();
            this.w1 = this.name != null ? this.fm.stringWidth(this.name) : 0;
            this.w2 = this.value != null ? this.fm.stringWidth(this.value) : 0;
            this.t_w1 = (int)((double)this.w1 / coordSys.getXMagnitude());
            this.t_w2 = (int)((double)this.w2 / coordSys.getYMagnitude());
            this.t_th = (int)((double)this.th / coordSys.getYMagnitude());
            coordSys.trackPoint(this.xa, this.ya);
            coordSys.trackPoint(this.xa + this.w1, this.ya + this.th);
            coordSys.trackPoint(this.xb, this.yb);
            coordSys.trackPoint(this.xb + this.w2, this.yb + this.th);
        }
        if (!g.hitClip(this.xa, this.ya, this.w1, this.th) && !g.hitClip(this.xb, this.yb, this.w2, this.th)) {
            return;
        }
        if (this.th < 4) {
            g.drawLine(this.xa, this.ya, this.xa + this.w1 - 1, this.ya);
            return;
        }
        if (!g.getFont().equals(this.f)) {
            g.setFont(this.f);
        }
        if (this.name != null && this.name.length() != 0) {
            g.drawString(this.name, this.xa, this.ya + this.h);
        }
        if (this.value != null && this.value.length() != 0) {
            g.drawString(this.value, this.xb, this.yb + this.h);
        }
    }

    public String saveText(boolean extensions) {
        String subsFont;
        String s = "";
        if (this.macroFont.equals("Courier New")) {
            subsFont = "*";
        } else {
            StringBuffer s1 = new StringBuffer("");
            for (int i = 0; i < this.macroFont.length(); ++i) {
                if (this.macroFont.charAt(i) != ' ') {
                    s1.append(this.macroFont.charAt(i));
                    continue;
                }
                s1.append("++");
            }
            subsFont = s1.toString();
        }
        if (this.name != null && !this.name.equals("") || this.value != null && !this.value.equals("")) {
            if (extensions) {
                s = s + "FCJ\n";
            }
            s = s + "TY " + this.virtualPoint[this.getNameVirtualPointNumber()].x + " " + this.virtualPoint[this.getNameVirtualPointNumber()].y + " " + this.macroFontSize * 4 / 3 + " " + this.macroFontSize + " " + "0" + " " + "0" + " " + this.getLayer() + " " + subsFont + " " + (this.name == null ? "" : this.name) + "\n";
            s = s + "TY " + this.virtualPoint[this.getValueVirtualPointNumber()].x + " " + this.virtualPoint[this.getValueVirtualPointNumber()].y + " " + this.macroFontSize * 4 / 3 + " " + this.macroFontSize + " " + "0" + " " + "0" + " " + this.getLayer() + " " + subsFont + " " + (this.value == null ? "" : this.value) + "\n";
        }
        return s;
    }

    public void exportText(ExportInterface exp, MapCoordinates cs, int drawOnlyLayer) throws IOException {
        double size = cs.mapXr(this.macroFontSize, this.macroFontSize) - cs.mapXr(0.0, 0.0);
        if (drawOnlyLayer < 0 || drawOnlyLayer == this.getLayer()) {
            if (this.name != null && !this.name.equals("")) {
                exp.exportAdvText(cs.mapX(this.virtualPoint[this.getNameVirtualPointNumber()].x, this.virtualPoint[this.getNameVirtualPointNumber()].y), cs.mapY(this.virtualPoint[this.getNameVirtualPointNumber()].x, this.virtualPoint[this.getNameVirtualPointNumber()].y), (int)size, (int)(size * 12.0 / 7.0 + 0.5), this.macroFont, false, false, false, 0, this.getLayer(), this.name);
            }
            if (this.value != null && !this.value.equals("")) {
                exp.exportAdvText(cs.mapX(this.virtualPoint[this.getValueVirtualPointNumber()].x, this.virtualPoint[this.getValueVirtualPointNumber()].y), cs.mapY(this.virtualPoint[this.getValueVirtualPointNumber()].x, this.virtualPoint[this.getValueVirtualPointNumber()].y), (int)size, (int)(size * 12.0 / 7.0 + 0.5), this.macroFont, false, false, false, 0, this.getLayer(), this.value);
            }
        }
    }

    public boolean checkText(int px, int py) {
        if (GeometricDistances.pointInRectangle(this.virtualPoint[this.getNameVirtualPointNumber()].x, this.virtualPoint[this.getNameVirtualPointNumber()].y, this.t_w1, this.t_th, px, py)) {
            return true;
        }
        return GeometricDistances.pointInRectangle(this.virtualPoint[this.getValueVirtualPointNumber()].x, this.virtualPoint[this.getValueVirtualPointNumber()].y, this.t_w2, this.t_th, px, py);
    }

    public void setValue(String[] tokens, int N) throws IOException {
        StringBuffer txtb = new StringBuffer();
        int j = 8;
        this.changed = true;
        if (tokens[0].equals("TY")) {
            if (N < 9) {
                IOException E = new IOException("bad arguments on TY");
                throw E;
            }
            this.virtualPoint[this.getValueVirtualPointNumber()].x = Integer.parseInt(tokens[1]);
            this.virtualPoint[this.getValueVirtualPointNumber()].y = Integer.parseInt(tokens[2]);
            this.macroFont = tokens[8].equals("*") ? "Courier New" : tokens[8].replaceAll("\\+\\+", " ");
            this.macroFontSize = Integer.parseInt(tokens[4]);
            while (j < N - 1) {
                txtb.append(tokens[++j]);
                if (j >= N - 1) continue;
                txtb.append(" ");
            }
        } else {
            IOException E = new IOException("Invalid primitive: " + tokens[0] + " programming error?");
            throw E;
        }
        this.value = txtb.toString();
    }

    public void setName(String[] tokens, int N) throws IOException {
        StringBuffer txtb = new StringBuffer();
        int j = 8;
        this.changed = true;
        if (tokens[0].equals("TY")) {
            if (N < 9) {
                IOException E = new IOException("bad arguments on TY");
                throw E;
            }
            this.virtualPoint[this.getNameVirtualPointNumber()].x = Integer.parseInt(tokens[1]);
            this.virtualPoint[this.getNameVirtualPointNumber()].y = Integer.parseInt(tokens[2]);
            while (j < N - 1) {
                txtb.append(tokens[++j]);
                if (j >= N - 1) continue;
                txtb.append(" ");
            }
        } else {
            IOException E = new IOException("Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
        this.name = txtb.toString();
    }

    public void setChanged(boolean c) {
        this.changed = c;
    }

    public Point getFirstPoint() {
        return this.virtualPoint[0];
    }

    public void movePrimitive(int dx, int dy) {
        int n = this.getControlPointNumber();
        for (int a = 0; a < n; ++a) {
            this.virtualPoint[a].x += dx;
            this.virtualPoint[a].y += dy;
        }
        this.changed = true;
    }

    public void mirrorPrimitive(int xPos) {
        int n = this.getControlPointNumber();
        for (int a = 0; a < n; ++a) {
            int xtmp = this.virtualPoint[a].x;
            this.virtualPoint[a].x = 2 * xPos - xtmp;
        }
        this.changed = true;
    }

    public void rotatePrimitive(boolean bCounterClockWise, int ix, int iy) {
        int m = this.getControlPointNumber();
        Point ptTmp = new Point();
        Point pt = new Point();
        pt.x = ix;
        pt.y = iy;
        for (int b = 0; b < m; ++b) {
            ptTmp.x = this.virtualPoint[b].x;
            ptTmp.y = this.virtualPoint[b].y;
            if (!bCounterClockWise) {
                this.virtualPoint[b].x = pt.x - (ptTmp.y - pt.y);
                this.virtualPoint[b].y = pt.y + (ptTmp.x - pt.x);
                continue;
            }
            this.virtualPoint[b].x = pt.x + (ptTmp.y - pt.y);
            this.virtualPoint[b].y = pt.y - (ptTmp.x - pt.x);
        }
        this.changed = true;
    }

    public void setDrawOnlyLayer(int i) {
    }

    public boolean containsLayer(int l) {
        return l == this.layer;
    }

    public int getMaxLayer() {
        return this.layer;
    }

    public final void setSelected(boolean s) {
        this.selectedState = s;
    }

    public final boolean getSelected() {
        return this.selectedState;
    }

    public final int getLayer() {
        return this.layer;
    }

    public void parseLayer(String token) {
        int l;
        try {
            l = Integer.parseInt(token);
        }
        catch (NumberFormatException E) {
            l = 0;
        }
        this.layer = this.layer < 0 || this.layer >= 16 ? 0 : l;
        this.changed = true;
    }

    public final void setLayer(int l) {
        this.layer = l < 0 || l >= 16 ? 0 : l;
        this.changed = true;
    }

    protected final boolean selectLayer(Graphics2D g, Vector layerV) {
        if (this.old_layer != this.layer || this.changed) {
            this.l = this.layer < layerV.size() ? (LayerDesc)layerV.get(this.layer) : (LayerDesc)layerV.get(0);
            this.old_layer = this.layer;
        }
        if (!this.l.isVisible) {
            return false;
        }
        if (this.selectedState) {
            g.setColor(Color.green);
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            oldalpha = 1.0f;
        } else if (g.getColor() != this.l.getColor() || oldalpha != this.alpha) {
            g.setColor(this.l.getColor());
            oldalpha = this.alpha = this.l.getAlpha();
            g.setComposite(AlphaComposite.getInstance(3, this.alpha));
        }
        return true;
    }

    public void drawHandles(Graphics2D g, MapCoordinates cs) {
        g.setColor(Color.red);
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            int ya;
            int xa;
            if (!this.testIfValidHandle(i) || !g.hitClip((xa = cs.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y)) - 4, (ya = cs.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y)) - 4, 8, 8)) continue;
            g.fillRect(xa - 4, ya - 4, 8, 8);
        }
    }

    public int onHandle(MapCoordinates cs, int px, int py) {
        int hw2 = 4;
        int hl2 = 4;
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            int ya;
            int xa;
            if (!this.testIfValidHandle(i) || !GeometricDistances.pointInRectangle((xa = cs.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y)) - hw2, (ya = cs.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y)) - hl2, 8, 8, px, py)) continue;
            return i;
        }
        return -1;
    }

    public boolean selectRect(int px, int py, int w, int h) {
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            if (!this.testIfValidHandle(i)) continue;
            int xa = this.virtualPoint[i].x;
            int ya = this.virtualPoint[i].y;
            if (px > xa || xa >= px + w || py > ya || ya >= py + h) continue;
            this.setSelected(true);
            return true;
        }
        return false;
    }

    protected boolean hasName() {
        return this.name != null && this.name.length() != 0;
    }

    protected boolean hasValue() {
        return this.value != null && this.value.length() != 0;
    }

    protected boolean testIfValidHandle(int i) {
        if (i == this.getNameVirtualPointNumber()) {
            if (this.name == null) {
                return false;
            }
            if (this.name.length() == 0) {
                return false;
            }
        }
        if (i == this.getValueVirtualPointNumber()) {
            if (this.value == null) {
                return false;
            }
            if (this.value.length() == 0) {
                return false;
            }
        }
        return true;
    }

    public Vector getControls() {
        Vector<ParameterDescription> v = new Vector<ParameterDescription>(10);
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = this.name != null ? this.name : "";
        pd.description = Globals.messages.getString("ctrl_name");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.value != null ? this.value : "";
        pd.description = Globals.messages.getString("ctrl_value");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new LayerInfo(this.layer);
        pd.description = Globals.messages.getString("ctrl_layer");
        v.add(pd);
        return v;
    }

    public int setControls(Vector v) {
        int i = 0;
        this.changed = true;
        ParameterDescription pd = (ParameterDescription)v.get(i);
        ++i;
        if (pd.parameter instanceof String) {
            this.name = (String)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = (ParameterDescription)v.get(i);
        ++i;
        if (pd.parameter instanceof String) {
            this.value = (String)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = (ParameterDescription)v.get(i);
        if (pd.parameter instanceof LayerInfo) {
            this.layer = ((LayerInfo)pd.parameter).getLayer();
        } else {
            System.out.println("Warning: unexpected parameter! (layer)");
        }
        return ++i;
    }

    public boolean needsHoles() {
        return false;
    }

    public void setDrawOnlyPads(boolean t) {
    }

    public abstract void draw(Graphics2D var1, MapCoordinates var2, Vector var3);

    public abstract void parseTokens(String[] var1, int var2) throws IOException;

    public abstract int getDistanceToPoint(int var1, int var2);

    public abstract int getControlPointNumber();

    public abstract String toString(boolean var1);

    public abstract void export(ExportInterface var1, MapCoordinates var2) throws IOException;

    public abstract int getNameVirtualPointNumber();

    public abstract int getValueVirtualPointNumber();

    static {
        oldalpha = 1.0f;
    }
}

