/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.tools;

import flash.swf.Dictionary;
import flash.swf.Header;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flash.swf.TagValues;
import flash.swf.tags.DebugID;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoAction;
import flash.swf.tags.DoInitAction;
import flash.swf.tags.EnableDebugger;
import flash.swf.tags.ExportAssets;
import flash.swf.tags.FileAttributes;
import flash.swf.tags.FrameLabel;
import flash.swf.tags.GenericTag;
import flash.swf.tags.ImportAssets;
import flash.swf.tags.PlaceObject;
import flash.swf.tags.ProductInfo;
import flash.swf.tags.ScriptLimits;
import flash.swf.tags.SetBackgroundColor;
import flash.swf.tags.ShowFrame;
import flash.swf.types.CXForm;
import flash.swf.types.CurvedEdgeRecord;
import flash.swf.types.FillStyle;
import flash.swf.types.FlashUUID;
import flash.swf.types.GradRecord;
import flash.swf.types.Gradient;
import flash.swf.types.ImportRecord;
import flash.swf.types.LineStyle;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.ShapeWithStyle;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flash.util.ArrayUtil;
import flash.util.Base64;
import flash.util.FileUtils;
import flash.util.StringUtils;
import flash.util.SwfImageUtils;
import flash.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SwfxParser
extends DefaultHandler
implements TagValues {
    private TagHandler tagHandler;
    private DefineSprite sprite;
    private Locator locator;
    private StringBuffer text;
    private Header header;
    private Stack stack;
    private ArrayList fillstyles;
    private ArrayList linestyles;
    private String docPath;
    private Dictionary dict;
    private String[] aspath;
    private String topLevel;
    private GenericTag jpegTables;
    private int startLineNumber;

    private TagHandler currentHandler() {
        return this.sprite != null ? this.sprite.tagList : this.tagHandler;
    }

    public SwfxParser(TagHandler handler, String[] aspath) {
        this.tagHandler = handler;
        this.aspath = aspath;
        try {
            this.topLevel = FileUtils.readFile(aspath[0] + File.separator + "toplevel.as", null);
        }
        catch (IOException ex) {
            this.topLevel = null;
        }
        this.stack = new Stack();
        this.dict = new Dictionary();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            Method method = this.getClass().getMethod(qName, Attributes.class);
            method.invoke((Object)this, attributes);
        }
        catch (NoSuchMethodException e) {
            this.warning(new SAXParseException("no start handler for " + qName, this.locator));
        }
        catch (IllegalAccessException e) {
            this.fatalError(new SAXParseException(e.getMessage(), this.locator, e));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof SAXException) {
                throw (SAXException)t;
            }
            this.fatalError(new SAXParseException(e.getMessage(), this.locator, e));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.text != null) {
            this.text.append(ch, start, length);
        }
    }

    public void curve(Attributes attributes) throws SAXParseException {
        CurvedEdgeRecord curvedEdge = new CurvedEdgeRecord();
        curvedEdge.controlDeltaX = this.parseInt(this.getAttribute(attributes, "cdx"));
        curvedEdge.controlDeltaY = this.parseInt(this.getAttribute(attributes, "cdy"));
        curvedEdge.anchorDeltaX = this.parseInt(this.getAttribute(attributes, "dx"));
        curvedEdge.anchorDeltaY = this.parseInt(this.getAttribute(attributes, "dy"));
        DefineShape defineShape = (DefineShape)this.stack.peek();
        defineShape.shapeWithStyle.shapeRecords.add(curvedEdge);
    }

    public void curve() {
    }

    public void DebugID(Attributes attributes) throws SAXParseException {
        DebugID debugId = new DebugID(this.parseUUID(this.getAttribute(attributes, "uuid")));
        this.tagHandler.debugID(debugId);
    }

    public void DebugID() {
    }

    private FlashUUID parseUUID(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(Character.digit(s.charAt(2 * i), 16) << 4 | Character.digit(s.charAt(2 * i + 1), 16) << 0);
        }
        return new FlashUUID(b);
    }

    private void createCharacter(int id, DefineTag tag) throws SAXParseException {
        try {
            this.dict.add(id, tag);
        }
        catch (IllegalArgumentException e) {
            this.error(new SAXParseException(e.getMessage(), this.locator, e));
        }
    }

    private SwfImageUtils.JPEG loadJPEG(Attributes attributes) throws SAXException {
        if (this.hasAttribute(attributes, "encoding")) {
            if (!this.getAttribute(attributes, "encoding").equals("base64")) {
                this.fatalError(new SAXParseException("unknown encoding " + this.getAttribute(attributes, "encoding"), this.locator));
            }
            if (this.hasAttribute(attributes, "src")) {
                this.fatalError(new SAXParseException("can only specify one of src or encoding attributes", this.locator));
            }
        } else {
            this.text = null;
            if (!this.hasAttribute(attributes, "src")) {
                this.fatalError(new SAXParseException("must provide either src or encoding attribute", this.locator));
            }
            try {
                File src = new File(this.getAttribute(attributes, "src"));
                FileInputStream input = new FileInputStream(this.getAttribute(attributes, "src"));
                byte[] image = new byte[(int)src.length()];
                input.read(image);
                input.close();
                SwfImageUtils.JPEG jpeg = new SwfImageUtils.JPEG(image, true);
                if (!jpeg.validate()) {
                    this.fatalError(new SAXParseException("Invalid JPEG data in " + src.getName(), this.locator));
                }
                return jpeg;
            }
            catch (IOException e) {
                throw new SAXParseException(e.getMessage(), this.locator);
            }
        }
        this.text = new StringBuffer();
        return null;
    }

    public void DefineBits(Attributes attributes) throws SAXException {
        if (this.jpegTables == null) {
            this.fatalError(new SAXParseException("DefineBits must follow JPEGTables", this.locator));
        }
        DefineBits db = new DefineBits(6);
        int id = this.parseInt(this.getAttribute(attributes, "id"));
        this.createCharacter(id, db);
        SwfImageUtils.JPEG jpeg = this.loadJPEG(attributes);
        if (jpeg != null) {
            if (!ArrayUtil.equals(jpeg.table, this.jpegTables.data)) {
                this.fatalError(new SAXParseException("JPEGTables data does not match, use DefineBitsJPEG2", this.locator));
            }
            db.data = jpeg.data;
        }
        this.stack.push(db);
    }

    public void DefineBits() {
        DefineBits db = (DefineBits)this.stack.pop();
        if (this.text != null) {
            Base64.Decoder dec = new Base64.Decoder();
            dec.decode(this.text.toString());
            db.data = dec.flush();
            db.jpegTables = this.jpegTables;
        }
        this.currentHandler().defineBits(db);
    }

    public void DefineBitsJPEG2(Attributes attributes) throws SAXException {
        DefineBits db = new DefineBits(21);
        int id = this.parseInt(this.getAttribute(attributes, "id"));
        this.createCharacter(id, db);
        if (this.hasAttribute(attributes, "encoding")) {
            if (!this.getAttribute(attributes, "encoding").equals("base64")) {
                this.fatalError(new SAXParseException("unknown encoding " + this.getAttribute(attributes, "encoding"), this.locator));
            }
            if (this.hasAttribute(attributes, "src")) {
                this.fatalError(new SAXParseException("can only specify one of src or encoding attributes", this.locator));
            }
            this.text = new StringBuffer();
        } else {
            if (!this.hasAttribute(attributes, "src")) {
                this.fatalError(new SAXParseException("must provide either src or encoding attribute", this.locator));
            }
            File src = new File(this.getAttribute(attributes, "src"));
            try {
                FileInputStream input = new FileInputStream(this.getAttribute(attributes, "src"));
                db.data = new byte[(int)src.length()];
                input.read(db.data);
            }
            catch (IOException e) {
                this.fatalError(new SAXParseException("Unable to load DefineBitsJPEG2 src " + src.getName() + ":" + e.getMessage(), this.locator));
            }
        }
        this.stack.push(db);
    }

    public void DefineBitsJPEG2() {
        DefineBits db = (DefineBits)this.stack.pop();
        if (this.text != null) {
            Base64.Decoder dec = new Base64.Decoder();
            dec.decode(this.text.toString());
            db.data = dec.flush();
            db.jpegTables = null;
        }
        this.currentHandler().defineBits(db);
    }

    public void DefineShape(Attributes attributes) throws SAXException {
        DefineShape tag = new DefineShape(2);
        int id = this.parseInt(this.getAttribute(attributes, "id"));
        this.createCharacter(id, tag);
        tag.bounds = this.parseRect(this.getAttribute(attributes, "bounds"));
        tag.shapeWithStyle = new ShapeWithStyle();
        tag.shapeWithStyle.fillstyles = new ArrayList();
        tag.shapeWithStyle.linestyles = new ArrayList();
        tag.shapeWithStyle.shapeRecords = new ArrayList();
        this.stack.push(tag);
        this.fillstyles = tag.shapeWithStyle.fillstyles;
        this.linestyles = tag.shapeWithStyle.linestyles;
    }

    public void DefineShape() {
        DefineShape tag = (DefineShape)this.stack.pop();
        this.fillstyles = null;
        this.linestyles = null;
        this.tagHandler.defineShape(tag);
    }

    public void DefineShape3(Attributes attributes) throws SAXException {
        DefineShape tag = new DefineShape(32);
        int id = this.parseInt(this.getAttribute(attributes, "id"));
        this.createCharacter(id, tag);
        tag.bounds = this.parseRect(this.getAttribute(attributes, "bounds"));
        tag.shapeWithStyle = new ShapeWithStyle();
        tag.shapeWithStyle.fillstyles = new ArrayList();
        tag.shapeWithStyle.linestyles = new ArrayList();
        tag.shapeWithStyle.shapeRecords = new ArrayList();
        this.stack.push(tag);
        this.fillstyles = tag.shapeWithStyle.fillstyles;
        this.linestyles = tag.shapeWithStyle.linestyles;
    }

    public void DefineShape3() {
        DefineShape tag = (DefineShape)this.stack.pop();
        this.fillstyles = null;
        this.linestyles = null;
        this.tagHandler.defineShape3(tag);
    }

    public void DefineSprite(Attributes attributes) throws SAXParseException {
        DefineSprite sprite = new DefineSprite();
        int id = this.parseInt(this.getAttribute(attributes, "id"));
        this.createCharacter(id, sprite);
        this.stack.push(sprite);
        this.sprite = sprite;
    }

    public void DefineSprite() {
        DefineSprite sprite = (DefineSprite)this.stack.pop();
        this.sprite = null;
        this.tagHandler.defineSprite(sprite);
    }

    public void DoAction(Attributes attributes) {
        this.text = new StringBuffer();
        this.startLineNumber = this.locator.getLineNumber();
    }

    public void DoAction() throws SAXException {
        this.text = null;
        DoAction doAction = new DoAction();
        this.currentHandler().doAction(doAction);
    }

    public void ProductInfo(Attributes attributes) throws SAXException {
        int product = this.parseInt(this.getAttribute(attributes, "product"));
        int edition = this.parseInt(this.getAttribute(attributes, "edition"));
        byte majorVersion = Byte.parseByte(this.getAttribute(attributes, "majorVersion"));
        byte minorVersion = Byte.parseByte(this.getAttribute(attributes, "majorVersion"));
        long build = Long.parseLong(this.getAttribute(attributes, "build"));
        long compileDate = Long.parseLong(this.getAttribute(attributes, "compileDate"));
        this.stack.push(new ProductInfo(product, edition, majorVersion, minorVersion, build, compileDate));
    }

    public void FileAttributes() {
        this.tagHandler.fileAttributes((FileAttributes)this.stack.pop());
    }

    public void FileAttributes(Attributes attributes) throws SAXException {
        FileAttributes tag = new FileAttributes();
        tag.hasMetadata = this.parseBoolean(this.getAttribute(attributes, "hasMetadata"));
        tag.actionScript3 = this.parseBoolean(this.getAttribute(attributes, "actionScript3"));
        tag.suppressCrossDomainCaching = this.parseBoolean(this.getAttribute(attributes, "suppressCrossDomainCaching"));
        tag.swfRelativeUrls = this.parseBoolean(this.getAttribute(attributes, "swfRelativeUrls"));
        tag.useNetwork = this.parseBoolean(this.getAttribute(attributes, "useNetwork"));
        this.stack.push(tag);
    }

    public void ProductInfo() {
        this.tagHandler.productInfo((ProductInfo)this.stack.pop());
    }

    private DefineTag findCharacter(int idref) throws SAXParseException {
        try {
            return this.dict.getTag(idref);
        }
        catch (IllegalArgumentException e) {
            throw new SAXParseException(e.getMessage(), this.locator, e);
        }
    }

    public void Package(Attributes attributes) throws SAXParseException {
        this.text = new StringBuffer();
        DefineSprite pkg = new DefineSprite();
        DoInitAction initAction = new DoInitAction(pkg);
        int id = this.parseInt(this.getAttribute(attributes, "id"));
        this.createCharacter(id, pkg);
        this.currentHandler().defineSprite(pkg);
        this.startLineNumber = this.locator.getLineNumber();
        this.stack.push(initAction);
    }

    public void Package() throws SAXException {
        this.text = null;
        DoInitAction initAction = (DoInitAction)this.stack.pop();
        this.currentHandler().doInitAction(initAction);
    }

    public void DoInitAction(Attributes attributes) throws SAXParseException {
        this.text = new StringBuffer();
        DoInitAction initAction = new DoInitAction();
        int idref = this.parseInt(this.getAttribute(attributes, "idref"));
        initAction.sprite = (DefineSprite)this.findCharacter(idref);
        this.startLineNumber = this.locator.getLineNumber();
        this.stack.push(initAction);
    }

    public void DoInitAction() throws SAXException {
        this.text = null;
        DoInitAction initAction = (DoInitAction)this.stack.pop();
        this.currentHandler().doInitAction(initAction);
    }

    public void EnableDebugger2(Attributes attributes) throws SAXParseException {
        EnableDebugger enableDebugger2 = new EnableDebugger(64);
        enableDebugger2.password = this.getAttribute(attributes, "password");
        this.tagHandler.enableDebugger2(enableDebugger2);
    }

    public void EnableDebugger2() {
    }

    public void ExportAssets(Attributes attributes) {
        ExportAssets tag = new ExportAssets();
        this.stack.push(tag);
    }

    public void ExportAssets() {
        ExportAssets tag = (ExportAssets)this.stack.pop();
        this.tagHandler.exportAssets(tag);
    }

    public void Export(Attributes attributes) throws SAXParseException {
        ExportAssets tag = (ExportAssets)this.stack.peek();
        int idref = this.parseInt(this.getAttribute(attributes, "idref"));
        String name = this.getAttribute(attributes, "name");
        DefineTag ref = this.findCharacter(idref);
        ref.name = name;
        tag.exports.add(ref);
    }

    public void Export() {
    }

    public void fillstyle(Attributes attributes) throws SAXParseException {
        DefineShape defineShape = (DefineShape)this.stack.peek();
        boolean hasAlpha = defineShape.code == 32;
        FillStyle fillstyle = new FillStyle();
        if (this.hasAttribute(attributes, "color")) {
            fillstyle.setType(0);
            int n = fillstyle.color = hasAlpha ? this.parseRGBA(this.getAttribute(attributes, "color")) : this.parseRGB(this.getAttribute(attributes, "color"));
        }
        if (this.hasAttribute(attributes, "gradient")) {
            fillstyle.setType(16);
            fillstyle.gradient = this.parseGradient(this.getAttribute(attributes, "gradient"), hasAlpha);
            fillstyle.matrix = this.parseMatrix(this.getAttribute(attributes, "matrix"));
        }
        if (this.hasAttribute(attributes, "idref")) {
            fillstyle.setType(64);
            int idref = this.parseInt(this.getAttribute(attributes, "idref"));
            fillstyle.bitmap = this.findCharacter(idref);
            fillstyle.matrix = this.parseMatrix(this.getAttribute(attributes, "matrix"));
        }
        defineShape.shapeWithStyle.fillstyles.add(fillstyle);
    }

    public void fillstyle() {
    }

    public void FrameLabel(Attributes attributes) throws SAXParseException {
        FrameLabel frameLabel = new FrameLabel();
        frameLabel.label = this.getAttribute(attributes, "label");
        frameLabel.anchor = this.parseBoolean(this.getAttribute(attributes, "anchor"));
        this.tagHandler.frameLabel(frameLabel);
    }

    public void FrameLabel() {
    }

    public void Import(Attributes attributes) throws SAXParseException {
        ImportRecord record = new ImportRecord();
        int id = this.parseInt(this.getAttribute(attributes, "id"));
        record.name = this.getAttribute(attributes, "name");
        ImportAssets importAssets = (ImportAssets)this.stack.peek();
        importAssets.importRecords.add(record);
        this.createCharacter(id, record);
    }

    public void Import() {
    }

    public void ImportAssets(Attributes attributes) throws SAXParseException {
        ImportAssets importAssets = new ImportAssets(57);
        importAssets.url = this.getAttribute(attributes, "url");
        importAssets.importRecords = new ArrayList();
        this.stack.push(importAssets);
    }

    public void ImportAssets() {
        ImportAssets importAssets = (ImportAssets)this.stack.pop();
        this.tagHandler.importAssets(importAssets);
    }

    public void line(Attributes attributes) throws SAXParseException {
        StraightEdgeRecord straightEdge = new StraightEdgeRecord();
        if (this.hasAttribute(attributes, "dx")) {
            straightEdge.deltaX = this.parseInt(this.getAttribute(attributes, "dx"));
        }
        if (this.hasAttribute(attributes, "dy")) {
            straightEdge.deltaY = this.parseInt(this.getAttribute(attributes, "dy"));
        }
        DefineShape defineShape = (DefineShape)this.stack.peek();
        defineShape.shapeWithStyle.shapeRecords.add(straightEdge);
    }

    public void line() {
    }

    public void linestyle(Attributes attributes) throws SAXParseException {
        DefineShape defineShape = (DefineShape)this.stack.peek();
        LineStyle linestyle = new LineStyle();
        linestyle.color = defineShape.code == 32 ? this.parseRGBA(this.getAttribute(attributes, "color")) : this.parseRGB(this.getAttribute(attributes, "color"));
        linestyle.width = this.parseInt(this.getAttribute(attributes, "width"));
        this.linestyles.add(linestyle);
    }

    public void linestyle() {
    }

    public void swf(Attributes attributes) throws SAXException {
        Header h = new Header();
        h.version = this.parseInt(this.getAttribute(attributes, "version"));
        h.compressed = this.parseBoolean(this.getAttribute(attributes, "compressed"));
        h.rate = this.parseInt(this.getAttribute(attributes, "framerate"));
        h.size = this.parseRect(this.getAttribute(attributes, "size"));
        this.header = h;
        this.tagHandler.header(h);
    }

    public void swf() {
    }

    public void JPEGTables(Attributes attributes) throws SAXParseException {
        this.text = new StringBuffer();
        if (this.hasAttribute(attributes, "encoding") && !this.getAttribute(attributes, "encoding").equals("base64")) {
            this.fatalError(new SAXParseException("unknown encoding " + this.getAttribute(attributes, "encoding"), this.locator));
        }
    }

    public void JPEGTables() {
        if (this.text != null) {
            String encoded = this.text.toString();
            this.text = null;
            Base64.Decoder dec = new Base64.Decoder();
            dec.decode(encoded);
            this.jpegTables = new GenericTag(8);
            this.jpegTables.data = dec.flush();
            this.currentHandler().jpegTables(this.jpegTables);
        }
    }

    public void ShowFrame(Attributes attributes) {
        this.currentHandler().showFrame(new ShowFrame());
        if (this.sprite != null) {
            ++this.sprite.framecount;
        } else {
            ++this.header.framecount;
        }
    }

    public void ShowFrame() {
    }

    public void styleChange(Attributes attributes) throws SAXParseException {
        StyleChangeRecord styleChange = new StyleChangeRecord();
        if (this.hasAttribute(attributes, "dx") || this.hasAttribute(attributes, "dy")) {
            styleChange.stateMoveTo = true;
            styleChange.moveDeltaX = this.parseInt(this.getAttribute(attributes, "dx"));
            styleChange.moveDeltaY = this.parseInt(this.getAttribute(attributes, "dy"));
        }
        if (this.hasAttribute(attributes, "fillStyle0")) {
            styleChange.stateFillStyle0 = true;
            styleChange.fillstyle0 = this.parseInt(this.getAttribute(attributes, "fillStyle0"));
        }
        if (this.hasAttribute(attributes, "fillStyle1")) {
            styleChange.stateFillStyle1 = true;
            styleChange.fillstyle1 = this.parseInt(this.getAttribute(attributes, "fillStyle1"));
        }
        if (this.hasAttribute(attributes, "lineStyle")) {
            styleChange.stateLineStyle = true;
            styleChange.linestyle = this.parseInt(this.getAttribute(attributes, "lineStyle"));
        }
        styleChange.fillstyles = new ArrayList();
        styleChange.linestyles = new ArrayList();
        this.fillstyles = styleChange.fillstyles;
        this.linestyles = styleChange.linestyles;
        this.stack.push(styleChange);
    }

    public void styleChange() {
        StyleChangeRecord styleChange = (StyleChangeRecord)this.stack.pop();
        if (this.fillstyles.size() != 0) {
            styleChange.stateNewStyles = true;
        }
        DefineShape defineShape = (DefineShape)this.stack.peek();
        defineShape.shapeWithStyle.shapeRecords.add(styleChange);
        this.fillstyles = defineShape.shapeWithStyle.fillstyles;
        this.linestyles = defineShape.shapeWithStyle.linestyles;
    }

    public void PlaceObject2(Attributes attributes) throws SAXParseException {
        PlaceObject tag = new PlaceObject(26);
        tag.depth = this.parseInt(this.getAttribute(attributes, "depth"));
        if (this.hasAttribute(attributes, "className")) {
            tag.setClassName(this.getAttribute(attributes, "className"));
        }
        if (this.hasAttribute(attributes, "hasImage")) {
            tag.setHasImage(this.getAttribute(attributes, "hasImage").equals("true"));
        }
        if (this.hasAttribute(attributes, "idref")) {
            int idref = this.parseInt(this.getAttribute(attributes, "idref"));
            tag.setRef(this.findCharacter(idref));
        }
        if (this.hasAttribute(attributes, "name")) {
            tag.setName(this.getAttribute(attributes, "name"));
        }
        if (this.hasAttribute(attributes, "clipDepth")) {
            tag.setClipDepth(this.parseInt(this.getAttribute(attributes, "clipDepth")));
        }
        if (this.hasAttribute(attributes, "ratio")) {
            tag.setRatio(this.parseInt(this.getAttribute(attributes, "ratio")));
        }
        if (this.hasAttribute(attributes, "cxform")) {
            tag.setCxform(this.parseCXForm(this.getAttribute(attributes, "cxform")));
        }
        if (this.hasAttribute(attributes, "matrix")) {
            tag.setMatrix(this.parseMatrix(this.getAttribute(attributes, "matrix")));
        }
        this.stack.push(tag);
        this.text = new StringBuffer();
    }

    public void PlaceObject2() throws SAXException {
        PlaceObject tag = (PlaceObject)this.stack.pop();
        this.text = null;
        this.currentHandler().placeObject2(tag);
    }

    public void SetBackgroundColor(Attributes attributes) throws SAXParseException {
        SetBackgroundColor tag = new SetBackgroundColor(this.parseRGB(this.getAttribute(attributes, "color")));
        this.currentHandler().setBackgroundColor(tag);
    }

    public void SetBackgroundColor() {
    }

    public void ScriptLimits(Attributes attributes) throws SAXParseException {
        ScriptLimits tag = new ScriptLimits(this.parseInt(this.getAttribute(attributes, "maxRecursionLimit")), this.parseInt(this.getAttribute(attributes, "scriptTimeLimit")));
        this.currentHandler().scriptLimits(tag);
    }

    public void ScriptLimits() {
    }

    private Matrix parseMatrix(String s) {
        Matrix matrix = new Matrix();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case 'r': {
                    String[] parts = StringUtils.split(s.substring(++i), "[, ]", 3);
                    matrix.setRotate(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]));
                    continue block5;
                }
                case 's': {
                    String[] parts = StringUtils.split(s.substring(++i), "[, ]", 3);
                    matrix.setScale(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]));
                    continue block5;
                }
                case 't': {
                    String[] parts = StringUtils.split(s.substring(++i), "[, ]", 3);
                    matrix.translateX = Integer.parseInt(parts[0]);
                    matrix.translateY = Integer.parseInt(parts[1]);
                }
            }
        }
        return matrix;
    }

    private Gradient parseGradient(String s, boolean hasAlpha) {
        Gradient gradient = new Gradient();
        String[] parts = StringUtils.split(s, " ");
        int count = parts.length / 2;
        gradient.records = new GradRecord[count];
        for (int i = 0; i < count; ++i) {
            GradRecord record = gradient.records[i] = new GradRecord();
            record.ratio = Integer.parseInt(parts[2 * i]);
            record.color = hasAlpha ? this.parseRGBA(parts[2 * i + 1]) : this.parseRGB(parts[2 * i + 1]);
        }
        return gradient;
    }

    private CXForm parseCXForm(String s) {
        String[] parts = StringUtils.split(s, "([rgb]\\+?| )");
        CXForm cxform = new CXForm();
        cxform.redAddTerm = Integer.parseInt(parts[0]);
        cxform.redMultTerm = Integer.parseInt(parts[1]);
        cxform.greenAddTerm = Integer.parseInt(parts[2]);
        cxform.greenMultTerm = Integer.parseInt(parts[3]);
        cxform.blueAddTerm = Integer.parseInt(parts[4]);
        cxform.blueMultTerm = Integer.parseInt(parts[5]);
        return cxform;
    }

    private boolean parseBoolean(String attribute) {
        return Boolean.valueOf(attribute);
    }

    private int parseRGB(String s) {
        int rgb = SwfxParser.parseColor(s);
        int color = (rgb >> 16 & 0xFF) << 16;
        color |= (rgb >> 8 & 0xFF) << 8;
        return color |= rgb >> 0 & 0xFF;
    }

    private int parseRGBA(String s) {
        int rgb = SwfxParser.parseColor(s);
        int color = (rgb >> 24 & 0xFF) << 16;
        color |= (rgb >> 16 & 0xFF) << 8;
        color |= rgb >> 8 & 0xFF;
        return color |= (rgb >> 0 & 0xFF) << 24;
    }

    public static int parseColor(String string) {
        if (string.length() > 0) {
            if (string.charAt(0) == '#') {
                return (int)Long.parseLong(string.substring(1), 16);
            }
            if (string.startsWith("0x") || string.startsWith("0X")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            return Integer.parseInt(string);
        }
        return 0;
    }

    private boolean hasAttribute(Attributes attributes, String qName) {
        return attributes.getValue(qName) != null;
    }

    private String getAttribute(Attributes attributes, String qName) throws SAXParseException {
        String value = attributes.getValue(qName);
        if (value == null) {
            this.error(new SAXParseException("attribute not found: " + qName, this.locator));
        }
        return value;
    }

    private Rect parseRect(String s) {
        String[] parts = StringUtils.split(s, "x");
        return new Rect(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    private int parseInt(String s) {
        return Integer.parseInt(s);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            Method method = this.getClass().getMethod(qName, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            this.warning(new SAXParseException("no end handler for " + qName, this.locator));
        }
        catch (IllegalAccessException e) {
            this.fatalError(new SAXParseException(e.getMessage(), this.locator, e));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof SAXException) {
                throw (SAXException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            this.fatalError(new SAXParseException(t.getMessage(), this.locator));
        }
    }

    public void endDocument() throws SAXException {
        this.tagHandler.finish();
    }

    public void warning(SAXParseException e) throws SAXParseException {
    }

    public void error(SAXParseException e) throws SAXParseException {
    }

    public void fatalError(SAXParseException e) throws SAXParseException {
        throw e;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(String path) throws IOException {
        String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
        String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
        String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
        this.docPath = path;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
        try {
            SAXParser parser;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            try {
                parser = factory.newSAXParser();
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", new InputSource(this.getClass().getResource("swfx.xsd").toExternalForm()));
            }
            catch (Exception e) {
                if (e instanceof SAXNotRecognizedException) {
                    factory.setValidating(false);
                    factory.setNamespaceAware(true);
                    parser = factory.newSAXParser();
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof SAXException) {
                    throw (SAXException)e;
                }
                e.printStackTrace();
                parser = null;
            }
            parser.parse((InputStream)in, (DefaultHandler)this);
            boolean bl = true;
            return bl;
        }
        catch (SAXException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (e instanceof ParserConfigurationException) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                boolean bl = false;
                return bl;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            e.printStackTrace();
            boolean bl = true;
            return bl;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String aspath = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-aspath")) {
                aspath = args[++i];
                continue;
            }
            TagEncoder encoder = new TagEncoder();
            SwfxParser swfxParser = new SwfxParser(encoder, StringUtils.splitPath(aspath));
            boolean success = swfxParser.parse(args[i]);
            if (success) {
                String swfFileName = args[i].substring(0, args[i].lastIndexOf(46)) + ".swf";
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(swfFileName));
                try {
                    encoder.writeTo(out);
                    continue;
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            System.exit(1);
        }
    }
}

