/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.util.StringTokenizer;
import macromedia.asc.util.ByteList;

public class SwfMaker {
    public static final int stagShowFrame = 1;
    public static final int stagEnableDebugger2 = 64;
    public static final int stagDebugID = 63;
    public static final int stagFileAttributes = 69;
    public static final int stagDoABC = 72;
    public static final int stagSymbolClass = 76;
    public static final int swfFlagsUseNetwork = 1;
    public static final int swfFlagsSwfRelativeUrls = 2;
    public static final int swfFlagsNoCrossdomainCache = 4;
    public static final int swfFlagsAS3 = 8;
    public static final int swfFlagsHasMetadata = 16;
    public static final int kDefaultSwfFlags = 0;
    int bitPos;
    int bitBuf;
    ByteList buffer = new ByteList();
    int pos = 0;
    int tagCode = 0;
    int tagPos = 0;
    int tagLen = 0;
    boolean tagIsBig = false;
    int swf_version = 9;

    private int CoreAbs(int x) {
        return x < 0 ? -x : x;
    }

    SwfMaker() {
    }

    void SetPos(int pos) {
        this.pos = pos;
    }

    void CheckSpace(int count) {
        this.buffer.resize(this.pos + count);
    }

    void PutData(byte[] data) {
        this.CheckSpace(data.length);
        for (int i = 0; i < data.length; ++i) {
            this.buffer.set(this.pos++, data[i]);
        }
    }

    void PutByte(byte b) {
        this.CheckSpace(1);
        this.buffer.set(this.pos++, b);
    }

    void PutString(String str) {
        this.PutData(str.getBytes());
        this.PutByte((byte)0);
    }

    void PutWord(int d) {
        this.CheckSpace(2);
        this.buffer.set(this.pos++, (byte)d);
        this.buffer.set(this.pos++, (byte)(d >> 8));
    }

    void PutDWord(int d) {
        this.CheckSpace(4);
        this.buffer.set(this.pos++, (byte)d);
        this.buffer.set(this.pos++, (byte)(d >> 8));
        this.buffer.set(this.pos++, (byte)(d >> 16));
        this.buffer.set(this.pos++, (byte)(d >> 24));
    }

    void StartTag(int code, boolean isBig) {
        this.tagCode = code;
        this.tagPos = this.pos;
        this.tagIsBig = isBig;
        this.PutWord(0);
        if (isBig) {
            this.PutDWord(0);
        }
    }

    void FinishTag() {
        int savePos = this.pos;
        int tagLen = this.pos - this.tagPos - (this.tagIsBig ? 6 : 2);
        this.pos = this.tagPos;
        if (this.tagIsBig) {
            this.PutWord((short)(this.tagCode << 6 | 0x3F));
            this.PutDWord(tagLen);
        } else {
            this.PutWord((short)(this.tagCode << 6 | tagLen));
        }
        this.pos = savePos;
        this.tagCode = 0;
    }

    int CountBits(int v) {
        int n = 0;
        while ((v & 0xFFFFFFF0) != 0) {
            v >>= 4;
            n += 4;
        }
        while (v != 0) {
            v >>= 1;
            ++n;
        }
        return n;
    }

    int CheckMag(int v, int mag) {
        if (v < 0) {
            v = -v;
        }
        return v > mag ? v : mag;
    }

    void InitBits() {
        this.bitPos = 8;
        this.bitBuf = 0;
    }

    void FlushBits() {
        if (this.bitPos < 8) {
            this.PutByte((byte)this.bitBuf);
        }
    }

    void PutBits(int v, int n) {
        if (n <= 0) {
            return;
        }
        while (true) {
            v &= -1 >> 32 - n;
            int s = n - this.bitPos;
            if (s <= 0) {
                this.bitBuf |= v << -s;
                this.bitPos -= n;
                return;
            }
            this.bitBuf |= v >> s;
            n -= this.bitPos;
            this.PutByte((byte)this.bitBuf);
            this.bitBuf = 0;
            this.bitPos = 8;
        }
    }

    void PutRect(SRECT r) {
        this.InitBits();
        int mag = this.CheckMag(r.xmin, this.CheckMag(r.xmax, this.CheckMag(r.ymin, this.CoreAbs(r.ymax))));
        int nBits = this.CountBits(mag) + 1;
        if (nBits < 15) {
            nBits = 15;
        }
        this.PutBits(nBits, 5);
        this.PutBits(r.xmin, nBits);
        this.PutBits(r.xmax, nBits);
        this.PutBits(r.ymin, nBits);
        this.PutBits(r.ymax, nBits);
        this.FlushBits();
    }

    public boolean EncodeABC(ByteList abcData, String options) {
        int height;
        int width;
        String className = null;
        int fps = 12;
        int useNetwork = 0;
        boolean debug = false;
        int dAt = options.indexOf(",-g");
        if (dAt > -1) {
            debug = true;
            options = options.substring(0, dAt) + options.substring(dAt + 3);
        }
        if ((dAt = options.indexOf(",-usenetwork")) > -1) {
            useNetwork = 1;
            options = options.substring(0, dAt) + options.substring(dAt + 12);
        }
        StringTokenizer tokenizer = new StringTokenizer(options, ",");
        switch (tokenizer.countTokens()) {
            case 2: {
                width = Integer.parseInt(tokenizer.nextToken());
                height = Integer.parseInt(tokenizer.nextToken());
                break;
            }
            case 3: {
                className = tokenizer.nextToken();
                width = Integer.parseInt(tokenizer.nextToken());
                height = Integer.parseInt(tokenizer.nextToken());
                break;
            }
            case 4: {
                className = tokenizer.nextToken();
                width = Integer.parseInt(tokenizer.nextToken());
                height = Integer.parseInt(tokenizer.nextToken());
                fps = Integer.parseInt(tokenizer.nextToken());
                break;
            }
            default: {
                return false;
            }
        }
        this.PutByte((byte)70);
        this.PutByte((byte)87);
        this.PutByte((byte)83);
        this.PutByte((byte)this.swf_version);
        this.PutDWord(0);
        SRECT bounds = new SRECT(this);
        bounds.xmin = 0;
        bounds.ymin = 0;
        bounds.xmax = width * 20;
        bounds.ymax = height * 20;
        this.PutRect(bounds);
        this.PutWord(fps << 8);
        this.PutWord(1);
        this.StartTag(69, false);
        this.PutDWord(8 | useNetwork);
        this.FinishTag();
        if (debug) {
            this.StartTag(64, false);
            this.PutWord(6517);
            this.PutString("");
            this.FinishTag();
            this.StartTag(63, false);
            this.PutData(new byte[]{-54, 73, -106, -57, 87, -114, 32, 2, -35, -110, -90, 63, 24, 120, -59, -68});
            this.FinishTag();
        }
        this.StartTag(72, true);
        this.PutData(abcData.toByteArray());
        this.FinishTag();
        if (className != null) {
            this.StartTag(76, false);
            this.PutWord(1);
            this.PutWord(0);
            this.PutString(className);
            this.FinishTag();
        }
        this.StartTag(1, false);
        this.FinishTag();
        int size = this.pos;
        this.SetPos(4);
        this.PutDWord(size);
        return true;
    }

    class SRECT {
        public int xmin;
        public int xmax;
        public int ymin;
        public int ymax;
        final /* synthetic */ SwfMaker this$0;

        /*
         * WARNING - void declaration
         */
        SRECT(SwfMaker swfMaker) {
            void arg0;
            this.this$0 = arg0;
        }
    }
}

