/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.AbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.wmf.tosvg.WMFPainter;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.XMLFilter;

public class WMFTranscoder
extends AbstractTranscoder
implements SVGConstants {
    public static final int WMF_TRANSCODER_ERROR_BASE = 65280;
    public static final int ERROR_NULL_INPUT = 65280;
    public static final int ERROR_INCOMPATIBLE_INPUT_TYPE = 65281;
    public static final int ERROR_INCOMPATIBLE_OUTPUT_TYPE = 65282;
    public static final String USAGE = "The WMFTranscoder converts a WMF document into an SVG document. \nThis simple application generates SVG documents that have the same name, but a where the .wmf extension \nis replaced with .svg. To run the application, type the following at the command line: \njava org.apache.batik.transcoder.wmf.tosvg.WMFTranscoder fileName [fileName]+";
    public static final String WMF_EXTENSION = ".wmf";
    public static final String SVG_EXTENSION = ".svg";

    public void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException {
        DataInputStream is = this.getCompatibleInput(input);
        WMFRecordStore currentStore = new WMFRecordStore();
        try {
            currentStore.read(is);
        }
        catch (IOException e) {
            this.handler.fatalError(new TranscoderException(e));
            return;
        }
        WMFPainter painter = new WMFPainter(currentStore);
        DOMImplementation domImpl = SVGDOMImplementation.getDOMImplementation();
        Document doc = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(doc);
        painter.paint((Graphics)svgGenerator);
        int vpX = currentStore.getVpX();
        int vpY = currentStore.getVpY();
        int vpW = currentStore.getVpW();
        int vpH = currentStore.getVpH();
        svgGenerator.setSVGCanvasSize(new Dimension(vpW, vpH));
        Element svgRoot = svgGenerator.getRoot();
        svgRoot.setAttributeNS(null, "viewBox", "" + vpX + " " + vpY + " " + vpW + " " + vpH);
        this.writeSVGToOutput(svgGenerator, svgRoot, output);
    }

    private void writeSVGToOutput(SVGGraphics2D svgGenerator, Element svgRoot, TranscoderOutput output) throws TranscoderException {
        block9: {
            Document doc;
            XMLFilter xmlFilter = output.getXMLFilter();
            if (xmlFilter != null) {
                this.handler.fatalError(new TranscoderException("65282"));
            }
            if ((doc = output.getDocument()) != null) {
                this.handler.fatalError(new TranscoderException("65282"));
            }
            try {
                OutputStream os = output.getOutputStream();
                if (os != null) {
                    svgGenerator.stream(svgRoot, (Writer)new OutputStreamWriter(os));
                    return;
                }
                Writer wr = output.getWriter();
                if (wr != null) {
                    svgGenerator.stream(svgRoot, wr);
                    return;
                }
                String uri = output.getURI();
                if (uri == null) break block9;
                try {
                    URL url = new URL(uri);
                    URLConnection urlCnx = url.openConnection();
                    os = urlCnx.getOutputStream();
                    svgGenerator.stream(svgRoot, (Writer)new OutputStreamWriter(os));
                    return;
                }
                catch (MalformedURLException e) {
                    this.handler.fatalError(new TranscoderException(e));
                }
                catch (IOException e) {
                    this.handler.fatalError(new TranscoderException(e));
                }
            }
            catch (IOException e) {
                throw new TranscoderException(e);
            }
        }
        throw new TranscoderException("65282");
    }

    private DataInputStream getCompatibleInput(TranscoderInput input) throws TranscoderException {
        InputStream in;
        if (input == null) {
            this.handler.fatalError(new TranscoderException("65280"));
        }
        if ((in = input.getInputStream()) != null) {
            return new DataInputStream(new BufferedInputStream(in));
        }
        String uri = input.getURI();
        if (uri != null) {
            try {
                URL url = new URL(uri);
                in = url.openStream();
                return new DataInputStream(new BufferedInputStream(in));
            }
            catch (MalformedURLException e) {
                this.handler.fatalError(new TranscoderException(e));
            }
            catch (IOException e) {
                this.handler.fatalError(new TranscoderException(e));
            }
        }
        this.handler.fatalError(new TranscoderException("65281"));
        return null;
    }

    public static void main(String[] args) throws TranscoderException {
        if (args.length < 1) {
            System.err.println(USAGE);
            System.exit(1);
        }
        WMFTranscoder transcoder = new WMFTranscoder();
        int nFiles = args.length;
        for (int i = 0; i < nFiles; ++i) {
            String fileName = args[i];
            if (!fileName.toLowerCase().endsWith(WMF_EXTENSION)) {
                System.err.println(args[i] + " does not have the " + WMF_EXTENSION + " extension. It is ignored");
                continue;
            }
            System.out.print("Processing : " + args[i] + "...");
            String outputFileName = fileName.substring(0, fileName.toLowerCase().indexOf(WMF_EXTENSION)) + SVG_EXTENSION;
            File inputFile = new File(fileName);
            File outputFile = new File(outputFileName);
            try {
                TranscoderInput input = new TranscoderInput(inputFile.toURL().toString());
                TranscoderOutput output = new TranscoderOutput(new FileOutputStream(outputFile));
                transcoder.transcode(input, output);
            }
            catch (MalformedURLException e) {
                throw new TranscoderException(e);
            }
            catch (IOException e) {
                throw new TranscoderException(e);
            }
            System.out.println(".... Done");
        }
        System.exit(0);
    }
}

