////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2006-2007 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package mx.core
{

import flash.utils.ByteArray;

/**
 *  ByteArrayAsset is a subclass of the flash.utils.ByteArray class
 *  which represents an arbitrary sequence of byte data that you embed
 *  in a Flex application.
 *
 *  <p>The byte data that you are embedding can be in any kind of file,
 *  and the entire file is always embedded.
 *  You cannot embed the bytes of a particular asset that is in a SWF file,
 *  although you can embed an entire SWF file.</p>
 *
 *  <p>The MXML compiler autogenerates a class that extends ByteArrayAsset
 *  to represent the embedded data.</p>
 *
 *  <p>To embed an arbitrary file, you declare a variable of type Class,
 *  and put <code>[Embed]</code> metadata on it, using the MIME type
 *  <code>application/octet-stream</code>.
 *  For example, you embed a text file like this:</p>
 *
 *  <pre>
 *  [Bindable]
 *  [Embed(source="Story.txt", mimeType="application/octet-stream")]
 *  private var storyClass:Class;
 *  </pre>
 *
 *  <p>The compiler autogenerates a subclass of the ByteArrayAsset class
 *  and sets your variable to be a reference to this autogenerated class.
 *  You can then use this class reference to create instances of the
 *  ByteArrayAsset using the <code>new</code> operator, and you can extract
 *  information from the byte array using methods of the ByteArray class:</p>
 *
 *  <pre>
 *  var storyByteArray:ByteArrayAsset = ByteArrayAsset(new storyClass());
 *  var story:String = storyByteArray.readUTFBytes(storyByteArray.length);
 *  </pre>
 *
 *  <p>You must specify that the MIME type for the embedding is
 *  <code>application/octet-stream</code>, which causes the byte data
 *  to be embedded "as is", with no interpretation.
 *  It also causes the autogenerated class to extend ByteArrayAsset
 *  rather than another asset class.</p>
 *
 *  <p>For example, if you embed a PNG file without specifying this
 *  MIME type, the PNG data will be automatically transcoded
 *  into the bitmap format used by the player, and a subclass
 *  of BitmapAsset will be autogenerated to represent it.
 *  But if you specify the MIME type as <code>application/octet-stream</code>,
 *  then no transcoding will occur, the PNG data will be embedded
 *  as is, and the autogenerated class will extend ByteArrayAsset.</p>
 */
public class ByteArrayAsset extends ByteArray implements IFlexAsset
{
    include "../core/Version.as";

    //--------------------------------------------------------------------------
    //
    //  Constructor
    //
    //--------------------------------------------------------------------------

    /**
     *  Constructor.
     */
    public function ByteArrayAsset()
    {
        super();
    }
}

}
