////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2006 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package mx.controls.scrollClasses
{
	
/**
 *  The ScrollBarDirection class defines the values for the 
 *  <code>direction</code> property of the ScrollBar control.
 *
 *  @see mx.controls.scrollClasses.ScrollBar
 *  @see mx.controls.HScrollBar
 *  @see mx.controls.VScrollBar
 */
public final class ScrollBarDirection
{
	include "../../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Class constants
	//
	//--------------------------------------------------------------------------

	/**
	 *  Specifies that a ScrollBar control is for horizontal scrolling.
	 */
	public static const HORIZONTAL:String = "horizontal";
	
	/**
	 *  Specifies that a ScrollBar control is for vertical scrolling.
	 */
	public static const VERTICAL:String = "vertical";
}

}
