/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import org.apache.commons.collections.CommonsLinkedList;

public class NodeCachingLinkedList
extends CommonsLinkedList {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAXIMUM_CACHE_SIZE = 20;
    private transient CommonsLinkedList.Node firstCachedNode;
    private transient int cacheSize = 0;
    private int maximumCacheSize = 20;

    public NodeCachingLinkedList() {
    }

    public NodeCachingLinkedList(Collection coll) {
        super(coll);
    }

    public NodeCachingLinkedList(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
        this.shrinkCacheToMaximumSize();
    }

    private void shrinkCacheToMaximumSize() {
        while (this.cacheSize > this.maximumCacheSize) {
            this.getNodeFromCache();
        }
    }

    private CommonsLinkedList.Node getNodeFromCache() {
        if (this.cacheSize == 0) {
            return null;
        }
        CommonsLinkedList.Node cachedNode = this.firstCachedNode;
        this.firstCachedNode = cachedNode.next;
        cachedNode.next = null;
        --this.cacheSize;
        return cachedNode;
    }

    private boolean cacheFull() {
        return this.cacheSize >= this.maximumCacheSize;
    }

    private void addNodeToCache(CommonsLinkedList.Node node) {
        if (this.cacheFull()) {
            return;
        }
        CommonsLinkedList.Node nextCachedNode = this.firstCachedNode;
        node.previous = null;
        node.next = nextCachedNode;
        node.element = null;
        this.firstCachedNode = node;
        ++this.cacheSize;
    }

    protected CommonsLinkedList.Node createNode() {
        CommonsLinkedList.Node cachedNode = this.getNodeFromCache();
        if (cachedNode == null) {
            return super.createNode();
        }
        return cachedNode;
    }

    protected CommonsLinkedList.Node createNode(CommonsLinkedList.Node next, CommonsLinkedList.Node previous, Object element) {
        CommonsLinkedList.Node cachedNode = this.getNodeFromCache();
        if (cachedNode == null) {
            return super.createNode(next, previous, element);
        }
        cachedNode.next = next;
        cachedNode.previous = previous;
        cachedNode.element = element;
        return cachedNode;
    }

    protected void removeNode(CommonsLinkedList.Node node) {
        super.removeNode(node);
        this.addNodeToCache(node);
    }

    protected void removeAllNodes() {
        int numberOfNodesToCache = Math.min(this.size, this.maximumCacheSize - this.cacheSize);
        CommonsLinkedList.Node node = this.marker.next;
        int currentIndex = 0;
        while (currentIndex < numberOfNodesToCache) {
            CommonsLinkedList.Node oldNode = node;
            node = node.next;
            this.addNodeToCache(oldNode);
            ++currentIndex;
        }
        super.removeAllNodes();
    }
}

