/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Stack;

public class StringStack
implements Serializable {
    private Stack stack = new Stack();

    public StringStack add(String s) {
        if (s != null && !this.contains(s)) {
            this.stack.push(s);
        }
        return this;
    }

    public StringStack addAll(StringStack ss) {
        Iterator i = ss.stack.iterator();
        while (i.hasNext()) {
            this.add((String)i.next());
        }
        return this;
    }

    public void clear() {
        this.stack.clear();
    }

    public boolean contains(String s) {
        return this.stack.search(s) != -1;
    }

    public final boolean empty() {
        return this.stack.empty();
    }

    public String get(int i) {
        return (String)this.stack.elementAt(i);
    }

    public final int size() {
        return this.stack.size();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String separator) {
        String s;
        if (this.size() > 0) {
            if (separator == null) {
                separator = "";
            }
            int totalSize = 0;
            int i = 0;
            while (i < this.stack.size()) {
                totalSize += this.get(i).length();
                ++i;
            }
            StringBuffer sb = new StringBuffer(totalSize += (this.stack.size() - 1) * separator.length()).append(this.get(0));
            int i2 = 1;
            while (i2 < this.stack.size()) {
                sb.append(separator).append(this.get(i2));
                ++i2;
            }
            s = sb.toString();
        } else {
            s = "";
        }
        return s;
    }

    public boolean equals(Object ssbuf) {
        boolean isEquiv = false;
        if (ssbuf == null || !(ssbuf instanceof StringStack)) {
            isEquiv = false;
        } else if (ssbuf == this) {
            isEquiv = true;
        } else if (this.toString().equals(ssbuf.toString())) {
            isEquiv = true;
        }
        return isEquiv;
    }

    public String[] toStringArray() {
        String[] array = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            array[i] = this.get(i);
            ++i;
        }
        return array;
    }
}

