/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.FileUtil;
import flex2.tools.DigestRootConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class DigestConfiguration {
    DigestRootConfiguration root;
    private File rslFile = null;
    private String swcPath = null;
    private boolean signed = false;

    public DigestConfiguration(DigestRootConfiguration root) {
        this.root = root;
    }

    public static Map getAliases() {
        HashMap map = new HashMap();
        return map;
    }

    public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        String appHome = System.getProperty("application.home");
        if (appHome == null) {
            appHome = ".";
        }
    }

    public File getRslFile() {
        return this.rslFile;
    }

    public void cfgRslFile(ConfigurationValue cfgval, String file) throws ConfigurationException {
        if (file == null || file.length() == 0) {
            throw new ConfigurationException.MissingArgument("filename", "rsl-file", null, 0);
        }
        this.rslFile = FileUtil.openFile((String)file);
        if (!this.rslFile.exists()) {
            throw new ConfigurationException.ConfigurationIOError(file, "rsl-file", null, 0);
        }
        if (!this.rslFile.isFile()) {
            throw new ConfigurationException.NotAFile(file, "rsl-file", null, 0);
        }
    }

    public static ConfigurationInfo getRslFileInfo() {
        return new ConfigurationInfo(new String[]{"filename"}){

            public boolean isPath() {
                return true;
            }

            public boolean isRequired() {
                return true;
            }
        };
    }

    public String getSwcPath() {
        return this.swcPath;
    }

    public void cfgSwcPath(ConfigurationValue cfgval, String path) throws ConfigurationException {
        if (path == null || path.length() == 0) {
            throw new ConfigurationException.MissingArgument("path-element", "swc-path", null, 0);
        }
        this.swcPath = path;
    }

    public static ConfigurationInfo getSwcPathInfo() {
        return new ConfigurationInfo(new String[]{"path-element"}){

            public boolean isPath() {
                return true;
            }

            public boolean isRequired() {
                return true;
            }
        };
    }

    public boolean getSigned() {
        return this.signed;
    }

    public void cfgSigned(ConfigurationValue cv, boolean signed) throws ConfigurationException {
        this.signed = signed;
    }

    public static ConfigurationInfo getSignedInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }
}

