/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.script.rhino.BatikSecurityController;
import org.apache.batik.script.rhino.BatikWrapFactory;
import org.apache.batik.script.rhino.EventTargetWrapper;
import org.apache.batik.script.rhino.RhinoClassLoader;
import org.apache.batik.script.rhino.RhinoClassShutter;
import org.apache.batik.script.rhino.WindowWrapper;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.EventTarget;

public class RhinoInterpreter
implements Interpreter {
    private static String[] TO_BE_IMPORTED = new String[]{"java.lang", "org.w3c.dom", "org.w3c.dom.css", "org.w3c.dom.events", "org.w3c.dom.smil", "org.w3c.dom.stylesheets", "org.w3c.dom.svg", "org.w3c.dom.views"};
    protected Window window;
    private static final int MAX_CACHED_SCRIPTS = 32;
    public static final String SOURCE_NAME_SVG = "<SVG>";
    public static final String BIND_NAME_WINDOW = "window";
    private ScriptableObject globalObject = null;
    private LinkedList compiledScripts = new LinkedList();
    private WrapFactory wrapFactory = new BatikWrapFactory(this);
    protected RhinoClassLoader rhinoClassLoader;
    private SecurityController securityController = new BatikSecurityController();
    Map objects = new HashMap(4);
    static Method rhinoGetter;
    static /* synthetic */ Class class$org$apache$batik$script$rhino$WindowWrapper;
    static /* synthetic */ Class class$org$mozilla$javascript$ScriptableObject;
    static /* synthetic */ Class class$org$apache$batik$script$rhino$RhinoInterpreter$RhinoGetDelegate;

    public Window getWindow() {
        return this.window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoInterpreter(URL documentURL) {
        try {
            this.rhinoClassLoader = new RhinoClassLoader(documentURL, this.getClass().getClassLoader());
        }
        catch (SecurityException se) {
            this.rhinoClassLoader = null;
        }
        Context ctx = this.enterContext();
        try {
            try {
                ScriptableObject scriptable = ctx.initStandardObjects(null, false);
                ScriptableObject.defineClass((Scriptable)scriptable, (Class)(class$org$apache$batik$script$rhino$WindowWrapper == null ? (class$org$apache$batik$script$rhino$WindowWrapper = RhinoInterpreter.class$("org.apache.batik.script.rhino.WindowWrapper")) : class$org$apache$batik$script$rhino$WindowWrapper));
            }
            catch (Exception e) {
                // empty catch block
            }
            WindowWrapper wWrapper = new WindowWrapper(ctx);
            this.globalObject = wWrapper;
            Object[] p = new NativeJavaPackage[TO_BE_IMPORTED.length];
            for (int i = 0; i < TO_BE_IMPORTED.length; ++i) {
                p[i] = new NativeJavaPackage(TO_BE_IMPORTED[i], (ClassLoader)this.rhinoClassLoader);
            }
            try {
                ScriptableObject.callMethod((Scriptable)this.globalObject, (String)"importPackage", (Object[])p);
            }
            catch (JavaScriptException e) {
                // empty catch block
            }
        }
        finally {
            Context.exit();
        }
    }

    public AccessControlContext getAccessControlContext() {
        return this.rhinoClassLoader.getAccessControlContext();
    }

    public Context enterContext() {
        Context ctx = Context.getCurrentContext();
        if (ctx == null) {
            ctx = new ExtendedContext();
            ctx.setWrapFactory(this.wrapFactory);
            ctx.setSecurityController(this.securityController);
            ctx.setClassShutter((ClassShutter)new RhinoClassShutter());
            if (this.rhinoClassLoader == null) {
                ctx.setOptimizationLevel(-1);
                Context.setCachingEnabled((boolean)false);
            }
        }
        ctx = Context.enter((Context)ctx);
        return ctx;
    }

    protected ScriptableObject getGlobalObject() {
        return this.globalObject;
    }

    public Object evaluate(Reader scriptreader) throws InterpreterException, IOException {
        return this.evaluate(scriptreader, SOURCE_NAME_SVG);
    }

    public Object evaluate(Reader scriptreader, String description) throws InterpreterException, IOException {
        Object rv = null;
        Context ctx = this.enterContext();
        try {
            rv = ctx.evaluateReader((Scriptable)this.globalObject, scriptreader, description, 1, (Object)this.rhinoClassLoader);
        }
        catch (JavaScriptException e) {
            if (e.getValue() instanceof Exception) {
                Exception ex = (Exception)e.getValue();
                throw new InterpreterException(ex, ex.getMessage(), -1, -1);
            }
            throw new InterpreterException((Exception)((Object)e), e.getMessage(), -1, -1);
        }
        catch (WrappedException we) {
            Throwable w = we.getWrappedException();
            if (w instanceof Exception) {
                throw new InterpreterException((Exception)we.getWrappedException(), we.getWrappedException().getMessage(), -1, -1);
            }
            throw new InterpreterException(we.getWrappedException().getMessage(), -1, -1);
        }
        catch (InterruptedBridgeException ibe) {
            throw ibe;
        }
        catch (RuntimeException re) {
            throw new InterpreterException(re, re.getMessage(), -1, -1);
        }
        finally {
            Context.exit();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(final String scriptstr) throws InterpreterException {
        Object rv = null;
        final Context ctx = this.enterContext();
        try {
            Script script = null;
            Entry et = null;
            Iterator it = this.compiledScripts.iterator();
            while (it.hasNext()) {
                et = (Entry)it.next();
                if (!et.str.equals(scriptstr)) continue;
                script = et.script;
                it.remove();
                break;
            }
            if (script == null) {
                script = (Script)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return ctx.compileReader((Scriptable)RhinoInterpreter.this.globalObject, (Reader)new StringReader(scriptstr), RhinoInterpreter.SOURCE_NAME_SVG, 1, (Object)RhinoInterpreter.this.rhinoClassLoader);
                        }
                        catch (IOException io) {
                            throw new Error();
                        }
                    }
                });
                if (this.compiledScripts.size() + 1 > 32) {
                    this.compiledScripts.removeFirst();
                }
                this.compiledScripts.addLast(new Entry(scriptstr, script));
            } else {
                this.compiledScripts.addLast(et);
            }
            try {
                rv = script.exec(ctx, (Scriptable)this.globalObject);
            }
            catch (JavaScriptException e) {
                if (e.getValue() instanceof Exception) {
                    Exception ex = (Exception)e.getValue();
                    throw new InterpreterException(ex, ex.getMessage(), -1, -1);
                }
                throw new InterpreterException((Exception)((Object)e), e.getMessage(), -1, -1);
            }
            catch (WrappedException we) {
                throw new InterpreterException((Exception)we.getWrappedException(), we.getWrappedException().getMessage(), -1, -1);
            }
            catch (RuntimeException re) {
                throw new InterpreterException(re, re.getMessage(), -1, -1);
            }
        }
        finally {
            Context.exit();
        }
        return rv;
    }

    public void dispose() {
        if (this.rhinoClassLoader != null) {
            Context.setCachingEnabled((boolean)false);
            Context.setCachingEnabled((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindObject(String name, Object object) {
        this.enterContext();
        try {
            if (name.equals(BIND_NAME_WINDOW) && object instanceof Window) {
                this.window = (Window)object;
                object = this.globalObject;
            }
            try {
                Scriptable jsObject = Context.toObject((Object)object, (Scriptable)this.globalObject);
                this.objects.put(name, jsObject);
                if (ScriptableObject.getProperty((Scriptable)this.globalObject, (String)name) == Scriptable.NOT_FOUND) {
                    this.globalObject.defineProperty(name, (Object)new RhinoGetDelegate(name), rhinoGetter, null, 1);
                }
            }
            catch (PropertyException pe) {
                pe.printStackTrace();
            }
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHandler(Function handler, Object arg) throws JavaScriptException {
        Context ctx = this.enterContext();
        try {
            arg = Context.toObject((Object)arg, (Scriptable)this.globalObject);
            Object[] args = new Object[]{arg};
            handler.call(ctx, (Scriptable)this.globalObject, (Scriptable)this.globalObject, args);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callMethod(ScriptableObject obj, String methodName, ArgumentsBuilder ab) throws JavaScriptException {
        this.enterContext();
        try {
            ScriptableObject.callMethod((Scriptable)obj, (String)methodName, (Object[])ab.buildArguments());
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHandler(Function handler, Object[] args) throws JavaScriptException {
        Context ctx = this.enterContext();
        try {
            handler.call(ctx, (Scriptable)this.globalObject, (Scriptable)this.globalObject, args);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHandler(Function handler, ArgumentsBuilder ab) throws JavaScriptException {
        Context ctx = this.enterContext();
        try {
            Object[] args = ab.buildArguments();
            handler.call(ctx, handler.getParentScope(), (Scriptable)this.globalObject, args);
        }
        finally {
            Context.exit();
        }
    }

    Scriptable buildEventTargetWrapper(EventTarget obj) {
        return new EventTargetWrapper((Scriptable)this.globalObject, obj);
    }

    public void setOut(Writer out) {
    }

    public Locale getLocale() {
        return null;
    }

    public void setLocale(Locale locale) {
    }

    public String formatMessage(String key, Object[] args) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class[] getterArgs = new Class[]{class$org$mozilla$javascript$ScriptableObject == null ? (class$org$mozilla$javascript$ScriptableObject = RhinoInterpreter.class$("org.mozilla.javascript.ScriptableObject")) : class$org$mozilla$javascript$ScriptableObject};
            rhinoGetter = (class$org$apache$batik$script$rhino$RhinoInterpreter$RhinoGetDelegate == null ? (class$org$apache$batik$script$rhino$RhinoInterpreter$RhinoGetDelegate = RhinoInterpreter.class$("org.apache.batik.script.rhino.RhinoInterpreter$RhinoGetDelegate")) : class$org$apache$batik$script$rhino$RhinoInterpreter$RhinoGetDelegate).getDeclaredMethod("get", getterArgs);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public class ExtendedContext
    extends Context {
        public RhinoInterpreter getInterpreter() {
            return RhinoInterpreter.this;
        }

        public Window getWindow() {
            return RhinoInterpreter.this.getWindow();
        }

        public ScriptableObject getGlobalObject() {
            return RhinoInterpreter.this.getGlobalObject();
        }
    }

    public static interface ArgumentsBuilder {
        public Object[] buildArguments();
    }

    public static class RhinoGetDelegate {
        String name;

        RhinoGetDelegate(String name) {
            this.name = name;
        }

        public Object get(ScriptableObject so) {
            Context ctx = Context.getCurrentContext();
            if (ctx == null) {
                return null;
            }
            return ((ExtendedContext)ctx).getInterpreter().objects.get(this.name);
        }
    }

    private static class Entry {
        String str;
        Script script;

        Entry(String str, Script script) {
            this.str = str;
            this.script = script;
        }
    }
}

