/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.DecoderException;
import macromedia.abc.IndexHistory;
import macromedia.abc.MultiName;
import macromedia.abc.QName;
import macromedia.abc.Scanner;
import macromedia.asc.util.Decimal128;
import macromedia.asc.util.IntegerPool;

public class ConstantPool {
    public static final Object NULL = new Object();
    public boolean poolHasDecimal;
    BytecodeBuffer in;
    IndexHistory history;
    private int size;
    int[] intpositions;
    int[] uintpositions;
    int[] doublepositions;
    int[] decimalpositions;
    int[] strpositions;
    int[] nspositions;
    int[] nsspositions;
    int[] mnpositions;
    int intEnd;
    int uintEnd;
    int doubleEnd;
    int decimalEnd;
    int strEnd;
    int nsEnd;
    int nssEnd;
    int mnEnd;

    public static ConstantPool merge(ConstantPool[] pools) {
        int preferredSize = 0;
        boolean hasDecimal = false;
        int size = pools.length;
        for (int i = 0; i < size; ++i) {
            if (pools[i].decimalpositions.length > 0) {
                hasDecimal = true;
            }
            preferredSize += pools[i].mnEnd;
        }
        ConstantPool newPool = new ConstantPool(hasDecimal);
        newPool.in = new BytecodeBuffer(preferredSize);
        newPool.history = new IndexHistory(pools, hasDecimal);
        return newPool;
    }

    ConstantPool(boolean hasDecimal) {
        this.poolHasDecimal = hasDecimal;
    }

    public ConstantPool(BytecodeBuffer in, boolean hasDecimal) throws DecoderException {
        this.in = in;
        this.poolHasDecimal = hasDecimal;
        this.scan();
    }

    private void scan() throws DecoderException {
        this.intpositions = Scanner.scanIntConstants(this.in);
        this.intEnd = this.in.pos();
        this.uintpositions = Scanner.scanUIntConstants(this.in);
        this.uintEnd = this.in.pos();
        this.doublepositions = Scanner.scanDoubleConstants(this.in);
        this.doubleEnd = this.in.pos();
        if (this.poolHasDecimal) {
            this.decimalpositions = Scanner.scanDecimalConstants(this.in);
            this.decimalEnd = this.in.pos();
        } else {
            this.decimalpositions = new int[0];
            this.decimalEnd = this.in.pos();
        }
        this.strpositions = Scanner.scanStrConstants(this.in);
        this.strEnd = this.in.pos();
        this.nspositions = Scanner.scanNsConstants(this.in);
        this.nsEnd = this.in.pos();
        this.nsspositions = Scanner.scanNsSetConstants(this.in);
        this.nssEnd = this.in.pos();
        this.mnpositions = Scanner.scanMultinameConstants(this.in);
        this.mnEnd = this.in.pos();
        this.size = (this.intpositions.length == 0 ? 0 : this.intpositions.length - 1) + (this.uintpositions.length == 0 ? 0 : this.uintpositions.length - 1) + (this.doublepositions.length == 0 ? 0 : this.doublepositions.length - 1) + (this.decimalpositions.length == 0 ? 0 : this.decimalpositions.length - 1) + (this.strpositions.length == 0 ? 0 : this.strpositions.length - 1) + (this.nspositions.length == 0 ? 0 : this.nspositions.length - 1) + (this.nsspositions.length == 0 ? 0 : this.nsspositions.length - 1) + (this.mnpositions.length == 0 ? 0 : this.mnpositions.length - 1);
    }

    public int size() {
        return this.size;
    }

    public int getInt(int index) {
        if (index == 0) {
            return 0;
        }
        int pos = this.intpositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        int value = this.in.readU32();
        this.in.seek(originalPos);
        return value;
    }

    public long getLong(int index) {
        if (index == 0) {
            return 0L;
        }
        int pos = this.uintpositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        long value = this.in.readU32();
        this.in.seek(originalPos);
        return value;
    }

    public double getDouble(int index) {
        if (index == 0) {
            return 0.0;
        }
        int pos = this.doublepositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        double value = this.in.readDouble();
        this.in.seek(originalPos);
        return value;
    }

    public Decimal128 getDecimal(int index) {
        if (index == 0) {
            return Decimal128.ZERO;
        }
        int pos = this.decimalpositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        byte[] valbytes = this.in.readBytes(16);
        this.in.seek(originalPos);
        return new Decimal128(valbytes);
    }

    public String getString(int index) throws DecoderException {
        if (index == 0) {
            return null;
        }
        int pos = this.strpositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        String value = this.in.readString(this.in.readU32());
        this.in.seek(originalPos);
        if (value != null) {
            return value;
        }
        throw new DecoderException("abc Decoder Erro: problem reading UTF-8 encoded strings.");
    }

    public String getNamespaceName(int index) throws DecoderException {
        if (index == 0) {
            return null;
        }
        int pos = this.nspositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        int kind = this.in.readU8();
        String value = "";
        switch (kind) {
            case 5: 
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                value = this.getString(this.in.readU32());
                break;
            }
            default: {
                throw new DecoderException("abc Decoder Error: constant pool index '" + index + "' is not a Namespace type. The actual type is '" + kind + "'");
            }
        }
        this.in.seek(originalPos);
        return value;
    }

    public String[] getNamespaceSet(int index) throws DecoderException {
        if (index == 0) {
            return null;
        }
        int pos = this.nsspositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        int count = this.in.readU32();
        String[] value = new String[count];
        for (int j = 0; j < count; ++j) {
            value[j] = this.getNamespaceName(this.in.readU32());
        }
        this.in.seek(originalPos);
        if (value != null) {
            return value;
        }
        throw new DecoderException("abc Decoder Erro: problem reading namespace set.");
    }

    public int getNamespaceIndexForQName(int index) throws DecoderException {
        if (index == 0) {
            return 0;
        }
        int pos = this.mnpositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        int kind = this.in.readU8();
        switch (kind) {
            case 7: 
            case 13: {
                int namespaceIndex = this.in.readU32();
                this.in.seek(originalPos);
                return namespaceIndex;
            }
        }
        this.in.seek(originalPos);
        throw new DecoderException("abc Decoder Error: constant pool index '" + index + "' is not a QName type. The actual type is '" + kind + "'");
    }

    public int getNamespaceKind(int namespaceIndex) {
        if (namespaceIndex == 0) {
            return -1;
        }
        int pos = this.nspositions[namespaceIndex];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        int kind = this.in.readU8();
        this.in.seek(originalPos);
        return kind;
    }

    public QName getQName(int index) throws DecoderException {
        if (index == 0) {
            return null;
        }
        int pos = this.mnpositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        int kind = this.in.readU8();
        switch (kind) {
            case 7: 
            case 13: {
                int namespaceIndex = this.in.readU32();
                int nameIndex = this.in.readU32();
                QName value = this.createQName(this.getNamespaceName(namespaceIndex), this.getString(nameIndex));
                this.in.seek(originalPos);
                return value;
            }
        }
        this.in.seek(originalPos);
        throw new DecoderException("abc Decoder Error: constant pool index '" + index + "' is not a QName type. The actual type is '" + kind + "'");
    }

    public MultiName getMultiName(int index) throws DecoderException {
        if (index == 0) {
            return null;
        }
        int pos = this.mnpositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        int kind = this.in.readU8();
        switch (kind) {
            case 9: 
            case 14: {
                String name = this.getString(this.in.readU32());
                int namespace_set = this.in.readU32();
                String[] namespaces = this.getNamespaceSet(namespace_set);
                MultiName value = this.createMultiName(name, namespaces);
                this.in.seek(originalPos);
                return value;
            }
        }
        this.in.seek(originalPos);
        throw new DecoderException("abc Decoder Error: constant constantPool index '" + index + "' is not a MultiName type. The actual type is '" + kind + "'");
    }

    public Object getGeneralMultiname(int index) throws DecoderException {
        if (index == 0) {
            return null;
        }
        int pos = this.mnpositions[index];
        int originalPos = this.in.pos();
        this.in.seek(pos);
        int kind = this.in.readU8();
        switch (kind) {
            case 7: 
            case 13: {
                int namespaceIndex = this.in.readU32();
                int nameIndex = this.in.readU32();
                QName value = this.createQName(this.getNamespaceName(namespaceIndex), this.getString(nameIndex));
                this.in.seek(originalPos);
                return value;
            }
            case 9: 
            case 14: {
                String name = this.getString(this.in.readU32());
                int namespace_set = this.in.readU32();
                String[] namespaces = this.getNamespaceSet(namespace_set);
                MultiName value = this.createMultiName(name, namespaces);
                this.in.seek(originalPos);
                return value;
            }
            case 17: {
                this.in.seek(originalPos);
                return "CONSTANT_RTQnameL";
            }
            case 18: {
                this.in.seek(originalPos);
                return "CONSTANT_RTQnameLA";
            }
            case 27: 
            case 28: {
                int namespacesetIndex = this.in.readU32();
                String[] value = this.getNamespaceSet(namespacesetIndex);
                ArrayList<String> a = new ArrayList<String>();
                for (int k = 0; k < value.length; ++k) {
                    a.add(value[k]);
                }
                this.in.seek(originalPos);
                return a;
            }
            case 15: 
            case 16: {
                int idx = this.in.readU32();
                String s = this.getString(idx);
                this.in.seek(originalPos);
                return s;
            }
        }
        this.in.seek(originalPos);
        throw new DecoderException("abc Decoder Error: constant pool index '" + index + "' is not a QName type. The actual type is '" + kind + "'");
    }

    public Object get(int index, int kind) throws DecoderException {
        if (index == 0) {
            return null;
        }
        switch (kind) {
            case 1: {
                String value = this.getString(index);
                return value;
            }
            case 3: {
                Integer value = this.createInteger(this.getInt(index));
                return value;
            }
            case 4: {
                Long value = this.createLong(this.getLong(index));
                return value;
            }
            case 6: {
                Double value = this.createDouble(this.getDouble(index));
                return value;
            }
            case 2: {
                Decimal128 value = this.getDecimal(index);
                return value;
            }
            case 7: 
            case 13: {
                QName value = this.getQName(index);
                return value;
            }
            case 5: 
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                String value = this.getNamespaceName(index);
                return value;
            }
            case 9: 
            case 14: {
                MultiName value = this.getMultiName(index);
                return value;
            }
            case 10: {
                Boolean value = Boolean.FALSE;
                return value;
            }
            case 11: {
                Boolean value = Boolean.TRUE;
                return value;
            }
            case 12: {
                Object value = NULL;
                return value;
            }
            case 15: 
            case 16: {
                Object value = this.getGeneralMultiname(index);
                return value;
            }
            case 17: {
                String value = "CONSTANT_RTQnameL";
                return value;
            }
            case 18: {
                String value = "CONSTANT_RTQnameLA";
                return value;
            }
            case 27: {
                String[] value = this.getNamespaceSet(this.getInt(index));
                return value;
            }
            case 28: {
                String[] value = this.getNamespaceSet(this.getInt(index));
                return value;
            }
            case 21: {
                String[] value = this.getNamespaceSet(index);
                return value;
            }
        }
        throw new DecoderException("Error: Unhandled constant type - " + kind);
    }

    private Integer createInteger(int number) {
        return IntegerPool.getNumber(number);
    }

    private Long createLong(long number) {
        return new Long(number);
    }

    private Double createDouble(double number) {
        return new Double(number);
    }

    private QName createQName(String ns, String name) {
        return new QName(ns, name);
    }

    private MultiName createMultiName(String name, String[] ns) {
        return new MultiName(name, ns);
    }

    public void writeTo(OutputStream out) throws IOException {
        this.history.writeTo(this.in);
        this.in.writeTo(out);
    }
}

