/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.parser.InputBufferStream;
import macromedia.asc.util.IntList;

public class InputBuffer {
    protected StringBuffer text;
    protected IntList line_breaks;
    private boolean atEOF = false;
    public Reader in;
    private int pushBackChar = -1;
    public String origin;
    public StringBuffer curr_line;
    public StringBuffer prev_line;
    public StringBuffer raw_curr_line;
    public int curr_line_offset;
    public int prev_line_offset;
    public int pos;
    public int colPos;
    public int lnNum;
    public boolean has_unixnewlines;
    public boolean report_pos = true;
    private byte[] bom = new byte[3];
    public int markCol;
    public int markLn;

    public InputBuffer(InputStream in, String encoding, String origin) {
        this.in = this.createReader(in, encoding);
        this.text = new StringBuffer(8192);
        this.init(origin, 0);
    }

    public InputBuffer(String in, String origin) {
        this.in = new StringReader(in);
        this.text = new StringBuffer(in.length() + 10);
        this.init(origin, 0);
    }

    protected InputBuffer() {
    }

    private void init(String origin, int pos) {
        this.origin = origin;
        this.curr_line = new StringBuffer(80);
        this.prev_line = new StringBuffer(80);
        this.prev_line_offset = -1;
        this.pos = pos;
        this.lnNum = -1;
        this.colPos = 0;
        this.raw_curr_line = new StringBuffer(80);
        this.has_unixnewlines = false;
        this.line_breaks = new IntList(200);
        this.line_breaks.add(0);
    }

    private Reader createReader(InputStream in, String encoding) {
        try {
            in.read(this.bom, 0, 3);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new StringReader("");
        }
        if (this.bom[0] == -17 && this.bom[1] == -69 && this.bom[2] == -65) {
            try {
                return new BufferedReader(new InputStreamReader(in, "UTF8"));
            }
            catch (UnsupportedEncodingException ex) {
                return new BufferedReader(new InputStreamReader(in));
            }
        }
        if (this.bom[0] == -1 && this.bom[1] == -2 || this.bom[0] == -2 && this.bom[1] == -1) {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)new InputBufferStream(this.bom, in), "UTF16"));
            }
            catch (UnsupportedEncodingException ex) {
                return new BufferedReader(new InputStreamReader(new InputBufferStream(this.bom, in)));
            }
        }
        if (encoding != null) {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)new InputBufferStream(this.bom, in), encoding));
            }
            catch (UnsupportedEncodingException ex) {
                return new BufferedReader(new InputStreamReader(new InputBufferStream(this.bom, in)));
            }
        }
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new InputBufferStream(this.bom, in), "UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            return new BufferedReader(new InputStreamReader(new InputBufferStream(this.bom, in)));
        }
    }

    public int read() {
        if (this.atEOF) {
            return -1;
        }
        if (this.pushBackChar != -1) {
            int result = this.pushBackChar;
            this.pushBackChar = -1;
            ++this.pos;
            return result;
        }
        try {
            int c = this.in.read();
            if (c == -1) {
                this.atEOF = true;
            } else {
                this.text.append((char)c);
                ++this.pos;
            }
            return c;
        }
        catch (IOException ex) {
            this.atEOF = true;
            ++this.pos;
            return -1;
        }
    }

    public String source() {
        return this.text.toString();
    }

    public String source(int begin, int end) {
        return this.text.substring(begin, end);
    }

    public int nextchar() {
        return this.nextchar(false);
    }

    public int nextchar(boolean get_unnormalized) {
        int c = -1;
        if (this.colPos == this.curr_line.length()) {
            if (!this.atEOF) {
                ++this.lnNum;
            }
            this.colPos = 0;
            this.raw_curr_line.setLength(0);
            StringBuffer prevSave = this.prev_line;
            this.prev_line = this.curr_line;
            this.prev_line_offset = this.curr_line_offset;
            this.curr_line = prevSave;
            this.curr_line.setLength(0);
            this.curr_line_offset = this.pos;
            block8: while (c != 10 && c != 0) {
                int lastChar = c;
                c = this.read();
                if (lastChar == 13 && c != 10) {
                    this.pushBackChar = c;
                    --this.pos;
                    break;
                }
                block9: while (true) {
                    switch (c) {
                        case 1807: 
                        case 6155: 
                        case 6156: 
                        case 6157: 
                        case 6158: 
                        case 8204: 
                        case 8205: 
                        case 8206: 
                        case 8207: 
                        case 8234: 
                        case 8235: 
                        case 8236: 
                        case 8237: 
                        case 8238: 
                        case 8298: 
                        case 8299: 
                        case 8300: 
                        case 8301: 
                        case 8302: 
                        case 8303: 
                        case 65279: 
                        case 65529: 
                        case 65530: 
                        case 65531: {
                            c = this.read();
                            continue block9;
                        }
                    }
                    break;
                }
                switch (c) {
                    case 10: 
                    case 13: 
                    case 8232: 
                    case 8233: {
                        this.raw_curr_line.append((char)c);
                        if (lastChar == 13 && c == 10) {
                            this.line_breaks.set(this.lnNum + 1, this.pos);
                            continue block8;
                        }
                        this.curr_line.append('\n');
                        this.line_breaks.resize(this.lnNum + 1);
                        this.line_breaks.set(this.lnNum + 1, this.pos);
                        continue block8;
                    }
                    case 9: 
                    case 11: 
                    case 12: 
                    case 32: 
                    case 160: {
                        this.raw_curr_line.append((char)c);
                        c = 32;
                        this.curr_line.append((char)c);
                        continue block8;
                    }
                    case -1: {
                        c = 0;
                        this.raw_curr_line.append((char)c);
                        this.curr_line.append((char)c);
                        continue block8;
                    }
                }
                this.raw_curr_line.append((char)c);
                this.curr_line.append((char)c);
            }
            if (get_unnormalized) {
                return 10;
            }
        }
        c = get_unnormalized ? this.raw_curr_line.charAt(this.colPos++) : this.curr_line.charAt(this.colPos++);
        return c;
    }

    public void retract() {
        if (--this.colPos < 0) {
            StringBuffer currSave = this.curr_line;
            this.curr_line = this.prev_line;
            this.prev_line = currSave;
            this.prev_line.setLength(0);
            --this.lnNum;
            this.colPos = this.curr_line.length() - 1;
            this.curr_line_offset = this.prev_line_offset;
        }
    }

    private final int unHex(char c) {
        return Character.digit(c, 16);
    }

    private final boolean isHex(char c) {
        return Character.digit(c, 16) != -1;
    }

    private final char javaTypeOfToCharacterClass(int javaClassOf) {
        switch (javaClassOf) {
            case 1: {
                return '\u0001';
            }
            case 2: {
                return '\u0002';
            }
            case 3: {
                return '\u0003';
            }
            case 6: {
                return '\u0004';
            }
            case 8: {
                return '\u0005';
            }
            case 7: {
                return '\u0006';
            }
            case 9: {
                return '\u0007';
            }
            case 10: {
                return '\b';
            }
            case 11: {
                return '\t';
            }
            case 12: {
                return '\n';
            }
            case 13: {
                return '\u000b';
            }
            case 14: {
                return '\f';
            }
            case 15: {
                return '\r';
            }
            case 16: {
                return '\u000e';
            }
            case 19: {
                return '\u000f';
            }
            case 18: {
                return '\u0010';
            }
            case 0: {
                return '\u0011';
            }
            case 4: {
                return '\u0012';
            }
            case 5: {
                return '\u0013';
            }
            case 23: {
                return '\u0014';
            }
            case 20: {
                return '\u0015';
            }
            case 21: {
                return '\u0016';
            }
            case 22: {
                return '\u0017';
            }
            case 29: {
                return '\u0018';
            }
            case 30: {
                return '\u0019';
            }
            case 24: {
                return '\u001a';
            }
            case 25: {
                return '\u001b';
            }
            case 26: {
                return '\u001c';
            }
            case 27: {
                return '\u001d';
            }
            case 28: {
                return '\u001e';
            }
        }
        return '\u0011';
    }

    public char classOfNext() {
        char c;
        if (this.curr_line.charAt(this.colPos - 1) == '\\' && this.curr_line.charAt(this.colPos) == 'u' && this.isHex(this.curr_line.charAt(this.colPos + 1)) && this.isHex(this.curr_line.charAt(this.colPos + 2)) && this.isHex(this.curr_line.charAt(this.colPos + 3)) && this.isHex(this.curr_line.charAt(this.colPos + 4))) {
            int ic = (((this.unHex(this.curr_line.charAt(this.colPos + 1)) << 4) + this.unHex(this.curr_line.charAt(this.colPos + 2)) << 4) + this.unHex(this.curr_line.charAt(this.colPos + 3)) << 4) + this.unHex(this.curr_line.charAt(this.colPos + 4));
            c = (char)ic;
            this.nextchar();
            this.nextchar();
            this.nextchar();
            this.nextchar();
            this.nextchar();
        } else {
            c = this.curr_line.charAt(this.colPos - 1);
        }
        return this.javaTypeOfToCharacterClass(Character.getType(c));
    }

    public int positionOfNext() {
        return this.curr_line_offset + this.colPos - 1;
    }

    public int positionOfMark() {
        if (!this.report_pos) {
            return -1;
        }
        int ret = this.markLn < 0 ? this.positionOfNext() : (this.markLn >= this.line_breaks.size() ? this.markCol : this.line_breaks.get(this.markLn) + this.markCol);
        return ret;
    }

    public int mark() {
        this.markLn = this.lnNum == -1 ? 0 : this.lnNum;
        this.markCol = this.colPos;
        return this.markCol;
    }

    public String copyWithoutInterpretingEscapedChars() {
        return this.curr_line.substring(this.markCol - 1, this.colPos);
    }

    public String escapeString(StringBuffer source, int from, int to) {
        int stop = to + 1;
        boolean required = false;
        for (int i = from; i < stop; ++i) {
            if (source.charAt(i) != '\\') continue;
            required = true;
            break;
        }
        if (!required) {
            return source.substring(from, stop);
        }
        StringBuffer buf = new StringBuffer(stop - from);
        block15: for (int i = from; i < stop; ++i) {
            int c = source.charAt(i);
            if (c == 92) {
                char c2 = source.charAt(i + 1);
                block0 : switch (c2) {
                    case '\"': 
                    case '\'': {
                        continue block15;
                    }
                    case '\\': {
                        c = 92;
                        ++i;
                        break;
                    }
                    case 'u': {
                        int digit;
                        int y;
                        int thisChar = 0;
                        for (y = i + 2; y < i + 6 && y < to + 1 && (digit = Character.digit(source.charAt(y), 16)) != -1; ++y) {
                            thisChar = (thisChar << 4) + digit;
                        }
                        if (y != i + 6 || !Character.isDefined((char)thisChar)) {
                            c = source.charAt(++i);
                            break;
                        }
                        c = (char)thisChar;
                        i += 5;
                        break;
                    }
                    default: {
                        if (Features.PASS_ESCAPES_TO_BACKEND) {
                            c = source.charAt(++i);
                            break;
                        }
                        switch (c2) {
                            case 'b': {
                                c = 8;
                                ++i;
                                break block0;
                            }
                            case 'f': {
                                c = 12;
                                ++i;
                                break block0;
                            }
                            case 'n': {
                                c = 10;
                                ++i;
                                break block0;
                            }
                            case 'r': {
                                c = 13;
                                ++i;
                                break block0;
                            }
                            case 't': {
                                c = 9;
                                ++i;
                                break block0;
                            }
                            case 'v': {
                                c = 11;
                                ++i;
                                break block0;
                            }
                            case 'x': {
                                if (i + 3 < this.colPos && this.isHex(source.charAt(i + 2)) && this.isHex(source.charAt(i + 3))) {
                                    c = (char)((this.unHex(source.charAt(i + 2)) << 4) + this.unHex(source.charAt(i + 3)));
                                    i += 3;
                                    break block0;
                                }
                                ++i;
                                c = 120;
                                break block0;
                            }
                        }
                        c = source.charAt(++i);
                    }
                }
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    public String copy() {
        return this.escapeString(this.curr_line, this.markCol - 1, this.colPos - 1);
    }

    public String getLineText(int pos) {
        int begin;
        int end;
        int a;
        for (int i = 0; i < this.line_breaks.size() && (a = this.line_breaks.get(i)) <= pos && a >= 0 && i <= this.lnNum; ++i) {
        }
        int len = this.text.length();
        for (end = begin = this.line_breaks.get(i - 1); end < len && this.text.charAt(end) != '\n' && this.text.charAt(end) != '\r' && this.text.charAt(end) != '\u0000'; ++end) {
        }
        int size = end - begin;
        String buf = begin + size > this.text.length() ? this.text.substring(begin) : this.text.substring(begin, begin + size);
        return buf;
    }

    public int getLineBreakPos(int line) {
        return this.line_breaks.at(line - 1);
    }

    public int getColPos(int pos) {
        int line = this.getLnNum(pos);
        return pos - (line == 0 ? 0 : this.line_breaks.get(line - 1)) + 1;
    }

    public int getColPos(int pos, int line) {
        return pos - (line == 0 ? 0 : this.line_breaks.get(line - 1)) + 1;
    }

    public void getLnNumAndColPos(int pos, int[] line, int[] col) {
        line[0] = this.getLnNum(pos);
        col[0] = pos - (line[0] == 0 ? 0 : this.line_breaks.get(line[0] - 1)) + 1;
    }

    public int getLnNum(int pos) {
        int lo = 0;
        int hi = this.lnNum;
        while (hi >= lo) {
            int mid = (hi + lo) / 2;
            int val = this.line_breaks.get(mid);
            if (val > pos) {
                hi = mid;
                continue;
            }
            if (val == pos) {
                return mid + 1;
            }
            if (mid == this.lnNum) {
                if (pos > val) {
                    return mid + 1;
                }
                return mid;
            }
            if (this.line_breaks.size() == mid + 1 || this.line_breaks.get(mid + 1) > pos) {
                return mid + 1;
            }
            lo = mid + 1;
        }
        return lo;
    }

    public static String getLinePointer(int pos) {
        StringBuffer padding = new StringBuffer(pos);
        for (int i = 0; i < pos - 1; ++i) {
            padding.append(".");
        }
        padding.append("^");
        return padding.toString();
    }

    public void clearUnusedBuffers() {
        this.text = new StringBuffer(this.text.toString());
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in = null;
        this.curr_line = null;
        this.prev_line = null;
        this.bom = null;
    }
}

