/*
 * Decompiled with CFR 0.152.
 */
package flex.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.Task;

public final class HtmlWrapperTask
extends Task
implements DynamicAttribute {
    private static final int CLIENT_SIDE_DETECTION = 0;
    private static final int EXPRESS_INSTALLATION = 1;
    private static final int NO_PLAYER_DETECTION = 2;
    private static final String[] templates = new String[]{"client-side-detection", "express-installation", "no-player-detection"};
    private static final String TEMPLATE_DIR = "/templates/html-templates/";
    private static final String WITH_HISTORY = "-with-history/";
    private static final String INDEX_TEMPLATE_HTML = "index.template.html";
    private static final String AC_OETAGS_JS = "AC_OETags.js";
    private static final String HISTORY_CSS = "history/history.css";
    private static final String HISTORY_JS = "history/history.js";
    private static final String HISTORY_FRAME_HTML = "history/historyFrame.html";
    private static final String PLAYERPRODUCTINSTALL_SWF = "playerProductInstall.swf";
    private String application;
    private String bgcolor = "white";
    private String fileName = "index.html";
    private String height = "400";
    private String output;
    private String swf;
    private String title = "Flex Application";
    private String versionMajor = "9";
    private String versionMinor = "0";
    private String versionRevision = "0";
    private String width = "400";
    private boolean history = false;
    private int template;

    public HtmlWrapperTask() {
        this.setTaskName("html-wrapper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if (this.swf == null) {
            throw new BuildException("The <html-wrapper> task requires the 'swf' attribute.", this.getLocation());
        }
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) throw new BuildException("Missing resources", this.getLocation());
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        String path = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            if (this.output != null) {
                File outputDir = new File(this.output);
                if (outputDir.exists() && outputDir.isDirectory()) {
                    path = this.output + File.separatorChar + this.fileName;
                } else {
                    String base = this.getProject().getBaseDir().getAbsolutePath();
                    outputDir = new File(base + File.separatorChar + this.output);
                    if (!outputDir.exists() || !outputDir.isDirectory()) throw new BuildException("output directory does not exist: " + this.output);
                    path = base + File.separatorChar + this.output + File.separatorChar + this.fileName;
                }
            } else {
                path = this.fileName;
            }
            printWriter = new PrintWriter(new FileWriter(path));
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(this.substitute(line));
            }
            return;
        }
        catch (IOException ioException) {
            System.err.println("Error outputting resource: " + path);
            ioException.printStackTrace();
            return;
        }
        finally {
            try {
                bufferedReader.close();
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private InputStream getInputStream() {
        InputStream inputStream = null;
        switch (this.template) {
            case 0: {
                if (this.history) {
                    inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(TEMPLATE_DIR + templates[0] + WITH_HISTORY + INDEX_TEMPLATE_HTML);
                    this.outputResources(TEMPLATE_DIR + templates[0] + WITH_HISTORY, new String[]{AC_OETAGS_JS, HISTORY_FRAME_HTML, HISTORY_JS, HISTORY_CSS});
                    break;
                }
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(TEMPLATE_DIR + templates[0] + "/" + INDEX_TEMPLATE_HTML);
                this.outputResources(TEMPLATE_DIR + templates[0] + "/", new String[]{AC_OETAGS_JS});
                break;
            }
            default: {
                if (this.history) {
                    inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(TEMPLATE_DIR + templates[1] + WITH_HISTORY + INDEX_TEMPLATE_HTML);
                    this.outputResources(TEMPLATE_DIR + templates[1] + WITH_HISTORY, new String[]{AC_OETAGS_JS, HISTORY_FRAME_HTML, HISTORY_JS, HISTORY_CSS, PLAYERPRODUCTINSTALL_SWF});
                    break;
                }
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(TEMPLATE_DIR + templates[1] + "/" + INDEX_TEMPLATE_HTML);
                this.outputResources(TEMPLATE_DIR + templates[1] + "/", new String[]{AC_OETAGS_JS, PLAYERPRODUCTINSTALL_SWF});
                break;
            }
            case 2: {
                if (this.history) {
                    inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(TEMPLATE_DIR + templates[2] + WITH_HISTORY + INDEX_TEMPLATE_HTML);
                    this.outputResources(TEMPLATE_DIR + templates[2] + WITH_HISTORY, new String[]{AC_OETAGS_JS, HISTORY_FRAME_HTML, HISTORY_JS, HISTORY_CSS});
                    break;
                }
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(TEMPLATE_DIR + templates[2] + "/" + INDEX_TEMPLATE_HTML);
                this.outputResources(TEMPLATE_DIR + templates[2] + "/", new String[]{AC_OETAGS_JS});
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputResources(String resourceDir, String[] resources) {
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        for (int i = 0; i < resources.length; ++i) {
            try {
                String line;
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(resourceDir + resources[i]);
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String path = null;
                if (this.output != null) {
                    File outputDir = new File(this.output);
                    if (outputDir.exists() && outputDir.isDirectory()) {
                        path = this.output + File.separatorChar + resources[i];
                    } else {
                        String base = this.getProject().getBaseDir().getAbsolutePath();
                        outputDir = new File(base + File.separatorChar + this.output);
                        if (!outputDir.exists() || !outputDir.isDirectory()) throw new BuildException("output directory does not exist: " + this.output);
                        path = base + File.separatorChar + this.output + File.separatorChar + resources[i];
                    }
                } else {
                    path = resources[i];
                }
                File file = new File(path);
                file.getParentFile().mkdirs();
                printWriter = new PrintWriter(new FileWriter(file));
                while ((line = bufferedReader.readLine()) != null) {
                    printWriter.println(line);
                }
                continue;
            }
            catch (IOException ioException) {
                System.err.println("Error outputting resource: " + resources[i]);
                ioException.printStackTrace();
                continue;
            }
            finally {
                try {
                    bufferedReader.close();
                    printWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
    }

    public void setDynamicAttribute(String name, String value) {
        if (name.equals("version-major")) {
            this.versionMajor = value;
        } else if (name.equals("version-minor")) {
            this.versionMinor = value;
        } else if (name.equals("version-revision")) {
            this.versionRevision = value;
        } else {
            throw new BuildException("The <html-wrapper> task doesn't support the \"" + name + "\" attribute.", this.getLocation());
        }
    }

    public void setFile(String fileName) {
        this.fileName = fileName;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setHistory(boolean history) {
        this.history = history;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setSwf(String swf) {
        this.swf = swf.replace('\\', '/');
        if (this.application == null) {
            this.application = this.swf;
        }
    }

    public void setTemplate(String template) {
        if (template.equals(templates[0])) {
            this.template = 0;
        } else if (template.equals(templates[1])) {
            this.template = 1;
        } else if (template.equals(templates[2])) {
            this.template = 2;
        } else {
            throw new BuildException("The 'template' attribute must be one of '" + templates[0] + "', '" + templates[1] + "', '" + templates[2] + "'.", this.getLocation());
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    private String substitute(String input) {
        String result = input.replaceAll("\\$\\{application\\}", this.application);
        result = result.replaceAll("\\$\\{bgcolor\\}", this.bgcolor);
        result = result.replaceAll("\\$\\{height\\}", this.height);
        result = result.replaceAll("\\$\\{swf\\}", this.swf);
        result = result.replaceAll("\\$\\{title\\}", this.title);
        result = result.replaceAll("\\$\\{version_major\\}", this.versionMajor);
        result = result.replaceAll("\\$\\{version_minor\\}", this.versionMinor);
        result = result.replaceAll("\\$\\{version_revision\\}", this.versionRevision);
        result = result.replaceAll("\\$\\{width\\}", this.width);
        return result;
    }
}

