/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.asdoc.ClassTable;
import flex2.compiler.asdoc.TopLevelGenerator;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.ObjectList;

public class ASDocExtension
implements Extension {
    private static String EXCLUDE_CLASS = "ExcludeClass";
    private static boolean useNewCode = true;
    private StringBuffer out;
    private String xml;
    private List excludeClasses;
    private Set includeOnly;
    private Set packages;
    private LinkedHashMap classes;
    private ClassTable tab;

    public ASDocExtension(List excludeClasses, Set includeOnly, Set packages) {
        this.excludeClasses = excludeClasses;
        this.includeOnly = includeOnly;
        this.packages = packages;
        if (!useNewCode) {
            this.out = new StringBuffer();
            this.out.append("<asdoc>\n");
            this.classes = new LinkedHashMap();
        } else {
            this.tab = new ClassTable();
        }
    }

    public void finish() {
        if (!useNewCode) {
            Iterator iter = this.classes.values().iterator();
            while (iter.hasNext()) {
                CommentsTable temp = (CommentsTable)iter.next();
                temp.writeTopLevel(this.out);
            }
            this.out.append("\n</asdoc>\n");
            this.xml = this.out.toString();
            this.out = null;
        } else {
            TopLevelGenerator g = new TopLevelGenerator();
            g.generate(this.tab);
            this.xml = ((Object)g).toString();
            Object var1_2 = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveFile(File file) {
        BufferedOutputStream outputStream = null;
        try {
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                outputStream.write(this.xml.getBytes("UTF-8"));
                outputStream.flush();
            }
            catch (IOException ex) {
                if (!Trace.error) throw new RuntimeException("Could not save " + file + ": " + ex);
                ex.printStackTrace();
                throw new RuntimeException("Could not save " + file + ": " + ex);
            }
            Object var5_3 = null;
            if (Trace.asdoc) {
                System.out.println("Wrote doc file: " + file);
            }
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (Trace.asdoc) {
                System.out.println("Wrote doc file: " + file);
            }
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        outputStream.close();
        return;
    }

    public String getXML() {
        return this.xml;
    }

    public void parse1(CompilationUnit unit, TypeTable typeTable) {
    }

    public void parse2(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze1(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze2(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze3(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze4(CompilationUnit unit, TypeTable typeTable) {
    }

    public void generate(CompilationUnit unit, TypeTable typeTable) {
        Context flexCx = unit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)flexCx.getAttribute("cx");
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        String className = NameFormatter.toDot(unit.topLevelDefinitions.first());
        boolean exclude = false;
        if (this.includeOnly != null && !this.includeOnly.contains(className)) {
            exclude = true;
        } else if (this.excludeClasses.contains(className)) {
            this.excludeClasses.remove(className);
            exclude = true;
        } else if (unit.metadata != null) {
            Iterator iterator = unit.metadata.iterator();
            while (iterator.hasNext()) {
                MetaDataNode metaDataNode = (MetaDataNode)iterator.next();
                if (!EXCLUDE_CLASS.equals(metaDataNode.id)) continue;
                exclude = true;
                break;
            }
        }
        HashSet inheritance = new HashSet();
        Iterator iter = unit.inheritance.iterator();
        while (iter.hasNext()) {
            inheritance.add(iter.next());
        }
        CommentsTable table = new CommentsTable(inheritance, exclude, cx);
        if (!exclude && !unit.getSource().isInternal()) {
            String n;
            if (Trace.asdoc) {
                System.out.println("Generating XML for " + unit.getSource().getName());
            }
            if (this.packages.size() != 0 && (n = unit.topLevelDefinitions.first().getNamespace()) != null) {
                this.packages.remove(n);
            }
            cx.pushScope(node.frame);
            MetaDataEvaluator printer = new MetaDataEvaluator();
            node.evaluate(cx, printer);
            ObjectList<DocCommentNode> comments = printer.doccomments;
            if (!useNewCode) {
                int numComments = comments.size();
                for (int x = 0; x < numComments; ++x) {
                    table.addComment((DocCommentNode)comments.get(x));
                }
            } else {
                this.tab.addComments(unit.topLevelDefinitions.first(), comments, inheritance, false, cx);
            }
            cx.popScope();
        } else {
            String n;
            if (Trace.asdoc) {
                System.out.println("Skipping generating XML for " + unit.getSource().getName());
            }
            if (this.packages.size() != 0 && (n = unit.topLevelDefinitions.first().getNamespace()) != null) {
                this.packages.remove(n);
            }
            cx.pushScope(node.frame);
            MetaDataEvaluator printer = new MetaDataEvaluator();
            node.evaluate(cx, printer);
            ObjectList<DocCommentNode> comments = printer.doccomments;
            if (!useNewCode) {
                int numComments = comments.size();
                for (int x = 0; x < numComments; ++x) {
                    table.addComment((DocCommentNode)comments.get(x));
                }
            } else {
                this.tab.addComments(unit.topLevelDefinitions.first(), comments, inheritance, true, cx);
            }
            cx.popScope();
        }
        if (!useNewCode) {
            this.classes.put(className, table);
        }
    }

    private class CommentsTable {
        private final int PACKAGE = 0;
        private final int CLASS = 1;
        private final int INTERFACE = 2;
        private final int FUNCTION = 3;
        private final int FUNCTION_GET = 4;
        private final int FUNCTION_SET = 5;
        private final int FIELD = 6;
        private TreeMap docTable = new TreeMap();
        private boolean exclude;
        private HashSet inheritance;
        private macromedia.asc.util.Context cx;

        public CommentsTable(HashSet inheritance, boolean exclude, macromedia.asc.util.Context cx) {
            this.exclude = exclude;
            this.inheritance = inheritance;
            this.cx = cx;
        }

        public void addComment(DocCommentNode comment) {
            CommentEntry entry = new CommentEntry(comment, this.exclude);
            if (!this.docTable.containsKey(entry.key)) {
                this.docTable.put(entry.key, entry);
            }
        }

        private String findInheritDoc(KeyPair key) {
            String inheritDoc = null;
            Iterator iter = this.inheritance.iterator();
            while (iter.hasNext()) {
                String nextClass = NameFormatter.toDot((QName)iter.next());
                CommentsTable t = (CommentsTable)ASDocExtension.this.classes.get(nextClass);
                if (t != null) {
                    inheritDoc = key.type == 1 ? t.getCommentForInherit(new KeyPair(nextClass.substring(nextClass.lastIndexOf(46) + 1), 1)) : t.getCommentForInherit(key);
                }
                if (inheritDoc == null) continue;
                break;
            }
            return inheritDoc;
        }

        public String getCommentForInherit(KeyPair key) {
            CommentEntry temp = (CommentEntry)this.docTable.get(key);
            if (temp != null) {
                return temp.getValue();
            }
            return this.findInheritDoc(key);
        }

        public StringBuffer writeTopLevel(StringBuffer s) {
            if (this.exclude) {
                return s;
            }
            Iterator iter = this.docTable.values().iterator();
            while (iter.hasNext()) {
                s = ((CommentEntry)iter.next()).emit(s);
            }
            return s;
        }

        private class CommentEntry {
            private boolean exclude;
            private String id;
            private StringBuffer emitme;
            public KeyPair key;
            private boolean inherit = false;

            public CommentEntry(DocCommentNode comment, boolean exclude) {
                this.exclude = exclude;
                this.emitme = new StringBuffer();
                this.id = comment.id == null ? "" : comment.id;
                this.processComment(comment);
            }

            private String getAccessKindFromNS(ObjectValue ns) {
                String access_specifier;
                switch (ns.getNamespaceKind()) {
                    case 0: {
                        access_specifier = "public";
                        break;
                    }
                    case 1: {
                        access_specifier = "internal";
                        break;
                    }
                    case 3: {
                        access_specifier = "protected";
                        break;
                    }
                    case 2: {
                        access_specifier = "private";
                        break;
                    }
                    default: {
                        access_specifier = "public";
                    }
                }
                return access_specifier;
            }

            private void emitMetaDataComment(String debugName, MetaDataNode meta, boolean isAttributeOfDefinition, MetaDataNode current) {
                MetaDataEvaluator.KeyValuePair kv;
                MetaDataEvaluator.KeylessValue ov;
                Value v;
                int i;
                this.emitme.append("\n<metadata>\n");
                String tagname = meta.id;
                this.emitme.append("\n\t<").append(tagname).append(" ");
                this.emitme.append("owner='").append(debugName).append("' ");
                boolean has_name = false;
                if (meta.values != null) {
                    for (i = 0; i < meta.values.length; ++i) {
                        v = meta.values[i];
                        if (v == null) continue;
                        if (v instanceof MetaDataEvaluator.KeylessValue && !has_name) {
                            ov = (MetaDataEvaluator.KeylessValue)v;
                            this.emitme.append("name='").append(ov.obj).append("' ");
                            has_name = true;
                            continue;
                        }
                        if (!(v instanceof MetaDataEvaluator.KeyValuePair)) continue;
                        kv = (MetaDataEvaluator.KeyValuePair)v;
                        this.emitme.append(kv.key).append("='").append(kv.obj).append("' ");
                    }
                } else if (meta.id != null) {
                    this.emitme.append("name='").append(meta.id).append("' ");
                }
                this.emitme.append(">\n");
                if (!isAttributeOfDefinition) {
                    if (current.values != null) {
                        for (i = 0; i < current.values.length; ++i) {
                            v = current.values[i];
                            if (v == null) continue;
                            if (v instanceof MetaDataEvaluator.KeylessValue) {
                                ov = (MetaDataEvaluator.KeylessValue)v;
                                this.emitme.append(ov.obj);
                                continue;
                            }
                            if (!(v instanceof MetaDataEvaluator.KeyValuePair)) continue;
                            kv = (MetaDataEvaluator.KeyValuePair)v;
                            this.emitme.append("\n\t<").append(kv.key).append(">").append(kv.obj).append("</").append(kv.key).append(">");
                        }
                    } else if (current.id != null) {
                        this.emitme.append(current.id);
                    }
                }
                this.emitme.append("\n\t</").append(tagname).append(">\n");
                this.emitme.append("</metadata>\n");
            }

            private void processComment(DocCommentNode comment) {
                int type;
                String name = "";
                String tagname = "";
                String debug_name = "";
                if (comment.def instanceof PackageDefinitionNode) {
                    type = 0;
                    PackageDefinitionNode pd = (PackageDefinitionNode)comment.def;
                    name = pd.name.id != null ? pd.name.id.pkg_part : "";
                    tagname = "packageRec";
                    debug_name = "";
                    this.emitme.append("\n<");
                    this.emitme.append(tagname);
                    this.emitme.append(" name='");
                    this.emitme.append(pd.name.id != null ? pd.name.id.pkg_part : "");
                    this.emitme.append(".");
                    this.emitme.append(pd.name.id != null ? pd.name.id.def_part : "");
                    this.emitme.append("' fullname='");
                    this.emitme.append(pd.name.id != null ? pd.name.id.pkg_part : "");
                    this.emitme.append(".");
                    this.emitme.append(pd.name.id != null ? pd.name.id.def_part : "");
                    this.emitme.append("'>\n");
                } else if (comment.def instanceof ClassDefinitionNode) {
                    ClassDefinitionNode cd = (ClassDefinitionNode)comment.def;
                    name = cd.name.name;
                    debug_name = cd.debug_name;
                    if (cd.metaData.items.at(0) != comment) {
                        type = -1;
                        name = "IGNORE";
                    } else {
                        Slot s;
                        ReferenceValue rv;
                        int i;
                        Value firstV;
                        ObjectList<Value> values;
                        InterfaceDefinitionNode idn = null;
                        if (comment.def instanceof InterfaceDefinitionNode) {
                            type = 2;
                            tagname = "interfaceRec";
                            idn = (InterfaceDefinitionNode)comment.def;
                        } else {
                            type = 1;
                            tagname = "classRec";
                        }
                        this.emitme.append("\n<");
                        this.emitme.append(tagname);
                        this.emitme.append(" name='");
                        this.emitme.append(cd.name.name);
                        this.emitme.append("' fullname='");
                        this.emitme.append(cd.debug_name);
                        if (cd.cx.input != null && cd.cx.input.origin.length() != 0) {
                            this.emitme.append("' sourcefile='");
                            this.emitme.append(cd.cx.input.origin);
                        }
                        this.emitme.append("' namespace='");
                        this.emitme.append(cd.cframe.builder.classname.ns.name);
                        this.emitme.append("' access='");
                        this.emitme.append(this.getAccessKindFromNS(cd.cframe.builder.classname.ns));
                        if (idn != null) {
                            this.emitme.append("' baseClasses='");
                            if (idn.interfaces != null) {
                                values = idn.interfaces.values;
                                firstV = (Value)values.get(0);
                                for (i = 0; i < values.size(); ++i) {
                                    rv = (ReferenceValue)values.get(i);
                                    if (rv != firstV) {
                                        this.emitme.append(";");
                                    }
                                    this.emitme.append((s = rv.getSlot(CommentsTable.this.cx, -79)) == null || s.getDebugName().length() == 0 ? rv.name : s.getDebugName());
                                }
                            } else {
                                this.emitme.append("Object");
                            }
                            this.emitme.append("' ");
                        } else {
                            this.emitme.append("' baseclass='");
                            if (cd.baseref != null) {
                                Slot s2 = cd.baseref.getSlot(CommentsTable.this.cx, -79);
                                this.emitme.append(s2 == null || s2.getDebugName().length() == 0 ? "Object" : s2.getDebugName());
                            } else {
                                this.emitme.append("Object");
                            }
                            this.emitme.append("' ");
                            if (cd.interfaces != null) {
                                this.emitme.append("interfaces='");
                                values = cd.interfaces.values;
                                firstV = (Value)values.get(0);
                                for (i = 0; i < values.size(); ++i) {
                                    rv = (ReferenceValue)values.get(i);
                                    if (rv != firstV) {
                                        this.emitme.append(";");
                                    }
                                    this.emitme.append((s = rv.getSlot(CommentsTable.this.cx, -79)) == null || s.getDebugName().length() == 0 ? rv.name : s.getDebugName());
                                }
                                this.emitme.append("' ");
                            }
                        }
                        AttributeListNode attrs = cd.attrs;
                        if (attrs != null) {
                            this.emitme.append("isFinal='");
                            this.emitme.append(attrs.hasFinal ? "true" : "false");
                            this.emitme.append("' ");
                            this.emitme.append("isDynamic='");
                            this.emitme.append(attrs.hasDynamic ? "true" : "false");
                            this.emitme.append("' ");
                        } else {
                            this.emitme.append("isFinal='false' ");
                            this.emitme.append("isDynamic='false' ");
                        }
                        this.emitme.append(">");
                    }
                } else if (comment.def instanceof FunctionDefinitionNode) {
                    type = 3;
                    FunctionDefinitionNode fd = (FunctionDefinitionNode)comment.def;
                    int check1 = fd.fexpr.debug_name.indexOf("/get");
                    int check2 = fd.fexpr.debug_name.indexOf("/set");
                    if (check1 == fd.fexpr.debug_name.length() - 4) {
                        type = 4;
                    } else if (check2 == fd.fexpr.debug_name.length() - 4) {
                        type = 5;
                    }
                    name = fd.name.identifier.name;
                    debug_name = fd.fexpr.debug_name;
                    tagname = "method";
                    this.emitme.append("\n<method name='");
                    this.emitme.append(fd.name.identifier.name);
                    this.emitme.append("' fullname='");
                    this.emitme.append(fd.fexpr.debug_name);
                    this.emitme.append("' ");
                    AttributeListNode attrs = fd.attrs;
                    if (attrs != null) {
                        this.emitme.append("isStatic='");
                        this.emitme.append(attrs.hasStatic ? "true" : "false");
                        this.emitme.append("' ");
                        this.emitme.append("isFinal='");
                        this.emitme.append(attrs.hasFinal ? "true" : "false");
                        this.emitme.append("' ");
                        this.emitme.append("isOverride='");
                        this.emitme.append(attrs.hasOverride ? "true" : "false");
                        this.emitme.append("' ");
                    } else {
                        this.emitme.append("isStatic='false' ");
                        this.emitme.append("isFinal='false' ");
                        this.emitme.append("isOverride='false' ");
                    }
                    fd.fexpr.signature.toCanonicalString(CommentsTable.this.cx, this.emitme);
                    this.emitme.append(">");
                } else if (comment.def instanceof VariableDefinitionNode) {
                    type = 6;
                    VariableDefinitionNode vd = (VariableDefinitionNode)comment.def;
                    VariableBindingNode vb = (VariableBindingNode)vd.list.items.get(0);
                    name = vb.variable.identifier.name;
                    debug_name = vb.debug_name;
                    tagname = "field";
                    this.emitme.append("\n<");
                    this.emitme.append(tagname);
                    this.emitme.append(" name='");
                    this.emitme.append(vb.variable.identifier.name);
                    this.emitme.append("' fullname='");
                    this.emitme.append(vb.debug_name);
                    this.emitme.append("' type='");
                    if (vb.typeref != null) {
                        Slot s = vb.typeref.getSlot(CommentsTable.this.cx, -79);
                        this.emitme.append(s == null || s.getDebugName().length() == 0 ? vb.typeref.name : s.getDebugName());
                    }
                    this.emitme.append("' ");
                    AttributeListNode attrs = vd.attrs;
                    if (attrs != null) {
                        this.emitme.append("isStatic='");
                        this.emitme.append(attrs.hasStatic ? "true" : "false");
                        this.emitme.append("' ");
                    } else {
                        this.emitme.append("isStatic='false' ");
                    }
                    Slot s = vb.ref.getSlot(CommentsTable.this.cx);
                    if (s != null) {
                        this.emitme.append("isConst='");
                        this.emitme.append(s.isConst() ? "true" : "false");
                        this.emitme.append("' ");
                    }
                    if (vb.initializer != null) {
                        this.emitme.append("defaultValue='");
                        if (vb.initializer instanceof LiteralNumberNode) {
                            this.emitme.append(((LiteralNumberNode)vb.initializer).value);
                        } else if (vb.initializer instanceof LiteralStringNode) {
                            this.emitme.append(DocCommentNode.escapeXml(((LiteralStringNode)vb.initializer).value));
                        } else if (vb.initializer instanceof LiteralNullNode) {
                            this.emitme.append("null");
                        } else if (vb.initializer instanceof LiteralBooleanNode) {
                            this.emitme.append(((LiteralBooleanNode)vb.initializer).value ? "true" : "false");
                        } else if (vb.initializer instanceof MemberExpressionNode) {
                            MemberExpressionNode mb = (MemberExpressionNode)vb.initializer;
                            Slot vs = mb.ref != null ? mb.ref.getSlot(CommentsTable.this.cx, -79) : null;
                            Value v = vs != null ? vs.getValue() : null;
                            ObjectValue ov = v instanceof ObjectValue ? (ObjectValue)v : null;
                            this.emitme.append(ov != null ? ov.getValue() : "unknown");
                        } else {
                            Slot vs = vb.ref.getSlot(CommentsTable.this.cx, -79);
                            Value v = vs != null ? vs.getValue() : null;
                            ObjectValue ov = v instanceof ObjectValue ? (ObjectValue)v : null;
                            this.emitme.append(ov != null ? ov.getValue() : "unknown");
                        }
                        this.emitme.append("' ");
                    }
                    this.emitme.append(">");
                } else {
                    type = -1;
                    name = "Unsupported";
                }
                this.key = new KeyPair(name, type);
                if (this.key.type != -1) {
                    NamespaceDefinitionNode nd;
                    Value[] values;
                    this.inherit = this.hasInheritDoc();
                    if (!this.exclude && this.inherit) {
                        this.processInheritDoc();
                    }
                    if ((values = comment.values) != null) {
                        for (int i = 0; i < values.length; ++i) {
                            Value v = values[i];
                            if (v == null) continue;
                            if (v instanceof MetaDataEvaluator.KeylessValue) {
                                MetaDataEvaluator.KeylessValue ov = (MetaDataEvaluator.KeylessValue)v;
                                this.emitme.append(ov.obj);
                                continue;
                            }
                            if (!(v instanceof MetaDataEvaluator.KeyValuePair)) continue;
                            MetaDataEvaluator.KeyValuePair kv = (MetaDataEvaluator.KeyValuePair)v;
                            this.emitme.append("\n<").append(kv.key).append(">").append(kv.obj).append("</").append(kv.key).append(">");
                        }
                    } else if (this.id != null) {
                        this.emitme.append(this.id);
                    }
                    if (comment.def != null && comment.def.metaData != null) {
                        int numItems = comment.def.metaData.items.size();
                        for (int x = 0; x < numItems; ++x) {
                            MetaDataNode mdi;
                            Node md = comment.def.metaData.items.at(x);
                            MetaDataNode metaDataNode = mdi = md instanceof MetaDataNode ? (MetaDataNode)md : null;
                            if (mdi == null || mdi.id == null) continue;
                            if (mdi.id.equals("Style") || mdi.id.equals("Event") || mdi.id.equals("Effect")) {
                                if (x + 1 < numItems) {
                                    DocCommentNode metaDataComment;
                                    Node next = comment.def.metaData.items.at(x + 1);
                                    DocCommentNode docCommentNode = metaDataComment = next instanceof DocCommentNode ? (DocCommentNode)next : null;
                                    if (metaDataComment != null) {
                                        this.emitMetaDataComment(debug_name, mdi, false, metaDataComment);
                                        ++x;
                                        continue;
                                    }
                                    this.emitMetaDataComment(debug_name, mdi, true, null);
                                    continue;
                                }
                                this.emitMetaDataComment(debug_name, mdi, true, null);
                                continue;
                            }
                            if (!mdi.id.equals("Bindable") && !mdi.id.equals("Deprecated") && !mdi.id.equals("Exclude") && !mdi.id.equals("DefaultProperty")) continue;
                            this.emitMetaDataComment(debug_name, mdi, true, null);
                        }
                    }
                    if (!"".equals(tagname)) {
                        this.emitme.append("\n</");
                        this.emitme.append(tagname);
                        this.emitme.append(">");
                    } else if (comment.def instanceof NamespaceDefinitionNode && (nd = (NamespaceDefinitionNode)comment.def) != null) {
                        this.emitme.append("<!-- Namespace comments not supported yet: ").append(nd.debug_name).append("-->");
                    }
                }
            }

            private boolean hasInheritDoc() {
                int begin = -1;
                begin = this.id.indexOf("<inheritDoc><![CDATA[", this.id.indexOf("]]></description>"));
                return begin >= 0;
            }

            private String addToComment(String inheritDoc) {
                String TEMP1 = "<description><![CDATA[";
                String TEMP2 = "]]></description>";
                String TEMP3 = "<inheritDoc><![CDATA[";
                String TEMP4 = "]]></inheritDoc>";
                int is = inheritDoc.indexOf(TEMP1) + TEMP1.length();
                int ie = inheritDoc.indexOf(TEMP2);
                int splice = this.id.indexOf(TEMP2);
                int temp4 = this.id.indexOf(TEMP4);
                int endCDATABeforeInherit = this.id.substring(0, temp4).lastIndexOf("]]>");
                int begin = this.id.indexOf(TEMP3, endCDATABeforeInherit);
                int end = temp4 + TEMP4.length();
                String result = this.id.substring(0, splice) + inheritDoc.substring(is, ie) + this.id.substring(splice, begin) + this.id.substring(end);
                if (this.key.type == 3) {
                    int endret2;
                    String TEMP5 = "<return><![CDATA[";
                    String TEMP6 = "]]></return>";
                    int endret = this.id.indexOf(TEMP5);
                    if (endret < 0 && (endret2 = inheritDoc.indexOf(TEMP6)) > 0) {
                        int endCDATABeforeReturn = inheritDoc.substring(0, endret2).lastIndexOf("]]>");
                        begin = inheritDoc.indexOf(TEMP5, endCDATABeforeReturn);
                        result = result + inheritDoc.substring(begin, endret2 + TEMP6.length());
                    }
                    String TEMP7 = "<param><![CDATA[";
                    String TEMP8 = "]]></param>";
                    int count1 = 0;
                    int count2 = 0;
                    int index = this.id.indexOf(TEMP8);
                    while (index >= 0) {
                        ++count1;
                        index = this.id.indexOf(TEMP8, index + 1);
                    }
                    index = inheritDoc.indexOf(TEMP8);
                    while (index >= 0) {
                        ++count2;
                        index = inheritDoc.indexOf(TEMP8, index + 1);
                    }
                    index = 0;
                    if (count2 - count1 > 0) {
                        for (int j = 0; j < count1; ++j) {
                            index = inheritDoc.indexOf(TEMP8, index + 1);
                        }
                        for (int i = 0; i < count2 - count1; ++i) {
                            index = inheritDoc.indexOf(TEMP8, index + 1);
                            int endCDATABeforeParam = inheritDoc.substring(0, index).lastIndexOf("]]>");
                            int newindex = inheritDoc.indexOf(TEMP7, endCDATABeforeParam);
                            result = result + inheritDoc.substring(newindex, inheritDoc.indexOf(TEMP8, newindex) + TEMP8.length());
                        }
                    }
                }
                return result;
            }

            private void processInheritDoc() {
                String inheritDoc = CommentsTable.this.findInheritDoc(this.key);
                if (inheritDoc != null) {
                    this.id = this.addToComment(inheritDoc);
                } else if (Trace.asdoc) {
                    System.out.println("Cannot find inherited documentation for: " + this.key.name);
                }
            }

            public String getValue() {
                String inheritDoc;
                if (this.inherit && this.exclude && (inheritDoc = CommentsTable.this.findInheritDoc(this.key)) != null) {
                    return this.addToComment(inheritDoc);
                }
                return this.id;
            }

            public StringBuffer emit(StringBuffer sb) {
                return sb.append(this.emitme);
            }
        }

        private class KeyPair
        implements Comparable {
            public String name;
            public int type;

            public KeyPair(String name, int type) {
                this.name = name;
                this.type = type;
            }

            public int compareTo(Object key) {
                return (new Integer(this.type).toString() + this.name).compareTo(new Integer(((KeyPair)key).type).toString() + ((KeyPair)key).name);
            }
        }
    }
}

