/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.FileUtils;
import flex2.compiler.asdoc.PackagesConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationException;
import flex2.compiler.config.AdvancedConfigurationInfo;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.tools.ToolsConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ASDocConfiguration
extends ToolsConfiguration {
    private PackagesConfiguration packagesConfig = new PackagesConfiguration();
    private List classes = new LinkedList();
    private List namespaces = new LinkedList();
    private List sources = new LinkedList();
    private String examplesPath;
    private List excludeClasses = new LinkedList();
    private boolean excludeDependencies;
    private String footer;
    private boolean keepXML;
    private int leftFramesetWidth;
    private String mainTitle;
    private String output;
    private boolean skipXSL;
    private String templatesPath;
    private String windowTitle;
    private boolean includeLookupOnly = false;

    public static Map getAliases() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("o", "output");
        map.put("dc", "doc-classes");
        map.put("dn", "doc-namespaces");
        map.put("ds", "doc-sources");
        map.putAll(Configuration.getAliases());
        return map;
    }

    public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        File templatesPathFile;
        super.validate(cfgbuf);
        String appHome = cfgbuf.getToken("flexlib");
        if (this.templatesPath != null) {
            templatesPathFile = new File(this.templatesPath);
        } else {
            templatesPathFile = new File(appHome, "asdoc" + File.separator + "templates");
            if (!templatesPathFile.isDirectory()) {
                templatesPathFile = new File(appHome, ".." + File.separator + "asdoc" + File.separator + "templates");
            }
        }
        if (!templatesPathFile.isDirectory()) {
            throw new ConfigurationException.NotDirectory(this.templatesPath, null, null, -1);
        }
        this.templatesPath = this.getFileStr(templatesPathFile);
        File outputFile = this.output != null ? new File(this.output) : new File(appHome, "asdoc-output");
        outputFile.mkdirs();
        if (outputFile.exists() && !outputFile.isDirectory()) {
            throw new ConfigurationException.NotDirectory(this.output, null, null, -1);
        }
        this.output = this.getFileStr(outputFile);
        if (this.getDocSources().isEmpty() && this.getClasses().isEmpty() && this.getNamespaces().isEmpty()) {
            throw new ConfigurationException.NoASDocInputs();
        }
        if (!this.getDocSources().isEmpty() && this.excludeDependencies) {
            throw new ConfigurationException.BadExcludeDependencies();
        }
    }

    private String getFileStr(File file) {
        String str = file.getAbsolutePath();
        if (!str.endsWith(File.separator)) {
            str = str + File.separator;
        }
        return str;
    }

    public List getClasses() {
        return this.classes;
    }

    public void cfgDocClasses(ConfigurationValue cv, List args) throws ConfigurationException {
        this.classes.addAll(args);
    }

    public static ConfigurationInfo getDocClassesInfo() {
        return new ConfigurationInfo(-1, new String[]{"class"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public List getNamespaces() {
        return this.namespaces;
    }

    public void cfgDocNamespaces(ConfigurationValue val, List DocNamespaces) {
        this.namespaces.addAll(DocNamespaces);
    }

    public static ConfigurationInfo getDocNamespacesInfo() {
        return new ConfigurationInfo(-1, new String[]{"uri"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public List getDocSources() {
        return this.sources;
    }

    public void cfgDocSources(ConfigurationValue cv, List args) throws ConfigurationException {
        this.sources.addAll(args);
    }

    public static ConfigurationInfo getDocSourcesInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    public String getExamplesPath() {
        return this.examplesPath;
    }

    public void cfgExamplesPath(ConfigurationValue cv, String str) throws ConfigurationException {
        File file = new File(str);
        if (!file.isDirectory()) {
            throw new ConfigurationException.NotDirectory(str, cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.examplesPath = file.getAbsolutePath().replace('\\', '/');
    }

    public static ConfigurationInfo getExamplesPathInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public List getExcludeClasses() {
        return this.excludeClasses;
    }

    public void cfgExcludeClasses(ConfigurationValue cv, List args) throws ConfigurationException {
        this.excludeClasses.addAll(args);
    }

    public static ConfigurationInfo getExcludeClassesInfo() {
        return new ConfigurationInfo(-1, new String[]{"class"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public boolean excludeDependencies() {
        return this.excludeDependencies;
    }

    public void cfgExcludeDependencies(ConfigurationValue val, boolean bool) {
        this.excludeDependencies = bool;
    }

    public String getFooter() {
        return this.footer;
    }

    public void cfgFooter(ConfigurationValue cv, String str) throws ConfigurationException {
        this.footer = str;
    }

    public void cfgHelp(ConfigurationValue cv, String[] keywords) {
    }

    public static ConfigurationInfo getHelpInfo() {
        return new ConfigurationInfo(-1, "keyword"){

            public boolean isGreedy() {
                return true;
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public boolean keepXml() {
        return this.keepXML;
    }

    public void cfgKeepXml(ConfigurationValue cv, boolean b) throws ConfigurationException {
        this.keepXML = b;
    }

    public static ConfigurationInfo getKeepXmlInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public int getLeftFramesetWidth() {
        return this.leftFramesetWidth;
    }

    public void cfgLeftFramesetWidth(ConfigurationValue val, int left) {
        this.leftFramesetWidth = left;
    }

    public void cfgLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
    }

    public static ConfigurationInfo getLoadConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public String getMainTitle() {
        return this.mainTitle;
    }

    public void cfgMainTitle(ConfigurationValue cv, String str) throws ConfigurationException {
        this.mainTitle = str;
    }

    public String getOutput() {
        return this.output;
    }

    public void cfgOutput(ConfigurationValue val, String str) throws ConfigurationException {
        this.output = str != null && (str.startsWith(File.separator) || str.startsWith("/") || FileUtils.isAbsolute((File)new File(str))) ? str : (val.getContext() != null ? FileUtils.addPathComponents((String)val.getContext(), (String)str, (char)File.separatorChar) : str);
    }

    public static ConfigurationInfo getOutputInfo() {
        return new ConfigurationInfo(1, "filename"){};
    }

    public PackagesConfiguration getPackagesConfiguration() {
        return this.packagesConfig;
    }

    public boolean skipXsl() {
        return this.skipXSL;
    }

    public void cfgSkipXsl(ConfigurationValue cv, boolean b) throws ConfigurationException {
        this.skipXSL = b;
    }

    public static ConfigurationInfo getSkipXslInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void cfgTemplatesPath(ConfigurationValue val, String basedir) throws ConfigurationException {
        this.templatesPath = basedir;
    }

    public void cfgVersion(ConfigurationValue cv, boolean dummy) {
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void cfgWindowTitle(ConfigurationValue cv, String str) throws ConfigurationException {
        this.windowTitle = str;
    }

    public boolean getIncludeLookupOnly() {
        return this.includeLookupOnly;
    }

    public void cfgIncludeLookupOnly(ConfigurationValue val, boolean includeLookupOnly) {
        this.includeLookupOnly = includeLookupOnly;
    }

    public static ConfigurationInfo getIncludeLookupOnlyInfo() {
        return new AdvancedConfigurationInfo();
    }
}

