/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.Source;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.QName;
import flex2.tools.ToolsConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SwcChecksums {
    int[] checksums;
    private Map swcDefSignatureChecksums = new HashMap();
    private Map swcFileChecksums = new HashMap();
    private Map archiveFileChecksums = new HashMap();
    private CompilerSwcContext swcContext;
    private ConfigurationBuffer cfgbuf;
    private boolean isSwcChecksumEnabled;

    protected SwcChecksums(CompilerSwcContext swcContext, ConfigurationBuffer cfgbuf, ToolsConfiguration configuration) {
        this.swcContext = swcContext;
        this.cfgbuf = cfgbuf;
        this.isSwcChecksumEnabled = configuration.isSwcChecksumEnabled();
        this.checksums = new int[4];
        this.checksums[0] = 0;
        this.checksums[1] = cfgbuf.checksum_ts();
        this.checksums[2] = cfgbuf.link_checksum_ts();
        this.checksums[3] = swcContext.checksum();
    }

    protected void saveSignatureChecksums(List units) {
        if (!this.isSwcChecksumEnabled) {
            this.swcDefSignatureChecksums = null;
            return;
        }
        if (units != null) {
            this.swcDefSignatureChecksums = new HashMap();
            Iterator iter = units.iterator();
            while (iter.hasNext()) {
                CompilationUnit unit = (CompilationUnit)iter.next();
                Source source = unit == null ? null : unit.getSource();
                if (source == null || !source.isSwcScriptOwner() || source.isInternal()) continue;
                this.addSignatureChecksumToData(unit);
            }
        }
    }

    protected void saveSwcFileChecksums() {
        if (!this.isSwcChecksumEnabled) {
            this.swcFileChecksums = null;
            return;
        }
        Iterator iter = this.swcContext.getFiles().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String filename = (String)entry.getKey();
            VirtualFile file = (VirtualFile)entry.getValue();
            this.swcFileChecksums.put(filename, new Long(file.getLastModified()));
        }
    }

    protected void saveArchiveFilesChecksums(Map m) {
        if (!this.isSwcChecksumEnabled) {
            this.swcFileChecksums = null;
            return;
        }
        Iterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            VirtualFile file = (VirtualFile)entry.getValue();
            this.archiveFileChecksums.put(file.getName(), new Long(file.getLastModified()));
        }
    }

    protected void saveChecksums(List units) {
        this.saveSwcFileChecksums();
        this.saveSignatureChecksums(units);
        this.updateChecksum();
    }

    protected boolean isRecompilationNeeded(int[] loadedChecksums) {
        boolean result;
        this.checksums[0] = this.calculateChecksum();
        if (this.checksums[0] != loadedChecksums[0]) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: calculated checksum differs from last checksum, recompile");
            }
            return true;
        }
        if (!this.isSwcChecksumEnabled) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: checksums equal, swc-checksum disabled, incremental compile");
            }
            return false;
        }
        Map signatureChecksums = this.swcDefSignatureChecksums;
        if (signatureChecksums == null) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: checksums equal, signatureChecksums is null, incremental compile");
            }
        } else {
            Iterator iter = signatureChecksums.entrySet().iterator();
            while (iter.hasNext()) {
                Source source;
                Map.Entry entry = iter.next();
                QName qName = (QName)entry.getKey();
                Long dataSignatureChecksum = (Long)entry.getValue();
                Long swcSignatureChecksum = this.swcContext.getChecksum(qName);
                if (swcSignatureChecksum == null && qName != null && (source = this.swcContext.getSource(qName.getNamespace(), qName.getLocalPart())) != null) {
                    swcSignatureChecksum = new Long(source.getLastModified());
                }
                if (Trace.swcChecksum && dataSignatureChecksum == null) {
                    throw new IllegalStateException("dataSignatureChecksum should never be null");
                }
                if (dataSignatureChecksum != null && swcSignatureChecksum == null) {
                    if (Trace.swcChecksum) {
                        Trace.trace((String)"isRecompilationNeeded: signature checksums not equal, recompile");
                        Trace.trace((String)("compare " + entry.getKey()));
                        Trace.trace((String)("data =  " + dataSignatureChecksum));
                        Trace.trace((String)("swc  =  " + swcSignatureChecksum));
                    }
                    return true;
                }
                if (dataSignatureChecksum != null) {
                    if (dataSignatureChecksum.longValue() == swcSignatureChecksum.longValue()) continue;
                    if (Trace.swcChecksum) {
                        Trace.trace((String)"isRecompilationNeeded: signature checksums not equal, recompile");
                        Trace.trace((String)("compare " + entry.getKey()));
                        Trace.trace((String)("data =  " + dataSignatureChecksum));
                        Trace.trace((String)("swc  =  " + swcSignatureChecksum));
                    }
                    return true;
                }
                return true;
            }
        }
        boolean bl = result = !this.areSwcFileChecksumsEqual();
        if (Trace.swcChecksum) {
            Trace.trace((String)("isRecompilationNeeded: " + (result ? "recompile" : "incremental compile")));
        }
        return result;
    }

    protected boolean isRelinkNeeded(int[] loadedChecksums) {
        boolean result;
        if (this.checksums[2] != loadedChecksums[2]) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: calculated checksum differs from last checksum, relink");
            }
            return true;
        }
        boolean bl = result = !this.areArchiveFileChecksumsEqual();
        if (Trace.swcChecksum) {
            Trace.trace((String)("isRelinkNeeded: " + result));
        }
        return result;
    }

    private void addSignatureChecksumToData(CompilationUnit unit) {
        Long signatureChecksum = unit.getSignatureChecksum();
        if (signatureChecksum == null) {
            SwcScript script = (SwcScript)unit.getSource().getOwner();
            signatureChecksum = new Long(script.getLastModified());
        }
        if (this.swcDefSignatureChecksums != null) {
            Iterator iter = unit.topLevelDefinitions.iterator();
            while (iter.hasNext()) {
                QName qname = (QName)iter.next();
                this.swcDefSignatureChecksums.put(qname, signatureChecksum);
            }
        }
    }

    private boolean areSwcFileChecksumsEqual() {
        if (this.swcFileChecksums == null) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"areSwcFileChecksumsEqual: no file checksum map, not equal");
            }
            return false;
        }
        Map swcFiles = this.swcContext.getFiles();
        Set dataSet = this.swcFileChecksums.entrySet();
        if (swcFiles.size() < dataSet.size()) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"areSwcFileChecksumsEqual: less files than before, not equal");
            }
            return false;
        }
        Iterator iter = dataSet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String filename = (String)entry.getKey();
            Long dataFileLastModified = (Long)entry.getValue();
            Long swcFileLastModified = null;
            VirtualFile swcFile = (VirtualFile)swcFiles.get(filename);
            if (swcFile != null) {
                swcFileLastModified = new Long(swcFile.getLastModified());
            }
            if (dataFileLastModified.equals(swcFileLastModified)) continue;
            if (Trace.swcChecksum) {
                Trace.trace((String)"areSwcFileChecksumsEqual: not equal");
                Trace.trace((String)("filename = " + filename));
                Trace.trace((String)("last modified1 = " + dataFileLastModified));
                Trace.trace((String)("last modified2 = " + swcFileLastModified));
            }
            return false;
        }
        if (Trace.swcChecksum) {
            Trace.trace((String)"areSwcFileChecksumsEqual: equal");
        }
        return true;
    }

    private boolean areArchiveFileChecksumsEqual() {
        if (this.swcFileChecksums == null) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"areArchiveFileChecksumsEqual: no file checksum map, not equal");
            }
            return false;
        }
        Set dataSet = this.archiveFileChecksums.entrySet();
        Iterator iter = dataSet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String filename = (String)entry.getKey();
            Long dataFileLastModified = (Long)entry.getValue();
            Long localFileLastModified = null;
            LocalFile localFile = new LocalFile(new File(filename));
            localFileLastModified = new Long(localFile.getLastModified());
            if (dataFileLastModified.equals(localFileLastModified)) continue;
            Trace.trace((String)"areArchiveFileChecksumsEqual: not equal");
            Trace.trace((String)("filename = " + filename));
            Trace.trace((String)("last modified1 = " + dataFileLastModified));
            Trace.trace((String)("last modified2 = " + localFileLastModified));
            return false;
        }
        if (Trace.swcChecksum) {
            Trace.trace((String)"areArchiveFileChecksumsEqual: equal");
        }
        return true;
    }

    protected int calculateChecksum() {
        int checksum = this.cfgbuf.checksum_ts();
        if (!this.isSwcChecksumEnabled || this.swcDefSignatureChecksums == null || this.swcDefSignatureChecksums.size() == 0) {
            checksum += this.swcContext.checksum();
        }
        return checksum;
    }

    protected void updateChecksum() {
        this.checksums[0] = this.calculateChecksum();
    }

    protected int[] copy() {
        int[] copy = (int[])this.checksums.clone();
        return copy;
    }

    protected int[] getChecksums() {
        return this.checksums;
    }

    protected Map getSwcDefSignatureChecksums() {
        return this.swcDefSignatureChecksums;
    }

    protected Map getSwcFileChecksums() {
        return this.swcFileChecksums;
    }

    protected Map getArchiveFileChecksums() {
        return this.archiveFileChecksums;
    }
}

