/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.Trace;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.LicensesConfiguration;
import java.lang.reflect.Method;
import java.util.Iterator;

public class ToolsConfiguration
extends Configuration {
    private LicensesConfiguration licenses = new LicensesConfiguration();
    private VirtualFile licenseFile;
    private boolean warnings = true;

    public LicensesConfiguration getLicensesConfiguration() {
        return this.licenses;
    }

    public VirtualFile getLicenseFile() {
        return this.licenseFile;
    }

    private void processDeprecatedOptions(ConfigurationBuffer configurationBuffer) {
        Iterator i = configurationBuffer.getVarIterator();
        while (i.hasNext()) {
            String var = (String)i.next();
            ConfigurationInfo info = configurationBuffer.getInfo(var);
            if (!info.isDeprecated() || configurationBuffer.getVar(var) == null) continue;
            CompilerMessage.CompilerWarning warning = info.getDeprecatedMessage();
            String replacement = info.getDeprecatedReplacement();
            String since = info.getDeprecatedSince();
            if (warning != null) {
                ThreadLocalToolkit.log(warning);
                continue;
            }
            ThreadLocalToolkit.log(new DeprecatedConfigurationOption(var, replacement, since));
        }
    }

    public void validate(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        CompilerConfiguration compConfig;
        this.processDeprecatedOptions(configurationBuffer);
        try {
            Class<?> oemLicenseServiceClass = Class.forName("flex.license.OEMLicenseService");
            Method method = oemLicenseServiceClass.getMethod("getLicenseFilename", null);
            String licenseFileName = (String)method.invoke(null, null);
            this.licenseFile = this.configResolver.resolve(licenseFileName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Trace.license) {
            String file = this.licenseFile != null ? this.licenseFile.getName() : "";
            Trace.trace((String)("ToolsConfiguration.validate: licenseFile = '" + file + "'"));
        }
        boolean strict = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.strict"));
        boolean as3 = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.as3"));
        boolean es = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.es"));
        if (as3 && es || !as3 && !es) {
            throw new BadAS3ESCombination(as3, es);
        }
        if (strict && es) {
            ThreadLocalToolkit.log(new BadESStrictCombination(es, strict));
        }
        if ((compConfig = this.getCompilerConfiguration()).getKeepGeneratedSignatures() && compConfig.getSignatureDirectory() == null) {
            compConfig.setSignatureDirectory(null);
        }
    }

    public boolean getWarnings() {
        return this.warnings;
    }

    public void cfgWarnings(ConfigurationValue cv, boolean b) {
        this.warnings = b;
    }

    public static ConfigurationInfo getWarningsInfo() {
        return new ConfigurationInfo();
    }

    public static class BadESStrictCombination
    extends ConfigurationException {
        public final boolean es;
        public final boolean strict;

        public BadESStrictCombination(boolean es, boolean strict) {
            super("");
            this.es = es;
            this.strict = strict;
        }

        public String getLevel() {
            return "warning";
        }
    }

    public static class BadAS3ESCombination
    extends ConfigurationException {
        public final boolean as3;
        public final boolean es;

        public BadAS3ESCombination(boolean as3, boolean es) {
            super("");
            this.as3 = as3;
            this.es = es;
        }
    }

    public static class DeprecatedConfigurationOption
    extends CompilerMessage.CompilerWarning {
        public final String var;
        public final String replacement;
        public final String since;

        public DeprecatedConfigurationOption(String var, String replacement, String since) {
            this.var = var;
            this.replacement = replacement;
            this.since = since;
        }
    }
}

