////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2005-2006 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package mx.controls.sliderClasses
{

/**
 *  The SliderDirection class defines the constant values
 *  for the <code>direction</code> property of the Slider class.
 *
 *  @see mx.controls.sliderClasses.Slider
 */
public final class SliderDirection
{
	include "../../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Class constants
	//
	//--------------------------------------------------------------------------

	/**
	 *  Specifies to display a horizontal slider.
	 *  The HSlider control uses this constant.
	 */
	public static const HORIZONTAL:String = "horizontal";
	
	/**
	 *  Specifies to display a vertical slider.
	 *  The VSlider control uses this constant.
	 */
	public static const VERTICAL:String = "vertical";
}

}
