/*
 * Decompiled with CFR 0.152.
 */
package flex.ant;

import flex.ant.config.BaseConfigVariable;
import flex.ant.config.ConfigVariable;
import flex.ant.config.NestedAttributeElement;
import flex.ant.config.OptionSpec;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public abstract class FlexTask
extends Java {
    protected final String toolName;
    private final String toolClassName;
    private final String jarFileName;
    protected final Commandline cmdl;
    protected final ConfigVariable[] variables;
    protected List nestedAttribs;
    protected boolean fork;
    private String maxmemory;
    private ClassLoader originalContextClassLoader;
    protected static OptionSpec rslpSpec = new OptionSpec(null, "runtime-shared-library-path", "rslp");

    protected FlexTask(String toolName, String toolClassName, String jarFileName, ConfigVariable[] vars) {
        this.toolName = toolName;
        this.toolClassName = toolClassName;
        this.jarFileName = jarFileName;
        this.variables = vars;
        this.cmdl = new Commandline();
    }

    public Object createDynamicElement(String elementName) {
        BaseConfigVariable var = null;
        for (int i = 0; i < this.variables.length && var == null; ++i) {
            if (!this.variables[i].matches(elementName)) continue;
            var = this.variables[i];
        }
        if (var != null) {
            return this.createElem(elementName, var.getSpec());
        }
        throw new BuildException("The <" + this.toolName + "> type doesn't support the \"" + elementName + "\" nested element.", this.getLocation());
    }

    protected NestedAttributeElement createElem(String attrib, OptionSpec spec) {
        NestedAttributeElement e = new NestedAttributeElement(attrib, spec);
        this.nestedAttribs.add(e);
        return e;
    }

    protected NestedAttributeElement createElem(String[] attribs, OptionSpec spec) {
        NestedAttributeElement e = new NestedAttributeElement(attribs, spec);
        this.nestedAttribs.add(e);
        return e;
    }

    public void setFork(boolean f) {
        super.setFork(f);
        this.fork = f;
    }

    public void setMaxmemory(String max) {
        super.setMaxmemory(max);
        this.maxmemory = max;
    }

    public void setDynamicAttribute(String attributeName, String value) {
        ConfigVariable var = null;
        for (int i = 0; i < this.variables.length && var == null; ++i) {
            if (!this.variables[i].matches(attributeName)) continue;
            var = this.variables[i];
        }
        if (var == null) {
            throw new BuildException("The <" + this.toolName + "> type doesn't support the \"" + attributeName + "\" attribute.", this.getLocation());
        }
        var.set(value);
    }

    protected abstract void prepareCommandline() throws BuildException;

    public final void execute() throws BuildException {
        String flexHomeProperty = this.getProject().getProperty("FLEX_HOME");
        if (flexHomeProperty == null) {
            throw new BuildException("FLEX_HOME must be set to use the Flex Ant Tasks");
        }
        System.setProperty("FLEX_HOME", flexHomeProperty);
        this.cmdl.createArgument().setValue("+flexlib=" + flexHomeProperty + "/frameworks");
        this.prepareCommandline();
        if (this.fork) {
            this.executeOutOfProcess();
        } else {
            this.executeInProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOutOfProcess() throws BuildException {
        try {
            Class toolClass = this.resolveClass(this.toolClassName);
            super.setClassname(this.toolClassName);
            super.createArg().setLine(Commandline.toString((String[])this.cmdl.getArguments()));
            int err = super.executeJava();
            if (err > 0) {
                throw new BuildException(this.toolName + " task failed.");
            }
        }
        finally {
            if (this.originalContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.originalContextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInProcess() throws BuildException {
        try {
            Class toolClass = this.resolveClass(this.toolClassName);
            Class threadLocalToolkitClass = this.resolveClass("flex2.compiler.util.ThreadLocalToolkit");
            this.log("FlexTask.execute: " + this.cmdl, 4);
            int errorCount = 0;
            try {
                Method toolMethod = toolClass.getMethod(this.toolName, String[].class);
                toolMethod.invoke(null, new Object[]{this.cmdl.getArguments()});
                Method errorCountMethod = threadLocalToolkitClass.getMethod("errorCount", null);
                errorCount = (Integer)errorCountMethod.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                this.log(stringWriter.toString(), 4);
                throw new BuildException("Unable to run " + this.toolName + ": " + e.getMessage(), (Throwable)e);
            }
            if (errorCount > 0) {
                throw new BuildException(this.toolName + " task failed");
            }
        }
        finally {
            if (this.originalContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.originalContextClassLoader);
            }
        }
    }

    private Class resolveClass(String className) {
        Class<?> result;
        block9: {
            result = null;
            try {
                result = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ignoredClassNotFoundException) {
                String flexHomeProperty = this.getProject().getProperty("FLEX_HOME");
                if (flexHomeProperty != null) {
                    File flexHome = new File(flexHomeProperty);
                    if (flexHome.exists()) {
                        File jarFile = new File(flexHome + "/lib", this.jarFileName);
                        if (jarFile.exists()) {
                            try {
                                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{jarFile.toURL()});
                                result = Class.forName(className, true, urlClassLoader);
                                this.originalContextClassLoader = Thread.currentThread().getContextClassLoader();
                                Thread.currentThread().setContextClassLoader(urlClassLoader);
                                if (this.fork) {
                                    super.setClasspath(new Path(this.getProject(), jarFile.getAbsolutePath()));
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                malformedURLException.printStackTrace();
                                break block9;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new BuildException("The class not found in jar file: " + this.jarFileName, this.getLocation());
                            }
                        }
                        throw new BuildException("File does not exist: " + this.jarFileName, this.getLocation());
                    }
                    throw new BuildException("FLEX_HOME does not exist.", this.getLocation());
                }
                throw new BuildException("The class, " + className + ", must be in the classpath or the FLEX_HOME property must be set.", this.getLocation());
            }
        }
        return result;
    }
}

