/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.QName;

public class XMLAttributesMMImpl
extends XMLAttributesImpl {
    public XMLAttributesMMImpl() {
        this.fAttributes = new AttributeMMImpl[4];
        for (int i = 0; i < this.fAttributes.length; ++i) {
            this.fAttributes[i] = new AttributeMMImpl();
        }
    }

    public XMLAttributesMMImpl(int tableSize) {
        this.fTableViewBuckets = tableSize;
        for (int i = 0; i < this.fAttributes.length; ++i) {
            this.fAttributes[i] = new AttributeMMImpl();
        }
    }

    public int addAttribute(QName name, String type, String value) {
        int index;
        if (this.fLength < 20) {
            int n = index = name.uri != null && !name.uri.equals("") ? this.getIndexFast(name.uri, name.localpart) : this.getIndexFast(name.rawname);
            if (index == -1) {
                index = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    AttributeMMImpl[] attributes = new AttributeMMImpl[this.fAttributes.length + 4];
                    System.arraycopy(this.fAttributes, 0, attributes, 0, this.fAttributes.length);
                    for (int i = this.fAttributes.length; i < attributes.length; ++i) {
                        attributes[i] = new AttributeMMImpl();
                    }
                    this.fAttributes = attributes;
                }
            }
        } else if (name.uri == null || name.uri.length() == 0 || (index = this.getIndexFast(name.uri, name.localpart)) == -1) {
            int bucket;
            if (!this.fIsTableViewConsistent || this.fLength == 20) {
                this.prepareAndPopulateTableView();
                this.fIsTableViewConsistent = true;
            }
            if (this.fAttributeTableViewChainState[bucket = this.getTableViewBucket(name.rawname)] != this.fLargeCount) {
                index = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    AttributeMMImpl[] attributes = new AttributeMMImpl[this.fAttributes.length << 1];
                    System.arraycopy(this.fAttributes, 0, attributes, 0, this.fAttributes.length);
                    for (int i = this.fAttributes.length; i < attributes.length; ++i) {
                        attributes[i] = new AttributeMMImpl();
                    }
                    this.fAttributes = attributes;
                }
                this.fAttributeTableViewChainState[bucket] = this.fLargeCount;
                this.fAttributes[index].next = null;
                this.fAttributeTableView[bucket] = this.fAttributes[index];
            } else {
                XMLAttributesImpl.Attribute found = this.fAttributeTableView[bucket];
                while (found != null && found.name.rawname != name.rawname) {
                    found = found.next;
                }
                if (found == null) {
                    index = this.fLength;
                    if (this.fLength++ == this.fAttributes.length) {
                        AttributeMMImpl[] attributes = new AttributeMMImpl[this.fAttributes.length << 1];
                        System.arraycopy(this.fAttributes, 0, attributes, 0, this.fAttributes.length);
                        for (int i = this.fAttributes.length; i < attributes.length; ++i) {
                            attributes[i] = new AttributeMMImpl();
                        }
                        this.fAttributes = attributes;
                    }
                    this.fAttributes[index].next = this.fAttributeTableView[bucket];
                    this.fAttributeTableView[bucket] = this.fAttributes[index];
                } else {
                    index = this.getIndexFast(name.rawname);
                }
            }
        }
        XMLAttributesImpl.Attribute attribute = this.fAttributes[index];
        attribute.name.setValues(name);
        attribute.type = type;
        attribute.value = value;
        attribute.nonNormalizedValue = value;
        attribute.specified = false;
        attribute.augs.removeAllItems();
        return index;
    }

    public void setLineNumber(int index, int lineno) {
        if (index < 0 || index >= this.fLength) {
            return;
        }
        if (!(this.fAttributes[index] instanceof AttributeMMImpl)) {
            return;
        }
        ((AttributeMMImpl)this.fAttributes[index]).lineno = lineno;
    }

    public int getLineNumber(int index) {
        if (index < 0 || index >= this.fLength) {
            return -1;
        }
        if (!(this.fAttributes[index] instanceof AttributeMMImpl)) {
            return -1;
        }
        return ((AttributeMMImpl)this.fAttributes[index]).lineno;
    }

    static class AttributeMMImpl
    extends XMLAttributesImpl.Attribute {
        public int lineno;

        AttributeMMImpl() {
        }
    }
}

