/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.LicenseException;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.FontsConfiguration;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.extensions.ExtensionManager;
import flex2.compiler.extensions.IApplicationExtension;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.PerformanceData;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.ConsoleApplication;
import flex2.linker.FlexMovie;
import flex2.linker.LinkerAPI;
import flex2.linker.LinkerException;
import flex2.linker.SimpleMovie;
import flex2.tools.Mxmlc;
import flex2.tools.PostLink;
import flex2.tools.PreLink;
import flex2.tools.ToolsConfiguration;
import flex2.tools.WebTierAPI;
import flex2.tools.oem.Builder;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.LibraryCache;
import flex2.tools.oem.Logger;
import flex2.tools.oem.Message;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.ProgressMeter;
import flex2.tools.oem.Report;
import flex2.tools.oem.VirtualLocalFile;
import flex2.tools.oem.internal.ApplicationCompilerConfiguration;
import flex2.tools.oem.internal.ApplicationData;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMReport;
import flex2.tools.oem.internal.OEMUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ContextStatics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements Builder {
    private List<VirtualFile> files;
    private OEMConfiguration oemConfiguration;
    private Logger logger;
    private File output;
    private MimeMappings mimeMappings;
    private ProgressMeter meter;
    protected PathResolver resolver;
    private CompilerControl cc;
    private LibraryCache librarySwcCache;
    private boolean isGeneratedTargetFile;
    private ApplicationData data;
    private String cacheName;
    private String configurationReport;
    private List<Message> messages;
    private HashMap<String, PerformanceData[]> compilerBenchmarks;
    private Benchmark benchmark;

    public Application(File file) throws FileNotFoundException {
        this(file, null);
    }

    public Application(File file, LibraryCache cache) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(FileUtil.getCanonicalPath(file));
        }
        this.init(new VirtualFile[]{new LocalFile(FileUtil.getCanonicalFile(file))});
        this.librarySwcCache = cache;
    }

    public Application(VirtualLocalFile file) {
        this.init(new VirtualFile[]{file});
    }

    public Application(VirtualLocalFile[] files) {
        this.init(files);
    }

    public Application() {
        this.init(new VirtualFile[0]);
    }

    private void init(VirtualFile[] files) {
        this.files = new ArrayList<VirtualFile>(files.length);
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            this.files.add(files[i]);
        }
        this.oemConfiguration = null;
        this.logger = null;
        this.output = null;
        this.mimeMappings = new MimeMappings();
        this.meter = null;
        this.resolver = null;
        this.cc = new CompilerControl();
        this.isGeneratedTargetFile = false;
        this.data = null;
        this.cacheName = null;
        this.configurationReport = null;
        this.messages = new ArrayList<Message>();
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.oemConfiguration = (OEMConfiguration)configuration;
    }

    @Override
    public Configuration getDefaultConfiguration() {
        return this.getDefaultConfiguration(false);
    }

    private Configuration getDefaultConfiguration(boolean processDefaults) {
        return OEMUtil.getApplicationConfiguration(this.constructCommandLine(null), false, OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings, processDefaults);
    }

    @Override
    public Map<String, PerformanceData[]> getCompilerBenchmarks() {
        return this.compilerBenchmarks;
    }

    @Override
    public Benchmark getBenchmark() {
        return this.benchmark;
    }

    @Override
    public Configuration getConfiguration() {
        return this.oemConfiguration;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public File getOutput() {
        return this.output;
    }

    @Override
    public void setSupportedFileExtensions(String mimeType, String[] extensions) {
        this.mimeMappings.set(mimeType, extensions);
    }

    @Override
    public void setProgressMeter(ProgressMeter meter) {
        this.meter = meter;
    }

    @Override
    public void setPathResolver(PathResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public long build(boolean incremental) throws IOException {
        if (this.output != null) {
            Exception ex222222;
            long l;
            OutputStream out;
            ByteArrayOutputStream tempOut;
            InputStream tempIn;
            block29: {
                tempIn = null;
                tempOut = null;
                out = null;
                long size = 0L;
                int result = this.compile(incremental);
                if (result == 0 || result == Integer.MAX_VALUE || result == 1) {
                    tempOut = new ByteArrayOutputStream();
                    size = result == 1 || result == Integer.MAX_VALUE ? this.link(tempOut) : this.encode(tempOut);
                    tempOut.flush();
                    if (size > 0L) {
                        tempIn = new ByteArrayInputStream(tempOut.toByteArray());
                        out = new BufferedOutputStream(new FileOutputStream(this.output));
                        FileUtil.streamOutput(tempIn, out);
                    }
                }
                l = size;
                Object var11_10 = null;
                if (tempIn == null) break block29;
                try {
                    tempIn.close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (tempOut != null) {
                try {
                    tempOut.close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                this.benchmark.stopTime("postcompile", false);
            }
            this.runExtensions();
            this.clean(false, false, false, true, false, true);
            return l;
            catch (Throwable t) {
                Exception ex222222;
                long l2;
                block32: {
                    try {
                        ThreadLocalToolkit.logError(t.getLocalizedMessage());
                        l2 = 0L;
                        Object var11_11 = null;
                        if (tempIn == null) break block32;
                    }
                    catch (Throwable throwable) {
                        Exception ex222222;
                        Object var11_12 = null;
                        if (tempIn != null) {
                            try {
                                tempIn.close();
                            }
                            catch (Exception ex222222) {
                                // empty catch block
                            }
                        }
                        if (tempOut != null) {
                            try {
                                tempOut.close();
                            }
                            catch (Exception ex222222) {
                                // empty catch block
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception ex222222) {
                                // empty catch block
                            }
                        }
                        if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                            this.benchmark.stopTime("postcompile", false);
                        }
                        this.runExtensions();
                        this.clean(false, false, false, true, false, true);
                        throw throwable;
                    }
                    try {
                        tempIn.close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (tempOut != null) {
                    try {
                        tempOut.close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                    this.benchmark.stopTime("postcompile", false);
                }
                this.runExtensions();
                this.clean(false, false, false, true, false, true);
                return l2;
            }
        }
        return 0L;
    }

    private void runExtensions() {
        if (this.oemConfiguration != null) {
            Set<IApplicationExtension> extensions = ExtensionManager.getApplicationExtensions(this.oemConfiguration.getExtensions());
            for (IApplicationExtension extension : extensions) {
                if (ThreadLocalToolkit.errorCount() != 0) continue;
                extension.run(this.oemConfiguration.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long build(OutputStream out, boolean incremental) throws IOException {
        long l;
        block9: {
            block7: {
                long l2;
                block8: {
                    int result;
                    block5: {
                        long l3;
                        block6: {
                            try {
                                result = this.compile(incremental);
                                if (result != 1 && result != Integer.MAX_VALUE) break block5;
                                this.runExtensions();
                                l3 = this.link(out);
                                Object var7_7 = null;
                                if (this.benchmark == null || !this.benchmark.hasStarted("postcompile")) break block6;
                                this.benchmark.stopTime("postcompile", false);
                            }
                            catch (Throwable throwable) {
                                Object var7_10 = null;
                                if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                                    this.benchmark.stopTime("postcompile", false);
                                }
                                this.clean(false, false, false, true, false, true);
                                throw throwable;
                            }
                        }
                        this.clean(false, false, false, true, false, true);
                        return l3;
                    }
                    if (result != 0) break block7;
                    this.runExtensions();
                    l2 = this.encode(out);
                    Object var7_8 = null;
                    if (this.benchmark == null || !this.benchmark.hasStarted("postcompile")) break block8;
                    this.benchmark.stopTime("postcompile", false);
                }
                this.clean(false, false, false, true, false, true);
                return l2;
            }
            l = 0L;
            Object var7_9 = null;
            if (this.benchmark == null || !this.benchmark.hasStarted("postcompile")) break block9;
            this.benchmark.stopTime("postcompile", false);
        }
        this.clean(false, false, false, true, false, true);
        return l;
    }

    @Override
    public void stop() {
        this.cc.stop();
    }

    @Override
    public void clean() {
        this.clean(true, true, true, true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(InputStream in) throws IOException {
        try {
            this.cacheName = OEMUtil.load(in, this.cacheName);
            Object var3_2 = null;
            this.clean(true, false, false, true, false, true);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.clean(true, false, false, true, false, true);
            throw throwable;
        }
    }

    @Override
    public long save(OutputStream out) throws IOException {
        return OEMUtil.save(out, this.cacheName, this.data);
    }

    @Override
    public Report getReport() {
        OEMUtil.setupLocalizationManager();
        return new OEMReport(this.data == null ? null : this.data.sources, this.data == null ? null : this.data.movie, this.data == null ? null : this.data.configuration, this.data == null ? null : this.data.sourceList, this.configurationReport, this.messages);
    }

    private void setupFontManager(OEMConfiguration localOEMConfiguration) {
        if (localOEMConfiguration != null && this.data != null) {
            FontsConfiguration fontsConfiguration = localOEMConfiguration.configuration.getCompilerConfiguration().getFontsConfiguration();
            fontsConfiguration.setTopLevelManager(this.data.fontManager);
        }
    }

    private boolean setupSourceContainers(OEMConfiguration localOEMConfiguration) {
        ToolsConfiguration configuration = localOEMConfiguration.configuration;
        CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
        VirtualFile[] asClasspath = compilerConfig.getSourcePath();
        boolean result = false;
        try {
            if (this.files.size() == 0) {
                ApplicationCompilerConfiguration acc = (ApplicationCompilerConfiguration)localOEMConfiguration.configuration;
                this.files.add(CompilerAPI.getVirtualFile(acc.getTargetFile(), true));
                this.isGeneratedTargetFile = true;
            } else if (this.isGeneratedTargetFile) {
                I18nUtils.regenerateResourceModule((ApplicationCompilerConfiguration)localOEMConfiguration.configuration);
            }
            VirtualFile targetFile = this.files.get(this.files.size() - 1);
            WebTierAPI.checkSupportedTargetMimeType(targetFile);
            this.data.fileSpec = new FileSpec(Collections.<VirtualFile>emptyList(), WebTierAPI.getFileSpecMimeTypes());
            this.data.sourceList = new SourceList(this.files, asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes());
            this.data.sourcePath = new SourcePath(asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
            this.data.resources = new ResourceContainer();
            this.data.bundlePath = new ResourceBundlePath(compilerConfig, targetFile);
            if (this.data.sources != null) {
                this.data.sources.clear();
            }
            if (this.data.units != null) {
                this.data.units.clear();
            }
            if (this.data.swcDefSignatureChecksums != null) {
                this.data.swcDefSignatureChecksums.clear();
            }
            if (this.data.swcFileChecksums != null) {
                this.data.swcFileChecksums.clear();
            }
            result = true;
        }
        catch (CompilerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (ConfigurationException e) {
            ThreadLocalToolkit.logInfo(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadCompilationUnits(OEMConfiguration localOEMConfiguration, CompilerSwcContext swcContext, int[] checksums) {
        ToolsConfiguration configuration = localOEMConfiguration.configuration;
        if (this.data.cacheName == null) {
            return true;
        }
        RandomAccessFile cacheFile = null;
        cacheFile = new RandomAccessFile(this.data.cacheName, "r");
        this.data.sources = new ArrayList<Source>();
        this.data.units = new ArrayList<CompilationUnit>();
        this.data.swcDefSignatureChecksums = new HashMap<QName, Long>();
        this.data.swcFileChecksums = new HashMap<String, Long>();
        CompilerAPI.loadCompilationUnits(configuration, this.data.fileSpec, this.data.sourceList, this.data.sourcePath, this.data.resources, this.data.bundlePath, this.data.sources, this.data.units, checksums, this.data.swcDefSignatureChecksums, this.data.swcFileChecksums, cacheFile, this.data.cacheName, this.data.fontManager);
        Object var9_6 = null;
        if (cacheFile == null) return true;
        try {
            cacheFile.close();
            return true;
        }
        catch (IOException ex2) {}
        return true;
        {
            catch (FileNotFoundException ex) {
                ThreadLocalToolkit.logInfo(ex.getMessage());
                Object var9_7 = null;
                if (cacheFile == null) return true;
                try {
                    cacheFile.close();
                    return true;
                }
                catch (IOException ex2) {}
                return true;
            }
            catch (IOException ex) {
                ThreadLocalToolkit.logInfo(ex.getMessage());
                if (!this.setupSourceContainers(localOEMConfiguration)) {
                    boolean bl = false;
                    Object var9_8 = null;
                    if (cacheFile == null) return bl;
                    try {
                        cacheFile.close();
                        return bl;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    return bl;
                }
                try {
                    Object var9_9 = null;
                    if (cacheFile == null) return true;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (cacheFile == null) throw throwable;
                    try {
                        cacheFile.close();
                        throw throwable;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    cacheFile.close();
                    return true;
                }
                catch (IOException ex2) {}
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int compile(boolean incremental) {
        CompilerSwcContext swcContext;
        OEMConfiguration tempOEMConfiguration;
        block31: {
            SubCompiler[] compilers;
            NameMappings mappings;
            Map licenseMap;
            block30: {
                block29: {
                    String compilationType;
                    block28: {
                        int n;
                        try {
                            this.messages.clear();
                            tempOEMConfiguration = this.oemConfiguration == null ? (OEMConfiguration)this.getDefaultConfiguration(true) : OEMUtil.getApplicationConfiguration(this.constructCommandLine(this.oemConfiguration), this.oemConfiguration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings);
                            if (tempOEMConfiguration != null) break block28;
                            this.clean(false, false, false, true, false, false);
                            n = -1;
                            Object var14_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_11 = null;
                            OEMUtil.clean();
                            throw throwable;
                        }
                        OEMUtil.clean();
                        return n;
                    }
                    if (this.oemConfiguration != null && this.oemConfiguration.keepConfigurationReport()) {
                        this.configurationReport = OEMUtil.formatConfigurationBuffer(tempOEMConfiguration.cfgbuf);
                    }
                    this.setupFontManager(tempOEMConfiguration);
                    if (this.oemConfiguration != null) {
                        this.oemConfiguration.cfgbuf = tempOEMConfiguration.cfgbuf;
                    }
                    if (tempOEMConfiguration.configuration.benchmark()) {
                        this.benchmark = CompilerAPI.runBenchmark();
                        this.benchmark.setTimeFilter(tempOEMConfiguration.configuration.getBenchmarkTimeFilter());
                        this.benchmark.startTime("precompile");
                    } else {
                        CompilerAPI.disableBenchmark();
                    }
                    this.cc.run();
                    OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
                    licenseMap = OEMUtil.getLicenseMap(tempOEMConfiguration.configuration);
                    if (this.data != null && incremental) break block29;
                    String string = compilationType = this.cacheName != null ? "inactive" : "full";
                    if (this.benchmark != null) {
                        this.benchmark.benchmark2("Starting " + compilationType + " compile for " + this.getOutput(), true);
                    }
                    int returnValue = this.recompile(false, licenseMap, tempOEMConfiguration);
                    if (this.benchmark != null) {
                        this.benchmark.benchmark2("Ending " + compilationType + " compile for " + this.getOutput(), true);
                    }
                    this.clean(returnValue != 1, false, false, true, false, false);
                    int n = returnValue;
                    Object var14_6 = null;
                    OEMUtil.clean();
                    return n;
                }
                CompilerAPI.setupHeadless(tempOEMConfiguration.configuration);
                CompilerConfiguration compilerConfig = tempOEMConfiguration.configuration.getCompilerConfiguration();
                mappings = CompilerAPI.getNameMappings(tempOEMConfiguration.configuration);
                Transcoder[] transcoders = WebTierAPI.getTranscoders(tempOEMConfiguration.configuration);
                compilers = WebTierAPI.getCompilers(compilerConfig, mappings, transcoders);
                swcContext = new CompilerSwcContext(true);
                try {
                    swcContext.load(compilerConfig.getLibraryPath(), flex2.compiler.common.Configuration.getAllExcludedLibraries(compilerConfig, tempOEMConfiguration.configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat(compilerConfig), this.data.swcCache);
                }
                catch (SwcException ex) {
                    this.clean(false, false, false, true, false, false);
                    int n = -1;
                    Object var14_7 = null;
                    OEMUtil.clean();
                    return n;
                }
                if (this.librarySwcCache != null && this.librarySwcCache.getSwcCache() != this.data.swcCache) {
                    this.librarySwcCache.setSwcCache(this.data.swcCache);
                }
                this.data.includes = new HashSet<String>(swcContext.getIncludes());
                this.data.excludes = new HashSet<String>(swcContext.getExterns());
                tempOEMConfiguration.configuration.addExterns(swcContext.getExterns());
                tempOEMConfiguration.configuration.addIncludes(swcContext.getIncludes());
                tempOEMConfiguration.configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
                if (!OEMUtil.isRecompilationNeeded(this.data, swcContext, tempOEMConfiguration)) break block30;
                this.data.resources = new ResourceContainer();
                if (this.benchmark != null) {
                    this.benchmark.benchmark2("Starting full compile for " + this.getOutput(), true);
                }
                this.clean(true, false, false, true, false, false);
                int returnValue = this.recompile(true, licenseMap, tempOEMConfiguration);
                if (this.benchmark != null) {
                    this.benchmark.benchmark2("Ending full compile for " + this.getOutput(), true);
                }
                this.clean(returnValue != 1, false, false, true, false, false);
                int n = returnValue;
                Object var14_8 = null;
                OEMUtil.clean();
                return n;
            }
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Starting active compile for " + this.getOutput(), true);
            }
            this.data.sourcePath.clearCache();
            this.data.bundlePath.clearCache();
            this.data.resources.refresh();
            int count = CompilerAPI.validateCompilationUnits(this.data.fileSpec, this.data.sourceList, this.data.sourcePath, this.data.bundlePath, this.data.resources, swcContext, this.data.perCompileData, false, tempOEMConfiguration.configuration);
            if (count <= 0 && this.data.swcChecksum == swcContext.checksum()) break block31;
            this.data.configuration = tempOEMConfiguration.configuration;
            this.data.linkChecksum = tempOEMConfiguration.cfgbuf.link_checksum_ts();
            this.data.swcChecksum = swcContext.checksum();
            SymbolTable symbolTable = new SymbolTable(tempOEMConfiguration.configuration, this.data.perCompileData);
            this.data.sources = new ArrayList<Source>();
            this.data.units = this.compile(compilers, swcContext, symbolTable, mappings, licenseMap, this.data.sources, tempOEMConfiguration);
            boolean forcedToStop = CompilerAPI.forcedToStop();
            if (this.data.units == null || forcedToStop) {
                this.data.sources = null;
            }
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Ending active compile for " + this.getOutput(), true);
            }
            this.clean(false, false, false, true, false, false);
            int n = this.data.units != null && !forcedToStop ? 1 : -1;
            Object var14_9 = null;
            OEMUtil.clean();
            return n;
        }
        if (this.benchmark != null) {
            this.benchmark.stopTime("precompile", false);
            this.benchmark.startTime("postcompile");
        }
        int retVal = 0;
        if (this.data != null) {
            CompilerAPI.displayWarnings(this.data.units);
            if (this.data.linkChecksum != tempOEMConfiguration.cfgbuf.link_checksum_ts()) {
                retVal = Integer.MAX_VALUE;
            }
        } else {
            retVal = Integer.MAX_VALUE;
        }
        this.data.linkChecksum = tempOEMConfiguration.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        if (this.benchmark != null) {
            this.benchmark.benchmark2("Ending active compile for " + this.getOutput(), true);
        }
        if (CompilerAPI.forcedToStop()) {
            retVal = -1;
        }
        if (retVal != Integer.MAX_VALUE) {
            this.clean(false, false, false, true, false, false);
        }
        int n = retVal;
        Object var14_10 = null;
        OEMUtil.clean();
        return n;
    }

    private int recompile(boolean fullRecompile, Map licenseMap, OEMConfiguration localOEMConfiguration) {
        SymbolTable symbolTable;
        ContextStatics contextStatics;
        this.data = new ApplicationData();
        this.data.configuration = localOEMConfiguration.configuration;
        this.data.cacheName = this.cacheName;
        CompilerAPI.setupHeadless(localOEMConfiguration.configuration);
        CompilerConfiguration compilerConfig = localOEMConfiguration.configuration.getCompilerConfiguration();
        NameMappings mappings = CompilerAPI.getNameMappings(localOEMConfiguration.configuration);
        this.data.fontManager = compilerConfig.getFontsConfiguration().getTopLevelManager();
        if (this.output != null) {
            OEMUtil.setGeneratedDirectory(compilerConfig, this.output);
        }
        Transcoder[] transcoders = WebTierAPI.getTranscoders(localOEMConfiguration.configuration);
        SubCompiler[] compilers = WebTierAPI.getCompilers(compilerConfig, mappings, transcoders);
        if (!this.setupSourceContainers(localOEMConfiguration)) {
            this.clean(true, false, false, true, false, false);
            return -1;
        }
        if (this.librarySwcCache != null && (contextStatics = this.librarySwcCache.getContextStatics()) != null && contextStatics.use_static_semantics == compilerConfig.strict()) {
            this.data.swcCache = this.librarySwcCache.getSwcCache();
            this.data.perCompileData = contextStatics;
            this.data.perCompileData.clearUserDefined();
        }
        if (this.data.swcCache == null) {
            this.data.swcCache = new SwcCache();
        }
        CompilerSwcContext swcContext = new CompilerSwcContext(true);
        try {
            swcContext.load(compilerConfig.getLibraryPath(), flex2.compiler.common.Configuration.getAllExcludedLibraries(compilerConfig, localOEMConfiguration.configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat(compilerConfig), this.data.swcCache);
        }
        catch (SwcException ex) {
            this.clean(false, false, false, true, false, false);
            return -1;
        }
        if (this.librarySwcCache != null && this.librarySwcCache.getSwcCache() != this.data.swcCache) {
            this.librarySwcCache.setSwcCache(this.data.swcCache);
        }
        this.data.includes = new HashSet<String>(swcContext.getIncludes());
        this.data.excludes = new HashSet<String>(swcContext.getExterns());
        localOEMConfiguration.configuration.addExterns(swcContext.getExterns());
        localOEMConfiguration.configuration.addIncludes(swcContext.getIncludes());
        localOEMConfiguration.configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
        this.data.cmdChecksum = localOEMConfiguration.cfgbuf.checksum_ts();
        this.data.linkChecksum = localOEMConfiguration.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        int[] checksums = new int[]{0, this.data.cmdChecksum, this.data.linkChecksum, this.data.swcChecksum};
        if (!fullRecompile) {
            if (!this.loadCompilationUnits(localOEMConfiguration, swcContext, checksums)) {
                this.clean(true, false, false, true, false, false);
                return -1;
            }
            this.data.checksum = checksums[0];
            if (this.data.units != null && this.data.units.size() > 0 && OEMUtil.isRecompilationNeeded(this.data, swcContext, localOEMConfiguration) && !this.setupSourceContainers(localOEMConfiguration)) {
                this.clean(true, false, false, true, false, false);
                return -1;
            }
        }
        int count = CompilerAPI.validateCompilationUnits(this.data.fileSpec, this.data.sourceList, this.data.sourcePath, this.data.bundlePath, this.data.resources, swcContext, this.data.perCompileData, false, localOEMConfiguration.configuration);
        if (this.data.perCompileData != null) {
            symbolTable = new SymbolTable(localOEMConfiguration.configuration, this.data.perCompileData);
        } else {
            symbolTable = new SymbolTable(localOEMConfiguration.configuration);
            this.data.perCompileData = symbolTable.perCompileData;
            if (this.librarySwcCache != null) {
                this.librarySwcCache.setContextStatics(this.data.perCompileData);
            }
        }
        this.data.sources = new ArrayList<Source>();
        this.data.units = this.compile(compilers, swcContext, symbolTable, mappings, licenseMap, this.data.sources, localOEMConfiguration);
        this.data.checksum = OEMUtil.calculateChecksum(this.data, swcContext, localOEMConfiguration);
        boolean forcedToStop = CompilerAPI.forcedToStop();
        return this.data == null || this.data.units == null || forcedToStop ? -1 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<CompilationUnit> compile(SubCompiler[] compilers, CompilerSwcContext swcContext, SymbolTable symbolTable, NameMappings nameMappings, Map licenseMap, List<Source> sources, OEMConfiguration OEMConfig) {
        List<CompilationUnit> units = null;
        try {
            try {
                if (this.benchmark != null) {
                    for (int i = 0; i < compilers.length; ++i) {
                        compilers[i].initBenchmarks();
                    }
                }
                ApplicationCompilerConfiguration config = (ApplicationCompilerConfiguration)this.data.configuration;
                VirtualFile projector = config.getProjector();
                if (this.benchmark != null) {
                    this.benchmark.stopTime("precompile", false);
                }
                units = projector != null && projector.getName().endsWith("avmplus.exe") ? CompilerAPI.compile(this.data.fileSpec, this.data.sourceList, null, this.data.sourcePath, this.data.resources, this.data.bundlePath, swcContext, symbolTable, nameMappings, this.data.configuration, compilers, null, licenseMap, sources) : CompilerAPI.compile(this.data.fileSpec, this.data.sourceList, null, this.data.sourcePath, this.data.resources, this.data.bundlePath, swcContext, symbolTable, nameMappings, this.data.configuration, compilers, new PreLink(), licenseMap, sources);
                if (this.benchmark != null) {
                    this.benchmark.startTime("postcompile");
                }
                if (this.benchmark != null && ThreadLocalToolkit.getLogger() != null) {
                    if (this.compilerBenchmarks == null) {
                        this.compilerBenchmarks = new HashMap();
                    }
                    this.compilerBenchmarks.clear();
                    flex2.compiler.Logger logger = ThreadLocalToolkit.getLogger();
                    for (int i = 0; i < compilers.length; ++i) {
                        String compilerName;
                        SubCompiler compiler = compilers[i];
                        PerformanceData[] times = compiler.getBenchmarks();
                        if (times != null) {
                            compiler.logBenchmarks(logger);
                            compilerName = compiler.getName();
                            assert (!this.compilerBenchmarks.containsKey(compilerName));
                            this.compilerBenchmarks.put(compilerName, times);
                        }
                        if ((times = compiler.getEmbeddedBenchmarks()) == null) continue;
                        compiler.logBenchmarks(logger);
                        compilerName = compiler.getName();
                        compilerName = compilerName + "_emb";
                        assert (!this.compilerBenchmarks.containsKey(compilerName));
                        this.compilerBenchmarks.put(compilerName, times);
                    }
                }
                Object var17_19 = null;
            }
            catch (LicenseException ex) {
                ThreadLocalToolkit.logError(ex.getMessage());
                Object var17_20 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                return units;
            }
            catch (CompilerException ex) {
                assert (ThreadLocalToolkit.errorCount() > 0);
                Object var17_21 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                return units;
            }
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            this.data.sourcePath.clearCache();
            this.data.bundlePath.clearCache();
            this.data.resources.refresh();
            OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
            OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
            throw throwable;
        }
        this.data.sourcePath.clearCache();
        this.data.bundlePath.clearCache();
        this.data.resources.refresh();
        OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
        OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
        return units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long link(OutputStream out) throws IOException {
        if (this.data == null) return 0L;
        if (this.data.units == null) {
            return 0L;
        }
        boolean hasChanged = this.oemConfiguration == null ? false : this.oemConfiguration.hasChanged();
        flex2.compiler.common.Configuration config = null;
        if (hasChanged) {
            OEMConfiguration tempOEMConfiguration = OEMUtil.getLinkerConfiguration(this.oemConfiguration.getLinkerOptions(), this.oemConfiguration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.resolver, this.data.configuration, this.oemConfiguration.newLinkerOptionsAfterCompile, this.data.includes, this.data.excludes);
            if (tempOEMConfiguration == null) {
                this.clean(false, false, false, false, false, true);
                return 0L;
            }
            config = tempOEMConfiguration.configuration;
        } else {
            config = this.data.configuration;
        }
        long size = 0L;
        try {
            block13: {
                try {
                    OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
                    ApplicationCompilerConfiguration appConfig = (ApplicationCompilerConfiguration)this.data.configuration;
                    VirtualFile projector = appConfig.getProjector();
                    PostLink postLink = null;
                    if (config.optimize() && !config.generateDebugTags()) {
                        postLink = new PostLink(config);
                    }
                    if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                        ConsoleApplication temp = this.data.app;
                        this.data.app = LinkerAPI.linkConsole(this.data.units, postLink, config);
                        size = this.encodeConsoleProjector(projector, out);
                        if (hasChanged && temp != null) {
                            this.data.app = temp;
                        }
                        break block13;
                    }
                    SimpleMovie temp = this.data.movie;
                    this.data.movie = (FlexMovie)LinkerAPI.link(this.data.units, postLink, config);
                    long l = size = projector == null ? this.encode(out) : this.encodeProjector(projector, out);
                    if (!hasChanged || temp == null) break block13;
                    this.data.movie = temp;
                }
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var11_14 = null;
                    OEMUtil.clean();
                    return size;
                }
                catch (Throwable t) {
                    ThreadLocalToolkit.logError(t.getLocalizedMessage());
                    Object var11_15 = null;
                    OEMUtil.clean();
                    return size;
                }
            }
            Object var11_13 = null;
            OEMUtil.clean();
            return size;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            OEMUtil.clean();
            throw throwable;
        }
    }

    private long encode(OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null || this.data.movie == null) {
            return 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompilerAPI.encode(this.data.movie, (OutputStream)baos);
        long size = baos.size();
        baos.writeTo(out);
        out.flush();
        return size;
    }

    private long encodeProjector(VirtualFile projector, OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null || this.data.movie == null) {
            return 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompilerAPI.encode(this.data.movie, (OutputStream)baos);
        return Mxmlc.createProjector(projector, baos, out);
    }

    private long encodeConsoleProjector(VirtualFile projector, OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null || this.data.app == null) {
            return 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompilerAPI.encode(this.data.app, (OutputStream)baos);
        return Mxmlc.createProjector(projector, baos, out);
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput, boolean cleanConfig, boolean cleanMessages, boolean cleanThreadLocals) {
        if (cleanThreadLocals) {
            OEMUtil.clean();
        }
        if (this.oemConfiguration != null && cleanConfig) {
            this.oemConfiguration.reset();
        }
        if (cleanData) {
            this.data = null;
            this.configurationReport = null;
        }
        if (cleanCache && this.cacheName != null) {
            File dead = FileUtil.openFile(this.cacheName);
            if (dead != null && dead.exists()) {
                dead.delete();
            }
            this.cacheName = null;
        }
        if (cleanOutput && this.output != null && this.output.exists()) {
            this.output.delete();
        }
        if (cleanMessages) {
            this.messages.clear();
        }
    }

    private String[] constructCommandLine(OEMConfiguration localOEMConfiguration) {
        String[] options = localOEMConfiguration != null ? localOEMConfiguration.getCompilerOptions() : new String[]{};
        String[] args = new String[options.length + this.files.size() + 1];
        System.arraycopy(options, 0, args, 0, options.length);
        args[options.length] = "--file-specs";
        int size = this.files.size();
        for (int i = 0; i < size; ++i) {
            args[options.length + 1 + i] = this.files.get(i).getName();
        }
        return args;
    }

    public LibraryCache getSwcCache() {
        return this.librarySwcCache;
    }

    @Override
    public void setSwcCache(LibraryCache swcCache) {
        this.librarySwcCache = swcCache;
    }

    static {
        int len;
        File[] list = null;
        try {
            File tempDir = File.createTempFile("Flex2_", "").getParentFile();
            list = tempDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("Flex2_");
                }
            });
        }
        catch (Throwable e) {
            // empty catch block
        }
        int n = len = list == null ? 0 : list.length;
        for (int i = 0; i < len; ++i) {
            try {
                list[i].delete();
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        URL url = Application.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            File f = new File(new URI(url.toExternalForm()));
            if (f.getAbsolutePath().endsWith("flex-compiler-oem.jar")) {
                String applicationHome = f.getParentFile().getParent();
                System.setProperty("application.home", applicationHome);
            }
        }
        catch (URISyntaxException ex) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

