/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.util.graph.Algorithms;
import flex2.compiler.util.graph.DependencyGraph;
import flex2.compiler.util.graph.Vertex;
import flex2.compiler.util.graph.Visitor;
import flex2.tools.oem.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private DependencyGraph<Builder> dependencies = new DependencyGraph();

    public void addBuilder(Builder builder) {
        String name = Integer.toString(builder.hashCode());
        this.dependencies.put(name, builder);
        if (!this.dependencies.containsVertex(name)) {
            this.dependencies.addVertex(new Vertex(name));
        }
    }

    public void removeBuilder(Builder builder) {
        String name = Integer.toString(builder.hashCode());
        this.dependencies.remove(name);
        this.dependencies.removeVertex(name);
    }

    public void dependsOn(Builder builder1, Builder builder2) {
        String tail;
        String head = Integer.toString(builder1.hashCode());
        if (!head.equals(tail = Integer.toString(builder2.hashCode())) && this.dependencies.containsKey(head) && this.dependencies.containsKey(tail) && !this.dependencies.dependencyExists(head, tail)) {
            this.dependencies.addDependency(head, tail);
        }
    }

    public Iterator<Builder> getBuildOrder() {
        final ArrayList buildOrder = new ArrayList(this.dependencies.size());
        Algorithms.topologicalSort(this.dependencies, new Visitor<Vertex<String, Builder>>(){

            @Override
            public void visit(Vertex<String, Builder> v) {
                String name = v.getWeight();
                buildOrder.add(Project.this.dependencies.get(name));
            }
        });
        return buildOrder.iterator();
    }

    public Set detectCycles() {
        Set builders = Algorithms.detectCycles(this.dependencies);
        if (builders != null && builders.size() == 0) {
            builders = null;
        }
        return builders;
    }

    public void build(boolean incremental) throws IOException {
        Iterator<Builder> i = this.getBuildOrder();
        while (i.hasNext()) {
            Builder builder = i.next();
            if (builder == null) continue;
            builder.build(incremental);
        }
    }

    public void clean() {
        Iterator<Builder> i = this.getBuildOrder();
        while (i.hasNext()) {
            Builder builder = i.next();
            if (builder == null) continue;
            builder.clean();
        }
    }

    public void stop() {
        Iterator<Builder> i = this.getBuildOrder();
        while (i.hasNext()) {
            Builder builder = i.next();
            if (builder == null) continue;
            builder.stop();
        }
    }
}

