/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.QNameValue;

public class IndependentContext
extends AbstractStaticContext
implements XPathStaticContext,
NamespaceResolver,
Serializable,
Container {
    private HashMap namespaces = new HashMap(10);
    private HashMap variables = new HashMap(20);
    private NamespaceResolver externalResolver = null;
    private Set importedSchemaNamespaces = new HashSet();

    public IndependentContext() {
        this(new Configuration());
    }

    public IndependentContext(Configuration config) {
        this.setConfiguration(config);
        this.clearNamespaces();
        this.setDefaultFunctionLibrary();
    }

    public IndependentContext copy() {
        IndependentContext ic = new IndependentContext(this.getConfiguration());
        ic.setBaseURI(this.getBaseURI());
        ic.setLocationMap(this.getLocationMap());
        ic.setDefaultElementNamespace(this.getDefaultElementNamespace());
        ic.setDefaultFunctionNamespace(this.getDefaultFunctionNamespace());
        ic.namespaces = new HashMap(this.namespaces);
        ic.variables = new HashMap(10);
        ic.importedSchemaNamespaces = this.importedSchemaNamespaces;
        ic.externalResolver = this.externalResolver;
        return ic;
    }

    public void declareNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if ("".equals(prefix)) {
            this.setDefaultElementNamespace(uri);
        } else {
            this.namespaces.put(prefix, uri);
            this.getNamePool().allocateNamespaceCode(prefix, uri);
        }
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("", "");
    }

    public void clearAllNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("", "");
    }

    public void setNamespaces(NodeInfo node) {
        this.namespaces.clear();
        int kind = node.getNodeKind();
        if (kind == 2 || kind == 3 || kind == 8 || kind == 7 || kind == 13) {
            node = node.getParent();
        }
        if (node == null) {
            return;
        }
        AxisIterator iter = node.iterateAxis((byte)8);
        NodeInfo ns;
        while ((ns = (NodeInfo)iter.next()) != null) {
            String prefix = ns.getLocalPart();
            if ("".equals(prefix)) {
                this.setDefaultElementNamespace(ns.getStringValue());
                continue;
            }
            this.declareNamespace(ns.getLocalPart(), ns.getStringValue());
        }
        return;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.externalResolver = resolver;
    }

    public XPathVariable declareVariable(QNameValue qname) {
        return this.declareVariable(qname.getNamespaceURI(), qname.getLocalName());
    }

    public XPathVariable declareVariable(String namespaceURI, String localName) {
        XPathVariable var = XPathVariable.make(new StructuredQName("", namespaceURI, localName));
        StructuredQName qName = var.getVariableQName();
        int slot = this.variables.size();
        var.setSlotNumber(slot);
        this.variables.put(qName, var);
        return var;
    }

    public int getSlotNumber(QNameValue qname) {
        StructuredQName sq = qname.toStructuredQName();
        XPathVariable var = (XPathVariable)this.variables.get(sq);
        if (var == null) {
            return -1;
        }
        return var.getLocalSlotNumber();
    }

    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.getURIForPrefix(prefix, false);
        if (uri == null) {
            throw new XPathException("Prefix " + prefix + " has not been declared");
        }
        return uri;
    }

    public NamespaceResolver getNamespaceResolver() {
        if (this.externalResolver != null) {
            return this.externalResolver;
        }
        return this;
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (this.externalResolver != null) {
            return this.externalResolver.getURIForPrefix(prefix, useDefault);
        }
        if (prefix.length() == 0) {
            return useDefault ? this.getDefaultElementNamespace() : "";
        }
        return (String)this.namespaces.get(prefix);
    }

    public Iterator iteratePrefixes() {
        if (this.externalResolver != null) {
            return this.externalResolver.iteratePrefixes();
        }
        return this.namespaces.keySet().iterator();
    }

    public VariableReference bindVariable(StructuredQName qName) throws XPathException {
        XPathVariable var = (XPathVariable)this.variables.get(qName);
        if (var == null) {
            throw new XPathException("Undeclared variable in XPath expression: $" + qName.getClarkName());
        }
        return new VariableReference(var);
    }

    public SlotManager getStackFrameMap() {
        SlotManager map = this.getConfiguration().makeSlotManager();
        Iterator v = this.variables.values().iterator();
        while (v.hasNext()) {
            XPathVariable var = (XPathVariable)v.next();
            map.allocateSlotNumber(var.getVariableQName());
        }
        return map;
    }

    public boolean isImportedSchema(String namespace) {
        return this.importedSchemaNamespaces.contains(namespace);
    }

    public Set getImportedSchemaNamespaces() {
        return this.importedSchemaNamespaces;
    }

    public void setImportedSchemaNamespaces(Set namespaces) {
        this.importedSchemaNamespaces = namespaces;
    }
}

