/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep.init;

import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.EventHandler;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.util.NameFormatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.util.Context;
import org.apache.commons.collections.iterators.SingletonIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventInitializer
implements Initializer {
    private static final String EVENT = "event".intern();
    private final EventHandler handler;
    private static final String ADD_EVENT_LISTENER = "addEventListener".intern();

    public EventInitializer(EventHandler handler) {
        this.handler = handler;
    }

    public String getName() {
        return this.handler.getName();
    }

    @Override
    public Type getLValueType() {
        return this.handler.getType();
    }

    @Override
    public int getLineRef() {
        return this.handler.getXmlLineNumber();
    }

    public String getHandlerText() {
        return this.handler.getEventHandlerText();
    }

    @Override
    public boolean isBinding() {
        return false;
    }

    @Override
    public boolean isStateSpecific() {
        return false;
    }

    @Override
    public String getValueExpr() {
        return this.handler.getDocumentFunctionName();
    }

    @Override
    public Node generateValueExpr(NodeFactory nodeFactory) {
        return AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, this.handler.getDocumentFunctionName(), true);
    }

    @Override
    public String getAssignExpr(String lvalueBase) {
        return lvalueBase + ".addEventListener(" + TextGen.quoteWord(this.getName()) + ", " + this.getValueExpr() + ")";
    }

    @Override
    public StatementListNode generateAssignExpr(NodeFactory nodeFactory, StatementListNode statementList, Node lvalueBase) {
        IdentifierNode identifier = nodeFactory.identifier(ADD_EVENT_LISTENER, false);
        LiteralStringNode literalString = nodeFactory.literalString(this.getName());
        ArgumentListNode argumentList = nodeFactory.argumentList(null, literalString);
        argumentList = nodeFactory.argumentList(argumentList, this.generateValueExpr(nodeFactory));
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression(identifier, argumentList);
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(lvalueBase, callExpression);
        ListNode list = nodeFactory.list(null, memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement(list);
        return nodeFactory.statementList(statementList, expressionStatement);
    }

    @Override
    public boolean hasDefinition() {
        return true;
    }

    @Override
    public Iterator getDefinitionsIterator() {
        return new SingletonIterator((Object)this.getDefinitionBody());
    }

    private CodeFragmentList getDefinitionBody() {
        int line = this.getLineRef();
        CodeFragmentList list = new CodeFragmentList();
        list.add("/**", line);
        list.add(" * @private", line);
        list.add(" **/", line);
        list.add("public function ", this.handler.getDocumentFunctionName(), "(event:", NameFormatter.toDot(this.handler.getType().getName()), "):void", line);
        list.add("{", line);
        list.add("\t", this.handler.getEventHandlerText(), line);
        list.add("}", line);
        return list;
    }

    @Override
    public StatementListNode generateDefinitions(Context context, HashSet<String> configNamespaces, StatementListNode statementList, boolean generateDocComments) {
        StatementListNode result = statementList;
        NodeFactory nodeFactory = context.getNodeFactory();
        if (generateDocComments) {
            DocCommentNode docComment = AbstractSyntaxTreeUtil.generatePrivateDocComment(nodeFactory);
            result = nodeFactory.statementList(result, docComment);
        }
        String type = NameFormatter.toDot(this.handler.getType().getName());
        ParameterNode parameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, EVENT, type, true);
        ParameterListNode parameterList = nodeFactory.parameterList(null, parameter);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, null);
        functionSignature.void_anno = true;
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory);
        IdentifierNode stylesInitIdentifier = nodeFactory.identifier(this.handler.getDocumentFunctionName());
        FunctionNameNode functionName = nodeFactory.functionName(-133, stylesInitIdentifier);
        StatementListNode functionStatementList = null;
        String text = this.handler.getEventHandlerText();
        int xmlLineNumber = this.handler.getXmlLineNumber();
        List<Node> list = AbstractSyntaxTreeUtil.parse(context, configNamespaces, text, xmlLineNumber, generateDocComments);
        for (Node node : list) {
            functionStatementList = nodeFactory.statementList(functionStatementList, node);
        }
        int position = AbstractSyntaxTreeUtil.lineNumberToPosition(nodeFactory, this.getLineRef());
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, null, functionSignature, functionStatementList, position);
        functionCommon.setUserDefinedBody(true);
        if (functionStatementList != null) {
            ReturnStatementNode returnStatement = (ReturnStatementNode)functionStatementList.items.last();
            returnStatement.setPositionTerminal(position);
        }
        FunctionDefinitionNode functionDefinition = nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
        result = nodeFactory.statementList(result, functionDefinition);
        return result;
    }
}

