/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.Source;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;

public class NameFormatter {
    public static String toDot(String ns, String n) {
        return ns.length() > 0 ? ns + '.' + n : n;
    }

    public static String toColon(String ns, String n) {
        return ns.length() > 0 ? (ns + ':' + n).intern() : n;
    }

    public static String toDot(String n) {
        assert (n.indexOf(47) == -1);
        return NameFormatter.toDot(n, ':');
    }

    public static String toDot(QName qname) {
        return NameFormatter.toDot(qname.getNamespace(), qname.getLocalPart());
    }

    public static String toDot(String n, char delimiter) {
        return n.replace(delimiter, '.');
    }

    public static String toColon(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i > 0 ? (n.substring(0, i) + ':' + n.substring(i + 1)).intern() : n;
    }

    public static String toDotStar(String pkg) {
        return pkg + ".*";
    }

    public static String retrievePackageName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i == -1 ? "" : n.substring(0, i);
    }

    public static String normalizePackageName(String n) {
        return n.endsWith("$internal") ? n.substring(0, n.length() - "$internal".length()) : n;
    }

    public static String retrieveClassName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i == -1 ? n : n.substring(i + 1);
    }

    public static MultiName toMultiName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i >= 0 ? new MultiName(new String[]{n.substring(0, i)}, n.substring(i + 1)) : new MultiName(new String[]{""}, n);
    }

    public static MultiName toMultiName(QName qname) {
        return new MultiName(qname.getNamespace(), qname.getLocalPart());
    }

    public static QName toQName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i >= 0 ? new QName(n.substring(0, i), n.substring(i + 1)) : new QName("", n);
    }

    private static String classNameFromSource(Source source) {
        if (source.isSourcePathOwner() || source.isSourceListOwner()) {
            return source.getShortName();
        }
        if (source.isSwcScriptOwner() || source.getCompilationUnit() != null) {
            return source.getCompilationUnit().topLevelDefinitions.first().getLocalPart();
        }
        assert (false);
        return null;
    }

    public static String nameFromSource(Source source) {
        if (source.isSwcScriptOwner()) {
            SwcScript script = (SwcScript)source.getOwner();
            return script.getName();
        }
        if (source.getCompilationUnit() != null) {
            return source.getCompilationUnit().topLevelDefinitions.first().toString().replace(':', '/').replace('.', '/');
        }
        assert (false) : source + ", owner = " + source.getOwner();
        return null;
    }

    public static QName qNameFromSource(Source src) {
        String rel = src.getRelativePath();
        String name = (rel == null || rel.length() == 0 ? "" : rel.replace('/', '.').replace('\\', '.') + ":") + NameFormatter.classNameFromSource(src);
        return new QName(name);
    }
}

