/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.util.Name;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.graph.Algorithms;
import flex2.compiler.util.graph.DependencyGraph;
import flex2.compiler.util.graph.Vertex;
import flex2.compiler.util.graph.Visitor;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleApplication {
    private List<byte[]> abcList = new ArrayList<byte[]>();
    private byte[] main;
    public final boolean enableDebugger;
    private List<CompilationUnit> exportedUnits;

    public ConsoleApplication(LinkerConfiguration linkerConfiguration) {
        this.enableDebugger = linkerConfiguration.generateDebugTags();
        this.exportedUnits = new LinkedList<CompilationUnit>();
    }

    public List<byte[]> getABCs() {
        return this.abcList;
    }

    public void generate(List<CompilationUnit> units) throws LinkerException {
        DependencyGraph<CompilationUnit> dependencies = this.extractCompilationUnitInfo(units);
        this.exportDependencies(dependencies);
        if (ThreadLocalToolkit.errorCount() > 0) {
            throw new LinkerException.LinkingFailed();
        }
    }

    private DependencyGraph<CompilationUnit> extractCompilationUnitInfo(List<CompilationUnit> units) {
        Source s;
        CompilationUnit u;
        int i;
        DependencyGraph<CompilationUnit> dependencies = new DependencyGraph<CompilationUnit>();
        HashMap qnames = new HashMap();
        int length = units.size();
        for (i = 0; i < length; ++i) {
            u = units.get(i);
            s = u.getSource();
            String path = s.getName();
            dependencies.put(path, u);
            if (!dependencies.containsVertex(s.getName())) {
                dependencies.addVertex(new Vertex(path));
            }
            Iterator j = u.topLevelDefinitions.iterator();
            while (j.hasNext()) {
                qnames.put(j.next(), s.getName());
            }
        }
        int size = units.size();
        for (i = 0; i < size; ++i) {
            u = units.get(i);
            s = u.getSource();
            String head = s.getName();
            for (Name name : u.inheritance) {
                QName qname;
                String tail;
                if (!(name instanceof QName) || (tail = (String)qnames.get(qname = (QName)name)) == null || head.equals(tail) || dependencies.dependencyExists(head, tail)) continue;
                dependencies.addDependency(head, tail);
            }
        }
        return dependencies;
    }

    private void exportDependencies(final DependencyGraph<CompilationUnit> dependencies) {
        Algorithms.topologicalSort(dependencies, new Visitor<Vertex<String, CompilationUnit>>(){

            @Override
            public void visit(Vertex<String, CompilationUnit> v) {
                String fileName = v.getWeight();
                CompilationUnit u = (CompilationUnit)dependencies.get(fileName);
                if (!u.getSource().isInternal()) {
                    if (u.isRoot()) {
                        ConsoleApplication.access$002(ConsoleApplication.this, u.getByteCodes());
                    } else {
                        ConsoleApplication.this.abcList.add(u.getByteCodes());
                    }
                    ConsoleApplication.this.exportedUnits.add(u);
                }
            }
        });
        this.abcList.add(this.main);
    }

    public List<CompilationUnit> getExportedUnits() {
        return this.exportedUnits;
    }

    static /* synthetic */ byte[] access$002(ConsoleApplication x0, byte[] x1) {
        x0.main = x1;
        return x1;
    }
}

