/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.fonts.LocalFont;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.svggen.font.Font;
import org.apache.batik.svggen.font.table.NameTable;
import org.apache.batik.svggen.font.table.Os2Table;

public class FontSnapshot {
    private static Method getFontPath;
    private Map<String, LocalFont> fonts = new HashMap<String, LocalFont>();
    private static boolean printForMap;

    public static void main(String[] args) throws Exception {
        FontSnapshot snapshot = new FontSnapshot(args);
        snapshot.save();
    }

    public FontSnapshot(String[] paths) {
        this.findFonts(paths);
    }

    protected void findFonts(String[] paths) {
        if (paths != null && paths.length != 0) {
            for (int i = 0; i < paths.length; ++i) {
                this.findFonts(paths[i]);
            }
        }
        if (getFontPath != null) {
            String fPath;
            try {
                fPath = (String)getFontPath.invoke(null, Boolean.TRUE);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not call getFontPath() for initializing system fonts: " + e, e);
            }
            StringTokenizer parser = new StringTokenizer(fPath, File.pathSeparator);
            while (parser.hasMoreTokens()) {
                this.findFonts(parser.nextToken());
            }
        }
    }

    protected void findFonts(String path) {
        File file = new File(path);
        if (!file.exists()) {
            throw new RuntimeException("Font or dir not found: " + file);
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    File child = children[i];
                    if (!child.isDirectory() && !child.toString().toLowerCase().endsWith(".ttf")) continue;
                    this.findFonts(child.toString());
                }
            }
        } else {
            Font font = null;
            String err = null;
            try {
                font = Font.create((String)file.toString());
            }
            catch (Exception e) {
                err = e.toString();
            }
            if (font == null || font.getOS2Table() == null || font.getNameTable() == null) {
                System.err.println("Error reading " + file + ": " + err);
            } else {
                Os2Table os2Table = font.getOS2Table();
                short fsType = os2Table.getLicenseType();
                NameTable name = font.getNameTable();
                String copyright = name.getRecord((short)0);
                String trademark = name.getRecord((short)7);
                String postScriptName = name.getRecord((short)6);
                LocalFont localFont = new LocalFont(postScriptName, path, (int)fsType, copyright, trademark);
                LocalFont cachedFont = this.fonts.get(postScriptName);
                if (cachedFont != null) {
                    if (!localFont.equals((Object)cachedFont)) {
                        System.out.println("Found different fonts with the same postscript name. Keeping font " + postScriptName + " found at  " + cachedFont.path + " and ignoring " + localFont.path);
                    }
                } else {
                    this.fonts.put(postScriptName, localFont);
                    if (printForMap) {
                        System.out.println("defaultLocalFonts.put(\"" + postScriptName + "\", new LocalFont(\"" + postScriptName + "\", null, " + fsType + ", \"" + copyright + "\", \"" + trademark + "\"));");
                    }
                }
            }
        }
    }

    public void save() throws IOException {
        if (this.fonts.size() == 0) {
            System.err.println("No fonts were found.  You must specify the system font directories.");
        }
        BufferedOutputStream buffStream = new BufferedOutputStream(new FileOutputStream("localFonts.ser"));
        ObjectOutputStream out = new ObjectOutputStream(buffStream);
        out.writeObject(this.fonts);
        out.flush();
        ((OutputStream)buffStream).close();
    }

    static {
        printForMap = true;
        try {
            Class<?> cls = Class.forName("sun.awt.font.NativeFontWrapper", true, Thread.currentThread().getContextClassLoader());
            Method[] meth = cls.getMethods();
            for (int i = 0; i < meth.length; ++i) {
                Method method = meth[i];
                if (!method.getName().equals("getFontPath")) continue;
                getFontPath = method;
                break;
            }
        }
        catch (Exception e) {
            try {
                Class<?> cls = Class.forName("sun.font.FontManager", true, Thread.currentThread().getContextClassLoader());
                getFontPath = cls.getMethod("getFontPath", Boolean.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

