/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.AbstractFXGNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.GroupNode;
import com.adobe.internal.fxg.dom.TextGraphicNode;
import com.adobe.internal.fxg.dom.types.ScalingGrid;
import java.util.ArrayList;
import java.util.List;

public class GroupDefinitionNode
extends AbstractFXGNode {
    public double scaleGridLeft = 0.0;
    public double scaleGridRight = 0.0;
    public double scaleGridTop = 0.0;
    public double scaleGridBottom = 0.0;
    public List<GraphicContentNode> children;
    private boolean definesScaleGrid;
    private int textCount;

    public void addChild(FXGNode child) {
        if (child instanceof GraphicContentNode) {
            if (child instanceof TextGraphicNode) {
                ++this.textCount;
            }
            if (this.children == null) {
                this.children = new ArrayList<GraphicContentNode>();
            }
            this.children.add((GraphicContentNode)child);
            if (child instanceof GroupNode && this.definesScaleGrid()) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidScaleGridGroupChild", new Object[0]);
            }
        } else {
            super.addChild(child);
        }
    }

    public String getNodeName() {
        return "Group";
    }

    public void setAttribute(String name, String value) {
        if ("scaleGridLeft".equals(name)) {
            this.scaleGridLeft = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("scaleGridTop".equals(name)) {
            this.scaleGridTop = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("scaleGridRight".equals(name)) {
            this.scaleGridRight = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("scaleGridBottom".equals(name)) {
            this.scaleGridBottom = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else {
            if ("id".equals(name)) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidGroupIDAttribute", new Object[0]);
            }
            super.setAttribute(name, value);
        }
    }

    public ScalingGrid getScalingGrid() {
        ScalingGrid scalingGrid = null;
        if (this.definesScaleGrid()) {
            scalingGrid = new ScalingGrid();
            scalingGrid.scaleGridLeft = this.scaleGridLeft;
            scalingGrid.scaleGridTop = this.scaleGridTop;
            scalingGrid.scaleGridRight = this.scaleGridRight;
            scalingGrid.scaleGridBottom = this.scaleGridBottom;
        }
        return scalingGrid;
    }

    public boolean definesScaleGrid() {
        return this.definesScaleGrid;
    }

    public int getTextCount() {
        return this.textCount;
    }
}

