/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.AlreadyActiveApplicationException;
import flash.tools.debugger.CommandLineException;
import flash.tools.debugger.ILaunchNotification;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.concrete.StreamListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;

public class ProcessListener {
    private Process m_process;
    private ILaunchNotification m_launchNotification;
    private boolean m_isDebugging;
    private boolean m_isAIRapp;
    private final String[] m_launchCommand;
    private StringWriter m_processMessages;
    private Thread m_launchNotifierThread = new Thread("DJAPI ProcessListener"){

        public void run() {
            try {
                ProcessListener.this.m_process.waitFor();
                IOException e = null;
                if (ProcessListener.this.getProcessExitValue() != 0) {
                    e = ProcessListener.this.createLaunchFailureException();
                }
                ProcessListener.this.m_launchNotification.notify(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public ProcessListener(String[] launchCommand, Process process, ILaunchNotification launchNotification, boolean forDebugging, boolean isAIRapp) {
        this.m_launchCommand = launchCommand;
        this.m_process = process;
        this.m_launchNotification = launchNotification;
        this.m_isDebugging = forDebugging;
        this.m_isAIRapp = isAIRapp;
        this.m_processMessages = new StringWriter();
        this.startMessageListener();
    }

    private void startMessageListener() {
        new StreamListener(new InputStreamReader(this.m_process.getInputStream()), this.m_processMessages).start();
        new StreamListener(new InputStreamReader(this.m_process.getErrorStream()), this.m_processMessages).start();
        try {
            OutputStream stm = this.m_process.getOutputStream();
            if (stm != null) {
                stm.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startLaunchNotifier() {
        if (this.m_launchNotification == null) {
            throw new NullPointerException();
        }
        this.m_launchNotifierThread.setDaemon(true);
        this.m_launchNotifierThread.start();
    }

    public String[] getLaunchCommand() {
        return this.m_launchCommand;
    }

    public boolean isAIRApp() {
        return this.m_isAIRapp;
    }

    public boolean isProcessDead() {
        try {
            this.m_process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public int getProcessExitValue() throws IllegalThreadStateException {
        return this.m_process.exitValue();
    }

    public String getProcessMessages() {
        return this.m_processMessages.toString();
    }

    public IOException createLaunchFailureException() {
        IOException e = null;
        String detailMessage = this.m_isDebugging ? PlayerSessionManager.getLocalizationManager().getLocalizedTextString("processTerminatedWithoutDebuggerConnection") : PlayerSessionManager.getLocalizationManager().getLocalizedTextString("processTerminatedUnexpectedly");
        if (!this.isProcessDead()) {
            throw new IllegalThreadStateException();
        }
        int exitValue = this.getProcessExitValue();
        e = this.m_isAIRapp && exitValue == 1 ? new AlreadyActiveApplicationException(detailMessage, this.m_isDebugging) : new CommandLineException(detailMessage, this.getLaunchCommand(), this.getProcessMessages(), exitValue);
        return e;
    }
}

