/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import org.apache.batik.Version;
import org.apache.batik.apps.svgbrowser.Resources;

public class AboutDialog
extends JWindow {
    public static final String ICON_BATIK_SPLASH = "AboutDialog.icon.batik.splash";
    public static final String ICON_APACHE_LOGO = "AboutDialog.icon.apache.logo";
    public static final String LABEL_APACHE_BATIK_PROJECT = "AboutDialog.label.apache.batik.project";
    public static final String LABEL_CONTRIBUTORS = "AboutDialog.label.contributors";

    public AboutDialog() {
        this.buildGUI();
    }

    public AboutDialog(Frame owner) {
        super(owner);
        this.buildGUI();
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    AboutDialog.this.setVisible(false);
                    AboutDialog.this.dispose();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                AboutDialog.this.setVisible(false);
                AboutDialog.this.dispose();
            }
        });
    }

    public void setLocationRelativeTo(Frame f) {
        Dimension invokerSize = f.getSize();
        Point loc = f.getLocation();
        Point invokerScreenLocation = new Point(loc.x, loc.y);
        Rectangle bounds = this.getBounds();
        int dx = invokerScreenLocation.x + (invokerSize.width - bounds.width) / 2;
        int dy = invokerScreenLocation.y + (invokerSize.height - bounds.height) / 2;
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (dy + bounds.height > screenSize.height) {
            dy = screenSize.height - bounds.height;
            int n = dx = invokerScreenLocation.x < screenSize.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - bounds.width;
        }
        if (dx + bounds.width > screenSize.width) {
            dx = screenSize.width - bounds.width;
        }
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        this.setLocation(dx, dy);
    }

    protected void buildGUI() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBackground(Color.white);
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = cl.getResource(Resources.getString(ICON_APACHE_LOGO));
        JLabel l = new JLabel(Resources.getString(LABEL_APACHE_BATIK_PROJECT), new ImageIcon(url), 2);
        panel.add("North", l);
        url = cl.getResource(Resources.getString(ICON_BATIK_SPLASH));
        panel.add("Center", new JLabel(new ImageIcon(url)));
        String tagName = Version.getVersion();
        panel.add("South", new JLabel(tagName, 4));
        this.setBackground(Color.white);
        this.getContentPane().setBackground(Color.white);
        JPanel p = new JPanel(new BorderLayout());
        p.setBackground(Color.white);
        p.add((Component)panel, "Center");
        JTextArea contributors = new JTextArea(Resources.getString(LABEL_CONTRIBUTORS)){
            {
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setEnabled(false);
                this.setRows(11);
            }
        };
        contributors.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        p.add((Component)contributors, "South");
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.gray, Color.black), BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.black)), BorderFactory.createEmptyBorder(10, 10, 10, 10))));
        this.getContentPane().add(p);
        this.pack();
    }
}

