/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.Authenticator;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.batik.apps.svgbrowser.AboutDialog;
import org.apache.batik.apps.svgbrowser.Application;
import org.apache.batik.apps.svgbrowser.JAuthenticator;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;
import org.apache.batik.apps.svgbrowser.PreferenceDialog;
import org.apache.batik.apps.svgbrowser.XMLPreferenceManager;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.util.ApplicationSecurityEnforcer;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.batik.util.gui.resource.ResourceManager;

public class Main
implements Application {
    public static final String UNKNOWN_SCRIPT_TYPE_LOAD_KEY_EXTENSION = ".load";
    public static final String PROPERTY_USER_HOME = "user.home";
    public static final String PROPERTY_JAVA_SECURITY_POLICY = "java.security.policy";
    public static final String BATIK_CONFIGURATION_SUBDIRECTORY = ".batik";
    public static final String SQUIGGLE_CONFIGURATION_FILE = "preferences.xml";
    public static final String SQUIGGLE_POLICY_FILE = "__svgbrowser.policy";
    public static final String POLICY_GRANT_SCRIPT_NETWORK_ACCESS = "grant {\n  permission java.net.SocketPermission \"*\", \"listen, connect, resolve, accept\";\n};\n\n";
    public static final String POLICY_GRANT_SCRIPT_FILE_ACCESS = "grant {\n  permission java.io.FilePermission \"<<ALL FILES>>\", \"read\";\n};\n\n";
    public static final String PREFERENCE_KEY_VISITED_URI_LIST = "preference.key.visited.uri.list";
    public static final String PREFERENCE_KEY_VISITED_URI_LIST_LENGTH = "preference.key.visited.uri.list.length";
    public static final String URI_SEPARATOR = " ";
    public static final String DEFAULT_DEFAULT_FONT_FAMILY = "Arial, Helvetica, sans-serif";
    public static final String SVG_INITIALIZATION = "resources/init.svg";
    protected String svgInitializationURI;
    public static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.Main";
    public static final String SQUIGGLE_SECURITY_POLICY = "org/apache/batik/apps/svgbrowser/resources/svgbrowser.policy";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.Main", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected static ImageIcon frameIcon = new ImageIcon((class$org$apache$batik$apps$svgbrowser$Main == null ? (class$org$apache$batik$apps$svgbrowser$Main = Main.class$("org.apache.batik.apps.svgbrowser.Main")) : class$org$apache$batik$apps$svgbrowser$Main).getResource(resources.getString("Frame.icon")));
    protected XMLPreferenceManager preferenceManager;
    public static final int MAX_VISITED_URIS = 10;
    protected Vector lastVisited = new Vector();
    protected int maxVisitedURIs = 10;
    protected String[] arguments;
    protected boolean overrideSecurityPolicy = false;
    protected ApplicationSecurityEnforcer securityEnforcer;
    protected Map handlers = new HashMap();
    protected List viewerFrames;
    protected PreferenceDialog preferenceDialog;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$Main;

    public static void main(String[] args) {
        new Main(args);
    }

    public Main(String[] args) {
        this.handlers.put("-font-size", new FontSizeHandler());
        this.viewerFrames = new LinkedList();
        this.arguments = args;
        HashMap<String, Object> defaults = new HashMap<String, Object>(11);
        defaults.put("preference.key.languages", Locale.getDefault().getLanguage());
        defaults.put("preference.key.show.rendering", Boolean.FALSE);
        defaults.put("preference.key.auto.adjust.window", Boolean.TRUE);
        defaults.put("preference.key.selection.xor.mode", Boolean.FALSE);
        defaults.put("preference.key.enable.double.buffering", Boolean.TRUE);
        defaults.put("preference.key.show.debug.trace", Boolean.FALSE);
        defaults.put("preference.key.proxy.host", "");
        defaults.put("preference.key.proxy.port", "");
        defaults.put("preference.key.cssmedia", "screen");
        defaults.put("preference.key.default.font.family", DEFAULT_DEFAULT_FONT_FAMILY);
        defaults.put("preference.key.is.xml.parser.validating", Boolean.FALSE);
        defaults.put("preference.key.enforce.secure.scripting", Boolean.TRUE);
        defaults.put("preference.key.grant.script.file.access", Boolean.FALSE);
        defaults.put("preferenced.key.grant.script.network.access", Boolean.FALSE);
        defaults.put("preference.key.load.java.script", Boolean.TRUE);
        defaults.put("preference.key.load.ecmascript", Boolean.TRUE);
        defaults.put("preference.key.allowed.script.origin", new Integer(2));
        defaults.put("preference.key.allowed.external.resource.origin", new Integer(1));
        defaults.put(PREFERENCE_KEY_VISITED_URI_LIST, "");
        defaults.put(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH, new Integer(10));
        this.securityEnforcer = new ApplicationSecurityEnforcer(this.getClass(), SQUIGGLE_SECURITY_POLICY);
        try {
            this.preferenceManager = new XMLPreferenceManager(SQUIGGLE_CONFIGURATION_FILE, defaults);
            String dir = System.getProperty(PROPERTY_USER_HOME);
            File f = new File(dir, BATIK_CONFIGURATION_SUBDIRECTORY);
            f.mkdir();
            XMLPreferenceManager.setPreferenceDirectory(f.getCanonicalPath());
            this.preferenceManager.load();
            this.setPreferences();
            this.initializeLastVisited();
            Authenticator.setDefault(new JAuthenticator());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final AboutDialog initDialog = new AboutDialog();
        final JProgressBar pb = new JProgressBar(0, 3);
        initDialog.getContentPane().add("South", pb);
        Dimension ss = initDialog.getToolkit().getScreenSize();
        Dimension ds = initDialog.getPreferredSize();
        initDialog.setLocation((ss.width - ds.width) / 2, (ss.height - ds.height) / 2);
        initDialog.setSize(ds);
        initDialog.setVisible(true);
        final JSVGViewerFrame v = new JSVGViewerFrame(this);
        JSVGCanvas c = v.getJSVGCanvas();
        c.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                pb.setValue(1);
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                pb.setValue(2);
            }
        });
        c.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter(){

            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                pb.setValue(3);
            }
        });
        c.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                initDialog.dispose();
                v.dispose();
                System.gc();
                Main.this.run();
            }
        });
        c.setSize(100, 100);
        this.svgInitializationURI = (class$org$apache$batik$apps$svgbrowser$Main == null ? (class$org$apache$batik$apps$svgbrowser$Main = Main.class$("org.apache.batik.apps.svgbrowser.Main")) : class$org$apache$batik$apps$svgbrowser$Main).getResource(SVG_INITIALIZATION).toString();
        c.loadSVGDocument(this.svgInitializationURI);
    }

    public void installCustomPolicyFile() throws IOException {
        String securityPolicyProperty = System.getProperty(PROPERTY_JAVA_SECURITY_POLICY);
        if (this.overrideSecurityPolicy || securityPolicyProperty == null || "".equals(securityPolicyProperty)) {
            ParsedURL policyURL = new ParsedURL(this.securityEnforcer.getPolicyURL());
            String dir = System.getProperty(PROPERTY_USER_HOME);
            File batikConfigDir = new File(dir, BATIK_CONFIGURATION_SUBDIRECTORY);
            File policyFile = new File(batikConfigDir, SQUIGGLE_POLICY_FILE);
            BufferedReader r = new BufferedReader(new InputStreamReader(policyURL.openStream()));
            FileWriter w = new FileWriter(policyFile);
            char[] buf = new char[1024];
            int n = 0;
            while ((n = ((Reader)r).read(buf, 0, buf.length)) != -1) {
                ((Writer)w).write(buf, 0, n);
            }
            ((Reader)r).close();
            boolean grantScriptNetworkAccess = this.preferenceManager.getBoolean("preferenced.key.grant.script.network.access");
            boolean grantScriptFileAccess = this.preferenceManager.getBoolean("preference.key.grant.script.file.access");
            if (grantScriptNetworkAccess) {
                w.write(POLICY_GRANT_SCRIPT_NETWORK_ACCESS);
            }
            if (grantScriptFileAccess) {
                w.write(POLICY_GRANT_SCRIPT_FILE_ACCESS);
            }
            ((Writer)w).close();
            this.overrideSecurityPolicy = true;
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, policyFile.toURL().toString());
        }
    }

    public void run() {
        try {
            OptionHandler oh;
            int i;
            for (i = 0; i < this.arguments.length && (oh = (OptionHandler)this.handlers.get(this.arguments[i])) != null; ++i) {
                i = oh.handleOption(i);
            }
            JSVGViewerFrame frame = this.createAndShowJSVGViewerFrame();
            while (i < this.arguments.length) {
                if (this.arguments[i].length() == 0) {
                    ++i;
                    continue;
                }
                File file = new File(this.arguments[i]);
                String uri = null;
                try {
                    if (file.canRead()) {
                        uri = file.toURL().toString();
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                if (uri == null) {
                    uri = this.arguments[i];
                    ParsedURL purl = null;
                    purl = new ParsedURL(this.arguments[i]);
                    if (!purl.complete()) {
                        uri = null;
                    }
                }
                if (uri != null) {
                    if (frame == null) {
                        frame = this.createAndShowJSVGViewerFrame();
                    }
                    frame.showSVGDocument(uri);
                    frame = null;
                } else {
                    JOptionPane.showMessageDialog(frame, resources.getString("Error.skipping.file") + this.arguments[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printUsage();
        }
    }

    protected void printUsage() {
        System.out.println();
        System.out.println(resources.getString("Command.header"));
        System.out.println(resources.getString("Command.syntax"));
        System.out.println();
        System.out.println(resources.getString("Command.options"));
        Iterator it = this.handlers.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            System.out.println(((OptionHandler)this.handlers.get(s)).getDescription());
        }
    }

    public JSVGViewerFrame createAndShowJSVGViewerFrame() {
        JSVGViewerFrame mainFrame = new JSVGViewerFrame(this);
        mainFrame.setSize(resources.getInteger("Frame.width"), resources.getInteger("Frame.height"));
        mainFrame.setIconImage(frameIcon.getImage());
        mainFrame.setTitle(resources.getString("Frame.title"));
        mainFrame.setVisible(true);
        this.viewerFrames.add(mainFrame);
        this.setPreferences(mainFrame);
        return mainFrame;
    }

    public void closeJSVGViewerFrame(JSVGViewerFrame f) {
        f.getJSVGCanvas().stopProcessing();
        this.viewerFrames.remove(f);
        if (this.viewerFrames.size() == 0) {
            System.exit(0);
        }
        f.dispose();
    }

    public Action createExitAction(JSVGViewerFrame vf) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
    }

    public void openLink(String url) {
        JSVGViewerFrame f = this.createAndShowJSVGViewerFrame();
        f.getJSVGCanvas().loadSVGDocument(url);
    }

    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    public boolean isXMLParserValidating() {
        return this.preferenceManager.getBoolean("preference.key.is.xml.parser.validating");
    }

    public void showPreferenceDialog(JSVGViewerFrame f) {
        if (this.preferenceDialog == null) {
            this.preferenceDialog = new PreferenceDialog(this.preferenceManager);
        }
        if (this.preferenceDialog.showDialog() == 0) {
            try {
                this.preferenceManager.save();
                this.setPreferences();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setPreferences() throws IOException {
        Iterator it = this.viewerFrames.iterator();
        while (it.hasNext()) {
            this.setPreferences((JSVGViewerFrame)it.next());
        }
        System.setProperty("proxyHost", this.preferenceManager.getString("preference.key.proxy.host"));
        System.setProperty("proxyPort", this.preferenceManager.getString("preference.key.proxy.port"));
        this.installCustomPolicyFile();
        this.securityEnforcer.enforceSecurity(this.preferenceManager.getBoolean("preference.key.enforce.secure.scripting"));
    }

    private void setPreferences(JSVGViewerFrame vf) {
        boolean db = this.preferenceManager.getBoolean("preference.key.enable.double.buffering");
        vf.getJSVGCanvas().setDoubleBufferedRendering(db);
        boolean sr = this.preferenceManager.getBoolean("preference.key.show.rendering");
        vf.getJSVGCanvas().setProgressivePaint(sr);
        boolean d = this.preferenceManager.getBoolean("preference.key.show.debug.trace");
        vf.setDebug(d);
        boolean aa = this.preferenceManager.getBoolean("preference.key.auto.adjust.window");
        vf.setAutoAdjust(aa);
        boolean dd = this.preferenceManager.getBoolean("preference.key.selection.xor.mode");
        vf.getJSVGCanvas().setSelectionOverlayXORMode(dd);
    }

    public String getLanguages() {
        String s = this.preferenceManager.getString("preference.key.languages");
        return s == null ? Locale.getDefault().getLanguage() : s;
    }

    public String getUserStyleSheetURI() {
        return this.preferenceManager.getString("preference.key.user.stylesheet");
    }

    public String getDefaultFontFamily() {
        return this.preferenceManager.getString("preference.key.default.font.family");
    }

    public String getMedia() {
        String s = this.preferenceManager.getString("preference.key.cssmedia");
        return s == null ? "screen" : s;
    }

    public boolean isSelectionOverlayXORMode() {
        return this.preferenceManager.getBoolean("preference.key.selection.xor.mode");
    }

    public boolean canLoadScriptType(String scriptType) {
        if ("text/ecmascript".equals(scriptType)) {
            return this.preferenceManager.getBoolean("preference.key.load.ecmascript");
        }
        if ("application/java-archive".equals(scriptType)) {
            return this.preferenceManager.getBoolean("preference.key.load.java.script");
        }
        return this.preferenceManager.getBoolean(scriptType + UNKNOWN_SCRIPT_TYPE_LOAD_KEY_EXTENSION);
    }

    public int getAllowedScriptOrigin() {
        int ret = this.preferenceManager.getInteger("preference.key.allowed.script.origin");
        return ret;
    }

    public int getAllowedExternalResourceOrigin() {
        int ret = this.preferenceManager.getInteger("preference.key.allowed.external.resource.origin");
        return ret;
    }

    public void addVisitedURI(String uri) {
        if (this.svgInitializationURI.equals(uri)) {
            return;
        }
        int maxVisitedURIs = this.preferenceManager.getInteger(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH);
        if (maxVisitedURIs < 0) {
            maxVisitedURIs = 0;
        }
        if (this.lastVisited.contains(uri)) {
            this.lastVisited.removeElement(uri);
        }
        while (this.lastVisited.size() > 0 && this.lastVisited.size() > maxVisitedURIs - 1) {
            this.lastVisited.removeElementAt(0);
        }
        if (maxVisitedURIs > 0) {
            this.lastVisited.addElement(uri);
        }
        StringBuffer lastVisitedBuffer = new StringBuffer();
        for (int i = 0; i < this.lastVisited.size(); ++i) {
            lastVisitedBuffer.append(URLEncoder.encode(this.lastVisited.elementAt(i).toString()));
            lastVisitedBuffer.append(URI_SEPARATOR);
        }
        this.preferenceManager.setString(PREFERENCE_KEY_VISITED_URI_LIST, lastVisitedBuffer.toString());
        try {
            this.preferenceManager.save();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String[] getVisitedURIs() {
        Object[] visitedURIs = new String[this.lastVisited.size()];
        this.lastVisited.copyInto(visitedURIs);
        return visitedURIs;
    }

    protected void initializeLastVisited() {
        int maxVisitedURIs;
        String lastVisitedStr = this.preferenceManager.getString(PREFERENCE_KEY_VISITED_URI_LIST);
        StringTokenizer st = new StringTokenizer(lastVisitedStr, URI_SEPARATOR);
        int n = st.countTokens();
        if (n > (maxVisitedURIs = this.preferenceManager.getInteger(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH))) {
            n = maxVisitedURIs;
        }
        for (int i = 0; i < n; ++i) {
            this.lastVisited.addElement(URLDecoder.decode(st.nextToken()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class FontSizeHandler
    implements OptionHandler {
        protected FontSizeHandler() {
        }

        public int handleOption(int i) {
            int size = Integer.parseInt(Main.this.arguments[++i]);
            Font font = new Font("Dialog", 0, size);
            FontUIResource fontRes = new FontUIResource(font);
            UIManager.put("CheckBox.font", fontRes);
            UIManager.put("PopupMenu.font", fontRes);
            UIManager.put("TextPane.font", fontRes);
            UIManager.put("MenuItem.font", fontRes);
            UIManager.put("ComboBox.font", fontRes);
            UIManager.put("Button.font", fontRes);
            UIManager.put("Tree.font", fontRes);
            UIManager.put("ScrollPane.font", fontRes);
            UIManager.put("TabbedPane.font", fontRes);
            UIManager.put("EditorPane.font", fontRes);
            UIManager.put("TitledBorder.font", fontRes);
            UIManager.put("Menu.font", fontRes);
            UIManager.put("TextArea.font", fontRes);
            UIManager.put("OptionPane.font", fontRes);
            UIManager.put("DesktopIcon.font", fontRes);
            UIManager.put("MenuBar.font", fontRes);
            UIManager.put("ToolBar.font", fontRes);
            UIManager.put("RadioButton.font", fontRes);
            UIManager.put("RadioButtonMenuItem.font", fontRes);
            UIManager.put("ToggleButton.font", fontRes);
            UIManager.put("ToolTip.font", fontRes);
            UIManager.put("ProgressBar.font", fontRes);
            UIManager.put("TableHeader.font", fontRes);
            UIManager.put("Panel.font", fontRes);
            UIManager.put("List.font", fontRes);
            UIManager.put("ColorChooser.font", fontRes);
            UIManager.put("PasswordField.font", fontRes);
            UIManager.put("TextField.font", fontRes);
            UIManager.put("Table.font", fontRes);
            UIManager.put("Label.font", fontRes);
            UIManager.put("InternalFrameTitlePane.font", fontRes);
            UIManager.put("CheckBoxMenuItem.font", fontRes);
            return i;
        }

        public String getDescription() {
            return resources.getString("Command.font-size");
        }
    }

    protected static interface OptionHandler {
        public int handleOption(int var1);

        public String getDescription();
    }
}

