/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGPointList;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedPoints;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPointList;

public class SVGOMAnimatedPoints
implements SVGAnimatedPoints,
LiveAttributeValue {
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected boolean changing;
    protected AbstractSVGPointList points;
    protected String defaultValue;

    public SVGOMAnimatedPoints(AbstractElement elt, String ns, String ln, String defaultValue) {
        this.element = elt;
        this.namespaceURI = ns;
        this.localName = ln;
        this.defaultValue = defaultValue;
    }

    public SVGPointList getPoints() {
        if (this.points == null) {
            this.points = new SVGOMPointList();
        }
        return this.points;
    }

    public SVGPointList getAnimatedPoints() {
        throw new RuntimeException("TODO :  getAnimatedPoints() !!");
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.points != null) {
            this.points.invalidate();
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.points != null) {
            this.points.invalidate();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.points != null) {
            this.points.invalidate();
        }
    }

    public class SVGOMPointList
    extends AbstractSVGPointList {
        protected DOMException createDOMException(short type, String key, Object[] args) {
            return SVGOMAnimatedPoints.this.element.createDOMException(type, key, args);
        }

        protected SVGException createSVGException(short type, String key, Object[] args) {
            return ((SVGOMElement)SVGOMAnimatedPoints.this.element).createSVGException(type, key, args);
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedPoints.this.element.getAttributeNodeNS(SVGOMAnimatedPoints.this.namespaceURI, SVGOMAnimatedPoints.this.localName);
            if (attr == null) {
                return SVGOMAnimatedPoints.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAttributeValue(String value) {
            try {
                SVGOMAnimatedPoints.this.changing = true;
                SVGOMAnimatedPoints.this.element.setAttributeNS(SVGOMAnimatedPoints.this.namespaceURI, SVGOMAnimatedPoints.this.localName, value);
            }
            finally {
                SVGOMAnimatedPoints.this.changing = false;
            }
        }
    }
}

