/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.flow;

import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.flow.FlowGlyphLayout;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.TextSpanLayout;

public class FlowTextPainter
extends StrokingTextPainter {
    protected static TextPainter singleton = new FlowTextPainter();

    public static TextPainter getInstance() {
        return singleton;
    }

    public List getTextRuns(TextNode node, AttributedCharacterIterator aci) {
        List textRuns = node.getTextRuns();
        if (textRuns != null) {
            return textRuns;
        }
        AttributedCharacterIterator[] chunkACIs = this.getTextChunkACIs(aci);
        textRuns = this.computeTextRuns(node, aci, chunkACIs);
        aci.first();
        List rgns = (List)aci.getAttribute(FLOW_REGIONS);
        if (rgns != null) {
            Iterator i = textRuns.iterator();
            ArrayList chunkLayouts = new ArrayList();
            StrokingTextPainter.TextRun tr = (StrokingTextPainter.TextRun)i.next();
            ArrayList<TextSpanLayout> layouts = new ArrayList<TextSpanLayout>();
            chunkLayouts.add(layouts);
            layouts.add(tr.getLayout());
            while (i.hasNext()) {
                tr = (StrokingTextPainter.TextRun)i.next();
                if (tr.isFirstRunInChunk()) {
                    layouts = new ArrayList();
                    chunkLayouts.add(layouts);
                }
                layouts.add(tr.getLayout());
            }
            FlowGlyphLayout.textWrapTextChunk(chunkACIs, chunkLayouts, rgns, this.fontRenderContext);
        }
        node.setTextRuns(textRuns);
        return textRuns;
    }
}

