/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.swf.tools.as3.EvaluatorAdapter;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.as3.reflect.NodeMagic;
import java.util.Iterator;
import java.util.Map;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SkinPartEvaluator
extends EvaluatorAdapter {
    private SymbolTable symbolTable;
    private Context currentContext;
    private static final String SKINPARTS = "skinParts".intern();
    private static final String _SKINPARTS = "_skinParts".intern();
    private static final String OVERRIDE = "override".intern();
    private static final String OBJECT = "Object".intern();

    public SkinPartEvaluator(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    @Override
    public Value evaluate(Context context, ClassDefinitionNode node) {
        super.evaluate(context, node);
        TypeAnalyzer typeAnalyzer = this.symbolTable.getTypeAnalyzer();
        String className = NodeMagic.getClassName(node);
        if (className == null) {
            return null;
        }
        this.currentContext = context;
        typeAnalyzer.evaluate(context, node);
        ClassInfo classInfo = typeAnalyzer.getClassInfo(className);
        Map<String, Boolean> parts = classInfo.getSkinParts(true);
        if (parts != null && parts.size() > 0) {
            NodeFactory nodeFactory = context.getNodeFactory();
            node.statements = this.genSkinPartsAST(parts, nodeFactory, node.statements);
        }
        return null;
    }

    private StatementListNode genSkinPartsAST(Map<String, Boolean> parts, NodeFactory nodeFactory, StatementListNode statements) {
        StatementListNode result = statements;
        Iterator<String> iterator = parts.keySet().iterator();
        ArgumentListNode partsList = null;
        while (iterator.hasNext()) {
            String key = iterator.next();
            LiteralStringNode partName = nodeFactory.literalString(key);
            LiteralBooleanNode required = nodeFactory.literalBoolean(parts.get(key));
            LiteralFieldNode literalField = nodeFactory.literalField(partName, required);
            partsList = nodeFactory.argumentList(partsList, literalField);
        }
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, OBJECT, true);
        LiteralObjectNode literalObject = nodeFactory.literalObject(partsList);
        VariableDefinitionNode skinParts = (VariableDefinitionNode)AbstractSyntaxTreeUtil.generatePrivateStaticVariable(this.currentContext, typeExpression, _SKINPARTS, literalObject);
        MemberExpressionNode returnTypeExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, OBJECT, true);
        TypeExpressionNode returnType = nodeFactory.typeExpression(returnTypeExpression, true, false, -1);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(null, returnType);
        IdentifierNode identifier = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, _SKINPARTS, false);
        GetExpressionNode selector = nodeFactory.getExpression(identifier);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, selector);
        ListNode list = nodeFactory.list(null, memberExpression);
        ReturnStatementNode returnStatement = nodeFactory.returnStatement(list);
        StatementListNode rStatementList = nodeFactory.statementList(null, returnStatement);
        FunctionCommonNode propertyGetter = nodeFactory.functionCommon(this.currentContext, null, functionSignature, rStatementList);
        QualifiedIdentifierNode qFunctionName = AbstractSyntaxTreeUtil.generatePublicQualifiedIdentifier(nodeFactory, SKINPARTS);
        FunctionNameNode functionName = nodeFactory.functionName(-79, qFunctionName);
        FunctionDefinitionNode functionDefinition = nodeFactory.functionDefinition(this.currentContext, AbstractSyntaxTreeUtil.generateProtectedAttribute(nodeFactory), functionName, propertyGetter);
        functionDefinition.attrs = nodeFactory.attributeList(AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, OVERRIDE, false), functionDefinition.attrs);
        result = nodeFactory.statementList(result, skinParts);
        result = nodeFactory.statementList(result, functionDefinition);
        return result;
    }
}

